<?php
/**
 * MIT License
 *
 * Copyright (c) 2020 DW Web-Engineering
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

namespace Controllers;


use Interfaces\ControllerInterfaces\XmlControllerInterface;

/**
 * Class PublicController
 * @package Controllers
 */
class PublicXmlController extends PublicController implements XmlControllerInterface
{
    /**
     * @param string $action
     */
    public final function run(string $action)
    {
        $methodName = sprintf("%sAction", $action);

        if (method_exists($this, $methodName)) {
            $this->$methodName();
        } else {
            $this->render404();
        }

        $this->render();
    }

    /**
     *
     */
    public final function render404(): void
    {
        header(self::HEADER_ERROR_404);
        header(self::HEADER_CONTENT_TYPE_JSON);
        $this->addContext("error", "Not Found");
        die(json_encode($this->getContext()));
    }

    /**
     *
     */
    public final function render(): void
    {
        header(self::HEADER_CONTENT_TYPE_JSON);
        echo json_encode($this->getContext());
        exit();
    }

    /**
     *
     */
    public function indexAction(): void
    {
        parent::indexAction(); // TODO: Change the autogenerated stub
    }
}
