<?php
/**
 * MIT License
 *
 * Copyright (c) 2020 DW Web-Engineering
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

namespace Annotations;


use Doctrine\Common\Annotations\Annotation\Enum;

/**
 * Class Access
 * @package Annotations
 * @Annotation
 * @Target("CLASS")
 */
class Navigation
{
    /**
     * @var string
     * @Enum({"sidebar", "top_left", "top_right", "misc"})
     */
    public string $position;

    /**
     * @var array
     */
    public array $positions;

    /**
     * @var string
     */
    public string $text;

    /**
     * @var string
     */
    public string $class;

    /**
     * @var string
     * @Enum({"","cil-3d","cil-4k","cil-account-logout","cil-action-redo","cil-action-undo","cil-address-book","cil-airplane-mode","cil-airplane-mode-off","cil-airplay","cil-alarm","cil-album","cil-align-center","cil-align-left","cil-align-right","cil-american-football","cil-animal","cil-aperture","cil-apple","cil-applications","cil-applications-settings","cil-apps","cil-apps-settings","cil-arrow-bottom","cil-arrow-circle-bottom","cil-arrow-circle-left","cil-arrow-circle-right","cil-arrow-circle-top","cil-arrow-left","cil-arrow-right","cil-arrow-thick-bottom","cil-arrow-thick-from-bottom","cil-arrow-thick-from-left","cil-arrow-thick-from-right","cil-arrow-thick-from-top","cil-arrow-thick-left","cil-arrow-thick-right","cil-arrow-thick-to-bottom","cil-arrow-thick-to-left","cil-arrow-thick-to-right","cil-arrow-thick-to-top","cil-arrow-thick-top","cil-arrow-top","cil-assistive-listening-system","cil-asterisk","cil-asterisk-circle","cil-at","cil-audio","cil-audio-description","cil-audio-spectrum","cil-av-timer","cil-baby","cil-baby-carriage","cil-backspace","cil-badge","cil-balance-scale","cil-ban","cil-bank","cil-bank","cil-bar-chart","cil-barcode","cil-baseball","cil-basket","cil-basketball","cil-bath","cil-bathroom","cil-battery-0","cil-battery-3","cil-battery-5","cil-battery-alert","cil-battery-empty","cil-battery-full","cil-battery-slash","cil-beach-access","cil-beaker","cil-bed","cil-bell","cil-bell-exclamation","cil-bike","cil-birthday-cake","cil-blind","cil-bluetooth","cil-blur","cil-blur-circular","cil-blur-linear","cil-boat-alt","cil-bold","cil-bolt","cil-bolt-circle","cil-book","cil-bookmark","cil-border-all","cil-border-bottom","cil-border-clear","cil-border-horizontal","cil-border-inner","cil-border-left","cil-border-outer","cil-border-right","cil-border-style","cil-border-top","cil-border-vertical","cil-bowling","cil-braille","cil-briefcase","cil-brightness","cil-british-pound","cil-browser","cil-brush","cil-brush-alt","cil-bug","cil-building","cil-bullhorn","cil-burger","cil-burn","cil-bus-alt","cil-calculator","cil-calendar","cil-calendar-check","cil-camera","cil-camera-control","cil-camera-roll","cil-car-alt","cil-caret-bottom","cil-caret-left","cil-caret-right","cil-caret-top","cil-cart","cil-cash","cil-casino","cil-cast","cil-cat","cil-cc","cil-center-focus","cil-chart","cil-chart-line","cil-chart-pie","cil-chat-bubble","cil-check","cil-check-alt","cil-check-circle","cil-chevron-bottom","cil-chevron-circle-down-alt","cil-chevron-circle-left-alt","cil-chevron-circle-right-alt","cil-chevron-circle-up-alt","cil-chevron-double-down","cil-chevron-double-left","cil-chevron-double-right","cil-chevron-double-up","cil-chevron-left","cil-chevron-right","cil-chevron-top","cil-child","cil-child-friendly","cil-circle","cil-clear-all","cil-clipboard","cil-clock","cil-clone","cil-closed-captioning","cil-cloud","cil-cloud-download","cil-cloud-upload","cil-cloudy","cil-code","cil-coffee","cil-cog","cil-color-border","cil-color-fill","cil-color-palette","cil-columns","cil-command","cil-comment-bubble","cil-comment-square","cil-compass","cil-compress","cil-contact","cil-contrast","cil-control","cil-copy","cil-couch","cil-credit-card","cil-crop","cil-crop-rotate","cil-cursor","cil-cursor-move","cil-cut","cil-data-transfer-down","cil-data-transfer-up","cil-deaf","cil-delete","cil-description","cil-devices","cil-dialpad","cil-diamond","cil-dinner","cil-disabled","cil-dog","cil-dollar","cil-door","cil-double-quote-sans-left","cil-double-quote-sans-right","cil-drink","cil-drink-alcohol","cil-drop","cil-drop","cil-eco","cil-education","cil-elevator","cil-envelope-closed","cil-envelope-letter","cil-envelope-open","cil-equalizer","cil-ethernet","cil-euro","cil-excerpt","cil-exit-to-app","cil-expand-down","cil-expand-left","cil-expand-right","cil-expand-up","cil-exposure","cil-external-link","cil-eyedropper","cil-face","cil-face-dead","cil-factory","cil-factory-slash","cil-fastfood","cil-fax","cil-featured-playlist","cil-file","cil-filter","cil-filter-frames","cil-filter-photo","cil-filter-square","cil-filter-x","cil-find-in-page","cil-fingerprint","cil-fire","cil-flag-alt","cil-flight-takeoff","cil-flip","cil-flip-to-back","cil-flip-to-front","cil-flower","cil-folder","cil-folder-open","cil-font","cil-football","cil-fork","cil-fridge","cil-frown","cil-fullscreen","cil-fullscreen-exit","cil-functions","cil-functions-alt","cil-gamepad","cil-garage","cil-gem","cil-gif","cil-gift","cil-globe-alt","cil-golf","cil-golf-alt","cil-gradient","cil-grain","cil-graph","cil-grid","cil-grid-slash","cil-group","cil-hamburger-menu","cil-hand-point-down","cil-hand-point-left","cil-hand-point-right","cil-hand-point-up","cil-happy","cil-hd","cil-hdr","cil-header","cil-headphones","cil-healing","cil-heart","cil-highlighter","cil-highligt","cil-history","cil-home","cil-hospital","cil-hot-tub","cil-house","cil-https","cil-image","cil-image","cil-image-broken","cil-image-plus","cil-inbox","cil-indent-decrease","cil-indent-increase","cil-industry","cil-industry-slash","cil-info","cil-input","cil-input-hdmi","cil-input-power","cil-institution","cil-italic","cil-justify-center","cil-justify-left","cil-justify-right","cil-keyboard","cil-lan","cil-language","cil-laptop","cil-layers","cil-leaf","cil-lemon","cil-level-down","cil-level-up","cil-library","cil-library-add","cil-library-building","cil-life-ring","cil-lightbulb","cil-line-spacing","cil-line-style","cil-line-weight","cil-link","cil-link-alt","cil-link-broken","cil-list","cil-list-filter","cil-list-high-priority","cil-list-low-priority","cil-list-numbered","cil-list-numbered-rtl","cil-list-rich","cil-location-pin","cil-lock-locked","cil-lock-unlocked","cil-locomotive","cil-loop","cil-loop-1","cil-loop-circular","cil-low-vision","cil-magnifying-glass","cil-map","cil-media-eject","cil-media-pause","cil-media-play","cil-media-record","cil-media-skip-backward","cil-media-skip-forward","cil-media-step-backward","cil-media-step-forward","cil-media-stop","cil-medical-cross","cil-meh","cil-memory","cil-menu","cil-mic","cil-microphone","cil-minus","cil-mobile","cil-mobile-landscape","cil-money","cil-monitor","cil-mood-bad","cil-mood-good","cil-mood-very-bad","cil-mood-very-good","cil-moon","cil-mouse","cil-mouth-slash","cil-move","cil-movie","cil-mug","cil-mug-tea","cil-music-note","cil-newspaper","cil-note-add","cil-notes","cil-object-group","cil-object-ungroup","cil-opacity","cil-opentype","cil-options","cil-paint","cil-paint-bucket","cil-paper-plane","cil-paperclip","cil-paragraph","cil-paw","cil-pen","cil-pen-alt","cil-pen-nib","cil-pencil","cil-people","cil-phone","cil-pin","cil-pin","cil-pizza","cil-plant","cil-playlist-add","cil-plus","cil-pool","cil-power-standby","cil-pregnant","cil-print","cil-pushchair","cil-puzzle","cil-qr-code","cil-rain","cil-rectangle","cil-recycle","cil-reload","cil-report-slash","cil-resize-both","cil-resize-height","cil-resize-width","cil-restaurant","cil-room","cil-router","cil-rowing","cil-rss","cil-ruble","cil-running","cil-sad","cil-satelite","cil-save","cil-school","cil-screen-desktop","cil-screen-smartphone","cil-scrubber","cil-search","cil-send","cil-settings","cil-share","cil-share-all","cil-share-alt","cil-share-boxed","cil-shield-alt","cil-short-text","cil-shower","cil-sign-language","cil-signal-cellular-0","cil-signal-cellular-3","cil-signal-cellular-4","cil-sim","cil-sitemap","cil-smile","cil-smile-plus","cil-smoke","cil-smoke-free","cil-smoke-slash","cil-smoking-room","cil-snowflake","cil-soccer","cil-sofa","cil-sort-alpha-down","cil-sort-alpha-up","cil-sort-ascending","cil-sort-descending","cil-sort-numeric-down","cil-sort-numeric-up","cil-spa","cil-space-bar","cil-speak","cil-speaker","cil-speech","cil-speedometer","cil-spreadsheet","cil-square","cil-star","cil-star-half","cil-storage","cil-stream","cil-strikethrough","cil-sun","cil-swap-horizontal","cil-swap-vertical","cil-swimming","cil-sync","cil-tablet","cil-tag","cil-tags","cil-task","cil-taxi","cil-tennis","cil-tennis-ball","cil-terminal","cil-terrain","cil-text","cil-text-shapes","cil-text-size","cil-text-square","cil-text-strike","cil-thumb-down","cil-thumb-up","cil-toggle-off","cil-toggle-on","cil-toilet","cil-touch-app","cil-transfer","cil-translate","cil-trash","cil-triangle","cil-truck","cil-tv","cil-tv","cil-underline","cil-usb","cil-user","cil-user-female","cil-user-follow","cil-user-plus","cil-user-unfollow","cil-user-x","cil-vector","cil-vertical-align-bottom","cil-vertical-align-bottom","cil-vertical-align-center","cil-vertical-align-center","cil-vertical-align-top","cil-vertical-align-top","cil-video","cil-videogame","cil-view-column","cil-view-module","cil-view-quilt","cil-view-stream","cil-voice","cil-voice-over-record","cil-volume-high","cil-volume-low","cil-volume-off","cil-walk","cil-wallet","cil-wallpaper","cil-warning","cil-watch","cil-wc","cil-weightlifitng","cil-wheelchair","cil-wifi-signal-0","cil-wifi-signal-1","cil-wifi-signal-2","cil-wifi-signal-3","cil-wifi-signal-4","cil-wifi-signal-off","cil-window","cil-window-maximize","cil-window-minimize","cil-window-restore","cil-wrap-text","cil-x","cil-x-circle","cil-yen","cil-zoom","cil-zoom-in","cil-zoom-out","cil-infinity","cib-500px","cib-500px-5","cib-about-me","cib-abstract","cib-acm","cib-addthis","cib-adguard","cib-adobe","cib-adobe-acrobat-reader","cib-adobe-after-effects","cib-adobe-audition","cib-adobe-creative-cloud","cib-adobe-dreamweaver","cib-adobe-illustrator","cib-adobe-indesign","cib-adobe-lightroom","cib-adobe-lightroom-classic","cib-adobe-photoshop","cib-adobe-premiere","cib-adobe-typekit","cib-adobe-xd","cib-airbnb","cib-algolia","cib-alipay","cib-allocine","cib-amazon","cib-amazon-aws","cib-amazon-pay","cib-amd","cib-american-express","cib-anaconda","cib-analogue","cib-android","cib-android-alt","cib-angellist","cib-angular","cib-angular-universal","cib-ansible","cib-apache","cib-apache-airflow","cib-apache-flink","cib-apache-spark","cib-app-store","cib-app-store-ios","cib-apple","cib-apple-music","cib-apple-pay","cib-apple-podcasts","cib-appveyor","cib-aral","cib-arch-linux","cib-archive-of-our-own","cib-arduino","cib-artstation","cib-arxiv","cib-asana","cib-at-and-t","cib-atlassian","cib-atom","cib-audible","cib-aurelia","cib-auth0","cib-automatic","cib-autotask","cib-aventrix","cib-azure-artifacts","cib-azure-devops","cib-azure-pipelines","cib-babel","cib-baidu","cib-bamboo","cib-bancontact","cib-bandcamp","cib-basecamp","cib-bathasu","cib-behance","cib-big-cartel","cib-bing","cib-bit","cib-bitbucket","cib-bitcoin","cib-bitdefender","cib-bitly","cib-blackberry","cib-blender","cib-blogger","cib-blogger-b","cib-bluetooth","cib-bluetooth-b","cib-boeing","cib-boost","cib-bootstrap","cib-bower","cib-brand-ai","cib-brave","cib-btc","cib-buddy","cib-buffer","cib-buy-me-a-coffee","cib-buysellads","cib-buzzfeed","cib-c","cib-cakephp","cib-campaign-monitor","cib-canva","cib-cashapp","cib-cassandra","cib-castro","cib-cc-amazon-pay","cib-cc-amex","cib-cc-apple-pay","cib-cc-diners-club","cib-cc-discover","cib-cc-jcb","cib-cc-mastercard","cib-cc-paypal","cib-cc-stripe","cib-cc-visa","cib-centos","cib-cevo","cib-chase","cib-chef","cib-chromecast","cib-circle","cib-circleci","cib-cirrusci","cib-cisco","cib-civicrm","cib-clockify","cib-clojure","cib-cloudbees","cib-cloudflare","cib-cmake","cib-co-op","cib-codacy","cib-code-climate","cib-codecademy","cib-codecov","cib-codeigniter","cib-codepen","cib-coderwall","cib-codesandbox","cib-codeship","cib-codewars","cib-codio","cib-coffeescript","cib-common-workflow-language","cib-composer","cib-conda-forge","cib-conekta","cib-confluence","cib-coreui","cib-coreui-c","cib-coursera","cib-coveralls","cib-cpanel","cib-cplusplus","cib-creative-commons","cib-creative-commons-by","cib-creative-commons-nc","cib-creative-commons-nc-eu","cib-creative-commons-nc-jp","cib-creative-commons-nd","cib-creative-commons-pd","cib-creative-commons-pd-alt","cib-creative-commons-remix","cib-creative-commons-sa","cib-creative-commons-sampling","cib-creative-commons-sampling-plus","cib-creative-commons-share","cib-creative-commons-zero","cib-crunchbase","cib-crunchyroll","cib-css3","cib-css3-shiled","cib-csswizardry","cib-d3-js","cib-dailymotion","cib-dashlane","cib-dazn","cib-dblp","cib-debian","cib-deepin","cib-deezer","cib-delicious","cib-dell","cib-deno","cib-dependabot","cib-designer-news","cib-dev-to","cib-deviantart","cib-devrant","cib-diaspora","cib-digg","cib-digital-ocean","cib-discord","cib-discourse","cib-discover","cib-disqus","cib-disroot","cib-django","cib-docker","cib-docusign","cib-dot-net","cib-draugiem-lv","cib-dribbble","cib-drone","cib-dropbox","cib-drupal","cib-dtube","cib-duckduckgo","cib-dynatrace","cib-ebay","cib-eclipseide","cib-elastic","cib-elastic-cloud","cib-elastic-search","cib-elastic-stack","cib-electron","cib-elementary","cib-eleventy","cib-ello","cib-elsevier","cib-emlakjet","cib-empirekred","cib-envato","cib-epic-games","cib-epson","cib-esea","cib-eslint","cib-ethereum","cib-etsy","cib-event-store","cib-eventbrite","cib-evernote","cib-everplaces","cib-evry","cib-exercism","cib-experts-exchange","cib-expo","cib-eyeem","cib-f-secure","cib-facebook","cib-facebook-f","cib-faceit","cib-fandango","cib-favro","cib-feathub","cib-fedex","cib-fedora","cib-feedly","cib-fido-alliance","cib-figma","cib-filezilla","cib-firebase","cib-fitbit","cib-flask","cib-flattr","cib-flickr","cib-flipboard","cib-flutter","cib-fnac","cib-foursquare","cib-framer","cib-freebsd","cib-freecodecamp","cib-fur-affinity","cib-furry-network","cib-garmin","cib-gatsby","cib-gauges","cib-genius","cib-gentoo","cib-geocaching","cib-gerrit","cib-gg","cib-ghost","cib-gimp","cib-git","cib-gitea","cib-github","cib-gitkraken","cib-gitlab","cib-gitpod","cib-gitter","cib-glassdoor","cib-glitch","cib-gmail","cib-gnu","cib-gnu-privacy-guard","cib-gnu-social","cib-go","cib-godot-engine","cib-gog-com","cib-goldenline","cib-goodreads","cib-google","cib-google-ads","cib-google-allo","cib-google-analytics","cib-google-chrome","cib-google-cloud","cib-google-keep","cib-google-pay","cib-google-play","cib-google-podcasts","cib-googles-cholar","cib-gov-uk","cib-gradle","cib-grafana","cib-graphcool","cib-graphql","cib-grav","cib-gravatar","cib-greenkeeper","cib-greensock","cib-groovy","cib-groupon","cib-grunt","cib-gulp","cib-gumroad","cib-gumtree","cib-habr","cib-hackaday","cib-hackerearth","cib-hackerone","cib-hackerrank","cib-hackhands","cib-hackster","cib-happycow","cib-hashnode","cib-haskell","cib-hatena-bookmark","cib-haxe","cib-helm","cib-here","cib-heroku","cib-hexo","cib-highly","cib-hipchat","cib-hitachi","cib-hockeyapp","cib-homify","cib-hootsuite","cib-hotjar","cib-houzz","cib-hp","cib-html5","cib-html5-shield","cib-htmlacademy","cib-huawei","cib-hubspot","cib-hulu","cib-humble-bundle","cib-iata","cib-ibm","cib-icloud","cib-iconjar","cib-icq","cib-ideal","cib-ifixit","cib-imdb","cib-indeed","cib-inkscape","cib-instacart","cib-instagram","cib-instapaper","cib-intel","cib-intellijidea","cib-intercom","cib-internet-explorer","cib-invision","cib-ionic","cib-issuu","cib-itch-io","cib-jabber","cib-java","cib-javascript","cib-jekyll","cib-jenkins","cib-jest","cib-jet","cib-jetbrains","cib-jira","cib-joomla","cib-jquery","cib-js","cib-jsdelivr","cib-jsfiddle","cib-json","cib-jupyter","cib-justgiving","cib-kaggle","cib-kaios","cib-kaspersky","cib-kentico","cib-keras","cib-keybase","cib-keycdn","cib-khan-academy","cib-kibana","cib-kickstarter","cib-kik","cib-kirby","cib-klout","cib-known","cib-ko-fi","cib-kodi","cib-koding","cib-kotlin","cib-krita","cib-kubernetes","cib-lanyrd","cib-laravel","cib-laravel-horizon","cib-laravel-nova","cib-last-fm","cib-latex","cib-launchpad","cib-leetcode","cib-lenovo","cib-less","cib-lets-encrypt","cib-letterboxd","cib-lgtm","cib-liberapay","cib-librarything","cib-libreoffice","cib-line","cib-linkedin","cib-linkedin-in","cib-linux","cib-linux-foundation","cib-linux-mint","cib-livejournal","cib-livestream","cib-logstash","cib-lua","cib-lumen","cib-lyft","cib-macys","cib-magento","cib-magisk","cib-mail-ru","cib-mailchimp","cib-makerbot","cib-manjaro","cib-markdown","cib-marketo","cib-mastercard","cib-mastodon","cib-material-design","cib-mathworks","cib-matrix","cib-mattermost","cib-matternet","cib-maxcdn","cib-mcafee","cib-media-temple","cib-mediafire","cib-medium","cib-medium-m","cib-meetup","cib-mega","cib-mendeley","cib-messenger","cib-meteor","cib-micro-blog","cib-microgenetics","cib-microsoft","cib-microsoft-edge","cib-minetest","cib-minutemailer","cib-mix","cib-mixcloud","cib-mixer","cib-mojang","cib-monero","cib-mongodb","cib-monkeytie","cib-monogram","cib-monzo","cib-moo","cib-mozilla","cib-mozilla-firefox","cib-musescore","cib-mxlinux","cib-myspace","cib-mysql","cib-nativescript","cib-nec","cib-neo4j","cib-netflix","cib-netlify","cib-next-js","cib-nextcloud","cib-nextdoor","cib-nginx","cib-nim","cib-nintendo","cib-nintendo-3ds","cib-nintendo-gamecube","cib-nintendo-switch","cib-node-js","cib-node-red","cib-nodemon","cib-nokia","cib-notion","cib-npm","cib-nucleo","cib-nuget","cib-nuxt-js","cib-nvidia","cib-ocaml","cib-octave","cib-octopus-deploy","cib-oculus","cib-odnoklassniki","cib-open-access","cib-open-collective","cib-open-id","cib-open-source-initiative","cib-openstreetmap","cib-opensuse","cib-openvpn","cib-opera","cib-opsgenie","cib-oracle","cib-orcid","cib-origin","cib-osi","cib-osmc","cib-overcast","cib-overleaf","cib-ovh","cib-pagekit","cib-palantir","cib-pandora","cib-pantheon","cib-patreon","cib-paypal","cib-periscope","cib-php","cib-picarto-tv","cib-pinboard","cib-pingdom","cib-pingup","cib-pinterest","cib-pinterest-p","cib-pivotaltracker","cib-plangrid","cib-player-me","cib-playerfm","cib-playstation","cib-playstation3","cib-playstation4","cib-plesk","cib-plex","cib-pluralsight","cib-plurk","cib-pocket","cib-postgresql","cib-postman","cib-postwoman","cib-powershell","cib-prettier","cib-prismic","cib-probot","cib-processwire","cib-product-hunt","cib-proto-io","cib-protonmail","cib-proxmox","cib-pypi","cib-python","cib-pytorch","cib-qgis","cib-qiita","cib-qq","cib-qualcomm","cib-quantcast","cib-quantopian","cib-quarkus","cib-quora","cib-qwiklabs","cib-qzone","cib-r","cib-radiopublic","cib-rails","cib-raspberry-pi","cib-react","cib-read-the-docs","cib-readme","cib-realm","cib-reason","cib-redbubble","cib-reddit","cib-reddit-alt","cib-redhat","cib-redis","cib-redux","cib-renren","cib-reverbnation","cib-riot","cib-ripple","cib-riseup","cib-rollup-js","cib-roots","cib-roundcube","cib-rss","cib-rstudio","cib-ruby","cib-rubygems","cib-runkeeper","cib-rust","cib-safari","cib-sahibinden","cib-salesforce","cib-saltstack","cib-samsung","cib-samsung-pay","cib-sap","cib-sass","cib-sass-alt","cib-saucelabs","cib-scala","cib-scaleway","cib-scribd","cib-scrutinizerci","cib-seagate","cib-sega","cib-sellfy","cib-semaphoreci","cib-sensu","cib-sentry","cib-server-fault","cib-shazam","cib-shell","cib-shopify","cib-showpad","cib-siemens","cib-signal","cib-sina-weibo","cib-sitepoint","cib-sketch","cib-skillshare","cib-skyliner","cib-skype","cib-slack","cib-slashdot","cib-slickpic","cib-slides","cib-slideshare","cib-smashingmagazine","cib-snapchat","cib-snapcraft","cib-snyk","cib-society6","cib-socket-io","cib-sogou","cib-solus","cib-songkick","cib-sonos","cib-soundcloud","cib-sourceforge","cib-sourcegraph","cib-spacemacs","cib-spacex","cib-sparkfun","cib-sparkpost","cib-spdx","cib-speaker-deck","cib-spectrum","cib-spotify","cib-spotlight","cib-spreaker","cib-spring","cib-sprint","cib-squarespace","cib-stackbit","cib-stackexchange","cib-stackoverflow","cib-stackpath","cib-stackshare","cib-stadia","cib-statamic","cib-staticman","cib-statuspage","cib-steam","cib-steem","cib-steemit","cib-stitcher","cib-storify","cib-storybook","cib-strapi","cib-strava","cib-stripe","cib-stripe-s","cib-stubhub","cib-stumbleupon","cib-styleshare","cib-stylus","cib-sublime-text","cib-subversion","cib-superuser","cib-svelte","cib-svg","cib-swagger","cib-swarm","cib-swift","cib-symantec","cib-symfony","cib-synology","cib-t-mobile","cib-tableau","cib-tails","cib-tapas","cib-teamviewer","cib-ted","cib-teespring","cib-telegram","cib-telegram-plane","cib-tencent-qq","cib-tencent-weibo","cib-tensorflow","cib-terraform","cib-tesla","cib-the-mighty","cib-the-movie-database","cib-tidal","cib-tiktok","cib-tinder","cib-todoist","cib-toggl","cib-topcoder","cib-toptal","cib-tor","cib-toshiba","cib-trainerroad","cib-trakt","cib-travisci","cib-treehouse","cib-trello","cib-tripadvisor","cib-trulia","cib-tumblr","cib-twilio","cib-twitch","cib-twitter","cib-twoo","cib-typescript","cib-typo3","cib-uber","cib-ubisoft","cib-ublock-origin","cib-ubuntu","cib-udacity","cib-udemy","cib-uikit","cib-umbraco","cib-unity","cib-unreal-engine","cib-unsplash","cib-untappd","cib-upwork","cib-usb","cib-v8","cib-vagrant","cib-venmo","cib-verizon","cib-viadeo","cib-viber","cib-vim","cib-vimeo","cib-vimeo-v","cib-vine","cib-virb","cib-visa","cib-visual-studio","cib-visual-studio-code","cib-vk","cib-vlc","cib-vsco","cib-vue-js","cib-wattpad","cib-weasyl","cib-webcomponents-org","cib-webpack","cib-webstorm","cib-wechat","cib-whatsapp","cib-when-i-work","cib-wii","cib-wiiu","cib-wikipedia","cib-windows","cib-wire","cib-wireguard","cib-wix","cib-wolfram","cib-wolfram-language","cib-wolfram-mathematica","cib-wordpress","cib-wpengine","cib-x-pack","cib-xbox","cib-xcode","cib-xero","cib-xiaomi","cib-xing","cib-xrp","cib-xsplit","cib-y-combinator","cib-yahoo","cib-yammer","cib-yandex","cib-yarn","cib-yelp","cib-youtube","cib-zalando","cib-zapier","cib-zeit","cib-zendesk","cib-zerply","cib-zillow","cib-zingat","cib-zoom","cib-zorin","cib-zulip","cif-Norway","cif-United","cif-Arab","cif-Emirates","cif-Afghanistan","cif-Antigua","cif-and","cif-Barbuda","cif-Albania","cif-Armenia","cif-Angola","cif-Argentina","cif-Austria","cif-Australia","cif-Azerbaijan","cif-Bosnia","cif-and","cif-Herzegovina","cif-Barbados","cif-Bangladesh","cif-Belgium","cif-Burkina","cif-Faso","cif-Bulgaria","cif-Bahrain","cif-Burundi","cif-Benin","cif-Brunei","cif-Darussalam","cif-Bolivia","cif-Brazil","cif-Bahamas","cif-Andorra","cif-Botswana","cif-Belarus","cif-Belize","cif-Canada","cif-Congo,","cif-The","cif-Democratic","cif-Republic","cif-of","cif-the","cif-Central","cif-African","cif-Republic","cif-Congo","cif-Switzerland","cif-Chile","cif-Cameroon","cif-China","cif-Colombia","cif-Costa","cif-Rica","cif-Cuba","cif-Cape","cif-Verde","cif-Cyprus","cif-Czech","cif-Republic","cif-Germany","cif-Djibouti","cif-Denmark","cif-Dominica","cif-Dominican","cif-Republic","cif-Algeria","cif-Ecuador","cif-Estonia","cif-Egypt","cif-Eritrea","cif-Spain","cif-Ethiopia","cif-Finland","cif-Fiji","cif-Micronesia,","cif-Federated","cif-States","cif-of","cif-France","cif-Gabon","cif-United","cif-Kingdom","cif-Grenada","cif-Georgia","cif-Ghana","cif-Gambia","cif-Guinea","cif-Equatorial","cif-Guinea","cif-Greece","cif-Guatemala","cif-Guinea-Bissau","cif-Guyana","cif-Hong","cif-Kong","cif-Honduras","cif-Croatia","cif-Japan","cif-Hungary","cif-Indonesia","cif-Ireland","cif-Israel","cif-India","cif-Iraq","cif-Iran,","cif-Islamic","cif-Republic","cif-Of","cif-Iceland","cif-Italy","cif-Jamaica","cif-Jordan","cif-Bhutan","cif-Kenya","cif-Kyrgyzstan","cif-Cambodia","cif-Kiribati","cif-Comoros","cif-Saint","cif-Kitts","cif-and","cif-Nevis","cif-Korea,","cif-Republic","cif-of","cif-Kuwait","cif-Kazakhstan","cif-Haiti","cif-Lebanon","cif-Saint","cif-Lucia","cif-Liechtenstein","cif-Sri","cif-Lanka","cif-Liberia","cif-Lesotho","cif-Lithuania","cif-Luxembourg","cif-Latvia","cif-Libyan","cif-Arab","cif-Jamahiriya","cif-Morocco","cif-Monaco","cif-Moldova,","cif-Republic","cif-of","cif-Montenegro","cif-Madagascar","cif-Marshall","cif-Islands","cif-Macedonia,","cif-The","cif-Former","cif-Yugoslav","cif-Republic","cif-of","cif-Mali","cif-Myanmar","cif-Mongolia","cif-Mauritania","cif-Malta","cif-Mauritius","cif-Maldives","cif-Malawi","cif-Mexico","cif-Malaysia","cif-Mozambique","cif-Namibia","cif-Niger","cif-Nigeria","cif-Nicaragua","cif-Netherlands","cif-Nepal","cif-Nauru","cif-Niue","cif-New","cif-Zealand","cif-Oman","cif-Panama","cif-Peru","cif-Papua","cif-New","cif-Guinea","cif-Philippines","cif-Pakistan","cif-Poland","cif-Portugal","cif-Palau","cif-Paraguay","cif-Qatar","cif-Romania","cif-Serbia","cif-Russian","cif-Federation","cif-RWANDA","cif-Saudi","cif-Arabia","cif-Solomon","cif-Islands","cif-Seychelles","cif-Sudan","cif-Sweden","cif-Singapore","cif-Slovenia","cif-Slovakia","cif-Sierra","cif-Leone","cif-San","cif-Marino","cif-Senegal","cif-Somalia","cif-Suriname","cif-South","cif-Sudan","cif-Sao","cif-Tome","cif-and","cif-Principe","cif-El","cif-Salvador","cif-Syrian","cif-Arab","cif-Republic","cif-Swaziland","cif-Chad","cif-Togo","cif-Thailand","cif-Tajikistan","cif-Timor-Leste","cif-Turkmenistan","cif-Tunisia","cif-Tonga","cif-Turkey","cif-Trinidad","cif-and","cif-Tobago","cif-Tuvalu","cif-Taiwan,","cif-Province","cif-of","cif-China","cif-Tanzania,","cif-United","cif-Republic","cif-of","cif-Ukraine","cif-Uganda","cif-United","cif-States","cif-Uruguay","cif-Uzbekistan","cif-Holy","cif-See","cif-(Vatican","cif-City","cif-State)","cif-Saint","cif-Vincent","cif-and","cif-the","cif-Grenadines","cif-Venezuela","cif-Viet","cif-Nam","cif-Samoa","cif-Kosovo","cif-Yemen","cif-South","cif-Africa","cif-Zambia","cif-Zimbabwe"})
     * @link https://icons.coreui.io/icons/
     * @author @coreui/icons
     * @license https://github.com/coreui/coreui-icons/blob/master/LICENSE
     */
    public string $icon = "cil-chevron-right";

    /**
     * @var string
     */
    public string $title;

    /**
     * @var bool
     */
    public bool $hidden;

    /**
     * @var string
     */
    public string $badge;

    /**
     * @var string
     * @Enum({"info","success","warning","danger"})
     */
    public string $badgeClass;

    /**
     * @var array
     */
    public array $requiredGetParams;

    /**
     * @var bool
     */
    public bool $isLabel;

    /**
     * @var string
     * @Enum({"info","success","warning","danger"})
     */
    public string $labelClass;

    /**
     * @var string
     * @Enum({"","cil-3d","cil-4k","cil-account-logout","cil-action-redo","cil-action-undo","cil-address-book","cil-airplane-mode","cil-airplane-mode-off","cil-airplay","cil-alarm","cil-album","cil-align-center","cil-align-left","cil-align-right","cil-american-football","cil-animal","cil-aperture","cil-apple","cil-applications","cil-applications-settings","cil-apps","cil-apps-settings","cil-arrow-bottom","cil-arrow-circle-bottom","cil-arrow-circle-left","cil-arrow-circle-right","cil-arrow-circle-top","cil-arrow-left","cil-arrow-right","cil-arrow-thick-bottom","cil-arrow-thick-from-bottom","cil-arrow-thick-from-left","cil-arrow-thick-from-right","cil-arrow-thick-from-top","cil-arrow-thick-left","cil-arrow-thick-right","cil-arrow-thick-to-bottom","cil-arrow-thick-to-left","cil-arrow-thick-to-right","cil-arrow-thick-to-top","cil-arrow-thick-top","cil-arrow-top","cil-assistive-listening-system","cil-asterisk","cil-asterisk-circle","cil-at","cil-audio","cil-audio-description","cil-audio-spectrum","cil-av-timer","cil-baby","cil-baby-carriage","cil-backspace","cil-badge","cil-balance-scale","cil-ban","cil-bank","cil-bank","cil-bar-chart","cil-barcode","cil-baseball","cil-basket","cil-basketball","cil-bath","cil-bathroom","cil-battery-0","cil-battery-3","cil-battery-5","cil-battery-alert","cil-battery-empty","cil-battery-full","cil-battery-slash","cil-beach-access","cil-beaker","cil-bed","cil-bell","cil-bell-exclamation","cil-bike","cil-birthday-cake","cil-blind","cil-bluetooth","cil-blur","cil-blur-circular","cil-blur-linear","cil-boat-alt","cil-bold","cil-bolt","cil-bolt-circle","cil-book","cil-bookmark","cil-border-all","cil-border-bottom","cil-border-clear","cil-border-horizontal","cil-border-inner","cil-border-left","cil-border-outer","cil-border-right","cil-border-style","cil-border-top","cil-border-vertical","cil-bowling","cil-braille","cil-briefcase","cil-brightness","cil-british-pound","cil-browser","cil-brush","cil-brush-alt","cil-bug","cil-building","cil-bullhorn","cil-burger","cil-burn","cil-bus-alt","cil-calculator","cil-calendar","cil-calendar-check","cil-camera","cil-camera-control","cil-camera-roll","cil-car-alt","cil-caret-bottom","cil-caret-left","cil-caret-right","cil-caret-top","cil-cart","cil-cash","cil-casino","cil-cast","cil-cat","cil-cc","cil-center-focus","cil-chart","cil-chart-line","cil-chart-pie","cil-chat-bubble","cil-check","cil-check-alt","cil-check-circle","cil-chevron-bottom","cil-chevron-circle-down-alt","cil-chevron-circle-left-alt","cil-chevron-circle-right-alt","cil-chevron-circle-up-alt","cil-chevron-double-down","cil-chevron-double-left","cil-chevron-double-right","cil-chevron-double-up","cil-chevron-left","cil-chevron-right","cil-chevron-top","cil-child","cil-child-friendly","cil-circle","cil-clear-all","cil-clipboard","cil-clock","cil-clone","cil-closed-captioning","cil-cloud","cil-cloud-download","cil-cloud-upload","cil-cloudy","cil-code","cil-coffee","cil-cog","cil-color-border","cil-color-fill","cil-color-palette","cil-columns","cil-command","cil-comment-bubble","cil-comment-square","cil-compass","cil-compress","cil-contact","cil-contrast","cil-control","cil-copy","cil-couch","cil-credit-card","cil-crop","cil-crop-rotate","cil-cursor","cil-cursor-move","cil-cut","cil-data-transfer-down","cil-data-transfer-up","cil-deaf","cil-delete","cil-description","cil-devices","cil-dialpad","cil-diamond","cil-dinner","cil-disabled","cil-dog","cil-dollar","cil-door","cil-double-quote-sans-left","cil-double-quote-sans-right","cil-drink","cil-drink-alcohol","cil-drop","cil-drop","cil-eco","cil-education","cil-elevator","cil-envelope-closed","cil-envelope-letter","cil-envelope-open","cil-equalizer","cil-ethernet","cil-euro","cil-excerpt","cil-exit-to-app","cil-expand-down","cil-expand-left","cil-expand-right","cil-expand-up","cil-exposure","cil-external-link","cil-eyedropper","cil-face","cil-face-dead","cil-factory","cil-factory-slash","cil-fastfood","cil-fax","cil-featured-playlist","cil-file","cil-filter","cil-filter-frames","cil-filter-photo","cil-filter-square","cil-filter-x","cil-find-in-page","cil-fingerprint","cil-fire","cil-flag-alt","cil-flight-takeoff","cil-flip","cil-flip-to-back","cil-flip-to-front","cil-flower","cil-folder","cil-folder-open","cil-font","cil-football","cil-fork","cil-fridge","cil-frown","cil-fullscreen","cil-fullscreen-exit","cil-functions","cil-functions-alt","cil-gamepad","cil-garage","cil-gem","cil-gif","cil-gift","cil-globe-alt","cil-golf","cil-golf-alt","cil-gradient","cil-grain","cil-graph","cil-grid","cil-grid-slash","cil-group","cil-hamburger-menu","cil-hand-point-down","cil-hand-point-left","cil-hand-point-right","cil-hand-point-up","cil-happy","cil-hd","cil-hdr","cil-header","cil-headphones","cil-healing","cil-heart","cil-highlighter","cil-highligt","cil-history","cil-home","cil-hospital","cil-hot-tub","cil-house","cil-https","cil-image","cil-image","cil-image-broken","cil-image-plus","cil-inbox","cil-indent-decrease","cil-indent-increase","cil-industry","cil-industry-slash","cil-info","cil-input","cil-input-hdmi","cil-input-power","cil-institution","cil-italic","cil-justify-center","cil-justify-left","cil-justify-right","cil-keyboard","cil-lan","cil-language","cil-laptop","cil-layers","cil-leaf","cil-lemon","cil-level-down","cil-level-up","cil-library","cil-library-add","cil-library-building","cil-life-ring","cil-lightbulb","cil-line-spacing","cil-line-style","cil-line-weight","cil-link","cil-link-alt","cil-link-broken","cil-list","cil-list-filter","cil-list-high-priority","cil-list-low-priority","cil-list-numbered","cil-list-numbered-rtl","cil-list-rich","cil-location-pin","cil-lock-locked","cil-lock-unlocked","cil-locomotive","cil-loop","cil-loop-1","cil-loop-circular","cil-low-vision","cil-magnifying-glass","cil-map","cil-media-eject","cil-media-pause","cil-media-play","cil-media-record","cil-media-skip-backward","cil-media-skip-forward","cil-media-step-backward","cil-media-step-forward","cil-media-stop","cil-medical-cross","cil-meh","cil-memory","cil-menu","cil-mic","cil-microphone","cil-minus","cil-mobile","cil-mobile-landscape","cil-money","cil-monitor","cil-mood-bad","cil-mood-good","cil-mood-very-bad","cil-mood-very-good","cil-moon","cil-mouse","cil-mouth-slash","cil-move","cil-movie","cil-mug","cil-mug-tea","cil-music-note","cil-newspaper","cil-note-add","cil-notes","cil-object-group","cil-object-ungroup","cil-opacity","cil-opentype","cil-options","cil-paint","cil-paint-bucket","cil-paper-plane","cil-paperclip","cil-paragraph","cil-paw","cil-pen","cil-pen-alt","cil-pen-nib","cil-pencil","cil-people","cil-phone","cil-pin","cil-pin","cil-pizza","cil-plant","cil-playlist-add","cil-plus","cil-pool","cil-power-standby","cil-pregnant","cil-print","cil-pushchair","cil-puzzle","cil-qr-code","cil-rain","cil-rectangle","cil-recycle","cil-reload","cil-report-slash","cil-resize-both","cil-resize-height","cil-resize-width","cil-restaurant","cil-room","cil-router","cil-rowing","cil-rss","cil-ruble","cil-running","cil-sad","cil-satelite","cil-save","cil-school","cil-screen-desktop","cil-screen-smartphone","cil-scrubber","cil-search","cil-send","cil-settings","cil-share","cil-share-all","cil-share-alt","cil-share-boxed","cil-shield-alt","cil-short-text","cil-shower","cil-sign-language","cil-signal-cellular-0","cil-signal-cellular-3","cil-signal-cellular-4","cil-sim","cil-sitemap","cil-smile","cil-smile-plus","cil-smoke","cil-smoke-free","cil-smoke-slash","cil-smoking-room","cil-snowflake","cil-soccer","cil-sofa","cil-sort-alpha-down","cil-sort-alpha-up","cil-sort-ascending","cil-sort-descending","cil-sort-numeric-down","cil-sort-numeric-up","cil-spa","cil-space-bar","cil-speak","cil-speaker","cil-speech","cil-speedometer","cil-spreadsheet","cil-square","cil-star","cil-star-half","cil-storage","cil-stream","cil-strikethrough","cil-sun","cil-swap-horizontal","cil-swap-vertical","cil-swimming","cil-sync","cil-tablet","cil-tag","cil-tags","cil-task","cil-taxi","cil-tennis","cil-tennis-ball","cil-terminal","cil-terrain","cil-text","cil-text-shapes","cil-text-size","cil-text-square","cil-text-strike","cil-thumb-down","cil-thumb-up","cil-toggle-off","cil-toggle-on","cil-toilet","cil-touch-app","cil-transfer","cil-translate","cil-trash","cil-triangle","cil-truck","cil-tv","cil-tv","cil-underline","cil-usb","cil-user","cil-user-female","cil-user-follow","cil-user-plus","cil-user-unfollow","cil-user-x","cil-vector","cil-vertical-align-bottom","cil-vertical-align-bottom","cil-vertical-align-center","cil-vertical-align-center","cil-vertical-align-top","cil-vertical-align-top","cil-video","cil-videogame","cil-view-column","cil-view-module","cil-view-quilt","cil-view-stream","cil-voice","cil-voice-over-record","cil-volume-high","cil-volume-low","cil-volume-off","cil-walk","cil-wallet","cil-wallpaper","cil-warning","cil-watch","cil-wc","cil-weightlifitng","cil-wheelchair","cil-wifi-signal-0","cil-wifi-signal-1","cil-wifi-signal-2","cil-wifi-signal-3","cil-wifi-signal-4","cil-wifi-signal-off","cil-window","cil-window-maximize","cil-window-minimize","cil-window-restore","cil-wrap-text","cil-x","cil-x-circle","cil-yen","cil-zoom","cil-zoom-in","cil-zoom-out","cil-infinity","cib-500px","cib-500px-5","cib-about-me","cib-abstract","cib-acm","cib-addthis","cib-adguard","cib-adobe","cib-adobe-acrobat-reader","cib-adobe-after-effects","cib-adobe-audition","cib-adobe-creative-cloud","cib-adobe-dreamweaver","cib-adobe-illustrator","cib-adobe-indesign","cib-adobe-lightroom","cib-adobe-lightroom-classic","cib-adobe-photoshop","cib-adobe-premiere","cib-adobe-typekit","cib-adobe-xd","cib-airbnb","cib-algolia","cib-alipay","cib-allocine","cib-amazon","cib-amazon-aws","cib-amazon-pay","cib-amd","cib-american-express","cib-anaconda","cib-analogue","cib-android","cib-android-alt","cib-angellist","cib-angular","cib-angular-universal","cib-ansible","cib-apache","cib-apache-airflow","cib-apache-flink","cib-apache-spark","cib-app-store","cib-app-store-ios","cib-apple","cib-apple-music","cib-apple-pay","cib-apple-podcasts","cib-appveyor","cib-aral","cib-arch-linux","cib-archive-of-our-own","cib-arduino","cib-artstation","cib-arxiv","cib-asana","cib-at-and-t","cib-atlassian","cib-atom","cib-audible","cib-aurelia","cib-auth0","cib-automatic","cib-autotask","cib-aventrix","cib-azure-artifacts","cib-azure-devops","cib-azure-pipelines","cib-babel","cib-baidu","cib-bamboo","cib-bancontact","cib-bandcamp","cib-basecamp","cib-bathasu","cib-behance","cib-big-cartel","cib-bing","cib-bit","cib-bitbucket","cib-bitcoin","cib-bitdefender","cib-bitly","cib-blackberry","cib-blender","cib-blogger","cib-blogger-b","cib-bluetooth","cib-bluetooth-b","cib-boeing","cib-boost","cib-bootstrap","cib-bower","cib-brand-ai","cib-brave","cib-btc","cib-buddy","cib-buffer","cib-buy-me-a-coffee","cib-buysellads","cib-buzzfeed","cib-c","cib-cakephp","cib-campaign-monitor","cib-canva","cib-cashapp","cib-cassandra","cib-castro","cib-cc-amazon-pay","cib-cc-amex","cib-cc-apple-pay","cib-cc-diners-club","cib-cc-discover","cib-cc-jcb","cib-cc-mastercard","cib-cc-paypal","cib-cc-stripe","cib-cc-visa","cib-centos","cib-cevo","cib-chase","cib-chef","cib-chromecast","cib-circle","cib-circleci","cib-cirrusci","cib-cisco","cib-civicrm","cib-clockify","cib-clojure","cib-cloudbees","cib-cloudflare","cib-cmake","cib-co-op","cib-codacy","cib-code-climate","cib-codecademy","cib-codecov","cib-codeigniter","cib-codepen","cib-coderwall","cib-codesandbox","cib-codeship","cib-codewars","cib-codio","cib-coffeescript","cib-common-workflow-language","cib-composer","cib-conda-forge","cib-conekta","cib-confluence","cib-coreui","cib-coreui-c","cib-coursera","cib-coveralls","cib-cpanel","cib-cplusplus","cib-creative-commons","cib-creative-commons-by","cib-creative-commons-nc","cib-creative-commons-nc-eu","cib-creative-commons-nc-jp","cib-creative-commons-nd","cib-creative-commons-pd","cib-creative-commons-pd-alt","cib-creative-commons-remix","cib-creative-commons-sa","cib-creative-commons-sampling","cib-creative-commons-sampling-plus","cib-creative-commons-share","cib-creative-commons-zero","cib-crunchbase","cib-crunchyroll","cib-css3","cib-css3-shiled","cib-csswizardry","cib-d3-js","cib-dailymotion","cib-dashlane","cib-dazn","cib-dblp","cib-debian","cib-deepin","cib-deezer","cib-delicious","cib-dell","cib-deno","cib-dependabot","cib-designer-news","cib-dev-to","cib-deviantart","cib-devrant","cib-diaspora","cib-digg","cib-digital-ocean","cib-discord","cib-discourse","cib-discover","cib-disqus","cib-disroot","cib-django","cib-docker","cib-docusign","cib-dot-net","cib-draugiem-lv","cib-dribbble","cib-drone","cib-dropbox","cib-drupal","cib-dtube","cib-duckduckgo","cib-dynatrace","cib-ebay","cib-eclipseide","cib-elastic","cib-elastic-cloud","cib-elastic-search","cib-elastic-stack","cib-electron","cib-elementary","cib-eleventy","cib-ello","cib-elsevier","cib-emlakjet","cib-empirekred","cib-envato","cib-epic-games","cib-epson","cib-esea","cib-eslint","cib-ethereum","cib-etsy","cib-event-store","cib-eventbrite","cib-evernote","cib-everplaces","cib-evry","cib-exercism","cib-experts-exchange","cib-expo","cib-eyeem","cib-f-secure","cib-facebook","cib-facebook-f","cib-faceit","cib-fandango","cib-favro","cib-feathub","cib-fedex","cib-fedora","cib-feedly","cib-fido-alliance","cib-figma","cib-filezilla","cib-firebase","cib-fitbit","cib-flask","cib-flattr","cib-flickr","cib-flipboard","cib-flutter","cib-fnac","cib-foursquare","cib-framer","cib-freebsd","cib-freecodecamp","cib-fur-affinity","cib-furry-network","cib-garmin","cib-gatsby","cib-gauges","cib-genius","cib-gentoo","cib-geocaching","cib-gerrit","cib-gg","cib-ghost","cib-gimp","cib-git","cib-gitea","cib-github","cib-gitkraken","cib-gitlab","cib-gitpod","cib-gitter","cib-glassdoor","cib-glitch","cib-gmail","cib-gnu","cib-gnu-privacy-guard","cib-gnu-social","cib-go","cib-godot-engine","cib-gog-com","cib-goldenline","cib-goodreads","cib-google","cib-google-ads","cib-google-allo","cib-google-analytics","cib-google-chrome","cib-google-cloud","cib-google-keep","cib-google-pay","cib-google-play","cib-google-podcasts","cib-googles-cholar","cib-gov-uk","cib-gradle","cib-grafana","cib-graphcool","cib-graphql","cib-grav","cib-gravatar","cib-greenkeeper","cib-greensock","cib-groovy","cib-groupon","cib-grunt","cib-gulp","cib-gumroad","cib-gumtree","cib-habr","cib-hackaday","cib-hackerearth","cib-hackerone","cib-hackerrank","cib-hackhands","cib-hackster","cib-happycow","cib-hashnode","cib-haskell","cib-hatena-bookmark","cib-haxe","cib-helm","cib-here","cib-heroku","cib-hexo","cib-highly","cib-hipchat","cib-hitachi","cib-hockeyapp","cib-homify","cib-hootsuite","cib-hotjar","cib-houzz","cib-hp","cib-html5","cib-html5-shield","cib-htmlacademy","cib-huawei","cib-hubspot","cib-hulu","cib-humble-bundle","cib-iata","cib-ibm","cib-icloud","cib-iconjar","cib-icq","cib-ideal","cib-ifixit","cib-imdb","cib-indeed","cib-inkscape","cib-instacart","cib-instagram","cib-instapaper","cib-intel","cib-intellijidea","cib-intercom","cib-internet-explorer","cib-invision","cib-ionic","cib-issuu","cib-itch-io","cib-jabber","cib-java","cib-javascript","cib-jekyll","cib-jenkins","cib-jest","cib-jet","cib-jetbrains","cib-jira","cib-joomla","cib-jquery","cib-js","cib-jsdelivr","cib-jsfiddle","cib-json","cib-jupyter","cib-justgiving","cib-kaggle","cib-kaios","cib-kaspersky","cib-kentico","cib-keras","cib-keybase","cib-keycdn","cib-khan-academy","cib-kibana","cib-kickstarter","cib-kik","cib-kirby","cib-klout","cib-known","cib-ko-fi","cib-kodi","cib-koding","cib-kotlin","cib-krita","cib-kubernetes","cib-lanyrd","cib-laravel","cib-laravel-horizon","cib-laravel-nova","cib-last-fm","cib-latex","cib-launchpad","cib-leetcode","cib-lenovo","cib-less","cib-lets-encrypt","cib-letterboxd","cib-lgtm","cib-liberapay","cib-librarything","cib-libreoffice","cib-line","cib-linkedin","cib-linkedin-in","cib-linux","cib-linux-foundation","cib-linux-mint","cib-livejournal","cib-livestream","cib-logstash","cib-lua","cib-lumen","cib-lyft","cib-macys","cib-magento","cib-magisk","cib-mail-ru","cib-mailchimp","cib-makerbot","cib-manjaro","cib-markdown","cib-marketo","cib-mastercard","cib-mastodon","cib-material-design","cib-mathworks","cib-matrix","cib-mattermost","cib-matternet","cib-maxcdn","cib-mcafee","cib-media-temple","cib-mediafire","cib-medium","cib-medium-m","cib-meetup","cib-mega","cib-mendeley","cib-messenger","cib-meteor","cib-micro-blog","cib-microgenetics","cib-microsoft","cib-microsoft-edge","cib-minetest","cib-minutemailer","cib-mix","cib-mixcloud","cib-mixer","cib-mojang","cib-monero","cib-mongodb","cib-monkeytie","cib-monogram","cib-monzo","cib-moo","cib-mozilla","cib-mozilla-firefox","cib-musescore","cib-mxlinux","cib-myspace","cib-mysql","cib-nativescript","cib-nec","cib-neo4j","cib-netflix","cib-netlify","cib-next-js","cib-nextcloud","cib-nextdoor","cib-nginx","cib-nim","cib-nintendo","cib-nintendo-3ds","cib-nintendo-gamecube","cib-nintendo-switch","cib-node-js","cib-node-red","cib-nodemon","cib-nokia","cib-notion","cib-npm","cib-nucleo","cib-nuget","cib-nuxt-js","cib-nvidia","cib-ocaml","cib-octave","cib-octopus-deploy","cib-oculus","cib-odnoklassniki","cib-open-access","cib-open-collective","cib-open-id","cib-open-source-initiative","cib-openstreetmap","cib-opensuse","cib-openvpn","cib-opera","cib-opsgenie","cib-oracle","cib-orcid","cib-origin","cib-osi","cib-osmc","cib-overcast","cib-overleaf","cib-ovh","cib-pagekit","cib-palantir","cib-pandora","cib-pantheon","cib-patreon","cib-paypal","cib-periscope","cib-php","cib-picarto-tv","cib-pinboard","cib-pingdom","cib-pingup","cib-pinterest","cib-pinterest-p","cib-pivotaltracker","cib-plangrid","cib-player-me","cib-playerfm","cib-playstation","cib-playstation3","cib-playstation4","cib-plesk","cib-plex","cib-pluralsight","cib-plurk","cib-pocket","cib-postgresql","cib-postman","cib-postwoman","cib-powershell","cib-prettier","cib-prismic","cib-probot","cib-processwire","cib-product-hunt","cib-proto-io","cib-protonmail","cib-proxmox","cib-pypi","cib-python","cib-pytorch","cib-qgis","cib-qiita","cib-qq","cib-qualcomm","cib-quantcast","cib-quantopian","cib-quarkus","cib-quora","cib-qwiklabs","cib-qzone","cib-r","cib-radiopublic","cib-rails","cib-raspberry-pi","cib-react","cib-read-the-docs","cib-readme","cib-realm","cib-reason","cib-redbubble","cib-reddit","cib-reddit-alt","cib-redhat","cib-redis","cib-redux","cib-renren","cib-reverbnation","cib-riot","cib-ripple","cib-riseup","cib-rollup-js","cib-roots","cib-roundcube","cib-rss","cib-rstudio","cib-ruby","cib-rubygems","cib-runkeeper","cib-rust","cib-safari","cib-sahibinden","cib-salesforce","cib-saltstack","cib-samsung","cib-samsung-pay","cib-sap","cib-sass","cib-sass-alt","cib-saucelabs","cib-scala","cib-scaleway","cib-scribd","cib-scrutinizerci","cib-seagate","cib-sega","cib-sellfy","cib-semaphoreci","cib-sensu","cib-sentry","cib-server-fault","cib-shazam","cib-shell","cib-shopify","cib-showpad","cib-siemens","cib-signal","cib-sina-weibo","cib-sitepoint","cib-sketch","cib-skillshare","cib-skyliner","cib-skype","cib-slack","cib-slashdot","cib-slickpic","cib-slides","cib-slideshare","cib-smashingmagazine","cib-snapchat","cib-snapcraft","cib-snyk","cib-society6","cib-socket-io","cib-sogou","cib-solus","cib-songkick","cib-sonos","cib-soundcloud","cib-sourceforge","cib-sourcegraph","cib-spacemacs","cib-spacex","cib-sparkfun","cib-sparkpost","cib-spdx","cib-speaker-deck","cib-spectrum","cib-spotify","cib-spotlight","cib-spreaker","cib-spring","cib-sprint","cib-squarespace","cib-stackbit","cib-stackexchange","cib-stackoverflow","cib-stackpath","cib-stackshare","cib-stadia","cib-statamic","cib-staticman","cib-statuspage","cib-steam","cib-steem","cib-steemit","cib-stitcher","cib-storify","cib-storybook","cib-strapi","cib-strava","cib-stripe","cib-stripe-s","cib-stubhub","cib-stumbleupon","cib-styleshare","cib-stylus","cib-sublime-text","cib-subversion","cib-superuser","cib-svelte","cib-svg","cib-swagger","cib-swarm","cib-swift","cib-symantec","cib-symfony","cib-synology","cib-t-mobile","cib-tableau","cib-tails","cib-tapas","cib-teamviewer","cib-ted","cib-teespring","cib-telegram","cib-telegram-plane","cib-tencent-qq","cib-tencent-weibo","cib-tensorflow","cib-terraform","cib-tesla","cib-the-mighty","cib-the-movie-database","cib-tidal","cib-tiktok","cib-tinder","cib-todoist","cib-toggl","cib-topcoder","cib-toptal","cib-tor","cib-toshiba","cib-trainerroad","cib-trakt","cib-travisci","cib-treehouse","cib-trello","cib-tripadvisor","cib-trulia","cib-tumblr","cib-twilio","cib-twitch","cib-twitter","cib-twoo","cib-typescript","cib-typo3","cib-uber","cib-ubisoft","cib-ublock-origin","cib-ubuntu","cib-udacity","cib-udemy","cib-uikit","cib-umbraco","cib-unity","cib-unreal-engine","cib-unsplash","cib-untappd","cib-upwork","cib-usb","cib-v8","cib-vagrant","cib-venmo","cib-verizon","cib-viadeo","cib-viber","cib-vim","cib-vimeo","cib-vimeo-v","cib-vine","cib-virb","cib-visa","cib-visual-studio","cib-visual-studio-code","cib-vk","cib-vlc","cib-vsco","cib-vue-js","cib-wattpad","cib-weasyl","cib-webcomponents-org","cib-webpack","cib-webstorm","cib-wechat","cib-whatsapp","cib-when-i-work","cib-wii","cib-wiiu","cib-wikipedia","cib-windows","cib-wire","cib-wireguard","cib-wix","cib-wolfram","cib-wolfram-language","cib-wolfram-mathematica","cib-wordpress","cib-wpengine","cib-x-pack","cib-xbox","cib-xcode","cib-xero","cib-xiaomi","cib-xing","cib-xrp","cib-xsplit","cib-y-combinator","cib-yahoo","cib-yammer","cib-yandex","cib-yarn","cib-yelp","cib-youtube","cib-zalando","cib-zapier","cib-zeit","cib-zendesk","cib-zerply","cib-zillow","cib-zingat","cib-zoom","cib-zorin","cib-zulip","cif-Norway","cif-United","cif-Arab","cif-Emirates","cif-Afghanistan","cif-Antigua","cif-and","cif-Barbuda","cif-Albania","cif-Armenia","cif-Angola","cif-Argentina","cif-Austria","cif-Australia","cif-Azerbaijan","cif-Bosnia","cif-and","cif-Herzegovina","cif-Barbados","cif-Bangladesh","cif-Belgium","cif-Burkina","cif-Faso","cif-Bulgaria","cif-Bahrain","cif-Burundi","cif-Benin","cif-Brunei","cif-Darussalam","cif-Bolivia","cif-Brazil","cif-Bahamas","cif-Andorra","cif-Botswana","cif-Belarus","cif-Belize","cif-Canada","cif-Congo,","cif-The","cif-Democratic","cif-Republic","cif-of","cif-the","cif-Central","cif-African","cif-Republic","cif-Congo","cif-Switzerland","cif-Chile","cif-Cameroon","cif-China","cif-Colombia","cif-Costa","cif-Rica","cif-Cuba","cif-Cape","cif-Verde","cif-Cyprus","cif-Czech","cif-Republic","cif-Germany","cif-Djibouti","cif-Denmark","cif-Dominica","cif-Dominican","cif-Republic","cif-Algeria","cif-Ecuador","cif-Estonia","cif-Egypt","cif-Eritrea","cif-Spain","cif-Ethiopia","cif-Finland","cif-Fiji","cif-Micronesia,","cif-Federated","cif-States","cif-of","cif-France","cif-Gabon","cif-United","cif-Kingdom","cif-Grenada","cif-Georgia","cif-Ghana","cif-Gambia","cif-Guinea","cif-Equatorial","cif-Guinea","cif-Greece","cif-Guatemala","cif-Guinea-Bissau","cif-Guyana","cif-Hong","cif-Kong","cif-Honduras","cif-Croatia","cif-Japan","cif-Hungary","cif-Indonesia","cif-Ireland","cif-Israel","cif-India","cif-Iraq","cif-Iran,","cif-Islamic","cif-Republic","cif-Of","cif-Iceland","cif-Italy","cif-Jamaica","cif-Jordan","cif-Bhutan","cif-Kenya","cif-Kyrgyzstan","cif-Cambodia","cif-Kiribati","cif-Comoros","cif-Saint","cif-Kitts","cif-and","cif-Nevis","cif-Korea,","cif-Republic","cif-of","cif-Kuwait","cif-Kazakhstan","cif-Haiti","cif-Lebanon","cif-Saint","cif-Lucia","cif-Liechtenstein","cif-Sri","cif-Lanka","cif-Liberia","cif-Lesotho","cif-Lithuania","cif-Luxembourg","cif-Latvia","cif-Libyan","cif-Arab","cif-Jamahiriya","cif-Morocco","cif-Monaco","cif-Moldova,","cif-Republic","cif-of","cif-Montenegro","cif-Madagascar","cif-Marshall","cif-Islands","cif-Macedonia,","cif-The","cif-Former","cif-Yugoslav","cif-Republic","cif-of","cif-Mali","cif-Myanmar","cif-Mongolia","cif-Mauritania","cif-Malta","cif-Mauritius","cif-Maldives","cif-Malawi","cif-Mexico","cif-Malaysia","cif-Mozambique","cif-Namibia","cif-Niger","cif-Nigeria","cif-Nicaragua","cif-Netherlands","cif-Nepal","cif-Nauru","cif-Niue","cif-New","cif-Zealand","cif-Oman","cif-Panama","cif-Peru","cif-Papua","cif-New","cif-Guinea","cif-Philippines","cif-Pakistan","cif-Poland","cif-Portugal","cif-Palau","cif-Paraguay","cif-Qatar","cif-Romania","cif-Serbia","cif-Russian","cif-Federation","cif-RWANDA","cif-Saudi","cif-Arabia","cif-Solomon","cif-Islands","cif-Seychelles","cif-Sudan","cif-Sweden","cif-Singapore","cif-Slovenia","cif-Slovakia","cif-Sierra","cif-Leone","cif-San","cif-Marino","cif-Senegal","cif-Somalia","cif-Suriname","cif-South","cif-Sudan","cif-Sao","cif-Tome","cif-and","cif-Principe","cif-El","cif-Salvador","cif-Syrian","cif-Arab","cif-Republic","cif-Swaziland","cif-Chad","cif-Togo","cif-Thailand","cif-Tajikistan","cif-Timor-Leste","cif-Turkmenistan","cif-Tunisia","cif-Tonga","cif-Turkey","cif-Trinidad","cif-and","cif-Tobago","cif-Tuvalu","cif-Taiwan,","cif-Province","cif-of","cif-China","cif-Tanzania,","cif-United","cif-Republic","cif-of","cif-Ukraine","cif-Uganda","cif-United","cif-States","cif-Uruguay","cif-Uzbekistan","cif-Holy","cif-See","cif-(Vatican","cif-City","cif-State)","cif-Saint","cif-Vincent","cif-and","cif-the","cif-Grenadines","cif-Venezuela","cif-Viet","cif-Nam","cif-Samoa","cif-Kosovo","cif-Yemen","cif-South","cif-Africa","cif-Zambia","cif-Zimbabwe"})
     * @link https://icons.coreui.io/icons/
     * @author @coreui/icons
     * @license https://github.com/coreui/coreui-icons/blob/master/LICENSE
     */
    public string $labelIcon;

    /**
     * @var string
     */
    public string $style;

    /**
     * @var string
     */
    public string $description;

    /**
     * @var string
     */
    public string $href = "javascript:void(0)";

    /**
     * @var string
     * @Enum({"_blank", "_self", "_parent"})
     */
    public string $target;
}