<?php
/**
 * MIT License
 *
 * Copyright (c) 2020 DW Web-Engineering
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

namespace Modules\ExampleModule\Controllers;


use Annotations\Navigation;
use Annotations\Redirect;
use Annotations\SubNavigation;
use Annotations\SubRoute;
use Annotations\SubRoutes;
use Controllers\PublicFrontController;

/**
 * Class ExampleController
 * @package Modules\Example\Controllers
 * @Navigation(text="Example Public Menu", position="sidebar")
 */
class IndexController extends PublicFrontController
{
    /**
     * @SubNavigation(text="Public Menu Link")
     */
    public function indexAction(): void
    {
        parent::indexAction(); // TODO: Change the autogenerated stub
    }

    /**
     * @SubNavigation(text="Public Disabled Link", icon="cil-ban", requiredGetParams={"required_param_1", "required_param_2"})
     */
    public function disabledAction(): void {}

    /**
     * @SubNavigation(text="Test", icon="cil-line-spacing")
     * @SubRoutes(routes={
     *     @SubRoute(text="SubRoute Link1", icon="cil-mood-good", hrefQueryAddition={"test": "test", "test2": "test2"}),
     *     @SubRoute(text="SubRoute Link2", labelIcon="cil-meh", href="javascript:void(0)", isLabel=true, labelClass="danger"),
     *     @SubRoute(text="SubRoute Link3", labelIcon="cil-mood-very-bad", href="javascript:void(0)", isLabel=true, labelClass="info"),
     *     @SubRoute(text="SubRoute Link4", icon="cil-mood-very-good", href="javascript:void(0)"),
     *     @SubRoute(text="SubRoute Link5", icon="cil-mood-very-good", href="javascript:void(0)"),
     * }, onlyWhenActive=false)
     */
    public function testAction(): void
    {
        parent::indexAction();
    }
}