# DWWE - Php ORM React Framework (Phorm RF)
PHP & React JS efficiently combined

## General informations

Why we develop our own framework when there are many others? Quite simply, to tailor it to the needs that are needed.
The Phorm React Framework offers a professional possibility to develop completely detached from the core.

Below you may find some useful links that lead to necessary documentations!

## Installation

To create a new Phorm RF project using Composer you can use the create-project command. Pass the package name, and the directory to create the project in. You can also provide a version as third argument, otherwise the latest version is used.

```composer create-project dwwe/php-orm-react-framework project-dir```

After the project has been successfully created, install the npm library, change to the project directory and use the command 

```yarn install```

Repeat the same step again in the ```assets``` directory, when that's done you can get started!
If you have not installed yarn and npm you can do this here [https://classic.yarnpkg.com/en/docs/install](https://classic.yarnpkg.com/en/docs/install)

***

## React

A JavaScript library for building user interfaces

[https://reactjs.org/](https://reactjs.org/)

***

## Doctrine 2 ORM

Doctrine 2 is an object-relational mapper (ORM) <http://en.wikipedia.org/wiki/Object-relational_mapping> for PHP 5.4+ that provides transparent persistence for PHP objects. It uses the Data Mapper pattern at the heart, aiming for a complete separation of your domain/business logic from the persistence in a relational database management system.

The benefit of Doctrine for the programmer is the ability to focus on the object-oriented business logic and worry about persistence only as a secondary problem. This doesn't mean persistence is downplayed by Doctrine 2, however it is our belief that there are considerable benefits for object-oriented programming if persistence and entities are kept separated.

[https://www.doctrine-project.org/projects/doctrine-orm/en/2.6/index.html](https://www.doctrine-project.org/projects/doctrine-orm/en/2.6/index.html)

***
## Webpack Encore

Webpack Encore is a simpler way to integrate Webpack into your application. It wraps Webpack, giving you a clean & powerful API for bundling JavaScript modules, pre-processing CSS & JS and compiling and minifying assets. Encore gives you a professional asset system that's a delight to use.

[https://symfony.com/doc/current/frontend.html](https://symfony.com/doc/current/frontend.html)

***

## UI-Docs

CoreUI is the fastest way to build a modern dashboard for any platforms, browser, or device. A complete Dashboard UI Kit that allows you to quickly build eye-catching, high-quality, high-performance responsive applications.

- Bootstrap: [https://coreui.io/docs/getting-started/introduction/](https://coreui.io/docs/getting-started/introduction/)
- React: [https://coreui.io/react/docs/3.3/](https://coreui.io/react/docs/3.3/)

***

## Template

Here you can get an overview of all available elements and get an impression of the way of representation above

- Bootstrap: [https://coreui.io/demo/free/3.4.0/](https://coreui.io/demo/free/3.4.0/)
- React JS: [https://coreui.io/react/demo/free/3.1.1/#/dashboard](https://coreui.io/react/demo/free/3.1.1/#/dashboard)

***

## CoreUI Free React and Bootstrap Admin Template v2.6.1 (React) and v3.4.0 (Bootstrap)

CoreUI is an Open Source Bootstrap Admin Template. But CoreUI is not just another Admin Template. It goes way beyond hitherto admin templates thanks to transparent code and file structure. And if that's not enough, let’s just add that CoreUI consists bunch of unique features and over 1000 high quality icons. In the folder ```src/views/``` you will find a lot of examples of how an implementation with React can look like. 

- Bootstrap: [https://github.com/coreui/coreui-free-bootstrap-admin-template/tree/v3.4.0](https://github.com/coreui/coreui-free-bootstrap-admin-template/tree/v3.4.0)
- React: [https://github.com/coreui/coreui-free-react-admin-template/tree/v2.6.1](https://github.com/coreui/coreui-free-react-admin-template/tree/v2.6.1)

#### Please note that we use both CoreUI and CoreUI Pro in our framwork. We have acquired a valid license for CoreUI Pro. If you want to use the Pro version of the CoreUI template in your project, you will most likely need to purchase a license. You can find more information at https://coreui.io/pro/.

***

## Twig - Template engine for PHP 

Twig is a modern template engine for PHP

[https://twig.symfony.com/](https://twig.symfony.com/)

***

## PhpFastCache

Simple Yet Powerful PHP Caching Class

More information in [Wiki](https://github.com/PHPSocialNetwork/phpfastcache/wiki) The simplicity of abstraction: One class for many backend cache. You don't need to rewrite your code many times again.

[https://www.phpfastcache.com/](https://www.phpfastcache.com/)

