/*
 Navicat Premium Data Transfer

 Source Server         : mysql8
 Source Server Type    : MySQL
 Source Server Version : 80028
 Source Host           : 101.42.135.254:3307
 Source Schema         : admin_mall

 Target Server Type    : MySQL
 Target Server Version : 80028
 File Encoding         : 65001

 Date: 17/02/2022 16:37:25
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for Sys_File_busines
-- ----------------------------
DROP TABLE IF EXISTS `Sys_File_busines`;
CREATE TABLE `Sys_File_busines`  (
  `Id` char(36) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `Extension` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `Title` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `BucketName` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `ObjectName` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `Size` bigint NOT NULL,
  `FileStatus` int NOT NULL DEFAULT 0,
  `BusinessCode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `BusinessId` char(36) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
  `AccountCode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_bin ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of Sys_File_busines
-- ----------------------------
INSERT INTO `Sys_File_busines` VALUES ('08d9d82f-d204-48ad-8eb3-01054607cfec', '2022-01-15 22:03:34.874545', '2022-01-15 22:04:04.900069', 0, NULL, '.jpg', 'touxiang', 'storage', 'images/92f51289-e444-4177-b739-c405c5ad511b.jpg', 14324, 1, 'article.coverImage', '48403a10-f60e-4fd6-a728-3f950436d564', 'admin');
INSERT INTO `Sys_File_busines` VALUES ('08d9d831-189f-4e28-8c86-59b73d3aae94', '2022-01-15 22:12:43.711023', NULL, 0, NULL, '.png', 'test2', 'storage', 'images/dc7bd7c4-d719-4d3d-a5d9-e9452a8fa0a3.png', 52970, 0, 'article.coverImage', '2e48ba60-17fe-4faa-9f15-7c0d102f70ac', 'admin');
INSERT INTO `Sys_File_busines` VALUES ('08d9d831-34c5-4d10-8f4c-30d0588706aa', '2022-01-15 22:13:30.008284', '2022-01-15 22:13:41.232014', 0, NULL, '.png', 'test2', 'storage', 'images/c9398661-fbe6-4205-851e-2d40aa7846d3.png', 52970, 1, 'article.coverImage', '0b0e271d-4f05-4283-90d4-baa2e3f73a25', 'admin');
INSERT INTO `Sys_File_busines` VALUES ('08d9d831-a01f-4129-850f-ab51943bc502', '2022-01-15 22:16:30.110106', '2022-01-15 22:16:36.719678', 0, NULL, '.jpg', 'touxiang', 'storage', 'images/0ba17982-aef4-4029-a0cb-77a9daeadd1b.jpg', 14324, 1, 'article.coverImage', '774d6d40-0c17-423d-b5d2-ca6eaa80bfb9', 'admin');
INSERT INTO `Sys_File_busines` VALUES ('08d9d8c0-0080-4135-8823-5e470ca7caef', '2022-01-16 15:15:40.350535', '2022-01-16 15:15:48.194202', 0, NULL, '.jpg', 'touxiang', 'storage', 'images/9ad4f272-8a68-4310-bb18-8b78d9334d10.jpg', 14324, 1, 'blog.link.backImg', '586ebf59-fa18-4ef9-9f1d-4edae338aa9b', 'admin');
INSERT INTO `Sys_File_busines` VALUES ('08d9f1df-23a6-483e-8540-c8c32488af8e', '2022-02-17 14:31:32.786190', '2022-02-17 14:31:35.527501', 0, NULL, '.png', 'photo-1523726491678-bf852e717f6a', 'storage', 'images/df06b200-7db1-483f-bb5c-5d66b0ee5999.png', 117534, 1, 'article.coverImage', '9ef1de35-9da8-48f9-8f02-7565bb381b8e', 'admin');
INSERT INTO `Sys_File_busines` VALUES ('08d9f1df-9ba7-48c7-8a81-fbabb704b4b7', '2022-02-17 14:34:54.115105', '2022-02-17 14:51:59.642954', 0, NULL, '.png', '23984952-8e264adc9bbc3aa3', 'storage', 'images/e4394e0e-6a2b-4fd9-b1ed-a1c8d35243fb.png', 42044, 1, 'article.contentImage', 'f0361b89-e5fb-4d73-b65e-00843c7ee361', 'admin');
INSERT INTO `Sys_File_busines` VALUES ('08d9f1e0-113a-4775-8991-14a3d74dd56c', '2022-02-17 14:38:11.371537', '2022-02-17 14:51:59.642972', 0, NULL, '.png', '23984952-da5bd7c329bcc937', 'storage', 'images/f3fbf84f-8d78-4ffb-b7cf-82b3bb28c7ef.png', 5842, 1, 'article.contentImage', 'f0361b89-e5fb-4d73-b65e-00843c7ee361', 'admin');
INSERT INTO `Sys_File_busines` VALUES ('08d9f1e0-28bf-4daa-8fd7-30acd74636b2', '2022-02-17 14:38:50.836936', '2022-02-17 14:51:59.642972', 0, NULL, '.png', '23984952-6ccc3c525cf54ac9', 'storage', 'images/ac8fc5c6-2cfe-4f15-b2d0-398a622679ae.png', 7088, 1, 'article.contentImage', 'f0361b89-e5fb-4d73-b65e-00843c7ee361', 'admin');
INSERT INTO `Sys_File_busines` VALUES ('08d9f1e0-7ea7-4593-8f81-45f06953cc1f', '2022-02-17 14:41:14.957583', '2022-02-17 14:51:59.642972', 0, NULL, '.jpg', 'istockphoto-483902160-170667a', 'storage', 'images/750c07b2-071e-4857-a6e0-cada87be221a.jpg', 124554, 1, 'article.coverImage', 'f0361b89-e5fb-4d73-b65e-00843c7ee361', 'admin');
INSERT INTO `Sys_File_busines` VALUES ('08d9f1e1-af70-4e4a-87cb-26c61d2d494a', '2022-02-17 14:49:46.307603', '2022-02-17 14:51:59.642972', 0, NULL, '.png', '金额转换', 'storage', 'images/acdd6108-d3d4-42b5-9dd3-31e9ff01341f.png', 29147, 1, 'article.contentImage', 'f0361b89-e5fb-4d73-b65e-00843c7ee361', 'admin');
INSERT INTO `Sys_File_busines` VALUES ('08d9f1e8-51fe-48d6-8246-11741c237dca', '2022-02-17 15:37:16.024656', '2022-02-17 16:19:57.763246', 0, NULL, '.png', '截图', 'storage', 'images/7b596fa9-2e0d-444a-8024-ac9987851f35.png', 15488, 1, 'article.contentImage', '3927ba01-0c71-44a2-84f9-c844f17e776d', 'admin');
INSERT INTO `Sys_File_busines` VALUES ('08d9f1e9-96e7-46aa-8ce8-d894f4d80b21', '2022-02-17 15:46:21.128635', '2022-02-17 16:19:57.763248', 0, NULL, '.png', 'code', 'storage', 'images/4be7fe5c-e903-481b-8443-387e9c4d4161.png', 141399, 1, 'article.coverImage', '3927ba01-0c71-44a2-84f9-c844f17e776d', 'admin');

-- ----------------------------
-- Table structure for __EFMigrationsHistory
-- ----------------------------
DROP TABLE IF EXISTS `__EFMigrationsHistory`;
CREATE TABLE `__EFMigrationsHistory`  (
  `MigrationId` varchar(95) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `ProductVersion` varchar(32) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  PRIMARY KEY (`MigrationId`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of __EFMigrationsHistory
-- ----------------------------
INSERT INTO `__EFMigrationsHistory` VALUES ('20211212033338_init', '3.1.7');
INSERT INTO `__EFMigrationsHistory` VALUES ('20211212034138_test', '3.1.7');
INSERT INTO `__EFMigrationsHistory` VALUES ('20211212034251_remove_test', '3.1.7');
INSERT INTO `__EFMigrationsHistory` VALUES ('20211213050138_update_sysuser', '3.1.7');
INSERT INTO `__EFMigrationsHistory` VALUES ('20211213084615_update_sysuser_2', '3.1.7');
INSERT INTO `__EFMigrationsHistory` VALUES ('20211213133713_update_sysuser_4', '3.1.7');
INSERT INTO `__EFMigrationsHistory` VALUES ('20211220080450_add_sys_oper_log', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20211220091854_update_sys_oper_log', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20211220131413_add_sys_login_log', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20220104145845_add_blog_tabls', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20220104151932_add_IsDisableComment', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20220107053819_update_table', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20220107081031_update_table02', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20220111115742_add_fileupload', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20220112055838_add_BusinessId', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20220112060942_remove_BusinessId', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20220115135004_add_articletag', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20220116063327_edit_blog_link', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20220116122501_edit_BlogComment', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20220118073010_add_blogcomment_CommentLocation', '3.1.22');
INSERT INTO `__EFMigrationsHistory` VALUES ('20220203075037_add_BlogArticle_Introduction', '3.1.22');

-- ----------------------------
-- Table structure for blog_article
-- ----------------------------
DROP TABLE IF EXISTS `blog_article`;
CREATE TABLE `blog_article`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `UserId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `ArticleTitle` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `ArticleContent` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `ArticleStatus` int NOT NULL DEFAULT 0,
  `CategoryId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `Top` int NOT NULL DEFAULT 0,
  `ViewNum` int NOT NULL DEFAULT 0,
  `LikeNum` int NOT NULL DEFAULT 0,
  `CommentNum` int NOT NULL DEFAULT 0,
  `Auth` int NOT NULL DEFAULT 0,
  `IsDisableComment` tinyint(1) NOT NULL DEFAULT 0,
  `Introduction` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of blog_article
-- ----------------------------
INSERT INTO `blog_article` VALUES ('3927ba01-0c71-44a2-84f9-c844f17e776d', '2022-02-17 15:46:47.874793', '2022-02-17 16:20:00.636513', 0, NULL, '35fe9b5d-57cc-11ec-ad18-0242ac110004', 'AspNet部署到docker容器', '# 部署\n## 发布文件准备\n1. 点击要发布web程序，右键添加Dockerfile\n2. 编辑dockerfile文件如下：\n``` dockerfile\n# 使用运行时镜像\nFROM mcr.microsoft.com/dotnet/aspnet:6.0 AS base\n# 设置系统时间\nRUN echo \"Asia/shanghai\" > /etc/timezone\nRUN cp /usr/share/zoneinfo/Asia/Shanghai /etc/localtime\n\n# 设置工作目录\nWORKDIR /app\n# 把目录下的内容都复制到当前目录下\nCOPY . .\n# 暴露80端口\nEXPOSE 80\n# 运行镜像入口命令和可执行文件名称\nENTRYPOINT [\"dotnet\", \"w.Framework.Admin.Api.dll\"]\n```\n3. 修改Dockerfile文件的属性，修改为始终复制，这样能保证Dockerfile可以随程序一起发布。\n![截图.png](https://resource.yousu.xyz/storage/images/7b596fa9-2e0d-444a-8024-ac9987851f35.png)\n4. 点击发布并打包到Centos主机上\n\n## 开始部署\n1. 生成镜像（其中[xxx]是镜像名）\n``` docker\ndocker build -t aspnet3.1/admin:v1 . #admin是镜像名称，冒号后面是版本号（注意后面的点要加）\n```\n2. 启动运行生成号的镜像项目\n``` docker\ndocker run --name=admin01 -p 8080:80 -v /home/docker/www/admin:/app -d aspnet3.1/admin:v1 --restart=always\n #数据卷映射，注意：（宿主机必须有发布文件，否则docker容器app会被清空，建议使用打包后的解压包的发布文件）\n```\n备注\n``` cmd\n--name ：指定容器名称。\n--p ：指定容器端口，（8080外部端口，80容器端口）\n--d ：指定容器后台运行。\n--restart=always：容器启动并一起启动\n```\n## 其它相关命令 \n``` docker\n# 容器数据拷贝到宿主机命令：\ndocker cp my:/app /root/myapp\n\n# 宿主机拷贝到容器，反过来即可\ndocker cp /root/myapp my:/app\n```', 1, '08d9f1e7-1624-406e-8ea1-733d381f35a0', 0, 5, 3, 0, 0, 1, '在Centos 7.6上的Docker容器部署Asp.Net项目，这里部署只支持core以上版本');
INSERT INTO `blog_article` VALUES ('9ef1de35-9da8-48f9-8f02-7565bb381b8e', '2022-02-17 13:58:13.172327', '2022-02-17 14:31:35.527490', 0, NULL, '35fe9b5d-57cc-11ec-ad18-0242ac110004', 'C# 将人民币大写金额转换为数字金额', '``` c#\n    /// <summary>\n    /// 将人民币大写金额转换为数字金额\n    /// </summary>\n    public class RMBConversion\n    {\n        /// <summary>\n        /// 把大写中文转换为数字金额\n        /// </summary>\n        /// <param name=\"rmbStr\"></param>\n        /// <returns></returns>\n        public static decimal ToLowerCase(string rmbStr)\n        {\n            Dictionary<string, decimal> dict1 = new Dictionary<string, decimal>()\n            {\n                { \"壹\", 1 },\n                { \"贰\", 2 },\n                { \"叁\", 3 },\n                { \"肆\", 4 },\n                { \"伍\", 5 },\n                { \"陆\", 6 },\n                { \"柒\", 7 },\n                { \"捌\", 8 },\n                { \"玖\", 9 },\n            };\n            Dictionary<string, decimal> dict2 = new Dictionary<string, decimal>()\n            {\n                { \"拾\", 10 },\n                { \"佰\", 100 },\n                { \"仟\", 1000 },\n                { \"万\", 10000 },\n                { \"元\", 1 },\n                { \"角\", 0.1M },\n                { \"分\", 0.01M },\n            };\n            decimal result = 0M;\n            int rmbLength = rmbStr.Length;\n            for (int i = 0; i < rmbStr.Length; i++)\n            {\n                var nowStr = rmbStr[i].ToString();\n                var nowStrNext = i < rmbStr.Length - 1 ? rmbStr[i + 1].ToString() : \"\";\n                if ((dict1.ContainsKey(nowStr) && dict2.ContainsKey(nowStrNext)) || (dict2.ContainsKey(nowStr) && nowStrNext == \"万\"))\n                {\n                    if (nowStrNext != \"万\")\n                    {\n                        result += dict1[nowStr] * dict2[nowStrNext];\n                    }\n                    else if (dict2.ContainsKey(nowStr))\n                    {\n                        result *= 1000;\n                    }\n                    else\n                    {\n                        result += dict1[nowStr];\n                        result *= 10000;\n                    }\n                }\n                else if (nowStr == \"拾\" && nowStrNext == \"元\" && (rmbStr[0].ToString() + rmbStr[1].ToString()) == \"拾元\")\n                {\n                    result = 10;\n                }\n            }\n            return result;\n        }\n\n        /// <summary>\n        /// 判断金额是否是大写\n        /// </summary>\n        /// <param name=\"strCase\"></param>\n        /// <returns></returns>\n        public static bool IsContainCase(string strCase)\n        {\n            if (string.IsNullOrEmpty(strCase))\n            {\n                return false;\n            }\n            var arr = new List<string>() { \"壹\", \"贰\", \"叁\", \"肆\", \"伍\", \"陆\", \"柒\", \"捌\", \"玖\", \"零\", \"拾\", \"佰\", \"仟\", \"万\", \"亿\", \"圆\", \"整\", \"元\", \"正\" };\n\n            return arr.Contains(strCase[0].ToString());\n        }\n    }\n```', 1, '14f9df92-721e-11ec-b79b-0242ac110003', 0, 3, 1, 0, 0, 1, '使用C#把生活中人民币中文大写转换成阿拉伯数字');
INSERT INTO `blog_article` VALUES ('f0361b89-e5fb-4d73-b65e-00843c7ee361', '2022-02-17 14:41:30.066102', '2022-02-17 15:21:24.963829', 0, NULL, '35fe9b5d-57cc-11ec-ad18-0242ac110004', 'ASP.NET HTML转PDF', '## 包引用\n==这里使用的是TuesPechkin，引用下面2个Nuget包==\n\n![239849528e264adc9bbc3aa3.png](https://resource.yousu.xyz/storage/images/e4394e0e-6a2b-4fd9-b1ed-a1c8d35243fb.png)\n## 封装简单工具类\n\n``` c#\n    /// <summary>\n    /// html转pdf帮助类\n    /// </summary>\n    public static class HtmlToPdfHelper\n    {\n        private static readonly string _fileDir = \"htmlToPdf\";\n        private static readonly string _savePath = System.Web.Hosting.HostingEnvironment.MapPath(\"/\" + _fileDir);\n        private static IConverter _converter = null; //官方要求在程序生命周期内，只能实例化一次\n        private static string _domainUrl;\n\n        /// <summary>\n        /// 获取当前站点域名\n        /// </summary>\n        /// <returns></returns>\n        public static string DomainUrl\n        {\n            get\n            {\n                Uri uri = HttpContext.Current.Request.Url;\n                _domainUrl = uri.Scheme + \"://\" + uri.Host;\n                if (!uri.IsDefaultPort)\n                {\n                    _domainUrl += \":\" + uri.Port;\n                }\n                return _domainUrl;\n            }\n        }\n\n        static HtmlToPdfHelper()\n        {\n            _converter =\n                new ThreadSafeConverter(\n                    new RemotingToolset<PdfToolset>(\n                        new WinAnyCPUEmbeddedDeployment(\n                            new TempFolderDeployment())));\n\n            //_converter.Begin += ConverterOnBegin;\n            //_converter.PhaseChange += ConverterOnPhaseChange;\n            //_converter.ProgressChange += ConverterOnProgressChange;\n            //_converter.Finish += ConverterOnFinish;\n            _converter.Warning += new EventHandler<WarningEventArgs>((o, w) =>\n            {\n                Console.WriteLine(\"HtmlToPdfHelper类，html转换PDF，产生警告信息：\" + w.WarningMessage);\n            });\n            _converter.Error += new EventHandler<TuesPechkin.ErrorEventArgs>((o, e) =>\n            {\n                Console.WriteLine(\"HtmlToPdfHelper类，html转换PDF，产生错误信息：\" + e.ErrorMessage);\n            });\n        }\n\n        /// <summary>\n        /// 转换为pdf字节\n        /// </summary>\n        /// <param name=\"doc\"></param>\n        /// <returns></returns>\n        private static byte[] Filing(IDocument doc)\n        {\n            byte[] result = _converter.Convert(doc);\n            return result;\n        }\n\n        /// <summary>\n        /// 构建PDF服务器访问地址\n        /// </summary>\n        /// <param name=\"pdfName\"></param>\n        /// <returns></returns>\n        private static string BuildUrl(string pdfName)\n        {\n            return $@\"{DomainUrl}/{_fileDir}/{pdfName}.pdf\";\n        }\n\n        /// <summary>\n        /// 构建PDF保存路径\n        /// </summary>\n        /// <param name=\"pdfName\"></param>\n        /// <returns></returns>\n        private static string BuildSaveSrc(string pdfName)\n        {\n            return $@\"{_savePath}\\{pdfName}.pdf\";\n        }\n\n        /// <summary>\n        /// 查找已转换的PDF文件\n        /// </summary>\n        /// <param name=\"pdfName\">已保存PDF名称</param>\n        /// <returns>返回保存Url地址</returns>\n        private static string FindSaveHtmlPdf(string pdfName)\n        {\n            //把文件读进文件流 \n            var fileSrc = BuildSaveSrc(pdfName);\n            if (!File.Exists(fileSrc))\n            {\n                return string.Empty;\n            }\n            return BuildUrl(pdfName);\n        }\n\n        /// <summary>\n        /// 保存已转换的PDF文件\n        /// </summary>\n        /// <param name=\"fileName\">PDF文件名</param>\n        /// <param name=\"bf\">保存字节集</param>\n        /// <returns>保存成功返回url</returns>\n        private static string SaveHtmlToPdfFile(string fileName, byte[] bf)\n        {\n            var path = _savePath;\n            if (!Directory.Exists(path))\n            {\n                Directory.CreateDirectory(path);\n            }\n            System.IO.File.WriteAllBytes(BuildSaveSrc(fileName), bf);\n            return BuildUrl(fileName);\n        }\n\n        /// <summary>\n        /// 根据类型转换PDF为字节\n        /// </summary>\n        /// <param name=\"document\">保存文档</param>\n        /// <param name=\"type\">保存的类型</param>\n        /// <returns></returns>\n        private static byte[] BuildDocumentByType(string document, EHtmlToPdfDocumentType type)\n        {\n            byte[] saveBuffer = null;\n            if (type == EHtmlToPdfDocumentType.HtmlUrl)\n            {\n                saveBuffer = ConvertHtmlUrlToPDF(document);\n            }\n            else if (type == EHtmlToPdfDocumentType.HtmlText)\n            {\n                saveBuffer = ConvertHtmlTextToPDF(document);\n            }\n            return saveBuffer;\n        }\n\n        /// <summary>\n        /// 转换htmltext为PDF\n        /// </summary>\n        /// <param name=\"htmlText\">html文档内容</param>\n        /// <returns></returns>\n        public static byte[] ConvertHtmlTextToPDF(string htmlText)\n        {\n            if (string.IsNullOrWhiteSpace(htmlText))\n            {\n                new ArgumentNullException(\"htmlText\", \"html的内容不能为空\");\n            }\n\n            var document = new HtmlToPdfDocument\n            {\n                GlobalSettings = { },\n                Objects = {\n                new ObjectSettings {\n                        HtmlText = htmlText,\n                        WebSettings =new WebSettings\n                        {\n                            DefaultEncoding=\"UTF-8\",\n                            LoadImages=true,\n                        }\n                    }\n                },\n\n            };\n            var result = _converter.Convert(document);\n            return result;\n        }\n\n        /// <summary>\n        /// 转换htmlUrl为PDF\n        /// </summary>\n        /// <param name=\"htmlText\">html文档内容</param>\n        /// <returns></returns>\n        public static byte[] ConvertHtmlUrlToPDF(string htmlUrl)\n        {\n            if (string.IsNullOrWhiteSpace(htmlUrl))\n            {\n                new ArgumentNullException(\"htmlUrl\", \"html的Url地址不能为空\");\n            }\n\n            var doc = new HtmlToPdfDocument();\n            doc.Objects.Add(new ObjectSettings { PageUrl = htmlUrl });\n\n            byte[] result = Filing(doc);\n            return result;\n        }\n\n        /// <summary>\n        /// 获取Html转换后的PDF文件Url（如果文件不存在，并先执行保存，在返回url地址）\n        /// </summary>\n        /// <param name=\"pdfName\">要保存PDF名称</param>\n        /// <param name=\"document\">要保存的Hmtl文档内容，（例如，htmlTXT，htmlurl）</param>\n        /// <param name=\"type\">保存的type类型</param>\n        /// <param name=\"IsCover\">是否覆盖（默认不覆盖）</param>\n        /// <returns></returns>\n        public static string GetHtmlToPdfSaveUrl(string pdfName, string document, EHtmlToPdfDocumentType type, bool IsCover = false)\n        {\n            string pdfSaveUrl = FindSaveHtmlPdf(pdfName);\n            if (string.IsNullOrEmpty(pdfSaveUrl) || IsCover)\n            {\n                //获取转换成功后PDF字节\n                byte[] saveBuffer = BuildDocumentByType(document, type);\n                //返回保存成功后PDF文件url\n                return SaveHtmlToPdfFile(pdfName, saveBuffer);\n            }\n            return pdfSaveUrl;\n        }\n\n        /// <summary>\n        /// 下载Html转换后的PDF文件字节流（如果文件不存在，并先执行保存，在返回下载字节流）\n        /// </summary>\n        /// <param name=\"pdfName\">要保存PDF名称</param>\n        /// <param name=\"document\">要保存的Hmtl文档内容，（例如，htmlTXT，htmlurl）</param>\n        /// <param name=\"type\">保存的type类型</param>\n        /// <param name=\"IsCover\">是否覆盖（默认不覆盖）</param>\n        /// <returns></returns>\n        public static byte[] DownloadHtmlToPdf(string pdfName, string document, EHtmlToPdfDocumentType type, bool IsCover = false)\n        {\n            byte[] saveBuffer = DownloadSaveHtmlToPdf(pdfName);\n            if (saveBuffer == null || IsCover)\n            {\n                //获取转换成功后PDF字节\n                saveBuffer = BuildDocumentByType(document, type);\n                //保存PDF文件\n                SaveHtmlToPdfFile(pdfName, saveBuffer);\n                return saveBuffer;\n            }\n            return saveBuffer;\n        }\n\n        /// <summary>\n        /// 获取已存在服务器上的PDF文件字节\n        /// </summary>\n        /// <param name=\"pdfName\">文件名称</param>\n        /// <returns></returns>\n        public static byte[] DownloadSaveHtmlToPdf(string pdfName)\n        {\n            //把文件读进文件流 \n            var fileSrc = BuildSaveSrc(pdfName);\n            if (!File.Exists(fileSrc))\n            {\n                return null;\n            }\n            FileStream fs = new FileStream(fileSrc, FileMode.Open);\n            byte[] file = new byte[fs.Length];\n            fs.Read(file, 0, file.Length);\n            fs.Close();\n            return file;\n        }\n    }\n\n    /// <summary>\n    /// 文档转换类型\n    /// </summary>\n    public enum EHtmlToPdfDocumentType\n    {\n        HtmlUrl = 0,\n        HtmlText = 1,\n    }\n```\n\n## 测试代码\n``` c#\n public string GetHtmlToPdf(string pdfName, string url)\n  {\n\n            if (string.IsNullOrWhiteSpace(url))\n            {\n                string[] arrs = new string[] { \"http://www.baidu.com\", \"https://news.qq.com/\", \"https://www.sogou.com/\" };\n                var index = new Random().Next(0, arrs.Length);\n                url = arrs[index];\n            }\n            if (string.IsNullOrWhiteSpace(pdfName))\n            {\n                pdfName = DateTime.Now.ToString(\"yyyyMMdd_HHmmss\");\n            }\n\n            var res = HtmlToPdfHelper.GetHtmlToPdfSaveUrl(pdfName, url, EHtmlToPdfDocumentType.HtmlUrl);\n            return res;\n}\n```\n\n## 测试调用\n![23984952da5bd7c329bcc937.png](https://resource.yousu.xyz/storage/images/f3fbf84f-8d78-4ffb-b7cf-82b3bb28c7ef.png)\n\n![239849526ccc3c525cf54ac9.png](https://resource.yousu.xyz/storage/images/ac8fc5c6-2cfe-4f15-b2d0-398a622679ae.png)', 1, '14f9df92-721e-11ec-b79b-0242ac110003', 0, 31, 1, 0, 0, 1, '通过Url地址或者html内容生成到PDF文件，并部署到IIS，转换内容不支持Webpack构建的前端项目');

-- ----------------------------
-- Table structure for blog_article_tag
-- ----------------------------
DROP TABLE IF EXISTS `blog_article_tag`;
CREATE TABLE `blog_article_tag`  (
  `Id` char(36) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `ArticleId` char(36) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `TagId` char(36) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_bin ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of blog_article_tag
-- ----------------------------
INSERT INTO `blog_article_tag` VALUES ('08d9d830-1a3f-45a8-8f9f-fc1cb66fb1d9', '2022-01-15 22:05:36.021111', '2022-02-17 14:07:18.180348', 1, '2022-02-17 14:07:18.165500', '7b25ce40-809a-4f13-902b-05d79f9d4be0', 'cd1c05d6-7099-11ec-ae8d-0242ac110002');
INSERT INTO `blog_article_tag` VALUES ('08d9d830-1a3f-4b64-8d6c-79526d892304', '2022-01-15 22:05:36.021120', '2022-02-17 14:07:18.180369', 1, '2022-02-17 14:07:18.170791', '7b25ce40-809a-4f13-902b-05d79f9d4be0', 'aa3dc07d-7099-11ec-ae8d-0242ac110002');
INSERT INTO `blog_article_tag` VALUES ('08d9d830-3c6e-4feb-8fe0-7a3e08cd9de5', '2022-01-15 22:06:33.395938', '2022-01-15 22:11:37.221333', 1, '2022-01-15 22:11:37.203868', '9c04593e-ea93-4c8a-a472-84231abcd3f1', '08d9d824-4820-4c90-858a-c9b21bbd0e28');
INSERT INTO `blog_article_tag` VALUES ('08d9d831-3b72-457c-805c-fcc439d1e761', '2022-01-15 22:13:41.231997', '2022-02-17 14:31:51.780763', 1, '2022-02-17 14:31:51.765790', '451f478c-d517-4b2a-a63f-68e188befa72', 'cd1c05d6-7099-11ec-ae8d-0242ac110002');
INSERT INTO `blog_article_tag` VALUES ('08d9d831-3b72-4c6c-883f-9b5c8011000b', '2022-01-15 22:13:41.232012', '2022-02-17 14:31:51.780790', 1, '2022-02-17 14:31:51.771186', '451f478c-d517-4b2a-a63f-68e188befa72', 'aa3dc07d-7099-11ec-ae8d-0242ac110002');
INSERT INTO `blog_article_tag` VALUES ('08d9d831-a40c-476f-8b7f-a858b8b85254', '2022-01-15 22:16:36.719649', '2022-01-15 22:22:50.856897', 1, '2022-01-15 22:22:50.828306', '0d03159d-27c4-4bec-a3e8-76f08f4451b3', 'aa3dc07d-7099-11ec-ae8d-0242ac110002');
INSERT INTO `blog_article_tag` VALUES ('08d9d831-a40c-4d7c-8331-e1a28447d1c2', '2022-01-15 22:16:36.719660', '2022-01-15 22:22:50.856961', 1, '2022-01-15 22:22:50.840252', '0d03159d-27c4-4bec-a3e8-76f08f4451b3', '08d9d824-4820-4c90-858a-c9b21bbd0e28');
INSERT INTO `blog_article_tag` VALUES ('08d9d831-a40d-433c-82e5-3ca3f5300a5a', '2022-01-15 22:16:36.719666', '2022-01-15 22:22:50.856965', 1, '2022-01-15 22:22:50.845805', '0d03159d-27c4-4bec-a3e8-76f08f4451b3', 'cd1c05d6-7099-11ec-ae8d-0242ac110002');
INSERT INTO `blog_article_tag` VALUES ('08d9e6ea-6a22-49c5-8bfb-2b93cadc21e6', '2022-02-03 15:54:32.748568', '2022-02-17 14:07:22.479310', 1, '2022-02-17 14:07:22.469678', 'edf11af8-974a-494d-b1d7-0e7e97c8f063', 'cd1c05d6-7099-11ec-ae8d-0242ac110002');
INSERT INTO `blog_article_tag` VALUES ('08d9f1df-2528-45e6-8fae-be5138675503', '2022-02-17 14:31:35.527480', NULL, 0, NULL, '9ef1de35-9da8-48f9-8f02-7565bb381b8e', '08d9f1d9-9e2d-41a6-869c-78aab3285816');
INSERT INTO `blog_article_tag` VALUES ('08d9f1e1-fec5-43a9-8864-3f02180fdf13', '2022-02-17 14:51:59.642746', NULL, 0, NULL, 'f0361b89-e5fb-4d73-b65e-00843c7ee361', '08d9f1d9-9e2d-41a6-869c-78aab3285816');
INSERT INTO `blog_article_tag` VALUES ('08d9f1e1-fec5-4adb-83c1-d0b94f4260ea', '2022-02-17 14:51:59.642783', NULL, 0, NULL, 'f0361b89-e5fb-4d73-b65e-00843c7ee361', 'cd1c05d6-7099-11ec-ae8d-0242ac110002');
INSERT INTO `blog_article_tag` VALUES ('08d9f1ee-48cc-4c60-8919-a15693de1d15', '2022-02-17 16:19:57.763214', NULL, 0, NULL, '3927ba01-0c71-44a2-84f9-c844f17e776d', '08d9f1e7-5105-4944-81f5-ecafd5492dcf');

-- ----------------------------
-- Table structure for blog_category
-- ----------------------------
DROP TABLE IF EXISTS `blog_category`;
CREATE TABLE `blog_category`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL COMMENT '主键',
  `CreateTime` datetime(6) NOT NULL COMMENT '创建时间',
  `UpdateTime` datetime(6) NULL DEFAULT NULL COMMENT '修改时间',
  `IsDelete` tinyint(1) NOT NULL COMMENT '是否删除',
  `DeleteTime` datetime(6) NULL DEFAULT NULL COMMENT '删除时间',
  `CategoryTitle` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '' COMMENT '分类名称',
  `ParentId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000' COMMENT '父id',
  `SortNO` int NOT NULL DEFAULT 0 COMMENT '排序',
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of blog_category
-- ----------------------------
INSERT INTO `blog_category` VALUES ('08d9d81e-bede-41a3-8035-6d18b4cba358', '2022-01-15 20:01:21.327374', '2022-01-15 20:01:46.957983', 1, '2022-01-15 20:01:46.930439', '测试', '2ee18b9f-721e-11ec-b79b-0242ac110003', 2);
INSERT INTO `blog_category` VALUES ('08d9d81e-d320-4cd3-8b82-c95b733e9693', '2022-01-15 20:01:55.252740', '2022-02-17 15:27:30.635033', 1, '2022-02-17 15:27:30.610608', '测试1', '2ee18b9f-721e-11ec-b79b-0242ac110003', 2);
INSERT INTO `blog_category` VALUES ('08d9d828-76ce-4203-88e0-6acae4f3c5c0', '2022-01-15 21:10:55.358766', '2022-01-15 21:11:02.054874', 1, '2022-01-15 21:11:02.043799', '测试谷歌', '00000000-0000-0000-0000-000000000000', 3);
INSERT INTO `blog_category` VALUES ('08d9f1e7-1624-406e-8ea1-733d381f35a0', '2022-02-17 15:28:26.090581', NULL, 0, NULL, '部署', '2ee18b9f-721e-11ec-b79b-0242ac110003', 1);
INSERT INTO `blog_category` VALUES ('14f9df92-721e-11ec-b79b-0242ac110003', '2022-01-10 14:03:51.000000', NULL, 0, NULL, '.Net', '71598213-709e-11ec-ae8d-0242ac110002', 1);
INSERT INTO `blog_category` VALUES ('2ee18b9f-721e-11ec-b79b-0242ac110003', '2022-01-10 14:04:38.000000', NULL, 0, NULL, '运维', '00000000-0000-0000-0000-000000000000', 0);
INSERT INTO `blog_category` VALUES ('71598213-709e-11ec-ae8d-0242ac110002', '2022-01-08 16:20:26.000000', NULL, 0, NULL, '编程', '00000000-0000-0000-0000-000000000000', 1);

-- ----------------------------
-- Table structure for blog_comment
-- ----------------------------
DROP TABLE IF EXISTS `blog_comment`;
CREATE TABLE `blog_comment`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `ArticleId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CommentContent` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `ParentCommentId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
  `CommentLikeNum` int NOT NULL DEFAULT 0,
  `CommentNickName` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `CommentIp` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL,
  `CommentRootId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
  `CommentType` int NOT NULL DEFAULT 0,
  `CommenterType` int NOT NULL DEFAULT 0,
  `CommentLocation` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of blog_comment
-- ----------------------------
INSERT INTO `blog_comment` VALUES ('08d9da5b-bbac-4573-87e3-8c0d320c55db', '2022-01-18 16:22:57.558934', '2022-01-18 19:52:12.239998', 0, NULL, '451f478c-d517-4b2a-a63f-68e188befa72', '测试', '00000000-0000-0000-0000-000000000000', 5, '作者', '127.0.0.1', '00000000-0000-0000-0000-000000000000', 0, 1, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9da5d-4b09-4f93-860f-f85e04b5efd4', '2022-01-18 16:34:07.556604', '2022-01-18 17:59:06.621183', 0, NULL, '451f478c-d517-4b2a-a63f-68e188befa72', '评论不错，一起学习', '08d9da5b-bbac-4573-87e3-8c0d320c55db', 2, '作者', '127.0.0.1', '08d9da5b-bbac-4573-87e3-8c0d320c55db', 1, 1, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9da5e-f042-46f5-8a85-df7f90af82e0', '2022-01-18 16:45:54.257885', '2022-01-18 20:08:16.006106', 1, '2022-01-18 20:08:15.980804', '451f478c-d517-4b2a-a63f-68e188befa72', '测试评论2', '00000000-0000-0000-0000-000000000000', 1, '阿喵丶', '127.0.0.1', '00000000-0000-0000-0000-000000000000', 0, 0, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9da5f-66d0-4f49-8907-d0ce419d594c', '2022-01-18 16:49:13.156139', '2022-01-18 20:08:09.651878', 0, NULL, '451f478c-d517-4b2a-a63f-68e188befa72', '阿喵一起学习呀~~~~', '08d9da5e-f042-46f5-8a85-df7f90af82e0', 1, '吃瓜', '127.0.0.1', '08d9da5e-f042-46f5-8a85-df7f90af82e0', 1, 0, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9da5f-843f-4426-85ed-1f1535dd42c8', '2022-01-18 16:50:02.529859', '2022-01-18 19:41:10.412693', 1, '2022-01-18 19:41:10.356753', '451f478c-d517-4b2a-a63f-68e188befa72', '吃瓜，吃瓜', '08d9da5f-66d0-4f49-8907-d0ce419d594c', 0, 'devin', '127.0.0.1', '08d9da5e-f042-46f5-8a85-df7f90af82e0', 1, 0, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9da5f-8d52-44bd-8a02-4e0757abf50e', '2022-01-18 16:50:17.753483', NULL, 0, NULL, '451f478c-d517-4b2a-a63f-68e188befa72', '一起一起啦', '08d9da5e-f042-46f5-8a85-df7f90af82e0', 0, 'devin', '127.0.0.1', '08d9da5e-f042-46f5-8a85-df7f90af82e0', 1, 0, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9da5f-d3b0-4c41-897a-0db744a73520', '2022-01-18 16:52:15.807748', '2022-02-04 00:28:26.871049', 1, '2022-02-04 00:28:26.813709', '451f478c-d517-4b2a-a63f-68e188befa72', '哈哈哈哈', '08d9da5d-4b09-4f93-860f-f85e04b5efd4', 2, '小西瓜', '127.0.0.1', '08d9da5b-bbac-4573-87e3-8c0d320c55db', 1, 0, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9da5f-f934-4bb8-88ae-66ab838e41d8', '2022-01-18 16:53:18.752715', '2022-01-18 20:10:19.372481', 1, '2022-01-18 20:10:19.354698', '451f478c-d517-4b2a-a63f-68e188befa72', '我是小小', '08d9da5b-bbac-4573-87e3-8c0d320c55db', 0, '小小', '127.0.0.1', '08d9da5b-bbac-4573-87e3-8c0d320c55db', 1, 0, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9da60-2345-4283-8d18-01287c7c1ca0', '2022-01-18 16:54:29.327847', NULL, 0, NULL, '451f478c-d517-4b2a-a63f-68e188befa72', '我是大大', '08d9da5f-f934-4bb8-88ae-66ab838e41d8', 0, '大大', '127.0.0.1', '08d9da5b-bbac-4573-87e3-8c0d320c55db', 1, 0, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9db0e-6b97-4f64-8fc2-53e60d91957a', '2022-01-19 13:42:03.164135', NULL, 0, NULL, '451f478c-d517-4b2a-a63f-68e188befa72', '🙄🤣哈哈哈😒😄你好呀😒😊😊', '00000000-0000-0000-0000-000000000000', 0, '作者', '127.0.0.1', '00000000-0000-0000-0000-000000000000', 0, 1, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9db17-629a-4634-8482-2933c1fac07d', '2022-01-19 14:46:13.556623', NULL, 0, NULL, '7b25ce40-809a-4f13-902b-05d79f9d4be0', '自己留个言~~😎😎😎', '00000000-0000-0000-0000-000000000000', 0, '作者', '127.0.0.1', '00000000-0000-0000-0000-000000000000', 0, 1, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9db19-6023-4837-809e-f1da293b160e', '2022-01-19 15:00:28.623336', NULL, 0, NULL, '7b25ce40-809a-4f13-902b-05d79f9d4be0', '在留个😰言', '00000000-0000-0000-0000-000000000000', 0, '作者', '127.0.0.1', '00000000-0000-0000-0000-000000000000', 0, 1, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9e24d-e883-40d9-85e5-72fe5a0251b0', '2022-01-28 19:04:09.325016', NULL, 0, NULL, '7b25ce40-809a-4f13-902b-05d79f9d4be0', '你要呀', '08d9db17-629a-4634-8482-2933c1fac07d', 0, '吃瓜', '127.0.0.1', '08d9db17-629a-4634-8482-2933c1fac07d', 1, 0, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9e24d-f3bc-4904-80f6-7bfe3f373e8f', '2022-01-28 19:04:28.058734', NULL, 0, NULL, '7b25ce40-809a-4f13-902b-05d79f9d4be0', '一起学习', '08d9e24d-e883-40d9-85e5-72fe5a0251b0', 0, '阿喵', '127.0.0.1', '08d9db17-629a-4634-8482-2933c1fac07d', 1, 0, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9e72b-71be-4642-8255-e1b06fb1f4b1', '2022-02-03 23:40:06.054750', NULL, 0, NULL, '451f478c-d517-4b2a-a63f-68e188befa72', 'ddd', '00000000-0000-0000-0000-000000000000', 0, '作者(超级管理员)', '127.0.0.1', '00000000-0000-0000-0000-000000000000', 0, 1, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9e72d-0bbd-4bb7-87cb-e981a76219de', '2022-02-03 23:51:30.674613', NULL, 0, NULL, '451f478c-d517-4b2a-a63f-68e188befa72', 'ggg222😩😀', '00000000-0000-0000-0000-000000000000', 0, '111', '127.0.0.1', '00000000-0000-0000-0000-000000000000', 0, 0, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9e72d-175c-4a10-8d53-702d96458f94', '2022-02-03 23:51:50.165724', '2022-02-04 00:09:15.930342', 0, NULL, '451f478c-d517-4b2a-a63f-68e188befa72', '你好呀，小西瓜', '08d9da5f-d3b0-4c41-897a-0db744a73520', 1, '嘿嘿', '127.0.0.1', '08d9da5b-bbac-4573-87e3-8c0d320c55db', 1, 0, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9e72d-2c90-4aaa-8e03-4e317f8c8b28', '2022-02-03 23:52:29.445430', NULL, 0, NULL, '451f478c-d517-4b2a-a63f-68e188befa72', '你好呀，小西瓜', '08d9da5f-d3b0-4c41-897a-0db744a73520', 0, '嘿嘿', '127.0.0.1', '08d9da5b-bbac-4573-87e3-8c0d320c55db', 1, 0, '0 内网IP');
INSERT INTO `blog_comment` VALUES ('08d9e72d-9707-469f-8ad9-a0439fc53ae8', '2022-02-03 23:55:24.357678', NULL, 0, NULL, '451f478c-d517-4b2a-a63f-68e188befa72', '你也号😜😜', '08d9e72d-2c90-4aaa-8e03-4e317f8c8b28', 0, '哈哈哈哈', '127.0.0.1', '08d9da5b-bbac-4573-87e3-8c0d320c55db', 1, 0, '0 内网IP');

-- ----------------------------
-- Table structure for blog_link
-- ----------------------------
DROP TABLE IF EXISTS `blog_link`;
CREATE TABLE `blog_link`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `LinkTitle` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `LinkUrl` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `SortNO` int NOT NULL DEFAULT 0,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of blog_link
-- ----------------------------
INSERT INTO `blog_link` VALUES ('05074ce2-bf20-400f-8ae8-072688d5743a', '2022-01-16 15:16:19.544915', '2022-01-16 15:18:55.072777', 1, '2022-01-16 15:18:54.365957', 'c测试1', '测试1', 3);
INSERT INTO `blog_link` VALUES ('586ebf59-fa18-4ef9-9f1d-4edae338aa9b', '2022-01-16 15:13:25.759895', '2022-01-16 15:15:48.194164', 0, NULL, '测试2', 'xunyouyou.xyz2', 2);

-- ----------------------------
-- Table structure for blog_tag
-- ----------------------------
DROP TABLE IF EXISTS `blog_tag`;
CREATE TABLE `blog_tag`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `IsQuickNav` tinyint(1) NOT NULL DEFAULT 0,
  `TagTitle` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '',
  `SortNO` int NOT NULL DEFAULT 0,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of blog_tag
-- ----------------------------
INSERT INTO `blog_tag` VALUES ('08d9d824-4820-4c90-858a-c9b21bbd0e28', '2022-01-15 20:40:59.032393', '2022-02-17 13:52:06.680769', 1, '2022-02-17 13:52:06.544777', 0, '测试23', 3);
INSERT INTO `blog_tag` VALUES ('08d9f1d9-9e2d-41a6-869c-78aab3285816', '2022-02-17 13:52:01.446935', NULL, 0, NULL, 0, 'C#', 1);
INSERT INTO `blog_tag` VALUES ('08d9f1e7-5105-4944-81f5-ecafd5492dcf', '2022-02-17 15:30:04.883546', NULL, 0, NULL, 0, '.Net部署', 1);
INSERT INTO `blog_tag` VALUES ('aa3dc07d-7099-11ec-ae8d-0242ac110002', '2022-01-08 15:46:07.000000', NULL, 0, NULL, 1, '科学上网', 1);
INSERT INTO `blog_tag` VALUES ('cd1c05d6-7099-11ec-ae8d-0242ac110002', '2022-01-08 15:47:05.000000', NULL, 0, NULL, 1, 'Web开发', 2);

-- ----------------------------
-- Table structure for blog_website_manage
-- ----------------------------
DROP TABLE IF EXISTS `blog_website_manage`;
CREATE TABLE `blog_website_manage`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `WebSitName` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `BackImage` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of blog_website_manage
-- ----------------------------
INSERT INTO `blog_website_manage` VALUES ('08d9d8d1-f26f-47af-8922-b1e7652aad83', '2022-01-16 17:24:08.952941', '2022-02-17 00:39:52.477941', 0, NULL, 'devin3', 'images/c5f17784-4231-4c1b-afe8-7838c332ab87.png');

-- ----------------------------
-- Table structure for blog_website_msg
-- ----------------------------
DROP TABLE IF EXISTS `blog_website_msg`;
CREATE TABLE `blog_website_msg`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `MsgNickName` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `MsgContent` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `ParentMsgId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of blog_website_msg
-- ----------------------------

-- ----------------------------
-- Table structure for sys_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_dept`;
CREATE TABLE `sys_dept`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `ParentId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CurrentLevelCode` int NOT NULL DEFAULT 100,
  `AncestorsCode` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `AncestorsFullName` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `DeptName` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `SortNO` int NOT NULL,
  `Leader` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `Phone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `Email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `Status` int NOT NULL DEFAULT 1,
  `Level` int NOT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dept
-- ----------------------------
INSERT INTO `sys_dept` VALUES ('08d9bd33-971e-461f-84f8-8b436eebd227', '2021-12-12 13:52:32.597359', '2021-12-12 13:54:57.497154', 0, NULL, 'a89f00d7-57bf-11ec-ad18-0242ac110004', 101, '0.1.101', '总公司', '四川分公司', 2, '', NULL, NULL, 1, 2);
INSERT INTO `sys_dept` VALUES ('08d9bd33-b12f-446a-8dd3-d5eb9a520e28', '2021-12-12 13:53:16.329011', '2021-12-12 13:55:22.477521', 0, NULL, 'a89f00d7-57bf-11ec-ad18-0242ac110004', 102, '0.1.102', '总公司', '重庆分公司', 1, '', NULL, NULL, 1, 2);
INSERT INTO `sys_dept` VALUES ('08d9bd34-0b09-4d0d-82c0-7a790a5b7cbe', '2021-12-12 13:55:47.078627', NULL, 0, NULL, 'a89f00d7-57bf-11ec-ad18-0242ac110004', 103, '0.1.103', '总公司', '广东分公司', 3, '', NULL, NULL, 1, 2);
INSERT INTO `sys_dept` VALUES ('08d9beb0-3559-4632-815c-836aae6a7714', '2021-12-14 11:17:06.880118', NULL, 0, NULL, '08d9bd33-b12f-446a-8dd3-d5eb9a520e28', 101, '0.1.102.101', '总公司.重庆分公司', '重庆分公司1-1', 1, '', NULL, NULL, 1, 3);
INSERT INTO `sys_dept` VALUES ('08d9beb0-3a59-4969-8763-52c1dddb38ae', '2021-12-14 11:17:15.211355', NULL, 0, NULL, '08d9beb0-3559-4632-815c-836aae6a7714', 101, '0.1.102.101.101', '总公司.重庆分公司.重庆分公司1-1', '重庆分公司1-1-1', 1, '', NULL, NULL, 1, 4);
INSERT INTO `sys_dept` VALUES ('08d9beb0-3d23-49d8-821e-f9d327c21285', '2021-12-14 11:17:19.890859', NULL, 0, NULL, '08d9bd33-b12f-446a-8dd3-d5eb9a520e28', 102, '0.1.102.102', '总公司.重庆分公司', '重庆分公司1-2', 1, '', NULL, NULL, 1, 3);
INSERT INTO `sys_dept` VALUES ('08d9bf77-bc10-475a-802a-fbf53b05de36', '2021-12-15 11:05:22.722430', NULL, 0, NULL, '08d9beb0-3d23-49d8-821e-f9d327c21285', 101, '0.1.102.102.101', '总公司.重庆分公司.重庆分公司1-2', '重庆分公司1-2-1', 1, '', NULL, NULL, 1, 4);
INSERT INTO `sys_dept` VALUES ('08d9c2cd-013f-4913-8d4d-3a34a0601234', '2021-12-19 16:53:19.476103', NULL, 0, NULL, 'a89f00d7-57bf-11ec-ad18-0242ac110004', 105, '0.1.105', '总公司', 'test2', 1, '', NULL, NULL, 1, 2);
INSERT INTO `sys_dept` VALUES ('08d9c2cd-8465-4ffd-8025-4631c2b987af', '2021-12-19 16:56:59.523733', NULL, 0, NULL, 'a89f00d7-57bf-11ec-ad18-0242ac110004', 106, '0.1.106', '总公司', 'test3', 1, '', NULL, NULL, 1, 2);
INSERT INTO `sys_dept` VALUES ('08d9c2cd-8fc9-4175-8c9a-d38ec8d42af2', '2021-12-19 16:57:18.619782', NULL, 0, NULL, 'a89f00d7-57bf-11ec-ad18-0242ac110004', 107, '0.1.107', '总公司', 'test4', 1, '', NULL, NULL, 1, 2);
INSERT INTO `sys_dept` VALUES ('a89f00d7-57bf-11ec-ad18-0242ac110004', '2022-02-03 15:50:37.352050', NULL, 0, NULL, '00000000-0000-0000-0000-000000000000', 1, '0.1', '', '总公司', 1, NULL, NULL, NULL, 1, 1);

-- ----------------------------
-- Table structure for sys_login_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_login_log`;
CREATE TABLE `sys_login_log`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `AccountCode` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `Status` int NOT NULL DEFAULT 0,
  `Ipaddr` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `LoginLocation` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `Browser` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL,
  `Os` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL,
  `Msg` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_login_log
-- ----------------------------
INSERT INTO `sys_login_log` VALUES ('08d9c45b-e25d-4349-86f7-20e0203005d1', '2021-12-21 16:28:36.872940', NULL, 0, NULL, 'devin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9c45b-ef94-40fc-8d57-83a660bf26cf', '2021-12-21 16:28:59.026077', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9c45c-5585-4cff-8f80-b558a1ceed60', '2021-12-21 16:31:50.063874', NULL, 0, NULL, 'devin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9c45c-5c2e-4b13-898b-2c2588c43815', '2021-12-21 16:32:01.236920', NULL, 0, NULL, 'devin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '账号或密码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9c461-6ca7-4175-8731-20c934f8b440', '2021-12-21 17:08:16.420907', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9c46d-2d85-47de-808d-b889d5e11698', '2021-12-21 18:32:24.394266', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9c472-e5c9-4b69-894f-f0662b6eab7d', '2021-12-21 19:13:21.096198', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9c474-2bb9-47dc-8ab7-fb981b6b1f6a', '2021-12-21 19:22:27.947248', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9c47a-000c-482e-8920-37305c9fed49', '2021-12-21 20:04:11.609652', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9c47f-a85b-494d-874f-c806fc40da79', '2021-12-21 20:44:41.497127', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9c485-6389-43fd-8b43-f35d10aca365', '2021-12-21 21:25:43.007984', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9c504-7d8a-4ab2-8f45-531db924561c', '2021-12-22 12:35:32.718134', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9c50a-960f-4cef-8a9f-0654209c6d9b', '2021-12-22 13:19:10.838882', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9c511-f28b-475a-844d-7b7bcab9e737', '2021-12-22 14:11:52.477410', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9c518-0310-465f-82d3-f055dfc3d59b', '2021-12-22 14:55:17.175361', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d1cf-9fab-4a98-8186-f306236462f2', '2022-01-07 19:19:51.751351', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d277-759e-4eaa-85c2-9e769b6b0614', '2022-01-08 15:21:16.668091', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d27d-3860-463d-81e1-3d584e8dad8c', '2022-01-08 16:02:30.902201', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d286-9664-47e7-8561-762fd8031626', '2022-01-08 17:09:34.103804', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d3e4-fee0-468c-87af-91c97e45962e', '2022-01-10 10:57:53.276170', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d3fb-82d2-4c60-821b-143dc9e0a2b6', '2022-01-10 13:39:03.571784', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9d3fb-8745-4a40-8c37-43b18b989a41', '2022-01-10 13:39:10.961549', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d401-9e88-4957-8efb-f321e47d183a', '2022-01-10 14:22:47.052061', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d407-9a89-4663-8ef1-dfac98e9a300', '2022-01-10 15:05:37.236876', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d412-4e29-4e42-8e9c-b7f4ccd26bc3', '2022-01-10 16:22:13.635244', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d418-183a-46da-8c04-61ce4ad1f18b', '2022-01-10 17:03:40.058188', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d423-2c07-48d5-8896-f955b8c5c45e', '2022-01-10 18:22:57.738680', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d5a5-f924-4eee-87a3-d5d7d305abc9', '2022-01-12 16:31:47.782720', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9d5a6-00f7-4d46-8fa1-862742e1793e', '2022-01-12 16:32:00.745280', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d5ab-dc2e-4ba4-8f07-3f006326a049', '2022-01-12 17:13:56.031891', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d5bd-8fe5-417b-8566-8766fcca3dbb', '2022-01-12 19:20:39.013906', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d5cb-b9c0-405c-81d6-626f9770a062', '2022-01-12 21:02:02.204714', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9d5cb-c069-4aee-86a0-ed700aa7f67c', '2022-01-12 21:02:13.314618', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d63d-900e-4827-87e9-735d9f997eee', '2022-01-13 10:36:54.861894', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d656-d6e7-4bd1-87ba-84788583ae79', '2022-01-13 13:37:51.148758', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d65e-e003-46a7-86f9-a8c7691ea964', '2022-01-13 14:35:22.414929', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d664-bc5b-4a10-8cf3-a0145a65109e', '2022-01-13 15:17:19.493921', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9d664-c21c-47b6-83fc-5a95461a60c7', '2022-01-13 15:17:29.145862', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d66b-468b-4f7e-8202-908c4d5238c4', '2022-01-13 16:04:08.384165', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d670-e7b8-47f5-8cc1-f68f07272d79', '2022-01-13 16:44:26.286403', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d677-3106-4523-8b7d-a391c8543620', '2022-01-13 17:29:26.172025', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9d677-a56e-45c0-8404-07f0f52a178b', '2022-01-13 17:32:41.467912', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9d677-a8ed-4536-8cd5-77f06bb64daf', '2022-01-13 17:32:47.333033', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d690-2cf8-44cb-80f2-82e645425804', '2022-01-13 20:28:16.891949', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d695-ce17-422b-87b4-8ebb8973695d', '2022-01-13 21:08:34.655090', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d69b-97dd-4254-8db4-f02e75335c6d', '2022-01-13 21:50:00.623920', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d6a3-4eec-4689-89ea-7598203b4ad1', '2022-01-13 22:45:14.191771', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9d6a3-6e72-4d17-8e3a-5e64a551b06f', '2022-01-13 22:46:07.075885', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d6a9-b457-4bfd-8087-3f92714179e6', '2022-01-13 23:31:01.334186', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9d6a9-ea2f-4f77-8345-8c40abe2cfb4', '2022-01-13 23:32:31.666361', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9d6aa-5802-497d-8002-bce961bca5fc', '2022-01-13 23:35:35.980374', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d6b0-ac0f-44aa-8903-6f5ef6cda50f', '2022-01-14 00:20:53.903893', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9d6b0-af85-4534-87da-ef96f0178fe7', '2022-01-14 00:20:59.714721', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d6b0-e544-432c-8a2b-1ffd5f90fe87', '2022-01-14 00:22:29.877242', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d73c-e465-43bc-8916-16bfdeb5de49', '2022-01-14 17:04:37.972090', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d74c-32bc-481f-8770-d3a93fdcd527', '2022-01-14 18:54:11.849675', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d753-1067-4e7b-86b0-164a0286300e', '2022-01-14 19:43:20.811042', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d753-27b2-4964-8441-6ab631fdf937', '2022-01-14 19:43:59.804867', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d758-f5e8-4488-80d2-01e84b62cc48', '2022-01-14 20:25:33.247461', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d7ee-98f6-48dc-8821-1345ed219188', '2022-01-15 14:16:41.920140', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d818-aed3-4314-84b4-29e01f913bb6', '2022-01-15 19:17:57.442841', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9d818-b50e-4539-83d1-532ba46df168', '2022-01-15 19:18:07.833891', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d81e-5b38-4da2-8daa-aa9cf111febf', '2022-01-15 19:58:34.156885', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d824-062d-4e90-8e2f-17adeecd47e8', '2022-01-15 20:39:08.420372', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d82e-33ff-494a-8e0c-30a712460caa', '2022-01-15 21:52:00.262586', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d8bc-284e-4a77-8e7e-3becf1415e3c', '2022-01-16 14:48:09.210544', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d8ce-de30-489a-888a-8179fdd9399a', '2022-01-16 17:02:05.302641', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d8e7-8499-44b5-8890-95c85919c356', '2022-01-16 19:58:32.406225', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d989-7e6c-4047-8cb4-0b33e9861b79', '2022-01-17 15:18:00.512519', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d98f-6f31-4de0-847b-01dca3207ad1', '2022-01-17 16:00:31.892593', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d995-1704-494c-89f3-df0de8a8a48d', '2022-01-17 16:41:00.928713', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d99b-617a-4452-8a7d-92df202a6b52', '2022-01-17 17:26:02.832194', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d9a4-77ef-437f-8054-70519ebcb2ff', '2022-01-17 18:31:05.976455', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9d9b4-5424-447d-8ee4-6ba5755e5076', '2022-01-17 20:24:37.931273', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9da33-5ba7-40bf-8b68-7f96ab185fde', '2022-01-18 11:33:56.627133', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9da53-dd6a-47c4-8af9-09594ec8ee67', '2022-01-18 15:26:38.238323', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9da5b-8586-4b22-898e-129d1d49f136', '2022-01-18 16:21:26.749652', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9da61-6c41-4523-832e-bdffc99f00b6', '2022-01-18 17:03:41.269430', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9da67-b0a0-4ebe-82ef-ffe1507c0905', '2022-01-18 17:48:33.133354', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9da74-8eab-48ed-8bee-b971de94899b', '2022-01-18 19:20:39.543733', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9da7a-7b57-40a1-8dd2-b5a3f70722ed', '2022-01-18 20:03:04.038054', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9da80-2084-4d37-8677-9664fb5a5fd7', '2022-01-18 20:43:28.682815', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9dafb-a057-4c68-86db-ea8d66b58904', '2022-01-19 11:27:31.215753', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9db07-791d-427d-82ab-6f953ba43cc0', '2022-01-19 12:52:19.294283', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9db0d-5889-4df4-8cad-340ae09431f0', '2022-01-19 13:34:21.627252', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9db13-7365-4ccd-8a11-742202eefc17', '2022-01-19 14:18:03.713698', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9db19-465f-4b8b-8705-d6eb2a822ad3', '2022-01-19 14:59:45.182433', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e21d-302b-40a2-8d0e-053cf6ace180', '2022-01-28 13:15:24.055623', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e24d-a1c7-4db9-8d27-e4ebbb85cd71', '2022-01-28 19:02:10.512716', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e3e9-f545-44bf-8f5b-6ea506156f2f', '2022-01-30 20:13:43.237675', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e3ec-33d7-4f53-8c1e-a0d60de8e125', '2022-01-30 20:29:47.270067', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e3f6-9424-4e57-883f-f7020d866dbf', '2022-01-30 21:44:03.754206', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e499-17d7-4cbf-8b5c-eb596f56a937', '2022-01-31 17:07:23.139142', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e499-81ac-44e7-8054-1dd3d2860bb0', '2022-01-31 17:10:20.642598', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '账号或密码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9e499-83da-4bfd-83aa-f6da432a8a3d', '2022-01-31 17:10:24.301868', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9e499-aefa-4732-8778-7cae073158f2', '2022-01-31 17:11:36.663696', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9e499-b17b-4164-8dbc-44ccffb99b16', '2022-01-31 17:11:40.857819', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9e49a-5635-4f95-871f-ce680544f002', '2022-01-31 17:16:17.234660', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9e49a-5bab-494e-8ce0-3d9f64a964d2', '2022-01-31 17:16:26.396756', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e49a-7c95-4f9e-8afa-c8a0e7bb164a', '2022-01-31 17:17:21.618141', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e49a-d408-4882-828e-62af62096a12', '2022-01-31 17:19:48.332914', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e4a2-e37b-402a-80d4-8ec46bfc1307', '2022-01-31 18:17:30.321713', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e4b2-7255-4466-8b61-e6641cc93b5f', '2022-01-31 20:08:52.330513', NULL, 0, NULL, 'admin', 1, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e4b2-9132-4649-8c18-900eabd0ed5b', '2022-01-31 20:09:44.124128', NULL, 0, NULL, 'admin', 1, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e4b2-adbf-4c5d-8ed9-8099236c7f59', '2022-01-31 20:10:32.023564', NULL, 0, NULL, 'admin', 1, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e4b2-b768-4519-8d9b-611c04f751dc', '2022-01-31 20:10:48.230818', NULL, 0, NULL, 'admin', 0, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9e4b5-c2b2-4145-800f-1b1e738d7af6', '2022-01-31 20:32:35.650588', NULL, 0, NULL, 'admin', 1, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e4b5-ffb9-4679-80bb-c577d2ae853a', '2022-01-31 20:34:18.052985', NULL, 0, NULL, 'admin', 1, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e4b6-2780-4daf-88ad-4270605280e9', '2022-01-31 20:35:24.778243', NULL, 0, NULL, 'admin', 1, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e4b6-564f-4b44-8ee1-46abeb014536', '2022-01-31 20:36:43.313453', NULL, 0, NULL, 'admin', 0, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9e4b6-5a7b-4c18-873a-8f94924636b4', '2022-01-31 20:36:50.313458', NULL, 0, NULL, 'admin', 1, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e4b6-d6af-46fc-8c82-60f4f59c34ff', '2022-01-31 20:40:18.694755', NULL, 0, NULL, 'admin', 1, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e4b6-e5b0-4085-80d8-0fb08c6aa49d', '2022-01-31 20:40:43.858475', NULL, 0, NULL, 'admin', 1, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e4b6-fca2-4536-8475-44d290fff36b', '2022-01-31 20:41:22.354484', NULL, 0, NULL, 'admin', 1, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e4b9-85f9-428c-87eb-e1388de1fcab', '2022-01-31 20:59:31.769648', NULL, 0, NULL, 'admin', 1, '192.168.31.221', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e61e-cd31-407e-805c-d13999aa2cf2', '2022-02-02 15:37:01.619981', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e61e-dc9a-410b-853c-e82097df914d', '2022-02-02 15:37:27.422075', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e61f-04a1-40d5-8ac2-18137f218f1d', '2022-02-02 15:38:34.577445', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e61f-450f-49f0-8cf3-7006e70895c3', '2022-02-02 15:40:22.673886', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e6dc-ba3f-4d00-8db3-df1d31fe8130', '2022-02-03 14:16:34.245501', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e6de-2200-41b4-8ed0-0fbdf0b8fa91', '2022-02-03 14:26:37.731741', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e6e9-b520-4f1f-8ccf-f388c9527b18', '2022-02-03 15:49:29.098155', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e72b-4900-4cf4-89b3-e9bfe55defb5', '2022-02-03 23:38:54.493773', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e72b-f77b-441b-845c-5f4f53c62423', '2022-02-03 23:43:47.139276', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e72c-d014-4d1c-8492-a6c2350de7af', '2022-02-03 23:49:50.535214', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9e7d8-36d3-43b1-82f8-5813bc227f92', '2022-02-04 20:16:46.926012', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9ec5d-6d55-4ecf-89fc-97e790c522c2', '2022-02-10 14:20:26.101088', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9ec66-9c76-4a7b-885b-a91a15b3a8c8', '2022-02-10 15:26:10.640906', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9ec67-9742-497e-820f-615712d7a74f', '2022-02-10 15:33:11.327070', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9ec6f-25fe-469c-8c04-963a33ee3d1c', '2022-02-10 16:27:17.277964', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9ec90-3ac3-44c8-8358-ecc608cfdb3c', '2022-02-10 20:24:05.507894', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9edf3-abbd-4578-8845-3a14c3b038a5', '2022-02-12 14:48:26.506675', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9eeab-cf54-4a7b-8f3a-02532971beb9', '2022-02-13 12:46:33.574676', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9eeb1-da6b-4033-8f9b-571e38e517d3', '2022-02-13 13:29:49.080003', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9eeb2-067e-43fc-88c5-611b4828275d', '2022-02-13 13:31:03.027632', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9eeb9-7652-4572-8af3-ba42acd6184f', '2022-02-13 14:24:17.202503', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9eec8-3a2a-4aff-8371-f247140232d4', '2022-02-13 16:09:58.649931', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9eecf-54fc-4e55-8b83-96da7ff47835', '2022-02-13 17:00:50.122773', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9eecf-65ed-46a7-8617-95ff398a4255', '2022-02-13 17:01:18.546058', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9eed6-993a-4ce9-8b4f-86759de94e81', '2022-02-13 17:52:51.169466', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9ef74-769a-4c36-8991-162038eb858c', '2022-02-14 12:42:53.558015', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9ef8f-4397-4b12-867f-1eb618097987', '2022-02-14 15:54:44.394432', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9ef96-7e37-42b6-870d-08e7d6ed551d', '2022-02-14 16:46:29.225212', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f044-061f-4e55-825a-ea4174ada626', '2022-02-15 13:28:40.171483', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f04c-f58e-48d8-8b55-e54448711636', '2022-02-15 14:32:37.768936', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f053-b7e3-4234-8086-fb5455ba2e89', '2022-02-15 15:21:00.779631', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9f054-1737-4566-8286-3936a01e27cb', '2022-02-15 15:23:40.712798', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9f054-3eaa-420c-81c6-08b48ba026f4', '2022-02-15 15:24:46.900200', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f055-e0fc-4131-8c80-00d685dc911d', '2022-02-15 15:36:28.813827', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f150-693e-472f-848f-d894fbd2cc77', '2022-02-16 21:29:51.564987', NULL, 0, NULL, 'admin', 1, '192.243.127.218', 'Zuid-Holland-0', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f151-ba67-4236-840c-6ca1d0f0f33d', '2022-02-16 21:39:17.271344', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f153-3e34-4fd5-8169-6adf3b5259a8', '2022-02-16 21:50:07.788193', NULL, 0, NULL, 'admin', 1, '192.243.127.218', 'Zuid-Holland-0', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f15a-f8b8-40c7-8c25-24cc6dc78bb4', '2022-02-16 22:45:27.242931', NULL, 0, NULL, 'admin', 1, '192.243.127.218', 'Zuid-Holland-0', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f164-a3b7-491c-8017-209d8abbc2fe', '2022-02-16 23:54:39.590761', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f167-2cf1-4ab8-8e9a-17a51cd68c5f', '2022-02-17 00:12:48.827982', NULL, 0, NULL, 'admin', 1, '192.243.127.218', 'Zuid-Holland-0', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f16d-7759-4c5c-82d3-b0ddd36d2342', '2022-02-17 00:57:50.598991', NULL, 0, NULL, 'admin', 1, '192.243.127.218', 'Zuid-Holland-0', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f1c0-398e-463b-8913-69b19377cac9', '2022-02-17 10:50:15.168208', NULL, 0, NULL, 'admin', 1, '192.243.127.218', 'Zuid-Holland-0', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f1c7-7306-4f70-8e48-8308b30768d9', '2022-02-17 11:41:58.026981', NULL, 0, NULL, 'admin', 1, '218.17.199.27', '广东省-深圳市', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f1d7-9a2e-48f5-8483-0111bb16826f', '2022-02-17 13:37:35.664846', NULL, 0, NULL, 'admin', 0, '192.243.127.218', 'Zuid-Holland-0', 'Other', 'Windows 10', '验证码已过期');
INSERT INTO `sys_login_log` VALUES ('08d9f1d9-2d21-4cab-828c-9b16cb8f4866', '2022-02-17 13:48:51.763473', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f1df-08a1-499e-8e9d-43652fdf78bf', '2022-02-17 14:30:47.474192', NULL, 0, NULL, 'admin', 0, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '验证码不正确');
INSERT INTO `sys_login_log` VALUES ('08d9f1df-0bb7-4ebd-84c8-79c7fcbdfdab', '2022-02-17 14:30:52.631728', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f1e6-e32b-4760-840e-3ba24ad3b5bf', '2022-02-17 15:27:00.627048', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');
INSERT INTO `sys_login_log` VALUES ('08d9f1ed-0652-4282-8012-9af2df8d923a', '2022-02-17 16:10:56.584560', NULL, 0, NULL, 'admin', 1, '127.0.0.1', '0-内网IP', 'Other', 'Windows 10', '登录成功');

-- ----------------------------
-- Table structure for sys_module_resource
-- ----------------------------
DROP TABLE IF EXISTS `sys_module_resource`;
CREATE TABLE `sys_module_resource`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `ResourceCode` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `ResourceName` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `ResourceIcon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `Path` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `PathName` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `NoCache` tinyint(1) NOT NULL DEFAULT 0,
  `ResourceType` int NOT NULL,
  `ParentResourceID` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `SortNO` int NOT NULL,
  `Description` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `IsShow` tinyint(1) NOT NULL DEFAULT 0,
  `State` int NOT NULL DEFAULT 1,
  `IsExternalLink` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_module_resource
-- ----------------------------
INSERT INTO `sys_module_resource` VALUES ('08d9b97c-d65d-496b-8cfd-a3c040d33de1', '2021-12-07 20:26:47.366350', NULL, 0, NULL, 'System.MenuFunctional.Read', '查询', 'search', NULL, NULL, 0, 3, 'e3c9c50b-52e1-11ec-887b-0242ac110005', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bb89-5c43-4807-82e5-a42380072993', '2021-12-10 11:01:28.253257', '2021-12-10 11:05:17.236077', 0, NULL, 'System.MenuFunctional.Add', '新增', 'add', NULL, NULL, 0, 3, 'e3c9c50b-52e1-11ec-887b-0242ac110005', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bb89-6a73-4dd7-8c08-a3e6af13bf80', '2021-12-10 11:01:52.053666', '2021-12-10 11:05:24.410982', 0, NULL, 'System.MenuFunctional.Edit', '修改', 'edit', NULL, NULL, 0, 3, 'e3c9c50b-52e1-11ec-887b-0242ac110005', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bb89-76e7-4150-87c0-2159adcc1aca', '2021-12-10 11:02:12.940907', '2021-12-10 11:05:28.892938', 0, NULL, 'System.MenuFunctional.Delete', '删除', 'delete', NULL, NULL, 0, 3, 'e3c9c50b-52e1-11ec-887b-0242ac110005', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bb89-b3e7-48e5-82f3-028d7cd9f4c9', '2021-12-10 11:03:55.285106', '2021-12-12 15:02:59.449870', 0, NULL, 'System.Dept', '机构管理', 'tree', 'system/dept/index', '/system/dept', 0, 2, '7fd11851-4bdb-11ec-9aa7-0242ac110003', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bb89-d806-4128-8020-d9108defc759', '2021-12-10 11:04:55.883311', NULL, 0, NULL, 'System.Dept.Add', '新增', 'add', NULL, NULL, 0, 3, '08d9bb89-b3e7-48e5-82f3-028d7cd9f4c9', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bb8a-07fd-4421-8b06-cb038d69a35e', '2021-12-10 11:06:16.355855', NULL, 0, NULL, 'System.Dept.Edit', '修改', 'edit', NULL, NULL, 0, 3, '08d9bb89-b3e7-48e5-82f3-028d7cd9f4c9', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bb8a-23d4-429c-8cd1-f2a99823c761', '2021-12-10 11:07:03.062586', NULL, 0, NULL, 'System.Dept.Delete', '删除', 'delete', NULL, NULL, 0, 3, '08d9bb89-b3e7-48e5-82f3-028d7cd9f4c9', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bb8a-6e94-4cc8-873c-d6a150336693', '2021-12-10 11:09:08.476479', '2021-12-10 13:35:32.073001', 0, NULL, 'System.Dept.Read', '查询', 'search', NULL, NULL, 0, 3, '08d9bb89-b3e7-48e5-82f3-028d7cd9f4c9', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bc68-1aa1-497b-83e8-b23ba75a8467', '2021-12-11 13:35:55.911341', NULL, 0, NULL, 'System.User.Read', '查询', 'search', NULL, NULL, 0, 3, 'c31dc578-4bda-11ec-9aa7-0242ac110003', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bd3d-d962-435c-8e01-4bf2250caa05', '2021-12-12 15:05:58.744121', NULL, 0, NULL, 'System.Role.Add', '新增', 'add', NULL, NULL, 0, 3, '5ecc9776-4bdb-11ec-9aa7-0242ac110003', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bd3d-e5bc-4068-87e6-33c7dc0a4679', '2021-12-12 15:06:19.460047', NULL, 0, NULL, 'System.Role.Edit', '修改', 'edit', NULL, NULL, 0, 3, '5ecc9776-4bdb-11ec-9aa7-0242ac110003', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bd3d-f780-4026-88c0-fdb0828a2f3c', '2021-12-12 15:06:49.265898', NULL, 0, NULL, 'System.Role.Delete', '删除', 'delete', NULL, NULL, 0, 3, '5ecc9776-4bdb-11ec-9aa7-0242ac110003', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bd3e-7a70-4eb8-8082-3b2530c133d0', '2021-12-12 15:10:28.948478', NULL, 0, NULL, 'System.Role.Read', '查询', 'search', NULL, NULL, 0, 3, '5ecc9776-4bdb-11ec-9aa7-0242ac110003', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bf7a-8e15-4519-837d-3fb6a1978459', '2021-12-15 11:25:34.035247', '2021-12-15 17:10:50.824605', 0, NULL, 'System.Role.AssignPermission', '分配权限', 'role-permission', NULL, NULL, 0, 3, '5ecc9776-4bdb-11ec-9aa7-0242ac110003', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9bf7a-dc5f-42f3-8759-37ecb85a20ad', '2021-12-15 11:27:45.378730', '2021-12-16 11:24:42.595021', 0, NULL, 'System.User.AssignPermission', '额外权限', 'user-permission', NULL, NULL, 0, 3, 'c31dc578-4bda-11ec-9aa7-0242ac110003', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9c06b-02f5-4e55-87f6-211932aacc4d', '2021-12-16 16:06:49.360975', NULL, 0, NULL, 'System.User.ResetPwd', '重置密码', 'reset-pwd', NULL, NULL, 0, 3, 'c31dc578-4bda-11ec-9aa7-0242ac110003', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9c445-dd64-4d4a-834a-d1fd5761465d', '2021-12-21 13:50:59.622181', '2021-12-21 13:51:15.695514', 0, NULL, 'System.LogManage', '日志管理', 'log', NULL, '/system/log-manage', 0, 1, '7fd11851-4bdb-11ec-9aa7-0242ac110003', 5, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9c446-1481-49a9-862b-f8b8990ddc48', '2021-12-21 13:52:32.053245', NULL, 0, NULL, 'System.LoginLog', '登录日志', 'log-login', 'system/log-manage/login-log/index', '/system/log-manage/login-log/index', 0, 2, '08d9c445-dd64-4d4a-834a-d1fd5761465d', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9c451-2c05-43ff-89cf-fc84d6e69b1c', '2021-12-21 15:11:56.094757', '2021-12-21 15:14:52.010862', 0, NULL, 'System.LoginLog.Read', '查询', 'search', NULL, NULL, 0, 3, '08d9c446-1481-49a9-862b-f8b8990ddc48', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9c451-a89f-4092-8dca-fe6caee7d1ae', '2021-12-21 15:15:25.024661', NULL, 0, NULL, 'System.LoginLog.Delete', '删除', 'delete', NULL, NULL, 0, 3, '08d9c446-1481-49a9-862b-f8b8990ddc48', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9c451-ec75-4ac6-827e-c36b6d059c23', '2021-12-21 15:17:18.830303', NULL, 0, NULL, 'System.LoginLog.Clear', '清空', 'clear', NULL, NULL, 0, 3, '08d9c446-1481-49a9-862b-f8b8990ddc48', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9c461-a8db-4220-8c86-06dadcac3b05', '2021-12-21 17:09:57.389994', '2021-12-21 17:16:31.198403', 0, NULL, 'System.SysOperLog', '操作日志', 'log-oper', 'system/log-manage/oper-log/index', '/system/log-manage/oper-log/index', 0, 2, '08d9c445-dd64-4d4a-834a-d1fd5761465d', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9c461-dabb-4f72-83ee-4571a98ac0ce', '2021-12-21 17:11:21.049978', NULL, 0, NULL, 'System.SysOperLog.Read', '查询', 'search', NULL, NULL, 0, 3, '08d9c461-a8db-4220-8c86-06dadcac3b05', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9c461-ffa0-4747-8183-175eb396b7b1', '2021-12-21 17:12:22.938618', NULL, 0, NULL, 'System.SysOperLog.Clear', '清空', 'clear', NULL, NULL, 0, 3, '08d9c461-a8db-4220-8c86-06dadcac3b05', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9c462-0be8-4dda-81fd-567d60bd92ab', '2021-12-21 17:12:43.548628', NULL, 0, NULL, 'System.SysOperLog.Delete', '删除', 'delete', NULL, NULL, 0, 3, '08d9c461-a8db-4220-8c86-06dadcac3b05', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d278-48ca-46aa-8e3a-7b05904a507b', '2022-01-08 15:27:10.935654', NULL, 0, NULL, 'Blog', '博客管理', 'clipboard', NULL, '/blog', 0, 1, '00000000-0000-0000-0000-000000000000', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d278-c8cc-4084-8c07-282aa214a5d4', '2022-01-08 15:30:45.646816', '2022-01-19 14:19:40.530129', 0, NULL, 'Blog.Article', '博文管理', 'excel', 'blog/article/index', '/blog/article/index', 1, 2, '08d9d278-48ca-46aa-8e3a-7b05904a507b', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d404-b018-49c4-8c42-df2377f39761', '2022-01-10 14:44:45.053587', NULL, 0, NULL, 'Blog.Article.Add', '新增', 'add', NULL, NULL, 0, 3, '08d9d278-c8cc-4084-8c07-282aa214a5d4', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d63e-da87-4e48-8d95-31e146a52649', '2022-01-13 10:46:09.400360', NULL, 0, NULL, 'Blog.Article.Edit', '修改', 'edit', NULL, NULL, 0, 3, '08d9d278-c8cc-4084-8c07-282aa214a5d4', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d63e-edaa-4cb9-8cba-6ef80d6df4c5', '2022-01-13 10:46:41.349489', NULL, 0, NULL, 'Blog.Article.Delete', '删除', 'delete', NULL, NULL, 0, 3, '08d9d278-c8cc-4084-8c07-282aa214a5d4', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d63e-feab-4bf5-8a49-226d7957b33a', '2022-01-13 10:47:09.894370', NULL, 0, NULL, 'Blog.Article.Read', '查询', 'search', NULL, NULL, 0, 3, '08d9d278-c8cc-4084-8c07-282aa214a5d4', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d819-097a-44ec-8f8d-ac7854b6750c', '2022-01-15 19:20:29.487642', NULL, 0, NULL, 'Blog.Category', '博文分类', 'tab', 'blog/category/index', '/blog/category/index', 0, 2, '08d9d278-48ca-46aa-8e3a-7b05904a507b', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d819-1fe4-4699-8546-7de83142cd8c', '2022-01-15 19:21:07.059085', '2022-01-15 19:37:57.340889', 0, NULL, 'Blog.Category.Add', '新增', 'add', NULL, NULL, 0, 3, '08d9d819-097a-44ec-8f8d-ac7854b6750c', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d819-2c15-4209-8476-92e202c5c3bf', '2022-01-15 19:21:27.516642', '2022-01-15 20:02:51.181867', 0, NULL, 'Blog.Category.Edit', '修改', 'edit', NULL, NULL, 0, 3, '08d9d819-097a-44ec-8f8d-ac7854b6750c', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d819-391d-4d39-8c6b-d0e89d533187', '2022-01-15 19:21:49.377504', '2022-01-15 19:37:52.994724', 0, NULL, 'Blog.Category.Delete', '删除', 'delete', NULL, NULL, 0, 3, '08d9d819-097a-44ec-8f8d-ac7854b6750c', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d819-456e-45e8-865d-b709c23dfb4b', '2022-01-15 19:22:10.040827', '2022-01-15 19:37:48.023443', 0, NULL, 'Blog.Category.Read', '查询', 'search', NULL, NULL, 0, 3, '08d9d819-097a-44ec-8f8d-ac7854b6750c', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d822-a34c-439c-803f-0ba9c221772c', '2022-01-15 20:29:13.104289', '2022-01-15 20:29:26.066699', 0, NULL, 'Blog.Tag', '博文标签', 'link', 'blog/tag/index', '/blog/tag/index', 0, 2, '08d9d278-48ca-46aa-8e3a-7b05904a507b', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d822-b49a-44e3-8b9b-3f683b27ac28', '2022-01-15 20:29:42.026018', NULL, 0, NULL, 'Blog.Tag.Add', '新增', 'add', NULL, NULL, 0, 3, '08d9d822-a34c-439c-803f-0ba9c221772c', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d822-be9b-453f-850b-a0927a35ad11', '2022-01-15 20:29:58.808835', NULL, 0, NULL, 'Blog.Tag.Edit', '修改', 'edit', NULL, NULL, 0, 3, '08d9d822-a34c-439c-803f-0ba9c221772c', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d822-cd95-44cb-8e73-f70e3368c149', '2022-01-15 20:30:23.944245', NULL, 0, NULL, 'Blog.Tag.Read', '查询', 'search', NULL, NULL, 0, 3, '08d9d822-a34c-439c-803f-0ba9c221772c', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d822-d6d4-4bd2-8b7f-52f5cb0ade41', '2022-01-15 20:30:39.449901', NULL, 0, NULL, 'Blog.Tag.Delete', '删除', 'delete', NULL, NULL, 0, 3, '08d9d822-a34c-439c-803f-0ba9c221772c', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d8bc-67bb-4270-8229-8476a2c61a8d', '2022-01-16 14:49:55.590163', NULL, 0, NULL, 'Blog.Link', '友情链接', 'star', 'blog/link/index', '/blog/link/index', 0, 2, '08d9d278-48ca-46aa-8e3a-7b05904a507b', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d8bc-734f-4647-87ce-828f5e4cb3df', '2022-01-16 14:50:14.995394', NULL, 0, NULL, 'Blog.Link.Add', '新增', 'add', NULL, NULL, 0, 3, '08d9d8bc-67bb-4270-8229-8476a2c61a8d', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d8bc-7e5d-4224-8f12-def73405d646', '2022-01-16 14:50:33.534502', NULL, 0, NULL, 'Blog.Link.Edit', '修改', 'edit', NULL, NULL, 0, 3, '08d9d8bc-67bb-4270-8229-8476a2c61a8d', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d8bc-8fbd-4237-86c7-b2c3a259ec66', '2022-01-16 14:51:02.675229', NULL, 0, NULL, 'Blog.Link.Read', '查询', 'search', NULL, NULL, 0, 3, '08d9d8bc-67bb-4270-8229-8476a2c61a8d', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d8bc-99a8-40f9-8f1e-e651d28bbc98', '2022-01-16 14:51:19.317582', NULL, 0, NULL, 'Blog.Link.Delete', '删除', 'delete', NULL, NULL, 0, 3, '08d9d8bc-67bb-4270-8229-8476a2c61a8d', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d8cf-23b1-4d2b-8526-5e7e1ee68fa6', '2022-01-16 17:04:01.883562', NULL, 0, NULL, 'Blog.Manage', '站点管理', 'international', 'blog/manage/index', '/blog/manage/index', 0, 2, '08d9d278-48ca-46aa-8e3a-7b05904a507b', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d8cf-3419-44ae-831a-1be7ab8a6151', '2022-01-16 17:04:29.376432', NULL, 0, NULL, 'Blog.Manage.Read', '查询', 'search', NULL, NULL, 0, 3, '08d9d8cf-23b1-4d2b-8526-5e7e1ee68fa6', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d8cf-5d29-47d9-8b55-938f20398c89', '2022-01-16 17:05:38.261305', NULL, 0, NULL, 'Blog.Manage.Edit', '编辑', 'edit', NULL, NULL, 0, 3, '08d9d8cf-23b1-4d2b-8526-5e7e1ee68fa6', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d989-d511-4f79-854f-1502e3be6364', '2022-01-17 15:20:25.864455', '2022-01-19 14:30:43.870467', 0, NULL, 'Blog.Comment', '博文评论', 'message', 'blog/comment/index', '/blog/comment/index/:id', 0, 2, '08d9d278-48ca-46aa-8e3a-7b05904a507b', 1, '', 0, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d989-e88a-44e1-8242-885fdd3796cb', '2022-01-17 15:20:58.491275', NULL, 0, NULL, 'Blog.Comment.Add', '新增', 'add', NULL, NULL, 0, 3, '08d9d989-d511-4f79-854f-1502e3be6364', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9d989-f2ed-47eb-8e60-0b3d9fc6954b', '2022-01-17 15:21:15.923356', NULL, 0, NULL, 'Blog.Comment.Delete', '删除', 'delete', NULL, NULL, 0, 3, '08d9d989-d511-4f79-854f-1502e3be6364', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9db14-cdab-4158-8866-4682be33a937', '2022-01-19 14:27:44.615203', '2022-01-19 14:28:47.926335', 0, NULL, 'Blog.Comment.Read', '评论', 'message', NULL, NULL, 0, 3, '08d9d989-d511-4f79-854f-1502e3be6364', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9ec5f-286e-4e76-88e3-d670b6e167d0', '2022-02-10 14:32:49.458075', NULL, 0, NULL, 'Tools', '系统工具', 'tools', NULL, '/tools', 0, 1, '00000000-0000-0000-0000-000000000000', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9ec5f-6ca5-4965-87a7-ae5b7d484b8f', '2022-02-10 14:34:43.859134', '2022-02-10 14:47:25.040156', 0, NULL, 'Tools.Build', '表单构建', 'form-build', 'tools-page/build/index', '/tools-page/build/index', 1, 2, '08d9ec5f-286e-4e76-88e3-d670b6e167d0', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9ec90-a697-4204-8f92-c2f5b88d2047', '2022-02-10 20:27:06.454965', NULL, 0, NULL, 'Tools.Swagger', '系统接口', 'list', 'tools-page/swagger', '/tools-page/swagger', 1, 2, '08d9ec5f-286e-4e76-88e3-d670b6e167d0', 1, '', 1, 1, 1);
INSERT INTO `sys_module_resource` VALUES ('08d9eeac-a0a7-4637-8a48-3b1c1ef40ac7', '2022-02-13 12:52:24.723895', '2022-02-13 12:53:40.530249', 0, NULL, 'Tools.Code', '代码生成', 'code', 'tools-page/code-generator/index', '/tools-page/code-generator/index', 1, 2, '08d9ec5f-286e-4e76-88e3-d670b6e167d0', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9eecf-8916-434e-8a2e-f0e931838d02', '2022-02-13 17:02:17.579993', NULL, 0, NULL, 'Tools.Code.Read', '链接', 'api', NULL, NULL, 0, 3, '08d9eeac-a0a7-4637-8a48-3b1c1ef40ac7', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9eecf-b92c-4336-839c-56a728cd171d', '2022-02-13 17:03:38.212251', NULL, 0, NULL, 'Tools.Code.Build', '生成代码', 'zip', NULL, NULL, 0, 3, '08d9eeac-a0a7-4637-8a48-3b1c1ef40ac7', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9ef8f-5f36-4b7f-808a-5ce5385d15d8', '2022-02-14 15:55:30.692591', '2022-02-14 16:58:31.307222', 0, NULL, 'Monitor', '服务监控', 'monitor', NULL, '/monitor', 0, 1, '00000000-0000-0000-0000-000000000000', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('08d9ef96-c633-4f79-8514-ad2ce54536c9', '2022-02-14 16:48:29.957021', '2022-02-14 16:58:41.092880', 0, NULL, 'Monitor.Server', '服务监控', 'server', 'monitor/server/index', '/monitor/server/index', 1, 2, '08d9ef8f-5f36-4b7f-808a-5ce5385d15d8', 1, '', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('3a6926ca-5385-11ec-887b-0242ac110005', '2021-12-02 22:34:54.000000', '2021-12-11 13:35:09.364922', 0, NULL, 'System.User.Edit', '修改', 'edit', NULL, NULL, 0, 3, 'c31dc578-4bda-11ec-9aa7-0242ac110003', 3, NULL, 1, 1, 1);
INSERT INTO `sys_module_resource` VALUES ('5ecc9776-4bdb-11ec-9aa7-0242ac110003', '2021-11-22 22:34:54.000000', '2021-12-15 12:30:56.678284', 0, NULL, 'System.Role', '角色管理', 'role-manager', 'system/role/index', '/system/role/index', 0, 2, '7fd11851-4bdb-11ec-9aa7-0242ac110003', 4, '测试', 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('61922a4b-5385-11ec-887b-0242ac110005', '2021-12-02 22:34:54.000000', '2021-12-11 13:35:24.470943', 0, NULL, 'System.User.Delete', '删除', 'delete', NULL, NULL, 0, 3, 'c31dc578-4bda-11ec-9aa7-0242ac110003', 3, NULL, 1, 1, 1);
INSERT INTO `sys_module_resource` VALUES ('7fd11851-4bdb-11ec-9aa7-0242ac110003', '2021-11-22 21:36:11.000000', '2021-12-21 14:18:33.279252', 0, NULL, 'System', '系统管理', 'system', '', '/system', 0, 1, '00000000-0000-0000-0000-000000000000', 1, NULL, 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('a6550668-4bf2-11ec-9aa7-0242ac110003', '2021-11-22 22:34:54.000000', '2021-12-11 13:35:29.994898', 0, NULL, 'System.User.Add', '新增', 'add', NULL, NULL, 0, 3, 'c31dc578-4bda-11ec-9aa7-0242ac110003', 3, NULL, 1, 1, 1);
INSERT INTO `sys_module_resource` VALUES ('c31dc578-4bda-11ec-9aa7-0242ac110003', '2021-11-22 22:02:10.000000', '2021-12-15 12:25:14.879691', 0, NULL, 'System.User', '用户管理', 'user-manager', 'system/user/index', '/system/user/index', 0, 2, '7fd11851-4bdb-11ec-9aa7-0242ac110003', 2, NULL, 1, 1, 0);
INSERT INTO `sys_module_resource` VALUES ('e3c9c50b-52e1-11ec-887b-0242ac110005', '2021-12-01 22:02:10.000000', '2022-01-07 19:28:59.838962', 0, NULL, 'System.MenuFunctional', '功能模块', 'component', 'system/menu-functional/index', '/system/menu-functional/index', 1, 2, '7fd11851-4bdb-11ec-9aa7-0242ac110003', 2, NULL, 1, 1, 0);

-- ----------------------------
-- Table structure for sys_oper_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_oper_log`;
CREATE TABLE `sys_oper_log`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `businessType` int NOT NULL,
  `method` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `requestMethod` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `operatorType` int NOT NULL,
  `operName` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `deptName` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL,
  `operUrl` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `operIp` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `operLocation` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL,
  `operParam` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL,
  `jsonResult` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL,
  `status` int NOT NULL,
  `errorMsg` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL,
  `Elapsed` double NOT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_oper_log
-- ----------------------------
INSERT INTO `sys_oper_log` VALUES ('08d9c515-c5be-4808-8fe8-ecb31ffb39e2', '2021-12-22 14:39:15.231786', NULL, 0, NULL, '操作日志', 9, 'OperLog.ClearOperLogAllData()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/System/OperLog/ClearOperLogAllData', '127.0.0.1', '0 内网IP', '', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 10.8587215);
INSERT INTO `sys_oper_log` VALUES ('08d9c516-137d-4e8c-806b-70de051f97c7', '2021-12-22 14:41:25.673474', NULL, 0, NULL, '角色管理', 1, 'Role.AddRole()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/Role/AddRole', '127.0.0.1', '0 内网IP', '{\"roleName\":\"test2\",\"RoleCode\":\"\",\"orderSort\":1,\"description\":\"\",\"status\":1,\"roleCode\":\"tes2\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0001717);
INSERT INTO `sys_oper_log` VALUES ('08d9c516-dc6e-4eb2-8d31-b275aa51c3ad', '2021-12-22 14:47:02.836770', NULL, 0, NULL, '角色管理', 1, 'Role.AddRole()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/Role/AddRole', '127.0.0.1', '0 内网IP', '{\"roleName\":\"test5\",\"RoleCode\":\"\",\"orderSort\":1,\"description\":\"\",\"status\":1,\"roleCode\":\"test4\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 4.133515);
INSERT INTO `sys_oper_log` VALUES ('08d9c518-0e38-452f-8075-d962985b76ee', '2021-12-22 14:55:35.872497', NULL, 0, NULL, '角色管理', 1, 'Role.AddRole()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/Role/AddRole', '127.0.0.1', '0 内网IP', '{\"roleName\":\"test6\",\"RoleCode\":\"\",\"orderSort\":1,\"description\":\"\",\"status\":1,\"roleCode\":\"test\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 6.522124300000001);
INSERT INTO `sys_oper_log` VALUES ('08d9c518-1df9-4156-842b-848531332494', '2021-12-22 14:56:02.255460', NULL, 0, NULL, '角色管理', 3, 'Role.DeleteRole()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/System/Role/DeleteRole', '127.0.0.1', '0 内网IP', '?id=08d9c512-1327-4d52-8b6a-50e169a6a6e4', '{\"Msg\":\"操作的数据项，不存在或已被删除\",\"StatusCode\":-102,\"Success\":false}', 0, '操作的数据项，不存在或已被删除', 0.5310750000000001);
INSERT INTO `sys_oper_log` VALUES ('08d9c518-3613-4ac7-80f0-4bfaea90367b', '2021-12-22 14:56:42.694527', NULL, 0, NULL, '角色管理', 3, 'Role.DeleteRole()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/System/Role/DeleteRole', '127.0.0.1', '0 内网IP', '?id=08d9c512-1327-4d52-8b6a-50e169a6a6e4', '{\"Msg\":\"操作的数据项，不存在或已被删除\",\"StatusCode\":-102,\"Success\":false}', 0, '操作的数据项，不存在或已被删除', 0.37354550000000003);
INSERT INTO `sys_oper_log` VALUES ('08d9c518-4f0b-40bc-885e-31407563fed2', '2021-12-22 14:57:24.582427', NULL, 0, NULL, '角色管理', 3, 'Role.DeleteRole()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/System/Role/DeleteRole', '127.0.0.1', '0 内网IP', '?id=08d9c512-1327-4d52-8b6a-50e169a6a6e4', '{\"Msg\":\"操作的数据项，不存在或已被删除\",\"StatusCode\":-102,\"Success\":false}', 0, '操作的数据项，不存在或已被删除', 0.3445875);
INSERT INTO `sys_oper_log` VALUES ('08d9c518-6f28-4a65-8787-7616e4998a03', '2021-12-22 14:58:18.468223', NULL, 0, NULL, '角色管理', 3, 'Role.DeleteRole()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/System/Role/DeleteRole', '127.0.0.1', '0 内网IP', '?id=08d9c511-f8aa-411a-897e-b863502b4ace', '{\"Msg\":\"操作的数据项，不存在或已被删除\",\"StatusCode\":-102,\"Success\":false}', 0, '操作的数据项，不存在或已被删除', 0.5561408);
INSERT INTO `sys_oper_log` VALUES ('08d9c518-7440-4c24-8dd0-c33e7ae4aa76', '2021-12-22 14:58:27.007675', NULL, 0, NULL, '角色管理', 3, 'Role.DeleteRole()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/System/Role/DeleteRole', '127.0.0.1', '0 内网IP', '?id=08d9c512-2121-4c5c-895b-b2c791ecdfc6', '{\"Msg\":\"操作的数据项，不存在或已被删除\",\"StatusCode\":-102,\"Success\":false}', 0, '操作的数据项，不存在或已被删除', 0.3693008);
INSERT INTO `sys_oper_log` VALUES ('08d9c518-a465-49b8-8362-096c57062710', '2021-12-22 14:59:47.774631', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"00000000-0000-0000-0000-000000000000\",\"resourceType\":1,\"resourceName\":\"test\",\"resourceCode\":\"test\",\"resourceIcon\":\"\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"test\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0005092);
INSERT INTO `sys_oper_log` VALUES ('08d9c518-a6bb-47d3-87a6-bf832c232423', '2021-12-22 14:59:51.696174', NULL, 0, NULL, '模块管理', 3, 'MenuFunctional.DeleteMenuFunctional()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/DeleteMenuFunctional', '127.0.0.1', '0 内网IP', '?id=08d9c518-a443-4b4e-83dd-86b2ff93d8f1', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0007702);
INSERT INTO `sys_oper_log` VALUES ('08d9d1d0-e691-4adb-879b-f4cc8d90bd21', '2022-01-07 19:29:00.195272', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"e3c9c50b-52e1-11ec-887b-0242ac110005\",\"resourceCode\":\"System.MenuFunctional\",\"resourceName\":\"功能模块\",\"resourceIcon\":\"component\",\"path\":\"system/menu-functional/index\",\"pathName\":\"/system/menu-functional/index\",\"noCache\":true,\"resourceType\":2,\"parentResourceID\":\"7fd11851-4bdb-11ec-9aa7-0242ac110003\",\"sortNO\":2,\"description\":null,\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.007453);
INSERT INTO `sys_oper_log` VALUES ('08d9d278-492d-4963-8133-dcdd9a329d60', '2022-01-08 15:27:11.571964', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"00000000-0000-0000-0000-000000000000\",\"resourceType\":1,\"resourceName\":\"博客管理\",\"resourceCode\":\"Blog\",\"resourceIcon\":\"clipboard\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"/blog\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0044147);
INSERT INTO `sys_oper_log` VALUES ('08d9d278-c8e8-47a6-8a3b-73c421ef9ded', '2022-01-08 15:30:45.842792', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"resourceType\":2,\"resourceName\":\"博文管理\",\"resourceIcon\":\"excel\",\"isExternalLink\":false,\"path\":\"blog/article/index\",\"pathName\":\"/blog/article/index\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Article\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0009297);
INSERT INTO `sys_oper_log` VALUES ('08d9d404-b092-4e1b-86d6-5cfe6fdd9c70', '2022-01-10 14:44:45.747818', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d278-c8cc-4084-8c07-282aa214a5d4\",\"resourceType\":3,\"resourceName\":\"新增\",\"resourceCode\":\"Blog.Article.Add\",\"resourceIcon\":\"add\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0034165000000000003);
INSERT INTO `sys_oper_log` VALUES ('08d9d405-ae72-401c-8570-da371c71491f', '2022-01-10 14:51:51.637472', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d278-c8cc-4084-8c07-282aa214a5d4\",\"resourceType\":2,\"resourceName\":\"新增_编辑_详情\",\"resourceCode\":\"Blog.Article.Operate\",\"resourceIcon\":\"\",\"isExternalLink\":false,\"path\":\"blog/article/operate\",\"pathName\":\"/blog/article/operate\",\"sortNO\":1,\"isShow\":false,\"state\":1,\"noCache\":false,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.00017449999999999999);
INSERT INTO `sys_oper_log` VALUES ('08d9d405-cd23-4116-81a0-e7211aabef63', '2022-01-10 14:52:43.140338', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9d405-ae5c-4b5e-816d-84afed6daf65\",\"resourceCode\":\"Blog.Article.Operate\",\"resourceName\":\"操作页面\",\"resourceIcon\":\"\",\"path\":\"blog/article/operate\",\"pathName\":\"/blog/article/operate\",\"noCache\":false,\"resourceType\":2,\"parentResourceID\":\"08d9d278-c8cc-4084-8c07-282aa214a5d4\",\"sortNO\":1,\"description\":\"包含（新增、编辑、详情）功能页\",\"isShow\":false,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0002972);
INSERT INTO `sys_oper_log` VALUES ('08d9d408-a2cb-4de8-8d1d-c0e7a04bc7c2', '2022-01-10 15:13:00.586417', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9d405-ae5c-4b5e-816d-84afed6daf65\",\"resourceCode\":\"Blog.Article.Operate\",\"resourceName\":\"博文操作页\",\"resourceIcon\":\"\",\"path\":\"blog/article/operate\",\"pathName\":\"/blog/article/operate\",\"noCache\":false,\"resourceType\":2,\"parentResourceID\":\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"sortNO\":1,\"description\":\"包含（新增、编辑、详情）功能页\",\"isShow\":false,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0005211);
INSERT INTO `sys_oper_log` VALUES ('08d9d63e-daee-47dc-827f-14ed21e8923b', '2022-01-13 10:46:09.954608', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d278-c8cc-4084-8c07-282aa214a5d4\",\"resourceType\":3,\"resourceName\":\"修改\",\"resourceCode\":\"Blog.Article.Edit\",\"resourceIcon\":\"edit\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0048879);
INSERT INTO `sys_oper_log` VALUES ('08d9d63e-edd8-49f0-8004-d30689128301', '2022-01-13 10:46:41.648482', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d278-c8cc-4084-8c07-282aa214a5d4\",\"resourceType\":3,\"resourceName\":\"删除\",\"resourceIcon\":\"delete\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Article.Delete\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.001248);
INSERT INTO `sys_oper_log` VALUES ('08d9d63e-fee0-4fca-86ae-f677d4fee287', '2022-01-13 10:47:10.221688', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d278-c8cc-4084-8c07-282aa214a5d4\",\"resourceType\":3,\"resourceName\":\"查询\",\"resourceIcon\":\"search\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Article.Read\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0014569000000000001);
INSERT INTO `sys_oper_log` VALUES ('08d9d667-2e7f-4a36-8cc8-885bcfa8a382', '2022-01-13 15:34:50.018717', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9d405-ae5c-4b5e-816d-84afed6daf65\",\"resourceCode\":\"Blog.Article.Add\",\"resourceName\":\"博文操作页\",\"resourceIcon\":\"\",\"path\":\"blog/article/operate\",\"pathName\":\"/blog/article/operate?opt=add\",\"noCache\":false,\"resourceType\":2,\"parentResourceID\":\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"sortNO\":1,\"description\":\"包含（新增、编辑、详情）功能页\",\"isShow\":false,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0026638);
INSERT INTO `sys_oper_log` VALUES ('08d9d667-41dd-419e-856c-70381c29735a', '2022-01-13 15:35:22.472494', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9d405-ae5c-4b5e-816d-84afed6daf65\",\"resourceCode\":\"Blog.Article.Add\",\"resourceName\":\"新增博文\",\"resourceIcon\":\"\",\"path\":\"blog/article/operate\",\"pathName\":\"/blog/article/operate?opt=add\",\"noCache\":false,\"resourceType\":2,\"parentResourceID\":\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"sortNO\":1,\"description\":\"包含（新增、编辑、详情）功能页\",\"isShow\":false,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0002596);
INSERT INTO `sys_oper_log` VALUES ('08d9d670-feb7-4d62-87f7-f59f35b98cd3', '2022-01-13 16:45:04.826497', NULL, 0, NULL, '模块管理', 3, 'MenuFunctional.DeleteMenuFunctional()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/DeleteMenuFunctional', '127.0.0.1', '0 内网IP', '?id=08d9d405-ae5c-4b5e-816d-84afed6daf65', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0053327);
INSERT INTO `sys_oper_log` VALUES ('08d9d819-09a0-42d6-8ecf-d7d43faa701d', '2022-01-15 19:20:29.736210', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"resourceType\":2,\"resourceName\":\"博文分类\",\"resourceCode\":\"Blog.Category\",\"resourceIcon\":\"tab\",\"isExternalLink\":false,\"path\":\"blog/category/index\",\"pathName\":\"/blog/category/index\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.004328299999999999);
INSERT INTO `sys_oper_log` VALUES ('08d9d819-1ff2-4b97-8509-34f16d860efb', '2022-01-15 19:21:07.154251', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d819-097a-44ec-8f8d-ac7854b6750c\",\"resourceType\":3,\"resourceName\":\"新增\",\"resourceIcon\":\"add\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Article.Add\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0007501);
INSERT INTO `sys_oper_log` VALUES ('08d9d819-2c25-4012-8224-4df83dcf57f1', '2022-01-15 19:21:27.613763', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d819-097a-44ec-8f8d-ac7854b6750c\",\"resourceType\":3,\"resourceName\":\"修改\",\"resourceIcon\":\"edit\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Article.Update\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0005878);
INSERT INTO `sys_oper_log` VALUES ('08d9d819-392b-478e-8f90-26b911aaa75c', '2022-01-15 19:21:49.467956', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d819-097a-44ec-8f8d-ac7854b6750c\",\"resourceType\":3,\"resourceName\":\"删除\",\"resourceIcon\":\"delete\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Article.Delete\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0005537);
INSERT INTO `sys_oper_log` VALUES ('08d9d819-4581-4883-82b9-a11fc4cf89f1', '2022-01-15 19:22:10.165701', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d819-097a-44ec-8f8d-ac7854b6750c\",\"resourceType\":3,\"resourceName\":\"查询\",\"resourceIcon\":\"search\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Article.Read\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0005521);
INSERT INTO `sys_oper_log` VALUES ('08d9d81b-748f-4b5a-8d92-dc5b36f2b630', '2022-01-15 19:37:48.103881', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9d819-456e-45e8-865d-b709c23dfb4b\",\"resourceCode\":\"Blog.Category.Read\",\"resourceName\":\"查询\",\"resourceIcon\":\"search\",\"path\":null,\"pathName\":null,\"noCache\":false,\"resourceType\":3,\"parentResourceID\":\"08d9d819-097a-44ec-8f8d-ac7854b6750c\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0001688);
INSERT INTO `sys_oper_log` VALUES ('08d9d81b-7790-4337-835d-d8d98c378e2d', '2022-01-15 19:37:53.138968', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9d819-391d-4d39-8c6b-d0e89d533187\",\"resourceCode\":\"Blog.Category.Delete\",\"resourceName\":\"删除\",\"resourceIcon\":\"delete\",\"path\":null,\"pathName\":null,\"noCache\":false,\"resourceType\":3,\"parentResourceID\":\"08d9d819-097a-44ec-8f8d-ac7854b6750c\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.00021920000000000002);
INSERT INTO `sys_oper_log` VALUES ('08d9d81b-7a21-403b-8f00-31c8cf15b5fe', '2022-01-15 19:37:57.447391', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9d819-1fe4-4699-8546-7de83142cd8c\",\"resourceCode\":\"Blog.Category.Add\",\"resourceName\":\"新增\",\"resourceIcon\":\"add\",\"path\":null,\"pathName\":null,\"noCache\":false,\"resourceType\":3,\"parentResourceID\":\"08d9d819-097a-44ec-8f8d-ac7854b6750c\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0002432);
INSERT INTO `sys_oper_log` VALUES ('08d9d81b-7cf3-4c7b-80a0-6743efbd1f6a', '2022-01-15 19:38:02.182507', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9d819-2c15-4209-8476-92e202c5c3bf\",\"resourceCode\":\"Blog.Category.Update\",\"resourceName\":\"修改\",\"resourceIcon\":\"edit\",\"path\":null,\"pathName\":null,\"noCache\":false,\"resourceType\":3,\"parentResourceID\":\"08d9d819-097a-44ec-8f8d-ac7854b6750c\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.00020050000000000002);
INSERT INTO `sys_oper_log` VALUES ('08d9d81e-f491-490e-8a02-f25e2d4f87c3', '2022-01-15 20:02:51.427566', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9d819-2c15-4209-8476-92e202c5c3bf\",\"resourceCode\":\"Blog.Category.Edit\",\"resourceName\":\"修改\",\"resourceIcon\":\"edit\",\"path\":null,\"pathName\":null,\"noCache\":false,\"resourceType\":3,\"parentResourceID\":\"08d9d819-097a-44ec-8f8d-ac7854b6750c\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0074046);
INSERT INTO `sys_oper_log` VALUES ('08d9d822-a397-4e77-8cfe-6af00fd565ad', '2022-01-15 20:29:13.534412', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"resourceType\":2,\"resourceName\":\"标签\",\"resourceCode\":\"Blog.Tag\",\"resourceIcon\":\"link\",\"isExternalLink\":false,\"path\":\"blog/tag/index\",\"pathName\":\"/blog/tag/index\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.005218899999999999);
INSERT INTO `sys_oper_log` VALUES ('08d9d822-ab25-4187-8a9b-e04705e89ceb', '2022-01-15 20:29:26.156365', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9d822-a34c-439c-803f-0ba9c221772c\",\"resourceCode\":\"Blog.Tag\",\"resourceName\":\"博文标签\",\"resourceIcon\":\"link\",\"path\":\"blog/tag/index\",\"pathName\":\"/blog/tag/index\",\"noCache\":false,\"resourceType\":2,\"parentResourceID\":\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0008592999999999999);
INSERT INTO `sys_oper_log` VALUES ('08d9d822-b4a9-4c52-80d7-dc4077118ff3', '2022-01-15 20:29:42.126704', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d822-a34c-439c-803f-0ba9c221772c\",\"resourceType\":3,\"resourceName\":\"新增\",\"resourceIcon\":\"add\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Tag.Add\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0007769000000000001);
INSERT INTO `sys_oper_log` VALUES ('08d9d822-beab-45c8-8480-7d5cc2f3a114', '2022-01-15 20:29:58.916366', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d822-a34c-439c-803f-0ba9c221772c\",\"resourceType\":3,\"resourceName\":\"修改\",\"resourceIcon\":\"edit\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Tag.Edit\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0008566);
INSERT INTO `sys_oper_log` VALUES ('08d9d822-cda6-405b-8716-2950b4e3a689', '2022-01-15 20:30:24.043474', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d822-a34c-439c-803f-0ba9c221772c\",\"resourceType\":3,\"resourceName\":\"查询\",\"resourceIcon\":\"search\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Tag.Read\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0008094);
INSERT INTO `sys_oper_log` VALUES ('08d9d822-d6e1-4ba6-8866-a6de6c3d2070', '2022-01-15 20:30:39.536337', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d822-a34c-439c-803f-0ba9c221772c\",\"resourceType\":3,\"resourceName\":\"删除\",\"resourceIcon\":\"delete\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Tag.Delete\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0007071);
INSERT INTO `sys_oper_log` VALUES ('08d9d8bc-67d3-4710-8b78-012be94b16b6', '2022-01-16 14:49:55.747398', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"resourceType\":2,\"resourceName\":\"友情链接\",\"resourceCode\":\"Blog.Link\",\"resourceIcon\":\"star\",\"isExternalLink\":false,\"path\":\"blog/link/index\",\"pathName\":\"/blog/link/index\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0035594000000000003);
INSERT INTO `sys_oper_log` VALUES ('08d9d8bc-7368-4b79-803e-f370d70c024e', '2022-01-16 14:50:15.152505', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d8bc-67bb-4270-8229-8476a2c61a8d\",\"resourceType\":3,\"resourceName\":\"新增\",\"resourceIcon\":\"add\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Link.Add\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.001552);
INSERT INTO `sys_oper_log` VALUES ('08d9d8bc-7e78-43fe-817b-6de14602ed56', '2022-01-16 14:50:33.714867', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d8bc-67bb-4270-8229-8476a2c61a8d\",\"resourceType\":3,\"resourceName\":\"修改\",\"resourceIcon\":\"edit\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Link.Edit\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0017005999999999998);
INSERT INTO `sys_oper_log` VALUES ('08d9d8bc-8fcd-41a6-87c2-6c83b54d1538', '2022-01-16 14:51:02.779143', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d8bc-67bb-4270-8229-8476a2c61a8d\",\"resourceType\":3,\"resourceName\":\"查询\",\"resourceIcon\":\"search\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Link.Read\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0005252);
INSERT INTO `sys_oper_log` VALUES ('08d9d8bc-99b6-4739-879e-ccdb8183348b', '2022-01-16 14:51:19.407606', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d8bc-67bb-4270-8229-8476a2c61a8d\",\"resourceType\":3,\"resourceName\":\"删除\",\"resourceIcon\":\"delete\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Link.Delete\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.00046899999999999996);
INSERT INTO `sys_oper_log` VALUES ('08d9d8cf-23eb-4da0-84a0-2ba5f1ef216f', '2022-01-16 17:04:02.257897', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"resourceType\":2,\"resourceName\":\"站点管理\",\"resourceCode\":\"Blog.Manage\",\"resourceIcon\":\"international\",\"isExternalLink\":false,\"path\":\"blog/manage/index\",\"pathName\":\"/blog/manage/index\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.003936);
INSERT INTO `sys_oper_log` VALUES ('08d9d8cf-342f-4962-8f48-600936df27b1', '2022-01-16 17:04:29.520249', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d8cf-23b1-4d2b-8526-5e7e1ee68fa6\",\"resourceType\":3,\"resourceName\":\"查询\",\"resourceIcon\":\"search\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Manage.Read\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.001279);
INSERT INTO `sys_oper_log` VALUES ('08d9d8cf-5d37-4252-8b8a-5822afc17d67', '2022-01-16 17:05:38.348753', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d8cf-23b1-4d2b-8526-5e7e1ee68fa6\",\"resourceType\":3,\"resourceName\":\"编辑\",\"resourceIcon\":\"edit\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Manage.Edit\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0006128);
INSERT INTO `sys_oper_log` VALUES ('08d9d989-d52d-4f2b-8a4c-31006168ad14', '2022-01-17 15:20:26.046127', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"resourceType\":2,\"resourceName\":\"博文评论\",\"resourceCode\":\"Blog.Comment\",\"resourceIcon\":\"message\",\"isExternalLink\":false,\"path\":\"blog/comment/index\",\"pathName\":\"/blog/comment/index\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.005356499999999999);
INSERT INTO `sys_oper_log` VALUES ('08d9d989-e898-48e5-8ec4-e968f68f3436', '2022-01-17 15:20:58.584622', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d989-d511-4f79-854f-1502e3be6364\",\"resourceType\":3,\"resourceName\":\"新增\",\"resourceIcon\":\"add\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Comment.Add\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0008167);
INSERT INTO `sys_oper_log` VALUES ('08d9d989-f2fd-4abc-863b-ec0d8e48bbad', '2022-01-17 15:21:16.026216', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d989-d511-4f79-854f-1502e3be6364\",\"resourceType\":3,\"resourceName\":\"删除\",\"resourceIcon\":\"delete\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Comment.Delete\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0019809000000000003);
INSERT INTO `sys_oper_log` VALUES ('08d9da33-8071-4fa2-8db3-9d70d833d885', '2022-01-18 11:34:58.324751', NULL, 0, NULL, '角色管理', 3, 'Role.DeleteRole()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/System/Role/DeleteRole', '127.0.0.1', '0 内网IP', '?id=08d9bed2-0906-4743-8cb0-534c446e1956', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.005324);
INSERT INTO `sys_oper_log` VALUES ('08d9db13-ad3d-422d-8706-2192144995a5', '2022-01-19 14:19:40.770278', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9d278-c8cc-4084-8c07-282aa214a5d4\",\"resourceCode\":\"Blog.Article\",\"resourceName\":\"博文管理\",\"resourceIcon\":\"excel\",\"path\":\"blog/article/index\",\"pathName\":\"/blog/article/index\",\"noCache\":true,\"resourceType\":2,\"parentResourceID\":\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0063414000000000005);
INSERT INTO `sys_oper_log` VALUES ('08d9db14-cdc0-4775-89db-b25440d8ed49', '2022-01-19 14:27:44.752663', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9d989-d511-4f79-854f-1502e3be6364\",\"resourceType\":3,\"resourceName\":\"查看\",\"resourceIcon\":\"message\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Blog.Comment.Read\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0002115);
INSERT INTO `sys_oper_log` VALUES ('08d9db14-f377-4220-8de1-ebffb63681c1', '2022-01-19 14:28:48.027157', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9db14-cdab-4158-8866-4682be33a937\",\"resourceCode\":\"Blog.Comment.Read\",\"resourceName\":\"评论\",\"resourceIcon\":\"message\",\"path\":null,\"pathName\":null,\"noCache\":false,\"resourceType\":3,\"parentResourceID\":\"08d9d989-d511-4f79-854f-1502e3be6364\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0001772);
INSERT INTO `sys_oper_log` VALUES ('08d9db15-389d-4a90-8534-32ee32d4e02b', '2022-01-19 14:30:44.062398', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9d989-d511-4f79-854f-1502e3be6364\",\"resourceCode\":\"Blog.Comment\",\"resourceName\":\"博文评论\",\"resourceIcon\":\"message\",\"path\":\"blog/comment/index\",\"pathName\":\"/blog/comment/index/:id\",\"noCache\":false,\"resourceType\":2,\"parentResourceID\":\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"sortNO\":1,\"description\":\"\",\"isShow\":false,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0009812);
INSERT INTO `sys_oper_log` VALUES ('08d9e3eb-92fe-4b7c-8222-57d43a9ee0f0', '2022-01-30 20:25:17.367338', NULL, 0, NULL, '角色管理', 3, 'Role.DeleteRole()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/System/Role/DeleteRole', '127.0.0.1', '0 内网IP', '?id=08d9c512-1327-4d52-8b6a-50e169a6a6e4', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.1485582);
INSERT INTO `sys_oper_log` VALUES ('08d9e3ec-424a-4f9b-8cdb-eef0ac7e7acc', '2022-01-30 20:30:11.460535', NULL, 0, NULL, '角色管理', 3, 'Role.DeleteRole()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/System/Role/DeleteRole', '127.0.0.1', '0 内网IP', '?id=08d9c516-1368-4b04-8d6e-7d69acb79690', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0056021000000000005);
INSERT INTO `sys_oper_log` VALUES ('08d9ec5f-28ad-4cfc-8e14-e1bf51711cd6', '2022-02-10 14:32:49.864364', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"00000000-0000-0000-0000-000000000000\",\"resourceType\":1,\"resourceName\":\"系统工具\",\"resourceCode\":\"Tools\",\"resourceIcon\":\"tools\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"/tools\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0033672);
INSERT INTO `sys_oper_log` VALUES ('08d9ec5f-6cd9-482a-8843-02a69f65051d', '2022-02-10 14:34:44.199298', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9ec5f-286e-4e76-88e3-d670b6e167d0\",\"resourceType\":2,\"resourceName\":\"表单构建\",\"resourceIcon\":\"theme\",\"isExternalLink\":false,\"path\":\"tools/build/index\",\"pathName\":\"/tools/build/index\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":true,\"description\":\"\",\"resourceCode\":\"Tools.Build\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0006413);
INSERT INTO `sys_oper_log` VALUES ('08d9ec60-1c81-47d0-83d4-13f1af79635f', '2022-02-10 14:39:38.902328', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9ec5f-6ca5-4965-87a7-ae5b7d484b8f\",\"resourceCode\":\"Tools.Build\",\"resourceName\":\"表单构建\",\"resourceIcon\":\"form-build\",\"path\":\"tools/build/index\",\"pathName\":\"/tools/build/index\",\"noCache\":true,\"resourceType\":2,\"parentResourceID\":\"08d9ec5f-286e-4e76-88e3-d670b6e167d0\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0005671000000000001);
INSERT INTO `sys_oper_log` VALUES ('08d9ec61-3092-458e-8690-85faca7ccb93', '2022-02-10 14:47:22.063443', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9ec5f-6ca5-4965-87a7-ae5b7d484b8f\",\"resourceCode\":\"Tools.Build\",\"resourceName\":\"表单构建\",\"resourceIcon\":\"form-build\",\"path\":\"tools-page/build/index\",\"pathName\":\"/tools-page/build/index\",\"noCache\":true,\"resourceType\":2,\"parentResourceID\":\"08d9ec5f-286e-4e76-88e3-d670b6e167d0\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"网络繁忙，请稍后重试\",\"StatusCode\":500,\"Success\":true}', 0, 'Exceeded timeout of 00:00:10', 98.9768056);
INSERT INTO `sys_oper_log` VALUES ('08d9ec61-3290-4052-86f5-a284315ad0e5', '2022-02-10 14:47:25.403505', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9ec5f-6ca5-4965-87a7-ae5b7d484b8f\",\"resourceCode\":\"Tools.Build\",\"resourceName\":\"表单构建\",\"resourceIcon\":\"form-build\",\"path\":\"tools-page/build/index\",\"pathName\":\"/tools-page/build/index\",\"noCache\":true,\"resourceType\":2,\"parentResourceID\":\"08d9ec5f-286e-4e76-88e3-d670b6e167d0\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0006728);
INSERT INTO `sys_oper_log` VALUES ('08d9ec90-a6d1-4892-8226-88201b1f59e6', '2022-02-10 20:27:06.840503', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9ec5f-286e-4e76-88e3-d670b6e167d0\",\"resourceType\":2,\"resourceName\":\"系统接口\",\"resourceIcon\":\"list\",\"isExternalLink\":true,\"path\":\"tools-page/swagger\",\"pathName\":\"/tools-page/swagger\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":true,\"description\":\"\",\"resourceCode\":\"Tools.Swagger\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0045975);
INSERT INTO `sys_oper_log` VALUES ('08d9eeac-a0e5-4ba3-812f-514086c64008', '2022-02-13 12:52:25.132396', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9ec5f-286e-4e76-88e3-d670b6e167d0\",\"resourceType\":2,\"resourceName\":\"代码生成\",\"resourceCode\":\"Tools.Code\",\"resourceIcon\":\"code\",\"isExternalLink\":false,\"path\":\"tools-page/tools-page/index\",\"pathName\":\"/tools-page/tools-page/index\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":true,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0041638000000000005);
INSERT INTO `sys_oper_log` VALUES ('08d9eeac-ce10-486e-80e8-5c3d02df99db', '2022-02-13 12:53:40.872018', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9eeac-a0a7-4637-8a48-3b1c1ef40ac7\",\"resourceCode\":\"Tools.Code\",\"resourceName\":\"代码生成\",\"resourceIcon\":\"code\",\"path\":\"tools-page/code-generator/index\",\"pathName\":\"/tools-page/code-generator/index\",\"noCache\":true,\"resourceType\":2,\"parentResourceID\":\"08d9ec5f-286e-4e76-88e3-d670b6e167d0\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0005652000000000001);
INSERT INTO `sys_oper_log` VALUES ('08d9eecf-8955-4f8d-86c2-c84a79dba948', '2022-02-13 17:02:17.991381', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9eeac-a0a7-4637-8a48-3b1c1ef40ac7\",\"resourceType\":3,\"resourceName\":\"链接\",\"resourceIcon\":\"api\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Tools.Code.Read\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0054763);
INSERT INTO `sys_oper_log` VALUES ('08d9eecf-b95f-4737-8103-e72455903838', '2022-02-13 17:03:38.544001', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9eeac-a0a7-4637-8a48-3b1c1ef40ac7\",\"resourceType\":3,\"resourceName\":\"生成代码\",\"resourceIcon\":\"zip\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\",\"resourceCode\":\"Tools.Code.Build\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.00024229999999999998);
INSERT INTO `sys_oper_log` VALUES ('08d9ef8f-5f7c-4b51-8472-e9e94bc76456', '2022-02-14 15:55:31.156826', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"00000000-0000-0000-0000-000000000000\",\"resourceType\":1,\"resourceName\":\"服务监控\",\"resourceCode\":\"Monitoring\",\"resourceIcon\":\"drag\",\"isExternalLink\":false,\"path\":\"\",\"pathName\":\"/monitoring\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":false,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.004801199999999999);
INSERT INTO `sys_oper_log` VALUES ('08d9ef8f-890b-4bfb-882e-edbd39033c6e', '2022-02-14 15:56:40.836907', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9ef8f-5f36-4b7f-808a-5ce5385d15d8\",\"resourceCode\":\"Monitor\",\"resourceName\":\"服务监控\",\"resourceIcon\":\"drag\",\"path\":null,\"pathName\":\"/monitor\",\"noCache\":false,\"resourceType\":1,\"parentResourceID\":\"00000000-0000-0000-0000-000000000000\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0007241);
INSERT INTO `sys_oper_log` VALUES ('08d9ef96-c677-4c7e-8352-b8e8a0118b01', '2022-02-14 16:48:30.402364', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"parentResourceID\":\"08d9ef8f-5f36-4b7f-808a-5ce5385d15d8\",\"resourceType\":2,\"resourceName\":\"服务监控\",\"resourceCode\":\"Monitor.Server\",\"resourceIcon\":\"tree\",\"isExternalLink\":false,\"path\":\"monitor/server/index\",\"pathName\":\"/monitor/server/index\",\"sortNO\":1,\"isShow\":true,\"state\":1,\"noCache\":true,\"description\":\"\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0055419);
INSERT INTO `sys_oper_log` VALUES ('08d9ef98-2cdd-4556-8561-4d3cfb711f61', '2022-02-14 16:58:31.652177', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9ef8f-5f36-4b7f-808a-5ce5385d15d8\",\"resourceCode\":\"Monitor\",\"resourceName\":\"服务监控\",\"resourceIcon\":\"monitor\",\"path\":null,\"pathName\":\"/monitor\",\"noCache\":false,\"resourceType\":1,\"parentResourceID\":\"00000000-0000-0000-0000-000000000000\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0002218);
INSERT INTO `sys_oper_log` VALUES ('08d9ef98-32b0-4bbe-8f89-8e61ca420cb1', '2022-02-14 16:58:41.427028', NULL, 0, NULL, '模块管理', 2, 'MenuFunctional.UpdateMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/UpdateMenuFunctional', '127.0.0.1', '0 内网IP', '{\"id\":\"08d9ef96-c633-4f79-8514-ad2ce54536c9\",\"resourceCode\":\"Monitor.Server\",\"resourceName\":\"服务监控\",\"resourceIcon\":\"server\",\"path\":\"monitor/server/index\",\"pathName\":\"/monitor/server/index\",\"noCache\":true,\"resourceType\":2,\"parentResourceID\":\"08d9ef8f-5f36-4b7f-808a-5ce5385d15d8\",\"sortNO\":1,\"description\":\"\",\"isShow\":true,\"isExternalLink\":false,\"state\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0003116);
INSERT INTO `sys_oper_log` VALUES ('08d9f056-089a-4074-8e42-f699e416f06a', '2022-02-15 15:37:35.240319', NULL, 0, NULL, '模块管理', 4, 'MenuFunctional.AssignMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/AssignMenuFunctional', '127.0.0.1', '0 内网IP', '{\"menuFunctionalIds\":[\"08d9ef8f-5f36-4b7f-808a-5ce5385d15d8\",\"08d9ef96-c633-4f79-8514-ad2ce54536c9\"],\"enumOwnerIdentityType\":2,\"ownerId\":\"08d9c512-18fc-44d2-8167-9b02d835a157\"}', '{\"Msg\":\"演示模式不能操作\",\"StatusCode\":-202,\"Success\":false}', 0, '演示模式不能操作', 0.0453894);
INSERT INTO `sys_oper_log` VALUES ('08d9f058-ee33-474e-8d1c-ca4b442d7fc3', '2022-02-15 15:58:19.504858', NULL, 0, NULL, '模块管理', 4, 'MenuFunctional.AssignMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/AssignMenuFunctional', '127.0.0.1', '0 内网IP', '{\"menuFunctionalIds\":[\"08d9ef8f-5f36-4b7f-808a-5ce5385d15d8\",\"08d9ef96-c633-4f79-8514-ad2ce54536c9\"],\"enumOwnerIdentityType\":2,\"ownerId\":\"08d9c512-18fc-44d2-8167-9b02d835a157\"}', '{\"Msg\":\"预览模式，不能操作\",\"StatusCode\":-202,\"Success\":false}', 0, '预览模式，不能操作', 0.4688838);
INSERT INTO `sys_oper_log` VALUES ('08d9f058-f697-4aff-85d3-88f6bb01d6b5', '2022-02-15 15:58:33.471029', NULL, 0, NULL, '模块管理', 4, 'MenuFunctional.AssignMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/AssignMenuFunctional', '127.0.0.1', '0 内网IP', '{\"menuFunctionalIds\":[\"08d9ef8f-5f36-4b7f-808a-5ce5385d15d8\",\"08d9ef96-c633-4f79-8514-ad2ce54536c9\"],\"enumOwnerIdentityType\":2,\"ownerId\":\"08d9c512-18fc-44d2-8167-9b02d835a157\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0208592);
INSERT INTO `sys_oper_log` VALUES ('08d9f15b-5c66-4f2f-8d97-aa0527698295', '2022-02-16 22:48:14.459930', NULL, 0, NULL, '模块管理', 4, 'MenuFunctional.AssignMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/AssignMenuFunctional', '192.243.127.218', 'Zuid-Holland 0', '{\"menuFunctionalIds\":[\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"08d9d8cf-23b1-4d2b-8526-5e7e1ee68fa6\",\"08d9d8cf-3419-44ae-831a-1be7ab8a6151\",\"08d9d8cf-5d29-47d9-8b55-938f20398c89\",\"08d9d819-097a-44ec-8f8d-ac7854b6750c\",\"08d9d819-1fe4-4699-8546-7de83142cd8c\",\"08d9d819-2c15-4209-8476-92e202c5c3bf\",\"08d9d819-391d-4d39-8c6b-d0e89d533187\",\"08d9d819-456e-45e8-865d-b709c23dfb4b\",\"08d9d822-a34c-439c-803f-0ba9c221772c\",\"08d9d822-b49a-44e3-8b9b-3f683b27ac28\",\"08d9d822-be9b-453f-850b-a0927a35ad11\",\"08d9d822-cd95-44cb-8e73-f70e3368c149\",\"08d9d822-d6d4-4bd2-8b7f-52f5cb0ade41\",\"08d9d8bc-67bb-4270-8229-8476a2c61a8d\",\"08d9d8bc-734f-4647-87ce-828f5e4cb3df\",\"08d9d8bc-7e5d-4224-8f12-def73405d646\",\"08d9d8bc-8fbd-4237-86c7-b2c3a259ec66\",\"08d9d8bc-99a8-40f9-8f1e-e651d28bbc98\",\"08d9d989-d511-4f79-854f-1502e3be6364\",\"08d9d989-e88a-44e1-8242-885fdd3796cb\",\"08d9d989-f2ed-47eb-8e60-0b3d9fc6954b\",\"08d9db14-cdab-4158-8866-4682be33a937\",\"08d9d278-c8cc-4084-8c07-282aa214a5d4\",\"08d9d63e-edaa-4cb9-8cba-6ef80d6df4c5\",\"08d9d404-b018-49c4-8c42-df2377f39761\",\"08d9d63e-da87-4e48-8d95-31e146a52649\",\"08d9d63e-feab-4bf5-8a49-226d7957b33a\"],\"enumOwnerIdentityType\":2,\"ownerId\":\"08d9c511-f8aa-411a-897e-b863502b4ace\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0045419);
INSERT INTO `sys_oper_log` VALUES ('08d9f15e-9d55-4760-8a6a-927436a50dc7', '2022-02-16 23:11:31.849171', NULL, 0, NULL, '模块管理', 4, 'MenuFunctional.AssignMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/AssignMenuFunctional', '127.0.0.1', '0 内网IP', '{\"menuFunctionalIds\":[\"08d9ef8f-5f36-4b7f-808a-5ce5385d15d8\",\"08d9ef96-c633-4f79-8514-ad2ce54536c9\",\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"08d9d8cf-23b1-4d2b-8526-5e7e1ee68fa6\",\"08d9d8cf-3419-44ae-831a-1be7ab8a6151\",\"08d9d8cf-5d29-47d9-8b55-938f20398c89\",\"08d9d819-097a-44ec-8f8d-ac7854b6750c\",\"08d9d819-1fe4-4699-8546-7de83142cd8c\",\"08d9d819-2c15-4209-8476-92e202c5c3bf\",\"08d9d819-391d-4d39-8c6b-d0e89d533187\",\"08d9d819-456e-45e8-865d-b709c23dfb4b\",\"08d9d822-a34c-439c-803f-0ba9c221772c\",\"08d9d822-b49a-44e3-8b9b-3f683b27ac28\",\"08d9d822-be9b-453f-850b-a0927a35ad11\",\"08d9d822-cd95-44cb-8e73-f70e3368c149\",\"08d9d822-d6d4-4bd2-8b7f-52f5cb0ade41\",\"08d9d8bc-67bb-4270-8229-8476a2c61a8d\",\"08d9d8bc-734f-4647-87ce-828f5e4cb3df\",\"08d9d8bc-7e5d-4224-8f12-def73405d646\",\"08d9d8bc-8fbd-4237-86c7-b2c3a259ec66\",\"08d9d8bc-99a8-40f9-8f1e-e651d28bbc98\",\"08d9d989-d511-4f79-854f-1502e3be6364\",\"08d9d989-e88a-44e1-8242-885fdd3796cb\",\"08d9d989-f2ed-47eb-8e60-0b3d9fc6954b\",\"08d9db14-cdab-4158-8866-4682be33a937\",\"08d9d278-c8cc-4084-8c07-282aa214a5d4\",\"08d9d63e-edaa-4cb9-8cba-6ef80d6df4c5\",\"08d9d404-b018-49c4-8c42-df2377f39761\",\"08d9d63e-da87-4e48-8d95-31e146a52649\",\"08d9d63e-feab-4bf5-8a49-226d7957b33a\"],\"enumOwnerIdentityType\":2,\"ownerId\":\"08d9c511-f8aa-411a-897e-b863502b4ace\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0005003999999999999);
INSERT INTO `sys_oper_log` VALUES ('08d9f15e-ec05-4111-8804-89055ff823ed', '2022-02-16 23:13:43.865700', NULL, 0, NULL, '模块管理', 4, 'MenuFunctional.AssignMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/AssignMenuFunctional', '192.243.127.218', 'Zuid-Holland 0', '{\"menuFunctionalIds\":[\"08d9ef8f-5f36-4b7f-808a-5ce5385d15d8\",\"08d9ef96-c633-4f79-8514-ad2ce54536c9\",\"7fd11851-4bdb-11ec-9aa7-0242ac110003\",\"08d9bb89-b3e7-48e5-82f3-028d7cd9f4c9\",\"08d9bb89-d806-4128-8020-d9108defc759\",\"08d9bb8a-07fd-4421-8b06-cb038d69a35e\",\"08d9bb8a-23d4-429c-8cd1-f2a99823c761\",\"08d9bb8a-6e94-4cc8-873c-d6a150336693\",\"e3c9c50b-52e1-11ec-887b-0242ac110005\",\"08d9bb89-5c43-4807-82e5-a42380072993\",\"08d9b97c-d65d-496b-8cfd-a3c040d33de1\",\"08d9bb89-6a73-4dd7-8c08-a3e6af13bf80\",\"08d9bb89-76e7-4150-87c0-2159adcc1aca\",\"c31dc578-4bda-11ec-9aa7-0242ac110003\",\"08d9bc68-1aa1-497b-83e8-b23ba75a8467\",\"08d9bf7a-dc5f-42f3-8759-37ecb85a20ad\",\"08d9c06b-02f5-4e55-87f6-211932aacc4d\",\"61922a4b-5385-11ec-887b-0242ac110005\",\"a6550668-4bf2-11ec-9aa7-0242ac110003\",\"3a6926ca-5385-11ec-887b-0242ac110005\",\"5ecc9776-4bdb-11ec-9aa7-0242ac110003\",\"08d9bd3d-d962-435c-8e01-4bf2250caa05\",\"08d9bd3d-e5bc-4068-87e6-33c7dc0a4679\",\"08d9bd3d-f780-4026-88c0-fdb0828a2f3c\",\"08d9bd3e-7a70-4eb8-8082-3b2530c133d0\",\"08d9bf7a-8e15-4519-837d-3fb6a1978459\",\"08d9c445-dd64-4d4a-834a-d1fd5761465d\",\"08d9c446-1481-49a9-862b-f8b8990ddc48\",\"08d9c451-2c05-43ff-89cf-fc84d6e69b1c\",\"08d9c451-a89f-4092-8dca-fe6caee7d1ae\",\"08d9c451-ec75-4ac6-827e-c36b6d059c23\",\"08d9c461-a8db-4220-8c86-06dadcac3b05\",\"08d9c461-dabb-4f72-83ee-4571a98ac0ce\",\"08d9c461-ffa0-4747-8183-175eb396b7b1\",\"08d9c462-0be8-4dda-81fd-567d60bd92ab\",\"08d9d278-48ca-46aa-8e3a-7b05904a507b\",\"08d9d8cf-23b1-4d2b-8526-5e7e1ee68fa6\",\"08d9d8cf-3419-44ae-831a-1be7ab8a6151\",\"08d9d8cf-5d29-47d9-8b55-938f20398c89\",\"08d9d819-097a-44ec-8f8d-ac7854b6750c\",\"08d9d819-1fe4-4699-8546-7de83142cd8c\",\"08d9d819-2c15-4209-8476-92e202c5c3bf\",\"08d9d819-391d-4d39-8c6b-d0e89d533187\",\"08d9d819-456e-45e8-865d-b709c23dfb4b\",\"08d9d822-a34c-439c-803f-0ba9c221772c\",\"08d9d822-b49a-44e3-8b9b-3f683b27ac28\",\"08d9d822-be9b-453f-850b-a0927a35ad11\",\"08d9d822-cd95-44cb-8e73-f70e3368c149\",\"08d9d822-d6d4-4bd2-8b7f-52f5cb0ade41\",\"08d9d8bc-67bb-4270-8229-8476a2c61a8d\",\"08d9d8bc-734f-4647-87ce-828f5e4cb3df\",\"08d9d8bc-7e5d-4224-8f12-def73405d646\",\"08d9d8bc-8fbd-4237-86c7-b2c3a259ec66\",\"08d9d8bc-99a8-40f9-8f1e-e651d28bbc98\",\"08d9d989-d511-4f79-854f-1502e3be6364\",\"08d9d989-e88a-44e1-8242-885fdd3796cb\",\"08d9d989-f2ed-47eb-8e60-0b3d9fc6954b\",\"08d9db14-cdab-4158-8866-4682be33a937\",\"08d9d278-c8cc-4084-8c07-282aa214a5d4\",\"08d9d63e-edaa-4cb9-8cba-6ef80d6df4c5\",\"08d9d404-b018-49c4-8c42-df2377f39761\",\"08d9d63e-da87-4e48-8d95-31e146a52649\",\"08d9d63e-feab-4bf5-8a49-226d7957b33a\"],\"enumOwnerIdentityType\":2,\"ownerId\":\"08d9c511-f8aa-411a-897e-b863502b4ace\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0003359);
INSERT INTO `sys_oper_log` VALUES ('08d9f15e-ffa3-431f-8405-2e82581d69de', '2022-02-16 23:14:16.774404', NULL, 0, NULL, '角色管理', 3, 'Role.DeleteRole()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/System/Role/DeleteRole', '182.132.199.242', '四川 眉山', '?id=08d9c517-0e08-43c0-8007-e213751e4a7e', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0003361);
INSERT INTO `sys_oper_log` VALUES ('08d9f164-b8d4-420f-8b76-e85da94abf0f', '2022-02-16 23:55:14.991855', NULL, 0, NULL, '用户管理', 2, 'User.UpdateUser()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/User/UpdateUser', '127.0.0.1', '0 内网IP', '{\"id\":\"9543be7c-116c-4ef0-99ce-722918813b40\",\"accountCode\":\"devin\",\"userEmail\":\"dwen@outlook.com\",\"userName\":\"devin\",\"nickName\":\"devin\",\"gender\":1,\"phoneNum\":\"\",\"deptId\":\"a89f00d7-57bf-11ec-ad18-0242ac110004\",\"description\":\"\",\"status\":1,\"roleIds\":[\"08d9c511-f8aa-411a-897e-b863502b4ace\"]}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0041887999999999995);
INSERT INTO `sys_oper_log` VALUES ('08d9f16a-f502-4e10-863f-85016eb63fca', '2022-02-17 00:39:52.956018', NULL, 0, NULL, '站点管理', 2, 'WebSiteManage.Update()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/WebSiteManage/Update', '192.243.127.218', 'Zuid-Holland 0', '{\"id\":\"08d9d8d1-f26f-47af-8922-b1e7652aad83\",\"webSitName\":\"devin3\",\"backImage\":\"images/c5f17784-4231-4c1b-afe8-7838c332ab87.png\"}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.019335);
INSERT INTO `sys_oper_log` VALUES ('08d9f170-8818-4642-8bbb-41df4cfea636', '2022-02-17 01:19:47.217414', NULL, 0, NULL, '模块管理', 4, 'MenuFunctional.AssignMenuFunctional()', 'POST', 0, 'admin', NULL, '/api/v1.0/System/MenuFunctional/AssignMenuFunctional', '192.243.127.218', 'Zuid-Holland 0', '{\"menuFunctionalIds\":[\"08d9ef8f-5f36-4b7f-808a-5ce5385d15d8\",\"08d9ef96-c633-4f79-8514-ad2ce54536c9\",\"7fd11851-4bdb-11ec-9aa7-0242ac110003\",\"08d9bb89-b3e7-48e5-82f3-028d7cd9f4c9\",\"08d9bb89-d806-4128-8020-d9108defc759\",\"08d9bb8a-07fd-4421-8b06-cb038d69a35e\",\"08d9bb8a-23d4-429c-8cd1-f2a99823c761\",\"08d9bb8a-6e94-4cc8-873c-d6a150336693\",\"e3c9c50b-52e1-11ec-887b-0242ac110005\",\"08d9bb89-5c43-4807-82e5-a42380072993\",\"08d9b97c-d65d-496b-8cfd-a3c040d33de1\",\"08d9bb89-6a73-4dd7-8c08-a3e6af13bf80\",\"08d9bb89-76e7-4150-87c0-2159adcc1aca\",\"c31dc578-4bda-11ec-9aa7-0242ac110003\",\"08d9bc68-1aa1-497b-83e8-b23ba75a8467\",\"08d9bf7a-dc5f-42f3-8759-37ecb85a20ad\",\"08d9c06b-02f5-4e55-87f6-211932aacc4d\",\"61922a4b-5385-11ec-887b-0242ac110005\",\"a6550668-4bf2-11ec-9aa7-0242ac110003\",\"3a6926ca-5385-11ec-887b-0242ac110005\",\"5ecc9776-4bdb-11ec-9aa7-0242ac110003\",\"08d9bd3d-d962-435c-8e01-4bf2250caa05\",\"08d9bd3d-e5bc-4068-87e6-33c7dc0a4679\",\"08d9bd3d-f780-4026-88c0-fdb0828a2f3c\",\"08d9bd3e-7a70-4eb8-8082-3b2530c133d0\",\"08d9bf7a-8e15-4519-837d-3fb6a1978459\",\"08d9c445-dd64-4d4a-834a-d1fd5761465d\",\"08d9c446-1481-49a9-862b-f8b8990ddc48\",\"08d9c451-2c05-43ff-89cf-fc84d6e69b1c\",\"08d9c451-a89f-4092-8dca-fe6caee7d1ae\",\"08d9c451-ec75-4ac6-827e-c36b6d059c23\",\"08d9c461-a8db-4220-8c86-06dadcac3b05\",\"08d9c461-dabb-4f72-83ee-4571a98ac0ce\",\"08d9c461-ffa0-4747-8183-175eb396b7b1\",\"08d9c462-0be8-4dda-81fd-567d60bd92ab\"],\"enumOwnerIdentityType\":2,\"ownerId\":\"08d9c512-18fc-44d2-8167-9b02d835a157\"}', '{\"Msg\":\"预览模式，不能操作\",\"StatusCode\":-202,\"Success\":false}', 0, '预览模式，不能操作', 0.1300807);
INSERT INTO `sys_oper_log` VALUES ('08d9f1d9-9e85-49ff-8a15-a9a61d061507', '2022-02-17 13:52:01.970731', NULL, 0, NULL, '博文标签', 1, 'Tag.Add()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Tag/Add', '127.0.0.1', '0 内网IP', '{\"isQuickNav\":false,\"tagTitle\":\"C#\",\"sortNO\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0840962);
INSERT INTO `sys_oper_log` VALUES ('08d9f1d9-a17e-437e-8286-ae040db1460c', '2022-02-17 13:52:06.930977', NULL, 0, NULL, '博文标签', 3, 'Tag.Delete()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/Blog/Tag/Delete', '127.0.0.1', '0 内网IP', '?id=08d9d824-4820-4c90-858a-c9b21bbd0e28', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0007552);
INSERT INTO `sys_oper_log` VALUES ('08d9f1da-7beb-4ad5-804a-b8cb11b531fe', '2022-02-17 13:58:13.391029', NULL, 0, NULL, '博文管理', 1, 'Article.AddArticle()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Article/AddArticle', '127.0.0.1', '0 内网IP', '{\"id\":\"9ef1de35-9da8-48f9-8f02-7565bb381b8e\",\"articleTitle\":\"C# 将人民币大写金额转换为数字金额\",\"introduction\":\"使用C#把生活中人民币中文大写转换成阿拉伯数字\",\"articleContent\":\"``` c#\\n    /// <summary>\\n    /// 将人民币大写金额转换为数字金额\\n    /// </summary>\\n    public class RMBConversion\\n    {\\n        /// <summary>\\n        /// 把大写中文转换为数字金额\\n        /// </summary>\\n        /// <param name=\\\"rmbStr\\\"></param>\\n        /// <returns></returns>\\n        public static decimal ToLowerCase(string rmbStr)\\n        {\\n            Dictionary<string, decimal> dict1 = new Dictionary<string, decimal>()\\n            {\\n                { \\\"壹\\\", 1 },\\n                { \\\"贰\\\", 2 },\\n                { \\\"叁\\\", 3 },\\n                { \\\"肆\\\", 4 },\\n                { \\\"伍\\\", 5 },\\n                { \\\"陆\\\", 6 },\\n                { \\\"柒\\\", 7 },\\n                { \\\"捌\\\", 8 },\\n                { \\\"玖\\\", 9 },\\n            };\\n            Dictionary<string, decimal> dict2 = new Dictionary<string, decimal>()\\n            {\\n                { \\\"拾\\\", 10 },\\n                { \\\"佰\\\", 100 },\\n                { \\\"仟\\\", 1000 },\\n                { \\\"万\\\", 10000 },\\n                { \\\"元\\\", 1 },\\n                { \\\"角\\\", 0.1M },\\n                { \\\"分\\\", 0.01M },\\n            };\\n            decimal result = 0M;\\n            int rmbLength = rmbStr.Length;\\n            for (int i = 0; i < rmbStr.Length; i++)\\n            {\\n                var nowStr = rmbStr[i].ToString();\\n                var nowStrNext = i < rmbStr.Length - 1 ? rmbStr[i + 1].ToString() : \\\"\\\";\\n                if ((dict1.ContainsKey(nowStr) && dict2.ContainsKey(nowStrNext)) || (dict2.ContainsKey(nowStr) && nowStrNext == \\\"万\\\"))\\n                {\\n                    if (nowStrNext != \\\"万\\\")\\n                    {\\n                        result += dict1[nowStr] * dict2[nowStrNext];\\n                    }\\n                    else if (dict2.ContainsKey(nowStr))\\n                    {\\n                        result *= 1000;\\n                    }\\n                    else\\n                    {\\n                        result += dict1[nowStr];\\n                        result *= 10000;\\n                    }\\n                }\\n                else if (nowStr == \\\"拾\\\" && nowStrNext == \\\"元\\\" && (rmbStr[0].ToString() + rmbStr[1].ToString()) == \\\"拾元\\\")\\n                {\\n                    result = 10;\\n                }\\n            }\\n            return result;\\n        }\\n\\n        /// <summary>\\n        /// 判断金额是否是大写\\n        /// </summary>\\n        /// <param name=\\\"strCase\\\"></param>\\n        /// <returns></returns>\\n        public static bool IsContainCase(string strCase)\\n        {\\n            if (string.IsNullOrEmpty(strCase))\\n            {\\n                return false;\\n            }\\n            var arr = new List<string>() { \\\"壹\\\", \\\"贰\\\", \\\"叁\\\", \\\"肆\\\", \\\"伍\\\", \\\"陆\\\", \\\"柒\\\", \\\"捌\\\", \\\"玖\\\", \\\"零\\\", \\\"拾\\\", \\\"佰\\\", \\\"仟\\\", \\\"万\\\", \\\"亿\\\", \\\"圆\\\", \\\"整\\\", \\\"元\\\", \\\"正\\\" };\\n\\n            return arr.Contains(strCase[0].ToString());\\n        }\\n    }\\n```\",\"categoryId\":\"14f9df92-721e-11ec-b79b-0242ac110003\",\"tagIds\":[\"08d9f1d9-9e2d-41a6-869c-78aab3285816\"],\"articleStatus\":1,\"top\":0,\"auth\":1,\"isDisableComment\":true,\"viewNum\":3,\"likeNum\":1,\"coverImage\":[{\"name\":\"金额转换.png\",\"id\":\"08d9f1d9-f5dd-45eb-8b8a-3db99e0de2ab\",\"businessId\":\"9ef1de35-9da8-48f9-8f02-7565bb381b8e\",\"url\":\"http://101.42.135.254:9000/storage/images/7b622207-ecff-45da-a72b-33fa30438c25.png\",\"uid\":1645077268748,\"status\":\"success\"}]}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0006659000000000001);
INSERT INTO `sys_oper_log` VALUES ('08d9f1db-c0bc-47a4-880f-6c5dd3f004e8', '2022-02-17 14:07:18.341306', NULL, 0, NULL, '博文管理', 3, 'Article.DeleteArticle()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/Blog/Article/DeleteArticle', '127.0.0.1', '0 内网IP', '?id=7b25ce40-809a-4f13-902b-05d79f9d4be0', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0007029);
INSERT INTO `sys_oper_log` VALUES ('08d9f1db-c344-44bb-8ad3-34c848aa9235', '2022-02-17 14:07:22.586873', NULL, 0, NULL, '博文管理', 3, 'Article.DeleteArticle()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/Blog/Article/DeleteArticle', '127.0.0.1', '0 内网IP', '?id=edf11af8-974a-494d-b1d7-0e7e97c8f063', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0008064);
INSERT INTO `sys_oper_log` VALUES ('08d9f1dc-09bf-451d-8396-300987ccbe7a', '2022-02-17 14:09:20.833731', NULL, 0, NULL, '博文管理', 2, 'Article.UpdateArticle()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Article/UpdateArticle', '127.0.0.1', '0 内网IP', '{\"id\":\"9ef1de35-9da8-48f9-8f02-7565bb381b8e\",\"userName\":\"00000000-0000-0000-0000-000000000000\",\"articleTitle\":\"C# 将人民币大写金额转换为数字金额\",\"introduction\":\"使用C#把生活中人民币中文大写转换成阿拉伯数字\",\"articleContent\":\"``` c#\\n    /// <summary>\\n    /// 将人民币大写金额转换为数字金额\\n    /// </summary>\\n    public class RMBConversion\\n    {\\n        /// <summary>\\n        /// 把大写中文转换为数字金额\\n        /// </summary>\\n        /// <param name=\\\"rmbStr\\\"></param>\\n        /// <returns></returns>\\n        public static decimal ToLowerCase(string rmbStr)\\n        {\\n            Dictionary<string, decimal> dict1 = new Dictionary<string, decimal>()\\n            {\\n                { \\\"壹\\\", 1 },\\n                { \\\"贰\\\", 2 },\\n                { \\\"叁\\\", 3 },\\n                { \\\"肆\\\", 4 },\\n                { \\\"伍\\\", 5 },\\n                { \\\"陆\\\", 6 },\\n                { \\\"柒\\\", 7 },\\n                { \\\"捌\\\", 8 },\\n                { \\\"玖\\\", 9 },\\n            };\\n            Dictionary<string, decimal> dict2 = new Dictionary<string, decimal>()\\n            {\\n                { \\\"拾\\\", 10 },\\n                { \\\"佰\\\", 100 },\\n                { \\\"仟\\\", 1000 },\\n                { \\\"万\\\", 10000 },\\n                { \\\"元\\\", 1 },\\n                { \\\"角\\\", 0.1M },\\n                { \\\"分\\\", 0.01M },\\n            };\\n            decimal result = 0M;\\n            int rmbLength = rmbStr.Length;\\n            for (int i = 0; i < rmbStr.Length; i++)\\n            {\\n                var nowStr = rmbStr[i].ToString();\\n                var nowStrNext = i < rmbStr.Length - 1 ? rmbStr[i + 1].ToString() : \\\"\\\";\\n                if ((dict1.ContainsKey(nowStr) && dict2.ContainsKey(nowStrNext)) || (dict2.ContainsKey(nowStr) && nowStrNext == \\\"万\\\"))\\n                {\\n                    if (nowStrNext != \\\"万\\\")\\n                    {\\n                        result += dict1[nowStr] * dict2[nowStrNext];\\n                    }\\n                    else if (dict2.ContainsKey(nowStr))\\n                    {\\n                        result *= 1000;\\n                    }\\n                    else\\n                    {\\n                        result += dict1[nowStr];\\n                        result *= 10000;\\n                    }\\n                }\\n                else if (nowStr == \\\"拾\\\" && nowStrNext == \\\"元\\\" && (rmbStr[0].ToString() + rmbStr[1].ToString()) == \\\"拾元\\\")\\n                {\\n                    result = 10;\\n                }\\n            }\\n            return result;\\n        }\\n\\n        /// <summary>\\n        /// 判断金额是否是大写\\n        /// </summary>\\n        /// <param name=\\\"strCase\\\"></param>\\n        /// <returns></returns>\\n        public static bool IsContainCase(string strCase)\\n        {\\n            if (string.IsNullOrEmpty(strCase))\\n            {\\n                return false;\\n            }\\n            var arr = new List<string>() { \\\"壹\\\", \\\"贰\\\", \\\"叁\\\", \\\"肆\\\", \\\"伍\\\", \\\"陆\\\", \\\"柒\\\", \\\"捌\\\", \\\"玖\\\", \\\"零\\\", \\\"拾\\\", \\\"佰\\\", \\\"仟\\\", \\\"万\\\", \\\"亿\\\", \\\"圆\\\", \\\"整\\\", \\\"元\\\", \\\"正\\\" };\\n\\n            return arr.Contains(strCase[0].ToString());\\n        }\\n    }\\n```\",\"articleStatus\":1,\"categoryId\":\"14f9df92-721e-11ec-b79b-0242ac110003\",\"top\":0,\"viewNum\":3,\"likeNum\":1,\"commentNum\":0,\"auth\":0,\"isDisableComment\":true,\"coverImage\":[{\"name\":\"金额转换.png\",\"id\":\"08d9f1d9-f5dd-45eb-8b8a-3db99e0de2ab\",\"businessId\":\"9ef1de35-9da8-48f9-8f02-7565bb381b8e\",\"url\":\"http://101.42.135.254:9000/storage/images/7b622207-ecff-45da-a72b-33fa30438c25.png\",\"uid\":1645078154705,\"status\":\"success\"}],\"tagIds\":[\"08d9f1d9-9e2d-41a6-869c-78aab3285816\"]}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0006313);
INSERT INTO `sys_oper_log` VALUES ('08d9f1de-2fca-44c8-85b3-7db47879dc20', '2022-02-17 14:24:43.686450', NULL, 0, NULL, '博文管理', 2, 'Article.UpdateArticle()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Article/UpdateArticle', '127.0.0.1', '0 内网IP', '{\"id\":\"9ef1de35-9da8-48f9-8f02-7565bb381b8e\",\"userName\":\"00000000-0000-0000-0000-000000000000\",\"articleTitle\":\"C# 将人民币大写金额转换为数字金额\",\"introduction\":\"使用C#把生活中人民币中文大写转换成阿拉伯数字\",\"articleContent\":\"``` c#\\n    /// <summary>\\n    /// 将人民币大写金额转换为数字金额\\n    /// </summary>\\n    public class RMBConversion\\n    {\\n        /// <summary>\\n        /// 把大写中文转换为数字金额\\n        /// </summary>\\n        /// <param name=\\\"rmbStr\\\"></param>\\n        /// <returns></returns>\\n        public static decimal ToLowerCase(string rmbStr)\\n        {\\n            Dictionary<string, decimal> dict1 = new Dictionary<string, decimal>()\\n            {\\n                { \\\"壹\\\", 1 },\\n                { \\\"贰\\\", 2 },\\n                { \\\"叁\\\", 3 },\\n                { \\\"肆\\\", 4 },\\n                { \\\"伍\\\", 5 },\\n                { \\\"陆\\\", 6 },\\n                { \\\"柒\\\", 7 },\\n                { \\\"捌\\\", 8 },\\n                { \\\"玖\\\", 9 },\\n            };\\n            Dictionary<string, decimal> dict2 = new Dictionary<string, decimal>()\\n            {\\n                { \\\"拾\\\", 10 },\\n                { \\\"佰\\\", 100 },\\n                { \\\"仟\\\", 1000 },\\n                { \\\"万\\\", 10000 },\\n                { \\\"元\\\", 1 },\\n                { \\\"角\\\", 0.1M },\\n                { \\\"分\\\", 0.01M },\\n            };\\n            decimal result = 0M;\\n            int rmbLength = rmbStr.Length;\\n            for (int i = 0; i < rmbStr.Length; i++)\\n            {\\n                var nowStr = rmbStr[i].ToString();\\n                var nowStrNext = i < rmbStr.Length - 1 ? rmbStr[i + 1].ToString() : \\\"\\\";\\n                if ((dict1.ContainsKey(nowStr) && dict2.ContainsKey(nowStrNext)) || (dict2.ContainsKey(nowStr) && nowStrNext == \\\"万\\\"))\\n                {\\n                    if (nowStrNext != \\\"万\\\")\\n                    {\\n                        result += dict1[nowStr] * dict2[nowStrNext];\\n                    }\\n                    else if (dict2.ContainsKey(nowStr))\\n                    {\\n                        result *= 1000;\\n                    }\\n                    else\\n                    {\\n                        result += dict1[nowStr];\\n                        result *= 10000;\\n                    }\\n                }\\n                else if (nowStr == \\\"拾\\\" && nowStrNext == \\\"元\\\" && (rmbStr[0].ToString() + rmbStr[1].ToString()) == \\\"拾元\\\")\\n                {\\n                    result = 10;\\n                }\\n            }\\n            return result;\\n        }\\n\\n        /// <summary>\\n        /// 判断金额是否是大写\\n        /// </summary>\\n        /// <param name=\\\"strCase\\\"></param>\\n        /// <returns></returns>\\n        public static bool IsContainCase(string strCase)\\n        {\\n            if (string.IsNullOrEmpty(strCase))\\n            {\\n                return false;\\n            }\\n            var arr = new List<string>() { \\\"壹\\\", \\\"贰\\\", \\\"叁\\\", \\\"肆\\\", \\\"伍\\\", \\\"陆\\\", \\\"柒\\\", \\\"捌\\\", \\\"玖\\\", \\\"零\\\", \\\"拾\\\", \\\"佰\\\", \\\"仟\\\", \\\"万\\\", \\\"亿\\\", \\\"圆\\\", \\\"整\\\", \\\"元\\\", \\\"正\\\" };\\n\\n            return arr.Contains(strCase[0].ToString());\\n        }\\n    }\\n```\",\"articleStatus\":1,\"categoryId\":\"14f9df92-721e-11ec-b79b-0242ac110003\",\"top\":0,\"viewNum\":3,\"likeNum\":1,\"commentNum\":0,\"auth\":0,\"isDisableComment\":true,\"coverImage\":[{\"name\":\"images.png\",\"id\":\"08d9f1de-2dd0-4fbb-8b1c-ee4bd810d87e\",\"businessId\":\"9ef1de35-9da8-48f9-8f02-7565bb381b8e\",\"url\":\"http://101.42.135.254:9000/storage/images/0b5a6955-83a6-40c9-a811-34446bb52299.png\",\"uid\":1645079080628,\"status\":\"success\"}],\"tagIds\":[\"08d9f1d9-9e2d-41a6-869c-78aab3285816\"]}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.056321399999999994);
INSERT INTO `sys_oper_log` VALUES ('08d9f1df-255c-4603-8491-517337a5004a', '2022-02-17 14:31:35.651199', NULL, 0, NULL, '博文管理', 2, 'Article.UpdateArticle()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Article/UpdateArticle', '127.0.0.1', '0 内网IP', '{\"id\":\"9ef1de35-9da8-48f9-8f02-7565bb381b8e\",\"userName\":\"00000000-0000-0000-0000-000000000000\",\"articleTitle\":\"C# 将人民币大写金额转换为数字金额\",\"introduction\":\"使用C#把生活中人民币中文大写转换成阿拉伯数字\",\"articleContent\":\"``` c#\\n    /// <summary>\\n    /// 将人民币大写金额转换为数字金额\\n    /// </summary>\\n    public class RMBConversion\\n    {\\n        /// <summary>\\n        /// 把大写中文转换为数字金额\\n        /// </summary>\\n        /// <param name=\\\"rmbStr\\\"></param>\\n        /// <returns></returns>\\n        public static decimal ToLowerCase(string rmbStr)\\n        {\\n            Dictionary<string, decimal> dict1 = new Dictionary<string, decimal>()\\n            {\\n                { \\\"壹\\\", 1 },\\n                { \\\"贰\\\", 2 },\\n                { \\\"叁\\\", 3 },\\n                { \\\"肆\\\", 4 },\\n                { \\\"伍\\\", 5 },\\n                { \\\"陆\\\", 6 },\\n                { \\\"柒\\\", 7 },\\n                { \\\"捌\\\", 8 },\\n                { \\\"玖\\\", 9 },\\n            };\\n            Dictionary<string, decimal> dict2 = new Dictionary<string, decimal>()\\n            {\\n                { \\\"拾\\\", 10 },\\n                { \\\"佰\\\", 100 },\\n                { \\\"仟\\\", 1000 },\\n                { \\\"万\\\", 10000 },\\n                { \\\"元\\\", 1 },\\n                { \\\"角\\\", 0.1M },\\n                { \\\"分\\\", 0.01M },\\n            };\\n            decimal result = 0M;\\n            int rmbLength = rmbStr.Length;\\n            for (int i = 0; i < rmbStr.Length; i++)\\n            {\\n                var nowStr = rmbStr[i].ToString();\\n                var nowStrNext = i < rmbStr.Length - 1 ? rmbStr[i + 1].ToString() : \\\"\\\";\\n                if ((dict1.ContainsKey(nowStr) && dict2.ContainsKey(nowStrNext)) || (dict2.ContainsKey(nowStr) && nowStrNext == \\\"万\\\"))\\n                {\\n                    if (nowStrNext != \\\"万\\\")\\n                    {\\n                        result += dict1[nowStr] * dict2[nowStrNext];\\n                    }\\n                    else if (dict2.ContainsKey(nowStr))\\n                    {\\n                        result *= 1000;\\n                    }\\n                    else\\n                    {\\n                        result += dict1[nowStr];\\n                        result *= 10000;\\n                    }\\n                }\\n                else if (nowStr == \\\"拾\\\" && nowStrNext == \\\"元\\\" && (rmbStr[0].ToString() + rmbStr[1].ToString()) == \\\"拾元\\\")\\n                {\\n                    result = 10;\\n                }\\n            }\\n            return result;\\n        }\\n\\n        /// <summary>\\n        /// 判断金额是否是大写\\n        /// </summary>\\n        /// <param name=\\\"strCase\\\"></param>\\n        /// <returns></returns>\\n        public static bool IsContainCase(string strCase)\\n        {\\n            if (string.IsNullOrEmpty(strCase))\\n            {\\n                return false;\\n            }\\n            var arr = new List<string>() { \\\"壹\\\", \\\"贰\\\", \\\"叁\\\", \\\"肆\\\", \\\"伍\\\", \\\"陆\\\", \\\"柒\\\", \\\"捌\\\", \\\"玖\\\", \\\"零\\\", \\\"拾\\\", \\\"佰\\\", \\\"仟\\\", \\\"万\\\", \\\"亿\\\", \\\"圆\\\", \\\"整\\\", \\\"元\\\", \\\"正\\\" };\\n\\n            return arr.Contains(strCase[0].ToString());\\n        }\\n    }\\n```\",\"articleStatus\":1,\"categoryId\":\"14f9df92-721e-11ec-b79b-0242ac110003\",\"top\":0,\"viewNum\":3,\"likeNum\":1,\"commentNum\":0,\"auth\":0,\"isDisableComment\":true,\"coverImage\":[{\"name\":\"photo-1523726491678-bf852e717f6a.png\",\"id\":\"08d9f1df-23a6-483e-8540-c8c32488af8e\",\"businessId\":\"9ef1de35-9da8-48f9-8f02-7565bb381b8e\",\"url\":\"http://101.42.135.254:9000/storage/images/df06b200-7db1-483f-bb5c-5d66b0ee5999.png\",\"uid\":1645079493082,\"status\":\"success\"}],\"tagIds\":[\"08d9f1d9-9e2d-41a6-869c-78aab3285816\"]}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0005708);
INSERT INTO `sys_oper_log` VALUES ('08d9f1df-2f11-4a54-8d4c-786572399161', '2022-02-17 14:31:51.938816', NULL, 0, NULL, '博文管理', 3, 'Article.DeleteArticle()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/Blog/Article/DeleteArticle', '127.0.0.1', '0 内网IP', '?id=451f478c-d517-4b2a-a63f-68e188befa72', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0004682);
INSERT INTO `sys_oper_log` VALUES ('08d9f1e0-87c3-4f9c-87f0-9bb293f0b4df', '2022-02-17 14:41:30.243669', NULL, 0, NULL, '博文管理', 1, 'Article.AddArticle()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Article/AddArticle', '127.0.0.1', '0 内网IP', '{\"id\":\"f0361b89-e5fb-4d73-b65e-00843c7ee361\",\"articleTitle\":\"ASP.NET HTML转PDF\",\"introduction\":\"通过Url地址或者html内容生成到PDF文件，并部署到IIS，转换内容不支持Webpack构建的前端项目\",\"articleContent\":\"## 包引用\\n==这里使用的是TuesPechkin，引用下面2个Nuget包==\\n\\n![239849528e264adc9bbc3aa3.png](http://101.42.135.254:9000/storage/images/e4394e0e-6a2b-4fd9-b1ed-a1c8d35243fb.png)\\n## 封装简单工具类\\n\\n``` c#\\n    /// <summary>\\n    /// html转pdf帮助类\\n    /// </summary>\\n    public static class HtmlToPdfHelper\\n    {\\n        private static readonly string _fileDir = \\\"htmlToPdf\\\";\\n        private static readonly string _savePath = System.Web.Hosting.HostingEnvironment.MapPath(\\\"/\\\" + _fileDir);\\n        private static IConverter _converter = null; //官方要求在程序生命周期内，只能实例化一次\\n        private static string _domainUrl;\\n\\n        /// <summary>\\n        /// 获取当前站点域名\\n        /// </summary>\\n        /// <returns></returns>\\n        public static string DomainUrl\\n        {\\n            get\\n            {\\n                Uri uri = HttpContext.Current.Request.Url;\\n                _domainUrl = uri.Scheme + \\\"://\\\" + uri.Host;\\n                if (!uri.IsDefaultPort)\\n                {\\n                    _domainUrl += \\\":\\\" + uri.Port;\\n                }\\n                return _domainUrl;\\n            }\\n        }\\n\\n        static HtmlToPdfHelper()\\n        {\\n            _converter =\\n                new ThreadSafeConverter(\\n                    new RemotingToolset<PdfToolset>(\\n                        new WinAnyCPUEmbeddedDeployment(\\n                            new TempFolderDeployment())));\\n\\n            //_converter.Begin += ConverterOnBegin;\\n            //_converter.PhaseChange += ConverterOnPhaseChange;\\n            //_converter.ProgressChange += ConverterOnProgressChange;\\n            //_converter.Finish += ConverterOnFinish;\\n            _converter.Warning += new EventHandler<WarningEventArgs>((o, w) =>\\n            {\\n                Console.WriteLine(\\\"HtmlToPdfHelper类，html转换PDF，产生警告信息：\\\" + w.WarningMessage);\\n            });\\n            _converter.Error += new EventHandler<TuesPechkin.ErrorEventArgs>((o, e) =>\\n            {\\n                Console.WriteLine(\\\"HtmlToPdfHelper类，html转换PDF，产生错误信息：\\\" + e.ErrorMessage);\\n            });\\n        }\\n\\n        /// <summary>\\n        /// 转换为pdf字节\\n        /// </summary>\\n        /// <param name=\\\"doc\\\"></param>\\n        /// <returns></returns>\\n        private static byte[] Filing(IDocument doc)\\n        {\\n            byte[] result = _converter.Convert(doc);\\n            return result;\\n        }\\n\\n        /// <summary>\\n        /// 构建PDF服务器访问地址\\n        /// </summary>\\n        /// <param name=\\\"pdfName\\\"></param>\\n        /// <returns></returns>\\n        private static string BuildUrl(string pdfName)\\n        {\\n            return $@\\\"{DomainUrl}/{_fileDir}/{pdfName}.pdf\\\";\\n        }\\n\\n        /// <summary>\\n        /// 构建PDF保存路径\\n        /// </summary>\\n        /// <param name=\\\"pdfName\\\"></param>\\n        /// <returns></returns>\\n        private static string BuildSaveSrc(string pdfName)\\n        {\\n            return $@\\\"{_savePath}\\\\{pdfName}.pdf\\\";\\n        }\\n\\n        /// <summary>\\n        /// 查找已转换的PDF文件\\n        /// </summary>\\n        /// <param name=\\\"pdfName\\\">已保存PDF名称</param>\\n        /// <returns>返回保存Url地址</returns>\\n        private static string FindSaveHtmlPdf(string pdfName)\\n        {\\n            //把文件读进文件流 \\n            var fileSrc = BuildSaveSrc(pdfName);\\n            if (!File.Exists(fileSrc))\\n            {\\n                return string.Empty;\\n            }\\n            return BuildUrl(pdfName);\\n        }\\n\\n        /// <summary>\\n        /// 保存已转换的PDF文件\\n        /// </summary>\\n        /// <param name=\\\"fileName\\\">PDF文件名</param>\\n        /// <param name=\\\"bf\\\">保存字节集</param>\\n        /// <returns>保存成功返回url</returns>\\n        private static string SaveHtmlToPdfFile(string fileName, byte[] bf)\\n        {\\n            var path = _savePath;\\n            if (!Directory.Exists(path))\\n            {\\n                Directory.CreateDirectory(path);\\n            }\\n            System.IO.File.WriteAllBytes(BuildSaveSrc(fileName), bf);\\n            return BuildUrl(fileName);\\n        }\\n\\n        /// <summary>\\n        /// 根据类型转换PDF为字节\\n        /// </summary>\\n        /// <param name=\\\"document\\\">保存文档</param>\\n        /// <param name=\\\"type\\\">保存的类型</param>\\n        /// <returns></returns>\\n        private static byte[] BuildDocumentByType(string document, EHtmlToPdfDocumentType type)\\n        {\\n            byte[] saveBuffer = null;\\n            if (type == EHtmlToPdfDocumentType.HtmlUrl)\\n            {\\n                saveBuffer = ConvertHtmlUrlToPDF(document);\\n            }\\n            else if (type == EHtmlToPdfDocumentType.HtmlText)\\n            {\\n                saveBuffer = ConvertHtmlTextToPDF(document);\\n            }\\n            return saveBuffer;\\n        }\\n\\n        /// <summary>\\n        /// 转换htmltext为PDF\\n        /// </summary>\\n        /// <param name=\\\"htmlText\\\">html文档内容</param>\\n        /// <returns></returns>\\n        public static byte[] ConvertHtmlTextToPDF(string htmlText)\\n        {\\n            if (string.IsNullOrWhiteSpace(htmlText))\\n            {\\n                new ArgumentNullException(\\\"htmlText\\\", \\\"html的内容不能为空\\\");\\n            }\\n\\n            var document = new HtmlToPdfDocument\\n            {\\n                GlobalSettings = { },\\n                Objects = {\\n                new ObjectSettings {\\n                        HtmlText = htmlText,\\n                        WebSettings =new WebSettings\\n                        {\\n                            DefaultEncoding=\\\"UTF-8\\\",\\n                            LoadImages=true,\\n                        }\\n                    }\\n                },\\n\\n            };\\n            var result = _converter.Convert(document);\\n            return result;\\n        }\\n\\n        /// <summary>\\n        /// 转换htmlUrl为PDF\\n        /// </summary>\\n        /// <param name=\\\"htmlText\\\">html文档内容</param>\\n        /// <returns></returns>\\n        public static byte[] ConvertHtmlUrlToPDF(string htmlUrl)\\n        {\\n            if (string.IsNullOrWhiteSpace(htmlUrl))\\n            {\\n                new ArgumentNullException(\\\"htmlUrl\\\", \\\"html的Url地址不能为空\\\");\\n            }\\n\\n            var doc = new HtmlToPdfDocument();\\n            doc.Objects.Add(new ObjectSettings { PageUrl = htmlUrl });\\n\\n            byte[] result = Filing(doc);\\n            return result;\\n        }\\n\\n        /// <summary>\\n        /// 获取Html转换后的PDF文件Url（如果文件不存在，并先执行保存，在返回url地址）\\n        /// </summary>\\n        /// <param name=\\\"pdfName\\\">要保存PDF名称</param>\\n        /// <param name=\\\"document\\\">要保存的Hmtl文档内容，（例如，htmlTXT，htmlurl）</param>\\n        /// <param name=\\\"type\\\">保存的type类型</param>\\n        /// <param name=\\\"IsCover\\\">是否覆盖（默认不覆盖）</param>\\n        /// <returns></returns>\\n        public static string GetHtmlToPdfSaveUrl(string pdfName, string document, EHtmlToPdfDocumentType type, bool IsCover = false)\\n        {\\n            string pdfSaveUrl = FindSaveHtmlPdf(pdfName);\\n            if (string.IsNullOrEmpty(pdfSaveUrl) || IsCover)\\n            {\\n                //获取转换成功后PDF字节\\n                byte[] saveBuffer = BuildDocumentByType(document, type);\\n                //返回保存成功后PDF文件url\\n                return SaveHtmlToPdfFile(pdfName, saveBuffer);\\n            }\\n            return pdfSaveUrl;\\n        }\\n\\n        /// <summary>\\n        /// 下载Html转换后的PDF文件字节流（如果文件不存在，并先执行保存，在返回下载字节流）\\n        /// </summary>\\n        /// <param name=\\\"pdfName\\\">要保存PDF名称</param>\\n        /// <param name=\\\"document\\\">要保存的Hmtl文档内容，（例如，htmlTXT，htmlurl）</param>\\n        /// <param name=\\\"type\\\">保存的type类型</param>\\n        /// <param name=\\\"IsCover\\\">是否覆盖（默认不覆盖）</param>\\n        /// <returns></returns>\\n        public static byte[] DownloadHtmlToPdf(string pdfName, string document, EHtmlToPdfDocumentType type, bool IsCover = false)\\n        {\\n            byte[] saveBuffer = DownloadSaveHtmlToPdf(pdfName);\\n            if (saveBuffer == null || IsCover)\\n            {\\n                //获取转换成功后PDF字节\\n                saveBuffer = BuildDocumentByType(document, type);\\n                //保存PDF文件\\n                SaveHtmlToPdfFile(pdfName, saveBuffer);\\n                return saveBuffer;\\n            }\\n            return saveBuffer;\\n        }\\n\\n        /// <summary>\\n        /// 获取已存在服务器上的PDF文件字节\\n        /// </summary>\\n        /// <param name=\\\"pdfName\\\">文件名称</param>\\n        /// <returns></returns>\\n        public static byte[] DownloadSaveHtmlToPdf(string pdfName)\\n        {\\n            //把文件读进文件流 \\n            var fileSrc = BuildSaveSrc(pdfName);\\n            if (!File.Exists(fileSrc))\\n            {\\n                return null;\\n            }\\n            FileStream fs = new FileStream(fileSrc, FileMode.Open);\\n            byte[] file = new byte[fs.Length];\\n            fs.Read(file, 0, file.Length);\\n            fs.Close();\\n            return file;\\n        }\\n    }\\n\\n    /// <summary>\\n    /// 文档转换类型\\n    /// </summary>\\n    public enum EHtmlToPdfDocumentType\\n    {\\n        HtmlUrl = 0,\\n        HtmlText = 1,\\n    }\\n```\\n\\n## 测试代码\\n``` c#\\n public string GetHtmlToPdf(string pdfName, string url)\\n  {\\n\\n            if (string.IsNullOrWhiteSpace(url))\\n            {\\n                string[] arrs = new string[] { \\\"http://www.baidu.com\\\", \\\"https://news.qq.com/\\\", \\\"https://www.sogou.com/\\\" };\\n                var index = new Random().Next(0, arrs.Length);\\n                url = arrs[index];\\n            }\\n            if (string.IsNullOrWhiteSpace(pdfName))\\n            {\\n                pdfName = DateTime.Now.ToString(\\\"yyyyMMdd_HHmmss\\\");\\n            }\\n\\n            var res = HtmlToPdfHelper.GetHtmlToPdfSaveUrl(pdfName, url, EHtmlToPdfDocumentType.HtmlUrl);\\n            return res;\\n}\\n```\\n\\n## 测试调用\\n![23984952da5bd7c329bcc937.png](http://101.42.135.254:9000/storage/images/f3fbf84f-8d78-4ffb-b7cf-82b3bb28c7ef.png)\\n\\n![239849526ccc3c525cf54ac9.png](http://101.42.135.254:9000/storage/images/ac8fc5c6-2cfe-4f15-b2d0-398a622679ae.png)\",\"categoryId\":\"14f9df92-721e-11ec-b79b-0242ac110003\",\"tagIds\":[\"08d9f1d9-9e2d-41a6-869c-78aab3285816\",\"cd1c05d6-7099-11ec-ae8d-0242ac110002\"],\"articleStatus\":1,\"top\":0,\"auth\":0,\"isDisableComment\":true,\"viewNum\":8,\"likeNum\":1,\"coverImage\":[{\"name\":\"istockphoto-483902160-170667a.jpg\",\"id\":\"08d9f1e0-7ea7-4593-8f81-45f06953cc1f\",\"businessId\":\"f0361b89-e5fb-4d73-b65e-00843c7ee361\",\"url\":\"http://101.42.135.254:9000/storage/images/750c07b2-071e-4857-a6e0-cada87be221a.jpg\",\"uid\":1645080075247,\"status\":\"success\"}]}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0003608);
INSERT INTO `sys_oper_log` VALUES ('08d9f1e1-ff0e-43d4-86a9-695d9a6547a7', '2022-02-17 14:51:59.901939', NULL, 0, NULL, '博文管理', 2, 'Article.UpdateArticle()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Article/UpdateArticle', '127.0.0.1', '0 内网IP', '{\"id\":\"f0361b89-e5fb-4d73-b65e-00843c7ee361\",\"userName\":\"00000000-0000-0000-0000-000000000000\",\"articleTitle\":\"ASP.NET HTML转PDF\",\"introduction\":\"通过Url地址或者html内容生成到PDF文件，并部署到IIS，转换内容不支持Webpack构建的前端项目\",\"articleContent\":\"## 包引用\\n==这里使用的是TuesPechkin，引用下面2个Nuget包==\\n\\n![239849528e264adc9bbc3aa3.png](https://resource.yousu.xyz/storage/images/e4394e0e-6a2b-4fd9-b1ed-a1c8d35243fb.png)\\n## 封装简单工具类\\n\\n``` c#\\n    /// <summary>\\n    /// html转pdf帮助类\\n    /// </summary>\\n    public static class HtmlToPdfHelper\\n    {\\n        private static readonly string _fileDir = \\\"htmlToPdf\\\";\\n        private static readonly string _savePath = System.Web.Hosting.HostingEnvironment.MapPath(\\\"/\\\" + _fileDir);\\n        private static IConverter _converter = null; //官方要求在程序生命周期内，只能实例化一次\\n        private static string _domainUrl;\\n\\n        /// <summary>\\n        /// 获取当前站点域名\\n        /// </summary>\\n        /// <returns></returns>\\n        public static string DomainUrl\\n        {\\n            get\\n            {\\n                Uri uri = HttpContext.Current.Request.Url;\\n                _domainUrl = uri.Scheme + \\\"://\\\" + uri.Host;\\n                if (!uri.IsDefaultPort)\\n                {\\n                    _domainUrl += \\\":\\\" + uri.Port;\\n                }\\n                return _domainUrl;\\n            }\\n        }\\n\\n        static HtmlToPdfHelper()\\n        {\\n            _converter =\\n                new ThreadSafeConverter(\\n                    new RemotingToolset<PdfToolset>(\\n                        new WinAnyCPUEmbeddedDeployment(\\n                            new TempFolderDeployment())));\\n\\n            //_converter.Begin += ConverterOnBegin;\\n            //_converter.PhaseChange += ConverterOnPhaseChange;\\n            //_converter.ProgressChange += ConverterOnProgressChange;\\n            //_converter.Finish += ConverterOnFinish;\\n            _converter.Warning += new EventHandler<WarningEventArgs>((o, w) =>\\n            {\\n                Console.WriteLine(\\\"HtmlToPdfHelper类，html转换PDF，产生警告信息：\\\" + w.WarningMessage);\\n            });\\n            _converter.Error += new EventHandler<TuesPechkin.ErrorEventArgs>((o, e) =>\\n            {\\n                Console.WriteLine(\\\"HtmlToPdfHelper类，html转换PDF，产生错误信息：\\\" + e.ErrorMessage);\\n            });\\n        }\\n\\n        /// <summary>\\n        /// 转换为pdf字节\\n        /// </summary>\\n        /// <param name=\\\"doc\\\"></param>\\n        /// <returns></returns>\\n        private static byte[] Filing(IDocument doc)\\n        {\\n            byte[] result = _converter.Convert(doc);\\n            return result;\\n        }\\n\\n        /// <summary>\\n        /// 构建PDF服务器访问地址\\n        /// </summary>\\n        /// <param name=\\\"pdfName\\\"></param>\\n        /// <returns></returns>\\n        private static string BuildUrl(string pdfName)\\n        {\\n            return $@\\\"{DomainUrl}/{_fileDir}/{pdfName}.pdf\\\";\\n        }\\n\\n        /// <summary>\\n        /// 构建PDF保存路径\\n        /// </summary>\\n        /// <param name=\\\"pdfName\\\"></param>\\n        /// <returns></returns>\\n        private static string BuildSaveSrc(string pdfName)\\n        {\\n            return $@\\\"{_savePath}\\\\{pdfName}.pdf\\\";\\n        }\\n\\n        /// <summary>\\n        /// 查找已转换的PDF文件\\n        /// </summary>\\n        /// <param name=\\\"pdfName\\\">已保存PDF名称</param>\\n        /// <returns>返回保存Url地址</returns>\\n        private static string FindSaveHtmlPdf(string pdfName)\\n        {\\n            //把文件读进文件流 \\n            var fileSrc = BuildSaveSrc(pdfName);\\n            if (!File.Exists(fileSrc))\\n            {\\n                return string.Empty;\\n            }\\n            return BuildUrl(pdfName);\\n        }\\n\\n        /// <summary>\\n        /// 保存已转换的PDF文件\\n        /// </summary>\\n        /// <param name=\\\"fileName\\\">PDF文件名</param>\\n        /// <param name=\\\"bf\\\">保存字节集</param>\\n        /// <returns>保存成功返回url</returns>\\n        private static string SaveHtmlToPdfFile(string fileName, byte[] bf)\\n        {\\n            var path = _savePath;\\n            if (!Directory.Exists(path))\\n            {\\n                Directory.CreateDirectory(path);\\n            }\\n            System.IO.File.WriteAllBytes(BuildSaveSrc(fileName), bf);\\n            return BuildUrl(fileName);\\n        }\\n\\n        /// <summary>\\n        /// 根据类型转换PDF为字节\\n        /// </summary>\\n        /// <param name=\\\"document\\\">保存文档</param>\\n        /// <param name=\\\"type\\\">保存的类型</param>\\n        /// <returns></returns>\\n        private static byte[] BuildDocumentByType(string document, EHtmlToPdfDocumentType type)\\n        {\\n            byte[] saveBuffer = null;\\n            if (type == EHtmlToPdfDocumentType.HtmlUrl)\\n            {\\n                saveBuffer = ConvertHtmlUrlToPDF(document);\\n            }\\n            else if (type == EHtmlToPdfDocumentType.HtmlText)\\n            {\\n                saveBuffer = ConvertHtmlTextToPDF(document);\\n            }\\n            return saveBuffer;\\n        }\\n\\n        /// <summary>\\n        /// 转换htmltext为PDF\\n        /// </summary>\\n        /// <param name=\\\"htmlText\\\">html文档内容</param>\\n        /// <returns></returns>\\n        public static byte[] ConvertHtmlTextToPDF(string htmlText)\\n        {\\n            if (string.IsNullOrWhiteSpace(htmlText))\\n            {\\n                new ArgumentNullException(\\\"htmlText\\\", \\\"html的内容不能为空\\\");\\n            }\\n\\n            var document = new HtmlToPdfDocument\\n            {\\n                GlobalSettings = { },\\n                Objects = {\\n                new ObjectSettings {\\n                        HtmlText = htmlText,\\n                        WebSettings =new WebSettings\\n                        {\\n                            DefaultEncoding=\\\"UTF-8\\\",\\n                            LoadImages=true,\\n                        }\\n                    }\\n                },\\n\\n            };\\n            var result = _converter.Convert(document);\\n            return result;\\n        }\\n\\n        /// <summary>\\n        /// 转换htmlUrl为PDF\\n        /// </summary>\\n        /// <param name=\\\"htmlText\\\">html文档内容</param>\\n        /// <returns></returns>\\n        public static byte[] ConvertHtmlUrlToPDF(string htmlUrl)\\n        {\\n            if (string.IsNullOrWhiteSpace(htmlUrl))\\n            {\\n                new ArgumentNullException(\\\"htmlUrl\\\", \\\"html的Url地址不能为空\\\");\\n            }\\n\\n            var doc = new HtmlToPdfDocument();\\n            doc.Objects.Add(new ObjectSettings { PageUrl = htmlUrl });\\n\\n            byte[] result = Filing(doc);\\n            return result;\\n        }\\n\\n        /// <summary>\\n        /// 获取Html转换后的PDF文件Url（如果文件不存在，并先执行保存，在返回url地址）\\n        /// </summary>\\n        /// <param name=\\\"pdfName\\\">要保存PDF名称</param>\\n        /// <param name=\\\"document\\\">要保存的Hmtl文档内容，（例如，htmlTXT，htmlurl）</param>\\n        /// <param name=\\\"type\\\">保存的type类型</param>\\n        /// <param name=\\\"IsCover\\\">是否覆盖（默认不覆盖）</param>\\n        /// <returns></returns>\\n        public static string GetHtmlToPdfSaveUrl(string pdfName, string document, EHtmlToPdfDocumentType type, bool IsCover = false)\\n        {\\n            string pdfSaveUrl = FindSaveHtmlPdf(pdfName);\\n            if (string.IsNullOrEmpty(pdfSaveUrl) || IsCover)\\n            {\\n                //获取转换成功后PDF字节\\n                byte[] saveBuffer = BuildDocumentByType(document, type);\\n                //返回保存成功后PDF文件url\\n                return SaveHtmlToPdfFile(pdfName, saveBuffer);\\n            }\\n            return pdfSaveUrl;\\n        }\\n\\n        /// <summary>\\n        /// 下载Html转换后的PDF文件字节流（如果文件不存在，并先执行保存，在返回下载字节流）\\n        /// </summary>\\n        /// <param name=\\\"pdfName\\\">要保存PDF名称</param>\\n        /// <param name=\\\"document\\\">要保存的Hmtl文档内容，（例如，htmlTXT，htmlurl）</param>\\n        /// <param name=\\\"type\\\">保存的type类型</param>\\n        /// <param name=\\\"IsCover\\\">是否覆盖（默认不覆盖）</param>\\n        /// <returns></returns>\\n        public static byte[] DownloadHtmlToPdf(string pdfName, string document, EHtmlToPdfDocumentType type, bool IsCover = false)\\n        {\\n            byte[] saveBuffer = DownloadSaveHtmlToPdf(pdfName);\\n            if (saveBuffer == null || IsCover)\\n            {\\n                //获取转换成功后PDF字节\\n                saveBuffer = BuildDocumentByType(document, type);\\n                //保存PDF文件\\n                SaveHtmlToPdfFile(pdfName, saveBuffer);\\n                return saveBuffer;\\n            }\\n            return saveBuffer;\\n        }\\n\\n        /// <summary>\\n        /// 获取已存在服务器上的PDF文件字节\\n        /// </summary>\\n        /// <param name=\\\"pdfName\\\">文件名称</param>\\n        /// <returns></returns>\\n        public static byte[] DownloadSaveHtmlToPdf(string pdfName)\\n        {\\n            //把文件读进文件流 \\n            var fileSrc = BuildSaveSrc(pdfName);\\n            if (!File.Exists(fileSrc))\\n            {\\n                return null;\\n            }\\n            FileStream fs = new FileStream(fileSrc, FileMode.Open);\\n            byte[] file = new byte[fs.Length];\\n            fs.Read(file, 0, file.Length);\\n            fs.Close();\\n            return file;\\n        }\\n    }\\n\\n    /// <summary>\\n    /// 文档转换类型\\n    /// </summary>\\n    public enum EHtmlToPdfDocumentType\\n    {\\n        HtmlUrl = 0,\\n        HtmlText = 1,\\n    }\\n```\\n\\n## 测试代码\\n``` c#\\n public string GetHtmlToPdf(string pdfName, string url)\\n  {\\n\\n            if (string.IsNullOrWhiteSpace(url))\\n            {\\n                string[] arrs = new string[] { \\\"http://www.baidu.com\\\", \\\"https://news.qq.com/\\\", \\\"https://www.sogou.com/\\\" };\\n                var index = new Random().Next(0, arrs.Length);\\n                url = arrs[index];\\n            }\\n            if (string.IsNullOrWhiteSpace(pdfName))\\n            {\\n                pdfName = DateTime.Now.ToString(\\\"yyyyMMdd_HHmmss\\\");\\n            }\\n\\n            var res = HtmlToPdfHelper.GetHtmlToPdfSaveUrl(pdfName, url, EHtmlToPdfDocumentType.HtmlUrl);\\n            return res;\\n}\\n```\\n\\n## 测试调用\\n![23984952da5bd7c329bcc937.png](https://resource.yousu.xyz/storage/images/f3fbf84f-8d78-4ffb-b7cf-82b3bb28c7ef.png)\\n\\n![239849526ccc3c525cf54ac9.png](https://resource.yousu.xyz/storage/images/ac8fc5c6-2cfe-4f15-b2d0-398a622679ae.png)\",\"articleStatus\":1,\"categoryId\":\"14f9df92-721e-11ec-b79b-0242ac110003\",\"top\":0,\"viewNum\":8,\"likeNum\":1,\"commentNum\":0,\"auth\":0,\"isDisableComment\":true,\"coverImage\":[{\"name\":\"istockphoto-483902160-170667a.jpg\",\"id\":\"08d9f1e0-7ea7-4593-8f81-45f06953cc1f\",\"businessId\":\"f0361b89-e5fb-4d73-b65e-00843c7ee361\",\"url\":\"http://101.42.135.254:9000/storage/images/750c07b2-071e-4857-a6e0-cada87be221a.jpg\",\"uid\":1645080353758,\"status\":\"success\"}],\"tagIds\":[\"08d9f1d9-9e2d-41a6-869c-78aab3285816\",\"cd1c05d6-7099-11ec-ae8d-0242ac110002\"]}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.054175600000000004);
INSERT INTO `sys_oper_log` VALUES ('08d9f1e6-f53e-467f-874c-be45ad982ba3', '2022-02-17 15:27:30.922218', NULL, 0, NULL, '博文分类', 2, 'Category.Delete()', 'DELETE', 0, 'admin', NULL, '/api/v1.0/Blog/Category/Delete', '127.0.0.1', '0 内网IP', '?id=08d9d81e-d320-4cd3-8b82-c95b733e9693', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0035644);
INSERT INTO `sys_oper_log` VALUES ('08d9f1e7-164a-4337-8371-aef3c2c6cde7', '2022-02-17 15:28:26.341637', NULL, 0, NULL, '博文分类', 1, 'Category.Add()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Category/Add', '127.0.0.1', '0 内网IP', '{\"parentId\":\"2ee18b9f-721e-11ec-b79b-0242ac110003\",\"categoryTitle\":\"部署\",\"sortNO\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0007764);
INSERT INTO `sys_oper_log` VALUES ('08d9f1e7-512d-4a13-8089-00bd5966592d', '2022-02-17 15:30:05.140066', NULL, 0, NULL, '博文标签', 1, 'Tag.Add()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Tag/Add', '127.0.0.1', '0 内网IP', '{\"isQuickNav\":false,\"tagTitle\":\".Net部署\",\"sortNO\":1}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0008575000000000001);
INSERT INTO `sys_oper_log` VALUES ('08d9f1e9-a6ef-4c17-8159-a2cc3ac8af9d', '2022-02-17 15:46:48.010626', NULL, 0, NULL, '博文管理', 1, 'Article.AddArticle()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Article/AddArticle', '127.0.0.1', '0 内网IP', '{\"id\":\"3927ba01-0c71-44a2-84f9-c844f17e776d\",\"articleTitle\":\"AspNet部署到docker容器\",\"introduction\":\"在Centos 7.6上的Docker容器部署Asp.Net项目，这里部署只支持core以上版本\",\"articleContent\":\"# 部署\\n## 发布文件准备\\n1. 点击要发布web程序，右键添加Dockerfile\\n2. 编辑dockerfile文件如下：\\n``` dockerfile\\n# 使用运行时镜像\\nFROM mcr.microsoft.com/dotnet/aspnet:6.0 AS base\\n# 设置系统时间\\nRUN echo \\\"Asia/shanghai\\\" > /etc/timezone\\nRUN cp /usr/share/zoneinfo/Asia/Shanghai /etc/localtime\\n\\n# 设置工作目录\\nWORKDIR /app\\n# 把目录下的内容都复制到当前目录下\\nCOPY . .\\n# 暴露80端口\\nEXPOSE 80\\n# 运行镜像入口命令和可执行文件名称\\nENTRYPOINT [\\\"dotnet\\\", \\\"w.Framework.Admin.Api.dll\\\"]\\n```\\n3. 修改Dockerfile文件的属性，修改为始终复制，这样能保证Dockerfile可以随程序一起发布。\\n![截图.png](https://resource.yousu.xyz/storage/images/7b596fa9-2e0d-444a-8024-ac9987851f35.png)\\n4. 点击发布并打包到Centos主机上\\n\\n## 开始部署\\n1. 生成镜像（其中[xxx]是镜像名）\\n``` shell\\ndocker build -t aspnet3.1/admin:v1 . #admin是镜像名称，冒号后面是版本号（注意后面的点要加）\\n```\\n2. 启动运行生成号的镜像项目\\n``` shell\\ndocker run --name=admin01 -p 8080:80 -v /home/docker/www/admin:/app -d aspnet3.1/admin:v1 --restart=always\\n #数据卷映射，注意：（宿主机必须有发布文件，否则docker容器app会被清空，建议使用打包后的解压包的发布文件）\\n```\\n```\\n--name ：指定容器名称。\\n--p ：指定容器端口，（8080外部端口，80容器端口）\\n--d ：指定容器后台运行。\\n--restart=always：容器启动并一起启动\\n```\\n## 其它相关命令\\n```\\n# 容器数据拷贝到宿主机命令：\\ndocker cp my:/app /root/myapp\\n```\\n```\\n# 宿主机拷贝到容器，反过来即可\\ndocker cp /root/myapp my:/app\\n```\",\"categoryId\":\"08d9f1e7-1624-406e-8ea1-733d381f35a0\",\"tagIds\":[\"08d9f1e7-5105-4944-81f5-ecafd5492dcf\"],\"articleStatus\":1,\"top\":0,\"auth\":0,\"isDisableComment\":true,\"viewNum\":2,\"likeNum\":3,\"coverImage\":[{\"name\":\"code.png\",\"id\":\"08d9f1e9-96e7-46aa-8ce8-d894f4d80b21\",\"businessId\":\"3927ba01-0c71-44a2-84f9-c844f17e776d\",\"url\":\"https://resource.yousu.xyz/storage/images/4be7fe5c-e903-481b-8443-387e9c4d4161.png\",\"uid\":1645083981712,\"status\":\"success\"}]}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0005295);
INSERT INTO `sys_oper_log` VALUES ('08d9f1ed-ba42-408a-8db2-9dc264a26517', '2022-02-17 16:15:58.438513', NULL, 0, NULL, '博文管理', 2, 'Article.UpdateArticle()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Article/UpdateArticle', '127.0.0.1', '0 内网IP', '{\"id\":\"3927ba01-0c71-44a2-84f9-c844f17e776d\",\"userName\":\"00000000-0000-0000-0000-000000000000\",\"articleTitle\":\"AspNet部署到docker容器\",\"introduction\":\"在Centos 7.6上的Docker容器部署Asp.Net项目，这里部署只支持core以上版本\",\"articleContent\":\"# 部署\\n## 发布文件准备\\n1. 点击要发布web程序，右键添加Dockerfile\\n2. 编辑dockerfile文件如下：\\n``` dockerfile\\n# 使用运行时镜像\\nFROM mcr.microsoft.com/dotnet/aspnet:6.0 AS base\\n# 设置系统时间\\nRUN echo \\\"Asia/shanghai\\\" > /etc/timezone\\nRUN cp /usr/share/zoneinfo/Asia/Shanghai /etc/localtime\\n\\n# 设置工作目录\\nWORKDIR /app\\n# 把目录下的内容都复制到当前目录下\\nCOPY . .\\n# 暴露80端口\\nEXPOSE 80\\n# 运行镜像入口命令和可执行文件名称\\nENTRYPOINT [\\\"dotnet\\\", \\\"w.Framework.Admin.Api.dll\\\"]\\n```\\n3. 修改Dockerfile文件的属性，修改为始终复制，这样能保证Dockerfile可以随程序一起发布。\\n![截图.png](https://resource.yousu.xyz/storage/images/7b596fa9-2e0d-444a-8024-ac9987851f35.png)\\n4. 点击发布并打包到Centos主机上\\n\\n## 开始部署\\n1. 生成镜像（其中[xxx]是镜像名）\\n``` docker\\ndocker build -t aspnet3.1/admin:v1 . #admin是镜像名称，冒号后面是版本号（注意后面的点要加）\\n```\\n2. 启动运行生成号的镜像项目\\n``` docker\\ndocker run --name=admin01 -p 8080:80 -v /home/docker/www/admin:/app -d aspnet3.1/admin:v1 --restart=always\\n #数据卷映射，注意：（宿主机必须有发布文件，否则docker容器app会被清空，建议使用打包后的解压包的发布文件）\\n```\\n\\n``` shell\\n--name ：指定容器名称。\\n--p ：指定容器端口，（8080外部端口，80容器端口）\\n--d ：指定容器后台运行。\\n--restart=always：容器启动并一起启动\\n```\\n## 其它相关命令 \\n``` docker\\n# 容器数据拷贝到宿主机命令：\\ndocker cp my:/app /root/myapp\\n```\\n``` docker\\n# 宿主机拷贝到容器，反过来即可\\ndocker cp /root/myapp my:/app\\n```\",\"articleStatus\":1,\"categoryId\":\"08d9f1e7-1624-406e-8ea1-733d381f35a0\",\"top\":0,\"viewNum\":4,\"likeNum\":3,\"commentNum\":0,\"auth\":0,\"isDisableComment\":true,\"coverImage\":[{\"name\":\"code.png\",\"id\":\"08d9f1e9-96e7-46aa-8ce8-d894f4d80b21\",\"businessId\":\"3927ba01-0c71-44a2-84f9-c844f17e776d\",\"url\":\"https://resource.yousu.xyz/storage/images/4be7fe5c-e903-481b-8443-387e9c4d4161.png\",\"uid\":1645085473893,\"status\":\"success\"}],\"tagIds\":[\"08d9f1e7-5105-4944-81f5-ecafd5492dcf\"]}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0051947);
INSERT INTO `sys_oper_log` VALUES ('08d9f1ee-2ac4-43ea-883e-4afe3527b0ab', '2022-02-17 16:19:07.176553', NULL, 0, NULL, '博文管理', 2, 'Article.UpdateArticle()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Article/UpdateArticle', '127.0.0.1', '0 内网IP', '{\"id\":\"3927ba01-0c71-44a2-84f9-c844f17e776d\",\"userName\":\"00000000-0000-0000-0000-000000000000\",\"articleTitle\":\"AspNet部署到docker容器\",\"introduction\":\"在Centos 7.6上的Docker容器部署Asp.Net项目，这里部署只支持core以上版本\",\"articleContent\":\"# 部署\\n## 发布文件准备\\n1. 点击要发布web程序，右键添加Dockerfile\\n2. 编辑dockerfile文件如下：\\n``` dockerfile\\n# 使用运行时镜像\\nFROM mcr.microsoft.com/dotnet/aspnet:6.0 AS base\\n# 设置系统时间\\nRUN echo \\\"Asia/shanghai\\\" > /etc/timezone\\nRUN cp /usr/share/zoneinfo/Asia/Shanghai /etc/localtime\\n\\n# 设置工作目录\\nWORKDIR /app\\n# 把目录下的内容都复制到当前目录下\\nCOPY . .\\n# 暴露80端口\\nEXPOSE 80\\n# 运行镜像入口命令和可执行文件名称\\nENTRYPOINT [\\\"dotnet\\\", \\\"w.Framework.Admin.Api.dll\\\"]\\n```\\n3. 修改Dockerfile文件的属性，修改为始终复制，这样能保证Dockerfile可以随程序一起发布。\\n![截图.png](https://resource.yousu.xyz/storage/images/7b596fa9-2e0d-444a-8024-ac9987851f35.png)\\n4. 点击发布并打包到Centos主机上\\n\\n## 开始部署\\n1. 生成镜像（其中[xxx]是镜像名）\\n``` docker\\ndocker build -t aspnet3.1/admin:v1 . #admin是镜像名称，冒号后面是版本号（注意后面的点要加）\\n```\\n2. 启动运行生成号的镜像项目\\n``` docker\\ndocker run --name=admin01 -p 8080:80 -v /home/docker/www/admin:/app -d aspnet3.1/admin:v1 --restart=always\\n #数据卷映射，注意：（宿主机必须有发布文件，否则docker容器app会被清空，建议使用打包后的解压包的发布文件）\\n```\\n备注\\n``` cmd\\n--name ：指定容器名称。\\n--p ：指定容器端口，（8080外部端口，80容器端口）\\n--d ：指定容器后台运行。\\n--restart=always：容器启动并一起启动\\n```\\n## 其它相关命令 \\n``` docker\\n# 容器数据拷贝到宿主机命令：\\ndocker cp my:/app /root/myapp\\n```\\n``` docker\\n# 宿主机拷贝到容器，反过来即可\\ndocker cp /root/myapp my:/app\\n```\",\"articleStatus\":1,\"categoryId\":\"08d9f1e7-1624-406e-8ea1-733d381f35a0\",\"top\":0,\"viewNum\":4,\"likeNum\":3,\"commentNum\":0,\"auth\":0,\"isDisableComment\":true,\"coverImage\":[{\"name\":\"code.png\",\"id\":\"08d9f1e9-96e7-46aa-8ce8-d894f4d80b21\",\"businessId\":\"3927ba01-0c71-44a2-84f9-c844f17e776d\",\"url\":\"https://resource.yousu.xyz/storage/images/4be7fe5c-e903-481b-8443-387e9c4d4161.png\",\"uid\":1645085473893,\"status\":\"success\"}],\"tagIds\":[\"08d9f1e7-5105-4944-81f5-ecafd5492dcf\"]}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0013163);
INSERT INTO `sys_oper_log` VALUES ('08d9f1ee-4041-4c5b-838f-e6ffe2be37ed', '2022-02-17 16:19:43.227705', NULL, 0, NULL, '博文管理', 2, 'Article.UpdateArticle()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Article/UpdateArticle', '127.0.0.1', '0 内网IP', '{\"id\":\"3927ba01-0c71-44a2-84f9-c844f17e776d\",\"userName\":\"00000000-0000-0000-0000-000000000000\",\"articleTitle\":\"AspNet部署到docker容器\",\"introduction\":\"在Centos 7.6上的Docker容器部署Asp.Net项目，这里部署只支持core以上版本\",\"articleContent\":\"# 部署\\n## 发布文件准备\\n1. 点击要发布web程序，右键添加Dockerfile\\n2. 编辑dockerfile文件如下：\\n``` dockerfile\\n# 使用运行时镜像\\nFROM mcr.microsoft.com/dotnet/aspnet:6.0 AS base\\n# 设置系统时间\\nRUN echo \\\"Asia/shanghai\\\" > /etc/timezone\\nRUN cp /usr/share/zoneinfo/Asia/Shanghai /etc/localtime\\n\\n# 设置工作目录\\nWORKDIR /app\\n# 把目录下的内容都复制到当前目录下\\nCOPY . .\\n# 暴露80端口\\nEXPOSE 80\\n# 运行镜像入口命令和可执行文件名称\\nENTRYPOINT [\\\"dotnet\\\", \\\"w.Framework.Admin.Api.dll\\\"]\\n```\\n3. 修改Dockerfile文件的属性，修改为始终复制，这样能保证Dockerfile可以随程序一起发布。\\n![截图.png](https://resource.yousu.xyz/storage/images/7b596fa9-2e0d-444a-8024-ac9987851f35.png)\\n4. 点击发布并打包到Centos主机上\\n\\n## 开始部署\\n1. 生成镜像（其中[xxx]是镜像名）\\n``` docker\\ndocker build -t aspnet3.1/admin:v1 . #admin是镜像名称，冒号后面是版本号（注意后面的点要加）\\n```\\n2. 启动运行生成号的镜像项目\\n``` docker\\ndocker run --name=admin01 -p 8080:80 -v /home/docker/www/admin:/app -d aspnet3.1/admin:v1 --restart=always\\n #数据卷映射，注意：（宿主机必须有发布文件，否则docker容器app会被清空，建议使用打包后的解压包的发布文件）\\n```\\n备注\\n``` cmd\\n--name ：指定容器名称。\\n--p ：指定容器端口，（8080外部端口，80容器端口）\\n--d ：指定容器后台运行。\\n--restart=always：容器启动并一起启动\\n```\\n## 其它相关命令 \\n``` docker\\n# 容器数据拷贝到宿主机命令：\\ndocker cp my:/app /root/myapp\\n# 宿主机拷贝到容器，反过来即可\\ndocker cp /root/myapp my:/app\\n```\",\"articleStatus\":1,\"categoryId\":\"08d9f1e7-1624-406e-8ea1-733d381f35a0\",\"top\":0,\"viewNum\":4,\"likeNum\":3,\"commentNum\":0,\"auth\":0,\"isDisableComment\":true,\"coverImage\":[{\"name\":\"code.png\",\"id\":\"08d9f1e9-96e7-46aa-8ce8-d894f4d80b21\",\"businessId\":\"3927ba01-0c71-44a2-84f9-c844f17e776d\",\"url\":\"https://resource.yousu.xyz/storage/images/4be7fe5c-e903-481b-8443-387e9c4d4161.png\",\"uid\":1645085473893,\"status\":\"success\"}],\"tagIds\":[\"08d9f1e7-5105-4944-81f5-ecafd5492dcf\"]}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0007534);
INSERT INTO `sys_oper_log` VALUES ('08d9f1ee-48ff-4182-8a21-ef402b4a8d22', '2022-02-17 16:19:57.893977', NULL, 0, NULL, '博文管理', 2, 'Article.UpdateArticle()', 'POST', 0, 'admin', NULL, '/api/v1.0/Blog/Article/UpdateArticle', '127.0.0.1', '0 内网IP', '{\"id\":\"3927ba01-0c71-44a2-84f9-c844f17e776d\",\"userName\":\"00000000-0000-0000-0000-000000000000\",\"articleTitle\":\"AspNet部署到docker容器\",\"introduction\":\"在Centos 7.6上的Docker容器部署Asp.Net项目，这里部署只支持core以上版本\",\"articleContent\":\"# 部署\\n## 发布文件准备\\n1. 点击要发布web程序，右键添加Dockerfile\\n2. 编辑dockerfile文件如下：\\n``` dockerfile\\n# 使用运行时镜像\\nFROM mcr.microsoft.com/dotnet/aspnet:6.0 AS base\\n# 设置系统时间\\nRUN echo \\\"Asia/shanghai\\\" > /etc/timezone\\nRUN cp /usr/share/zoneinfo/Asia/Shanghai /etc/localtime\\n\\n# 设置工作目录\\nWORKDIR /app\\n# 把目录下的内容都复制到当前目录下\\nCOPY . .\\n# 暴露80端口\\nEXPOSE 80\\n# 运行镜像入口命令和可执行文件名称\\nENTRYPOINT [\\\"dotnet\\\", \\\"w.Framework.Admin.Api.dll\\\"]\\n```\\n3. 修改Dockerfile文件的属性，修改为始终复制，这样能保证Dockerfile可以随程序一起发布。\\n![截图.png](https://resource.yousu.xyz/storage/images/7b596fa9-2e0d-444a-8024-ac9987851f35.png)\\n4. 点击发布并打包到Centos主机上\\n\\n## 开始部署\\n1. 生成镜像（其中[xxx]是镜像名）\\n``` docker\\ndocker build -t aspnet3.1/admin:v1 . #admin是镜像名称，冒号后面是版本号（注意后面的点要加）\\n```\\n2. 启动运行生成号的镜像项目\\n``` docker\\ndocker run --name=admin01 -p 8080:80 -v /home/docker/www/admin:/app -d aspnet3.1/admin:v1 --restart=always\\n #数据卷映射，注意：（宿主机必须有发布文件，否则docker容器app会被清空，建议使用打包后的解压包的发布文件）\\n```\\n备注\\n``` cmd\\n--name ：指定容器名称。\\n--p ：指定容器端口，（8080外部端口，80容器端口）\\n--d ：指定容器后台运行。\\n--restart=always：容器启动并一起启动\\n```\\n## 其它相关命令 \\n``` docker\\n# 容器数据拷贝到宿主机命令：\\ndocker cp my:/app /root/myapp\\n\\n# 宿主机拷贝到容器，反过来即可\\ndocker cp /root/myapp my:/app\\n```\",\"articleStatus\":1,\"categoryId\":\"08d9f1e7-1624-406e-8ea1-733d381f35a0\",\"top\":0,\"viewNum\":4,\"likeNum\":3,\"commentNum\":0,\"auth\":0,\"isDisableComment\":true,\"coverImage\":[{\"name\":\"code.png\",\"id\":\"08d9f1e9-96e7-46aa-8ce8-d894f4d80b21\",\"businessId\":\"3927ba01-0c71-44a2-84f9-c844f17e776d\",\"url\":\"https://resource.yousu.xyz/storage/images/4be7fe5c-e903-481b-8443-387e9c4d4161.png\",\"uid\":1645085473893,\"status\":\"success\"}],\"tagIds\":[\"08d9f1e7-5105-4944-81f5-ecafd5492dcf\"]}', '{\"Msg\":\"ok\",\"StatusCode\":1000,\"Success\":true}', 1, NULL, 0.0006958);

-- ----------------------------
-- Table structure for sys_privilege
-- ----------------------------
DROP TABLE IF EXISTS `sys_privilege`;
CREATE TABLE `sys_privilege`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `OwnerId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `OwnerType` int NOT NULL,
  `ResourceId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_privilege
-- ----------------------------
INSERT INTO `sys_privilege` VALUES ('08d9c043-a703-412c-8a71-bb7702747035', '2021-12-16 11:25:04.721925', NULL, 0, NULL, '35fe9b5d-57cc-11ec-ad18-0242ac110004', 1, '7fd11851-4bdb-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c043-a705-4e23-831e-b429ba9082f5', '2021-12-16 11:25:04.722013', NULL, 0, NULL, '35fe9b5d-57cc-11ec-ad18-0242ac110004', 1, 'c31dc578-4bda-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c043-a705-4eca-8bce-8804778f4cd2', '2021-12-16 11:25:04.722014', NULL, 0, NULL, '35fe9b5d-57cc-11ec-ad18-0242ac110004', 1, '08d9bc68-1aa1-497b-83e8-b23ba75a8467');
INSERT INTO `sys_privilege` VALUES ('08d9c043-a705-4edc-8e4b-e8256f7efdb4', '2021-12-16 11:25:04.722014', NULL, 0, NULL, '35fe9b5d-57cc-11ec-ad18-0242ac110004', 1, '3a6926ca-5385-11ec-887b-0242ac110005');
INSERT INTO `sys_privilege` VALUES ('08d9c044-2284-404e-8dab-ddda58e711f1', '2021-12-16 11:28:31.904481', NULL, 0, NULL, '086fe721-61f4-4257-b11b-2a27204005dc', 1, '7fd11851-4bdb-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c044-2284-4119-872a-a3af1d41056c', '2021-12-16 11:28:31.904498', NULL, 0, NULL, '086fe721-61f4-4257-b11b-2a27204005dc', 1, '5ecc9776-4bdb-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c044-2284-419a-8882-167854434725', '2021-12-16 11:28:31.904506', NULL, 0, NULL, '086fe721-61f4-4257-b11b-2a27204005dc', 1, 'c31dc578-4bda-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c044-2284-420c-85b4-0601d15947d2', '2021-12-16 11:28:31.904511', NULL, 0, NULL, '086fe721-61f4-4257-b11b-2a27204005dc', 1, '08d9bc68-1aa1-497b-83e8-b23ba75a8467');
INSERT INTO `sys_privilege` VALUES ('08d9c044-2284-4269-81c8-304d06e09a73', '2021-12-16 11:28:31.904517', NULL, 0, NULL, '086fe721-61f4-4257-b11b-2a27204005dc', 1, '08d9bf7a-dc5f-42f3-8759-37ecb85a20ad');
INSERT INTO `sys_privilege` VALUES ('08d9c044-2284-42c1-8c41-4b52f43a6789', '2021-12-16 11:28:31.904522', NULL, 0, NULL, '086fe721-61f4-4257-b11b-2a27204005dc', 1, '3a6926ca-5385-11ec-887b-0242ac110005');
INSERT INTO `sys_privilege` VALUES ('08d9c044-2284-4306-813a-a7de2a3bd0ae', '2021-12-16 11:28:31.904526', NULL, 0, NULL, '086fe721-61f4-4257-b11b-2a27204005dc', 1, '61922a4b-5385-11ec-887b-0242ac110005');
INSERT INTO `sys_privilege` VALUES ('08d9c044-2284-4355-8bf8-c47b562db0ce', '2021-12-16 11:28:31.904531', NULL, 0, NULL, '086fe721-61f4-4257-b11b-2a27204005dc', 1, 'a6550668-4bf2-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c044-2284-438b-8699-b517d0ae2f26', '2021-12-16 11:28:31.904543', NULL, 0, NULL, '086fe721-61f4-4257-b11b-2a27204005dc', 1, '08d9bd3d-e5bc-4068-87e6-33c7dc0a4679');
INSERT INTO `sys_privilege` VALUES ('08d9c044-2284-43c1-8a51-421067f2ed14', '2021-12-16 11:28:31.904550', NULL, 0, NULL, '086fe721-61f4-4257-b11b-2a27204005dc', 1, '08d9bd3d-f780-4026-88c0-fdb0828a2f3c');
INSERT INTO `sys_privilege` VALUES ('08d9c0a6-f2f4-4fec-824d-0699969ef70e', '2021-12-16 23:15:52.296786', NULL, 0, NULL, '08d9c0a2-784c-405a-85f4-dd5e3991eed3', 2, '7fd11851-4bdb-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c0a6-f2f5-4dea-86f7-a95e5c4cdc2b', '2021-12-16 23:15:52.296797', NULL, 0, NULL, '08d9c0a2-784c-405a-85f4-dd5e3991eed3', 2, 'c31dc578-4bda-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c0a6-f2f5-4e5a-840f-e4dfcdb48a60', '2021-12-16 23:15:52.296798', NULL, 0, NULL, '08d9c0a2-784c-405a-85f4-dd5e3991eed3', 2, '08d9bc68-1aa1-497b-83e8-b23ba75a8467');
INSERT INTO `sys_privilege` VALUES ('08d9c0a6-f2f5-4e72-8b77-b3b93347a49f', '2021-12-16 23:15:52.296798', NULL, 0, NULL, '08d9c0a2-784c-405a-85f4-dd5e3991eed3', 2, '08d9bf7a-dc5f-42f3-8759-37ecb85a20ad');
INSERT INTO `sys_privilege` VALUES ('08d9c0a6-f2f5-4e8d-82a6-e403a348163d', '2021-12-16 23:15:52.296798', NULL, 0, NULL, '08d9c0a2-784c-405a-85f4-dd5e3991eed3', 2, '08d9c06b-02f5-4e55-87f6-211932aacc4d');
INSERT INTO `sys_privilege` VALUES ('08d9c0a6-f2f5-4ead-823c-fa80c73f2f7c', '2021-12-16 23:15:52.296799', NULL, 0, NULL, '08d9c0a2-784c-405a-85f4-dd5e3991eed3', 2, '3a6926ca-5385-11ec-887b-0242ac110005');
INSERT INTO `sys_privilege` VALUES ('08d9c0a6-f2f5-4ec8-8e22-270903540d91', '2021-12-16 23:15:52.296799', NULL, 0, NULL, '08d9c0a2-784c-405a-85f4-dd5e3991eed3', 2, '61922a4b-5385-11ec-887b-0242ac110005');
INSERT INTO `sys_privilege` VALUES ('08d9c0a6-f2f5-4ee7-8d92-9e1f40d7eda7', '2021-12-16 23:15:52.296799', NULL, 0, NULL, '08d9c0a2-784c-405a-85f4-dd5e3991eed3', 2, 'a6550668-4bf2-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c2d7-e01b-46f8-844e-813d4766bc48', '2021-12-19 18:11:08.379905', NULL, 0, NULL, '9543be7c-116c-4ef0-99ce-722918813b40', 1, '7fd11851-4bdb-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c2d7-e01e-46a2-84ae-c16158440e22', '2021-12-19 18:11:08.379934', NULL, 0, NULL, '9543be7c-116c-4ef0-99ce-722918813b40', 1, '08d9bb89-b3e7-48e5-82f3-028d7cd9f4c9');
INSERT INTO `sys_privilege` VALUES ('08d9c2d7-e01f-4159-813f-cfb6636e802b', '2021-12-19 18:11:08.379935', NULL, 0, NULL, '9543be7c-116c-4ef0-99ce-722918813b40', 1, 'c31dc578-4bda-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c2d7-e01f-4aad-8e13-f49325c1559c', '2021-12-19 18:11:08.379935', NULL, 0, NULL, '9543be7c-116c-4ef0-99ce-722918813b40', 1, '08d9bb89-d806-4128-8020-d9108defc759');
INSERT INTO `sys_privilege` VALUES ('08d9c2d7-e020-44e9-8dbb-2668efff4874', '2021-12-19 18:11:08.379936', NULL, 0, NULL, '9543be7c-116c-4ef0-99ce-722918813b40', 1, '08d9bb8a-07fd-4421-8b06-cb038d69a35e');
INSERT INTO `sys_privilege` VALUES ('08d9c2d7-e020-4ee3-863b-baf904501ca3', '2021-12-19 18:11:08.379936', NULL, 0, NULL, '9543be7c-116c-4ef0-99ce-722918813b40', 1, '08d9bc68-1aa1-497b-83e8-b23ba75a8467');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96ce-4890-8683-c75726caee4b', '2021-12-20 15:30:25.322112', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '7fd11851-4bdb-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96cf-4029-8615-921305769520', '2021-12-20 15:30:25.322121', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '5ecc9776-4bdb-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96cf-46c5-8f82-c0ad7257677b', '2021-12-20 15:30:25.322125', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, 'c31dc578-4bda-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96cf-4e3f-8e64-c8532b82d96b', '2021-12-20 15:30:25.322129', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '08d9bc68-1aa1-497b-83e8-b23ba75a8467');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d0-456e-87ce-f3078a26a1b5', '2021-12-20 15:30:25.322134', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '08d9bf7a-dc5f-42f3-8759-37ecb85a20ad');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d0-4bbe-8649-2b88d4138c4c', '2021-12-20 15:30:25.322140', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '08d9c06b-02f5-4e55-87f6-211932aacc4d');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d1-4311-85d3-2ab8840ebdc2', '2021-12-20 15:30:25.322144', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '3a6926ca-5385-11ec-887b-0242ac110005');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d1-4985-8913-8ff2607117c5', '2021-12-20 15:30:25.322147', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '61922a4b-5385-11ec-887b-0242ac110005');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d2-400e-8968-af8a4a16031d', '2021-12-20 15:30:25.322150', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, 'a6550668-4bf2-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d2-46aa-8852-fb3ba9d9cb99', '2021-12-20 15:30:25.322153', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, 'e3c9c50b-52e1-11ec-887b-0242ac110005');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d2-4cf7-80ed-bee7246c9f62', '2021-12-20 15:30:25.322156', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '08d9b97c-d65d-496b-8cfd-a3c040d33de1');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d3-43eb-858d-35b7e1d6185e', '2021-12-20 15:30:25.322160', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '08d9bb89-5c43-4807-82e5-a42380072993');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d3-4b48-88eb-6b4e6f163d2e', '2021-12-20 15:30:25.322163', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '08d9bb89-6a73-4dd7-8c08-a3e6af13bf80');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d4-41bf-80fd-9a7aa2f5ed1a', '2021-12-20 15:30:25.322166', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '08d9bb89-76e7-4150-87c0-2159adcc1aca');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d4-4857-86a0-9a7bf623d8db', '2021-12-20 15:30:25.322169', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '08d9bd3d-d962-435c-8e01-4bf2250caa05');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d4-4e8c-8d07-3d360c9c94d1', '2021-12-20 15:30:25.322172', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '08d9bd3d-e5bc-4068-87e6-33c7dc0a4679');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d5-452d-8845-99f61ed3fe3c', '2021-12-20 15:30:25.322175', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '08d9bd3d-f780-4026-88c0-fdb0828a2f3c');
INSERT INTO `sys_privilege` VALUES ('08d9c38a-96d5-4bcc-809b-8f51ae144038', '2021-12-20 15:30:25.322178', NULL, 0, NULL, '08d9bed2-0906-4743-8cb0-534c446e1956', 2, '08d9bd3e-7a70-4eb8-8082-3b2530c133d0');
INSERT INTO `sys_privilege` VALUES ('08d9f058-f538-4eef-8e1a-66f6bdb1813b', '2022-02-15 15:58:31.187482', NULL, 0, NULL, '08d9c512-18fc-44d2-8167-9b02d835a157', 2, '08d9ef8f-5f36-4b7f-808a-5ce5385d15d8');
INSERT INTO `sys_privilege` VALUES ('08d9f058-f53b-4021-8eed-e3a0937d7430', '2022-02-15 15:58:31.187497', NULL, 0, NULL, '08d9c512-18fc-44d2-8167-9b02d835a157', 2, '08d9ef96-c633-4f79-8514-ad2ce54536c9');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4283-8b23-7461b7355ca5', '2022-02-16 23:13:40.942614', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9ef8f-5f36-4b7f-808a-5ce5385d15d8');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-42e1-8586-c7030505ad0c', '2022-02-16 23:13:40.942620', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9ef96-c633-4f79-8514-ad2ce54536c9');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-42f0-8cc7-432b7b8e99b7', '2022-02-16 23:13:40.942620', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '7fd11851-4bdb-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4301-8dd4-472e056d29a2', '2022-02-16 23:13:40.942620', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bb89-b3e7-48e5-82f3-028d7cd9f4c9');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-430f-8436-ac384283daeb', '2022-02-16 23:13:40.942621', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bb89-d806-4128-8020-d9108defc759');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-431b-8ba3-1f7084770882', '2022-02-16 23:13:40.942621', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bb8a-07fd-4421-8b06-cb038d69a35e');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-432b-85b6-01f2334e16b1', '2022-02-16 23:13:40.942621', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bb8a-23d4-429c-8cd1-f2a99823c761');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4338-82d5-6ac84fa32f01', '2022-02-16 23:13:40.942622', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bb8a-6e94-4cc8-873c-d6a150336693');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4349-8ab0-88eb5ee86181', '2022-02-16 23:13:40.942622', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, 'e3c9c50b-52e1-11ec-887b-0242ac110005');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4356-8314-c6b0c6c2fc37', '2022-02-16 23:13:40.942622', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bb89-5c43-4807-82e5-a42380072993');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4362-88b8-551ad18edbd5', '2022-02-16 23:13:40.942623', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9b97c-d65d-496b-8cfd-a3c040d33de1');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4377-813e-90f1df46ec0c', '2022-02-16 23:13:40.942623', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bb89-6a73-4dd7-8c08-a3e6af13bf80');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4383-8b44-431af6ff9838', '2022-02-16 23:13:40.942623', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bb89-76e7-4150-87c0-2159adcc1aca');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-438f-8e1a-cb9793039fd1', '2022-02-16 23:13:40.942624', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, 'c31dc578-4bda-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-439f-8892-f806dadb9631', '2022-02-16 23:13:40.942624', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bc68-1aa1-497b-83e8-b23ba75a8467');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-43b4-81ab-40248164cdb0', '2022-02-16 23:13:40.942624', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bf7a-dc5f-42f3-8759-37ecb85a20ad');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-43c0-8c30-a5c8ac791c02', '2022-02-16 23:13:40.942624', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9c06b-02f5-4e55-87f6-211932aacc4d');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-43d0-8782-3215b1df2ebc', '2022-02-16 23:13:40.942625', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '61922a4b-5385-11ec-887b-0242ac110005');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-43dd-8447-fa7b8dcaf5be', '2022-02-16 23:13:40.942625', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, 'a6550668-4bf2-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-43e9-89a3-7dd521f82385', '2022-02-16 23:13:40.942625', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '3a6926ca-5385-11ec-887b-0242ac110005');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-43fa-8294-2800d90e4bda', '2022-02-16 23:13:40.942625', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '5ecc9776-4bdb-11ec-9aa7-0242ac110003');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4406-881b-01491c8b10ef', '2022-02-16 23:13:40.942626', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bd3d-d962-435c-8e01-4bf2250caa05');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4412-8b74-f7a1e771414e', '2022-02-16 23:13:40.942626', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bd3d-e5bc-4068-87e6-33c7dc0a4679');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4422-8653-d1aae92f976e', '2022-02-16 23:13:40.942626', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bd3d-f780-4026-88c0-fdb0828a2f3c');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-442e-8c5d-08858edc595c', '2022-02-16 23:13:40.942627', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bd3e-7a70-4eb8-8082-3b2530c133d0');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-443a-8fb7-a262ddd87c67', '2022-02-16 23:13:40.942627', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9bf7a-8e15-4519-837d-3fb6a1978459');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-444b-8fde-4fb92128511d', '2022-02-16 23:13:40.942627', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9c445-dd64-4d4a-834a-d1fd5761465d');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-445e-8352-e44eb58cc7ee', '2022-02-16 23:13:40.942628', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9c446-1481-49a9-862b-f8b8990ddc48');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-446b-825c-ec91c836aeed', '2022-02-16 23:13:40.942628', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9c451-2c05-43ff-89cf-fc84d6e69b1c');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-447b-83ba-a0d4f29e0b2b', '2022-02-16 23:13:40.942628', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9c451-a89f-4092-8dca-fe6caee7d1ae');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4487-8a77-ec796f492281', '2022-02-16 23:13:40.942628', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9c451-ec75-4ac6-827e-c36b6d059c23');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4493-8d01-f196f5ced766', '2022-02-16 23:13:40.942629', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9c461-a8db-4220-8c86-06dadcac3b05');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-44a3-88a8-bf02e2ebec5f', '2022-02-16 23:13:40.942629', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9c461-dabb-4f72-83ee-4571a98ac0ce');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-44b0-81bf-3c0c85f7a08b', '2022-02-16 23:13:40.942629', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9c461-ffa0-4747-8183-175eb396b7b1');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-44bc-8251-f7785aafed85', '2022-02-16 23:13:40.942630', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9c462-0be8-4dda-81fd-567d60bd92ab');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-44cd-8e52-d60d7f8d05b0', '2022-02-16 23:13:40.942630', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d278-48ca-46aa-8e3a-7b05904a507b');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-44da-84c0-b3be347a2dde', '2022-02-16 23:13:40.942630', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d8cf-23b1-4d2b-8526-5e7e1ee68fa6');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-44e6-884d-047926f8e335', '2022-02-16 23:13:40.942630', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d8cf-3419-44ae-831a-1be7ab8a6151');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-44f6-8705-a6713e3bbbbd', '2022-02-16 23:13:40.942631', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d8cf-5d29-47d9-8b55-938f20398c89');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4502-8a12-624739f663b8', '2022-02-16 23:13:40.942631', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d819-097a-44ec-8f8d-ac7854b6750c');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4529-8ef4-5d4390f7c840', '2022-02-16 23:13:40.942631', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d819-1fe4-4699-8546-7de83142cd8c');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4537-8579-0cc1d11a0a10', '2022-02-16 23:13:40.942631', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d819-2c15-4209-8476-92e202c5c3bf');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4543-8906-069d731bcfbc', '2022-02-16 23:13:40.942632', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d819-391d-4d39-8c6b-d0e89d533187');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4553-8211-a67c8d36ef88', '2022-02-16 23:13:40.942632', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d819-456e-45e8-865d-b709c23dfb4b');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-455f-890a-417c24f4a326', '2022-02-16 23:13:40.942632', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d822-a34c-439c-803f-0ba9c221772c');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-456b-8d03-14f628d61e46', '2022-02-16 23:13:40.942633', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d822-b49a-44e3-8b9b-3f683b27ac28');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-457b-8513-4e42a2609d4c', '2022-02-16 23:13:40.942633', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d822-be9b-453f-850b-a0927a35ad11');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4587-8dc2-93318ca2d659', '2022-02-16 23:13:40.942633', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d822-cd95-44cb-8e73-f70e3368c149');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4593-8f87-adaa5af99653', '2022-02-16 23:13:40.942633', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d822-d6d4-4bd2-8b7f-52f5cb0ade41');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-45a3-82e1-ff4acdaef58c', '2022-02-16 23:13:40.942634', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d8bc-67bb-4270-8229-8476a2c61a8d');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-45af-897d-b5e6719bc69a', '2022-02-16 23:13:40.942634', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d8bc-734f-4647-87ce-828f5e4cb3df');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-45bc-8474-64d03f869da3', '2022-02-16 23:13:40.942634', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d8bc-7e5d-4224-8f12-def73405d646');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-45d2-89b4-910412676507', '2022-02-16 23:13:40.942635', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d8bc-8fbd-4237-86c7-b2c3a259ec66');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-45e0-8817-9887448d7dac', '2022-02-16 23:13:40.942635', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d8bc-99a8-40f9-8f1e-e651d28bbc98');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-45ec-8ffd-361858e163ff', '2022-02-16 23:13:40.942635', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d989-d511-4f79-854f-1502e3be6364');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-45fc-8ae3-7c2827d6e874', '2022-02-16 23:13:40.942635', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d989-e88a-44e1-8242-885fdd3796cb');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4609-830b-f24d4af2905d', '2022-02-16 23:13:40.942636', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d989-f2ed-47eb-8e60-0b3d9fc6954b');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4615-8678-347ba57b7124', '2022-02-16 23:13:40.942636', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9db14-cdab-4158-8866-4682be33a937');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-4630-82e6-ce98691d5c27', '2022-02-16 23:13:40.942636', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d278-c8cc-4084-8c07-282aa214a5d4');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-463c-8f94-bb78630233e7', '2022-02-16 23:13:40.942637', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d63e-edaa-4cb9-8cba-6ef80d6df4c5');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-464e-8758-412785d55e39', '2022-02-16 23:13:40.942637', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d404-b018-49c4-8c42-df2377f39761');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-465a-8e44-491c89fb19fe', '2022-02-16 23:13:40.942637', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d63e-da87-4e48-8d95-31e146a52649');
INSERT INTO `sys_privilege` VALUES ('08d9f15e-ea47-466a-87d1-c89d16386d05', '2022-02-16 23:13:40.942637', NULL, 0, NULL, '08d9c511-f8aa-411a-897e-b863502b4ace', 2, '08d9d63e-feab-4bf5-8a49-226d7957b33a');

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `RoleName` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `RoleCode` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `Status` int NOT NULL DEFAULT 1,
  `Description` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `OrderSort` int NOT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES ('08d9c511-f8aa-411a-897e-b863502b4ace', '2021-12-22 14:12:02.723242', NULL, 0, NULL, 'test', 'test', 1, '', 1);
INSERT INTO `sys_role` VALUES ('08d9c512-18fc-44d2-8167-9b02d835a157', '2021-12-22 14:12:56.904931', NULL, 0, NULL, 'test', 'test', 1, '', 1);
INSERT INTO `sys_role` VALUES ('08d9c512-2121-4c5c-895b-b2c791ecdfc6', '2021-12-22 14:13:10.570389', NULL, 0, NULL, 'test', 'test', 1, '', 1);
INSERT INTO `sys_role` VALUES ('08d9c516-4ced-4801-8a6d-534fe929dbbb', '2021-12-22 14:43:02.106571', NULL, 0, NULL, 'test3', 'tes2', 1, '', 1);
INSERT INTO `sys_role` VALUES ('08d9c516-64c3-401b-85aa-fb34ef595e1f', '2021-12-22 14:43:42.103506', NULL, 0, NULL, 'test3', 'tes2', 1, '', 1);
INSERT INTO `sys_role` VALUES ('08d9c516-7b59-4c66-893c-409d356bab1d', '2021-12-22 14:44:20.002757', NULL, 0, NULL, 'test3', 'tes2', 1, '', 1);
INSERT INTO `sys_role` VALUES ('08d9c516-a705-48e4-853b-1ed8bcbe1e41', '2021-12-22 14:45:33.350469', NULL, 0, NULL, 'test4', 'test4', 1, '', 1);
INSERT INTO `sys_role` VALUES ('08d9c516-b568-4178-8716-3ccc0b1484ba', '2021-12-22 14:45:57.410094', NULL, 0, NULL, 'test4', 'test4', 1, '', 1);
INSERT INTO `sys_role` VALUES ('08d9c516-d971-4714-8352-38a3875530c5', '2021-12-22 14:46:57.851658', NULL, 0, NULL, 'test5', 'test4', 1, '', 1);
INSERT INTO `sys_role` VALUES ('08d9c518-0a3c-42f1-8912-7812fc3f1801', '2021-12-22 14:55:29.175553', NULL, 0, NULL, 'test6', 'test', 1, '', 1);
INSERT INTO `sys_role` VALUES ('c81edfd1-4bb2-11ec-9aa7-0242ac110003', '2022-02-03 15:50:37.351578', NULL, 0, NULL, '系统管理员', 'admin', 1, '系统管理员，拥有该系统整个权限', 1);

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `AccountCode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `Password` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `UserEmail` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `UserName` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `Gender` int NOT NULL,
  `PhoneNum` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `Avatar` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `DeptId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
  `LoginDate` datetime(6) NULL DEFAULT NULL,
  `LoginIP` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `NickName` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '',
  `Description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `Status` int NOT NULL DEFAULT 1,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES ('35fe9b5d-57cc-11ec-ad18-0242ac110004', '2022-02-03 15:50:37.349304', NULL, 0, NULL, 'admin', 'e10adc3949ba59abbe56e057f20f883e', 'dwen@outlook.com', '超级管理员', 1, '19365056612', 'https://gimg2.baidu.com/image_search/src=http%3A%2F%2Fup.enterdesk.com%2Fedpic%2F0e%2F17%2Fa6%2F0e17a6c3b98c9128bfe420450ac4df56.jpg&refer=http%3A%2F%2Fup.enterdesk.com&app=2002&size=f9999,10000&q=a80&n=0&g=0n&fmt=jpeg?sec=1641955220&t=a69ff4e2830ba1e41a4541136091f473', 'a89f00d7-57bf-11ec-ad18-0242ac110004', NULL, NULL, '超级管理员', NULL, 1);
INSERT INTO `sys_user` VALUES ('9543be7c-116c-4ef0-99ce-722918813b40', '2021-12-16 23:25:37.646022', '2022-02-16 23:55:14.594245', 0, NULL, 'devin', 'e10adc3949ba59abbe56e057f20f883e', 'dwen@outlook.com', 'devin', 1, '', NULL, 'a89f00d7-57bf-11ec-ad18-0242ac110004', NULL, NULL, 'devin', '', 1);

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role`  (
  `Id` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `UpdateTime` datetime(6) NULL DEFAULT NULL,
  `IsDelete` tinyint(1) NOT NULL,
  `DeleteTime` datetime(6) NULL DEFAULT NULL,
  `UserId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `RoleId` char(36) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
INSERT INTO `sys_user_role` VALUES ('08d9bed9-68c9-4a59-89e1-72f34625b58e', '2021-12-14 16:12:02.486760', NULL, 0, NULL, '086fe721-61f4-4257-b11b-2a27204005dc', 'c81edfd1-4bb2-11ec-9aa7-0242ac110003');
INSERT INTO `sys_user_role` VALUES ('08d9bedb-d0a0-4a3c-87bf-a597dbf0b71d', '2021-12-14 16:29:15.694735', NULL, 0, NULL, 'c791b287-3adb-410d-aedb-cba99403ccb6', '08d9bed2-0906-4743-8cb0-534c446e1956');
INSERT INTO `sys_user_role` VALUES ('08d9bee2-4d86-4a2d-8fae-2c91aaddae72', '2021-12-14 17:15:42.251382', NULL, 0, NULL, '3428f16e-69b9-408b-8b76-6375a8b518ab', '08d9bed2-0906-4743-8cb0-534c446e1956');
INSERT INTO `sys_user_role` VALUES ('08d9bee2-5975-4f05-881b-62c94745a52c', '2021-12-14 17:16:02.243103', NULL, 0, NULL, 'd6f0ca21-0e09-4d46-8e78-b807c71b0503', 'c81edfd1-4bb2-11ec-9aa7-0242ac110003');
INSERT INTO `sys_user_role` VALUES ('08d9f164-b89b-44b8-85c1-8434fbbe5306', '2022-02-16 23:55:14.594219', NULL, 0, NULL, '9543be7c-116c-4ef0-99ce-722918813b40', '08d9c511-f8aa-411a-897e-b863502b4ace');
INSERT INTO `sys_user_role` VALUES ('35fe9b5d-57cc-11ec-ad18-0242ac110004', '2022-02-03 15:50:37.351695', NULL, 0, NULL, '35fe9b5d-57cc-11ec-ad18-0242ac110004', 'c81edfd1-4bb2-11ec-9aa7-0242ac110003');

SET FOREIGN_KEY_CHECKS = 1;
