### STEP⑨: 实现部分Mapper

本文github[备份地址](https://github.com/dustpg/BlogFM/issues/22)

这一次继续吧: Mapper02.

### Mapper002: [UxROM](https://wiki.nesdev.com/w/index.php/UxROM)

UxROM这就比较厉害了, 能够用到最高用到4MB的RPG-ROM.

但是**没有CHR-ROM**, 需要自己写入CHR-RAM.

根据数据库,UxROM(在自己看来)比较有名的游戏, 比如:

 - [恶魔城](http://bootgod.dyndns.org:7777/profile.php?id=57)
 - (不被小岛承认的)[合金装备](http://bootgod.dyndns.org:7777/profile.php?id=79)
 - [洛克人](http://bootgod.dyndns.org:7777/profile.php?id=608)
 - 以及这次测试的主角, 美版[魂斗罗](http://bootgod.dyndns.org:7777/profile.php?id=52)
 - 不找了

### Banks
 - CPU $8000-$BFFF: 16 KB switchable PRG ROM bank
 - CPU $C000-$FFFF: 16 KB PRG ROM bank, fixed to the last bank

 这个设计就很暴力了, 我喜欢

### Bank select ($8000-$FFFF)
```
7  bit  0
---- ----
xxxx pPPP
     ||||
     ++++- Select 16 KB PRG ROM bank for CPU $8000-$BFFF
          (UNROM uses bits 2-0; UOROM uses bits 3-0)
```
完全可以实现为使用全部的8bit.

要使用全部8bit, 即4MB, 需要 NES 2.0的文件头, 为此自己特地更新了文件头让其支持4MB. 之前有一个搞事的就是用的4MB的Mapper002(自制ROM, 没有物理板子)

有些会有总线冲突, 需要使用副-Mapper来解决, 这里就不讨论了

这个Mapper简单暴力. 避免溢出, 可以膜一下: ```value % count_prgrom16kb```

### 实现
这次感觉是Mapper上最简单的: [STEP9-MAPPER002.c](https://github.com/dustpg/StepFC/blob/master/step9/sfc_mapper_002_uxrom.c) 

### 魂斗罗模拟出现的问题
 - 魂斗罗使用的精灵是8x16模式
 - 魂斗罗使用了DMC声道增强音效
 - 上面决定了, 下次测试DMC就靠你了
 - BGM还行, SE表现力实在太差.
 - 主要就是声音播放有点问题
 - 上上下下左右左右BA!
 - ![30life](./30life.png)
 - 我就不信三十条命打不通关
 - ~~我才不会告诉你即时存档需要保存CHR-RAM呢~~
 - ![clear](./clear.png)
 - 游戏愉快!

### REF
 - [UxROM](https://wiki.nesdev.com/w/index.php/UxROM)