### Make FC(NES) Emulator Step by Step
Re: 从零开始的红白机模拟

![StepFC](./blog/re0fc-37-visualizers1/demo1.gif)

### 项目说明
同时拥有VS2017和CodeLite的项目工程以保证在不同编译器上能够成功编译.

### License
 - StepFC::StepX 每个步骤, 基于 MIT, 重点是分享代码
 - StepFC::StepFC 成品模拟器, 基于GPLv2, 重点是模拟器本身的可执行二进制文件

### StepX列表

0. [第0步](./step0/): 加载NES ROM文件
    - 读取文件是优先的. 
    - 但是打好基础也是非常重要的, 接口是一个好东西
1. [第1步](./step1/): 实现基本的CPU读写功能
    - 需要了解CPU地址空间的布局哦
2. [第2步](./step2/): 6502汇编
    - 实现反汇编是调试不可缺少的一环
3. [第3步](./step3/): 实现CPU指令
    - 这一步比起前面就比较大了
    - 实现所有的CPU指令
4. [第4步](./step4/): 背景渲染
    - 实现第一次图像显示
5. [第5步](./step5/): 基本输入
    - 实现标准双手柄的输入
6. [第6步](./step6/): 精灵渲染
    - 然后就是渲染64个精灵
7. [第7步](./step7/): 实现中精度同步
    - 基于初级的暴力的垂直同步
    - 合并背景与精灵
8. [第8步](./step8/): 实现基本音频播放
    - 用一个末端的状态机实现音频吧
9. [第9步](./step9/): 实现Mappper1234
    - Mapper4是主要介绍的, 因为会触发IRQ
10. [第A步](./stepa/): 实现基础混频
    - 将音频准确度从60Hz提高至44.1kHz吧
    - 但是距离1.79MHz还差了几十倍, 路还很长
11. [第B步](./stepb/): 存档读档规范化
    - 终于规范化存储档了
    - SL大法好
12. [第C步](./stepc/): 录像与回放
    - 可以用于TAS了
13. [第D步](./stepd/): 滤镜与滤波器
    - 让用户体验更好一点
    - FC甚至自带了滤波器
14. [第E步](./stepe/): 扩展音频
    - 扩展音频也是FC的一大亮点
    - NSF探索
    - 音频可视化
15. [第F步](./stepf/): 全部成为F
    - 重启
    - 扩展输入
    - 更精确地模拟
    - FDS BIOS
    - 更多的Mapper
    - 游戏特化
    - 平台优化
    - 网络
    - 图形用户接口
    - NES调试
    - 作弊器/金手指
    - 以上内容均讨论, 内容留空