/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CekTable;
import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopyOptions;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerSecurityUtility;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSType;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import microsoft.sql.DateTimeOffset;

public class SQLServerBulkCopy
implements AutoCloseable {
    private static final String loggerClassName = "com.microsoft.sqlserver.jdbc.SQLServerBulkCopy";
    private static final int SQL_SERVER_2016_VERSION = 13;
    private static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerBulkCopy");
    private SQLServerConnection connection;
    private SQLServerBulkCopyOptions copyOptions;
    private List<ColumnMapping> columnMappings;
    private boolean ownsConnection;
    private String destinationTableName;
    private ISQLServerBulkRecord sourceBulkRecord;
    private ResultSet sourceResultSet;
    private ResultSetMetaData sourceResultSetMetaData;
    private CekTable destCekTable = null;
    private Map<Integer, BulkColumnMetaData> destColumnMetadata;
    private Map<Integer, BulkColumnMetaData> srcColumnMetadata;
    private int destColumnCount;
    private int srcColumnCount;
    private BulkTimeoutTimer timeoutTimer = null;

    public SQLServerBulkCopy(Connection connection) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "SQLServerBulkCopy", connection);
        if (null == connection || !connection.getClass().equals(SQLServerConnection.class)) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDestConnection"), null, false);
        }
        if (connection instanceof SQLServerConnection) {
            this.connection = (SQLServerConnection)connection;
        } else {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDestConnection"), null, false);
        }
        this.ownsConnection = false;
        this.copyOptions = new SQLServerBulkCopyOptions();
        this.initializeDefaults();
        loggerExternal.exiting(loggerClassName, "SQLServerBulkCopy");
    }

    public SQLServerBulkCopy(String string) throws SQLException {
        loggerExternal.entering(loggerClassName, "SQLServerBulkCopy", "connectionUrl not traced.");
        if (string == null || string.trim().equals("")) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_nullConnection"), null, 0, false);
        }
        this.ownsConnection = true;
        SQLServerDriver sQLServerDriver = new SQLServerDriver();
        this.connection = (SQLServerConnection)sQLServerDriver.connect(string, null);
        if (null == this.connection) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_invalidConnection"), null, 0, false);
        }
        this.copyOptions = new SQLServerBulkCopyOptions();
        this.initializeDefaults();
        loggerExternal.exiting(loggerClassName, "SQLServerBulkCopy");
    }

    public void addColumnMapping(int n, int n2) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "addColumnMapping", new Object[]{n, n2});
        if (0 >= n) {
            this.throwInvalidArgument("sourceColumn");
        } else if (0 >= n2) {
            this.throwInvalidArgument("destinationColumn");
        }
        this.columnMappings.add(new ColumnMapping(n, n2));
        loggerExternal.exiting(loggerClassName, "addColumnMapping");
    }

    public void addColumnMapping(int n, String string) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "addColumnMapping", new Object[]{n, string});
        if (0 >= n) {
            this.throwInvalidArgument("sourceColumn");
        } else if (null == string || string.isEmpty()) {
            this.throwInvalidArgument("destinationColumn");
        }
        this.columnMappings.add(new ColumnMapping(n, string.trim()));
        loggerExternal.exiting(loggerClassName, "addColumnMapping");
    }

    public void addColumnMapping(String string, int n) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "addColumnMapping", new Object[]{string, n});
        if (0 >= n) {
            this.throwInvalidArgument("destinationColumn");
        } else if (null == string || string.isEmpty()) {
            this.throwInvalidArgument("sourceColumn");
        }
        this.columnMappings.add(new ColumnMapping(string.trim(), n));
        loggerExternal.exiting(loggerClassName, "addColumnMapping");
    }

    public void addColumnMapping(String string, String string2) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "addColumnMapping", new Object[]{string, string2});
        if (null == string || string.isEmpty()) {
            this.throwInvalidArgument("sourceColumn");
        } else if (null == string2 || string2.isEmpty()) {
            this.throwInvalidArgument("destinationColumn");
        }
        this.columnMappings.add(new ColumnMapping(string.trim(), string2.trim()));
        loggerExternal.exiting(loggerClassName, "addColumnMapping");
    }

    public void clearColumnMappings() {
        loggerExternal.entering(loggerClassName, "clearColumnMappings");
        this.columnMappings.clear();
        loggerExternal.exiting(loggerClassName, "clearColumnMappings");
    }

    @Override
    public void close() {
        loggerExternal.entering(loggerClassName, "close");
        if (this.ownsConnection) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        loggerExternal.exiting(loggerClassName, "close");
    }

    public String getDestinationTableName() {
        return this.destinationTableName;
    }

    public void setDestinationTableName(String string) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "setDestinationTableName", string);
        if (null == string || 0 == string.trim().length()) {
            this.throwInvalidArgument("tableName");
        }
        this.destinationTableName = string.trim();
        loggerExternal.exiting(loggerClassName, "setDestinationTableName");
    }

    public SQLServerBulkCopyOptions getBulkCopyOptions() {
        return this.copyOptions;
    }

    public void setBulkCopyOptions(SQLServerBulkCopyOptions sQLServerBulkCopyOptions) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "updateBulkCopyOptions", sQLServerBulkCopyOptions);
        if (!this.ownsConnection && sQLServerBulkCopyOptions.isUseInternalTransaction()) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidTransactionOption"), null, false);
        }
        this.copyOptions = sQLServerBulkCopyOptions;
        loggerExternal.exiting(loggerClassName, "updateBulkCopyOptions");
    }

    public void writeToServer(ResultSet resultSet) throws SQLServerException {
        this.writeResultSet(resultSet, false);
    }

    public void writeToServer(RowSet rowSet) throws SQLServerException {
        this.writeResultSet(rowSet, true);
    }

    private void writeResultSet(ResultSet resultSet, boolean bl) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "writeToServer");
        if (null == resultSet) {
            this.throwInvalidArgument("sourceData");
        }
        try {
            if (bl) {
                if (!resultSet.isBeforeFirst()) {
                    resultSet.beforeFirst();
                }
            } else if (resultSet.isClosed()) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_resultsetClosed"), null, false);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(null, sQLException.getMessage(), null, 0, false);
        }
        this.sourceResultSet = resultSet;
        this.sourceBulkRecord = null;
        try {
            this.sourceResultSetMetaData = this.sourceResultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), sQLException);
        }
        this.writeToServer();
        loggerExternal.exiting(loggerClassName, "writeToServer");
    }

    public void writeToServer(ISQLServerBulkRecord iSQLServerBulkRecord) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "writeToServer");
        if (null == iSQLServerBulkRecord) {
            this.throwInvalidArgument("sourceData");
        }
        this.sourceBulkRecord = iSQLServerBulkRecord;
        this.sourceResultSet = null;
        this.writeToServer();
        loggerExternal.exiting(loggerClassName, "writeToServer");
    }

    private void initializeDefaults() {
        this.columnMappings = new LinkedList<ColumnMapping>();
        this.destinationTableName = null;
        this.sourceBulkRecord = null;
        this.sourceResultSet = null;
        this.sourceResultSetMetaData = null;
        this.srcColumnCount = 0;
        this.srcColumnMetadata = null;
        this.destColumnMetadata = null;
        this.destColumnCount = 0;
    }

    private void sendBulkLoadBCP() throws SQLServerException {
        final class InsertBulk
        extends TDSCommand {
            InsertBulk() {
                super("InsertBulk", 0);
                int n = SQLServerBulkCopy.this.copyOptions.getBulkCopyTimeout();
                SQLServerBulkCopy.this.timeoutTimer = n > 0 ? new BulkTimeoutTimer(n, this) : null;
            }

            @Override
            final boolean doExecute() throws SQLServerException {
                if (null != SQLServerBulkCopy.this.timeoutTimer) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + ": Starting bulk timer...");
                    }
                    SQLServerBulkCopy.this.timeoutTimer.start();
                }
                try {
                    while (SQLServerBulkCopy.this.doInsertBulk(this)) {
                    }
                }
                catch (SQLServerException sQLServerException) {
                    Throwable throwable = sQLServerException;
                    while (null != throwable.getCause()) {
                        throwable = throwable.getCause();
                    }
                    if (throwable instanceof SQLException) {
                        SQLServerBulkCopy.this.checkForTimeoutException(throwable, SQLServerBulkCopy.this.timeoutTimer);
                    }
                    throw sQLServerException;
                }
                if (null != SQLServerBulkCopy.this.timeoutTimer) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + ": Stopping bulk timer...");
                    }
                    SQLServerBulkCopy.this.timeoutTimer.stop();
                }
                return true;
            }
        }
        this.connection.executeCommand(new InsertBulk());
    }

    private final void writeColumnMetaDataColumnData(TDSWriter tDSWriter, int n) throws SQLServerException {
        int n2;
        boolean bl;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        SQLCollation sQLCollation = null;
        SSType sSType = null;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        tDSWriter.writeBytes(byArray);
        int n8 = this.columnMappings.get((int)n).destinationColumnOrdinal;
        byte[] byArray2 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n8)).flags;
        tDSWriter.writeBytes(byArray2);
        n3 = this.columnMappings.get((int)n).sourceColumnOrdinal;
        n5 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n3)).jdbcType;
        n6 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n3)).precision;
        n7 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n3)).scale;
        boolean bl2 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n3)).isNullable;
        sSType = this.destColumnMetadata.get((Object)Integer.valueOf((int)n8)).ssType;
        n4 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n8)).precision;
        n6 = this.validateSourcePrecision(n6, n5, n4);
        sQLCollation = this.destColumnMetadata.get((Object)Integer.valueOf((int)n8)).collation;
        if (null == sQLCollation) {
            sQLCollation = this.connection.getDatabaseCollation();
        }
        if (-15 == n5 || -9 == n5 || -16 == n5) {
            bl = 4000 < n6 || 4000 < n4;
        } else {
            boolean bl3 = bl = 8000 < n6 || 8000 < n4;
        }
        if (this.sourceResultSet instanceof SQLServerResultSet && this.connection.isColumnEncryptionSettingEnabled()) {
            n5 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n8)).jdbcType;
            n6 = n4;
            n7 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n8)).scale;
        }
        if (null != this.destColumnMetadata.get((Object)Integer.valueOf((int)n8)).encryptionType && this.copyOptions.isAllowEncryptedValueModifications() || null != this.destColumnMetadata.get((Object)Integer.valueOf((int)n8)).cryptoMeta) {
            tDSWriter.writeByte((byte)-91);
            if (bl) {
                tDSWriter.writeShort((short)-1);
            } else {
                tDSWriter.writeShort((short)n6);
            }
        } else if (!(1 != n5 && 12 != n5 && -1 != n5 || SSType.BINARY != sSType && SSType.VARBINARY != sSType && SSType.VARBINARYMAX != sSType && SSType.IMAGE != sSType)) {
            if (bl) {
                tDSWriter.writeByte((byte)-91);
            } else {
                tDSWriter.writeByte((byte)(SSType.BINARY == sSType ? 173 : 165));
            }
            tDSWriter.writeShort((short)n6);
        } else {
            this.writeTypeInfo(tDSWriter, n5, n7, n6, sSType, sQLCollation, bl, bl2, false);
        }
        CryptoMetadata cryptoMetadata = null;
        cryptoMetadata = this.destColumnMetadata.get((Object)Integer.valueOf((int)n8)).cryptoMeta;
        if (null != cryptoMetadata) {
            n2 = cryptoMetadata.baseTypeInfo.getSSType().getJDBCType().asJavaSqlType();
            int n9 = cryptoMetadata.baseTypeInfo.getPrecision();
            bl = -15 == n2 || -9 == n2 || -16 == n2 ? 4000 < n9 : 8000 < n9;
            tDSWriter.writeShort(cryptoMetadata.getOrdinal());
            tDSWriter.writeBytes(byArray);
            this.writeTypeInfo(tDSWriter, n2, cryptoMetadata.baseTypeInfo.getScale(), n9, cryptoMetadata.baseTypeInfo.getSSType(), sQLCollation, bl, bl2, true);
            tDSWriter.writeByte(cryptoMetadata.cipherAlgorithmId);
            tDSWriter.writeByte(cryptoMetadata.encryptionType.getValue());
            tDSWriter.writeByte(cryptoMetadata.normalizationRuleVersion);
        }
        n2 = this.columnMappings.get((int)n).destinationColumnName.length();
        String string = this.columnMappings.get((int)n).destinationColumnName;
        byte[] byArray3 = new byte[2 * n2];
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            byArray3[2 * i] = (byte)(c & 0xFF);
            byArray3[2 * i + 1] = (byte)(c >> 8 & 0xFF);
        }
        tDSWriter.writeByte((byte)n2);
        tDSWriter.writeBytes(byArray3);
    }

    private final void writeTypeInfo(TDSWriter tDSWriter, int n, int n2, int n3, SSType sSType, SQLCollation sQLCollation, boolean bl, boolean bl2, boolean bl3) throws SQLServerException {
        block0 : switch (n) {
            case 4: {
                if (!bl2) {
                    tDSWriter.writeByte(TDSType.INT4.byteValue());
                    break;
                }
                tDSWriter.writeByte(TDSType.INTN.byteValue());
                tDSWriter.writeByte((byte)4);
                break;
            }
            case -5: {
                if (!bl2) {
                    tDSWriter.writeByte(TDSType.INT8.byteValue());
                    break;
                }
                tDSWriter.writeByte(TDSType.INTN.byteValue());
                tDSWriter.writeByte((byte)8);
                break;
            }
            case -7: {
                if (!bl2) {
                    tDSWriter.writeByte(TDSType.BIT1.byteValue());
                    break;
                }
                tDSWriter.writeByte(TDSType.BITN.byteValue());
                tDSWriter.writeByte((byte)1);
                break;
            }
            case 5: {
                if (!bl2) {
                    tDSWriter.writeByte(TDSType.INT2.byteValue());
                    break;
                }
                tDSWriter.writeByte(TDSType.INTN.byteValue());
                tDSWriter.writeByte((byte)2);
                break;
            }
            case -6: {
                if (!bl2) {
                    tDSWriter.writeByte(TDSType.INT1.byteValue());
                    break;
                }
                tDSWriter.writeByte(TDSType.INTN.byteValue());
                tDSWriter.writeByte((byte)1);
                break;
            }
            case 8: {
                if (!bl2) {
                    tDSWriter.writeByte(TDSType.FLOAT8.byteValue());
                    break;
                }
                tDSWriter.writeByte(TDSType.FLOATN.byteValue());
                tDSWriter.writeByte((byte)8);
                break;
            }
            case 7: {
                if (!bl2) {
                    tDSWriter.writeByte(TDSType.FLOAT4.byteValue());
                    break;
                }
                tDSWriter.writeByte(TDSType.FLOATN.byteValue());
                tDSWriter.writeByte((byte)4);
                break;
            }
            case -148: 
            case -146: 
            case 2: 
            case 3: {
                if (bl3 && (SSType.MONEY == sSType || SSType.SMALLMONEY == sSType)) {
                    tDSWriter.writeByte(TDSType.MONEYN.byteValue());
                    if (SSType.MONEY == sSType) {
                        tDSWriter.writeByte((byte)8);
                        break;
                    }
                    tDSWriter.writeByte((byte)4);
                    break;
                }
                if (3 == n) {
                    tDSWriter.writeByte(TDSType.DECIMALN.byteValue());
                } else {
                    tDSWriter.writeByte(TDSType.NUMERICN.byteValue());
                }
                tDSWriter.writeByte((byte)17);
                tDSWriter.writeByte((byte)n3);
                tDSWriter.writeByte((byte)n2);
                break;
            }
            case -145: 
            case 1: {
                if (bl3 && SSType.GUID == sSType) {
                    tDSWriter.writeByte(TDSType.GUID.byteValue());
                    tDSWriter.writeByte((byte)16);
                    break;
                }
                tDSWriter.writeByte(TDSType.BIGCHAR.byteValue());
                tDSWriter.writeShort((short)n3);
                sQLCollation.writeCollation(tDSWriter);
                break;
            }
            case -15: {
                tDSWriter.writeByte(TDSType.NCHAR.byteValue());
                tDSWriter.writeShort(bl3 ? (short)n3 : (short)(2 * n3));
                sQLCollation.writeCollation(tDSWriter);
                break;
            }
            case -1: 
            case 12: {
                tDSWriter.writeByte(TDSType.BIGVARCHAR.byteValue());
                if (bl) {
                    tDSWriter.writeShort((short)-1);
                } else {
                    tDSWriter.writeShort((short)n3);
                }
                sQLCollation.writeCollation(tDSWriter);
                break;
            }
            case -16: 
            case -9: {
                tDSWriter.writeByte(TDSType.NVARCHAR.byteValue());
                if (bl) {
                    tDSWriter.writeShort((short)-1);
                } else {
                    tDSWriter.writeShort(bl3 ? (short)n3 : (short)(2 * n3));
                }
                sQLCollation.writeCollation(tDSWriter);
                break;
            }
            case -2: {
                tDSWriter.writeByte(TDSType.BIGBINARY.byteValue());
                tDSWriter.writeShort((short)n3);
                break;
            }
            case -4: 
            case -3: {
                tDSWriter.writeByte(TDSType.BIGVARBINARY.byteValue());
                if (bl) {
                    tDSWriter.writeShort((short)-1);
                    break;
                }
                tDSWriter.writeShort((short)n3);
                break;
            }
            case -151: 
            case -150: 
            case 93: {
                if (!bl3 && null != this.sourceBulkRecord) {
                    tDSWriter.writeByte(TDSType.BIGVARCHAR.byteValue());
                    tDSWriter.writeShort((short)n3);
                    sQLCollation.writeCollation(tDSWriter);
                    break;
                }
                switch (sSType) {
                    case SMALLDATETIME: {
                        if (!bl2) {
                            tDSWriter.writeByte(TDSType.DATETIME4.byteValue());
                            break block0;
                        }
                        tDSWriter.writeByte(TDSType.DATETIMEN.byteValue());
                        tDSWriter.writeByte((byte)4);
                        break block0;
                    }
                    case DATETIME: {
                        if (!bl2) {
                            tDSWriter.writeByte(TDSType.DATETIME8.byteValue());
                            break block0;
                        }
                        tDSWriter.writeByte(TDSType.DATETIMEN.byteValue());
                        tDSWriter.writeByte((byte)8);
                        break block0;
                    }
                }
                tDSWriter.writeByte(TDSType.DATETIME2N.byteValue());
                tDSWriter.writeByte((byte)n2);
                break;
            }
            case 91: {
                if (!bl3 && null != this.sourceBulkRecord) {
                    tDSWriter.writeByte(TDSType.BIGVARCHAR.byteValue());
                    tDSWriter.writeShort((short)n3);
                    sQLCollation.writeCollation(tDSWriter);
                    break;
                }
                tDSWriter.writeByte(TDSType.DATEN.byteValue());
                break;
            }
            case 92: {
                if (!bl3 && null != this.sourceBulkRecord) {
                    tDSWriter.writeByte(TDSType.BIGVARCHAR.byteValue());
                    tDSWriter.writeShort((short)n3);
                    sQLCollation.writeCollation(tDSWriter);
                    break;
                }
                tDSWriter.writeByte(TDSType.TIMEN.byteValue());
                tDSWriter.writeByte((byte)n2);
                break;
            }
            case 2013: 
            case 2014: {
                tDSWriter.writeByte(TDSType.DATETIMEOFFSETN.byteValue());
                tDSWriter.writeByte((byte)n2);
                break;
            }
            case -155: {
                if (!bl3 && null != this.sourceBulkRecord) {
                    tDSWriter.writeByte(TDSType.BIGVARCHAR.byteValue());
                    tDSWriter.writeShort((short)n3);
                    sQLCollation.writeCollation(tDSWriter);
                    break;
                }
                tDSWriter.writeByte(TDSType.DATETIMEOFFSETN.byteValue());
                tDSWriter.writeByte((byte)n2);
                break;
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_BulkTypeNotSupported"));
                String string = JDBCType.of(n).toString().toLowerCase(Locale.ENGLISH);
                throw new SQLServerException(messageFormat.format(new Object[]{string}), null, 0, null);
            }
        }
    }

    private void writeCekTable(TDSWriter tDSWriter) throws SQLServerException {
        if (this.connection.getServerSupportsColumnEncryption()) {
            if (null != this.destCekTable && 0 < this.destCekTable.getSize()) {
                tDSWriter.writeShort((short)this.destCekTable.getSize());
                for (int i = 0; i < this.destCekTable.getSize(); ++i) {
                    tDSWriter.writeInt(this.destCekTable.getCekTableEntry((int)i).getColumnEncryptionKeyValues().get((int)0).databaseId);
                    tDSWriter.writeInt(this.destCekTable.getCekTableEntry((int)i).getColumnEncryptionKeyValues().get((int)0).cekId);
                    tDSWriter.writeInt(this.destCekTable.getCekTableEntry((int)i).getColumnEncryptionKeyValues().get((int)0).cekVersion);
                    tDSWriter.writeBytes(this.destCekTable.getCekTableEntry((int)i).getColumnEncryptionKeyValues().get((int)0).cekMdVersion);
                    tDSWriter.writeByte((byte)0);
                }
            } else {
                tDSWriter.writeShort((short)0);
            }
        }
    }

    private final void writeColumnMetaData(TDSWriter tDSWriter) throws SQLServerException {
        tDSWriter.writeByte((byte)-127);
        byte[] byArray = new byte[]{(byte)(this.columnMappings.size() & 0xFF), (byte)(this.columnMappings.size() >> 8 & 0xFF)};
        tDSWriter.writeBytes(byArray);
        this.writeCekTable(tDSWriter);
        for (int i = 0; i < this.columnMappings.size(); ++i) {
            this.writeColumnMetaDataColumnData(tDSWriter, i);
        }
    }

    private void checkForTimeoutException(SQLException sQLException, BulkTimeoutTimer bulkTimeoutTimer) throws SQLServerException {
        if (null != sQLException.getSQLState() && sQLException.getSQLState().equals(SQLState.STATEMENT_CANCELED.getSQLStateCode()) && bulkTimeoutTimer.expired()) {
            if (this.copyOptions.isUseInternalTransaction()) {
                this.connection.rollback();
            }
            throw new SQLServerException(SQLServerException.getErrString("R_queryTimedOut"), SQLState.STATEMENT_CANCELED, DriverError.NOT_SET, null);
        }
    }

    private void validateDataTypeConversions(int n, int n2) throws SQLServerException {
        SSType sSType;
        CryptoMetadata cryptoMetadata = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).cryptoMeta;
        CryptoMetadata cryptoMetadata2 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).cryptoMeta;
        JDBCType jDBCType = null != cryptoMetadata ? cryptoMetadata.baseTypeInfo.getSSType().getJDBCType() : JDBCType.of(this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).jdbcType);
        SSType sSType2 = sSType = null != cryptoMetadata2 ? cryptoMetadata2.baseTypeInfo.getSSType() : this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).ssType;
        if (!jDBCType.convertsTo(sSType)) {
            DataTypes.throwConversionError(jDBCType.toString(), sSType.toString());
        }
    }

    private String getDestTypeFromSrcType(int n, int n2, TDSWriter tDSWriter) throws SQLServerException {
        boolean bl;
        SSType sSType = null != this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).cryptoMeta ? this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).cryptoMeta.baseTypeInfo.getSSType() : this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).ssType;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n3 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).jdbcType;
        n4 = n6 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).precision;
        int n7 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).precision;
        n5 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).scale;
        CryptoMetadata cryptoMetadata = this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).cryptoMeta;
        if (null != cryptoMetadata) {
            tDSWriter.setCryptoMetaData(this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).cryptoMeta);
            if (8000 < n7) {
                return "varbinary(max)";
            }
            return "varbinary(" + this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).precision + ")";
        }
        if (null != this.sourceResultSet && null != this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).encryptionType && this.copyOptions.isAllowEncryptedValueModifications()) {
            return "varbinary(" + n4 + ")";
        }
        n4 = this.validateSourcePrecision(n6, n3, n7);
        if (this.sourceResultSet instanceof SQLServerResultSet && this.connection.isColumnEncryptionSettingEnabled()) {
            n3 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).jdbcType;
            n4 = n7;
            n5 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).scale;
        }
        if (-15 == n3 || -9 == n3 || -16 == n3) {
            bl = 4000 < n6 || 4000 < n7;
        } else {
            boolean bl2 = bl = 8000 < n6 || 8000 < n7;
        }
        if (Util.isCharType(n3).booleanValue() && Util.isBinaryType(sSType).booleanValue()) {
            if (bl) {
                return "varbinary(max)";
            }
            return sSType.toString() + "(" + (8000 < n7 ? "max" : Integer.valueOf(n7)) + ")";
        }
        switch (n3) {
            case 4: {
                return "int";
            }
            case 5: {
                return "smallint";
            }
            case -5: {
                return "bigint";
            }
            case -7: {
                return "bit";
            }
            case -6: {
                return "tinyint";
            }
            case 8: {
                return "float";
            }
            case 7: {
                return "real";
            }
            case -148: 
            case -146: 
            case 3: {
                return "decimal(" + n4 + ", " + n5 + ")";
            }
            case 2: {
                return "numeric(" + n4 + ", " + n5 + ")";
            }
            case -145: 
            case 1: {
                return "char(" + n4 + ")";
            }
            case -15: {
                return "NCHAR(" + n4 + ")";
            }
            case -1: 
            case 12: {
                if (bl) {
                    return "varchar(max)";
                }
                return "varchar(" + n4 + ")";
            }
            case -16: 
            case -9: {
                if (bl) {
                    return "NVARCHAR(MAX)";
                }
                return "NVARCHAR(" + n4 + ")";
            }
            case -2: {
                return "binary(" + n4 + ")";
            }
            case -4: 
            case -3: {
                if (bl) {
                    return "varbinary(max)";
                }
                return "varbinary(" + n4 + ")";
            }
            case -151: 
            case -150: 
            case 93: {
                switch (sSType) {
                    case SMALLDATETIME: {
                        if (null != this.sourceBulkRecord) {
                            return "varchar(" + (0 == n4 ? n7 : n4) + ")";
                        }
                        return "smalldatetime";
                    }
                    case DATETIME: {
                        if (null != this.sourceBulkRecord) {
                            return "varchar(" + (0 == n4 ? n7 : n4) + ")";
                        }
                        return "datetime";
                    }
                }
                if (null != this.sourceBulkRecord) {
                    return "varchar(" + (0 == n4 ? n7 : n4) + ")";
                }
                return "datetime2(" + n5 + ")";
            }
            case 91: {
                if (null != this.sourceBulkRecord) {
                    return "varchar(" + (0 == n4 ? n7 : n4) + ")";
                }
                return "date";
            }
            case 92: {
                if (null != this.sourceBulkRecord) {
                    return "varchar(" + (0 == n4 ? n7 : n4) + ")";
                }
                return "time(" + n5 + ")";
            }
            case 2013: 
            case 2014: {
                return "datetimeoffset(" + n5 + ")";
            }
            case -155: {
                if (null != this.sourceBulkRecord) {
                    return "varchar(" + (0 == n4 ? n7 : n4) + ")";
                }
                return "datetimeoffset(" + n5 + ")";
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_BulkTypeNotSupported"));
        Object[] objectArray = new Object[]{JDBCType.of(n3).toString().toLowerCase(Locale.ENGLISH)};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
        return null;
    }

    private final String createInsertBulkCommand(TDSWriter tDSWriter) throws SQLServerException {
        Iterator iterator;
        StringBuilder stringBuilder = new StringBuilder();
        Vector<String> vector = new Vector<String>();
        String string = " , ";
        stringBuilder.append("INSERT BULK " + this.destinationTableName + " (");
        for (int i = 0; i < this.columnMappings.size(); ++i) {
            if (i == this.columnMappings.size() - 1) {
                string = " ) ";
            }
            ColumnMapping columnMapping = this.columnMappings.get(i);
            String string2 = this.destColumnMetadata.get((Object)Integer.valueOf((int)this.columnMappings.get((int)i).destinationColumnOrdinal)).collationName;
            String string3 = "";
            String string4 = this.getDestTypeFromSrcType(columnMapping.sourceColumnOrdinal, columnMapping.destinationColumnOrdinal, tDSWriter).toUpperCase(Locale.ENGLISH);
            if (null != string2 && string2.trim().length() > 0 && null != string4 && (string4.toLowerCase().trim().startsWith("char") || string4.toLowerCase().trim().startsWith("varchar"))) {
                string3 = " COLLATE " + string2;
            }
            stringBuilder.append("[" + columnMapping.destinationColumnName + "] " + string4 + string3 + string);
        }
        if (this.copyOptions.isCheckConstraints()) {
            vector.add("CHECK_CONSTRAINTS");
        }
        if (this.copyOptions.isFireTriggers()) {
            vector.add("FIRE_TRIGGERS");
        }
        if (this.copyOptions.isKeepNulls()) {
            vector.add("KEEP_NULLS");
        }
        if (this.copyOptions.getBatchSize() > 0) {
            vector.add("ROWS_PER_BATCH = " + this.copyOptions.getBatchSize());
        }
        if (this.copyOptions.isTableLock()) {
            vector.add("TABLOCK");
        }
        if (this.copyOptions.isAllowEncryptedValueModifications()) {
            vector.add("ALLOW_ENCRYPTED_VALUE_MODIFICATIONS");
        }
        if ((iterator = vector.iterator()).hasNext()) {
            stringBuilder.append(" with (");
            while (iterator.hasNext()) {
                stringBuilder.append(((String)iterator.next()).toString());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(")");
        }
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.finer(this.toString() + " TDSCommand: " + stringBuilder);
        }
        return stringBuilder.toString();
    }

    private final boolean doInsertBulk(TDSCommand tDSCommand) throws SQLServerException {
        if (this.copyOptions.isUseInternalTransaction()) {
            this.connection.setAutoCommit(false);
        }
        TDSWriter tDSWriter = tDSCommand.startRequest((byte)1);
        String string = this.createInsertBulkCommand(tDSWriter);
        tDSWriter.writeString(string);
        TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
        tDSWriter = tDSCommand.startRequest((byte)7);
        boolean bl = false;
        try {
            this.writeColumnMetaData(tDSWriter);
            bl = this.writeBatchData(tDSWriter);
        }
        catch (SQLServerException sQLServerException) {
            this.writePacketDataDone(tDSWriter);
            tDSCommand.startRequest((byte)6);
            TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
            tDSCommand.interrupt(sQLServerException.getMessage());
            tDSCommand.onRequestComplete();
            throw sQLServerException;
        }
        finally {
            tDSWriter.setCryptoMetaData(null);
        }
        this.writePacketDataDone(tDSWriter);
        TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
        if (this.copyOptions.isUseInternalTransaction()) {
            this.connection.commit();
        }
        return bl;
    }

    private final void writePacketDataDone(TDSWriter tDSWriter) throws SQLServerException {
        tDSWriter.writeByte((byte)-3);
        tDSWriter.writeLong(0L);
        tDSWriter.writeInt(0);
    }

    private void throwInvalidArgument(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] objectArray = new Object[]{string};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, false);
    }

    private void throwInvalidJavaToJDBC(String string, int n) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
        throw new SQLServerException(messageFormat.format(new Object[]{string, n}), null, 0, null);
    }

    private void writeToServer() throws SQLServerException {
        if (this.connection.isClosed()) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), "08003", false);
        }
        long l = System.currentTimeMillis();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.finer(this.toString() + " Start writeToServer: " + l);
        }
        this.getDestinationMetadata();
        this.getSourceMetadata();
        this.validateColumnMappings();
        this.sendBulkLoadBCP();
        long l2 = System.currentTimeMillis();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.finer(this.toString() + " End writeToServer: " + l2);
            int n = (int)((l2 - l) / 1000L);
            loggerExternal.finer(this.toString() + "Time elapsed: " + n + " seconds");
        }
    }

    private void validateStringBinaryLengths(Object object, int n, int n2) throws SQLServerException {
        int n3 = 0;
        int n4 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).precision;
        int n5 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).jdbcType;
        SSType sSType = this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).ssType;
        if (Util.isCharType(n5).booleanValue() && Util.isCharType(sSType).booleanValue() || Util.isBinaryType(n5).booleanValue() && Util.isBinaryType(sSType).booleanValue()) {
            if (object instanceof String) {
                n3 = ((String)object).length();
            } else if (object instanceof byte[]) {
                n3 = ((byte[])object).length;
            } else {
                return;
            }
            if (n3 > n4) {
                String string = (Object)((Object)JDBCType.of(n5)) + "(" + n3 + ")";
                String string2 = sSType.toString() + "(" + n4 + ")";
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidDataForAE"));
                Object[] objectArray = new Object[]{string, string2};
                throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
            }
        }
    }

    private void getDestinationMetadata() throws SQLServerException {
        if (null == this.destinationTableName) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDestinationTable"), null, false);
        }
        SQLServerResultSet sQLServerResultSet = null;
        SQLServerResultSet sQLServerResultSet2 = null;
        try {
            sQLServerResultSet = ((SQLServerStatement)this.connection.createStatement()).executeQueryInternal("SET FMTONLY ON SELECT * FROM " + this.destinationTableName + " SET FMTONLY OFF ");
            this.destColumnCount = sQLServerResultSet.getMetaData().getColumnCount();
            this.destColumnMetadata = new HashMap<Integer, BulkColumnMetaData>();
            this.destCekTable = sQLServerResultSet.getCekTable();
            sQLServerResultSet2 = !this.connection.getServerSupportsColumnEncryption() ? ((SQLServerStatement)this.connection.createStatement()).executeQueryInternal("select collation_name from sys.columns where object_id=OBJECT_ID('" + this.destinationTableName + "') " + "order by column_id ASC") : ((SQLServerStatement)this.connection.createStatement()).executeQueryInternal("select collation_name, encryption_type from sys.columns where object_id=OBJECT_ID('" + this.destinationTableName + "') " + "order by column_id ASC");
            for (int i = 1; i <= this.destColumnCount; ++i) {
                if (sQLServerResultSet2.next()) {
                    if (!this.connection.getServerSupportsColumnEncryption()) {
                        this.destColumnMetadata.put(i, new BulkColumnMetaData(sQLServerResultSet.getColumn(i), sQLServerResultSet2.getString("collation_name"), null));
                        continue;
                    }
                    this.destColumnMetadata.put(i, new BulkColumnMetaData(sQLServerResultSet.getColumn(i), sQLServerResultSet2.getString("collation_name"), sQLServerResultSet2.getString("encryption_type")));
                    continue;
                }
                this.destColumnMetadata.put(i, new BulkColumnMetaData(sQLServerResultSet.getColumn(i)));
            }
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), sQLException);
        }
        finally {
            if (null != sQLServerResultSet) {
                sQLServerResultSet.close();
            }
            if (null != sQLServerResultSet2) {
                sQLServerResultSet2.close();
            }
        }
    }

    private void getSourceMetadata() throws SQLServerException {
        this.srcColumnMetadata = new HashMap<Integer, BulkColumnMetaData>();
        if (null != this.sourceResultSet) {
            try {
                this.srcColumnCount = this.sourceResultSetMetaData.getColumnCount();
                for (int i = 1; i <= this.srcColumnCount; ++i) {
                    this.srcColumnMetadata.put(i, new BulkColumnMetaData(this.sourceResultSetMetaData.getColumnName(i), 0 != this.sourceResultSetMetaData.isNullable(i), this.sourceResultSetMetaData.getPrecision(i), this.sourceResultSetMetaData.getScale(i), this.sourceResultSetMetaData.getColumnType(i), null));
                }
            }
            catch (SQLException sQLException) {
                throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), sQLException);
            }
        } else if (null != this.sourceBulkRecord) {
            Set<Integer> set = this.sourceBulkRecord.getColumnOrdinals();
            this.srcColumnCount = set.size();
            if (0 == this.srcColumnCount) {
                throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), null);
            }
            for (int n : set) {
                this.srcColumnMetadata.put(n, new BulkColumnMetaData(this.sourceBulkRecord.getColumnName(n), true, this.sourceBulkRecord.getPrecision(n), this.sourceBulkRecord.getScale(n), this.sourceBulkRecord.getColumnType(n), this.sourceBulkRecord instanceof SQLServerBulkCSVFileRecord ? ((SQLServerBulkCSVFileRecord)this.sourceBulkRecord).getColumnDateTimeFormatter(n) : null));
            }
        } else {
            throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), null);
        }
    }

    private int validateSourcePrecision(int n, int n2, int n3) {
        if (1 > n && Util.isCharType(n2).booleanValue()) {
            n = n3;
        }
        return n;
    }

    private void validateColumnMappings() throws SQLServerException {
        block27: {
            try {
                boolean bl;
                ColumnMapping columnMapping;
                int n;
                if (this.columnMappings.isEmpty()) {
                    if (this.destColumnCount != this.srcColumnCount) {
                        throw new SQLServerException(SQLServerException.getErrString("R_schemaMismatch"), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
                    }
                    for (int i = 1; i <= this.srcColumnCount; ++i) {
                        if (this.destColumnMetadata.get((Object)Integer.valueOf((int)i)).isIdentity && !this.copyOptions.isKeepIdentity()) continue;
                        ColumnMapping columnMapping2 = new ColumnMapping(i, i);
                        columnMapping2.destinationColumnName = this.destColumnMetadata.get((Object)Integer.valueOf((int)i)).columnName;
                        this.columnMappings.add(columnMapping2);
                    }
                    if (null != this.sourceBulkRecord) {
                        Set<Integer> set = this.sourceBulkRecord.getColumnOrdinals();
                        Iterator<Integer> iterator = set.iterator();
                        int n2 = 1;
                        while (iterator.hasNext()) {
                            int n3 = iterator.next();
                            if (n2 != n3) {
                                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
                                Object[] objectArray = new Object[]{n3};
                                throw new SQLServerException(messageFormat.format(objectArray), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
                            }
                            ++n2;
                        }
                    }
                    break block27;
                }
                int n4 = this.columnMappings.size();
                for (n = 0; n < n4; ++n) {
                    columnMapping = this.columnMappings.get(n);
                    if (-1 == columnMapping.destinationColumnOrdinal) {
                        bl = false;
                        for (int i = 1; i <= this.destColumnCount; ++i) {
                            if (!this.destColumnMetadata.get((Object)Integer.valueOf((int)i)).columnName.equals(columnMapping.destinationColumnName)) continue;
                            bl = true;
                            columnMapping.destinationColumnOrdinal = i;
                            break;
                        }
                        if (bl) continue;
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
                        Object[] objectArray = new Object[]{columnMapping.destinationColumnName};
                        throw new SQLServerException(messageFormat.format(objectArray), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
                    }
                    if (0 > columnMapping.destinationColumnOrdinal || this.destColumnCount < columnMapping.destinationColumnOrdinal) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
                        Object[] objectArray = new Object[]{columnMapping.destinationColumnOrdinal};
                        throw new SQLServerException(messageFormat.format(objectArray), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
                    }
                    columnMapping.destinationColumnName = this.destColumnMetadata.get((Object)Integer.valueOf((int)columnMapping.destinationColumnOrdinal)).columnName;
                }
                for (n = 0; n < n4; ++n) {
                    columnMapping = this.columnMappings.get(n);
                    if (-1 == columnMapping.sourceColumnOrdinal) {
                        bl = false;
                        if (null != this.sourceResultSet) {
                            int n5 = this.sourceResultSetMetaData.getColumnCount();
                            for (int i = 1; i <= n5; ++i) {
                                if (!this.sourceResultSetMetaData.getColumnName(i).equals(columnMapping.sourceColumnName)) continue;
                                bl = true;
                                columnMapping.sourceColumnOrdinal = i;
                                break;
                            }
                        } else {
                            Set<Integer> set = this.sourceBulkRecord.getColumnOrdinals();
                            for (int n6 : set) {
                                if (!this.sourceBulkRecord.getColumnName(n6).equals(columnMapping.sourceColumnName)) continue;
                                bl = true;
                                columnMapping.sourceColumnOrdinal = n6;
                                break;
                            }
                        }
                        if (!bl) {
                            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
                            Object[] objectArray = new Object[]{columnMapping.sourceColumnName};
                            throw new SQLServerException(messageFormat.format(objectArray), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
                        }
                    } else {
                        bl = true;
                        if (null != this.sourceResultSet) {
                            int n7 = this.sourceResultSetMetaData.getColumnCount();
                            if (0 < columnMapping.sourceColumnOrdinal && n7 >= columnMapping.sourceColumnOrdinal) {
                                bl = false;
                            }
                        } else if (this.srcColumnMetadata.containsKey(columnMapping.sourceColumnOrdinal)) {
                            bl = false;
                        }
                        if (bl) {
                            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
                            Object[] objectArray = new Object[]{columnMapping.sourceColumnOrdinal};
                            throw new SQLServerException(messageFormat.format(objectArray), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
                        }
                    }
                    if (!this.destColumnMetadata.get((Object)Integer.valueOf((int)columnMapping.destinationColumnOrdinal)).isIdentity || this.copyOptions.isKeepIdentity()) continue;
                    this.columnMappings.remove(n);
                    --n4;
                    --n;
                }
            }
            catch (SQLException sQLException) {
                if (sQLException instanceof SQLServerException && null != sQLException.getSQLState() && sQLException.getSQLState().equals(SQLState.COL_NOT_FOUND.getSQLStateCode())) {
                    throw (SQLServerException)sQLException;
                }
                throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), sQLException);
            }
        }
        if (this.columnMappings.isEmpty()) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_BulkColumnMappingsIsEmpty"), null, 0, false);
        }
    }

    private void writeNullToTdsWriter(TDSWriter tDSWriter, int n, boolean bl) throws SQLServerException {
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                if (bl) {
                    tDSWriter.writeLong(-1L);
                } else {
                    tDSWriter.writeByte((byte)-1);
                    tDSWriter.writeByte((byte)-1);
                }
                return;
            }
            case -155: 
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                tDSWriter.writeByte((byte)0);
                return;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_BulkTypeNotSupported"));
        Object[] objectArray = new Object[]{JDBCType.of(n).toString().toLowerCase(Locale.ENGLISH)};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
    }

    private void writeColumnToTdsWriter(TDSWriter tDSWriter, int n, int n2, int n3, boolean bl, int n4, int n5, boolean bl2, Object object) throws SQLServerException {
        SSType sSType = this.destColumnMetadata.get((Object)Integer.valueOf((int)n5)).ssType;
        n = this.validateSourcePrecision(n, n3, this.destColumnMetadata.get((Object)Integer.valueOf((int)n5)).precision);
        CryptoMetadata cryptoMetadata = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n4)).cryptoMeta;
        if (null != this.destColumnMetadata.get((Object)Integer.valueOf((int)n5)).encryptionType && this.copyOptions.isAllowEncryptedValueModifications() || null != this.destColumnMetadata.get((Object)Integer.valueOf((int)n5)).cryptoMeta) {
            n3 = -3;
        } else if (null != cryptoMetadata) {
            n3 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n5)).jdbcType;
            n2 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n5)).scale;
        } else if (null != this.sourceBulkRecord) {
            switch (n3) {
                case -155: 
                case 91: 
                case 92: 
                case 93: {
                    n3 = 12;
                    break;
                }
            }
        }
        block9 : switch (n3) {
            case 4: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)4);
                }
                tDSWriter.writeInt((Integer)object);
                break;
            }
            case 5: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)2);
                }
                tDSWriter.writeShort(((Number)object).shortValue());
                break;
            }
            case -5: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)8);
                }
                tDSWriter.writeLong((Long)object);
                break;
            }
            case -7: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)1);
                }
                tDSWriter.writeByte((byte)((Boolean)object != false ? 1 : 0));
                break;
            }
            case -6: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)1);
                }
                tDSWriter.writeByte((byte)(((Number)object).shortValue() & 0xFF));
                break;
            }
            case 8: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)8);
                }
                tDSWriter.writeDouble((Double)object);
                break;
            }
            case 7: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)4);
                }
                tDSWriter.writeReal(Float.valueOf(((Float)object).floatValue()));
                break;
            }
            case -148: 
            case -146: 
            case 2: 
            case 3: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                tDSWriter.writeBigDecimal((BigDecimal)object, n3, n);
                break;
            }
            case -145: 
            case -1: 
            case 1: 
            case 12: {
                if (bl2) {
                    if (null == object) {
                        this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                        break;
                    }
                    tDSWriter.writeLong(-2L);
                    try {
                        Reader reader = null;
                        reader = object instanceof Reader ? (Reader)object : new StringReader(object.toString());
                        if (SSType.BINARY == sSType || SSType.VARBINARY == sSType || SSType.VARBINARYMAX == sSType || SSType.IMAGE == sSType) {
                            tDSWriter.writeNonUnicodeReader(reader, -1L, true, null);
                        } else {
                            SQLCollation sQLCollation = this.destColumnMetadata.get((Object)Integer.valueOf((int)n5)).collation;
                            if (null != sQLCollation) {
                                tDSWriter.writeNonUnicodeReader(reader, -1L, false, sQLCollation.getCharset());
                            } else {
                                tDSWriter.writeNonUnicodeReader(reader, -1L, false, null);
                            }
                        }
                        reader.close();
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), iOException);
                    }
                }
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                String string = object.toString();
                if (SSType.BINARY == sSType || SSType.VARBINARY == sSType) {
                    byte[] byArray = null;
                    try {
                        byArray = ParameterUtils.HexToBin(string);
                    }
                    catch (SQLServerException sQLServerException) {
                        throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), sQLServerException);
                    }
                    tDSWriter.writeShort((short)byArray.length);
                    tDSWriter.writeBytes(byArray);
                    break;
                }
                try {
                    tDSWriter.writeShort((short)string.length());
                    SQLCollation sQLCollation = this.destColumnMetadata.get((Object)Integer.valueOf((int)n5)).collation;
                    if (null != sQLCollation) {
                        tDSWriter.writeBytes(string.getBytes(this.destColumnMetadata.get((Object)Integer.valueOf((int)n5)).collation.getCharset()));
                        break;
                    }
                    tDSWriter.writeBytes(string.getBytes());
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLServerException(SQLServerException.getErrString("R_encodingErrorWritingTDS"), unsupportedEncodingException);
                }
            }
            case -16: 
            case -15: 
            case -9: {
                if (bl2) {
                    if (null == object) {
                        this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                        break;
                    }
                    tDSWriter.writeLong(-2L);
                    try {
                        Reader reader = null;
                        reader = object instanceof Reader ? (Reader)object : new StringReader(object.toString());
                        tDSWriter.writeReader(reader, -1L, true);
                        reader.close();
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), iOException);
                    }
                }
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                int n6 = object.toString().length();
                byte[] byArray = new byte[]{(byte)(2 * n6 & 0xFF), (byte)(2 * n6 >> 8 & 0xFF)};
                tDSWriter.writeBytes(byArray);
                tDSWriter.writeString(object.toString());
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray;
                if (bl2) {
                    if (null == object) {
                        this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                        break;
                    }
                    tDSWriter.writeLong(-2L);
                    try {
                        InputStream inputStream = null;
                        inputStream = object instanceof InputStream ? (InputStream)object : (object instanceof byte[] ? new ByteArrayInputStream((byte[])object) : new ByteArrayInputStream(ParameterUtils.HexToBin(object.toString())));
                        tDSWriter.writeStream(inputStream, -1L, true);
                        inputStream.close();
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), iOException);
                    }
                }
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (object instanceof byte[]) {
                    byArray = (byte[])object;
                } else {
                    try {
                        byArray = ParameterUtils.HexToBin(object.toString());
                    }
                    catch (SQLServerException sQLServerException) {
                        throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), sQLServerException);
                    }
                }
                tDSWriter.writeShort((short)byArray.length);
                tDSWriter.writeBytes(byArray);
                break;
            }
            case -151: 
            case -150: 
            case 93: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                switch (sSType) {
                    case SMALLDATETIME: {
                        if (bl) {
                            tDSWriter.writeByte((byte)4);
                        }
                        tDSWriter.writeSmalldatetime(object.toString());
                        break block9;
                    }
                    case DATETIME: {
                        if (bl) {
                            tDSWriter.writeByte((byte)8);
                        }
                        tDSWriter.writeDatetime(object.toString());
                        break block9;
                    }
                }
                if (bl) {
                    if (2 >= n2) {
                        tDSWriter.writeByte((byte)6);
                    } else if (4 >= n2) {
                        tDSWriter.writeByte((byte)7);
                    } else {
                        tDSWriter.writeByte((byte)8);
                    }
                }
                String string = object.toString();
                tDSWriter.writeTime(Timestamp.valueOf(string), n2);
                tDSWriter.writeDate(string.substring(0, string.lastIndexOf(32)));
                break;
            }
            case 91: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                tDSWriter.writeByte((byte)3);
                tDSWriter.writeDate(object.toString());
                break;
            }
            case 92: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (2 >= n2) {
                    tDSWriter.writeByte((byte)3);
                } else if (4 >= n2) {
                    tDSWriter.writeByte((byte)4);
                } else {
                    tDSWriter.writeByte((byte)5);
                }
                tDSWriter.writeTime((Timestamp)object, n2);
                break;
            }
            case 2013: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (2 >= n2) {
                    tDSWriter.writeByte((byte)8);
                } else if (4 >= n2) {
                    tDSWriter.writeByte((byte)9);
                } else {
                    tDSWriter.writeByte((byte)10);
                }
                tDSWriter.writeOffsetTimeWithTimezone((OffsetTime)object, n2);
                break;
            }
            case 2014: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (2 >= n2) {
                    tDSWriter.writeByte((byte)8);
                } else if (4 >= n2) {
                    tDSWriter.writeByte((byte)9);
                } else {
                    tDSWriter.writeByte((byte)10);
                }
                tDSWriter.writeOffsetDateTimeWithTimezone((OffsetDateTime)object, n2);
                break;
            }
            case -155: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (2 >= n2) {
                    tDSWriter.writeByte((byte)8);
                } else if (4 >= n2) {
                    tDSWriter.writeByte((byte)9);
                } else {
                    tDSWriter.writeByte((byte)10);
                }
                tDSWriter.writeDateTimeOffset((DateTimeOffset)object, n2, sSType);
                break;
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_BulkTypeNotSupported"));
                Object[] objectArray = new Object[]{JDBCType.of(n3).toString().toLowerCase(Locale.ENGLISH)};
                SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
            }
        }
    }

    private Object readColumnFromResultSet(int n, int n2, boolean bl, boolean bl2) throws SQLServerException {
        Object object;
        CryptoMetadata cryptoMetadata = null;
        if (this.sourceResultSet instanceof SQLServerResultSet && null != (cryptoMetadata = ((SQLServerResultSet)this.sourceResultSet).getterGetColumn(n).getCryptoMetadata())) {
            n2 = cryptoMetadata.baseTypeInfo.getSSType().getJDBCType().asJavaSqlType();
            object = this.srcColumnMetadata.get(n);
            this.srcColumnMetadata.put(n, new BulkColumnMetaData((BulkColumnMetaData)object, cryptoMetadata));
        }
        try {
            switch (n2) {
                case -7: 
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    return this.sourceResultSet.getObject(n);
                }
                case -148: 
                case -146: 
                case 2: 
                case 3: {
                    return this.sourceResultSet.getBigDecimal(n);
                }
                case -145: 
                case -1: 
                case 1: 
                case 12: {
                    if (bl && !bl2) {
                        return this.sourceResultSet.getCharacterStream(n);
                    }
                    return this.sourceResultSet.getString(n);
                }
                case -16: 
                case -15: 
                case -9: {
                    if (bl && !bl2) {
                        return this.sourceResultSet.getNCharacterStream(n);
                    }
                    return this.sourceResultSet.getObject(n);
                }
                case -4: 
                case -3: 
                case -2: {
                    if (bl && !bl2) {
                        return this.sourceResultSet.getBinaryStream(n);
                    }
                    return this.sourceResultSet.getBytes(n);
                }
                case -151: 
                case -150: 
                case 93: {
                    return this.sourceResultSet.getTimestamp(n);
                }
                case 91: {
                    return this.sourceResultSet.getDate(n);
                }
                case 92: {
                    return this.sourceResultSet.getTimestamp(n);
                }
                case -155: {
                    return ((SQLServerResultSet)this.sourceResultSet).getDateTimeOffset(n);
                }
            }
            object = new MessageFormat(SQLServerException.getErrString("R_BulkTypeNotSupported"));
            Object[] objectArray = new Object[]{JDBCType.of(n2).toString().toLowerCase(Locale.ENGLISH)};
            SQLServerException.makeFromDriverError(null, null, ((Format)object).format(objectArray), null, true);
            return null;
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), sQLException);
        }
    }

    private final void writeColumn(TDSWriter tDSWriter, int n, int n2, Object object) throws SQLServerException {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        SSType sSType = null;
        boolean bl = false;
        n3 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).precision;
        n4 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).scale;
        n6 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).jdbcType;
        boolean bl2 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).isNullable;
        n5 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).precision;
        bl = -15 == n6 || -9 == n6 || -16 == n6 ? 4000 < n3 || 4000 < n5 : 8000 < n3 || 8000 < n5;
        CryptoMetadata cryptoMetadata = this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).cryptoMeta;
        if (null != cryptoMetadata) {
            sSType = cryptoMetadata.baseTypeInfo.getSSType();
        }
        if (null != this.sourceResultSet) {
            object = this.readColumnFromResultSet(n, n6, bl, null != cryptoMetadata);
            this.validateStringBinaryLengths(object, n, n2);
            if (!(this.copyOptions.isAllowEncryptedValueModifications() || null != cryptoMetadata && null != object)) {
                this.validateDataTypeConversions(n, n2);
            }
        } else if (null != this.sourceBulkRecord && null != cryptoMetadata) {
            if (91 == n6 || 92 == n6 || 93 == n6 || -155 == n6 || 2013 == n6 || 2014 == n6) {
                object = this.getTemporalObjectFromCSV(object, n6, n);
            } else if (2 == n6 || 3 == n6) {
                int n7 = cryptoMetadata.baseTypeInfo.getPrecision();
                int n8 = cryptoMetadata.baseTypeInfo.getScale();
                if (n4 != n8 || n3 != n7) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidDataForAE"));
                    String string = (Object)((Object)JDBCType.of(n6)) + "(" + n3 + "," + n4 + ")";
                    String string2 = (Object)((Object)sSType) + "(" + n7 + "," + n8 + ")";
                    Object[] objectArray = new Object[]{string, string2};
                    throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
                }
            }
        }
        CryptoMetadata cryptoMetadata2 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).cryptoMeta;
        if (null != cryptoMetadata && null != object) {
            JDBCType jDBCType;
            JDBCType jDBCType2 = jDBCType = null != cryptoMetadata2 ? this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).cryptoMeta.baseTypeInfo.getSSType().getJDBCType() : JDBCType.of(n6);
            if (JDBCType.TIMESTAMP == jDBCType) {
                if (SSType.DATETIME == sSType) {
                    jDBCType = JDBCType.DATETIME;
                } else if (SSType.SMALLDATETIME == sSType) {
                    jDBCType = JDBCType.SMALLDATETIME;
                }
            }
            if (!(SSType.MONEY == sSType && JDBCType.DECIMAL == jDBCType || SSType.SMALLMONEY == sSType && JDBCType.DECIMAL == jDBCType || SSType.GUID == sSType && JDBCType.CHAR == jDBCType || Util.isCharType(sSType).booleanValue() && Util.isCharType(n6).booleanValue() || this.sourceResultSet instanceof SQLServerResultSet || jDBCType.normalizationCheck(sSType))) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionAE"));
                Object[] objectArray = new Object[]{jDBCType, sSType};
                throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
            }
            if (jDBCType == JDBCType.DATE || jDBCType == JDBCType.TIMESTAMP || jDBCType == JDBCType.TIME || jDBCType == JDBCType.DATETIMEOFFSET || jDBCType == JDBCType.DATETIME || jDBCType == JDBCType.SMALLDATETIME) {
                object = this.getEncryptedTemporalBytes(tDSWriter, jDBCType, object, n, cryptoMetadata.baseTypeInfo.getScale());
            } else {
                TypeInfo typeInfo = cryptoMetadata.getBaseTypeInfo();
                object = SQLServerSecurityUtility.encryptWithKey(this.normalizedValue(typeInfo.getSSType().getJDBCType(), object, jDBCType, typeInfo.getPrecision(), typeInfo.getScale()), cryptoMetadata, this.connection);
            }
        }
        this.writeColumnToTdsWriter(tDSWriter, n3, n4, n6, bl2, n, n2, bl, object);
    }

    private Object getTemporalObjectFromCSVWithFormatter(String string, int n, int n2, DateTimeFormatter dateTimeFormatter) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        try {
            TemporalAccessor temporalAccessor = dateTimeFormatter.parse(string);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            if (temporalAccessor.isSupported(ChronoField.NANO_OF_SECOND)) {
                n4 = temporalAccessor.get(ChronoField.NANO_OF_SECOND);
            }
            if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                n3 = temporalAccessor.get(ChronoField.OFFSET_SECONDS);
            }
            if (temporalAccessor.isSupported(ChronoField.HOUR_OF_DAY)) {
                n10 = temporalAccessor.get(ChronoField.HOUR_OF_DAY);
            }
            if (temporalAccessor.isSupported(ChronoField.MINUTE_OF_HOUR)) {
                n9 = temporalAccessor.get(ChronoField.MINUTE_OF_HOUR);
            }
            if (temporalAccessor.isSupported(ChronoField.SECOND_OF_MINUTE)) {
                n8 = temporalAccessor.get(ChronoField.SECOND_OF_MINUTE);
            }
            if (temporalAccessor.isSupported(ChronoField.DAY_OF_MONTH)) {
                n5 = temporalAccessor.get(ChronoField.DAY_OF_MONTH);
            }
            if (temporalAccessor.isSupported(ChronoField.MONTH_OF_YEAR)) {
                n6 = temporalAccessor.get(ChronoField.MONTH_OF_YEAR);
            }
            if (temporalAccessor.isSupported(ChronoField.YEAR)) {
                n7 = temporalAccessor.get(ChronoField.YEAR);
            }
            GregorianCalendar gregorianCalendar = null;
            gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(n3 * 1000, ""));
            gregorianCalendar.clear();
            gregorianCalendar.set(11, n10);
            gregorianCalendar.set(12, n9);
            gregorianCalendar.set(13, n8);
            gregorianCalendar.set(5, n5);
            gregorianCalendar.set(2, n6 - 1);
            gregorianCalendar.set(1, n7);
            int n11 = Integer.toString(n4).length();
            for (int i = 0; i < 9 - n11; ++i) {
                n4 *= 10;
            }
            Timestamp timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
            timestamp.setNanos(n4);
            switch (n) {
                case 93: {
                    return timestamp;
                }
                case 92: {
                    gregorianCalendar.set(this.connection.baseYear(), 0, 1);
                    timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
                    timestamp.setNanos(n4);
                    return new Timestamp(timestamp.getTime());
                }
                case 91: {
                    return new Date(timestamp.getTime());
                }
                case -155: {
                    return DateTimeOffset.valueOf(timestamp, n3 / 60);
                }
            }
        }
        catch (ArithmeticException | DateTimeException runtimeException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_ParsingError"));
            Object[] objectArray = new Object[]{JDBCType.of(n)};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        return string;
    }

    private Object getTemporalObjectFromCSV(Object object, int n, int n2) throws SQLServerException {
        if (2013 == n) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnsupportedDataTypeAE"));
            Object[] objectArray = new Object[]{"TIME_WITH_TIMEZONE"};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        if (2014 == n) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnsupportedDataTypeAE"));
            Object[] objectArray = new Object[]{"TIMESTAMP_WITH_TIMEZONE"};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        String string = null;
        String string2 = null;
        if (null != object && object instanceof String) {
            string2 = (String)object;
            string = string2.trim();
        }
        if (null == string) {
            switch (n) {
                case 92: 
                case 93: {
                    return null;
                }
                case 91: {
                    return null;
                }
                case -155: {
                    return null;
                }
            }
        }
        GregorianCalendar gregorianCalendar = null;
        DateTimeFormatter dateTimeFormatter = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n2)).dateTimeFormatter;
        if (null != dateTimeFormatter) {
            return this.getTemporalObjectFromCSVWithFormatter(string2, n, n2, dateTimeFormatter);
        }
        try {
            switch (n) {
                case 93: {
                    return Timestamp.valueOf(string);
                }
                case 92: {
                    String string3 = this.connection.baseYear() + "-01-01 " + string;
                    Timestamp timestamp = Timestamp.valueOf(string3);
                    return timestamp;
                }
                case 91: {
                    return Date.valueOf(string);
                }
                case -155: {
                    int n3 = string.indexOf(45, 0);
                    int n4 = Integer.parseInt(string.substring(0, n3));
                    int n5 = ++n3;
                    n3 = string.indexOf(45, n5);
                    int n6 = Integer.parseInt(string.substring(n5, n3));
                    n5 = ++n3;
                    n3 = string.indexOf(32, n5);
                    int n7 = Integer.parseInt(string.substring(n5, n3));
                    n5 = ++n3;
                    n3 = string.indexOf(58, n5);
                    int n8 = Integer.parseInt(string.substring(n5, n3));
                    n5 = ++n3;
                    n3 = string.indexOf(58, n5);
                    int n9 = Integer.parseInt(string.substring(n5, n3));
                    n5 = ++n3;
                    n3 = string.indexOf(46, n5);
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    boolean bl = false;
                    boolean bl2 = false;
                    int n13 = 0;
                    if (-1 != n3) {
                        n10 = Integer.parseInt(string.substring(n5, n3));
                        ++n3;
                        n5 = n3;
                        if (-1 != (n3 = string.indexOf(32, n5))) {
                            n12 = Integer.parseInt(string.substring(n5, n3));
                            n13 = n3 - n5;
                            bl2 = true;
                        } else {
                            n12 = Integer.parseInt(string.substring(n5));
                            n13 = string.length() - n5;
                        }
                    } else {
                        n3 = string.indexOf(32, n5);
                        if (-1 != n3) {
                            bl2 = true;
                            n10 = Integer.parseInt(string.substring(n5, n3));
                        } else {
                            n10 = Integer.parseInt(string.substring(n5));
                            n5 = ++n3;
                        }
                    }
                    if (bl2) {
                        if ('+' == string.charAt(n5 = ++n3)) {
                            ++n5;
                        } else if ('-' == string.charAt(n5)) {
                            bl = true;
                            ++n5;
                        }
                        n3 = string.indexOf(58, n5);
                        int n14 = Integer.parseInt(string.substring(n5, n3));
                        n5 = ++n3;
                        int n15 = Integer.parseInt(string.substring(n5));
                        n11 = n14 * 60 + n15;
                        if (bl) {
                            n11 = -n11;
                        }
                    }
                    gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(n11 * 60 * 1000, ""), Locale.US);
                    gregorianCalendar.clear();
                    gregorianCalendar.set(11, n8);
                    gregorianCalendar.set(12, n9);
                    gregorianCalendar.set(13, n10);
                    gregorianCalendar.set(5, n7);
                    gregorianCalendar.set(2, n6 - 1);
                    gregorianCalendar.set(1, n4);
                    for (int i = 0; i < 9 - n13; ++i) {
                        n12 *= 10;
                    }
                    Timestamp timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
                    timestamp.setNanos(n12);
                    return DateTimeOffset.valueOf(timestamp, n11);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_ParsingError"));
            Object[] objectArray = new Object[]{JDBCType.of(n)};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        catch (NumberFormatException numberFormatException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_ParsingError"));
            Object[] objectArray = new Object[]{JDBCType.of(n)};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_ParsingError"));
            Object[] objectArray = new Object[]{JDBCType.of(n)};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        return object;
    }

    private byte[] getEncryptedTemporalBytes(TDSWriter tDSWriter, JDBCType jDBCType, Object object, int n, int n2) throws SQLServerException {
        long l = 0L;
        GregorianCalendar gregorianCalendar = null;
        switch (jDBCType) {
            case DATE: {
                gregorianCalendar = new GregorianCalendar(TimeZone.getDefault(), Locale.US);
                gregorianCalendar.setLenient(true);
                gregorianCalendar.clear();
                gregorianCalendar.setTimeInMillis(((Date)object).getTime());
                return tDSWriter.writeEncryptedScaledTemporal(gregorianCalendar, 0, 0, SSType.DATE, (short)0);
            }
            case TIME: {
                gregorianCalendar = new GregorianCalendar(TimeZone.getDefault(), Locale.US);
                gregorianCalendar.setLenient(true);
                gregorianCalendar.clear();
                l = ((Timestamp)object).getTime();
                gregorianCalendar.setTimeInMillis(l);
                int n3 = 0;
                if (object instanceof Timestamp) {
                    n3 = ((Timestamp)object).getNanos();
                } else {
                    n3 = 1000000 * (int)(l % 1000L);
                    if (n3 < 0) {
                        n3 += 1000000000;
                    }
                }
                return tDSWriter.writeEncryptedScaledTemporal(gregorianCalendar, n3, n2, SSType.TIME, (short)0);
            }
            case TIMESTAMP: {
                gregorianCalendar = new GregorianCalendar(TimeZone.getDefault(), Locale.US);
                gregorianCalendar.setLenient(true);
                gregorianCalendar.clear();
                l = ((Timestamp)object).getTime();
                gregorianCalendar.setTimeInMillis(l);
                int n4 = ((Timestamp)object).getNanos();
                return tDSWriter.writeEncryptedScaledTemporal(gregorianCalendar, n4, n2, SSType.DATETIME2, (short)0);
            }
            case DATETIME: 
            case SMALLDATETIME: {
                gregorianCalendar = new GregorianCalendar(TimeZone.getDefault(), Locale.US);
                gregorianCalendar.setLenient(true);
                gregorianCalendar.clear();
                l = ((Timestamp)object).getTime();
                gregorianCalendar.setTimeInMillis(l);
                int n5 = ((Timestamp)object).getNanos();
                return tDSWriter.getEncryptedDateTimeAsBytes(gregorianCalendar, n5, jDBCType);
            }
            case DATETIMEOFFSET: {
                DateTimeOffset dateTimeOffset = (DateTimeOffset)object;
                l = dateTimeOffset.getTimestamp().getTime();
                int n6 = dateTimeOffset.getTimestamp().getNanos();
                int n7 = dateTimeOffset.getMinutesOffset();
                gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                gregorianCalendar.setLenient(true);
                gregorianCalendar.clear();
                gregorianCalendar.setTimeInMillis(l);
                return tDSWriter.writeEncryptedScaledTemporal(gregorianCalendar, n6, n2, SSType.DATETIMEOFFSET, (short)n7);
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnsupportedDataTypeAE"));
        Object[] objectArray = new Object[]{jDBCType};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    private byte[] normalizedValue(JDBCType jDBCType, Object object, JDBCType jDBCType2, int n, int n2) throws SQLServerException {
        Long l = null;
        byte[] byArray = null;
        try {
            switch (jDBCType) {
                case BIT: {
                    l = (Boolean)object != false ? 1L : 0L;
                    return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(l).array();
                }
                case TINYINT: 
                case SMALLINT: {
                    switch (jDBCType2) {
                        case BIT: {
                            l = new Long((Boolean)object != false ? 1L : 0L);
                            break;
                        }
                        default: {
                            if (object instanceof Integer) {
                                int n3 = (Integer)object;
                                short s = (short)n3;
                                l = new Long(s);
                                break;
                            }
                            l = new Long(((Short)object).shortValue());
                        }
                    }
                    return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(l).array();
                }
                case INTEGER: {
                    switch (jDBCType2) {
                        case BIT: {
                            l = new Long((Boolean)object != false ? 1L : 0L);
                            break;
                        }
                        case TINYINT: 
                        case SMALLINT: {
                            l = new Long(((Short)object).shortValue());
                            break;
                        }
                        default: {
                            l = new Long(((Integer)object).intValue());
                        }
                    }
                    return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(l).array();
                }
                case BIGINT: {
                    switch (jDBCType2) {
                        case BIT: {
                            l = new Long((Boolean)object != false ? 1L : 0L);
                            break;
                        }
                        case TINYINT: 
                        case SMALLINT: {
                            l = new Long(((Short)object).shortValue());
                            break;
                        }
                        case INTEGER: {
                            l = new Long(((Integer)object).intValue());
                            break;
                        }
                        default: {
                            l = new Long((Long)object);
                        }
                    }
                    return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(l).array();
                }
                case BINARY: 
                case VARBINARY: 
                case LONGVARBINARY: {
                    byte[] byArray2 = null;
                    byArray2 = object instanceof String ? ParameterUtils.HexToBin((String)object) : (byte[])object;
                    if (byArray2.length > n) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidDataForAE"));
                        Object[] objectArray = new Object[]{jDBCType2, jDBCType};
                        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
                    }
                    return byArray2;
                }
                case GUID: {
                    return Util.asGuidByteArray(UUID.fromString((String)object));
                }
                case CHAR: 
                case VARCHAR: 
                case LONGVARCHAR: {
                    if (((String)object).length() > n) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidDataForAE"));
                        Object[] objectArray = new Object[]{jDBCType2, jDBCType};
                        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
                    }
                    return ((String)object).getBytes(Charset.forName("UTF-8"));
                }
                case NCHAR: 
                case NVARCHAR: 
                case LONGNVARCHAR: {
                    if (((String)object).length() > n) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidDataForAE"));
                        Object[] objectArray = new Object[]{jDBCType2, jDBCType};
                        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
                    }
                    return ((String)object).getBytes(Charset.forName("UTF-16LE"));
                }
                case REAL: 
                case FLOAT: {
                    Float f = Float.valueOf(object instanceof String ? Float.parseFloat((String)object) : ((Float)object).floatValue());
                    return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(f.floatValue()).array();
                }
                case DOUBLE: {
                    Double d = object instanceof String ? Double.parseDouble((String)object) : (Double)object;
                    return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(d).array();
                }
                case NUMERIC: 
                case DECIMAL: {
                    int n4 = ((BigDecimal)object).scale();
                    int n5 = ((BigDecimal)object).precision();
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (n5 > n || n4 > n2) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidDataForAE"));
                        Object[] objectArray = new Object[]{jDBCType2, jDBCType};
                        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
                    }
                    if (n4 < n2) {
                        bigDecimal = bigDecimal.setScale(n2);
                    }
                    byArray = DDC.convertBigDecimalToBytes(bigDecimal, bigDecimal.scale());
                    byte[] byArray3 = new byte[16];
                    System.arraycopy(byArray, 2, byArray3, 0, byArray.length - 2);
                    return byArray3;
                }
                case SMALLMONEY: 
                case MONEY: {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    Util.validateMoneyRange(bigDecimal, jDBCType);
                    int n6 = bigDecimal.precision() - bigDecimal.scale() + 4;
                    long l2 = ((BigDecimal)object).multiply(new BigDecimal(10000), new MathContext(n6, RoundingMode.HALF_UP)).longValue();
                    ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
                    byteBuffer.putInt((int)(l2 >> 32)).array();
                    byteBuffer.putInt((int)l2).array();
                    return byteBuffer.array();
                }
            }
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnsupportedDataTypeAE"));
            Object[] objectArray = new Object[]{jDBCType};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        catch (NumberFormatException numberFormatException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidDataForAE"));
            Object[] objectArray = new Object[]{jDBCType2, jDBCType};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidDataForAE"));
            Object[] objectArray = new Object[]{jDBCType2, jDBCType};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
    }

    private boolean goToNextRow() throws SQLServerException {
        try {
            if (null != this.sourceResultSet) {
                return this.sourceResultSet.next();
            }
            return this.sourceBulkRecord.next();
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), sQLException);
        }
    }

    private final boolean writeBatchData(TDSWriter tDSWriter) throws SQLServerException {
        int n = this.copyOptions.getBatchSize();
        int n2 = 0;
        while (0 == n || n2 < n) {
            if (!this.goToNextRow()) {
                return false;
            }
            tDSWriter.writeByte((byte)-47);
            int n3 = this.columnMappings.size();
            if (null != this.sourceResultSet) {
                for (int i = 0; i < n3; ++i) {
                    this.writeColumn(tDSWriter, this.columnMappings.get((int)i).sourceColumnOrdinal, this.columnMappings.get((int)i).destinationColumnOrdinal, null);
                }
            } else {
                Object[] objectArray = this.sourceBulkRecord.getRowData();
                for (int i = 0; i < n3; ++i) {
                    this.writeColumn(tDSWriter, this.columnMappings.get((int)i).sourceColumnOrdinal, this.columnMappings.get((int)i).destinationColumnOrdinal, objectArray[this.columnMappings.get((int)i).sourceColumnOrdinal - 1]);
                }
            }
            ++n2;
        }
        return true;
    }

    private final class BulkTimeoutTimer
    implements Runnable {
        private final int timeoutSeconds;
        private int secondsRemaining;
        private final TDSCommand command;
        private Thread timerThread;
        private volatile boolean canceled = false;

        BulkTimeoutTimer(int n, TDSCommand tDSCommand) {
            assert (n > 0);
            assert (null != tDSCommand);
            this.timeoutSeconds = n;
            this.secondsRemaining = n;
            this.command = tDSCommand;
        }

        final void start() {
            this.timerThread = new Thread(this);
            this.timerThread.setDaemon(true);
            this.timerThread.start();
        }

        final void stop() {
            this.canceled = true;
            this.timerThread.interrupt();
        }

        final boolean expired() {
            return this.secondsRemaining <= 0;
        }

        @Override
        public void run() {
            try {
                do {
                    if (this.canceled) {
                        return;
                    }
                    Thread.sleep(1000L);
                } while (--this.secondsRemaining > 0);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            try {
                this.command.interrupt(SQLServerException.getErrString("R_queryTimedOut"));
            }
            catch (SQLServerException sQLServerException) {
                this.command.log(Level.FINE, "Command could not be timed out. Reason: " + sQLServerException.getMessage());
            }
        }
    }

    class BulkColumnMetaData {
        String columnName;
        SSType ssType = null;
        int jdbcType;
        int precision;
        int scale;
        SQLCollation collation;
        byte[] flags = new byte[2];
        boolean isIdentity = false;
        boolean isNullable;
        String collationName;
        CryptoMetadata cryptoMeta = null;
        DateTimeFormatter dateTimeFormatter = null;
        String encryptionType = null;

        BulkColumnMetaData(Column column) throws SQLServerException {
            this.cryptoMeta = column.getCryptoMetadata();
            TypeInfo typeInfo = column.getTypeInfo();
            this.columnName = column.getColumnName();
            this.ssType = typeInfo.getSSType();
            this.flags = typeInfo.getFlags();
            this.isIdentity = typeInfo.isIdentity();
            this.isNullable = typeInfo.isNullable();
            this.precision = typeInfo.getPrecision();
            this.scale = typeInfo.getScale();
            this.collation = typeInfo.getSQLCollation();
            this.jdbcType = this.ssType.getJDBCType().getIntValue();
        }

        BulkColumnMetaData(String string, boolean bl, int n, int n2, int n3, DateTimeFormatter dateTimeFormatter) throws SQLServerException {
            this.columnName = string;
            this.isNullable = bl;
            this.precision = n;
            this.scale = n2;
            this.jdbcType = n3;
            this.dateTimeFormatter = dateTimeFormatter;
        }

        BulkColumnMetaData(Column column, String string, String string2) throws SQLServerException {
            this(column);
            this.collationName = string;
            this.encryptionType = string2;
        }

        BulkColumnMetaData(BulkColumnMetaData bulkColumnMetaData, CryptoMetadata cryptoMetadata) {
            this.columnName = bulkColumnMetaData.columnName;
            this.isNullable = bulkColumnMetaData.isNullable;
            this.precision = bulkColumnMetaData.precision;
            this.scale = bulkColumnMetaData.scale;
            this.jdbcType = bulkColumnMetaData.jdbcType;
            this.cryptoMeta = cryptoMetadata;
        }
    }

    private class ColumnMapping {
        String sourceColumnName = null;
        int sourceColumnOrdinal = -1;
        String destinationColumnName = null;
        int destinationColumnOrdinal = -1;

        ColumnMapping(String string, String string2) {
            this.sourceColumnName = string;
            this.destinationColumnName = string2;
        }

        ColumnMapping(String string, int n) {
            this.sourceColumnName = string;
            this.destinationColumnOrdinal = n;
        }

        ColumnMapping(int n, String string) {
            this.sourceColumnOrdinal = n;
            this.destinationColumnName = string;
        }

        ColumnMapping(int n, int n2) {
            this.sourceColumnOrdinal = n;
            this.destinationColumnOrdinal = n2;
        }
    }
}

