# 概念
文本聚类（Text clustering）文档聚类主要是依据著名的聚类假设：同类的文档相似度较大，而不同类的文档相似度较小。作为一种无监督的机器学习方法，聚类由于不需要训练过程，以及不需要预先对文档手工标注类别，因此具有一定的灵活性和较高的自动化处理能力，已经成为对文本信息进行有效地组织、摘要和导航的重要手段，为越来越多的研究人员所关注。

# 数据集
本文演示用的数据集，依然使用搜狗新闻数据集SogouCS。我们从SogouCS中提取正文内容，每个URL对应的正文当做一篇文档，并且使用jieba进行了分词。演示期间我们提取SogouCS的前10000条数据用于计算LDA。
# 特征提取
通常会在LDA的基础上进行文本聚类，即把文本内容删除停用词、提取词袋并进行TFIDF后再使用LDA算法转换成若干主题的概率分布，然后使用聚类算法分析。关于LDA的内容请参考本书中关于使用LDA进行文档主题建模的章节。

	lda = models.ldamulticore.LdaMulticore(corpus=texts_tf_idf, id2word=dictionary, num_topics=num_topics)

# 衡量指标
无监督学习的性能衡量方式不像监督学习那样直观，目前常见的衡量方式包括一下几种：
## 轮廓系数
聚类中还有一种评估方法，叫轮廓系数。轮廓系数综合了聚类后的两项因素：内聚度和分离度。内聚度就指一个样本在簇内的不相似度，而分离度就指一个样本在簇间的不相似度。在scikit-learn中，同样也提供了直接计算轮廓系数的方法。

	from sklearn.metrics import silhouette_score
	
# 聚类算法

常用于文本聚类的算法包括kmeans、dbscan等。

## dbscan
dbscan（Density-Based Spatial Clustering of Applications with Noise，具有噪声的基于密度的聚类方法）是一种基于密度的空间聚类算法。该算法将具有足够密度的区域划分为簇，并在具有噪声的空间数据库中发现任意形状的簇，它将簇定义为密度相连的点的最大集合。该算法利用基于密度的聚类的概念，即要求聚类空间中的一定区域内所包含对象（点或其他空间对象）的数目不小于某一给定阈值。dbscan算法的显著优点是聚类速度快且能够有效处理噪声点和发现任意形状的空间聚类。

# 参考文献