# 概述
数据和算法在NLP中都非常重要，使用公开的数据集可以帮助我们快速学习NLP相关知识并实践，下面我们将介绍常用的几个数据集。

# 搜狗实验室数据

![常用数据集简介-图1](picture/常用数据集简介-图1.png "搜狗实验室数据")

搜狗实验室（Sogo Labs）是搜狗搜索核心研发团队对外交流的窗口，包含数据资源、数据挖掘云、研究合作等几个栏目。数据资源包括评测集合、语料数据、新闻数据、图片数据和自然语言处理相关数据，网址为：
> http://www.sogou.com/labs/resource/list_pingce.php

## 互联网语料库(SogouT)

SogouT来自互联网各种类型的1.3亿个原始网页, 压缩前的大小超过了5TB，格式如下：
	
	<doc>
	
	<docno>页面ID</docno>
	
	<url>页面URL</url>
	
	页面原始内容
	
	</doc>

为了满足不同需求，SogouT分为了不同的版本，差别体现在数据量上：

- 迷你版(样例数据, 61KB)：tar.gz格式,zip格式
- 完整版(1TB)：(硬盘拷贝)
- 历史版本(130GB)：V2.0(硬盘拷贝)


## 全网新闻数据(SogouCA)

SogouCA来自若干新闻站点2012年6月—7月期间国内，国际，体育，社会，娱乐等18个频道的新闻数据，提供URL和正文信息，格式如下：

	<doc>
	
	<url>页面URL</url>
	
	<docno>页面ID</docno>
	
	<contenttitle>页面标题</contenttitle>
	
	<content>页面内容</content>
	
	</doc>

为了满足不同需求，SogouCA分为了不同的版本，差别体现在数据量上：

- 迷你版(样例数据, 101KB)：tar.gz格式，zip格式
- 完整版(711MB)：tar.gz格式，zip格式
- 历史版本：
	- 完整版(同时提供硬盘拷贝,1.02GB)：tar.gz格式
	- 迷你版(样例数据, 3KB)：tar.gz格式
	- 精简版(一个月数据, 437MB)：tar.gz格式
	
## 搜狐新闻数据(SogouCS)

SogouCS来自搜狐新闻2012年6月—7月期间国内，国际，体育，社会，娱乐等18个频道的新闻数据，提供URL和正文信息，格式如下：

	<doc>
	
	<url>页面URL</url>
	
	<docno>页面ID</docno>
	
	<contenttitle>页面标题</contenttitle>
	
	<content>页面内容</content>
	
	</doc>

为了满足不同需求，SogouCS分为了不同的版本，差别体现在数据量上：

- 迷你版(样例数据, 110KB)：tar.gz格式，zip格式
- 完整版(648MB)：tar.gz格式，zip格式
- 历史版本：
	- 完整版(同时提供硬盘拷贝,65GB)：tar.gz格式
	- 迷你版(样例数据, 1KB)：tar.gz格式
	- 精简版(一个月数据, 347MB)：tar.gz格式
	- 特别版(王灿辉WWW08论文数据, 647KB)：tar.gz格式

## 文本分类评价(SogouTCE)

SogouTCE用以评估文本分类结果的正确性，语料来自搜狐等多个新闻网站近20个频道，格式如下：

	URL前缀\t对应类别标记

SogouTCE只包含URL前缀和对应类别标记的数据，原始的文本数据可以使用SogouCA和SogouCS。

## 互联网词库(SogouW)

SogouW来自于对SOGOU搜索引擎所索引到的中文互联网语料的统计分析，统计所进行的时间是2006年10月，涉及到的互联网语料规模在1亿页面以上。统计出的词条数约为15万条高频词，除标出这部分词条的词频信息之外，还标出了常用的词性信息，格式如下：

	词A 词频 词性1 词性2 … 词性N
	
	词B 词频 词性1 词性2 … 词性N
	
	词C 词频 词性1 词性2 … 词性N
	
# IMDB Reviews

互联网电影资料库（Internet Movie Database，简称IMDB）是一个关于电影演员、电影、电视节目、电视明星和电影制作的在线数据库。IMDB Reviews是记录了观众对IMDB中作品的评价。除了训练和测试评估示例之外，还有更多未标记的数据可供使用，包括文本和预处理的词袋格式。IMDB Reviews包含25,000个高度差异化的电影评论用于训练，25,000个测试，通常用于英文的情感理解。

# Sentiment140
Sentiment140是一个可用于情感分析的数据集，包含160,000条推文。一个流行的数据集，非常适合开始你的NLP旅程。情绪已经从数据中预先移除。最终的数据集具有以下6个特征：	

- 推文的极性
- 推文的ID
- 推文的日期
- 问题
- 推文的用户名
- 推文的文本

# Yelp Reviews
Yelp Reviews是Yelp为了学习目的而发布的一个开源数据集。它包含了由数百万用户评论，商业属性和来自多个大都市地区的超过20万张照片。这是一个常用的全球NLP挑战数据集，包含5,200,000条评论，174,000条商业属性。
数据集下载地址为：


>https://www.yelp.com/dataset/download

![常用数据集简介-图5](picture/常用数据集简介-图5.png)

数据集格式分为JSON和SQL两种，以JSON格式为例,其中最重要的review.json,包含评论数据，格式如下：


		{
	    // string, 22 character unique review id
	    "review_id": "zdSx_SD6obEhz9VrW9uAWA",
	
	    // string, 22 character unique user id, maps to the user in user.json
	    "user_id": "Ha3iJu77CxlrFm-vQRs_8g",
	
	    // string, 22 character business id, maps to business in business.json
	    "business_id": "tnhfDv5Il8EaGSXZGiuQGg",
	
	    // integer, star rating
	    "stars": 4,
	
	    // string, date formatted YYYY-MM-DD
	    "date": "2016-03-09",
	
	    // string, the review itself
	    "text": "Great place to hang out after work: the prices are decent, and the ambience is fun. It's a bit loud, but very lively. The staff is friendly, and the food is good. They have a good selection of drinks.",
	
	    // integer, number of useful votes received
	    "useful": 0,
	
	    // integer, number of funny votes received
	    "funny": 0,
	
	    // integer, number of cool votes received
	    "cool": 0}

另外tip.json文件记录了短评数据，格式如下：

	{
	    // string, text of the tip
	    "text": "Secret menu - fried chicken sando is da bombbbbbb Their zapatos are good too.",
	
	    // string, when the tip was written, formatted like YYYY-MM-DD
	    "date": "2013-09-20",
	
	    // integer, how many likes it has
	    "likes": 172,
	
	    // string, 22 character business id, maps to business in business.json
	    "business_id": "tnhfDv5Il8EaGSXZGiuQGg",
	
	    // string, 22 character unique user id, maps to the user in user.json
	    "user_id": "49JhAJh8vSQ-vM4Aourl0g"
	}

专门有个开源项目用于解析该JSON文件：

>https://github.com/Yelp/dataset-examples

# Enron-Spam
Enron-Spam数据集是目前在电子邮件相关研究中使用最多的公开数据集，其邮件数据是安然公司（Enron Corporation, 原是世界上最大的综合性天然气和电力公司之一，在北美地区是头号天然气和电力批发销售商）150位高级管理人员的往来邮件。这些邮件在安然公司接受美国联邦能源监管委员会调查时被其公布到网上。机器学习领域使用Enron-Spam数据集来研究文档分类、词性标注、垃圾邮件识别等，由于Enron-Spam数据集都是真实环境下的真实邮件，非常具有实际意义。
Enron-Spam数据集合如下图所示，使用不同文件夹区分正常邮件和垃圾邮件。

![常用数据集简介-图3.png](picture/常用数据集简介-图3.png "Enron-Spam数据集文件夹结构")

正常邮件内容举例如下：

>
Subject: christmas baskets
the christmas baskets have been ordered .
we have ordered several baskets .
individual earth - sat freeze - notis
smith barney group baskets
rodney keys matt rodgers charlie
notis jon davis move
team
phillip randle chris hyde
harvey
freese
faclities

垃圾邮件内容举例如下：

>
Subject: fw : this is the solution i mentioned lscoo
thank you ,
your email address was obtained from a purchased list ,reference # 2020 mid = 3300 . if you wish to unsubscribe
from this list , please click here and enter
your name into the remove box . if you have previously unsubscribed
and are still receiving this message , you may email our abuse
control center , or call 1 - 888 - 763 - 2497 , or write us at : nospam ,
6484 coral way , miami , fl , 33155 " . 2002
web credit inc . all rights reserved .


Enron-Spam数据集对应的网址为：

>
http://www2.aueb.gr/users/ion/data/enron-spam/


# babi阅读理解数据集

babi是来自FAIR（Facebook AI Research）的合成式阅读理解与问答数据集，是个入门级的阅读理解数据集，其训练集以对话集合[2] + 问题[1] + 回答[1]的形式组成：

	1 Mary moved to the bathroom.
	2 John went to the hallway.
	3 Where is Mary?     bathroom    1
	4 Daniel went back to the hallway.
	5 Sandra moved to the garden.
	6 Where is Daniel?     hallway    4
	7 John moved to the office.
	8 Sandra journeyed to the bathroom.
	9 Where is Daniel?     hallway    4
	10 Mary moved to the hallway.
	11 Daniel travelled to the office.
	12 Where is Daniel?     office    11
	13 John went back to the garden.
	14 John moved to the bedroom.
	15 Where is Sandra?     bathroom    8
	1 Sandra travelled to the office.
	2 Sandra went to the bathroom.
	3 Where is Sandra?     bathroom    2
	4 Mary went to the bedroom.
	5 Daniel moved to the hallway.
	6 Where is Sandra?     bathroom    2
	7 John went to the garden.
	8 John travelled to the office.
	9 Where is Sandra?     bathroom    2
	10 Daniel journeyed to the bedroom.
	11 Daniel travelled to the hallway.
	12 Where is John?     office    8

抽象表示格式为：

	ID text
	ID text
	ID text
	ID question[tab]answer[tab]supporting fact IDS.
	
项目主页地址为：

> https://research.fb.com/downloads/babi/

数据下载地址为：

> http://www.thespermwhale.com/jaseweston/babi/tasks_1-20_v1.tar.gz

下载压缩包，解压后，全部文件保存在en文件下，文件夹下包含以下文件：

	qa10_indefinite-knowledge_test.txt	
	qa1_single-supporting-fact_test.txt
	qa10_indefinite-knowledge_train.txt	
	qa1_single-supporting-fact_train.txt
	qa11_basic-coreference_test.txt		
	qa20_agents-motivations_test.txt
	qa11_basic-coreference_train.txt	
	qa20_agents-motivations_train.txt
	qa12_conjunction_test.txt		
	qa2_two-supporting-facts_test.txt
	qa12_conjunction_train.txt		
	qa2_two-supporting-facts_train.txt
	qa13_compound-coreference_test.txt	
	qa3_three-supporting-facts_test.txt
	qa13_compound-coreference_train.txt	
	qa3_three-supporting-facts_train.txt
	qa14_time-reasoning_test.txt		
	qa4_two-arg-relations_test.txt
	qa14_time-reasoning_train.txt		
	qa4_two-arg-relations_train.txt
	qa15_basic-deduction_test.txt		
	qa5_three-arg-relations_test.txt
	qa15_basic-deduction_train.txt		
	qa5_three-arg-relations_train.txt
	qa16_basic-induction_test.txt		
	qa6_yes-no-questions_test.txt
	qa16_basic-induction_train.txt		
	qa6_yes-no-questions_train.txt
	qa17_positional-reasoning_test.txt
	qa7_counting_test.txt
	qa17_positional-reasoning_train.txt
	qa7_counting_train.txt
	qa18_size-reasoning_test.txt		
	qa8_lists-sets_test.txt
	qa18_size-reasoning_train.txt		
	qa8_lists-sets_train.txt
	qa19_path-finding_test.txt		
	qa9_simple-negation_test.txt
	qa19_path-finding_train.txt		
	qa9_simple-negation_train.txt
	
# SMS Spam Collection
SMS Spam Collection是用于骚扰短信识别的经典数据集，完全来自真实短信内容，包括4831条正常短信和747条骚扰短信。从官网下载数据集压缩包，解压，正常短信和骚扰短信保存在一个文本文件中。
每行完整记录一条短信内容，每行开头通过ham和spam标识正常短信和骚扰短信，数据集文件内容举例如下：
>
ham What you doing?how are you?  
ham Ok lar... Joking wif u oni...  
ham dun say so early hor... U c already then say...  
ham MY NO. IN LUTON 0125698789 RING ME IF UR AROUND! H*  
ham Siva is in hostel aha:-.  
ham Cos i was out shopping wif darren jus now n i called him 2 ask wat present he wan lor. Then he started guessing who i was wif n he finally guessed darren lor.  
spam FreeMsg: Txt: CALL to No: 86888 & claim your reward of 3 hours talk time to use from your phone now! ubscribe6GBP/ mnth inc 3hrs 16 stop?txtStop  
spam Sunshine Quiz! Win a super Sony DVD recorder if you canname the capital of Australia? Text MQUIZ to 82277. B  
spam URGENT! Your Mobile No 07808726822 was awarded a L2,000 Bonus Caller Prize on 02/09/03! This is our 2nd attempt to contact YOU! Call 0871-872-9758 BOX95QU

SMS Spam Collection数据集主页地址为：
>http://archive.ics.uci.edu/ml/datasets/SMS+Spam+Collection

![常用数据集](picture/常用数据集-图4.png)

# UBUNTU DIALOG CORPUS
UBUNTU DIALOG CORPUS（UDC）是可用的最大的公共对话数据集之一,下载地址为：

>cs.mcgill.ca/~jpineau/datasets/ubuntu-corpus-1.0/ubuntu_dialogs.tgz

它基于公共IRC网络上的Ubuntu频道的聊天记录。训练数据包括100万个样例，50％的正样例（标签1）和50％的负样例（标签0）。每个样例都包含一个上下文,即直到这一点的谈话记录,以及一个话语，即对上下文的回应。一个正标签意味着话语是对当前语境上下文的实际响应，一个负标签意味着这个话语不是真实的响应 ,它是从语料库的某个地方随机挑选出来的。这是一些示例数据：

![常用数据集简介-图8](picture/常用数据集简介-图8.png)

UDC相关的经典论文地址为：

>https://arxiv.org/abs/1506.08909

UDC相关的Github地址为：

>https://github.com/rkadlec/ubuntu-ranking-dataset-creator

# Hate speech identification
Hate speech identification由ICWSM 2017论文“自动仇恨语音检测和无礼语言问题”的作者提供。包含3类短文本：

- 包含仇恨言论；
- 是冒犯性的，但没有仇恨言论；
- 根本没有冒犯性。

由15,000行文本构成，每个字符串都经过3人判断。

下载链接为：

>https://github.com/t-davidson/hate-speech-and-offensive-language

# Twitter Progressive issues sentiment analysis

Twitter Progressive issues sentiment analysis是关于诸如堕胎合法化、女权主义、希拉里·克林顿等各种左倾问题的推文，分为赞成、反对或保持中立的三种类别。

下载链接为：

>https://www.figure-eight.com/data-for-everyone/

# 今日头条新闻文本分类数据集
今日头条新闻文本分类数据集共382688条，分布于15个分类中，分类code与名称：

- 100 民生 故事 news_story
- 101 文化 文化 news_culture
- 102 娱乐 娱乐 news_entertainment
- 103 体育 体育 news_sports
- 104 财经 财经 news_finance
- 106 房产 房产 news_house
- 107 汽车 汽车 news_car
- 108 教育 教育 news_edu 
- 109 科技 科技 news_tech
- 110 军事 军事 news_military
- 112 旅游 旅游 news_travel
- 113 国际 国际 news_world
- 114 证券 股票 stock
- 115 农业 三农 news_agriculture
- 116 电竞 游戏 news_game

数据格式为：

	6552431613437805063_!_102_!_news_entertainment_!_谢娜为李浩菲澄清网络谣言，
	
	之后她的两个行为给自己加分_!_佟丽娅,网络谣言,快乐大本营,李浩菲,谢娜,观众们

每行为一条数据，以_\!\_分割的个字段，从前往后分别是 新闻ID，分类code，分类名称，新闻字符串（仅含标题），新闻关键词.

项目主页在github上，运行get_data.py即可获取实时获取对应的数据。

	https://github.com/fateleak/toutiao-text-classfication-dataset
	
也可以直接使用github上的历史数据进行分析。

	https://github.com/fateleak/toutiao-text-classfication-dataset/raw/master/toutiao_cat_data.txt.zip