# FROM https://gist.githubusercontent.com/ksafranski/2973986/raw/5fda5e87189b066e11c1bf80bbfbecb556cf2cc1/Common-Currency.json
iso_4217_to_symbols = {
    "AED": ["د.إ", "AED"],
    "AFN": ["؋", "Af"],
    "ALL": ["ALL", "Lek"],
    "AMD": ["դր.", "AMD"],
    "ANG": ["ƒ", "NAf", "NAƒ"],
    "AOA": ["Kz"],
    "ARS": ["$", "AR$"],
    "AUD": ["$", "AU$"],
    "AZN": ["man.", "ман."],
    "BAM": ["KM"],
    "BDT": ["৳", "Tk"],
    "BGN": ["лв.", "BGN"],
    "BHD": ["BD", "৳"],
    "BIF": ["FBu"],
    "BND": ["BN$", "$"],
    "BOB": ["Bs"],
    "BRL": ["R$"],
    "BWP": ["BWP", "P"],
    "BYN": ["Br", "руб."],
    "BZD": ["$", "BZ$"],
    "CAD": ["$", "CA$"],
    "CDF": ["FrCD", "CDF"],
    "CHF": ["CHF"],
    "CLP": ["CL$", "$"],
    "CNY": ["CN¥"],
    "COP": ["CO$", "$"],
    "CRC": ["₡"],
    "CVE": ["CV$"],
    "CZK": ["Kč"],
    "DEM": ["DM", "DEM"],
    "DJF": ["Fdj"],
    "DKK": ["Dkr", "kr"],
    "DOP": ["RD$"],
    "DZD": ["دج", "DA"],
    "EEK": ["Ekr", "kr"],
    "EGP": ["EGP", "ج.م", "E£"],
    "ERN": ["Nfk"],
    "ESP": ["Pta", "Pt", "Pts", "Ptas"],
    "ETB": ["Br"],
    "EUR": ["€"],
    "FRF": ["FRF", "₣"],
    "GBP": ["£"],
    "GEL": ["GEL"],
    "GHS": ["GH₵"],
    "GNF": ["FG"],
    "GTQ": ["Q", "GTQ"],
    "HKD": ["$", "HK$"],
    "HNL": ["HNL", "L"],
    "HRK": ["kn"],
    "HUF": ["Ft"],
    "IDR": ["Rp"],
    "ILS": ["₪"],
    "INR": ["টকা", "Rs"],
    "IQD": ["IQD", "ع.د"],
    "IRR": ["IRR", "﷼"],
    "ISK": ["Ikr", "kr"],
    "JMD": ["J$", "$"],
    "JOD": ["د.ا", "JD"],
    "JPY": ["¥", "￥"],
    "KES": ["Ksh"],
    "KHR": ["៛", "KHR"],
    "KMF": ["CF", "FC"],
    "KPW": ["₩"],
    "KRW": ["₩"],
    "KWD": ["KD", "د.ك"],
    "KZT": ["KZT", "тңг."],
    "LBP": ["L.L.", "ل.ل"],
    "LKR": ["SLRs", "SL Re"],
    "LTL": ["Lt"],
    "LVL": ["Ls"],
    "LYD": ["LD", "ل.د"],
    "MAD": ["MAD"],
    "MDL": ["MDL"],
    "MGA": ["MGA"],
    "MKD": ["MKD"],
    "MMK": ["K", "MMK"],
    "MOP": ["MOP$"],
    "MUR": ["MURs"],
    "MXN": ["MX$", "$"],
    "MYR": ["RM"],
    "MZN": ["MTn"],
    "NAD": ["N$"],
    "NGN": ["₦"],
    "NIO": ["C$"],
    "NOK": ["Nkr", "kr"],
    "NPR": ["NPRs", "नेरू"],
    "NZD": ["$", "NZ$"],
    "OMR": ["ر.ع.", "OMR"],
    "PAB": ["B/."],
    "PEN": ["S/."],
    "PHP": ["₱"],
    "PKR": ["₨", "PKRs"],
    "PLN": ["zł"],
    "PYG": ["₲"],
    "QAR": ["QR", "ر.ق"],
    "RON": ["RON"],
    "RSD": ["дин.", "din."],
    "RUB": ["RUB", "₽."],
    "RWF": ["FR", "RWF"],
    "SAR": ["SR"],
    "SDG": ["SDG"],
    "SEK": ["Skr", "kr"],
    "SGD": ["$", "S$"],
    "SOS": ["Ssh"],
    "SYP": ["LS", "£S", "SY£"],
    "THB": ["฿"],
    "TND": ["د.ت", "DT"],
    "TOP": ["T$"],
    "TRY": ["TL"],
    "TTD": ["$", "TT$"],
    "TWD": ["NT$"],
    "TZS": ["TSh"],
    "UAH": ["₴"],
    "UGX": ["USh"],
    "USD": ["$"],
    "UYU": ["$", "$U"],
    "UZS": ["UZS"],
    "VEF": ["Bs.F."],
    "VES": ["Bs.D", "Bs."],
    "VND": ["₫"],
    "XAF": ["FCFA"],
    "XOF": ["CFA"],
    "YER": ["YR", "﷼"],
    "ZAR": ["R"],
    "ZMK": ["ZK"],
    "ZWL": ["ZWL$"],
}

