#!/bin/sh
#
# Create an obfuscated version of the awk source code
#

rm -rf awk
mkdir awk
cp ../example/awk/* awk/
cd awk
rm makefile
mv ytabc.bak ytab.c
mv ytabh.bak ytab.h
sed "/LC_MESSAGES/d" ../../example/awk/main.c >main.c
cat <<\EOF >extern.h
#include <stdio.h>

FILE * popen(const char *command, const char *type);
int pclose(FILE *stream);
extern char **environ;
EOF

rm buildwin.bat awkgram.y makefile.win mac.code

cat <<\EOF >README2
This is an obfuscated version of the One True Awk source code,
generated by the supported version of CScout <http://www.spinellis.gr/cscout>.
It demonstrates the idea of obfuscating the identifiers in program's C
source code, while leaving intact the identifiers of all system-related
facilities.
Such a form can be used to distribute proprietary code, in a format that
can compile under any supported operating system and processor architecture,
but remains difficult to reverse-engineer and modify.


To compile this version of awk under Unix, Linux, FreeBSD, Mac OS X,
or Cygwin run:
make

To compile awk under Microsoft's Visual Studio run:
nmake /f makefile.win

You can find an up-to-date version of the awk source code at
<http://www.cs.princeton.edu/~bwk/btl.mirror/>

Diomidis Spinellis - December 2008
EOF

cat <<\EOF >Makefile
CC=cc

OFILES = b.o lex.o lib.o main.o parse.o proctab.o run.o tran.o ytab.o

awk:	$(OFILES)
	$(CC) -o $@ $(CFLAGS) $(OFILES) -lm
EOF

cd ..
perl ../src/cswc.pl awk.prj >awk.cs
../src/build/cscout -o awk.cs
(cd awk ; for i in *.obf; do mv $i `basename $i .obf`; done)
