Public Class clsOrder
    Private sID As String                       'Hold Order ID
    Private sCustomerName As String             'Hold Customer Name
    Private sCustomerPhone As String            'Hold Customer Phone
    Private sOrderDate As Date                  'Holds Order Date
    Private sBillingStreet As String            'Hold Billing Street
    Private sBillingCity As String              'Hold Billing City
    Private sBillingState As String             'Hold Billing State
    Private sBillingZip As String               'Hold Billing Zip
    Private bCheckBox As Boolean                'Hold Check Box Option
    Private sShippingStreet As String           'Hold Shipping Street
    Private sShippingCity As String             'Hold Shipping City
    Private sShippingState As String            'Hold Shipping State
    Private sShippingZip As String              'Hold Shipping Zip
    Private bRadioButton As Boolean             'Hold Del option
    Private detailsList As ArrayList            'Hold the detail line items as an Arraylist
    Private sError As String                    'Hold any errors generated by this class

    Public Sub New()
        'Set our initial values
        sID = ""
        sCustomerName = ""
        sError = ""
        detailsList = New ArrayList
    End Sub

    '===================================================
    ' Object properties setters / getters
    '===================================================
    Public Property ID()
        'get and set the order id
        Get
            Return sID
        End Get
        Set(ByVal value)
            'Validation at class level
            If isValidID(value) = True Then
                sID = Convert.ToInt32(value)
            End If
        End Set
    End Property

    Public Property CustomerName()
        'Get and set the customer name
        Get
            Return sCustomerName
        End Get
        Set(ByVal value)
            'Validate, you can also add a try/catch
            If isValidName(value) Then
                sCustomerName = value
            End If
        End Set
    End Property

    Public Property CustomerPhone()
        'Get and set the customer name
        Get
            Return sCustomerPhone
        End Get
        Set(ByVal value)
            'Validate, you can also add a try/catch
            If isValidPhone(value) Then
                sCustomerPhone = value
            End If
        End Set
    End Property

    Public Property CustomerOrderDate()
        'Get and set the customer name
        Get
            Return sOrderDate
        End Get
        Set(ByVal value)
            'Validate, you can also add a try/catch
            If isValidDate(value) Then
                sOrderDate = value
            End If
        End Set
    End Property

    Public Property BillingStreet()
        'Get and set the customer name
        Get
            Return sBillingStreet
        End Get
        Set(ByVal value)
            'Validate, you can also add a try/catch
            If isValidBillingStreet(value) Then
                sBillingStreet = value
            End If
        End Set
    End Property

    Public Property BillingCity()
        'Get and set the customer name
        Get
            Return sBillingCity
        End Get
        Set(ByVal value)
            'Validate, you can also add a try/catch
            If isValidBillingCity(value) Then
                sBillingCity = value
            End If
        End Set
    End Property

    Public Property BillingState()
        'Get and set the customer name
        Get
            Return sBillingState
        End Get
        Set(ByVal value)
            'Validate, you can also add a try/catch
            If isValidBillingState(value) Then
                sBillingState = value
            End If
        End Set
    End Property

    Public Property BillingZip()
        'Get and set the customer name
        Get
            Return sBillingZip
        End Get
        Set(ByVal value)
            'Validate, you can also add a try/catch
            If isValidBillingZip(value) Then
                sBillingZip = value
            End If
        End Set
    End Property

    Public Property CheckBox()
        'Get and set the customer name
        Get
            Return bCheckBox
        End Get
        Set(ByVal value)
            bCheckBox = value
        End Set
    End Property

    Public Property ShippingStreet()
        'Get and set the customer name
        Get
            Return sShippingStreet
        End Get
        Set(ByVal value)
            'Validate, you can also add a try/catch
            If isValidShippingStreet(value) Then
                sShippingStreet = value
            End If
        End Set
    End Property

    Public Property ShippingCity()
        'Get and set the customer name
        Get
            Return sShippingCity
        End Get
        Set(ByVal value)
            'Validate, you can also add a try/catch
            If isValidShippingCity(value) Then
                sShippingCity = value
            End If
        End Set
    End Property

    Public Property ShippingState()
        'Get and set the customer name
        Get
            Return sShippingState
        End Get
        Set(ByVal value)
            'Validate, you can also add a try/catch
            If isValidShippingState(value) Then
                sShippingState = value
            End If
        End Set
    End Property

    Public Property ShippingZip()
        'Get and set the customer name
        Get
            Return sShippingZip
        End Get
        Set(ByVal value)
            'Validate, you can also add a try/catch
            If isValidShippingZip(value) Then
                sShippingZip = value
            End If
        End Set
    End Property

    Public Property RadioButton()
        'Get and set the customer name
        Get
            Return bRadioButton
        End Get
        Set(ByVal value)
            bRadioButton = value
        End Set
    End Property

    '===================================================
    ' Helper routines
    '===================================================
    Public Sub AddDetail(ByVal aDetailsList As ArrayList)
        'Loop through all our arraylist of details
        For i As Integer = 0 To aDetailsList.Count - 1
            'get a single order detail line out of 
            'the ArrayList of orders details
            Dim arrItem As String() = aDetailsList(i)

            'create a new order detail object
            Dim myOrderDetail As New clsOrderDetail

            'Add detail info to our object
            myOrderDetail.line = arrItem(0)     ' 0 - detail line
            myOrderDetail.Item = arrItem(1)     ' 1 - Item Description
            myOrderDetail.Qty = arrItem(2)      ' 2 - Item Quantity
            myOrderDetail.Price = arrItem(3)    ' 3 - Item Price

            If myOrderDetail.getError = "" Then
                myOrderDetail.total()
            End If

            'Check for errors in the detail 
            'if no errors then add the order to our collection
            If myOrderDetail.getError = "" Then
                detailsList.Add(myOrderDetail)
            Else
                addError(myOrderDetail.getError)
            End If
        Next

        If detailsList.Count = 0 Then
            addError("Detail:Order must contain at least one valid detail line")
        End If
    End Sub

    Public Function getLineTotal(ByVal iLine As Integer) As Decimal
        'return the line total
        'Loop through all the order lines
        For i As Integer = 0 To detailsList.Count - 1
            Dim myOrderDetail As clsOrderDetail = CType(detailsList(i), clsOrderDetail)
            If myOrderDetail.line = iLine Then
                Return myOrderDetail.total
            End If
        Next
    End Function

    Public Function getTotal() As Decimal
        'return the total for the order
        Dim aTotal As Decimal
        For i As Integer = 0 To detailsList.Count - 1
            Dim anOrderDetail As clsOrderDetail = CType(detailsList(i), clsOrderDetail)
            aTotal += anOrderDetail.total
        Next
        Return aTotal
    End Function

    Private Sub addError(ByVal s As String)
        'private function to format our error message by
        'adding line breaks when necessary
        If sError = "" Then
            sError = s
        Else
            sError += vbCrLf & s
        End If
    End Sub

    '===================================================
    ' Public functions to access the detail lines
    ' and the error
    '===================================================
    Public Function GetDetail() As ArrayList
        'Retrieve a detail item from the order
        Dim detailItemsList As New ArrayList
        For i As Integer = 0 To detailsList.Count - 1
            Dim orderDetail As New clsOrderDetail
            orderDetail = detailsList.Item(i)

            Dim arrDetail(4) As String
            arrDetail(0) = orderDetail.line
            arrDetail(1) = orderDetail.Item
            arrDetail(2) = orderDetail.Qty
            arrDetail(3) = orderDetail.Price

            detailItemsList.Add(arrDetail)
        Next
        Return detailItemsList
    End Function

    Public Function getError()
        'public Function to return the error to other objects
        Return sError
    End Function

    '===================================================
    ' Validation routines
    '===================================================
    Private Function isValidID(ByVal s As String) As Boolean
        Dim bResult As Boolean
        'needs to increment by 100
        Try
            If CInt(s) >= 100 And CInt(s) Mod 100 = 0 Then
                bResult = True
            ElseIf CDec(s) < 100 Or CInt(s) Mod 100 <> 0 Then
                addError("ID: Id must be an increment of 100")
            Else
                addError("ID: Cannot be left blank")
                bResult = False
            End If
        Catch ex As Exception
            addError("ID: Invalid ID (" & ex.Message & ")")
            bResult = False
        End Try

        Return bResult
    End Function

    Private Function isValidName(ByVal s As String) As Boolean
        Dim bResult As Boolean
        Try
            If s <> "" Then
                bResult = True
            Else
                addError("Name: Invalid Customer Name")
                bResult = False
            End If
        Catch ex As Exception
            addError("Name: Invalid Customer Name (" & ex.Message & ")")
            bResult = False
        End Try

        Return bResult
    End Function
    Private Function isValidPhone(ByVal s As String) As Boolean
        Dim bResult As Boolean
        Try
            If CLng(s) And Len(s) = 10 Then
                bResult = True
            Else
                addError("Phone: Invalid Customer Phone. Should be only 10 numbers")
                bResult = False
            End If
        Catch ex As Exception
            addError("Phone: Invalid Customer Phone (" & ex.Message & ")")
            bResult = False
        End Try

        Return bResult
    End Function

    Private Function isValidDate(ByVal s As String) As Boolean
        Dim bResult As Boolean
        Try
            If IsDate(s) Then
                bResult = True
            Else
                addError("Date: Invalid Customer Order Date")
                bResult = False
            End If
        Catch ex As Exception
            addError("Date: Invalid Customer Order Date (" & ex.Message & ")")
            bResult = False
        End Try

        Return bResult
    End Function

    Private Function isValidBillingStreet(ByVal s As String) As Boolean
        Dim bResult As Boolean
        Try
            If s <> "" Then
                bResult = True
            Else
                addError("Street: Invalid Billing Street")
                bResult = False
            End If
        Catch ex As Exception
            addError("Street: Invalid Billing Street (" & ex.Message & ")")
            bResult = False
        End Try

        Return bResult
    End Function

    Private Function isValidBillingCity(ByVal s As String) As Boolean
        Dim bResult As Boolean
        Try
            If s <> "" Then
                bResult = True
            Else
                addError("City: Invalid Billing City")
                bResult = False
            End If
        Catch ex As Exception
            addError("City: Invalid Billing City (" & ex.Message & ")")
            bResult = False
        End Try

        Return bResult
    End Function

    Private Function isValidBillingState(ByVal s As String) As Boolean
        Dim bResult As Boolean
        Try
            If Len(s) = 2 Then
                bResult = True
            Else
                addError("State: Invalid Billing State")
                bResult = False
            End If
        Catch ex As Exception
            addError("State: Invalid Billing State (" & ex.Message & ")")
            bResult = False
        End Try

        Return bResult
    End Function

    Private Function isValidBillingZip(ByVal s As String) As Boolean
        Dim bResult As Boolean
        Try
            If IsNumeric(s) And Len(s) = 5 Then
                bResult = True
            Else
                addError("Zip: Invalid Billing Zip")
                bResult = False
            End If
        Catch ex As Exception
            addError("Zip: Invalid Billing Zip (" & ex.Message & ")")
            bResult = False
        End Try

        Return bResult
    End Function

    Private Function isValidShippingStreet(ByVal s As String) As Boolean
        Dim bResult As Boolean
        Try
            If s <> "" Then
                bResult = True
            Else
                addError("Street: Invalid Shipping Street")
                bResult = False
            End If
        Catch ex As Exception
            addError("Street: Invalid Shipping Street (" & ex.Message & ")")
            bResult = False
        End Try

        Return bResult
    End Function

    Private Function isValidShippingCity(ByVal s As String) As Boolean
        Dim bResult As Boolean
        Try
            If s <> "" Then
                bResult = True
            Else
                addError("City: Invalid Shipping City")
                bResult = False
            End If
        Catch ex As Exception
            addError("City: Invalid Shipping City (" & ex.Message & ")")
            bResult = False
        End Try

        Return bResult
    End Function

    Private Function isValidShippingState(ByVal s As String) As Boolean
        Dim bResult As Boolean
        Try
            If Len(s) = 2 Then
                bResult = True
            Else
                addError("State: Invalid Shipping State")
                bResult = False
            End If
        Catch ex As Exception
            addError("State: Invalid Shipping State (" & ex.Message & ")")
            bResult = False
        End Try

        Return bResult
    End Function

    Private Function isValidShippingZip(ByVal s As String) As Boolean
        Dim bResult As Boolean
        Try
            If IsNumeric(s) And Len(s) = 5 Then
                bResult = True
            Else
                addError("Zip: Invalid Shipping Zip")
                bResult = False
            End If
        Catch ex As Exception
            addError("Zip: Invalid Shipping Zip (" & ex.Message & ")")
            bResult = False
        End Try

        Return bResult
    End Function
End Class