# --------------------------------------------------------------------------
# Build variables
#

FILESYSTEM_SERENAFS_C_SOURCES := $(wildcard $(FILESYSTEM_SERENAFS_SOURCES_DIR)/*.c)

FILESYSTEM_SERENAFS_OBJS := $(patsubst $(FILESYSTEM_SERENAFS_SOURCES_DIR)/%.c,$(FILESYSTEM_SERENAFS_OBJS_DIR)/%.o,$(FILESYSTEM_SERENAFS_C_SOURCES))
FILESYSTEM_SERENAFS_DEPS := $(FILESYSTEM_SERENAFS_OBJS:.o=.d)

FILESYSTEM_SERENAFS_C_INCLUDES := -I$(LIBSYSTEM_HEADERS_DIR) -I$(KERNEL_SOURCES_DIR) -I$(FILESYSTEM_SERENAFS_SOURCES_DIR)

#FILESYSTEM_SERENAFS_GENERATE_DEPS = -deps -depfile=$(patsubst $(FILESYSTEM_SERENAFS_OBJS_DIR)/%.o,$(FILESYSTEM_SERENAFS_OBJS_DIR)/%.d,$@)
FILESYSTEM_SERENAFS_GENERATE_DEPS := 


# --------------------------------------------------------------------------
# Build rules
#

$(FILESYSTEM_SERENAFS_OBJS): | $(FILESYSTEM_SERENAFS_OBJS_DIR)

$(FILESYSTEM_SERENAFS_OBJS_DIR):
	$(call mkdir_if_needed,$(FILESYSTEM_SERENAFS_OBJS_DIR))

-include $(FILESYSTEM_SERENAFS_DEPS)

$(FILESYSTEM_SERENAFS_OBJS_DIR)/%.o : $(FILESYSTEM_SERENAFS_SOURCES_DIR)/%.c
	@echo $<
	@$(CC) $(KERNEL_CC_CONFIG) $(CC_KOPT_SETTING) $(CC_GEN_DEBUG_INFO) $(KERNEL_CC_PREPROC_DEFS) $(FILESYSTEM_SERENAFS_C_INCLUDES) $(KERNEL_CC_DONTWARN) $(FILESYSTEM_SERENAFS_GENERATE_DEPS) -o $@ $<
