# --------------------------------------------------------------------------
# Build variables
#

FILESYSTEM_DEVFS_C_SOURCES := $(wildcard $(FILESYSTEM_DEVFS_SOURCES_DIR)/*.c)

FILESYSTEM_DEVFS_OBJS := $(patsubst $(FILESYSTEM_DEVFS_SOURCES_DIR)/%.c,$(FILESYSTEM_DEVFS_OBJS_DIR)/%.o,$(FILESYSTEM_DEVFS_C_SOURCES))
FILESYSTEM_DEVFS_DEPS := $(FILESYSTEM_DEVFS_OBJS:.o=.d)

FILESYSTEM_DEVFS_C_INCLUDES := -I$(LIBSYSTEM_HEADERS_DIR) -I$(KERNEL_SOURCES_DIR) -I$(FILESYSTEM_DEVFS_SOURCES_DIR)

#FILESYSTEM_DEVFS_GENERATE_DEPS = -deps -depfile=$(patsubst $(FILESYSTEM_DEVFS_OBJS_DIR)/%.o,$(FILESYSTEM_DEVFS_OBJS_DIR)/%.d,$@)
FILESYSTEM_DEVFS_GENERATE_DEPS := 


# --------------------------------------------------------------------------
# Build rules
#

$(FILESYSTEM_DEVFS_OBJS): | $(FILESYSTEM_DEVFS_OBJS_DIR)

$(FILESYSTEM_DEVFS_OBJS_DIR):
	$(call mkdir_if_needed,$(FILESYSTEM_DEVFS_OBJS_DIR))

-include $(FILESYSTEM_DEVFS_DEPS)

$(FILESYSTEM_DEVFS_OBJS_DIR)/%.o : $(FILESYSTEM_DEVFS_SOURCES_DIR)/%.c
	@echo $<
	@$(CC) $(KERNEL_CC_CONFIG) $(CC_KOPT_SETTING) $(CC_GEN_DEBUG_INFO) $(KERNEL_CC_PREPROC_DEFS) $(FILESYSTEM_DEVFS_C_INCLUDES) $(KERNEL_CC_DONTWARN) $(FILESYSTEM_DEVFS_GENERATE_DEPS) -o $@ $<
