//#define VT500PARSE_DEBUG

typedef enum {
   VT500PARSE_STATE_CSI_ENTRY = 1,
   VT500PARSE_STATE_CSI_IGNORE = 2,
   VT500PARSE_STATE_CSI_INTERMEDIATE = 3,
   VT500PARSE_STATE_CSI_PARAM = 4,
   VT500PARSE_STATE_DCS_ENTRY = 5,
   VT500PARSE_STATE_DCS_IGNORE = 6,
   VT500PARSE_STATE_DCS_INTERMEDIATE = 7,
   VT500PARSE_STATE_DCS_PARAM = 8,
   VT500PARSE_STATE_DCS_PASSTHROUGH = 9,
   VT500PARSE_STATE_ESCAPE = 10,
   VT500PARSE_STATE_ESCAPE_INTERMEDIATE = 11,
   VT500PARSE_STATE_GROUND = 12,
   VT500PARSE_STATE_OSC_STRING = 13,
   VT500PARSE_STATE_SOS_PM_APC_STRING = 14,
} vt500parse_state_t;

typedef enum {
   VT500PARSE_ACTION_CLEAR = 1,
   VT500PARSE_ACTION_COLLECT = 2,
   VT500PARSE_ACTION_CSI_DISPATCH = 3,
   VT500PARSE_ACTION_ESC_DISPATCH = 4,
   VT500PARSE_ACTION_EXECUTE = 5,
   VT500PARSE_ACTION_HOOK = 6,
   VT500PARSE_ACTION_IGNORE = 7,
   VT500PARSE_ACTION_OSC_END = 8,
   VT500PARSE_ACTION_OSC_PUT = 9,
   VT500PARSE_ACTION_OSC_START = 10,
   VT500PARSE_ACTION_PARAM = 11,
   VT500PARSE_ACTION_PRINT = 12,
   VT500PARSE_ACTION_PUT = 13,
   VT500PARSE_ACTION_UNHOOK = 14,
   VT500PARSE_ACTION_ERROR = 15,
} vt500parse_action_t;

typedef unsigned char state_change_t;
extern const state_change_t VT500_STATE_TABLE[14][256];
extern const vt500parse_action_t VT500_ENTRY_ACTIONS[14];
extern const vt500parse_action_t VT500_EXIT_ACTIONS[14];
#ifdef VT500PARSE_DEBUG
extern char *ACTION_NAMES[16];
extern char *STATE_NAMES[15];
#endif
