
#include "vt500parse_table.h"

#ifdef VT500PARSE_DEBUG
char *ACTION_NAMES[] = {
   "<no action>",
   "CLEAR",
   "COLLECT",
   "CSI_DISPATCH",
   "ESC_DISPATCH",
   "EXECUTE",
   "HOOK",
   "IGNORE",
   "OSC_END",
   "OSC_PUT",
   "OSC_START",
   "PARAM",
   "PRINT",
   "PUT",
   "UNHOOK",
   "ERROR",
};

char *STATE_NAMES[] = {
   "<no state>",
   "CSI_ENTRY",
   "CSI_IGNORE",
   "CSI_INTERMEDIATE",
   "CSI_PARAM",
   "DCS_ENTRY",
   "DCS_IGNORE",
   "DCS_INTERMEDIATE",
   "DCS_PARAM",
   "DCS_PASSTHROUGH",
   "ESCAPE",
   "ESCAPE_INTERMEDIATE",
   "GROUND",
   "OSC_STRING",
   "SOS_PM_APC_STRING",
};
#endif

const state_change_t VT500_STATE_TABLE[14][256] = {
  {  /* VT500PARSE_STATE_CSI_ENTRY = 0 */
/*0  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*33 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*34 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*35 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*36 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*37 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*38 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*39 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*40 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*41 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*42 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*43 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*44 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*45 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*46 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*47 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*48 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*49 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*50 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*51 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*52 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*53 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*54 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*55 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*56 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*57 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*58 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*59 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*60 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*61 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*62 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*63 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_PARAM           << 4),
/*64 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*65 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*66 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*67 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*68 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*69 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*70 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*71 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*72 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*73 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*74 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*75 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*76 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*77 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*78 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*79 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*80 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*81 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*82 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*83 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*84 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*85 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*86 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*87 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*88 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*89 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*90 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*91 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*92 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*93 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*94 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*95 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*96 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*97 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*98 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*99 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*100*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*101*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*102*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*103*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*104*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*105*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*106*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*107*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*108*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*109*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*110*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*111*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*112*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*113*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*114*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*115*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*116*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*117*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*118*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*119*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*120*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*121*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*122*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*123*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*124*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*125*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*126*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*127*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_CSI_IGNORE = 1 */
/*0  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*33 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*34 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*35 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*36 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*37 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*38 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*39 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*40 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*41 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*42 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*43 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*44 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*45 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*46 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*47 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*48 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*49 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*50 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*51 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*52 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*53 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*54 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*55 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*56 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*57 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*58 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*59 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*60 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*61 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*62 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*63 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*64 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*65 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*66 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*67 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*68 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*69 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*70 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*71 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*72 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*73 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*74 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*75 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*76 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*77 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*78 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*79 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*80 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*81 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*82 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*83 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*84 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*85 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*86 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*87 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*88 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*89 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*90 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*91 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*92 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*93 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*94 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*95 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*96 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*97 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*98 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*99 */  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*100*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*101*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*102*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*103*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*104*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*105*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*106*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*107*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*108*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*109*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*110*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*111*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*112*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*113*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*114*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*115*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*116*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*117*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*118*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*119*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*120*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*121*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*122*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*123*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*124*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*125*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*126*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*127*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_CSI_INTERMEDIATE = 2 */
/*0  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*33 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*34 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*35 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*36 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*37 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*38 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*39 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*40 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*41 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*42 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*43 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*44 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*45 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*46 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*47 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*48 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*49 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*50 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*51 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*52 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*53 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*54 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*55 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*56 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*57 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*58 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*59 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*60 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*61 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*62 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*63 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*64 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*65 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*66 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*67 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*68 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*69 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*70 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*71 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*72 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*73 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*74 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*75 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*76 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*77 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*78 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*79 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*80 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*81 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*82 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*83 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*84 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*85 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*86 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*87 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*88 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*89 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*90 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*91 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*92 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*93 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*94 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*95 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*96 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*97 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*98 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*99 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*100*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*101*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*102*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*103*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*104*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*105*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*106*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*107*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*108*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*109*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*110*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*111*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*112*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*113*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*114*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*115*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*116*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*117*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*118*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*119*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*120*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*121*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*122*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*123*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*124*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*125*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*126*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*127*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_CSI_PARAM = 3 */
/*0  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*33 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*34 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*35 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*36 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*37 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*38 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*39 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*40 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*41 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*42 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*43 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*44 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*45 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*46 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*47 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_CSI_INTERMEDIATE    << 4),
/*48 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*49 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*50 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*51 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*52 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*53 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*54 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*55 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*56 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*57 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*58 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*59 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*60 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*61 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*62 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*63 */  0                                 | (VT500PARSE_STATE_CSI_IGNORE          << 4),
/*64 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*65 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*66 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*67 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*68 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*69 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*70 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*71 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*72 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*73 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*74 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*75 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*76 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*77 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*78 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*79 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*80 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*81 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*82 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*83 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*84 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*85 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*86 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*87 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*88 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*89 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*90 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*91 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*92 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*93 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*94 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*95 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*96 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*97 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*98 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*99 */  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*100*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*101*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*102*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*103*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*104*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*105*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*106*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*107*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*108*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*109*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*110*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*111*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*112*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*113*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*114*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*115*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*116*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*117*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*118*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*119*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*120*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*121*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*122*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*123*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*124*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*125*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*126*/  VT500PARSE_ACTION_CSI_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*127*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_DCS_ENTRY = 4 */
/*0  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*33 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*34 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*35 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*36 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*37 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*38 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*39 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*40 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*41 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*42 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*43 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*44 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*45 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*46 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*47 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*48 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*49 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*50 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*51 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*52 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*53 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*54 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*55 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*56 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*57 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*58 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*59 */  VT500PARSE_ACTION_PARAM              | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*60 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*61 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*62 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*63 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_PARAM           << 4),
/*64 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*65 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*66 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*67 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*68 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*69 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*70 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*71 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*72 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*73 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*74 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*75 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*76 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*77 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*78 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*79 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*80 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*81 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*82 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*83 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*84 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*85 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*86 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*87 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*88 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*89 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*90 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*91 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*92 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*93 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*94 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*95 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*96 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*97 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*98 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*99 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*100*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*101*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*102*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*103*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*104*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*105*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*106*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*107*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*108*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*109*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*110*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*111*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*112*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*113*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*114*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*115*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*116*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*117*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*118*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*119*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*120*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*121*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*122*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*123*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*124*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*125*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*126*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*127*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_DCS_IGNORE = 5 */
/*0  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*33 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*34 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*35 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*36 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*37 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*38 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*39 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*40 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*41 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*42 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*43 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*44 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*45 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*46 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*47 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*48 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*49 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*50 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*51 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*52 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*53 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*54 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*55 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*56 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*57 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*58 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*59 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*60 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*61 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*62 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*63 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*64 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*65 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*66 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*67 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*68 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*69 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*70 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*71 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*72 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*73 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*74 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*75 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*76 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*77 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*78 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*79 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*80 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*81 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*82 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*83 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*84 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*85 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*86 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*87 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*88 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*89 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*90 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*91 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*92 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*93 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*94 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*95 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*96 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*97 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*98 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*99 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*100*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*101*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*102*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*103*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*104*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*105*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*106*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*107*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*108*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*109*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*110*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*111*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*112*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*113*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*114*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*115*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*116*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*117*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*118*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*119*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*120*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*121*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*122*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*123*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*124*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*125*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*126*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*127*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_DCS_INTERMEDIATE = 6 */
/*0  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*33 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*34 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*35 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*36 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*37 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*38 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*39 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*40 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*41 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*42 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*43 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*44 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*45 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*46 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*47 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*48 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*49 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*50 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*51 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*52 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*53 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*54 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*55 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*56 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*57 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*58 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*59 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*60 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*61 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*62 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*63 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*64 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*65 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*66 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*67 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*68 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*69 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*70 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*71 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*72 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*73 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*74 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*75 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*76 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*77 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*78 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*79 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*80 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*81 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*82 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*83 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*84 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*85 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*86 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*87 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*88 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*89 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*90 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*91 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*92 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*93 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*94 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*95 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*96 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*97 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*98 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*99 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*100*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*101*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*102*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*103*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*104*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*105*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*106*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*107*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*108*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*109*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*110*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*111*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*112*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*113*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*114*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*115*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*116*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*117*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*118*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*119*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*120*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*121*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*122*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*123*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*124*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*125*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*126*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*127*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_DCS_PARAM = 7 */
/*0  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*33 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*34 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*35 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*36 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*37 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*38 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*39 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*40 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*41 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*42 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*43 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*44 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*45 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*46 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*47 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_DCS_INTERMEDIATE    << 4),
/*48 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*49 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*50 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*51 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*52 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*53 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*54 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*55 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*56 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*57 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*58 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*59 */  VT500PARSE_ACTION_PARAM              | (0                                 << 4),
/*60 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*61 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*62 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*63 */  0                                 | (VT500PARSE_STATE_DCS_IGNORE          << 4),
/*64 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*65 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*66 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*67 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*68 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*69 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*70 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*71 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*72 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*73 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*74 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*75 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*76 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*77 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*78 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*79 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*80 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*81 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*82 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*83 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*84 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*85 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*86 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*87 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*88 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*89 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*90 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*91 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*92 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*93 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*94 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*95 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*96 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*97 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*98 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*99 */  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*100*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*101*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*102*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*103*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*104*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*105*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*106*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*107*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*108*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*109*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*110*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*111*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*112*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*113*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*114*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*115*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*116*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*117*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*118*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*119*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*120*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*121*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*122*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*123*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*124*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*125*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*126*/  0                                 | (VT500PARSE_STATE_DCS_PASSTHROUGH     << 4),
/*127*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_DCS_PASSTHROUGH = 8 */
/*0  */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*33 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*34 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*35 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*36 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*37 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*38 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*39 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*40 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*41 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*42 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*43 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*44 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*45 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*46 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*47 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*48 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*49 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*50 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*51 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*52 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*53 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*54 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*55 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*56 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*57 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*58 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*59 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*60 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*61 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*62 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*63 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*64 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*65 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*66 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*67 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*68 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*69 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*70 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*71 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*72 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*73 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*74 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*75 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*76 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*77 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*78 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*79 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*80 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*81 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*82 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*83 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*84 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*85 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*86 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*87 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*88 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*89 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*90 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*91 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*92 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*93 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*94 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*95 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*96 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*97 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*98 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*99 */  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*100*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*101*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*102*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*103*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*104*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*105*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*106*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*107*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*108*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*109*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*110*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*111*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*112*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*113*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*114*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*115*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*116*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*117*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*118*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*119*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*120*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*121*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*122*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*123*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*124*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*125*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*126*/  VT500PARSE_ACTION_PUT                | (0                                 << 4),
/*127*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_ESCAPE = 9 */
/*0  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*33 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*34 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*35 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*36 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*37 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*38 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*39 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*40 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*41 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*42 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*43 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*44 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*45 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*46 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*47 */  VT500PARSE_ACTION_COLLECT            | (VT500PARSE_STATE_ESCAPE_INTERMEDIATE << 4),
/*48 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*49 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*50 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*51 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*52 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*53 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*54 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*55 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*56 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*57 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*58 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*59 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*60 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*61 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*62 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*63 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*64 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*65 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*66 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*67 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*68 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*69 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*70 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*71 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*72 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*73 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*74 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*75 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*76 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*77 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*78 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*79 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*80 */  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*81 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*82 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*83 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*84 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*85 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*86 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*87 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*88 */  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*89 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*90 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*91 */  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*92 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*93 */  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*94 */  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*95 */  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*96 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*97 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*98 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*99 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*100*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*101*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*102*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*103*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*104*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*105*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*106*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*107*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*108*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*109*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*110*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*111*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*112*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*113*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*114*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*115*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*116*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*117*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*118*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*119*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*120*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*121*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*122*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*123*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*124*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*125*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*126*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*127*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_ESCAPE_INTERMEDIATE = 10 */
/*0  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*33 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*34 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*35 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*36 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*37 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*38 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*39 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*40 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*41 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*42 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*43 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*44 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*45 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*46 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*47 */  VT500PARSE_ACTION_COLLECT            | (0                                 << 4),
/*48 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*49 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*50 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*51 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*52 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*53 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*54 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*55 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*56 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*57 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*58 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*59 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*60 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*61 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*62 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*63 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*64 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*65 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*66 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*67 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*68 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*69 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*70 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*71 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*72 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*73 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*74 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*75 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*76 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*77 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*78 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*79 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*80 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*81 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*82 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*83 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*84 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*85 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*86 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*87 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*88 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*89 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*90 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*91 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*92 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*93 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*94 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*95 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*96 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*97 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*98 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*99 */  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*100*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*101*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*102*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*103*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*104*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*105*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*106*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*107*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*108*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*109*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*110*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*111*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*112*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*113*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*114*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*115*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*116*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*117*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*118*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*119*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*120*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*121*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*122*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*123*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*124*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*125*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*126*/  VT500PARSE_ACTION_ESC_DISPATCH       | (VT500PARSE_STATE_GROUND              << 4),
/*127*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_GROUND = 11 */
/*0  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_EXECUTE            | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*33 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*34 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*35 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*36 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*37 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*38 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*39 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*40 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*41 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*42 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*43 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*44 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*45 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*46 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*47 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*48 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*49 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*50 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*51 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*52 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*53 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*54 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*55 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*56 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*57 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*58 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*59 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*60 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*61 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*62 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*63 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*64 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*65 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*66 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*67 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*68 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*69 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*70 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*71 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*72 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*73 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*74 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*75 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*76 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*77 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*78 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*79 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*80 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*81 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*82 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*83 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*84 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*85 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*86 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*87 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*88 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*89 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*90 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*91 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*92 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*93 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*94 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*95 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*96 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*97 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*98 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*99 */  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*100*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*101*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*102*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*103*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*104*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*105*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*106*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*107*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*108*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*109*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*110*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*111*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*112*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*113*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*114*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*115*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*116*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*117*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*118*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*119*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*120*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*121*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*122*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*123*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*124*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*125*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*126*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*127*/  VT500PARSE_ACTION_PRINT              | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_OSC_STRING = 12 */
/*0  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*33 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*34 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*35 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*36 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*37 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*38 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*39 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*40 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*41 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*42 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*43 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*44 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*45 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*46 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*47 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*48 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*49 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*50 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*51 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*52 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*53 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*54 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*55 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*56 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*57 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*58 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*59 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*60 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*61 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*62 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*63 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*64 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*65 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*66 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*67 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*68 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*69 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*70 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*71 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*72 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*73 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*74 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*75 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*76 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*77 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*78 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*79 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*80 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*81 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*82 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*83 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*84 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*85 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*86 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*87 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*88 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*89 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*90 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*91 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*92 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*93 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*94 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*95 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*96 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*97 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*98 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*99 */  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*100*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*101*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*102*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*103*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*104*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*105*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*106*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*107*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*108*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*109*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*110*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*111*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*112*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*113*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*114*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*115*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*116*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*117*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*118*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*119*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*120*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*121*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*122*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*123*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*124*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*125*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*126*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*127*/  VT500PARSE_ACTION_OSC_PUT            | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VT500PARSE_STATE_SOS_PM_APC_STRING = 13 */
/*0  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*1  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*2  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*3  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*4  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*5  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*6  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*7  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*8  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*9  */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*10 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*11 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*12 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*13 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*14 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*15 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*16 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*17 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*18 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*19 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*20 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*21 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*22 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*23 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*24 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*25 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*26 */  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*27 */  0                                 | (VT500PARSE_STATE_ESCAPE              << 4),
/*28 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*29 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*30 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*31 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*32 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*33 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*34 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*35 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*36 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*37 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*38 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*39 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*40 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*41 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*42 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*43 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*44 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*45 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*46 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*47 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*48 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*49 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*50 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*51 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*52 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*53 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*54 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*55 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*56 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*57 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*58 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*59 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*60 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*61 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*62 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*63 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*64 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*65 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*66 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*67 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*68 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*69 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*70 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*71 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*72 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*73 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*74 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*75 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*76 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*77 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*78 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*79 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*80 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*81 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*82 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*83 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*84 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*85 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*86 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*87 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*88 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*89 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*90 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*91 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*92 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*93 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*94 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*95 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*96 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*97 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*98 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*99 */  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*100*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*101*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*102*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*103*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*104*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*105*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*106*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*107*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*108*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*109*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*110*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*111*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*112*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*113*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*114*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*115*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*116*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*117*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*118*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*119*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*120*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*121*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*122*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*123*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*124*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*125*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*126*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*127*/  VT500PARSE_ACTION_IGNORE             | (0                                 << 4),
/*128*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*129*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*130*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*131*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*132*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*133*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*134*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*135*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*136*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*137*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*138*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*139*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*140*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*141*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*142*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*143*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*144*/  0                                 | (VT500PARSE_STATE_DCS_ENTRY           << 4),
/*145*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*146*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*147*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*148*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*149*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*150*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*151*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*152*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*153*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*154*/  VT500PARSE_ACTION_EXECUTE            | (VT500PARSE_STATE_GROUND              << 4),
/*155*/  0                                 | (VT500PARSE_STATE_CSI_ENTRY           << 4),
/*156*/  0                                 | (VT500PARSE_STATE_GROUND              << 4),
/*157*/  0                                 | (VT500PARSE_STATE_OSC_STRING          << 4),
/*158*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
/*159*/  0                                 | (VT500PARSE_STATE_SOS_PM_APC_STRING   << 4),
  },
};

const vt500parse_action_t VT500_ENTRY_ACTIONS[] = {
   VT500PARSE_ACTION_CLEAR, /* CSI_ENTRY */
   0  /* none for CSI_IGNORE */,
   0  /* none for CSI_INTERMEDIATE */,
   0  /* none for CSI_PARAM */,
   VT500PARSE_ACTION_CLEAR, /* DCS_ENTRY */
   0  /* none for DCS_IGNORE */,
   0  /* none for DCS_INTERMEDIATE */,
   0  /* none for DCS_PARAM */,
   VT500PARSE_ACTION_HOOK, /* DCS_PASSTHROUGH */
   VT500PARSE_ACTION_CLEAR, /* ESCAPE */
   0  /* none for ESCAPE_INTERMEDIATE */,
   0  /* none for GROUND */,
   VT500PARSE_ACTION_OSC_START, /* OSC_STRING */
   0  /* none for SOS_PM_APC_STRING */,
};

const vt500parse_action_t VT500_EXIT_ACTIONS[] = {
   0  /* none for CSI_ENTRY */,
   0  /* none for CSI_IGNORE */,
   0  /* none for CSI_INTERMEDIATE */,
   0  /* none for CSI_PARAM */,
   0  /* none for DCS_ENTRY */,
   0  /* none for DCS_IGNORE */,
   0  /* none for DCS_INTERMEDIATE */,
   0  /* none for DCS_PARAM */,
   VT500PARSE_ACTION_UNHOOK, /* DCS_PASSTHROUGH */
   0  /* none for ESCAPE */,
   0  /* none for ESCAPE_INTERMEDIATE */,
   0  /* none for GROUND */,
   VT500PARSE_ACTION_OSC_END, /* OSC_STRING */
   0  /* none for SOS_PM_APC_STRING */,
};

