//
//  cls.c
//  sh
//
//  Created by Dietmar Planitzer on 4/4/24.
//  Copyright © 2024 Dietmar Planitzer. All rights reserved.
//

#include "Interpreter.h"
#include <stdio.h>
#include <stdlib.h>
#include <clap.h>


static CLAP_DECL(params,
    CLAP_VERSION("1.0"),
    CLAP_HELP(),
    CLAP_USAGE("cls"),
    CLAP_PROLOG("Clear the screen.")
);


int cmd_cls(InterpreterRef _Nonnull ip, int argc, char** argv, char** envp)
{
    const int status = clap_parse(clap_option_no_exit, params, argc, argv);
    int exitCode;
    
    if (!clap_should_exit(status)) {
        printf("\033[2J\033[H");
        exitCode = EXIT_SUCCESS;
    }
    else {
        exitCode = clap_exit_code(status);
    }    

    OpStack_PushVoid(ip->opStack);
    return exitCode;
}
