"""Specify Django url patterns for MK8 Django views."""

from django.conf import settings
from django.conf.urls import include, patterns, url
from django.contrib import admin

admin.autodiscover()

urlpatterns = patterns('',
    url(r'^', include('comparison.urls')),

    url(r'^admin/', include(admin.site.urls)),
)

handler404 = 'comparison.views.handler404'

# Uncomment the next line to serve media files in dev.
# urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)

# Add urls required for debug_toolbar when in DEBUG mode
if settings.DEBUG:
    try:
        import debug_toolbar
        urlpatterns += patterns('',
            url(r'^__debug__/', include(debug_toolbar.urls)),
        )
    except ImportError:
        pass
