<?php

$web = 'index.php';

if (in_array('phar', stream_get_wrappers()) && class_exists('Phar', 0)) {
Phar::interceptFileFuncs();
set_include_path('phar://' . __FILE__ . PATH_SEPARATOR . get_include_path());
Phar::webPhar(null, $web);
include 'phar://' . __FILE__ . '/' . Extract_Phar::START;
return;
}

if (@(isset($_SERVER['REQUEST_URI']) && isset($_SERVER['REQUEST_METHOD']) && ($_SERVER['REQUEST_METHOD'] == 'GET' || $_SERVER['REQUEST_METHOD'] == 'POST'))) {
Extract_Phar::go(true);
$mimes = array(
'phps' => 2,
'c' => 'text/plain',
'cc' => 'text/plain',
'cpp' => 'text/plain',
'c++' => 'text/plain',
'dtd' => 'text/plain',
'h' => 'text/plain',
'log' => 'text/plain',
'rng' => 'text/plain',
'txt' => 'text/plain',
'xsd' => 'text/plain',
'php' => 1,
'inc' => 1,
'avi' => 'video/avi',
'bmp' => 'image/bmp',
'css' => 'text/css',
'gif' => 'image/gif',
'htm' => 'text/html',
'html' => 'text/html',
'htmls' => 'text/html',
'ico' => 'image/x-ico',
'jpe' => 'image/jpeg',
'jpg' => 'image/jpeg',
'jpeg' => 'image/jpeg',
'js' => 'application/x-javascript',
'midi' => 'audio/midi',
'mid' => 'audio/midi',
'mod' => 'audio/mod',
'mov' => 'movie/quicktime',
'mp3' => 'audio/mp3',
'mpg' => 'video/mpeg',
'mpeg' => 'video/mpeg',
'pdf' => 'application/pdf',
'png' => 'image/png',
'swf' => 'application/shockwave-flash',
'tif' => 'image/tiff',
'tiff' => 'image/tiff',
'wav' => 'audio/wav',
'xbm' => 'image/xbm',
'xml' => 'text/xml',
);

header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");

$basename = basename(__FILE__);
if (!strpos($_SERVER['REQUEST_URI'], $basename)) {
chdir(Extract_Phar::$temp);
include $web;
return;
}
$pt = substr($_SERVER['REQUEST_URI'], strpos($_SERVER['REQUEST_URI'], $basename) + strlen($basename));
if (!$pt || $pt == '/') {
$pt = $web;
header('HTTP/1.1 301 Moved Permanently');
header('Location: ' . $_SERVER['REQUEST_URI'] . '/' . $pt);
exit;
}
$a = realpath(Extract_Phar::$temp . DIRECTORY_SEPARATOR . $pt);
if (!$a || strlen(dirname($a)) < strlen(Extract_Phar::$temp)) {
header('HTTP/1.0 404 Not Found');
echo "<html>\n <head>\n  <title>File Not Found<title>\n </head>\n <body>\n  <h1>404 - File Not Found</h1>\n </body>\n</html>";
exit;
}
$b = pathinfo($a);
if (!isset($b['extension'])) {
header('Content-Type: text/plain');
header('Content-Length: ' . filesize($a));
readfile($a);
exit;
}
if (isset($mimes[$b['extension']])) {
if ($mimes[$b['extension']] === 1) {
include $a;
exit;
}
if ($mimes[$b['extension']] === 2) {
highlight_file($a);
exit;
}
header('Content-Type: ' .$mimes[$b['extension']]);
header('Content-Length: ' . filesize($a));
readfile($a);
exit;
}
}

class Extract_Phar
{
static $temp;
static $origdir;
const GZ = 0x1000;
const BZ2 = 0x2000;
const MASK = 0x3000;
const START = 'index.php';
const LEN = 6643;

static function go($return = false)
{
$fp = fopen(__FILE__, 'rb');
fseek($fp, self::LEN);
$L = unpack('V', $a = fread($fp, 4));
$m = '';

do {
$read = 8192;
if ($L[1] - strlen($m) < 8192) {
$read = $L[1] - strlen($m);
}
$last = fread($fp, $read);
$m .= $last;
} while (strlen($last) && strlen($m) < $L[1]);

if (strlen($m) < $L[1]) {
die('ERROR: manifest length read was "' .
strlen($m) .'" should be "' .
$L[1] . '"');
}

$info = self::_unpack($m);
$f = $info['c'];

if ($f & self::GZ) {
if (!function_exists('gzinflate')) {
die('Error: zlib extension is not enabled -' .
' gzinflate() function needed for zlib-compressed .phars');
}
}

if ($f & self::BZ2) {
if (!function_exists('bzdecompress')) {
die('Error: bzip2 extension is not enabled -' .
' bzdecompress() function needed for bz2-compressed .phars');
}
}

$temp = self::tmpdir();

if (!$temp || !is_writable($temp)) {
$sessionpath = session_save_path();
if (strpos ($sessionpath, ";") !== false)
$sessionpath = substr ($sessionpath, strpos ($sessionpath, ";")+1);
if (!file_exists($sessionpath) || !is_dir($sessionpath)) {
die('Could not locate temporary directory to extract phar');
}
$temp = $sessionpath;
}

$temp .= '/pharextract/'.basename(__FILE__, '.phar');
self::$temp = $temp;
self::$origdir = getcwd();
@mkdir($temp, 0777, true);
$temp = realpath($temp);

if (!file_exists($temp . DIRECTORY_SEPARATOR . md5_file(__FILE__))) {
self::_removeTmpFiles($temp, getcwd());
@mkdir($temp, 0777, true);
@file_put_contents($temp . '/' . md5_file(__FILE__), '');

foreach ($info['m'] as $path => $file) {
$a = !file_exists(dirname($temp . '/' . $path));
@mkdir(dirname($temp . '/' . $path), 0777, true);
clearstatcache();

if ($path[strlen($path) - 1] == '/') {
@mkdir($temp . '/' . $path, 0777);
} else {
file_put_contents($temp . '/' . $path, self::extractFile($path, $file, $fp));
@chmod($temp . '/' . $path, 0666);
}
}
}

chdir($temp);

if (!$return) {
include self::START;
}
}

static function tmpdir()
{
if (strpos(PHP_OS, 'WIN') !== false) {
if ($var = getenv('TMP') ? getenv('TMP') : getenv('TEMP')) {
return $var;
}
if (is_dir('/temp') || mkdir('/temp')) {
return realpath('/temp');
}
return false;
}
if ($var = getenv('TMPDIR')) {
return $var;
}
return realpath('/tmp');
}

static function _unpack($m)
{
$info = unpack('V', substr($m, 0, 4));
 $l = unpack('V', substr($m, 10, 4));
$m = substr($m, 14 + $l[1]);
$s = unpack('V', substr($m, 0, 4));
$o = 0;
$start = 4 + $s[1];
$ret['c'] = 0;

for ($i = 0; $i < $info[1]; $i++) {
 $len = unpack('V', substr($m, $start, 4));
$start += 4;
 $savepath = substr($m, $start, $len[1]);
$start += $len[1];
   $ret['m'][$savepath] = array_values(unpack('Va/Vb/Vc/Vd/Ve/Vf', substr($m, $start, 24)));
$ret['m'][$savepath][3] = sprintf('%u', $ret['m'][$savepath][3]
& 0xffffffff);
$ret['m'][$savepath][7] = $o;
$o += $ret['m'][$savepath][2];
$start += 24 + $ret['m'][$savepath][5];
$ret['c'] |= $ret['m'][$savepath][4] & self::MASK;
}
return $ret;
}

static function extractFile($path, $entry, $fp)
{
$data = '';
$c = $entry[2];

while ($c) {
if ($c < 8192) {
$data .= @fread($fp, $c);
$c = 0;
} else {
$c -= 8192;
$data .= @fread($fp, 8192);
}
}

if ($entry[4] & self::GZ) {
$data = gzinflate($data);
} elseif ($entry[4] & self::BZ2) {
$data = bzdecompress($data);
}

if (strlen($data) != $entry[0]) {
die("Invalid internal .phar file (size error " . strlen($data) . " != " .
$stat[7] . ")");
}

if ($entry[3] != sprintf("%u", crc32($data) & 0xffffffff)) {
die("Invalid internal .phar file (checksum error)");
}

return $data;
}

static function _removeTmpFiles($temp, $origdir)
{
chdir($temp);

foreach (glob('*') as $f) {
if (file_exists($f)) {
is_dir($f) ? @rmdir($f) : @unlink($f);
if (file_exists($f) && is_dir($f)) {
self::_removeTmpFiles($f, getcwd());
}
}
}

@rmdir($temp);
clearstatcache();
chdir($origdir);
}
}

Extract_Phar::go();
__HALT_COMPILER(); ?>                     hall.htm(  d  M      	   index.htm  dR  d0      
   notice.htm  d  iRN         room.htm4#  d  '      ZoGR멒*%PخZHTj_*^ޭc'@M0$)1Bgw}NP՗xo?f~3;3;;7_гofBFRMwb_S$E丘fGvіZwir%Tti04GYDsmˡ)6^hQqLP"gf&
t%]r?P9JBZ_DmN1AsHʒ-
iT dFQEGQ|[WΦA5p_S_
15|L9*E=lubyCCgd-bCR	g%
QbF!e:u}~C	y촭yWZ#s#pٕvmdvPQbb*L"Òd8hFI~U-'M&)&JR71)us| f&) u@LA6K`L|>1M,#]F?eP.wh vl|ik('%oRyxR:四?AyR"1=)ؔvgFpY`. OW6~_#xY_~=Xl:~Z %+Zzq!La lk.Q_ognyꕗמpUnxkw'܁r˝NȾ;6=YvvNN0A~>
|0^5=+b!?Whuc*7y`5R2py܂xPga3ΓBw3pr('yE416*`&|,GDrv؂X=XhP!YdBjUĐ@QafrUin)o*#{LK)"AL\F	gPbdFπ%^Xdd6RLGIԃE=cb؎Up0+d"Y;b+ ,./R0I
%q-|rrbu\- p6*V-=ehAf)B\Cjȫ]ךV+KfF P+h|x%uem^+KO+QV]&.|CHvr|Rlb3v%~KΊ<FV+<vv̪Em2l Tkroo\;uY}1>Ҹ]mVŉf^Ԟ=/c>[+r5H` F#+bњٞwU4m	@̲)C쌜wiE[Ίیp$rv[{q[výC[.VL"t|G4`ph4Uz_i8=	Uۘ!g݂Qfm.<PN<fn2H3hK#f؂(k vֻxB׳کd0
]ΣFmUs]~_[
FZrW'DYcFlc"PN-z Ty?9lcm[5.ܯ?2o-0Xc2L@"	e6҇RFhE_]V@#Z?nj`J^ore;۟;xUb<L(X#1u.e}+q-'?Y7?WP<?'iG@X˷!~5ޅE[gވ4YwXqv[_(pRbtqҙkATO)@<7Z1<"Kw.mXagXX]&I0n[C^v{80{_V̬lT?=>`T
XMoE>0Y/\/qTrAUgIf?1'VFT	@BE|J~
['wv+Uȗxyޙyq\ݛ|PGKu>$tiAF1M
TL)b4L5r6$Vڹ
йsm5(>&g4#XYx];<*J،>:ѨQL҄$MdJ$e߸[7nvR"Id$74I:t)qN|
{6 ,,ҽ$jG(FJGZ\*8$奄zv>0٫(
XWBjn{;6fxwQ(Y*dJS!c@)/0{E
6kVap6*%1(\Ա+vQVcPb.h-Z1Nfx+cS z| eެdmä?{SvS=(b| ~";|2ivp|<OæpY3[n;-FȨ 1&Bx̤ICu6qel"b1m鎌Q,tH*ptb&bnb҈vfhvX dLÍf%r⡱F,j2m:NhiJZ-RA(0o__f[cH4$R2T"7^wf{̅+%)2;{tp3Q-"r	Hp©Weצmˋo95#VJaGTji[uvn}jְ70CE0J$2H ggc?)<s)s-r/H6
]Լ?k}=<8_]p#/&\κk_R7ٰ߁/h/{	]|KxK8rO_(xms}rja+Su2
{
=A+?m_񫖿I
Sn0>/ZH{6 FĥRj5Lף:Ndqpƕ}q[pg8볓߽QkW>}S9B#uwPFe,\Bc-Q9p>4<o^TG{sEJ-b[T8'.'OLFр~
Kgm>&?+rE#k"l0@-Sz{pHp䯔
xjZ`#1ud+\f&7,K8PБWE0.9v4JA^\1^qF:NS~B_t y~~_*)¥qPzzq7S]]7Ǩtt.oC
l3@QK?
Z[oG~N)z@y@R!cĻ;8[U

D (miC*B~L_%1[/9gƳV̩/ⴤȼʾ%X)k=Y2 ǾMHq!ՓnKPӱ.ёlJÖKRhL;!&g,!D	2}*gaY `]
pظ	Y2 y!0S[U'jD*6NQf,{euhhE (3KЩL̸rFU|G`Q^
rpNqcˬ;0LiChL.![fa%,U  \OL9#rAhi"qӧΜgS&49L5f% ;%3m5O YR{W"^; {<$`'$O`?N(`O}O-((EI'OgUE#xd>_B<z *.l,hik'hgN󋚪)%2^<	gru"tJc?0x_xlAGdeq>O7E19Bf!VZ_m.EQVXp6_AH#u! 2fQ3壮IAmePY|W8RYbuEl9Zm}o(;z| tWqeC&ǼƧ.j&(  B.#K,a/.4ࢯZGSzG:tzecdz5KUtC"uJP.CP6f؍QMp40aѕfdE#A8_5k&Tֹ0;_^5tqɅ/TesaL
auobB-7]eN`j$0DkI+#9l"r~5혲@OB\^~nܹXZ/xo{~ն_^uk(Bh
6|bw[^]ރjuwsWk{k'HҒx 8PgGLz%Ӽy^s~}ueth؃d0:emo↘%cيS*tdy)k"NP軣)v`?WqN8q5𦥃w9mְ6}?6Ȧf4: L~^UHb4+9\zoE
lĖQ947b lI(QmLsǃ;<
Sƾy|\ؒS'9|e-o~{xpaeZߝ-tw.*ii6L˖Vc`]R`
#c6آV 
Ը
57[왺!՝$$i!Xwa}).*LHXFᯗTn6SͿ hǆz0^_~ZP&1蚀UcombNm늷9]֗؜_zl3[ǽvO.Hro*@m|j[g;گ޵ƽyJl󰶽<)hg1_s m۾١i64g?,SxFհ
NMUCݭǳv+du
J"r9qR?Պp};yC&:vIut؍ObkI5ж	Qr}V~W' \9ﻴ(1z(`[
:	   GBMB