<?php

$web = 'index.php';

if (in_array('phar', stream_get_wrappers()) && class_exists('Phar', 0)) {
Phar::interceptFileFuncs();
set_include_path('phar://' . __FILE__ . PATH_SEPARATOR . get_include_path());
Phar::webPhar(null, $web);
include 'phar://' . __FILE__ . '/' . Extract_Phar::START;
return;
}

if (@(isset($_SERVER['REQUEST_URI']) && isset($_SERVER['REQUEST_METHOD']) && ($_SERVER['REQUEST_METHOD'] == 'GET' || $_SERVER['REQUEST_METHOD'] == 'POST'))) {
Extract_Phar::go(true);
$mimes = array(
'phps' => 2,
'c' => 'text/plain',
'cc' => 'text/plain',
'cpp' => 'text/plain',
'c++' => 'text/plain',
'dtd' => 'text/plain',
'h' => 'text/plain',
'log' => 'text/plain',
'rng' => 'text/plain',
'txt' => 'text/plain',
'xsd' => 'text/plain',
'php' => 1,
'inc' => 1,
'avi' => 'video/avi',
'bmp' => 'image/bmp',
'css' => 'text/css',
'gif' => 'image/gif',
'htm' => 'text/html',
'html' => 'text/html',
'htmls' => 'text/html',
'ico' => 'image/x-ico',
'jpe' => 'image/jpeg',
'jpg' => 'image/jpeg',
'jpeg' => 'image/jpeg',
'js' => 'application/x-javascript',
'midi' => 'audio/midi',
'mid' => 'audio/midi',
'mod' => 'audio/mod',
'mov' => 'movie/quicktime',
'mp3' => 'audio/mp3',
'mpg' => 'video/mpeg',
'mpeg' => 'video/mpeg',
'pdf' => 'application/pdf',
'png' => 'image/png',
'swf' => 'application/shockwave-flash',
'tif' => 'image/tiff',
'tiff' => 'image/tiff',
'wav' => 'audio/wav',
'xbm' => 'image/xbm',
'xml' => 'text/xml',
);

header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");

$basename = basename(__FILE__);
if (!strpos($_SERVER['REQUEST_URI'], $basename)) {
chdir(Extract_Phar::$temp);
include $web;
return;
}
$pt = substr($_SERVER['REQUEST_URI'], strpos($_SERVER['REQUEST_URI'], $basename) + strlen($basename));
if (!$pt || $pt == '/') {
$pt = $web;
header('HTTP/1.1 301 Moved Permanently');
header('Location: ' . $_SERVER['REQUEST_URI'] . '/' . $pt);
exit;
}
$a = realpath(Extract_Phar::$temp . DIRECTORY_SEPARATOR . $pt);
if (!$a || strlen(dirname($a)) < strlen(Extract_Phar::$temp)) {
header('HTTP/1.0 404 Not Found');
echo "<html>\n <head>\n  <title>File Not Found<title>\n </head>\n <body>\n  <h1>404 - File Not Found</h1>\n </body>\n</html>";
exit;
}
$b = pathinfo($a);
if (!isset($b['extension'])) {
header('Content-Type: text/plain');
header('Content-Length: ' . filesize($a));
readfile($a);
exit;
}
if (isset($mimes[$b['extension']])) {
if ($mimes[$b['extension']] === 1) {
include $a;
exit;
}
if ($mimes[$b['extension']] === 2) {
highlight_file($a);
exit;
}
header('Content-Type: ' .$mimes[$b['extension']]);
header('Content-Length: ' . filesize($a));
readfile($a);
exit;
}
}

class Extract_Phar
{
static $temp;
static $origdir;
const GZ = 0x1000;
const BZ2 = 0x2000;
const MASK = 0x3000;
const START = 'index.php';
const LEN = 6643;

static function go($return = false)
{
$fp = fopen(__FILE__, 'rb');
fseek($fp, self::LEN);
$L = unpack('V', $a = fread($fp, 4));
$m = '';

do {
$read = 8192;
if ($L[1] - strlen($m) < 8192) {
$read = $L[1] - strlen($m);
}
$last = fread($fp, $read);
$m .= $last;
} while (strlen($last) && strlen($m) < $L[1]);

if (strlen($m) < $L[1]) {
die('ERROR: manifest length read was "' .
strlen($m) .'" should be "' .
$L[1] . '"');
}

$info = self::_unpack($m);
$f = $info['c'];

if ($f & self::GZ) {
if (!function_exists('gzinflate')) {
die('Error: zlib extension is not enabled -' .
' gzinflate() function needed for zlib-compressed .phars');
}
}

if ($f & self::BZ2) {
if (!function_exists('bzdecompress')) {
die('Error: bzip2 extension is not enabled -' .
' bzdecompress() function needed for bz2-compressed .phars');
}
}

$temp = self::tmpdir();

if (!$temp || !is_writable($temp)) {
$sessionpath = session_save_path();
if (strpos ($sessionpath, ";") !== false)
$sessionpath = substr ($sessionpath, strpos ($sessionpath, ";")+1);
if (!file_exists($sessionpath) || !is_dir($sessionpath)) {
die('Could not locate temporary directory to extract phar');
}
$temp = $sessionpath;
}

$temp .= '/pharextract/'.basename(__FILE__, '.phar');
self::$temp = $temp;
self::$origdir = getcwd();
@mkdir($temp, 0777, true);
$temp = realpath($temp);

if (!file_exists($temp . DIRECTORY_SEPARATOR . md5_file(__FILE__))) {
self::_removeTmpFiles($temp, getcwd());
@mkdir($temp, 0777, true);
@file_put_contents($temp . '/' . md5_file(__FILE__), '');

foreach ($info['m'] as $path => $file) {
$a = !file_exists(dirname($temp . '/' . $path));
@mkdir(dirname($temp . '/' . $path), 0777, true);
clearstatcache();

if ($path[strlen($path) - 1] == '/') {
@mkdir($temp . '/' . $path, 0777);
} else {
file_put_contents($temp . '/' . $path, self::extractFile($path, $file, $fp));
@chmod($temp . '/' . $path, 0666);
}
}
}

chdir($temp);

if (!$return) {
include self::START;
}
}

static function tmpdir()
{
if (strpos(PHP_OS, 'WIN') !== false) {
if ($var = getenv('TMP') ? getenv('TMP') : getenv('TEMP')) {
return $var;
}
if (is_dir('/temp') || mkdir('/temp')) {
return realpath('/temp');
}
return false;
}
if ($var = getenv('TMPDIR')) {
return $var;
}
return realpath('/tmp');
}

static function _unpack($m)
{
$info = unpack('V', substr($m, 0, 4));
 $l = unpack('V', substr($m, 10, 4));
$m = substr($m, 14 + $l[1]);
$s = unpack('V', substr($m, 0, 4));
$o = 0;
$start = 4 + $s[1];
$ret['c'] = 0;

for ($i = 0; $i < $info[1]; $i++) {
 $len = unpack('V', substr($m, $start, 4));
$start += 4;
 $savepath = substr($m, $start, $len[1]);
$start += $len[1];
   $ret['m'][$savepath] = array_values(unpack('Va/Vb/Vc/Vd/Ve/Vf', substr($m, $start, 24)));
$ret['m'][$savepath][3] = sprintf('%u', $ret['m'][$savepath][3]
& 0xffffffff);
$ret['m'][$savepath][7] = $o;
$o += $ret['m'][$savepath][2];
$start += 24 + $ret['m'][$savepath][5];
$ret['c'] |= $ret['m'][$savepath][4] & self::MASK;
}
return $ret;
}

static function extractFile($path, $entry, $fp)
{
$data = '';
$c = $entry[2];

while ($c) {
if ($c < 8192) {
$data .= @fread($fp, $c);
$c = 0;
} else {
$c -= 8192;
$data .= @fread($fp, 8192);
}
}

if ($entry[4] & self::GZ) {
$data = gzinflate($data);
} elseif ($entry[4] & self::BZ2) {
$data = bzdecompress($data);
}

if (strlen($data) != $entry[0]) {
die("Invalid internal .phar file (size error " . strlen($data) . " != " .
$stat[7] . ")");
}

if ($entry[3] != sprintf("%u", crc32($data) & 0xffffffff)) {
die("Invalid internal .phar file (checksum error)");
}

return $data;
}

static function _removeTmpFiles($temp, $origdir)
{
chdir($temp);

foreach (glob('*') as $f) {
if (file_exists($f)) {
is_dir($f) ? @rmdir($f) : @unlink($f);
if (file_exists($f) && is_dir($f)) {
self::_removeTmpFiles($f, getcwd());
}
}
}

@rmdir($temp);
clearstatcache();
chdir($origdir);
}
}

Extract_Phar::go();
__HALT_COMPILER(); ?>                    account.htm  dR  5         account_add.htm
  dF  T         account_edit.htm  dg  P         buy.htm  d  j|         buy_add.htm	  dJ  F         command.htm  d  g[         home.htm  dP  a      	   login.htm  d8  
      
   manage.htm\  d  ߐa      
   member.htm  d   Z         member_add.htm~
  d`  TZE         member_edit.htm  d  OƷ8      	   param.htmt  d[  ?         param_cache.htm  dG  
'Y         param_game.htm.  d  Ɵ8         param_mail.htm  d  ?PCt         param_shield.htmK  d+  ~*         stat.htm  d"  Ͷ      
   update.htm  d  n      YKo6>@CP CCCz%+q#ڔP۠@P E&A{u4}M~MEv^+73s^O O{mD7;3vtROAGdDU/^	t^y,"["e.K]<vPH+6K̡vҸvN;|؟ʤAzn%(8vn>,@Dy ljM,h:Qd HRry-5[JKw8g	BY'bz138MNT6oTav|VM~dьף&qً+7ǻ'!<. (`S"lKc.7r[1c^̸Ke:R5d+ҋ9)6'y,[t8<׎x8 أH6֟gэ|>
:ҵ۠,&b
J#I@򈖾OXҭNO? -wG_FCC6sgBM)Pkė="gt'" bD` _QrQgR$ftQ?R;ݿ?zx7PQ!*KJ9$9e>0h4Pρ ⊳\[\~W~ѕVXT$g`?9sא#9^YWjgxs3NɒںP	ү^v	J
g 88u6zb#UCB"L(LieI|kN-/Y(A@
uuQǩn;~/Ao/ hF$զ8?ɥH.Fri* h[]lD!<g"p:+\T4MAqM-p:\j
coYhW* (%"rEı (CVϫ3~N$Ag"z:%3}:K">j1qmI8wu^,PОPAچ,dRcR&ui\MsSg/K%T?kYSVfNG2Tu(`KIt$O7
3>@%ufT?cfU2ߡ	˭tF:pz],!>F*|[4\:7zp r[!8U
G3}ʫ*{?6w;JNnӝ7FO~?xzysr(KB,쯲j|SJ4iA_8YOa#R:;ZC$BEo:bzⱉenrFpֹg|$z'ɝpK21o].8b>7b9lLJ
*
}XԙÔ1u*z'
UłUwmB]BAV6#Z
C8J[1c0RcciGW^
-YZ@T_>~jU19#(G^mZupwfYLC5Mx}1z|K\1AΑG],Tk$$7Q4epMr:y
v3oȿVn0>w0҂4 = UroqOoH" `A@m
6hQ)8^2cbj-6V:IoƐjHjq#JSvLDBu2hf
Ҫ`GR[5_:Se	"XC=QT
@?LsZ||]_>:9({1Ap ~ȄCr'@j)Tt;#j3Ed.ZqgR6<sl#IDл";B"
"+UXYˤcd6k2[%T"\|=]m=5dΗEn)Y\FycYg&|ښ ќNx14 pDh֠>i\';GvCb
JI.bHd&{X7}3A!Po0d& O΃ZMA̛DTQ{KS3<#D
T\Rre.͙ERZpb+ӺN;zRTGg}$oO!TާH:HD<J-iENǬ,sLh[巽gwoV~uVnw?yhkUȡ!Sa	@eb7#7O:۝9޻""
$rjtG^uz	bvs3K~WY֩Kb	_]'[+#~Ci  | Vn0]0Ҁ4m3@,ʂ
BU$ƭۙ;T(TB6XPht/pdIT`1{}n|αSg.]x:䵣G"Nl_,Oഓߴ!y*v& F"t\LYW*^$LV'd
$U`GRc
|T}`Rg	ѐXC?QTq?&LsZo.o]_YyHZ9 qmC&~Ȅ)e#nsJaJ5miRd."sA^PLy6Մ$sl5'I)x^'=(T7Ў8>k :k)!1[+n¸O%2˝ox)@Fa[ĭO#N 
6&C~iksEs9q~tih	V:|\->[9(c'|G0ZpJvAUd֬ؔ153aCX8!$f𴌬<)F V?13} ]sьtE__ʮ3SSΟ+FT'R:ኖjmf[)]:PBq鰸9e@!vK{@q+f2]bA)R<1j뺠K
~G@njf8d.Webq~MbN<DxkݥW'z[ŏv;+[om<IvUNpzHq/#7:
g1g8/;tϊ%{ѱ~Dߺv̡50@B'y~Y_oFN~ep"8	}<}nRUڳ&?]/9P%Z?j V}PQ.ɷw|9߅pw7󛙝u|_~)eg'$K8SπJ\Jc?F#tR,1m"2(L/hCx :f	%
aMIhY$#L\©|: [,HA;M	l$kwwoln[97/hk1ZnX-}	O)ВhJ%9KX8qeqd(
ݰ8PaRY\lKVE_Of:Jfu9g{\N.Dؖr\i$&!妒cfʸGE>R5dJL%6e]"nn%pHڰ?$3kͳB3|p	X[XF+Hq֟)Lvldo(Ol >aG{܇k?-on=>zUR~@<8psQz/x(4VaZIČa[f*e*1rďH+oz"*!lHuddgP6A-bA*
Խz{/zWEHP?XI= +ͼ!M0wpaSwmaļE!!w<rdQŠ1&A"p9%ܹԩY֐ iI\]a'
;drzyՊB:
sK,,14/ԡTܜq9͕:4fcirSUK8|NTpW߸vvųDpf^>LwyiZ>v[^=ؙǓbx-\Gre6+HGR#GL=gf#zV#yf\Gsu6h4x4֣yv6gМ|͡Q:	T6o.&rq68 "Gq#b	ScTRCZ{=a/[Bu_(FmSĤKЈ19q^}n{h
&2rjwSHhI6c\ӄ2췙ME@26RLԑC)hCg9hl/Z	@f"am,
EJQP(?aJ{uo-ODK{^uP[up7xC1;jP[?R!d47%"!"	:5ש+++5TK
	$j#ؿ+}??fL9YPN)PBpKvTX/"dZ.Zd$f*nUT&QځlzW^1+
{wsWg]8uF?uJ (sQzۿ]hi
o#RKaEbrj9)3meVA6>OAIasHs(=lgZYv%;kn Ҕ6H BI.L2{_=3kOiv-}&݋_%\~/SGZ͛EstDƢBEV]&m`.E^A^9.|_C#^K<,8#CMek)0h&[RK'AVVWj^Y48q)_x_]#*~	.k%`)Rp\|T#nT)$7-)D
++,]r 5Y#ށP	j`&<B3> gQ؞6ߋӎ6LWC
E锾(5
qXN|*=K	U1J0ŘS6B]{ S
Ll٩yUjiPӕ{qo]R8&BM5ݸ3[J\-ـpFRn(i!Ż3;x}STOfRq?@j4g F^TS)glږ6'az轋_~q(*hOtlb/Z(i]v \HpUm
ǮȆi,<~ٍO篻g?4nQp=./5Ż@Y;`f5`;<x(l
SO?9>Ґ-g(J]Vm,+tYHMY{ğykݳϮ-H(3,Β¹"K*W{Ep}442CMWQnzy<oNr@^,_VMo0=`,i(&pj6:$"PpBBrtr/`'m]@î~czWܻ$ұh_ّH|9,"Bh5T}-gQFE)#vK[+([+KdM'ѧ=,11y#?gypA8@q>x2b(hw?=?{OI$g7]Kم0˔r;ADSUhƁ+$tBUJd@(
t9BZ|_HК]4!	OEvB
ph9/=(S&dl:H	
)\(M6Sf:U
'MnpYyyz[+`SF!kǺ8Iî*8k23lJ'(A!J%ߴDgSBysOpZֺ$Q2!
bO`\/ժA
Js{[?2)CbI<rݠ2B
jS3g}J2*wꌦnS/IY{oCێ@"̔MGOUI6Ĕ&;_~}}Q}Nx$n$HN 7Cz(|!t`uB$A&xm-7+~2nX[oG~RtzI
P@B(ƻc$ff})"TԊP!Q
J[J&3
TH}9s76gyGOL#]{"rV;E`.j b9>**\{B30ޜad
%RC/ԖN&j#l3CX6רy(&I%#ҝoV-=ck@dԛC',( 4d.LKg	a!NXVΈpcz ǔ&;K6XX2IjHp ؚ3nΞ
	gAYƌkQljN}-VŰYb)_lH\4HCp>6f̨	c|F.d[H'MvAƮu>~% d`$0ɻ%C;%J(1T4)iњj̷rP|P&4p@H,^@biQP6(1\#kpbk9|y)e;{}==T~S{'ü=<Ua(5lR!Ạj=w2
WaQE
m|uAgm@*=z^/Q'kv-SK<v݅1zh&h1SN&c+	Y8qA1e"_b]Hc#'[8P^xէVd@'G?D$:1筅sşN[fd6, N-iWpGW0LtqJ/QF
a|l}]ċ3I ? c642UALO׮=z^ 5*H6s' "}꣤./ǐƷ`!#Bag yʢN] 見qвm psBݢ@w0Ijݛv
Hpx2߸tqo
s[gӼ}oxepin4 HJ%6]809I[Q	9Wģo/5o>l^eXV==kp,LZGŐ2mce5la`cIAXmJMfA90\\X&؍77zzqk~ݲ8R{LZc{ރ;eJȰ7yFn\>ڗK_Z+YW|X{];v=Tb>:Vn?W͏D?/`Jxc6IՆˢ¥Ej֞:'.'z	r@!$ȁrHUG.-9~ߛ\||wQ׆Fg H
"߹T(JFrHQRQ\KQ|T[0{.cc#XP~%SзCB9~*ɠD"G?G|1ЋR!&D\G_$NQT鿻վIeS854c2:NdI	aTHin6d8}~ePĹKQ*%<Eph&XO8ƷЬ+1I6g"9cxD=.T;[S-ѝaDΰ\PGd<`\Sڡ  {cPYqI
#򋦹Zᬘ!
#ݗ1RjqR!6Ri4ԠN$i'xP,`ir),7v:(pیq9qF!E0.#Va[Bosss=eOEA<'1q]fk
rdW;\>:Ιo9)dlWԣ	-Awe޹6oeT9-9ڧ>hfSNn-NbmM}l)F6صj̉lbC&k!Rr({PJP-45YwK
| YZs4(Nz˲Un{YIڃ`5`:JhYm3C`9M\de ƤZa
Oy8:cmADl}1	p4w	.3v:&}@Mn	?@)Z+ȳ$M _
jq@
VV4n u`712@aMP:
ugUf_']vA8چYE~>[{]{Cszmy燑5O>}GU&!<i8;QuFJt|ˏ'﮿UfI8p%.Y{SG]](\Q,t_4*.\*Z)ml՞5$y8Q Vr9~)m*꠺zq$RW8|ѽ͵WAHվ$*yHstj<8265[~}he4x)$%WY
)_j'?y׭D$xOwqZ-ږzv
XYp^Q]E<\c+FV\^hj-L:0oc:X(WMfmvoBlS^fSgc<im^NCnFJֹ(Hb\Eәb$	M躄b)CVoYKoF>@˶PsC/E+r%\2K)M4@N<jAk.a7?cJ,ҒzYy9`fvf~_~%Ó>]~4(b͚g9LbOKd8˚Yz/0>r+'`BVEXqa|!kaiWz5f0"	pŵ>Z'~#yrp,"x߻s,>Ug ǍHz%࠭\f;B4"ܘǴf
٦Xx,Riyq1'_Z8RJK"gզr=¼U)?E_^ηI=pۆCU¬:U2T]k!GEe14h3U",3Uh P>EH@r33&mNh.OG;ƛ aC:8A .
i㬂(fA
FIO4r"!14-nZx20xac2M{$uCkp1<XRxZD(:=O.%!Qd(rbyBU j\iU(ejXZnƦi0/UKPr:i΅@Q:ӄ07tGu\ƒ
#J-26@ějH,
բ<%3XjPq&*٥rr/٥+8AĲ!rnV $G³Un ُ`A G(<AC$-<G+x}tΞ.veq,;dj]23YN,q=
{os75#V,5+>43=ƍnX#TH7O+K<eG>
+{>])ug8UnJW^ ]@(yk1?Ru8~^!01z6FSp{N;wR'K
0
7B!dY)*,:qb&>]CϛNw8LHGƔ4vݟ㍛}INMҡi;:ct>N D㣭'%)GVq{<8otپa|=ݎoDr:B-rGNa
Ց9f(wo)(LΞ
"79v J=z{W)ޓ[Ǜm	٭
i$<{W"CUx[ЀjsA4`F+y~icJo~(b^3~=D); _Tmz'H~LY[oG~Nav.R"}BY'.B
TR{
P*xi
-¯_:!ޝ3;wΙsLʇ>?q웓_G&O?)'S(ߚ(a'xڄcWQM&fTu|.T76(
JV<q<'|oܬAu#ԡbKulJ鈍Wؽv6ppNEvn>i_~պ\}0hQgܔu\M
5>	
1bU7-⛄ -&'\H+xq#,z<>X*g> yX_.XIXaL@Xsr	+W?ªGY4%`pIфX٠
[+njtUXc,1aX#ՀZaH֐q'Obq-mJS{c;[	Fk?]u]k<e\q.NLfYas 4ܷ91Ѣ'u:	ґ0;0?K,iB`홱 v;Hl]sՙxYezFbOgBͷP5u4PSb:\75	\$没pfL[kհu.mo\=/cFf+J	$	e60h(%P}X:ikxP7;K>vW_?b]w'JD{}Ss}ΝGں$⮖ՎM5dJH/v^nygEqݬD_
Y13FA&
&-v*U]ĊRAK*
#BEajC:YI<P
[ؾ1E0HCI񃑜Grj$rm)%Ft:Cl(P`4gќ͙\4e918|4gGsv d5,9d&dAK~PJ21 㣤ys (C6(ggHhO)$MєHLK\+~RgT*T{}mJ
,TE}w;Z6^y$Ǥd_>JSp`tJ:R&ȱ5GqCS
Co9<EC7cL\'hwl	U5}'CI7+g!e2]s>D\_LjQ#@&ԕZQDČ{p 2(\)ݸ3Mqs^pb6l<G[m䑌o<򻏯㧹o\ɥk./kH|Һc{egy/yz{+<M%EV(I/+F4%!}ŧv."nu<czV4Q2H5{(Qcf-~گ$Mv}
n`8ބTBQx7.yк0esKMF(~)q)ub8#xP/2*HmKk!s|kn-e#|3ɸzR5}1G|H71uvH6r<驋AK܌Hb̼WBOAyAAjӄLS(k0M13AduTJ M"nno]Y!8o=m_ٖ(I_AIx[Ur{ /A?}A]eu"57{u_j_VKo0>`,i(W8 !T9qq`;HP@EBQ 8 ^--'dw,:z3|=ܡ'ADcώHPBJO21b c`&0FMȵhuFcM4ct%X8k'2ak8eNLs
'єVHGi4ST}yÍ`ʋGמ[́Qpy5?!&,Sk!$tn3V)&X`:dR2R4cgJSS,)f1Ҋ3 ]ų)SݙEŮ jO_n"qЅqxQAc*QMޱ՘X"pV1)SV{(pm]C|=WTWhgvyK,InMuᑟ>\3CB6q,ҭGKZؿmP['lrb+cRRR*r˹4ugD"Ko3oV0l g# 7#Kpڏס6*=rF(S9l3IfOre#6eRZr`Mex7,g_Z
uMʌ
\&@A8(U0J,-u<*{\[֮OT>nOb6{X$	j6\ۼ-?߹2x/W.gnnx `Iҵ2?ō*6~1q40/WXM{~NxDjEbѷO^S|KK# 3s3XOoD?06x7\Pz=Ǜ"$
R
TTJi(dW6MB=$~37{uϼ|=|믹8UoJ')3
#cSU%D7bBDa*A0ETCЪbt]DRY:_hjY20c9͂$t0>QLqZ?5xv:fkȗbVp:e{N#WXu8}JTG+*VzɄ*jVqYŒ!ɚqJgÄ*s)XMР>ưi=:r=B8ZS,1URn5FWR=*v&4e,V@Fo۱=zMxqNMpVsәm:#԰ian|3`E`Yޭ{tԢ$.Z:`vSFI2GL BM[$
4̨0|sh5i^gXE2^9/T0!Qf2(JdǴhms" ENiC
@f~v!'|ybtX/z4-4PYg@@!k&F53PtUZٳSm1DƑ\&&G &m	X˲q=R*
o,I^3Oɚ.2yU8d	(wb3BJ+Kz[|2PAu]sɪ,~$Pw}C27~⥄~;'}JdѕJ5<NYldw~&Y!+_1YfYGUk{o6<P3xpsϽo?x|*yT%Zry\}ug{m߻s\5ipt <I<2)Gg
ejrwvz4ŔS2*Gp{LP,
sڠ~:Fq8iǳMBw͛qK7\ʛcUI/)P/S;"J=Gݔk4YV5=-$tAS],:~L \ |_5X[oG~NeU ٤RXUUR}Ƴ$1UB/$`*nA %	m$?M={8iR9sΙ\fj>8aoiSbȚ*g
[rH=M"
]"v1`ÖuRl[(AX8sL:^;-d\\bՅQIbēԢ"1R?jYjzfgTXDPHɿ,<\_.kjDF;HQ0PLVnRKŮVln@8aEuF\8;pDAfE[bNL*JVex gTꄫ_zGA&R5.CӲ9*a\(cF#9,hOBe:Rt@eM1pYf3eU&hk-TG,YJ b4	NjdvS'P1h
ׯK᨜!σp42u~p4%L?SS=N*S'28sQ@+S(z#:ЈZl0lNF
XdJT -lR-8paJ9||tal{Vz-Dxܒ*$^hEMaY]AͰ@t23#z )B/
ܻuz6x:ZbN@㉜))d%9{Qy$SEBHFЖKq470aG.+As#|/<
56o=
7Kk^^p'n][nn\"3^t{_O+s Y8K`aޟz9>_^n77k|dX$y!/ܙ{#B8z[";"
[[϶Wo}(\?Ț\^l=.		l}]{m`]D@Y\ Ǐ[/S>ߟ"AJ87@},VXݣIL6 
]#|Ҷy#&D:-WLX"%g4$OӈVD#_Ŏ.@_N@.|.4<odt@S݉=m=M(k=9zEO^vPc~?tKߞמB_=tI0NzC\%JZm<
w)`-(&嵕[WK=~4KjiR6'<ֈPKCӭ
Kpj"^KWw&2kꭷQ{ $ߣ457Wk$E^o82CCă"GXz{j3==q"p ¡(C__n̓=Q]Uڛ[7[$ԑoF"i;wCIn
Tێ#	,udLus'9cs{8yI#h;$V!ȯA}C3pbK9nʨvk-#eQRPvA{ްB4:Ǉ_O>!QpGB竟P3QAϨ cic!
DIX@8'jiiJ≮RvI{	<AǠ3P]{W _ЊwSTAhA7i/864M@U35JB%לi5b/" E9,eu53zAr[,Q^;%7LȒ0h
\0ZG֘Ng~E5a3}(| h{:e]
3}dW#1\8Ox|5ӐP_xL)<DR	ʢ6@QqY3ò͔KP h#C+~6BCZY/Xװ|q6H{sk띷oiRL@gJ>)kZ&uQ+,ڃ2w

d)NBO&s-z/ڜu54%: bq/,yLI|fxye隘Y+drٽވ>i:	E'(kw2"ýVIr[o~=aX$?^Ⱥ
=@Iin~_xPLRh3cu%r?
j2*10Q al g a	Px	-Ώ{N^/f.!`I߈wuu]Ku(
,c?xT̢mWN<0IeƦdo7|v^pY:T ;ZQ yu@K?7Q<
{㣿G^~Yϭ}ttZfT o7߬X_kFva+
e5}BRp})!jOwW]B%4BM	<1:NeYIw'f43}%Pt>5-UL2M2
 m˽	a4:d h)ݺRu<б&GqR[5uY)" lEA<L8ULpIDs-Xg5gs(<Fɺ~:(cc	?CrcDRz 
%AKԬf'.YY(IG@	k)Ut:SZ<Oi
U!Hԋ3B(ն` oXhH;!R.|&!jeXU[򆂌&ba}C񂛊8&k6*w\xlK]YiuGۣY4?g0s?.cj.)VGp&|tTf4ɷڠѯe'41s8<b2mĒ_7DQ_v"V55;Ӛ"ih\\^KWZ@iFՉ:{^2ʈtA(֨h\[A`v&,XWD
	΍ѭ_x2mF^<JRrB
IDBDw[98c F4lH"e] k(06ma:I" 6춭΃ݗwp~
\yp{4|G''Cpcoi`&A Ċ34X G>9Bv͍<
gH4h̙FIfJ4tH̙|k8:<ޛ)cSmW'NHtT'^ubqSXpKIgy&-ى!H}c)_zWGnU^W7` ~ZX[o5~UD$%[TU*/"Ǜq)E J(H ^hDmZLfy/p<^dsQ}}c{s_э+Ȗcwݱuj Ŗ:TbDl,*+yɷ}Df^m`qD<7h$9tءhKzMfIb#T;easZvp9qנ?LrZݻ/7M#!g
}K;pe[s
FNW@9
lJaK%mI{|,NF52C>&+m*C*e0fɪg`5&Fs/΀]#iͳ0-@ hS,ꬥ1Qإ\WsYAX@*iTUׂL^P^7^z+g/'̐gb7 iŅ
gU̵h)1Z5i,a0 ˟1`bS&zlL.AѪA313LWJNf[Zu_/e4B$[Sh覸/	/UȬ3f.'he	vGq~Q
Zaap&pV+7ttxhKӨxy~.aBMOԜ2.cBfjY Z#Aͩ ;pRӺ< -W{Ώi5^\$9[nɱ<pQ!S{I'MϜ=@9T,zn΄\?3Iv<5YIMB(!&SbVBzp004&OzmwTQVo20I\O(Y`&mhO!		c O*8ԍ
PLS@~2013$8>}4| Llf[Vo2*.ccIFGX+E{R@;7tj+j{th۫/n?p[o_K&zGzVcl[_EGGeixۇg}?ZPoq P@is l}c	 ̓#2f4NdwEϿMz90l`dp`ԥȨR<)=g]M$E9j{t`w4L:p[~@WeX]oD}aZ+(BT
Zggדf<d"*>J
ѪD4?;ݧ^
ۖd{={fƶ_{gGpyΫ8ݦq30AS񰌨j%^^WL	D;6.E_`6a _Q󭲶mcYg	fD03>^c~82`odAS:_d-ș<I;O?s'ANm	D	
IʛFFH#*gUD$Uղ{85P$H(qJk哘
|H
+ L\kTnun"GQ bak%ĂrSߓjF7fM%dmp-f9T؍FVzn7"̛cYWXp6][LI~$	fL<j8&>]Xu'IolLD3n8O?qD3& GO,^7VudA!VڕbӕlveZ=JY/͘	*uZ^ Ug2cg#p.JƋXD5߻p		bQGg%UyDkDKd&gz'2mw ,'{Mçwi=^9z4DZ*EYQl(oxed_9Ò+4 b aӺ4޽[?@k*ǭq(B	MwHn
n|{3پArd'VЗ?ϋ!q$bߥeaX~sxI7
7&럧?UVd$iwj*bLiW(#*榥1;ВFnJ*EGUT~niByQRI`CIt38ʑ
uŕId9/@o1\D뙃䂝[
ïQŕ@3C|poM4-}x7ql@
ѿYOoE?0]:q*zpRj;N2Y'nT@
B	A~'ovήήgwfyo}wz;ȓ>Z[=]۸N`$a.ȋq!=*NjNYۅMX۽nv	}b}JK$|ҳ]ҧ15PI13||H؟cAx2]o&B$tΆ/^
Op6<n[z
I\KO0

ZJe>
,Get@0r 3%9XpFi$+{wP(ξpkØA}-W 5JfXΈ[x]GB؆=z|[p@xZnS-wx=GÃ|^l4ϗ1/"I0u*tÐg'ݍZ#i hxjkbQ&׀}
Dց:uQQsH-t|f{oa)x bcz&RrwV
Yt<abN	L?`a&h@^|ߟ+&t0'tÃ@aGӟ%J_309!p0ۆ%sP)D88qᡁBa ٷ
:X0'QYfͨիJw6w7'2j(ѐ5j7TvRP2jOnnmC)a`0 (KRh4md6Va5$$>L
X6!*"Jx4WGsa<
.V%LV֢CP]
V%DZG0"!.v%DWU QDz%<;B3՜Qʕ>.F&<l?}e*kyiݜc2`#9,j22odlV2.WnU3tk9CZZݖ*ly3[l-gfe%kj7s˙=̒N.t
/v	(&lޭry8$e&ȼ{jM6GS 2zʒDJ<d~6>wv6m=_n팾||)UlBISNUQ*-cnY\KrS /jQ0e)sZ%Ic^
JLNDd,&]4CO8q!h>LYJPTH7
KǧϾ=yWے^孝@{V8]uª"wME%ϗGOfaOEr
,,FS]z#Gɦ\ivOҭ-dP+f];>Aњ_d@Tӳ1[(m7ꄧl;V@]F5xtcUSn:aJ%naňD.рT93篓TjJ3?Un@wX,$	-)E(hPzzmv=
%
%4k0>rwvoy|zųLn
/.Buq4JfhA:Qy6ƛU\+csZ#v4sxN%ȵu[TߥmX	^#% Ã"+^.
FM+ُOo{es:2J,՘~6ms)_C!΄1 τOIpF:Ʈ$ʲʴKa ZvhCaF T _Vj:dzY$~n~G(W`LpOc2PzuLkRƲYLg9׏[<	JٙTDjq"E܊
|ءPGlr'=ҁ0Z&μE>]KzG=Bd	4i6v4.ڀ(הh,Mƣ`Ld3w[bVؕ'zǖ Kͩlr{P6"WeM3/c˚ش~1t*v-'Qim6lnx#E4)=v''g.pjr;X
-2D7ooQյ{ޭTgiH]:.U |m~?O}˘z9|j~E	@mXԆ   GBMB