﻿//----------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All rights reserved.
//----------------------------------------------------------------

using System;
using System.ServiceModel;

namespace Microsoft.Samples.Udp
{
    class UdpTestClient
    {
        static void Main(string[] args)
        {
            Console.Out.WriteLine("Testing Udp From Imported Files Generated By SvcUtil.");

            //the endpointConfigurationName parameter must reflect the one in config.
            DatagramContractClient datagramClient = new DatagramContractClient("CustomBinding_IDatagramContract");
            try
            {
                for (int i = 0; i < 5; i++)
                {
                    datagramClient.Hello();
                }

                datagramClient.Close();
            }
            catch (TimeoutException)
            {
                datagramClient.Abort();
            }
            catch (CommunicationException)
            {
                datagramClient.Abort();
            }
            catch (Exception)
            {
                datagramClient.Abort();
                throw;
            }

            //the endpointConfigurationName parameter must reflect the one in config.
            CalculatorContractClient calculatorClient = new CalculatorContractClient("SampleProfileUdpBinding_ICalculatorContract");
            try
            {
                for (int i = 0; i < 5; ++i)
                {
                    Console.WriteLine(calculatorClient.Add(i, i * 2));
                }
                calculatorClient.Close();
            }
            catch (TimeoutException)
            {
                calculatorClient.Abort();
            }
            catch (CommunicationException)
            {
                calculatorClient.Abort();
            }
            catch (Exception)
            {
                calculatorClient.Abort();
                throw;
            }

            Console.Out.WriteLine("Press <ENTER> to complete test.");
            Console.In.ReadLine();
        }
    }
}
