﻿'  Copyright (c) Microsoft Corporation. All rights reserved.

Imports System.ServiceModel
Imports System.Threading
Imports System.Transactions

Namespace Microsoft.ServiceModel.Samples
	Friend Class UdpTestClient
		Shared Sub Main(ByVal args() As String)
			Console.Out.WriteLine("Testing Udp From Imported Files Generated By SvcUtil.")

			' the endpointConfigurationName parameter must reflect the one in config.
			Dim datagramClient As New DatagramContractClient("CustomBinding_IDatagramContract")
			Try
                For i = 0 To 4
                    datagramClient.Hello()
                Next i

				datagramClient.Close()
			Catch e1 As TimeoutException
				datagramClient.Abort()
			Catch e2 As CommunicationException
				datagramClient.Abort()
			Catch e3 As Exception
				datagramClient.Abort()
				Throw
			End Try

            Thread.Sleep(5000) 'want to wait 3s for the service to finish processing first batch of messages.

			' the endpointConfigurationName parameter must reflect the one in config.
			Dim calculatorClient As New CalculatorContractClient("SampleProfileUdpBinding_ICalculatorContract")

			' Add a TransactionFlowBehavior, which in turn adds a message inspector that appends the current 
			' transaction on the message (via a TransactionFlowProperty). We need this in order to ensure 
			' that the channel receives the current transaction (the framework may call the channel on a different 
			' thread, and the current transaction would be missing) and flows it to the service.
			calculatorClient.Endpoint.Behaviors.Add(New TransactionFlowBehavior())

			Try
                For i = 0 To 4
                    ' call the 'Add' service operation under a transaction scope
                    Using ts As New TransactionScope()
                        TransactionInterop.GetDtcTransaction(Transaction.Current) 'promote transaction to DTC in order to have a distributed id
                        Console.WriteLine(calculatorClient.Add(i, i * 2, Transaction.Current.TransactionInformation.DistributedIdentifier))
                        ts.Complete()
                    End Using
                Next i

				calculatorClient.Close()
			Catch e4 As TimeoutException
				calculatorClient.Abort()
			Catch e5 As CommunicationException
				calculatorClient.Abort()
			Catch e6 As Exception
				calculatorClient.Abort()
				Throw
			End Try

			Console.Out.WriteLine("Press <ENTER> to complete test.")
			Console.In.ReadLine()
		End Sub
	End Class
End Namespace
