# Generated by Django 2.0.1 on 2018-02-06 07:56

from django.db import migrations, models
import django.db.models.deletion
import siem.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='LimitRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('is_enabled', models.BooleanField(default=True)),
                ('rule_events', models.BooleanField(default=False)),
                ('rule_category', models.CharField(default='default', max_length=24)),
                ('local_lifespan_days', models.IntegerField()),
                ('backup_lifespan_days', models.IntegerField()),
                ('event_type', models.CharField(default='default', max_length=24)),
                ('severity', models.IntegerField(choices=[(0, 'emerg'), (1, 'alert'), (2, 'crit'), (3, 'err'), (4, 'warning'), (5, 'notice'), (6, 'info'), (7, 'debug')])),
                ('overkill_modifier', models.DecimalField(decimal_places=1, default=1, max_digits=3, validators=[siem.models.validate_modifier_range])),
                ('severity_modifier', models.DecimalField(decimal_places=1, default=1, max_digits=3, validators=[siem.models.validate_modifier_range])),
                ('time_int', models.IntegerField()),
                ('event_limit', models.IntegerField()),
                ('allowed_log_sources', models.IntegerField(default=0)),
                ('message_filter_regex', models.CharField(blank=True, max_length=1024, null=True)),
                ('raw_text_filter_regex', models.CharField(blank=True, max_length=1024, null=True)),
                ('log_source_filter', models.CharField(blank=True, max_length=32, null=True)),
                ('process_filter', models.CharField(blank=True, max_length=32, null=True)),
                ('rulename_filter', models.CharField(blank=True, max_length=32, null=True)),
                ('magnitude_filter', models.IntegerField(blank=True, null=True)),
                ('message', models.CharField(max_length=1024)),
            ],
            options={
                'permissions': (('view_limitrule', 'Can view limit rules'),),
            },
        ),
        migrations.CreateModel(
            name='LogEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('parsed_at', models.DateTimeField(verbose_name=6)),
                ('time_zone', models.CharField(blank=True, max_length=32, null=True)),
                ('eol_date_local', models.DateField()),
                ('eol_date_backup', models.DateField()),
                ('event_type', models.CharField(default='default', max_length=24)),
                ('raw_text', models.CharField(max_length=1280)),
                ('date_stamp', models.CharField(blank=True, max_length=32, null=True)),
                ('log_source', models.CharField(default='', max_length=32)),
                ('facility', models.IntegerField(blank=True, choices=[(0, 'kern'), (1, 'user'), (2, 'mail'), (3, 'daemon'), (4, 'auth'), (5, 'syslog'), (6, 'lpr'), (7, 'news'), (8, 'uucp'), (9, 'clock'), (10, 'authpriv'), (11, 'ftp'), (12, '-'), (13, '-'), (14, '-'), (15, 'cron'), (16, 'local0'), (17, 'local1'), (18, 'local2'), (19, 'local3'), (20, 'local4'), (21, 'local5'), (22, 'local6'), (23, 'local7')], null=True)),
                ('severity', models.IntegerField(blank=True, choices=[(0, 'emerg'), (1, 'alert'), (2, 'crit'), (3, 'err'), (4, 'warning'), (5, 'notice'), (6, 'info'), (7, 'debug')], null=True)),
                ('aggregated_events', models.IntegerField(default=1)),
                ('source_host', models.CharField(default='', max_length=32)),
                ('source_port', models.CharField(default='', max_length=8)),
                ('dest_host', models.CharField(default='', max_length=32)),
                ('dest_port', models.CharField(default='', max_length=8)),
                ('source_process', models.CharField(default='', max_length=24)),
                ('source_pid', models.IntegerField(blank=True, null=True)),
                ('action', models.CharField(default='', max_length=48)),
                ('protocol', models.CharField(default='', max_length=12)),
                ('message', models.CharField(default='', max_length=1024)),
                ('username', models.CharField(default='', max_length=32)),
                ('sessionid', models.CharField(default='', max_length=24)),
                ('ext0', models.CharField(default='', max_length=128)),
                ('ext1', models.CharField(default='', max_length=128)),
                ('ext2', models.CharField(default='', max_length=45)),
                ('ext3', models.CharField(default='', max_length=45)),
                ('ext4', models.CharField(default='', max_length=45)),
                ('ext5', models.CharField(default='', max_length=45)),
                ('ext6', models.CharField(default='', max_length=45)),
                ('ext7', models.CharField(default='', max_length=45)),
                ('parsed_on', models.CharField(max_length=32)),
                ('source_path', models.CharField(max_length=200)),
            ],
            options={
                'permissions': (('view_logevent', 'Can view log events'),),
            },
        ),
        migrations.CreateModel(
            name='LogEventParser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32, unique=True)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('match_regex', models.CharField(max_length=1024)),
                ('backup_match_regex', models.CharField(blank=True, max_length=1024, null=True)),
                ('fields', models.CharField(max_length=512)),
                ('backup_fields', models.CharField(blank=True, max_length=512, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ParseHelper',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32, unique=True)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('match_regex', models.CharField(max_length=1024)),
                ('fields', models.CharField(max_length=512)),
            ],
        ),
        migrations.CreateModel(
            name='RuleEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_stamp', models.DateTimeField()),
                ('time_zone', models.CharField(max_length=32)),
                ('eol_date_local', models.DateField()),
                ('eol_date_backup', models.DateField()),
                ('rule_category', models.CharField(default='default', max_length=24)),
                ('event_type', models.CharField(default='default', max_length=24)),
                ('severity', models.IntegerField(choices=[(0, 'emerg'), (1, 'alert'), (2, 'crit'), (3, 'err'), (4, 'warning'), (5, 'notice'), (6, 'info'), (7, 'debug')])),
                ('event_limit', models.IntegerField()),
                ('event_count', models.IntegerField()),
                ('magnitude', models.IntegerField()),
                ('time_int', models.IntegerField()),
                ('message', models.CharField(max_length=1024)),
                ('log_source_count', models.IntegerField(blank=True, null=True)),
                ('source_ids_log', models.ManyToManyField(blank=True, related_name='rules_triggered', to='siem.LogEvent')),
                ('source_ids_rule', models.ManyToManyField(blank=True, related_name='rules_triggered', to='siem.RuleEvent')),
                ('source_rule', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='triggered_events', to='siem.LimitRule')),
            ],
            options={
                'permissions': (('view_ruleevent', 'Can view rule events'),),
            },
        ),
    ]
