
from django.urls import path
from django.contrib.auth.decorators import login_required

from . import views

app_name = 'risk'
urlpatterns = [
    path('', login_required(views.index), name='index'),
    path('help/', login_required(views.help_index), name='help_index'),
    path('help/adv_threat', login_required(views.help_adv_threat),
        name='help_adv_threat'),
    path('help/nonadv_threat', login_required(views.help_nonadv_threat),
        name='help_nonadv_threat'),
    path('at/', login_required(views.ATEIndexView.as_view()),
        name='ate_index'),
    path('nt/', login_required(views.NTEIndexView.as_view()),
        name='nte_index'),
    path('at/sources/', login_required(views.ATSIndexView.as_view()),
        name='ats_index'),
    path('nt/sources/', login_required(views.NTSIndexView.as_view()),
        name='nts_index'),
    path('at/vulns/', login_required(views.VulnIndexView.as_view()),
        name='vuln_index'),
    path('nt/conds/', login_required(views.CondIndexView.as_view()),
        name='cond_index'),
    path('impacts/', login_required(views.ImpactIndexView.as_view()),
        name='impact_index'),
    path('responses/', login_required(views.ResponseIndexView.as_view()),
        name='response_index'),
    path('at/events/<int:pk>/', login_required(
        views.ATEDetailView.as_view()),
        name='ate_detail'),
    path('nt/events/<int:pk>/', login_required(
        views.NTEDetailView.as_view()),
        name='nte_detail'),
    path('at/sources/<int:pk>/', login_required(
        views.ATSDetailView.as_view()),
        name='ats_detail'),
    path('nt/sources/<int:pk>/', login_required(
        views.NTSDetailView.as_view()),
        name='nts_detail'),
    path('at/vulns/<int:pk>/', login_required(
        views.VulnDetailView.as_view()),
        name='vuln_detail'),
    path('nt/conds/<int:pk>/', login_required(
        views.CondDetailView.as_view()),
        name='cond_detail'),
    path('impacts/<int:pk>/', login_required(
        views.ImpactDetailView.as_view()),
        name='impact_detail'),
    path('response/<int:pk>/', login_required(
        views.ResponseDetailView.as_view()),
        name='response_detail'),
    path('at/events/add/', login_required(views.ATECreateView.as_view()),
        name='ate_create'),
    path('nt/events/add/', login_required(views.NTECreateView.as_view()),
        name='nte_create'),
    path('at/sources/add/', login_required(views.ATSCreateView.as_view()),
        name='ats_create'),
    path('nt/sources/add/', login_required(views.NTSCreateView.as_view()),
        name='nts_create'),
    path('at/vulns/add/', login_required(views.VulnCreateView.as_view()),
        name='vuln_create'),
    path('nt/conds/add/', login_required(views.CondCreateView.as_view()),
        name='cond_create'),
    path('impacts/add/', login_required(views.ImpactCreateView.as_view()),
        name='impact_create'),
    path('responses/add/', login_required(
        views.ResponseCreateView.as_view()),
        name='response_create'),
    path('at/events/<int:pk>/update/',
        login_required(views.ATEUpdateView.as_view()),
        name='ate_update'),
    path('nt/events/<int:pk>/update/',
        login_required(views.NTEUpdateView.as_view()),
        name='nte_update'),
    path('at/sources/<int:pk>/update/',
        login_required(views.ATSUpdateView.as_view()),
        name='ats_update'),
    path('nt/sources/<int:pk>/update/',
        login_required(views.NTSUpdateView.as_view()),
        name='nts_update'),
    path('at/vulns/<int:pk>/update/',
        login_required(views.VulnUpdateView.as_view()),
        name='vuln_update'),
    path('nt/conds/<int:pk>/update/',
        login_required(views.CondUpdateView.as_view()),
        name='cond_update'),
    path('impacts/<int:pk>/update/',
        login_required(views.ImpactUpdateView.as_view()),
        name='impact_update'),
    path('responses/<int:pk>/update/',
        login_required(views.ResponseUpdateView.as_view()),
        name='response_update'),
    path('at/events/<int:pk>/delete/',
        login_required(views.ATEDeleteView.as_view()),
        name='ate_delete'),
    path('nt/events/<int:pk>/delete/',
        login_required(views.NTEDeleteView.as_view()),
        name='nte_delete'),
    path('at/sources/<int:pk>/delete/',
        login_required(views.ATSDeleteView.as_view()),
        name='ats_delete'),
    path('nt/sources/<int:pk>/delete/',
        login_required(views.NTSDeleteView.as_view()),
        name='nts_delete'),
    path('at/vulns/<int:pk>/delete/',
        login_required(views.VulnDeleteView.as_view()),
        name='vuln_delete'),
    path('nt/conds/<int:pk>/delete/',
        login_required(views.CondDeleteView.as_view()),
        name='cond_delete'),
    path('impacts/<int:pk>/delete/',
        login_required(views.ImpactDeleteView.as_view()),
        name='impact_delete'),
    path('responses/<int:pk>/delete/',
        login_required(views.ResponseDeleteView.as_view()),
        name='response_delete'),
]
