# Generated by Django 2.0.1 on 2018-02-06 07:56

from django.db import migrations, models
import django.db.models.deletion
import risk.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AdvThreatEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('relevance', models.IntegerField(choices=[(1, 'NA'), (2, 'Possible'), (3, 'Predicted'), (4, 'Anticipated'), (5, 'Expected'), (6, 'Confirmed')], default=1)),
                ('info_source', models.CharField(blank=True, max_length=50, null=True)),
                ('tier', models.IntegerField(choices=[(1, 'Org-wide'), (2, 'Dept-wide'), (3, 'Localized')], default=3)),
                ('likelihood_initiation', models.IntegerField(blank=True, null=True, validators=[risk.models.validate_scale_range])),
                ('likelihood_impact', models.IntegerField(blank=True, null=True, validators=[risk.models.validate_scale_range])),
                ('assigned_risk', models.IntegerField(blank=True, null=True, validators=[risk.models.validate_scale_range])),
            ],
        ),
        migrations.CreateModel(
            name='AdvThreatEventCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='AdvThreatEventType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('source_category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='event_types', to='risk.AdvThreatEventCategory')),
            ],
        ),
        migrations.CreateModel(
            name='AdvThreatSource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('info_source', models.CharField(blank=True, max_length=50, null=True)),
                ('tier', models.IntegerField(choices=[(1, 'Org-wide'), (2, 'Dept-wide'), (3, 'Localized')], default=3)),
                ('in_scope', models.BooleanField(default=True)),
                ('capability', models.IntegerField(blank=True, null=True, validators=[risk.models.validate_scale_range])),
                ('intent', models.IntegerField(blank=True, null=True, validators=[risk.models.validate_scale_range])),
                ('targeting', models.IntegerField(blank=True, null=True, validators=[risk.models.validate_scale_range])),
            ],
        ),
        migrations.CreateModel(
            name='AdvThreatSrcCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='AdvThreatSrcType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('source_category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='source_types', to='risk.AdvThreatSrcCategory')),
            ],
        ),
        migrations.CreateModel(
            name='ConditionCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ConditionClass',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ConditionType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('condition_category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='condition_types', to='risk.ConditionCategory')),
            ],
        ),
        migrations.CreateModel(
            name='Impact',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('info_source', models.CharField(blank=True, max_length=50, null=True)),
                ('tier', models.IntegerField(choices=[(1, 'Org-wide'), (2, 'Dept-wide'), (3, 'Localized')], default=3)),
                ('severity', models.IntegerField(validators=[risk.models.validate_scale_range])),
                ('impact_tier', models.IntegerField(choices=[(1, 'Org-wide'), (2, 'Dept-wide'), (3, 'Localized')], default=3)),
            ],
        ),
        migrations.CreateModel(
            name='ImpactType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='NonAdvThreatEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('relevance', models.IntegerField(choices=[(1, 'NA'), (2, 'Possible'), (3, 'Predicted'), (4, 'Anticipated'), (5, 'Expected'), (6, 'Confirmed')], default=1)),
                ('info_source', models.CharField(blank=True, max_length=50, null=True)),
                ('tier', models.IntegerField(choices=[(1, 'Org-wide'), (2, 'Dept-wide'), (3, 'Localized')], default=3)),
                ('likelihood_initiation', models.IntegerField(blank=True, null=True, validators=[risk.models.validate_scale_range])),
                ('likelihood_impact', models.IntegerField(blank=True, null=True, validators=[risk.models.validate_scale_range])),
                ('assigned_risk', models.IntegerField(blank=True, null=True, validators=[risk.models.validate_scale_range])),
            ],
        ),
        migrations.CreateModel(
            name='NonAdvThreatEventType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='NonAdvThreatSource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('info_source', models.CharField(blank=True, max_length=50, null=True)),
                ('tier', models.IntegerField(choices=[(1, 'Org-wide'), (2, 'Dept-wide'), (3, 'Localized')], default=3)),
                ('in_scope', models.BooleanField(default=True)),
                ('range_of_effect', models.IntegerField(blank=True, null=True, validators=[risk.models.validate_scale_range])),
            ],
        ),
        migrations.CreateModel(
            name='NonAdvThreatSrcCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='NonAdvThreatSrcClass',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='NonAdvThreatSrcType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('source_category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='source_types', to='risk.NonAdvThreatSrcCategory')),
            ],
        ),
        migrations.CreateModel(
            name='RiskCondition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('pervasiveness', models.IntegerField(validators=[risk.models.validate_scale_range])),
                ('info_source', models.CharField(blank=True, max_length=50, null=True)),
                ('tier', models.IntegerField(choices=[(1, 'Org-wide'), (2, 'Dept-wide'), (3, 'Localized')], default=3)),
                ('condition_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='risk_conditions', to='risk.ConditionType')),
            ],
        ),
        migrations.CreateModel(
            name='RiskResponse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('effectiveness', models.IntegerField(validators=[risk.models.validate_scale_range])),
                ('status', models.IntegerField(choices=[(1, 'Enabled'), (2, 'Declined'), (3, 'Planned'), (4, 'Undecided'), (5, 'Disabled'), (6, 'Nonfunctional')], default=4)),
            ],
        ),
        migrations.CreateModel(
            name='RiskResponseType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Vulnerability',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('severity', models.IntegerField(validators=[risk.models.validate_scale_range])),
                ('info_source', models.CharField(blank=True, max_length=50, null=True)),
                ('tier', models.IntegerField(choices=[(1, 'Org-wide'), (2, 'Dept-wide'), (3, 'Localized')], default=3)),
            ],
        ),
        migrations.CreateModel(
            name='VulnerabilityCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='VulnerabilityClass',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='VulnerabilityType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('vuln_category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='vuln_types', to='risk.VulnerabilityCategory')),
            ],
        ),
        migrations.AddField(
            model_name='vulnerabilitycategory',
            name='vuln_class',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='vuln_categories', to='risk.VulnerabilityClass'),
        ),
        migrations.AddField(
            model_name='vulnerability',
            name='vuln_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='vulnerabilities', to='risk.VulnerabilityType'),
        ),
        migrations.AddField(
            model_name='riskresponse',
            name='response_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='risk.RiskResponseType'),
        ),
        migrations.AddField(
            model_name='nonadvthreatsrccategory',
            name='source_class',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='source_categories', to='risk.NonAdvThreatSrcClass'),
        ),
        migrations.AddField(
            model_name='nonadvthreatsource',
            name='source_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='nonadv_sources', to='risk.NonAdvThreatSrcType'),
        ),
        migrations.AddField(
            model_name='nonadvthreatevent',
            name='event_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='nonadv_events', to='risk.NonAdvThreatEventType'),
        ),
        migrations.AddField(
            model_name='nonadvthreatevent',
            name='impacts',
            field=models.ManyToManyField(blank=True, related_name='nonadv_threat_events', to='risk.Impact'),
        ),
        migrations.AddField(
            model_name='nonadvthreatevent',
            name='responses',
            field=models.ManyToManyField(blank=True, related_name='nonadv_threat_events', to='risk.RiskResponse'),
        ),
        migrations.AddField(
            model_name='nonadvthreatevent',
            name='risk_conditions',
            field=models.ManyToManyField(blank=True, related_name='threat_events', to='risk.RiskCondition'),
        ),
        migrations.AddField(
            model_name='nonadvthreatevent',
            name='sources',
            field=models.ManyToManyField(blank=True, related_name='threat_events', to='risk.NonAdvThreatSource'),
        ),
        migrations.AddField(
            model_name='impact',
            name='impact_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='impacts', to='risk.ImpactType'),
        ),
        migrations.AddField(
            model_name='conditioncategory',
            name='condition_class',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='condition_categories', to='risk.ConditionClass'),
        ),
        migrations.AddField(
            model_name='advthreatsource',
            name='source_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='adv_sources', to='risk.AdvThreatSrcType'),
        ),
        migrations.AddField(
            model_name='advthreatevent',
            name='event_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='adv_events', to='risk.AdvThreatEventType'),
        ),
        migrations.AddField(
            model_name='advthreatevent',
            name='impacts',
            field=models.ManyToManyField(blank=True, related_name='adv_threat_events', to='risk.Impact'),
        ),
        migrations.AddField(
            model_name='advthreatevent',
            name='responses',
            field=models.ManyToManyField(blank=True, related_name='adv_threat_events', to='risk.RiskResponse'),
        ),
        migrations.AddField(
            model_name='advthreatevent',
            name='sources',
            field=models.ManyToManyField(blank=True, related_name='threat_events', to='risk.AdvThreatSource'),
        ),
        migrations.AddField(
            model_name='advthreatevent',
            name='vulnerabilities',
            field=models.ManyToManyField(blank=True, related_name='threat_events', to='risk.Vulnerability'),
        ),
    ]
