# Generated by Django 2.0.1 on 2018-02-06 07:56

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='HardwareAsset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('device_maker', models.CharField(blank=True, max_length=20, null=True)),
                ('device_model', models.CharField(blank=True, max_length=20, null=True)),
                ('property_id', models.CharField(blank=True, max_length=30, null=True)),
                ('location', models.CharField(blank=True, max_length=40, null=True)),
                ('status', models.IntegerField(choices=[(1, 'Active'), (2, 'Inactive'), (3, 'Broken'), (4, 'Destroyed'), (5, 'Missing'), (6, 'Unknown'), (7, 'Stolen')], default=6)),
                ('date_added', models.DateField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='date added')),
                ('date_eol', models.DateField(blank=True, null=True, verbose_name='end of life')),
                ('asset_custodian', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='hardware_assets_cust', to=settings.AUTH_USER_MODEL)),
                ('asset_owner', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='hardware_assets_owned', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='HardwareCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='HardwareClass',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='HardwareType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('hardware_category', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='hardware_types', to='hwam.HardwareCategory')),
            ],
        ),
        migrations.CreateModel(
            name='OrganizationalUnit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('parent_ou', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='child_ous', to='hwam.OrganizationalUnit')),
                ('unit_contact', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SoftwareAsset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('package_name', models.CharField(blank=True, max_length=20, null=True)),
                ('package_version', models.CharField(blank=True, max_length=20, null=True)),
                ('sw_property_id', models.CharField(blank=True, max_length=30, null=True)),
                ('status', models.IntegerField(choices=[(1, 'Active'), (2, 'Inactive'), (3, 'Broken'), (4, 'Destroyed'), (5, 'Missing'), (6, 'Unknown'), (7, 'Stolen')], default=6)),
                ('date_added', models.DateField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='date added')),
                ('date_eol', models.DateField(blank=True, null=True, verbose_name='end of life')),
                ('custodian_csm', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='systems_csm', to=settings.AUTH_USER_MODEL)),
                ('custodian_swam', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='systems_swam', to=settings.AUTH_USER_MODEL)),
                ('custodian_vul', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='systems_vul', to=settings.AUTH_USER_MODEL)),
                ('org_unit', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='software_assets', to='hwam.OrganizationalUnit')),
                ('parent_hardware', models.ManyToManyField(blank=True, related_name='child_software', to='hwam.HardwareAsset')),
                ('parent_software', models.ManyToManyField(blank=True, related_name='child_software', to='hwam.SoftwareAsset')),
            ],
        ),
        migrations.CreateModel(
            name='SoftwareCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='SoftwareType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('desc', models.CharField(blank=True, max_length=200, null=True)),
                ('software_category', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='software_types', to='hwam.SoftwareCategory')),
            ],
        ),
        migrations.AddField(
            model_name='softwareasset',
            name='software_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='assets', to='hwam.SoftwareType'),
        ),
        migrations.AddField(
            model_name='hardwarecategory',
            name='hardware_class',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='hardware_categories', to='hwam.HardwareClass'),
        ),
        migrations.AddField(
            model_name='hardwareasset',
            name='hardware_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='assets', to='hwam.HardwareType'),
        ),
        migrations.AddField(
            model_name='hardwareasset',
            name='org_unit',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='hardware_assets', to='hwam.OrganizationalUnit'),
        ),
        migrations.AddField(
            model_name='hardwareasset',
            name='parent_hardware',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='child_hardware', to='hwam.HardwareAsset'),
        ),
    ]
