# LogESP Contributing Guidelines

## Testing
LogESP needs testing feedback! Use the [GitHub issues page](https://github.com/dogoncouch/LogESP/issues), or email the author at [dpersonsdev@gmail.com](mailto:dpersonsdev@gmail.com) to reporting bugs and any other testing feedback.

## Coding Style
When working on LogESP, coding style should be very neat. Use four spaces instead of tabs, limit lines to 80 characters or less, use intuitive variable names, and use documentation where needed to clarify what the code does.

## Apps
The core LogESP apps (SIEM, RISK, HWAM) are designed to be a foundation on which other apps can build. New apps for analyzing data, or dealing with specific types of data (network devices, web access logs, etc.) are encouraged. Create an [issue](https://github.com/dogoncouch/LogESP/issues) or [pull request](https://github.com/dogoncouch/LogESP/pulls) on GitHub, or email the author at [dpersonsdev@gmail.com](mailto:dpersonsdev@gmail.com).

## Bug Fixes
Bug fixes are welcome, but it's a good idea to get in touch before doing any major work on the core LogESP system, as development moves fast. To minimize code conflicts, use the [GitHub issues page](https://github.com/dogoncouch/LogESP/issues), or email the author at [dpersonsdev@gmail.com](mailto:dpersonsdev@gmail.com).
