"""
Django settings for CollaboDev project.

Generated by 'django-admin startproject' using Django 2.0.

For more information on this file, see
https://docs.djangoproject.com/en/2.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.0/ref/settings/
"""

import os

import random
import string

try:
    with open('CollaboDev/SECRET_KEY', 'r') as secret_key_file:
        SECRET_KEY = secret_key_file.read()
        if SECRET_KEY == '':
            raise FileNotFoundError
except FileNotFoundError:
    with open('CollaboDev/SECRET_KEY', 'w') as secret_key_file:
        KEY_CHARS = ''.join([string.ascii_letters, string.digits,
                             string.punctuation])
        KEY_CHARS = KEY_CHARS.replace('\'', '').replace('"', '')
        KEY_CHARS = KEY_CHARS.replace('\\', '')
        KEY_LIST = [random.SystemRandom().choice(KEY_CHARS) for i in range(50)]
        SECRET_KEY = ''.join(KEY_LIST)
        secret_key_file.write(SECRET_KEY)
        secret_key_file.close()

ALLOWED_HOSTS = ['127.0.0.1']


# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = False

# Application definition

INSTALLED_APPS = [
    'admin.apps.adminConfig',
    'tasks.apps.TasksConfig',
    'accounts.apps.AccountsConfig',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'whitenoise.middleware.WhiteNoiseMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'CollaboDev.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': ['./templates', ],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'CollaboDev.wsgi.application'


# Database
# https://docs.djangoproject.com/en/2.0/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}


# Password validation
# https://docs.djangoproject.com/en/2.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.' +
                'auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.' +
                'auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.' +
                'auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.' +
                'auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/2.0/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.0/howto/static-files/

STATIC_URL = '/static/'

MEDIA_URL = '/user_content/'
MEDIA_ROOT = os.path.join(BASE_DIR, 'media')

LOGIN_REDIRECT_URL = '/tasks/'
LOGIN_URL = '/'

STATICFILES_DIRS = [
    os.path.join(BASE_DIR, "static"),
]

STATIC_ROOT = os.path.join(BASE_DIR, 'staticfiles')

ADMIN_ENABLED = False

HEROKU_ENVIRONMENT = False

# Heroku autoconfig
if 'DYNO' in os.environ:
    ALLOWED_HOSTS = ['*']

    import dj_database_url
    DB_FROM_ENV = dj_database_url.config()
    DATABASES['default'].update(DB_FROM_ENV)
    HEROKU_ENVIRONMENT = True
