# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# pylint: disable=too-many-lines
"""Constants."""

GLOVE_NPZ_SHA1 = \
    {'glove.42B.300d': ('glove.42B.300d.npz',
                        '7deee8f4860744db53ed9e50892effe9883e6d89'),
     'glove.6B.100d': ('glove.6B.100d.npz',
                       '01f80f202fcabcc3e0804898349087bfc191dd1c'),
     'glove.6B.200d': ('glove.6B.200d.npz',
                       '5e6e2bdab346c257f88d80d215d518e680d86e32'),
     'glove.6B.300d': ('glove.6B.300d.npz',
                       '1db264aa936be62f055dfb72854204450bdf4399'),
     'glove.6B.50d': ('glove.6B.50d.npz',
                      'aa16be8d184399d2199f83fd62586f2c30497bfa'),
     'glove.840B.300d': ('glove.840B.300d.npz',
                         'b4ba390c1154736e07c0e67d9180935f5930e83c'),
     'glove.twitter.27B.100d': ('glove.twitter.27B.100d.npz',
                                '0f7b82c223451d0002f79ba23596983cdbe0e2b1'),
     'glove.twitter.27B.200d': ('glove.twitter.27B.200d.npz',
                                '41cc2d26f58a54622ce96bf6c8434360ab524f20'),
     'glove.twitter.27B.25d': ('glove.twitter.27B.25d.npz',
                               '9f563d2f296995598cc46812b2fda05ad4c3c879'),
     'glove.twitter.27B.50d': ('glove.twitter.27B.50d.npz',
                               'ce9959c056f2a0a780c468feeb4f823af51630e9')}

WORD2VEC_NPZ_SHA1 = {
    'GoogleNews-vectors-negative300': ('GoogleNews-vectors-negative300-be6d6f98.npz',
                                       'be6d6f98609bd65db8f6991ecaed923f1b1c8377'),
    'freebase-vectors-skipgram1000-en': ('freebase-vectors-skipgram1000-en-6086803e.npz',
                                         '6086803e4fd0b60e12b79031d585ef2c63ca71e6'),
    'freebase-vectors-skipgram1000': ('freebase-vectors-skipgram1000-827a5d3a.npz',
                                      '827a5d3a777ea3de21be4f61dad4de6510d77ee3')
}

FAST_TEXT_NPZ_SHA1 = {
    'crawl-300d-2M': ('crawl-300d-2M.npz', '9dd611a1fe280c63050cd546d3595400fc0eede4'),
    'crawl-300d-2M-subword': ('crawl-300d-2M-subword-927782c8e.npz',
                              '927782c8ec8c2c1deb6a8a550217478e183ca25a'),
    'wiki.aa': ('wiki.aa.npz', '48f163b80eb37f1806142169d3d4c05cf75b7339'),
    'wiki.ab': ('wiki.ab.npz', '860ceff119dd27e5b701b605879037c1310cbc3e'),
    'wiki.ace': ('wiki.ace.npz', '62938287464040491719f56a6f521f8f808beee8'),
    'wiki.ady': ('wiki.ady.npz', '646843afa260d018ed711df3f1ca9c3e000447b6'),
    'wiki.af': ('wiki.af.npz', '7b14cd27690b67fea318d0bac2283c16430680e2'),
    'wiki.ak': ('wiki.ak.npz', '20f309adad1c45958c97b6055d5838e05bbaea72'),
    'wiki.als': ('wiki.als.npz', 'a8b03aa133c4f7da12fc27c2b167b7918b1e9805'),
    'wiki.am': ('wiki.am.npz', 'ed3dd10cea64737f7a1623612ee099df9dc19f66'),
    'wiki.ang': ('wiki.ang.npz', '8efe64706d9d6b8eae38b2c7ff0b277e20592bc7'),
    'wiki.an': ('wiki.an.npz', '168046283c719ab96a29b1abae2e25a6575c7be8'),
    'wiki.arc': ('wiki.arc.npz', '049021b7decea4bc009b12936e56b4dbf5b760e7'),
    'wiki.ar': ('wiki.ar.npz', '7e325e1e98dfcdc9368d2ebe40ee834a2ed44912'),
    'wiki.arz': ('wiki.arz.npz', '7d851c2c7be3ee6f7fd896de7b76ea08e3fb08b0'),
    'wiki.as': ('wiki.as.npz', '01d38c29cd4bd99c1a8534abc058822da14a5b9c'),
    'wiki.ast': ('wiki.ast.npz', '9c9846ba5084505a0adea89c95c66e04efbf5ce9'),
    'wiki.av': ('wiki.av.npz', '7ef6a920c364638504e673cfde5f7675503fa81e'),
    'wiki.ay': ('wiki.ay.npz', 'c1202e110930e3902397f5cb64a8359e013b469f'),
    'wiki.azb': ('wiki.azb.npz', '10351b7ef14ec2cb610d290cb6a3f6987ef5d8b3'),
    'wiki.az': ('wiki.az.npz', '74257c3bcd533a606afae509ea835dc036d61546'),
    'wiki.ba': ('wiki.ba.npz', '4a2857ed694d66864df562b376c2fa12fcb03646'),
    'wiki.bar': ('wiki.bar.npz', 'e65c6b7e9ff83798d1eea05d166148837d53e615'),
    'wiki.bat_smg': ('wiki.bat_smg.npz', '6420584ae28ba6c9dd145fea8f096243d457c2d8'),
    'wiki.bcl': ('wiki.bcl.npz', '33606c970ab336b678393e2bdb8af2116d11cf7b'),
    'wiki.be': ('wiki.be.npz', '84487d341e333344cf71bc12c7a205d923762498'),
    'wiki.bg': ('wiki.bg.npz', '56f2a175b1a1d1a9cf9f1cea277cd0b46ffd7f66'),
    'wiki.bh': ('wiki.bh.npz', '07473989853a344a41aaa18f41030dc56d0d01c7'),
    'wiki.bi': ('wiki.bi.npz', '08adfa3c9ef3016d30ef69ea539d217ff67eda09'),
    'wiki.bjn': ('wiki.bjn.npz', '998a551283222931d3a26922308449950bfa3ec7'),
    'wiki.bm': ('wiki.bm.npz', '454ff9fbd4790e4a076d9a2087a51da28aa1332f'),
    'wiki.bn': ('wiki.bn.npz', '1f36f6f39c9a9b33bb8035c9a4dc7e04933604fd'),
    'wiki.bo': ('wiki.bo.npz', 'b9fe87318428de0a7790de175b5fec80c5af482d'),
    'wiki.bpy': ('wiki.bpy.npz', '5c7853173d27e2c018c24eca69de8d5f34511b0d'),
    'wiki.br': ('wiki.br.npz', '7aa66a2034fbfaa1d39e637385d48610238797c9'),
    'wiki.bs': ('wiki.bs.npz', 'a019a4677677c2e9e4d899326b2b6c15ad6c011a'),
    'wiki.bug': ('wiki.bug.npz', '09ae3477941d7a99d1df494368d7efb0b2c18913'),
    'wiki.bxr': ('wiki.bxr.npz', 'b832c691b8ddd95896c052d3d15e1f98d72068d5'),
    'wiki.ca': ('wiki.ca.npz', '391e0d4daad08649251274fa1cc2a5f49c7728b1'),
    'wiki.cbk_zam': ('wiki.cbk_zam.npz', '02e57a763bc9f9eadaba57953383dd12a0a78a37'),
    'wiki.cdo': ('wiki.cdo.npz', 'd6e8f422327e8b2273f1f2662d793707ece6695d'),
    'wiki.ceb': ('wiki.ceb.npz', '23bc0bb9aeaa57dff35092766941a866de142aae'),
    'wiki.ce': ('wiki.ce.npz', '182b2a889256119a6d379d501c55c7621e5855db'),
    'wiki.ch': ('wiki.ch.npz', '82dd77512fcb463481f43c9cef3507e2baa90d7b'),
    'wiki.cho': ('wiki.cho.npz', 'b0b620fc2442d1a6e2440e71a424861c80175f0c'),
    'wiki.chr': ('wiki.chr.npz', '3d62c6b95c5af46abd6234426ae760cca65d5bd0'),
    'wiki.chy': ('wiki.chy.npz', '34a28a22da79aebc100e3714b825c95c8d5f54a3'),
    'wiki.ckb': ('wiki.ckb.npz', 'ad19461e4be583d08b7693ff5b1e9d590ed41add'),
    'wiki.co': ('wiki.co.npz', 'fa60d9f0e79f1c7e15f381aef983a0f4f31c05a8'),
    'wiki.crh': ('wiki.crh.npz', '540270ba6edd9d7b2f7efca52b3b407524ac67d1'),
    'wiki.cr': ('wiki.cr.npz', 'f06b77465a38ec960d7d5a7554b848c37e945c76'),
    'wiki.csb': ('wiki.csb.npz', 'b8b28559cf2541341af98e2aa755856765bdeabf'),
    'wiki.cs': ('wiki.cs.npz', '19881e931fe06abf341450f00c342d364313e232'),
    'wiki.cu': ('wiki.cu.npz', '731e0d00abd53bc2a8eb6cf37f6ab883cff34e15'),
    'wiki.cv': ('wiki.cv.npz', 'e60034fcffb7dfef7b236ddba1194c3aa20b7967'),
    'wiki.cy': ('wiki.cy.npz', '5a0fb967b5556f007c0d5065f951a3d3b1c1005a'),
    'wiki.da': ('wiki.da.npz', 'd06258014ba2c7450bc2d55edfdf1731433e42e5'),
    'wiki.de': ('wiki.de.npz', 'a21694dfd2af63bd7bb00f0b60b28e88bd1153f1'),
    'wiki.diq': ('wiki.diq.npz', '4f6c77a86b39834a7130419967759afd8cc26b84'),
    'wiki.dsb': ('wiki.dsb.npz', 'e74f1d346a8db96987bff0c33ee5f886907c380a'),
    'wiki.dv': ('wiki.dv.npz', '5d6fe6f0eec2e7704121d5aba03b4edbb28af873'),
    'wiki.dz': ('wiki.dz.npz', '77c639d36d0355b2de5adead7996eae342b852a6'),
    'wiki.ee': ('wiki.ee.npz', '4b5a76127d57515d3e8a76787cdefde5856b754a'),
    'wiki.el': ('wiki.el.npz', 'a00bcb97e7898931196a1c69f7a492e5b6202661'),
    'wiki.eml': ('wiki.eml.npz', 'b475d626b3d97e7a68c02827fdc7900599e838c6'),
    'wiki.en': ('wiki.en.npz', 'ad5ec6d49db6c6fe76b8e85ff05d34e5d0e1eb6a'),
    'wiki.eo': ('wiki.eo.npz', '18049b0010520d13e676f5a82e8bb90153d99003'),
    'wiki.es': ('wiki.es.npz', 'a6d192ba7d82d762f8367e75ca951aad4d11e410'),
    'wiki.et': ('wiki.et.npz', '4beb7025cf88f1aa62d025b187f0cb09aee61858'),
    'wiki.eu': ('wiki.eu.npz', '5e1a8197e35f20a2476798bbb935b4c131289c4f'),
    'wiki.ext': ('wiki.ext.npz', '049b2d1b0a8b102b45907cf487cac30aa294e0a0'),
    'wiki.fa': ('wiki.fa.npz', '81ed274997c87ef87d73d25e166ca06272ce426f'),
    'wiki.ff': ('wiki.ff.npz', '4867dc74cd53ca0b0f769af4fa1ea420406b59bf'),
    'wiki.fi': ('wiki.fi.npz', '6d1291b854045179f8171ac7d62ede7d8ac159a2'),
    'wiki.fiu_vro': ('wiki.fiu_vro.npz', 'dd87806d9dc8833fa0e21e35a50815ebdbaa6c8b'),
    'wiki.fj': ('wiki.fj.npz', 'cf5c31b0a69276f5dd18ab738ed92444abaeb755'),
    'wiki.fo': ('wiki.fo.npz', 'ffc19807d528af000861a94cfb8097bd686e14fc'),
    'wiki.fr': ('wiki.fr.npz', '8f06d5dbe3cf7214354fe9b2f6eca0ef7419f063'),
    'wiki.frp': ('wiki.frp.npz', 'c8b200ae592478d3cd0bfaafcd7aa19de8a3bfe5'),
    'wiki.frr': ('wiki.frr.npz', 'fa5e5c39ea2a45793c679eacea290a35e37405ea'),
    'wiki.fur': ('wiki.fur.npz', 'a61a8940d059f25000e3fe23933e5ed0d37e65d3'),
    'wiki.fy': ('wiki.fy.npz', '46f9f41bdf6f4fb8e27a753290413d745465963b'),
    'wiki.gag': ('wiki.gag.npz', '49fb01230e6803544122d47ab7d3fe694d1444f2'),
    'wiki.gan': ('wiki.gan.npz', '716b7b26acc15975f30caf3c6effa111516fcca5'),
    'wiki.ga': ('wiki.ga.npz', 'ea934bc1fdc1acf6caf9ac746c6c499251f1fdee'),
    'wiki.gd': ('wiki.gd.npz', '597017b5a32d933f194595d3656f858e37e70a62'),
    'wiki.glk': ('wiki.glk.npz', '91a5834658bc2d48714e8807ef24efb79567b4b5'),
    'wiki.gl': ('wiki.gl.npz', '2fa8e48d6ae1e9c9d542eb3f2156cf9e359e66c2'),
    'wiki.gn': ('wiki.gn.npz', 'e359eef3928e1f1b5d8fcf0ea532e8794c66289a'),
    'wiki.gom': ('wiki.gom.npz', '8cd361481c23f7545cc2bd8f1bf22aa7400edd4d'),
    'wiki.got': ('wiki.got.npz', 'd05daf105611150695e61775fdff2c500b36be3f'),
    'wiki.gu': ('wiki.gu.npz', '0ce175c5fc39bab4032892f70c9d2bb850af0f4a'),
    'wiki.gv': ('wiki.gv.npz', '2c573f873d607831ff01b64603c17b8db79bd7e1'),
    'wiki.hak': ('wiki.hak.npz', 'e6048727799cdf149f5c50037e0fc59300d33a94'),
    'wiki.ha': ('wiki.ha.npz', 'f18ea7286bbd390c5470896b2c99cb1adc740064'),
    'wiki.haw': ('wiki.haw.npz', '18bcd85d2e06b1b889f0835fc5b62697fdf32d72'),
    'wiki.he': ('wiki.he.npz', '76915ff167b6ecb7b7e22ff0ca46914a55d344af'),
    'wiki.hif': ('wiki.hif.npz', '12153aaf98d76d5502ab77a27cd0b9a539f61513'),
    'wiki.hi': ('wiki.hi.npz', '249666a598991f6ec147954c6af9e531fd1cd94e'),
    'wiki.ho': ('wiki.ho.npz', '3f804fd69780c0789708b56ea9d48715f8e38f26'),
    'wiki.hr': ('wiki.hr.npz', '9a3de28e69f97048bfb480b4f83eaab6149f66ad'),
    'wiki.hsb': ('wiki.hsb.npz', '7070bf64e13299dd66ac0e9f8e24011a56b6bfe8'),
    'wiki.ht': ('wiki.ht.npz', 'a607093d511afeb584d02dc676bc5a27eff66287'),
    'wiki.hu': ('wiki.hu.npz', '9b2c4750daf1bcf39768572e874b5afda0e2f0bc'),
    'wiki.hy': ('wiki.hy.npz', 'ec0461a102a6fb00bd324f66cefd3c8d55a7093a'),
    'wiki.hz': ('wiki.hz.npz', '5dfb8afbdae6b4148c3e55ab459c56a74b46b463'),
    'wiki.ia': ('wiki.ia.npz', '4cfaaf053b9513bbf5b2423258c0f01d20256de6'),
    'wiki.id': ('wiki.id.npz', 'bace396bb9941cc9e5b2e5f5a19be6db833c5fd4'),
    'wiki.ie': ('wiki.ie.npz', '1bae7256c2e763ce6d692d1c0a603d99a8b22826'),
    'wiki.ig': ('wiki.ig.npz', '23128e54a5e143891d392d621723bad9cfc8cf7b'),
    'wiki.ii': ('wiki.ii.npz', '54bc16d05da512481865a89ecf30260b0acc04dc'),
    'wiki.ik': ('wiki.ik.npz', 'f8015227e893d2375699b7d132b306ba381f02ac'),
    'wiki.ilo': ('wiki.ilo.npz', '185a11f81bd5d24a34558dda81ee4735f5ba150b'),
    'wiki.io': ('wiki.io.npz', 'ddf8180a90aa6ee5be93a2582cc99c535f21363e'),
    'wiki.is': ('wiki.is.npz', '968f8dd2a093b279a6f7aaa734008454bf51d724'),
    'wiki.it': ('wiki.it.npz', 'fdfb857a309b2c3d29482bb5cc55f21b858d2e6f'),
    'wiki.iu': ('wiki.iu.npz', 'fa8896730bd6c24c3473daa22116d1016294e7f7'),
    'wiki.jam': ('wiki.jam.npz', 'a8f0d0b99c89ace0a6401b8fcda261d06065faaf'),
    'wiki.ja': ('wiki.ja.npz', '8d42e5a40e4d1d8645b2d80b873a65cadcf68b5c'),
    'wiki.jbo': ('wiki.jbo.npz', '145fc999ab004b348cf9bf445f0a93a7a145308b'),
    'wiki.jv': ('wiki.jv.npz', '66978770bf06e42414395cf5fd8c596044d72bec'),
    'wiki.kaa': ('wiki.kaa.npz', '624a640ecb9901b2aba2e9f44ab615146ecb2862'),
    'wiki.kab': ('wiki.kab.npz', 'e97f93b6ba65e95c85b7541932cf53c5ad9eb896'),
    'wiki.ka': ('wiki.ka.npz', '1ca8376e1e0cbd58001c1b51a2d488a2874a6743'),
    'wiki.kbd': ('wiki.kbd.npz', 'f2d2a05b06723ac549784ad5470d84f5742a1352'),
    'wiki.kg': ('wiki.kg.npz', 'fa7f6d5f660a173a3e75342d449980eedcdc789e'),
    'wiki.ki': ('wiki.ki.npz', '21a8c7c616c0050c51c288861f3423f313e4f634'),
    'wiki.kj': ('wiki.kj.npz', 'f3c347509a0d81f4f7fdbb8b22889b8d76e5014e'),
    'wiki.kk': ('wiki.kk.npz', 'bc24a3289e1c1e18e16b6789c2f9f92af1e73071'),
    'wiki.kl': ('wiki.kl.npz', 'b8b7e7359f067836e2be2ecfe9f35a820b00fe1d'),
    'wiki.km': ('wiki.km.npz', 'e053799fd01463808432dc035bef3e36620e2f36'),
    'wiki.kn': ('wiki.kn.npz', '2849a0a8b3453e9bf6af05d4c7bd3db881dd1068'),
    'wiki.koi': ('wiki.koi.npz', 'a9b02e9bd41833bcd54769f94626019c03f29997'),
    'wiki.ko': ('wiki.ko.npz', '764d9896e74b5a26c6884d48bce3bed8ed3a7822'),
    'wiki.krc': ('wiki.krc.npz', 'bfe39598c718f1cc95909db7544b3214b308a97c'),
    'wiki.kr': ('wiki.kr.npz', '1e6af853d4a8ea7830e116eb9b61ac5d7d9a315c'),
    'wiki.ksh': ('wiki.ksh.npz', '66cd0e3e0a0b0282a13960571ebe7cddd7706bf2'),
    'wiki.ks': ('wiki.ks.npz', '85f1adaa05b854df4dede745a1aaab3836e60770'),
    'wiki.ku': ('wiki.ku.npz', 'faf90584e5a45e6d0f9eeb88399b82abe037d584'),
    'wiki.kv': ('wiki.kv.npz', '9f2b41822013a412da9c99fac06eed8be03ca192'),
    'wiki.kw': ('wiki.kw.npz', '3eed8a8fc97a2fc79241b8474a458c98d00fc897'),
    'wiki.ky': ('wiki.ky.npz', '0116ff90f10a6c0728e1ea86d8a44896ea83270a'),
    'wiki.lad': ('wiki.lad.npz', '5af2015b3d1c5e8563f0e92721580988ebe2ce50'),
    'wiki.la': ('wiki.la.npz', '7143303a3ea13c7668eb90ea6e3d2ca69857a3be'),
    'wiki.lbe': ('wiki.lbe.npz', 'f206a3c35a184ba5d2b32ee68640eadf66c847da'),
    'wiki.lb': ('wiki.lb.npz', '143dc6337f3690379282034c460c613d7f144923'),
    'wiki.lez': ('wiki.lez.npz', 'b29a680decc6b29f24e8eb9e4f8e11e3419d45f1'),
    'wiki.lg': ('wiki.lg.npz', '866640ce62cedbc1d453b7ea3c289c291ad76e13'),
    'wiki.lij': ('wiki.lij.npz', '0dcd3d7009ae89b1016ca6cdb99a9f0d70bc4baf'),
    'wiki.li': ('wiki.li.npz', '4666b3c238256d7b7623a136db19b8b9f4754734'),
    'wiki.lmo': ('wiki.lmo.npz', 'ac89fa7cfe0675950bcb31c66bf3f88a3cfc98f0'),
    'wiki.ln': ('wiki.ln.npz', 'fba158719944aabe58e0002a90be0ed77e11702d'),
    'wiki.lo': ('wiki.lo.npz', '1e113e340a8a93d385e14502c9c4e3bcdf6c3101'),
    'wiki.lrc': ('wiki.lrc.npz', '42cb755f398fba6f0da7949c91e92b55654bd482'),
    'wiki.ltg': ('wiki.ltg.npz', '182f75859e228d1162215f28fe7f2dca127624a4'),
    'wiki.lt': ('wiki.lt.npz', '66aa944bd2e777cb82d6d59b1f2f837b6c48cb37'),
    'wiki.lv': ('wiki.lv.npz', '2be8f926da85694fa998bf79d80b61ebb8d67576'),
    'wiki.mai': ('wiki.mai.npz', 'b8a9c36e2a0f1bb84a44dc762250d2a9007ef637'),
    'wiki.map_bms': ('wiki.map_bms.npz', '6f0394d6b3d08a946e3df4b9355efe94148f018a'),
    'wiki.mdf': ('wiki.mdf.npz', '774ee35334641db57f9ac9069961c5372a5d92e8'),
    'wiki.mg': ('wiki.mg.npz', '496c48ef668f08ce95ebb11ce1ce5026b52d935c'),
    'wiki.mh': ('wiki.mh.npz', '352edd84f99c5aa277a7306f6cacea1fab065ed3'),
    'wiki.mhr': ('wiki.mhr.npz', 'dd78b27a674ac10411cdf74ac32f9391506b17e0'),
    'wiki.min': ('wiki.min.npz', '628b406441ab03bc8aa68195ada50bfdc8226f34'),
    'wiki.mi': ('wiki.mi.npz', '754127b473861cd4f9ae034c9f527a34827b1f00'),
    'wiki.mk': ('wiki.mk.npz', 'b09fed4f56c296f13c4020ef1fec498382a38b73'),
    'wiki.ml': ('wiki.ml.npz', '02fb55d97ca2f0408f0e7e8dd6a661bbc3319a2a'),
    'wiki.mn': ('wiki.mn.npz', '08b2c45689aa5d9ec49df96dc7c777ce9b9a0b4b'),
    'wiki.mo': ('wiki.mo.npz', '638c2e8bd2352fd52921b9ae62f578b8357bab49'),
    'wiki.mrj': ('wiki.mrj.npz', 'ec5cf1f4fb8dfdca64d8172974e620eb8fa41626'),
    'wiki.mr': ('wiki.mr.npz', '074dd68c947c2f137a3e84b55012925f00213139'),
    'wiki.ms': ('wiki.ms.npz', '3dbe9e9d70251de8a374776ff1250a9c3103ee59'),
    'wiki.mt': ('wiki.mt.npz', 'f5103998a68d1b178387417436a83123d44aba01'),
    'wiki.multi.ar': ('wiki.multi.ar.npz', 'a010d1d81a465c56ebaf596b3e8e8795e7f0f8e3'),
    'wiki.multi.bg': ('wiki.multi.bg.npz', 'c04018f3a600cee170f12a36cdd35b4727a2aade'),
    'wiki.multi.ca': ('wiki.multi.ca.npz', 'eef52a0cf20c133ca9065de25f0702861a8cfa29'),
    'wiki.multi.cs': ('wiki.multi.cs.npz', 'c5f547aa78c0e3d7dae67a0334d500bf2a86aa30'),
    'wiki.multi.da': ('wiki.multi.da.npz', '24374f2ee169b33327feeee46da31b0de1622fe4'),
    'wiki.multi.de': ('wiki.multi.de.npz', '2e6c119b345bebd34b56eaaf855d6703889b11f7'),
    'wiki.multi.el': ('wiki.multi.el.npz', '9d122beedb80a2e5334946641e5bafd32c01e76b'),
    'wiki.multi.en': ('wiki.multi.en.npz', '8c3c480b4cb2690304173713a646280613b244a8'),
    'wiki.multi.es': ('wiki.multi.es.npz', '483a22656e4fb2a01e9f4ef8156b261e780850ab'),
    'wiki.multi.et': ('wiki.multi.et.npz', '22498c7b91645a3874fa738b5cfb16bf98b6f97c'),
    'wiki.multi.fi': ('wiki.multi.fi.npz', '765a6f0b63777bff4ae6ca2b461c5889c03d6a70'),
    'wiki.multi.fr': ('wiki.multi.fr.npz', 'decd9aacf600114b8a36072535c0309874a37c83'),
    'wiki.multi.he': ('wiki.multi.he.npz', '7eee940c1b85936f59122f4b1a166223dd946674'),
    'wiki.multi.hr': ('wiki.multi.hr.npz', '1673963416af088f8bf15576afb33d58115db35c'),
    'wiki.multi.hu': ('wiki.multi.hu.npz', 'a1fbe6ededf3cbaa3eaa22dd8b20cce4b36cfc6d'),
    'wiki.multi.id': ('wiki.multi.id.npz', '6c3e721febb511ede7db7bf978d65769e4270f5c'),
    'wiki.multi.it': ('wiki.multi.it.npz', 'fc5bfc11e0165e8d95c1708573dad5e456826c73'),
    'wiki.multi.mk': ('wiki.multi.mk.npz', '6cd50198355674f156fc863108d9bebf11cfabd9'),
    'wiki.multi.nl': ('wiki.multi.nl.npz', '4fa06b9230c95dfa5a9e9a5d80f1f5ba614d3cbf'),
    'wiki.multi.no': ('wiki.multi.no.npz', '63756168c1101e73fba8d1a5015f32b8892819e6'),
    'wiki.multi.pl': ('wiki.multi.pl.npz', '958b8e8bead965ba1bb1433e1c960fc3e12a10fb'),
    'wiki.multi.pt': ('wiki.multi.pt.npz', '22f07df1609d79b95344ee575ea43141424a1528'),
    'wiki.multi.ro': ('wiki.multi.ro.npz', '73180b3e382519004bf38ea7b86237aacbbe813a'),
    'wiki.multi.ru': ('wiki.multi.ru.npz', '3b2eb9163f35e90bf2ce1cd3c997b354d0c34f59'),
    'wiki.multi.sk': ('wiki.multi.sk.npz', '606a0c3ba9849070c6b6b8c22d920fdeed9a1385'),
    'wiki.multi.sl': ('wiki.multi.sl.npz', '3cfdab5043b8cfe1535cb6dbd4c9e68847ad5904'),
    'wiki.multi.sv': ('wiki.multi.sv.npz', '4f1494885b9a831e87cfa3c15f2204c4a73c0779'),
    'wiki.multi.tr': ('wiki.multi.tr.npz', '54f90d5ddb9a65538a41e37c5a67ed933a5e4885'),
    'wiki.multi.uk': ('wiki.multi.uk.npz', '500fd26b1d7a25b42458012e99f9f76642e0c787'),
    'wiki.multi.vi': ('wiki.multi.vi.npz', '3955809cceb300965c15f9372221417719bb0db8'),
    'wiki.mus': ('wiki.mus.npz', 'a5f48934a3fa6eaf4929098046c93fc94dd6bcb6'),
    'wiki.mwl': ('wiki.mwl.npz', '8a5e2c272166f8a72c5694ca6c3104d5f49179ec'),
    'wiki.my': ('wiki.my.npz', '5e035aca16700d7d6695af8a6d3a88ac847aaeb7'),
    'wiki.myv': ('wiki.myv.npz', 'd4cfaab70c640033e02c0fc0c5a3615ae836c569'),
    'wiki.mzn': ('wiki.mzn.npz', 'ad09ac584ae455b5862b95125ef409360ae18445'),
    'wiki.nah': ('wiki.nah.npz', '2dc454ef37d059f2053af46cfa1f4f0ca939cba0'),
    'wiki.na': ('wiki.na.npz', '401f0f880eb7aa78d21348bc1e0a3953b3e81bf0'),
    'wiki.nap': ('wiki.nap.npz', '996da46aeeab5644ba766d00c5e343b1553361d7'),
    'wiki.nds_nl': ('wiki.nds_nl.npz', '5a9307e16b13a5a82ec19a52b33254537e7198e7'),
    'wiki.nds': ('wiki.nds.npz', 'b249a87c78c52becf51e7b50aaf9f9b6a36585f1'),
    'wiki.ne': ('wiki.ne.npz', 'a601db2647a74ffd2b4b43dcb8584735f555459c'),
    'wiki.new': ('wiki.new.npz', 'c398a3775aba9c68ce765cfdfb6b188f7c47e4c6'),
    'wiki-news-300d-1M': ('wiki-news-300d-1M.npz', '0a03bbd508e5381e140476140fb121afeb0050ed'),
    'wiki-news-300d-1M-subword': ('wiki-news-300d-1M-subword.npz',
                                  '69edae21375407781c727dcb9e534e79d712d137'),
    'wiki.ng': ('wiki.ng.npz', 'befd774d15f69d43547e13e5ea3a97c4cb1ab405'),
    'wiki.nl': ('wiki.nl.npz', '5a7cb6f1dd0a7621202abba9461ac2c5bf905219'),
    'wiki.nn': ('wiki.nn.npz', '8e5059ddeb24050fadaa5cc4622b13feb3e4a226'),
    'wiki.no': ('wiki.no.npz', '5ce6e0f793e66f081652f64013968099de03d9f9'),
    'wiki.nov': ('wiki.nov.npz', '95ed23b4cfd7a65afa1c12c7dbdce6af53923d77'),
    'wiki.vec': ('wiki.npz.npz', '08ebb912efeb9df1c7d05e1af90484d210dff47e'),
    'wiki.nrm': ('wiki.nrm.npz', 'e58614b4508ff9810f0b58fd818f973775bc918d'),
    'wiki.nso': ('wiki.nso.npz', '56a2ebe260241402d117cd89c5c872b9c96ff05b'),
    'wiki.nv': ('wiki.nv.npz', 'c713051fe03ec1f60314bb42161b2a47fb5e169a'),
    'wiki.ny': ('wiki.ny.npz', 'ba5a1725955cbc13e7fd93ab499f8085840c992c'),
    'wiki.oc': ('wiki.oc.npz', '259e7d994c38a4cfc140fb07016b82d6781e5027'),
    'wiki.olo': ('wiki.olo.npz', '0fea70f887def4779ee70a79366b88f1ada65004'),
    'wiki.om': ('wiki.om.npz', '47e2d756b5f8913085d901375c1b4e0b118a4221'),
    'wiki.or': ('wiki.or.npz', '7e274ab060219b019aa02bb97941cc6e162fd01f'),
    'wiki.os': ('wiki.os.npz', '19e8199cc2aaffdb07b6c558dbc5465ac6e03155'),
    'wiki.pag': ('wiki.pag.npz', 'eddf4931547649026c02f893297ef673ec6158bb'),
    'wiki.pam': ('wiki.pam.npz', '40109aa174bd9f0fa657839bb548e2b0646c58d3'),
    'wiki.pa': ('wiki.pa.npz', '8a5870717e9e641b1f757f13259171698118de2e'),
    'wiki.pap': ('wiki.pap.npz', '999c8e5b005ca20d9998fbbe4fa79177f69e24c0'),
    'wiki.pcd': ('wiki.pcd.npz', 'e975066b323a65cdc5e4c27138ef674d2cf7250b'),
    'wiki.pdc': ('wiki.pdc.npz', '5c770b9d56f276b0aa535845f175c05ee1cea615'),
    'wiki.pfl': ('wiki.pfl.npz', '0063d0b633ee529a75482b36ed4f4da7d64994ec'),
    'wiki.pih': ('wiki.pih.npz', 'ce1d76c94d248545eea0d7436c54849dbb380bfc'),
    'wiki.pi': ('wiki.pi.npz', 'c7d56c334bf529f8b3655693d207a80feaec4aed'),
    'wiki.pl': ('wiki.pl.npz', '0d612fdf871a1a4084c867f394940475be899443'),
    'wiki.pms': ('wiki.pms.npz', 'ca149a2fb138011315bb6d5d61c7a5647e515e51'),
    'wiki.pnb': ('wiki.pnb.npz', '9ec82d02ad8894056c67991cf8ce927bcca74ee2'),
    'wiki.pnt': ('wiki.pnt.npz', '3f90123407bb8fc838a0a0d3700a14e15f5b26aa'),
    'wiki.ps': ('wiki.ps.npz', '7edebc02ac16f5fab83eb10b7d0fab821a9a4d43'),
    'wiki.pt': ('wiki.pt.npz', 'f172fd801edd1ad9d319ba44146d40b5d682a473'),
    'wiki.qu': ('wiki.qu.npz', '68bec60ccfe1826c3b3a8968574488dbc74cdf7b'),
    'wiki.rm': ('wiki.rm.npz', '00fb191fc736ba60cb23e76169dfccde9a9daad0'),
    'wiki.rmy': ('wiki.rmy.npz', 'c5e93cc37ff7293b9a1d9fe55c42d6fbde372b97'),
    'wiki.rn': ('wiki.rn.npz', '57b8e0d6999269be227af6ef2797a9cf8386ff1b'),
    'wiki.roa_rup': ('wiki.roa_rup.npz', 'e06d6b5672a59bb9e83143bc8b28300d23c09546'),
    'wiki.roa_tara': ('wiki.roa_tara.npz', 'c083105f40236dc3711f06c1b40e8ee7a714b99d'),
    'wiki.ro': ('wiki.ro.npz', '766bc0cb58a65b0b1763b9a0d90e91ab982eb20d'),
    'wiki.rue': ('wiki.rue.npz', '9a91fa093cd48d7d658d526b0ccda48dc59cd7f4'),
    'wiki.ru': ('wiki.ru.npz', 'd59d099481c22d5592ab9635c9ee48060aa0bf45'),
    'wiki.rw': ('wiki.rw.npz', 'e99ee87d249f6c157c5c97397d1025d798b85c69'),
    'wiki.sah': ('wiki.sah.npz', '85dae39097b29bc8e2b64f343a77794e4a62f91a'),
    'wiki.sa': ('wiki.sa.npz', '7d1928d7c67400045ac1b35a37a0e3089690d875'),
    'wiki.scn': ('wiki.scn.npz', '27d7b8050bbeed8ce196061c610216760b053c39'),
    'wiki.sc': ('wiki.sc.npz', '69c7b8be0f03a1bbd615695f93bdd78f96a58e16'),
    'wiki.sco': ('wiki.sco.npz', '4880282f59d3338b67fbff75359e2d24896e95bb'),
    'wiki.sd': ('wiki.sd.npz', '0ed8da4d27223db717a612cf0c88582351db6e19'),
    'wiki.se': ('wiki.se.npz', '0f4b2e060d5e29f96ca73aab29c967e79db69c17'),
    'wiki.sg': ('wiki.sg.npz', 'a5e4edf34fe1a88b322da4c3922ec5a470e200c6'),
    'wiki.sh': ('wiki.sh.npz', 'c13f1e94676bc939560193f7aa7ffd7d604707b3'),
    'wiki.simple': ('wiki.simple.npz', '352d0575e7d60b08e1dfce2c5de713906f0ed78f'),
    'wiki.si': ('wiki.si.npz', '204f9ffbe7770a9f56d3b2fb26999165015f5c33'),
    'wiki.sk': ('wiki.sk.npz', '7a9820b5a343b242660bf2595d1ecbf6e00a76d6'),
    'wiki.sl': ('wiki.sl.npz', '85f3186f26d6725317a64e290363a7251b928b81'),
    'wiki.sm': ('wiki.sm.npz', '9e13452cc4bff677f4f15db04f9d2f95f6ec054c'),
    'wiki.sn': ('wiki.sn.npz', 'e8d5f7dcf51280c5f99bc3df849b4889a61e9fcd'),
    'wiki.so': ('wiki.so.npz', '0f5d71b95768b33fd939a870c15344c4478364a9'),
    'wiki.sq': ('wiki.sq.npz', '8b05826df8575e65c87a2fc0b7630cf644d4216d'),
    'wiki.srn': ('wiki.srn.npz', '2711396ef297ac5dde8904508bc002bdecbcc6f4'),
    'wiki.sr': ('wiki.sr.npz', '546edc8e29a5d2e99ed10eb4a552cbef2bb8f417'),
    'wiki.ss': ('wiki.ss.npz', '2e5911bad79bb5270a64f587e326d31c95ec58f3'),
    'wiki.st': ('wiki.st.npz', '23bc954719a2962e891f02efaea754c9ea025894'),
    'wiki.stq': ('wiki.stq.npz', 'dd3ece0c0aa30e53ae0f4b558309bb60ab628652'),
    'wiki.su': ('wiki.su.npz', '7e48732e8a1fcf212e692924a4416a6ac3b3b055'),
    'wiki.sv': ('wiki.sv.npz', 'b9ec52e9423688f195f3145c243226c0e0b51e83'),
    'wiki.sw': ('wiki.sw.npz', '5262f0c645322b10eca73f792a970f10b2719e55'),
    'wiki.szl': ('wiki.szl.npz', 'fdd6d6b291cdbbcec5ff93451a588fdd103bb2d0'),
    'wiki.ta': ('wiki.ta.npz', 'da7c5bc6e1142306ff2669bf1739832beb6c1763'),
    'wiki.tcy': ('wiki.tcy.npz', 'baa49e1afa2bb0dcaaef0fac1ee75bbe711d1134'),
    'wiki.te': ('wiki.te.npz', 'baf48767ce85e4d41d65d25f2bbf1c5f559ec18f'),
    'wiki.tet': ('wiki.tet.npz', '11e46a893af55344dbe102d530fdfea5d949d3bc'),
    'wiki.tg': ('wiki.tg.npz', 'da66abb72ec9ccc602713161e544963d59cc51d7'),
    'wiki.th': ('wiki.th.npz', '25e54bf2d305779ec9baa5f344410bd75c7702fc'),
    'wiki.ti': ('wiki.ti.npz', '1faf98f3a0eafa7559a4b2a111f43dd1f7b9a05b'),
    'wiki.tk': ('wiki.tk.npz', '34c714fa8275fd6abfe86b2d144a043774552a6c'),
    'wiki.tl': ('wiki.tl.npz', '7d7f8a0485155bce7a74a1d778824375b0029f53'),
    'wiki.tn': ('wiki.tn.npz', 'd0bc3a9b948753ac2283e5e10480c9fa0f6acb53'),
    'wiki.to': ('wiki.to.npz', 'e982fc31bcfcf7339988d7aad21ce29ac9e84b0b'),
    'wiki.tpi': ('wiki.tpi.npz', '448cef043fa4b7f97825dbf8ee205ef05543bcac'),
    'wiki.tr': ('wiki.tr.npz', 'c9830607a4c5134c6191006f1d80bae0ec798fe6'),
    'wiki.ts': ('wiki.ts.npz', '84a0598803712c8a713943447ddb73fc0f39af43'),
    'wiki.tt': ('wiki.tt.npz', '82c29df18f33e6284af3e977a6dda7e132a7a225'),
    'wiki.tum': ('wiki.tum.npz', '358990b894a3fb09d70674465952d828c9b0eda7'),
    'wiki.tw': ('wiki.tw.npz', '1e6d2838a4f271c1808795fb929cfcbf95094d93'),
    'wiki.ty': ('wiki.ty.npz', 'e41ca5192d8cb515b3561c8d6935b150deb027b7'),
    'wiki.tyv': ('wiki.tyv.npz', 'ce062ed32e854604714b65698ae290c99ba28060'),
    'wiki.udm': ('wiki.udm.npz', '9e1c5891ee0c5ac8f65fc457e1b42c7b2bfc8d37'),
    'wiki.ug': ('wiki.ug.npz', '656503e54063e200980e39f00fc011395bcd8551'),
    'wiki.uk': ('wiki.uk.npz', '352b7ee24d9fc6513fff4fe13bc04086c680834a'),
    'wiki.ur': ('wiki.ur.npz', 'a81e55c7adfc2cef779ce9a01fe21319a7e4943b'),
    'wiki.uz': ('wiki.uz.npz', 'd60d1e67bb8574dd71c18c88114aba674fc1eecb'),
    'wiki.ve': ('wiki.ve.npz', '5bfc3dbb3e47d23597df47ef12bd1c64ab8d3ea9'),
    'wiki.vep': ('wiki.vep.npz', '7a94355754fbe56802242c0bf9d7a27335095552'),
    'wiki.vi': ('wiki.vi.npz', 'f118039eb16a4ca3347b6b171eac41113350a041'),
    'wiki.vls': ('wiki.vls.npz', '9a46a2fdc6448aa54f212081643745499ea7d05c'),
    'wiki.vo': ('wiki.vo.npz', '8e2f93c85ac608bcc4ae14093b9ff016061378fb'),
    'wiki.wa': ('wiki.wa.npz', '907074f7743d30cdbb2c48d0c8b4040796ea4164'),
    'wiki.war': ('wiki.war.npz', '928fb410c394b9c18d875326b6a3e750e2611e1b'),
    'wiki.wo': ('wiki.wo.npz', '7bb352be44f7261aa926f49b13e77df30f29312f'),
    'wiki.wuu': ('wiki.wuu.npz', '0d1dc7b05867ff2156a1180ad3da3b4697924e59'),
    'wiki.xal': ('wiki.xal.npz', 'd87f4a131e086dc0bdc2a7e10406820c3c03b6a9'),
    'wiki.xh': ('wiki.xh.npz', 'c64e1d2e77d1c744a628e2bd7353284616e48bea'),
    'wiki.xmf': ('wiki.xmf.npz', '160b9ee9773b9099aaf37ae9bdbc8a4a93b7f6ea'),
    'wiki.yi': ('wiki.yi.npz', '0662542cee29f3392fc905004ac6443b32c1477c'),
    'wiki.yo': ('wiki.yo.npz', '5d12d3b902a1fa19d8548295c3802c0608afa5c8'),
    'wiki.za': ('wiki.za.npz', '536348ff89df62e968739b567a1245bfd4112fbe'),
    'wiki.zea': ('wiki.zea.npz', '61fa192289a7c0f73ffa8035632a38b91c31c224'),
    'wiki.zh_classical': ('wiki.zh_classical.npz', '9acc9eaf8ebe316b945fb1f56ac71a2b7e024854'),
    'wiki.zh_min_nan': ('wiki.zh_min_nan.npz', '5d38bc025c82af578299d60f7df7b399de6ed81a'),
    'wiki.zh': ('wiki.zh.npz', '94007fcf3b105bf2c21b84a3a22bdb7946e74804'),
    'wiki.zh_yue': ('wiki.zh_yue.npz', 'af6f0d94e6418d528d6cedd859e07e6e2fb416ab'),
    'wiki.zu': ('wiki.zu.npz', 'fc9ce07d5d0c49a3c86cf1b26056ada58f9404ca'),
    'cc.af.300': ('cc.af.300-6cf6fb1b.npz', '6cf6fb1b9f890787cbd3b510ef6201de9e02a297'),
    'cc.als.300': ('cc.als.300-479a6674.npz', '479a66746401f6119a7e4cba58ddfac5f9937ba6'),
    'cc.am.300': ('cc.am.300-0d9530cd.npz', '0d9530cd2b7e4bc9eac96048ed5cbf7d3cc9f799'),
    'cc.an.300': ('cc.an.300-ef9cb799.npz', 'ef9cb799a5a627a9d33b54604aff1593e0de3b40'),
    'cc.ar.300': ('cc.ar.300-e9c5e360.npz', 'e9c5e360d5cd050effd9ce42f831b9c94b7ffbd9'),
    'cc.arz.300': ('cc.arz.300-9e6a80e7.npz', '9e6a80e752f3830b5cc934884d0a65f8cf94eff4'),
    'cc.as.300': ('cc.as.300-8b00a681.npz', '8b00a681b079d56929bedf1ced16b3c9573c5b37'),
    'cc.ast.300': ('cc.ast.300-8681d5cb.npz', '8681d5cbbdfd89bed0a9335a8e6f28617185627a'),
    'cc.az.300': ('cc.az.300-06632ae7.npz', '06632ae75e85f75caa9b87f8327661333a504ccc'),
    'cc.azb.300': ('cc.azb.300-01c48025.npz', '01c480257a8343fd18d1d9011dd14ef5c3f124a2'),
    'cc.ba.300': ('cc.ba.300-afc6b4d1.npz', 'afc6b4d1e77964965fd8cc2ff31e077286af81e4'),
    'cc.bar.300': ('cc.bar.300-67450b87.npz', '67450b879ae9d6d5e1b7c7150baab9173563d38a'),
    'cc.bcl.300': ('cc.bcl.300-261d8d11.npz', '261d8d11ca9fe67a12de812976398722b30e1df2'),
    'cc.be.300': ('cc.be.300-cd32b101.npz', 'cd32b101a860ae629f05ee90beb2a8f137ed8bc2'),
    'cc.bg.300': ('cc.bg.300-088de1c6.npz', '088de1c633cbfe8e06405badd685bc04f2127cfd'),
    'cc.bh.300': ('cc.bh.300-35ced78e.npz', '35ced78e8dc524f17e7ba4a5326b6bbeb92af4e1'),
    'cc.bn.300': ('cc.bn.300-98293882.npz', '98293882fc548c2047f5482ea4dcd5eedef58f13'),
    'cc.bo.300': ('cc.bo.300-7653c3c7.npz', '7653c3c76bfb21a3f4e655b4a3d347d6b5e1ebc3'),
    'cc.bpy.300': ('cc.bpy.300-8225d2db.npz', '8225d2db3bbd34c1f27e491b41d35e1f4394f529'),
    'cc.br.300': ('cc.br.300-ac611b58.npz', 'ac611b58dd6006dc741170ea4066aeff8b8b7a0c'),
    'cc.bs.300': ('cc.bs.300-be17aeed.npz', 'be17aeedde87cdd173a3508edf2762311df5b369'),
    'cc.ca.300': ('cc.ca.300-8e7f57c1.npz', '8e7f57c190a9a4bd5513b9d268b5a26f55202fe0'),
    'cc.ce.300': ('cc.ce.300-7ef28422.npz', '7ef28422df058d6be07c819c195b9ce50be5a985'),
    'cc.ceb.300': ('cc.ceb.300-25801d42.npz', '25801d429ed046998749cb07526533b9c63bded2'),
    'cc.ckb.300': ('cc.ckb.300-c56f75b4.npz', 'c56f75b46cc38357f38f7de51d46e97c66381ca0'),
    'cc.co.300': ('cc.co.300-f9394c12.npz', 'f9394c1285bf6d5d33b1c28387535e1010a1d4c6'),
    'cc.cs.300': ('cc.cs.300-82823bbf.npz', '82823bbfc29ec94051b72079939eb66d5db4d1bf'),
    'cc.cv.300': ('cc.cv.300-6862885d.npz', '6862885d97a2c84792bf7f291338008757eb5790'),
    'cc.cy.300': ('cc.cy.300-c649c74c.npz', 'c649c74c0ca139d80e19b9a98b5f5d15386393d7'),
    'cc.da.300': ('cc.da.300-ee9246dc.npz', 'ee9246dc34da5fa1e2d49d37395b169598488324'),
    'cc.de.300': ('cc.de.300-713dc52f.npz', '713dc52f1c24b5c31e4104aee9d92e7e26bd6db9'),
    'cc.diq.300': ('cc.diq.300-fdc37a8e.npz', 'fdc37a8e2357e922bc27f945f1e080d80fbcae5a'),
    'cc.dv.300': ('cc.dv.300-d37b74b2.npz', 'd37b74b2247761723126b92183857f5e32a4f17c'),
    'cc.el.300': ('cc.el.300-888b3ecf.npz', '888b3ecfc9f3e16349d15cc85b5453a90f524529'),
    'cc.eml.300': ('cc.eml.300-01926a33.npz', '01926a335cb7055270066d07a9d050a786398adf'),
    'cc.en.300': ('cc.en.300-79da8fea.npz', '79da8fea1408d642ce43a5fdf40c3c803a49db2c'),
    'cc.eo.300': ('cc.eo.300-02accc23.npz', '02accc23007b196a0bab9be70dcfe911fb8fa87c'),
    'cc.es.300': ('cc.es.300-a0063528.npz', 'a00635289e65081d50fc46bb39203e48115b5d20'),
    'cc.et.300': ('cc.et.300-2916e309.npz', '2916e309a61ba0b83761ed9b4f75d959ad59247f'),
    'cc.eu.300': ('cc.eu.300-0257399f.npz', '0257399f1433ca579aeaf625f897b01c2f041438'),
    'cc.fa.300': ('cc.fa.300-d5aca585.npz', 'd5aca58546a99513e1f96b6df7a52b95ace2247a'),
    'cc.fi.300': ('cc.fi.300-ed53841e.npz', 'ed53841e29ebf6d701ee4c96a10c25f2ecc8a904'),
    'cc.fr.300': ('cc.fr.300-c87b8969.npz', 'c87b89697779a76650b5a583a5d682809d73a794'),
    'cc.frr.300': ('cc.frr.300-dd4b3bdf.npz', 'dd4b3bdf9d6df61f7e9e94cdf754dee46ec15fa7'),
    'cc.fy.300': ('cc.fy.300-7eb20794.npz', '7eb20794c65568e6fabe5c9df974d1951035a819'),
    'cc.ga.300': ('cc.ga.300-8d09df0e.npz', '8d09df0e774f7ac3fe7cafb8ed67dd58388743a9'),
    'cc.gd.300': ('cc.gd.300-606435bb.npz', '606435bba611f1c77a59e684ac44c3e852d31beb'),
    'cc.gl.300': ('cc.gl.300-a58a25da.npz', 'a58a25da563958c3ae70fc023c4f25bd2fc8a75d'),
    'cc.gom.300': ('cc.gom.300-ec42b285.npz', 'ec42b285a4cbb43ca76056ea0873f0a3b4c19a2e'),
    'cc.gu.300': ('cc.gu.300-ddfdc7d5.npz', 'ddfdc7d5351cbf95838050af53c76e874a013f3d'),
    'cc.gv.300': ('cc.gv.300-df66ebec.npz', 'df66ebec5580e2e8ce5ed42b0116768ac1e63d43'),
    'cc.he.300': ('cc.he.300-bd197a43.npz', 'bd197a43f2600b73f42480f901f8fafb9056e334'),
    'cc.hi.300': ('cc.hi.300-e8f1a8ee.npz', 'e8f1a8ee11d469ee007ac66f1a6ae2d9cf996fde'),
    'cc.hif.300': ('cc.hif.300-cd787567.npz', 'cd7875675c126764f76394435d114a0405a6341b'),
    'cc.hr.300': ('cc.hr.300-f33745d1.npz', 'f33745d1c8e966932d5034f248bcc22b7f8d2297'),
    'cc.hsb.300': ('cc.hsb.300-2c0e9847.npz', '2c0e9847177614324fd271e9c9fa5524969090e9'),
    'cc.ht.300': ('cc.ht.300-3192d8a6.npz', '3192d8a632af0d617d9a9c9e78f4015d0f594131'),
    'cc.hu.300': ('cc.hu.300-08a106da.npz', '08a106da56e64d2b8db4306cbacc99086b49659d'),
    'cc.hy.300': ('cc.hy.300-935747f2.npz', '935747f2a88dff9edf957723fe4736d6ebcf1d6a'),
    'cc.ia.300': ('cc.ia.300-737f4b78.npz', '737f4b78c4fa857a575ea01e6946217b69616ee9'),
    'cc.id.300': ('cc.id.300-b50ae07a.npz', 'b50ae07a0663023c3c117305c05b09143a167700'),
    'cc.ilo.300': ('cc.ilo.300-02b500a7.npz', '02b500a7e10d206239aa502590ff4768840e29c0'),
    'cc.io.300': ('cc.io.300-aaf228a7.npz', 'aaf228a78ce7dc1138181a32011c4d495e383e81'),
    'cc.is.300': ('cc.is.300-2f612f20.npz', '2f612f20cfdcd68b5eb46dacef4ba30f00069f55'),
    'cc.it.300': ('cc.it.300-5b21ee40.npz', '5b21ee408ab99c35a2bdd25e716975e0b73182ad'),
    'cc.ja.300': ('cc.ja.300-89cf6cb7.npz', '89cf6cb70985ca841246139719028103e7a932f8'),
    'cc.jv.300': ('cc.jv.300-85d4a52b.npz', '85d4a52b83150aa46ea60887d58e12f5b8fbc732'),
    'cc.ka.300': ('cc.ka.300-048778a9.npz', '048778a9ac39f9e4fc2b216f5fe752864c793295'),
    'cc.kk.300': ('cc.kk.300-f29ac700.npz', 'f29ac7000778e5adea0c9aa00f11fdcc47386adf'),
    'cc.km.300': ('cc.km.300-b9a2073f.npz', 'b9a2073f8d325e49934ac919cbe222ac84ef77af'),
    'cc.kn.300': ('cc.kn.300-034e4f17.npz', '034e4f17d08351a890896d9b7d2573a88d0fc230'),
    'cc.ko.300': ('cc.ko.300-28e7ae64.npz', '28e7ae64e994b9989f042323ec6f15f5ad7a53d2'),
    'cc.ku.300': ('cc.ku.300-82496bfd.npz', '82496bfd5e23f697b17ae4f351c1a13b12f482b5'),
    'cc.ky.300': ('cc.ky.300-4efb03dc.npz', '4efb03dc26319fd813edfe7cd1c1f373d134ac97'),
    'cc.la.300': ('cc.la.300-8adf2142.npz', '8adf2142b05825aa040d4b96afee9f08b00b94fe'),
    'cc.lb.300': ('cc.lb.300-8945d3df.npz', '8945d3dfb24fbe5ac9391aa10296f9a18992c380'),
    'cc.li.300': ('cc.li.300-0b6aee43.npz', '0b6aee432ca667db8b06dfb29fd249d00df7a275'),
    'cc.lmo.300': ('cc.lmo.300-a02cf032.npz', 'a02cf032a3af3a035bec24b2b225048bf0f86eb5'),
    'cc.lt.300': ('cc.lt.300-2b682e7d.npz', '2b682e7d30e739c4090fef65593d29f40f1323f9'),
    'cc.lv.300': ('cc.lv.300-c2453825.npz', 'c24538254050ce393b7ed8a018ed27a693c9dfa1'),
    'cc.mai.300': ('cc.mai.300-4bc11fe3.npz', '4bc11fe3470e23c79ad5bc2a16283ede92857f9b'),
    'cc.mg.300': ('cc.mg.300-2b644c0f.npz', '2b644c0fe3d32d89cf4a91a62b30a8cdf84eb69e'),
    'cc.mhr.300': ('cc.mhr.300-f9216c88.npz', 'f9216c883afb62c0fd890f1df1f076fda48d534d'),
    'cc.min.300': ('cc.min.300-0d8c3a77.npz', '0d8c3a7709acb9386c9bfb29294c56923e2fe160'),
    'cc.mk.300': ('cc.mk.300-bf1caa91.npz', 'bf1caa91a2376a6e4cae5576e84c00bd7b4d53ea'),
    'cc.ml.300': ('cc.ml.300-0c3baa74.npz', '0c3baa74f062367e00c2df09446480df4ef45b79'),
    'cc.mn.300': ('cc.mn.300-4ce878ea.npz', '4ce878ea1e15afffefa257374a8e265bc26b9d19'),
    'cc.mr.300': ('cc.mr.300-a9e08f9d.npz', 'a9e08f9d21627dc34318208aebb0b7a8f78aeb47'),
    'cc.mrj.300': ('cc.mrj.300-1ebb04f1.npz', '1ebb04f175c1e115c77167222cbfc434474dbf11'),
    'cc.ms.300': ('cc.ms.300-05216b2f.npz', '05216b2f3f76af940bd343135be243c8ed5f0de5'),
    'cc.mt.300': ('cc.mt.300-2a3ba408.npz', '2a3ba408205f3552f432d97fca3de797aa086c62'),
    'cc.mwl.300': ('cc.mwl.300-e758f2b4.npz', 'e758f2b42482ad9d1caf1d4f46f8873a61f6e0ce'),
    'cc.my.300': ('cc.my.300-443b1674.npz', '443b16746ef8f23d64a397b21b1d0ae5707d1e5c'),
    'cc.myv.300': ('cc.myv.300-67d19cef.npz', '67d19ceffa23cb376c309f9e985222579abb9ac1'),
    'cc.mzn.300': ('cc.mzn.300-ce441f50.npz', 'ce441f50a28f0b1f02b47ee1608297750ef0cabd'),
    'cc.nah.300': ('cc.nah.300-ba4c46c0.npz', 'ba4c46c0089109c65cfc25735c5000845345d56e'),
    'cc.nap.300': ('cc.nap.300-489727c7.npz', '489727c7e8241f98c0c7049387a12a101f625226'),
    'cc.nds.300': ('cc.nds.300-6265356d.npz', '6265356d5822372b15ca5103b5ef43f8b3ff4a1c'),
    'cc.ne.300': ('cc.ne.300-6b66b354.npz', '6b66b3542ec091054c2735cb3358b349c8ca3a87'),
    'cc.new.300': ('cc.new.300-f4747761.npz', 'f4747761d9827340fd8074a08e61769ab3a7cc11'),
    'cc.nl.300': ('cc.nl.300-1867fc6d.npz', '1867fc6d6f466fb0d2f46623530c21f4c149197b'),
    'cc.nn.300': ('cc.nn.300-3ce324ef.npz', '3ce324eff15cd595e81bb1882d23b7948772f400'),
    'cc.no.300': ('cc.no.300-6e39d0d5.npz', '6e39d0d5e205c7106be0a601dbd59455f17c97e1'),
    'cc.nso.300': ('cc.nso.300-90ba6fda.npz', '90ba6fdac1eb6d14d6de69b6a794a2a6194ea5a2'),
    'cc.oc.300': ('cc.oc.300-c66e395b.npz', 'c66e395bce5ad97815b7273556b6225e72b76a0d'),
    'cc.or.300': ('cc.or.300-8b14cde1.npz', '8b14cde1cee9858052430c9ecc6cfa8a16fcab39'),
    'cc.os.300': ('cc.os.300-1a888846.npz', '1a8888460713455b33f9cd2ddd957a1afda6ce45'),
    'cc.pa.300': ('cc.pa.300-185e0f43.npz', '185e0f4361f927fca6c0ff27cf8e1963d627041c'),
    'cc.pam.300': ('cc.pam.300-9ac2a111.npz', '9ac2a1112ffbe96cc9ba226a4cc9331f696db6e9'),
    'cc.pfl.300': ('cc.pfl.300-ca0cddb4.npz', 'ca0cddb47b061380b2522041d9472ca06240b92f'),
    'cc.pl.300': ('cc.pl.300-98c4c23c.npz', '98c4c23c78824a3801d05f9d67a696f9fcc40683'),
    'cc.pms.300': ('cc.pms.300-cbd33047.npz', 'cbd3304720df204b5c8ec576e3abf9306728f5d4'),
    'cc.pnb.300': ('cc.pnb.300-66b69add.npz', '66b69addc40b633af8d06c7d5fd8066ac64c8a2c'),
    'cc.ps.300': ('cc.ps.300-ce11c971.npz', 'ce11c97193ee28cdb53ed72c68b20465a607f957'),
    'cc.pt.300': ('cc.pt.300-985866df.npz', '985866df8e19f52f410e6251b82e3bb4494b0d1d'),
    'cc.qu.300': ('cc.qu.300-0ae2e211.npz', '0ae2e2111ee2e7aab1116b587fe302d86ab3641e'),
    'cc.rm.300': ('cc.rm.300-b2367a7f.npz', 'b2367a7f72e26ab5a844b7d8483a455dc73e1994'),
    'cc.ro.300': ('cc.ro.300-682eda30.npz', '682eda308c2a14041e71d0d0588dd17681294ec5'),
    'cc.ru.300': ('cc.ru.300-0f9c3b90.npz', '0f9c3b905669e0f2a32196bc2a391fe2ef40f5a4'),
    'cc.sa.300': ('cc.sa.300-1d0f5bfd.npz', '1d0f5bfdc3118f9ad77e704a7d808c9231cb13eb'),
    'cc.sah.300': ('cc.sah.300-f8532800.npz', 'f85328005fd0d2f0f09cbdc24760b20180b537c4'),
    'cc.sc.300': ('cc.sc.300-dcb4fb26.npz', 'dcb4fb26874067e449f609f9b2cd138b60606d33'),
    'cc.scn.300': ('cc.scn.300-e72c5de7.npz', 'e72c5de7693efab12d6f9a6508c0a5fa8845bd04'),
    'cc.sco.300': ('cc.sco.300-13d0662d.npz', '13d0662d930c18bf0c8dff7efc01219712d38351'),
    'cc.sd.300': ('cc.sd.300-baf6b5af.npz', 'baf6b5afa56fd93d78175307b3d84dbad85d2710'),
    'cc.sh.300': ('cc.sh.300-b6958a18.npz', 'b6958a18612551a7b325022fcbbdfa2637fb4411'),
    'cc.si.300': ('cc.si.300-c846206f.npz', 'c846206fd77cdb5619752e3cb448dbcc0dac61b6'),
    'cc.sk.300': ('cc.sk.300-4fc2be73.npz', '4fc2be73972027f55f88e288dc3c0ecb2a6fba42'),
    'cc.sl.300': ('cc.sl.300-6b735538.npz', '6b7355380cee5320c42b1aa8d41226a562bc6407'),
    'cc.so.300': ('cc.so.300-f09c2019.npz', 'f09c2019099cd0ae488810a26ceea3437c450711'),
    'cc.sq.300': ('cc.sq.300-c55b576c.npz', 'c55b576c14d06489d6105a7a1d9126e181877030'),
    'cc.sr.300': ('cc.sr.300-887cf83d.npz', '887cf83d9525573407f4206b268e6e3c31266403'),
    'cc.su.300': ('cc.su.300-224e9974.npz', '224e99745371a890c6c944aae94d6c5d637876b5'),
    'cc.sv.300': ('cc.sv.300-c5266ab8.npz', 'c5266ab8ee8a1c093b9437c6b598659c72dd1f7e'),
    'cc.sw.300': ('cc.sw.300-829d1ca0.npz', '829d1ca09c78d52280497fd257883292b53e8bc7'),
    'cc.ta.300': ('cc.ta.300-f8e9bee4.npz', 'f8e9bee4ea31e6952ff582855200ade217c11d9b'),
    'cc.te.300': ('cc.te.300-19b7470c.npz', '19b7470cd59e6a67986267cf9171c6d02340c1d1'),
    'cc.tg.300': ('cc.tg.300-069920da.npz', '069920da67fcaba58e2bd5f4bd505e3cd0b325ab'),
    'cc.th.300': ('cc.th.300-17f28dd9.npz', '17f28dd9fabe987d6017ed4ed0897e3f01ab18a2'),
    'cc.tk.300': ('cc.tk.300-ac4be8fe.npz', 'ac4be8fe39901913ac0ae5b9ec023ffdb2c4ccdd'),
    'cc.tl.300': ('cc.tl.300-919ed791.npz', '919ed791c7cc2f7f1a214611fa12d32187f186c5'),
    'cc.tr.300': ('cc.tr.300-cbd537c6.npz', 'cbd537c606cd41c6a90e2de71ad7dc2902e63363'),
    'cc.tt.300': ('cc.tt.300-c38d9317.npz', 'c38d93176d6fa35658352bd74a0fb81e0edf3d3a'),
    'cc.ug.300': ('cc.ug.300-d99daa00.npz', 'd99daa007459f8129508fdd3ffcab135083309d5'),
    'cc.uk.300': ('cc.uk.300-a20e9dab.npz', 'a20e9dab63d727dc4c03a99caf66c8a194a2f96e'),
    'cc.ur.300': ('cc.ur.300-57ca0636.npz', '57ca06364b7413195d75adda61c00f972ab1a43e'),
    'cc.uz.300': ('cc.uz.300-0f2eef78.npz', '0f2eef78cc68f14a89b6b6a2d6ac4b6613d080e9'),
    'cc.vec.300': ('cc.vec.300-c9bfa76a.npz', 'c9bfa76a5dc2787923f26ea314f3a5a957fcd00c'),
    'cc.vi.300': ('cc.vi.300-44d740f4.npz', '44d740f4044cb2cd8d442327c17b99c359a8ca43'),
    'cc.vls.300': ('cc.vls.300-08e7eaba.npz', '08e7eaba113d6084d1a25958165428486caf7d19'),
    'cc.vo.300': ('cc.vo.300-792d3a79.npz', '792d3a7983bb4560d05932d1a2de35203c6b9479'),
    'cc.wa.300': ('cc.wa.300-bfc87d4c.npz', 'bfc87d4c6738770afd3b9f0f5e7adccd79131a03'),
    'cc.war.300': ('cc.war.300-d8a9082f.npz', 'd8a9082f98ebd8b312cafbc90c50a8ab421dc06b'),
    'cc.xmf.300': ('cc.xmf.300-8bc1fdf1.npz', '8bc1fdf1db5f2716a2d6542c3ae6d5a4abbd2506'),
    'cc.yi.300': ('cc.yi.300-33533193.npz', '33533193c9b710d2ca283e8978b83e3842ea8f5d'),
    'cc.yo.300': ('cc.yo.300-9dc5edde.npz', '9dc5eddeee3354f3f587ecdca73caf01080c399d'),
    'cc.zea.300': ('cc.zea.300-c0a4fb02.npz', 'c0a4fb025aab6774db52d6a845108f5cf8738508'),
    'cc.zh.300': ('cc.zh.300-355cfcaf.npz', '355cfcafe71536226a1737aafb4530c9ba4fd09f'),
}

FAST_TEXT_BIN_SHA1 = {
    'wiki-news-300d-1M-subword': ('wiki-news-300d-1M-subword-c8853bda.bin',
                                  'c8853bdae00318097b6337c4631d342879d6b18c'),
    'crawl-300d-2M-subword': ('crawl-300d-2M-subword-e6b07293f.bin',
                              'e6b07293f7b0095e3c72c2a12bc09464b69444b0'),
    'cc.af.300': ('cc.af.300-33115ff8.bin', '33115ff8e4c8f439757c819399177f1f58f07f12'),
    'cc.als.300': ('cc.als.300-d6579933.bin', 'd65799331a03895d68a3fbe7611b181d7e7cc916'),
    'cc.am.300': ('cc.am.300-999b3e95.bin', '999b3e95a2c490d7fcab2a6e08074746303d3c17'),
    'cc.an.300': ('cc.an.300-65f5c5b8.bin', '65f5c5b88d1c8181ce60aff4275d14e8a7c4ae53'),
    'cc.ar.300': ('cc.ar.300-44333e53.bin', '44333e5344fe66e78322b05bf53d6047925097ee'),
    'cc.arz.300': ('cc.arz.300-430f08ff.bin', '430f08ffc7f9391ed09c781fabc30baf568b8d47'),
    'cc.as.300': ('cc.as.300-e85d59f6.bin', 'e85d59f6fe2e908b3caab3a8bc9bfd23d6885eb2'),
    'cc.ast.300': ('cc.ast.300-4bdc4520.bin', '4bdc452067cc838e49a1544902941470ff685b12'),
    'cc.az.300': ('cc.az.300-10a62cca.bin', '10a62cca45f99e977accd28912ee18c74332080e'),
    'cc.azb.300': ('cc.azb.300-5f148a4f.bin', '5f148a4f2d8feecb217da604ca02fabd0fc112fd'),
    'cc.ba.300': ('cc.ba.300-9310a2c1.bin', '9310a2c11fda72ec87493bd4d65330537911b09a'),
    'cc.bar.300': ('cc.bar.300-35ab084b.bin', '35ab084b3e3972419534bd60197a564c27ca90e0'),
    'cc.bcl.300': ('cc.bcl.300-cf0fb2f8.bin', 'cf0fb2f8f1cbd04ad12bebb9846d7636333de556'),
    'cc.be.300': ('cc.be.300-ac4ef017.bin', 'ac4ef017d975f0649c294f57fb83a3bddf55e137'),
    'cc.bg.300': ('cc.bg.300-a5a375ef.bin', 'a5a375ef5f670c0a0926aa1a8025df3190cfc2d0'),
    'cc.bh.300': ('cc.bh.300-776d7f4d.bin', '776d7f4d102a574cffba45a43b1913b2e23c6d94'),
    'cc.bn.300': ('cc.bn.300-e327bd67.bin', 'e327bd678adbda1b4ace3e020a0329f6146d9f6f'),
    'cc.bo.300': ('cc.bo.300-33174d4f.bin', '33174d4f9ffa87f71c401260a5a6008cdaac61cb'),
    'cc.bpy.300': ('cc.bpy.300-4f8f3598.bin', '4f8f35987bc35b30d11b189f7066c41510331d4e'),
    'cc.br.300': ('cc.br.300-7a48b869.bin', '7a48b869104057ba097c210d847de2f76ec748fb'),
    'cc.bs.300': ('cc.bs.300-8a237bd9.bin', '8a237bd9a530f8feee7feaab583d89028e26be8d'),
    'cc.ca.300': ('cc.ca.300-db0f7120.bin', 'db0f7120e03604c8dcedb57582cee4f7d5d9c90c'),
    'cc.ce.300': ('cc.ce.300-5f8cebac.bin', '5f8cebac11c1fbbb23540655f83d8afe1b1a7760'),
    'cc.ceb.300': ('cc.ceb.300-89a4764f.bin', '89a4764f1ff3dc073a76fda3290f04fe5adf83ac'),
    'cc.ckb.300': ('cc.ckb.300-990d1cef.bin', '990d1cef7d7d36c12f7b9afe2381251169417499'),
    'cc.co.300': ('cc.co.300-836763a0.bin', '836763a0b4e40facde79983f5156d8c6a875dffb'),
    'cc.cs.300': ('cc.cs.300-884c693a.bin', '884c693a557633cd711bcd2888a4088bdc74723e'),
    'cc.cv.300': ('cc.cv.300-0dfbf016.bin', '0dfbf0168205c4ca02fd7f249c8a4f7caec6ea2a'),
    'cc.cy.300': ('cc.cy.300-cb4b9534.bin', 'cb4b953463170fa209c2ce9991bea3a07575e9de'),
    'cc.da.300': ('cc.da.300-6b65b204.bin', '6b65b204ff034184c785678655ffc9fa7b642b34'),
    'cc.de.300': ('cc.de.300-fc6e4385.bin', 'fc6e438502a3b8aadf119d117f85120a3cc28bae'),
    'cc.diq.300': ('cc.diq.300-490f18c4.bin', '490f18c4a8963ca511a8d064da68eddd05f44e7f'),
    'cc.dv.300': ('cc.dv.300-4ffe23d6.bin', '4ffe23d6bd18a1ba6273601e543932abf69d4651'),
    'cc.el.300': ('cc.el.300-7a89986b.bin', '7a89986b681f178b92f3af015aaa4900ba6dd6a6'),
    'cc.eml.300': ('cc.eml.300-8a6221bf.bin', '8a6221bfd1d98e1d14c89db54436d17f505b065d'),
    'cc.en.300': ('cc.en.300-53588c22.bin', '53588c22cac7f8bf504169f671206b60da21d9b2'),
    'cc.eo.300': ('cc.eo.300-5d9aeebb.bin', '5d9aeebb2c19807839ef68b5c5f7897d1e8ddd3a'),
    'cc.es.300': ('cc.es.300-e9f8c041.bin', 'e9f8c04142005cadae449f016e1bebf7ae254307'),
    'cc.et.300': ('cc.et.300-3f4391ed.bin', '3f4391edec8cf6aafcf9857bf465439f00b84a1a'),
    'cc.eu.300': ('cc.eu.300-142f1337.bin', '142f1337d51569f9254a50bdcfe125c028f28bb5'),
    'cc.fa.300': ('cc.fa.300-3d6ad675.bin', '3d6ad6750c27ad94e3498314a985d81bf20130f0'),
    'cc.fi.300': ('cc.fi.300-edbd8e6e.bin', 'edbd8e6e56ab951429911ce7a16d51260773e81c'),
    'cc.fr.300': ('cc.fr.300-35ea5d6b.bin', '35ea5d6b86011a5b85d0671d133acf8aded5fc54'),
    'cc.frr.300': ('cc.frr.300-d87f646a.bin', 'd87f646a6c3559263217941255856da48d159e4d'),
    'cc.fy.300': ('cc.fy.300-fd96db60.bin', 'fd96db60715adb8aaddc85123e14b3d081ef0ad3'),
    'cc.ga.300': ('cc.ga.300-520acbd7.bin', '520acbd7771703194c8e99b28094ea54fa86a3c7'),
    'cc.gd.300': ('cc.gd.300-781ceb1c.bin', '781ceb1cceaa107adea7c0434677c74906c05e4c'),
    'cc.gl.300': ('cc.gl.300-b71ae11d.bin', 'b71ae11d25dfecfa3dfe83e49b24a85037e83b43'),
    'cc.gom.300': ('cc.gom.300-65ba9b91.bin', '65ba9b9172c78600b5fcccd7514e6f5cb6b34750'),
    'cc.gu.300': ('cc.gu.300-d717959d.bin', 'd717959de35ffdc4be47ea282181f3118fa6af05'),
    'cc.gv.300': ('cc.gv.300-15fb06cb.bin', '15fb06cbfed61516a6014cb04f45e3876b154ae2'),
    'cc.he.300': ('cc.he.300-743fbd32.bin', '743fbd320942c5c48bb4347beb9f24aa5d3b46f4'),
    'cc.hi.300': ('cc.hi.300-75e919aa.bin', '75e919aa43832d6a7f08b8e05d9ddff562ead072'),
    'cc.hif.300': ('cc.hif.300-0c25528b.bin', '0c25528b1f156a61205b96817b0fa9995fa5a2b3'),
    'cc.hr.300': ('cc.hr.300-ab167ebb.bin', 'ab167ebb9a5cdd999500fd1beac2229796923795'),
    'cc.hsb.300': ('cc.hsb.300-62fb0705.bin', '62fb07054f659ce5d9f2e2dda67133649b432611'),
    'cc.ht.300': ('cc.ht.300-292d0eeb.bin', '292d0eebf256811b9cc7d6cd5dccf039d5083cf9'),
    'cc.hu.300': ('cc.hu.300-9d660157.bin', '9d660157bc371de60ead317cce852d506544f0e2'),
    'cc.hy.300': ('cc.hy.300-fa5ac6a1.bin', 'fa5ac6a1eb9e1e4e047bbf8343ea042ded75dd40'),
    'cc.ia.300': ('cc.ia.300-a01758dc.bin', 'a01758dcab7138e5f67e9fd58c23b18e88142b4b'),
    'cc.id.300': ('cc.id.300-609f02da.bin', '609f02daa0c13e544c52314452bf077f6f769019'),
    'cc.ilo.300': ('cc.ilo.300-199068ee.bin', '199068ee56ce25ac16b6ba70c3ae337f8eed9d96'),
    'cc.io.300': ('cc.io.300-80565e7e.bin', '80565e7e7e71b28e247ebb85da1e767cc62e7c38'),
    'cc.is.300': ('cc.is.300-b228019a.bin', 'b228019ac716a60a4da057e787a64b0b53c1a1ec'),
    'cc.it.300': ('cc.it.300-411f0ed7.bin', '411f0ed74448758f25c66699eec582ff5f9d2cc2'),
    'cc.ja.300': ('cc.ja.300-806f7e68.bin', '806f7e68c0c832afb5d70f0c072189fbb4d44108'),
    'cc.jv.300': ('cc.jv.300-af9d3f82.bin', 'af9d3f823a4d87c0dcf85d8b7ba753e1145cc4f9'),
    'cc.ka.300': ('cc.ka.300-7189ff30.bin', '7189ff30be4d8e45b394149b1fd9f3db794e3b42'),
    'cc.kk.300': ('cc.kk.300-621de409.bin', '621de40935e740a063a945402111b3bb7c619c08'),
    'cc.km.300': ('cc.km.300-6410e183.bin', '6410e1832df131f309337416e4ed07a19bd22d9f'),
    'cc.kn.300': ('cc.kn.300-dfcf2d68.bin', 'dfcf2d68bf43a1dcbb5d01e5076db16132e27d8f'),
    'cc.ko.300': ('cc.ko.300-b7990877.bin', 'b7990877d498f084adf300f63b53565bc868b520'),
    'cc.ku.300': ('cc.ku.300-eb62ada0.bin', 'eb62ada0e5bf9cf0535f1fe80d47b136665a8e3a'),
    'cc.ky.300': ('cc.ky.300-01ae0d23.bin', '01ae0d2346e12e30b7ac0422cfd1f3ad6cb701da'),
    'cc.la.300': ('cc.la.300-08e402f3.bin', '08e402f3d0d10da67444890fe15ca09e563f11a6'),
    'cc.lb.300': ('cc.lb.300-c3b5e0a3.bin', 'c3b5e0a3ee790f21f12c17f6302e73ba0ee644f7'),
    'cc.li.300': ('cc.li.300-b7c9c792.bin', 'b7c9c79273458c4110786f4a89c1fa0ec9bcaa80'),
    'cc.lmo.300': ('cc.lmo.300-b7da2fe8.bin', 'b7da2fe85b58341e63379a0e22ccb84a7d2466ba'),
    'cc.lt.300': ('cc.lt.300-73413b3f.bin', '73413b3f0072abf2eb7666795d77e9f0e85b327a'),
    'cc.lv.300': ('cc.lv.300-725f5e2a.bin', '725f5e2a1e66173d73cbf103fceb5f86844e2278'),
    'cc.mai.300': ('cc.mai.300-3de31332.bin', '3de31332d7afde6a93e3d05c05212d27ea538d3d'),
    'cc.mg.300': ('cc.mg.300-0c7757e2.bin', '0c7757e2b3417cea49c679291e6e7bfe8f3653d5'),
    'cc.mhr.300': ('cc.mhr.300-1013afe9.bin', '1013afe9cd1428e5915feebc3a2b189d8d77f9d0'),
    'cc.min.300': ('cc.min.300-1d684a9b.bin', '1d684a9bead229e94c9b538fc9aebb1235c6e68f'),
    'cc.mk.300': ('cc.mk.300-f9ba6f8e.bin', 'f9ba6f8eddb4e577bf44475f831984c70e371719'),
    'cc.ml.300': ('cc.ml.300-bc6a2b1c.bin', 'bc6a2b1c2743bc2749fc8072a8276e2beb3f9a22'),
    'cc.mn.300': ('cc.mn.300-7637ae47.bin', '7637ae47bb925fa77fe82dbe2d20eb3c56b517ee'),
    'cc.mr.300': ('cc.mr.300-3e5eb45e.bin', '3e5eb45e7475dd3115ef5cc91e7b0257989fde18'),
    'cc.mrj.300': ('cc.mrj.300-1593ea78.bin', '1593ea786cfcf70ba4feffda09de2dc2f2bcf80d'),
    'cc.ms.300': ('cc.ms.300-a743adf6.bin', 'a743adf6420ad8a7aa146d9218f14d1bdf5c3285'),
    'cc.mt.300': ('cc.mt.300-87c3b72c.bin', '87c3b72cfcd0383d7edb8f4075106f51d5e6b03c'),
    'cc.mwl.300': ('cc.mwl.300-5d3cc773.bin', '5d3cc7739062030b9733f5dcbd64fdb1f3d397ec'),
    'cc.my.300': ('cc.my.300-b84b8c93.bin', 'b84b8c93cbb60178ada74e23caf85cf443208739'),
    'cc.myv.300': ('cc.myv.300-ccf32608.bin', 'ccf32608c23258ff0b381b07ee6b4a1374fac29f'),
    'cc.mzn.300': ('cc.mzn.300-00c010f4.bin', '00c010f4c43e3ddb4fcdc29b4a946dafd5196151'),
    'cc.nah.300': ('cc.nah.300-052fcbbc.bin', '052fcbbc5fd6891ef38250b3731987e480ba072d'),
    'cc.nap.300': ('cc.nap.300-aa45c158.bin', 'aa45c158119e095eb186098e47b8037dcca0c847'),
    'cc.nds.300': ('cc.nds.300-c934b13a.bin', 'c934b13ab1a06ea288461b12b9065a13d6e6438e'),
    'cc.ne.300': ('cc.ne.300-7f70c5b9.bin', '7f70c5b9b7b9f598c041c7d8454d1d12e41005df'),
    'cc.new.300': ('cc.new.300-4f8f8762.bin', '4f8f876293ff7096f4fe0ed13148dd116bf57ce5'),
    'cc.nl.300': ('cc.nl.300-fb2cb6e7.bin', 'fb2cb6e75fff23b26d220395b6e2869be083722e'),
    'cc.nn.300': ('cc.nn.300-085e9ef7.bin', '085e9ef79e6bb147d53081a407d598658562dab1'),
    'cc.no.300': ('cc.no.300-d3028680.bin', 'd3028680f0e5458d2272ea14ee56a10820e4e406'),
    'cc.nso.300': ('cc.nso.300-6cc24a78.bin', '6cc24a78780f4da1a18d5da310217dc21acc1977'),
    'cc.oc.300': ('cc.oc.300-8cee765a.bin', '8cee765a77d21044792895b4fe32d56e8287c200'),
    'cc.or.300': ('cc.or.300-64fb17ff.bin', '64fb17ffcd76db9836be3a8c553b0c973232b4fa'),
    'cc.os.300': ('cc.os.300-e5c880f6.bin', 'e5c880f6499b1ea9f9d554d0ea356f914e4c4657'),
    'cc.pa.300': ('cc.pa.300-3673544d.bin', '3673544dea157cfcae180fe5a444457c7bed462e'),
    'cc.pam.300': ('cc.pam.300-1e894611.bin', '1e894611ec170839348af1f767164230f7225c94'),
    'cc.pfl.300': ('cc.pfl.300-ac9babfd.bin', 'ac9babfd17941341fdd06f9dc23aeb3dd315952a'),
    'cc.pl.300': ('cc.pl.300-ea55590b.bin', 'ea55590b385ca9c8ff409a807a4635624c73693e'),
    'cc.pms.300': ('cc.pms.300-523564e9.bin', '523564e993e7925c706c039d444c4048fa19658e'),
    'cc.pnb.300': ('cc.pnb.300-d09b6003.bin', 'd09b6003f0852f698f9589523e717c3be9b0e230'),
    'cc.ps.300': ('cc.ps.300-0cb19e87.bin', '0cb19e874d83664980312fa659f1f7269f1459e4'),
    'cc.pt.300': ('cc.pt.300-e69e6c5b.bin', 'e69e6c5b1ba0e802755c227d2161106caabb6b3d'),
    'cc.qu.300': ('cc.qu.300-f99c269d.bin', 'f99c269de57ff62ec2a580307e239d80d6c0ac1a'),
    'cc.rm.300': ('cc.rm.300-20d2cdcd.bin', '20d2cdcd8fbb49e000eb588e969046f4a4058c9b'),
    'cc.ro.300': ('cc.ro.300-30900544.bin', '309005440433a108017444689d8605709c5bd0ee'),
    'cc.ru.300': ('cc.ru.300-fd892a10.bin', 'fd892a10914cde02c4f1348f9b03d25d45e0d2d3'),
    'cc.sa.300': ('cc.sa.300-91f3b393.bin', '91f3b3931e2b6f4ab6fb092032df7218d400d330'),
    'cc.sah.300': ('cc.sah.300-ea2c7d00.bin', 'ea2c7d00ccfd6b02a928d1f9326986c64cc6e558'),
    'cc.sc.300': ('cc.sc.300-6879c580.bin', '6879c58057dd2eeff50ef158fe53a26ae9050070'),
    'cc.scn.300': ('cc.scn.300-4fb8dad7.bin', '4fb8dad71966dffe5c70efe330a1f881df6227dd'),
    'cc.sco.300': ('cc.sco.300-191f6929.bin', '191f6929dcf10e7d6198529108156b9dd48b23be'),
    'cc.sd.300': ('cc.sd.300-de045844.bin', 'de045844a43e931db0183bdce996110a8593aa63'),
    'cc.sh.300': ('cc.sh.300-529f81f1.bin', '529f81f1d5fec8c2208e976a11406c93de3e8920'),
    'cc.si.300': ('cc.si.300-c66d404a.bin', 'c66d404a889326a06e20c3cfe7eea80d866a1d13'),
    'cc.sk.300': ('cc.sk.300-2ed40f6a.bin', '2ed40f6aa0bcd369d1450bcea9b0cfab16e6d6d0'),
    'cc.sl.300': ('cc.sl.300-da689ced.bin', 'da689cedcfef7914985e6085df7d0c4ef68da657'),
    'cc.so.300': ('cc.so.300-07b7260a.bin', '07b7260aff73dc829cb49eb2bd72584122337b7f'),
    'cc.sq.300': ('cc.sq.300-440b0444.bin', '440b04440edb4d26751c4b13010d0335972808d8'),
    'cc.sr.300': ('cc.sr.300-23f9d7d9.bin', '23f9d7d93f7f4d0bfb73dea047eae5f4d67aef23'),
    'cc.su.300': ('cc.su.300-5d7d8243.bin', '5d7d82438fb71594a31ea46c0b5580ac41b37ece'),
    'cc.sv.300': ('cc.sv.300-6fafdc44.bin', '6fafdc4452a30350ded92e9309bea658f2a31279'),
    'cc.sw.300': ('cc.sw.300-73909439.bin', '7390943941f25d75fe2bdd9894b2d49f32b1a74b'),
    'cc.ta.300': ('cc.ta.300-2e0386c4.bin', '2e0386c410927b53eafbc63b07ab45ff27d6dac9'),
    'cc.te.300': ('cc.te.300-e77f5ea9.bin', 'e77f5ea9e2e726607bdfc6634cf5eac0b9f7d5b5'),
    'cc.tg.300': ('cc.tg.300-ba451c18.bin', 'ba451c18ba027b5e12fb1d129aefe1dc8e10b451'),
    'cc.th.300': ('cc.th.300-5b8a7299.bin', '5b8a729925df8059de767a393e1c9cfef8d94a41'),
    'cc.tk.300': ('cc.tk.300-3f602443.bin', '3f602443ebee0d49cc181f4f21f21bd9590a31d5'),
    'cc.tl.300': ('cc.tl.300-afee5714.bin', 'afee5714639cfe4d145bf1ef6294da065bc65b37'),
    'cc.tr.300': ('cc.tr.300-5ac2d698.bin', '5ac2d698881a330dfeb554c43cd3737605f04e66'),
    'cc.tt.300': ('cc.tt.300-8b467e9d.bin', '8b467e9d9834df62075829c00a007618280a3980'),
    'cc.ug.300': ('cc.ug.300-8dd88596.bin', '8dd88596669dba3822a701baab0fabb5c97ed7cb'),
    'cc.uk.300': ('cc.uk.300-89630e2d.bin', '89630e2d47dac2e0c7a2036e4a6021b5323dd5aa'),
    'cc.ur.300': ('cc.ur.300-997b377c.bin', '997b377c148c50f9e39ccf085e2316e23da54228'),
    'cc.uz.300': ('cc.uz.300-7f1e67da.bin', '7f1e67dae218977ffc2da9c7160a4ac268fa4199'),
    'cc.vec.300': ('cc.vec.300-21e1d068.bin', '21e1d068086afcaecc3fa585b72697eb5ca3aeee'),
    'cc.vi.300': ('cc.vi.300-3c52cba2.bin', '3c52cba2d0c5fbf781eef4068e31f6c53ba7ed8f'),
    'cc.vls.300': ('cc.vls.300-6ffd43bb.bin', '6ffd43bb11eceec01fd5f0d6fefc96f9c14a17f1'),
    'cc.vo.300': ('cc.vo.300-70751ce3.bin', '70751ce3c3867fa9ddc5fd7e435fcc9f1334e796'),
    'cc.wa.300': ('cc.wa.300-eaca4696.bin', 'eaca46968edb721849fc99e15647f9f0f2df3eca'),
    'cc.war.300': ('cc.war.300-a89f1676.bin', 'a89f1676dba8d7beae42828c71b43f749da7cbfd'),
    'cc.xmf.300': ('cc.xmf.300-bb054a64.bin', 'bb054a64c6e287173224fbc7bf19f7a365a5866f'),
    'cc.yi.300': ('cc.yi.300-38a25707.bin', '38a257077225bf544e5ac95d36125ccd26f1e45a'),
    'cc.yo.300': ('cc.yo.300-cecf6563.bin', 'cecf6563658de3082db9a197e8e5382d4a9c5b25'),
    'cc.zea.300': ('cc.zea.300-ac403268.bin', 'ac4032686216c76784c743c33e703109584d0a3f'),
    'cc.zh.300': ('cc.zh.300-bbab54e0.bin', 'bbab54e09aa1de478a02de1c2c7c71c3a8d1f4a9'),
    'wiki.aa': ('wiki.aa-19450d26.bin', '19450d26509c90a0a6f00114fb8d25f58e108d90'),
    'wiki.ab': ('wiki.ab-4c3cc463.bin', '4c3cc4637cf8c75abc4377c40e5238d15e506264'),
    'wiki.ace': ('wiki.ace-1d107b15.bin', '1d107b158e94cff010021775ad4d440035d375c0'),
    'wiki.ady': ('wiki.ady-568aebce.bin', '568aebce6b718077f8faa8441a7bd6ffdbbae821'),
    'wiki.af': ('wiki.af-e4c40da8.bin', 'e4c40da87e6628c32d82a736d0178298b8dc612d'),
    'wiki.ak': ('wiki.ak-c1c81013.bin', 'c1c81013d6ec19ad97fbf145df71f72341ff95f0'),
    'wiki.als': ('wiki.als-a77c3e58.bin', 'a77c3e58b0e13eb2a43dc43b4a519dc9f1a10fe8'),
    'wiki.am': ('wiki.am-18ab66cf.bin', '18ab66cfc9d1ae84679acc2edb4696ac79b77aec'),
    'wiki.an': ('wiki.an-ad4f3886.bin', 'ad4f3886c2f4794349bf45ddc7af700ce3941aa6'),
    'wiki.ang': ('wiki.ang-1053783b.bin', '1053783bb06e698f1705bd7244cad81134dae6ff'),
    'wiki.ar': ('wiki.ar-48738c73.bin', '48738c73a1438a8b615335deff77864556e783eb'),
    'wiki.arc': ('wiki.arc-9e0740db.bin', '9e0740dbf20d39fccd4b7bed2be329b06cf7270b'),
    'wiki.arz': ('wiki.arz-32384b81.bin', '32384b8102596a459436caf02031d29a2fb31b2a'),
    'wiki.as': ('wiki.as-50765f8c.bin', '50765f8c2a6bb827b843165aa6ab4b25ffb340c2'),
    'wiki.ast': ('wiki.ast-0b3e9cd0.bin', '0b3e9cd0c14ad6e72847f549cf4e2d684c23e2fc'),
    'wiki.av': ('wiki.av-26427883.bin', '2642788376154d8fc10e0f50eefd6ebd956d8211'),
    'wiki.ay': ('wiki.ay-3926337d.bin', '3926337dc3162e5eb369d2c4141aa19d43de7e77'),
    'wiki.az': ('wiki.az-7e1aa3b5.bin', '7e1aa3b54e75aa381104a36d32e9b2b943c58416'),
    'wiki.azb': ('wiki.azb-2a3112fe.bin', '2a3112fedf2eeee37d929f2e24e6ce93651c1e58'),
    'wiki.ba': ('wiki.ba-ddb26431.bin', 'ddb2643124e4d67da1099a6bb7c34ccda9c4d54b'),
    'wiki.bar': ('wiki.bar-76a67a05.bin', '76a67a057330963a89845248718e9c0cf43042e6'),
    'wiki.bat_smg': ('wiki.bat_smg-e6bb57b0.bin', 'e6bb57b0c61e2e4486b29c8437f073893111bc12'),
    'wiki.bcl': ('wiki.bcl-f9b50b40.bin', 'f9b50b40c7398b441db0d023b9546c5623ca81e6'),
    'wiki.be': ('wiki.be-9de13c85.bin', '9de13c852c5e283ac3362d3debc9343dcaf851ed'),
    'wiki.bg': ('wiki.bg-fa0e36e7.bin', 'fa0e36e702301e091dab5b50353f5b93ec99eda1'),
    'wiki.bh': ('wiki.bh-4ea0c4ce.bin', '4ea0c4ce9fb9e7fcec9b102a1d21e51cbea54860'),
    'wiki.bi': ('wiki.bi-d756a260.bin', 'd756a26035e8a4f4c556bfd40470a3504bf47380'),
    'wiki.bjn': ('wiki.bjn-a6bda749.bin', 'a6bda7490f87734de0e9cb0996e6edd68b32d097'),
    'wiki.bm': ('wiki.bm-ddae0aee.bin', 'ddae0aee51f99812ec418ca32ebc7bcb3d7d7afe'),
    'wiki.bn': ('wiki.bn-84a5663f.bin', '84a5663fdeb61edf7a2076b313970d5cef5a1e58'),
    'wiki.bo': ('wiki.bo-ee189a77.bin', 'ee189a7723d6d89088299b2f7b2b7c5c81c1a83c'),
    'wiki.bpy': ('wiki.bpy-7c9cab8b.bin', '7c9cab8bc9317b2c9b782f3684956f62ce5253c9'),
    'wiki.br': ('wiki.br-750d7016.bin', '750d7016b22ac7293214cb26e25562b1fc333165'),
    'wiki.bs': ('wiki.bs-0a2fdd98.bin', '0a2fdd987687a7485f4a1030d013f7b707af2d56'),
    'wiki.bug': ('wiki.bug-3937c2af.bin', '3937c2afd0b6bea60d31b600858002657319dfff'),
    'wiki.bxr': ('wiki.bxr-2b522edb.bin', '2b522edb5fef85bf5c2818f84cc1ffd13e4ddf95'),
    'wiki.ca': ('wiki.ca-fc711e4b.bin', 'fc711e4b5b67de1ebf6cd1f5f99bb09822953781'),
    'wiki.cbk_zam': ('wiki.cbk_zam-b7832a19.bin', 'b7832a1932382f1ce89562042009055a914f7c1e'),
    'wiki.cdo': ('wiki.cdo-e75244c2.bin', 'e75244c2d992bd14c0900546b950a707ee99c79a'),
    'wiki.ce': ('wiki.ce-06dcd3ba.bin', '06dcd3bab08d2caabe5b8e5b7e7fcce233858a43'),
    'wiki.ceb': ('wiki.ceb-35c5cd0f.bin', '35c5cd0f8aeef5a78a9113d0ef856e5470eb6400'),
    'wiki.ch': ('wiki.ch-9bfefcab.bin', '9bfefcab247cef190bbcc711e2982c033df8faab'),
    'wiki.cho': ('wiki.cho-7087a54a.bin', '7087a54a087863d5d7058d35478740cd3fdd716d'),
    'wiki.chr': ('wiki.chr-5e93d639.bin', '5e93d6398b44467f8a57593656127cc3a601d361'),
    'wiki.chy': ('wiki.chy-f119f436.bin', 'f119f43617ba2adbf6f7b10f573c3d6c8daa63a9'),
    'wiki.ckb': ('wiki.ckb-49d6d997.bin', '49d6d99772cac2e25beeb02d9f8f055739d1f369'),
    'wiki.co': ('wiki.co-dd8e6c6c.bin', 'dd8e6c6ce7d740c9a87f10a90b597df2d1a0d883'),
    'wiki.cr': ('wiki.cr-a60b68fc.bin', 'a60b68fc163412717af9d50ce6f8cce90de6089a'),
    'wiki.crh': ('wiki.crh-ae73e838.bin', 'ae73e83881604df8dfeb7ae558be351a57051080'),
    'wiki.cs': ('wiki.cs-a41ff81a.bin', 'a41ff81af6ef6ff5f692d9719c90fac2261b7c21'),
    'wiki.csb': ('wiki.csb-13121dd7.bin', '13121dd7558b3ea692d73c964bc721db6ccb8d9b'),
    'wiki.cu': ('wiki.cu-968dea66.bin', '968dea66e5856289724c4d1c8290c1012ea97df3'),
    'wiki.cv': ('wiki.cv-a87c66dc.bin', 'a87c66dc67a57af38333aeb375dd33e4c42f327f'),
    'wiki.cy': ('wiki.cy-4cc3571e.bin', '4cc3571ed974dd877daa3b5ffaf486725d4436a0'),
    'wiki.da': ('wiki.da-53f0da01.bin', '53f0da01b102ff17499678e0a3876146365b5de7'),
    'wiki.de': ('wiki.de-2da44d3d.bin', '2da44d3d5ac758a7c1a169f66db4953a020b1df4'),
    'wiki.diq': ('wiki.diq-f31f5534.bin', 'f31f5534d63a6adaf8fce1426fd2b8efa5dbb88e'),
    'wiki.dsb': ('wiki.dsb-1b26e0af.bin', '1b26e0af41d67a4a8a0d4e2e97ff7d8f958daaac'),
    'wiki.dv': ('wiki.dv-32a8ebf5.bin', '32a8ebf59405ad8f9919b18e27f2a2a79bdd3f3f'),
    'wiki.dz': ('wiki.dz-594a371f.bin', '594a371f17bec9ab45514bf5cf26252be7bb8396'),
    'wiki.ee': ('wiki.ee-e0003d72.bin', 'e0003d7287640101f6b9ecb69452cb47afa0d438'),
    'wiki.el': ('wiki.el-9c824bd0.bin', '9c824bd0e0e6888e2bbc065a27e2b45ec4164e8b'),
    'wiki.eml': ('wiki.eml-84490c6b.bin', '84490c6bedef5204c703b5ac5c9ee008147ddaa2'),
    'wiki.en': ('wiki.en-8ca82682.bin', '8ca8268250f81b88119949e0fea5a6b81bcac809'),
    'wiki.eo': ('wiki.eo-7baf04e3.bin', '7baf04e353a607bbddb36f439c4033097d854747'),
    'wiki.es': ('wiki.es-422e6f75.bin', '422e6f7582adff418f527ceb01763296c60e1f31'),
    'wiki.et': ('wiki.et-9cf101e3.bin', '9cf101e3cdb6cdf0b0cb16364769cbb26ef8875a'),
    'wiki.eu': ('wiki.eu-f5637868.bin', 'f56378689a3c14d26b0b1df0483c5b96c9a1ec9f'),
    'wiki.ext': ('wiki.ext-daefc0bc.bin', 'daefc0bc266f14f48a58e5ea632796adb9a36540'),
    'wiki.fa': ('wiki.fa-0b8559e6.bin', '0b8559e6b6506e262de3fb55ea9dec03244badca'),
    'wiki.ff': ('wiki.ff-4d6b11b3.bin', '4d6b11b3d6ccdfa2b06d91c78fd05d7a46106582'),
    'wiki.fi': ('wiki.fi-d1d2f60d.bin', 'd1d2f60da48564f659072dee5b2de1306cf2b590'),
    'wiki.fiu_vro': ('wiki.fiu_vro-fc73c1f3.bin', 'fc73c1f3caec0bff7ca7e3ec006c0c9757d2c8f2'),
    'wiki.fj': ('wiki.fj-d3f97816.bin', 'd3f9781664886cd2e332623615a1db8b2781c925'),
    'wiki.fo': ('wiki.fo-04aeaf7c.bin', '04aeaf7cef283cfdd6766af0c65f6a6b13f6040a'),
    'wiki.fr': ('wiki.fr-ee1dde08.bin', 'ee1dde0800113dcd6124ccb643bd1004184b7559'),
    'wiki.frp': ('wiki.frp-0f64bb1b.bin', '0f64bb1b389e30e3af163e526b72bfc4cab8eb7d'),
    'wiki.frr': ('wiki.frr-576ebf02.bin', '576ebf02e6b9b0acf2ea9da6d35e1a5b2c98648b'),
    'wiki.fur': ('wiki.fur-5ebed3c9.bin', '5ebed3c9e39243479326b288202b9e11d1c434c2'),
    'wiki.fy': ('wiki.fy-811bc386.bin', '811bc3864418110fe914f555216372b2f79b7fb5'),
    'wiki.ga': ('wiki.ga-77b3aa66.bin', '77b3aa6640cc25536b965f5dc512503d8d0c2a6a'),
    'wiki.gag': ('wiki.gag-a732c376.bin', 'a732c376f771309bc196fa8758fd5100c67627f6'),
    'wiki.gan': ('wiki.gan-40a8cfd9.bin', '40a8cfd9889646aa722c32dac2e0a5c76689c6a1'),
    'wiki.gd': ('wiki.gd-0dcdb67d.bin', '0dcdb67d346f0f9abc41554b7ca13190aa8fab16'),
    'wiki.gl': ('wiki.gl-44a91a4c.bin', '44a91a4cf3aaaa68feaa3dc10e16f03cb7d41e53'),
    'wiki.glk': ('wiki.glk-43f0bf43.bin', '43f0bf43b98d2e0477b0671ee9fce7f2cb8da6a3'),
    'wiki.gn': ('wiki.gn-29975179.bin', '2997517997b93f71613b9d008e6d95f68a01ad4b'),
    'wiki.gom': ('wiki.gom-08ba082b.bin', '08ba082b769cf631bfcd100631bfdda77980aa54'),
    'wiki.got': ('wiki.got-bfe0a90d.bin', 'bfe0a90d91343f24c8f9faea325f40395ab8bb8e'),
    'wiki.gu': ('wiki.gu-7d49d055.bin', '7d49d05551425e5661f968b9cc0354e15ea0405f'),
    'wiki.gv': ('wiki.gv-eeea71f6.bin', 'eeea71f64e24c80ff07482825f1ce26be19a69fd'),
    'wiki.ha': ('wiki.ha-87a99090.bin', '87a990900d4a74055303585b4d4a89ab7bf0aa47'),
    'wiki.hak': ('wiki.hak-c652e7ff.bin', 'c652e7ff3d63676307bcbd9f4241fb1c6b8cf7ff'),
    'wiki.haw': ('wiki.haw-4f2d842b.bin', '4f2d842b730bec90d0268bff9ca2c8f41fc33987'),
    'wiki.he': ('wiki.he-9c5eb5cd.bin', '9c5eb5cda37954c481d2053bd4e553bbfd34deb4'),
    'wiki.hi': ('wiki.hi-1ca0898a.bin', '1ca0898af562c2ec90a06860ebb27b5a7b0b8cf4'),
    'wiki.hif': ('wiki.hif-8876acba.bin', '8876acbaf8195b94724179aab516234b06f3812a'),
    'wiki.ho': ('wiki.ho-8bc406a1.bin', '8bc406a1defb5703a743a5b424c169b26ffb347c'),
    'wiki.hr': ('wiki.hr-b06384ed.bin', 'b06384ede2bbacae89cb7e94cc9457b0905b410c'),
    'wiki.hsb': ('wiki.hsb-c9cc78b6.bin', 'c9cc78b6e9c1eb2ec3ad57e0f47f2312134de86c'),
    'wiki.ht': ('wiki.ht-da38ff9e.bin', 'da38ff9e8e8e61672422316cba888f2f35fbf9f5'),
    'wiki.hu': ('wiki.hu-a7cd92e6.bin', 'a7cd92e6880b53ee880a7b9de6767a8bd77c9f1a'),
    'wiki.hy': ('wiki.hy-e23e7c36.bin', 'e23e7c36fe63418d46621efee4d4a5248fa7b9ce'),
    'wiki.hz': ('wiki.hz-1a43df11.bin', '1a43df118a1a21f3c9c2d7d43f1cc30900569fdb'),
    'wiki.ia': ('wiki.ia-439e6f2f.bin', '439e6f2f0bf209b7e36e166c8c7e0af6aba34cd2'),
    'wiki.id': ('wiki.id-4ed7d4aa.bin', '4ed7d4aabb54f0af97ca35e31b79711bec2a033e'),
    'wiki.ie': ('wiki.ie-7b0a9761.bin', '7b0a97617ddaf155b898ed9281ff5d2e78e428ef'),
    'wiki.ig': ('wiki.ig-f588d85a.bin', 'f588d85a10ba426ab4825aaaf66d4a87e82b22dd'),
    'wiki.ii': ('wiki.ii-3214212c.bin', '3214212c59f85e40a6fcd1ceb00b36428c1dcc17'),
    'wiki.ik': ('wiki.ik-6bf795cf.bin', '6bf795cf8233e6bfd312f943d301ff5ce70d70b7'),
    'wiki.ilo': ('wiki.ilo-17eb1eff.bin', '17eb1eff170510e85874f83136ead4cc9a2121a6'),
    'wiki.io': ('wiki.io-3f7d30f3.bin', '3f7d30f3abed949dbd089c67e0131f0412fdc84f'),
    'wiki.is': ('wiki.is-e246137d.bin', 'e246137db426f11ec6eb3cbf1bcd1152b0ce0aab'),
    'wiki.it': ('wiki.it-d3019ee2.bin', 'd3019ee2bdafaac7fbb3b9590ce4af35887e3ecc'),
    'wiki.iu': ('wiki.iu-25d55802.bin', '25d558026b0f65cbadd485f63f335faacd192dbd'),
    'wiki.ja': ('wiki.ja-7f4f37fa.bin', '7f4f37fad9c4cff36b221d73bdd8a2d6c5d96518'),
    'wiki.jam': ('wiki.jam-32f692c1.bin', '32f692c1f817d4a5f64e98942e50cfe24356cb43'),
    'wiki.jbo': ('wiki.jbo-2cada509.bin', '2cada509f2e32a01af248c11b76f1e3de313997f'),
    'wiki.jv': ('wiki.jv-2def005b.bin', '2def005b119888a0940302704639c6d47c452839'),
    'wiki.ka': ('wiki.ka-deed211e.bin', 'deed211e28a45a7cec32e9a4a6e0b8015bb5c75a'),
    'wiki.kaa': ('wiki.kaa-31a0f80c.bin', '31a0f80cb3a6e6d1d435489cfbc6a778e6177cbc'),
    'wiki.kab': ('wiki.kab-01dfdf1f.bin', '01dfdf1fcaf0888df6e43bb12e6f680c33181032'),
    'wiki.kbd': ('wiki.kbd-b753b4d4.bin', 'b753b4d4584d3ee158a0e65de8cf1e684b9204a6'),
    'wiki.kg': ('wiki.kg-bd1f271d.bin', 'bd1f271dc512d5e5e6100ddeb09d92ef20f5735b'),
    'wiki.ki': ('wiki.ki-6044fff2.bin', '6044fff24b0951468438c10bd17a67c3042d3df5'),
    'wiki.kj': ('wiki.kj-b4c8d6ad.bin', 'b4c8d6ad7b89e596e92b4ab275758837961c074a'),
    'wiki.kk': ('wiki.kk-3357eee9.bin', '3357eee9c3193859b2a254e7e03167f9e133aefa'),
    'wiki.kl': ('wiki.kl-2ae394ee.bin', '2ae394ee6b61bac8732b97a8b09783e2d49e7a64'),
    'wiki.km': ('wiki.km-ef0eed3b.bin', 'ef0eed3b83c8f54c7f124fd3f8d9c0200d981f8a'),
    'wiki.kn': ('wiki.kn-7ba6e9f2.bin', '7ba6e9f2da563dbd9a657032c8eb99c5b56cdba3'),
    'wiki.ko': ('wiki.ko-ae46f52b.bin', 'ae46f52bd2534a01b601449af7f2eccfa1c06719'),
    'wiki.koi': ('wiki.koi-fa0c7bdd.bin', 'fa0c7bdd198e6afd88b0f735796faa43a8dc33fb'),
    'wiki.kr': ('wiki.kr-08696f70.bin', '08696f7016cc384fd8170e6cf485da5f17d1b7cd'),
    'wiki.krc': ('wiki.krc-ff8a4631.bin', 'ff8a46318685e56cb5cf5eed87ec899c5352b963'),
    'wiki.ks': ('wiki.ks-19d31479.bin', '19d31479421121b35d4f1281846033125f8c4ad7'),
    'wiki.ksh': ('wiki.ksh-97112af8.bin', '97112af8d32fae08270e7a88cd4da3af85e23b35'),
    'wiki.ku': ('wiki.ku-0ef76a6f.bin', '0ef76a6ff71586b155eda3273205b1b7b08cd73d'),
    'wiki.kv': ('wiki.kv-a50d93bf.bin', 'a50d93bf0db87356b6e8f794a37c989392195277'),
    'wiki.kw': ('wiki.kw-77ef77b3.bin', '77ef77b3323955a9825c992868ba83cb80775e8e'),
    'wiki.ky': ('wiki.ky-3f5928bc.bin', '3f5928bca0dc2551c2a9d2b25a90aa957e9742bf'),
    'wiki.la': ('wiki.la-3fe4d514.bin', '3fe4d51458c4b10878b671c8a7c0550b4e7d6baa'),
    'wiki.lad': ('wiki.lad-753bb201.bin', '753bb20136b3372cdcddf3bf5cbbef2910039490'),
    'wiki.lb': ('wiki.lb-827a0e46.bin', '827a0e46d57af4b8b59cd921a072ee0c0dd713ca'),
    'wiki.lbe': ('wiki.lbe-2934dfa5.bin', '2934dfa5f791f36f46abff43fcafce5ea6726a59'),
    'wiki.lez': ('wiki.lez-f344710f.bin', 'f344710ffb5eb75b59fb97b9a91be1d6c01329eb'),
    'wiki.lg': ('wiki.lg-3c31935e.bin', '3c31935eeb7165c4bdc28a77644c82703e61deb7'),
    'wiki.li': ('wiki.li-a9214c96.bin', 'a9214c96d8df517c68bf95c0e832905e85c7a6a9'),
    'wiki.lij': ('wiki.lij-55fead2b.bin', '55fead2bf98a2ee9e19ba5890ac2d5d82679b21e'),
    'wiki.lmo': ('wiki.lmo-b3a6ce73.bin', 'b3a6ce73aa41892ded828247f22cf41c71c5044d'),
    'wiki.ln': ('wiki.ln-403279f9.bin', '403279f918ab9409df69f1582ad850aa02046696'),
    'wiki.lo': ('wiki.lo-a5903d28.bin', 'a5903d2807e8088df6cef9e88ad9e3fc42dbe17e'),
    'wiki.lrc': ('wiki.lrc-07de075f.bin', '07de075f09cb54767ec7e79114311ca5e58f6d3e'),
    'wiki.lt': ('wiki.lt-62e95727.bin', '62e957278fe6c45f73071c4c91e68d4f02a9fe20'),
    'wiki.ltg': ('wiki.ltg-1351a4b3.bin', '1351a4b3a671bd208f5a6527d9d9047124007f78'),
    'wiki.lv': ('wiki.lv-991eae2a.bin', '991eae2ae2cbe77a89133bb42c5829f15cf59c9e'),
    'wiki.mai': ('wiki.mai-56cee5cb.bin', '56cee5cbeb259bc26927e15baf68c7e0b88786ab'),
    'wiki.map_bms': ('wiki.map_bms-87356c93.bin', '87356c93b166304986df7b5df52728e896d58180'),
    'wiki.mdf': ('wiki.mdf-5c5f1c2c.bin', '5c5f1c2c499bed790b81c1954edad644b1d137aa'),
    'wiki.mg': ('wiki.mg-a1b18be8.bin', 'a1b18be8864cc40d2ef5be324783de32e35d3c40'),
    'wiki.mh': ('wiki.mh-14147c18.bin', '14147c18cd451b7693babf995edeafb1a03a6f01'),
    'wiki.mhr': ('wiki.mhr-204edb17.bin', '204edb1741f0b04566f0e2a9bce46e8a2411ce32'),
    'wiki.mi': ('wiki.mi-ef6b4e35.bin', 'ef6b4e35b9f3dc7aa8803bb422a48c72eaea64ec'),
    'wiki.min': ('wiki.min-9a0a9ebc.bin', '9a0a9ebc607286f43cb6dc8cd06e2fa8c8986f12'),
    'wiki.mk': ('wiki.mk-4100301f.bin', '4100301fafb6ff4c5531187c54c11e9f24679657'),
    'wiki.ml': ('wiki.ml-e08b01b3.bin', 'e08b01b34318ca3eebedcfd6d44c832a0f16dd37'),
    'wiki.mn': ('wiki.mn-f6a269d2.bin', 'f6a269d2225d518acbb45cc3f8c5cbc2a318ee30'),
    'wiki.mo': ('wiki.mo-394239a3.bin', '394239a3d27bed433cad8c70e5bba16a0a30838c'),
    'wiki.mr': ('wiki.mr-37b4bb82.bin', '37b4bb82fa499080e015b3081b85c8c3c5e3e6b9'),
    'wiki.mrj': ('wiki.mrj-37ca837d.bin', '37ca837dde630945217e46ff4065e5a2e795bc93'),
    'wiki.ms': ('wiki.ms-5b4ddb79.bin', '5b4ddb79ab02d5638ee69d60a6191b65fda5ce86'),
    'wiki.mt': ('wiki.mt-b3323fa1.bin', 'b3323fa1038143a3e791bc352e6964f197213af5'),
    'wiki.mus': ('wiki.mus-f005e240.bin', 'f005e2408799819e6337aa62afb8d92e713f60d6'),
    'wiki.mwl': ('wiki.mwl-f0838820.bin', 'f0838820a819b3de537d6e2e01c543ffea2cf2fc'),
    'wiki.my': ('wiki.my-d64aad4e.bin', 'd64aad4e6f5c6c7319d794e657e96718c752277f'),
    'wiki.myv': ('wiki.myv-0464a2f4.bin', '0464a2f4ffde9637f93d59f2004e350b15b1f4eb'),
    'wiki.mzn': ('wiki.mzn-872ffc98.bin', '872ffc987bff427a3bd7edab5850658f07611fed'),
    'wiki.na': ('wiki.na-d7b31b79.bin', 'd7b31b7991767f4d328347dcc871d11dffdd629d'),
    'wiki.nah': ('wiki.nah-712f2493.bin', '712f2493b87f6ce3f8991f842e91ae18f93e7357'),
    'wiki.nap': ('wiki.nap-11b97cb5.bin', '11b97cb5d41fa479322a569dbaf79b7e3c26f819'),
    'wiki.nds': ('wiki.nds-305ba618.bin', '305ba618d97b6b6b334a28df888ffe624ae4b9c9'),
    'wiki.nds_nl': ('wiki.nds_nl-fb880749.bin', 'fb880749b3326a03de850e064a65f89a4e069e40'),
    'wiki.ne': ('wiki.ne-72e739fd.bin', '72e739fd99cfda922ff3b8262550df087d59581d'),
    'wiki.new': ('wiki.new-8f66c97a.bin', '8f66c97ab6e30c0ee9ff350818e7df2da18636a0'),
    'wiki.ng': ('wiki.ng-bc569540.bin', 'bc569540c4fd3d4ddb6ab7bf1c63d3e576b0d0fa'),
    'wiki.nl': ('wiki.nl-40d9776a.bin', '40d9776a8466d3eebdc9c8e6b385bdd3271ea126'),
    'wiki.nn': ('wiki.nn-d4e5918c.bin', 'd4e5918cde9a4354dcc3c4174ae4fca97392b250'),
    'wiki.no': ('wiki.no-18db3b96.bin', '18db3b96776c453b37c343c663516a9b937635ae'),
    'wiki.nov': ('wiki.nov-3056416e.bin', '3056416e12e7d08fc4fdd85f0173a6dd72c40ab6'),
    'wiki.nrm': ('wiki.nrm-1a0a8daf.bin', '1a0a8daf48da8476dcef8018bae70e20dd027e36'),
    'wiki.nso': ('wiki.nso-977d9079.bin', '977d9079818970d709f50a1cd6a5917875b805fc'),
    'wiki.nv': ('wiki.nv-4dfd868a.bin', '4dfd868ae77b006a34e873180698e7152aef910e'),
    'wiki.ny': ('wiki.ny-ad7f85e7.bin', 'ad7f85e700fd386d88e5c82a53773afd493c7a3d'),
    'wiki.oc': ('wiki.oc-289fe81d.bin', '289fe81dbadcbd7ea052545b73c46206c34864ec'),
    'wiki.olo': ('wiki.olo-9721fefd.bin', '9721fefd1e1b1c3e51a0d8543f8c5473984fe2c4'),
    'wiki.om': ('wiki.om-71345bb8.bin', '71345bb8c3186e27bd4d1d4808a8cb097903e1bf'),
    'wiki.or': ('wiki.or-f55c1ca8.bin', 'f55c1ca84126f315312e2a7ed45e32ab91b8e636'),
    'wiki.os': ('wiki.os-c0148462.bin', 'c0148462d638e5dc94cef3ec607d8b6ef9672156'),
    'wiki.pa': ('wiki.pa-a0903f78.bin', 'a0903f78b47f32e11e4c62173bbedebb64a510e0'),
    'wiki.pag': ('wiki.pag-00e02108.bin', '00e021082f3a14b5603be9cc201b145405498f2a'),
    'wiki.pam': ('wiki.pam-dfe4c21c.bin', 'dfe4c21c29e4022f1ab848c060c3acb697d279f9'),
    'wiki.pap': ('wiki.pap-a3766e93.bin', 'a3766e936218cbd5e8ac0c279209960a7908b15a'),
    'wiki.pcd': ('wiki.pcd-986d648c.bin', '986d648ce805d15c3fa0e706c7a96c5d02e22298'),
    'wiki.pdc': ('wiki.pdc-031d7283.bin', '031d7283179b75f0f62e427b58eef4ecc7211243'),
    'wiki.pfl': ('wiki.pfl-826fc525.bin', '826fc525d7542d9c9a6ac3b72cfb01f438f6d33f'),
    'wiki.pi': ('wiki.pi-c0ddd653.bin', 'c0ddd653f5c89cea4eca90de1b0a8f78111e77a4'),
    'wiki.pih': ('wiki.pih-a71523db.bin', 'a71523dba29a0f98e6fd52c4bac3f984cdfcd0b2'),
    'wiki.pl': ('wiki.pl-b600fdc2.bin', 'b600fdc2f1d62c062ec6028d0652ede539081381'),
    'wiki.pms': ('wiki.pms-7e429bdf.bin', '7e429bdf7094257c372008d5ef1638f813f60da0'),
    'wiki.pnb': ('wiki.pnb-08ab3d18.bin', '08ab3d185ebc76a6636cb4da169a6904361ba048'),
    'wiki.pnt': ('wiki.pnt-14458f30.bin', '14458f3083992b5cddd87f2b9cbcd152377ff97b'),
    'wiki.ps': ('wiki.ps-b86afb94.bin', 'b86afb94162924807dc8e4c75d80fcfb71acda76'),
    'wiki.pt': ('wiki.pt-f971330c.bin', 'f971330cf54742dd17d1cb6245c1b3b468b42978'),
    'wiki.qu': ('wiki.qu-7cbfa5fd.bin', '7cbfa5fdb2d41e0569209c4a297a54b80743bc17'),
    'wiki.rm': ('wiki.rm-15cc9e74.bin', '15cc9e74f2ea0db93f8914a357e9b60840607b08'),
    'wiki.rmy': ('wiki.rmy-fdc5afea.bin', 'fdc5afeae1f185a2a551e091bf3d7731ba92223d'),
    'wiki.rn': ('wiki.rn-9859ac6f.bin', '9859ac6f33ae14670772f0fa06957127ffba60d8'),
    'wiki.ro': ('wiki.ro-be264092.bin', 'be264092886bd9cdfa3e0fe43896ee7e7b8039ad'),
    'wiki.roa_rup': ('wiki.roa_rup-ab463b13.bin', 'ab463b13e26f3c9ab99598ddcb722e70cf5bf35a'),
    'wiki.roa_tara': ('wiki.roa_tara-073b0d19.bin', '073b0d192290b9c45463ddc11f043ff1ec42371e'),
    'wiki.ru': ('wiki.ru-5fbe8dd5.bin', '5fbe8dd58e6f6f58fb430e948e4d6a3b6cd6b603'),
    'wiki.rue': ('wiki.rue-1d09f6c5.bin', '1d09f6c53dc669f2fed52b511ba551c9ebb5caa4'),
    'wiki.rw': ('wiki.rw-e5e6abb9.bin', 'e5e6abb981ce2898a10f19c092033111d881917b'),
    'wiki.sa': ('wiki.sa-a651ca36.bin', 'a651ca363e7b431f9a2340557fa54163ff523764'),
    'wiki.sah': ('wiki.sah-0a0642a3.bin', '0a0642a36a863726bf8009957505101b74e2d8ef'),
    'wiki.sc': ('wiki.sc-9a6d6d82.bin', '9a6d6d82cb0bf57cf0b05ecaadfa0614712ddca7'),
    'wiki.scn': ('wiki.scn-2beb5569.bin', '2beb556906fc10a70a5dc5d8359c57ddbb567620'),
    'wiki.sco': ('wiki.sco-99406b00.bin', '99406b00be5c98fc69e561b2cd6bf29549514d5d'),
    'wiki.sd': ('wiki.sd-f9bafcac.bin', 'f9bafcacfc1b99aa5235ef6ff23f0532a638a89d'),
    'wiki.se': ('wiki.se-4ec410b7.bin', '4ec410b7963d85535bbc40429e3e74597aa102a3'),
    'wiki.sg': ('wiki.sg-05416c3e.bin', '05416c3e636d6b4612966de3476262760dc1b6af'),
    'wiki.sh': ('wiki.sh-d1262628.bin', 'd126262872b90d3d9d3d4a91c009a1a4a8ba6c38'),
    'wiki.si': ('wiki.si-cba0721f.bin', 'cba0721fa9b6d6ef470da3f852c475cef2af793e'),
    'wiki.simple': ('wiki.simple-67424112.bin', '67424112bc1879dc1288c9081ac3292aed1027e9'),
    'wiki.sk': ('wiki.sk-42878f2a.bin', '42878f2afd7633bdb5c2b4f742c4d1b13377eb00'),
    'wiki.sl': ('wiki.sl-3df13aa9.bin', '3df13aa9cf7c2c5a8b7a655e129cca46bc7635d7'),
    'wiki.sm': ('wiki.sm-0b04a63e.bin', '0b04a63e3cdc04722530f7b1d60dfa01368191b8'),
    'wiki.sn': ('wiki.sn-30f67c3f.bin', '30f67c3f26a074888813ebf67d9ae9c4d5863d2f'),
    'wiki.so': ('wiki.so-8466ae2e.bin', '8466ae2ea133cac06cceb240934e826a9e304d89'),
    'wiki.sq': ('wiki.sq-4068a1bc.bin', '4068a1bcce63aee6af1aabfd8139dc6508c017cf'),
    'wiki.sr': ('wiki.sr-082e3132.bin', '082e3132151777aa9f20f005dbb59b78f415cb5f'),
    'wiki.srn': ('wiki.srn-b7f15abf.bin', 'b7f15abf361445aa2bb621b71f7e70bbf88cb547'),
    'wiki.ss': ('wiki.ss-d84b4c58.bin', 'd84b4c58fc78d5bfd8e0ae3909fa6ad8966ed5a2'),
    'wiki.st': ('wiki.st-41bbfe88.bin', '41bbfe88fcc624496d35ed1801da3c51dd444c43'),
    'wiki.stq': ('wiki.stq-7869010b.bin', '7869010b7edd26d51849f676ef1a4f39dc83ec55'),
    'wiki.su': ('wiki.su-522015ae.bin', '522015ae575b367ba73baed722168c6035bf1a4f'),
    'wiki.sv': ('wiki.sv-2b51c008.bin', '2b51c00867be3483aa123b82af93bab8fc596886'),
    'wiki.sw': ('wiki.sw-b19842d4.bin', 'b19842d48289ca2a81b7b22e34b467cf8dfb9a26'),
    'wiki.szl': ('wiki.szl-19f27783.bin', '19f277833eea6f5d878114e54dc097764f963efb'),
    'wiki.ta': ('wiki.ta-0746a2ef.bin', '0746a2ef062efecd5268146d64c060ef1e9144f2'),
    'wiki.tcy': ('wiki.tcy-0ff14866.bin', '0ff1486683d6b736a04305e8625f8d3850c6a3a8'),
    'wiki.te': ('wiki.te-0dc2bd97.bin', '0dc2bd97553cc270d3d4154c35fcfce6998a88bd'),
    'wiki.tet': ('wiki.tet-670940fc.bin', '670940fc5658e21740f8d9ce442e6133b5e3e260'),
    'wiki.tg': ('wiki.tg-488952ce.bin', '488952ce406c4deafd1d5dfb1336f49341faef55'),
    'wiki.th': ('wiki.th-7332f0f8.bin', '7332f0f8c42f5b60cd4e2676f7b806cc942a4ab0'),
    'wiki.ti': ('wiki.ti-398f25bb.bin', '398f25bb3685800cc46aab59b084726c8cb6cd74'),
    'wiki.tk': ('wiki.tk-c281e62a.bin', 'c281e62aa025f18f4c0006939cf42446b12cd0f3'),
    'wiki.tl': ('wiki.tl-929953fd.bin', '929953fd9b07fbad5bc79cd62703b3fb1a59ba1a'),
    'wiki.tn': ('wiki.tn-ea8fac80.bin', 'ea8fac801735804eb98971cf823c89af496be814'),
    'wiki.to': ('wiki.to-bcc965ca.bin', 'bcc965cace5fe8c359b97a9389188ea04077c1bf'),
    'wiki.tpi': ('wiki.tpi-efd371af.bin', 'efd371af61d7ce4d1b7922e33790b72bc8f3c4d5'),
    'wiki.tr': ('wiki.tr-9c2c0a70.bin', '9c2c0a7008cd89cbe211a909431f7896a630f686'),
    'wiki.ts': ('wiki.ts-8958dcb3.bin', '8958dcb31274f4fa1ac96cff7de2ad12b0594ff2'),
    'wiki.tt': ('wiki.tt-4835092f.bin', '4835092f1ee35ece995f73712c11b128d7e6d8e3'),
    'wiki.tum': ('wiki.tum-20684599.bin', '206845992b8ec51f673408f11c6383a7ddc75faf'),
    'wiki.tw': ('wiki.tw-6fcf965e.bin', '6fcf965e4f74a6bccac892ebebb7e305e4d747c3'),
    'wiki.ty': ('wiki.ty-cf5c1022.bin', 'cf5c10220157851050babc0086af7e0812be9fb4'),
    'wiki.tyv': ('wiki.tyv-dd1284c9.bin', 'dd1284c9f847ebcc171616e0e60b5d97bdfa1808'),
    'wiki.udm': ('wiki.udm-85b368ec.bin', '85b368ec3981bd3fb0599f6dc8287ff8c9dac2aa'),
    'wiki.ug': ('wiki.ug-57acb78f.bin', '57acb78f7370a0766145cd9ca6fc11e0543f1385'),
    'wiki.uk': ('wiki.uk-747aa3ab.bin', '747aa3ab24fd860f6304fc021ef281facc4c039d'),
    'wiki.ur': ('wiki.ur-b89e16db.bin', 'b89e16dbc9ec62f9f91bce2a44447f7cdc830453'),
    'wiki.uz': ('wiki.uz-e8a38b09.bin', 'e8a38b091ff4ecdb8ded1a20bb182ba3ef73c6aa'),
    'wiki.ve': ('wiki.ve-5c1b48c3.bin', '5c1b48c309cb43717bcaeecb33e26cdcfd46cdec'),
    'wiki.vec': ('wiki.vec-34e6f3d9.bin', '34e6f3d94843381be488b37eb06600aff3ab3d6b'),
    'wiki.vep': ('wiki.vep-660b5d1e.bin', '660b5d1e7f74f97fe18f310736bf8950d4696c67'),
    'wiki.vi': ('wiki.vi-99ab162f.bin', '99ab162f703a0a6fb03a64142b6d47013e0314a3'),
    'wiki.vls': ('wiki.vls-07e0742e.bin', '07e0742e4946f2ae057be2ce84e327053a916c91'),
    'wiki.vo': ('wiki.vo-562905a3.bin', '562905a3c920bdf4b9bf4a9fb1b3a1293883a905'),
    'wiki.wa': ('wiki.wa-727a61c7.bin', '727a61c7115e7093ce8e2c1dc1f3e164eb2654cc'),
    'wiki.war': ('wiki.war-bcad746f.bin', 'bcad746f062fa166ceebc47df3449f4752448be5'),
    'wiki.wo': ('wiki.wo-5a3815d8.bin', '5a3815d82f535f6d35cd7058cc757117f2a41ac2'),
    'wiki.wuu': ('wiki.wuu-b114fb8d.bin', 'b114fb8d1ca2ba54ec3e4295f93ae6f33b7eed16'),
    'wiki.xal': ('wiki.xal-45449f93.bin', '45449f936d0ea7a57e7b287702fd09a715180efb'),
    'wiki.xh': ('wiki.xh-7b5a743d.bin', '7b5a743dca7f9ed9d0a8760169e681ccc5d00e54'),
    'wiki.xmf': ('wiki.xmf-755644bf.bin', '755644bfb0223e56e4d3ef7ae113f057b9143a18'),
    'wiki.yi': ('wiki.yi-191d3a6a.bin', '191d3a6a6676566f21ddf2b9a645e7dadd719600'),
    'wiki.yo': ('wiki.yo-2629d292.bin', '2629d292d16a7a6f80a12c1ca446b7ba4be56508'),
    'wiki.za': ('wiki.za-0f26bdfb.bin', '0f26bdfb74dacc74b3690d8b00c9ce92e2598152'),
    'wiki.zea': ('wiki.zea-f40226d3.bin', 'f40226d3c27c013b0690a3dba70b36cec1233aa6'),
    'wiki.zh': ('wiki.zh-69e1fa5f.bin', '69e1fa5f3a7a1625789e5eeb47d3bfe72506f403'),
    'wiki.zh_classical': ('wiki.zh_classical-ac01671b.bin',
                          'ac01671b3fd0baadbc5fd850132ef4c9891b7e55'),
    'wiki.zh_min_nan': ('wiki.zh_min_nan-5b773206.bin', '5b773206277e3c47fdfb110e43797bad644c1feb'),
    'wiki.zh_yue': ('wiki.zh_yue-2e504f07.bin', '2e504f07395f4ac5f732d8c3ee3594b431c2eb64'),
    'wiki.zu': ('wiki.zu-642b157b.bin', '642b157b3b799cfb50b13eda0b7d156698cdde83'),
}

