# Bungee editing guide

This document describes Bungee's development process source structure, in case it is helpful to those attempting to expand or  edit the fonts.

## Sources

### Drawing Sources

Bungee’s sources are in UFO 2 format that were authored and generated using Frederik Berlaen's <a href="http://www.robofont.com">RoboFont</a> app.

* /sources/1-drawing/Bungee-Regular.ufo

This is the primary drawing source for all styles of Bungee. 

The sources for the Inline, Shade, and Outline versions of each glyph are stored in RoboFont layers in the same UFO (*com.typemytype.robofont.layerData*).

No layer besides the foreground layer will contain components.

In many glyphs, the *inlineContour* layer contains the original single contour I used to generate the *inline*, to which I added a 10-unit outline using the <a href="http://doc.robofont.com/extensions/download-extensions/outliner/">Outliner RoboFont extension</a>.

The *metrics* layer contains rectangles that show the metrics of the vertical alternates, as expressed in the {vpal} feature. Each rectangle is 1000 units wide, and with variable height.

* /sources/1-drawing/Bungee_Rotated-Regular.ufo

This is the source that I used to design the proper sidebearings and kerning of the vertical forms. It is derived from Bungee-Regular.ufo, but has enough unique information that it’s worth storing separately. 

It contains the vertical forms in the default slots, and the extent of the character set is limited. Each glyph is rotated 90° clockwise, which is handled by */scripts/dev/bungeeRotate.py*.

* features.fea

This contains the full feature set, and is included in fonts where the horizontal forms are the default.

The contents of the {vpal} feature are generated by *getVerticalMetrics_vpal.py*, and are derived from the contents of the *metrics* layer.

The contents of {vkrn} are derived from *getVerticalMetrics_vkrn.py*, which changes all the glyph names, and then using Metrics Machine’s *Export Kerning* feature for */1-drawing/Bungee_Rotated-Regular.ufo*. I’m sure there is a smarter way to do this.

{vert} and {ss01} contain blocks that force all non-vertical glyphs on an 1000-unit width, as generated by  *getVerticalMetrics_normalizeVerticalWidths.py*. This may or may not actually be necessary.

* features_vertical.fea

This feature file omits vertical features and vertical alternates. It can be included in fonts where the vertical forms are already the default.

### Build Sources 

* 2-build/Bungee_Basic

These build sources are derived from the drawing sources using */scripts/dev/breakOutLayers.py*.

Because these fonts contain interactions between multiple layers, it was necessary to go through each glyph and make manual adjustments, especially where components resulted in the overlapping of contours.

Bungee-Shade.ufo is tracked 150 units to prevent collisions between the shade and the preceding letterform.

* 2-build/Bungee_Layers/, Bungee_Layers_Rotated/

These build sources are also derived from the drawing sources using */scripts/dev/breakOutLayers.py*. Few adjustments are needed.

* 2-build/Bungee_Color/

This source is derived from the drawing source using */scripts/dev/breakOutLayerIntoAlternates.py*. 

Each layer becomes an alternate glyph in the same UFO, with suffices .alt000 (shade), .alt001 (regular), and .alt002 (inline).

With this source, <a href="https://github.com/fontfont/RoboChrome">RoboChrome</a>’s "auto layers" function will build color information, that can be exported to SVG, COLR/CPAL and sbix formats.


## Generate

* 1. Copy the UFOs and the features.fea file into the */sources/2-build/temp/* folder.

* 2. Run */scripts/dev/generatePrep.py*, which will act on all UFOs the */sources/2-build/temp* folder. This script removes overlap issues with components and splits off double-encoded glyphs.

* Use RoboFont’s <a href="https://github.com/typemytype/batchRoboFontExtension">Batch</a> extension to generate the font files, and then to generate the web fonts from those files. 


##  Minor Changes

For making minor changes to Bungee, you may find it easier to edit the generated fonts directly rather than generating from the source. TTX (part of FontTools) will convert a generated OTF or TTF file to readable and editable XML.

    ttx /path/to/Bungee-Regular.ttf

When you are done tinkering, you can use the same command to convert the .ttx file back to a font.

    ttx /path/to/Bungee-Regular.ttx
	
* Previous: [Color fonts](6-color-fonts.md)
