# Making your tiny OS

> Let's start!

## what  should know before

* `C`语言和`x86`汇编

  当然，只需要简单的汇编基础就可以，至于`C`语言，也不需要很多知识，了解源文件到可执行文件的流程。

* `linux`基本命令

  在简单的内核编译中，我们用到了`linux`下的一些工具，比如`nasm`，当然这些`windows`下也有，包括`gcc`。但编译过程是在`linux`虚拟机中完成的。

## Tools

我们会用到什么工具呢?

* 文本编辑器，如`Notepad++`，`sublime`等等，最简单的记事本也可以。
* 二进制查看器，当然，这个也不是很关键，一来`sublime`工具本身就能已`16`进制形式显示，同时虚拟机也有帮助我们解析的工具。
* `linux`虚拟机，这里我们用到的是`Ubuntu i386`。需要安装工具`nasm`、`vim`、`gcc`、`readelf`等。

当然，你不必担心，用到这些工具或者资料的时候，文中都会有超链接，你可以去下载查阅。同时互联网上也有大量的资料供你翻阅。

## Result

最后我们做的结果是？

最后当然不是一个非常完整的操作系统，这更像是一次研究探索和对`OS`的了解，以及对`C`语言和汇编的关系的认识，最后是对硬件和软件如何打交道的一种认识。

`7`个部分，我们仅仅完成了加电开机自启，加载主引导扇区，然后加载更多的信息到内存，最后简单实现了从实模式进入保护模式，仅此而已，但操作系统的雏形大致也是如此。

## Reference

在整个过程中，我们参考了一些视频和电子课本

`[1]` 《`30`天自制操作系统》

`[2]` 《`Oranges`一个操作系统的实现》

`[3]` `51CTO`

等等。

其中主要参考的是电子书`[2]`。`[1]`中的内容更加全面，最后完成的效果也更加完善。

## Last

源文件和笔记一并上传至[`GitHub`](https://github.com/djh-sudo/tiny-OS-kernel/)，如果您有任何问题，也可以通过`djh113@126.com`联系我。每个文件夹是独立的结构，编译的二进制文件并未上传，但源码和工具都已上传。
