<?php
/*
diskover-web community edition (ce)
https://github.com/diskoverdata/diskover-community/
https://diskoverdata.com

Copyright 2017-2023 Diskover Data, Inc.
"Community" portion of Diskover made available under the Apache 2.0 License found here:
https://www.diskoverdata.com/apache-license/
 
All other content is subject to the Diskover Data, Inc. end user license agreement found at:
https://www.diskoverdata.com/eula-subscriptions/
  
Diskover Data products and features for all versions found here:
https://www.diskoverdata.com/solutions/

*/

require '../vendor/autoload.php';
require "d3_inc.php";

// check if path in session cache
if ($_SESSION["diskover_cache_filetree_search"][$esIndex][$path] && $_GET['usecache'] == 1) {
    $data = $_SESSION["diskover_cache_filetree_search"][$esIndex][$path];
} else {
    // get mtime in ES format
    $time = gettime($time);

    // get dir total size and file count
    $dirinfo = get_dir_info($client, $esIndex, $path);

    // how should the file tree be sorted (alphanumeric or size)
    if (isset($_COOKIE['searchfiletreesort'])) {
        $sortdirs = (int)$_COOKIE['searchfiletreesort'];
    } else {
        $sortdirs = 0;
    }

    $data = [
        "name" => $path,
        "size" => $dirinfo[0],
        "count" => $dirinfo[1],
        "count_files" => $dirinfo[2],
        "count_subdirs" => $dirinfo[3],
        "modified" => $dirinfo[4],
        "type" => 'directory',
        "children" => walk_tree($client, $esIndex, $path, $filter, $time, $depth = 0, $maxdepth = 1, 
            $use_count, $show_files, $sortdirs, $maxdirs = 5000)
    ];

    // cache path data in session
    $_SESSION["diskover_cache_filetree_search"][$esIndex][$path] = $data;
}

echo json_encode($data);
