# Diskover Community Edition - Open source file indexer, file search engine and data management and analytics powered by Elasticsearch

[![GitHub issues](https://img.shields.io/github/issues/diskoverdata/diskover-community)](https://github.com/diskoverdata/diskover-community/issues)
[![GitHub forks](https://img.shields.io/github/forks/diskoverdata/diskover-community)](https://github.com/diskoverdata/diskover-community/network)
[![GitHub stars](https://img.shields.io/github/stars/diskoverdata/diskover-community)](https://github.com/diskoverdata/diskover-community/stargazers)
[![GitHub license](https://img.shields.io/github/license/diskoverdata/diskover-community)](https://github.com/diskoverdata/diskover-community/blob/master/LICENSE)
[![GitHub releases](https://img.shields.io/github/release/diskoverdata/diskover-community)](https://github.com/diskoverdata/diskover-community/releases)

<img width="156" height="104" src="https://diskoverdata.com/wp-content/uploads/2024/08/diskover_logo_color_trimmed.png" hspace="5" vspace="5" alt="diskover logo">

diskover is an open source file system indexer that uses Elasticsearch to index and manage data across heterogeneous storage systems. Using diskover, you are able to more effectively search and organize files and system administrators are able to manage storage infrastructure, efficiently provision storage, monitor and report on storage use, and effectively make decisions about new infrastructure purchases.

As the amount of file data generated by businesses continues to expand, the stress on expensive storage infrastructure, users and system administrators, and IT budgets continues to grow.

Using diskover, users can identify old and unused files and give better insights into data change, file duplication and wasted space. diskover supports crawling local file-systems, crawling NFS/SMB, cloud storage, etc. Plugins can be used for adding additional meta data.

diskover runs on Linux, macOS and Windows and is written in Python. Diskover's web app, diskover-web, is written in PHP, Javascript, HTML5 and CSS.

## Screenshots
<p>
<img width="366" height="234" src="http://www.diskoverdata.com/wp-content/uploads/2021/10/diskover_v2_ce_screenshot1.png" hspace="10" vspace="5" alt="diskover-web screenshot 1">
<img width="366" height="234" src="http://www.diskoverdata.com/wp-content/uploads/2021/10/diskover_v2_ce_screenshot2.png" hspace="10" vspace="5" alt="diskover-web screenshot 2">
</p>

## Requirements
- Python 3.5+
- PHP 7.4 + PHP-FPM
- Nginx
- Elasticsearch 7.x

## Download
```sh
git clone https://github.com/diskoverdata/diskover-community.git
```
- See [releases](https://github.com/diskoverdata/diskover-community/releases) to download latest stable version in zip or tar.gz. 
- diskover ce v2 linuxserver.io docker container. Download on [docker hub](https://hub.docker.com/r/linuxserver/diskover) or [lsio github](https://github.com/linuxserver/docker-diskover).
- diskover ce v2 on [AWS Marketplace](https://aws.amazon.com/marketplace/pp/prodview-ahatamjklfgk4?sr=0-1&ref_=beagle&applicationId=AWSMPContessa)

## News/ Updates
- v1 is end of life and is no longer supported.

## Install/User Guide

[Read the docs](https://docs.diskoverdata.com/) for more documentation on how to install and use diskover.

## Changelogs

[Changelogs](https://docs.diskoverdata.com/diskover_changelogs/)

## Discussions/Support

For discussions or support for diskover join the [diskover Slack workspace](https://join.slack.com/t/diskoverworkspace/shared_invite/enQtNzQ0NjE1Njk5MjIyLWI4NWQ0MjFhYzQyMTRhMzk4NTQ3YjBlYjJiMDk1YWUzMTZmZjI1MTdhYTA3NzAzNTU0MDc5NDA2ZDI4OWRiMjM).

## Bugs

For bugs about diskover, please use the [issues page](https://github.com/diskoverdata/diskover-community/issues).

## Security

See the [security file](https://github.com/diskoverdata/diskover-community/blob/master/SECURITY.md).

## License

See the [license file](https://github.com/diskoverdata/diskover-community/blob/master/LICENSE).
