unit UMLModels;

{******************************************************************************}
{                                                                              }
{                StarUML - The Open Source UML/MDA Platform.                   }
{                                                                              }
{              Copyright (C) 2002-2005 - Plastic Software, Inc.                }
{                                                                              }
{                                                                              }
{ This program is free software; you can redistribute it and/or modify it      }
{ under the terms of the GNU General Public License as published by the Free   }
{ Software Foundation; either version 2 of the License, or (at your option)    }
{ any later version.                                                           }
{                                                                              }
{ This program is distributed in the hope that it will be useful, but WITHOUT  }
{ ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or        }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for     }
{ more details.                                                                }
{                                                                              }
{ You should have received a copy of the GNU General Public License along with }
{ this program; if not, write to the Free Software Foundation, Inc., 51        }
{ Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                          }
{                                                                              }
{ Linking StarUML statically or dynamically with other modules is making a     }
{ combined work based on StarUML. Thus, the terms and conditions of the GNU    }
{ General Public License cover the whole combination.                          }
{                                                                              }
{ In addition, as a special exception, Plastic Software give you permission to }
{ combine StarUML program with free software programs or libraries that are    }
{ released under the GNU LGPL/Mozilla/Apache/BSD and with code included in the }
{ standard release of ExpressBar, ExpressNavBar, ExpressInspector,             }
{ ExpressPageControl, ProGrammar, NextGrid under the commercial license (or    }
{ modified versions of such code, with unchanged license). You may copy and    }
{ distribute such a system following the terms of the GNU GPL for StarUML and  }
{ the licenses of the other code concerned, provided that you include the      }
{ source code of that other code when and as the GNU GPL requires distribution }
{ of source code. Plastic Software also give you permission to combine StarUML }
{ program with dynamically linking plug-in (or add-in) programs that are       }
{ released under the GPL-incompatible and proprietary license.                 }
{                                                                              }
{ Note that people who make modified versions of StarUML are not obligated to  }
{ grant this special exception for their modified versions; it is their choice }
{ whether to do so. The GNU General Public License gives permission to release }
{ a modified version without this exception; this exception also makes it      }
{ possible to release a modified version which carries forward this exception. }
{******************************************************************************}

interface

{$HINTS OFF}

uses
  BasicClasses, Core, ExtCore,
  SysUtils;

type
  // Forward Declaration
  PUMLElement = class;
  PUMLModelElement = class;
  PUMLLinkEnd = class;
  PUMLLinkObject = class;
  PUMLPartition = class;
  PUMLInteractionFragment = class;
  PUMLInteractionOperand = class;
  PUMLCombinedFragment = class;
  PUMLInteractionInstanceSet = class;
  PUMLInstance = class;
  PUMLDataValue = class;
  PUMLNodeInstance = class;
  PUMLObject = class;
  PUMLSubsystemInstance = class;
  PUMLUseCaseInstance = class;
  PUMLComponentInstance = class;
  PUMLArgument = class;
  PUMLConnectorEnd = class;
  PUMLStateVertex = class;
  PUMLSynchState = class;
  PUMLPseudostate = class;
  PUMLStubState = class;
  PUMLState = class;
  PUMLSimpleState = class;
  PUMLObjectFlowState = class;
  PUMLActionState = class;
  PUMLSignalAcceptState = class;
  PUMLCallState = class;
  PUMLSignalSendState = class;
  PUMLCompositeState = class;
  PUMLSubmachineState = class;
  PUMLSubactivityState = class;
  PUMLFinalState = class;
  PUMLFlowFinalState = class;
  PUMLInteraction = class;
  PUMLMessage = class;
  PUMLAssociationClass = class;
  PUMLStateMachine = class;
  PUMLActivityGraph = class;
  PUMLFeature = class;
  PUMLBehavioralFeature = class;
  PUMLMethod = class;
  PUMLOperation = class;
  PUMLReception = class;
  PUMLConnector = class;
  PUMLStructuralFeature = class;
  PUMLAttribute = class;
  PUMLPort = class;
  PUMLGeneralizableElement = class;
  PUMLNamespace = class;
  PUMLCollaboration = class;
  PUMLClassifier = class;
  PUMLUseCase = class;
  PUMLActor = class;
  PUMLClassifierInState = class;
  PUMLInterface = class;
  PUMLPackage = class;
  PUMLSubsystem = class;
  PUMLProject = class;
  PUMLModel = class;
  PUMLDataType = class;
  PUMLProgrammingLanguageDataType = class;
  PUMLPrimitive = class;
  PUMLEnumeration = class;
  PUMLClass = class;
  PUMLNode = class;
  PUMLArtifact = class;
  PUMLComponent = class;
  PUMLSignal = class;
  PUMLException = class;
  PUMLClassifierRole = class;
  PUMLEvent = class;
  PUMLChangeEvent = class;
  PUMLSignalEvent = class;
  PUMLTimeEvent = class;
  PUMLCallEvent = class;
  PUMLEnumerationLiteral = class;
  PUMLStimulus = class;
  PUMLAttributeLink = class;
  PUMLRelationship = class;
  PUMLGeneralization = class;
  PUMLInclude = class;
  PUMLDependency = class;
  PUMLRealization = class;
  PUMLExtend = class;
  PUMLAssociation = class;
  PUMLAssociationRole = class;
  PUMLAction = class;
  PUMLTerminateAction = class;
  PUMLSendAction = class;
  PUMLActionSequence = class;
  PUMLCreateAction = class;
  PUMLDestroyAction = class;
  PUMLUninterpretedAction = class;
  PUMLCallAction = class;
  PUMLReturnAction = class;
  PUMLFrame = class;
  PUMLCollaborationInstanceSet = class;
  PUMLParameter = class;
  PUMLAssociationEnd = class;
  PUMLAssociationEndRole = class;
  PUMLTransition = class;
  PUMLExtensionPoint = class;
  PUMLLink = class;
  PUMLComment = class;
  PUMLTemplateParameter = class;
  PUMLTemplateArgument = class;
  PUMLElementImport = class;
  PUMLDiagram = class;
  PUMLDeploymentDiagram = class;
  PUMLComponentDiagram = class;
  PUMLSequenceDiagram = class;
  PUMLCollaborationDiagram = class;
  PUMLSequenceRoleDiagram = class;
  PUMLUseCaseDiagram = class;
  PUMLClassDiagram = class;
  PUMLActivityDiagram = class;
  PUMLCollaborationRoleDiagram = class;
  PUMLCompositeStructureDiagram = class;
  PUMLStatechartDiagram = class;

  // Enumeration Types
  PUMLAggregationKind = (akNone, akAggregate, akComposite);
  PUMLCallConcurrencyKind = (cckSequential, cckGuarded, cckConcurrent);
  PUMLChangeableKind = (ckChangeable, ckFrozen, ckAddOnly);
  PUMLOrderingKind = (okUnordered, okOrdered);
  PUMLParameterDirectionKind = (pdkIn, pdkInout, pdkOut, pdkReturn);
  PUMLScopeKind = (skInstance, skClassifier);
  PUMLVisibilityKind = (vkPublic, vkProtected, vkPrivate, vkPackage);
  PUMLPseudostateKind = (pkChoice, pkDeepHistory, pkSynchronization, pkInitial, pkJunction, pkShallowHistory, pkDecision);
  PUMLInteractionOperatorKind = (iokSeq, iokAlt, iokOpt, iokBreak, iokPar, iokStrict, iokLoop, iokRegion, iokNeg, iokAssert, iokIgnore, iokConsider);
  PUMLMessageSignatureKind = (mskNone, mskTypeOnly, mskNameOnly, mskNameAndType);

  // Parametrized collections of UML types
  PUMLInstanceOrderedSet = POrderedSet<PUMLInstance>;

  // Class Definitions
  // PUMLElement
  PUMLElement = class(PExtensibleModel)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLModelElement
  PUMLModelElement = class(PUMLElement)
  private
    FVisibility: PUMLVisibilityKind;
    FIsSpecification: Boolean;
    FElementImports: POrderedSet;
    FNamespace: PUMLNamespace;
    FClientDependencies: POrderedSet;
    FSupplierDependencies: POrderedSet;
    FDefaultParameters: POrderedSet;
    FComments: POrderedSet;
    FContainer: PUMLComponent;
    FTemplateParameters: POrderedSet;
    FParameterOwner: PUMLTemplateParameter;
    FTemplateArguments: POrderedSet;
    FBehaviors: POrderedSet;
    FContentRoles: POrderedSet;
    FFrames: POrderedSet;
    FOwnerPartitions: POrderedSet;
    procedure SetVisibility(Value: PUMLVisibilityKind);
    procedure SetIsSpecification(Value: Boolean);
    function GetElementImport(Index: Integer): PUMLElementImport;
    function GetElementImportCount: Integer;
    procedure SetNamespace(Value: PUMLNamespace);
    function GetClientDependency(Index: Integer): PUMLDependency;
    function GetClientDependencyCount: Integer;
    function GetSupplierDependency(Index: Integer): PUMLDependency;
    function GetSupplierDependencyCount: Integer;
    function GetDefaultParameter(Index: Integer): PUMLTemplateParameter;
    function GetDefaultParameterCount: Integer;
    function GetComment(Index: Integer): PUMLComment;
    function GetCommentCount: Integer;
    procedure SetContainer(Value: PUMLComponent);
    function GetTemplateParameter(Index: Integer): PUMLTemplateParameter;
    function GetTemplateParameterCount: Integer;
    procedure SetParameterOwner(Value: PUMLTemplateParameter);
    function GetTemplateArgument(Index: Integer): PUMLTemplateArgument;
    function GetTemplateArgumentCount: Integer;
    function GetBehavior(Index: Integer): PUMLStateMachine;
    function GetBehaviorCount: Integer;
    function GetContentRole(Index: Integer): PUMLClassifierRole;
    function GetContentRoleCount: Integer;
    function GetFrame(Index: Integer): PUMLFrame;
    function GetFrameCount: Integer;
    function GetOwnerPartition(Index: Integer): PUMLPartition;
    function GetOwnerPartitionCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearElementImports;
    procedure AddElementImport(Value: PUMLElementImport);
    procedure RemoveElementImport(Value: PUMLElementImport);
    procedure InsertElementImport(Index: Integer; Value: PUMLElementImport);
    procedure DeleteElementImport(Index: Integer);
    function IndexOfElementImport(Value: PUMLElementImport): Integer;
    procedure ClearClientDependencies;
    procedure AddClientDependency(Value: PUMLDependency);
    procedure RemoveClientDependency(Value: PUMLDependency);
    procedure InsertClientDependency(Index: Integer; Value: PUMLDependency);
    procedure DeleteClientDependency(Index: Integer);
    function IndexOfClientDependency(Value: PUMLDependency): Integer;
    procedure ClearSupplierDependencies;
    procedure AddSupplierDependency(Value: PUMLDependency);
    procedure RemoveSupplierDependency(Value: PUMLDependency);
    procedure InsertSupplierDependency(Index: Integer; Value: PUMLDependency);
    procedure DeleteSupplierDependency(Index: Integer);
    function IndexOfSupplierDependency(Value: PUMLDependency): Integer;
    procedure ClearDefaultParameters;
    procedure AddDefaultParameter(Value: PUMLTemplateParameter);
    procedure RemoveDefaultParameter(Value: PUMLTemplateParameter);
    procedure InsertDefaultParameter(Index: Integer; Value: PUMLTemplateParameter);
    procedure DeleteDefaultParameter(Index: Integer);
    function IndexOfDefaultParameter(Value: PUMLTemplateParameter): Integer;
    procedure ClearComments;
    procedure AddComment(Value: PUMLComment);
    procedure RemoveComment(Value: PUMLComment);
    procedure InsertComment(Index: Integer; Value: PUMLComment);
    procedure DeleteComment(Index: Integer);
    function IndexOfComment(Value: PUMLComment): Integer;
    procedure ClearTemplateParameters;
    procedure AddTemplateParameter(Value: PUMLTemplateParameter);
    procedure RemoveTemplateParameter(Value: PUMLTemplateParameter);
    procedure InsertTemplateParameter(Index: Integer; Value: PUMLTemplateParameter);
    procedure DeleteTemplateParameter(Index: Integer);
    function IndexOfTemplateParameter(Value: PUMLTemplateParameter): Integer;
    procedure ClearTemplateArguments;
    procedure AddTemplateArgument(Value: PUMLTemplateArgument);
    procedure RemoveTemplateArgument(Value: PUMLTemplateArgument);
    procedure InsertTemplateArgument(Index: Integer; Value: PUMLTemplateArgument);
    procedure DeleteTemplateArgument(Index: Integer);
    function IndexOfTemplateArgument(Value: PUMLTemplateArgument): Integer;
    procedure ClearBehaviors;
    procedure AddBehavior(Value: PUMLStateMachine);
    procedure RemoveBehavior(Value: PUMLStateMachine);
    procedure InsertBehavior(Index: Integer; Value: PUMLStateMachine);
    procedure DeleteBehavior(Index: Integer);
    function IndexOfBehavior(Value: PUMLStateMachine): Integer;
    procedure ClearContentRoles;
    procedure AddContentRole(Value: PUMLClassifierRole);
    procedure RemoveContentRole(Value: PUMLClassifierRole);
    procedure InsertContentRole(Index: Integer; Value: PUMLClassifierRole);
    procedure DeleteContentRole(Index: Integer);
    function IndexOfContentRole(Value: PUMLClassifierRole): Integer;
    procedure ClearFrames;
    procedure AddFrame(Value: PUMLFrame);
    procedure RemoveFrame(Value: PUMLFrame);
    procedure InsertFrame(Index: Integer; Value: PUMLFrame);
    procedure DeleteFrame(Index: Integer);
    function IndexOfFrame(Value: PUMLFrame): Integer;
    procedure ClearOwnerPartitions;
    procedure AddOwnerPartition(Value: PUMLPartition);
    procedure RemoveOwnerPartition(Value: PUMLPartition);
    procedure InsertOwnerPartition(Index: Integer; Value: PUMLPartition);
    procedure DeleteOwnerPartition(Index: Integer);
    function IndexOfOwnerPartition(Value: PUMLPartition): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Visibility: PUMLVisibilityKind read FVisibility write SetVisibility;
    property IsSpecification: Boolean read FIsSpecification write SetIsSpecification;
    property ElementImports[Index: Integer]: PUMLElementImport read GetElementImport;
    property ElementImportCount: Integer read GetElementImportCount;
    property Namespace: PUMLNamespace read FNamespace write SetNamespace;
    property ClientDependencies[Index: Integer]: PUMLDependency read GetClientDependency;
    property ClientDependencyCount: Integer read GetClientDependencyCount;
    property SupplierDependencies[Index: Integer]: PUMLDependency read GetSupplierDependency;
    property SupplierDependencyCount: Integer read GetSupplierDependencyCount;
    property DefaultParameters[Index: Integer]: PUMLTemplateParameter read GetDefaultParameter;
    property DefaultParameterCount: Integer read GetDefaultParameterCount;
    property Comments[Index: Integer]: PUMLComment read GetComment;
    property CommentCount: Integer read GetCommentCount;
    property Container: PUMLComponent read FContainer write SetContainer;
    property TemplateParameters[Index: Integer]: PUMLTemplateParameter read GetTemplateParameter;
    property TemplateParameterCount: Integer read GetTemplateParameterCount;
    property ParameterOwner: PUMLTemplateParameter read FParameterOwner write SetParameterOwner;
    property TemplateArguments[Index: Integer]: PUMLTemplateArgument read GetTemplateArgument;
    property TemplateArgumentCount: Integer read GetTemplateArgumentCount;
    property Behaviors[Index: Integer]: PUMLStateMachine read GetBehavior;
    property BehaviorCount: Integer read GetBehaviorCount;
    property ContentRoles[Index: Integer]: PUMLClassifierRole read GetContentRole;
    property ContentRoleCount: Integer read GetContentRoleCount;
    property Frames[Index: Integer]: PUMLFrame read GetFrame;
    property FrameCount: Integer read GetFrameCount;
    property OwnerPartitions[Index: Integer]: PUMLPartition read GetOwnerPartition;
    property OwnerPartitionCount: Integer read GetOwnerPartitionCount;
  end;

    // PUMLRelationship
  PUMLRelationship = class abstract (PUMLModelElement)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;

    function FindRelatedModel(FirstElement: PModel): PModel; virtual; abstract;

  end;


  // PUMLLinkEnd
  PUMLLinkEnd = class(PUMLModelElement)
  private
    FInstance: PUMLInstance;
    FLink: PUMLLink;
    FAssociationEnd: PUMLAssociationEnd;
    FQualifiedValues: POrderedSet;
    procedure SetInstance(Value: PUMLInstance);
    procedure SetLink(Value: PUMLLink);
    procedure SetAssociationEnd(Value: PUMLAssociationEnd);
    function GetQualifiedValue(Index: Integer): PUMLAttributeLink;
    function GetQualifiedValueCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearQualifiedValues;
    procedure AddQualifiedValue(Value: PUMLAttributeLink);
    procedure RemoveQualifiedValue(Value: PUMLAttributeLink);
    procedure InsertQualifiedValue(Index: Integer; Value: PUMLAttributeLink);
    procedure DeleteQualifiedValue(Index: Integer);
    function IndexOfQualifiedValue(Value: PUMLAttributeLink): Integer;
    function CanCopy: Boolean; override;
    function CanDelete: Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Instance: PUMLInstance read FInstance write SetInstance;
    property Link: PUMLLink read FLink write SetLink;
    property AssociationEnd: PUMLAssociationEnd read FAssociationEnd write SetAssociationEnd;
    property QualifiedValues[Index: Integer]: PUMLAttributeLink read GetQualifiedValue;
    property QualifiedValueCount: Integer read GetQualifiedValueCount;
  end;

  // PUMLLinkObject
  PUMLLinkObject = class(PUMLModelElement)
  private
    FLinkSide: PUMLLink;
    FObjectSide: PUMLObject;
    procedure SetLinkSide(Value: PUMLLink);
    procedure SetObjectSide(Value: PUMLObject);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property LinkSide: PUMLLink read FLinkSide write SetLinkSide;
    property ObjectSide: PUMLObject read FObjectSide write SetObjectSide;
  end;

  // PUMLPartition
  PUMLPartition = class(PUMLModelElement)
  private
    FContents: POrderedSet;
    FActivityGraph: PUMLActivityGraph;
    function GetContent(Index: Integer): PUMLModelElement;
    function GetContentCount: Integer;
    procedure SetActivityGraph(Value: PUMLActivityGraph);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearContents;
    procedure AddContent(Value: PUMLModelElement);
    procedure RemoveContent(Value: PUMLModelElement);
    procedure InsertContent(Index: Integer; Value: PUMLModelElement);
    procedure DeleteContent(Index: Integer);
    function IndexOfContent(Value: PUMLModelElement): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Contents[Index: Integer]: PUMLModelElement read GetContent;
    property ContentCount: Integer read GetContentCount;
    property ActivityGraph: PUMLActivityGraph read FActivityGraph write SetActivityGraph;
  end;

  // PUMLInteractionFragment
  PUMLInteractionFragment = class(PUMLModelElement)
  private
    FEnclosingOperand: PUMLInteractionOperand;
    FEnclosingInteraction: PUMLInteraction;
    FEnclosingInteractionInstanceSet: PUMLInteractionInstanceSet;
    procedure SetEnclosingOperand(Value: PUMLInteractionOperand);
    procedure SetEnclosingInteraction(Value: PUMLInteraction);
    procedure SetEnclosingInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property EnclosingOperand: PUMLInteractionOperand read FEnclosingOperand write SetEnclosingOperand;
    property EnclosingInteraction: PUMLInteraction read FEnclosingInteraction write SetEnclosingInteraction;
    property EnclosingInteractionInstanceSet: PUMLInteractionInstanceSet read FEnclosingInteractionInstanceSet write SetEnclosingInteractionInstanceSet;
  end;

  // PUMLInteractionOperand
  PUMLInteractionOperand = class(PUMLInteractionFragment)
  private
    FGuard: string;
    FCombinedFragment: PUMLCombinedFragment;
    FFragments: POrderedSet;
    procedure SetGuard(Value: string);
    procedure SetCombinedFragment(Value: PUMLCombinedFragment);
    function GetFragment(Index: Integer): PUMLInteractionFragment;
    function GetFragmentCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearFragments;
    procedure AddFragment(Value: PUMLInteractionFragment);
    procedure RemoveFragment(Value: PUMLInteractionFragment);
    procedure InsertFragment(Index: Integer; Value: PUMLInteractionFragment);
    procedure DeleteFragment(Index: Integer);
    function IndexOfFragment(Value: PUMLInteractionFragment): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Guard: string read FGuard write SetGuard;
    property CombinedFragment: PUMLCombinedFragment read FCombinedFragment write SetCombinedFragment;
    property Fragments[Index: Integer]: PUMLInteractionFragment read GetFragment;
    property FragmentCount: Integer read GetFragmentCount;
  end;

  // PUMLCombinedFragment
  PUMLCombinedFragment = class(PUMLInteractionFragment)
  private
    FInteractionOperator: PUMLInteractionOperatorKind;
    FOperands: POrderedSet;
    procedure SetInteractionOperator(Value: PUMLInteractionOperatorKind);
    function GetOperand(Index: Integer): PUMLInteractionOperand;
    function GetOperandCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearOperands;
    procedure AddOperand(Value: PUMLInteractionOperand);
    procedure RemoveOperand(Value: PUMLInteractionOperand);
    procedure InsertOperand(Index: Integer; Value: PUMLInteractionOperand);
    procedure DeleteOperand(Index: Integer);
    function IndexOfOperand(Value: PUMLInteractionOperand): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property InteractionOperator: PUMLInteractionOperatorKind read FInteractionOperator write SetInteractionOperator;
    property Operands[Index: Integer]: PUMLInteractionOperand read GetOperand;
    property OperandCount: Integer read GetOperandCount;
  end;

  // PUMLInteractionInstanceSet
  PUMLInteractionInstanceSet = class(PUMLModelElement)
  private
    FContext: PUMLCollaborationInstanceSet;
    FInteraction: PUMLInteraction;
    FParticipatingStimuli: POrderedSet;
    FFragments: POrderedSet;
    FOwnedFrames: POrderedSet;
    procedure SetContext(Value: PUMLCollaborationInstanceSet);
    procedure SetInteraction(Value: PUMLInteraction);
    function GetParticipatingStimulus(Index: Integer): PUMLStimulus;
    function GetParticipatingStimulusCount: Integer;
    function GetFragment(Index: Integer): PUMLInteractionFragment;
    function GetFragmentCount: Integer;
    function GetOwnedFrame(Index: Integer): PUMLFrame;
    function GetOwnedFrameCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearParticipatingStimuli;
    procedure AddParticipatingStimulus(Value: PUMLStimulus);
    procedure RemoveParticipatingStimulus(Value: PUMLStimulus);
    procedure InsertParticipatingStimulus(Index: Integer; Value: PUMLStimulus);
    procedure DeleteParticipatingStimulus(Index: Integer);
    function IndexOfParticipatingStimulus(Value: PUMLStimulus): Integer;
    procedure ClearFragments;
    procedure AddFragment(Value: PUMLInteractionFragment);
    procedure RemoveFragment(Value: PUMLInteractionFragment);
    procedure InsertFragment(Index: Integer; Value: PUMLInteractionFragment);
    procedure DeleteFragment(Index: Integer);
    function IndexOfFragment(Value: PUMLInteractionFragment): Integer;
    procedure ClearOwnedFrames;
    procedure AddOwnedFrame(Value: PUMLFrame);
    procedure RemoveOwnedFrame(Value: PUMLFrame);
    procedure InsertOwnedFrame(Index: Integer; Value: PUMLFrame);
    procedure DeleteOwnedFrame(Index: Integer);
    function IndexOfOwnedFrame(Value: PUMLFrame): Integer;
    function CanContainDiagramKind(Kind: string): Boolean; override;
    function CanContainDiagram(Diagram: PDiagram): Boolean; override;
    function CanContainKind(Kind: string): Boolean; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function CanPaste(Kind: string; CopyContext: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Context: PUMLCollaborationInstanceSet read FContext write SetContext;
    property Interaction: PUMLInteraction read FInteraction write SetInteraction;
    property ParticipatingStimuli[Index: Integer]: PUMLStimulus read GetParticipatingStimulus;
    property ParticipatingStimulusCount: Integer read GetParticipatingStimulusCount;
    property Fragments[Index: Integer]: PUMLInteractionFragment read GetFragment;
    property FragmentCount: Integer read GetFragmentCount;
    property OwnedFrames[Index: Integer]: PUMLFrame read GetOwnedFrame;
    property OwnedFrameCount: Integer read GetOwnedFrameCount;
  end;

  // PUMLInstance
  PUMLInstance = class(PUMLModelElement)
  private
    FIsMultiInstance: Boolean;
    FClassifier: PUMLClassifier;
    FAttributeLinks: POrderedSet;
    FLinkEnds: POrderedSet;
    FSlots: POrderedSet;
    FSendingStimuli: POrderedSet;
    FComponentInstance: PUMLComponentInstance;
    FReceivingStimuli: POrderedSet;
    FOwner: PUMLInstance;
    FOwnedInstances: POrderedSet;
    FOwnedLinks: POrderedSet;
    FPlayedRoles: POrderedSet;
    FCollaborationInstanceSet: PUMLCollaborationInstanceSet;
    procedure SetIsMultiInstance(Value: Boolean);
    procedure SetClassifier(Value: PUMLClassifier);
    function GetAttributeLink(Index: Integer): PUMLAttributeLink;
    function GetAttributeLinkCount: Integer;
    function GetLinkEnd(Index: Integer): PUMLLinkEnd;
    function GetLinkEndCount: Integer;
    function GetSlot(Index: Integer): PUMLAttributeLink;
    function GetSlotCount: Integer;
    function GetSendingStimulus(Index: Integer): PUMLStimulus;
    function GetSendingStimulusCount: Integer;
    procedure SetComponentInstance(Value: PUMLComponentInstance);
    function GetReceivingStimulus(Index: Integer): PUMLStimulus;
    function GetReceivingStimulusCount: Integer;
    procedure SetOwner(Value: PUMLInstance);
    function GetOwnedInstance(Index: Integer): PUMLInstance;
    function GetOwnedInstanceCount: Integer;
    function GetOwnedLink(Index: Integer): PUMLLink;
    function GetOwnedLinkCount: Integer;
    function GetPlayedRole(Index: Integer): PUMLClassifierRole;
    function GetPlayedRoleCount: Integer;
    procedure SetCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearAttributeLinks;
    procedure AddAttributeLink(Value: PUMLAttributeLink);
    procedure RemoveAttributeLink(Value: PUMLAttributeLink);
    procedure InsertAttributeLink(Index: Integer; Value: PUMLAttributeLink);
    procedure DeleteAttributeLink(Index: Integer);
    function IndexOfAttributeLink(Value: PUMLAttributeLink): Integer;
    procedure ClearLinkEnds;
    procedure AddLinkEnd(Value: PUMLLinkEnd);
    procedure RemoveLinkEnd(Value: PUMLLinkEnd);
    procedure InsertLinkEnd(Index: Integer; Value: PUMLLinkEnd);
    procedure DeleteLinkEnd(Index: Integer);
    function IndexOfLinkEnd(Value: PUMLLinkEnd): Integer;
    procedure ClearSlots;
    procedure AddSlot(Value: PUMLAttributeLink);
    procedure RemoveSlot(Value: PUMLAttributeLink);
    procedure InsertSlot(Index: Integer; Value: PUMLAttributeLink);
    procedure DeleteSlot(Index: Integer);
    function IndexOfSlot(Value: PUMLAttributeLink): Integer;
    procedure ClearSendingStimuli;
    procedure AddSendingStimulus(Value: PUMLStimulus);
    procedure RemoveSendingStimulus(Value: PUMLStimulus);
    procedure InsertSendingStimulus(Index: Integer; Value: PUMLStimulus);
    procedure DeleteSendingStimulus(Index: Integer);
    function IndexOfSendingStimulus(Value: PUMLStimulus): Integer;
    procedure ClearReceivingStimuli;
    procedure AddReceivingStimulus(Value: PUMLStimulus);
    procedure RemoveReceivingStimulus(Value: PUMLStimulus);
    procedure InsertReceivingStimulus(Index: Integer; Value: PUMLStimulus);
    procedure DeleteReceivingStimulus(Index: Integer);
    function IndexOfReceivingStimulus(Value: PUMLStimulus): Integer;
    procedure ClearOwnedInstances;
    procedure AddOwnedInstance(Value: PUMLInstance);
    procedure RemoveOwnedInstance(Value: PUMLInstance);
    procedure InsertOwnedInstance(Index: Integer; Value: PUMLInstance);
    procedure DeleteOwnedInstance(Index: Integer);
    function IndexOfOwnedInstance(Value: PUMLInstance): Integer;
    procedure ClearOwnedLinks;
    procedure AddOwnedLink(Value: PUMLLink);
    procedure RemoveOwnedLink(Value: PUMLLink);
    procedure InsertOwnedLink(Index: Integer; Value: PUMLLink);
    procedure DeleteOwnedLink(Index: Integer);
    function IndexOfOwnedLink(Value: PUMLLink): Integer;
    procedure ClearPlayedRoles;
    procedure AddPlayedRole(Value: PUMLClassifierRole);
    procedure RemovePlayedRole(Value: PUMLClassifierRole);
    procedure InsertPlayedRole(Index: Integer; Value: PUMLClassifierRole);
    procedure DeletePlayedRole(Index: Integer);
    function IndexOfPlayedRole(Value: PUMLClassifierRole): Integer;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function HasAttachedLinks: Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property IsMultiInstance: Boolean read FIsMultiInstance write SetIsMultiInstance;
    property Classifier: PUMLClassifier read FClassifier write SetClassifier;
    property AttributeLinks[Index: Integer]: PUMLAttributeLink read GetAttributeLink;
    property AttributeLinkCount: Integer read GetAttributeLinkCount;
    property LinkEnds[Index: Integer]: PUMLLinkEnd read GetLinkEnd;
    property LinkEndCount: Integer read GetLinkEndCount;
    property Slots[Index: Integer]: PUMLAttributeLink read GetSlot;
    property SlotCount: Integer read GetSlotCount;
    property SendingStimuli[Index: Integer]: PUMLStimulus read GetSendingStimulus;
    property SendingStimulusCount: Integer read GetSendingStimulusCount;
    property ComponentInstance: PUMLComponentInstance read FComponentInstance write SetComponentInstance;
    property ReceivingStimuli[Index: Integer]: PUMLStimulus read GetReceivingStimulus;
    property ReceivingStimulusCount: Integer read GetReceivingStimulusCount;
    property Owner: PUMLInstance read FOwner write SetOwner;
    property OwnedInstances[Index: Integer]: PUMLInstance read GetOwnedInstance;
    property OwnedInstanceCount: Integer read GetOwnedInstanceCount;
    property OwnedLinks[Index: Integer]: PUMLLink read GetOwnedLink;
    property OwnedLinkCount: Integer read GetOwnedLinkCount;
    property PlayedRoles[Index: Integer]: PUMLClassifierRole read GetPlayedRole;
    property PlayedRoleCount: Integer read GetPlayedRoleCount;
    property CollaborationInstanceSet: PUMLCollaborationInstanceSet read FCollaborationInstanceSet write SetCollaborationInstanceSet;
  end;

  // PUMLDataValue
  PUMLDataValue = class(PUMLInstance)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLNodeInstance
  PUMLNodeInstance = class(PUMLInstance)
  private
    FResidents: POrderedSet;
    function GetResident(Index: Integer): PUMLComponentInstance;
    function GetResidentCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearResidents;
    procedure AddResident(Value: PUMLComponentInstance);
    procedure RemoveResident(Value: PUMLComponentInstance);
    procedure InsertResident(Index: Integer; Value: PUMLComponentInstance);
    procedure DeleteResident(Index: Integer);
    function IndexOfResident(Value: PUMLComponentInstance): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Residents[Index: Integer]: PUMLComponentInstance read GetResident;
    property ResidentCount: Integer read GetResidentCount;
  end;

  // PUMLObject
  PUMLObject = class(PUMLInstance)
  private
    FLinkObject: PUMLLinkObject;
    procedure SetLinkObject(Value: PUMLLinkObject);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property LinkObject: PUMLLinkObject read FLinkObject write SetLinkObject;
  end;

  // PUMLSubsystemInstance
  PUMLSubsystemInstance = class(PUMLInstance)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLUseCaseInstance
  PUMLUseCaseInstance = class(PUMLInstance)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLComponentInstance
  PUMLComponentInstance = class(PUMLInstance)
  private
    FNodeInstance: PUMLNodeInstance;
    FResidents: POrderedSet;
    procedure SetNodeInstance(Value: PUMLNodeInstance);
    function GetResident(Index: Integer): PUMLInstance;
    function GetResidentCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearResidents;
    procedure AddResident(Value: PUMLInstance);
    procedure RemoveResident(Value: PUMLInstance);
    procedure InsertResident(Index: Integer; Value: PUMLInstance);
    procedure DeleteResident(Index: Integer);
    function IndexOfResident(Value: PUMLInstance): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property NodeInstance: PUMLNodeInstance read FNodeInstance write SetNodeInstance;
    property Residents[Index: Integer]: PUMLInstance read GetResident;
    property ResidentCount: Integer read GetResidentCount;
  end;

  // PUMLArgument
  PUMLArgument = class(PUMLModelElement)
  private
    FValue: string;
    FAction: PUMLAction;
    procedure SetValue(Value: string);
    procedure SetAction(Value: PUMLAction);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Value: string read FValue write SetValue;
    property Action: PUMLAction read FAction write SetAction;
  end;

  // PUMLConnectorEnd
  PUMLConnectorEnd = class(PUMLModelElement)
  private
    FMultiplicity: string;
    FIsOrdered: Boolean;
    FIsUnique: Boolean;
    FConnector: PUMLConnector;
    FRole: PUMLFeature;
    procedure SetMultiplicity(Value: string);
    procedure SetIsOrdered(Value: Boolean);
    procedure SetIsUnique(Value: Boolean);
    procedure SetConnector(Value: PUMLConnector);
    procedure SetRole(Value: PUMLFeature);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Multiplicity: string read FMultiplicity write SetMultiplicity;
    property IsOrdered: Boolean read FIsOrdered write SetIsOrdered;
    property IsUnique: Boolean read FIsUnique write SetIsUnique;
    property Connector: PUMLConnector read FConnector write SetConnector;
    property Role: PUMLFeature read FRole write SetRole;
  end;

  // PUMLStateVertex
  PUMLStateVertex = class(PUMLModelElement)
  private
    FContainerState: PUMLCompositeState;
    FOutgoings: POrderedSet;
    FIncomings: POrderedSet;
    procedure SetContainerState(Value: PUMLCompositeState);
    function GetOutgoing(Index: Integer): PUMLTransition;
    function GetOutgoingCount: Integer;
    function GetIncoming(Index: Integer): PUMLTransition;
    function GetIncomingCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearOutgoings;
    procedure AddOutgoing(Value: PUMLTransition);
    procedure RemoveOutgoing(Value: PUMLTransition);
    procedure InsertOutgoing(Index: Integer; Value: PUMLTransition);
    procedure DeleteOutgoing(Index: Integer);
    function IndexOfOutgoing(Value: PUMLTransition): Integer;
    procedure ClearIncomings;
    procedure AddIncoming(Value: PUMLTransition);
    procedure RemoveIncoming(Value: PUMLTransition);
    procedure InsertIncoming(Index: Integer; Value: PUMLTransition);
    procedure DeleteIncoming(Index: Integer);
    function IndexOfIncoming(Value: PUMLTransition): Integer;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property ContainerState: PUMLCompositeState read FContainerState write SetContainerState;
    property Outgoings[Index: Integer]: PUMLTransition read GetOutgoing;
    property OutgoingCount: Integer read GetOutgoingCount;
    property Incomings[Index: Integer]: PUMLTransition read GetIncoming;
    property IncomingCount: Integer read GetIncomingCount;
  end;

  // PUMLSynchState
  PUMLSynchState = class(PUMLStateVertex)
  private
    FBound: Integer;
    procedure SetBound(Value: Integer);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Bound: Integer read FBound write SetBound;
  end;

  // PUMLPseudostate
  PUMLPseudostate = class(PUMLStateVertex)
  private
    FPseudostateKind: PUMLPseudostateKind;
    procedure SetPseudostateKind(Value: PUMLPseudostateKind);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property PseudostateKind: PUMLPseudostateKind read FPseudostateKind write SetPseudostateKind;
  end;

  // PUMLStubState
  PUMLStubState = class(PUMLStateVertex)
  private
    FReferenceState: string;
    procedure SetReferenceState(Value: string);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property ReferenceState: string read FReferenceState write SetReferenceState;
  end;

  // PUMLState
  PUMLState = class(PUMLStateVertex)
  private
    FEntryActions: POrderedSet;
    FExitActions: POrderedSet;
    FStateMachine: PUMLStateMachine;
    FDeferrableEvents: POrderedSet;
    FInternalTransitions: POrderedSet;
    FDoActivities: POrderedSet;
    FClassifierStates: POrderedSet;
    function GetEntryAction(Index: Integer): PUMLAction;
    function GetEntryActionCount: Integer;
    function GetExitAction(Index: Integer): PUMLAction;
    function GetExitActionCount: Integer;
    procedure SetStateMachine(Value: PUMLStateMachine);
    function GetDeferrableEvent(Index: Integer): PUMLEvent;
    function GetDeferrableEventCount: Integer;
    function GetInternalTransition(Index: Integer): PUMLTransition;
    function GetInternalTransitionCount: Integer;
    function GetDoActivity(Index: Integer): PUMLAction;
    function GetDoActivityCount: Integer;
    function GetClassifierState(Index: Integer): PUMLClassifierInState;
    function GetClassifierStateCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearEntryActions;
    procedure AddEntryAction(Value: PUMLAction);
    procedure RemoveEntryAction(Value: PUMLAction);
    procedure InsertEntryAction(Index: Integer; Value: PUMLAction);
    procedure DeleteEntryAction(Index: Integer);
    function IndexOfEntryAction(Value: PUMLAction): Integer;
    procedure ClearExitActions;
    procedure AddExitAction(Value: PUMLAction);
    procedure RemoveExitAction(Value: PUMLAction);
    procedure InsertExitAction(Index: Integer; Value: PUMLAction);
    procedure DeleteExitAction(Index: Integer);
    function IndexOfExitAction(Value: PUMLAction): Integer;
    procedure ClearDeferrableEvents;
    procedure AddDeferrableEvent(Value: PUMLEvent);
    procedure RemoveDeferrableEvent(Value: PUMLEvent);
    procedure InsertDeferrableEvent(Index: Integer; Value: PUMLEvent);
    procedure DeleteDeferrableEvent(Index: Integer);
    function IndexOfDeferrableEvent(Value: PUMLEvent): Integer;
    procedure ClearInternalTransitions;
    procedure AddInternalTransition(Value: PUMLTransition);
    procedure RemoveInternalTransition(Value: PUMLTransition);
    procedure InsertInternalTransition(Index: Integer; Value: PUMLTransition);
    procedure DeleteInternalTransition(Index: Integer);
    function IndexOfInternalTransition(Value: PUMLTransition): Integer;
    procedure ClearDoActivities;
    procedure AddDoActivity(Value: PUMLAction);
    procedure RemoveDoActivity(Value: PUMLAction);
    procedure InsertDoActivity(Index: Integer; Value: PUMLAction);
    procedure DeleteDoActivity(Index: Integer);
    function IndexOfDoActivity(Value: PUMLAction): Integer;
    procedure ClearClassifierStates;
    procedure AddClassifierState(Value: PUMLClassifierInState);
    procedure RemoveClassifierState(Value: PUMLClassifierInState);
    procedure InsertClassifierState(Index: Integer; Value: PUMLClassifierInState);
    procedure DeleteClassifierState(Index: Integer);
    function IndexOfClassifierState(Value: PUMLClassifierInState): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function CanDelete: Boolean; override;
    function CanPaste(Kind: string; CopyContext: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property EntryActions[Index: Integer]: PUMLAction read GetEntryAction;
    property EntryActionCount: Integer read GetEntryActionCount;
    property ExitActions[Index: Integer]: PUMLAction read GetExitAction;
    property ExitActionCount: Integer read GetExitActionCount;
    property StateMachine: PUMLStateMachine read FStateMachine write SetStateMachine;
    property DeferrableEvents[Index: Integer]: PUMLEvent read GetDeferrableEvent;
    property DeferrableEventCount: Integer read GetDeferrableEventCount;
    property InternalTransitions[Index: Integer]: PUMLTransition read GetInternalTransition;
    property InternalTransitionCount: Integer read GetInternalTransitionCount;
    property DoActivities[Index: Integer]: PUMLAction read GetDoActivity;
    property DoActivityCount: Integer read GetDoActivityCount;
    property ClassifierStates[Index: Integer]: PUMLClassifierInState read GetClassifierState;
    property ClassifierStateCount: Integer read GetClassifierStateCount;
  end;

  // PUMLSimpleState
  PUMLSimpleState = class(PUMLState)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLObjectFlowState
  PUMLObjectFlowState = class(PUMLSimpleState)
  private
    FIsSynch: Boolean;
    FParameters: POrderedSet;
    FType_: PUMLClassifier;
    procedure SetIsSynch(Value: Boolean);
    function GetParameter(Index: Integer): PUMLParameter;
    function GetParameterCount: Integer;
    procedure SetType_(Value: PUMLClassifier);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearParameters;
    procedure AddParameter(Value: PUMLParameter);
    procedure RemoveParameter(Value: PUMLParameter);
    procedure InsertParameter(Index: Integer; Value: PUMLParameter);
    procedure DeleteParameter(Index: Integer);
    function IndexOfParameter(Value: PUMLParameter): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property IsSynch: Boolean read FIsSynch write SetIsSynch;
    property Parameters[Index: Integer]: PUMLParameter read GetParameter;
    property ParameterCount: Integer read GetParameterCount;
    property Type_: PUMLClassifier read FType_ write SetType_;
  end;

  // PUMLActionState
  PUMLActionState = class(PUMLSimpleState)
  private
    FIsDynamic: Boolean;
    FDynamicArguments: string;
    FDynamicMultiplicity: string;
    procedure SetIsDynamic(Value: Boolean);
    procedure SetDynamicArguments(Value: string);
    procedure SetDynamicMultiplicity(Value: string);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property IsDynamic: Boolean read FIsDynamic write SetIsDynamic;
    property DynamicArguments: string read FDynamicArguments write SetDynamicArguments;
    property DynamicMultiplicity: string read FDynamicMultiplicity write SetDynamicMultiplicity;
  end;

  // PUMLSignalAcceptState
  PUMLSignalAcceptState = class(PUMLActionState)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLCallState
  PUMLCallState = class(PUMLActionState)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLSignalSendState
  PUMLSignalSendState = class(PUMLActionState)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLCompositeState
  PUMLCompositeState = class(PUMLState)
  private
    FIsConcurrent: Boolean;
    FSubvertices: POrderedSet;
    procedure SetIsConcurrent(Value: Boolean);
    function GetSubvertex(Index: Integer): PUMLStateVertex;
    function GetSubvertexCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearSubvertices;
    procedure AddSubvertex(Value: PUMLStateVertex);
    procedure RemoveSubvertex(Value: PUMLStateVertex);
    procedure InsertSubvertex(Index: Integer; Value: PUMLStateVertex);
    procedure DeleteSubvertex(Index: Integer);
    function IndexOfSubvertex(Value: PUMLStateVertex): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property IsConcurrent: Boolean read FIsConcurrent write SetIsConcurrent;
    property Subvertices[Index: Integer]: PUMLStateVertex read GetSubvertex;
    property SubvertexCount: Integer read GetSubvertexCount;
  end;

  // PUMLSubmachineState
  PUMLSubmachineState = class(PUMLCompositeState)
  private
    FSubmachine: PUMLStateMachine;
    procedure SetSubmachine(Value: PUMLStateMachine);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Submachine: PUMLStateMachine read FSubmachine write SetSubmachine;
  end;

  // PUMLSubactivityState
  PUMLSubactivityState = class(PUMLSubmachineState)
  private
    FIsDynamic: Boolean;
    FDynamicArguments: string;
    FDynamicMultiplicity: string;
    procedure SetIsDynamic(Value: Boolean);
    procedure SetDynamicArguments(Value: string);
    procedure SetDynamicMultiplicity(Value: string);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property IsDynamic: Boolean read FIsDynamic write SetIsDynamic;
    property DynamicArguments: string read FDynamicArguments write SetDynamicArguments;
    property DynamicMultiplicity: string read FDynamicMultiplicity write SetDynamicMultiplicity;
  end;

  // PUMLFinalState
  PUMLFinalState = class(PUMLState)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLFlowFinalState
  PUMLFlowFinalState = class(PUMLFinalState)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLInteraction
  PUMLInteraction = class(PUMLModelElement)
  private
    FMessages: POrderedSet;
    FContext: PUMLCollaboration;
    FInteractionInstanceSets: POrderedSet;
    FFragments: POrderedSet;
    FOwnedFrames: POrderedSet;
    function GetMessage(Index: Integer): PUMLMessage;
    function GetMessageCount: Integer;
    procedure SetContext(Value: PUMLCollaboration);
    function GetInteractionInstanceSet(Index: Integer): PUMLInteractionInstanceSet;
    function GetInteractionInstanceSetCount: Integer;
    function GetFragment(Index: Integer): PUMLInteractionFragment;
    function GetFragmentCount: Integer;
    function GetOwnedFrame(Index: Integer): PUMLFrame;
    function GetOwnedFrameCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearMessages;
    procedure AddMessage(Value: PUMLMessage);
    procedure RemoveMessage(Value: PUMLMessage);
    procedure InsertMessage(Index: Integer; Value: PUMLMessage);
    procedure DeleteMessage(Index: Integer);
    function IndexOfMessage(Value: PUMLMessage): Integer;
    procedure ClearInteractionInstanceSets;
    procedure AddInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
    procedure RemoveInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
    procedure InsertInteractionInstanceSet(Index: Integer; Value: PUMLInteractionInstanceSet);
    procedure DeleteInteractionInstanceSet(Index: Integer);
    function IndexOfInteractionInstanceSet(Value: PUMLInteractionInstanceSet): Integer;
    procedure ClearFragments;
    procedure AddFragment(Value: PUMLInteractionFragment);
    procedure RemoveFragment(Value: PUMLInteractionFragment);
    procedure InsertFragment(Index: Integer; Value: PUMLInteractionFragment);
    procedure DeleteFragment(Index: Integer);
    function IndexOfFragment(Value: PUMLInteractionFragment): Integer;
    procedure ClearOwnedFrames;
    procedure AddOwnedFrame(Value: PUMLFrame);
    procedure RemoveOwnedFrame(Value: PUMLFrame);
    procedure InsertOwnedFrame(Index: Integer; Value: PUMLFrame);
    procedure DeleteOwnedFrame(Index: Integer);
    function IndexOfOwnedFrame(Value: PUMLFrame): Integer;
    function CanContainDiagramKind(Kind: string): Boolean; override;
    function CanContainDiagram(Diagram: PDiagram): Boolean; override;
    function CanContainKind(Kind: string): Boolean; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function CanPaste(Kind: string; CopyContext: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Messages[Index: Integer]: PUMLMessage read GetMessage;
    property MessageCount: Integer read GetMessageCount;
    property Context: PUMLCollaboration read FContext write SetContext;
    property InteractionInstanceSets[Index: Integer]: PUMLInteractionInstanceSet read GetInteractionInstanceSet;
    property InteractionInstanceSetCount: Integer read GetInteractionInstanceSetCount;
    property Fragments[Index: Integer]: PUMLInteractionFragment read GetFragment;
    property FragmentCount: Integer read GetFragmentCount;
    property OwnedFrames[Index: Integer]: PUMLFrame read GetOwnedFrame;
    property OwnedFrameCount: Integer read GetOwnedFrameCount;
  end;

  // PUMLMessage
  PUMLMessage = class(PUMLModelElement)
  private
    FArguments: string;
    FReturn: string;
    FIteration: string;
    FBranch: string;
    FInteraction: PUMLInteraction;
    FActivator: PUMLMessage;
    FActivatees: POrderedSet;
    FSender: PUMLClassifierRole;
    FReceiver: PUMLClassifierRole;
    FSuccessor: PUMLMessage;
    FPredecessor: PUMLMessage;
    FCommunicationConnection: PUMLAssociationRole;
    FAction: PUMLAction;
    FConformingStimuli: POrderedSet;
    procedure SetArguments(Value: string);
    procedure SetReturn(Value: string);
    procedure SetIteration(Value: string);
    procedure SetBranch(Value: string);
    procedure SetInteraction(Value: PUMLInteraction);
    procedure SetActivator(Value: PUMLMessage);
    function GetActivatee(Index: Integer): PUMLMessage;
    function GetActivateeCount: Integer;
    procedure SetSender(Value: PUMLClassifierRole);
    procedure SetReceiver(Value: PUMLClassifierRole);
    procedure SetSuccessor(Value: PUMLMessage);
    procedure SetPredecessor(Value: PUMLMessage);
    procedure SetCommunicationConnection(Value: PUMLAssociationRole);
    procedure SetAction(Value: PUMLAction);
    function GetConformingStimulus(Index: Integer): PUMLStimulus;
    function GetConformingStimulusCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearActivatees;
    procedure AddActivatee(Value: PUMLMessage);
    procedure RemoveActivatee(Value: PUMLMessage);
    procedure InsertActivatee(Index: Integer; Value: PUMLMessage);
    procedure DeleteActivatee(Index: Integer);
    function IndexOfActivatee(Value: PUMLMessage): Integer;
    procedure ClearConformingStimuli;
    procedure AddConformingStimulus(Value: PUMLStimulus);
    procedure RemoveConformingStimulus(Value: PUMLStimulus);
    procedure InsertConformingStimulus(Index: Integer; Value: PUMLStimulus);
    procedure DeleteConformingStimulus(Index: Integer);
    function IndexOfConformingStimulus(Value: PUMLStimulus): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function CanCopy: Boolean; override;
    function CanPaste(Kind: string; CopyContext: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Arguments: string read FArguments write SetArguments;
    property Return: string read FReturn write SetReturn;
    property Iteration: string read FIteration write SetIteration;
    property Branch: string read FBranch write SetBranch;
    property Interaction: PUMLInteraction read FInteraction write SetInteraction;
    property Activator: PUMLMessage read FActivator write SetActivator;
    property Activatees[Index: Integer]: PUMLMessage read GetActivatee;
    property ActivateeCount: Integer read GetActivateeCount;
    property Sender: PUMLClassifierRole read FSender write SetSender;
    property Receiver: PUMLClassifierRole read FReceiver write SetReceiver;
    property Successor: PUMLMessage read FSuccessor write SetSuccessor;
    property Predecessor: PUMLMessage read FPredecessor write SetPredecessor;
    property CommunicationConnection: PUMLAssociationRole read FCommunicationConnection write SetCommunicationConnection;
    property Action: PUMLAction read FAction write SetAction;
    property ConformingStimuli[Index: Integer]: PUMLStimulus read GetConformingStimulus;
    property ConformingStimulusCount: Integer read GetConformingStimulusCount;
  end;

  // PUMLAssociationClass
  PUMLAssociationClass = class(PUMLRelationship)
  private
    FClassSide: PUMLClass;
    FAssociationSide: PUMLAssociation;
    procedure SetClassSide(Value: PUMLClass);
    procedure SetAssociationSide(Value: PUMLAssociation);
  public
    constructor Create; override;
    destructor Destroy; override;
    function CanCopy: Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    function FindRelatedModel(FirstElement: PModel): PModel; override;

    property ClassSide: PUMLClass read FClassSide write SetClassSide;
    property AssociationSide: PUMLAssociation read FAssociationSide write SetAssociationSide;
  end;

  // PUMLStateMachine
  PUMLStateMachine = class(PUMLModelElement)
  private
    FContext: PUMLModelElement;
    FTop: PUMLState;
    FTransitions: POrderedSet;
    FSubmachineStates: POrderedSet;
    procedure SetContext(Value: PUMLModelElement);
    procedure SetTop(Value: PUMLState);
    function GetTransition(Index: Integer): PUMLTransition;
    function GetTransitionCount: Integer;
    function GetSubmachineState(Index: Integer): PUMLSubmachineState;
    function GetSubmachineStateCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearTransitions;
    procedure AddTransition(Value: PUMLTransition);
    procedure RemoveTransition(Value: PUMLTransition);
    procedure InsertTransition(Index: Integer; Value: PUMLTransition);
    procedure DeleteTransition(Index: Integer);
    function IndexOfTransition(Value: PUMLTransition): Integer;
    procedure ClearSubmachineStates;
    procedure AddSubmachineState(Value: PUMLSubmachineState);
    procedure RemoveSubmachineState(Value: PUMLSubmachineState);
    procedure InsertSubmachineState(Index: Integer; Value: PUMLSubmachineState);
    procedure DeleteSubmachineState(Index: Integer);
    function IndexOfSubmachineState(Value: PUMLSubmachineState): Integer;
    function CanContainDiagramKind(Kind: string): Boolean; override;
    function CanContainKind(Kind: string): Boolean; override;
    function CanPaste(Kind: string; CopyContext: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Context: PUMLModelElement read FContext write SetContext;
    property Top: PUMLState read FTop write SetTop;
    property Transitions[Index: Integer]: PUMLTransition read GetTransition;
    property TransitionCount: Integer read GetTransitionCount;
    property SubmachineStates[Index: Integer]: PUMLSubmachineState read GetSubmachineState;
    property SubmachineStateCount: Integer read GetSubmachineStateCount;
  end;

  // PUMLActivityGraph
  PUMLActivityGraph = class(PUMLStateMachine)
  private
    FPartitions: POrderedSet;
    function GetPartition(Index: Integer): PUMLPartition;
    function GetPartitionCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearPartitions;
    procedure AddPartition(Value: PUMLPartition);
    procedure RemovePartition(Value: PUMLPartition);
    procedure InsertPartition(Index: Integer; Value: PUMLPartition);
    procedure DeletePartition(Index: Integer);
    function IndexOfPartition(Value: PUMLPartition): Integer;
    function CanContainDiagramKind(Kind: string): Boolean; override;
    function CanContainKind(Kind: string): Boolean; override;
    function CanPaste(Kind: string; CopyContext: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Partitions[Index: Integer]: PUMLPartition read GetPartition;
    property PartitionCount: Integer read GetPartitionCount;
  end;

  // PUMLFeature
  PUMLFeature = class(PUMLRelationship)
  private
    FOwnerScope: PUMLScopeKind;
    FConnectorEnds: POrderedSet;
    FClassifierRoles: POrderedSet;
    procedure SetOwnerScope(Value: PUMLScopeKind);
    function GetConnectorEnd(Index: Integer): PUMLConnectorEnd;
    function GetConnectorEndCount: Integer;
    function GetClassifierRole(Index: Integer): PUMLClassifierRole;
    function GetClassifierRoleCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearConnectorEnds;
    procedure AddConnectorEnd(Value: PUMLConnectorEnd);
    procedure RemoveConnectorEnd(Value: PUMLConnectorEnd);
    procedure InsertConnectorEnd(Index: Integer; Value: PUMLConnectorEnd);
    procedure DeleteConnectorEnd(Index: Integer);
    function IndexOfConnectorEnd(Value: PUMLConnectorEnd): Integer;
    procedure ClearClassifierRoles;
    procedure AddClassifierRole(Value: PUMLClassifierRole);
    procedure RemoveClassifierRole(Value: PUMLClassifierRole);
    procedure InsertClassifierRole(Index: Integer; Value: PUMLClassifierRole);
    procedure DeleteClassifierRole(Index: Integer);
    function IndexOfClassifierRole(Value: PUMLClassifierRole): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    function FindRelatedModel(FirstElement: PModel): PModel; override;

    property OwnerScope: PUMLScopeKind read FOwnerScope write SetOwnerScope;
    property ConnectorEnds[Index: Integer]: PUMLConnectorEnd read GetConnectorEnd;
    property ConnectorEndCount: Integer read GetConnectorEndCount;
    property ClassifierRoles[Index: Integer]: PUMLClassifierRole read GetClassifierRole;
    property ClassifierRoleCount: Integer read GetClassifierRoleCount;
  end;

  // PUMLBehavioralFeature
  PUMLBehavioralFeature = class(PUMLFeature)
  private
    FIsQuery: Boolean;
    FParameters: POrderedSet;
    FRaisedSignals: POrderedSet;
    procedure SetIsQuery(Value: Boolean);
    function GetParameter(Index: Integer): PUMLParameter;
    function GetParameterCount: Integer;
    function GetRaisedSignal(Index: Integer): PUMLSignal;
    function GetRaisedSignalCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearParameters;
    procedure AddParameter(Value: PUMLParameter);
    procedure RemoveParameter(Value: PUMLParameter);
    procedure InsertParameter(Index: Integer; Value: PUMLParameter);
    procedure DeleteParameter(Index: Integer);
    function IndexOfParameter(Value: PUMLParameter): Integer;
    procedure ClearRaisedSignals;
    procedure AddRaisedSignal(Value: PUMLSignal);
    procedure RemoveRaisedSignal(Value: PUMLSignal);
    procedure InsertRaisedSignal(Index: Integer; Value: PUMLSignal);
    procedure DeleteRaisedSignal(Index: Integer);
    function IndexOfRaisedSignal(Value: PUMLSignal): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property IsQuery: Boolean read FIsQuery write SetIsQuery;
    property Parameters[Index: Integer]: PUMLParameter read GetParameter;
    property ParameterCount: Integer read GetParameterCount;
    property RaisedSignals[Index: Integer]: PUMLSignal read GetRaisedSignal;
    property RaisedSignalCount: Integer read GetRaisedSignalCount;
  end;

  // PUMLMethod
  PUMLMethod = class(PUMLBehavioralFeature)
  private
    FBody: string;
    FSpecification: PUMLOperation;
    procedure SetBody(Value: string);
    procedure SetSpecification(Value: PUMLOperation);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Body: string read FBody write SetBody;
    property Specification: PUMLOperation read FSpecification write SetSpecification;
  end;

  // PUMLOperation
  PUMLOperation = class(PUMLBehavioralFeature)
  private
    FConcurrency: PUMLCallConcurrencyKind;
    FIsRoot: Boolean;
    FIsLeaf: Boolean;
    FIsAbstract: Boolean;
    FSpecification: string;
    FOwner: PUMLClassifier;
    FMethods: POrderedSet;
    FCallActions: POrderedSet;
    FOccurrences: POrderedSet;
    FOwnedCollaborations: POrderedSet;
    FOwnedCollaborationInstanceSets: POrderedSet;
    procedure SetConcurrency(Value: PUMLCallConcurrencyKind);
    procedure SetIsRoot(Value: Boolean);
    procedure SetIsLeaf(Value: Boolean);
    procedure SetIsAbstract(Value: Boolean);
    procedure SetSpecification(Value: string);
    procedure SetOwner(Value: PUMLClassifier);
    function GetMethod(Index: Integer): PUMLMethod;
    function GetMethodCount: Integer;
    function GetCallAction(Index: Integer): PUMLCallAction;
    function GetCallActionCount: Integer;
    function GetOccurrence(Index: Integer): PUMLCallEvent;
    function GetOccurrenceCount: Integer;
    function GetOwnedCollaboration(Index: Integer): PUMLCollaboration;
    function GetOwnedCollaborationCount: Integer;
    function GetOwnedCollaborationInstanceSet(Index: Integer): PUMLCollaborationInstanceSet;
    function GetOwnedCollaborationInstanceSetCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearMethods;
    procedure AddMethod(Value: PUMLMethod);
    procedure RemoveMethod(Value: PUMLMethod);
    procedure InsertMethod(Index: Integer; Value: PUMLMethod);
    procedure DeleteMethod(Index: Integer);
    function IndexOfMethod(Value: PUMLMethod): Integer;
    procedure ClearCallActions;
    procedure AddCallAction(Value: PUMLCallAction);
    procedure RemoveCallAction(Value: PUMLCallAction);
    procedure InsertCallAction(Index: Integer; Value: PUMLCallAction);
    procedure DeleteCallAction(Index: Integer);
    function IndexOfCallAction(Value: PUMLCallAction): Integer;
    procedure ClearOccurrences;
    procedure AddOccurrence(Value: PUMLCallEvent);
    procedure RemoveOccurrence(Value: PUMLCallEvent);
    procedure InsertOccurrence(Index: Integer; Value: PUMLCallEvent);
    procedure DeleteOccurrence(Index: Integer);
    function IndexOfOccurrence(Value: PUMLCallEvent): Integer;
    procedure ClearOwnedCollaborations;
    procedure AddOwnedCollaboration(Value: PUMLCollaboration);
    procedure RemoveOwnedCollaboration(Value: PUMLCollaboration);
    procedure InsertOwnedCollaboration(Index: Integer; Value: PUMLCollaboration);
    procedure DeleteOwnedCollaboration(Index: Integer);
    function IndexOfOwnedCollaboration(Value: PUMLCollaboration): Integer;
    procedure ClearOwnedCollaborationInstanceSets;
    procedure AddOwnedCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
    procedure RemoveOwnedCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
    procedure InsertOwnedCollaborationInstanceSet(Index: Integer; Value: PUMLCollaborationInstanceSet);
    procedure DeleteOwnedCollaborationInstanceSet(Index: Integer);
    function IndexOfOwnedCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Concurrency: PUMLCallConcurrencyKind read FConcurrency write SetConcurrency;
    property IsRoot: Boolean read FIsRoot write SetIsRoot;
    property IsLeaf: Boolean read FIsLeaf write SetIsLeaf;
    property IsAbstract: Boolean read FIsAbstract write SetIsAbstract;
    property Specification: string read FSpecification write SetSpecification;
    property Owner: PUMLClassifier read FOwner write SetOwner;
    property Methods[Index: Integer]: PUMLMethod read GetMethod;
    property MethodCount: Integer read GetMethodCount;
    property CallActions[Index: Integer]: PUMLCallAction read GetCallAction;
    property CallActionCount: Integer read GetCallActionCount;
    property Occurrences[Index: Integer]: PUMLCallEvent read GetOccurrence;
    property OccurrenceCount: Integer read GetOccurrenceCount;
    property OwnedCollaborations[Index: Integer]: PUMLCollaboration read GetOwnedCollaboration;
    property OwnedCollaborationCount: Integer read GetOwnedCollaborationCount;
    property OwnedCollaborationInstanceSets[Index: Integer]: PUMLCollaborationInstanceSet read GetOwnedCollaborationInstanceSet;
    property OwnedCollaborationInstanceSetCount: Integer read GetOwnedCollaborationInstanceSetCount;
  end;

  // PUMLReception
  PUMLReception = class(PUMLBehavioralFeature)
  private
    FSpecification: string;
    FIsRoot: Boolean;
    FIsLeaf: Boolean;
    FIsAbstract: Boolean;
    FSignal: PUMLSignal;
    procedure SetSpecification(Value: string);
    procedure SetIsRoot(Value: Boolean);
    procedure SetIsLeaf(Value: Boolean);
    procedure SetIsAbstract(Value: Boolean);
    procedure SetSignal(Value: PUMLSignal);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Specification: string read FSpecification write SetSpecification;
    property IsRoot: Boolean read FIsRoot write SetIsRoot;
    property IsLeaf: Boolean read FIsLeaf write SetIsLeaf;
    property IsAbstract: Boolean read FIsAbstract write SetIsAbstract;
    property Signal: PUMLSignal read FSignal write SetSignal;
  end;

  // PUMLConnector
  PUMLConnector = class(PUMLFeature)
  private
    FEnds: POrderedSet;
    FOwner: PUMLClassifier;
    function GetEnd(Index: Integer): PUMLConnectorEnd;
    function GetEndCount: Integer;
    procedure SetOwner(Value: PUMLClassifier);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearEnds;
    procedure AddEnd(Value: PUMLConnectorEnd);
    procedure RemoveEnd(Value: PUMLConnectorEnd);
    procedure InsertEnd(Index: Integer; Value: PUMLConnectorEnd);
    procedure DeleteEnd(Index: Integer);
    function IndexOfEnd(Value: PUMLConnectorEnd): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    function FindRelatedModel(FirstElement: PModel): PModel; override;

    property Ends[Index: Integer]: PUMLConnectorEnd read GetEnd;
    property EndCount: Integer read GetEndCount;
    property Owner: PUMLClassifier read FOwner write SetOwner;
  end;

  // PUMLStructuralFeature
  PUMLStructuralFeature = class(PUMLFeature)
  private
    FMultiplicity: string;
    FChangeability: PUMLChangeableKind;
    FTargetScope: PUMLScopeKind;
    FOrdering: PUMLOrderingKind;
    FTypeExpression: string;
    FType_: PUMLClassifier;
    procedure SetMultiplicity(Value: string);
    procedure SetChangeability(Value: PUMLChangeableKind);
    procedure SetTargetScope(Value: PUMLScopeKind);
    procedure SetOrdering(Value: PUMLOrderingKind);
    procedure SetTypeExpression(Value: string);
    procedure SetType_(Value: PUMLClassifier);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Multiplicity: string read FMultiplicity write SetMultiplicity;
    property Changeability: PUMLChangeableKind read FChangeability write SetChangeability;
    property TargetScope: PUMLScopeKind read FTargetScope write SetTargetScope;
    property Ordering: PUMLOrderingKind read FOrdering write SetOrdering;
    property TypeExpression: string read FTypeExpression write SetTypeExpression;
    property Type_: PUMLClassifier read FType_ write SetType_;
  end;

  // PUMLAttribute
  PUMLAttribute = class(PUMLStructuralFeature)
  private
    FInitialValue: string;
    FAssociationEnd: PUMLAssociationEnd;
    FOwner: PUMLClassifier;
    FAttributeLinks: POrderedSet;
    FAssociationEndRoles: POrderedSet;
    procedure SetInitialValue(Value: string);
    procedure SetAssociationEnd(Value: PUMLAssociationEnd);
    procedure SetOwner(Value: PUMLClassifier);
    function GetAttributeLink(Index: Integer): PUMLAttributeLink;
    function GetAttributeLinkCount: Integer;
    function GetAssociationEndRole(Index: Integer): PUMLAssociationEndRole;
    function GetAssociationEndRoleCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearAttributeLinks;
    procedure AddAttributeLink(Value: PUMLAttributeLink);
    procedure RemoveAttributeLink(Value: PUMLAttributeLink);
    procedure InsertAttributeLink(Index: Integer; Value: PUMLAttributeLink);
    procedure DeleteAttributeLink(Index: Integer);
    function IndexOfAttributeLink(Value: PUMLAttributeLink): Integer;
    procedure ClearAssociationEndRoles;
    procedure AddAssociationEndRole(Value: PUMLAssociationEndRole);
    procedure RemoveAssociationEndRole(Value: PUMLAssociationEndRole);
    procedure InsertAssociationEndRole(Index: Integer; Value: PUMLAssociationEndRole);
    procedure DeleteAssociationEndRole(Index: Integer);
    function IndexOfAssociationEndRole(Value: PUMLAssociationEndRole): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property InitialValue: string read FInitialValue write SetInitialValue;
    property AssociationEnd: PUMLAssociationEnd read FAssociationEnd write SetAssociationEnd;
    property Owner: PUMLClassifier read FOwner write SetOwner;
    property AttributeLinks[Index: Integer]: PUMLAttributeLink read GetAttributeLink;
    property AttributeLinkCount: Integer read GetAttributeLinkCount;
    property AssociationEndRoles[Index: Integer]: PUMLAssociationEndRole read GetAssociationEndRole;
    property AssociationEndRoleCount: Integer read GetAssociationEndRoleCount;
  end;

  // PUMLPort
  PUMLPort = class(PUMLStructuralFeature)
  private
    FIsBehavior: Boolean;
    FIsService: Boolean;
    FOwner: PUMLClassifier;
    procedure SetIsBehavior(Value: Boolean);
    procedure SetIsService(Value: Boolean);
    procedure SetOwner(Value: PUMLClassifier);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property IsBehavior: Boolean read FIsBehavior write SetIsBehavior;
    property IsService: Boolean read FIsService write SetIsService;
    property Owner: PUMLClassifier read FOwner write SetOwner;
  end;

  // PUMLGeneralizableElement
  PUMLGeneralizableElement = class(PUMLModelElement)
  private
    FIsRoot: Boolean;
    FIsLeaf: Boolean;
    FIsAbstract: Boolean;
    FGeneralizations: POrderedSet;
    FSpecializations: POrderedSet;
    procedure SetIsRoot(Value: Boolean);
    procedure SetIsLeaf(Value: Boolean);
    procedure SetIsAbstract(Value: Boolean);
    function GetGeneralization(Index: Integer): PUMLGeneralization;
    function GetGeneralizationCount: Integer;
    function GetSpecialization(Index: Integer): PUMLGeneralization;
    function GetSpecializationCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearGeneralizations;
    procedure AddGeneralization(Value: PUMLGeneralization);
    procedure RemoveGeneralization(Value: PUMLGeneralization);
    procedure InsertGeneralization(Index: Integer; Value: PUMLGeneralization);
    procedure DeleteGeneralization(Index: Integer);
    function IndexOfGeneralization(Value: PUMLGeneralization): Integer;
    procedure ClearSpecializations;
    procedure AddSpecialization(Value: PUMLGeneralization);
    procedure RemoveSpecialization(Value: PUMLGeneralization);
    procedure InsertSpecialization(Index: Integer; Value: PUMLGeneralization);
    procedure DeleteSpecialization(Index: Integer);
    function IndexOfSpecialization(Value: PUMLGeneralization): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property IsRoot: Boolean read FIsRoot write SetIsRoot;
    property IsLeaf: Boolean read FIsLeaf write SetIsLeaf;
    property IsAbstract: Boolean read FIsAbstract write SetIsAbstract;
    property Generalizations[Index: Integer]: PUMLGeneralization read GetGeneralization;
    property GeneralizationCount: Integer read GetGeneralizationCount;
    property Specializations[Index: Integer]: PUMLGeneralization read GetSpecialization;
    property SpecializationCount: Integer read GetSpecializationCount;
  end;

  // PUMLNamespace
  PUMLNamespace = class(PUMLGeneralizableElement)
  private
    FOwnedElements: POrderedSet;
    function GetOwnedElement(Index: Integer): PUMLModelElement;
    function GetOwnedElementCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearOwnedElements;
    procedure AddOwnedElement(Value: PUMLModelElement);
    procedure RemoveOwnedElement(Value: PUMLModelElement);
    procedure InsertOwnedElement(Index: Integer; Value: PUMLModelElement);
    procedure DeleteOwnedElement(Index: Integer);
    function IndexOfOwnedElement(Value: PUMLModelElement): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property OwnedElements[Index: Integer]: PUMLModelElement read GetOwnedElement;
    property OwnedElementCount: Integer read GetOwnedElementCount;
  end;

  // PUMLCollaboration
  PUMLCollaboration = class(PUMLNamespace)
  private
    FInteractions: POrderedSet;
    FRepresentedOperation: PUMLOperation;
    FCollaborationInstanceSets: POrderedSet;
    FUserCollaborations: POrderedSet;
    FUsedCollaborations: POrderedSet;
    FRepresentedClassifier: PUMLClassifier;
    function GetInteraction(Index: Integer): PUMLInteraction;
    function GetInteractionCount: Integer;
    procedure SetRepresentedOperation(Value: PUMLOperation);
    function GetCollaborationInstanceSet(Index: Integer): PUMLCollaborationInstanceSet;
    function GetCollaborationInstanceSetCount: Integer;
    function GetUserCollaboration(Index: Integer): PUMLCollaboration;
    function GetUserCollaborationCount: Integer;
    function GetUsedCollaboration(Index: Integer): PUMLCollaboration;
    function GetUsedCollaborationCount: Integer;
    procedure SetRepresentedClassifier(Value: PUMLClassifier);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearInteractions;
    procedure AddInteraction(Value: PUMLInteraction);
    procedure RemoveInteraction(Value: PUMLInteraction);
    procedure InsertInteraction(Index: Integer; Value: PUMLInteraction);
    procedure DeleteInteraction(Index: Integer);
    function IndexOfInteraction(Value: PUMLInteraction): Integer;
    procedure ClearCollaborationInstanceSets;
    procedure AddCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
    procedure RemoveCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
    procedure InsertCollaborationInstanceSet(Index: Integer; Value: PUMLCollaborationInstanceSet);
    procedure DeleteCollaborationInstanceSet(Index: Integer);
    function IndexOfCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet): Integer;
    procedure ClearUserCollaborations;
    procedure AddUserCollaboration(Value: PUMLCollaboration);
    procedure RemoveUserCollaboration(Value: PUMLCollaboration);
    procedure InsertUserCollaboration(Index: Integer; Value: PUMLCollaboration);
    procedure DeleteUserCollaboration(Index: Integer);
    function IndexOfUserCollaboration(Value: PUMLCollaboration): Integer;
    procedure ClearUsedCollaborations;
    procedure AddUsedCollaboration(Value: PUMLCollaboration);
    procedure RemoveUsedCollaboration(Value: PUMLCollaboration);
    procedure InsertUsedCollaboration(Index: Integer; Value: PUMLCollaboration);
    procedure DeleteUsedCollaboration(Index: Integer);
    function IndexOfUsedCollaboration(Value: PUMLCollaboration): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Interactions[Index: Integer]: PUMLInteraction read GetInteraction;
    property InteractionCount: Integer read GetInteractionCount;
    property RepresentedOperation: PUMLOperation read FRepresentedOperation write SetRepresentedOperation;
    property CollaborationInstanceSets[Index: Integer]: PUMLCollaborationInstanceSet read GetCollaborationInstanceSet;
    property CollaborationInstanceSetCount: Integer read GetCollaborationInstanceSetCount;
    property UserCollaborations[Index: Integer]: PUMLCollaboration read GetUserCollaboration;
    property UserCollaborationCount: Integer read GetUserCollaborationCount;
    property UsedCollaborations[Index: Integer]: PUMLCollaboration read GetUsedCollaboration;
    property UsedCollaborationCount: Integer read GetUsedCollaborationCount;
    property RepresentedClassifier: PUMLClassifier read FRepresentedClassifier write SetRepresentedClassifier;
  end;

  // PUMLClassifier
  PUMLClassifier = class(PUMLNamespace)
  private type
    PAssociationEndOrderedSet = POrderedSet<UMLModels.PUMLAssociationEnd>;
  private
    FOperations: POrderedSet;
    FTypedFeatures: POrderedSet;
    FTypedParameters: POrderedSet;
    FAssociations: PAssociationEndOrderedSet;
    FPowertypeGeneralizations: POrderedSet;
    FAttributes: POrderedSet;
    FOwnedPorts: POrderedSet;
    FOwnedConnectors: POrderedSet;
    FInstances: POrderedSet;
    FCreateActions: POrderedSet;
    FClassifierRoles: POrderedSet;
    FOwnedCollaborations: POrderedSet;
    FOwnedCollaborationInstanceSets: POrderedSet;
    FClassifierInStates: POrderedSet;
    FObjectFlowStates: POrderedSet;
    function GetOperation(Index: Integer): PUMLOperation;
    function GetOperationCount: Integer;
    function GetTypedFeature(Index: Integer): PUMLStructuralFeature;
    function GetTypedFeatureCount: Integer;
    function GetTypedParameter(Index: Integer): PUMLParameter;
    function GetTypedParameterCount: Integer;
    function GetAssociation(Index: Integer): PUMLAssociationEnd;
    function GetAssociationCount: Integer;
    function GetPowertypeGeneralization(Index: Integer): PUMLGeneralization;
    function GetPowertypeGeneralizationCount: Integer;
    function GetAttribute(Index: Integer): PUMLAttribute;
    function GetAttributeCount: Integer;
    function GetOwnedPort(Index: Integer): PUMLPort;
    function GetOwnedPortCount: Integer;
    function GetOwnedConnector(Index: Integer): PUMLConnector;
    function GetOwnedConnectorCount: Integer;
    function GetInstance(Index: Integer): PUMLInstance;
    function GetInstanceCount: Integer;
    function GetCreateAction(Index: Integer): PUMLCreateAction;
    function GetCreateActionCount: Integer;
    function GetClassifierRole(Index: Integer): PUMLClassifierRole;
    function GetClassifierRoleCount: Integer;
    function GetOwnedCollaboration(Index: Integer): PUMLCollaboration;
    function GetOwnedCollaborationCount: Integer;
    function GetOwnedCollaborationInstanceSet(Index: Integer): PUMLCollaborationInstanceSet;
    function GetOwnedCollaborationInstanceSetCount: Integer;
    function GetClassifierInState(Index: Integer): PUMLClassifierInState;
    function GetClassifierInStateCount: Integer;
    function GetObjectFlowState(Index: Integer): PUMLObjectFlowState;
    function GetObjectFlowStateCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearOperations;
    procedure AddOperation(Value: PUMLOperation);
    procedure RemoveOperation(Value: PUMLOperation);
    procedure InsertOperation(Index: Integer; Value: PUMLOperation);
    procedure DeleteOperation(Index: Integer);
    function IndexOfOperation(Value: PUMLOperation): Integer;
    procedure ClearTypedFeatures;
    procedure AddTypedFeature(Value: PUMLStructuralFeature);
    procedure RemoveTypedFeature(Value: PUMLStructuralFeature);
    procedure InsertTypedFeature(Index: Integer; Value: PUMLStructuralFeature);
    procedure DeleteTypedFeature(Index: Integer);
    function IndexOfTypedFeature(Value: PUMLStructuralFeature): Integer;
    procedure ClearTypedParameters;
    procedure AddTypedParameter(Value: PUMLParameter);
    procedure RemoveTypedParameter(Value: PUMLParameter);
    procedure InsertTypedParameter(Index: Integer; Value: PUMLParameter);
    procedure DeleteTypedParameter(Index: Integer);
    function IndexOfTypedParameter(Value: PUMLParameter): Integer;
    procedure ClearAssociations;
    procedure AddAssociation(Value: PUMLAssociationEnd);
    procedure RemoveAssociation(Value: PUMLAssociationEnd);
    procedure InsertAssociation(Index: Integer; Value: PUMLAssociationEnd);
    procedure DeleteAssociation(Index: Integer);
    function IndexOfAssociation(Value: PUMLAssociationEnd): Integer;
    procedure ClearPowertypeGeneralizations;
    procedure AddPowertypeGeneralization(Value: PUMLGeneralization);
    procedure RemovePowertypeGeneralization(Value: PUMLGeneralization);
    procedure InsertPowertypeGeneralization(Index: Integer; Value: PUMLGeneralization);
    procedure DeletePowertypeGeneralization(Index: Integer);
    function IndexOfPowertypeGeneralization(Value: PUMLGeneralization): Integer;
    procedure ClearAttributes;
    procedure AddAttribute(Value: PUMLAttribute);
    procedure RemoveAttribute(Value: PUMLAttribute);
    procedure InsertAttribute(Index: Integer; Value: PUMLAttribute);
    procedure DeleteAttribute(Index: Integer);
    function IndexOfAttribute(Value: PUMLAttribute): Integer;
    procedure ClearOwnedPorts;
    procedure AddOwnedPort(Value: PUMLPort);
    procedure RemoveOwnedPort(Value: PUMLPort);
    procedure InsertOwnedPort(Index: Integer; Value: PUMLPort);
    procedure DeleteOwnedPort(Index: Integer);
    function IndexOfOwnedPort(Value: PUMLPort): Integer;
    procedure ClearOwnedConnectors;
    procedure AddOwnedConnector(Value: PUMLConnector);
    procedure RemoveOwnedConnector(Value: PUMLConnector);
    procedure InsertOwnedConnector(Index: Integer; Value: PUMLConnector);
    procedure DeleteOwnedConnector(Index: Integer);
    function IndexOfOwnedConnector(Value: PUMLConnector): Integer;
    procedure ClearInstances;
    procedure AddInstance(Value: PUMLInstance);
    procedure RemoveInstance(Value: PUMLInstance);
    procedure InsertInstance(Index: Integer; Value: PUMLInstance);
    procedure DeleteInstance(Index: Integer);
    function IndexOfInstance(Value: PUMLInstance): Integer;
    procedure ClearCreateActions;
    procedure AddCreateAction(Value: PUMLCreateAction);
    procedure RemoveCreateAction(Value: PUMLCreateAction);
    procedure InsertCreateAction(Index: Integer; Value: PUMLCreateAction);
    procedure DeleteCreateAction(Index: Integer);
    function IndexOfCreateAction(Value: PUMLCreateAction): Integer;
    procedure ClearClassifierRoles;
    procedure AddClassifierRole(Value: PUMLClassifierRole);
    procedure RemoveClassifierRole(Value: PUMLClassifierRole);
    procedure InsertClassifierRole(Index: Integer; Value: PUMLClassifierRole);
    procedure DeleteClassifierRole(Index: Integer);
    function IndexOfClassifierRole(Value: PUMLClassifierRole): Integer;
    procedure ClearOwnedCollaborations;
    procedure AddOwnedCollaboration(Value: PUMLCollaboration);
    procedure RemoveOwnedCollaboration(Value: PUMLCollaboration);
    procedure InsertOwnedCollaboration(Index: Integer; Value: PUMLCollaboration);
    procedure DeleteOwnedCollaboration(Index: Integer);
    function IndexOfOwnedCollaboration(Value: PUMLCollaboration): Integer;
    procedure ClearOwnedCollaborationInstanceSets;
    procedure AddOwnedCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
    procedure RemoveOwnedCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
    procedure InsertOwnedCollaborationInstanceSet(Index: Integer; Value: PUMLCollaborationInstanceSet);
    procedure DeleteOwnedCollaborationInstanceSet(Index: Integer);
    function IndexOfOwnedCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet): Integer;
    procedure ClearClassifierInStates;
    procedure AddClassifierInState(Value: PUMLClassifierInState);
    procedure RemoveClassifierInState(Value: PUMLClassifierInState);
    procedure InsertClassifierInState(Index: Integer; Value: PUMLClassifierInState);
    procedure DeleteClassifierInState(Index: Integer);
    function IndexOfClassifierInState(Value: PUMLClassifierInState): Integer;
    procedure ClearObjectFlowStates;
    procedure AddObjectFlowState(Value: PUMLObjectFlowState);
    procedure RemoveObjectFlowState(Value: PUMLObjectFlowState);
    procedure InsertObjectFlowState(Index: Integer; Value: PUMLObjectFlowState);
    procedure DeleteObjectFlowState(Index: Integer);
    function IndexOfObjectFlowState(Value: PUMLObjectFlowState): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Operations[Index: Integer]: PUMLOperation read GetOperation;
    property OperationCount: Integer read GetOperationCount;
    property TypedFeatures[Index: Integer]: PUMLStructuralFeature read GetTypedFeature;
    property TypedFeatureCount: Integer read GetTypedFeatureCount;
    property TypedParameters[Index: Integer]: PUMLParameter read GetTypedParameter;
    property TypedParameterCount: Integer read GetTypedParameterCount;
    property Associations: PAssociationEndOrderedSet read FAssociations;
    property Association[Index: Integer]: PUMLAssociationEnd read GetAssociation;
    property AssociationCount: Integer read GetAssociationCount;
    property PowertypeGeneralizations[Index: Integer]: PUMLGeneralization read GetPowertypeGeneralization;
    property PowertypeGeneralizationCount: Integer read GetPowertypeGeneralizationCount;
    property Attributes[Index: Integer]: PUMLAttribute read GetAttribute;
    property AttributeCount: Integer read GetAttributeCount;
    property OwnedPorts[Index: Integer]: PUMLPort read GetOwnedPort;
    property OwnedPortCount: Integer read GetOwnedPortCount;
    property OwnedConnectors[Index: Integer]: PUMLConnector read GetOwnedConnector;
    property OwnedConnectorCount: Integer read GetOwnedConnectorCount;
    property Instances[Index: Integer]: PUMLInstance read GetInstance;
    property InstanceCount: Integer read GetInstanceCount;
    property CreateActions[Index: Integer]: PUMLCreateAction read GetCreateAction;
    property CreateActionCount: Integer read GetCreateActionCount;
    property ClassifierRoles[Index: Integer]: PUMLClassifierRole read GetClassifierRole;
    property ClassifierRoleCount: Integer read GetClassifierRoleCount;
    property OwnedCollaborations[Index: Integer]: PUMLCollaboration read GetOwnedCollaboration;
    property OwnedCollaborationCount: Integer read GetOwnedCollaborationCount;
    property OwnedCollaborationInstanceSets[Index: Integer]: PUMLCollaborationInstanceSet read GetOwnedCollaborationInstanceSet;
    property OwnedCollaborationInstanceSetCount: Integer read GetOwnedCollaborationInstanceSetCount;
    property ClassifierInStates[Index: Integer]: PUMLClassifierInState read GetClassifierInState;
    property ClassifierInStateCount: Integer read GetClassifierInStateCount;
    property ObjectFlowStates[Index: Integer]: PUMLObjectFlowState read GetObjectFlowState;
    property ObjectFlowStateCount: Integer read GetObjectFlowStateCount;
  end;

  // PUMLUseCase
  PUMLUseCase = class(PUMLClassifier)
  private
    FExtenders: POrderedSet;
    FExtends: POrderedSet;
    FIncluders: POrderedSet;
    FIncludes: POrderedSet;
    FExtensionPoints: POrderedSet;
    function GetExtender(Index: Integer): PUMLExtend;
    function GetExtenderCount: Integer;
    function GetExtend(Index: Integer): PUMLExtend;
    function GetExtendCount: Integer;
    function GetIncluder(Index: Integer): PUMLInclude;
    function GetIncluderCount: Integer;
    function GetInclude(Index: Integer): PUMLInclude;
    function GetIncludeCount: Integer;
    function GetExtensionPoint(Index: Integer): PUMLExtensionPoint;
    function GetExtensionPointCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearExtenders;
    procedure AddExtender(Value: PUMLExtend);
    procedure RemoveExtender(Value: PUMLExtend);
    procedure InsertExtender(Index: Integer; Value: PUMLExtend);
    procedure DeleteExtender(Index: Integer);
    function IndexOfExtender(Value: PUMLExtend): Integer;
    procedure ClearExtends;
    procedure AddExtend(Value: PUMLExtend);
    procedure RemoveExtend(Value: PUMLExtend);
    procedure InsertExtend(Index: Integer; Value: PUMLExtend);
    procedure DeleteExtend(Index: Integer);
    function IndexOfExtend(Value: PUMLExtend): Integer;
    procedure ClearIncluders;
    procedure AddIncluder(Value: PUMLInclude);
    procedure RemoveIncluder(Value: PUMLInclude);
    procedure InsertIncluder(Index: Integer; Value: PUMLInclude);
    procedure DeleteIncluder(Index: Integer);
    function IndexOfIncluder(Value: PUMLInclude): Integer;
    procedure ClearIncludes;
    procedure AddInclude(Value: PUMLInclude);
    procedure RemoveInclude(Value: PUMLInclude);
    procedure InsertInclude(Index: Integer; Value: PUMLInclude);
    procedure DeleteInclude(Index: Integer);
    function IndexOfInclude(Value: PUMLInclude): Integer;
    procedure ClearExtensionPoints;
    procedure AddExtensionPoint(Value: PUMLExtensionPoint);
    procedure RemoveExtensionPoint(Value: PUMLExtensionPoint);
    procedure InsertExtensionPoint(Index: Integer; Value: PUMLExtensionPoint);
    procedure DeleteExtensionPoint(Index: Integer);
    function IndexOfExtensionPoint(Value: PUMLExtensionPoint): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Extenders[Index: Integer]: PUMLExtend read GetExtender;
    property ExtenderCount: Integer read GetExtenderCount;
    property Extends[Index: Integer]: PUMLExtend read GetExtend;
    property ExtendCount: Integer read GetExtendCount;
    property Includers[Index: Integer]: PUMLInclude read GetIncluder;
    property IncluderCount: Integer read GetIncluderCount;
    property Includes[Index: Integer]: PUMLInclude read GetInclude;
    property IncludeCount: Integer read GetIncludeCount;
    property ExtensionPoints[Index: Integer]: PUMLExtensionPoint read GetExtensionPoint;
    property ExtensionPointCount: Integer read GetExtensionPointCount;
  end;

  // PUMLActor
  PUMLActor = class(PUMLClassifier)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLClassifierInState
  PUMLClassifierInState = class(PUMLClassifier)
  private
    FType_: PUMLClassifier;
    FInStates: POrderedSet;
    procedure SetType_(Value: PUMLClassifier);
    function GetInState(Index: Integer): PUMLState;
    function GetInStateCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearInStates;
    procedure AddInState(Value: PUMLState);
    procedure RemoveInState(Value: PUMLState);
    procedure InsertInState(Index: Integer; Value: PUMLState);
    procedure DeleteInState(Index: Integer);
    function IndexOfInState(Value: PUMLState): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Type_: PUMLClassifier read FType_ write SetType_;
    property InStates[Index: Integer]: PUMLState read GetInState;
    property InStateCount: Integer read GetInStateCount;
  end;

  // PUMLInterface
  PUMLInterface = class(PUMLClassifier)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLPackage
  PUMLPackage = class(PUMLClassifier)
  private
    FElementImportItems: POrderedSet;
    function GetElementImportItem(Index: Integer): PUMLElementImport;
    function GetElementImportItemCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearElementImportItems;
    procedure AddElementImportItem(Value: PUMLElementImport);
    procedure RemoveElementImportItem(Value: PUMLElementImport);
    procedure InsertElementImportItem(Index: Integer; Value: PUMLElementImport);
    procedure DeleteElementImportItem(Index: Integer);
    function IndexOfElementImportItem(Value: PUMLElementImport): Integer;
    function CanContainDiagramKind(Kind: string): Boolean; override;
    function CanContainKind(Kind: string): Boolean; override;
    function CanPaste(Kind: string; CopyContext: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property ElementImportItems[Index: Integer]: PUMLElementImport read GetElementImportItem;
    property ElementImportItemCount: Integer read GetElementImportItemCount;
  end;

  // PUMLSubsystem
  PUMLSubsystem = class(PUMLPackage)
  private
    FIsInstantiable: Boolean;
    procedure SetIsInstantiable(Value: Boolean);
  public
    constructor Create; override;
    destructor Destroy; override;
    function CanContainKind(Kind: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property IsInstantiable: Boolean read FIsInstantiable write SetIsInstantiable;
  end;

  // PUMLProject
  PUMLProject = class(PUMLPackage)
  private
    FTitle: string;
    FAuthor: string;
    FCompany: string;
    FCopyright: string;
    procedure SetTitle(Value: string);
    procedure SetAuthor(Value: string);
    procedure SetCompany(Value: string);
    procedure SetCopyright(Value: string);
  public
    constructor Create; override;
    destructor Destroy; override;
    function CanContainKind(Kind: string): Boolean; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function CanCopy: Boolean; override;
    function CanDelete: Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Title: string read FTitle write SetTitle;
    property Author: string read FAuthor write SetAuthor;
    property Company: string read FCompany write SetCompany;
    property Copyright: string read FCopyright write SetCopyright;
  end;

  // PUMLModel
  PUMLModel = class(PUMLPackage)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLDataType
  PUMLDataType = class(PUMLClassifier)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLProgrammingLanguageDataType
  PUMLProgrammingLanguageDataType = class(PUMLDataType)
  private
    FExpression: string;
    procedure SetExpression(Value: string);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Expression: string read FExpression write SetExpression;
  end;

  // PUMLPrimitive
  PUMLPrimitive = class(PUMLDataType)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLEnumeration
  PUMLEnumeration = class(PUMLDataType)
  private
    FLiterals: POrderedSet;
    function GetLiteral(Index: Integer): PUMLEnumerationLiteral;
    function GetLiteralCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearLiterals;
    procedure AddLiteral(Value: PUMLEnumerationLiteral);
    procedure RemoveLiteral(Value: PUMLEnumerationLiteral);
    procedure InsertLiteral(Index: Integer; Value: PUMLEnumerationLiteral);
    procedure DeleteLiteral(Index: Integer);
    function IndexOfLiteral(Value: PUMLEnumerationLiteral): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Literals[Index: Integer]: PUMLEnumerationLiteral read GetLiteral;
    property LiteralCount: Integer read GetLiteralCount;
  end;

  // PUMLClass
  PUMLClass = class(PUMLClassifier)
  private
    FIsActive: Boolean;
    FAssociationClass: PUMLAssociationClass;
    procedure SetIsActive(Value: Boolean);
    procedure SetAssociationClass(Value: PUMLAssociationClass);
  public
    constructor Create; override;
    destructor Destroy; override;
    function CanContainKind(Kind: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property IsActive: Boolean read FIsActive write SetIsActive;
    property AssociationClass: PUMLAssociationClass read FAssociationClass write SetAssociationClass;
  end;

  // PUMLNode
  PUMLNode = class(PUMLClassifier)
  private
    FDeployedComponents: POrderedSet;
    FDeployedArtifacts: POrderedSet;
    function GetDeployedComponent(Index: Integer): PUMLComponent;
    function GetDeployedComponentCount: Integer;
    function GetDeployedArtifact(Index: Integer): PUMLArtifact;
    function GetDeployedArtifactCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearDeployedComponents;
    procedure AddDeployedComponent(Value: PUMLComponent);
    procedure RemoveDeployedComponent(Value: PUMLComponent);
    procedure InsertDeployedComponent(Index: Integer; Value: PUMLComponent);
    procedure DeleteDeployedComponent(Index: Integer);
    function IndexOfDeployedComponent(Value: PUMLComponent): Integer;
    procedure ClearDeployedArtifacts;
    procedure AddDeployedArtifact(Value: PUMLArtifact);
    procedure RemoveDeployedArtifact(Value: PUMLArtifact);
    procedure InsertDeployedArtifact(Index: Integer; Value: PUMLArtifact);
    procedure DeleteDeployedArtifact(Index: Integer);
    function IndexOfDeployedArtifact(Value: PUMLArtifact): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property DeployedComponents[Index: Integer]: PUMLComponent read GetDeployedComponent;
    property DeployedComponentCount: Integer read GetDeployedComponentCount;
    property DeployedArtifacts[Index: Integer]: PUMLArtifact read GetDeployedArtifact;
    property DeployedArtifactCount: Integer read GetDeployedArtifactCount;
  end;

  // PUMLArtifact
  PUMLArtifact = class(PUMLClassifier)
  private
    FImplementationLocations: POrderedSet;
    FDeploymentLocations: POrderedSet;
    function GetImplementationLocation(Index: Integer): PUMLComponent;
    function GetImplementationLocationCount: Integer;
    function GetDeploymentLocation(Index: Integer): PUMLNode;
    function GetDeploymentLocationCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearImplementationLocations;
    procedure AddImplementationLocation(Value: PUMLComponent);
    procedure RemoveImplementationLocation(Value: PUMLComponent);
    procedure InsertImplementationLocation(Index: Integer; Value: PUMLComponent);
    procedure DeleteImplementationLocation(Index: Integer);
    function IndexOfImplementationLocation(Value: PUMLComponent): Integer;
    procedure ClearDeploymentLocations;
    procedure AddDeploymentLocation(Value: PUMLNode);
    procedure RemoveDeploymentLocation(Value: PUMLNode);
    procedure InsertDeploymentLocation(Index: Integer; Value: PUMLNode);
    procedure DeleteDeploymentLocation(Index: Integer);
    function IndexOfDeploymentLocation(Value: PUMLNode): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property ImplementationLocations[Index: Integer]: PUMLComponent read GetImplementationLocation;
    property ImplementationLocationCount: Integer read GetImplementationLocationCount;
    property DeploymentLocations[Index: Integer]: PUMLNode read GetDeploymentLocation;
    property DeploymentLocationCount: Integer read GetDeploymentLocationCount;
  end;

  // PUMLComponent
  PUMLComponent = class(PUMLClassifier)
  private
    FDeploymentLocations: POrderedSet;
    FResidents: POrderedSet;
    FImplementations: POrderedSet;
    function GetDeploymentLocation(Index: Integer): PUMLNode;
    function GetDeploymentLocationCount: Integer;
    function GetResident(Index: Integer): PUMLModelElement;
    function GetResidentCount: Integer;
    function GetImplementation(Index: Integer): PUMLArtifact;
    function GetImplementationCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearDeploymentLocations;
    procedure AddDeploymentLocation(Value: PUMLNode);
    procedure RemoveDeploymentLocation(Value: PUMLNode);
    procedure InsertDeploymentLocation(Index: Integer; Value: PUMLNode);
    procedure DeleteDeploymentLocation(Index: Integer);
    function IndexOfDeploymentLocation(Value: PUMLNode): Integer;
    procedure ClearResidents;
    procedure AddResident(Value: PUMLModelElement);
    procedure RemoveResident(Value: PUMLModelElement);
    procedure InsertResident(Index: Integer; Value: PUMLModelElement);
    procedure DeleteResident(Index: Integer);
    function IndexOfResident(Value: PUMLModelElement): Integer;
    procedure ClearImplementations;
    procedure AddImplementation(Value: PUMLArtifact);
    procedure RemoveImplementation(Value: PUMLArtifact);
    procedure InsertImplementation(Index: Integer; Value: PUMLArtifact);
    procedure DeleteImplementation(Index: Integer);
    function IndexOfImplementation(Value: PUMLArtifact): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property DeploymentLocations[Index: Integer]: PUMLNode read GetDeploymentLocation;
    property DeploymentLocationCount: Integer read GetDeploymentLocationCount;
    property Residents[Index: Integer]: PUMLModelElement read GetResident;
    property ResidentCount: Integer read GetResidentCount;
    property Implementations[Index: Integer]: PUMLArtifact read GetImplementation;
    property ImplementationCount: Integer read GetImplementationCount;
  end;

  // PUMLSignal
  PUMLSignal = class(PUMLClassifier)
  private
    FReceptions: POrderedSet;
    FContexts: POrderedSet;
    FSendActions: POrderedSet;
    FOccurrences: POrderedSet;
    function GetReception(Index: Integer): PUMLReception;
    function GetReceptionCount: Integer;
    function GetContext(Index: Integer): PUMLBehavioralFeature;
    function GetContextCount: Integer;
    function GetSendAction(Index: Integer): PUMLSendAction;
    function GetSendActionCount: Integer;
    function GetOccurrence(Index: Integer): PUMLSignalEvent;
    function GetOccurrenceCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearReceptions;
    procedure AddReception(Value: PUMLReception);
    procedure RemoveReception(Value: PUMLReception);
    procedure InsertReception(Index: Integer; Value: PUMLReception);
    procedure DeleteReception(Index: Integer);
    function IndexOfReception(Value: PUMLReception): Integer;
    procedure ClearContexts;
    procedure AddContext(Value: PUMLBehavioralFeature);
    procedure RemoveContext(Value: PUMLBehavioralFeature);
    procedure InsertContext(Index: Integer; Value: PUMLBehavioralFeature);
    procedure DeleteContext(Index: Integer);
    function IndexOfContext(Value: PUMLBehavioralFeature): Integer;
    procedure ClearSendActions;
    procedure AddSendAction(Value: PUMLSendAction);
    procedure RemoveSendAction(Value: PUMLSendAction);
    procedure InsertSendAction(Index: Integer; Value: PUMLSendAction);
    procedure DeleteSendAction(Index: Integer);
    function IndexOfSendAction(Value: PUMLSendAction): Integer;
    procedure ClearOccurrences;
    procedure AddOccurrence(Value: PUMLSignalEvent);
    procedure RemoveOccurrence(Value: PUMLSignalEvent);
    procedure InsertOccurrence(Index: Integer; Value: PUMLSignalEvent);
    procedure DeleteOccurrence(Index: Integer);
    function IndexOfOccurrence(Value: PUMLSignalEvent): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Receptions[Index: Integer]: PUMLReception read GetReception;
    property ReceptionCount: Integer read GetReceptionCount;
    property Contexts[Index: Integer]: PUMLBehavioralFeature read GetContext;
    property ContextCount: Integer read GetContextCount;
    property SendActions[Index: Integer]: PUMLSendAction read GetSendAction;
    property SendActionCount: Integer read GetSendActionCount;
    property Occurrences[Index: Integer]: PUMLSignalEvent read GetOccurrence;
    property OccurrenceCount: Integer read GetOccurrenceCount;
  end;

  // PUMLException
  PUMLException = class(PUMLSignal)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLClassifierRole
  PUMLClassifierRole = class(PUMLClassifier)
  private
    FMultiplicity: string;
    FBase: PUMLClassifier;
    FAvailableFeatures: POrderedSet;
    FSenderClientMessages: POrderedSet;
    FReceiverClientMessages: POrderedSet;
    FAvailableContents: POrderedSet;
    FConformingInstances: POrderedSet;
    procedure SetMultiplicity(Value: string);
    procedure SetBase(Value: PUMLClassifier);
    function GetAvailableFeature(Index: Integer): PUMLFeature;
    function GetAvailableFeatureCount: Integer;
    function GetSenderClientMessage(Index: Integer): PUMLMessage;
    function GetSenderClientMessageCount: Integer;
    function GetReceiverClientMessage(Index: Integer): PUMLMessage;
    function GetReceiverClientMessageCount: Integer;
    function GetAvailableContent(Index: Integer): PUMLModelElement;
    function GetAvailableContentCount: Integer;
    function GetConformingInstance(Index: Integer): PUMLInstance;
    function GetConformingInstanceCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearAvailableFeatures;
    procedure AddAvailableFeature(Value: PUMLFeature);
    procedure RemoveAvailableFeature(Value: PUMLFeature);
    procedure InsertAvailableFeature(Index: Integer; Value: PUMLFeature);
    procedure DeleteAvailableFeature(Index: Integer);
    function IndexOfAvailableFeature(Value: PUMLFeature): Integer;
    procedure ClearSenderClientMessages;
    procedure AddSenderClientMessage(Value: PUMLMessage);
    procedure RemoveSenderClientMessage(Value: PUMLMessage);
    procedure InsertSenderClientMessage(Index: Integer; Value: PUMLMessage);
    procedure DeleteSenderClientMessage(Index: Integer);
    function IndexOfSenderClientMessage(Value: PUMLMessage): Integer;
    procedure ClearReceiverClientMessages;
    procedure AddReceiverClientMessage(Value: PUMLMessage);
    procedure RemoveReceiverClientMessage(Value: PUMLMessage);
    procedure InsertReceiverClientMessage(Index: Integer; Value: PUMLMessage);
    procedure DeleteReceiverClientMessage(Index: Integer);
    function IndexOfReceiverClientMessage(Value: PUMLMessage): Integer;
    procedure ClearAvailableContents;
    procedure AddAvailableContent(Value: PUMLModelElement);
    procedure RemoveAvailableContent(Value: PUMLModelElement);
    procedure InsertAvailableContent(Index: Integer; Value: PUMLModelElement);
    procedure DeleteAvailableContent(Index: Integer);
    function IndexOfAvailableContent(Value: PUMLModelElement): Integer;
    procedure ClearConformingInstances;
    procedure AddConformingInstance(Value: PUMLInstance);
    procedure RemoveConformingInstance(Value: PUMLInstance);
    procedure InsertConformingInstance(Index: Integer; Value: PUMLInstance);
    procedure DeleteConformingInstance(Index: Integer);
    function IndexOfConformingInstance(Value: PUMLInstance): Integer;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Multiplicity: string read FMultiplicity write SetMultiplicity;
    property Base: PUMLClassifier read FBase write SetBase;
    property AvailableFeatures[Index: Integer]: PUMLFeature read GetAvailableFeature;
    property AvailableFeatureCount: Integer read GetAvailableFeatureCount;
    property SenderClientMessages[Index: Integer]: PUMLMessage read GetSenderClientMessage;
    property SenderClientMessageCount: Integer read GetSenderClientMessageCount;
    property ReceiverClientMessages[Index: Integer]: PUMLMessage read GetReceiverClientMessage;
    property ReceiverClientMessageCount: Integer read GetReceiverClientMessageCount;
    property AvailableContents[Index: Integer]: PUMLModelElement read GetAvailableContent;
    property AvailableContentCount: Integer read GetAvailableContentCount;
    property ConformingInstances[Index: Integer]: PUMLInstance read GetConformingInstance;
    property ConformingInstanceCount: Integer read GetConformingInstanceCount;
  end;

  // PUMLEvent
  PUMLEvent = class(PUMLModelElement)
  private
    FParameters: POrderedSet;
    FStates: POrderedSet;
    FTransition: PUMLTransition;
    function GetParameter(Index: Integer): PUMLParameter;
    function GetParameterCount: Integer;
    function GetState(Index: Integer): PUMLState;
    function GetStateCount: Integer;
    procedure SetTransition(Value: PUMLTransition);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearParameters;
    procedure AddParameter(Value: PUMLParameter);
    procedure RemoveParameter(Value: PUMLParameter);
    procedure InsertParameter(Index: Integer; Value: PUMLParameter);
    procedure DeleteParameter(Index: Integer);
    function IndexOfParameter(Value: PUMLParameter): Integer;
    procedure ClearStates;
    procedure AddState(Value: PUMLState);
    procedure RemoveState(Value: PUMLState);
    procedure InsertState(Index: Integer; Value: PUMLState);
    procedure DeleteState(Index: Integer);
    function IndexOfState(Value: PUMLState): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Parameters[Index: Integer]: PUMLParameter read GetParameter;
    property ParameterCount: Integer read GetParameterCount;
    property States[Index: Integer]: PUMLState read GetState;
    property StateCount: Integer read GetStateCount;
    property Transition: PUMLTransition read FTransition write SetTransition;
  end;

  // PUMLChangeEvent
  PUMLChangeEvent = class(PUMLEvent)
  private
    FChangeExpression: string;
    procedure SetChangeExpression(Value: string);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property ChangeExpression: string read FChangeExpression write SetChangeExpression;
  end;

  // PUMLSignalEvent
  PUMLSignalEvent = class(PUMLEvent)
  private
    FSignal: PUMLSignal;
    procedure SetSignal(Value: PUMLSignal);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Signal: PUMLSignal read FSignal write SetSignal;
  end;

  // PUMLTimeEvent
  PUMLTimeEvent = class(PUMLEvent)
  private
    FWhen: string;
    procedure SetWhen(Value: string);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property When: string read FWhen write SetWhen;
  end;

  // PUMLCallEvent
  PUMLCallEvent = class(PUMLEvent)
  private
    FOperation: PUMLOperation;
    procedure SetOperation(Value: PUMLOperation);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Operation: PUMLOperation read FOperation write SetOperation;
  end;

  // PUMLEnumerationLiteral
  PUMLEnumerationLiteral = class(PUMLModelElement)
  private
    FEnumeration: PUMLEnumeration;
    procedure SetEnumeration(Value: PUMLEnumeration);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Enumeration: PUMLEnumeration read FEnumeration write SetEnumeration;
  end;

  // PUMLStimulus
  PUMLStimulus = class(PUMLModelElement)
  private
    FArguments: string;
    FReturn: string;
    FIteration: string;
    FBranch: string;
    FSender: PUMLInstance;
    FReceiver: PUMLInstance;
    FCommunicationLink: PUMLLink;
    FAction: PUMLAction;
    FActivator: PUMLStimulus;
    FActivatees: POrderedSet;
    FPredecessor: PUMLStimulus;
    FSuccessor: PUMLStimulus;
    FPlayedRoles: POrderedSet;
    FInteractionInstanceSet: PUMLInteractionInstanceSet;
    procedure SetArguments(Value: string);
    procedure SetReturn(Value: string);
    procedure SetIteration(Value: string);
    procedure SetBranch(Value: string);
    procedure SetSender(Value: PUMLInstance);
    procedure SetReceiver(Value: PUMLInstance);
    procedure SetCommunicationLink(Value: PUMLLink);
    procedure SetAction(Value: PUMLAction);
    procedure SetActivator(Value: PUMLStimulus);
    function GetActivatee(Index: Integer): PUMLStimulus;
    function GetActivateeCount: Integer;
    procedure SetPredecessor(Value: PUMLStimulus);
    procedure SetSuccessor(Value: PUMLStimulus);
    function GetPlayedRole(Index: Integer): PUMLMessage;
    function GetPlayedRoleCount: Integer;
    procedure SetInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearActivatees;
    procedure AddActivatee(Value: PUMLStimulus);
    procedure RemoveActivatee(Value: PUMLStimulus);
    procedure InsertActivatee(Index: Integer; Value: PUMLStimulus);
    procedure DeleteActivatee(Index: Integer);
    function IndexOfActivatee(Value: PUMLStimulus): Integer;
    procedure ClearPlayedRoles;
    procedure AddPlayedRole(Value: PUMLMessage);
    procedure RemovePlayedRole(Value: PUMLMessage);
    procedure InsertPlayedRole(Index: Integer; Value: PUMLMessage);
    procedure DeletePlayedRole(Index: Integer);
    function IndexOfPlayedRole(Value: PUMLMessage): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function CanCopy: Boolean; override;
    function CanPaste(Kind: string; CopyContext: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Arguments: string read FArguments write SetArguments;
    property Return: string read FReturn write SetReturn;
    property Iteration: string read FIteration write SetIteration;
    property Branch: string read FBranch write SetBranch;
    property Sender: PUMLInstance read FSender write SetSender;
    property Receiver: PUMLInstance read FReceiver write SetReceiver;
    property CommunicationLink: PUMLLink read FCommunicationLink write SetCommunicationLink;
    property Action: PUMLAction read FAction write SetAction;
    property Activator: PUMLStimulus read FActivator write SetActivator;
    property Activatees[Index: Integer]: PUMLStimulus read GetActivatee;
    property ActivateeCount: Integer read GetActivateeCount;
    property Predecessor: PUMLStimulus read FPredecessor write SetPredecessor;
    property Successor: PUMLStimulus read FSuccessor write SetSuccessor;
    property PlayedRoles[Index: Integer]: PUMLMessage read GetPlayedRole;
    property PlayedRoleCount: Integer read GetPlayedRoleCount;
    property InteractionInstanceSet: PUMLInteractionInstanceSet read FInteractionInstanceSet write SetInteractionInstanceSet;
  end;

  // PUMLAttributeLink
  PUMLAttributeLink = class(PUMLModelElement)
  private
    FValueExpression: string;
    FAttribute: PUMLAttribute;
    FValue_: PUMLInstance;
    FInstance: PUMLInstance;
    FLinkEnd: PUMLLinkEnd;
    procedure SetValueExpression(Value: string);
    procedure SetAttribute(Value: PUMLAttribute);
    procedure SetValue_(Value: PUMLInstance);
    procedure SetInstance(Value: PUMLInstance);
    procedure SetLinkEnd(Value: PUMLLinkEnd);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property ValueExpression: string read FValueExpression write SetValueExpression;
    property Attribute: PUMLAttribute read FAttribute write SetAttribute;
    property Value_: PUMLInstance read FValue_ write SetValue_;
    property Instance: PUMLInstance read FInstance write SetInstance;
    property LinkEnd: PUMLLinkEnd read FLinkEnd write SetLinkEnd;
  end;

  // PUMLGeneralization
  PUMLGeneralization = class(PUMLRelationship)
  private
    FDiscriminator: string;
    FChild: PUMLGeneralizableElement;
    FParent: PUMLGeneralizableElement;
    FPowertype: PUMLClassifier;
    procedure SetDiscriminator(Value: string);
    procedure SetChild(Value: PUMLGeneralizableElement);
    procedure SetParent(Value: PUMLGeneralizableElement);
    procedure SetPowertype(Value: PUMLClassifier);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    function FindRelatedModel(FirstElement: PModel): PModel; override;

    property Discriminator: string read FDiscriminator write SetDiscriminator;
    property Child: PUMLGeneralizableElement read FChild write SetChild;
    property Parent: PUMLGeneralizableElement read FParent write SetParent;
    property Powertype: PUMLClassifier read FPowertype write SetPowertype;
  end;

  // PUMLInclude
  PUMLInclude = class(PUMLRelationship)
  private
    FAddition: PUMLUseCase;
    FBase: PUMLUseCase;
    procedure SetAddition(Value: PUMLUseCase);
    procedure SetBase(Value: PUMLUseCase);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    function FindRelatedModel(FirstElement: PModel): PModel; override;
    property Addition: PUMLUseCase read FAddition write SetAddition;
    property Base: PUMLUseCase read FBase write SetBase;
  end;

  // PUMLDependency
  PUMLDependency = class(PUMLRelationship)
  private
    FMapping: string;
    FClient: PUMLModelElement;
    FSupplier: PUMLModelElement;
    procedure SetMapping(Value: string);
    procedure SetClient(Value: PUMLModelElement);
    procedure SetSupplier(Value: PUMLModelElement);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    function FindRelatedModel(FirstElement: PModel): PModel; override;

    property Mapping: string read FMapping write SetMapping;
    property Client: PUMLModelElement read FClient write SetClient;
    property Supplier: PUMLModelElement read FSupplier write SetSupplier;
  end;

  // PUMLRealization
  PUMLRealization = class(PUMLDependency)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLExtend
  PUMLExtend = class(PUMLRelationship)
  private
    FCondition: string;
    FBase: PUMLUseCase;
    FExtension: PUMLUseCase;
    FExtensionPoints: POrderedSet;
    procedure SetCondition(Value: string);
    procedure SetBase(Value: PUMLUseCase);
    procedure SetExtension(Value: PUMLUseCase);
    function GetExtensionPoint(Index: Integer): PUMLExtensionPoint;
    function GetExtensionPointCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearExtensionPoints;
    procedure AddExtensionPoint(Value: PUMLExtensionPoint);
    procedure RemoveExtensionPoint(Value: PUMLExtensionPoint);
    procedure InsertExtensionPoint(Index: Integer; Value: PUMLExtensionPoint);
    procedure DeleteExtensionPoint(Index: Integer);
    function IndexOfExtensionPoint(Value: PUMLExtensionPoint): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    function FindRelatedModel(FirstElement: PModel): PModel; override;

    property Condition: string read FCondition write SetCondition;
    property Base: PUMLUseCase read FBase write SetBase;
    property Extension: PUMLUseCase read FExtension write SetExtension;
    property ExtensionPoints[Index: Integer]: PUMLExtensionPoint read GetExtensionPoint;
    property ExtensionPointCount: Integer read GetExtensionPointCount;
  end;

  // PUMLAssociation
  PUMLAssociation = class(PUMLRelationship)
  private
    FConnections: POrderedSet;
    FAssociationClass: PUMLAssociationClass;
    FLinks: POrderedSet;
    FAssociationRoles: POrderedSet;
    function GetConnection(Index: Integer): PUMLAssociationEnd;
    function GetConnectionCount: Integer;
    procedure SetAssociationClass(Value: PUMLAssociationClass);
    function GetLink(Index: Integer): PUMLLink;
    function GetLinkCount: Integer;
    function GetAssociationRole(Index: Integer): PUMLAssociationRole;
    function GetAssociationRoleCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearConnections;
    procedure AddConnection(Value: PUMLAssociationEnd);
    procedure RemoveConnection(Value: PUMLAssociationEnd);
    procedure InsertConnection(Index: Integer; Value: PUMLAssociationEnd);
    procedure DeleteConnection(Index: Integer);
    function IndexOfConnection(Value: PUMLAssociationEnd): Integer;
    procedure ClearLinks;
    procedure AddLink(Value: PUMLLink);
    procedure RemoveLink(Value: PUMLLink);
    procedure InsertLink(Index: Integer; Value: PUMLLink);
    procedure DeleteLink(Index: Integer);
    function IndexOfLink(Value: PUMLLink): Integer;
    procedure ClearAssociationRoles;
    procedure AddAssociationRole(Value: PUMLAssociationRole);
    procedure RemoveAssociationRole(Value: PUMLAssociationRole);
    procedure InsertAssociationRole(Index: Integer; Value: PUMLAssociationRole);
    procedure DeleteAssociationRole(Index: Integer);
    function IndexOfAssociationRole(Value: PUMLAssociationRole): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    function FindRelatedModel(FirstElement: PModel): PModel; override;

    property Connections[Index: Integer]: PUMLAssociationEnd read GetConnection;
    property ConnectionCount: Integer read GetConnectionCount;
    property AssociationClass: PUMLAssociationClass read FAssociationClass write SetAssociationClass;
    property Links[Index: Integer]: PUMLLink read GetLink;
    property LinkCount: Integer read GetLinkCount;
    property AssociationRoles[Index: Integer]: PUMLAssociationRole read GetAssociationRole;
    property AssociationRoleCount: Integer read GetAssociationRoleCount;
  end;

  // PUMLAssociationRole
  PUMLAssociationRole = class(PUMLAssociation)
  private
    FMultiplicity: string;
    FBase: PUMLAssociation;
    FMessages: POrderedSet;
    FConformingLinks: POrderedSet;
    procedure SetMultiplicity(Value: string);
    procedure SetBase(Value: PUMLAssociation);
    function GetMessage(Index: Integer): PUMLMessage;
    function GetMessageCount: Integer;
    function GetConformingLink(Index: Integer): PUMLLink;
    function GetConformingLinkCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearMessages;
    procedure AddMessage(Value: PUMLMessage);
    procedure RemoveMessage(Value: PUMLMessage);
    procedure InsertMessage(Index: Integer; Value: PUMLMessage);
    procedure DeleteMessage(Index: Integer);
    function IndexOfMessage(Value: PUMLMessage): Integer;
    procedure ClearConformingLinks;
    procedure AddConformingLink(Value: PUMLLink);
    procedure RemoveConformingLink(Value: PUMLLink);
    procedure InsertConformingLink(Index: Integer; Value: PUMLLink);
    procedure DeleteConformingLink(Index: Integer);
    function IndexOfConformingLink(Value: PUMLLink): Integer;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Multiplicity: string read FMultiplicity write SetMultiplicity;
    property Base: PUMLAssociation read FBase write SetBase;
    property Messages[Index: Integer]: PUMLMessage read GetMessage;
    property MessageCount: Integer read GetMessageCount;
    property ConformingLinks[Index: Integer]: PUMLLink read GetConformingLink;
    property ConformingLinkCount: Integer read GetConformingLinkCount;
  end;

  // PUMLAction
  PUMLAction = class(PUMLModelElement)
  private
    FRecurrence: string;
    FTarget: string;
    FIsAsynchronous: Boolean;
    FScript: string;
    FActualArguments: POrderedSet;
    FActionSequence: PUMLActionSequence;
    FStimulus: PUMLStimulus;
    FEntryState: PUMLState;
    FExitState: PUMLState;
    FTransition: PUMLTransition;
    FDoActivityState: PUMLState;
    FMessage: PUMLMessage;
    procedure SetRecurrence(Value: string);
    procedure SetTarget(Value: string);
    procedure SetIsAsynchronous(Value: Boolean);
    procedure SetScript(Value: string);
    function GetActualArgument(Index: Integer): PUMLArgument;
    function GetActualArgumentCount: Integer;
    procedure SetActionSequence(Value: PUMLActionSequence);
    procedure SetStimulus(Value: PUMLStimulus);
    procedure SetEntryState(Value: PUMLState);
    procedure SetExitState(Value: PUMLState);
    procedure SetTransition(Value: PUMLTransition);
    procedure SetDoActivityState(Value: PUMLState);
    procedure SetMessage(Value: PUMLMessage);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearActualArguments;
    procedure AddActualArgument(Value: PUMLArgument);
    procedure RemoveActualArgument(Value: PUMLArgument);
    procedure InsertActualArgument(Index: Integer; Value: PUMLArgument);
    procedure DeleteActualArgument(Index: Integer);
    function IndexOfActualArgument(Value: PUMLArgument): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function CanCopy: Boolean; override;
    function CanDelete: Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Recurrence: string read FRecurrence write SetRecurrence;
    property Target: string read FTarget write SetTarget;
    property IsAsynchronous: Boolean read FIsAsynchronous write SetIsAsynchronous;
    property Script: string read FScript write SetScript;
    property ActualArguments[Index: Integer]: PUMLArgument read GetActualArgument;
    property ActualArgumentCount: Integer read GetActualArgumentCount;
    property ActionSequence: PUMLActionSequence read FActionSequence write SetActionSequence;
    property Stimulus: PUMLStimulus read FStimulus write SetStimulus;
    property EntryState: PUMLState read FEntryState write SetEntryState;
    property ExitState: PUMLState read FExitState write SetExitState;
    property Transition: PUMLTransition read FTransition write SetTransition;
    property DoActivityState: PUMLState read FDoActivityState write SetDoActivityState;
    property Message: PUMLMessage read FMessage write SetMessage;
  end;

  // PUMLTerminateAction
  PUMLTerminateAction = class(PUMLAction)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLSendAction
  PUMLSendAction = class(PUMLAction)
  private
    FSignal: PUMLSignal;
    procedure SetSignal(Value: PUMLSignal);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Signal: PUMLSignal read FSignal write SetSignal;
  end;

  // PUMLActionSequence
  PUMLActionSequence = class(PUMLAction)
  private
    FActions: POrderedSet;
    function GetAction(Index: Integer): PUMLAction;
    function GetActionCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearActions;
    procedure AddAction(Value: PUMLAction);
    procedure RemoveAction(Value: PUMLAction);
    procedure InsertAction(Index: Integer; Value: PUMLAction);
    procedure DeleteAction(Index: Integer);
    function IndexOfAction(Value: PUMLAction): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Actions[Index: Integer]: PUMLAction read GetAction;
    property ActionCount: Integer read GetActionCount;
  end;

  // PUMLCreateAction
  PUMLCreateAction = class(PUMLAction)
  private
    FInstantiation: PUMLClassifier;
    procedure SetInstantiation(Value: PUMLClassifier);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Instantiation: PUMLClassifier read FInstantiation write SetInstantiation;
  end;

  // PUMLDestroyAction
  PUMLDestroyAction = class(PUMLAction)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLUninterpretedAction
  PUMLUninterpretedAction = class(PUMLAction)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLCallAction
  PUMLCallAction = class(PUMLAction)
  private
    FOperation: PUMLOperation;
    procedure SetOperation(Value: PUMLOperation);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Operation: PUMLOperation read FOperation write SetOperation;
  end;

  // PUMLReturnAction
  PUMLReturnAction = class(PUMLAction)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLFrame
  PUMLFrame = class(PUMLModelElement)
  private
    FFrameKind: string;
    FRepresentedElement: PUMLModelElement;
    FInteraction: PUMLInteraction;
    FInteractionInstanceSet: PUMLInteractionInstanceSet;
    procedure SetFrameKind(Value: string);
    procedure SetRepresentedElement(Value: PUMLModelElement);
    procedure SetInteraction(Value: PUMLInteraction);
    procedure SetInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property FrameKind: string read FFrameKind write SetFrameKind;
    property RepresentedElement: PUMLModelElement read FRepresentedElement write SetRepresentedElement;
    property Interaction: PUMLInteraction read FInteraction write SetInteraction;
    property InteractionInstanceSet: PUMLInteractionInstanceSet read FInteractionInstanceSet write SetInteractionInstanceSet;
  end;

  // PUMLCollaborationInstanceSet
  PUMLCollaborationInstanceSet = class(PUMLModelElement)
  private
    FInteractionInstanceSets: POrderedSet;
    FCollaboration: PUMLCollaboration;
    FParticipatingInstances: POrderedSet;
    FParticipatingLinks: POrderedSet;
    FRepresentedOperation: PUMLOperation;
    FRepresentedClassifier: PUMLClassifier;
    function GetInteractionInstanceSet(Index: Integer): PUMLInteractionInstanceSet;
    function GetInteractionInstanceSetCount: Integer;
    procedure SetCollaboration(Value: PUMLCollaboration);
    function GetParticipatingInstance(Index: Integer): PUMLInstance;
    function GetParticipatingInstanceCount: Integer;
    function GetParticipatingLink(Index: Integer): PUMLLink;
    function GetParticipatingLinkCount: Integer;
    procedure SetRepresentedOperation(Value: PUMLOperation);
    procedure SetRepresentedClassifier(Value: PUMLClassifier);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearInteractionInstanceSets;
    procedure AddInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
    procedure RemoveInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
    procedure InsertInteractionInstanceSet(Index: Integer; Value: PUMLInteractionInstanceSet);
    procedure DeleteInteractionInstanceSet(Index: Integer);
    function IndexOfInteractionInstanceSet(Value: PUMLInteractionInstanceSet): Integer;
    procedure ClearParticipatingInstances;
    procedure AddParticipatingInstance(Value: PUMLInstance);
    procedure RemoveParticipatingInstance(Value: PUMLInstance);
    procedure InsertParticipatingInstance(Index: Integer; Value: PUMLInstance);
    procedure DeleteParticipatingInstance(Index: Integer);
    function IndexOfParticipatingInstance(Value: PUMLInstance): Integer;
    procedure ClearParticipatingLinks;
    procedure AddParticipatingLink(Value: PUMLLink);
    procedure RemoveParticipatingLink(Value: PUMLLink);
    procedure InsertParticipatingLink(Index: Integer; Value: PUMLLink);
    procedure DeleteParticipatingLink(Index: Integer);
    function IndexOfParticipatingLink(Value: PUMLLink): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property InteractionInstanceSets[Index: Integer]: PUMLInteractionInstanceSet read GetInteractionInstanceSet;
    property InteractionInstanceSetCount: Integer read GetInteractionInstanceSetCount;
    property Collaboration: PUMLCollaboration read FCollaboration write SetCollaboration;
    property ParticipatingInstances[Index: Integer]: PUMLInstance read GetParticipatingInstance;
    property ParticipatingInstanceCount: Integer read GetParticipatingInstanceCount;
    property ParticipatingLinks[Index: Integer]: PUMLLink read GetParticipatingLink;
    property ParticipatingLinkCount: Integer read GetParticipatingLinkCount;
    property RepresentedOperation: PUMLOperation read FRepresentedOperation write SetRepresentedOperation;
    property RepresentedClassifier: PUMLClassifier read FRepresentedClassifier write SetRepresentedClassifier;
  end;

  // PUMLParameter
  PUMLParameter = class(PUMLModelElement)
  private
    FDefaultValue: string;
    FDirectionKind: PUMLParameterDirectionKind;
    FTypeExpression: string;
    FBehavioralFeature: PUMLBehavioralFeature;
    FType_: PUMLClassifier;
    FEvent: PUMLEvent;
    FStates: POrderedSet;
    procedure SetDefaultValue(Value: string);
    procedure SetDirectionKind(Value: PUMLParameterDirectionKind);
    procedure SetTypeExpression(Value: string);
    procedure SetBehavioralFeature(Value: PUMLBehavioralFeature);
    procedure SetType_(Value: PUMLClassifier);
    procedure SetEvent(Value: PUMLEvent);
    function GetState(Index: Integer): PUMLObjectFlowState;
    function GetStateCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearStates;
    procedure AddState(Value: PUMLObjectFlowState);
    procedure RemoveState(Value: PUMLObjectFlowState);
    procedure InsertState(Index: Integer; Value: PUMLObjectFlowState);
    procedure DeleteState(Index: Integer);
    function IndexOfState(Value: PUMLObjectFlowState): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property DefaultValue: string read FDefaultValue write SetDefaultValue;
    property DirectionKind: PUMLParameterDirectionKind read FDirectionKind write SetDirectionKind;
    property TypeExpression: string read FTypeExpression write SetTypeExpression;
    property BehavioralFeature: PUMLBehavioralFeature read FBehavioralFeature write SetBehavioralFeature;
    property Type_: PUMLClassifier read FType_ write SetType_;
    property Event: PUMLEvent read FEvent write SetEvent;
    property States[Index: Integer]: PUMLObjectFlowState read GetState;
    property StateCount: Integer read GetStateCount;
  end;

  // PUMLAssociationEnd
  PUMLAssociationEnd = class(PUMLModelElement)
  private
    FIsNavigable: Boolean;
    FOrdering: PUMLOrderingKind;
    FAggregation: PUMLAggregationKind;
    FTargetScope: PUMLScopeKind;
    FMultiplicity: string;
    FChangeability: PUMLChangeableKind;
    FAssociation: PUMLAssociation;
    FQualifiers: POrderedSet;
    FParticipant: PUMLClassifier;
    FLinkEnds: POrderedSet;
    FAssociationEndRoles: POrderedSet;
    procedure SetIsNavigable(Value: Boolean);
    procedure SetOrdering(Value: PUMLOrderingKind);
    procedure SetAggregation(Value: PUMLAggregationKind);
    procedure SetTargetScope(Value: PUMLScopeKind);
    procedure SetMultiplicity(Value: string);
    procedure SetChangeability(Value: PUMLChangeableKind);
    procedure SetAssociation(Value: PUMLAssociation);
    function GetQualifier(Index: Integer): PUMLAttribute;
    function GetQualifierCount: Integer;
    procedure SetParticipant(Value: PUMLClassifier);
    function GetLinkEnd(Index: Integer): PUMLLinkEnd;
    function GetLinkEndCount: Integer;
    function GetAssociationEndRole(Index: Integer): PUMLAssociationEndRole;
    function GetAssociationEndRoleCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearQualifiers;
    procedure AddQualifier(Value: PUMLAttribute);
    procedure RemoveQualifier(Value: PUMLAttribute);
    procedure InsertQualifier(Index: Integer; Value: PUMLAttribute);
    procedure DeleteQualifier(Index: Integer);
    function IndexOfQualifier(Value: PUMLAttribute): Integer;
    procedure ClearLinkEnds;
    procedure AddLinkEnd(Value: PUMLLinkEnd);
    procedure RemoveLinkEnd(Value: PUMLLinkEnd);
    procedure InsertLinkEnd(Index: Integer; Value: PUMLLinkEnd);
    procedure DeleteLinkEnd(Index: Integer);
    function IndexOfLinkEnd(Value: PUMLLinkEnd): Integer;
    procedure ClearAssociationEndRoles;
    procedure AddAssociationEndRole(Value: PUMLAssociationEndRole);
    procedure RemoveAssociationEndRole(Value: PUMLAssociationEndRole);
    procedure InsertAssociationEndRole(Index: Integer; Value: PUMLAssociationEndRole);
    procedure DeleteAssociationEndRole(Index: Integer);
    function IndexOfAssociationEndRole(Value: PUMLAssociationEndRole): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function CanCopy: Boolean; override;
    function CanDelete: Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property IsNavigable: Boolean read FIsNavigable write SetIsNavigable;
    property Ordering: PUMLOrderingKind read FOrdering write SetOrdering;
    property Aggregation: PUMLAggregationKind read FAggregation write SetAggregation;
    property TargetScope: PUMLScopeKind read FTargetScope write SetTargetScope;
    property Multiplicity: string read FMultiplicity write SetMultiplicity;
    property Changeability: PUMLChangeableKind read FChangeability write SetChangeability;
    property Association: PUMLAssociation read FAssociation write SetAssociation;
    property Qualifiers[Index: Integer]: PUMLAttribute read GetQualifier;
    property QualifierCount: Integer read GetQualifierCount;
    property Participant: PUMLClassifier read FParticipant write SetParticipant;
    property LinkEnds[Index: Integer]: PUMLLinkEnd read GetLinkEnd;
    property LinkEndCount: Integer read GetLinkEndCount;
    property AssociationEndRoles[Index: Integer]: PUMLAssociationEndRole read GetAssociationEndRole;
    property AssociationEndRoleCount: Integer read GetAssociationEndRoleCount;
  end;

  // PUMLAssociationEndRole
  PUMLAssociationEndRole = class(PUMLAssociationEnd)
  private
    FCollaborationMultiplicity: string;
    FBase: PUMLAssociationEnd;
    FAvailableQualifiers: POrderedSet;
    procedure SetCollaborationMultiplicity(Value: string);
    procedure SetBase(Value: PUMLAssociationEnd);
    function GetAvailableQualifier(Index: Integer): PUMLAttribute;
    function GetAvailableQualifierCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearAvailableQualifiers;
    procedure AddAvailableQualifier(Value: PUMLAttribute);
    procedure RemoveAvailableQualifier(Value: PUMLAttribute);
    procedure InsertAvailableQualifier(Index: Integer; Value: PUMLAttribute);
    procedure DeleteAvailableQualifier(Index: Integer);
    function IndexOfAvailableQualifier(Value: PUMLAttribute): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property CollaborationMultiplicity: string read FCollaborationMultiplicity write SetCollaborationMultiplicity;
    property Base: PUMLAssociationEnd read FBase write SetBase;
    property AvailableQualifiers[Index: Integer]: PUMLAttribute read GetAvailableQualifier;
    property AvailableQualifierCount: Integer read GetAvailableQualifierCount;
  end;

  // PUMLTransition
  PUMLTransition = class(PUMLRelationship)
  private
    FGuardCondition: string;
    FEffects: POrderedSet;
    FState: PUMLState;
    FTriggers: POrderedSet;
    FStateMachine: PUMLStateMachine;
    FSource: PUMLStateVertex;
    FTarget: PUMLStateVertex;
    procedure SetGuardCondition(Value: string);
    function GetEffect(Index: Integer): PUMLAction;
    function GetEffectCount: Integer;
    procedure SetState(Value: PUMLState);
    function GetTrigger(Index: Integer): PUMLEvent;
    function GetTriggerCount: Integer;
    procedure SetStateMachine(Value: PUMLStateMachine);
    procedure SetSource(Value: PUMLStateVertex);
    procedure SetTarget(Value: PUMLStateVertex);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearEffects;
    procedure AddEffect(Value: PUMLAction);
    procedure RemoveEffect(Value: PUMLAction);
    procedure InsertEffect(Index: Integer; Value: PUMLAction);
    procedure DeleteEffect(Index: Integer);
    function IndexOfEffect(Value: PUMLAction): Integer;
    procedure ClearTriggers;
    procedure AddTrigger(Value: PUMLEvent);
    procedure RemoveTrigger(Value: PUMLEvent);
    procedure InsertTrigger(Index: Integer; Value: PUMLEvent);
    procedure DeleteTrigger(Index: Integer);
    function IndexOfTrigger(Value: PUMLEvent): Integer;
    function CanContainKind(Kind: string): Boolean; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function CanCopy: Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    function FindRelatedModel(FirstElement: PModel): PModel; override;

    property GuardCondition: string read FGuardCondition write SetGuardCondition;
    property Effects[Index: Integer]: PUMLAction read GetEffect;
    property EffectCount: Integer read GetEffectCount;
    property State: PUMLState read FState write SetState;
    property Triggers[Index: Integer]: PUMLEvent read GetTrigger;
    property TriggerCount: Integer read GetTriggerCount;
    property StateMachine: PUMLStateMachine read FStateMachine write SetStateMachine;
    property Source: PUMLStateVertex read FSource write SetSource;
    property Target: PUMLStateVertex read FTarget write SetTarget;
  end;

  // PUMLExtensionPoint
  PUMLExtensionPoint = class(PUMLModelElement)
  private
    FLocation: string;
    FUseCase: PUMLUseCase;
    FExtends: POrderedSet;
    procedure SetLocation(Value: string);
    procedure SetUseCase(Value: PUMLUseCase);
    function GetExtend(Index: Integer): PUMLExtend;
    function GetExtendCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearExtends;
    procedure AddExtend(Value: PUMLExtend);
    procedure RemoveExtend(Value: PUMLExtend);
    procedure InsertExtend(Index: Integer; Value: PUMLExtend);
    procedure DeleteExtend(Index: Integer);
    function IndexOfExtend(Value: PUMLExtend): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Location: string read FLocation write SetLocation;
    property UseCase: PUMLUseCase read FUseCase write SetUseCase;
    property Extends[Index: Integer]: PUMLExtend read GetExtend;
    property ExtendCount: Integer read GetExtendCount;
  end;

  // PUMLLink
  PUMLLink = class(PUMLGeneralization)
  private
    FAssociation: PUMLAssociation;
    FConnections: POrderedSet;
    FStimuli: POrderedSet;
    FOwner: PUMLInstance;
    FLinkObject: PUMLLinkObject;
    FPlayedRoles: POrderedSet;
    FCollaborationInstanceSet: PUMLCollaborationInstanceSet;
    procedure SetAssociation(Value: PUMLAssociation);
    function GetConnection(Index: Integer): PUMLLinkEnd;
    function GetConnectionCount: Integer;
    function GetStimulus(Index: Integer): PUMLStimulus;
    function GetStimulusCount: Integer;
    procedure SetOwner(Value: PUMLInstance);
    procedure SetLinkObject(Value: PUMLLinkObject);
    function GetPlayedRole(Index: Integer): PUMLAssociationRole;
    function GetPlayedRoleCount: Integer;
    procedure SetCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearConnections;
    procedure AddConnection(Value: PUMLLinkEnd);
    procedure RemoveConnection(Value: PUMLLinkEnd);
    procedure InsertConnection(Index: Integer; Value: PUMLLinkEnd);
    procedure DeleteConnection(Index: Integer);
    function IndexOfConnection(Value: PUMLLinkEnd): Integer;
    procedure ClearStimuli;
    procedure AddStimulus(Value: PUMLStimulus);
    procedure RemoveStimulus(Value: PUMLStimulus);
    procedure InsertStimulus(Index: Integer; Value: PUMLStimulus);
    procedure DeleteStimulus(Index: Integer);
    function IndexOfStimulus(Value: PUMLStimulus): Integer;
    procedure ClearPlayedRoles;
    procedure AddPlayedRole(Value: PUMLAssociationRole);
    procedure RemovePlayedRole(Value: PUMLAssociationRole);
    procedure InsertPlayedRole(Index: Integer; Value: PUMLAssociationRole);
    procedure DeletePlayedRole(Index: Integer);
    function IndexOfPlayedRole(Value: PUMLAssociationRole): Integer;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    function FindRelatedModel(FirstElement: PModel): PModel; override;

    property Association: PUMLAssociation read FAssociation write SetAssociation;
    property Connections[Index: Integer]: PUMLLinkEnd read GetConnection;
    property ConnectionCount: Integer read GetConnectionCount;
    property Stimuli[Index: Integer]: PUMLStimulus read GetStimulus;
    property StimulusCount: Integer read GetStimulusCount;
    property Owner: PUMLInstance read FOwner write SetOwner;
    property LinkObject: PUMLLinkObject read FLinkObject write SetLinkObject;
    property PlayedRoles[Index: Integer]: PUMLAssociationRole read GetPlayedRole;
    property PlayedRoleCount: Integer read GetPlayedRoleCount;
    property CollaborationInstanceSet: PUMLCollaborationInstanceSet read FCollaborationInstanceSet write SetCollaborationInstanceSet;
  end;

  // PUMLComment
  PUMLComment = class(PUMLModelElement)
  private
    FBody: string;
    FAnnotatedElements: POrderedSet;
    procedure SetBody(Value: string);
    function GetAnnotatedElement(Index: Integer): PUMLModelElement;
    function GetAnnotatedElementCount: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure ClearAnnotatedElements;
    procedure AddAnnotatedElement(Value: PUMLModelElement);
    procedure RemoveAnnotatedElement(Value: PUMLModelElement);
    procedure InsertAnnotatedElement(Index: Integer; Value: PUMLModelElement);
    procedure DeleteAnnotatedElement(Index: Integer);
    function IndexOfAnnotatedElement(Value: PUMLModelElement): Integer;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Body: string read FBody write SetBody;
    property AnnotatedElements[Index: Integer]: PUMLModelElement read GetAnnotatedElement;
    property AnnotatedElementCount: Integer read GetAnnotatedElementCount;
  end;

  // PUMLTemplateParameter
  PUMLTemplateParameter = class(PUMLElement)
  private
    FParameterType: string;
    FDefaultValue: string;
    FDefaultElement: PUMLModelElement;
    FTemplate: PUMLModelElement;
    FParameter: PUMLModelElement;
    procedure SetParameterType(Value: string);
    procedure SetDefaultValue(Value: string);
    procedure SetDefaultElement(Value: PUMLModelElement);
    procedure SetTemplate(Value: PUMLModelElement);
    procedure SetParameter(Value: PUMLModelElement);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property ParameterType: string read FParameterType write SetParameterType;
    property DefaultValue: string read FDefaultValue write SetDefaultValue;
    property DefaultElement: PUMLModelElement read FDefaultElement write SetDefaultElement;
    property Template: PUMLModelElement read FTemplate write SetTemplate;
    property Parameter: PUMLModelElement read FParameter write SetParameter;
  end;

  // PUMLTemplateArgument
  PUMLTemplateArgument = class(PUMLElement)
  private
    FModelElement: PUMLModelElement;
    procedure SetModelElement(Value: PUMLModelElement);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property ModelElement: PUMLModelElement read FModelElement write SetModelElement;
  end;

  // PUMLElementImport
  PUMLElementImport = class(PUMLElement)
  private
    FVisibility: PUMLVisibilityKind;
    FAlias: string;
    FIsSpecification: Boolean;
    FImportedElement: PUMLModelElement;
    FPackage: PUMLPackage;
    procedure SetVisibility(Value: PUMLVisibilityKind);
    procedure SetAlias(Value: string);
    procedure SetIsSpecification(Value: Boolean);
    procedure SetImportedElement(Value: PUMLModelElement);
    procedure SetPackage(Value: PUMLPackage);
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property Visibility: PUMLVisibilityKind read FVisibility write SetVisibility;
    property Alias: string read FAlias write SetAlias;
    property IsSpecification: Boolean read FIsSpecification write SetIsSpecification;
    property ImportedElement: PUMLModelElement read FImportedElement write SetImportedElement;
    property Package: PUMLPackage read FPackage write SetPackage;
  end;

  // PUMLDiagram
  PUMLDiagram = class(PDiagram)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLDeploymentDiagram
  PUMLDeploymentDiagram = class(PUMLDiagram)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLComponentDiagram
  PUMLComponentDiagram = class(PUMLDiagram)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLSequenceDiagram
  PUMLSequenceDiagram = class(PUMLDiagram)
  private
    FShowSequenceNumber: Boolean;
    FMessageSignature: PUMLMessageSignatureKind;
    FShowActivation: Boolean;
    procedure SetShowSequenceNumber(Value: Boolean);
    procedure SetMessageSignature(Value: PUMLMessageSignatureKind);
    procedure SetShowActivation(Value: Boolean);
  public
    constructor Create; override;
    destructor Destroy; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function CanCopy: Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property ShowSequenceNumber: Boolean read FShowSequenceNumber write SetShowSequenceNumber;
    property MessageSignature: PUMLMessageSignatureKind read FMessageSignature write SetMessageSignature;
    property ShowActivation: Boolean read FShowActivation write SetShowActivation;
  end;

  // PUMLCollaborationDiagram
  PUMLCollaborationDiagram = class(PUMLDiagram)
  private
    FShowSequenceNumber: Boolean;
    FMessageSignature: PUMLMessageSignatureKind;
    procedure SetShowSequenceNumber(Value: Boolean);
    procedure SetMessageSignature(Value: PUMLMessageSignatureKind);
  public
    constructor Create; override;
    destructor Destroy; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function CanCopy: Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property ShowSequenceNumber: Boolean read FShowSequenceNumber write SetShowSequenceNumber;
    property MessageSignature: PUMLMessageSignatureKind read FMessageSignature write SetMessageSignature;
  end;

  // PUMLSequenceRoleDiagram
  PUMLSequenceRoleDiagram = class(PUMLDiagram)
  private
    FShowSequenceNumber: Boolean;
    FMessageSignature: PUMLMessageSignatureKind;
    FShowActivation: Boolean;
    procedure SetShowSequenceNumber(Value: Boolean);
    procedure SetMessageSignature(Value: PUMLMessageSignatureKind);
    procedure SetShowActivation(Value: Boolean);
  public
    constructor Create; override;
    destructor Destroy; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function CanCopy: Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property ShowSequenceNumber: Boolean read FShowSequenceNumber write SetShowSequenceNumber;
    property MessageSignature: PUMLMessageSignatureKind read FMessageSignature write SetMessageSignature;
    property ShowActivation: Boolean read FShowActivation write SetShowActivation;
  end;

  // PUMLUseCaseDiagram
  PUMLUseCaseDiagram = class(PUMLDiagram)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLClassDiagram
  PUMLClassDiagram = class(PUMLDiagram)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLActivityDiagram
  PUMLActivityDiagram = class(PUMLDiagram)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLCollaborationRoleDiagram
  PUMLCollaborationRoleDiagram = class(PUMLDiagram)
  private
    FShowSequenceNumber: Boolean;
    FMessageSignature: PUMLMessageSignatureKind;
    procedure SetShowSequenceNumber(Value: Boolean);
    procedure SetMessageSignature(Value: PUMLMessageSignatureKind);
  public
    constructor Create; override;
    destructor Destroy; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function CanCopy: Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
    property ShowSequenceNumber: Boolean read FShowSequenceNumber write SetShowSequenceNumber;
    property MessageSignature: PUMLMessageSignatureKind read FMessageSignature write SetMessageSignature;
  end;

  // PUMLCompositeStructureDiagram
  PUMLCompositeStructureDiagram = class(PUMLDiagram)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // PUMLStatechartDiagram
  PUMLStatechartDiagram = class(PUMLDiagram)
  private
  public
    constructor Create; override;
    destructor Destroy; override;
    function CanRelocateTo(Model: PModel): Boolean; override;
    function MOF_GetAttribute(Name: string): string; override;
    procedure MOF_SetAttribute(Name, Value: string); override;
    function MOF_GetReference(Name: string): PElement; override;
    procedure MOF_SetReference(Name: string; Value: PElement); override;
    procedure MOF_AddCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_RemoveCollectionItem(Name: string; Value: PElement); override;
    procedure MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement); override;
    procedure MOF_DeleteCollectionItem(Name: string; Index: Integer); override;
    procedure MOF_ClearCollection(Name: string); override;
    function MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer; override;
    function MOF_GetCollectionItem(Name: string; Index: Integer): PElement; override;
    function MOF_GetCollectionCount(Name: string): Integer; override;
  end;

  // Enumeration Conversion Functions
  function UMLAggregationKindToString(Value: PUMLAggregationKind): string;
  function StringToUMLAggregationKind(Value: string): PUMLAggregationKind;
  function UMLCallConcurrencyKindToString(Value: PUMLCallConcurrencyKind): string;
  function StringToUMLCallConcurrencyKind(Value: string): PUMLCallConcurrencyKind;
  function UMLChangeableKindToString(Value: PUMLChangeableKind): string;
  function StringToUMLChangeableKind(Value: string): PUMLChangeableKind;
  function UMLOrderingKindToString(Value: PUMLOrderingKind): string;
  function StringToUMLOrderingKind(Value: string): PUMLOrderingKind;
  function UMLParameterDirectionKindToString(Value: PUMLParameterDirectionKind): string;
  function StringToUMLParameterDirectionKind(Value: string): PUMLParameterDirectionKind;
  function UMLScopeKindToString(Value: PUMLScopeKind): string;
  function StringToUMLScopeKind(Value: string): PUMLScopeKind;
  function UMLVisibilityKindToString(Value: PUMLVisibilityKind): string;
  function StringToUMLVisibilityKind(Value: string): PUMLVisibilityKind;
  function UMLPseudostateKindToString(Value: PUMLPseudostateKind): string;
  function StringToUMLPseudostateKind(Value: string): PUMLPseudostateKind;
  function UMLInteractionOperatorKindToString(Value: PUMLInteractionOperatorKind): string;
  function StringToUMLInteractionOperatorKind(Value: string): PUMLInteractionOperatorKind;
  function UMLMessageSignatureKindToString(Value: PUMLMessageSignatureKind): string;
  function StringToUMLMessageSignatureKind(Value: string): PUMLMessageSignatureKind;

implementation

////////////////////////////////////////////////////////////////////////////////
// PUMLElement

constructor PUMLElement.Create;
begin
  inherited;
end;

destructor PUMLElement.Destroy;
begin
  inherited;
end;

function PUMLElement.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLElement.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLElement.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLElement.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLElement.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLElement.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLElement.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLElement.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLElement.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLElement.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLElement.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLElement.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLElement
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLModelElement

constructor PUMLModelElement.Create;
begin
  inherited;
  FElementImports := POrderedSet.Create;
  FNamespace := nil;
  FClientDependencies := POrderedSet.Create;
  FSupplierDependencies := POrderedSet.Create;
  FDefaultParameters := POrderedSet.Create;
  FComments := POrderedSet.Create;
  FContainer := nil;
  FTemplateParameters := POrderedSet.Create;
  FParameterOwner := nil;
  FTemplateArguments := POrderedSet.Create;
  FBehaviors := POrderedSet.Create;
  FContentRoles := POrderedSet.Create;
  FFrames := POrderedSet.Create;
  FOwnerPartitions := POrderedSet.Create;
end;

destructor PUMLModelElement.Destroy;
begin
  FElementImports.Free;
  FClientDependencies.Free;
  FSupplierDependencies.Free;
  FDefaultParameters.Free;
  FComments.Free;
  FTemplateParameters.Free;
  FTemplateArguments.Free;
  FBehaviors.Free;
  FContentRoles.Free;
  FFrames.Free;
  FOwnerPartitions.Free;
  inherited;
end;

procedure PUMLModelElement.SetVisibility(Value: PUMLVisibilityKind);
begin
  if FVisibility <> Value then
    FVisibility := Value;
end;

procedure PUMLModelElement.SetIsSpecification(Value: Boolean);
begin
  if FIsSpecification <> Value then
    FIsSpecification := Value;
end;

function PUMLModelElement.GetElementImport(Index: Integer): PUMLElementImport;
begin
  Result := FElementImports.Items[Index] as UMLModels.PUMLElementImport;
end;

function PUMLModelElement.GetElementImportCount: Integer;
begin
  Result := FElementImports.Count;
end;

procedure PUMLModelElement.SetNamespace(Value: PUMLNamespace);
begin
  if FNamespace <> Value then begin
    if FNamespace <> nil then begin
      FNamespace.FOwnedElements.Remove(Self);
      FNamespace.RemoveVirtualOwnedModel(Self);
    end;
    FNamespace := Value;
    if Value <> nil then begin
      Value.FOwnedElements.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLModelElement.GetClientDependency(Index: Integer): PUMLDependency;
begin
  Result := FClientDependencies.Items[Index] as UMLModels.PUMLDependency;
end;

function PUMLModelElement.GetClientDependencyCount: Integer;
begin
  Result := FClientDependencies.Count;
end;

function PUMLModelElement.GetSupplierDependency(Index: Integer): PUMLDependency;
begin
  Result := FSupplierDependencies.Items[Index] as UMLModels.PUMLDependency;
end;

function PUMLModelElement.GetSupplierDependencyCount: Integer;
begin
  Result := FSupplierDependencies.Count;
end;

function PUMLModelElement.GetDefaultParameter(Index: Integer): PUMLTemplateParameter;
begin
  Result := FDefaultParameters.Items[Index] as UMLModels.PUMLTemplateParameter;
end;

function PUMLModelElement.GetDefaultParameterCount: Integer;
begin
  Result := FDefaultParameters.Count;
end;

function PUMLModelElement.GetComment(Index: Integer): PUMLComment;
begin
  Result := FComments.Items[Index] as UMLModels.PUMLComment;
end;

function PUMLModelElement.GetCommentCount: Integer;
begin
  Result := FComments.Count;
end;

procedure PUMLModelElement.SetContainer(Value: PUMLComponent);
begin
  if FContainer <> Value then begin
    if FContainer <> nil then Container.FResidents.Remove(Self);
    FContainer := Value;
    if Value <> nil then begin
      Value.FResidents.Add(Self);
    end;
  end;
end;

function PUMLModelElement.GetTemplateParameter(Index: Integer): PUMLTemplateParameter;
begin
  Result := FTemplateParameters.Items[Index] as UMLModels.PUMLTemplateParameter;
end;

function PUMLModelElement.GetTemplateParameterCount: Integer;
begin
  Result := FTemplateParameters.Count;
end;

procedure PUMLModelElement.SetParameterOwner(Value: PUMLTemplateParameter);
begin
  if FParameterOwner <> Value then begin
    if FParameterOwner <> nil then begin
      ParameterOwner.RemoveVirtualOwnedModel(ParameterOwner.FParameter);
      ParameterOwner.FParameter := nil;
    end;
    FParameterOwner := Value;
    if Value <> nil then begin
      Value.FParameter := Self;
      ParameterOwner.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLModelElement.GetTemplateArgument(Index: Integer): PUMLTemplateArgument;
begin
  Result := FTemplateArguments.Items[Index] as UMLModels.PUMLTemplateArgument;
end;

function PUMLModelElement.GetTemplateArgumentCount: Integer;
begin
  Result := FTemplateArguments.Count;
end;

function PUMLModelElement.GetBehavior(Index: Integer): PUMLStateMachine;
begin
  Result := FBehaviors.Items[Index] as UMLModels.PUMLStateMachine;
end;

function PUMLModelElement.GetBehaviorCount: Integer;
begin
  Result := FBehaviors.Count;
end;

function PUMLModelElement.GetContentRole(Index: Integer): PUMLClassifierRole;
begin
  Result := FContentRoles.Items[Index] as UMLModels.PUMLClassifierRole;
end;

function PUMLModelElement.GetContentRoleCount: Integer;
begin
  Result := FContentRoles.Count;
end;

function PUMLModelElement.GetFrame(Index: Integer): PUMLFrame;
begin
  Result := FFrames.Items[Index] as UMLModels.PUMLFrame;
end;

function PUMLModelElement.GetFrameCount: Integer;
begin
  Result := FFrames.Count;
end;

function PUMLModelElement.GetOwnerPartition(Index: Integer): PUMLPartition;
begin
  Result := FOwnerPartitions.Items[Index] as UMLModels.PUMLPartition;
end;

function PUMLModelElement.GetOwnerPartitionCount: Integer;
begin
  Result := FOwnerPartitions.Count;
end;

procedure PUMLModelElement.ClearElementImports;
var
  I: Integer;
begin
  for I := FElementImports.Count - 1 downto 0 do
    DeleteElementImport(I);
end;

procedure PUMLModelElement.AddElementImport(Value: PUMLElementImport);
begin
  if Value <> nil then begin
    if Value.FImportedElement <> nil then Value.FImportedElement.FElementImports.Remove(Value);
    FElementImports.Add(Value);
    Value.FImportedElement := Self;
  end;
end;

procedure PUMLModelElement.RemoveElementImport(Value: PUMLElementImport);
begin
  if Value <> nil then begin
    FElementImports.Remove(Value);
    Value.FImportedElement := nil;
  end;
end;

procedure PUMLModelElement.InsertElementImport(Index: Integer; Value: PUMLElementImport);
begin
  if Value <> nil then begin
    if Value.FImportedElement <> nil then Value.FImportedElement.FElementImports.Remove(Value);
    FElementImports.Insert(Index, Value);
    Value.FImportedElement := Self;
  end;
end;

procedure PUMLModelElement.DeleteElementImport(Index: Integer);
begin
  RemoveElementImport(FElementImports.Items[Index] as UMLModels.PUMLElementImport);
end;

function PUMLModelElement.IndexOfElementImport(Value: PUMLElementImport): Integer;
begin
  Result := FElementImports.IndexOf(Value);
end;

procedure PUMLModelElement.ClearClientDependencies;
var
  I: Integer;
begin
  for I := FClientDependencies.Count - 1 downto 0 do
    DeleteClientDependency(I);
end;

procedure PUMLModelElement.AddClientDependency(Value: PUMLDependency);
begin
  if Value <> nil then begin
    if Value.FClient <> nil then Value.FClient.FClientDependencies.Remove(Value);
    FClientDependencies.Add(Value);
    Value.FClient := Self;
  end;
end;

procedure PUMLModelElement.RemoveClientDependency(Value: PUMLDependency);
begin
  if Value <> nil then begin
    FClientDependencies.Remove(Value);
    Value.FClient := nil;
  end;
end;

procedure PUMLModelElement.InsertClientDependency(Index: Integer; Value: PUMLDependency);
begin
  if Value <> nil then begin
    if Value.FClient <> nil then Value.FClient.FClientDependencies.Remove(Value);
    FClientDependencies.Insert(Index, Value);
    Value.FClient := Self;
  end;
end;

procedure PUMLModelElement.DeleteClientDependency(Index: Integer);
begin
  RemoveClientDependency(FClientDependencies.Items[Index] as UMLModels.PUMLDependency);
end;

function PUMLModelElement.IndexOfClientDependency(Value: PUMLDependency): Integer;
begin
  Result := FClientDependencies.IndexOf(Value);
end;

procedure PUMLModelElement.ClearSupplierDependencies;
var
  I: Integer;
begin
  for I := FSupplierDependencies.Count - 1 downto 0 do
    DeleteSupplierDependency(I);
end;

procedure PUMLModelElement.AddSupplierDependency(Value: PUMLDependency);
begin
  if Value <> nil then begin
    if Value.FSupplier <> nil then Value.FSupplier.FSupplierDependencies.Remove(Value);
    FSupplierDependencies.Add(Value);
    Value.FSupplier := Self;
  end;
end;

procedure PUMLModelElement.RemoveSupplierDependency(Value: PUMLDependency);
begin
  if Value <> nil then begin
    FSupplierDependencies.Remove(Value);
    Value.FSupplier := nil;
  end;
end;

procedure PUMLModelElement.InsertSupplierDependency(Index: Integer; Value: PUMLDependency);
begin
  if Value <> nil then begin
    if Value.FSupplier <> nil then Value.FSupplier.FSupplierDependencies.Remove(Value);
    FSupplierDependencies.Insert(Index, Value);
    Value.FSupplier := Self;
  end;
end;

procedure PUMLModelElement.DeleteSupplierDependency(Index: Integer);
begin
  RemoveSupplierDependency(FSupplierDependencies.Items[Index] as UMLModels.PUMLDependency);
end;

function PUMLModelElement.IndexOfSupplierDependency(Value: PUMLDependency): Integer;
begin
  Result := FSupplierDependencies.IndexOf(Value);
end;

procedure PUMLModelElement.ClearDefaultParameters;
var
  I: Integer;
begin
  for I := FDefaultParameters.Count - 1 downto 0 do
    DeleteDefaultParameter(I);
end;

procedure PUMLModelElement.AddDefaultParameter(Value: PUMLTemplateParameter);
begin
  if Value <> nil then begin
    if Value.FDefaultElement <> nil then Value.FDefaultElement.FDefaultParameters.Remove(Value);
    FDefaultParameters.Add(Value);
    Value.FDefaultElement := Self;
  end;
end;

procedure PUMLModelElement.RemoveDefaultParameter(Value: PUMLTemplateParameter);
begin
  if Value <> nil then begin
    FDefaultParameters.Remove(Value);
    Value.FDefaultElement := nil;
  end;
end;

procedure PUMLModelElement.InsertDefaultParameter(Index: Integer; Value: PUMLTemplateParameter);
begin
  if Value <> nil then begin
    if Value.FDefaultElement <> nil then Value.FDefaultElement.FDefaultParameters.Remove(Value);
    FDefaultParameters.Insert(Index, Value);
    Value.FDefaultElement := Self;
  end;
end;

procedure PUMLModelElement.DeleteDefaultParameter(Index: Integer);
begin
  RemoveDefaultParameter(FDefaultParameters.Items[Index] as UMLModels.PUMLTemplateParameter);
end;

function PUMLModelElement.IndexOfDefaultParameter(Value: PUMLTemplateParameter): Integer;
begin
  Result := FDefaultParameters.IndexOf(Value);
end;

procedure PUMLModelElement.ClearComments;
var
  I: Integer;
begin
  for I := FComments.Count - 1 downto 0 do
    DeleteComment(I);
end;

procedure PUMLModelElement.AddComment(Value: PUMLComment);
begin
  if Value <> nil then begin
    FComments.Add(Value);
    Value.FAnnotatedElements.Add(Self);
  end;
end;

procedure PUMLModelElement.RemoveComment(Value: PUMLComment);
begin
  if Value <> nil then begin
    FComments.Remove(Value);
    Value.FAnnotatedElements.Remove(Self);
  end;
end;

procedure PUMLModelElement.InsertComment(Index: Integer; Value: PUMLComment);
begin
  if Value <> nil then begin
    FComments.Insert(Index, Value);
    Value.FAnnotatedElements.Add(Self);
  end;
end;

procedure PUMLModelElement.DeleteComment(Index: Integer);
begin
  RemoveComment(FComments.Items[Index] as UMLModels.PUMLComment);
end;

function PUMLModelElement.IndexOfComment(Value: PUMLComment): Integer;
begin
  Result := FComments.IndexOf(Value);
end;

procedure PUMLModelElement.ClearTemplateParameters;
var
  I: Integer;
begin
  for I := FTemplateParameters.Count - 1 downto 0 do
    DeleteTemplateParameter(I);
end;

procedure PUMLModelElement.AddTemplateParameter(Value: PUMLTemplateParameter);
begin
  if Value <> nil then begin
    if Value.FTemplate <> nil then begin
      Value.FTemplate.FTemplateParameters.Remove(Value);
      Value.FTemplate.RemoveVirtualOwnedModel(Value);
    end;
    FTemplateParameters.Add(Value);
    Value.FTemplate := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLModelElement.RemoveTemplateParameter(Value: PUMLTemplateParameter);
begin
  if Value <> nil then begin
    FTemplateParameters.Remove(Value);
    Value.FTemplate := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLModelElement.InsertTemplateParameter(Index: Integer; Value: PUMLTemplateParameter);
begin
  if Value <> nil then begin
    if Value.FTemplate <> nil then begin
      Value.FTemplate.FTemplateParameters.Remove(Value);
      Value.FTemplate.RemoveVirtualOwnedModel(Value);
    end;
    FTemplateParameters.Insert(Index, Value);
    Value.FTemplate := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLModelElement.DeleteTemplateParameter(Index: Integer);
begin
  RemoveTemplateParameter(FTemplateParameters.Items[Index] as UMLModels.PUMLTemplateParameter);
end;

function PUMLModelElement.IndexOfTemplateParameter(Value: PUMLTemplateParameter): Integer;
begin
  Result := FTemplateParameters.IndexOf(Value);
end;

procedure PUMLModelElement.ClearTemplateArguments;
var
  I: Integer;
begin
  for I := FTemplateArguments.Count - 1 downto 0 do
    DeleteTemplateArgument(I);
end;

procedure PUMLModelElement.AddTemplateArgument(Value: PUMLTemplateArgument);
begin
  if Value <> nil then begin
    if Value.FModelElement <> nil then Value.FModelElement.FTemplateArguments.Remove(Value);
    FTemplateArguments.Add(Value);
    Value.FModelElement := Self;
  end;
end;

procedure PUMLModelElement.RemoveTemplateArgument(Value: PUMLTemplateArgument);
begin
  if Value <> nil then begin
    FTemplateArguments.Remove(Value);
    Value.FModelElement := nil;
  end;
end;

procedure PUMLModelElement.InsertTemplateArgument(Index: Integer; Value: PUMLTemplateArgument);
begin
  if Value <> nil then begin
    if Value.FModelElement <> nil then Value.FModelElement.FTemplateArguments.Remove(Value);
    FTemplateArguments.Insert(Index, Value);
    Value.FModelElement := Self;
  end;
end;

procedure PUMLModelElement.DeleteTemplateArgument(Index: Integer);
begin
  RemoveTemplateArgument(FTemplateArguments.Items[Index] as UMLModels.PUMLTemplateArgument);
end;

function PUMLModelElement.IndexOfTemplateArgument(Value: PUMLTemplateArgument): Integer;
begin
  Result := FTemplateArguments.IndexOf(Value);
end;

procedure PUMLModelElement.ClearBehaviors;
var
  I: Integer;
begin
  for I := FBehaviors.Count - 1 downto 0 do
    DeleteBehavior(I);
end;

procedure PUMLModelElement.AddBehavior(Value: PUMLStateMachine);
begin
  if Value <> nil then begin
    if Value.FContext <> nil then begin
      Value.FContext.FBehaviors.Remove(Value);
      Value.FContext.RemoveVirtualOwnedModel(Value);
    end;
    FBehaviors.Add(Value);
    Value.FContext := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLModelElement.RemoveBehavior(Value: PUMLStateMachine);
begin
  if Value <> nil then begin
    FBehaviors.Remove(Value);
    Value.FContext := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLModelElement.InsertBehavior(Index: Integer; Value: PUMLStateMachine);
begin
  if Value <> nil then begin
    if Value.FContext <> nil then begin
      Value.FContext.FBehaviors.Remove(Value);
      Value.FContext.RemoveVirtualOwnedModel(Value);
    end;
    FBehaviors.Insert(Index, Value);
    Value.FContext := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLModelElement.DeleteBehavior(Index: Integer);
begin
  RemoveBehavior(FBehaviors.Items[Index] as UMLModels.PUMLStateMachine);
end;

function PUMLModelElement.IndexOfBehavior(Value: PUMLStateMachine): Integer;
begin
  Result := FBehaviors.IndexOf(Value);
end;

procedure PUMLModelElement.ClearContentRoles;
var
  I: Integer;
begin
  for I := FContentRoles.Count - 1 downto 0 do
    DeleteContentRole(I);
end;

procedure PUMLModelElement.AddContentRole(Value: PUMLClassifierRole);
begin
  if Value <> nil then begin
    FContentRoles.Add(Value);
    Value.FAvailableContents.Add(Self);
  end;
end;

procedure PUMLModelElement.RemoveContentRole(Value: PUMLClassifierRole);
begin
  if Value <> nil then begin
    FContentRoles.Remove(Value);
    Value.FAvailableContents.Remove(Self);
  end;
end;

procedure PUMLModelElement.InsertContentRole(Index: Integer; Value: PUMLClassifierRole);
begin
  if Value <> nil then begin
    FContentRoles.Insert(Index, Value);
    Value.FAvailableContents.Add(Self);
  end;
end;

procedure PUMLModelElement.DeleteContentRole(Index: Integer);
begin
  RemoveContentRole(FContentRoles.Items[Index] as UMLModels.PUMLClassifierRole);
end;

function PUMLModelElement.IndexOfContentRole(Value: PUMLClassifierRole): Integer;
begin
  Result := FContentRoles.IndexOf(Value);
end;

procedure PUMLModelElement.ClearFrames;
var
  I: Integer;
begin
  for I := FFrames.Count - 1 downto 0 do
    DeleteFrame(I);
end;

procedure PUMLModelElement.AddFrame(Value: PUMLFrame);
begin
  if Value <> nil then begin
    if Value.FRepresentedElement <> nil then Value.FRepresentedElement.FFrames.Remove(Value);
    FFrames.Add(Value);
    Value.FRepresentedElement := Self;
  end;
end;

procedure PUMLModelElement.RemoveFrame(Value: PUMLFrame);
begin
  if Value <> nil then begin
    FFrames.Remove(Value);
    Value.FRepresentedElement := nil;
  end;
end;

procedure PUMLModelElement.InsertFrame(Index: Integer; Value: PUMLFrame);
begin
  if Value <> nil then begin
    if Value.FRepresentedElement <> nil then Value.FRepresentedElement.FFrames.Remove(Value);
    FFrames.Insert(Index, Value);
    Value.FRepresentedElement := Self;
  end;
end;

procedure PUMLModelElement.DeleteFrame(Index: Integer);
begin
  RemoveFrame(FFrames.Items[Index] as UMLModels.PUMLFrame);
end;

function PUMLModelElement.IndexOfFrame(Value: PUMLFrame): Integer;
begin
  Result := FFrames.IndexOf(Value);
end;

procedure PUMLModelElement.ClearOwnerPartitions;
var
  I: Integer;
begin
  for I := FOwnerPartitions.Count - 1 downto 0 do
    DeleteOwnerPartition(I);
end;

procedure PUMLModelElement.AddOwnerPartition(Value: PUMLPartition);
begin
  if Value <> nil then begin
    FOwnerPartitions.Add(Value);
    Value.FContents.Add(Self);
  end;
end;

procedure PUMLModelElement.RemoveOwnerPartition(Value: PUMLPartition);
begin
  if Value <> nil then begin
    FOwnerPartitions.Remove(Value);
    Value.FContents.Remove(Self);
  end;
end;

procedure PUMLModelElement.InsertOwnerPartition(Index: Integer; Value: PUMLPartition);
begin
  if Value <> nil then begin
    FOwnerPartitions.Insert(Index, Value);
    Value.FContents.Add(Self);
  end;
end;

procedure PUMLModelElement.DeleteOwnerPartition(Index: Integer);
begin
  RemoveOwnerPartition(FOwnerPartitions.Items[Index] as UMLModels.PUMLPartition);
end;

function PUMLModelElement.IndexOfOwnerPartition(Value: PUMLPartition): Integer;
begin
  Result := FOwnerPartitions.IndexOf(Value);
end;

function PUMLModelElement.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Visibility' then begin
    Result := UMLVisibilityKindToString(Visibility);
  end
  else if Name = 'IsSpecification' then begin
    Result := BooleanToString(IsSpecification);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLModelElement.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Visibility' then begin
    Visibility := StringToUMLVisibilityKind(Value);
  end
  else if Name = 'IsSpecification' then begin
    IsSpecification := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLModelElement.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Namespace' then begin
    Result := Namespace;
  end
  else if Name = 'Container' then begin
    Result := Container;
  end
  else if Name = 'ParameterOwner' then begin
    Result := ParameterOwner;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLModelElement.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Namespace' then begin
    Namespace := Value as PUMLNamespace;
  end
  else if Name = 'Container' then begin
    Container := Value as PUMLComponent;
  end
  else if Name = 'ParameterOwner' then begin
    ParameterOwner := Value as PUMLTemplateParameter;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLModelElement.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ElementImports' then begin
    AddElementImport(Value as PUMLElementImport);
  end
  else if Name = 'ClientDependencies' then begin
    AddClientDependency(Value as PUMLDependency);
  end
  else if Name = 'SupplierDependencies' then begin
    AddSupplierDependency(Value as PUMLDependency);
  end
  else if Name = 'DefaultParameters' then begin
    AddDefaultParameter(Value as PUMLTemplateParameter);
  end
  else if Name = 'Comments' then begin
    AddComment(Value as PUMLComment);
  end
  else if Name = 'TemplateParameters' then begin
    AddTemplateParameter(Value as PUMLTemplateParameter);
  end
  else if Name = 'TemplateArguments' then begin
    AddTemplateArgument(Value as PUMLTemplateArgument);
  end
  else if Name = 'Behaviors' then begin
    AddBehavior(Value as PUMLStateMachine);
  end
  else if Name = 'ContentRoles' then begin
    AddContentRole(Value as PUMLClassifierRole);
  end
  else if Name = 'Frames' then begin
    AddFrame(Value as PUMLFrame);
  end
  else if Name = 'OwnerPartitions' then begin
    AddOwnerPartition(Value as PUMLPartition);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLModelElement.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ElementImports' then begin
    RemoveElementImport(Value as PUMLElementImport);
  end
  else if Name = 'ClientDependencies' then begin
    RemoveClientDependency(Value as PUMLDependency);
  end
  else if Name = 'SupplierDependencies' then begin
    RemoveSupplierDependency(Value as PUMLDependency);
  end
  else if Name = 'DefaultParameters' then begin
    RemoveDefaultParameter(Value as PUMLTemplateParameter);
  end
  else if Name = 'Comments' then begin
    RemoveComment(Value as PUMLComment);
  end
  else if Name = 'TemplateParameters' then begin
    RemoveTemplateParameter(Value as PUMLTemplateParameter);
  end
  else if Name = 'TemplateArguments' then begin
    RemoveTemplateArgument(Value as PUMLTemplateArgument);
  end
  else if Name = 'Behaviors' then begin
    RemoveBehavior(Value as PUMLStateMachine);
  end
  else if Name = 'ContentRoles' then begin
    RemoveContentRole(Value as PUMLClassifierRole);
  end
  else if Name = 'Frames' then begin
    RemoveFrame(Value as PUMLFrame);
  end
  else if Name = 'OwnerPartitions' then begin
    RemoveOwnerPartition(Value as PUMLPartition);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLModelElement.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'ElementImports' then begin
    InsertElementImport(Index, Value as PUMLElementImport);
  end
  else if Name = 'ClientDependencies' then begin
    InsertClientDependency(Index, Value as PUMLDependency);
  end
  else if Name = 'SupplierDependencies' then begin
    InsertSupplierDependency(Index, Value as PUMLDependency);
  end
  else if Name = 'DefaultParameters' then begin
    InsertDefaultParameter(Index, Value as PUMLTemplateParameter);
  end
  else if Name = 'Comments' then begin
    InsertComment(Index, Value as PUMLComment);
  end
  else if Name = 'TemplateParameters' then begin
    InsertTemplateParameter(Index, Value as PUMLTemplateParameter);
  end
  else if Name = 'TemplateArguments' then begin
    InsertTemplateArgument(Index, Value as PUMLTemplateArgument);
  end
  else if Name = 'Behaviors' then begin
    InsertBehavior(Index, Value as PUMLStateMachine);
  end
  else if Name = 'ContentRoles' then begin
    InsertContentRole(Index, Value as PUMLClassifierRole);
  end
  else if Name = 'Frames' then begin
    InsertFrame(Index, Value as PUMLFrame);
  end
  else if Name = 'OwnerPartitions' then begin
    InsertOwnerPartition(Index, Value as PUMLPartition);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLModelElement.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'ElementImports' then begin
    DeleteElementImport(Index);
  end
  else if Name = 'ClientDependencies' then begin
    DeleteClientDependency(Index);
  end
  else if Name = 'SupplierDependencies' then begin
    DeleteSupplierDependency(Index);
  end
  else if Name = 'DefaultParameters' then begin
    DeleteDefaultParameter(Index);
  end
  else if Name = 'Comments' then begin
    DeleteComment(Index);
  end
  else if Name = 'TemplateParameters' then begin
    DeleteTemplateParameter(Index);
  end
  else if Name = 'TemplateArguments' then begin
    DeleteTemplateArgument(Index);
  end
  else if Name = 'Behaviors' then begin
    DeleteBehavior(Index);
  end
  else if Name = 'ContentRoles' then begin
    DeleteContentRole(Index);
  end
  else if Name = 'Frames' then begin
    DeleteFrame(Index);
  end
  else if Name = 'OwnerPartitions' then begin
    DeleteOwnerPartition(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLModelElement.MOF_ClearCollection(Name: string);
begin
  if Name = 'ElementImports' then begin
    ClearElementImports;
  end
  else if Name = 'ClientDependencies' then begin
    ClearClientDependencies;
  end
  else if Name = 'SupplierDependencies' then begin
    ClearSupplierDependencies;
  end
  else if Name = 'DefaultParameters' then begin
    ClearDefaultParameters;
  end
  else if Name = 'Comments' then begin
    ClearComments;
  end
  else if Name = 'TemplateParameters' then begin
    ClearTemplateParameters;
  end
  else if Name = 'TemplateArguments' then begin
    ClearTemplateArguments;
  end
  else if Name = 'Behaviors' then begin
    ClearBehaviors;
  end
  else if Name = 'ContentRoles' then begin
    ClearContentRoles;
  end
  else if Name = 'Frames' then begin
    ClearFrames;
  end
  else if Name = 'OwnerPartitions' then begin
    ClearOwnerPartitions;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLModelElement.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'ElementImports' then begin
    Result := IndexOfElementImport(Value as PUMLElementImport);
  end
  else if Name = 'ClientDependencies' then begin
    Result := IndexOfClientDependency(Value as PUMLDependency);
  end
  else if Name = 'SupplierDependencies' then begin
    Result := IndexOfSupplierDependency(Value as PUMLDependency);
  end
  else if Name = 'DefaultParameters' then begin
    Result := IndexOfDefaultParameter(Value as PUMLTemplateParameter);
  end
  else if Name = 'Comments' then begin
    Result := IndexOfComment(Value as PUMLComment);
  end
  else if Name = 'TemplateParameters' then begin
    Result := IndexOfTemplateParameter(Value as PUMLTemplateParameter);
  end
  else if Name = 'TemplateArguments' then begin
    Result := IndexOfTemplateArgument(Value as PUMLTemplateArgument);
  end
  else if Name = 'Behaviors' then begin
    Result := IndexOfBehavior(Value as PUMLStateMachine);
  end
  else if Name = 'ContentRoles' then begin
    Result := IndexOfContentRole(Value as PUMLClassifierRole);
  end
  else if Name = 'Frames' then begin
    Result := IndexOfFrame(Value as PUMLFrame);
  end
  else if Name = 'OwnerPartitions' then begin
    Result := IndexOfOwnerPartition(Value as PUMLPartition);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLModelElement.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'ElementImports' then begin
    Result := ElementImports[Index];
  end
  else if Name = 'ClientDependencies' then begin
    Result := ClientDependencies[Index];
  end
  else if Name = 'SupplierDependencies' then begin
    Result := SupplierDependencies[Index];
  end
  else if Name = 'DefaultParameters' then begin
    Result := DefaultParameters[Index];
  end
  else if Name = 'Comments' then begin
    Result := Comments[Index];
  end
  else if Name = 'TemplateParameters' then begin
    Result := TemplateParameters[Index];
  end
  else if Name = 'TemplateArguments' then begin
    Result := TemplateArguments[Index];
  end
  else if Name = 'Behaviors' then begin
    Result := Behaviors[Index];
  end
  else if Name = 'ContentRoles' then begin
    Result := ContentRoles[Index];
  end
  else if Name = 'Frames' then begin
    Result := Frames[Index];
  end
  else if Name = 'OwnerPartitions' then begin
    Result := OwnerPartitions[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLModelElement.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'ElementImports' then begin
    Result := ElementImportCount;
  end
  else if Name = 'ClientDependencies' then begin
    Result := ClientDependencyCount;
  end
  else if Name = 'SupplierDependencies' then begin
    Result := SupplierDependencyCount;
  end
  else if Name = 'DefaultParameters' then begin
    Result := DefaultParameterCount;
  end
  else if Name = 'Comments' then begin
    Result := CommentCount;
  end
  else if Name = 'TemplateParameters' then begin
    Result := TemplateParameterCount;
  end
  else if Name = 'TemplateArguments' then begin
    Result := TemplateArgumentCount;
  end
  else if Name = 'Behaviors' then begin
    Result := BehaviorCount;
  end
  else if Name = 'ContentRoles' then begin
    Result := ContentRoleCount;
  end
  else if Name = 'Frames' then begin
    Result := FrameCount;
  end
  else if Name = 'OwnerPartitions' then begin
    Result := OwnerPartitionCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLModelElement
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLLinkEnd

constructor PUMLLinkEnd.Create;
begin
  inherited;
  FInstance := nil;
  FLink := nil;
  FAssociationEnd := nil;
  FQualifiedValues := POrderedSet.Create;
end;

destructor PUMLLinkEnd.Destroy;
begin
  FQualifiedValues.Free;
  inherited;
end;

procedure PUMLLinkEnd.SetInstance(Value: PUMLInstance);
begin
  if FInstance <> Value then begin
    if FInstance <> nil then Instance.FLinkEnds.Remove(Self);
    FInstance := Value;
    if Value <> nil then begin
      Value.FLinkEnds.Add(Self);
    end;
  end;
end;

procedure PUMLLinkEnd.SetLink(Value: PUMLLink);
begin
  if FLink <> Value then begin
    if FLink <> nil then begin
      FLink.FConnections.Remove(Self);
      FLink.RemoveVirtualOwnedModel(Self);
    end;
    FLink := Value;
    if Value <> nil then begin
      Value.FConnections.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLLinkEnd.SetAssociationEnd(Value: PUMLAssociationEnd);
begin
  if FAssociationEnd <> Value then begin
    if FAssociationEnd <> nil then AssociationEnd.FLinkEnds.Remove(Self);
    FAssociationEnd := Value;
    if Value <> nil then begin
      Value.FLinkEnds.Add(Self);
    end;
  end;
end;

function PUMLLinkEnd.GetQualifiedValue(Index: Integer): PUMLAttributeLink;
begin
  Result := FQualifiedValues.Items[Index] as UMLModels.PUMLAttributeLink;
end;

function PUMLLinkEnd.GetQualifiedValueCount: Integer;
begin
  Result := FQualifiedValues.Count;
end;

procedure PUMLLinkEnd.ClearQualifiedValues;
var
  I: Integer;
begin
  for I := FQualifiedValues.Count - 1 downto 0 do
    DeleteQualifiedValue(I);
end;

procedure PUMLLinkEnd.AddQualifiedValue(Value: PUMLAttributeLink);
begin
  if Value <> nil then begin
    if Value.FLinkEnd <> nil then begin
      Value.FLinkEnd.FQualifiedValues.Remove(Value);
      Value.FLinkEnd.RemoveVirtualOwnedModel(Value);
    end;
    FQualifiedValues.Add(Value);
    Value.FLinkEnd := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLLinkEnd.RemoveQualifiedValue(Value: PUMLAttributeLink);
begin
  if Value <> nil then begin
    FQualifiedValues.Remove(Value);
    Value.FLinkEnd := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLLinkEnd.InsertQualifiedValue(Index: Integer; Value: PUMLAttributeLink);
begin
  if Value <> nil then begin
    if Value.FLinkEnd <> nil then begin
      Value.FLinkEnd.FQualifiedValues.Remove(Value);
      Value.FLinkEnd.RemoveVirtualOwnedModel(Value);
    end;
    FQualifiedValues.Insert(Index, Value);
    Value.FLinkEnd := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLLinkEnd.DeleteQualifiedValue(Index: Integer);
begin
  RemoveQualifiedValue(FQualifiedValues.Items[Index] as UMLModels.PUMLAttributeLink);
end;

function PUMLLinkEnd.IndexOfQualifiedValue(Value: PUMLAttributeLink): Integer;
begin
  Result := FQualifiedValues.IndexOf(Value);
end;

function PUMLLinkEnd.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLLinkEnd.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLLinkEnd.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Instance' then begin
    Result := Instance;
  end
  else if Name = 'Link' then begin
    Result := Link;
  end
  else if Name = 'AssociationEnd' then begin
    Result := AssociationEnd;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLLinkEnd.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Instance' then begin
    Instance := Value as PUMLInstance;
  end
  else if Name = 'Link' then begin
    Link := Value as PUMLLink;
  end
  else if Name = 'AssociationEnd' then begin
    AssociationEnd := Value as PUMLAssociationEnd;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLLinkEnd.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'QualifiedValues' then begin
    AddQualifiedValue(Value as PUMLAttributeLink);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLLinkEnd.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'QualifiedValues' then begin
    RemoveQualifiedValue(Value as PUMLAttributeLink);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLLinkEnd.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'QualifiedValues' then begin
    InsertQualifiedValue(Index, Value as PUMLAttributeLink);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLLinkEnd.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'QualifiedValues' then begin
    DeleteQualifiedValue(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLLinkEnd.MOF_ClearCollection(Name: string);
begin
  if Name = 'QualifiedValues' then begin
    ClearQualifiedValues;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLLinkEnd.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'QualifiedValues' then begin
    Result := IndexOfQualifiedValue(Value as PUMLAttributeLink);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLLinkEnd.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'QualifiedValues' then begin
    Result := QualifiedValues[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLLinkEnd.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'QualifiedValues' then begin
    Result := QualifiedValueCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLLinkEnd.CanCopy: Boolean;
begin
  Result := False;
end;

function PUMLLinkEnd.CanDelete: Boolean;
begin
  Result := False;
end;

// PUMLLinkEnd
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLLinkObject

constructor PUMLLinkObject.Create;
begin
  inherited;
  FLinkSide := nil;
  FObjectSide := nil;
end;

destructor PUMLLinkObject.Destroy;
begin
  inherited;
end;

procedure PUMLLinkObject.SetLinkSide(Value: PUMLLink);
begin
  if FLinkSide <> Value then begin
    if FLinkSide <> nil then LinkSide.FLinkObject := nil;
    FLinkSide := Value;
    if Value <> nil then Value.FLinkObject := Self;
  end;
end;

procedure PUMLLinkObject.SetObjectSide(Value: PUMLObject);
begin
  if FObjectSide <> Value then begin
    if FObjectSide <> nil then ObjectSide.FLinkObject := nil;
    FObjectSide := Value;
    if Value <> nil then Value.FLinkObject := Self;
  end;
end;

function PUMLLinkObject.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLLinkObject.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLLinkObject.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'LinkSide' then begin
    Result := LinkSide;
  end
  else if Name = 'ObjectSide' then begin
    Result := ObjectSide;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLLinkObject.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'LinkSide' then begin
    LinkSide := Value as PUMLLink;
  end
  else if Name = 'ObjectSide' then begin
    ObjectSide := Value as PUMLObject;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLLinkObject.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLLinkObject.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLLinkObject.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLLinkObject.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLLinkObject.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLLinkObject.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLLinkObject.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLLinkObject.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLLinkObject
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLPartition

constructor PUMLPartition.Create;
begin
  inherited;
  FContents := POrderedSet.Create;
  FActivityGraph := nil;
end;

destructor PUMLPartition.Destroy;
begin
  FContents.Free;
  inherited;
end;

function PUMLPartition.GetContent(Index: Integer): PUMLModelElement;
begin
  Result := FContents.Items[Index] as UMLModels.PUMLModelElement;
end;

function PUMLPartition.GetContentCount: Integer;
begin
  Result := FContents.Count;
end;

procedure PUMLPartition.SetActivityGraph(Value: PUMLActivityGraph);
begin
  if FActivityGraph <> Value then begin
    if FActivityGraph <> nil then begin
      FActivityGraph.FPartitions.Remove(Self);
      FActivityGraph.RemoveVirtualOwnedModel(Self);
    end;
    FActivityGraph := Value;
    if Value <> nil then begin
      Value.FPartitions.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLPartition.ClearContents;
var
  I: Integer;
begin
  for I := FContents.Count - 1 downto 0 do
    DeleteContent(I);
end;

procedure PUMLPartition.AddContent(Value: PUMLModelElement);
begin
  if Value <> nil then begin
    FContents.Add(Value);
    Value.FOwnerPartitions.Add(Self);
  end;
end;

procedure PUMLPartition.RemoveContent(Value: PUMLModelElement);
begin
  if Value <> nil then begin
    FContents.Remove(Value);
    Value.FOwnerPartitions.Remove(Self);
  end;
end;

procedure PUMLPartition.InsertContent(Index: Integer; Value: PUMLModelElement);
begin
  if Value <> nil then begin
    FContents.Insert(Index, Value);
    Value.FOwnerPartitions.Add(Self);
  end;
end;

procedure PUMLPartition.DeleteContent(Index: Integer);
begin
  RemoveContent(FContents.Items[Index] as UMLModels.PUMLModelElement);
end;

function PUMLPartition.IndexOfContent(Value: PUMLModelElement): Integer;
begin
  Result := FContents.IndexOf(Value);
end;

function PUMLPartition.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLPartition.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLPartition.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'ActivityGraph' then begin
    Result := ActivityGraph;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLPartition.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'ActivityGraph' then begin
    ActivityGraph := Value as PUMLActivityGraph;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLPartition.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Contents' then begin
    AddContent(Value as PUMLModelElement);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLPartition.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Contents' then begin
    RemoveContent(Value as PUMLModelElement);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLPartition.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Contents' then begin
    InsertContent(Index, Value as PUMLModelElement);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLPartition.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Contents' then begin
    DeleteContent(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLPartition.MOF_ClearCollection(Name: string);
begin
  if Name = 'Contents' then begin
    ClearContents;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLPartition.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Contents' then begin
    Result := IndexOfContent(Value as PUMLModelElement);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLPartition.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Contents' then begin
    Result := Contents[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLPartition.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Contents' then begin
    Result := ContentCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLPartition
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLInteractionFragment

constructor PUMLInteractionFragment.Create;
begin
  inherited;
  FEnclosingOperand := nil;
  FEnclosingInteraction := nil;
  FEnclosingInteractionInstanceSet := nil;
end;

destructor PUMLInteractionFragment.Destroy;
begin
  inherited;
end;

procedure PUMLInteractionFragment.SetEnclosingOperand(Value: PUMLInteractionOperand);
begin
  if FEnclosingOperand <> Value then begin
    if FEnclosingOperand <> nil then begin
      FEnclosingOperand.FFragments.Remove(Self);
      FEnclosingOperand.RemoveVirtualOwnedModel(Self);
    end;
    FEnclosingOperand := Value;
    if Value <> nil then begin
      Value.FFragments.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLInteractionFragment.SetEnclosingInteraction(Value: PUMLInteraction);
begin
  if FEnclosingInteraction <> Value then begin
    if FEnclosingInteraction <> nil then begin
      FEnclosingInteraction.FFragments.Remove(Self);
      FEnclosingInteraction.RemoveVirtualOwnedModel(Self);
    end;
    FEnclosingInteraction := Value;
    if Value <> nil then begin
      Value.FFragments.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLInteractionFragment.SetEnclosingInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
begin
  if FEnclosingInteractionInstanceSet <> Value then begin
    if FEnclosingInteractionInstanceSet <> nil then begin
      FEnclosingInteractionInstanceSet.FFragments.Remove(Self);
      FEnclosingInteractionInstanceSet.RemoveVirtualOwnedModel(Self);
    end;
    FEnclosingInteractionInstanceSet := Value;
    if Value <> nil then begin
      Value.FFragments.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLInteractionFragment.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLInteractionFragment.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLInteractionFragment.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'EnclosingOperand' then begin
    Result := EnclosingOperand;
  end
  else if Name = 'EnclosingInteraction' then begin
    Result := EnclosingInteraction;
  end
  else if Name = 'EnclosingInteractionInstanceSet' then begin
    Result := EnclosingInteractionInstanceSet;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLInteractionFragment.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'EnclosingOperand' then begin
    EnclosingOperand := Value as PUMLInteractionOperand;
  end
  else if Name = 'EnclosingInteraction' then begin
    EnclosingInteraction := Value as PUMLInteraction;
  end
  else if Name = 'EnclosingInteractionInstanceSet' then begin
    EnclosingInteractionInstanceSet := Value as PUMLInteractionInstanceSet;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLInteractionFragment.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLInteractionFragment.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLInteractionFragment.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLInteractionFragment.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLInteractionFragment.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLInteractionFragment.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLInteractionFragment.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLInteractionFragment.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLInteractionFragment
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLInteractionOperand

constructor PUMLInteractionOperand.Create;
begin
  inherited;
  FCombinedFragment := nil;
  FFragments := POrderedSet.Create;
end;

destructor PUMLInteractionOperand.Destroy;
begin
  FFragments.Free;
  inherited;
end;

procedure PUMLInteractionOperand.SetGuard(Value: string);
begin
  if FGuard <> Value then
    FGuard := Value;
end;

procedure PUMLInteractionOperand.SetCombinedFragment(Value: PUMLCombinedFragment);
begin
  if FCombinedFragment <> Value then begin
    if FCombinedFragment <> nil then begin
      FCombinedFragment.FOperands.Remove(Self);
      FCombinedFragment.RemoveVirtualOwnedModel(Self);
    end;
    FCombinedFragment := Value;
    if Value <> nil then begin
      Value.FOperands.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLInteractionOperand.GetFragment(Index: Integer): PUMLInteractionFragment;
begin
  Result := FFragments.Items[Index] as UMLModels.PUMLInteractionFragment;
end;

function PUMLInteractionOperand.GetFragmentCount: Integer;
begin
  Result := FFragments.Count;
end;

procedure PUMLInteractionOperand.ClearFragments;
var
  I: Integer;
begin
  for I := FFragments.Count - 1 downto 0 do
    DeleteFragment(I);
end;

procedure PUMLInteractionOperand.AddFragment(Value: PUMLInteractionFragment);
begin
  if Value <> nil then begin
    if Value.FEnclosingOperand <> nil then begin
      Value.FEnclosingOperand.FFragments.Remove(Value);
      Value.FEnclosingOperand.RemoveVirtualOwnedModel(Value);
    end;
    FFragments.Add(Value);
    Value.FEnclosingOperand := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteractionOperand.RemoveFragment(Value: PUMLInteractionFragment);
begin
  if Value <> nil then begin
    FFragments.Remove(Value);
    Value.FEnclosingOperand := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteractionOperand.InsertFragment(Index: Integer; Value: PUMLInteractionFragment);
begin
  if Value <> nil then begin
    if Value.FEnclosingOperand <> nil then begin
      Value.FEnclosingOperand.FFragments.Remove(Value);
      Value.FEnclosingOperand.RemoveVirtualOwnedModel(Value);
    end;
    FFragments.Insert(Index, Value);
    Value.FEnclosingOperand := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLInteractionOperand.DeleteFragment(Index: Integer);
begin
  RemoveFragment(FFragments.Items[Index] as UMLModels.PUMLInteractionFragment);
end;

function PUMLInteractionOperand.IndexOfFragment(Value: PUMLInteractionFragment): Integer;
begin
  Result := FFragments.IndexOf(Value);
end;

function PUMLInteractionOperand.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Guard' then begin
    Result := Guard;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLInteractionOperand.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Guard' then begin
    Guard := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLInteractionOperand.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'CombinedFragment' then begin
    Result := CombinedFragment;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLInteractionOperand.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'CombinedFragment' then begin
    CombinedFragment := Value as PUMLCombinedFragment;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLInteractionOperand.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Fragments' then begin
    AddFragment(Value as PUMLInteractionFragment);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLInteractionOperand.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Fragments' then begin
    RemoveFragment(Value as PUMLInteractionFragment);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLInteractionOperand.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Fragments' then begin
    InsertFragment(Index, Value as PUMLInteractionFragment);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLInteractionOperand.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Fragments' then begin
    DeleteFragment(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLInteractionOperand.MOF_ClearCollection(Name: string);
begin
  if Name = 'Fragments' then begin
    ClearFragments;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLInteractionOperand.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Fragments' then begin
    Result := IndexOfFragment(Value as PUMLInteractionFragment);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLInteractionOperand.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Fragments' then begin
    Result := Fragments[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLInteractionOperand.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Fragments' then begin
    Result := FragmentCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLInteractionOperand
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLCombinedFragment

constructor PUMLCombinedFragment.Create;
begin
  inherited;
  FOperands := POrderedSet.Create;
end;

destructor PUMLCombinedFragment.Destroy;
begin
  FOperands.Free;
  inherited;
end;

procedure PUMLCombinedFragment.SetInteractionOperator(Value: PUMLInteractionOperatorKind);
begin
  if FInteractionOperator <> Value then
    FInteractionOperator := Value;
end;

function PUMLCombinedFragment.GetOperand(Index: Integer): PUMLInteractionOperand;
begin
  Result := FOperands.Items[Index] as UMLModels.PUMLInteractionOperand;
end;

function PUMLCombinedFragment.GetOperandCount: Integer;
begin
  Result := FOperands.Count;
end;

procedure PUMLCombinedFragment.ClearOperands;
var
  I: Integer;
begin
  for I := FOperands.Count - 1 downto 0 do
    DeleteOperand(I);
end;

procedure PUMLCombinedFragment.AddOperand(Value: PUMLInteractionOperand);
begin
  if Value <> nil then begin
    if Value.FCombinedFragment <> nil then begin
      Value.FCombinedFragment.FOperands.Remove(Value);
      Value.FCombinedFragment.RemoveVirtualOwnedModel(Value);
    end;
    FOperands.Add(Value);
    Value.FCombinedFragment := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLCombinedFragment.RemoveOperand(Value: PUMLInteractionOperand);
begin
  if Value <> nil then begin
    FOperands.Remove(Value);
    Value.FCombinedFragment := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLCombinedFragment.InsertOperand(Index: Integer; Value: PUMLInteractionOperand);
begin
  if Value <> nil then begin
    if Value.FCombinedFragment <> nil then begin
      Value.FCombinedFragment.FOperands.Remove(Value);
      Value.FCombinedFragment.RemoveVirtualOwnedModel(Value);
    end;
    FOperands.Insert(Index, Value);
    Value.FCombinedFragment := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLCombinedFragment.DeleteOperand(Index: Integer);
begin
  RemoveOperand(FOperands.Items[Index] as UMLModels.PUMLInteractionOperand);
end;

function PUMLCombinedFragment.IndexOfOperand(Value: PUMLInteractionOperand): Integer;
begin
  Result := FOperands.IndexOf(Value);
end;

function PUMLCombinedFragment.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'InteractionOperator' then begin
    Result := UMLInteractionOperatorKindToString(InteractionOperator);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLCombinedFragment.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'InteractionOperator' then begin
    InteractionOperator := StringToUMLInteractionOperatorKind(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLCombinedFragment.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLCombinedFragment.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLCombinedFragment.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Operands' then begin
    AddOperand(Value as PUMLInteractionOperand);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLCombinedFragment.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Operands' then begin
    RemoveOperand(Value as PUMLInteractionOperand);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLCombinedFragment.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Operands' then begin
    InsertOperand(Index, Value as PUMLInteractionOperand);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLCombinedFragment.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Operands' then begin
    DeleteOperand(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLCombinedFragment.MOF_ClearCollection(Name: string);
begin
  if Name = 'Operands' then begin
    ClearOperands;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLCombinedFragment.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Operands' then begin
    Result := IndexOfOperand(Value as PUMLInteractionOperand);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLCombinedFragment.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Operands' then begin
    Result := Operands[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLCombinedFragment.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Operands' then begin
    Result := OperandCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLCombinedFragment
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLInteractionInstanceSet

constructor PUMLInteractionInstanceSet.Create;
begin
  inherited;
  FContext := nil;
  FInteraction := nil;
  FParticipatingStimuli := POrderedSet.Create;
  FFragments := POrderedSet.Create;
  FOwnedFrames := POrderedSet.Create;
end;

destructor PUMLInteractionInstanceSet.Destroy;
begin
  FParticipatingStimuli.Free;
  FFragments.Free;
  FOwnedFrames.Free;
  inherited;
end;

procedure PUMLInteractionInstanceSet.SetContext(Value: PUMLCollaborationInstanceSet);
begin
  if FContext <> Value then begin
    if FContext <> nil then begin
      FContext.FInteractionInstanceSets.Remove(Self);
      FContext.RemoveVirtualOwnedModel(Self);
    end;
    FContext := Value;
    if Value <> nil then begin
      Value.FInteractionInstanceSets.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLInteractionInstanceSet.SetInteraction(Value: PUMLInteraction);
begin
  if FInteraction <> Value then begin
    if FInteraction <> nil then Interaction.FInteractionInstanceSets.Remove(Self);
    FInteraction := Value;
    if Value <> nil then begin
      Value.FInteractionInstanceSets.Add(Self);
    end;
  end;
end;

function PUMLInteractionInstanceSet.GetParticipatingStimulus(Index: Integer): PUMLStimulus;
begin
  Result := FParticipatingStimuli.Items[Index] as UMLModels.PUMLStimulus;
end;

function PUMLInteractionInstanceSet.GetParticipatingStimulusCount: Integer;
begin
  Result := FParticipatingStimuli.Count;
end;

function PUMLInteractionInstanceSet.GetFragment(Index: Integer): PUMLInteractionFragment;
begin
  Result := FFragments.Items[Index] as UMLModels.PUMLInteractionFragment;
end;

function PUMLInteractionInstanceSet.GetFragmentCount: Integer;
begin
  Result := FFragments.Count;
end;

function PUMLInteractionInstanceSet.GetOwnedFrame(Index: Integer): PUMLFrame;
begin
  Result := FOwnedFrames.Items[Index] as UMLModels.PUMLFrame;
end;

function PUMLInteractionInstanceSet.GetOwnedFrameCount: Integer;
begin
  Result := FOwnedFrames.Count;
end;

procedure PUMLInteractionInstanceSet.ClearParticipatingStimuli;
var
  I: Integer;
begin
  for I := FParticipatingStimuli.Count - 1 downto 0 do
    DeleteParticipatingStimulus(I);
end;

procedure PUMLInteractionInstanceSet.AddParticipatingStimulus(Value: PUMLStimulus);
begin
  if Value <> nil then begin
    if Value.FInteractionInstanceSet <> nil then begin
      Value.FInteractionInstanceSet.FParticipatingStimuli.Remove(Value);
      Value.FInteractionInstanceSet.RemoveVirtualOwnedModel(Value);
    end;
    FParticipatingStimuli.Add(Value);
    Value.FInteractionInstanceSet := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteractionInstanceSet.RemoveParticipatingStimulus(Value: PUMLStimulus);
begin
  if Value <> nil then begin
    FParticipatingStimuli.Remove(Value);
    Value.FInteractionInstanceSet := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteractionInstanceSet.InsertParticipatingStimulus(Index: Integer; Value: PUMLStimulus);
begin
  if Value <> nil then begin
    if Value.FInteractionInstanceSet <> nil then begin
      Value.FInteractionInstanceSet.FParticipatingStimuli.Remove(Value);
      Value.FInteractionInstanceSet.RemoveVirtualOwnedModel(Value);
    end;
    FParticipatingStimuli.Insert(Index, Value);
    Value.FInteractionInstanceSet := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLInteractionInstanceSet.DeleteParticipatingStimulus(Index: Integer);
begin
  RemoveParticipatingStimulus(FParticipatingStimuli.Items[Index] as UMLModels.PUMLStimulus);
end;

function PUMLInteractionInstanceSet.IndexOfParticipatingStimulus(Value: PUMLStimulus): Integer;
begin
  Result := FParticipatingStimuli.IndexOf(Value);
end;

procedure PUMLInteractionInstanceSet.ClearFragments;
var
  I: Integer;
begin
  for I := FFragments.Count - 1 downto 0 do
    DeleteFragment(I);
end;

procedure PUMLInteractionInstanceSet.AddFragment(Value: PUMLInteractionFragment);
begin
  if Value <> nil then begin
    if Value.FEnclosingInteractionInstanceSet <> nil then begin
      Value.FEnclosingInteractionInstanceSet.FFragments.Remove(Value);
      Value.FEnclosingInteractionInstanceSet.RemoveVirtualOwnedModel(Value);
    end;
    FFragments.Add(Value);
    Value.FEnclosingInteractionInstanceSet := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteractionInstanceSet.RemoveFragment(Value: PUMLInteractionFragment);
begin
  if Value <> nil then begin
    FFragments.Remove(Value);
    Value.FEnclosingInteractionInstanceSet := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteractionInstanceSet.InsertFragment(Index: Integer; Value: PUMLInteractionFragment);
begin
  if Value <> nil then begin
    if Value.FEnclosingInteractionInstanceSet <> nil then begin
      Value.FEnclosingInteractionInstanceSet.FFragments.Remove(Value);
      Value.FEnclosingInteractionInstanceSet.RemoveVirtualOwnedModel(Value);
    end;
    FFragments.Insert(Index, Value);
    Value.FEnclosingInteractionInstanceSet := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLInteractionInstanceSet.DeleteFragment(Index: Integer);
begin
  RemoveFragment(FFragments.Items[Index] as UMLModels.PUMLInteractionFragment);
end;

function PUMLInteractionInstanceSet.IndexOfFragment(Value: PUMLInteractionFragment): Integer;
begin
  Result := FFragments.IndexOf(Value);
end;

procedure PUMLInteractionInstanceSet.ClearOwnedFrames;
var
  I: Integer;
begin
  for I := FOwnedFrames.Count - 1 downto 0 do
    DeleteOwnedFrame(I);
end;

procedure PUMLInteractionInstanceSet.AddOwnedFrame(Value: PUMLFrame);
begin
  if Value <> nil then begin
    if Value.FInteractionInstanceSet <> nil then begin
      Value.FInteractionInstanceSet.FOwnedFrames.Remove(Value);
      Value.FInteractionInstanceSet.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedFrames.Add(Value);
    Value.FInteractionInstanceSet := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteractionInstanceSet.RemoveOwnedFrame(Value: PUMLFrame);
begin
  if Value <> nil then begin
    FOwnedFrames.Remove(Value);
    Value.FInteractionInstanceSet := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteractionInstanceSet.InsertOwnedFrame(Index: Integer; Value: PUMLFrame);
begin
  if Value <> nil then begin
    if Value.FInteractionInstanceSet <> nil then begin
      Value.FInteractionInstanceSet.FOwnedFrames.Remove(Value);
      Value.FInteractionInstanceSet.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedFrames.Insert(Index, Value);
    Value.FInteractionInstanceSet := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLInteractionInstanceSet.DeleteOwnedFrame(Index: Integer);
begin
  RemoveOwnedFrame(FOwnedFrames.Items[Index] as UMLModels.PUMLFrame);
end;

function PUMLInteractionInstanceSet.IndexOfOwnedFrame(Value: PUMLFrame): Integer;
begin
  Result := FOwnedFrames.IndexOf(Value);
end;

function PUMLInteractionInstanceSet.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLInteractionInstanceSet.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLInteractionInstanceSet.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Context' then begin
    Result := Context;
  end
  else if Name = 'Interaction' then begin
    Result := Interaction;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLInteractionInstanceSet.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Context' then begin
    Context := Value as PUMLCollaborationInstanceSet;
  end
  else if Name = 'Interaction' then begin
    Interaction := Value as PUMLInteraction;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLInteractionInstanceSet.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ParticipatingStimuli' then begin
    AddParticipatingStimulus(Value as PUMLStimulus);
  end
  else if Name = 'Fragments' then begin
    AddFragment(Value as PUMLInteractionFragment);
  end
  else if Name = 'OwnedFrames' then begin
    AddOwnedFrame(Value as PUMLFrame);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLInteractionInstanceSet.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ParticipatingStimuli' then begin
    RemoveParticipatingStimulus(Value as PUMLStimulus);
  end
  else if Name = 'Fragments' then begin
    RemoveFragment(Value as PUMLInteractionFragment);
  end
  else if Name = 'OwnedFrames' then begin
    RemoveOwnedFrame(Value as PUMLFrame);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLInteractionInstanceSet.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'ParticipatingStimuli' then begin
    InsertParticipatingStimulus(Index, Value as PUMLStimulus);
  end
  else if Name = 'Fragments' then begin
    InsertFragment(Index, Value as PUMLInteractionFragment);
  end
  else if Name = 'OwnedFrames' then begin
    InsertOwnedFrame(Index, Value as PUMLFrame);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLInteractionInstanceSet.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'ParticipatingStimuli' then begin
    DeleteParticipatingStimulus(Index);
  end
  else if Name = 'Fragments' then begin
    DeleteFragment(Index);
  end
  else if Name = 'OwnedFrames' then begin
    DeleteOwnedFrame(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLInteractionInstanceSet.MOF_ClearCollection(Name: string);
begin
  if Name = 'ParticipatingStimuli' then begin
    ClearParticipatingStimuli;
  end
  else if Name = 'Fragments' then begin
    ClearFragments;
  end
  else if Name = 'OwnedFrames' then begin
    ClearOwnedFrames;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLInteractionInstanceSet.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'ParticipatingStimuli' then begin
    Result := IndexOfParticipatingStimulus(Value as PUMLStimulus);
  end
  else if Name = 'Fragments' then begin
    Result := IndexOfFragment(Value as PUMLInteractionFragment);
  end
  else if Name = 'OwnedFrames' then begin
    Result := IndexOfOwnedFrame(Value as PUMLFrame);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLInteractionInstanceSet.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'ParticipatingStimuli' then begin
    Result := ParticipatingStimuli[Index];
  end
  else if Name = 'Fragments' then begin
    Result := Fragments[Index];
  end
  else if Name = 'OwnedFrames' then begin
    Result := OwnedFrames[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLInteractionInstanceSet.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'ParticipatingStimuli' then begin
    Result := ParticipatingStimulusCount;
  end
  else if Name = 'Fragments' then begin
    Result := FragmentCount;
  end
  else if Name = 'OwnedFrames' then begin
    Result := OwnedFrameCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLInteractionInstanceSet.CanContainDiagramKind(Kind: string): Boolean;
begin
  Result := (Kind = 'UMLSequenceDiagram') or
    (Kind = 'UMLCollaborationDiagram');
end;

function PUMLInteractionInstanceSet.CanContainDiagram(Diagram: PDiagram): Boolean;
begin
  if OwnedDiagramCount > 0 then
    Result := False
  else
    Result := inherited CanContainDiagram(Diagram);
end;

function PUMLInteractionInstanceSet.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLStimulus') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;

function PUMLInteractionInstanceSet.CanRelocateTo(Model: PModel): Boolean;
begin
  if ParticipatingStimulusCount> 0 then
    Result := False
  else
    Result := inherited CanRelocateTo(Model);
end;

function PUMLInteractionInstanceSet.CanPaste(Kind: string; CopyContext: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLSequenceRoleDiagram') or
     MetaModel.IsKindOf(Kind, 'UMLCollaborationRoleDiagram') then
    Result := (OwnedDiagramCount = 0) and (GUID = CopyContext)
  else
    Result := inherited CanPaste(Kind, CopyContext);
end;
    

// PUMLInteractionInstanceSet
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLInstance

constructor PUMLInstance.Create;
begin
  inherited;
  FClassifier := nil;
  FAttributeLinks := POrderedSet.Create;
  FLinkEnds := POrderedSet.Create;
  FSlots := POrderedSet.Create;
  FSendingStimuli := POrderedSet.Create;
  FComponentInstance := nil;
  FReceivingStimuli := POrderedSet.Create;
  FOwner := nil;
  FOwnedInstances := POrderedSet.Create;
  FOwnedLinks := POrderedSet.Create;
  FPlayedRoles := POrderedSet.Create;
  FCollaborationInstanceSet := nil;
end;

destructor PUMLInstance.Destroy;
begin
  FAttributeLinks.Free;
  FLinkEnds.Free;
  FSlots.Free;
  FSendingStimuli.Free;
  FReceivingStimuli.Free;
  FOwnedInstances.Free;
  FOwnedLinks.Free;
  FPlayedRoles.Free;
  inherited;
end;

procedure PUMLInstance.SetIsMultiInstance(Value: Boolean);
begin
  if FIsMultiInstance <> Value then
    FIsMultiInstance := Value;
end;

procedure PUMLInstance.SetClassifier(Value: PUMLClassifier);
begin
  if FClassifier <> Value then begin
    if FClassifier <> nil then Classifier.FInstances.Remove(Self);
    FClassifier := Value;
    if Value <> nil then begin
      Value.FInstances.Add(Self);
    end;
  end;
end;

function PUMLInstance.GetAttributeLink(Index: Integer): PUMLAttributeLink;
begin
  Result := FAttributeLinks.Items[Index] as UMLModels.PUMLAttributeLink;
end;

function PUMLInstance.GetAttributeLinkCount: Integer;
begin
  Result := FAttributeLinks.Count;
end;

function PUMLInstance.GetLinkEnd(Index: Integer): PUMLLinkEnd;
begin
  Result := FLinkEnds.Items[Index] as UMLModels.PUMLLinkEnd;
end;

function PUMLInstance.GetLinkEndCount: Integer;
begin
  Result := FLinkEnds.Count;
end;

function PUMLInstance.GetSlot(Index: Integer): PUMLAttributeLink;
begin
  Result := FSlots.Items[Index] as UMLModels.PUMLAttributeLink;
end;

function PUMLInstance.GetSlotCount: Integer;
begin
  Result := FSlots.Count;
end;

function PUMLInstance.HasAttachedLinks: Boolean;
begin
  Result := Assigned(Classifier) or inherited HasAttachedLinks; // Instance has attached classifier link if one is defined
end;

function PUMLInstance.GetSendingStimulus(Index: Integer): PUMLStimulus;
begin
  Result := FSendingStimuli.Items[Index] as UMLModels.PUMLStimulus;
end;

function PUMLInstance.GetSendingStimulusCount: Integer;
begin
  Result := FSendingStimuli.Count;
end;

procedure PUMLInstance.SetComponentInstance(Value: PUMLComponentInstance);
begin
  if FComponentInstance <> Value then begin
    if FComponentInstance <> nil then ComponentInstance.FResidents.Remove(Self);
    FComponentInstance := Value;
    if Value <> nil then begin
      Value.FResidents.Add(Self);
    end;
  end;
end;

function PUMLInstance.GetReceivingStimulus(Index: Integer): PUMLStimulus;
begin
  Result := FReceivingStimuli.Items[Index] as UMLModels.PUMLStimulus;
end;

function PUMLInstance.GetReceivingStimulusCount: Integer;
begin
  Result := FReceivingStimuli.Count;
end;

procedure PUMLInstance.SetOwner(Value: PUMLInstance);
begin
  if FOwner <> Value then begin
    if FOwner <> nil then begin
      FOwner.FOwnedInstances.Remove(Self);
      FOwner.RemoveVirtualOwnedModel(Self);
    end;
    FOwner := Value;
    if Value <> nil then begin
      Value.FOwnedInstances.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLInstance.GetOwnedInstance(Index: Integer): PUMLInstance;
begin
  Result := FOwnedInstances.Items[Index] as UMLModels.PUMLInstance;
end;

function PUMLInstance.GetOwnedInstanceCount: Integer;
begin
  Result := FOwnedInstances.Count;
end;

function PUMLInstance.GetOwnedLink(Index: Integer): PUMLLink;
begin
  Result := FOwnedLinks.Items[Index] as UMLModels.PUMLLink;
end;

function PUMLInstance.GetOwnedLinkCount: Integer;
begin
  Result := FOwnedLinks.Count;
end;

function PUMLInstance.GetPlayedRole(Index: Integer): PUMLClassifierRole;
begin
  Result := FPlayedRoles.Items[Index] as UMLModels.PUMLClassifierRole;
end;

function PUMLInstance.GetPlayedRoleCount: Integer;
begin
  Result := FPlayedRoles.Count;
end;

procedure PUMLInstance.SetCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
begin
  if FCollaborationInstanceSet <> Value then begin
    if FCollaborationInstanceSet <> nil then begin
      FCollaborationInstanceSet.FParticipatingInstances.Remove(Self);
      FCollaborationInstanceSet.RemoveVirtualOwnedModel(Self);
    end;
    FCollaborationInstanceSet := Value;
    if Value <> nil then begin
      Value.FParticipatingInstances.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLInstance.ClearAttributeLinks;
var
  I: Integer;
begin
  for I := FAttributeLinks.Count - 1 downto 0 do
    DeleteAttributeLink(I);
end;

procedure PUMLInstance.AddAttributeLink(Value: PUMLAttributeLink);
begin
  if Value <> nil then begin
    if Value.FValue_ <> nil then Value.FValue_.FAttributeLinks.Remove(Value);
    FAttributeLinks.Add(Value);
    Value.FValue_ := Self;
  end;
end;

procedure PUMLInstance.RemoveAttributeLink(Value: PUMLAttributeLink);
begin
  if Value <> nil then begin
    FAttributeLinks.Remove(Value);
    Value.FValue_ := nil;
  end;
end;

procedure PUMLInstance.InsertAttributeLink(Index: Integer; Value: PUMLAttributeLink);
begin
  if Value <> nil then begin
    if Value.FValue_ <> nil then Value.FValue_.FAttributeLinks.Remove(Value);
    FAttributeLinks.Insert(Index, Value);
    Value.FValue_ := Self;
  end;
end;

procedure PUMLInstance.DeleteAttributeLink(Index: Integer);
begin
  RemoveAttributeLink(FAttributeLinks.Items[Index] as UMLModels.PUMLAttributeLink);
end;

function PUMLInstance.IndexOfAttributeLink(Value: PUMLAttributeLink): Integer;
begin
  Result := FAttributeLinks.IndexOf(Value);
end;

procedure PUMLInstance.ClearLinkEnds;
var
  I: Integer;
begin
  for I := FLinkEnds.Count - 1 downto 0 do
    DeleteLinkEnd(I);
end;

procedure PUMLInstance.AddLinkEnd(Value: PUMLLinkEnd);
begin
  if Value <> nil then begin
    if Value.FInstance <> nil then Value.FInstance.FLinkEnds.Remove(Value);
    FLinkEnds.Add(Value);
    Value.FInstance := Self;
  end;
end;

procedure PUMLInstance.RemoveLinkEnd(Value: PUMLLinkEnd);
begin
  if Value <> nil then begin
    FLinkEnds.Remove(Value);
    Value.FInstance := nil;
  end;
end;

procedure PUMLInstance.InsertLinkEnd(Index: Integer; Value: PUMLLinkEnd);
begin
  if Value <> nil then begin
    if Value.FInstance <> nil then Value.FInstance.FLinkEnds.Remove(Value);
    FLinkEnds.Insert(Index, Value);
    Value.FInstance := Self;
  end;
end;

procedure PUMLInstance.DeleteLinkEnd(Index: Integer);
begin
  RemoveLinkEnd(FLinkEnds.Items[Index] as UMLModels.PUMLLinkEnd);
end;

function PUMLInstance.IndexOfLinkEnd(Value: PUMLLinkEnd): Integer;
begin
  Result := FLinkEnds.IndexOf(Value);
end;

procedure PUMLInstance.ClearSlots;
var
  I: Integer;
begin
  for I := FSlots.Count - 1 downto 0 do
    DeleteSlot(I);
end;

procedure PUMLInstance.AddSlot(Value: PUMLAttributeLink);
begin
  if Value <> nil then begin
    if Value.FInstance <> nil then begin
      Value.FInstance.FSlots.Remove(Value);
      Value.FInstance.RemoveVirtualOwnedModel(Value);
    end;
    FSlots.Add(Value);
    Value.FInstance := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInstance.RemoveSlot(Value: PUMLAttributeLink);
begin
  if Value <> nil then begin
    FSlots.Remove(Value);
    Value.FInstance := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInstance.InsertSlot(Index: Integer; Value: PUMLAttributeLink);
begin
  if Value <> nil then begin
    if Value.FInstance <> nil then begin
      Value.FInstance.FSlots.Remove(Value);
      Value.FInstance.RemoveVirtualOwnedModel(Value);
    end;
    FSlots.Insert(Index, Value);
    Value.FInstance := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLInstance.DeleteSlot(Index: Integer);
begin
  RemoveSlot(FSlots.Items[Index] as UMLModels.PUMLAttributeLink);
end;

function PUMLInstance.IndexOfSlot(Value: PUMLAttributeLink): Integer;
begin
  Result := FSlots.IndexOf(Value);
end;

procedure PUMLInstance.ClearSendingStimuli;
var
  I: Integer;
begin
  for I := FSendingStimuli.Count - 1 downto 0 do
    DeleteSendingStimulus(I);
end;

procedure PUMLInstance.AddSendingStimulus(Value: PUMLStimulus);
begin
  if Value <> nil then begin
    if Value.FSender <> nil then Value.FSender.FSendingStimuli.Remove(Value);
    FSendingStimuli.Add(Value);
    Value.FSender := Self;
  end;
end;

procedure PUMLInstance.RemoveSendingStimulus(Value: PUMLStimulus);
begin
  if Value <> nil then begin
    FSendingStimuli.Remove(Value);
    Value.FSender := nil;
  end;
end;

procedure PUMLInstance.InsertSendingStimulus(Index: Integer; Value: PUMLStimulus);
begin
  if Value <> nil then begin
    if Value.FSender <> nil then Value.FSender.FSendingStimuli.Remove(Value);
    FSendingStimuli.Insert(Index, Value);
    Value.FSender := Self;
  end;
end;

procedure PUMLInstance.DeleteSendingStimulus(Index: Integer);
begin
  RemoveSendingStimulus(FSendingStimuli.Items[Index] as UMLModels.PUMLStimulus);
end;

function PUMLInstance.IndexOfSendingStimulus(Value: PUMLStimulus): Integer;
begin
  Result := FSendingStimuli.IndexOf(Value);
end;

procedure PUMLInstance.ClearReceivingStimuli;
var
  I: Integer;
begin
  for I := FReceivingStimuli.Count - 1 downto 0 do
    DeleteReceivingStimulus(I);
end;

procedure PUMLInstance.AddReceivingStimulus(Value: PUMLStimulus);
begin
  if Value <> nil then begin
    if Value.FReceiver <> nil then Value.FReceiver.FReceivingStimuli.Remove(Value);
    FReceivingStimuli.Add(Value);
    Value.FReceiver := Self;
  end;
end;

procedure PUMLInstance.RemoveReceivingStimulus(Value: PUMLStimulus);
begin
  if Value <> nil then begin
    FReceivingStimuli.Remove(Value);
    Value.FReceiver := nil;
  end;
end;

procedure PUMLInstance.InsertReceivingStimulus(Index: Integer; Value: PUMLStimulus);
begin
  if Value <> nil then begin
    if Value.FReceiver <> nil then Value.FReceiver.FReceivingStimuli.Remove(Value);
    FReceivingStimuli.Insert(Index, Value);
    Value.FReceiver := Self;
  end;
end;

procedure PUMLInstance.DeleteReceivingStimulus(Index: Integer);
begin
  RemoveReceivingStimulus(FReceivingStimuli.Items[Index] as UMLModels.PUMLStimulus);
end;

function PUMLInstance.IndexOfReceivingStimulus(Value: PUMLStimulus): Integer;
begin
  Result := FReceivingStimuli.IndexOf(Value);
end;

procedure PUMLInstance.ClearOwnedInstances;
var
  I: Integer;
begin
  for I := FOwnedInstances.Count - 1 downto 0 do
    DeleteOwnedInstance(I);
end;

procedure PUMLInstance.AddOwnedInstance(Value: PUMLInstance);
begin
  if Value <> nil then begin
    if Value.FOwner <> nil then begin
      Value.FOwner.FOwnedInstances.Remove(Value);
      Value.FOwner.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedInstances.Add(Value);
    Value.FOwner := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInstance.RemoveOwnedInstance(Value: PUMLInstance);
begin
  if Value <> nil then begin
    FOwnedInstances.Remove(Value);
    Value.FOwner := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInstance.InsertOwnedInstance(Index: Integer; Value: PUMLInstance);
begin
  if Value <> nil then begin
    if Value.FOwner <> nil then begin
      Value.FOwner.FOwnedInstances.Remove(Value);
      Value.FOwner.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedInstances.Insert(Index, Value);
    Value.FOwner := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLInstance.DeleteOwnedInstance(Index: Integer);
begin
  RemoveOwnedInstance(FOwnedInstances.Items[Index] as UMLModels.PUMLInstance);
end;

function PUMLInstance.IndexOfOwnedInstance(Value: PUMLInstance): Integer;
begin
  Result := FOwnedInstances.IndexOf(Value);
end;

procedure PUMLInstance.ClearOwnedLinks;
var
  I: Integer;
begin
  for I := FOwnedLinks.Count - 1 downto 0 do
    DeleteOwnedLink(I);
end;

procedure PUMLInstance.AddOwnedLink(Value: PUMLLink);
begin
  if Value <> nil then begin
    if Value.FOwner <> nil then begin
      Value.FOwner.FOwnedLinks.Remove(Value);
      Value.FOwner.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedLinks.Add(Value);
    Value.FOwner := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInstance.RemoveOwnedLink(Value: PUMLLink);
begin
  if Value <> nil then begin
    FOwnedLinks.Remove(Value);
    Value.FOwner := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInstance.InsertOwnedLink(Index: Integer; Value: PUMLLink);
begin
  if Value <> nil then begin
    if Value.FOwner <> nil then begin
      Value.FOwner.FOwnedLinks.Remove(Value);
      Value.FOwner.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedLinks.Insert(Index, Value);
    Value.FOwner := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLInstance.DeleteOwnedLink(Index: Integer);
begin
  RemoveOwnedLink(FOwnedLinks.Items[Index] as UMLModels.PUMLLink);
end;

function PUMLInstance.IndexOfOwnedLink(Value: PUMLLink): Integer;
begin
  Result := FOwnedLinks.IndexOf(Value);
end;

procedure PUMLInstance.ClearPlayedRoles;
var
  I: Integer;
begin
  for I := FPlayedRoles.Count - 1 downto 0 do
    DeletePlayedRole(I);
end;

procedure PUMLInstance.AddPlayedRole(Value: PUMLClassifierRole);
begin
  if Value <> nil then begin
    FPlayedRoles.Add(Value);
    Value.FConformingInstances.Add(Self);
  end;
end;

procedure PUMLInstance.RemovePlayedRole(Value: PUMLClassifierRole);
begin
  if Value <> nil then begin
    FPlayedRoles.Remove(Value);
    Value.FConformingInstances.Remove(Self);
  end;
end;

procedure PUMLInstance.InsertPlayedRole(Index: Integer; Value: PUMLClassifierRole);
begin
  if Value <> nil then begin
    FPlayedRoles.Insert(Index, Value);
    Value.FConformingInstances.Add(Self);
  end;
end;

procedure PUMLInstance.DeletePlayedRole(Index: Integer);
begin
  RemovePlayedRole(FPlayedRoles.Items[Index] as UMLModels.PUMLClassifierRole);
end;

function PUMLInstance.IndexOfPlayedRole(Value: PUMLClassifierRole): Integer;
begin
  Result := FPlayedRoles.IndexOf(Value);
end;

function PUMLInstance.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'IsMultiInstance' then begin
    Result := BooleanToString(IsMultiInstance);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLInstance.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'IsMultiInstance' then begin
    IsMultiInstance := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLInstance.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Classifier' then begin
    Result := Classifier;
  end
  else if Name = 'ComponentInstance' then begin
    Result := ComponentInstance;
  end
  else if Name = 'Owner' then begin
    Result := Owner;
  end
  else if Name = 'CollaborationInstanceSet' then begin
    Result := CollaborationInstanceSet;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLInstance.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Classifier' then begin
    Classifier := Value as PUMLClassifier;
  end
  else if Name = 'ComponentInstance' then begin
    ComponentInstance := Value as PUMLComponentInstance;
  end
  else if Name = 'Owner' then begin
    Owner := Value as PUMLInstance;
  end
  else if Name = 'CollaborationInstanceSet' then begin
    CollaborationInstanceSet := Value as PUMLCollaborationInstanceSet;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLInstance.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'AttributeLinks' then begin
    AddAttributeLink(Value as PUMLAttributeLink);
  end
  else if Name = 'LinkEnds' then begin
    AddLinkEnd(Value as PUMLLinkEnd);
  end
  else if Name = 'Slots' then begin
    AddSlot(Value as PUMLAttributeLink);
  end
  else if Name = 'SendingStimuli' then begin
    AddSendingStimulus(Value as PUMLStimulus);
  end
  else if Name = 'ReceivingStimuli' then begin
    AddReceivingStimulus(Value as PUMLStimulus);
  end
  else if Name = 'OwnedInstances' then begin
    AddOwnedInstance(Value as PUMLInstance);
  end
  else if Name = 'OwnedLinks' then begin
    AddOwnedLink(Value as PUMLLink);
  end
  else if Name = 'PlayedRoles' then begin
    AddPlayedRole(Value as PUMLClassifierRole);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLInstance.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'AttributeLinks' then begin
    RemoveAttributeLink(Value as PUMLAttributeLink);
  end
  else if Name = 'LinkEnds' then begin
    RemoveLinkEnd(Value as PUMLLinkEnd);
  end
  else if Name = 'Slots' then begin
    RemoveSlot(Value as PUMLAttributeLink);
  end
  else if Name = 'SendingStimuli' then begin
    RemoveSendingStimulus(Value as PUMLStimulus);
  end
  else if Name = 'ReceivingStimuli' then begin
    RemoveReceivingStimulus(Value as PUMLStimulus);
  end
  else if Name = 'OwnedInstances' then begin
    RemoveOwnedInstance(Value as PUMLInstance);
  end
  else if Name = 'OwnedLinks' then begin
    RemoveOwnedLink(Value as PUMLLink);
  end
  else if Name = 'PlayedRoles' then begin
    RemovePlayedRole(Value as PUMLClassifierRole);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLInstance.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'AttributeLinks' then begin
    InsertAttributeLink(Index, Value as PUMLAttributeLink);
  end
  else if Name = 'LinkEnds' then begin
    InsertLinkEnd(Index, Value as PUMLLinkEnd);
  end
  else if Name = 'Slots' then begin
    InsertSlot(Index, Value as PUMLAttributeLink);
  end
  else if Name = 'SendingStimuli' then begin
    InsertSendingStimulus(Index, Value as PUMLStimulus);
  end
  else if Name = 'ReceivingStimuli' then begin
    InsertReceivingStimulus(Index, Value as PUMLStimulus);
  end
  else if Name = 'OwnedInstances' then begin
    InsertOwnedInstance(Index, Value as PUMLInstance);
  end
  else if Name = 'OwnedLinks' then begin
    InsertOwnedLink(Index, Value as PUMLLink);
  end
  else if Name = 'PlayedRoles' then begin
    InsertPlayedRole(Index, Value as PUMLClassifierRole);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLInstance.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'AttributeLinks' then begin
    DeleteAttributeLink(Index);
  end
  else if Name = 'LinkEnds' then begin
    DeleteLinkEnd(Index);
  end
  else if Name = 'Slots' then begin
    DeleteSlot(Index);
  end
  else if Name = 'SendingStimuli' then begin
    DeleteSendingStimulus(Index);
  end
  else if Name = 'ReceivingStimuli' then begin
    DeleteReceivingStimulus(Index);
  end
  else if Name = 'OwnedInstances' then begin
    DeleteOwnedInstance(Index);
  end
  else if Name = 'OwnedLinks' then begin
    DeleteOwnedLink(Index);
  end
  else if Name = 'PlayedRoles' then begin
    DeletePlayedRole(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLInstance.MOF_ClearCollection(Name: string);
begin
  if Name = 'AttributeLinks' then begin
    ClearAttributeLinks;
  end
  else if Name = 'LinkEnds' then begin
    ClearLinkEnds;
  end
  else if Name = 'Slots' then begin
    ClearSlots;
  end
  else if Name = 'SendingStimuli' then begin
    ClearSendingStimuli;
  end
  else if Name = 'ReceivingStimuli' then begin
    ClearReceivingStimuli;
  end
  else if Name = 'OwnedInstances' then begin
    ClearOwnedInstances;
  end
  else if Name = 'OwnedLinks' then begin
    ClearOwnedLinks;
  end
  else if Name = 'PlayedRoles' then begin
    ClearPlayedRoles;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLInstance.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'AttributeLinks' then begin
    Result := IndexOfAttributeLink(Value as PUMLAttributeLink);
  end
  else if Name = 'LinkEnds' then begin
    Result := IndexOfLinkEnd(Value as PUMLLinkEnd);
  end
  else if Name = 'Slots' then begin
    Result := IndexOfSlot(Value as PUMLAttributeLink);
  end
  else if Name = 'SendingStimuli' then begin
    Result := IndexOfSendingStimulus(Value as PUMLStimulus);
  end
  else if Name = 'ReceivingStimuli' then begin
    Result := IndexOfReceivingStimulus(Value as PUMLStimulus);
  end
  else if Name = 'OwnedInstances' then begin
    Result := IndexOfOwnedInstance(Value as PUMLInstance);
  end
  else if Name = 'OwnedLinks' then begin
    Result := IndexOfOwnedLink(Value as PUMLLink);
  end
  else if Name = 'PlayedRoles' then begin
    Result := IndexOfPlayedRole(Value as PUMLClassifierRole);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLInstance.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'AttributeLinks' then begin
    Result := AttributeLinks[Index];
  end
  else if Name = 'LinkEnds' then begin
    Result := LinkEnds[Index];
  end
  else if Name = 'Slots' then begin
    Result := Slots[Index];
  end
  else if Name = 'SendingStimuli' then begin
    Result := SendingStimuli[Index];
  end
  else if Name = 'ReceivingStimuli' then begin
    Result := ReceivingStimuli[Index];
  end
  else if Name = 'OwnedInstances' then begin
    Result := OwnedInstances[Index];
  end
  else if Name = 'OwnedLinks' then begin
    Result := OwnedLinks[Index];
  end
  else if Name = 'PlayedRoles' then begin
    Result := PlayedRoles[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLInstance.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'AttributeLinks' then begin
    Result := AttributeLinkCount;
  end
  else if Name = 'LinkEnds' then begin
    Result := LinkEndCount;
  end
  else if Name = 'Slots' then begin
    Result := SlotCount;
  end
  else if Name = 'SendingStimuli' then begin
    Result := SendingStimulusCount;
  end
  else if Name = 'ReceivingStimuli' then begin
    Result := ReceivingStimulusCount;
  end
  else if Name = 'OwnedInstances' then begin
    Result := OwnedInstanceCount;
  end
  else if Name = 'OwnedLinks' then begin
    Result := OwnedLinkCount;
  end
  else if Name = 'PlayedRoles' then begin
    Result := PlayedRoleCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLInstance.CanRelocateTo(Model: PModel): Boolean;
begin
  if CollaborationInstanceSet <> nil then
    Result := False
  else
    Result := inherited CanRelocateTo(Model);
end;

// PUMLInstance
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLDataValue

constructor PUMLDataValue.Create;
begin
  inherited;
end;

destructor PUMLDataValue.Destroy;
begin
  inherited;
end;

function PUMLDataValue.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLDataValue.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLDataValue.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLDataValue.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLDataValue.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLDataValue.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLDataValue.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLDataValue.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLDataValue.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLDataValue.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLDataValue.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLDataValue.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLDataValue
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLNodeInstance

constructor PUMLNodeInstance.Create;
begin
  inherited;
  FResidents := POrderedSet.Create;
end;

destructor PUMLNodeInstance.Destroy;
begin
  FResidents.Free;
  inherited;
end;

function PUMLNodeInstance.GetResident(Index: Integer): PUMLComponentInstance;
begin
  Result := FResidents.Items[Index] as UMLModels.PUMLComponentInstance;
end;

function PUMLNodeInstance.GetResidentCount: Integer;
begin
  Result := FResidents.Count;
end;

procedure PUMLNodeInstance.ClearResidents;
var
  I: Integer;
begin
  for I := FResidents.Count - 1 downto 0 do
    DeleteResident(I);
end;

procedure PUMLNodeInstance.AddResident(Value: PUMLComponentInstance);
begin
  if Value <> nil then begin
    if Value.FNodeInstance <> nil then Value.FNodeInstance.FResidents.Remove(Value);
    FResidents.Add(Value);
    Value.FNodeInstance := Self;
  end;
end;

procedure PUMLNodeInstance.RemoveResident(Value: PUMLComponentInstance);
begin
  if Value <> nil then begin
    FResidents.Remove(Value);
    Value.FNodeInstance := nil;
  end;
end;

procedure PUMLNodeInstance.InsertResident(Index: Integer; Value: PUMLComponentInstance);
begin
  if Value <> nil then begin
    if Value.FNodeInstance <> nil then Value.FNodeInstance.FResidents.Remove(Value);
    FResidents.Insert(Index, Value);
    Value.FNodeInstance := Self;
  end;
end;

procedure PUMLNodeInstance.DeleteResident(Index: Integer);
begin
  RemoveResident(FResidents.Items[Index] as UMLModels.PUMLComponentInstance);
end;

function PUMLNodeInstance.IndexOfResident(Value: PUMLComponentInstance): Integer;
begin
  Result := FResidents.IndexOf(Value);
end;

function PUMLNodeInstance.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLNodeInstance.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLNodeInstance.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLNodeInstance.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLNodeInstance.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Residents' then begin
    AddResident(Value as PUMLComponentInstance);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLNodeInstance.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Residents' then begin
    RemoveResident(Value as PUMLComponentInstance);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLNodeInstance.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Residents' then begin
    InsertResident(Index, Value as PUMLComponentInstance);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLNodeInstance.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Residents' then begin
    DeleteResident(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLNodeInstance.MOF_ClearCollection(Name: string);
begin
  if Name = 'Residents' then begin
    ClearResidents;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLNodeInstance.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Residents' then begin
    Result := IndexOfResident(Value as PUMLComponentInstance);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLNodeInstance.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Residents' then begin
    Result := Residents[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLNodeInstance.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Residents' then begin
    Result := ResidentCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLNodeInstance
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLObject

constructor PUMLObject.Create;
begin
  inherited;
  FLinkObject := nil;
end;

destructor PUMLObject.Destroy;
begin
  inherited;
end;

procedure PUMLObject.SetLinkObject(Value: PUMLLinkObject);
begin
  if FLinkObject <> Value then begin
    if FLinkObject <> nil then LinkObject.FObjectSide := nil;
    FLinkObject := Value;
    if Value <> nil then Value.FObjectSide := Self;
  end;
end;

function PUMLObject.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLObject.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLObject.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'LinkObject' then begin
    Result := LinkObject;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLObject.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'LinkObject' then begin
    LinkObject := Value as PUMLLinkObject;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLObject.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLObject.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLObject.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLObject.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLObject.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLObject.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLObject.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLObject.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLObject
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSubsystemInstance

constructor PUMLSubsystemInstance.Create;
begin
  inherited;
end;

destructor PUMLSubsystemInstance.Destroy;
begin
  inherited;
end;

function PUMLSubsystemInstance.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLSubsystemInstance.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLSubsystemInstance.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLSubsystemInstance.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLSubsystemInstance.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLSubsystemInstance.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLSubsystemInstance.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLSubsystemInstance.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLSubsystemInstance.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLSubsystemInstance.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLSubsystemInstance.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLSubsystemInstance.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLSubsystemInstance
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLUseCaseInstance

constructor PUMLUseCaseInstance.Create;
begin
  inherited;
end;

destructor PUMLUseCaseInstance.Destroy;
begin
  inherited;
end;

function PUMLUseCaseInstance.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLUseCaseInstance.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLUseCaseInstance.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLUseCaseInstance.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLUseCaseInstance.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLUseCaseInstance.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLUseCaseInstance.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLUseCaseInstance.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLUseCaseInstance.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLUseCaseInstance.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLUseCaseInstance.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLUseCaseInstance.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLUseCaseInstance
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLComponentInstance

constructor PUMLComponentInstance.Create;
begin
  inherited;
  FNodeInstance := nil;
  FResidents := POrderedSet.Create;
end;

destructor PUMLComponentInstance.Destroy;
begin
  FResidents.Free;
  inherited;
end;

procedure PUMLComponentInstance.SetNodeInstance(Value: PUMLNodeInstance);
begin
  if FNodeInstance <> Value then begin
    if FNodeInstance <> nil then NodeInstance.FResidents.Remove(Self);
    FNodeInstance := Value;
    if Value <> nil then begin
      Value.FResidents.Add(Self);
    end;
  end;
end;

function PUMLComponentInstance.GetResident(Index: Integer): PUMLInstance;
begin
  Result := FResidents.Items[Index] as UMLModels.PUMLInstance;
end;

function PUMLComponentInstance.GetResidentCount: Integer;
begin
  Result := FResidents.Count;
end;

procedure PUMLComponentInstance.ClearResidents;
var
  I: Integer;
begin
  for I := FResidents.Count - 1 downto 0 do
    DeleteResident(I);
end;

procedure PUMLComponentInstance.AddResident(Value: PUMLInstance);
begin
  if Value <> nil then begin
    if Value.FComponentInstance <> nil then Value.FComponentInstance.FResidents.Remove(Value);
    FResidents.Add(Value);
    Value.FComponentInstance := Self;
  end;
end;

procedure PUMLComponentInstance.RemoveResident(Value: PUMLInstance);
begin
  if Value <> nil then begin
    FResidents.Remove(Value);
    Value.FComponentInstance := nil;
  end;
end;

procedure PUMLComponentInstance.InsertResident(Index: Integer; Value: PUMLInstance);
begin
  if Value <> nil then begin
    if Value.FComponentInstance <> nil then Value.FComponentInstance.FResidents.Remove(Value);
    FResidents.Insert(Index, Value);
    Value.FComponentInstance := Self;
  end;
end;

procedure PUMLComponentInstance.DeleteResident(Index: Integer);
begin
  RemoveResident(FResidents.Items[Index] as UMLModels.PUMLInstance);
end;

function PUMLComponentInstance.IndexOfResident(Value: PUMLInstance): Integer;
begin
  Result := FResidents.IndexOf(Value);
end;

function PUMLComponentInstance.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLComponentInstance.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLComponentInstance.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'NodeInstance' then begin
    Result := NodeInstance;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLComponentInstance.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'NodeInstance' then begin
    NodeInstance := Value as PUMLNodeInstance;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLComponentInstance.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Residents' then begin
    AddResident(Value as PUMLInstance);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLComponentInstance.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Residents' then begin
    RemoveResident(Value as PUMLInstance);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLComponentInstance.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Residents' then begin
    InsertResident(Index, Value as PUMLInstance);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLComponentInstance.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Residents' then begin
    DeleteResident(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLComponentInstance.MOF_ClearCollection(Name: string);
begin
  if Name = 'Residents' then begin
    ClearResidents;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLComponentInstance.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Residents' then begin
    Result := IndexOfResident(Value as PUMLInstance);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLComponentInstance.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Residents' then begin
    Result := Residents[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLComponentInstance.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Residents' then begin
    Result := ResidentCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLComponentInstance
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLArgument

constructor PUMLArgument.Create;
begin
  inherited;
  FAction := nil;
end;

destructor PUMLArgument.Destroy;
begin
  inherited;
end;

procedure PUMLArgument.SetValue(Value: string);
begin
  if FValue <> Value then
    FValue := Value;
end;

procedure PUMLArgument.SetAction(Value: PUMLAction);
begin
  if FAction <> Value then begin
    if FAction <> nil then begin
      FAction.FActualArguments.Remove(Self);
      FAction.RemoveVirtualOwnedModel(Self);
    end;
    FAction := Value;
    if Value <> nil then begin
      Value.FActualArguments.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLArgument.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Value' then begin
    Result := Value;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLArgument.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Value' then begin
    Value := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLArgument.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Action' then begin
    Result := Action;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLArgument.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Action' then begin
    Action := Value as PUMLAction;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLArgument.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLArgument.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLArgument.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLArgument.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLArgument.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLArgument.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLArgument.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLArgument.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLArgument
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLConnectorEnd

constructor PUMLConnectorEnd.Create;
begin
  inherited;
  FConnector := nil;
  FRole := nil;
end;

destructor PUMLConnectorEnd.Destroy;
begin
  inherited;
end;

procedure PUMLConnectorEnd.SetMultiplicity(Value: string);
begin
  if FMultiplicity <> Value then
    FMultiplicity := Value;
end;

procedure PUMLConnectorEnd.SetIsOrdered(Value: Boolean);
begin
  if FIsOrdered <> Value then
    FIsOrdered := Value;
end;

procedure PUMLConnectorEnd.SetIsUnique(Value: Boolean);
begin
  if FIsUnique <> Value then
    FIsUnique := Value;
end;

procedure PUMLConnectorEnd.SetConnector(Value: PUMLConnector);
begin
  if FConnector <> Value then begin
    if FConnector <> nil then begin
      FConnector.FEnds.Remove(Self);
      FConnector.RemoveVirtualOwnedModel(Self);
    end;
    FConnector := Value;
    if Value <> nil then begin
      Value.FEnds.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLConnectorEnd.SetRole(Value: PUMLFeature);
begin
  if FRole <> Value then begin
    if FRole <> nil then Role.FConnectorEnds.Remove(Self);
    FRole := Value;
    if Value <> nil then begin
      Value.FConnectorEnds.Add(Self);
    end;
  end;
end;

function PUMLConnectorEnd.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Multiplicity' then begin
    Result := Multiplicity;
  end
  else if Name = 'IsOrdered' then begin
    Result := BooleanToString(IsOrdered);
  end
  else if Name = 'IsUnique' then begin
    Result := BooleanToString(IsUnique);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLConnectorEnd.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Multiplicity' then begin
    Multiplicity := Value;
  end
  else if Name = 'IsOrdered' then begin
    IsOrdered := StringToBoolean(Value);
  end
  else if Name = 'IsUnique' then begin
    IsUnique := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLConnectorEnd.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Connector' then begin
    Result := Connector;
  end
  else if Name = 'Role' then begin
    Result := Role;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLConnectorEnd.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Connector' then begin
    Connector := Value as PUMLConnector;
  end
  else if Name = 'Role' then begin
    Role := Value as PUMLFeature;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLConnectorEnd.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLConnectorEnd.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLConnectorEnd.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLConnectorEnd.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLConnectorEnd.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLConnectorEnd.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLConnectorEnd.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLConnectorEnd.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLConnectorEnd
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLStateVertex

constructor PUMLStateVertex.Create;
begin
  inherited;
  FContainerState := nil;
  FOutgoings := POrderedSet.Create;
  FIncomings := POrderedSet.Create;
end;

destructor PUMLStateVertex.Destroy;
begin
  FOutgoings.Free;
  FIncomings.Free;
  inherited;
end;

procedure PUMLStateVertex.SetContainerState(Value: PUMLCompositeState);
begin
  if FContainerState <> Value then begin
    if FContainerState <> nil then begin
      FContainerState.FSubvertices.Remove(Self);
      FContainerState.RemoveVirtualOwnedModel(Self);
    end;
    FContainerState := Value;
    if Value <> nil then begin
      Value.FSubvertices.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLStateVertex.GetOutgoing(Index: Integer): PUMLTransition;
begin
  Result := FOutgoings.Items[Index] as UMLModels.PUMLTransition;
end;

function PUMLStateVertex.GetOutgoingCount: Integer;
begin
  Result := FOutgoings.Count;
end;

function PUMLStateVertex.GetIncoming(Index: Integer): PUMLTransition;
begin
  Result := FIncomings.Items[Index] as UMLModels.PUMLTransition;
end;

function PUMLStateVertex.GetIncomingCount: Integer;
begin
  Result := FIncomings.Count;
end;

procedure PUMLStateVertex.ClearOutgoings;
var
  I: Integer;
begin
  for I := FOutgoings.Count - 1 downto 0 do
    DeleteOutgoing(I);
end;

procedure PUMLStateVertex.AddOutgoing(Value: PUMLTransition);
begin
  if Value <> nil then begin
    if Value.FSource <> nil then Value.FSource.FOutgoings.Remove(Value);
    FOutgoings.Add(Value);
    Value.FSource := Self;
  end;
end;

procedure PUMLStateVertex.RemoveOutgoing(Value: PUMLTransition);
begin
  if Value <> nil then begin
    FOutgoings.Remove(Value);
    Value.FSource := nil;
  end;
end;

procedure PUMLStateVertex.InsertOutgoing(Index: Integer; Value: PUMLTransition);
begin
  if Value <> nil then begin
    if Value.FSource <> nil then Value.FSource.FOutgoings.Remove(Value);
    FOutgoings.Insert(Index, Value);
    Value.FSource := Self;
  end;
end;

procedure PUMLStateVertex.DeleteOutgoing(Index: Integer);
begin
  RemoveOutgoing(FOutgoings.Items[Index] as UMLModels.PUMLTransition);
end;

function PUMLStateVertex.IndexOfOutgoing(Value: PUMLTransition): Integer;
begin
  Result := FOutgoings.IndexOf(Value);
end;

procedure PUMLStateVertex.ClearIncomings;
var
  I: Integer;
begin
  for I := FIncomings.Count - 1 downto 0 do
    DeleteIncoming(I);
end;

procedure PUMLStateVertex.AddIncoming(Value: PUMLTransition);
begin
  if Value <> nil then begin
    if Value.FTarget <> nil then Value.FTarget.FIncomings.Remove(Value);
    FIncomings.Add(Value);
    Value.FTarget := Self;
  end;
end;

procedure PUMLStateVertex.RemoveIncoming(Value: PUMLTransition);
begin
  if Value <> nil then begin
    FIncomings.Remove(Value);
    Value.FTarget := nil;
  end;
end;

procedure PUMLStateVertex.InsertIncoming(Index: Integer; Value: PUMLTransition);
begin
  if Value <> nil then begin
    if Value.FTarget <> nil then Value.FTarget.FIncomings.Remove(Value);
    FIncomings.Insert(Index, Value);
    Value.FTarget := Self;
  end;
end;

procedure PUMLStateVertex.DeleteIncoming(Index: Integer);
begin
  RemoveIncoming(FIncomings.Items[Index] as UMLModels.PUMLTransition);
end;

function PUMLStateVertex.IndexOfIncoming(Value: PUMLTransition): Integer;
begin
  Result := FIncomings.IndexOf(Value);
end;

function PUMLStateVertex.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLStateVertex.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLStateVertex.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'ContainerState' then begin
    Result := ContainerState;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLStateVertex.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'ContainerState' then begin
    ContainerState := Value as PUMLCompositeState;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLStateVertex.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Outgoings' then begin
    AddOutgoing(Value as PUMLTransition);
  end
  else if Name = 'Incomings' then begin
    AddIncoming(Value as PUMLTransition);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLStateVertex.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Outgoings' then begin
    RemoveOutgoing(Value as PUMLTransition);
  end
  else if Name = 'Incomings' then begin
    RemoveIncoming(Value as PUMLTransition);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLStateVertex.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Outgoings' then begin
    InsertOutgoing(Index, Value as PUMLTransition);
  end
  else if Name = 'Incomings' then begin
    InsertIncoming(Index, Value as PUMLTransition);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLStateVertex.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Outgoings' then begin
    DeleteOutgoing(Index);
  end
  else if Name = 'Incomings' then begin
    DeleteIncoming(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLStateVertex.MOF_ClearCollection(Name: string);
begin
  if Name = 'Outgoings' then begin
    ClearOutgoings;
  end
  else if Name = 'Incomings' then begin
    ClearIncomings;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLStateVertex.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Outgoings' then begin
    Result := IndexOfOutgoing(Value as PUMLTransition);
  end
  else if Name = 'Incomings' then begin
    Result := IndexOfIncoming(Value as PUMLTransition);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLStateVertex.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Outgoings' then begin
    Result := Outgoings[Index];
  end
  else if Name = 'Incomings' then begin
    Result := Incomings[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLStateVertex.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Outgoings' then begin
    Result := OutgoingCount;
  end
  else if Name = 'Incomings' then begin
    Result := IncomingCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLStateVertex.CanRelocateTo(Model: PModel): Boolean;

  function GetOwnerStateMachine(AState: PUMLStateVertex): PUMLStateMachine;
  begin
    if not (AState is PUMLStateVertex) then
      Result := nil
    else if (AState is PUMLState) and ((AState as PUMLState).StateMachine <> nil) then
      Result := (AState as PUMLState).StateMachine
    else
      Result := GetOwnerStateMachine(AState.ContainerState);
  end;

begin
  if Model is PUMLStateMachine then
    Result := False
  else if (Model is PUMLStateVertex) and
    (GetOwnerStateMachine(Self) <> GetOwnerStateMachine(Model as PUMLStateVertex)) then
    Result := False
  else
    Result := inherited CanRelocateTo(Model);
end;


// PUMLStateVertex
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSynchState

constructor PUMLSynchState.Create;
begin
  inherited;
end;

destructor PUMLSynchState.Destroy;
begin
  inherited;
end;

procedure PUMLSynchState.SetBound(Value: Integer);
begin
  if FBound <> Value then
    FBound := Value;
end;

function PUMLSynchState.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Bound' then begin
    Result := IntegerToString(Bound);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLSynchState.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Bound' then begin
    Bound := StringToInteger(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLSynchState.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLSynchState.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLSynchState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLSynchState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLSynchState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLSynchState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLSynchState.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLSynchState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLSynchState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLSynchState.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLSynchState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLPseudostate

constructor PUMLPseudostate.Create;
begin
  inherited;
end;

destructor PUMLPseudostate.Destroy;
begin
  inherited;
end;

procedure PUMLPseudostate.SetPseudostateKind(Value: PUMLPseudostateKind);
begin
  if FPseudostateKind <> Value then
    FPseudostateKind := Value;
end;

function PUMLPseudostate.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'PseudostateKind' then begin
    Result := UMLPseudostateKindToString(PseudostateKind);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLPseudostate.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'PseudostateKind' then begin
    PseudostateKind := StringToUMLPseudostateKind(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLPseudostate.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLPseudostate.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLPseudostate.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLPseudostate.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLPseudostate.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLPseudostate.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLPseudostate.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLPseudostate.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLPseudostate.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLPseudostate.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLPseudostate
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLStubState

constructor PUMLStubState.Create;
begin
  inherited;
end;

destructor PUMLStubState.Destroy;
begin
  inherited;
end;

procedure PUMLStubState.SetReferenceState(Value: string);
begin
  if FReferenceState <> Value then
    FReferenceState := Value;
end;

function PUMLStubState.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'ReferenceState' then begin
    Result := ReferenceState;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLStubState.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'ReferenceState' then begin
    ReferenceState := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLStubState.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLStubState.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLStubState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLStubState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLStubState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLStubState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLStubState.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLStubState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLStubState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLStubState.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLStubState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLState

constructor PUMLState.Create;
begin
  inherited;
  FEntryActions := POrderedSet.Create;
  FExitActions := POrderedSet.Create;
  FStateMachine := nil;
  FDeferrableEvents := POrderedSet.Create;
  FInternalTransitions := POrderedSet.Create;
  FDoActivities := POrderedSet.Create;
  FClassifierStates := POrderedSet.Create;
end;

destructor PUMLState.Destroy;
begin
  FEntryActions.Free;
  FExitActions.Free;
  FDeferrableEvents.Free;
  FInternalTransitions.Free;
  FDoActivities.Free;
  FClassifierStates.Free;
  inherited;
end;

function PUMLState.GetEntryAction(Index: Integer): PUMLAction;
begin
  Result := FEntryActions.Items[Index] as UMLModels.PUMLAction;
end;

function PUMLState.GetEntryActionCount: Integer;
begin
  Result := FEntryActions.Count;
end;

function PUMLState.GetExitAction(Index: Integer): PUMLAction;
begin
  Result := FExitActions.Items[Index] as UMLModels.PUMLAction;
end;

function PUMLState.GetExitActionCount: Integer;
begin
  Result := FExitActions.Count;
end;

procedure PUMLState.SetStateMachine(Value: PUMLStateMachine);
begin
  if FStateMachine <> Value then begin
    if FStateMachine <> nil then begin
      StateMachine.RemoveVirtualOwnedModel(StateMachine.FTop);
      StateMachine.FTop := nil;
    end;
    FStateMachine := Value;
    if Value <> nil then begin
      Value.FTop := Self;
      StateMachine.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLState.GetDeferrableEvent(Index: Integer): PUMLEvent;
begin
  Result := FDeferrableEvents.Items[Index] as UMLModels.PUMLEvent;
end;

function PUMLState.GetDeferrableEventCount: Integer;
begin
  Result := FDeferrableEvents.Count;
end;

function PUMLState.GetInternalTransition(Index: Integer): PUMLTransition;
begin
  Result := FInternalTransitions.Items[Index] as UMLModels.PUMLTransition;
end;

function PUMLState.GetInternalTransitionCount: Integer;
begin
  Result := FInternalTransitions.Count;
end;

function PUMLState.GetDoActivity(Index: Integer): PUMLAction;
begin
  Result := FDoActivities.Items[Index] as UMLModels.PUMLAction;
end;

function PUMLState.GetDoActivityCount: Integer;
begin
  Result := FDoActivities.Count;
end;

function PUMLState.GetClassifierState(Index: Integer): PUMLClassifierInState;
begin
  Result := FClassifierStates.Items[Index] as UMLModels.PUMLClassifierInState;
end;

function PUMLState.GetClassifierStateCount: Integer;
begin
  Result := FClassifierStates.Count;
end;

procedure PUMLState.ClearEntryActions;
var
  I: Integer;
begin
  for I := FEntryActions.Count - 1 downto 0 do
    DeleteEntryAction(I);
end;

procedure PUMLState.AddEntryAction(Value: PUMLAction);
begin
  if Value <> nil then begin
    if Value.FEntryState <> nil then begin
      Value.FEntryState.FEntryActions.Remove(Value);
      Value.FEntryState.RemoveVirtualOwnedModel(Value);
    end;
    FEntryActions.Add(Value);
    Value.FEntryState := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLState.RemoveEntryAction(Value: PUMLAction);
begin
  if Value <> nil then begin
    FEntryActions.Remove(Value);
    Value.FEntryState := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLState.InsertEntryAction(Index: Integer; Value: PUMLAction);
begin
  if Value <> nil then begin
    if Value.FEntryState <> nil then begin
      Value.FEntryState.FEntryActions.Remove(Value);
      Value.FEntryState.RemoveVirtualOwnedModel(Value);
    end;
    FEntryActions.Insert(Index, Value);
    Value.FEntryState := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLState.DeleteEntryAction(Index: Integer);
begin
  RemoveEntryAction(FEntryActions.Items[Index] as UMLModels.PUMLAction);
end;

function PUMLState.IndexOfEntryAction(Value: PUMLAction): Integer;
begin
  Result := FEntryActions.IndexOf(Value);
end;

procedure PUMLState.ClearExitActions;
var
  I: Integer;
begin
  for I := FExitActions.Count - 1 downto 0 do
    DeleteExitAction(I);
end;

procedure PUMLState.AddExitAction(Value: PUMLAction);
begin
  if Value <> nil then begin
    if Value.FExitState <> nil then begin
      Value.FExitState.FExitActions.Remove(Value);
      Value.FExitState.RemoveVirtualOwnedModel(Value);
    end;
    FExitActions.Add(Value);
    Value.FExitState := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLState.RemoveExitAction(Value: PUMLAction);
begin
  if Value <> nil then begin
    FExitActions.Remove(Value);
    Value.FExitState := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLState.InsertExitAction(Index: Integer; Value: PUMLAction);
begin
  if Value <> nil then begin
    if Value.FExitState <> nil then begin
      Value.FExitState.FExitActions.Remove(Value);
      Value.FExitState.RemoveVirtualOwnedModel(Value);
    end;
    FExitActions.Insert(Index, Value);
    Value.FExitState := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLState.DeleteExitAction(Index: Integer);
begin
  RemoveExitAction(FExitActions.Items[Index] as UMLModels.PUMLAction);
end;

function PUMLState.IndexOfExitAction(Value: PUMLAction): Integer;
begin
  Result := FExitActions.IndexOf(Value);
end;

procedure PUMLState.ClearDeferrableEvents;
var
  I: Integer;
begin
  for I := FDeferrableEvents.Count - 1 downto 0 do
    DeleteDeferrableEvent(I);
end;

procedure PUMLState.AddDeferrableEvent(Value: PUMLEvent);
begin
  if Value <> nil then begin
    FDeferrableEvents.Add(Value);
    Value.FStates.Add(Self);
  end;
end;

procedure PUMLState.RemoveDeferrableEvent(Value: PUMLEvent);
begin
  if Value <> nil then begin
    FDeferrableEvents.Remove(Value);
    Value.FStates.Remove(Self);
  end;
end;

procedure PUMLState.InsertDeferrableEvent(Index: Integer; Value: PUMLEvent);
begin
  if Value <> nil then begin
    FDeferrableEvents.Insert(Index, Value);
    Value.FStates.Add(Self);
  end;
end;

procedure PUMLState.DeleteDeferrableEvent(Index: Integer);
begin
  RemoveDeferrableEvent(FDeferrableEvents.Items[Index] as UMLModels.PUMLEvent);
end;

function PUMLState.IndexOfDeferrableEvent(Value: PUMLEvent): Integer;
begin
  Result := FDeferrableEvents.IndexOf(Value);
end;

procedure PUMLState.ClearInternalTransitions;
var
  I: Integer;
begin
  for I := FInternalTransitions.Count - 1 downto 0 do
    DeleteInternalTransition(I);
end;

procedure PUMLState.AddInternalTransition(Value: PUMLTransition);
begin
  if Value <> nil then begin
    if Value.FState <> nil then begin
      Value.FState.FInternalTransitions.Remove(Value);
      Value.FState.RemoveVirtualOwnedModel(Value);
    end;
    FInternalTransitions.Add(Value);
    Value.FState := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLState.RemoveInternalTransition(Value: PUMLTransition);
begin
  if Value <> nil then begin
    FInternalTransitions.Remove(Value);
    Value.FState := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLState.InsertInternalTransition(Index: Integer; Value: PUMLTransition);
begin
  if Value <> nil then begin
    if Value.FState <> nil then begin
      Value.FState.FInternalTransitions.Remove(Value);
      Value.FState.RemoveVirtualOwnedModel(Value);
    end;
    FInternalTransitions.Insert(Index, Value);
    Value.FState := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLState.DeleteInternalTransition(Index: Integer);
begin
  RemoveInternalTransition(FInternalTransitions.Items[Index] as UMLModels.PUMLTransition);
end;

function PUMLState.IndexOfInternalTransition(Value: PUMLTransition): Integer;
begin
  Result := FInternalTransitions.IndexOf(Value);
end;

procedure PUMLState.ClearDoActivities;
var
  I: Integer;
begin
  for I := FDoActivities.Count - 1 downto 0 do
    DeleteDoActivity(I);
end;

procedure PUMLState.AddDoActivity(Value: PUMLAction);
begin
  if Value <> nil then begin
    if Value.FDoActivityState <> nil then begin
      Value.FDoActivityState.FDoActivities.Remove(Value);
      Value.FDoActivityState.RemoveVirtualOwnedModel(Value);
    end;
    FDoActivities.Add(Value);
    Value.FDoActivityState := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLState.RemoveDoActivity(Value: PUMLAction);
begin
  if Value <> nil then begin
    FDoActivities.Remove(Value);
    Value.FDoActivityState := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLState.InsertDoActivity(Index: Integer; Value: PUMLAction);
begin
  if Value <> nil then begin
    if Value.FDoActivityState <> nil then begin
      Value.FDoActivityState.FDoActivities.Remove(Value);
      Value.FDoActivityState.RemoveVirtualOwnedModel(Value);
    end;
    FDoActivities.Insert(Index, Value);
    Value.FDoActivityState := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLState.DeleteDoActivity(Index: Integer);
begin
  RemoveDoActivity(FDoActivities.Items[Index] as UMLModels.PUMLAction);
end;

function PUMLState.IndexOfDoActivity(Value: PUMLAction): Integer;
begin
  Result := FDoActivities.IndexOf(Value);
end;

procedure PUMLState.ClearClassifierStates;
var
  I: Integer;
begin
  for I := FClassifierStates.Count - 1 downto 0 do
    DeleteClassifierState(I);
end;

procedure PUMLState.AddClassifierState(Value: PUMLClassifierInState);
begin
  if Value <> nil then begin
    FClassifierStates.Add(Value);
    Value.FInStates.Add(Self);
  end;
end;

procedure PUMLState.RemoveClassifierState(Value: PUMLClassifierInState);
begin
  if Value <> nil then begin
    FClassifierStates.Remove(Value);
    Value.FInStates.Remove(Self);
  end;
end;

procedure PUMLState.InsertClassifierState(Index: Integer; Value: PUMLClassifierInState);
begin
  if Value <> nil then begin
    FClassifierStates.Insert(Index, Value);
    Value.FInStates.Add(Self);
  end;
end;

procedure PUMLState.DeleteClassifierState(Index: Integer);
begin
  RemoveClassifierState(FClassifierStates.Items[Index] as UMLModels.PUMLClassifierInState);
end;

function PUMLState.IndexOfClassifierState(Value: PUMLClassifierInState): Integer;
begin
  Result := FClassifierStates.IndexOf(Value);
end;

function PUMLState.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLState.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLState.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'StateMachine' then begin
    Result := StateMachine;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLState.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'StateMachine' then begin
    StateMachine := Value as PUMLStateMachine;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'EntryActions' then begin
    AddEntryAction(Value as PUMLAction);
  end
  else if Name = 'ExitActions' then begin
    AddExitAction(Value as PUMLAction);
  end
  else if Name = 'DeferrableEvents' then begin
    AddDeferrableEvent(Value as PUMLEvent);
  end
  else if Name = 'InternalTransitions' then begin
    AddInternalTransition(Value as PUMLTransition);
  end
  else if Name = 'DoActivities' then begin
    AddDoActivity(Value as PUMLAction);
  end
  else if Name = 'ClassifierStates' then begin
    AddClassifierState(Value as PUMLClassifierInState);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'EntryActions' then begin
    RemoveEntryAction(Value as PUMLAction);
  end
  else if Name = 'ExitActions' then begin
    RemoveExitAction(Value as PUMLAction);
  end
  else if Name = 'DeferrableEvents' then begin
    RemoveDeferrableEvent(Value as PUMLEvent);
  end
  else if Name = 'InternalTransitions' then begin
    RemoveInternalTransition(Value as PUMLTransition);
  end
  else if Name = 'DoActivities' then begin
    RemoveDoActivity(Value as PUMLAction);
  end
  else if Name = 'ClassifierStates' then begin
    RemoveClassifierState(Value as PUMLClassifierInState);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'EntryActions' then begin
    InsertEntryAction(Index, Value as PUMLAction);
  end
  else if Name = 'ExitActions' then begin
    InsertExitAction(Index, Value as PUMLAction);
  end
  else if Name = 'DeferrableEvents' then begin
    InsertDeferrableEvent(Index, Value as PUMLEvent);
  end
  else if Name = 'InternalTransitions' then begin
    InsertInternalTransition(Index, Value as PUMLTransition);
  end
  else if Name = 'DoActivities' then begin
    InsertDoActivity(Index, Value as PUMLAction);
  end
  else if Name = 'ClassifierStates' then begin
    InsertClassifierState(Index, Value as PUMLClassifierInState);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'EntryActions' then begin
    DeleteEntryAction(Index);
  end
  else if Name = 'ExitActions' then begin
    DeleteExitAction(Index);
  end
  else if Name = 'DeferrableEvents' then begin
    DeleteDeferrableEvent(Index);
  end
  else if Name = 'InternalTransitions' then begin
    DeleteInternalTransition(Index);
  end
  else if Name = 'DoActivities' then begin
    DeleteDoActivity(Index);
  end
  else if Name = 'ClassifierStates' then begin
    DeleteClassifierState(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLState.MOF_ClearCollection(Name: string);
begin
  if Name = 'EntryActions' then begin
    ClearEntryActions;
  end
  else if Name = 'ExitActions' then begin
    ClearExitActions;
  end
  else if Name = 'DeferrableEvents' then begin
    ClearDeferrableEvents;
  end
  else if Name = 'InternalTransitions' then begin
    ClearInternalTransitions;
  end
  else if Name = 'DoActivities' then begin
    ClearDoActivities;
  end
  else if Name = 'ClassifierStates' then begin
    ClearClassifierStates;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'EntryActions' then begin
    Result := IndexOfEntryAction(Value as PUMLAction);
  end
  else if Name = 'ExitActions' then begin
    Result := IndexOfExitAction(Value as PUMLAction);
  end
  else if Name = 'DeferrableEvents' then begin
    Result := IndexOfDeferrableEvent(Value as PUMLEvent);
  end
  else if Name = 'InternalTransitions' then begin
    Result := IndexOfInternalTransition(Value as PUMLTransition);
  end
  else if Name = 'DoActivities' then begin
    Result := IndexOfDoActivity(Value as PUMLAction);
  end
  else if Name = 'ClassifierStates' then begin
    Result := IndexOfClassifierState(Value as PUMLClassifierInState);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'EntryActions' then begin
    Result := EntryActions[Index];
  end
  else if Name = 'ExitActions' then begin
    Result := ExitActions[Index];
  end
  else if Name = 'DeferrableEvents' then begin
    Result := DeferrableEvents[Index];
  end
  else if Name = 'InternalTransitions' then begin
    Result := InternalTransitions[Index];
  end
  else if Name = 'DoActivities' then begin
    Result := DoActivities[Index];
  end
  else if Name = 'ClassifierStates' then begin
    Result := ClassifierStates[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLState.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'EntryActions' then begin
    Result := EntryActionCount;
  end
  else if Name = 'ExitActions' then begin
    Result := ExitActionCount;
  end
  else if Name = 'DeferrableEvents' then begin
    Result := DeferrableEventCount;
  end
  else if Name = 'InternalTransitions' then begin
    Result := InternalTransitionCount;
  end
  else if Name = 'DoActivities' then begin
    Result := DoActivityCount;
  end
  else if Name = 'ClassifierStates' then begin
    Result := ClassifierStateCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLState.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLAction') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;

function PUMLState.CanDelete: Boolean;
begin
  if StateMachine <> nil then
    Result := False
  else
    Result := inherited CanDelete;
end;

function PUMLState.CanPaste(Kind: string; CopyContext: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLAction') then
    Result := False
  else
    Result := inherited CanPaste(Kind, CopyContext);
end;

// PUMLState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSimpleState

constructor PUMLSimpleState.Create;
begin
  inherited;
end;

destructor PUMLSimpleState.Destroy;
begin
  inherited;
end;

function PUMLSimpleState.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLSimpleState.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLSimpleState.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLSimpleState.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLSimpleState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLSimpleState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLSimpleState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLSimpleState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLSimpleState.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLSimpleState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLSimpleState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLSimpleState.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLSimpleState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLObjectFlowState

constructor PUMLObjectFlowState.Create;
begin
  inherited;
  FParameters := POrderedSet.Create;
  FType_ := nil;
end;

destructor PUMLObjectFlowState.Destroy;
begin
  FParameters.Free;
  inherited;
end;

procedure PUMLObjectFlowState.SetIsSynch(Value: Boolean);
begin
  if FIsSynch <> Value then
    FIsSynch := Value;
end;

function PUMLObjectFlowState.GetParameter(Index: Integer): PUMLParameter;
begin
  Result := FParameters.Items[Index] as UMLModels.PUMLParameter;
end;

function PUMLObjectFlowState.GetParameterCount: Integer;
begin
  Result := FParameters.Count;
end;

procedure PUMLObjectFlowState.SetType_(Value: PUMLClassifier);
begin
  if FType_ <> Value then begin
    if FType_ <> nil then Type_.FObjectFlowStates.Remove(Self);
    FType_ := Value;
    if Value <> nil then begin
      Value.FObjectFlowStates.Add(Self);
    end;
  end;
end;

procedure PUMLObjectFlowState.ClearParameters;
var
  I: Integer;
begin
  for I := FParameters.Count - 1 downto 0 do
    DeleteParameter(I);
end;

procedure PUMLObjectFlowState.AddParameter(Value: PUMLParameter);
begin
  if Value <> nil then begin
    FParameters.Add(Value);
    Value.FStates.Add(Self);
  end;
end;

procedure PUMLObjectFlowState.RemoveParameter(Value: PUMLParameter);
begin
  if Value <> nil then begin
    FParameters.Remove(Value);
    Value.FStates.Remove(Self);
  end;
end;

procedure PUMLObjectFlowState.InsertParameter(Index: Integer; Value: PUMLParameter);
begin
  if Value <> nil then begin
    FParameters.Insert(Index, Value);
    Value.FStates.Add(Self);
  end;
end;

procedure PUMLObjectFlowState.DeleteParameter(Index: Integer);
begin
  RemoveParameter(FParameters.Items[Index] as UMLModels.PUMLParameter);
end;

function PUMLObjectFlowState.IndexOfParameter(Value: PUMLParameter): Integer;
begin
  Result := FParameters.IndexOf(Value);
end;

function PUMLObjectFlowState.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'IsSynch' then begin
    Result := BooleanToString(IsSynch);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLObjectFlowState.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'IsSynch' then begin
    IsSynch := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLObjectFlowState.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Type_' then begin
    Result := Type_;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLObjectFlowState.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Type_' then begin
    Type_ := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLObjectFlowState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Parameters' then begin
    AddParameter(Value as PUMLParameter);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLObjectFlowState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Parameters' then begin
    RemoveParameter(Value as PUMLParameter);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLObjectFlowState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Parameters' then begin
    InsertParameter(Index, Value as PUMLParameter);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLObjectFlowState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Parameters' then begin
    DeleteParameter(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLObjectFlowState.MOF_ClearCollection(Name: string);
begin
  if Name = 'Parameters' then begin
    ClearParameters;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLObjectFlowState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Parameters' then begin
    Result := IndexOfParameter(Value as PUMLParameter);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLObjectFlowState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Parameters' then begin
    Result := Parameters[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLObjectFlowState.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Parameters' then begin
    Result := ParameterCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLObjectFlowState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLActionState

constructor PUMLActionState.Create;
begin
  inherited;
end;

destructor PUMLActionState.Destroy;
begin
  inherited;
end;

procedure PUMLActionState.SetIsDynamic(Value: Boolean);
begin
  if FIsDynamic <> Value then
    FIsDynamic := Value;
end;

procedure PUMLActionState.SetDynamicArguments(Value: string);
begin
  if FDynamicArguments <> Value then
    FDynamicArguments := Value;
end;

procedure PUMLActionState.SetDynamicMultiplicity(Value: string);
begin
  if FDynamicMultiplicity <> Value then
    FDynamicMultiplicity := Value;
end;

function PUMLActionState.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'IsDynamic' then begin
    Result := BooleanToString(IsDynamic);
  end
  else if Name = 'DynamicArguments' then begin
    Result := DynamicArguments;
  end
  else if Name = 'DynamicMultiplicity' then begin
    Result := DynamicMultiplicity;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLActionState.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'IsDynamic' then begin
    IsDynamic := StringToBoolean(Value);
  end
  else if Name = 'DynamicArguments' then begin
    DynamicArguments := Value;
  end
  else if Name = 'DynamicMultiplicity' then begin
    DynamicMultiplicity := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLActionState.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLActionState.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLActionState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLActionState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLActionState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLActionState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLActionState.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLActionState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLActionState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLActionState.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLActionState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSignalAcceptState

constructor PUMLSignalAcceptState.Create;
begin
  inherited;
end;

destructor PUMLSignalAcceptState.Destroy;
begin
  inherited;
end;

function PUMLSignalAcceptState.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLSignalAcceptState.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLSignalAcceptState.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLSignalAcceptState.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLSignalAcceptState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLSignalAcceptState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLSignalAcceptState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLSignalAcceptState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLSignalAcceptState.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLSignalAcceptState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLSignalAcceptState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLSignalAcceptState.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLSignalAcceptState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLCallState

constructor PUMLCallState.Create;
begin
  inherited;
end;

destructor PUMLCallState.Destroy;
begin
  inherited;
end;

function PUMLCallState.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLCallState.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLCallState.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLCallState.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLCallState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLCallState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLCallState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLCallState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLCallState.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLCallState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLCallState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLCallState.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLCallState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSignalSendState

constructor PUMLSignalSendState.Create;
begin
  inherited;
end;

destructor PUMLSignalSendState.Destroy;
begin
  inherited;
end;

function PUMLSignalSendState.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLSignalSendState.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLSignalSendState.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLSignalSendState.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLSignalSendState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLSignalSendState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLSignalSendState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLSignalSendState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLSignalSendState.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLSignalSendState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLSignalSendState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLSignalSendState.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLSignalSendState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLCompositeState

constructor PUMLCompositeState.Create;
begin
  inherited;
  FSubvertices := POrderedSet.Create;
end;

destructor PUMLCompositeState.Destroy;
begin
  FSubvertices.Free;
  inherited;
end;

procedure PUMLCompositeState.SetIsConcurrent(Value: Boolean);
begin
  if FIsConcurrent <> Value then
    FIsConcurrent := Value;
end;

function PUMLCompositeState.GetSubvertex(Index: Integer): PUMLStateVertex;
begin
  Result := FSubvertices.Items[Index] as UMLModels.PUMLStateVertex;
end;

function PUMLCompositeState.GetSubvertexCount: Integer;
begin
  Result := FSubvertices.Count;
end;

procedure PUMLCompositeState.ClearSubvertices;
var
  I: Integer;
begin
  for I := FSubvertices.Count - 1 downto 0 do
    DeleteSubvertex(I);
end;

procedure PUMLCompositeState.AddSubvertex(Value: PUMLStateVertex);
begin
  if Value <> nil then begin
    if Value.FContainerState <> nil then begin
      Value.FContainerState.FSubvertices.Remove(Value);
      Value.FContainerState.RemoveVirtualOwnedModel(Value);
    end;
    FSubvertices.Add(Value);
    Value.FContainerState := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLCompositeState.RemoveSubvertex(Value: PUMLStateVertex);
begin
  if Value <> nil then begin
    FSubvertices.Remove(Value);
    Value.FContainerState := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLCompositeState.InsertSubvertex(Index: Integer; Value: PUMLStateVertex);
begin
  if Value <> nil then begin
    if Value.FContainerState <> nil then begin
      Value.FContainerState.FSubvertices.Remove(Value);
      Value.FContainerState.RemoveVirtualOwnedModel(Value);
    end;
    FSubvertices.Insert(Index, Value);
    Value.FContainerState := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLCompositeState.DeleteSubvertex(Index: Integer);
begin
  RemoveSubvertex(FSubvertices.Items[Index] as UMLModels.PUMLStateVertex);
end;

function PUMLCompositeState.IndexOfSubvertex(Value: PUMLStateVertex): Integer;
begin
  Result := FSubvertices.IndexOf(Value);
end;

function PUMLCompositeState.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'IsConcurrent' then begin
    Result := BooleanToString(IsConcurrent);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLCompositeState.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'IsConcurrent' then begin
    IsConcurrent := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLCompositeState.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLCompositeState.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLCompositeState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Subvertices' then begin
    AddSubvertex(Value as PUMLStateVertex);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLCompositeState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Subvertices' then begin
    RemoveSubvertex(Value as PUMLStateVertex);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLCompositeState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Subvertices' then begin
    InsertSubvertex(Index, Value as PUMLStateVertex);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLCompositeState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Subvertices' then begin
    DeleteSubvertex(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLCompositeState.MOF_ClearCollection(Name: string);
begin
  if Name = 'Subvertices' then begin
    ClearSubvertices;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLCompositeState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Subvertices' then begin
    Result := IndexOfSubvertex(Value as PUMLStateVertex);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLCompositeState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Subvertices' then begin
    Result := Subvertices[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLCompositeState.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Subvertices' then begin
    Result := SubvertexCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLCompositeState.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLStateVertex') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;

function PUMLCompositeState.CanRelocateTo(Model: PModel): Boolean;
begin
  if StateMachine <> nil then
    Result := False
  else
    Result := inherited CanRelocateTo(Model);
end;

// PUMLCompositeState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSubmachineState

constructor PUMLSubmachineState.Create;
begin
  inherited;
  FSubmachine := nil;
end;

destructor PUMLSubmachineState.Destroy;
begin
  inherited;
end;

procedure PUMLSubmachineState.SetSubmachine(Value: PUMLStateMachine);
begin
  if FSubmachine <> Value then begin
    if FSubmachine <> nil then Submachine.FSubmachineStates.Remove(Self);
    FSubmachine := Value;
    if Value <> nil then begin
      Value.FSubmachineStates.Add(Self);
    end;
  end;
end;

function PUMLSubmachineState.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLSubmachineState.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLSubmachineState.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Submachine' then begin
    Result := Submachine;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLSubmachineState.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Submachine' then begin
    Submachine := Value as PUMLStateMachine;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLSubmachineState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLSubmachineState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLSubmachineState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLSubmachineState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLSubmachineState.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLSubmachineState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLSubmachineState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLSubmachineState.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLSubmachineState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSubactivityState

constructor PUMLSubactivityState.Create;
begin
  inherited;
end;

destructor PUMLSubactivityState.Destroy;
begin
  inherited;
end;

procedure PUMLSubactivityState.SetIsDynamic(Value: Boolean);
begin
  if FIsDynamic <> Value then
    FIsDynamic := Value;
end;

procedure PUMLSubactivityState.SetDynamicArguments(Value: string);
begin
  if FDynamicArguments <> Value then
    FDynamicArguments := Value;
end;

procedure PUMLSubactivityState.SetDynamicMultiplicity(Value: string);
begin
  if FDynamicMultiplicity <> Value then
    FDynamicMultiplicity := Value;
end;

function PUMLSubactivityState.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'IsDynamic' then begin
    Result := BooleanToString(IsDynamic);
  end
  else if Name = 'DynamicArguments' then begin
    Result := DynamicArguments;
  end
  else if Name = 'DynamicMultiplicity' then begin
    Result := DynamicMultiplicity;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLSubactivityState.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'IsDynamic' then begin
    IsDynamic := StringToBoolean(Value);
  end
  else if Name = 'DynamicArguments' then begin
    DynamicArguments := Value;
  end
  else if Name = 'DynamicMultiplicity' then begin
    DynamicMultiplicity := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLSubactivityState.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLSubactivityState.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLSubactivityState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLSubactivityState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLSubactivityState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLSubactivityState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLSubactivityState.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLSubactivityState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLSubactivityState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLSubactivityState.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLSubactivityState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLFinalState

constructor PUMLFinalState.Create;
begin
  inherited;
end;

destructor PUMLFinalState.Destroy;
begin
  inherited;
end;

function PUMLFinalState.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLFinalState.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLFinalState.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLFinalState.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLFinalState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLFinalState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLFinalState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLFinalState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLFinalState.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLFinalState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLFinalState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLFinalState.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLFinalState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLFlowFinalState

constructor PUMLFlowFinalState.Create;
begin
  inherited;
end;

destructor PUMLFlowFinalState.Destroy;
begin
  inherited;
end;

function PUMLFlowFinalState.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLFlowFinalState.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLFlowFinalState.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLFlowFinalState.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLFlowFinalState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLFlowFinalState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLFlowFinalState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLFlowFinalState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLFlowFinalState.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLFlowFinalState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLFlowFinalState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLFlowFinalState.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLFlowFinalState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLInteraction

constructor PUMLInteraction.Create;
begin
  inherited;
  FMessages := POrderedSet.Create;
  FContext := nil;
  FInteractionInstanceSets := POrderedSet.Create;
  FFragments := POrderedSet.Create;
  FOwnedFrames := POrderedSet.Create;
end;

destructor PUMLInteraction.Destroy;
begin
  FMessages.Free;
  FInteractionInstanceSets.Free;
  FFragments.Free;
  FOwnedFrames.Free;
  inherited;
end;

function PUMLInteraction.GetMessage(Index: Integer): PUMLMessage;
begin
  Result := FMessages.Items[Index] as UMLModels.PUMLMessage;
end;

function PUMLInteraction.GetMessageCount: Integer;
begin
  Result := FMessages.Count;
end;

procedure PUMLInteraction.SetContext(Value: PUMLCollaboration);
begin
  if FContext <> Value then begin
    if FContext <> nil then begin
      FContext.FInteractions.Remove(Self);
      FContext.RemoveVirtualOwnedModel(Self);
    end;
    FContext := Value;
    if Value <> nil then begin
      Value.FInteractions.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLInteraction.GetInteractionInstanceSet(Index: Integer): PUMLInteractionInstanceSet;
begin
  Result := FInteractionInstanceSets.Items[Index] as UMLModels.PUMLInteractionInstanceSet;
end;

function PUMLInteraction.GetInteractionInstanceSetCount: Integer;
begin
  Result := FInteractionInstanceSets.Count;
end;

function PUMLInteraction.GetFragment(Index: Integer): PUMLInteractionFragment;
begin
  Result := FFragments.Items[Index] as UMLModels.PUMLInteractionFragment;
end;

function PUMLInteraction.GetFragmentCount: Integer;
begin
  Result := FFragments.Count;
end;

function PUMLInteraction.GetOwnedFrame(Index: Integer): PUMLFrame;
begin
  Result := FOwnedFrames.Items[Index] as UMLModels.PUMLFrame;
end;

function PUMLInteraction.GetOwnedFrameCount: Integer;
begin
  Result := FOwnedFrames.Count;
end;

procedure PUMLInteraction.ClearMessages;
var
  I: Integer;
begin
  for I := FMessages.Count - 1 downto 0 do
    DeleteMessage(I);
end;

procedure PUMLInteraction.AddMessage(Value: PUMLMessage);
begin
  if Value <> nil then begin
    if Value.FInteraction <> nil then begin
      Value.FInteraction.FMessages.Remove(Value);
      Value.FInteraction.RemoveVirtualOwnedModel(Value);
    end;
    FMessages.Add(Value);
    Value.FInteraction := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteraction.RemoveMessage(Value: PUMLMessage);
begin
  if Value <> nil then begin
    FMessages.Remove(Value);
    Value.FInteraction := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteraction.InsertMessage(Index: Integer; Value: PUMLMessage);
begin
  if Value <> nil then begin
    if Value.FInteraction <> nil then begin
      Value.FInteraction.FMessages.Remove(Value);
      Value.FInteraction.RemoveVirtualOwnedModel(Value);
    end;
    FMessages.Insert(Index, Value);
    Value.FInteraction := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLInteraction.DeleteMessage(Index: Integer);
begin
  RemoveMessage(FMessages.Items[Index] as UMLModels.PUMLMessage);
end;

function PUMLInteraction.IndexOfMessage(Value: PUMLMessage): Integer;
begin
  Result := FMessages.IndexOf(Value);
end;

procedure PUMLInteraction.ClearInteractionInstanceSets;
var
  I: Integer;
begin
  for I := FInteractionInstanceSets.Count - 1 downto 0 do
    DeleteInteractionInstanceSet(I);
end;

procedure PUMLInteraction.AddInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
begin
  if Value <> nil then begin
    if Value.FInteraction <> nil then Value.FInteraction.FInteractionInstanceSets.Remove(Value);
    FInteractionInstanceSets.Add(Value);
    Value.FInteraction := Self;
  end;
end;

procedure PUMLInteraction.RemoveInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
begin
  if Value <> nil then begin
    FInteractionInstanceSets.Remove(Value);
    Value.FInteraction := nil;
  end;
end;

procedure PUMLInteraction.InsertInteractionInstanceSet(Index: Integer; Value: PUMLInteractionInstanceSet);
begin
  if Value <> nil then begin
    if Value.FInteraction <> nil then Value.FInteraction.FInteractionInstanceSets.Remove(Value);
    FInteractionInstanceSets.Insert(Index, Value);
    Value.FInteraction := Self;
  end;
end;

procedure PUMLInteraction.DeleteInteractionInstanceSet(Index: Integer);
begin
  RemoveInteractionInstanceSet(FInteractionInstanceSets.Items[Index] as UMLModels.PUMLInteractionInstanceSet);
end;

function PUMLInteraction.IndexOfInteractionInstanceSet(Value: PUMLInteractionInstanceSet): Integer;
begin
  Result := FInteractionInstanceSets.IndexOf(Value);
end;

procedure PUMLInteraction.ClearFragments;
var
  I: Integer;
begin
  for I := FFragments.Count - 1 downto 0 do
    DeleteFragment(I);
end;

procedure PUMLInteraction.AddFragment(Value: PUMLInteractionFragment);
begin
  if Value <> nil then begin
    if Value.FEnclosingInteraction <> nil then begin
      Value.FEnclosingInteraction.FFragments.Remove(Value);
      Value.FEnclosingInteraction.RemoveVirtualOwnedModel(Value);
    end;
    FFragments.Add(Value);
    Value.FEnclosingInteraction := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteraction.RemoveFragment(Value: PUMLInteractionFragment);
begin
  if Value <> nil then begin
    FFragments.Remove(Value);
    Value.FEnclosingInteraction := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteraction.InsertFragment(Index: Integer; Value: PUMLInteractionFragment);
begin
  if Value <> nil then begin
    if Value.FEnclosingInteraction <> nil then begin
      Value.FEnclosingInteraction.FFragments.Remove(Value);
      Value.FEnclosingInteraction.RemoveVirtualOwnedModel(Value);
    end;
    FFragments.Insert(Index, Value);
    Value.FEnclosingInteraction := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLInteraction.DeleteFragment(Index: Integer);
begin
  RemoveFragment(FFragments.Items[Index] as UMLModels.PUMLInteractionFragment);
end;

function PUMLInteraction.IndexOfFragment(Value: PUMLInteractionFragment): Integer;
begin
  Result := FFragments.IndexOf(Value);
end;

procedure PUMLInteraction.ClearOwnedFrames;
var
  I: Integer;
begin
  for I := FOwnedFrames.Count - 1 downto 0 do
    DeleteOwnedFrame(I);
end;

procedure PUMLInteraction.AddOwnedFrame(Value: PUMLFrame);
begin
  if Value <> nil then begin
    if Value.FInteraction <> nil then begin
      Value.FInteraction.FOwnedFrames.Remove(Value);
      Value.FInteraction.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedFrames.Add(Value);
    Value.FInteraction := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteraction.RemoveOwnedFrame(Value: PUMLFrame);
begin
  if Value <> nil then begin
    FOwnedFrames.Remove(Value);
    Value.FInteraction := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLInteraction.InsertOwnedFrame(Index: Integer; Value: PUMLFrame);
begin
  if Value <> nil then begin
    if Value.FInteraction <> nil then begin
      Value.FInteraction.FOwnedFrames.Remove(Value);
      Value.FInteraction.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedFrames.Insert(Index, Value);
    Value.FInteraction := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLInteraction.DeleteOwnedFrame(Index: Integer);
begin
  RemoveOwnedFrame(FOwnedFrames.Items[Index] as UMLModels.PUMLFrame);
end;

function PUMLInteraction.IndexOfOwnedFrame(Value: PUMLFrame): Integer;
begin
  Result := FOwnedFrames.IndexOf(Value);
end;

function PUMLInteraction.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLInteraction.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLInteraction.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Context' then begin
    Result := Context;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLInteraction.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Context' then begin
    Context := Value as PUMLCollaboration;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLInteraction.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Messages' then begin
    AddMessage(Value as PUMLMessage);
  end
  else if Name = 'InteractionInstanceSets' then begin
    AddInteractionInstanceSet(Value as PUMLInteractionInstanceSet);
  end
  else if Name = 'Fragments' then begin
    AddFragment(Value as PUMLInteractionFragment);
  end
  else if Name = 'OwnedFrames' then begin
    AddOwnedFrame(Value as PUMLFrame);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLInteraction.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Messages' then begin
    RemoveMessage(Value as PUMLMessage);
  end
  else if Name = 'InteractionInstanceSets' then begin
    RemoveInteractionInstanceSet(Value as PUMLInteractionInstanceSet);
  end
  else if Name = 'Fragments' then begin
    RemoveFragment(Value as PUMLInteractionFragment);
  end
  else if Name = 'OwnedFrames' then begin
    RemoveOwnedFrame(Value as PUMLFrame);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLInteraction.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Messages' then begin
    InsertMessage(Index, Value as PUMLMessage);
  end
  else if Name = 'InteractionInstanceSets' then begin
    InsertInteractionInstanceSet(Index, Value as PUMLInteractionInstanceSet);
  end
  else if Name = 'Fragments' then begin
    InsertFragment(Index, Value as PUMLInteractionFragment);
  end
  else if Name = 'OwnedFrames' then begin
    InsertOwnedFrame(Index, Value as PUMLFrame);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLInteraction.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Messages' then begin
    DeleteMessage(Index);
  end
  else if Name = 'InteractionInstanceSets' then begin
    DeleteInteractionInstanceSet(Index);
  end
  else if Name = 'Fragments' then begin
    DeleteFragment(Index);
  end
  else if Name = 'OwnedFrames' then begin
    DeleteOwnedFrame(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLInteraction.MOF_ClearCollection(Name: string);
begin
  if Name = 'Messages' then begin
    ClearMessages;
  end
  else if Name = 'InteractionInstanceSets' then begin
    ClearInteractionInstanceSets;
  end
  else if Name = 'Fragments' then begin
    ClearFragments;
  end
  else if Name = 'OwnedFrames' then begin
    ClearOwnedFrames;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLInteraction.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Messages' then begin
    Result := IndexOfMessage(Value as PUMLMessage);
  end
  else if Name = 'InteractionInstanceSets' then begin
    Result := IndexOfInteractionInstanceSet(Value as PUMLInteractionInstanceSet);
  end
  else if Name = 'Fragments' then begin
    Result := IndexOfFragment(Value as PUMLInteractionFragment);
  end
  else if Name = 'OwnedFrames' then begin
    Result := IndexOfOwnedFrame(Value as PUMLFrame);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLInteraction.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Messages' then begin
    Result := Messages[Index];
  end
  else if Name = 'InteractionInstanceSets' then begin
    Result := InteractionInstanceSets[Index];
  end
  else if Name = 'Fragments' then begin
    Result := Fragments[Index];
  end
  else if Name = 'OwnedFrames' then begin
    Result := OwnedFrames[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLInteraction.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Messages' then begin
    Result := MessageCount;
  end
  else if Name = 'InteractionInstanceSets' then begin
    Result := InteractionInstanceSetCount;
  end
  else if Name = 'Fragments' then begin
    Result := FragmentCount;
  end
  else if Name = 'OwnedFrames' then begin
    Result := OwnedFrameCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLInteraction.CanContainDiagramKind(Kind: string): Boolean;
begin
  Result := (Kind = 'UMLSequenceRoleDiagram') or
    (Kind = 'UMLCollaborationRoleDiagram');
end;

function PUMLInteraction.CanContainDiagram(Diagram: PDiagram): Boolean;
begin
  if OwnedDiagramCount > 0 then
    Result := False
  else
    Result := inherited CanContainDiagram(Diagram);
end;

function PUMLInteraction.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLMessage') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;

function PUMLInteraction.CanRelocateTo(Model: PModel): Boolean;
begin
  if MessageCount > 0 then
    Result := False
  else
    Result := inherited CanRelocateTo(Model);
end;

function PUMLInteraction.CanPaste(Kind: string; CopyContext: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLSequenceDiagram') or
     MetaModel.IsKindOf(Kind, 'UMLCollaborationDiagram') then
    Result := (OwnedDiagramCount = 0) and (GUID = CopyContext)
  else
    Result := inherited CanPaste(Kind, CopyContext);
end;
    

// PUMLInteraction
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLMessage

constructor PUMLMessage.Create;
begin
  inherited;
  FInteraction := nil;
  FActivator := nil;
  FActivatees := POrderedSet.Create;
  FSender := nil;
  FReceiver := nil;
  FSuccessor := nil;
  FPredecessor := nil;
  FCommunicationConnection := nil;
  FAction := nil;
  FConformingStimuli := POrderedSet.Create;
end;

destructor PUMLMessage.Destroy;
begin
  FActivatees.Free;
  FConformingStimuli.Free;
  inherited;
end;

procedure PUMLMessage.SetArguments(Value: string);
begin
  if FArguments <> Value then
    FArguments := Value;
end;

procedure PUMLMessage.SetReturn(Value: string);
begin
  if FReturn <> Value then
    FReturn := Value;
end;

procedure PUMLMessage.SetIteration(Value: string);
begin
  if FIteration <> Value then
    FIteration := Value;
end;

procedure PUMLMessage.SetBranch(Value: string);
begin
  if FBranch <> Value then
    FBranch := Value;
end;

procedure PUMLMessage.SetInteraction(Value: PUMLInteraction);
begin
  if FInteraction <> Value then begin
    if FInteraction <> nil then begin
      FInteraction.FMessages.Remove(Self);
      FInteraction.RemoveVirtualOwnedModel(Self);
    end;
    FInteraction := Value;
    if Value <> nil then begin
      Value.FMessages.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLMessage.SetActivator(Value: PUMLMessage);
begin
  if FActivator <> Value then begin
    if FActivator <> nil then Activator.FActivatees.Remove(Self);
    FActivator := Value;
    if Value <> nil then begin
      Value.FActivatees.Add(Self);
    end;
  end;
end;

function PUMLMessage.GetActivatee(Index: Integer): PUMLMessage;
begin
  Result := FActivatees.Items[Index] as UMLModels.PUMLMessage;
end;

function PUMLMessage.GetActivateeCount: Integer;
begin
  Result := FActivatees.Count;
end;

procedure PUMLMessage.SetSender(Value: PUMLClassifierRole);
begin
  if FSender <> Value then begin
    if FSender <> nil then Sender.FSenderClientMessages.Remove(Self);
    FSender := Value;
    if Value <> nil then begin
      Value.FSenderClientMessages.Add(Self);
    end;
  end;
end;

procedure PUMLMessage.SetReceiver(Value: PUMLClassifierRole);
begin
  if FReceiver <> Value then begin
    if FReceiver <> nil then Receiver.FReceiverClientMessages.Remove(Self);
    FReceiver := Value;
    if Value <> nil then begin
      Value.FReceiverClientMessages.Add(Self);
    end;
  end;
end;

procedure PUMLMessage.SetSuccessor(Value: PUMLMessage);
begin
  if FSuccessor <> Value then begin
    if FSuccessor <> nil then Successor.FPredecessor := nil;
    FSuccessor := Value;
    if Value <> nil then Value.FPredecessor := Self;
  end;
end;

procedure PUMLMessage.SetPredecessor(Value: PUMLMessage);
begin
  if FPredecessor <> Value then begin
    if FPredecessor <> nil then Predecessor.FSuccessor := nil;
    FPredecessor := Value;
    if Value <> nil then Value.FSuccessor := Self;
  end;
end;

procedure PUMLMessage.SetCommunicationConnection(Value: PUMLAssociationRole);
begin
  if FCommunicationConnection <> Value then begin
    if FCommunicationConnection <> nil then CommunicationConnection.FMessages.Remove(Self);
    FCommunicationConnection := Value;
    if Value <> nil then begin
      Value.FMessages.Add(Self);
    end;
  end;
end;

procedure PUMLMessage.SetAction(Value: PUMLAction);
begin
  if FAction <> Value then begin
    if FAction <> nil then Action.FMessage := nil;
    RemoveVirtualOwnedModel(FAction);
    FAction := Value;
    AddVirtualOwnedModel(FAction);
    if Value <> nil then Value.FMessage := Self;
  end;
end;

function PUMLMessage.GetConformingStimulus(Index: Integer): PUMLStimulus;
begin
  Result := FConformingStimuli.Items[Index] as UMLModels.PUMLStimulus;
end;

function PUMLMessage.GetConformingStimulusCount: Integer;
begin
  Result := FConformingStimuli.Count;
end;

procedure PUMLMessage.ClearActivatees;
var
  I: Integer;
begin
  for I := FActivatees.Count - 1 downto 0 do
    DeleteActivatee(I);
end;

procedure PUMLMessage.AddActivatee(Value: PUMLMessage);
begin
  if Value <> nil then begin
    if Value.FActivator <> nil then Value.FActivator.FActivatees.Remove(Value);
    FActivatees.Add(Value);
    Value.FActivator := Self;
  end;
end;

procedure PUMLMessage.RemoveActivatee(Value: PUMLMessage);
begin
  if Value <> nil then begin
    FActivatees.Remove(Value);
    Value.FActivator := nil;
  end;
end;

procedure PUMLMessage.InsertActivatee(Index: Integer; Value: PUMLMessage);
begin
  if Value <> nil then begin
    if Value.FActivator <> nil then Value.FActivator.FActivatees.Remove(Value);
    FActivatees.Insert(Index, Value);
    Value.FActivator := Self;
  end;
end;

procedure PUMLMessage.DeleteActivatee(Index: Integer);
begin
  RemoveActivatee(FActivatees.Items[Index] as UMLModels.PUMLMessage);
end;

function PUMLMessage.IndexOfActivatee(Value: PUMLMessage): Integer;
begin
  Result := FActivatees.IndexOf(Value);
end;

procedure PUMLMessage.ClearConformingStimuli;
var
  I: Integer;
begin
  for I := FConformingStimuli.Count - 1 downto 0 do
    DeleteConformingStimulus(I);
end;

procedure PUMLMessage.AddConformingStimulus(Value: PUMLStimulus);
begin
  if Value <> nil then begin
    FConformingStimuli.Add(Value);
    Value.FPlayedRoles.Add(Self);
  end;
end;

procedure PUMLMessage.RemoveConformingStimulus(Value: PUMLStimulus);
begin
  if Value <> nil then begin
    FConformingStimuli.Remove(Value);
    Value.FPlayedRoles.Remove(Self);
  end;
end;

procedure PUMLMessage.InsertConformingStimulus(Index: Integer; Value: PUMLStimulus);
begin
  if Value <> nil then begin
    FConformingStimuli.Insert(Index, Value);
    Value.FPlayedRoles.Add(Self);
  end;
end;

procedure PUMLMessage.DeleteConformingStimulus(Index: Integer);
begin
  RemoveConformingStimulus(FConformingStimuli.Items[Index] as UMLModels.PUMLStimulus);
end;

function PUMLMessage.IndexOfConformingStimulus(Value: PUMLStimulus): Integer;
begin
  Result := FConformingStimuli.IndexOf(Value);
end;

function PUMLMessage.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Arguments' then begin
    Result := Arguments;
  end
  else if Name = 'Return' then begin
    Result := Return;
  end
  else if Name = 'Iteration' then begin
    Result := Iteration;
  end
  else if Name = 'Branch' then begin
    Result := Branch;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLMessage.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Arguments' then begin
    Arguments := Value;
  end
  else if Name = 'Return' then begin
    Return := Value;
  end
  else if Name = 'Iteration' then begin
    Iteration := Value;
  end
  else if Name = 'Branch' then begin
    Branch := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLMessage.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Interaction' then begin
    Result := Interaction;
  end
  else if Name = 'Activator' then begin
    Result := Activator;
  end
  else if Name = 'Sender' then begin
    Result := Sender;
  end
  else if Name = 'Receiver' then begin
    Result := Receiver;
  end
  else if Name = 'Successor' then begin
    Result := Successor;
  end
  else if Name = 'Predecessor' then begin
    Result := Predecessor;
  end
  else if Name = 'CommunicationConnection' then begin
    Result := CommunicationConnection;
  end
  else if Name = 'Action' then begin
    Result := Action;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLMessage.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Interaction' then begin
    Interaction := Value as PUMLInteraction;
  end
  else if Name = 'Activator' then begin
    Activator := Value as PUMLMessage;
  end
  else if Name = 'Sender' then begin
    Sender := Value as PUMLClassifierRole;
  end
  else if Name = 'Receiver' then begin
    Receiver := Value as PUMLClassifierRole;
  end
  else if Name = 'Successor' then begin
    Successor := Value as PUMLMessage;
  end
  else if Name = 'Predecessor' then begin
    Predecessor := Value as PUMLMessage;
  end
  else if Name = 'CommunicationConnection' then begin
    CommunicationConnection := Value as PUMLAssociationRole;
  end
  else if Name = 'Action' then begin
    Action := Value as PUMLAction;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLMessage.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Activatees' then begin
    AddActivatee(Value as PUMLMessage);
  end
  else if Name = 'ConformingStimuli' then begin
    AddConformingStimulus(Value as PUMLStimulus);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLMessage.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Activatees' then begin
    RemoveActivatee(Value as PUMLMessage);
  end
  else if Name = 'ConformingStimuli' then begin
    RemoveConformingStimulus(Value as PUMLStimulus);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLMessage.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Activatees' then begin
    InsertActivatee(Index, Value as PUMLMessage);
  end
  else if Name = 'ConformingStimuli' then begin
    InsertConformingStimulus(Index, Value as PUMLStimulus);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLMessage.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Activatees' then begin
    DeleteActivatee(Index);
  end
  else if Name = 'ConformingStimuli' then begin
    DeleteConformingStimulus(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLMessage.MOF_ClearCollection(Name: string);
begin
  if Name = 'Activatees' then begin
    ClearActivatees;
  end
  else if Name = 'ConformingStimuli' then begin
    ClearConformingStimuli;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLMessage.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Activatees' then begin
    Result := IndexOfActivatee(Value as PUMLMessage);
  end
  else if Name = 'ConformingStimuli' then begin
    Result := IndexOfConformingStimulus(Value as PUMLStimulus);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLMessage.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Activatees' then begin
    Result := Activatees[Index];
  end
  else if Name = 'ConformingStimuli' then begin
    Result := ConformingStimuli[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLMessage.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Activatees' then begin
    Result := ActivateeCount;
  end
  else if Name = 'ConformingStimuli' then begin
    Result := ConformingStimulusCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLMessage.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLAction') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;


function PUMLMessage.CanRelocateTo(Model: PModel): Boolean;
begin
  Result := False;
end;

function PUMLMessage.CanCopy: Boolean;
begin
  Result := False;
end;

function PUMLMessage.CanPaste(Kind: string; CopyContext: string): Boolean;
begin
  Result := False;
end;

// PUMLMessage
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLAssociationClass

constructor PUMLAssociationClass.Create;
begin
  inherited;
  FClassSide := nil;
  FAssociationSide := nil;
end;

destructor PUMLAssociationClass.Destroy;
begin
  inherited;
end;

function PUMLAssociationClass.FindRelatedModel(FirstElement: PModel): PModel;
begin
  if FirstElement = ClassSide then
    Result := AssociationSide
  else if FirstElement = AssociationSide then
    Result := ClassSide
  else
    Result := nil; // First element does not match
end;

procedure PUMLAssociationClass.SetClassSide(Value: PUMLClass);
begin
  if FClassSide <> Value then begin
    if FClassSide <> nil then ClassSide.FAssociationClass := nil;
    FClassSide := Value;
    if Value <> nil then Value.FAssociationClass := Self;
  end;
end;

procedure PUMLAssociationClass.SetAssociationSide(Value: PUMLAssociation);
begin
  if FAssociationSide <> Value then begin
    if FAssociationSide <> nil then AssociationSide.FAssociationClass := nil;
    FAssociationSide := Value;
    if Value <> nil then Value.FAssociationClass := Self;
  end;
end;

function PUMLAssociationClass.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLAssociationClass.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLAssociationClass.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'ClassSide' then begin
    Result := ClassSide;
  end
  else if Name = 'AssociationSide' then begin
    Result := AssociationSide;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLAssociationClass.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'ClassSide' then begin
    ClassSide := Value as PUMLClass;
  end
  else if Name = 'AssociationSide' then begin
    AssociationSide := Value as PUMLAssociation;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLAssociationClass.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLAssociationClass.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLAssociationClass.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLAssociationClass.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLAssociationClass.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLAssociationClass.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLAssociationClass.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLAssociationClass.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

function PUMLAssociationClass.CanCopy: Boolean;
begin
  Result := False;
end;

// PUMLAssociationClass
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLStateMachine

constructor PUMLStateMachine.Create;
begin
  inherited;
  FContext := nil;
  FTop := nil;
  FTransitions := POrderedSet.Create;
  FSubmachineStates := POrderedSet.Create;
end;

destructor PUMLStateMachine.Destroy;
begin
  FTransitions.Free;
  FSubmachineStates.Free;
  inherited;
end;

procedure PUMLStateMachine.SetContext(Value: PUMLModelElement);
begin
  if FContext <> Value then begin
    if FContext <> nil then begin
      FContext.FBehaviors.Remove(Self);
      FContext.RemoveVirtualOwnedModel(Self);
    end;
    FContext := Value;
    if Value <> nil then begin
      Value.FBehaviors.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLStateMachine.SetTop(Value: PUMLState);
begin
  if FTop <> Value then begin
    if FTop <> nil then Top.FStateMachine := nil;
    RemoveVirtualOwnedModel(FTop);
    FTop := Value;
    AddVirtualOwnedModel(FTop);
    if Value <> nil then Value.FStateMachine := Self;
  end;
end;

function PUMLStateMachine.GetTransition(Index: Integer): PUMLTransition;
begin
  Result := FTransitions.Items[Index] as UMLModels.PUMLTransition;
end;

function PUMLStateMachine.GetTransitionCount: Integer;
begin
  Result := FTransitions.Count;
end;

function PUMLStateMachine.GetSubmachineState(Index: Integer): PUMLSubmachineState;
begin
  Result := FSubmachineStates.Items[Index] as UMLModels.PUMLSubmachineState;
end;

function PUMLStateMachine.GetSubmachineStateCount: Integer;
begin
  Result := FSubmachineStates.Count;
end;

procedure PUMLStateMachine.ClearTransitions;
var
  I: Integer;
begin
  for I := FTransitions.Count - 1 downto 0 do
    DeleteTransition(I);
end;

procedure PUMLStateMachine.AddTransition(Value: PUMLTransition);
begin
  if Value <> nil then begin
    if Value.FStateMachine <> nil then begin
      Value.FStateMachine.FTransitions.Remove(Value);
      Value.FStateMachine.RemoveVirtualOwnedModel(Value);
    end;
    FTransitions.Add(Value);
    Value.FStateMachine := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLStateMachine.RemoveTransition(Value: PUMLTransition);
begin
  if Value <> nil then begin
    FTransitions.Remove(Value);
    Value.FStateMachine := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLStateMachine.InsertTransition(Index: Integer; Value: PUMLTransition);
begin
  if Value <> nil then begin
    if Value.FStateMachine <> nil then begin
      Value.FStateMachine.FTransitions.Remove(Value);
      Value.FStateMachine.RemoveVirtualOwnedModel(Value);
    end;
    FTransitions.Insert(Index, Value);
    Value.FStateMachine := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLStateMachine.DeleteTransition(Index: Integer);
begin
  RemoveTransition(FTransitions.Items[Index] as UMLModels.PUMLTransition);
end;

function PUMLStateMachine.IndexOfTransition(Value: PUMLTransition): Integer;
begin
  Result := FTransitions.IndexOf(Value);
end;

procedure PUMLStateMachine.ClearSubmachineStates;
var
  I: Integer;
begin
  for I := FSubmachineStates.Count - 1 downto 0 do
    DeleteSubmachineState(I);
end;

procedure PUMLStateMachine.AddSubmachineState(Value: PUMLSubmachineState);
begin
  if Value <> nil then begin
    if Value.FSubmachine <> nil then Value.FSubmachine.FSubmachineStates.Remove(Value);
    FSubmachineStates.Add(Value);
    Value.FSubmachine := Self;
  end;
end;

procedure PUMLStateMachine.RemoveSubmachineState(Value: PUMLSubmachineState);
begin
  if Value <> nil then begin
    FSubmachineStates.Remove(Value);
    Value.FSubmachine := nil;
  end;
end;

procedure PUMLStateMachine.InsertSubmachineState(Index: Integer; Value: PUMLSubmachineState);
begin
  if Value <> nil then begin
    if Value.FSubmachine <> nil then Value.FSubmachine.FSubmachineStates.Remove(Value);
    FSubmachineStates.Insert(Index, Value);
    Value.FSubmachine := Self;
  end;
end;

procedure PUMLStateMachine.DeleteSubmachineState(Index: Integer);
begin
  RemoveSubmachineState(FSubmachineStates.Items[Index] as UMLModels.PUMLSubmachineState);
end;

function PUMLStateMachine.IndexOfSubmachineState(Value: PUMLSubmachineState): Integer;
begin
  Result := FSubmachineStates.IndexOf(Value);
end;

function PUMLStateMachine.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLStateMachine.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLStateMachine.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Context' then begin
    Result := Context;
  end
  else if Name = 'Top' then begin
    Result := Top;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLStateMachine.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Context' then begin
    Context := Value as PUMLModelElement;
  end
  else if Name = 'Top' then begin
    Top := Value as PUMLState;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLStateMachine.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Transitions' then begin
    AddTransition(Value as PUMLTransition);
  end
  else if Name = 'SubmachineStates' then begin
    AddSubmachineState(Value as PUMLSubmachineState);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLStateMachine.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Transitions' then begin
    RemoveTransition(Value as PUMLTransition);
  end
  else if Name = 'SubmachineStates' then begin
    RemoveSubmachineState(Value as PUMLSubmachineState);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLStateMachine.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Transitions' then begin
    InsertTransition(Index, Value as PUMLTransition);
  end
  else if Name = 'SubmachineStates' then begin
    InsertSubmachineState(Index, Value as PUMLSubmachineState);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLStateMachine.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Transitions' then begin
    DeleteTransition(Index);
  end
  else if Name = 'SubmachineStates' then begin
    DeleteSubmachineState(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLStateMachine.MOF_ClearCollection(Name: string);
begin
  if Name = 'Transitions' then begin
    ClearTransitions;
  end
  else if Name = 'SubmachineStates' then begin
    ClearSubmachineStates;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLStateMachine.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Transitions' then begin
    Result := IndexOfTransition(Value as PUMLTransition);
  end
  else if Name = 'SubmachineStates' then begin
    Result := IndexOfSubmachineState(Value as PUMLSubmachineState);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLStateMachine.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Transitions' then begin
    Result := Transitions[Index];
  end
  else if Name = 'SubmachineStates' then begin
    Result := SubmachineStates[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLStateMachine.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Transitions' then begin
    Result := TransitionCount;
  end
  else if Name = 'SubmachineStates' then begin
    Result := SubmachineStateCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLStateMachine.CanContainDiagramKind(Kind: string): Boolean;
begin
  Result := (Kind = 'UMLStateDiagram');
end;

function PUMLStateMachine.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLCompositeState') or
     MetaModel.IsKindOf(Kind, 'UMLTransition') then
    Result := True
  else if MetaModel.IsKindOf(Kind, 'UMLElement') then
    Result := False
  else
    Result := inherited CanContainKind(Kind);
end;

function PUMLStateMachine.CanPaste(Kind: string; CopyContext: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLStatechartDiagram') then
    Result := (GUID = CopyContext)
  else if MetaModel.IsKindOf(Kind, 'UMLState') then
    Result := False
  else
    Result := inherited CanPaste(Kind, CopyContext);
end;

// PUMLStateMachine
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLActivityGraph

constructor PUMLActivityGraph.Create;
begin
  inherited;
  FPartitions := POrderedSet.Create;
end;

destructor PUMLActivityGraph.Destroy;
begin
  FPartitions.Free;
  inherited;
end;

function PUMLActivityGraph.GetPartition(Index: Integer): PUMLPartition;
begin
  Result := FPartitions.Items[Index] as UMLModels.PUMLPartition;
end;

function PUMLActivityGraph.GetPartitionCount: Integer;
begin
  Result := FPartitions.Count;
end;

procedure PUMLActivityGraph.ClearPartitions;
var
  I: Integer;
begin
  for I := FPartitions.Count - 1 downto 0 do
    DeletePartition(I);
end;

procedure PUMLActivityGraph.AddPartition(Value: PUMLPartition);
begin
  if Value <> nil then begin
    if Value.FActivityGraph <> nil then begin
      Value.FActivityGraph.FPartitions.Remove(Value);
      Value.FActivityGraph.RemoveVirtualOwnedModel(Value);
    end;
    FPartitions.Add(Value);
    Value.FActivityGraph := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLActivityGraph.RemovePartition(Value: PUMLPartition);
begin
  if Value <> nil then begin
    FPartitions.Remove(Value);
    Value.FActivityGraph := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLActivityGraph.InsertPartition(Index: Integer; Value: PUMLPartition);
begin
  if Value <> nil then begin
    if Value.FActivityGraph <> nil then begin
      Value.FActivityGraph.FPartitions.Remove(Value);
      Value.FActivityGraph.RemoveVirtualOwnedModel(Value);
    end;
    FPartitions.Insert(Index, Value);
    Value.FActivityGraph := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLActivityGraph.DeletePartition(Index: Integer);
begin
  RemovePartition(FPartitions.Items[Index] as UMLModels.PUMLPartition);
end;

function PUMLActivityGraph.IndexOfPartition(Value: PUMLPartition): Integer;
begin
  Result := FPartitions.IndexOf(Value);
end;

function PUMLActivityGraph.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLActivityGraph.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLActivityGraph.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLActivityGraph.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLActivityGraph.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Partitions' then begin
    AddPartition(Value as PUMLPartition);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLActivityGraph.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Partitions' then begin
    RemovePartition(Value as PUMLPartition);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLActivityGraph.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Partitions' then begin
    InsertPartition(Index, Value as PUMLPartition);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLActivityGraph.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Partitions' then begin
    DeletePartition(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLActivityGraph.MOF_ClearCollection(Name: string);
begin
  if Name = 'Partitions' then begin
    ClearPartitions;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLActivityGraph.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Partitions' then begin
    Result := IndexOfPartition(Value as PUMLPartition);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLActivityGraph.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Partitions' then begin
    Result := Partitions[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLActivityGraph.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Partitions' then begin
    Result := PartitionCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLActivityGraph.CanContainDiagramKind(Kind: string): Boolean;
begin
  Result := (Kind = 'UMLActivityDiagram');
end;

function PUMLActivityGraph.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLPartition') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;

function PUMLActivityGraph.CanPaste(Kind: string; CopyContext: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLActivityDiagram') then
    Result := (GUID = CopyContext)
  else
    Result := inherited CanPaste(Kind, CopyContext);
end;

// PUMLActivityGraph
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLFeature

constructor PUMLFeature.Create;
begin
  inherited;
  FConnectorEnds := POrderedSet.Create;
  FClassifierRoles := POrderedSet.Create;
end;

destructor PUMLFeature.Destroy;
begin
  FConnectorEnds.Free;
  FClassifierRoles.Free;
  inherited;
end;

function PUMLFeature.FindRelatedModel(FirstElement: PModel): PModel;
begin
  if FirstElement = ConnectorEnds[0].Role then
    Result := ConnectorEnds[1].Role
  else if FirstElement = ConnectorEnds[1].Role then
    Result := ConnectorEnds[0].Role
  else
    Result := nil; // First element does not match
end;

procedure PUMLFeature.SetOwnerScope(Value: PUMLScopeKind);
begin
  if FOwnerScope <> Value then
    FOwnerScope := Value;
end;

function PUMLFeature.GetConnectorEnd(Index: Integer): PUMLConnectorEnd;
begin
  Result := FConnectorEnds.Items[Index] as UMLModels.PUMLConnectorEnd;
end;

function PUMLFeature.GetConnectorEndCount: Integer;
begin
  Result := FConnectorEnds.Count;
end;

function PUMLFeature.GetClassifierRole(Index: Integer): PUMLClassifierRole;
begin
  Result := FClassifierRoles.Items[Index] as UMLModels.PUMLClassifierRole;
end;

function PUMLFeature.GetClassifierRoleCount: Integer;
begin
  Result := FClassifierRoles.Count;
end;

procedure PUMLFeature.ClearConnectorEnds;
var
  I: Integer;
begin
  for I := FConnectorEnds.Count - 1 downto 0 do
    DeleteConnectorEnd(I);
end;

procedure PUMLFeature.AddConnectorEnd(Value: PUMLConnectorEnd);
begin
  if Value <> nil then begin
    if Value.FRole <> nil then Value.FRole.FConnectorEnds.Remove(Value);
    FConnectorEnds.Add(Value);
    Value.FRole := Self;
  end;
end;

procedure PUMLFeature.RemoveConnectorEnd(Value: PUMLConnectorEnd);
begin
  if Value <> nil then begin
    FConnectorEnds.Remove(Value);
    Value.FRole := nil;
  end;
end;

procedure PUMLFeature.InsertConnectorEnd(Index: Integer; Value: PUMLConnectorEnd);
begin
  if Value <> nil then begin
    if Value.FRole <> nil then Value.FRole.FConnectorEnds.Remove(Value);
    FConnectorEnds.Insert(Index, Value);
    Value.FRole := Self;
  end;
end;

procedure PUMLFeature.DeleteConnectorEnd(Index: Integer);
begin
  RemoveConnectorEnd(FConnectorEnds.Items[Index] as UMLModels.PUMLConnectorEnd);
end;

function PUMLFeature.IndexOfConnectorEnd(Value: PUMLConnectorEnd): Integer;
begin
  Result := FConnectorEnds.IndexOf(Value);
end;

procedure PUMLFeature.ClearClassifierRoles;
var
  I: Integer;
begin
  for I := FClassifierRoles.Count - 1 downto 0 do
    DeleteClassifierRole(I);
end;

procedure PUMLFeature.AddClassifierRole(Value: PUMLClassifierRole);
begin
  if Value <> nil then begin
    FClassifierRoles.Add(Value);
    Value.FAvailableFeatures.Add(Self);
  end;
end;

procedure PUMLFeature.RemoveClassifierRole(Value: PUMLClassifierRole);
begin
  if Value <> nil then begin
    FClassifierRoles.Remove(Value);
    Value.FAvailableFeatures.Remove(Self);
  end;
end;

procedure PUMLFeature.InsertClassifierRole(Index: Integer; Value: PUMLClassifierRole);
begin
  if Value <> nil then begin
    FClassifierRoles.Insert(Index, Value);
    Value.FAvailableFeatures.Add(Self);
  end;
end;

procedure PUMLFeature.DeleteClassifierRole(Index: Integer);
begin
  RemoveClassifierRole(FClassifierRoles.Items[Index] as UMLModels.PUMLClassifierRole);
end;

function PUMLFeature.IndexOfClassifierRole(Value: PUMLClassifierRole): Integer;
begin
  Result := FClassifierRoles.IndexOf(Value);
end;

function PUMLFeature.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'OwnerScope' then begin
    Result := UMLScopeKindToString(OwnerScope);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLFeature.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'OwnerScope' then begin
    OwnerScope := StringToUMLScopeKind(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLFeature.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLFeature.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLFeature.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ConnectorEnds' then begin
    AddConnectorEnd(Value as PUMLConnectorEnd);
  end
  else if Name = 'ClassifierRoles' then begin
    AddClassifierRole(Value as PUMLClassifierRole);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLFeature.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ConnectorEnds' then begin
    RemoveConnectorEnd(Value as PUMLConnectorEnd);
  end
  else if Name = 'ClassifierRoles' then begin
    RemoveClassifierRole(Value as PUMLClassifierRole);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLFeature.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'ConnectorEnds' then begin
    InsertConnectorEnd(Index, Value as PUMLConnectorEnd);
  end
  else if Name = 'ClassifierRoles' then begin
    InsertClassifierRole(Index, Value as PUMLClassifierRole);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLFeature.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'ConnectorEnds' then begin
    DeleteConnectorEnd(Index);
  end
  else if Name = 'ClassifierRoles' then begin
    DeleteClassifierRole(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLFeature.MOF_ClearCollection(Name: string);
begin
  if Name = 'ConnectorEnds' then begin
    ClearConnectorEnds;
  end
  else if Name = 'ClassifierRoles' then begin
    ClearClassifierRoles;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLFeature.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'ConnectorEnds' then begin
    Result := IndexOfConnectorEnd(Value as PUMLConnectorEnd);
  end
  else if Name = 'ClassifierRoles' then begin
    Result := IndexOfClassifierRole(Value as PUMLClassifierRole);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLFeature.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'ConnectorEnds' then begin
    Result := ConnectorEnds[Index];
  end
  else if Name = 'ClassifierRoles' then begin
    Result := ClassifierRoles[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLFeature.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'ConnectorEnds' then begin
    Result := ConnectorEndCount;
  end
  else if Name = 'ClassifierRoles' then begin
    Result := ClassifierRoleCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLFeature
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLBehavioralFeature

constructor PUMLBehavioralFeature.Create;
begin
  inherited;
  FParameters := POrderedSet.Create;
  FRaisedSignals := POrderedSet.Create;
end;

destructor PUMLBehavioralFeature.Destroy;
begin
  FParameters.Free;
  FRaisedSignals.Free;
  inherited;
end;

procedure PUMLBehavioralFeature.SetIsQuery(Value: Boolean);
begin
  if FIsQuery <> Value then
    FIsQuery := Value;
end;

function PUMLBehavioralFeature.GetParameter(Index: Integer): PUMLParameter;
begin
  Result := FParameters.Items[Index] as UMLModels.PUMLParameter;
end;

function PUMLBehavioralFeature.GetParameterCount: Integer;
begin
  Result := FParameters.Count;
end;

function PUMLBehavioralFeature.GetRaisedSignal(Index: Integer): PUMLSignal;
begin
  Result := FRaisedSignals.Items[Index] as UMLModels.PUMLSignal;
end;

function PUMLBehavioralFeature.GetRaisedSignalCount: Integer;
begin
  Result := FRaisedSignals.Count;
end;

procedure PUMLBehavioralFeature.ClearParameters;
var
  I: Integer;
begin
  for I := FParameters.Count - 1 downto 0 do
    DeleteParameter(I);
end;

procedure PUMLBehavioralFeature.AddParameter(Value: PUMLParameter);
begin
  if Value <> nil then begin
    if Value.FBehavioralFeature <> nil then begin
      Value.FBehavioralFeature.FParameters.Remove(Value);
      Value.FBehavioralFeature.RemoveVirtualOwnedModel(Value);
    end;
    FParameters.Add(Value);
    Value.FBehavioralFeature := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLBehavioralFeature.RemoveParameter(Value: PUMLParameter);
begin
  if Value <> nil then begin
    FParameters.Remove(Value);
    Value.FBehavioralFeature := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLBehavioralFeature.InsertParameter(Index: Integer; Value: PUMLParameter);
begin
  if Value <> nil then begin
    if Value.FBehavioralFeature <> nil then begin
      Value.FBehavioralFeature.FParameters.Remove(Value);
      Value.FBehavioralFeature.RemoveVirtualOwnedModel(Value);
    end;
    FParameters.Insert(Index, Value);
    Value.FBehavioralFeature := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLBehavioralFeature.DeleteParameter(Index: Integer);
begin
  RemoveParameter(FParameters.Items[Index] as UMLModels.PUMLParameter);
end;

function PUMLBehavioralFeature.IndexOfParameter(Value: PUMLParameter): Integer;
begin
  Result := FParameters.IndexOf(Value);
end;

procedure PUMLBehavioralFeature.ClearRaisedSignals;
var
  I: Integer;
begin
  for I := FRaisedSignals.Count - 1 downto 0 do
    DeleteRaisedSignal(I);
end;

procedure PUMLBehavioralFeature.AddRaisedSignal(Value: PUMLSignal);
begin
  if Value <> nil then begin
    FRaisedSignals.Add(Value);
    Value.FContexts.Add(Self);
  end;
end;

procedure PUMLBehavioralFeature.RemoveRaisedSignal(Value: PUMLSignal);
begin
  if Value <> nil then begin
    FRaisedSignals.Remove(Value);
    Value.FContexts.Remove(Self);
  end;
end;

procedure PUMLBehavioralFeature.InsertRaisedSignal(Index: Integer; Value: PUMLSignal);
begin
  if Value <> nil then begin
    FRaisedSignals.Insert(Index, Value);
    Value.FContexts.Add(Self);
  end;
end;

procedure PUMLBehavioralFeature.DeleteRaisedSignal(Index: Integer);
begin
  RemoveRaisedSignal(FRaisedSignals.Items[Index] as UMLModels.PUMLSignal);
end;

function PUMLBehavioralFeature.IndexOfRaisedSignal(Value: PUMLSignal): Integer;
begin
  Result := FRaisedSignals.IndexOf(Value);
end;

function PUMLBehavioralFeature.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'IsQuery' then begin
    Result := BooleanToString(IsQuery);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLBehavioralFeature.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'IsQuery' then begin
    IsQuery := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLBehavioralFeature.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLBehavioralFeature.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLBehavioralFeature.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Parameters' then begin
    AddParameter(Value as PUMLParameter);
  end
  else if Name = 'RaisedSignals' then begin
    AddRaisedSignal(Value as PUMLSignal);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLBehavioralFeature.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Parameters' then begin
    RemoveParameter(Value as PUMLParameter);
  end
  else if Name = 'RaisedSignals' then begin
    RemoveRaisedSignal(Value as PUMLSignal);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLBehavioralFeature.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Parameters' then begin
    InsertParameter(Index, Value as PUMLParameter);
  end
  else if Name = 'RaisedSignals' then begin
    InsertRaisedSignal(Index, Value as PUMLSignal);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLBehavioralFeature.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Parameters' then begin
    DeleteParameter(Index);
  end
  else if Name = 'RaisedSignals' then begin
    DeleteRaisedSignal(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLBehavioralFeature.MOF_ClearCollection(Name: string);
begin
  if Name = 'Parameters' then begin
    ClearParameters;
  end
  else if Name = 'RaisedSignals' then begin
    ClearRaisedSignals;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLBehavioralFeature.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Parameters' then begin
    Result := IndexOfParameter(Value as PUMLParameter);
  end
  else if Name = 'RaisedSignals' then begin
    Result := IndexOfRaisedSignal(Value as PUMLSignal);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLBehavioralFeature.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Parameters' then begin
    Result := Parameters[Index];
  end
  else if Name = 'RaisedSignals' then begin
    Result := RaisedSignals[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLBehavioralFeature.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Parameters' then begin
    Result := ParameterCount;
  end
  else if Name = 'RaisedSignals' then begin
    Result := RaisedSignalCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLBehavioralFeature
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLMethod

constructor PUMLMethod.Create;
begin
  inherited;
  FSpecification := nil;
end;

destructor PUMLMethod.Destroy;
begin
  inherited;
end;

procedure PUMLMethod.SetBody(Value: string);
begin
  if FBody <> Value then
    FBody := Value;
end;

procedure PUMLMethod.SetSpecification(Value: PUMLOperation);
begin
  if FSpecification <> Value then begin
    if FSpecification <> nil then Specification.FMethods.Remove(Self);
    FSpecification := Value;
    if Value <> nil then begin
      Value.FMethods.Add(Self);
    end;
  end;
end;

function PUMLMethod.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Body' then begin
    Result := Body;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLMethod.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Body' then begin
    Body := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLMethod.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Specification' then begin
    Result := Specification;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLMethod.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Specification' then begin
    Specification := Value as PUMLOperation;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLMethod.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLMethod.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLMethod.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLMethod.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLMethod.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLMethod.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLMethod.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLMethod.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLMethod
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLOperation

constructor PUMLOperation.Create;
begin
  inherited;
  FOwner := nil;
  FMethods := POrderedSet.Create;
  FCallActions := POrderedSet.Create;
  FOccurrences := POrderedSet.Create;
  FOwnedCollaborations := POrderedSet.Create;
  FOwnedCollaborationInstanceSets := POrderedSet.Create;
end;

destructor PUMLOperation.Destroy;
begin
  FMethods.Free;
  FCallActions.Free;
  FOccurrences.Free;
  FOwnedCollaborations.Free;
  FOwnedCollaborationInstanceSets.Free;
  inherited;
end;

procedure PUMLOperation.SetConcurrency(Value: PUMLCallConcurrencyKind);
begin
  if FConcurrency <> Value then
    FConcurrency := Value;
end;

procedure PUMLOperation.SetIsRoot(Value: Boolean);
begin
  if FIsRoot <> Value then
    FIsRoot := Value;
end;

procedure PUMLOperation.SetIsLeaf(Value: Boolean);
begin
  if FIsLeaf <> Value then
    FIsLeaf := Value;
end;

procedure PUMLOperation.SetIsAbstract(Value: Boolean);
begin
  if FIsAbstract <> Value then
    FIsAbstract := Value;
end;

procedure PUMLOperation.SetSpecification(Value: string);
begin
  if FSpecification <> Value then
    FSpecification := Value;
end;

procedure PUMLOperation.SetOwner(Value: PUMLClassifier);
begin
  if FOwner <> Value then begin
    if FOwner <> nil then begin
      FOwner.FOperations.Remove(Self);
      FOwner.RemoveVirtualOwnedModel(Self);
    end;
    FOwner := Value;
    if Value <> nil then begin
      Value.FOperations.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLOperation.GetMethod(Index: Integer): PUMLMethod;
begin
  Result := FMethods.Items[Index] as UMLModels.PUMLMethod;
end;

function PUMLOperation.GetMethodCount: Integer;
begin
  Result := FMethods.Count;
end;

function PUMLOperation.GetCallAction(Index: Integer): PUMLCallAction;
begin
  Result := FCallActions.Items[Index] as UMLModels.PUMLCallAction;
end;

function PUMLOperation.GetCallActionCount: Integer;
begin
  Result := FCallActions.Count;
end;

function PUMLOperation.GetOccurrence(Index: Integer): PUMLCallEvent;
begin
  Result := FOccurrences.Items[Index] as UMLModels.PUMLCallEvent;
end;

function PUMLOperation.GetOccurrenceCount: Integer;
begin
  Result := FOccurrences.Count;
end;

function PUMLOperation.GetOwnedCollaboration(Index: Integer): PUMLCollaboration;
begin
  Result := FOwnedCollaborations.Items[Index] as UMLModels.PUMLCollaboration;
end;

function PUMLOperation.GetOwnedCollaborationCount: Integer;
begin
  Result := FOwnedCollaborations.Count;
end;

function PUMLOperation.GetOwnedCollaborationInstanceSet(Index: Integer): PUMLCollaborationInstanceSet;
begin
  Result := FOwnedCollaborationInstanceSets.Items[Index] as UMLModels.PUMLCollaborationInstanceSet;
end;

function PUMLOperation.GetOwnedCollaborationInstanceSetCount: Integer;
begin
  Result := FOwnedCollaborationInstanceSets.Count;
end;

procedure PUMLOperation.ClearMethods;
var
  I: Integer;
begin
  for I := FMethods.Count - 1 downto 0 do
    DeleteMethod(I);
end;

procedure PUMLOperation.AddMethod(Value: PUMLMethod);
begin
  if Value <> nil then begin
    if Value.FSpecification <> nil then Value.FSpecification.FMethods.Remove(Value);
    FMethods.Add(Value);
    Value.FSpecification := Self;
  end;
end;

procedure PUMLOperation.RemoveMethod(Value: PUMLMethod);
begin
  if Value <> nil then begin
    FMethods.Remove(Value);
    Value.FSpecification := nil;
  end;
end;

procedure PUMLOperation.InsertMethod(Index: Integer; Value: PUMLMethod);
begin
  if Value <> nil then begin
    if Value.FSpecification <> nil then Value.FSpecification.FMethods.Remove(Value);
    FMethods.Insert(Index, Value);
    Value.FSpecification := Self;
  end;
end;

procedure PUMLOperation.DeleteMethod(Index: Integer);
begin
  RemoveMethod(FMethods.Items[Index] as UMLModels.PUMLMethod);
end;

function PUMLOperation.IndexOfMethod(Value: PUMLMethod): Integer;
begin
  Result := FMethods.IndexOf(Value);
end;

procedure PUMLOperation.ClearCallActions;
var
  I: Integer;
begin
  for I := FCallActions.Count - 1 downto 0 do
    DeleteCallAction(I);
end;

procedure PUMLOperation.AddCallAction(Value: PUMLCallAction);
begin
  if Value <> nil then begin
    if Value.FOperation <> nil then Value.FOperation.FCallActions.Remove(Value);
    FCallActions.Add(Value);
    Value.FOperation := Self;
  end;
end;

procedure PUMLOperation.RemoveCallAction(Value: PUMLCallAction);
begin
  if Value <> nil then begin
    FCallActions.Remove(Value);
    Value.FOperation := nil;
  end;
end;

procedure PUMLOperation.InsertCallAction(Index: Integer; Value: PUMLCallAction);
begin
  if Value <> nil then begin
    if Value.FOperation <> nil then Value.FOperation.FCallActions.Remove(Value);
    FCallActions.Insert(Index, Value);
    Value.FOperation := Self;
  end;
end;

procedure PUMLOperation.DeleteCallAction(Index: Integer);
begin
  RemoveCallAction(FCallActions.Items[Index] as UMLModels.PUMLCallAction);
end;

function PUMLOperation.IndexOfCallAction(Value: PUMLCallAction): Integer;
begin
  Result := FCallActions.IndexOf(Value);
end;

procedure PUMLOperation.ClearOccurrences;
var
  I: Integer;
begin
  for I := FOccurrences.Count - 1 downto 0 do
    DeleteOccurrence(I);
end;

procedure PUMLOperation.AddOccurrence(Value: PUMLCallEvent);
begin
  if Value <> nil then begin
    if Value.FOperation <> nil then Value.FOperation.FOccurrences.Remove(Value);
    FOccurrences.Add(Value);
    Value.FOperation := Self;
  end;
end;

procedure PUMLOperation.RemoveOccurrence(Value: PUMLCallEvent);
begin
  if Value <> nil then begin
    FOccurrences.Remove(Value);
    Value.FOperation := nil;
  end;
end;

procedure PUMLOperation.InsertOccurrence(Index: Integer; Value: PUMLCallEvent);
begin
  if Value <> nil then begin
    if Value.FOperation <> nil then Value.FOperation.FOccurrences.Remove(Value);
    FOccurrences.Insert(Index, Value);
    Value.FOperation := Self;
  end;
end;

procedure PUMLOperation.DeleteOccurrence(Index: Integer);
begin
  RemoveOccurrence(FOccurrences.Items[Index] as UMLModels.PUMLCallEvent);
end;

function PUMLOperation.IndexOfOccurrence(Value: PUMLCallEvent): Integer;
begin
  Result := FOccurrences.IndexOf(Value);
end;

procedure PUMLOperation.ClearOwnedCollaborations;
var
  I: Integer;
begin
  for I := FOwnedCollaborations.Count - 1 downto 0 do
    DeleteOwnedCollaboration(I);
end;

procedure PUMLOperation.AddOwnedCollaboration(Value: PUMLCollaboration);
begin
  if Value <> nil then begin
    if Value.FRepresentedOperation <> nil then begin
      Value.FRepresentedOperation.FOwnedCollaborations.Remove(Value);
      Value.FRepresentedOperation.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedCollaborations.Add(Value);
    Value.FRepresentedOperation := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLOperation.RemoveOwnedCollaboration(Value: PUMLCollaboration);
begin
  if Value <> nil then begin
    FOwnedCollaborations.Remove(Value);
    Value.FRepresentedOperation := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLOperation.InsertOwnedCollaboration(Index: Integer; Value: PUMLCollaboration);
begin
  if Value <> nil then begin
    if Value.FRepresentedOperation <> nil then begin
      Value.FRepresentedOperation.FOwnedCollaborations.Remove(Value);
      Value.FRepresentedOperation.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedCollaborations.Insert(Index, Value);
    Value.FRepresentedOperation := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLOperation.DeleteOwnedCollaboration(Index: Integer);
begin
  RemoveOwnedCollaboration(FOwnedCollaborations.Items[Index] as UMLModels.PUMLCollaboration);
end;

function PUMLOperation.IndexOfOwnedCollaboration(Value: PUMLCollaboration): Integer;
begin
  Result := FOwnedCollaborations.IndexOf(Value);
end;

procedure PUMLOperation.ClearOwnedCollaborationInstanceSets;
var
  I: Integer;
begin
  for I := FOwnedCollaborationInstanceSets.Count - 1 downto 0 do
    DeleteOwnedCollaborationInstanceSet(I);
end;

procedure PUMLOperation.AddOwnedCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
begin
  if Value <> nil then begin
    if Value.FRepresentedOperation <> nil then begin
      Value.FRepresentedOperation.FOwnedCollaborationInstanceSets.Remove(Value);
      Value.FRepresentedOperation.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedCollaborationInstanceSets.Add(Value);
    Value.FRepresentedOperation := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLOperation.RemoveOwnedCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
begin
  if Value <> nil then begin
    FOwnedCollaborationInstanceSets.Remove(Value);
    Value.FRepresentedOperation := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLOperation.InsertOwnedCollaborationInstanceSet(Index: Integer; Value: PUMLCollaborationInstanceSet);
begin
  if Value <> nil then begin
    if Value.FRepresentedOperation <> nil then begin
      Value.FRepresentedOperation.FOwnedCollaborationInstanceSets.Remove(Value);
      Value.FRepresentedOperation.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedCollaborationInstanceSets.Insert(Index, Value);
    Value.FRepresentedOperation := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLOperation.DeleteOwnedCollaborationInstanceSet(Index: Integer);
begin
  RemoveOwnedCollaborationInstanceSet(FOwnedCollaborationInstanceSets.Items[Index] as UMLModels.PUMLCollaborationInstanceSet);
end;

function PUMLOperation.IndexOfOwnedCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet): Integer;
begin
  Result := FOwnedCollaborationInstanceSets.IndexOf(Value);
end;

function PUMLOperation.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Concurrency' then begin
    Result := UMLCallConcurrencyKindToString(Concurrency);
  end
  else if Name = 'IsRoot' then begin
    Result := BooleanToString(IsRoot);
  end
  else if Name = 'IsLeaf' then begin
    Result := BooleanToString(IsLeaf);
  end
  else if Name = 'IsAbstract' then begin
    Result := BooleanToString(IsAbstract);
  end
  else if Name = 'Specification' then begin
    Result := Specification;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLOperation.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Concurrency' then begin
    Concurrency := StringToUMLCallConcurrencyKind(Value);
  end
  else if Name = 'IsRoot' then begin
    IsRoot := StringToBoolean(Value);
  end
  else if Name = 'IsLeaf' then begin
    IsLeaf := StringToBoolean(Value);
  end
  else if Name = 'IsAbstract' then begin
    IsAbstract := StringToBoolean(Value);
  end
  else if Name = 'Specification' then begin
    Specification := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLOperation.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Owner' then begin
    Result := Owner;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLOperation.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Owner' then begin
    Owner := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLOperation.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Methods' then begin
    AddMethod(Value as PUMLMethod);
  end
  else if Name = 'CallActions' then begin
    AddCallAction(Value as PUMLCallAction);
  end
  else if Name = 'Occurrences' then begin
    AddOccurrence(Value as PUMLCallEvent);
  end
  else if Name = 'OwnedCollaborations' then begin
    AddOwnedCollaboration(Value as PUMLCollaboration);
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    AddOwnedCollaborationInstanceSet(Value as PUMLCollaborationInstanceSet);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLOperation.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Methods' then begin
    RemoveMethod(Value as PUMLMethod);
  end
  else if Name = 'CallActions' then begin
    RemoveCallAction(Value as PUMLCallAction);
  end
  else if Name = 'Occurrences' then begin
    RemoveOccurrence(Value as PUMLCallEvent);
  end
  else if Name = 'OwnedCollaborations' then begin
    RemoveOwnedCollaboration(Value as PUMLCollaboration);
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    RemoveOwnedCollaborationInstanceSet(Value as PUMLCollaborationInstanceSet);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLOperation.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Methods' then begin
    InsertMethod(Index, Value as PUMLMethod);
  end
  else if Name = 'CallActions' then begin
    InsertCallAction(Index, Value as PUMLCallAction);
  end
  else if Name = 'Occurrences' then begin
    InsertOccurrence(Index, Value as PUMLCallEvent);
  end
  else if Name = 'OwnedCollaborations' then begin
    InsertOwnedCollaboration(Index, Value as PUMLCollaboration);
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    InsertOwnedCollaborationInstanceSet(Index, Value as PUMLCollaborationInstanceSet);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLOperation.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Methods' then begin
    DeleteMethod(Index);
  end
  else if Name = 'CallActions' then begin
    DeleteCallAction(Index);
  end
  else if Name = 'Occurrences' then begin
    DeleteOccurrence(Index);
  end
  else if Name = 'OwnedCollaborations' then begin
    DeleteOwnedCollaboration(Index);
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    DeleteOwnedCollaborationInstanceSet(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLOperation.MOF_ClearCollection(Name: string);
begin
  if Name = 'Methods' then begin
    ClearMethods;
  end
  else if Name = 'CallActions' then begin
    ClearCallActions;
  end
  else if Name = 'Occurrences' then begin
    ClearOccurrences;
  end
  else if Name = 'OwnedCollaborations' then begin
    ClearOwnedCollaborations;
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    ClearOwnedCollaborationInstanceSets;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLOperation.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Methods' then begin
    Result := IndexOfMethod(Value as PUMLMethod);
  end
  else if Name = 'CallActions' then begin
    Result := IndexOfCallAction(Value as PUMLCallAction);
  end
  else if Name = 'Occurrences' then begin
    Result := IndexOfOccurrence(Value as PUMLCallEvent);
  end
  else if Name = 'OwnedCollaborations' then begin
    Result := IndexOfOwnedCollaboration(Value as PUMLCollaboration);
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    Result := IndexOfOwnedCollaborationInstanceSet(Value as PUMLCollaborationInstanceSet);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLOperation.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Methods' then begin
    Result := Methods[Index];
  end
  else if Name = 'CallActions' then begin
    Result := CallActions[Index];
  end
  else if Name = 'Occurrences' then begin
    Result := Occurrences[Index];
  end
  else if Name = 'OwnedCollaborations' then begin
    Result := OwnedCollaborations[Index];
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    Result := OwnedCollaborationInstanceSets[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLOperation.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Methods' then begin
    Result := MethodCount;
  end
  else if Name = 'CallActions' then begin
    Result := CallActionCount;
  end
  else if Name = 'Occurrences' then begin
    Result := OccurrenceCount;
  end
  else if Name = 'OwnedCollaborations' then begin
    Result := OwnedCollaborationCount;
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    Result := OwnedCollaborationInstanceSetCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLOperation.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLCollaboration') or
     MetaModel.IsKindOf(Kind, 'UMLCollaborationInstanceSet') or
     MetaModel.IsKindOf(Kind, 'UMLStateMachine') or
     MetaModel.IsKindOf(Kind, 'UMLParameter') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;

// PUMLOperation
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLReception

constructor PUMLReception.Create;
begin
  inherited;
  FSignal := nil;
end;

destructor PUMLReception.Destroy;
begin
  inherited;
end;

procedure PUMLReception.SetSpecification(Value: string);
begin
  if FSpecification <> Value then
    FSpecification := Value;
end;

procedure PUMLReception.SetIsRoot(Value: Boolean);
begin
  if FIsRoot <> Value then
    FIsRoot := Value;
end;

procedure PUMLReception.SetIsLeaf(Value: Boolean);
begin
  if FIsLeaf <> Value then
    FIsLeaf := Value;
end;

procedure PUMLReception.SetIsAbstract(Value: Boolean);
begin
  if FIsAbstract <> Value then
    FIsAbstract := Value;
end;

procedure PUMLReception.SetSignal(Value: PUMLSignal);
begin
  if FSignal <> Value then begin
    if FSignal <> nil then Signal.FReceptions.Remove(Self);
    FSignal := Value;
    if Value <> nil then begin
      Value.FReceptions.Add(Self);
    end;
  end;
end;

function PUMLReception.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Specification' then begin
    Result := Specification;
  end
  else if Name = 'IsRoot' then begin
    Result := BooleanToString(IsRoot);
  end
  else if Name = 'IsLeaf' then begin
    Result := BooleanToString(IsLeaf);
  end
  else if Name = 'IsAbstract' then begin
    Result := BooleanToString(IsAbstract);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLReception.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Specification' then begin
    Specification := Value;
  end
  else if Name = 'IsRoot' then begin
    IsRoot := StringToBoolean(Value);
  end
  else if Name = 'IsLeaf' then begin
    IsLeaf := StringToBoolean(Value);
  end
  else if Name = 'IsAbstract' then begin
    IsAbstract := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLReception.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Signal' then begin
    Result := Signal;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLReception.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Signal' then begin
    Signal := Value as PUMLSignal;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLReception.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLReception.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLReception.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLReception.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLReception.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLReception.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLReception.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLReception.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLReception
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLConnector

constructor PUMLConnector.Create;
begin
  inherited;
  FEnds := POrderedSet.Create;
  FOwner := nil;
end;

destructor PUMLConnector.Destroy;
begin
  FEnds.Free;
  inherited;
end;

function PUMLConnector.FindRelatedModel(FirstElement: PModel): PModel;
begin
  if FirstElement = Ends[0].Role then
    Result := Ends[1].Role
  else if FirstElement = Ends[1].Role then
    Result := Ends[0].Role
  else
    Result := nil; // First element does not match
end;

function PUMLConnector.GetEnd(Index: Integer): PUMLConnectorEnd;
begin
  Result := FEnds.Items[Index] as UMLModels.PUMLConnectorEnd;
end;

function PUMLConnector.GetEndCount: Integer;
begin
  Result := FEnds.Count;
end;

procedure PUMLConnector.SetOwner(Value: PUMLClassifier);
begin
  if FOwner <> Value then begin
    if FOwner <> nil then begin
      FOwner.FOwnedConnectors.Remove(Self);
      FOwner.RemoveVirtualOwnedModel(Self);
    end;
    FOwner := Value;
    if Value <> nil then begin
      Value.FOwnedConnectors.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLConnector.ClearEnds;
var
  I: Integer;
begin
  for I := FEnds.Count - 1 downto 0 do
    DeleteEnd(I);
end;

procedure PUMLConnector.AddEnd(Value: PUMLConnectorEnd);
begin
  if Value <> nil then begin
    if Value.FConnector <> nil then begin
      Value.FConnector.FEnds.Remove(Value);
      Value.FConnector.RemoveVirtualOwnedModel(Value);
    end;
    FEnds.Add(Value);
    Value.FConnector := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLConnector.RemoveEnd(Value: PUMLConnectorEnd);
begin
  if Value <> nil then begin
    FEnds.Remove(Value);
    Value.FConnector := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLConnector.InsertEnd(Index: Integer; Value: PUMLConnectorEnd);
begin
  if Value <> nil then begin
    if Value.FConnector <> nil then begin
      Value.FConnector.FEnds.Remove(Value);
      Value.FConnector.RemoveVirtualOwnedModel(Value);
    end;
    FEnds.Insert(Index, Value);
    Value.FConnector := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLConnector.DeleteEnd(Index: Integer);
begin
  RemoveEnd(FEnds.Items[Index] as UMLModels.PUMLConnectorEnd);
end;

function PUMLConnector.IndexOfEnd(Value: PUMLConnectorEnd): Integer;
begin
  Result := FEnds.IndexOf(Value);
end;

function PUMLConnector.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLConnector.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLConnector.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Owner' then begin
    Result := Owner;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLConnector.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Owner' then begin
    Owner := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLConnector.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Ends' then begin
    AddEnd(Value as PUMLConnectorEnd);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLConnector.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Ends' then begin
    RemoveEnd(Value as PUMLConnectorEnd);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLConnector.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Ends' then begin
    InsertEnd(Index, Value as PUMLConnectorEnd);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLConnector.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Ends' then begin
    DeleteEnd(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLConnector.MOF_ClearCollection(Name: string);
begin
  if Name = 'Ends' then begin
    ClearEnds;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLConnector.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Ends' then begin
    Result := IndexOfEnd(Value as PUMLConnectorEnd);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLConnector.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Ends' then begin
    Result := Ends[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLConnector.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Ends' then begin
    Result := EndCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLConnector
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLStructuralFeature

constructor PUMLStructuralFeature.Create;
begin
  inherited;
  FType_ := nil;
end;

destructor PUMLStructuralFeature.Destroy;
begin
  inherited;
end;

procedure PUMLStructuralFeature.SetMultiplicity(Value: string);
begin
  if FMultiplicity <> Value then
    FMultiplicity := Value;
end;

procedure PUMLStructuralFeature.SetChangeability(Value: PUMLChangeableKind);
begin
  if FChangeability <> Value then
    FChangeability := Value;
end;

procedure PUMLStructuralFeature.SetTargetScope(Value: PUMLScopeKind);
begin
  if FTargetScope <> Value then
    FTargetScope := Value;
end;

procedure PUMLStructuralFeature.SetOrdering(Value: PUMLOrderingKind);
begin
  if FOrdering <> Value then
    FOrdering := Value;
end;

procedure PUMLStructuralFeature.SetTypeExpression(Value: string);
begin
  if FTypeExpression <> Value then
    FTypeExpression := Value;
end;

procedure PUMLStructuralFeature.SetType_(Value: PUMLClassifier);
begin
  if FType_ <> Value then begin
    if FType_ <> nil then Type_.FTypedFeatures.Remove(Self);
    FType_ := Value;
    if Value <> nil then begin
      Value.FTypedFeatures.Add(Self);
    end;
  end;
end;

function PUMLStructuralFeature.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Multiplicity' then begin
    Result := Multiplicity;
  end
  else if Name = 'Changeability' then begin
    Result := UMLChangeableKindToString(Changeability);
  end
  else if Name = 'TargetScope' then begin
    Result := UMLScopeKindToString(TargetScope);
  end
  else if Name = 'Ordering' then begin
    Result := UMLOrderingKindToString(Ordering);
  end
  else if Name = 'TypeExpression' then begin
    Result := TypeExpression;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLStructuralFeature.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Multiplicity' then begin
    Multiplicity := Value;
  end
  else if Name = 'Changeability' then begin
    Changeability := StringToUMLChangeableKind(Value);
  end
  else if Name = 'TargetScope' then begin
    TargetScope := StringToUMLScopeKind(Value);
  end
  else if Name = 'Ordering' then begin
    Ordering := StringToUMLOrderingKind(Value);
  end
  else if Name = 'TypeExpression' then begin
    TypeExpression := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLStructuralFeature.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Type_' then begin
    Result := Type_;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLStructuralFeature.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Type_' then begin
    Type_ := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLStructuralFeature.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLStructuralFeature.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLStructuralFeature.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLStructuralFeature.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLStructuralFeature.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLStructuralFeature.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLStructuralFeature.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLStructuralFeature.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLStructuralFeature
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLAttribute

constructor PUMLAttribute.Create;
begin
  inherited;
  FAssociationEnd := nil;
  FOwner := nil;
  FAttributeLinks := POrderedSet.Create;
  FAssociationEndRoles := POrderedSet.Create;
end;

destructor PUMLAttribute.Destroy;
begin
  FAttributeLinks.Free;
  FAssociationEndRoles.Free;
  inherited;
end;

procedure PUMLAttribute.SetInitialValue(Value: string);
begin
  if FInitialValue <> Value then
    FInitialValue := Value;
end;

procedure PUMLAttribute.SetAssociationEnd(Value: PUMLAssociationEnd);
begin
  if FAssociationEnd <> Value then begin
    if FAssociationEnd <> nil then begin
      FAssociationEnd.FQualifiers.Remove(Self);
      FAssociationEnd.RemoveVirtualOwnedModel(Self);
    end;
    FAssociationEnd := Value;
    if Value <> nil then begin
      Value.FQualifiers.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLAttribute.SetOwner(Value: PUMLClassifier);
begin
  if FOwner <> Value then begin
    if FOwner <> nil then begin
      FOwner.FAttributes.Remove(Self);
      FOwner.RemoveVirtualOwnedModel(Self);
    end;
    FOwner := Value;
    if Value <> nil then begin
      Value.FAttributes.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLAttribute.GetAttributeLink(Index: Integer): PUMLAttributeLink;
begin
  Result := FAttributeLinks.Items[Index] as UMLModels.PUMLAttributeLink;
end;

function PUMLAttribute.GetAttributeLinkCount: Integer;
begin
  Result := FAttributeLinks.Count;
end;

function PUMLAttribute.GetAssociationEndRole(Index: Integer): PUMLAssociationEndRole;
begin
  Result := FAssociationEndRoles.Items[Index] as UMLModels.PUMLAssociationEndRole;
end;

function PUMLAttribute.GetAssociationEndRoleCount: Integer;
begin
  Result := FAssociationEndRoles.Count;
end;

procedure PUMLAttribute.ClearAttributeLinks;
var
  I: Integer;
begin
  for I := FAttributeLinks.Count - 1 downto 0 do
    DeleteAttributeLink(I);
end;

procedure PUMLAttribute.AddAttributeLink(Value: PUMLAttributeLink);
begin
  if Value <> nil then begin
    if Value.FAttribute <> nil then Value.FAttribute.FAttributeLinks.Remove(Value);
    FAttributeLinks.Add(Value);
    Value.FAttribute := Self;
  end;
end;

procedure PUMLAttribute.RemoveAttributeLink(Value: PUMLAttributeLink);
begin
  if Value <> nil then begin
    FAttributeLinks.Remove(Value);
    Value.FAttribute := nil;
  end;
end;

procedure PUMLAttribute.InsertAttributeLink(Index: Integer; Value: PUMLAttributeLink);
begin
  if Value <> nil then begin
    if Value.FAttribute <> nil then Value.FAttribute.FAttributeLinks.Remove(Value);
    FAttributeLinks.Insert(Index, Value);
    Value.FAttribute := Self;
  end;
end;

procedure PUMLAttribute.DeleteAttributeLink(Index: Integer);
begin
  RemoveAttributeLink(FAttributeLinks.Items[Index] as UMLModels.PUMLAttributeLink);
end;

function PUMLAttribute.IndexOfAttributeLink(Value: PUMLAttributeLink): Integer;
begin
  Result := FAttributeLinks.IndexOf(Value);
end;

procedure PUMLAttribute.ClearAssociationEndRoles;
var
  I: Integer;
begin
  for I := FAssociationEndRoles.Count - 1 downto 0 do
    DeleteAssociationEndRole(I);
end;

procedure PUMLAttribute.AddAssociationEndRole(Value: PUMLAssociationEndRole);
begin
  if Value <> nil then begin
    FAssociationEndRoles.Add(Value);
    Value.FAvailableQualifiers.Add(Self);
  end;
end;

procedure PUMLAttribute.RemoveAssociationEndRole(Value: PUMLAssociationEndRole);
begin
  if Value <> nil then begin
    FAssociationEndRoles.Remove(Value);
    Value.FAvailableQualifiers.Remove(Self);
  end;
end;

procedure PUMLAttribute.InsertAssociationEndRole(Index: Integer; Value: PUMLAssociationEndRole);
begin
  if Value <> nil then begin
    FAssociationEndRoles.Insert(Index, Value);
    Value.FAvailableQualifiers.Add(Self);
  end;
end;

procedure PUMLAttribute.DeleteAssociationEndRole(Index: Integer);
begin
  RemoveAssociationEndRole(FAssociationEndRoles.Items[Index] as UMLModels.PUMLAssociationEndRole);
end;

function PUMLAttribute.IndexOfAssociationEndRole(Value: PUMLAssociationEndRole): Integer;
begin
  Result := FAssociationEndRoles.IndexOf(Value);
end;

function PUMLAttribute.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'InitialValue' then begin
    Result := InitialValue;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLAttribute.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'InitialValue' then begin
    InitialValue := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLAttribute.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'AssociationEnd' then begin
    Result := AssociationEnd;
  end
  else if Name = 'Owner' then begin
    Result := Owner;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLAttribute.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'AssociationEnd' then begin
    AssociationEnd := Value as PUMLAssociationEnd;
  end
  else if Name = 'Owner' then begin
    Owner := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLAttribute.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'AttributeLinks' then begin
    AddAttributeLink(Value as PUMLAttributeLink);
  end
  else if Name = 'AssociationEndRoles' then begin
    AddAssociationEndRole(Value as PUMLAssociationEndRole);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLAttribute.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'AttributeLinks' then begin
    RemoveAttributeLink(Value as PUMLAttributeLink);
  end
  else if Name = 'AssociationEndRoles' then begin
    RemoveAssociationEndRole(Value as PUMLAssociationEndRole);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLAttribute.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'AttributeLinks' then begin
    InsertAttributeLink(Index, Value as PUMLAttributeLink);
  end
  else if Name = 'AssociationEndRoles' then begin
    InsertAssociationEndRole(Index, Value as PUMLAssociationEndRole);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLAttribute.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'AttributeLinks' then begin
    DeleteAttributeLink(Index);
  end
  else if Name = 'AssociationEndRoles' then begin
    DeleteAssociationEndRole(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLAttribute.MOF_ClearCollection(Name: string);
begin
  if Name = 'AttributeLinks' then begin
    ClearAttributeLinks;
  end
  else if Name = 'AssociationEndRoles' then begin
    ClearAssociationEndRoles;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLAttribute.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'AttributeLinks' then begin
    Result := IndexOfAttributeLink(Value as PUMLAttributeLink);
  end
  else if Name = 'AssociationEndRoles' then begin
    Result := IndexOfAssociationEndRole(Value as PUMLAssociationEndRole);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLAttribute.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'AttributeLinks' then begin
    Result := AttributeLinks[Index];
  end
  else if Name = 'AssociationEndRoles' then begin
    Result := AssociationEndRoles[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLAttribute.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'AttributeLinks' then begin
    Result := AttributeLinkCount;
  end
  else if Name = 'AssociationEndRoles' then begin
    Result := AssociationEndRoleCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLAttribute
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLPort

constructor PUMLPort.Create;
begin
  inherited;
  FOwner := nil;
end;

destructor PUMLPort.Destroy;
begin
  inherited;
end;

procedure PUMLPort.SetIsBehavior(Value: Boolean);
begin
  if FIsBehavior <> Value then
    FIsBehavior := Value;
end;

procedure PUMLPort.SetIsService(Value: Boolean);
begin
  if FIsService <> Value then
    FIsService := Value;
end;

procedure PUMLPort.SetOwner(Value: PUMLClassifier);
begin
  if FOwner <> Value then begin
    if FOwner <> nil then begin
      FOwner.FOwnedPorts.Remove(Self);
      FOwner.RemoveVirtualOwnedModel(Self);
    end;
    FOwner := Value;
    if Value <> nil then begin
      Value.FOwnedPorts.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLPort.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'IsBehavior' then begin
    Result := BooleanToString(IsBehavior);
  end
  else if Name = 'IsService' then begin
    Result := BooleanToString(IsService);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLPort.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'IsBehavior' then begin
    IsBehavior := StringToBoolean(Value);
  end
  else if Name = 'IsService' then begin
    IsService := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLPort.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Owner' then begin
    Result := Owner;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLPort.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Owner' then begin
    Owner := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLPort.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLPort.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLPort.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLPort.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLPort.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLPort.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLPort.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLPort.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLPort
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLGeneralizableElement

constructor PUMLGeneralizableElement.Create;
begin
  inherited;
  FGeneralizations := POrderedSet.Create;
  FSpecializations := POrderedSet.Create;
end;

destructor PUMLGeneralizableElement.Destroy;
begin
  FGeneralizations.Free;
  FSpecializations.Free;
  inherited;
end;

procedure PUMLGeneralizableElement.SetIsRoot(Value: Boolean);
begin
  if FIsRoot <> Value then
    FIsRoot := Value;
end;

procedure PUMLGeneralizableElement.SetIsLeaf(Value: Boolean);
begin
  if FIsLeaf <> Value then
    FIsLeaf := Value;
end;

procedure PUMLGeneralizableElement.SetIsAbstract(Value: Boolean);
begin
  if FIsAbstract <> Value then
    FIsAbstract := Value;
end;

function PUMLGeneralizableElement.GetGeneralization(Index: Integer): PUMLGeneralization;
begin
  Result := FGeneralizations.Items[Index] as UMLModels.PUMLGeneralization;
end;

function PUMLGeneralizableElement.GetGeneralizationCount: Integer;
begin
  Result := FGeneralizations.Count;
end;

function PUMLGeneralizableElement.GetSpecialization(Index: Integer): PUMLGeneralization;
begin
  Result := FSpecializations.Items[Index] as UMLModels.PUMLGeneralization;
end;

function PUMLGeneralizableElement.GetSpecializationCount: Integer;
begin
  Result := FSpecializations.Count;
end;

procedure PUMLGeneralizableElement.ClearGeneralizations;
var
  I: Integer;
begin
  for I := FGeneralizations.Count - 1 downto 0 do
    DeleteGeneralization(I);
end;

procedure PUMLGeneralizableElement.AddGeneralization(Value: PUMLGeneralization);
begin
  if Value <> nil then begin
    if Value.FChild <> nil then Value.FChild.FGeneralizations.Remove(Value);
    FGeneralizations.Add(Value);
    Value.FChild := Self;
  end;
end;

procedure PUMLGeneralizableElement.RemoveGeneralization(Value: PUMLGeneralization);
begin
  if Value <> nil then begin
    FGeneralizations.Remove(Value);
    Value.FChild := nil;
  end;
end;

procedure PUMLGeneralizableElement.InsertGeneralization(Index: Integer; Value: PUMLGeneralization);
begin
  if Value <> nil then begin
    if Value.FChild <> nil then Value.FChild.FGeneralizations.Remove(Value);
    FGeneralizations.Insert(Index, Value);
    Value.FChild := Self;
  end;
end;

procedure PUMLGeneralizableElement.DeleteGeneralization(Index: Integer);
begin
  RemoveGeneralization(FGeneralizations.Items[Index] as UMLModels.PUMLGeneralization);
end;

function PUMLGeneralizableElement.IndexOfGeneralization(Value: PUMLGeneralization): Integer;
begin
  Result := FGeneralizations.IndexOf(Value);
end;

procedure PUMLGeneralizableElement.ClearSpecializations;
var
  I: Integer;
begin
  for I := FSpecializations.Count - 1 downto 0 do
    DeleteSpecialization(I);
end;

procedure PUMLGeneralizableElement.AddSpecialization(Value: PUMLGeneralization);
begin
  if Value <> nil then begin
    if Value.FParent <> nil then Value.FParent.FSpecializations.Remove(Value);
    FSpecializations.Add(Value);
    Value.FParent := Self;
  end;
end;

procedure PUMLGeneralizableElement.RemoveSpecialization(Value: PUMLGeneralization);
begin
  if Value <> nil then begin
    FSpecializations.Remove(Value);
    Value.FParent := nil;
  end;
end;

procedure PUMLGeneralizableElement.InsertSpecialization(Index: Integer; Value: PUMLGeneralization);
begin
  if Value <> nil then begin
    if Value.FParent <> nil then Value.FParent.FSpecializations.Remove(Value);
    FSpecializations.Insert(Index, Value);
    Value.FParent := Self;
  end;
end;

procedure PUMLGeneralizableElement.DeleteSpecialization(Index: Integer);
begin
  RemoveSpecialization(FSpecializations.Items[Index] as UMLModels.PUMLGeneralization);
end;

function PUMLGeneralizableElement.IndexOfSpecialization(Value: PUMLGeneralization): Integer;
begin
  Result := FSpecializations.IndexOf(Value);
end;

function PUMLGeneralizableElement.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'IsRoot' then begin
    Result := BooleanToString(IsRoot);
  end
  else if Name = 'IsLeaf' then begin
    Result := BooleanToString(IsLeaf);
  end
  else if Name = 'IsAbstract' then begin
    Result := BooleanToString(IsAbstract);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLGeneralizableElement.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'IsRoot' then begin
    IsRoot := StringToBoolean(Value);
  end
  else if Name = 'IsLeaf' then begin
    IsLeaf := StringToBoolean(Value);
  end
  else if Name = 'IsAbstract' then begin
    IsAbstract := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLGeneralizableElement.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLGeneralizableElement.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLGeneralizableElement.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Generalizations' then begin
    AddGeneralization(Value as PUMLGeneralization);
  end
  else if Name = 'Specializations' then begin
    AddSpecialization(Value as PUMLGeneralization);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLGeneralizableElement.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Generalizations' then begin
    RemoveGeneralization(Value as PUMLGeneralization);
  end
  else if Name = 'Specializations' then begin
    RemoveSpecialization(Value as PUMLGeneralization);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLGeneralizableElement.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Generalizations' then begin
    InsertGeneralization(Index, Value as PUMLGeneralization);
  end
  else if Name = 'Specializations' then begin
    InsertSpecialization(Index, Value as PUMLGeneralization);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLGeneralizableElement.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Generalizations' then begin
    DeleteGeneralization(Index);
  end
  else if Name = 'Specializations' then begin
    DeleteSpecialization(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLGeneralizableElement.MOF_ClearCollection(Name: string);
begin
  if Name = 'Generalizations' then begin
    ClearGeneralizations;
  end
  else if Name = 'Specializations' then begin
    ClearSpecializations;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLGeneralizableElement.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Generalizations' then begin
    Result := IndexOfGeneralization(Value as PUMLGeneralization);
  end
  else if Name = 'Specializations' then begin
    Result := IndexOfSpecialization(Value as PUMLGeneralization);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLGeneralizableElement.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Generalizations' then begin
    //Result := (Generalizations[Index] as UMLModels.PUMLGeneralization).Parent;
    Result := Generalizations[Index];
  end
  else if Name = 'Specializations' then begin
    Result := Specializations[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLGeneralizableElement.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Generalizations' then begin
    Result := GeneralizationCount;
  end
  else if Name = 'Specializations' then begin
    Result := SpecializationCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLGeneralizableElement
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLNamespace

constructor PUMLNamespace.Create;
begin
  inherited;
  FOwnedElements := POrderedSet.Create;
end;

destructor PUMLNamespace.Destroy;
begin
  FOwnedElements.Free;
  inherited;
end;

function PUMLNamespace.GetOwnedElement(Index: Integer): PUMLModelElement;
begin
  Result := FOwnedElements.Items[Index] as UMLModels.PUMLModelElement;
end;

function PUMLNamespace.GetOwnedElementCount: Integer;
begin
  Result := FOwnedElements.Count;
end;

procedure PUMLNamespace.ClearOwnedElements;
var
  I: Integer;
begin
  for I := FOwnedElements.Count - 1 downto 0 do
    DeleteOwnedElement(I);
end;

procedure PUMLNamespace.AddOwnedElement(Value: PUMLModelElement);
begin
  if Value <> nil then begin
    if Value.FNamespace <> nil then begin
      Value.FNamespace.FOwnedElements.Remove(Value);
      Value.FNamespace.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedElements.Add(Value);
    Value.FNamespace := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLNamespace.RemoveOwnedElement(Value: PUMLModelElement);
begin
  if Value <> nil then begin
    FOwnedElements.Remove(Value);
    Value.FNamespace := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLNamespace.InsertOwnedElement(Index: Integer; Value: PUMLModelElement);
begin
  if Value <> nil then begin
    if Value.FNamespace <> nil then begin
      Value.FNamespace.FOwnedElements.Remove(Value);
      Value.FNamespace.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedElements.Insert(Index, Value);
    Value.FNamespace := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLNamespace.DeleteOwnedElement(Index: Integer);
begin
  RemoveOwnedElement(FOwnedElements.Items[Index] as UMLModels.PUMLModelElement);
end;

function PUMLNamespace.IndexOfOwnedElement(Value: PUMLModelElement): Integer;
begin
  Result := FOwnedElements.IndexOf(Value);
end;

function PUMLNamespace.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLNamespace.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLNamespace.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLNamespace.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLNamespace.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'OwnedElements' then begin
    AddOwnedElement(Value as PUMLModelElement);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLNamespace.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'OwnedElements' then begin
    RemoveOwnedElement(Value as PUMLModelElement);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLNamespace.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'OwnedElements' then begin
    InsertOwnedElement(Index, Value as PUMLModelElement);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLNamespace.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'OwnedElements' then begin
    DeleteOwnedElement(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLNamespace.MOF_ClearCollection(Name: string);
begin
  if Name = 'OwnedElements' then begin
    ClearOwnedElements;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLNamespace.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'OwnedElements' then begin
    Result := IndexOfOwnedElement(Value as PUMLModelElement);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLNamespace.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'OwnedElements' then begin
    Result := OwnedElements[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLNamespace.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'OwnedElements' then begin
    Result := OwnedElementCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLNamespace
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLCollaboration

constructor PUMLCollaboration.Create;
begin
  inherited;
  FInteractions := POrderedSet.Create;
  FRepresentedOperation := nil;
  FCollaborationInstanceSets := POrderedSet.Create;
  FUserCollaborations := POrderedSet.Create;
  FUsedCollaborations := POrderedSet.Create;
  FRepresentedClassifier := nil;
end;

destructor PUMLCollaboration.Destroy;
begin
  FInteractions.Free;
  FCollaborationInstanceSets.Free;
  FUserCollaborations.Free;
  FUsedCollaborations.Free;
  inherited;
end;

function PUMLCollaboration.GetInteraction(Index: Integer): PUMLInteraction;
begin
  Result := FInteractions.Items[Index] as UMLModels.PUMLInteraction;
end;

function PUMLCollaboration.GetInteractionCount: Integer;
begin
  Result := FInteractions.Count;
end;

procedure PUMLCollaboration.SetRepresentedOperation(Value: PUMLOperation);
begin
  if FRepresentedOperation <> Value then begin
    if FRepresentedOperation <> nil then begin
      FRepresentedOperation.FOwnedCollaborations.Remove(Self);
      FRepresentedOperation.RemoveVirtualOwnedModel(Self);
    end;
    FRepresentedOperation := Value;
    if Value <> nil then begin
      Value.FOwnedCollaborations.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLCollaboration.GetCollaborationInstanceSet(Index: Integer): PUMLCollaborationInstanceSet;
begin
  Result := FCollaborationInstanceSets.Items[Index] as UMLModels.PUMLCollaborationInstanceSet;
end;

function PUMLCollaboration.GetCollaborationInstanceSetCount: Integer;
begin
  Result := FCollaborationInstanceSets.Count;
end;

function PUMLCollaboration.GetUserCollaboration(Index: Integer): PUMLCollaboration;
begin
  Result := FUserCollaborations.Items[Index] as UMLModels.PUMLCollaboration;
end;

function PUMLCollaboration.GetUserCollaborationCount: Integer;
begin
  Result := FUserCollaborations.Count;
end;

function PUMLCollaboration.GetUsedCollaboration(Index: Integer): PUMLCollaboration;
begin
  Result := FUsedCollaborations.Items[Index] as UMLModels.PUMLCollaboration;
end;

function PUMLCollaboration.GetUsedCollaborationCount: Integer;
begin
  Result := FUsedCollaborations.Count;
end;

procedure PUMLCollaboration.SetRepresentedClassifier(Value: PUMLClassifier);
begin
  if FRepresentedClassifier <> Value then begin
    if FRepresentedClassifier <> nil then begin
      FRepresentedClassifier.FOwnedCollaborations.Remove(Self);
      FRepresentedClassifier.RemoveVirtualOwnedModel(Self);
    end;
    FRepresentedClassifier := Value;
    if Value <> nil then begin
      Value.FOwnedCollaborations.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLCollaboration.ClearInteractions;
var
  I: Integer;
begin
  for I := FInteractions.Count - 1 downto 0 do
    DeleteInteraction(I);
end;

procedure PUMLCollaboration.AddInteraction(Value: PUMLInteraction);
begin
  if Value <> nil then begin
    if Value.FContext <> nil then begin
      Value.FContext.FInteractions.Remove(Value);
      Value.FContext.RemoveVirtualOwnedModel(Value);
    end;
    FInteractions.Add(Value);
    Value.FContext := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLCollaboration.RemoveInteraction(Value: PUMLInteraction);
begin
  if Value <> nil then begin
    FInteractions.Remove(Value);
    Value.FContext := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLCollaboration.InsertInteraction(Index: Integer; Value: PUMLInteraction);
begin
  if Value <> nil then begin
    if Value.FContext <> nil then begin
      Value.FContext.FInteractions.Remove(Value);
      Value.FContext.RemoveVirtualOwnedModel(Value);
    end;
    FInteractions.Insert(Index, Value);
    Value.FContext := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLCollaboration.DeleteInteraction(Index: Integer);
begin
  RemoveInteraction(FInteractions.Items[Index] as UMLModels.PUMLInteraction);
end;

function PUMLCollaboration.IndexOfInteraction(Value: PUMLInteraction): Integer;
begin
  Result := FInteractions.IndexOf(Value);
end;

procedure PUMLCollaboration.ClearCollaborationInstanceSets;
var
  I: Integer;
begin
  for I := FCollaborationInstanceSets.Count - 1 downto 0 do
    DeleteCollaborationInstanceSet(I);
end;

procedure PUMLCollaboration.AddCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
begin
  if Value <> nil then begin
    if Value.FCollaboration <> nil then Value.FCollaboration.FCollaborationInstanceSets.Remove(Value);
    FCollaborationInstanceSets.Add(Value);
    Value.FCollaboration := Self;
  end;
end;

procedure PUMLCollaboration.RemoveCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
begin
  if Value <> nil then begin
    FCollaborationInstanceSets.Remove(Value);
    Value.FCollaboration := nil;
  end;
end;

procedure PUMLCollaboration.InsertCollaborationInstanceSet(Index: Integer; Value: PUMLCollaborationInstanceSet);
begin
  if Value <> nil then begin
    if Value.FCollaboration <> nil then Value.FCollaboration.FCollaborationInstanceSets.Remove(Value);
    FCollaborationInstanceSets.Insert(Index, Value);
    Value.FCollaboration := Self;
  end;
end;

procedure PUMLCollaboration.DeleteCollaborationInstanceSet(Index: Integer);
begin
  RemoveCollaborationInstanceSet(FCollaborationInstanceSets.Items[Index] as UMLModels.PUMLCollaborationInstanceSet);
end;

function PUMLCollaboration.IndexOfCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet): Integer;
begin
  Result := FCollaborationInstanceSets.IndexOf(Value);
end;

procedure PUMLCollaboration.ClearUserCollaborations;
var
  I: Integer;
begin
  for I := FUserCollaborations.Count - 1 downto 0 do
    DeleteUserCollaboration(I);
end;

procedure PUMLCollaboration.AddUserCollaboration(Value: PUMLCollaboration);
begin
  if Value <> nil then begin
    FUserCollaborations.Add(Value);
    Value.FUsedCollaborations.Add(Self);
  end;
end;

procedure PUMLCollaboration.RemoveUserCollaboration(Value: PUMLCollaboration);
begin
  if Value <> nil then begin
    FUserCollaborations.Remove(Value);
    Value.FUsedCollaborations.Remove(Self);
  end;
end;

procedure PUMLCollaboration.InsertUserCollaboration(Index: Integer; Value: PUMLCollaboration);
begin
  if Value <> nil then begin
    FUserCollaborations.Insert(Index, Value);
    Value.FUsedCollaborations.Add(Self);
  end;
end;

procedure PUMLCollaboration.DeleteUserCollaboration(Index: Integer);
begin
  RemoveUserCollaboration(FUserCollaborations.Items[Index] as UMLModels.PUMLCollaboration);
end;

function PUMLCollaboration.IndexOfUserCollaboration(Value: PUMLCollaboration): Integer;
begin
  Result := FUserCollaborations.IndexOf(Value);
end;

procedure PUMLCollaboration.ClearUsedCollaborations;
var
  I: Integer;
begin
  for I := FUsedCollaborations.Count - 1 downto 0 do
    DeleteUsedCollaboration(I);
end;

procedure PUMLCollaboration.AddUsedCollaboration(Value: PUMLCollaboration);
begin
  if Value <> nil then begin
    FUsedCollaborations.Add(Value);
    Value.FUserCollaborations.Add(Self);
  end;
end;

procedure PUMLCollaboration.RemoveUsedCollaboration(Value: PUMLCollaboration);
begin
  if Value <> nil then begin
    FUsedCollaborations.Remove(Value);
    Value.FUserCollaborations.Remove(Self);
  end;
end;

procedure PUMLCollaboration.InsertUsedCollaboration(Index: Integer; Value: PUMLCollaboration);
begin
  if Value <> nil then begin
    FUsedCollaborations.Insert(Index, Value);
    Value.FUserCollaborations.Add(Self);
  end;
end;

procedure PUMLCollaboration.DeleteUsedCollaboration(Index: Integer);
begin
  RemoveUsedCollaboration(FUsedCollaborations.Items[Index] as UMLModels.PUMLCollaboration);
end;

function PUMLCollaboration.IndexOfUsedCollaboration(Value: PUMLCollaboration): Integer;
begin
  Result := FUsedCollaborations.IndexOf(Value);
end;

function PUMLCollaboration.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLCollaboration.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLCollaboration.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'RepresentedOperation' then begin
    Result := RepresentedOperation;
  end
  else if Name = 'RepresentedClassifier' then begin
    Result := RepresentedClassifier;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLCollaboration.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'RepresentedOperation' then begin
    RepresentedOperation := Value as PUMLOperation;
  end
  else if Name = 'RepresentedClassifier' then begin
    RepresentedClassifier := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLCollaboration.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Interactions' then begin
    AddInteraction(Value as PUMLInteraction);
  end
  else if Name = 'CollaborationInstanceSets' then begin
    AddCollaborationInstanceSet(Value as PUMLCollaborationInstanceSet);
  end
  else if Name = 'UserCollaborations' then begin
    AddUserCollaboration(Value as PUMLCollaboration);
  end
  else if Name = 'UsedCollaborations' then begin
    AddUsedCollaboration(Value as PUMLCollaboration);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLCollaboration.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Interactions' then begin
    RemoveInteraction(Value as PUMLInteraction);
  end
  else if Name = 'CollaborationInstanceSets' then begin
    RemoveCollaborationInstanceSet(Value as PUMLCollaborationInstanceSet);
  end
  else if Name = 'UserCollaborations' then begin
    RemoveUserCollaboration(Value as PUMLCollaboration);
  end
  else if Name = 'UsedCollaborations' then begin
    RemoveUsedCollaboration(Value as PUMLCollaboration);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLCollaboration.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Interactions' then begin
    InsertInteraction(Index, Value as PUMLInteraction);
  end
  else if Name = 'CollaborationInstanceSets' then begin
    InsertCollaborationInstanceSet(Index, Value as PUMLCollaborationInstanceSet);
  end
  else if Name = 'UserCollaborations' then begin
    InsertUserCollaboration(Index, Value as PUMLCollaboration);
  end
  else if Name = 'UsedCollaborations' then begin
    InsertUsedCollaboration(Index, Value as PUMLCollaboration);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLCollaboration.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Interactions' then begin
    DeleteInteraction(Index);
  end
  else if Name = 'CollaborationInstanceSets' then begin
    DeleteCollaborationInstanceSet(Index);
  end
  else if Name = 'UserCollaborations' then begin
    DeleteUserCollaboration(Index);
  end
  else if Name = 'UsedCollaborations' then begin
    DeleteUsedCollaboration(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLCollaboration.MOF_ClearCollection(Name: string);
begin
  if Name = 'Interactions' then begin
    ClearInteractions;
  end
  else if Name = 'CollaborationInstanceSets' then begin
    ClearCollaborationInstanceSets;
  end
  else if Name = 'UserCollaborations' then begin
    ClearUserCollaborations;
  end
  else if Name = 'UsedCollaborations' then begin
    ClearUsedCollaborations;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLCollaboration.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Interactions' then begin
    Result := IndexOfInteraction(Value as PUMLInteraction);
  end
  else if Name = 'CollaborationInstanceSets' then begin
    Result := IndexOfCollaborationInstanceSet(Value as PUMLCollaborationInstanceSet);
  end
  else if Name = 'UserCollaborations' then begin
    Result := IndexOfUserCollaboration(Value as PUMLCollaboration);
  end
  else if Name = 'UsedCollaborations' then begin
    Result := IndexOfUsedCollaboration(Value as PUMLCollaboration);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLCollaboration.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Interactions' then begin
    Result := Interactions[Index];
  end
  else if Name = 'CollaborationInstanceSets' then begin
    Result := CollaborationInstanceSets[Index];
  end
  else if Name = 'UserCollaborations' then begin
    Result := UserCollaborations[Index];
  end
  else if Name = 'UsedCollaborations' then begin
    Result := UsedCollaborations[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLCollaboration.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Interactions' then begin
    Result := InteractionCount;
  end
  else if Name = 'CollaborationInstanceSets' then begin
    Result := CollaborationInstanceSetCount;
  end
  else if Name = 'UserCollaborations' then begin
    Result := UserCollaborationCount;
  end
  else if Name = 'UsedCollaborations' then begin
    Result := UsedCollaborationCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLCollaboration.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLInteraction') or
     MetaModel.IsKindOf(Kind, 'UMLAssociationRole') or
     MetaModel.IsKindOf(Kind, 'UMLClassifierRole') or
     MetaModel.IsKindOf(Kind, 'UMLTemplateParameter') then
    Result := True
  else if MetaModel.IsKindOf(Kind, 'UMLElement') then
    Result := False
  else
    Result := inherited CanContainKind(Kind);
end;

// PUMLCollaboration
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLClassifier

constructor PUMLClassifier.Create;
begin
  inherited;
  FOperations := POrderedSet.Create;
  FTypedFeatures := POrderedSet.Create;
  FTypedParameters := POrderedSet.Create;
  FAssociations := PAssociationEndOrderedSet.Create;
  FPowertypeGeneralizations := POrderedSet.Create;
  FAttributes := POrderedSet.Create;
  FOwnedPorts := POrderedSet.Create;
  FOwnedConnectors := POrderedSet.Create;
  FInstances := POrderedSet.Create;
  FCreateActions := POrderedSet.Create;
  FClassifierRoles := POrderedSet.Create;
  FOwnedCollaborations := POrderedSet.Create;
  FOwnedCollaborationInstanceSets := POrderedSet.Create;
  FClassifierInStates := POrderedSet.Create;
  FObjectFlowStates := POrderedSet.Create;
end;

destructor PUMLClassifier.Destroy;
begin
  FOperations.Free;
  FTypedFeatures.Free;
  FTypedParameters.Free;
  FAssociations.Free;
  FPowertypeGeneralizations.Free;
  FAttributes.Free;
  FOwnedPorts.Free;
  FOwnedConnectors.Free;
  FInstances.Free;
  FCreateActions.Free;
  FClassifierRoles.Free;
  FOwnedCollaborations.Free;
  FOwnedCollaborationInstanceSets.Free;
  FClassifierInStates.Free;
  FObjectFlowStates.Free;
  inherited;
end;

function PUMLClassifier.GetOperation(Index: Integer): PUMLOperation;
begin
  Result := FOperations.Items[Index] as UMLModels.PUMLOperation;
end;

function PUMLClassifier.GetOperationCount: Integer;
begin
  Result := FOperations.Count;
end;

function PUMLClassifier.GetTypedFeature(Index: Integer): PUMLStructuralFeature;
begin
  Result := FTypedFeatures.Items[Index] as UMLModels.PUMLStructuralFeature;
end;

function PUMLClassifier.GetTypedFeatureCount: Integer;
begin
  Result := FTypedFeatures.Count;
end;

function PUMLClassifier.GetTypedParameter(Index: Integer): PUMLParameter;
begin
  Result := FTypedParameters.Items[Index] as UMLModels.PUMLParameter;
end;

function PUMLClassifier.GetTypedParameterCount: Integer;
begin
  Result := FTypedParameters.Count;
end;

function PUMLClassifier.GetAssociation(Index: Integer): PUMLAssociationEnd;
begin
  Result := FAssociations.Items[Index];
end;

function PUMLClassifier.GetAssociationCount: Integer;
begin
  Result := FAssociations.Count;
end;

function PUMLClassifier.GetPowertypeGeneralization(Index: Integer): PUMLGeneralization;
begin
  Result := FPowertypeGeneralizations.Items[Index] as UMLModels.PUMLGeneralization;
end;

function PUMLClassifier.GetPowertypeGeneralizationCount: Integer;
begin
  Result := FPowertypeGeneralizations.Count;
end;

function PUMLClassifier.GetAttribute(Index: Integer): PUMLAttribute;
begin
  Result := FAttributes.Items[Index] as UMLModels.PUMLAttribute;
end;

function PUMLClassifier.GetAttributeCount: Integer;
begin
  Result := FAttributes.Count;
end;

function PUMLClassifier.GetOwnedPort(Index: Integer): PUMLPort;
begin
  Result := FOwnedPorts.Items[Index] as UMLModels.PUMLPort;
end;

function PUMLClassifier.GetOwnedPortCount: Integer;
begin
  Result := FOwnedPorts.Count;
end;

function PUMLClassifier.GetOwnedConnector(Index: Integer): PUMLConnector;
begin
  Result := FOwnedConnectors.Items[Index] as UMLModels.PUMLConnector;
end;

function PUMLClassifier.GetOwnedConnectorCount: Integer;
begin
  Result := FOwnedConnectors.Count;
end;

function PUMLClassifier.GetInstance(Index: Integer): PUMLInstance;
begin
  Result := FInstances.Items[Index] as UMLModels.PUMLInstance;
end;

function PUMLClassifier.GetInstanceCount: Integer;
begin
  Result := FInstances.Count;
end;

function PUMLClassifier.GetCreateAction(Index: Integer): PUMLCreateAction;
begin
  Result := FCreateActions.Items[Index] as UMLModels.PUMLCreateAction;
end;

function PUMLClassifier.GetCreateActionCount: Integer;
begin
  Result := FCreateActions.Count;
end;

function PUMLClassifier.GetClassifierRole(Index: Integer): PUMLClassifierRole;
begin
  Result := FClassifierRoles.Items[Index] as UMLModels.PUMLClassifierRole;
end;

function PUMLClassifier.GetClassifierRoleCount: Integer;
begin
  Result := FClassifierRoles.Count;
end;

function PUMLClassifier.GetOwnedCollaboration(Index: Integer): PUMLCollaboration;
begin
  Result := FOwnedCollaborations.Items[Index] as UMLModels.PUMLCollaboration;
end;

function PUMLClassifier.GetOwnedCollaborationCount: Integer;
begin
  Result := FOwnedCollaborations.Count;
end;

function PUMLClassifier.GetOwnedCollaborationInstanceSet(Index: Integer): PUMLCollaborationInstanceSet;
begin
  Result := FOwnedCollaborationInstanceSets.Items[Index] as UMLModels.PUMLCollaborationInstanceSet;
end;

function PUMLClassifier.GetOwnedCollaborationInstanceSetCount: Integer;
begin
  Result := FOwnedCollaborationInstanceSets.Count;
end;

function PUMLClassifier.GetClassifierInState(Index: Integer): PUMLClassifierInState;
begin
  Result := FClassifierInStates.Items[Index] as UMLModels.PUMLClassifierInState;
end;

function PUMLClassifier.GetClassifierInStateCount: Integer;
begin
  Result := FClassifierInStates.Count;
end;

function PUMLClassifier.GetObjectFlowState(Index: Integer): PUMLObjectFlowState;
begin
  Result := FObjectFlowStates.Items[Index] as UMLModels.PUMLObjectFlowState;
end;

function PUMLClassifier.GetObjectFlowStateCount: Integer;
begin
  Result := FObjectFlowStates.Count;
end;

procedure PUMLClassifier.ClearOperations;
var
  I: Integer;
begin
  for I := FOperations.Count - 1 downto 0 do
    DeleteOperation(I);
end;

procedure PUMLClassifier.AddOperation(Value: PUMLOperation);
begin
  if Value <> nil then begin
    if Value.FOwner <> nil then begin
      Value.FOwner.FOperations.Remove(Value);
      Value.FOwner.RemoveVirtualOwnedModel(Value);
    end;
    FOperations.Add(Value);
    Value.FOwner := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLClassifier.RemoveOperation(Value: PUMLOperation);
begin
  if Value <> nil then begin
    FOperations.Remove(Value);
    Value.FOwner := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLClassifier.InsertOperation(Index: Integer; Value: PUMLOperation);
begin
  if Value <> nil then begin
    if Value.FOwner <> nil then begin
      Value.FOwner.FOperations.Remove(Value);
      Value.FOwner.RemoveVirtualOwnedModel(Value);
    end;
    FOperations.Insert(Index, Value);
    Value.FOwner := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLClassifier.DeleteOperation(Index: Integer);
begin
  RemoveOperation(FOperations.Items[Index] as UMLModels.PUMLOperation);
end;

function PUMLClassifier.IndexOfOperation(Value: PUMLOperation): Integer;
begin
  Result := FOperations.IndexOf(Value);
end;

procedure PUMLClassifier.ClearTypedFeatures;
var
  I: Integer;
begin
  for I := FTypedFeatures.Count - 1 downto 0 do
    DeleteTypedFeature(I);
end;

procedure PUMLClassifier.AddTypedFeature(Value: PUMLStructuralFeature);
begin
  if Value <> nil then begin
    if Value.FType_ <> nil then Value.FType_.FTypedFeatures.Remove(Value);
    FTypedFeatures.Add(Value);
    Value.FType_ := Self;
  end;
end;

procedure PUMLClassifier.RemoveTypedFeature(Value: PUMLStructuralFeature);
begin
  if Value <> nil then begin
    FTypedFeatures.Remove(Value);
    Value.FType_ := nil;
  end;
end;

procedure PUMLClassifier.InsertTypedFeature(Index: Integer; Value: PUMLStructuralFeature);
begin
  if Value <> nil then begin
    if Value.FType_ <> nil then Value.FType_.FTypedFeatures.Remove(Value);
    FTypedFeatures.Insert(Index, Value);
    Value.FType_ := Self;
  end;
end;

procedure PUMLClassifier.DeleteTypedFeature(Index: Integer);
begin
  RemoveTypedFeature(FTypedFeatures.Items[Index] as UMLModels.PUMLStructuralFeature);
end;

function PUMLClassifier.IndexOfTypedFeature(Value: PUMLStructuralFeature): Integer;
begin
  Result := FTypedFeatures.IndexOf(Value);
end;

procedure PUMLClassifier.ClearTypedParameters;
var
  I: Integer;
begin
  for I := FTypedParameters.Count - 1 downto 0 do
    DeleteTypedParameter(I);
end;

procedure PUMLClassifier.AddTypedParameter(Value: PUMLParameter);
begin
  if Value <> nil then begin
    if Value.FType_ <> nil then Value.FType_.FTypedParameters.Remove(Value);
    FTypedParameters.Add(Value);
    Value.FType_ := Self;
  end;
end;

procedure PUMLClassifier.RemoveTypedParameter(Value: PUMLParameter);
begin
  if Value <> nil then begin
    FTypedParameters.Remove(Value);
    Value.FType_ := nil;
  end;
end;

procedure PUMLClassifier.InsertTypedParameter(Index: Integer; Value: PUMLParameter);
begin
  if Value <> nil then begin
    if Value.FType_ <> nil then Value.FType_.FTypedParameters.Remove(Value);
    FTypedParameters.Insert(Index, Value);
    Value.FType_ := Self;
  end;
end;

procedure PUMLClassifier.DeleteTypedParameter(Index: Integer);
begin
  RemoveTypedParameter(FTypedParameters.Items[Index] as UMLModels.PUMLParameter);
end;

function PUMLClassifier.IndexOfTypedParameter(Value: PUMLParameter): Integer;
begin
  Result := FTypedParameters.IndexOf(Value);
end;

procedure PUMLClassifier.ClearAssociations;
var
  I: Integer;
begin
  for I := FAssociations.Count - 1 downto 0 do
    DeleteAssociation(I);
end;

procedure PUMLClassifier.AddAssociation(Value: PUMLAssociationEnd);
begin
  if Value <> nil then begin
    if Value.FParticipant <> nil then Value.FParticipant.FAssociations.Remove(Value);
    FAssociations.Add(Value);
    Value.FParticipant := Self;
  end;
end;

procedure PUMLClassifier.RemoveAssociation(Value: PUMLAssociationEnd);
begin
  if Value <> nil then begin
    FAssociations.Remove(Value);
    Value.FParticipant := nil;
  end;
end;

procedure PUMLClassifier.InsertAssociation(Index: Integer; Value: PUMLAssociationEnd);
begin
  if Value <> nil then begin
    if Value.FParticipant <> nil then Value.FParticipant.FAssociations.Remove(Value);
    FAssociations.Insert(Index, Value);
    Value.FParticipant := Self;
  end;
end;

procedure PUMLClassifier.DeleteAssociation(Index: Integer);
begin
  RemoveAssociation(FAssociations.Items[Index]);
end;

function PUMLClassifier.IndexOfAssociation(Value: PUMLAssociationEnd): Integer;
begin
  Result := FAssociations.IndexOf(Value);
end;

procedure PUMLClassifier.ClearPowertypeGeneralizations;
var
  I: Integer;
begin
  for I := FPowertypeGeneralizations.Count - 1 downto 0 do
    DeletePowertypeGeneralization(I);
end;

procedure PUMLClassifier.AddPowertypeGeneralization(Value: PUMLGeneralization);
begin
  if Value <> nil then begin
    if Value.FPowertype <> nil then Value.FPowertype.FPowertypeGeneralizations.Remove(Value);
    FPowertypeGeneralizations.Add(Value);
    Value.FPowertype := Self;
  end;
end;

procedure PUMLClassifier.RemovePowertypeGeneralization(Value: PUMLGeneralization);
begin
  if Value <> nil then begin
    FPowertypeGeneralizations.Remove(Value);
    Value.FPowertype := nil;
  end;
end;

procedure PUMLClassifier.InsertPowertypeGeneralization(Index: Integer; Value: PUMLGeneralization);
begin
  if Value <> nil then begin
    if Value.FPowertype <> nil then Value.FPowertype.FPowertypeGeneralizations.Remove(Value);
    FPowertypeGeneralizations.Insert(Index, Value);
    Value.FPowertype := Self;
  end;
end;

procedure PUMLClassifier.DeletePowertypeGeneralization(Index: Integer);
begin
  RemovePowertypeGeneralization(FPowertypeGeneralizations.Items[Index] as UMLModels.PUMLGeneralization);
end;

function PUMLClassifier.IndexOfPowertypeGeneralization(Value: PUMLGeneralization): Integer;
begin
  Result := FPowertypeGeneralizations.IndexOf(Value);
end;

procedure PUMLClassifier.ClearAttributes;
var
  I: Integer;
begin
  for I := FAttributes.Count - 1 downto 0 do
    DeleteAttribute(I);
end;

procedure PUMLClassifier.AddAttribute(Value: PUMLAttribute);
begin
  if Value <> nil then begin
    if Value.FOwner <> nil then begin
      Value.FOwner.FAttributes.Remove(Value);
      Value.FOwner.RemoveVirtualOwnedModel(Value);
    end;
    FAttributes.Add(Value);
    Value.FOwner := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLClassifier.RemoveAttribute(Value: PUMLAttribute);
begin
  if Value <> nil then begin
    FAttributes.Remove(Value);
    Value.FOwner := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLClassifier.InsertAttribute(Index: Integer; Value: PUMLAttribute);
begin
  if Value <> nil then begin
    if Value.FOwner <> nil then begin
      Value.FOwner.FAttributes.Remove(Value);
      Value.FOwner.RemoveVirtualOwnedModel(Value);
    end;
    FAttributes.Insert(Index, Value);
    Value.FOwner := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLClassifier.DeleteAttribute(Index: Integer);
begin
  RemoveAttribute(FAttributes.Items[Index] as UMLModels.PUMLAttribute);
end;

function PUMLClassifier.IndexOfAttribute(Value: PUMLAttribute): Integer;
begin
  Result := FAttributes.IndexOf(Value);
end;

procedure PUMLClassifier.ClearOwnedPorts;
var
  I: Integer;
begin
  for I := FOwnedPorts.Count - 1 downto 0 do
    DeleteOwnedPort(I);
end;

procedure PUMLClassifier.AddOwnedPort(Value: PUMLPort);
begin
  if Value <> nil then begin
    if Value.FOwner <> nil then begin
      Value.FOwner.FOwnedPorts.Remove(Value);
      Value.FOwner.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedPorts.Add(Value);
    Value.FOwner := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLClassifier.RemoveOwnedPort(Value: PUMLPort);
begin
  if Value <> nil then begin
    FOwnedPorts.Remove(Value);
    Value.FOwner := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLClassifier.InsertOwnedPort(Index: Integer; Value: PUMLPort);
begin
  if Value <> nil then begin
    if Value.FOwner <> nil then begin
      Value.FOwner.FOwnedPorts.Remove(Value);
      Value.FOwner.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedPorts.Insert(Index, Value);
    Value.FOwner := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLClassifier.DeleteOwnedPort(Index: Integer);
begin
  RemoveOwnedPort(FOwnedPorts.Items[Index] as UMLModels.PUMLPort);
end;

function PUMLClassifier.IndexOfOwnedPort(Value: PUMLPort): Integer;
begin
  Result := FOwnedPorts.IndexOf(Value);
end;

procedure PUMLClassifier.ClearOwnedConnectors;
var
  I: Integer;
begin
  for I := FOwnedConnectors.Count - 1 downto 0 do
    DeleteOwnedConnector(I);
end;

procedure PUMLClassifier.AddOwnedConnector(Value: PUMLConnector);
begin
  if Value <> nil then begin
    if Value.FOwner <> nil then begin
      Value.FOwner.FOwnedConnectors.Remove(Value);
      Value.FOwner.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedConnectors.Add(Value);
    Value.FOwner := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLClassifier.RemoveOwnedConnector(Value: PUMLConnector);
begin
  if Value <> nil then begin
    FOwnedConnectors.Remove(Value);
    Value.FOwner := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLClassifier.InsertOwnedConnector(Index: Integer; Value: PUMLConnector);
begin
  if Value <> nil then begin
    if Value.FOwner <> nil then begin
      Value.FOwner.FOwnedConnectors.Remove(Value);
      Value.FOwner.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedConnectors.Insert(Index, Value);
    Value.FOwner := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLClassifier.DeleteOwnedConnector(Index: Integer);
begin
  RemoveOwnedConnector(FOwnedConnectors.Items[Index] as UMLModels.PUMLConnector);
end;

function PUMLClassifier.IndexOfOwnedConnector(Value: PUMLConnector): Integer;
begin
  Result := FOwnedConnectors.IndexOf(Value);
end;

procedure PUMLClassifier.ClearInstances;
var
  I: Integer;
begin
  for I := FInstances.Count - 1 downto 0 do
    DeleteInstance(I);
end;

procedure PUMLClassifier.AddInstance(Value: PUMLInstance);
begin
  if Value <> nil then begin
    if Value.FClassifier <> nil then Value.FClassifier.FInstances.Remove(Value);
    FInstances.Add(Value);
    Value.FClassifier := Self;
  end;
end;

procedure PUMLClassifier.RemoveInstance(Value: PUMLInstance);
begin
  if Value <> nil then begin
    FInstances.Remove(Value);
    Value.FClassifier := nil;
  end;
end;

procedure PUMLClassifier.InsertInstance(Index: Integer; Value: PUMLInstance);
begin
  if Value <> nil then begin
    if Value.FClassifier <> nil then Value.FClassifier.FInstances.Remove(Value);
    FInstances.Insert(Index, Value);
    Value.FClassifier := Self;
  end;
end;

procedure PUMLClassifier.DeleteInstance(Index: Integer);
begin
  RemoveInstance(FInstances.Items[Index] as UMLModels.PUMLInstance);
end;

function PUMLClassifier.IndexOfInstance(Value: PUMLInstance): Integer;
begin
  Result := FInstances.IndexOf(Value);
end;

procedure PUMLClassifier.ClearCreateActions;
var
  I: Integer;
begin
  for I := FCreateActions.Count - 1 downto 0 do
    DeleteCreateAction(I);
end;

procedure PUMLClassifier.AddCreateAction(Value: PUMLCreateAction);
begin
  if Value <> nil then begin
    if Value.FInstantiation <> nil then Value.FInstantiation.FCreateActions.Remove(Value);
    FCreateActions.Add(Value);
    Value.FInstantiation := Self;
  end;
end;

procedure PUMLClassifier.RemoveCreateAction(Value: PUMLCreateAction);
begin
  if Value <> nil then begin
    FCreateActions.Remove(Value);
    Value.FInstantiation := nil;
  end;
end;

procedure PUMLClassifier.InsertCreateAction(Index: Integer; Value: PUMLCreateAction);
begin
  if Value <> nil then begin
    if Value.FInstantiation <> nil then Value.FInstantiation.FCreateActions.Remove(Value);
    FCreateActions.Insert(Index, Value);
    Value.FInstantiation := Self;
  end;
end;

procedure PUMLClassifier.DeleteCreateAction(Index: Integer);
begin
  RemoveCreateAction(FCreateActions.Items[Index] as UMLModels.PUMLCreateAction);
end;

function PUMLClassifier.IndexOfCreateAction(Value: PUMLCreateAction): Integer;
begin
  Result := FCreateActions.IndexOf(Value);
end;

procedure PUMLClassifier.ClearClassifierRoles;
var
  I: Integer;
begin
  for I := FClassifierRoles.Count - 1 downto 0 do
    DeleteClassifierRole(I);
end;

procedure PUMLClassifier.AddClassifierRole(Value: PUMLClassifierRole);
begin
  if Value <> nil then begin
    if Value.FBase <> nil then Value.FBase.FClassifierRoles.Remove(Value);
    FClassifierRoles.Add(Value);
    Value.FBase := Self;
  end;
end;

procedure PUMLClassifier.RemoveClassifierRole(Value: PUMLClassifierRole);
begin
  if Value <> nil then begin
    FClassifierRoles.Remove(Value);
    Value.FBase := nil;
  end;
end;

procedure PUMLClassifier.InsertClassifierRole(Index: Integer; Value: PUMLClassifierRole);
begin
  if Value <> nil then begin
    if Value.FBase <> nil then Value.FBase.FClassifierRoles.Remove(Value);
    FClassifierRoles.Insert(Index, Value);
    Value.FBase := Self;
  end;
end;

procedure PUMLClassifier.DeleteClassifierRole(Index: Integer);
begin
  RemoveClassifierRole(FClassifierRoles.Items[Index] as UMLModels.PUMLClassifierRole);
end;

function PUMLClassifier.IndexOfClassifierRole(Value: PUMLClassifierRole): Integer;
begin
  Result := FClassifierRoles.IndexOf(Value);
end;

procedure PUMLClassifier.ClearOwnedCollaborations;
var
  I: Integer;
begin
  for I := FOwnedCollaborations.Count - 1 downto 0 do
    DeleteOwnedCollaboration(I);
end;

procedure PUMLClassifier.AddOwnedCollaboration(Value: PUMLCollaboration);
begin
  if Value <> nil then begin
    if Value.FRepresentedClassifier <> nil then begin
      Value.FRepresentedClassifier.FOwnedCollaborations.Remove(Value);
      Value.FRepresentedClassifier.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedCollaborations.Add(Value);
    Value.FRepresentedClassifier := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLClassifier.RemoveOwnedCollaboration(Value: PUMLCollaboration);
begin
  if Value <> nil then begin
    FOwnedCollaborations.Remove(Value);
    Value.FRepresentedClassifier := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLClassifier.InsertOwnedCollaboration(Index: Integer; Value: PUMLCollaboration);
begin
  if Value <> nil then begin
    if Value.FRepresentedClassifier <> nil then begin
      Value.FRepresentedClassifier.FOwnedCollaborations.Remove(Value);
      Value.FRepresentedClassifier.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedCollaborations.Insert(Index, Value);
    Value.FRepresentedClassifier := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLClassifier.DeleteOwnedCollaboration(Index: Integer);
begin
  RemoveOwnedCollaboration(FOwnedCollaborations.Items[Index] as UMLModels.PUMLCollaboration);
end;

function PUMLClassifier.IndexOfOwnedCollaboration(Value: PUMLCollaboration): Integer;
begin
  Result := FOwnedCollaborations.IndexOf(Value);
end;

procedure PUMLClassifier.ClearOwnedCollaborationInstanceSets;
var
  I: Integer;
begin
  for I := FOwnedCollaborationInstanceSets.Count - 1 downto 0 do
    DeleteOwnedCollaborationInstanceSet(I);
end;

procedure PUMLClassifier.AddOwnedCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
begin
  if Value <> nil then begin
    if Value.FRepresentedClassifier <> nil then begin
      Value.FRepresentedClassifier.FOwnedCollaborationInstanceSets.Remove(Value);
      Value.FRepresentedClassifier.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedCollaborationInstanceSets.Add(Value);
    Value.FRepresentedClassifier := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLClassifier.RemoveOwnedCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
begin
  if Value <> nil then begin
    FOwnedCollaborationInstanceSets.Remove(Value);
    Value.FRepresentedClassifier := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLClassifier.InsertOwnedCollaborationInstanceSet(Index: Integer; Value: PUMLCollaborationInstanceSet);
begin
  if Value <> nil then begin
    if Value.FRepresentedClassifier <> nil then begin
      Value.FRepresentedClassifier.FOwnedCollaborationInstanceSets.Remove(Value);
      Value.FRepresentedClassifier.RemoveVirtualOwnedModel(Value);
    end;
    FOwnedCollaborationInstanceSets.Insert(Index, Value);
    Value.FRepresentedClassifier := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLClassifier.DeleteOwnedCollaborationInstanceSet(Index: Integer);
begin
  RemoveOwnedCollaborationInstanceSet(FOwnedCollaborationInstanceSets.Items[Index] as UMLModels.PUMLCollaborationInstanceSet);
end;

function PUMLClassifier.IndexOfOwnedCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet): Integer;
begin
  Result := FOwnedCollaborationInstanceSets.IndexOf(Value);
end;

procedure PUMLClassifier.ClearClassifierInStates;
var
  I: Integer;
begin
  for I := FClassifierInStates.Count - 1 downto 0 do
    DeleteClassifierInState(I);
end;

procedure PUMLClassifier.AddClassifierInState(Value: PUMLClassifierInState);
begin
  if Value <> nil then begin
    if Value.FType_ <> nil then Value.FType_.FClassifierInStates.Remove(Value);
    FClassifierInStates.Add(Value);
    Value.FType_ := Self;
  end;
end;

procedure PUMLClassifier.RemoveClassifierInState(Value: PUMLClassifierInState);
begin
  if Value <> nil then begin
    FClassifierInStates.Remove(Value);
    Value.FType_ := nil;
  end;
end;

procedure PUMLClassifier.InsertClassifierInState(Index: Integer; Value: PUMLClassifierInState);
begin
  if Value <> nil then begin
    if Value.FType_ <> nil then Value.FType_.FClassifierInStates.Remove(Value);
    FClassifierInStates.Insert(Index, Value);
    Value.FType_ := Self;
  end;
end;

procedure PUMLClassifier.DeleteClassifierInState(Index: Integer);
begin
  RemoveClassifierInState(FClassifierInStates.Items[Index] as UMLModels.PUMLClassifierInState);
end;

function PUMLClassifier.IndexOfClassifierInState(Value: PUMLClassifierInState): Integer;
begin
  Result := FClassifierInStates.IndexOf(Value);
end;

procedure PUMLClassifier.ClearObjectFlowStates;
var
  I: Integer;
begin
  for I := FObjectFlowStates.Count - 1 downto 0 do
    DeleteObjectFlowState(I);
end;

procedure PUMLClassifier.AddObjectFlowState(Value: PUMLObjectFlowState);
begin
  if Value <> nil then begin
    if Value.FType_ <> nil then Value.FType_.FObjectFlowStates.Remove(Value);
    FObjectFlowStates.Add(Value);
    Value.FType_ := Self;
  end;
end;

procedure PUMLClassifier.RemoveObjectFlowState(Value: PUMLObjectFlowState);
begin
  if Value <> nil then begin
    FObjectFlowStates.Remove(Value);
    Value.FType_ := nil;
  end;
end;

procedure PUMLClassifier.InsertObjectFlowState(Index: Integer; Value: PUMLObjectFlowState);
begin
  if Value <> nil then begin
    if Value.FType_ <> nil then Value.FType_.FObjectFlowStates.Remove(Value);
    FObjectFlowStates.Insert(Index, Value);
    Value.FType_ := Self;
  end;
end;

procedure PUMLClassifier.DeleteObjectFlowState(Index: Integer);
begin
  RemoveObjectFlowState(FObjectFlowStates.Items[Index] as UMLModels.PUMLObjectFlowState);
end;

function PUMLClassifier.IndexOfObjectFlowState(Value: PUMLObjectFlowState): Integer;
begin
  Result := FObjectFlowStates.IndexOf(Value);
end;

function PUMLClassifier.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLClassifier.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLClassifier.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLClassifier.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLClassifier.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Operations' then begin
    AddOperation(Value as PUMLOperation);
  end
  else if Name = 'TypedFeatures' then begin
    AddTypedFeature(Value as PUMLStructuralFeature);
  end
  else if Name = 'TypedParameters' then begin
    AddTypedParameter(Value as PUMLParameter);
  end
  else if Name = 'Associations' then begin
    AddAssociation(Value as PUMLAssociationEnd);
  end
  else if Name = 'PowertypeGeneralizations' then begin
    AddPowertypeGeneralization(Value as PUMLGeneralization);
  end
  else if Name = 'Attributes' then begin
    AddAttribute(Value as PUMLAttribute);
  end
  else if Name = 'OwnedPorts' then begin
    AddOwnedPort(Value as PUMLPort);
  end
  else if Name = 'OwnedConnectors' then begin
    AddOwnedConnector(Value as PUMLConnector);
  end
  else if Name = 'Instances' then begin
    AddInstance(Value as PUMLInstance);
  end
  else if Name = 'CreateActions' then begin
    AddCreateAction(Value as PUMLCreateAction);
  end
  else if Name = 'ClassifierRoles' then begin
    AddClassifierRole(Value as PUMLClassifierRole);
  end
  else if Name = 'OwnedCollaborations' then begin
    AddOwnedCollaboration(Value as PUMLCollaboration);
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    AddOwnedCollaborationInstanceSet(Value as PUMLCollaborationInstanceSet);
  end
  else if Name = 'ClassifierInStates' then begin
    AddClassifierInState(Value as PUMLClassifierInState);
  end
  else if Name = 'ObjectFlowStates' then begin
    AddObjectFlowState(Value as PUMLObjectFlowState);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLClassifier.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Operations' then begin
    RemoveOperation(Value as PUMLOperation);
  end
  else if Name = 'TypedFeatures' then begin
    RemoveTypedFeature(Value as PUMLStructuralFeature);
  end
  else if Name = 'TypedParameters' then begin
    RemoveTypedParameter(Value as PUMLParameter);
  end
  else if Name = 'Associations' then begin
    RemoveAssociation(Value as PUMLAssociationEnd);
  end
  else if Name = 'PowertypeGeneralizations' then begin
    RemovePowertypeGeneralization(Value as PUMLGeneralization);
  end
  else if Name = 'Attributes' then begin
    RemoveAttribute(Value as PUMLAttribute);
  end
  else if Name = 'OwnedPorts' then begin
    RemoveOwnedPort(Value as PUMLPort);
  end
  else if Name = 'OwnedConnectors' then begin
    RemoveOwnedConnector(Value as PUMLConnector);
  end
  else if Name = 'Instances' then begin
    RemoveInstance(Value as PUMLInstance);
  end
  else if Name = 'CreateActions' then begin
    RemoveCreateAction(Value as PUMLCreateAction);
  end
  else if Name = 'ClassifierRoles' then begin
    RemoveClassifierRole(Value as PUMLClassifierRole);
  end
  else if Name = 'OwnedCollaborations' then begin
    RemoveOwnedCollaboration(Value as PUMLCollaboration);
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    RemoveOwnedCollaborationInstanceSet(Value as PUMLCollaborationInstanceSet);
  end
  else if Name = 'ClassifierInStates' then begin
    RemoveClassifierInState(Value as PUMLClassifierInState);
  end
  else if Name = 'ObjectFlowStates' then begin
    RemoveObjectFlowState(Value as PUMLObjectFlowState);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLClassifier.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Operations' then begin
    InsertOperation(Index, Value as PUMLOperation);
  end
  else if Name = 'TypedFeatures' then begin
    InsertTypedFeature(Index, Value as PUMLStructuralFeature);
  end
  else if Name = 'TypedParameters' then begin
    InsertTypedParameter(Index, Value as PUMLParameter);
  end
  else if Name = 'Associations' then begin
    InsertAssociation(Index, Value as PUMLAssociationEnd);
  end
  else if Name = 'PowertypeGeneralizations' then begin
    InsertPowertypeGeneralization(Index, Value as PUMLGeneralization);
  end
  else if Name = 'Attributes' then begin
    InsertAttribute(Index, Value as PUMLAttribute);
  end
  else if Name = 'OwnedPorts' then begin
    InsertOwnedPort(Index, Value as PUMLPort);
  end
  else if Name = 'OwnedConnectors' then begin
    InsertOwnedConnector(Index, Value as PUMLConnector);
  end
  else if Name = 'Instances' then begin
    InsertInstance(Index, Value as PUMLInstance);
  end
  else if Name = 'CreateActions' then begin
    InsertCreateAction(Index, Value as PUMLCreateAction);
  end
  else if Name = 'ClassifierRoles' then begin
    InsertClassifierRole(Index, Value as PUMLClassifierRole);
  end
  else if Name = 'OwnedCollaborations' then begin
    InsertOwnedCollaboration(Index, Value as PUMLCollaboration);
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    InsertOwnedCollaborationInstanceSet(Index, Value as PUMLCollaborationInstanceSet);
  end
  else if Name = 'ClassifierInStates' then begin
    InsertClassifierInState(Index, Value as PUMLClassifierInState);
  end
  else if Name = 'ObjectFlowStates' then begin
    InsertObjectFlowState(Index, Value as PUMLObjectFlowState);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLClassifier.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Operations' then begin
    DeleteOperation(Index);
  end
  else if Name = 'TypedFeatures' then begin
    DeleteTypedFeature(Index);
  end
  else if Name = 'TypedParameters' then begin
    DeleteTypedParameter(Index);
  end
  else if Name = 'Associations' then begin
    DeleteAssociation(Index);
  end
  else if Name = 'PowertypeGeneralizations' then begin
    DeletePowertypeGeneralization(Index);
  end
  else if Name = 'Attributes' then begin
    DeleteAttribute(Index);
  end
  else if Name = 'OwnedPorts' then begin
    DeleteOwnedPort(Index);
  end
  else if Name = 'OwnedConnectors' then begin
    DeleteOwnedConnector(Index);
  end
  else if Name = 'Instances' then begin
    DeleteInstance(Index);
  end
  else if Name = 'CreateActions' then begin
    DeleteCreateAction(Index);
  end
  else if Name = 'ClassifierRoles' then begin
    DeleteClassifierRole(Index);
  end
  else if Name = 'OwnedCollaborations' then begin
    DeleteOwnedCollaboration(Index);
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    DeleteOwnedCollaborationInstanceSet(Index);
  end
  else if Name = 'ClassifierInStates' then begin
    DeleteClassifierInState(Index);
  end
  else if Name = 'ObjectFlowStates' then begin
    DeleteObjectFlowState(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLClassifier.MOF_ClearCollection(Name: string);
begin
  if Name = 'Operations' then begin
    ClearOperations;
  end
  else if Name = 'TypedFeatures' then begin
    ClearTypedFeatures;
  end
  else if Name = 'TypedParameters' then begin
    ClearTypedParameters;
  end
  else if Name = 'Associations' then begin
    ClearAssociations;
  end
  else if Name = 'PowertypeGeneralizations' then begin
    ClearPowertypeGeneralizations;
  end
  else if Name = 'Attributes' then begin
    ClearAttributes;
  end
  else if Name = 'OwnedPorts' then begin
    ClearOwnedPorts;
  end
  else if Name = 'OwnedConnectors' then begin
    ClearOwnedConnectors;
  end
  else if Name = 'Instances' then begin
    ClearInstances;
  end
  else if Name = 'CreateActions' then begin
    ClearCreateActions;
  end
  else if Name = 'ClassifierRoles' then begin
    ClearClassifierRoles;
  end
  else if Name = 'OwnedCollaborations' then begin
    ClearOwnedCollaborations;
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    ClearOwnedCollaborationInstanceSets;
  end
  else if Name = 'ClassifierInStates' then begin
    ClearClassifierInStates;
  end
  else if Name = 'ObjectFlowStates' then begin
    ClearObjectFlowStates;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLClassifier.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Operations' then begin
    Result := IndexOfOperation(Value as PUMLOperation);
  end
  else if Name = 'TypedFeatures' then begin
    Result := IndexOfTypedFeature(Value as PUMLStructuralFeature);
  end
  else if Name = 'TypedParameters' then begin
    Result := IndexOfTypedParameter(Value as PUMLParameter);
  end
  else if Name = 'Associations' then begin
    Result := IndexOfAssociation(Value as PUMLAssociationEnd);
  end
  else if Name = 'PowertypeGeneralizations' then begin
    Result := IndexOfPowertypeGeneralization(Value as PUMLGeneralization);
  end
  else if Name = 'Attributes' then begin
    Result := IndexOfAttribute(Value as PUMLAttribute);
  end
  else if Name = 'OwnedPorts' then begin
    Result := IndexOfOwnedPort(Value as PUMLPort);
  end
  else if Name = 'OwnedConnectors' then begin
    Result := IndexOfOwnedConnector(Value as PUMLConnector);
  end
  else if Name = 'Instances' then begin
    Result := IndexOfInstance(Value as PUMLInstance);
  end
  else if Name = 'CreateActions' then begin
    Result := IndexOfCreateAction(Value as PUMLCreateAction);
  end
  else if Name = 'ClassifierRoles' then begin
    Result := IndexOfClassifierRole(Value as PUMLClassifierRole);
  end
  else if Name = 'OwnedCollaborations' then begin
    Result := IndexOfOwnedCollaboration(Value as PUMLCollaboration);
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    Result := IndexOfOwnedCollaborationInstanceSet(Value as PUMLCollaborationInstanceSet);
  end
  else if Name = 'ClassifierInStates' then begin
    Result := IndexOfClassifierInState(Value as PUMLClassifierInState);
  end
  else if Name = 'ObjectFlowStates' then begin
    Result := IndexOfObjectFlowState(Value as PUMLObjectFlowState);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLClassifier.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Operations' then begin
    Result := Operations[Index];
  end
  else if Name = 'TypedFeatures' then begin
    Result := TypedFeatures[Index];
  end
  else if Name = 'TypedParameters' then begin
    Result := TypedParameters[Index];
  end
  else if Name = 'Associations' then begin
    Result := Associations[Index];
  end
  else if Name = 'PowertypeGeneralizations' then begin
    Result := PowertypeGeneralizations[Index];
  end
  else if Name = 'Attributes' then begin
    Result := Attributes[Index];
  end
  else if Name = 'OwnedPorts' then begin
    Result := OwnedPorts[Index];
  end
  else if Name = 'OwnedConnectors' then begin
    Result := OwnedConnectors[Index];
  end
  else if Name = 'Instances' then begin
    Result := Instances[Index];
  end
  else if Name = 'CreateActions' then begin
    Result := CreateActions[Index];
  end
  else if Name = 'ClassifierRoles' then begin
    Result := ClassifierRoles[Index];
  end
  else if Name = 'OwnedCollaborations' then begin
    Result := OwnedCollaborations[Index];
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    Result := OwnedCollaborationInstanceSets[Index];
  end
  else if Name = 'ClassifierInStates' then begin
    Result := ClassifierInStates[Index];
  end
  else if Name = 'ObjectFlowStates' then begin
    Result := ObjectFlowStates[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLClassifier.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Operations' then begin
    Result := OperationCount;
  end
  else if Name = 'TypedFeatures' then begin
    Result := TypedFeatureCount;
  end
  else if Name = 'TypedParameters' then begin
    Result := TypedParameterCount;
  end
  else if Name = 'Associations' then begin
    Result := AssociationCount;
  end
  else if Name = 'PowertypeGeneralizations' then begin
    Result := PowertypeGeneralizationCount;
  end
  else if Name = 'Attributes' then begin
    Result := AttributeCount;
  end
  else if Name = 'OwnedPorts' then begin
    Result := OwnedPortCount;
  end
  else if Name = 'OwnedConnectors' then begin
    Result := OwnedConnectorCount;
  end
  else if Name = 'Instances' then begin
    Result := InstanceCount;
  end
  else if Name = 'CreateActions' then begin
    Result := CreateActionCount;
  end
  else if Name = 'ClassifierRoles' then begin
    Result := ClassifierRoleCount;
  end
  else if Name = 'OwnedCollaborations' then begin
    Result := OwnedCollaborationCount;
  end
  else if Name = 'OwnedCollaborationInstanceSets' then begin
    Result := OwnedCollaborationInstanceSetCount;
  end
  else if Name = 'ClassifierInStates' then begin
    Result := ClassifierInStateCount;
  end
  else if Name = 'ObjectFlowStates' then begin
    Result := ObjectFlowStateCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLClassifier.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLCollaboration') or
     MetaModel.IsKindOf(Kind, 'UMLCollaborationInstanceSet') or
     MetaModel.IsKindOf(Kind, 'UMLStateMachine') or
     MetaModel.IsKindOf(Kind, 'UMLFeature') then
    Result := True
  else if MetaModel.IsKindOf(Kind, 'UMLElement') then
    Result := False
  else
    Result := inherited CanContainKind(Kind);
end;

// PUMLClassifier
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLUseCase

constructor PUMLUseCase.Create;
begin
  inherited;
  FExtenders := POrderedSet.Create;
  FExtends := POrderedSet.Create;
  FIncluders := POrderedSet.Create;
  FIncludes := POrderedSet.Create;
  FExtensionPoints := POrderedSet.Create;
end;

destructor PUMLUseCase.Destroy;
begin
  FExtenders.Free;
  FExtends.Free;
  FIncluders.Free;
  FIncludes.Free;
  FExtensionPoints.Free;
  inherited;
end;

function PUMLUseCase.GetExtender(Index: Integer): PUMLExtend;
begin
  Result := FExtenders.Items[Index] as UMLModels.PUMLExtend;
end;

function PUMLUseCase.GetExtenderCount: Integer;
begin
  Result := FExtenders.Count;
end;

function PUMLUseCase.GetExtend(Index: Integer): PUMLExtend;
begin
  Result := FExtends.Items[Index] as UMLModels.PUMLExtend;
end;

function PUMLUseCase.GetExtendCount: Integer;
begin
  Result := FExtends.Count;
end;

function PUMLUseCase.GetIncluder(Index: Integer): PUMLInclude;
begin
  Result := FIncluders.Items[Index] as UMLModels.PUMLInclude;
end;

function PUMLUseCase.GetIncluderCount: Integer;
begin
  Result := FIncluders.Count;
end;

function PUMLUseCase.GetInclude(Index: Integer): PUMLInclude;
begin
  Result := FIncludes.Items[Index] as UMLModels.PUMLInclude;
end;

function PUMLUseCase.GetIncludeCount: Integer;
begin
  Result := FIncludes.Count;
end;

function PUMLUseCase.GetExtensionPoint(Index: Integer): PUMLExtensionPoint;
begin
  Result := FExtensionPoints.Items[Index] as UMLModels.PUMLExtensionPoint;
end;

function PUMLUseCase.GetExtensionPointCount: Integer;
begin
  Result := FExtensionPoints.Count;
end;

procedure PUMLUseCase.ClearExtenders;
var
  I: Integer;
begin
  for I := FExtenders.Count - 1 downto 0 do
    DeleteExtender(I);
end;

procedure PUMLUseCase.AddExtender(Value: PUMLExtend);
begin
  if Value <> nil then begin
    if Value.FBase <> nil then Value.FBase.FExtenders.Remove(Value);
    FExtenders.Add(Value);
    Value.FBase := Self;
  end;
end;

procedure PUMLUseCase.RemoveExtender(Value: PUMLExtend);
begin
  if Value <> nil then begin
    FExtenders.Remove(Value);
    Value.FBase := nil;
  end;
end;

procedure PUMLUseCase.InsertExtender(Index: Integer; Value: PUMLExtend);
begin
  if Value <> nil then begin
    if Value.FBase <> nil then Value.FBase.FExtenders.Remove(Value);
    FExtenders.Insert(Index, Value);
    Value.FBase := Self;
  end;
end;

procedure PUMLUseCase.DeleteExtender(Index: Integer);
begin
  RemoveExtender(FExtenders.Items[Index] as UMLModels.PUMLExtend);
end;

function PUMLUseCase.IndexOfExtender(Value: PUMLExtend): Integer;
begin
  Result := FExtenders.IndexOf(Value);
end;

procedure PUMLUseCase.ClearExtends;
var
  I: Integer;
begin
  for I := FExtends.Count - 1 downto 0 do
    DeleteExtend(I);
end;

procedure PUMLUseCase.AddExtend(Value: PUMLExtend);
begin
  if Value <> nil then begin
    if Value.FExtension <> nil then Value.FExtension.FExtends.Remove(Value);
    FExtends.Add(Value);
    Value.FExtension := Self;
  end;
end;

procedure PUMLUseCase.RemoveExtend(Value: PUMLExtend);
begin
  if Value <> nil then begin
    FExtends.Remove(Value);
    Value.FExtension := nil;
  end;
end;

procedure PUMLUseCase.InsertExtend(Index: Integer; Value: PUMLExtend);
begin
  if Value <> nil then begin
    if Value.FExtension <> nil then Value.FExtension.FExtends.Remove(Value);
    FExtends.Insert(Index, Value);
    Value.FExtension := Self;
  end;
end;

procedure PUMLUseCase.DeleteExtend(Index: Integer);
begin
  RemoveExtend(FExtends.Items[Index] as UMLModels.PUMLExtend);
end;

function PUMLUseCase.IndexOfExtend(Value: PUMLExtend): Integer;
begin
  Result := FExtends.IndexOf(Value);
end;

procedure PUMLUseCase.ClearIncluders;
var
  I: Integer;
begin
  for I := FIncluders.Count - 1 downto 0 do
    DeleteIncluder(I);
end;

procedure PUMLUseCase.AddIncluder(Value: PUMLInclude);
begin
  if Value <> nil then begin
    if Value.FAddition <> nil then Value.FAddition.FIncluders.Remove(Value);
    FIncluders.Add(Value);
    Value.FAddition := Self;
  end;
end;

procedure PUMLUseCase.RemoveIncluder(Value: PUMLInclude);
begin
  if Value <> nil then begin
    FIncluders.Remove(Value);
    Value.FAddition := nil;
  end;
end;

procedure PUMLUseCase.InsertIncluder(Index: Integer; Value: PUMLInclude);
begin
  if Value <> nil then begin
    if Value.FAddition <> nil then Value.FAddition.FIncluders.Remove(Value);
    FIncluders.Insert(Index, Value);
    Value.FAddition := Self;
  end;
end;

procedure PUMLUseCase.DeleteIncluder(Index: Integer);
begin
  RemoveIncluder(FIncluders.Items[Index] as UMLModels.PUMLInclude);
end;

function PUMLUseCase.IndexOfIncluder(Value: PUMLInclude): Integer;
begin
  Result := FIncluders.IndexOf(Value);
end;

procedure PUMLUseCase.ClearIncludes;
var
  I: Integer;
begin
  for I := FIncludes.Count - 1 downto 0 do
    DeleteInclude(I);
end;

procedure PUMLUseCase.AddInclude(Value: PUMLInclude);
begin
  if Value <> nil then begin
    if Value.FBase <> nil then Value.FBase.FIncludes.Remove(Value);
    FIncludes.Add(Value);
    Value.FBase := Self;
  end;
end;

procedure PUMLUseCase.RemoveInclude(Value: PUMLInclude);
begin
  if Value <> nil then begin
    FIncludes.Remove(Value);
    Value.FBase := nil;
  end;
end;

procedure PUMLUseCase.InsertInclude(Index: Integer; Value: PUMLInclude);
begin
  if Value <> nil then begin
    if Value.FBase <> nil then Value.FBase.FIncludes.Remove(Value);
    FIncludes.Insert(Index, Value);
    Value.FBase := Self;
  end;
end;

procedure PUMLUseCase.DeleteInclude(Index: Integer);
begin
  RemoveInclude(FIncludes.Items[Index] as UMLModels.PUMLInclude);
end;

function PUMLUseCase.IndexOfInclude(Value: PUMLInclude): Integer;
begin
  Result := FIncludes.IndexOf(Value);
end;

procedure PUMLUseCase.ClearExtensionPoints;
var
  I: Integer;
begin
  for I := FExtensionPoints.Count - 1 downto 0 do
    DeleteExtensionPoint(I);
end;

procedure PUMLUseCase.AddExtensionPoint(Value: PUMLExtensionPoint);
begin
  if Value <> nil then begin
    if Value.FUseCase <> nil then begin
      Value.FUseCase.FExtensionPoints.Remove(Value);
      Value.FUseCase.RemoveVirtualOwnedModel(Value);
    end;
    FExtensionPoints.Add(Value);
    Value.FUseCase := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLUseCase.RemoveExtensionPoint(Value: PUMLExtensionPoint);
begin
  if Value <> nil then begin
    FExtensionPoints.Remove(Value);
    Value.FUseCase := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLUseCase.InsertExtensionPoint(Index: Integer; Value: PUMLExtensionPoint);
begin
  if Value <> nil then begin
    if Value.FUseCase <> nil then begin
      Value.FUseCase.FExtensionPoints.Remove(Value);
      Value.FUseCase.RemoveVirtualOwnedModel(Value);
    end;
    FExtensionPoints.Insert(Index, Value);
    Value.FUseCase := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLUseCase.DeleteExtensionPoint(Index: Integer);
begin
  RemoveExtensionPoint(FExtensionPoints.Items[Index] as UMLModels.PUMLExtensionPoint);
end;

function PUMLUseCase.IndexOfExtensionPoint(Value: PUMLExtensionPoint): Integer;
begin
  Result := FExtensionPoints.IndexOf(Value);
end;

function PUMLUseCase.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLUseCase.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLUseCase.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLUseCase.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLUseCase.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Extenders' then begin
    AddExtender(Value as PUMLExtend);
  end
  else if Name = 'Extends' then begin
    AddExtend(Value as PUMLExtend);
  end
  else if Name = 'Includers' then begin
    AddIncluder(Value as PUMLInclude);
  end
  else if Name = 'Includes' then begin
    AddInclude(Value as PUMLInclude);
  end
  else if Name = 'ExtensionPoints' then begin
    AddExtensionPoint(Value as PUMLExtensionPoint);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLUseCase.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Extenders' then begin
    RemoveExtender(Value as PUMLExtend);
  end
  else if Name = 'Extends' then begin
    RemoveExtend(Value as PUMLExtend);
  end
  else if Name = 'Includers' then begin
    RemoveIncluder(Value as PUMLInclude);
  end
  else if Name = 'Includes' then begin
    RemoveInclude(Value as PUMLInclude);
  end
  else if Name = 'ExtensionPoints' then begin
    RemoveExtensionPoint(Value as PUMLExtensionPoint);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLUseCase.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Extenders' then begin
    InsertExtender(Index, Value as PUMLExtend);
  end
  else if Name = 'Extends' then begin
    InsertExtend(Index, Value as PUMLExtend);
  end
  else if Name = 'Includers' then begin
    InsertIncluder(Index, Value as PUMLInclude);
  end
  else if Name = 'Includes' then begin
    InsertInclude(Index, Value as PUMLInclude);
  end
  else if Name = 'ExtensionPoints' then begin
    InsertExtensionPoint(Index, Value as PUMLExtensionPoint);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLUseCase.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Extenders' then begin
    DeleteExtender(Index);
  end
  else if Name = 'Extends' then begin
    DeleteExtend(Index);
  end
  else if Name = 'Includers' then begin
    DeleteIncluder(Index);
  end
  else if Name = 'Includes' then begin
    DeleteInclude(Index);
  end
  else if Name = 'ExtensionPoints' then begin
    DeleteExtensionPoint(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLUseCase.MOF_ClearCollection(Name: string);
begin
  if Name = 'Extenders' then begin
    ClearExtenders;
  end
  else if Name = 'Extends' then begin
    ClearExtends;
  end
  else if Name = 'Includers' then begin
    ClearIncluders;
  end
  else if Name = 'Includes' then begin
    ClearIncludes;
  end
  else if Name = 'ExtensionPoints' then begin
    ClearExtensionPoints;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLUseCase.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Extenders' then begin
    Result := IndexOfExtender(Value as PUMLExtend);
  end
  else if Name = 'Extends' then begin
    Result := IndexOfExtend(Value as PUMLExtend);
  end
  else if Name = 'Includers' then begin
    Result := IndexOfIncluder(Value as PUMLInclude);
  end
  else if Name = 'Includes' then begin
    Result := IndexOfInclude(Value as PUMLInclude);
  end
  else if Name = 'ExtensionPoints' then begin
    Result := IndexOfExtensionPoint(Value as PUMLExtensionPoint);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLUseCase.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Extenders' then begin
    Result := Extenders[Index];
  end
  else if Name = 'Extends' then begin
    Result := Extends[Index];
  end
  else if Name = 'Includers' then begin
    Result := Includers[Index];
  end
  else if Name = 'Includes' then begin
    Result := Includes[Index];
  end
  else if Name = 'ExtensionPoints' then begin
    Result := ExtensionPoints[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLUseCase.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Extenders' then begin
    Result := ExtenderCount;
  end
  else if Name = 'Extends' then begin
    Result := ExtendCount;
  end
  else if Name = 'Includers' then begin
    Result := IncluderCount;
  end
  else if Name = 'Includes' then begin
    Result := IncludeCount;
  end
  else if Name = 'ExtensionPoints' then begin
    Result := ExtensionPointCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLUseCase
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLActor

constructor PUMLActor.Create;
begin
  inherited;
end;

destructor PUMLActor.Destroy;
begin
  inherited;
end;

function PUMLActor.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLActor.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLActor.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLActor.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLActor.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLActor.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLActor.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLActor.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLActor.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLActor.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLActor.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLActor.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLActor
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLClassifierInState

constructor PUMLClassifierInState.Create;
begin
  inherited;
  FType_ := nil;
  FInStates := POrderedSet.Create;
end;

destructor PUMLClassifierInState.Destroy;
begin
  FInStates.Free;
  inherited;
end;

procedure PUMLClassifierInState.SetType_(Value: PUMLClassifier);
begin
  if FType_ <> Value then begin
    if FType_ <> nil then Type_.FClassifierInStates.Remove(Self);
    FType_ := Value;
    if Value <> nil then begin
      Value.FClassifierInStates.Add(Self);
    end;
  end;
end;

function PUMLClassifierInState.GetInState(Index: Integer): PUMLState;
begin
  Result := FInStates.Items[Index] as UMLModels.PUMLState;
end;

function PUMLClassifierInState.GetInStateCount: Integer;
begin
  Result := FInStates.Count;
end;

procedure PUMLClassifierInState.ClearInStates;
var
  I: Integer;
begin
  for I := FInStates.Count - 1 downto 0 do
    DeleteInState(I);
end;

procedure PUMLClassifierInState.AddInState(Value: PUMLState);
begin
  if Value <> nil then begin
    FInStates.Add(Value);
    Value.FClassifierStates.Add(Self);
  end;
end;

procedure PUMLClassifierInState.RemoveInState(Value: PUMLState);
begin
  if Value <> nil then begin
    FInStates.Remove(Value);
    Value.FClassifierStates.Remove(Self);
  end;
end;

procedure PUMLClassifierInState.InsertInState(Index: Integer; Value: PUMLState);
begin
  if Value <> nil then begin
    FInStates.Insert(Index, Value);
    Value.FClassifierStates.Add(Self);
  end;
end;

procedure PUMLClassifierInState.DeleteInState(Index: Integer);
begin
  RemoveInState(FInStates.Items[Index] as UMLModels.PUMLState);
end;

function PUMLClassifierInState.IndexOfInState(Value: PUMLState): Integer;
begin
  Result := FInStates.IndexOf(Value);
end;

function PUMLClassifierInState.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLClassifierInState.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLClassifierInState.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Type_' then begin
    Result := Type_;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLClassifierInState.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Type_' then begin
    Type_ := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLClassifierInState.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'InStates' then begin
    AddInState(Value as PUMLState);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLClassifierInState.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'InStates' then begin
    RemoveInState(Value as PUMLState);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLClassifierInState.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'InStates' then begin
    InsertInState(Index, Value as PUMLState);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLClassifierInState.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'InStates' then begin
    DeleteInState(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLClassifierInState.MOF_ClearCollection(Name: string);
begin
  if Name = 'InStates' then begin
    ClearInStates;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLClassifierInState.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'InStates' then begin
    Result := IndexOfInState(Value as PUMLState);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLClassifierInState.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'InStates' then begin
    Result := InStates[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLClassifierInState.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'InStates' then begin
    Result := InStateCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLClassifierInState
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLInterface

constructor PUMLInterface.Create;
begin
  inherited;
end;

destructor PUMLInterface.Destroy;
begin
  inherited;
end;

function PUMLInterface.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLInterface.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLInterface.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLInterface.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLInterface.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLInterface.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLInterface.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLInterface.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLInterface.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLInterface.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLInterface.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLInterface.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLInterface
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLPackage

constructor PUMLPackage.Create;
begin
  inherited;
  FElementImportItems := POrderedSet.Create;
end;

destructor PUMLPackage.Destroy;
begin
  FElementImportItems.Free;
  inherited;
end;

function PUMLPackage.GetElementImportItem(Index: Integer): PUMLElementImport;
begin
  Result := FElementImportItems.Items[Index] as UMLModels.PUMLElementImport;
end;

function PUMLPackage.GetElementImportItemCount: Integer;
begin
  Result := FElementImportItems.Count;
end;

procedure PUMLPackage.ClearElementImportItems;
var
  I: Integer;
begin
  for I := FElementImportItems.Count - 1 downto 0 do
    DeleteElementImportItem(I);
end;

procedure PUMLPackage.AddElementImportItem(Value: PUMLElementImport);
begin
  if Value <> nil then begin
    if Value.FPackage <> nil then begin
      Value.FPackage.FElementImportItems.Remove(Value);
      Value.FPackage.RemoveVirtualOwnedModel(Value);
    end;
    FElementImportItems.Add(Value);
    Value.FPackage := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLPackage.RemoveElementImportItem(Value: PUMLElementImport);
begin
  if Value <> nil then begin
    FElementImportItems.Remove(Value);
    Value.FPackage := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLPackage.InsertElementImportItem(Index: Integer; Value: PUMLElementImport);
begin
  if Value <> nil then begin
    if Value.FPackage <> nil then begin
      Value.FPackage.FElementImportItems.Remove(Value);
      Value.FPackage.RemoveVirtualOwnedModel(Value);
    end;
    FElementImportItems.Insert(Index, Value);
    Value.FPackage := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLPackage.DeleteElementImportItem(Index: Integer);
begin
  RemoveElementImportItem(FElementImportItems.Items[Index] as UMLModels.PUMLElementImport);
end;

function PUMLPackage.IndexOfElementImportItem(Value: PUMLElementImport): Integer;
begin
  Result := FElementImportItems.IndexOf(Value);
end;

function PUMLPackage.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLPackage.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLPackage.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLPackage.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLPackage.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ElementImportItems' then begin
    AddElementImportItem(Value as PUMLElementImport);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLPackage.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ElementImportItems' then begin
    RemoveElementImportItem(Value as PUMLElementImport);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLPackage.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'ElementImportItems' then begin
    InsertElementImportItem(Index, Value as PUMLElementImport);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLPackage.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'ElementImportItems' then begin
    DeleteElementImportItem(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLPackage.MOF_ClearCollection(Name: string);
begin
  if Name = 'ElementImportItems' then begin
    ClearElementImportItems;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLPackage.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'ElementImportItems' then begin
    Result := IndexOfElementImportItem(Value as PUMLElementImport);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLPackage.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'ElementImportItems' then begin
    Result := ElementImportItems[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLPackage.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'ElementImportItems' then begin
    Result := ElementImportItemCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLPackage.CanContainDiagramKind(Kind: string): Boolean;
begin
  Result := (Kind = 'UMLClassDiagram') or
    (Kind = 'UMLUseCaseDiagram') or
    (Kind = 'UMLComponentDiagram') or
    (Kind = 'UMLDeploymentDiagram');
end;

function PUMLPackage.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLPackage') or
     MetaModel.IsKindOf(Kind, 'UMLClassifier') or
     MetaModel.IsKindOf(Kind, 'UMLRelationship') or
     MetaModel.IsKindOf(Kind, 'UMLAssociationClass') or
     MetaModel.IsKindOf(Kind, 'UMLInstance') or
     MetaModel.IsKindOf(Kind, 'UMLLink') then
    Result := True
  else if MetaModel.IsKindOf(Kind, 'UMLFeature') then
    Result := False
  else
    Result := inherited CanContainKind(Kind);
end;

function PUMLPackage.CanPaste(Kind: string; CopyContext: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLClassDiagram') or
     MetaModel.IsKindOf(Kind, 'UMLUseCaseDiagram') or
     MetaModel.IsKindOf(Kind, 'UMLComponentDiagram') or
     MetaModel.IsKindOf(Kind, 'UMLDeploymentDiagram') then
    Result := True
  else if MetaModel.IsKindOf(Kind, 'UMLDiagram') then
    Result := False
  else
    Result := inherited CanPaste(Kind, CopyContext);
end;

// PUMLPackage
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSubsystem

constructor PUMLSubsystem.Create;
begin
  inherited;
end;

destructor PUMLSubsystem.Destroy;
begin
  inherited;
end;

procedure PUMLSubsystem.SetIsInstantiable(Value: Boolean);
begin
  if FIsInstantiable <> Value then
    FIsInstantiable := Value;
end;

function PUMLSubsystem.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'IsInstantiable' then begin
    Result := BooleanToString(IsInstantiable);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLSubsystem.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'IsInstantiable' then begin
    IsInstantiable := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLSubsystem.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLSubsystem.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLSubsystem.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLSubsystem.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLSubsystem.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLSubsystem.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLSubsystem.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLSubsystem.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLSubsystem.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLSubsystem.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

function PUMLSubsystem.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLOperation') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;

// PUMLSubsystem
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLProject

constructor PUMLProject.Create;
begin
  inherited;
end;

destructor PUMLProject.Destroy;
begin
  inherited;
end;

procedure PUMLProject.SetTitle(Value: string);
begin
  if FTitle <> Value then
    FTitle := Value;
end;

procedure PUMLProject.SetAuthor(Value: string);
begin
  if FAuthor <> Value then
    FAuthor := Value;
end;

procedure PUMLProject.SetCompany(Value: string);
begin
  if FCompany <> Value then
    FCompany := Value;
end;

procedure PUMLProject.SetCopyright(Value: string);
begin
  if FCopyright <> Value then
    FCopyright := Value;
end;

function PUMLProject.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Title' then begin
    Result := Title;
  end
  else if Name = 'Author' then begin
    Result := Author;
  end
  else if Name = 'Company' then begin
    Result := Company;
  end
  else if Name = 'Copyright' then begin
    Result := Copyright;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLProject.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Title' then begin
    Title := Value;
  end
  else if Name = 'Author' then begin
    Author := Value;
  end
  else if Name = 'Company' then begin
    Company := Value;
  end
  else if Name = 'Copyright' then begin
    Copyright := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLProject.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLProject.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLProject.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLProject.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLProject.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLProject.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLProject.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLProject.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLProject.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLProject.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

function PUMLProject.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLPackage') then
    Result := True
  else
    Result := False;
end;

function PUMLProject.CanRelocateTo(Model: PModel): Boolean;
begin
  Result := False;
end;

function PUMLProject.CanCopy: Boolean;
begin
  Result := False;
end;

function PUMLProject.CanDelete: Boolean;
begin
  Result := False;
end;

// PUMLProject
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLModel

constructor PUMLModel.Create;
begin
  inherited;
end;

destructor PUMLModel.Destroy;
begin
  inherited;
end;

function PUMLModel.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLModel.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLModel.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLModel.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLModel.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLModel.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLModel.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLModel.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLModel.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLModel.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLModel.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLModel.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLModel
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLDataType

constructor PUMLDataType.Create;
begin
  inherited;
end;

destructor PUMLDataType.Destroy;
begin
  inherited;
end;

function PUMLDataType.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLDataType.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLDataType.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLDataType.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLDataType.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLDataType.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLDataType.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLDataType.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLDataType.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLDataType.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLDataType.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLDataType.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLDataType
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLProgrammingLanguageDataType

constructor PUMLProgrammingLanguageDataType.Create;
begin
  inherited;
end;

destructor PUMLProgrammingLanguageDataType.Destroy;
begin
  inherited;
end;

procedure PUMLProgrammingLanguageDataType.SetExpression(Value: string);
begin
  if FExpression <> Value then
    FExpression := Value;
end;

function PUMLProgrammingLanguageDataType.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Expression' then begin
    Result := Expression;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLProgrammingLanguageDataType.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Expression' then begin
    Expression := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLProgrammingLanguageDataType.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLProgrammingLanguageDataType.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLProgrammingLanguageDataType.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLProgrammingLanguageDataType.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLProgrammingLanguageDataType.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLProgrammingLanguageDataType.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLProgrammingLanguageDataType.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLProgrammingLanguageDataType.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLProgrammingLanguageDataType.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLProgrammingLanguageDataType.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLProgrammingLanguageDataType
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLPrimitive

constructor PUMLPrimitive.Create;
begin
  inherited;
end;

destructor PUMLPrimitive.Destroy;
begin
  inherited;
end;

function PUMLPrimitive.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLPrimitive.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLPrimitive.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLPrimitive.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLPrimitive.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLPrimitive.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLPrimitive.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLPrimitive.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLPrimitive.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLPrimitive.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLPrimitive.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLPrimitive.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLPrimitive
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLEnumeration

constructor PUMLEnumeration.Create;
begin
  inherited;
  FLiterals := POrderedSet.Create;
end;

destructor PUMLEnumeration.Destroy;
begin
  FLiterals.Free;
  inherited;
end;

function PUMLEnumeration.GetLiteral(Index: Integer): PUMLEnumerationLiteral;
begin
  Result := FLiterals.Items[Index] as UMLModels.PUMLEnumerationLiteral;
end;

function PUMLEnumeration.GetLiteralCount: Integer;
begin
  Result := FLiterals.Count;
end;

procedure PUMLEnumeration.ClearLiterals;
var
  I: Integer;
begin
  for I := FLiterals.Count - 1 downto 0 do
    DeleteLiteral(I);
end;

procedure PUMLEnumeration.AddLiteral(Value: PUMLEnumerationLiteral);
begin
  if Value <> nil then begin
    if Value.FEnumeration <> nil then begin
      Value.FEnumeration.FLiterals.Remove(Value);
      Value.FEnumeration.RemoveVirtualOwnedModel(Value);
    end;
    FLiterals.Add(Value);
    Value.FEnumeration := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLEnumeration.RemoveLiteral(Value: PUMLEnumerationLiteral);
begin
  if Value <> nil then begin
    FLiterals.Remove(Value);
    Value.FEnumeration := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLEnumeration.InsertLiteral(Index: Integer; Value: PUMLEnumerationLiteral);
begin
  if Value <> nil then begin
    if Value.FEnumeration <> nil then begin
      Value.FEnumeration.FLiterals.Remove(Value);
      Value.FEnumeration.RemoveVirtualOwnedModel(Value);
    end;
    FLiterals.Insert(Index, Value);
    Value.FEnumeration := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLEnumeration.DeleteLiteral(Index: Integer);
begin
  RemoveLiteral(FLiterals.Items[Index] as UMLModels.PUMLEnumerationLiteral);
end;

function PUMLEnumeration.IndexOfLiteral(Value: PUMLEnumerationLiteral): Integer;
begin
  Result := FLiterals.IndexOf(Value);
end;

function PUMLEnumeration.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLEnumeration.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLEnumeration.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLEnumeration.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLEnumeration.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Literals' then begin
    AddLiteral(Value as PUMLEnumerationLiteral);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLEnumeration.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Literals' then begin
    RemoveLiteral(Value as PUMLEnumerationLiteral);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLEnumeration.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Literals' then begin
    InsertLiteral(Index, Value as PUMLEnumerationLiteral);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLEnumeration.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Literals' then begin
    DeleteLiteral(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLEnumeration.MOF_ClearCollection(Name: string);
begin
  if Name = 'Literals' then begin
    ClearLiterals;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLEnumeration.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Literals' then begin
    Result := IndexOfLiteral(Value as PUMLEnumerationLiteral);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLEnumeration.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Literals' then begin
    Result := Literals[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLEnumeration.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Literals' then begin
    Result := LiteralCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLEnumeration.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLAttribute') then
    Result := False
  else if MetaModel.IsKindOf(Kind, 'UMLEnumerationLiteral') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;

// PUMLEnumeration
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLClass

constructor PUMLClass.Create;
begin
  inherited;
  FAssociationClass := nil;
end;

destructor PUMLClass.Destroy;
begin
  inherited;
end;

procedure PUMLClass.SetIsActive(Value: Boolean);
begin
  if FIsActive <> Value then
    FIsActive := Value;
end;

procedure PUMLClass.SetAssociationClass(Value: PUMLAssociationClass);
begin
  if FAssociationClass <> Value then begin
    if FAssociationClass <> nil then AssociationClass.FClassSide := nil;
    FAssociationClass := Value;
    if Value <> nil then Value.FClassSide := Self;
  end;
end;

function PUMLClass.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'IsActive' then begin
    Result := BooleanToString(IsActive);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLClass.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'IsActive' then begin
    IsActive := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLClass.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'AssociationClass' then begin
    Result := AssociationClass;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLClass.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'AssociationClass' then begin
    AssociationClass := Value as PUMLAssociationClass;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLClass.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLClass.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLClass.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLClass.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLClass.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLClass.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLClass.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLClass.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

function PUMLClass.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLClass') or
     MetaModel.IsKindOf(Kind, 'UMLInterface') or
     MetaModel.IsKindOf(Kind, 'UMLEnumeration') or
     MetaModel.IsKindOf(Kind, 'UMLSignal') or
     MetaModel.IsKindOf(Kind, 'UMLTemplateParameter') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;

// PUMLClass
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLNode

constructor PUMLNode.Create;
begin
  inherited;
  FDeployedComponents := POrderedSet.Create;
  FDeployedArtifacts := POrderedSet.Create;
end;

destructor PUMLNode.Destroy;
begin
  FDeployedComponents.Free;
  FDeployedArtifacts.Free;
  inherited;
end;

function PUMLNode.GetDeployedComponent(Index: Integer): PUMLComponent;
begin
  Result := FDeployedComponents.Items[Index] as UMLModels.PUMLComponent;
end;

function PUMLNode.GetDeployedComponentCount: Integer;
begin
  Result := FDeployedComponents.Count;
end;

function PUMLNode.GetDeployedArtifact(Index: Integer): PUMLArtifact;
begin
  Result := FDeployedArtifacts.Items[Index] as UMLModels.PUMLArtifact;
end;

function PUMLNode.GetDeployedArtifactCount: Integer;
begin
  Result := FDeployedArtifacts.Count;
end;

procedure PUMLNode.ClearDeployedComponents;
var
  I: Integer;
begin
  for I := FDeployedComponents.Count - 1 downto 0 do
    DeleteDeployedComponent(I);
end;

procedure PUMLNode.AddDeployedComponent(Value: PUMLComponent);
begin
  if Value <> nil then begin
    FDeployedComponents.Add(Value);
    Value.FDeploymentLocations.Add(Self);
  end;
end;

procedure PUMLNode.RemoveDeployedComponent(Value: PUMLComponent);
begin
  if Value <> nil then begin
    FDeployedComponents.Remove(Value);
    Value.FDeploymentLocations.Remove(Self);
  end;
end;

procedure PUMLNode.InsertDeployedComponent(Index: Integer; Value: PUMLComponent);
begin
  if Value <> nil then begin
    FDeployedComponents.Insert(Index, Value);
    Value.FDeploymentLocations.Add(Self);
  end;
end;

procedure PUMLNode.DeleteDeployedComponent(Index: Integer);
begin
  RemoveDeployedComponent(FDeployedComponents.Items[Index] as UMLModels.PUMLComponent);
end;

function PUMLNode.IndexOfDeployedComponent(Value: PUMLComponent): Integer;
begin
  Result := FDeployedComponents.IndexOf(Value);
end;

procedure PUMLNode.ClearDeployedArtifacts;
var
  I: Integer;
begin
  for I := FDeployedArtifacts.Count - 1 downto 0 do
    DeleteDeployedArtifact(I);
end;

procedure PUMLNode.AddDeployedArtifact(Value: PUMLArtifact);
begin
  if Value <> nil then begin
    FDeployedArtifacts.Add(Value);
    Value.FDeploymentLocations.Add(Self);
  end;
end;

procedure PUMLNode.RemoveDeployedArtifact(Value: PUMLArtifact);
begin
  if Value <> nil then begin
    FDeployedArtifacts.Remove(Value);
    Value.FDeploymentLocations.Remove(Self);
  end;
end;

procedure PUMLNode.InsertDeployedArtifact(Index: Integer; Value: PUMLArtifact);
begin
  if Value <> nil then begin
    FDeployedArtifacts.Insert(Index, Value);
    Value.FDeploymentLocations.Add(Self);
  end;
end;

procedure PUMLNode.DeleteDeployedArtifact(Index: Integer);
begin
  RemoveDeployedArtifact(FDeployedArtifacts.Items[Index] as UMLModels.PUMLArtifact);
end;

function PUMLNode.IndexOfDeployedArtifact(Value: PUMLArtifact): Integer;
begin
  Result := FDeployedArtifacts.IndexOf(Value);
end;

function PUMLNode.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLNode.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLNode.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLNode.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLNode.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'DeployedComponents' then begin
    AddDeployedComponent(Value as PUMLComponent);
  end
  else if Name = 'DeployedArtifacts' then begin
    AddDeployedArtifact(Value as PUMLArtifact);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLNode.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'DeployedComponents' then begin
    RemoveDeployedComponent(Value as PUMLComponent);
  end
  else if Name = 'DeployedArtifacts' then begin
    RemoveDeployedArtifact(Value as PUMLArtifact);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLNode.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'DeployedComponents' then begin
    InsertDeployedComponent(Index, Value as PUMLComponent);
  end
  else if Name = 'DeployedArtifacts' then begin
    InsertDeployedArtifact(Index, Value as PUMLArtifact);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLNode.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'DeployedComponents' then begin
    DeleteDeployedComponent(Index);
  end
  else if Name = 'DeployedArtifacts' then begin
    DeleteDeployedArtifact(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLNode.MOF_ClearCollection(Name: string);
begin
  if Name = 'DeployedComponents' then begin
    ClearDeployedComponents;
  end
  else if Name = 'DeployedArtifacts' then begin
    ClearDeployedArtifacts;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLNode.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'DeployedComponents' then begin
    Result := IndexOfDeployedComponent(Value as PUMLComponent);
  end
  else if Name = 'DeployedArtifacts' then begin
    Result := IndexOfDeployedArtifact(Value as PUMLArtifact);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLNode.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'DeployedComponents' then begin
    Result := DeployedComponents[Index];
  end
  else if Name = 'DeployedArtifacts' then begin
    Result := DeployedArtifacts[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLNode.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'DeployedComponents' then begin
    Result := DeployedComponentCount;
  end
  else if Name = 'DeployedArtifacts' then begin
    Result := DeployedArtifactCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLNode.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLOperation') then
    Result := False
  else
    Result := inherited CanContainKind(Kind);
end;

// PUMLNode
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLArtifact

constructor PUMLArtifact.Create;
begin
  inherited;
  FImplementationLocations := POrderedSet.Create;
  FDeploymentLocations := POrderedSet.Create;
end;

destructor PUMLArtifact.Destroy;
begin
  FImplementationLocations.Free;
  FDeploymentLocations.Free;
  inherited;
end;

function PUMLArtifact.GetImplementationLocation(Index: Integer): PUMLComponent;
begin
  Result := FImplementationLocations.Items[Index] as UMLModels.PUMLComponent;
end;

function PUMLArtifact.GetImplementationLocationCount: Integer;
begin
  Result := FImplementationLocations.Count;
end;

function PUMLArtifact.GetDeploymentLocation(Index: Integer): PUMLNode;
begin
  Result := FDeploymentLocations.Items[Index] as UMLModels.PUMLNode;
end;

function PUMLArtifact.GetDeploymentLocationCount: Integer;
begin
  Result := FDeploymentLocations.Count;
end;

procedure PUMLArtifact.ClearImplementationLocations;
var
  I: Integer;
begin
  for I := FImplementationLocations.Count - 1 downto 0 do
    DeleteImplementationLocation(I);
end;

procedure PUMLArtifact.AddImplementationLocation(Value: PUMLComponent);
begin
  if Value <> nil then begin
    FImplementationLocations.Add(Value);
    Value.FImplementations.Add(Self);
  end;
end;

procedure PUMLArtifact.RemoveImplementationLocation(Value: PUMLComponent);
begin
  if Value <> nil then begin
    FImplementationLocations.Remove(Value);
    Value.FImplementations.Remove(Self);
  end;
end;

procedure PUMLArtifact.InsertImplementationLocation(Index: Integer; Value: PUMLComponent);
begin
  if Value <> nil then begin
    FImplementationLocations.Insert(Index, Value);
    Value.FImplementations.Add(Self);
  end;
end;

procedure PUMLArtifact.DeleteImplementationLocation(Index: Integer);
begin
  RemoveImplementationLocation(FImplementationLocations.Items[Index] as UMLModels.PUMLComponent);
end;

function PUMLArtifact.IndexOfImplementationLocation(Value: PUMLComponent): Integer;
begin
  Result := FImplementationLocations.IndexOf(Value);
end;

procedure PUMLArtifact.ClearDeploymentLocations;
var
  I: Integer;
begin
  for I := FDeploymentLocations.Count - 1 downto 0 do
    DeleteDeploymentLocation(I);
end;

procedure PUMLArtifact.AddDeploymentLocation(Value: PUMLNode);
begin
  if Value <> nil then begin
    FDeploymentLocations.Add(Value);
    Value.FDeployedArtifacts.Add(Self);
  end;
end;

procedure PUMLArtifact.RemoveDeploymentLocation(Value: PUMLNode);
begin
  if Value <> nil then begin
    FDeploymentLocations.Remove(Value);
    Value.FDeployedArtifacts.Remove(Self);
  end;
end;

procedure PUMLArtifact.InsertDeploymentLocation(Index: Integer; Value: PUMLNode);
begin
  if Value <> nil then begin
    FDeploymentLocations.Insert(Index, Value);
    Value.FDeployedArtifacts.Add(Self);
  end;
end;

procedure PUMLArtifact.DeleteDeploymentLocation(Index: Integer);
begin
  RemoveDeploymentLocation(FDeploymentLocations.Items[Index] as UMLModels.PUMLNode);
end;

function PUMLArtifact.IndexOfDeploymentLocation(Value: PUMLNode): Integer;
begin
  Result := FDeploymentLocations.IndexOf(Value);
end;

function PUMLArtifact.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLArtifact.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLArtifact.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLArtifact.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLArtifact.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ImplementationLocations' then begin
    AddImplementationLocation(Value as PUMLComponent);
  end
  else if Name = 'DeploymentLocations' then begin
    AddDeploymentLocation(Value as PUMLNode);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLArtifact.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ImplementationLocations' then begin
    RemoveImplementationLocation(Value as PUMLComponent);
  end
  else if Name = 'DeploymentLocations' then begin
    RemoveDeploymentLocation(Value as PUMLNode);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLArtifact.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'ImplementationLocations' then begin
    InsertImplementationLocation(Index, Value as PUMLComponent);
  end
  else if Name = 'DeploymentLocations' then begin
    InsertDeploymentLocation(Index, Value as PUMLNode);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLArtifact.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'ImplementationLocations' then begin
    DeleteImplementationLocation(Index);
  end
  else if Name = 'DeploymentLocations' then begin
    DeleteDeploymentLocation(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLArtifact.MOF_ClearCollection(Name: string);
begin
  if Name = 'ImplementationLocations' then begin
    ClearImplementationLocations;
  end
  else if Name = 'DeploymentLocations' then begin
    ClearDeploymentLocations;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLArtifact.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'ImplementationLocations' then begin
    Result := IndexOfImplementationLocation(Value as PUMLComponent);
  end
  else if Name = 'DeploymentLocations' then begin
    Result := IndexOfDeploymentLocation(Value as PUMLNode);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLArtifact.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'ImplementationLocations' then begin
    Result := ImplementationLocations[Index];
  end
  else if Name = 'DeploymentLocations' then begin
    Result := DeploymentLocations[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLArtifact.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'ImplementationLocations' then begin
    Result := ImplementationLocationCount;
  end
  else if Name = 'DeploymentLocations' then begin
    Result := DeploymentLocationCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLArtifact
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLComponent

constructor PUMLComponent.Create;
begin
  inherited;
  FDeploymentLocations := POrderedSet.Create;
  FResidents := POrderedSet.Create;
  FImplementations := POrderedSet.Create;
end;

destructor PUMLComponent.Destroy;
begin
  FDeploymentLocations.Free;
  FResidents.Free;
  FImplementations.Free;
  inherited;
end;

function PUMLComponent.GetDeploymentLocation(Index: Integer): PUMLNode;
begin
  Result := FDeploymentLocations.Items[Index] as UMLModels.PUMLNode;
end;

function PUMLComponent.GetDeploymentLocationCount: Integer;
begin
  Result := FDeploymentLocations.Count;
end;

function PUMLComponent.GetResident(Index: Integer): PUMLModelElement;
begin
  Result := FResidents.Items[Index] as UMLModels.PUMLModelElement;
end;

function PUMLComponent.GetResidentCount: Integer;
begin
  Result := FResidents.Count;
end;

function PUMLComponent.GetImplementation(Index: Integer): PUMLArtifact;
begin
  Result := FImplementations.Items[Index] as UMLModels.PUMLArtifact;
end;

function PUMLComponent.GetImplementationCount: Integer;
begin
  Result := FImplementations.Count;
end;

procedure PUMLComponent.ClearDeploymentLocations;
var
  I: Integer;
begin
  for I := FDeploymentLocations.Count - 1 downto 0 do
    DeleteDeploymentLocation(I);
end;

procedure PUMLComponent.AddDeploymentLocation(Value: PUMLNode);
begin
  if Value <> nil then begin
    FDeploymentLocations.Add(Value);
    Value.FDeployedComponents.Add(Self);
  end;
end;

procedure PUMLComponent.RemoveDeploymentLocation(Value: PUMLNode);
begin
  if Value <> nil then begin
    FDeploymentLocations.Remove(Value);
    Value.FDeployedComponents.Remove(Self);
  end;
end;

procedure PUMLComponent.InsertDeploymentLocation(Index: Integer; Value: PUMLNode);
begin
  if Value <> nil then begin
    FDeploymentLocations.Insert(Index, Value);
    Value.FDeployedComponents.Add(Self);
  end;
end;

procedure PUMLComponent.DeleteDeploymentLocation(Index: Integer);
begin
  RemoveDeploymentLocation(FDeploymentLocations.Items[Index] as UMLModels.PUMLNode);
end;

function PUMLComponent.IndexOfDeploymentLocation(Value: PUMLNode): Integer;
begin
  Result := FDeploymentLocations.IndexOf(Value);
end;

procedure PUMLComponent.ClearResidents;
var
  I: Integer;
begin
  for I := FResidents.Count - 1 downto 0 do
    DeleteResident(I);
end;

procedure PUMLComponent.AddResident(Value: PUMLModelElement);
begin
  if Value <> nil then begin
    if Value.FContainer <> nil then Value.FContainer.FResidents.Remove(Value);
    FResidents.Add(Value);
    Value.FContainer := Self;
  end;
end;

procedure PUMLComponent.RemoveResident(Value: PUMLModelElement);
begin
  if Value <> nil then begin
    FResidents.Remove(Value);
    Value.FContainer := nil;
  end;
end;

procedure PUMLComponent.InsertResident(Index: Integer; Value: PUMLModelElement);
begin
  if Value <> nil then begin
    if Value.FContainer <> nil then Value.FContainer.FResidents.Remove(Value);
    FResidents.Insert(Index, Value);
    Value.FContainer := Self;
  end;
end;

procedure PUMLComponent.DeleteResident(Index: Integer);
begin
  RemoveResident(FResidents.Items[Index] as UMLModels.PUMLModelElement);
end;

function PUMLComponent.IndexOfResident(Value: PUMLModelElement): Integer;
begin
  Result := FResidents.IndexOf(Value);
end;

procedure PUMLComponent.ClearImplementations;
var
  I: Integer;
begin
  for I := FImplementations.Count - 1 downto 0 do
    DeleteImplementation(I);
end;

procedure PUMLComponent.AddImplementation(Value: PUMLArtifact);
begin
  if Value <> nil then begin
    FImplementations.Add(Value);
    Value.FImplementationLocations.Add(Self);
  end;
end;

procedure PUMLComponent.RemoveImplementation(Value: PUMLArtifact);
begin
  if Value <> nil then begin
    FImplementations.Remove(Value);
    Value.FImplementationLocations.Remove(Self);
  end;
end;

procedure PUMLComponent.InsertImplementation(Index: Integer; Value: PUMLArtifact);
begin
  if Value <> nil then begin
    FImplementations.Insert(Index, Value);
    Value.FImplementationLocations.Add(Self);
  end;
end;

procedure PUMLComponent.DeleteImplementation(Index: Integer);
begin
  RemoveImplementation(FImplementations.Items[Index] as UMLModels.PUMLArtifact);
end;

function PUMLComponent.IndexOfImplementation(Value: PUMLArtifact): Integer;
begin
  Result := FImplementations.IndexOf(Value);
end;

function PUMLComponent.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLComponent.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLComponent.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLComponent.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLComponent.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'DeploymentLocations' then begin
    AddDeploymentLocation(Value as PUMLNode);
  end
  else if Name = 'Residents' then begin
    AddResident(Value as PUMLModelElement);
  end
  else if Name = 'Implementations' then begin
    AddImplementation(Value as PUMLArtifact);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLComponent.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'DeploymentLocations' then begin
    RemoveDeploymentLocation(Value as PUMLNode);
  end
  else if Name = 'Residents' then begin
    RemoveResident(Value as PUMLModelElement);
  end
  else if Name = 'Implementations' then begin
    RemoveImplementation(Value as PUMLArtifact);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLComponent.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'DeploymentLocations' then begin
    InsertDeploymentLocation(Index, Value as PUMLNode);
  end
  else if Name = 'Residents' then begin
    InsertResident(Index, Value as PUMLModelElement);
  end
  else if Name = 'Implementations' then begin
    InsertImplementation(Index, Value as PUMLArtifact);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLComponent.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'DeploymentLocations' then begin
    DeleteDeploymentLocation(Index);
  end
  else if Name = 'Residents' then begin
    DeleteResident(Index);
  end
  else if Name = 'Implementations' then begin
    DeleteImplementation(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLComponent.MOF_ClearCollection(Name: string);
begin
  if Name = 'DeploymentLocations' then begin
    ClearDeploymentLocations;
  end
  else if Name = 'Residents' then begin
    ClearResidents;
  end
  else if Name = 'Implementations' then begin
    ClearImplementations;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLComponent.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'DeploymentLocations' then begin
    Result := IndexOfDeploymentLocation(Value as PUMLNode);
  end
  else if Name = 'Residents' then begin
    Result := IndexOfResident(Value as PUMLModelElement);
  end
  else if Name = 'Implementations' then begin
    Result := IndexOfImplementation(Value as PUMLArtifact);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLComponent.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'DeploymentLocations' then begin
    Result := DeploymentLocations[Index];
  end
  else if Name = 'Residents' then begin
    Result := Residents[Index];
  end
  else if Name = 'Implementations' then begin
    Result := Implementations[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLComponent.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'DeploymentLocations' then begin
    Result := DeploymentLocationCount;
  end
  else if Name = 'Residents' then begin
    Result := ResidentCount;
  end
  else if Name = 'Implementations' then begin
    Result := ImplementationCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLComponent
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSignal

constructor PUMLSignal.Create;
begin
  inherited;
  FReceptions := POrderedSet.Create;
  FContexts := POrderedSet.Create;
  FSendActions := POrderedSet.Create;
  FOccurrences := POrderedSet.Create;
end;

destructor PUMLSignal.Destroy;
begin
  FReceptions.Free;
  FContexts.Free;
  FSendActions.Free;
  FOccurrences.Free;
  inherited;
end;

function PUMLSignal.GetReception(Index: Integer): PUMLReception;
begin
  Result := FReceptions.Items[Index] as UMLModels.PUMLReception;
end;

function PUMLSignal.GetReceptionCount: Integer;
begin
  Result := FReceptions.Count;
end;

function PUMLSignal.GetContext(Index: Integer): PUMLBehavioralFeature;
begin
  Result := FContexts.Items[Index] as UMLModels.PUMLBehavioralFeature;
end;

function PUMLSignal.GetContextCount: Integer;
begin
  Result := FContexts.Count;
end;

function PUMLSignal.GetSendAction(Index: Integer): PUMLSendAction;
begin
  Result := FSendActions.Items[Index] as UMLModels.PUMLSendAction;
end;

function PUMLSignal.GetSendActionCount: Integer;
begin
  Result := FSendActions.Count;
end;

function PUMLSignal.GetOccurrence(Index: Integer): PUMLSignalEvent;
begin
  Result := FOccurrences.Items[Index] as UMLModels.PUMLSignalEvent;
end;

function PUMLSignal.GetOccurrenceCount: Integer;
begin
  Result := FOccurrences.Count;
end;

procedure PUMLSignal.ClearReceptions;
var
  I: Integer;
begin
  for I := FReceptions.Count - 1 downto 0 do
    DeleteReception(I);
end;

procedure PUMLSignal.AddReception(Value: PUMLReception);
begin
  if Value <> nil then begin
    if Value.FSignal <> nil then Value.FSignal.FReceptions.Remove(Value);
    FReceptions.Add(Value);
    Value.FSignal := Self;
  end;
end;

procedure PUMLSignal.RemoveReception(Value: PUMLReception);
begin
  if Value <> nil then begin
    FReceptions.Remove(Value);
    Value.FSignal := nil;
  end;
end;

procedure PUMLSignal.InsertReception(Index: Integer; Value: PUMLReception);
begin
  if Value <> nil then begin
    if Value.FSignal <> nil then Value.FSignal.FReceptions.Remove(Value);
    FReceptions.Insert(Index, Value);
    Value.FSignal := Self;
  end;
end;

procedure PUMLSignal.DeleteReception(Index: Integer);
begin
  RemoveReception(FReceptions.Items[Index] as UMLModels.PUMLReception);
end;

function PUMLSignal.IndexOfReception(Value: PUMLReception): Integer;
begin
  Result := FReceptions.IndexOf(Value);
end;

procedure PUMLSignal.ClearContexts;
var
  I: Integer;
begin
  for I := FContexts.Count - 1 downto 0 do
    DeleteContext(I);
end;

procedure PUMLSignal.AddContext(Value: PUMLBehavioralFeature);
begin
  if Value <> nil then begin
    FContexts.Add(Value);
    Value.FRaisedSignals.Add(Self);
  end;
end;

procedure PUMLSignal.RemoveContext(Value: PUMLBehavioralFeature);
begin
  if Value <> nil then begin
    FContexts.Remove(Value);
    Value.FRaisedSignals.Remove(Self);
  end;
end;

procedure PUMLSignal.InsertContext(Index: Integer; Value: PUMLBehavioralFeature);
begin
  if Value <> nil then begin
    FContexts.Insert(Index, Value);
    Value.FRaisedSignals.Add(Self);
  end;
end;

procedure PUMLSignal.DeleteContext(Index: Integer);
begin
  RemoveContext(FContexts.Items[Index] as UMLModels.PUMLBehavioralFeature);
end;

function PUMLSignal.IndexOfContext(Value: PUMLBehavioralFeature): Integer;
begin
  Result := FContexts.IndexOf(Value);
end;

procedure PUMLSignal.ClearSendActions;
var
  I: Integer;
begin
  for I := FSendActions.Count - 1 downto 0 do
    DeleteSendAction(I);
end;

procedure PUMLSignal.AddSendAction(Value: PUMLSendAction);
begin
  if Value <> nil then begin
    if Value.FSignal <> nil then Value.FSignal.FSendActions.Remove(Value);
    FSendActions.Add(Value);
    Value.FSignal := Self;
  end;
end;

procedure PUMLSignal.RemoveSendAction(Value: PUMLSendAction);
begin
  if Value <> nil then begin
    FSendActions.Remove(Value);
    Value.FSignal := nil;
  end;
end;

procedure PUMLSignal.InsertSendAction(Index: Integer; Value: PUMLSendAction);
begin
  if Value <> nil then begin
    if Value.FSignal <> nil then Value.FSignal.FSendActions.Remove(Value);
    FSendActions.Insert(Index, Value);
    Value.FSignal := Self;
  end;
end;

procedure PUMLSignal.DeleteSendAction(Index: Integer);
begin
  RemoveSendAction(FSendActions.Items[Index] as UMLModels.PUMLSendAction);
end;

function PUMLSignal.IndexOfSendAction(Value: PUMLSendAction): Integer;
begin
  Result := FSendActions.IndexOf(Value);
end;

procedure PUMLSignal.ClearOccurrences;
var
  I: Integer;
begin
  for I := FOccurrences.Count - 1 downto 0 do
    DeleteOccurrence(I);
end;

procedure PUMLSignal.AddOccurrence(Value: PUMLSignalEvent);
begin
  if Value <> nil then begin
    if Value.FSignal <> nil then Value.FSignal.FOccurrences.Remove(Value);
    FOccurrences.Add(Value);
    Value.FSignal := Self;
  end;
end;

procedure PUMLSignal.RemoveOccurrence(Value: PUMLSignalEvent);
begin
  if Value <> nil then begin
    FOccurrences.Remove(Value);
    Value.FSignal := nil;
  end;
end;

procedure PUMLSignal.InsertOccurrence(Index: Integer; Value: PUMLSignalEvent);
begin
  if Value <> nil then begin
    if Value.FSignal <> nil then Value.FSignal.FOccurrences.Remove(Value);
    FOccurrences.Insert(Index, Value);
    Value.FSignal := Self;
  end;
end;

procedure PUMLSignal.DeleteOccurrence(Index: Integer);
begin
  RemoveOccurrence(FOccurrences.Items[Index] as UMLModels.PUMLSignalEvent);
end;

function PUMLSignal.IndexOfOccurrence(Value: PUMLSignalEvent): Integer;
begin
  Result := FOccurrences.IndexOf(Value);
end;

function PUMLSignal.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLSignal.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLSignal.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLSignal.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLSignal.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Receptions' then begin
    AddReception(Value as PUMLReception);
  end
  else if Name = 'Contexts' then begin
    AddContext(Value as PUMLBehavioralFeature);
  end
  else if Name = 'SendActions' then begin
    AddSendAction(Value as PUMLSendAction);
  end
  else if Name = 'Occurrences' then begin
    AddOccurrence(Value as PUMLSignalEvent);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLSignal.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Receptions' then begin
    RemoveReception(Value as PUMLReception);
  end
  else if Name = 'Contexts' then begin
    RemoveContext(Value as PUMLBehavioralFeature);
  end
  else if Name = 'SendActions' then begin
    RemoveSendAction(Value as PUMLSendAction);
  end
  else if Name = 'Occurrences' then begin
    RemoveOccurrence(Value as PUMLSignalEvent);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLSignal.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Receptions' then begin
    InsertReception(Index, Value as PUMLReception);
  end
  else if Name = 'Contexts' then begin
    InsertContext(Index, Value as PUMLBehavioralFeature);
  end
  else if Name = 'SendActions' then begin
    InsertSendAction(Index, Value as PUMLSendAction);
  end
  else if Name = 'Occurrences' then begin
    InsertOccurrence(Index, Value as PUMLSignalEvent);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLSignal.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Receptions' then begin
    DeleteReception(Index);
  end
  else if Name = 'Contexts' then begin
    DeleteContext(Index);
  end
  else if Name = 'SendActions' then begin
    DeleteSendAction(Index);
  end
  else if Name = 'Occurrences' then begin
    DeleteOccurrence(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLSignal.MOF_ClearCollection(Name: string);
begin
  if Name = 'Receptions' then begin
    ClearReceptions;
  end
  else if Name = 'Contexts' then begin
    ClearContexts;
  end
  else if Name = 'SendActions' then begin
    ClearSendActions;
  end
  else if Name = 'Occurrences' then begin
    ClearOccurrences;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLSignal.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Receptions' then begin
    Result := IndexOfReception(Value as PUMLReception);
  end
  else if Name = 'Contexts' then begin
    Result := IndexOfContext(Value as PUMLBehavioralFeature);
  end
  else if Name = 'SendActions' then begin
    Result := IndexOfSendAction(Value as PUMLSendAction);
  end
  else if Name = 'Occurrences' then begin
    Result := IndexOfOccurrence(Value as PUMLSignalEvent);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLSignal.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Receptions' then begin
    Result := Receptions[Index];
  end
  else if Name = 'Contexts' then begin
    Result := Contexts[Index];
  end
  else if Name = 'SendActions' then begin
    Result := SendActions[Index];
  end
  else if Name = 'Occurrences' then begin
    Result := Occurrences[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLSignal.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Receptions' then begin
    Result := ReceptionCount;
  end
  else if Name = 'Contexts' then begin
    Result := ContextCount;
  end
  else if Name = 'SendActions' then begin
    Result := SendActionCount;
  end
  else if Name = 'Occurrences' then begin
    Result := OccurrenceCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLSignal
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLException

constructor PUMLException.Create;
begin
  inherited;
end;

destructor PUMLException.Destroy;
begin
  inherited;
end;

function PUMLException.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLException.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLException.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLException.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLException.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLException.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLException.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLException.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLException.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLException.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLException.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLException.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLException
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLClassifierRole

constructor PUMLClassifierRole.Create;
begin
  inherited;
  FBase := nil;
  FAvailableFeatures := POrderedSet.Create;
  FSenderClientMessages := POrderedSet.Create;
  FReceiverClientMessages := POrderedSet.Create;
  FAvailableContents := POrderedSet.Create;
  FConformingInstances := POrderedSet.Create;
end;

destructor PUMLClassifierRole.Destroy;
begin
  FAvailableFeatures.Free;
  FSenderClientMessages.Free;
  FReceiverClientMessages.Free;
  FAvailableContents.Free;
  FConformingInstances.Free;
  inherited;
end;

procedure PUMLClassifierRole.SetMultiplicity(Value: string);
begin
  if FMultiplicity <> Value then
    FMultiplicity := Value;
end;

procedure PUMLClassifierRole.SetBase(Value: PUMLClassifier);
begin
  if FBase <> Value then begin
    if FBase <> nil then Base.FClassifierRoles.Remove(Self);
    FBase := Value;
    if Value <> nil then begin
      Value.FClassifierRoles.Add(Self);
    end;
  end;
end;

function PUMLClassifierRole.GetAvailableFeature(Index: Integer): PUMLFeature;
begin
  Result := FAvailableFeatures.Items[Index] as UMLModels.PUMLFeature;
end;

function PUMLClassifierRole.GetAvailableFeatureCount: Integer;
begin
  Result := FAvailableFeatures.Count;
end;

function PUMLClassifierRole.GetSenderClientMessage(Index: Integer): PUMLMessage;
begin
  Result := FSenderClientMessages.Items[Index] as UMLModels.PUMLMessage;
end;

function PUMLClassifierRole.GetSenderClientMessageCount: Integer;
begin
  Result := FSenderClientMessages.Count;
end;

function PUMLClassifierRole.GetReceiverClientMessage(Index: Integer): PUMLMessage;
begin
  Result := FReceiverClientMessages.Items[Index] as UMLModels.PUMLMessage;
end;

function PUMLClassifierRole.GetReceiverClientMessageCount: Integer;
begin
  Result := FReceiverClientMessages.Count;
end;

function PUMLClassifierRole.GetAvailableContent(Index: Integer): PUMLModelElement;
begin
  Result := FAvailableContents.Items[Index] as UMLModels.PUMLModelElement;
end;

function PUMLClassifierRole.GetAvailableContentCount: Integer;
begin
  Result := FAvailableContents.Count;
end;

function PUMLClassifierRole.GetConformingInstance(Index: Integer): PUMLInstance;
begin
  Result := FConformingInstances.Items[Index] as UMLModels.PUMLInstance;
end;

function PUMLClassifierRole.GetConformingInstanceCount: Integer;
begin
  Result := FConformingInstances.Count;
end;

procedure PUMLClassifierRole.ClearAvailableFeatures;
var
  I: Integer;
begin
  for I := FAvailableFeatures.Count - 1 downto 0 do
    DeleteAvailableFeature(I);
end;

procedure PUMLClassifierRole.AddAvailableFeature(Value: PUMLFeature);
begin
  if Value <> nil then begin
    FAvailableFeatures.Add(Value);
    Value.FClassifierRoles.Add(Self);
  end;
end;

procedure PUMLClassifierRole.RemoveAvailableFeature(Value: PUMLFeature);
begin
  if Value <> nil then begin
    FAvailableFeatures.Remove(Value);
    Value.FClassifierRoles.Remove(Self);
  end;
end;

procedure PUMLClassifierRole.InsertAvailableFeature(Index: Integer; Value: PUMLFeature);
begin
  if Value <> nil then begin
    FAvailableFeatures.Insert(Index, Value);
    Value.FClassifierRoles.Add(Self);
  end;
end;

procedure PUMLClassifierRole.DeleteAvailableFeature(Index: Integer);
begin
  RemoveAvailableFeature(FAvailableFeatures.Items[Index] as UMLModels.PUMLFeature);
end;

function PUMLClassifierRole.IndexOfAvailableFeature(Value: PUMLFeature): Integer;
begin
  Result := FAvailableFeatures.IndexOf(Value);
end;

procedure PUMLClassifierRole.ClearSenderClientMessages;
var
  I: Integer;
begin
  for I := FSenderClientMessages.Count - 1 downto 0 do
    DeleteSenderClientMessage(I);
end;

procedure PUMLClassifierRole.AddSenderClientMessage(Value: PUMLMessage);
begin
  if Value <> nil then begin
    if Value.FSender <> nil then Value.FSender.FSenderClientMessages.Remove(Value);
    FSenderClientMessages.Add(Value);
    Value.FSender := Self;
  end;
end;

procedure PUMLClassifierRole.RemoveSenderClientMessage(Value: PUMLMessage);
begin
  if Value <> nil then begin
    FSenderClientMessages.Remove(Value);
    Value.FSender := nil;
  end;
end;

procedure PUMLClassifierRole.InsertSenderClientMessage(Index: Integer; Value: PUMLMessage);
begin
  if Value <> nil then begin
    if Value.FSender <> nil then Value.FSender.FSenderClientMessages.Remove(Value);
    FSenderClientMessages.Insert(Index, Value);
    Value.FSender := Self;
  end;
end;

procedure PUMLClassifierRole.DeleteSenderClientMessage(Index: Integer);
begin
  RemoveSenderClientMessage(FSenderClientMessages.Items[Index] as UMLModels.PUMLMessage);
end;

function PUMLClassifierRole.IndexOfSenderClientMessage(Value: PUMLMessage): Integer;
begin
  Result := FSenderClientMessages.IndexOf(Value);
end;

procedure PUMLClassifierRole.ClearReceiverClientMessages;
var
  I: Integer;
begin
  for I := FReceiverClientMessages.Count - 1 downto 0 do
    DeleteReceiverClientMessage(I);
end;

procedure PUMLClassifierRole.AddReceiverClientMessage(Value: PUMLMessage);
begin
  if Value <> nil then begin
    if Value.FReceiver <> nil then Value.FReceiver.FReceiverClientMessages.Remove(Value);
    FReceiverClientMessages.Add(Value);
    Value.FReceiver := Self;
  end;
end;

procedure PUMLClassifierRole.RemoveReceiverClientMessage(Value: PUMLMessage);
begin
  if Value <> nil then begin
    FReceiverClientMessages.Remove(Value);
    Value.FReceiver := nil;
  end;
end;

procedure PUMLClassifierRole.InsertReceiverClientMessage(Index: Integer; Value: PUMLMessage);
begin
  if Value <> nil then begin
    if Value.FReceiver <> nil then Value.FReceiver.FReceiverClientMessages.Remove(Value);
    FReceiverClientMessages.Insert(Index, Value);
    Value.FReceiver := Self;
  end;
end;

procedure PUMLClassifierRole.DeleteReceiverClientMessage(Index: Integer);
begin
  RemoveReceiverClientMessage(FReceiverClientMessages.Items[Index] as UMLModels.PUMLMessage);
end;

function PUMLClassifierRole.IndexOfReceiverClientMessage(Value: PUMLMessage): Integer;
begin
  Result := FReceiverClientMessages.IndexOf(Value);
end;

procedure PUMLClassifierRole.ClearAvailableContents;
var
  I: Integer;
begin
  for I := FAvailableContents.Count - 1 downto 0 do
    DeleteAvailableContent(I);
end;

procedure PUMLClassifierRole.AddAvailableContent(Value: PUMLModelElement);
begin
  if Value <> nil then begin
    FAvailableContents.Add(Value);
    Value.FContentRoles.Add(Self);
  end;
end;

procedure PUMLClassifierRole.RemoveAvailableContent(Value: PUMLModelElement);
begin
  if Value <> nil then begin
    FAvailableContents.Remove(Value);
    Value.FContentRoles.Remove(Self);
  end;
end;

procedure PUMLClassifierRole.InsertAvailableContent(Index: Integer; Value: PUMLModelElement);
begin
  if Value <> nil then begin
    FAvailableContents.Insert(Index, Value);
    Value.FContentRoles.Add(Self);
  end;
end;

procedure PUMLClassifierRole.DeleteAvailableContent(Index: Integer);
begin
  RemoveAvailableContent(FAvailableContents.Items[Index] as UMLModels.PUMLModelElement);
end;

function PUMLClassifierRole.IndexOfAvailableContent(Value: PUMLModelElement): Integer;
begin
  Result := FAvailableContents.IndexOf(Value);
end;

procedure PUMLClassifierRole.ClearConformingInstances;
var
  I: Integer;
begin
  for I := FConformingInstances.Count - 1 downto 0 do
    DeleteConformingInstance(I);
end;

procedure PUMLClassifierRole.AddConformingInstance(Value: PUMLInstance);
begin
  if Value <> nil then begin
    FConformingInstances.Add(Value);
    Value.FPlayedRoles.Add(Self);
  end;
end;

procedure PUMLClassifierRole.RemoveConformingInstance(Value: PUMLInstance);
begin
  if Value <> nil then begin
    FConformingInstances.Remove(Value);
    Value.FPlayedRoles.Remove(Self);
  end;
end;

procedure PUMLClassifierRole.InsertConformingInstance(Index: Integer; Value: PUMLInstance);
begin
  if Value <> nil then begin
    FConformingInstances.Insert(Index, Value);
    Value.FPlayedRoles.Add(Self);
  end;
end;

procedure PUMLClassifierRole.DeleteConformingInstance(Index: Integer);
begin
  RemoveConformingInstance(FConformingInstances.Items[Index] as UMLModels.PUMLInstance);
end;

function PUMLClassifierRole.IndexOfConformingInstance(Value: PUMLInstance): Integer;
begin
  Result := FConformingInstances.IndexOf(Value);
end;

function PUMLClassifierRole.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Multiplicity' then begin
    Result := Multiplicity;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLClassifierRole.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Multiplicity' then begin
    Multiplicity := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLClassifierRole.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Base' then begin
    Result := Base;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLClassifierRole.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Base' then begin
    Base := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLClassifierRole.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'AvailableFeatures' then begin
    AddAvailableFeature(Value as PUMLFeature);
  end
  else if Name = 'SenderClientMessages' then begin
    AddSenderClientMessage(Value as PUMLMessage);
  end
  else if Name = 'ReceiverClientMessages' then begin
    AddReceiverClientMessage(Value as PUMLMessage);
  end
  else if Name = 'AvailableContents' then begin
    AddAvailableContent(Value as PUMLModelElement);
  end
  else if Name = 'ConformingInstances' then begin
    AddConformingInstance(Value as PUMLInstance);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLClassifierRole.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'AvailableFeatures' then begin
    RemoveAvailableFeature(Value as PUMLFeature);
  end
  else if Name = 'SenderClientMessages' then begin
    RemoveSenderClientMessage(Value as PUMLMessage);
  end
  else if Name = 'ReceiverClientMessages' then begin
    RemoveReceiverClientMessage(Value as PUMLMessage);
  end
  else if Name = 'AvailableContents' then begin
    RemoveAvailableContent(Value as PUMLModelElement);
  end
  else if Name = 'ConformingInstances' then begin
    RemoveConformingInstance(Value as PUMLInstance);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLClassifierRole.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'AvailableFeatures' then begin
    InsertAvailableFeature(Index, Value as PUMLFeature);
  end
  else if Name = 'SenderClientMessages' then begin
    InsertSenderClientMessage(Index, Value as PUMLMessage);
  end
  else if Name = 'ReceiverClientMessages' then begin
    InsertReceiverClientMessage(Index, Value as PUMLMessage);
  end
  else if Name = 'AvailableContents' then begin
    InsertAvailableContent(Index, Value as PUMLModelElement);
  end
  else if Name = 'ConformingInstances' then begin
    InsertConformingInstance(Index, Value as PUMLInstance);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLClassifierRole.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'AvailableFeatures' then begin
    DeleteAvailableFeature(Index);
  end
  else if Name = 'SenderClientMessages' then begin
    DeleteSenderClientMessage(Index);
  end
  else if Name = 'ReceiverClientMessages' then begin
    DeleteReceiverClientMessage(Index);
  end
  else if Name = 'AvailableContents' then begin
    DeleteAvailableContent(Index);
  end
  else if Name = 'ConformingInstances' then begin
    DeleteConformingInstance(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLClassifierRole.MOF_ClearCollection(Name: string);
begin
  if Name = 'AvailableFeatures' then begin
    ClearAvailableFeatures;
  end
  else if Name = 'SenderClientMessages' then begin
    ClearSenderClientMessages;
  end
  else if Name = 'ReceiverClientMessages' then begin
    ClearReceiverClientMessages;
  end
  else if Name = 'AvailableContents' then begin
    ClearAvailableContents;
  end
  else if Name = 'ConformingInstances' then begin
    ClearConformingInstances;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLClassifierRole.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'AvailableFeatures' then begin
    Result := IndexOfAvailableFeature(Value as PUMLFeature);
  end
  else if Name = 'SenderClientMessages' then begin
    Result := IndexOfSenderClientMessage(Value as PUMLMessage);
  end
  else if Name = 'ReceiverClientMessages' then begin
    Result := IndexOfReceiverClientMessage(Value as PUMLMessage);
  end
  else if Name = 'AvailableContents' then begin
    Result := IndexOfAvailableContent(Value as PUMLModelElement);
  end
  else if Name = 'ConformingInstances' then begin
    Result := IndexOfConformingInstance(Value as PUMLInstance);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLClassifierRole.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'AvailableFeatures' then begin
    Result := AvailableFeatures[Index];
  end
  else if Name = 'SenderClientMessages' then begin
    Result := SenderClientMessages[Index];
  end
  else if Name = 'ReceiverClientMessages' then begin
    Result := ReceiverClientMessages[Index];
  end
  else if Name = 'AvailableContents' then begin
    Result := AvailableContents[Index];
  end
  else if Name = 'ConformingInstances' then begin
    Result := ConformingInstances[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLClassifierRole.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'AvailableFeatures' then begin
    Result := AvailableFeatureCount;
  end
  else if Name = 'SenderClientMessages' then begin
    Result := SenderClientMessageCount;
  end
  else if Name = 'ReceiverClientMessages' then begin
    Result := ReceiverClientMessageCount;
  end
  else if Name = 'AvailableContents' then begin
    Result := AvailableContentCount;
  end
  else if Name = 'ConformingInstances' then begin
    Result := ConformingInstanceCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLClassifierRole.CanRelocateTo(Model: PModel): Boolean;
begin
  if Namespace is PUMLCollaboration then
    Result := False
  else
    Result := inherited CanRelocateTo(Model);
end;

// PUMLClassifierRole
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLEvent

constructor PUMLEvent.Create;
begin
  inherited;
  FParameters := POrderedSet.Create;
  FStates := POrderedSet.Create;
  FTransition := nil;
end;

destructor PUMLEvent.Destroy;
begin
  FParameters.Free;
  FStates.Free;
  inherited;
end;

function PUMLEvent.GetParameter(Index: Integer): PUMLParameter;
begin
  Result := FParameters.Items[Index] as UMLModels.PUMLParameter;
end;

function PUMLEvent.GetParameterCount: Integer;
begin
  Result := FParameters.Count;
end;

function PUMLEvent.GetState(Index: Integer): PUMLState;
begin
  Result := FStates.Items[Index] as UMLModels.PUMLState;
end;

function PUMLEvent.GetStateCount: Integer;
begin
  Result := FStates.Count;
end;

procedure PUMLEvent.SetTransition(Value: PUMLTransition);
begin
  if FTransition <> Value then begin
    if FTransition <> nil then begin
      FTransition.FTriggers.Remove(Self);
      FTransition.RemoveVirtualOwnedModel(Self);
    end;
    FTransition := Value;
    if Value <> nil then begin
      Value.FTriggers.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLEvent.ClearParameters;
var
  I: Integer;
begin
  for I := FParameters.Count - 1 downto 0 do
    DeleteParameter(I);
end;

procedure PUMLEvent.AddParameter(Value: PUMLParameter);
begin
  if Value <> nil then begin
    if Value.FEvent <> nil then begin
      Value.FEvent.FParameters.Remove(Value);
      Value.FEvent.RemoveVirtualOwnedModel(Value);
    end;
    FParameters.Add(Value);
    Value.FEvent := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLEvent.RemoveParameter(Value: PUMLParameter);
begin
  if Value <> nil then begin
    FParameters.Remove(Value);
    Value.FEvent := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLEvent.InsertParameter(Index: Integer; Value: PUMLParameter);
begin
  if Value <> nil then begin
    if Value.FEvent <> nil then begin
      Value.FEvent.FParameters.Remove(Value);
      Value.FEvent.RemoveVirtualOwnedModel(Value);
    end;
    FParameters.Insert(Index, Value);
    Value.FEvent := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLEvent.DeleteParameter(Index: Integer);
begin
  RemoveParameter(FParameters.Items[Index] as UMLModels.PUMLParameter);
end;

function PUMLEvent.IndexOfParameter(Value: PUMLParameter): Integer;
begin
  Result := FParameters.IndexOf(Value);
end;

procedure PUMLEvent.ClearStates;
var
  I: Integer;
begin
  for I := FStates.Count - 1 downto 0 do
    DeleteState(I);
end;

procedure PUMLEvent.AddState(Value: PUMLState);
begin
  if Value <> nil then begin
    FStates.Add(Value);
    Value.FDeferrableEvents.Add(Self);
  end;
end;

procedure PUMLEvent.RemoveState(Value: PUMLState);
begin
  if Value <> nil then begin
    FStates.Remove(Value);
    Value.FDeferrableEvents.Remove(Self);
  end;
end;

procedure PUMLEvent.InsertState(Index: Integer; Value: PUMLState);
begin
  if Value <> nil then begin
    FStates.Insert(Index, Value);
    Value.FDeferrableEvents.Add(Self);
  end;
end;

procedure PUMLEvent.DeleteState(Index: Integer);
begin
  RemoveState(FStates.Items[Index] as UMLModels.PUMLState);
end;

function PUMLEvent.IndexOfState(Value: PUMLState): Integer;
begin
  Result := FStates.IndexOf(Value);
end;

function PUMLEvent.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLEvent.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLEvent.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Transition' then begin
    Result := Transition;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLEvent.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Transition' then begin
    Transition := Value as PUMLTransition;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLEvent.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Parameters' then begin
    AddParameter(Value as PUMLParameter);
  end
  else if Name = 'States' then begin
    AddState(Value as PUMLState);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLEvent.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Parameters' then begin
    RemoveParameter(Value as PUMLParameter);
  end
  else if Name = 'States' then begin
    RemoveState(Value as PUMLState);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLEvent.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Parameters' then begin
    InsertParameter(Index, Value as PUMLParameter);
  end
  else if Name = 'States' then begin
    InsertState(Index, Value as PUMLState);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLEvent.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Parameters' then begin
    DeleteParameter(Index);
  end
  else if Name = 'States' then begin
    DeleteState(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLEvent.MOF_ClearCollection(Name: string);
begin
  if Name = 'Parameters' then begin
    ClearParameters;
  end
  else if Name = 'States' then begin
    ClearStates;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLEvent.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Parameters' then begin
    Result := IndexOfParameter(Value as PUMLParameter);
  end
  else if Name = 'States' then begin
    Result := IndexOfState(Value as PUMLState);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLEvent.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Parameters' then begin
    Result := Parameters[Index];
  end
  else if Name = 'States' then begin
    Result := States[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLEvent.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Parameters' then begin
    Result := ParameterCount;
  end
  else if Name = 'States' then begin
    Result := StateCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLEvent
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLChangeEvent

constructor PUMLChangeEvent.Create;
begin
  inherited;
end;

destructor PUMLChangeEvent.Destroy;
begin
  inherited;
end;

procedure PUMLChangeEvent.SetChangeExpression(Value: string);
begin
  if FChangeExpression <> Value then
    FChangeExpression := Value;
end;

function PUMLChangeEvent.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'ChangeExpression' then begin
    Result := ChangeExpression;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLChangeEvent.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'ChangeExpression' then begin
    ChangeExpression := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLChangeEvent.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLChangeEvent.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLChangeEvent.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLChangeEvent.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLChangeEvent.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLChangeEvent.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLChangeEvent.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLChangeEvent.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLChangeEvent.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLChangeEvent.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLChangeEvent
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSignalEvent

constructor PUMLSignalEvent.Create;
begin
  inherited;
  FSignal := nil;
end;

destructor PUMLSignalEvent.Destroy;
begin
  inherited;
end;

procedure PUMLSignalEvent.SetSignal(Value: PUMLSignal);
begin
  if FSignal <> Value then begin
    if FSignal <> nil then Signal.FOccurrences.Remove(Self);
    FSignal := Value;
    if Value <> nil then begin
      Value.FOccurrences.Add(Self);
    end;
  end;
end;

function PUMLSignalEvent.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLSignalEvent.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLSignalEvent.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Signal' then begin
    Result := Signal;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLSignalEvent.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Signal' then begin
    Signal := Value as PUMLSignal;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLSignalEvent.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLSignalEvent.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLSignalEvent.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLSignalEvent.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLSignalEvent.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLSignalEvent.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLSignalEvent.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLSignalEvent.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLSignalEvent
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLTimeEvent

constructor PUMLTimeEvent.Create;
begin
  inherited;
end;

destructor PUMLTimeEvent.Destroy;
begin
  inherited;
end;

procedure PUMLTimeEvent.SetWhen(Value: string);
begin
  if FWhen <> Value then
    FWhen := Value;
end;

function PUMLTimeEvent.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'When' then begin
    Result := When;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLTimeEvent.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'When' then begin
    When := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLTimeEvent.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLTimeEvent.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLTimeEvent.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLTimeEvent.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLTimeEvent.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLTimeEvent.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLTimeEvent.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLTimeEvent.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLTimeEvent.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLTimeEvent.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLTimeEvent
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLCallEvent

constructor PUMLCallEvent.Create;
begin
  inherited;
  FOperation := nil;
end;

destructor PUMLCallEvent.Destroy;
begin
  inherited;
end;

procedure PUMLCallEvent.SetOperation(Value: PUMLOperation);
begin
  if FOperation <> Value then begin
    if FOperation <> nil then Operation.FOccurrences.Remove(Self);
    FOperation := Value;
    if Value <> nil then begin
      Value.FOccurrences.Add(Self);
    end;
  end;
end;

function PUMLCallEvent.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLCallEvent.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLCallEvent.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Operation' then begin
    Result := Operation;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLCallEvent.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Operation' then begin
    Operation := Value as PUMLOperation;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLCallEvent.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLCallEvent.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLCallEvent.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLCallEvent.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLCallEvent.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLCallEvent.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLCallEvent.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLCallEvent.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLCallEvent
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLEnumerationLiteral

constructor PUMLEnumerationLiteral.Create;
begin
  inherited;
  FEnumeration := nil;
end;

destructor PUMLEnumerationLiteral.Destroy;
begin
  inherited;
end;

procedure PUMLEnumerationLiteral.SetEnumeration(Value: PUMLEnumeration);
begin
  if FEnumeration <> Value then begin
    if FEnumeration <> nil then begin
      FEnumeration.FLiterals.Remove(Self);
      FEnumeration.RemoveVirtualOwnedModel(Self);
    end;
    FEnumeration := Value;
    if Value <> nil then begin
      Value.FLiterals.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLEnumerationLiteral.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLEnumerationLiteral.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLEnumerationLiteral.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Enumeration' then begin
    Result := Enumeration;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLEnumerationLiteral.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Enumeration' then begin
    Enumeration := Value as PUMLEnumeration;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLEnumerationLiteral.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLEnumerationLiteral.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLEnumerationLiteral.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLEnumerationLiteral.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLEnumerationLiteral.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLEnumerationLiteral.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLEnumerationLiteral.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLEnumerationLiteral.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLEnumerationLiteral
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLStimulus

constructor PUMLStimulus.Create;
begin
  inherited;
  FSender := nil;
  FReceiver := nil;
  FCommunicationLink := nil;
  FAction := nil;
  FActivator := nil;
  FActivatees := POrderedSet.Create;
  FPredecessor := nil;
  FSuccessor := nil;
  FPlayedRoles := POrderedSet.Create;
  FInteractionInstanceSet := nil;
end;

destructor PUMLStimulus.Destroy;
begin
  FActivatees.Free;
  FPlayedRoles.Free;
  inherited;
end;

procedure PUMLStimulus.SetArguments(Value: string);
begin
  if FArguments <> Value then
    FArguments := Value;
end;

procedure PUMLStimulus.SetReturn(Value: string);
begin
  if FReturn <> Value then
    FReturn := Value;
end;

procedure PUMLStimulus.SetIteration(Value: string);
begin
  if FIteration <> Value then
    FIteration := Value;
end;

procedure PUMLStimulus.SetBranch(Value: string);
begin
  if FBranch <> Value then
    FBranch := Value;
end;

procedure PUMLStimulus.SetSender(Value: PUMLInstance);
begin
  if FSender <> Value then begin
    if FSender <> nil then Sender.FSendingStimuli.Remove(Self);
    FSender := Value;
    if Value <> nil then begin
      Value.FSendingStimuli.Add(Self);
    end;
  end;
end;

procedure PUMLStimulus.SetReceiver(Value: PUMLInstance);
begin
  if FReceiver <> Value then begin
    if FReceiver <> nil then Receiver.FReceivingStimuli.Remove(Self);
    FReceiver := Value;
    if Value <> nil then begin
      Value.FReceivingStimuli.Add(Self);
    end;
  end;
end;

procedure PUMLStimulus.SetCommunicationLink(Value: PUMLLink);
begin
  if FCommunicationLink <> Value then begin
    if FCommunicationLink <> nil then CommunicationLink.FStimuli.Remove(Self);
    FCommunicationLink := Value;
    if Value <> nil then begin
      Value.FStimuli.Add(Self);
    end;
  end;
end;

procedure PUMLStimulus.SetAction(Value: PUMLAction);
begin
  if FAction <> Value then begin
    if FAction <> nil then Action.FStimulus := nil;
    RemoveVirtualOwnedModel(FAction);
    FAction := Value;
    AddVirtualOwnedModel(FAction);
    if Value <> nil then Value.FStimulus := Self;
  end;
end;

procedure PUMLStimulus.SetActivator(Value: PUMLStimulus);
begin
  if FActivator <> Value then begin
    if FActivator <> nil then Activator.FActivatees.Remove(Self);
    FActivator := Value;
    if Value <> nil then begin
      Value.FActivatees.Add(Self);
    end;
  end;
end;

function PUMLStimulus.GetActivatee(Index: Integer): PUMLStimulus;
begin
  Result := FActivatees.Items[Index] as UMLModels.PUMLStimulus;
end;

function PUMLStimulus.GetActivateeCount: Integer;
begin
  Result := FActivatees.Count;
end;

procedure PUMLStimulus.SetPredecessor(Value: PUMLStimulus);
begin
  if FPredecessor <> Value then begin
    if FPredecessor <> nil then Predecessor.FSuccessor := nil;
    FPredecessor := Value;
    if Value <> nil then Value.FSuccessor := Self;
  end;
end;

procedure PUMLStimulus.SetSuccessor(Value: PUMLStimulus);
begin
  if FSuccessor <> Value then begin
    if FSuccessor <> nil then Successor.FPredecessor := nil;
    FSuccessor := Value;
    if Value <> nil then Value.FPredecessor := Self;
  end;
end;

function PUMLStimulus.GetPlayedRole(Index: Integer): PUMLMessage;
begin
  Result := FPlayedRoles.Items[Index] as UMLModels.PUMLMessage;
end;

function PUMLStimulus.GetPlayedRoleCount: Integer;
begin
  Result := FPlayedRoles.Count;
end;

procedure PUMLStimulus.SetInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
begin
  if FInteractionInstanceSet <> Value then begin
    if FInteractionInstanceSet <> nil then begin
      FInteractionInstanceSet.FParticipatingStimuli.Remove(Self);
      FInteractionInstanceSet.RemoveVirtualOwnedModel(Self);
    end;
    FInteractionInstanceSet := Value;
    if Value <> nil then begin
      Value.FParticipatingStimuli.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLStimulus.ClearActivatees;
var
  I: Integer;
begin
  for I := FActivatees.Count - 1 downto 0 do
    DeleteActivatee(I);
end;

procedure PUMLStimulus.AddActivatee(Value: PUMLStimulus);
begin
  if Value <> nil then begin
    if Value.FActivator <> nil then Value.FActivator.FActivatees.Remove(Value);
    FActivatees.Add(Value);
    Value.FActivator := Self;
  end;
end;

procedure PUMLStimulus.RemoveActivatee(Value: PUMLStimulus);
begin
  if Value <> nil then begin
    FActivatees.Remove(Value);
    Value.FActivator := nil;
  end;
end;

procedure PUMLStimulus.InsertActivatee(Index: Integer; Value: PUMLStimulus);
begin
  if Value <> nil then begin
    if Value.FActivator <> nil then Value.FActivator.FActivatees.Remove(Value);
    FActivatees.Insert(Index, Value);
    Value.FActivator := Self;
  end;
end;

procedure PUMLStimulus.DeleteActivatee(Index: Integer);
begin
  RemoveActivatee(FActivatees.Items[Index] as UMLModels.PUMLStimulus);
end;

function PUMLStimulus.IndexOfActivatee(Value: PUMLStimulus): Integer;
begin
  Result := FActivatees.IndexOf(Value);
end;

procedure PUMLStimulus.ClearPlayedRoles;
var
  I: Integer;
begin
  for I := FPlayedRoles.Count - 1 downto 0 do
    DeletePlayedRole(I);
end;

procedure PUMLStimulus.AddPlayedRole(Value: PUMLMessage);
begin
  if Value <> nil then begin
    FPlayedRoles.Add(Value);
    Value.FConformingStimuli.Add(Self);
  end;
end;

procedure PUMLStimulus.RemovePlayedRole(Value: PUMLMessage);
begin
  if Value <> nil then begin
    FPlayedRoles.Remove(Value);
    Value.FConformingStimuli.Remove(Self);
  end;
end;

procedure PUMLStimulus.InsertPlayedRole(Index: Integer; Value: PUMLMessage);
begin
  if Value <> nil then begin
    FPlayedRoles.Insert(Index, Value);
    Value.FConformingStimuli.Add(Self);
  end;
end;

procedure PUMLStimulus.DeletePlayedRole(Index: Integer);
begin
  RemovePlayedRole(FPlayedRoles.Items[Index] as UMLModels.PUMLMessage);
end;

function PUMLStimulus.IndexOfPlayedRole(Value: PUMLMessage): Integer;
begin
  Result := FPlayedRoles.IndexOf(Value);
end;

function PUMLStimulus.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Arguments' then begin
    Result := Arguments;
  end
  else if Name = 'Return' then begin
    Result := Return;
  end
  else if Name = 'Iteration' then begin
    Result := Iteration;
  end
  else if Name = 'Branch' then begin
    Result := Branch;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLStimulus.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Arguments' then begin
    Arguments := Value;
  end
  else if Name = 'Return' then begin
    Return := Value;
  end
  else if Name = 'Iteration' then begin
    Iteration := Value;
  end
  else if Name = 'Branch' then begin
    Branch := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLStimulus.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Sender' then begin
    Result := Sender;
  end
  else if Name = 'Receiver' then begin
    Result := Receiver;
  end
  else if Name = 'CommunicationLink' then begin
    Result := CommunicationLink;
  end
  else if Name = 'Action' then begin
    Result := Action;
  end
  else if Name = 'Activator' then begin
    Result := Activator;
  end
  else if Name = 'Predecessor' then begin
    Result := Predecessor;
  end
  else if Name = 'Successor' then begin
    Result := Successor;
  end
  else if Name = 'InteractionInstanceSet' then begin
    Result := InteractionInstanceSet;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLStimulus.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Sender' then begin
    Sender := Value as PUMLInstance;
  end
  else if Name = 'Receiver' then begin
    Receiver := Value as PUMLInstance;
  end
  else if Name = 'CommunicationLink' then begin
    CommunicationLink := Value as PUMLLink;
  end
  else if Name = 'Action' then begin
    Action := Value as PUMLAction;
  end
  else if Name = 'Activator' then begin
    Activator := Value as PUMLStimulus;
  end
  else if Name = 'Predecessor' then begin
    Predecessor := Value as PUMLStimulus;
  end
  else if Name = 'Successor' then begin
    Successor := Value as PUMLStimulus;
  end
  else if Name = 'InteractionInstanceSet' then begin
    InteractionInstanceSet := Value as PUMLInteractionInstanceSet;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLStimulus.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Activatees' then begin
    AddActivatee(Value as PUMLStimulus);
  end
  else if Name = 'PlayedRoles' then begin
    AddPlayedRole(Value as PUMLMessage);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLStimulus.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Activatees' then begin
    RemoveActivatee(Value as PUMLStimulus);
  end
  else if Name = 'PlayedRoles' then begin
    RemovePlayedRole(Value as PUMLMessage);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLStimulus.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Activatees' then begin
    InsertActivatee(Index, Value as PUMLStimulus);
  end
  else if Name = 'PlayedRoles' then begin
    InsertPlayedRole(Index, Value as PUMLMessage);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLStimulus.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Activatees' then begin
    DeleteActivatee(Index);
  end
  else if Name = 'PlayedRoles' then begin
    DeletePlayedRole(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLStimulus.MOF_ClearCollection(Name: string);
begin
  if Name = 'Activatees' then begin
    ClearActivatees;
  end
  else if Name = 'PlayedRoles' then begin
    ClearPlayedRoles;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLStimulus.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Activatees' then begin
    Result := IndexOfActivatee(Value as PUMLStimulus);
  end
  else if Name = 'PlayedRoles' then begin
    Result := IndexOfPlayedRole(Value as PUMLMessage);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLStimulus.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Activatees' then begin
    Result := Activatees[Index];
  end
  else if Name = 'PlayedRoles' then begin
    Result := PlayedRoles[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLStimulus.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Activatees' then begin
    Result := ActivateeCount;
  end
  else if Name = 'PlayedRoles' then begin
    Result := PlayedRoleCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLStimulus.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLAction') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;


function PUMLStimulus.CanRelocateTo(Model: PModel): Boolean;
begin
  Result := False;
end;

function PUMLStimulus.CanCopy: Boolean;
begin
  Result := False;
end;

function PUMLStimulus.CanPaste(Kind: string; CopyContext: string): Boolean;
begin
  Result := False;
end;

// PUMLStimulus
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLAttributeLink

constructor PUMLAttributeLink.Create;
begin
  inherited;
  FAttribute := nil;
  FValue_ := nil;
  FInstance := nil;
  FLinkEnd := nil;
end;

destructor PUMLAttributeLink.Destroy;
begin
  inherited;
end;

procedure PUMLAttributeLink.SetValueExpression(Value: string);
begin
  if FValueExpression <> Value then
    FValueExpression := Value;
end;

procedure PUMLAttributeLink.SetAttribute(Value: PUMLAttribute);
begin
  if FAttribute <> Value then begin
    if FAttribute <> nil then Attribute.FAttributeLinks.Remove(Self);
    FAttribute := Value;
    if Value <> nil then begin
      Value.FAttributeLinks.Add(Self);
    end;
  end;
end;

procedure PUMLAttributeLink.SetValue_(Value: PUMLInstance);
begin
  if FValue_ <> Value then begin
    if FValue_ <> nil then Value_.FAttributeLinks.Remove(Self);
    FValue_ := Value;
    if Value <> nil then begin
      Value.FAttributeLinks.Add(Self);
    end;
  end;
end;

procedure PUMLAttributeLink.SetInstance(Value: PUMLInstance);
begin
  if FInstance <> Value then begin
    if FInstance <> nil then begin
      FInstance.FSlots.Remove(Self);
      FInstance.RemoveVirtualOwnedModel(Self);
    end;
    FInstance := Value;
    if Value <> nil then begin
      Value.FSlots.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLAttributeLink.SetLinkEnd(Value: PUMLLinkEnd);
begin
  if FLinkEnd <> Value then begin
    if FLinkEnd <> nil then begin
      FLinkEnd.FQualifiedValues.Remove(Self);
      FLinkEnd.RemoveVirtualOwnedModel(Self);
    end;
    FLinkEnd := Value;
    if Value <> nil then begin
      Value.FQualifiedValues.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLAttributeLink.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'ValueExpression' then begin
    Result := ValueExpression;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLAttributeLink.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'ValueExpression' then begin
    ValueExpression := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLAttributeLink.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Attribute' then begin
    Result := Attribute;
  end
  else if Name = 'Value_' then begin
    Result := Value_;
  end
  else if Name = 'Instance' then begin
    Result := Instance;
  end
  else if Name = 'LinkEnd' then begin
    Result := LinkEnd;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLAttributeLink.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Attribute' then begin
    Attribute := Value as PUMLAttribute;
  end
  else if Name = 'Value_' then begin
    Value_ := Value as PUMLInstance;
  end
  else if Name = 'Instance' then begin
    Instance := Value as PUMLInstance;
  end
  else if Name = 'LinkEnd' then begin
    LinkEnd := Value as PUMLLinkEnd;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLAttributeLink.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLAttributeLink.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLAttributeLink.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLAttributeLink.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLAttributeLink.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLAttributeLink.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLAttributeLink.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLAttributeLink.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLAttributeLink
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLRelationship

constructor PUMLRelationship.Create;
begin
  inherited;
end;

destructor PUMLRelationship.Destroy;
begin
  inherited;
end;

function PUMLRelationship.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLRelationship.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLRelationship.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLRelationship.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLRelationship.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLRelationship.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLRelationship.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLRelationship.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLRelationship.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLRelationship.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLRelationship.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLRelationship.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLRelationship
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLGeneralization

constructor PUMLGeneralization.Create;
begin
  inherited;
  FChild := nil;
  FParent := nil;
  FPowertype := nil;
end;

destructor PUMLGeneralization.Destroy;
begin
  inherited;
end;

function PUMLGeneralization.FindRelatedModel(
  FirstElement: PModel): PModel;
begin
  if FirstElement = Parent then
    Result := Child
  else if FirstElement = Child then
    Result := Parent
  else
    Result := nil; // First element does not match
end;

procedure PUMLGeneralization.SetDiscriminator(Value: string);
begin
  if FDiscriminator <> Value then
    FDiscriminator := Value;
end;

procedure PUMLGeneralization.SetChild(Value: PUMLGeneralizableElement);
begin
  if FChild <> Value then begin
    if FChild <> nil then Child.FGeneralizations.Remove(Self);
    FChild := Value;
    if Value <> nil then begin
      Value.FGeneralizations.Add(Self);
    end;
  end;
end;

procedure PUMLGeneralization.SetParent(Value: PUMLGeneralizableElement);
begin
  if FParent <> Value then begin
    if FParent <> nil then Parent.FSpecializations.Remove(Self);
    FParent := Value;
    if Value <> nil then begin
      Value.FSpecializations.Add(Self);
    end;
  end;
end;

procedure PUMLGeneralization.SetPowertype(Value: PUMLClassifier);
begin
  if FPowertype <> Value then begin
    if FPowertype <> nil then Powertype.FPowertypeGeneralizations.Remove(Self);
    FPowertype := Value;
    if Value <> nil then begin
      Value.FPowertypeGeneralizations.Add(Self);
    end;
  end;
end;

function PUMLGeneralization.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Discriminator' then begin
    Result := Discriminator;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLGeneralization.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Discriminator' then begin
    Discriminator := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLGeneralization.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Child' then begin
    Result := Child;
  end
  else if Name = 'Parent' then begin
    Result := Parent;
  end
  else if Name = 'Powertype' then begin
    Result := Powertype;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLGeneralization.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Child' then begin
    Child := Value as PUMLGeneralizableElement;
  end
  else if Name = 'Parent' then begin
    Parent := Value as PUMLGeneralizableElement;
  end
  else if Name = 'Powertype' then begin
    Powertype := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLGeneralization.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLGeneralization.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLGeneralization.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLGeneralization.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLGeneralization.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLGeneralization.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLGeneralization.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLGeneralization.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLGeneralization
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLInclude

constructor PUMLInclude.Create;
begin
  inherited;
  FAddition := nil;
  FBase := nil;
end;

destructor PUMLInclude.Destroy;
begin
  inherited;
end;

function PUMLInclude.FindRelatedModel(FirstElement: PModel): PModel;
begin
 if FirstElement = Base then
    Result := Addition
  else if FirstElement = Addition then
    Result := Base
  else
    Result := nil; // First element does not match
end;

procedure PUMLInclude.SetAddition(Value: PUMLUseCase);
begin
  if FAddition <> Value then begin
    if FAddition <> nil then Addition.FIncluders.Remove(Self);
    FAddition := Value;
    if Value <> nil then begin
      Value.FIncluders.Add(Self);
    end;
  end;
end;

procedure PUMLInclude.SetBase(Value: PUMLUseCase);
begin
  if FBase <> Value then begin
    if FBase <> nil then Base.FIncludes.Remove(Self);
    FBase := Value;
    if Value <> nil then begin
      Value.FIncludes.Add(Self);
    end;
  end;
end;

function PUMLInclude.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLInclude.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLInclude.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Addition' then begin
    Result := Addition;
  end
  else if Name = 'Base' then begin
    Result := Base;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLInclude.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Addition' then begin
    Addition := Value as PUMLUseCase;
  end
  else if Name = 'Base' then begin
    Base := Value as PUMLUseCase;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLInclude.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLInclude.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLInclude.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLInclude.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLInclude.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLInclude.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLInclude.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLInclude.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLInclude
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLDependency

constructor PUMLDependency.Create;
begin
  inherited;
  FClient := nil;
  FSupplier := nil;
end;

destructor PUMLDependency.Destroy;
begin
  inherited;
end;

function PUMLDependency.FindRelatedModel(FirstElement: PModel): PModel;
begin
  if FirstElement = Supplier then
    Result := Client
  else if FirstElement = Client then
    Result := Supplier
  else
    Result := nil; // First element does not match
end;

procedure PUMLDependency.SetMapping(Value: string);
begin
  if FMapping <> Value then
    FMapping := Value;
end;

procedure PUMLDependency.SetClient(Value: PUMLModelElement);
begin
  if FClient <> Value then begin
    if FClient <> nil then Client.FClientDependencies.Remove(Self);
    FClient := Value;
    if Value <> nil then begin
      Value.FClientDependencies.Add(Self);
    end;
  end;
end;

procedure PUMLDependency.SetSupplier(Value: PUMLModelElement);
begin
  if FSupplier <> Value then begin
    if FSupplier <> nil then Supplier.FSupplierDependencies.Remove(Self);
    FSupplier := Value;
    if Value <> nil then begin
      Value.FSupplierDependencies.Add(Self);
    end;
  end;
end;

function PUMLDependency.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Mapping' then begin
    Result := Mapping;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLDependency.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Mapping' then begin
    Mapping := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLDependency.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Client' then begin
    Result := Client;
  end
  else if Name = 'Supplier' then begin
    Result := Supplier;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLDependency.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Client' then begin
    Client := Value as PUMLModelElement;
  end
  else if Name = 'Supplier' then begin
    Supplier := Value as PUMLModelElement;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLDependency.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLDependency.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLDependency.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLDependency.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLDependency.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLDependency.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLDependency.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLDependency.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLDependency
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLRealization

constructor PUMLRealization.Create;
begin
  inherited;
end;

destructor PUMLRealization.Destroy;
begin
  inherited;
end;

function PUMLRealization.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLRealization.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLRealization.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLRealization.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLRealization.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLRealization.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLRealization.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLRealization.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLRealization.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLRealization.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLRealization.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLRealization.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLRealization
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLExtend

constructor PUMLExtend.Create;
begin
  inherited;
  FBase := nil;
  FExtension := nil;
  FExtensionPoints := POrderedSet.Create;
end;

destructor PUMLExtend.Destroy;
begin
  FExtensionPoints.Free;
  inherited;
end;

function PUMLExtend.FindRelatedModel(FirstElement: PModel): PModel;
begin
  if FirstElement = Base then
    Result := Extension
  else if FirstElement = Extension then
    Result := Base
  else
    Result := nil; // First element does not match
end;

procedure PUMLExtend.SetCondition(Value: string);
begin
  if FCondition <> Value then
    FCondition := Value;
end;

procedure PUMLExtend.SetBase(Value: PUMLUseCase);
begin
  if FBase <> Value then begin
    if FBase <> nil then Base.FExtenders.Remove(Self);
    FBase := Value;
    if Value <> nil then begin
      Value.FExtenders.Add(Self);
    end;
  end;
end;

procedure PUMLExtend.SetExtension(Value: PUMLUseCase);
begin
  if FExtension <> Value then begin
    if FExtension <> nil then Extension.FExtends.Remove(Self);
    FExtension := Value;
    if Value <> nil then begin
      Value.FExtends.Add(Self);
    end;
  end;
end;

function PUMLExtend.GetExtensionPoint(Index: Integer): PUMLExtensionPoint;
begin
  Result := FExtensionPoints.Items[Index] as UMLModels.PUMLExtensionPoint;
end;

function PUMLExtend.GetExtensionPointCount: Integer;
begin
  Result := FExtensionPoints.Count;
end;

procedure PUMLExtend.ClearExtensionPoints;
var
  I: Integer;
begin
  for I := FExtensionPoints.Count - 1 downto 0 do
    DeleteExtensionPoint(I);
end;

procedure PUMLExtend.AddExtensionPoint(Value: PUMLExtensionPoint);
begin
  if Value <> nil then begin
    FExtensionPoints.Add(Value);
    Value.FExtends.Add(Self);
  end;
end;

procedure PUMLExtend.RemoveExtensionPoint(Value: PUMLExtensionPoint);
begin
  if Value <> nil then begin
    FExtensionPoints.Remove(Value);
    Value.FExtends.Remove(Self);
  end;
end;

procedure PUMLExtend.InsertExtensionPoint(Index: Integer; Value: PUMLExtensionPoint);
begin
  if Value <> nil then begin
    FExtensionPoints.Insert(Index, Value);
    Value.FExtends.Add(Self);
  end;
end;

procedure PUMLExtend.DeleteExtensionPoint(Index: Integer);
begin
  RemoveExtensionPoint(FExtensionPoints.Items[Index] as UMLModels.PUMLExtensionPoint);
end;

function PUMLExtend.IndexOfExtensionPoint(Value: PUMLExtensionPoint): Integer;
begin
  Result := FExtensionPoints.IndexOf(Value);
end;

function PUMLExtend.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Condition' then begin
    Result := Condition;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLExtend.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Condition' then begin
    Condition := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLExtend.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Base' then begin
    Result := Base;
  end
  else if Name = 'Extension' then begin
    Result := Extension;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLExtend.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Base' then begin
    Base := Value as PUMLUseCase;
  end
  else if Name = 'Extension' then begin
    Extension := Value as PUMLUseCase;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLExtend.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ExtensionPoints' then begin
    AddExtensionPoint(Value as PUMLExtensionPoint);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLExtend.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ExtensionPoints' then begin
    RemoveExtensionPoint(Value as PUMLExtensionPoint);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLExtend.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'ExtensionPoints' then begin
    InsertExtensionPoint(Index, Value as PUMLExtensionPoint);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLExtend.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'ExtensionPoints' then begin
    DeleteExtensionPoint(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLExtend.MOF_ClearCollection(Name: string);
begin
  if Name = 'ExtensionPoints' then begin
    ClearExtensionPoints;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLExtend.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'ExtensionPoints' then begin
    Result := IndexOfExtensionPoint(Value as PUMLExtensionPoint);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLExtend.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'ExtensionPoints' then begin
    Result := ExtensionPoints[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLExtend.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'ExtensionPoints' then begin
    Result := ExtensionPointCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLExtend
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLAssociation

constructor PUMLAssociation.Create;
begin
  inherited;
  FConnections := POrderedSet.Create;
  FAssociationClass := nil;
  FLinks := POrderedSet.Create;
  FAssociationRoles := POrderedSet.Create;
end;

destructor PUMLAssociation.Destroy;
begin
  FConnections.Free;
  FLinks.Free;
  FAssociationRoles.Free;
  inherited;
end;

function PUMLAssociation.FindRelatedModel(FirstElement: PModel): PModel;
begin
  if FirstElement = Connections[0].Participant then
    Result := Connections[1].Participant
  else if FirstElement = Connections[1].Participant then
    Result := Connections[0].Participant
  else
    Result := nil; // First element does not match
end;

function PUMLAssociation.GetConnection(Index: Integer): PUMLAssociationEnd;
begin
  Result := FConnections.Items[Index] as UMLModels.PUMLAssociationEnd;
end;

function PUMLAssociation.GetConnectionCount: Integer;
begin
  Result := FConnections.Count;
end;

procedure PUMLAssociation.SetAssociationClass(Value: PUMLAssociationClass);
begin
  if FAssociationClass <> Value then begin
    if FAssociationClass <> nil then AssociationClass.FAssociationSide := nil;
    FAssociationClass := Value;
    if Value <> nil then Value.FAssociationSide := Self;
  end;
end;

function PUMLAssociation.GetLink(Index: Integer): PUMLLink;
begin
  Result := FLinks.Items[Index] as UMLModels.PUMLLink;
end;

function PUMLAssociation.GetLinkCount: Integer;
begin
  Result := FLinks.Count;
end;

function PUMLAssociation.GetAssociationRole(Index: Integer): PUMLAssociationRole;
begin
  Result := FAssociationRoles.Items[Index] as UMLModels.PUMLAssociationRole;
end;

function PUMLAssociation.GetAssociationRoleCount: Integer;
begin
  Result := FAssociationRoles.Count;
end;

procedure PUMLAssociation.ClearConnections;
var
  I: Integer;
begin
  for I := FConnections.Count - 1 downto 0 do
    DeleteConnection(I);
end;

procedure PUMLAssociation.AddConnection(Value: PUMLAssociationEnd);
begin
  if Value <> nil then begin
    if Value.FAssociation <> nil then begin
      Value.FAssociation.FConnections.Remove(Value);
      Value.FAssociation.RemoveVirtualOwnedModel(Value);
    end;
    FConnections.Add(Value);
    Value.FAssociation := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLAssociation.RemoveConnection(Value: PUMLAssociationEnd);
begin
  if Value <> nil then begin
    FConnections.Remove(Value);
    Value.FAssociation := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLAssociation.InsertConnection(Index: Integer; Value: PUMLAssociationEnd);
begin
  if Value <> nil then begin
    if Value.FAssociation <> nil then begin
      Value.FAssociation.FConnections.Remove(Value);
      Value.FAssociation.RemoveVirtualOwnedModel(Value);
    end;
    FConnections.Insert(Index, Value);
    Value.FAssociation := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLAssociation.DeleteConnection(Index: Integer);
begin
  RemoveConnection(FConnections.Items[Index] as UMLModels.PUMLAssociationEnd);
end;

function PUMLAssociation.IndexOfConnection(Value: PUMLAssociationEnd): Integer;
begin
  Result := FConnections.IndexOf(Value);
end;

procedure PUMLAssociation.ClearLinks;
var
  I: Integer;
begin
  for I := FLinks.Count - 1 downto 0 do
    DeleteLink(I);
end;

procedure PUMLAssociation.AddLink(Value: PUMLLink);
begin
  if Value <> nil then begin
    if Value.FAssociation <> nil then Value.FAssociation.FLinks.Remove(Value);
    FLinks.Add(Value);
    Value.FAssociation := Self;
  end;
end;

procedure PUMLAssociation.RemoveLink(Value: PUMLLink);
begin
  if Value <> nil then begin
    FLinks.Remove(Value);
    Value.FAssociation := nil;
  end;
end;

procedure PUMLAssociation.InsertLink(Index: Integer; Value: PUMLLink);
begin
  if Value <> nil then begin
    if Value.FAssociation <> nil then Value.FAssociation.FLinks.Remove(Value);
    FLinks.Insert(Index, Value);
    Value.FAssociation := Self;
  end;
end;

procedure PUMLAssociation.DeleteLink(Index: Integer);
begin
  RemoveLink(FLinks.Items[Index] as UMLModels.PUMLLink);
end;

function PUMLAssociation.IndexOfLink(Value: PUMLLink): Integer;
begin
  Result := FLinks.IndexOf(Value);
end;

procedure PUMLAssociation.ClearAssociationRoles;
var
  I: Integer;
begin
  for I := FAssociationRoles.Count - 1 downto 0 do
    DeleteAssociationRole(I);
end;

procedure PUMLAssociation.AddAssociationRole(Value: PUMLAssociationRole);
begin
  if Value <> nil then begin
    if Value.FBase <> nil then Value.FBase.FAssociationRoles.Remove(Value);
    FAssociationRoles.Add(Value);
    Value.FBase := Self;
  end;
end;

procedure PUMLAssociation.RemoveAssociationRole(Value: PUMLAssociationRole);
begin
  if Value <> nil then begin
    FAssociationRoles.Remove(Value);
    Value.FBase := nil;
  end;
end;

procedure PUMLAssociation.InsertAssociationRole(Index: Integer; Value: PUMLAssociationRole);
begin
  if Value <> nil then begin
    if Value.FBase <> nil then Value.FBase.FAssociationRoles.Remove(Value);
    FAssociationRoles.Insert(Index, Value);
    Value.FBase := Self;
  end;
end;

procedure PUMLAssociation.DeleteAssociationRole(Index: Integer);
begin
  RemoveAssociationRole(FAssociationRoles.Items[Index] as UMLModels.PUMLAssociationRole);
end;

function PUMLAssociation.IndexOfAssociationRole(Value: PUMLAssociationRole): Integer;
begin
  Result := FAssociationRoles.IndexOf(Value);
end;

function PUMLAssociation.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLAssociation.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLAssociation.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'AssociationClass' then begin
    Result := AssociationClass;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLAssociation.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'AssociationClass' then begin
    AssociationClass := Value as PUMLAssociationClass;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLAssociation.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Connections' then begin
    AddConnection(Value as PUMLAssociationEnd);
  end
  else if Name = 'Links' then begin
    AddLink(Value as PUMLLink);
  end
  else if Name = 'AssociationRoles' then begin
    AddAssociationRole(Value as PUMLAssociationRole);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLAssociation.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Connections' then begin
    RemoveConnection(Value as PUMLAssociationEnd);
  end
  else if Name = 'Links' then begin
    RemoveLink(Value as PUMLLink);
  end
  else if Name = 'AssociationRoles' then begin
    RemoveAssociationRole(Value as PUMLAssociationRole);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLAssociation.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Connections' then begin
    InsertConnection(Index, Value as PUMLAssociationEnd);
  end
  else if Name = 'Links' then begin
    InsertLink(Index, Value as PUMLLink);
  end
  else if Name = 'AssociationRoles' then begin
    InsertAssociationRole(Index, Value as PUMLAssociationRole);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLAssociation.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Connections' then begin
    DeleteConnection(Index);
  end
  else if Name = 'Links' then begin
    DeleteLink(Index);
  end
  else if Name = 'AssociationRoles' then begin
    DeleteAssociationRole(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLAssociation.MOF_ClearCollection(Name: string);
begin
  if Name = 'Connections' then begin
    ClearConnections;
  end
  else if Name = 'Links' then begin
    ClearLinks;
  end
  else if Name = 'AssociationRoles' then begin
    ClearAssociationRoles;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLAssociation.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Connections' then begin
    Result := IndexOfConnection(Value as PUMLAssociationEnd);
  end
  else if Name = 'Links' then begin
    Result := IndexOfLink(Value as PUMLLink);
  end
  else if Name = 'AssociationRoles' then begin
    Result := IndexOfAssociationRole(Value as PUMLAssociationRole);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLAssociation.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Connections' then begin
    Result := Connections[Index];
  end
  else if Name = 'Links' then begin
    Result := Links[Index];
  end
  else if Name = 'AssociationRoles' then begin
    Result := AssociationRoles[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLAssociation.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Connections' then begin
    Result := ConnectionCount;
  end
  else if Name = 'Links' then begin
    Result := LinkCount;
  end
  else if Name = 'AssociationRoles' then begin
    Result := AssociationRoleCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLAssociation
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLAssociationRole

constructor PUMLAssociationRole.Create;
begin
  inherited;
  FBase := nil;
  FMessages := POrderedSet.Create;
  FConformingLinks := POrderedSet.Create;
end;

destructor PUMLAssociationRole.Destroy;
begin
  FMessages.Free;
  FConformingLinks.Free;
  inherited;
end;

procedure PUMLAssociationRole.SetMultiplicity(Value: string);
begin
  if FMultiplicity <> Value then
    FMultiplicity := Value;
end;

procedure PUMLAssociationRole.SetBase(Value: PUMLAssociation);
begin
  if FBase <> Value then begin
    if FBase <> nil then Base.FAssociationRoles.Remove(Self);
    FBase := Value;
    if Value <> nil then begin
      Value.FAssociationRoles.Add(Self);
    end;
  end;
end;

function PUMLAssociationRole.GetMessage(Index: Integer): PUMLMessage;
begin
  Result := FMessages.Items[Index] as UMLModels.PUMLMessage;
end;

function PUMLAssociationRole.GetMessageCount: Integer;
begin
  Result := FMessages.Count;
end;

function PUMLAssociationRole.GetConformingLink(Index: Integer): PUMLLink;
begin
  Result := FConformingLinks.Items[Index] as UMLModels.PUMLLink;
end;

function PUMLAssociationRole.GetConformingLinkCount: Integer;
begin
  Result := FConformingLinks.Count;
end;

procedure PUMLAssociationRole.ClearMessages;
var
  I: Integer;
begin
  for I := FMessages.Count - 1 downto 0 do
    DeleteMessage(I);
end;

procedure PUMLAssociationRole.AddMessage(Value: PUMLMessage);
begin
  if Value <> nil then begin
    if Value.FCommunicationConnection <> nil then Value.FCommunicationConnection.FMessages.Remove(Value);
    FMessages.Add(Value);
    Value.FCommunicationConnection := Self;
  end;
end;

procedure PUMLAssociationRole.RemoveMessage(Value: PUMLMessage);
begin
  if Value <> nil then begin
    FMessages.Remove(Value);
    Value.FCommunicationConnection := nil;
  end;
end;

procedure PUMLAssociationRole.InsertMessage(Index: Integer; Value: PUMLMessage);
begin
  if Value <> nil then begin
    if Value.FCommunicationConnection <> nil then Value.FCommunicationConnection.FMessages.Remove(Value);
    FMessages.Insert(Index, Value);
    Value.FCommunicationConnection := Self;
  end;
end;

procedure PUMLAssociationRole.DeleteMessage(Index: Integer);
begin
  RemoveMessage(FMessages.Items[Index] as UMLModels.PUMLMessage);
end;

function PUMLAssociationRole.IndexOfMessage(Value: PUMLMessage): Integer;
begin
  Result := FMessages.IndexOf(Value);
end;

procedure PUMLAssociationRole.ClearConformingLinks;
var
  I: Integer;
begin
  for I := FConformingLinks.Count - 1 downto 0 do
    DeleteConformingLink(I);
end;

procedure PUMLAssociationRole.AddConformingLink(Value: PUMLLink);
begin
  if Value <> nil then begin
    FConformingLinks.Add(Value);
    Value.FPlayedRoles.Add(Self);
  end;
end;

procedure PUMLAssociationRole.RemoveConformingLink(Value: PUMLLink);
begin
  if Value <> nil then begin
    FConformingLinks.Remove(Value);
    Value.FPlayedRoles.Remove(Self);
  end;
end;

procedure PUMLAssociationRole.InsertConformingLink(Index: Integer; Value: PUMLLink);
begin
  if Value <> nil then begin
    FConformingLinks.Insert(Index, Value);
    Value.FPlayedRoles.Add(Self);
  end;
end;

procedure PUMLAssociationRole.DeleteConformingLink(Index: Integer);
begin
  RemoveConformingLink(FConformingLinks.Items[Index] as UMLModels.PUMLLink);
end;

function PUMLAssociationRole.IndexOfConformingLink(Value: PUMLLink): Integer;
begin
  Result := FConformingLinks.IndexOf(Value);
end;

function PUMLAssociationRole.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Multiplicity' then begin
    Result := Multiplicity;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLAssociationRole.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Multiplicity' then begin
    Multiplicity := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLAssociationRole.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Base' then begin
    Result := Base;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLAssociationRole.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Base' then begin
    Base := Value as PUMLAssociation;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLAssociationRole.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Messages' then begin
    AddMessage(Value as PUMLMessage);
  end
  else if Name = 'ConformingLinks' then begin
    AddConformingLink(Value as PUMLLink);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLAssociationRole.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Messages' then begin
    RemoveMessage(Value as PUMLMessage);
  end
  else if Name = 'ConformingLinks' then begin
    RemoveConformingLink(Value as PUMLLink);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLAssociationRole.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Messages' then begin
    InsertMessage(Index, Value as PUMLMessage);
  end
  else if Name = 'ConformingLinks' then begin
    InsertConformingLink(Index, Value as PUMLLink);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLAssociationRole.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Messages' then begin
    DeleteMessage(Index);
  end
  else if Name = 'ConformingLinks' then begin
    DeleteConformingLink(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLAssociationRole.MOF_ClearCollection(Name: string);
begin
  if Name = 'Messages' then begin
    ClearMessages;
  end
  else if Name = 'ConformingLinks' then begin
    ClearConformingLinks;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLAssociationRole.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Messages' then begin
    Result := IndexOfMessage(Value as PUMLMessage);
  end
  else if Name = 'ConformingLinks' then begin
    Result := IndexOfConformingLink(Value as PUMLLink);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLAssociationRole.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Messages' then begin
    Result := Messages[Index];
  end
  else if Name = 'ConformingLinks' then begin
    Result := ConformingLinks[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLAssociationRole.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Messages' then begin
    Result := MessageCount;
  end
  else if Name = 'ConformingLinks' then begin
    Result := ConformingLinkCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLAssociationRole.CanRelocateTo(Model: PModel): Boolean;
begin
  Result := False;
end;

// PUMLAssociationRole
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLAction

constructor PUMLAction.Create;
begin
  inherited;
  FActualArguments := POrderedSet.Create;
  FActionSequence := nil;
  FStimulus := nil;
  FEntryState := nil;
  FExitState := nil;
  FTransition := nil;
  FDoActivityState := nil;
  FMessage := nil;
end;

destructor PUMLAction.Destroy;
begin
  FActualArguments.Free;
  inherited;
end;

procedure PUMLAction.SetRecurrence(Value: string);
begin
  if FRecurrence <> Value then
    FRecurrence := Value;
end;

procedure PUMLAction.SetTarget(Value: string);
begin
  if FTarget <> Value then
    FTarget := Value;
end;

procedure PUMLAction.SetIsAsynchronous(Value: Boolean);
begin
  if FIsAsynchronous <> Value then
    FIsAsynchronous := Value;
end;

procedure PUMLAction.SetScript(Value: string);
begin
  if FScript <> Value then
    FScript := Value;
end;

function PUMLAction.GetActualArgument(Index: Integer): PUMLArgument;
begin
  Result := FActualArguments.Items[Index] as UMLModels.PUMLArgument;
end;

function PUMLAction.GetActualArgumentCount: Integer;
begin
  Result := FActualArguments.Count;
end;

procedure PUMLAction.SetActionSequence(Value: PUMLActionSequence);
begin
  if FActionSequence <> Value then begin
    if FActionSequence <> nil then begin
      FActionSequence.FActions.Remove(Self);
      FActionSequence.RemoveVirtualOwnedModel(Self);
    end;
    FActionSequence := Value;
    if Value <> nil then begin
      Value.FActions.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLAction.SetStimulus(Value: PUMLStimulus);
begin
  if FStimulus <> Value then begin
    if FStimulus <> nil then begin
      Stimulus.RemoveVirtualOwnedModel(Stimulus.FAction);
      Stimulus.FAction := nil;
    end;
    FStimulus := Value;
    if Value <> nil then begin
      Value.FAction := Self;
      Stimulus.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLAction.SetEntryState(Value: PUMLState);
begin
  if FEntryState <> Value then begin
    if FEntryState <> nil then begin
      FEntryState.FEntryActions.Remove(Self);
      FEntryState.RemoveVirtualOwnedModel(Self);
    end;
    FEntryState := Value;
    if Value <> nil then begin
      Value.FEntryActions.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLAction.SetExitState(Value: PUMLState);
begin
  if FExitState <> Value then begin
    if FExitState <> nil then begin
      FExitState.FExitActions.Remove(Self);
      FExitState.RemoveVirtualOwnedModel(Self);
    end;
    FExitState := Value;
    if Value <> nil then begin
      Value.FExitActions.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLAction.SetTransition(Value: PUMLTransition);
begin
  if FTransition <> Value then begin
    if FTransition <> nil then begin
      FTransition.FEffects.Remove(Self);
      FTransition.RemoveVirtualOwnedModel(Self);
    end;
    FTransition := Value;
    if Value <> nil then begin
      Value.FEffects.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLAction.SetDoActivityState(Value: PUMLState);
begin
  if FDoActivityState <> Value then begin
    if FDoActivityState <> nil then begin
      FDoActivityState.FDoActivities.Remove(Self);
      FDoActivityState.RemoveVirtualOwnedModel(Self);
    end;
    FDoActivityState := Value;
    if Value <> nil then begin
      Value.FDoActivities.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLAction.SetMessage(Value: PUMLMessage);
begin
  if FMessage <> Value then begin
    if FMessage <> nil then begin
      Message.RemoveVirtualOwnedModel(Message.FAction);
      Message.FAction := nil;
    end;
    FMessage := Value;
    if Value <> nil then begin
      Value.FAction := Self;
      Message.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLAction.ClearActualArguments;
var
  I: Integer;
begin
  for I := FActualArguments.Count - 1 downto 0 do
    DeleteActualArgument(I);
end;

procedure PUMLAction.AddActualArgument(Value: PUMLArgument);
begin
  if Value <> nil then begin
    if Value.FAction <> nil then begin
      Value.FAction.FActualArguments.Remove(Value);
      Value.FAction.RemoveVirtualOwnedModel(Value);
    end;
    FActualArguments.Add(Value);
    Value.FAction := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLAction.RemoveActualArgument(Value: PUMLArgument);
begin
  if Value <> nil then begin
    FActualArguments.Remove(Value);
    Value.FAction := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLAction.InsertActualArgument(Index: Integer; Value: PUMLArgument);
begin
  if Value <> nil then begin
    if Value.FAction <> nil then begin
      Value.FAction.FActualArguments.Remove(Value);
      Value.FAction.RemoveVirtualOwnedModel(Value);
    end;
    FActualArguments.Insert(Index, Value);
    Value.FAction := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLAction.DeleteActualArgument(Index: Integer);
begin
  RemoveActualArgument(FActualArguments.Items[Index] as UMLModels.PUMLArgument);
end;

function PUMLAction.IndexOfActualArgument(Value: PUMLArgument): Integer;
begin
  Result := FActualArguments.IndexOf(Value);
end;

function PUMLAction.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Recurrence' then begin
    Result := Recurrence;
  end
  else if Name = 'Target' then begin
    Result := Target;
  end
  else if Name = 'IsAsynchronous' then begin
    Result := BooleanToString(IsAsynchronous);
  end
  else if Name = 'Script' then begin
    Result := Script;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLAction.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Recurrence' then begin
    Recurrence := Value;
  end
  else if Name = 'Target' then begin
    Target := Value;
  end
  else if Name = 'IsAsynchronous' then begin
    IsAsynchronous := StringToBoolean(Value);
  end
  else if Name = 'Script' then begin
    Script := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLAction.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'ActionSequence' then begin
    Result := ActionSequence;
  end
  else if Name = 'Stimulus' then begin
    Result := Stimulus;
  end
  else if Name = 'EntryState' then begin
    Result := EntryState;
  end
  else if Name = 'ExitState' then begin
    Result := ExitState;
  end
  else if Name = 'Transition' then begin
    Result := Transition;
  end
  else if Name = 'DoActivityState' then begin
    Result := DoActivityState;
  end
  else if Name = 'Message' then begin
    Result := Message;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLAction.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'ActionSequence' then begin
    ActionSequence := Value as PUMLActionSequence;
  end
  else if Name = 'Stimulus' then begin
    Stimulus := Value as PUMLStimulus;
  end
  else if Name = 'EntryState' then begin
    EntryState := Value as PUMLState;
  end
  else if Name = 'ExitState' then begin
    ExitState := Value as PUMLState;
  end
  else if Name = 'Transition' then begin
    Transition := Value as PUMLTransition;
  end
  else if Name = 'DoActivityState' then begin
    DoActivityState := Value as PUMLState;
  end
  else if Name = 'Message' then begin
    Message := Value as PUMLMessage;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLAction.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ActualArguments' then begin
    AddActualArgument(Value as PUMLArgument);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLAction.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'ActualArguments' then begin
    RemoveActualArgument(Value as PUMLArgument);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLAction.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'ActualArguments' then begin
    InsertActualArgument(Index, Value as PUMLArgument);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLAction.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'ActualArguments' then begin
    DeleteActualArgument(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLAction.MOF_ClearCollection(Name: string);
begin
  if Name = 'ActualArguments' then begin
    ClearActualArguments;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLAction.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'ActualArguments' then begin
    Result := IndexOfActualArgument(Value as PUMLArgument);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLAction.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'ActualArguments' then begin
    Result := ActualArguments[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLAction.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'ActualArguments' then begin
    Result := ActualArgumentCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLAction.CanContainKind(Kind: string): Boolean;
begin
  Result := False;
end;

function PUMLAction.CanRelocateTo(Model: PModel): Boolean;
begin
  Result := False;
end;

function PUMLAction.CanCopy: Boolean;
begin
  Result := False;
end;

function PUMLAction.CanDelete: Boolean;
begin
  if (Message <> nil) or (Stimulus <> nil) then
    Result := False
  else
    Result := inherited CanDelete;
end;

// PUMLAction
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLTerminateAction

constructor PUMLTerminateAction.Create;
begin
  inherited;
end;

destructor PUMLTerminateAction.Destroy;
begin
  inherited;
end;

function PUMLTerminateAction.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLTerminateAction.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLTerminateAction.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLTerminateAction.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLTerminateAction.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLTerminateAction.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLTerminateAction.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLTerminateAction.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLTerminateAction.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLTerminateAction.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLTerminateAction.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLTerminateAction.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLTerminateAction
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSendAction

constructor PUMLSendAction.Create;
begin
  inherited;
  FSignal := nil;
end;

destructor PUMLSendAction.Destroy;
begin
  inherited;
end;

procedure PUMLSendAction.SetSignal(Value: PUMLSignal);
begin
  if FSignal <> Value then begin
    if FSignal <> nil then Signal.FSendActions.Remove(Self);
    FSignal := Value;
    if Value <> nil then begin
      Value.FSendActions.Add(Self);
    end;
  end;
end;

function PUMLSendAction.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLSendAction.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLSendAction.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Signal' then begin
    Result := Signal;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLSendAction.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Signal' then begin
    Signal := Value as PUMLSignal;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLSendAction.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLSendAction.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLSendAction.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLSendAction.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLSendAction.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLSendAction.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLSendAction.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLSendAction.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLSendAction
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLActionSequence

constructor PUMLActionSequence.Create;
begin
  inherited;
  FActions := POrderedSet.Create;
end;

destructor PUMLActionSequence.Destroy;
begin
  FActions.Free;
  inherited;
end;

function PUMLActionSequence.GetAction(Index: Integer): PUMLAction;
begin
  Result := FActions.Items[Index] as UMLModels.PUMLAction;
end;

function PUMLActionSequence.GetActionCount: Integer;
begin
  Result := FActions.Count;
end;

procedure PUMLActionSequence.ClearActions;
var
  I: Integer;
begin
  for I := FActions.Count - 1 downto 0 do
    DeleteAction(I);
end;

procedure PUMLActionSequence.AddAction(Value: PUMLAction);
begin
  if Value <> nil then begin
    if Value.FActionSequence <> nil then begin
      Value.FActionSequence.FActions.Remove(Value);
      Value.FActionSequence.RemoveVirtualOwnedModel(Value);
    end;
    FActions.Add(Value);
    Value.FActionSequence := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLActionSequence.RemoveAction(Value: PUMLAction);
begin
  if Value <> nil then begin
    FActions.Remove(Value);
    Value.FActionSequence := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLActionSequence.InsertAction(Index: Integer; Value: PUMLAction);
begin
  if Value <> nil then begin
    if Value.FActionSequence <> nil then begin
      Value.FActionSequence.FActions.Remove(Value);
      Value.FActionSequence.RemoveVirtualOwnedModel(Value);
    end;
    FActions.Insert(Index, Value);
    Value.FActionSequence := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLActionSequence.DeleteAction(Index: Integer);
begin
  RemoveAction(FActions.Items[Index] as UMLModels.PUMLAction);
end;

function PUMLActionSequence.IndexOfAction(Value: PUMLAction): Integer;
begin
  Result := FActions.IndexOf(Value);
end;

function PUMLActionSequence.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLActionSequence.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLActionSequence.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLActionSequence.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLActionSequence.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Actions' then begin
    AddAction(Value as PUMLAction);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLActionSequence.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Actions' then begin
    RemoveAction(Value as PUMLAction);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLActionSequence.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Actions' then begin
    InsertAction(Index, Value as PUMLAction);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLActionSequence.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Actions' then begin
    DeleteAction(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLActionSequence.MOF_ClearCollection(Name: string);
begin
  if Name = 'Actions' then begin
    ClearActions;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLActionSequence.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Actions' then begin
    Result := IndexOfAction(Value as PUMLAction);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLActionSequence.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Actions' then begin
    Result := Actions[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLActionSequence.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Actions' then begin
    Result := ActionCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLActionSequence
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLCreateAction

constructor PUMLCreateAction.Create;
begin
  inherited;
  FInstantiation := nil;
end;

destructor PUMLCreateAction.Destroy;
begin
  inherited;
end;

procedure PUMLCreateAction.SetInstantiation(Value: PUMLClassifier);
begin
  if FInstantiation <> Value then begin
    if FInstantiation <> nil then Instantiation.FCreateActions.Remove(Self);
    FInstantiation := Value;
    if Value <> nil then begin
      Value.FCreateActions.Add(Self);
    end;
  end;
end;

function PUMLCreateAction.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLCreateAction.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLCreateAction.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Instantiation' then begin
    Result := Instantiation;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLCreateAction.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Instantiation' then begin
    Instantiation := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLCreateAction.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLCreateAction.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLCreateAction.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLCreateAction.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLCreateAction.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLCreateAction.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLCreateAction.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLCreateAction.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLCreateAction
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLDestroyAction

constructor PUMLDestroyAction.Create;
begin
  inherited;
end;

destructor PUMLDestroyAction.Destroy;
begin
  inherited;
end;

function PUMLDestroyAction.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLDestroyAction.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLDestroyAction.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLDestroyAction.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLDestroyAction.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLDestroyAction.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLDestroyAction.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLDestroyAction.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLDestroyAction.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLDestroyAction.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLDestroyAction.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLDestroyAction.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLDestroyAction
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLUninterpretedAction

constructor PUMLUninterpretedAction.Create;
begin
  inherited;
end;

destructor PUMLUninterpretedAction.Destroy;
begin
  inherited;
end;

function PUMLUninterpretedAction.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLUninterpretedAction.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLUninterpretedAction.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLUninterpretedAction.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLUninterpretedAction.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLUninterpretedAction.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLUninterpretedAction.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLUninterpretedAction.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLUninterpretedAction.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLUninterpretedAction.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLUninterpretedAction.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLUninterpretedAction.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLUninterpretedAction
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLCallAction

constructor PUMLCallAction.Create;
begin
  inherited;
  FOperation := nil;
end;

destructor PUMLCallAction.Destroy;
begin
  inherited;
end;

procedure PUMLCallAction.SetOperation(Value: PUMLOperation);
begin
  if FOperation <> Value then begin
    if FOperation <> nil then Operation.FCallActions.Remove(Self);
    FOperation := Value;
    if Value <> nil then begin
      Value.FCallActions.Add(Self);
    end;
  end;
end;

function PUMLCallAction.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLCallAction.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLCallAction.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Operation' then begin
    Result := Operation;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLCallAction.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Operation' then begin
    Operation := Value as PUMLOperation;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLCallAction.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLCallAction.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLCallAction.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLCallAction.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLCallAction.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLCallAction.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLCallAction.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLCallAction.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLCallAction
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLReturnAction

constructor PUMLReturnAction.Create;
begin
  inherited;
end;

destructor PUMLReturnAction.Destroy;
begin
  inherited;
end;

function PUMLReturnAction.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLReturnAction.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLReturnAction.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLReturnAction.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLReturnAction.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLReturnAction.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLReturnAction.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLReturnAction.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLReturnAction.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLReturnAction.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLReturnAction.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLReturnAction.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLReturnAction
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLFrame

constructor PUMLFrame.Create;
begin
  inherited;
  FRepresentedElement := nil;
  FInteraction := nil;
  FInteractionInstanceSet := nil;
end;

destructor PUMLFrame.Destroy;
begin
  inherited;
end;

procedure PUMLFrame.SetFrameKind(Value: string);
begin
  if FFrameKind <> Value then
    FFrameKind := Value;
end;

procedure PUMLFrame.SetRepresentedElement(Value: PUMLModelElement);
begin
  if FRepresentedElement <> Value then begin
    if FRepresentedElement <> nil then RepresentedElement.FFrames.Remove(Self);
    FRepresentedElement := Value;
    if Value <> nil then begin
      Value.FFrames.Add(Self);
    end;
  end;
end;

procedure PUMLFrame.SetInteraction(Value: PUMLInteraction);
begin
  if FInteraction <> Value then begin
    if FInteraction <> nil then begin
      FInteraction.FOwnedFrames.Remove(Self);
      FInteraction.RemoveVirtualOwnedModel(Self);
    end;
    FInteraction := Value;
    if Value <> nil then begin
      Value.FOwnedFrames.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLFrame.SetInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
begin
  if FInteractionInstanceSet <> Value then begin
    if FInteractionInstanceSet <> nil then begin
      FInteractionInstanceSet.FOwnedFrames.Remove(Self);
      FInteractionInstanceSet.RemoveVirtualOwnedModel(Self);
    end;
    FInteractionInstanceSet := Value;
    if Value <> nil then begin
      Value.FOwnedFrames.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLFrame.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'FrameKind' then begin
    Result := FrameKind;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLFrame.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'FrameKind' then begin
    FrameKind := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLFrame.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'RepresentedElement' then begin
    Result := RepresentedElement;
  end
  else if Name = 'Interaction' then begin
    Result := Interaction;
  end
  else if Name = 'InteractionInstanceSet' then begin
    Result := InteractionInstanceSet;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLFrame.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'RepresentedElement' then begin
    RepresentedElement := Value as PUMLModelElement;
  end
  else if Name = 'Interaction' then begin
    Interaction := Value as PUMLInteraction;
  end
  else if Name = 'InteractionInstanceSet' then begin
    InteractionInstanceSet := Value as PUMLInteractionInstanceSet;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLFrame.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLFrame.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLFrame.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLFrame.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLFrame.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLFrame.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLFrame.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLFrame.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLFrame
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLCollaborationInstanceSet

constructor PUMLCollaborationInstanceSet.Create;
begin
  inherited;
  FInteractionInstanceSets := POrderedSet.Create;
  FCollaboration := nil;
  FParticipatingInstances := POrderedSet.Create;
  FParticipatingLinks := POrderedSet.Create;
  FRepresentedOperation := nil;
  FRepresentedClassifier := nil;
end;

destructor PUMLCollaborationInstanceSet.Destroy;
begin
  FInteractionInstanceSets.Free;
  FParticipatingInstances.Free;
  FParticipatingLinks.Free;
  inherited;
end;

function PUMLCollaborationInstanceSet.GetInteractionInstanceSet(Index: Integer): PUMLInteractionInstanceSet;
begin
  Result := FInteractionInstanceSets.Items[Index] as UMLModels.PUMLInteractionInstanceSet;
end;

function PUMLCollaborationInstanceSet.GetInteractionInstanceSetCount: Integer;
begin
  Result := FInteractionInstanceSets.Count;
end;

procedure PUMLCollaborationInstanceSet.SetCollaboration(Value: PUMLCollaboration);
begin
  if FCollaboration <> Value then begin
    if FCollaboration <> nil then Collaboration.FCollaborationInstanceSets.Remove(Self);
    FCollaboration := Value;
    if Value <> nil then begin
      Value.FCollaborationInstanceSets.Add(Self);
    end;
  end;
end;

function PUMLCollaborationInstanceSet.GetParticipatingInstance(Index: Integer): PUMLInstance;
begin
  Result := FParticipatingInstances.Items[Index] as UMLModels.PUMLInstance;
end;

function PUMLCollaborationInstanceSet.GetParticipatingInstanceCount: Integer;
begin
  Result := FParticipatingInstances.Count;
end;

function PUMLCollaborationInstanceSet.GetParticipatingLink(Index: Integer): PUMLLink;
begin
  Result := FParticipatingLinks.Items[Index] as UMLModels.PUMLLink;
end;

function PUMLCollaborationInstanceSet.GetParticipatingLinkCount: Integer;
begin
  Result := FParticipatingLinks.Count;
end;

procedure PUMLCollaborationInstanceSet.SetRepresentedOperation(Value: PUMLOperation);
begin
  if FRepresentedOperation <> Value then begin
    if FRepresentedOperation <> nil then begin
      FRepresentedOperation.FOwnedCollaborationInstanceSets.Remove(Self);
      FRepresentedOperation.RemoveVirtualOwnedModel(Self);
    end;
    FRepresentedOperation := Value;
    if Value <> nil then begin
      Value.FOwnedCollaborationInstanceSets.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLCollaborationInstanceSet.SetRepresentedClassifier(Value: PUMLClassifier);
begin
  if FRepresentedClassifier <> Value then begin
    if FRepresentedClassifier <> nil then begin
      FRepresentedClassifier.FOwnedCollaborationInstanceSets.Remove(Self);
      FRepresentedClassifier.RemoveVirtualOwnedModel(Self);
    end;
    FRepresentedClassifier := Value;
    if Value <> nil then begin
      Value.FOwnedCollaborationInstanceSets.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLCollaborationInstanceSet.ClearInteractionInstanceSets;
var
  I: Integer;
begin
  for I := FInteractionInstanceSets.Count - 1 downto 0 do
    DeleteInteractionInstanceSet(I);
end;

procedure PUMLCollaborationInstanceSet.AddInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
begin
  if Value <> nil then begin
    if Value.FContext <> nil then begin
      Value.FContext.FInteractionInstanceSets.Remove(Value);
      Value.FContext.RemoveVirtualOwnedModel(Value);
    end;
    FInteractionInstanceSets.Add(Value);
    Value.FContext := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.RemoveInteractionInstanceSet(Value: PUMLInteractionInstanceSet);
begin
  if Value <> nil then begin
    FInteractionInstanceSets.Remove(Value);
    Value.FContext := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.InsertInteractionInstanceSet(Index: Integer; Value: PUMLInteractionInstanceSet);
begin
  if Value <> nil then begin
    if Value.FContext <> nil then begin
      Value.FContext.FInteractionInstanceSets.Remove(Value);
      Value.FContext.RemoveVirtualOwnedModel(Value);
    end;
    FInteractionInstanceSets.Insert(Index, Value);
    Value.FContext := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.DeleteInteractionInstanceSet(Index: Integer);
begin
  RemoveInteractionInstanceSet(FInteractionInstanceSets.Items[Index] as UMLModels.PUMLInteractionInstanceSet);
end;

function PUMLCollaborationInstanceSet.IndexOfInteractionInstanceSet(Value: PUMLInteractionInstanceSet): Integer;
begin
  Result := FInteractionInstanceSets.IndexOf(Value);
end;

procedure PUMLCollaborationInstanceSet.ClearParticipatingInstances;
var
  I: Integer;
begin
  for I := FParticipatingInstances.Count - 1 downto 0 do
    DeleteParticipatingInstance(I);
end;

procedure PUMLCollaborationInstanceSet.AddParticipatingInstance(Value: PUMLInstance);
begin
  if Value <> nil then begin
    if Value.FCollaborationInstanceSet <> nil then begin
      Value.FCollaborationInstanceSet.FParticipatingInstances.Remove(Value);
      Value.FCollaborationInstanceSet.RemoveVirtualOwnedModel(Value);
    end;
    FParticipatingInstances.Add(Value);
    Value.FCollaborationInstanceSet := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.RemoveParticipatingInstance(Value: PUMLInstance);
begin
  if Value <> nil then begin
    FParticipatingInstances.Remove(Value);
    Value.FCollaborationInstanceSet := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.InsertParticipatingInstance(Index: Integer; Value: PUMLInstance);
begin
  if Value <> nil then begin
    if Value.FCollaborationInstanceSet <> nil then begin
      Value.FCollaborationInstanceSet.FParticipatingInstances.Remove(Value);
      Value.FCollaborationInstanceSet.RemoveVirtualOwnedModel(Value);
    end;
    FParticipatingInstances.Insert(Index, Value);
    Value.FCollaborationInstanceSet := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.DeleteParticipatingInstance(Index: Integer);
begin
  RemoveParticipatingInstance(FParticipatingInstances.Items[Index] as UMLModels.PUMLInstance);
end;

function PUMLCollaborationInstanceSet.IndexOfParticipatingInstance(Value: PUMLInstance): Integer;
begin
  Result := FParticipatingInstances.IndexOf(Value);
end;

procedure PUMLCollaborationInstanceSet.ClearParticipatingLinks;
var
  I: Integer;
begin
  for I := FParticipatingLinks.Count - 1 downto 0 do
    DeleteParticipatingLink(I);
end;

procedure PUMLCollaborationInstanceSet.AddParticipatingLink(Value: PUMLLink);
begin
  if Value <> nil then begin
    if Value.FCollaborationInstanceSet <> nil then begin
      Value.FCollaborationInstanceSet.FParticipatingLinks.Remove(Value);
      Value.FCollaborationInstanceSet.RemoveVirtualOwnedModel(Value);
    end;
    FParticipatingLinks.Add(Value);
    Value.FCollaborationInstanceSet := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.RemoveParticipatingLink(Value: PUMLLink);
begin
  if Value <> nil then begin
    FParticipatingLinks.Remove(Value);
    Value.FCollaborationInstanceSet := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.InsertParticipatingLink(Index: Integer; Value: PUMLLink);
begin
  if Value <> nil then begin
    if Value.FCollaborationInstanceSet <> nil then begin
      Value.FCollaborationInstanceSet.FParticipatingLinks.Remove(Value);
      Value.FCollaborationInstanceSet.RemoveVirtualOwnedModel(Value);
    end;
    FParticipatingLinks.Insert(Index, Value);
    Value.FCollaborationInstanceSet := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.DeleteParticipatingLink(Index: Integer);
begin
  RemoveParticipatingLink(FParticipatingLinks.Items[Index] as UMLModels.PUMLLink);
end;

function PUMLCollaborationInstanceSet.IndexOfParticipatingLink(Value: PUMLLink): Integer;
begin
  Result := FParticipatingLinks.IndexOf(Value);
end;

function PUMLCollaborationInstanceSet.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLCollaborationInstanceSet.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLCollaborationInstanceSet.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Collaboration' then begin
    Result := Collaboration;
  end
  else if Name = 'RepresentedOperation' then begin
    Result := RepresentedOperation;
  end
  else if Name = 'RepresentedClassifier' then begin
    Result := RepresentedClassifier;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLCollaborationInstanceSet.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Collaboration' then begin
    Collaboration := Value as PUMLCollaboration;
  end
  else if Name = 'RepresentedOperation' then begin
    RepresentedOperation := Value as PUMLOperation;
  end
  else if Name = 'RepresentedClassifier' then begin
    RepresentedClassifier := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'InteractionInstanceSets' then begin
    AddInteractionInstanceSet(Value as PUMLInteractionInstanceSet);
  end
  else if Name = 'ParticipatingInstances' then begin
    AddParticipatingInstance(Value as PUMLInstance);
  end
  else if Name = 'ParticipatingLinks' then begin
    AddParticipatingLink(Value as PUMLLink);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'InteractionInstanceSets' then begin
    RemoveInteractionInstanceSet(Value as PUMLInteractionInstanceSet);
  end
  else if Name = 'ParticipatingInstances' then begin
    RemoveParticipatingInstance(Value as PUMLInstance);
  end
  else if Name = 'ParticipatingLinks' then begin
    RemoveParticipatingLink(Value as PUMLLink);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'InteractionInstanceSets' then begin
    InsertInteractionInstanceSet(Index, Value as PUMLInteractionInstanceSet);
  end
  else if Name = 'ParticipatingInstances' then begin
    InsertParticipatingInstance(Index, Value as PUMLInstance);
  end
  else if Name = 'ParticipatingLinks' then begin
    InsertParticipatingLink(Index, Value as PUMLLink);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLCollaborationInstanceSet.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'InteractionInstanceSets' then begin
    DeleteInteractionInstanceSet(Index);
  end
  else if Name = 'ParticipatingInstances' then begin
    DeleteParticipatingInstance(Index);
  end
  else if Name = 'ParticipatingLinks' then begin
    DeleteParticipatingLink(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLCollaborationInstanceSet.MOF_ClearCollection(Name: string);
begin
  if Name = 'InteractionInstanceSets' then begin
    ClearInteractionInstanceSets;
  end
  else if Name = 'ParticipatingInstances' then begin
    ClearParticipatingInstances;
  end
  else if Name = 'ParticipatingLinks' then begin
    ClearParticipatingLinks;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLCollaborationInstanceSet.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'InteractionInstanceSets' then begin
    Result := IndexOfInteractionInstanceSet(Value as PUMLInteractionInstanceSet);
  end
  else if Name = 'ParticipatingInstances' then begin
    Result := IndexOfParticipatingInstance(Value as PUMLInstance);
  end
  else if Name = 'ParticipatingLinks' then begin
    Result := IndexOfParticipatingLink(Value as PUMLLink);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLCollaborationInstanceSet.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'InteractionInstanceSets' then begin
    Result := InteractionInstanceSets[Index];
  end
  else if Name = 'ParticipatingInstances' then begin
    Result := ParticipatingInstances[Index];
  end
  else if Name = 'ParticipatingLinks' then begin
    Result := ParticipatingLinks[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLCollaborationInstanceSet.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'InteractionInstanceSets' then begin
    Result := InteractionInstanceSetCount;
  end
  else if Name = 'ParticipatingInstances' then begin
    Result := ParticipatingInstanceCount;
  end
  else if Name = 'ParticipatingLinks' then begin
    Result := ParticipatingLinkCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLCollaborationInstanceSet.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLInteractionInstanceSet') or
     MetaModel.IsKindOf(Kind, 'UMLLink') or
     MetaModel.IsKindOf(Kind, 'UMLObject') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;

// PUMLCollaborationInstanceSet
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLParameter

constructor PUMLParameter.Create;
begin
  inherited;
  FBehavioralFeature := nil;
  FType_ := nil;
  FEvent := nil;
  FStates := POrderedSet.Create;
end;

destructor PUMLParameter.Destroy;
begin
  FStates.Free;
  inherited;
end;

procedure PUMLParameter.SetDefaultValue(Value: string);
begin
  if FDefaultValue <> Value then
    FDefaultValue := Value;
end;

procedure PUMLParameter.SetDirectionKind(Value: PUMLParameterDirectionKind);
begin
  if FDirectionKind <> Value then
    FDirectionKind := Value;
end;

procedure PUMLParameter.SetTypeExpression(Value: string);
begin
  if FTypeExpression <> Value then
    FTypeExpression := Value;
end;

procedure PUMLParameter.SetBehavioralFeature(Value: PUMLBehavioralFeature);
begin
  if FBehavioralFeature <> Value then begin
    if FBehavioralFeature <> nil then begin
      FBehavioralFeature.FParameters.Remove(Self);
      FBehavioralFeature.RemoveVirtualOwnedModel(Self);
    end;
    FBehavioralFeature := Value;
    if Value <> nil then begin
      Value.FParameters.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLParameter.SetType_(Value: PUMLClassifier);
begin
  if FType_ <> Value then begin
    if FType_ <> nil then Type_.FTypedParameters.Remove(Self);
    FType_ := Value;
    if Value <> nil then begin
      Value.FTypedParameters.Add(Self);
    end;
  end;
end;

procedure PUMLParameter.SetEvent(Value: PUMLEvent);
begin
  if FEvent <> Value then begin
    if FEvent <> nil then begin
      FEvent.FParameters.Remove(Self);
      FEvent.RemoveVirtualOwnedModel(Self);
    end;
    FEvent := Value;
    if Value <> nil then begin
      Value.FParameters.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLParameter.GetState(Index: Integer): PUMLObjectFlowState;
begin
  Result := FStates.Items[Index] as UMLModels.PUMLObjectFlowState;
end;

function PUMLParameter.GetStateCount: Integer;
begin
  Result := FStates.Count;
end;

procedure PUMLParameter.ClearStates;
var
  I: Integer;
begin
  for I := FStates.Count - 1 downto 0 do
    DeleteState(I);
end;

procedure PUMLParameter.AddState(Value: PUMLObjectFlowState);
begin
  if Value <> nil then begin
    FStates.Add(Value);
    Value.FParameters.Add(Self);
  end;
end;

procedure PUMLParameter.RemoveState(Value: PUMLObjectFlowState);
begin
  if Value <> nil then begin
    FStates.Remove(Value);
    Value.FParameters.Remove(Self);
  end;
end;

procedure PUMLParameter.InsertState(Index: Integer; Value: PUMLObjectFlowState);
begin
  if Value <> nil then begin
    FStates.Insert(Index, Value);
    Value.FParameters.Add(Self);
  end;
end;

procedure PUMLParameter.DeleteState(Index: Integer);
begin
  RemoveState(FStates.Items[Index] as UMLModels.PUMLObjectFlowState);
end;

function PUMLParameter.IndexOfState(Value: PUMLObjectFlowState): Integer;
begin
  Result := FStates.IndexOf(Value);
end;

function PUMLParameter.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'DefaultValue' then begin
    Result := DefaultValue;
  end
  else if Name = 'DirectionKind' then begin
    Result := UMLParameterDirectionKindToString(DirectionKind);
  end
  else if Name = 'TypeExpression' then begin
    Result := TypeExpression;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLParameter.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'DefaultValue' then begin
    DefaultValue := Value;
  end
  else if Name = 'DirectionKind' then begin
    DirectionKind := StringToUMLParameterDirectionKind(Value);
  end
  else if Name = 'TypeExpression' then begin
    TypeExpression := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLParameter.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'BehavioralFeature' then begin
    Result := BehavioralFeature;
  end
  else if Name = 'Type_' then begin
    Result := Type_;
  end
  else if Name = 'Event' then begin
    Result := Event;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLParameter.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'BehavioralFeature' then begin
    BehavioralFeature := Value as PUMLBehavioralFeature;
  end
  else if Name = 'Type_' then begin
    Type_ := Value as PUMLClassifier;
  end
  else if Name = 'Event' then begin
    Event := Value as PUMLEvent;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLParameter.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'States' then begin
    AddState(Value as PUMLObjectFlowState);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLParameter.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'States' then begin
    RemoveState(Value as PUMLObjectFlowState);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLParameter.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'States' then begin
    InsertState(Index, Value as PUMLObjectFlowState);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLParameter.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'States' then begin
    DeleteState(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLParameter.MOF_ClearCollection(Name: string);
begin
  if Name = 'States' then begin
    ClearStates;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLParameter.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'States' then begin
    Result := IndexOfState(Value as PUMLObjectFlowState);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLParameter.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'States' then begin
    Result := States[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLParameter.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'States' then begin
    Result := StateCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLParameter
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLAssociationEnd

constructor PUMLAssociationEnd.Create;
begin
  inherited;
  FAssociation := nil;
  FQualifiers := POrderedSet.Create;
  FParticipant := nil;
  FLinkEnds := POrderedSet.Create;
  FAssociationEndRoles := POrderedSet.Create;
end;

destructor PUMLAssociationEnd.Destroy;
begin
  FQualifiers.Free;
  FLinkEnds.Free;
  FAssociationEndRoles.Free;
  inherited;
end;

procedure PUMLAssociationEnd.SetIsNavigable(Value: Boolean);
begin
  if FIsNavigable <> Value then
    FIsNavigable := Value;
end;

procedure PUMLAssociationEnd.SetOrdering(Value: PUMLOrderingKind);
begin
  if FOrdering <> Value then
    FOrdering := Value;
end;

procedure PUMLAssociationEnd.SetAggregation(Value: PUMLAggregationKind);
begin
  if FAggregation <> Value then
    FAggregation := Value;
end;

procedure PUMLAssociationEnd.SetTargetScope(Value: PUMLScopeKind);
begin
  if FTargetScope <> Value then
    FTargetScope := Value;
end;

procedure PUMLAssociationEnd.SetMultiplicity(Value: string);
begin
  if FMultiplicity <> Value then
    FMultiplicity := Value;
end;

procedure PUMLAssociationEnd.SetChangeability(Value: PUMLChangeableKind);
begin
  if FChangeability <> Value then
    FChangeability := Value;
end;

procedure PUMLAssociationEnd.SetAssociation(Value: PUMLAssociation);
begin
  if FAssociation <> Value then begin
    if FAssociation <> nil then begin
      FAssociation.FConnections.Remove(Self);
      FAssociation.RemoveVirtualOwnedModel(Self);
    end;
    FAssociation := Value;
    if Value <> nil then begin
      Value.FConnections.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLAssociationEnd.GetQualifier(Index: Integer): PUMLAttribute;
begin
  Result := FQualifiers.Items[Index] as UMLModels.PUMLAttribute;
end;

function PUMLAssociationEnd.GetQualifierCount: Integer;
begin
  Result := FQualifiers.Count;
end;

procedure PUMLAssociationEnd.SetParticipant(Value: PUMLClassifier);
begin
  if FParticipant <> Value then begin
    if FParticipant <> nil then Participant.FAssociations.Remove(Self);
    FParticipant := Value;
    if Value <> nil then begin
      Value.FAssociations.Add(Self);
    end;
  end;
end;

function PUMLAssociationEnd.GetLinkEnd(Index: Integer): PUMLLinkEnd;
begin
  Result := FLinkEnds.Items[Index] as UMLModels.PUMLLinkEnd;
end;

function PUMLAssociationEnd.GetLinkEndCount: Integer;
begin
  Result := FLinkEnds.Count;
end;

function PUMLAssociationEnd.GetAssociationEndRole(Index: Integer): PUMLAssociationEndRole;
begin
  Result := FAssociationEndRoles.Items[Index] as UMLModels.PUMLAssociationEndRole;
end;

function PUMLAssociationEnd.GetAssociationEndRoleCount: Integer;
begin
  Result := FAssociationEndRoles.Count;
end;

procedure PUMLAssociationEnd.ClearQualifiers;
var
  I: Integer;
begin
  for I := FQualifiers.Count - 1 downto 0 do
    DeleteQualifier(I);
end;

procedure PUMLAssociationEnd.AddQualifier(Value: PUMLAttribute);
begin
  if Value <> nil then begin
    if Value.FAssociationEnd <> nil then begin
      Value.FAssociationEnd.FQualifiers.Remove(Value);
      Value.FAssociationEnd.RemoveVirtualOwnedModel(Value);
    end;
    FQualifiers.Add(Value);
    Value.FAssociationEnd := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLAssociationEnd.RemoveQualifier(Value: PUMLAttribute);
begin
  if Value <> nil then begin
    FQualifiers.Remove(Value);
    Value.FAssociationEnd := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLAssociationEnd.InsertQualifier(Index: Integer; Value: PUMLAttribute);
begin
  if Value <> nil then begin
    if Value.FAssociationEnd <> nil then begin
      Value.FAssociationEnd.FQualifiers.Remove(Value);
      Value.FAssociationEnd.RemoveVirtualOwnedModel(Value);
    end;
    FQualifiers.Insert(Index, Value);
    Value.FAssociationEnd := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLAssociationEnd.DeleteQualifier(Index: Integer);
begin
  RemoveQualifier(FQualifiers.Items[Index] as UMLModels.PUMLAttribute);
end;

function PUMLAssociationEnd.IndexOfQualifier(Value: PUMLAttribute): Integer;
begin
  Result := FQualifiers.IndexOf(Value);
end;

procedure PUMLAssociationEnd.ClearLinkEnds;
var
  I: Integer;
begin
  for I := FLinkEnds.Count - 1 downto 0 do
    DeleteLinkEnd(I);
end;

procedure PUMLAssociationEnd.AddLinkEnd(Value: PUMLLinkEnd);
begin
  if Value <> nil then begin
    if Value.FAssociationEnd <> nil then Value.FAssociationEnd.FLinkEnds.Remove(Value);
    FLinkEnds.Add(Value);
    Value.FAssociationEnd := Self;
  end;
end;

procedure PUMLAssociationEnd.RemoveLinkEnd(Value: PUMLLinkEnd);
begin
  if Value <> nil then begin
    FLinkEnds.Remove(Value);
    Value.FAssociationEnd := nil;
  end;
end;

procedure PUMLAssociationEnd.InsertLinkEnd(Index: Integer; Value: PUMLLinkEnd);
begin
  if Value <> nil then begin
    if Value.FAssociationEnd <> nil then Value.FAssociationEnd.FLinkEnds.Remove(Value);
    FLinkEnds.Insert(Index, Value);
    Value.FAssociationEnd := Self;
  end;
end;

procedure PUMLAssociationEnd.DeleteLinkEnd(Index: Integer);
begin
  RemoveLinkEnd(FLinkEnds.Items[Index] as UMLModels.PUMLLinkEnd);
end;

function PUMLAssociationEnd.IndexOfLinkEnd(Value: PUMLLinkEnd): Integer;
begin
  Result := FLinkEnds.IndexOf(Value);
end;

procedure PUMLAssociationEnd.ClearAssociationEndRoles;
var
  I: Integer;
begin
  for I := FAssociationEndRoles.Count - 1 downto 0 do
    DeleteAssociationEndRole(I);
end;

procedure PUMLAssociationEnd.AddAssociationEndRole(Value: PUMLAssociationEndRole);
begin
  if Value <> nil then begin
    if Value.FBase <> nil then Value.FBase.FAssociationEndRoles.Remove(Value);
    FAssociationEndRoles.Add(Value);
    Value.FBase := Self;
  end;
end;

procedure PUMLAssociationEnd.RemoveAssociationEndRole(Value: PUMLAssociationEndRole);
begin
  if Value <> nil then begin
    FAssociationEndRoles.Remove(Value);
    Value.FBase := nil;
  end;
end;

procedure PUMLAssociationEnd.InsertAssociationEndRole(Index: Integer; Value: PUMLAssociationEndRole);
begin
  if Value <> nil then begin
    if Value.FBase <> nil then Value.FBase.FAssociationEndRoles.Remove(Value);
    FAssociationEndRoles.Insert(Index, Value);
    Value.FBase := Self;
  end;
end;

procedure PUMLAssociationEnd.DeleteAssociationEndRole(Index: Integer);
begin
  RemoveAssociationEndRole(FAssociationEndRoles.Items[Index] as UMLModels.PUMLAssociationEndRole);
end;

function PUMLAssociationEnd.IndexOfAssociationEndRole(Value: PUMLAssociationEndRole): Integer;
begin
  Result := FAssociationEndRoles.IndexOf(Value);
end;

function PUMLAssociationEnd.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'IsNavigable' then begin
    Result := BooleanToString(IsNavigable);
  end
  else if Name = 'Ordering' then begin
    Result := UMLOrderingKindToString(Ordering);
  end
  else if Name = 'Aggregation' then begin
    Result := UMLAggregationKindToString(Aggregation);
  end
  else if Name = 'TargetScope' then begin
    Result := UMLScopeKindToString(TargetScope);
  end
  else if Name = 'Multiplicity' then begin
    Result := Multiplicity;
  end
  else if Name = 'Changeability' then begin
    Result := UMLChangeableKindToString(Changeability);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLAssociationEnd.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'IsNavigable' then begin
    IsNavigable := StringToBoolean(Value);
  end
  else if Name = 'Ordering' then begin
    Ordering := StringToUMLOrderingKind(Value);
  end
  else if Name = 'Aggregation' then begin
    Aggregation := StringToUMLAggregationKind(Value);
  end
  else if Name = 'TargetScope' then begin
    TargetScope := StringToUMLScopeKind(Value);
  end
  else if Name = 'Multiplicity' then begin
    Multiplicity := Value;
  end
  else if Name = 'Changeability' then begin
    Changeability := StringToUMLChangeableKind(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLAssociationEnd.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Association' then begin
    Result := Association;
  end
  else if Name = 'Participant' then begin
    Result := Participant;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLAssociationEnd.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Association' then begin
    Association := Value as PUMLAssociation;
  end
  else if Name = 'Participant' then begin
    Participant := Value as PUMLClassifier;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLAssociationEnd.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Qualifiers' then begin
    AddQualifier(Value as PUMLAttribute);
  end
  else if Name = 'LinkEnds' then begin
    AddLinkEnd(Value as PUMLLinkEnd);
  end
  else if Name = 'AssociationEndRoles' then begin
    AddAssociationEndRole(Value as PUMLAssociationEndRole);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLAssociationEnd.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Qualifiers' then begin
    RemoveQualifier(Value as PUMLAttribute);
  end
  else if Name = 'LinkEnds' then begin
    RemoveLinkEnd(Value as PUMLLinkEnd);
  end
  else if Name = 'AssociationEndRoles' then begin
    RemoveAssociationEndRole(Value as PUMLAssociationEndRole);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLAssociationEnd.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Qualifiers' then begin
    InsertQualifier(Index, Value as PUMLAttribute);
  end
  else if Name = 'LinkEnds' then begin
    InsertLinkEnd(Index, Value as PUMLLinkEnd);
  end
  else if Name = 'AssociationEndRoles' then begin
    InsertAssociationEndRole(Index, Value as PUMLAssociationEndRole);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLAssociationEnd.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Qualifiers' then begin
    DeleteQualifier(Index);
  end
  else if Name = 'LinkEnds' then begin
    DeleteLinkEnd(Index);
  end
  else if Name = 'AssociationEndRoles' then begin
    DeleteAssociationEndRole(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLAssociationEnd.MOF_ClearCollection(Name: string);
begin
  if Name = 'Qualifiers' then begin
    ClearQualifiers;
  end
  else if Name = 'LinkEnds' then begin
    ClearLinkEnds;
  end
  else if Name = 'AssociationEndRoles' then begin
    ClearAssociationEndRoles;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLAssociationEnd.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Qualifiers' then begin
    Result := IndexOfQualifier(Value as PUMLAttribute);
  end
  else if Name = 'LinkEnds' then begin
    Result := IndexOfLinkEnd(Value as PUMLLinkEnd);
  end
  else if Name = 'AssociationEndRoles' then begin
    Result := IndexOfAssociationEndRole(Value as PUMLAssociationEndRole);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLAssociationEnd.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Qualifiers' then begin
    Result := Qualifiers[Index];
  end
  else if Name = 'LinkEnds' then begin
    Result := LinkEnds[Index];
  end
  else if Name = 'AssociationEndRoles' then begin
    Result := AssociationEndRoles[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLAssociationEnd.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Qualifiers' then begin
    Result := QualifierCount;
  end
  else if Name = 'LinkEnds' then begin
    Result := LinkEndCount;
  end
  else if Name = 'AssociationEndRoles' then begin
    Result := AssociationEndRoleCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLAssociationEnd.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLAttribute') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;

function PUMLAssociationEnd.CanCopy: Boolean;
begin
  Result := False;
end;

function PUMLAssociationEnd.CanDelete: Boolean;
begin
  Result := False;
end;

// PUMLAssociationEnd
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLAssociationEndRole

constructor PUMLAssociationEndRole.Create;
begin
  inherited;
  FBase := nil;
  FAvailableQualifiers := POrderedSet.Create;
end;

destructor PUMLAssociationEndRole.Destroy;
begin
  FAvailableQualifiers.Free;
  inherited;
end;

procedure PUMLAssociationEndRole.SetCollaborationMultiplicity(Value: string);
begin
  if FCollaborationMultiplicity <> Value then
    FCollaborationMultiplicity := Value;
end;

procedure PUMLAssociationEndRole.SetBase(Value: PUMLAssociationEnd);
begin
  if FBase <> Value then begin
    if FBase <> nil then Base.FAssociationEndRoles.Remove(Self);
    FBase := Value;
    if Value <> nil then begin
      Value.FAssociationEndRoles.Add(Self);
    end;
  end;
end;

function PUMLAssociationEndRole.GetAvailableQualifier(Index: Integer): PUMLAttribute;
begin
  Result := FAvailableQualifiers.Items[Index] as UMLModels.PUMLAttribute;
end;

function PUMLAssociationEndRole.GetAvailableQualifierCount: Integer;
begin
  Result := FAvailableQualifiers.Count;
end;

procedure PUMLAssociationEndRole.ClearAvailableQualifiers;
var
  I: Integer;
begin
  for I := FAvailableQualifiers.Count - 1 downto 0 do
    DeleteAvailableQualifier(I);
end;

procedure PUMLAssociationEndRole.AddAvailableQualifier(Value: PUMLAttribute);
begin
  if Value <> nil then begin
    FAvailableQualifiers.Add(Value);
    Value.FAssociationEndRoles.Add(Self);
  end;
end;

procedure PUMLAssociationEndRole.RemoveAvailableQualifier(Value: PUMLAttribute);
begin
  if Value <> nil then begin
    FAvailableQualifiers.Remove(Value);
    Value.FAssociationEndRoles.Remove(Self);
  end;
end;

procedure PUMLAssociationEndRole.InsertAvailableQualifier(Index: Integer; Value: PUMLAttribute);
begin
  if Value <> nil then begin
    FAvailableQualifiers.Insert(Index, Value);
    Value.FAssociationEndRoles.Add(Self);
  end;
end;

procedure PUMLAssociationEndRole.DeleteAvailableQualifier(Index: Integer);
begin
  RemoveAvailableQualifier(FAvailableQualifiers.Items[Index] as UMLModels.PUMLAttribute);
end;

function PUMLAssociationEndRole.IndexOfAvailableQualifier(Value: PUMLAttribute): Integer;
begin
  Result := FAvailableQualifiers.IndexOf(Value);
end;

function PUMLAssociationEndRole.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'CollaborationMultiplicity' then begin
    Result := CollaborationMultiplicity;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLAssociationEndRole.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'CollaborationMultiplicity' then begin
    CollaborationMultiplicity := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLAssociationEndRole.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Base' then begin
    Result := Base;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLAssociationEndRole.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Base' then begin
    Base := Value as PUMLAssociationEnd;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLAssociationEndRole.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'AvailableQualifiers' then begin
    AddAvailableQualifier(Value as PUMLAttribute);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLAssociationEndRole.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'AvailableQualifiers' then begin
    RemoveAvailableQualifier(Value as PUMLAttribute);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLAssociationEndRole.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'AvailableQualifiers' then begin
    InsertAvailableQualifier(Index, Value as PUMLAttribute);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLAssociationEndRole.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'AvailableQualifiers' then begin
    DeleteAvailableQualifier(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLAssociationEndRole.MOF_ClearCollection(Name: string);
begin
  if Name = 'AvailableQualifiers' then begin
    ClearAvailableQualifiers;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLAssociationEndRole.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'AvailableQualifiers' then begin
    Result := IndexOfAvailableQualifier(Value as PUMLAttribute);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLAssociationEndRole.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'AvailableQualifiers' then begin
    Result := AvailableQualifiers[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLAssociationEndRole.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'AvailableQualifiers' then begin
    Result := AvailableQualifierCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLAssociationEndRole
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLTransition

constructor PUMLTransition.Create;
begin
  inherited;
  FEffects := POrderedSet.Create;
  FState := nil;
  FTriggers := POrderedSet.Create;
  FStateMachine := nil;
  FSource := nil;
  FTarget := nil;
end;

destructor PUMLTransition.Destroy;
begin
  FEffects.Free;
  FTriggers.Free;
  inherited;
end;

function PUMLTransition.FindRelatedModel(FirstElement: PModel): PModel;
begin
  if FirstElement = Source then
    Result := Target
  else if FirstElement = Target then
    Result := Source
  else
    Result := nil; // First element does not match
end;

procedure PUMLTransition.SetGuardCondition(Value: string);
begin
  if FGuardCondition <> Value then
    FGuardCondition := Value;
end;

function PUMLTransition.GetEffect(Index: Integer): PUMLAction;
begin
  Result := FEffects.Items[Index] as UMLModels.PUMLAction;
end;

function PUMLTransition.GetEffectCount: Integer;
begin
  Result := FEffects.Count;
end;

procedure PUMLTransition.SetState(Value: PUMLState);
begin
  if FState <> Value then begin
    if FState <> nil then begin
      FState.FInternalTransitions.Remove(Self);
      FState.RemoveVirtualOwnedModel(Self);
    end;
    FState := Value;
    if Value <> nil then begin
      Value.FInternalTransitions.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLTransition.GetTrigger(Index: Integer): PUMLEvent;
begin
  Result := FTriggers.Items[Index] as UMLModels.PUMLEvent;
end;

function PUMLTransition.GetTriggerCount: Integer;
begin
  Result := FTriggers.Count;
end;

procedure PUMLTransition.SetStateMachine(Value: PUMLStateMachine);
begin
  if FStateMachine <> Value then begin
    if FStateMachine <> nil then begin
      FStateMachine.FTransitions.Remove(Self);
      FStateMachine.RemoveVirtualOwnedModel(Self);
    end;
    FStateMachine := Value;
    if Value <> nil then begin
      Value.FTransitions.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLTransition.SetSource(Value: PUMLStateVertex);
begin
  if FSource <> Value then begin
    if FSource <> nil then Source.FOutgoings.Remove(Self);
    FSource := Value;
    if Value <> nil then begin
      Value.FOutgoings.Add(Self);
    end;
  end;
end;

procedure PUMLTransition.SetTarget(Value: PUMLStateVertex);
begin
  if FTarget <> Value then begin
    if FTarget <> nil then Target.FIncomings.Remove(Self);
    FTarget := Value;
    if Value <> nil then begin
      Value.FIncomings.Add(Self);
    end;
  end;
end;

procedure PUMLTransition.ClearEffects;
var
  I: Integer;
begin
  for I := FEffects.Count - 1 downto 0 do
    DeleteEffect(I);
end;

procedure PUMLTransition.AddEffect(Value: PUMLAction);
begin
  if Value <> nil then begin
    if Value.FTransition <> nil then begin
      Value.FTransition.FEffects.Remove(Value);
      Value.FTransition.RemoveVirtualOwnedModel(Value);
    end;
    FEffects.Add(Value);
    Value.FTransition := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLTransition.RemoveEffect(Value: PUMLAction);
begin
  if Value <> nil then begin
    FEffects.Remove(Value);
    Value.FTransition := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLTransition.InsertEffect(Index: Integer; Value: PUMLAction);
begin
  if Value <> nil then begin
    if Value.FTransition <> nil then begin
      Value.FTransition.FEffects.Remove(Value);
      Value.FTransition.RemoveVirtualOwnedModel(Value);
    end;
    FEffects.Insert(Index, Value);
    Value.FTransition := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLTransition.DeleteEffect(Index: Integer);
begin
  RemoveEffect(FEffects.Items[Index] as UMLModels.PUMLAction);
end;

function PUMLTransition.IndexOfEffect(Value: PUMLAction): Integer;
begin
  Result := FEffects.IndexOf(Value);
end;

procedure PUMLTransition.ClearTriggers;
var
  I: Integer;
begin
  for I := FTriggers.Count - 1 downto 0 do
    DeleteTrigger(I);
end;

procedure PUMLTransition.AddTrigger(Value: PUMLEvent);
begin
  if Value <> nil then begin
    if Value.FTransition <> nil then begin
      Value.FTransition.FTriggers.Remove(Value);
      Value.FTransition.RemoveVirtualOwnedModel(Value);
    end;
    FTriggers.Add(Value);
    Value.FTransition := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLTransition.RemoveTrigger(Value: PUMLEvent);
begin
  if Value <> nil then begin
    FTriggers.Remove(Value);
    Value.FTransition := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLTransition.InsertTrigger(Index: Integer; Value: PUMLEvent);
begin
  if Value <> nil then begin
    if Value.FTransition <> nil then begin
      Value.FTransition.FTriggers.Remove(Value);
      Value.FTransition.RemoveVirtualOwnedModel(Value);
    end;
    FTriggers.Insert(Index, Value);
    Value.FTransition := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLTransition.DeleteTrigger(Index: Integer);
begin
  RemoveTrigger(FTriggers.Items[Index] as UMLModels.PUMLEvent);
end;

function PUMLTransition.IndexOfTrigger(Value: PUMLEvent): Integer;
begin
  Result := FTriggers.IndexOf(Value);
end;

function PUMLTransition.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'GuardCondition' then begin
    Result := GuardCondition;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLTransition.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'GuardCondition' then begin
    GuardCondition := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLTransition.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'State' then begin
    Result := State;
  end
  else if Name = 'StateMachine' then begin
    Result := StateMachine;
  end
  else if Name = 'Source' then begin
    Result := Source;
  end
  else if Name = 'Target' then begin
    Result := Target;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLTransition.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'State' then begin
    State := Value as PUMLState;
  end
  else if Name = 'StateMachine' then begin
    StateMachine := Value as PUMLStateMachine;
  end
  else if Name = 'Source' then begin
    Source := Value as PUMLStateVertex;
  end
  else if Name = 'Target' then begin
    Target := Value as PUMLStateVertex;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLTransition.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Effects' then begin
    AddEffect(Value as PUMLAction);
  end
  else if Name = 'Triggers' then begin
    AddTrigger(Value as PUMLEvent);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLTransition.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Effects' then begin
    RemoveEffect(Value as PUMLAction);
  end
  else if Name = 'Triggers' then begin
    RemoveTrigger(Value as PUMLEvent);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLTransition.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Effects' then begin
    InsertEffect(Index, Value as PUMLAction);
  end
  else if Name = 'Triggers' then begin
    InsertTrigger(Index, Value as PUMLEvent);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLTransition.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Effects' then begin
    DeleteEffect(Index);
  end
  else if Name = 'Triggers' then begin
    DeleteTrigger(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLTransition.MOF_ClearCollection(Name: string);
begin
  if Name = 'Effects' then begin
    ClearEffects;
  end
  else if Name = 'Triggers' then begin
    ClearTriggers;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLTransition.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Effects' then begin
    Result := IndexOfEffect(Value as PUMLAction);
  end
  else if Name = 'Triggers' then begin
    Result := IndexOfTrigger(Value as PUMLEvent);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLTransition.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Effects' then begin
    Result := Effects[Index];
  end
  else if Name = 'Triggers' then begin
    Result := Triggers[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLTransition.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Effects' then begin
    Result := EffectCount;
  end
  else if Name = 'Triggers' then begin
    Result := TriggerCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLTransition.CanContainKind(Kind: string): Boolean;
begin
  if MetaModel.IsKindOf(Kind, 'UMLEvent') then
    Result := True
  else
    Result := inherited CanContainKind(Kind);
end;

function PUMLTransition.CanRelocateTo(Model: PModel): Boolean;
begin
  Result := False;
end;

function PUMLTransition.CanCopy: Boolean;
begin
  Result := False;
end;

// PUMLTransition
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLExtensionPoint

constructor PUMLExtensionPoint.Create;
begin
  inherited;
  FUseCase := nil;
  FExtends := POrderedSet.Create;
end;

destructor PUMLExtensionPoint.Destroy;
begin
  FExtends.Free;
  inherited;
end;

procedure PUMLExtensionPoint.SetLocation(Value: string);
begin
  if FLocation <> Value then
    FLocation := Value;
end;

procedure PUMLExtensionPoint.SetUseCase(Value: PUMLUseCase);
begin
  if FUseCase <> Value then begin
    if FUseCase <> nil then begin
      FUseCase.FExtensionPoints.Remove(Self);
      FUseCase.RemoveVirtualOwnedModel(Self);
    end;
    FUseCase := Value;
    if Value <> nil then begin
      Value.FExtensionPoints.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLExtensionPoint.GetExtend(Index: Integer): PUMLExtend;
begin
  Result := FExtends.Items[Index] as UMLModels.PUMLExtend;
end;

function PUMLExtensionPoint.GetExtendCount: Integer;
begin
  Result := FExtends.Count;
end;

procedure PUMLExtensionPoint.ClearExtends;
var
  I: Integer;
begin
  for I := FExtends.Count - 1 downto 0 do
    DeleteExtend(I);
end;

procedure PUMLExtensionPoint.AddExtend(Value: PUMLExtend);
begin
  if Value <> nil then begin
    FExtends.Add(Value);
    Value.FExtensionPoints.Add(Self);
  end;
end;

procedure PUMLExtensionPoint.RemoveExtend(Value: PUMLExtend);
begin
  if Value <> nil then begin
    FExtends.Remove(Value);
    Value.FExtensionPoints.Remove(Self);
  end;
end;

procedure PUMLExtensionPoint.InsertExtend(Index: Integer; Value: PUMLExtend);
begin
  if Value <> nil then begin
    FExtends.Insert(Index, Value);
    Value.FExtensionPoints.Add(Self);
  end;
end;

procedure PUMLExtensionPoint.DeleteExtend(Index: Integer);
begin
  RemoveExtend(FExtends.Items[Index] as UMLModels.PUMLExtend);
end;

function PUMLExtensionPoint.IndexOfExtend(Value: PUMLExtend): Integer;
begin
  Result := FExtends.IndexOf(Value);
end;

function PUMLExtensionPoint.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Location' then begin
    Result := Location;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLExtensionPoint.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Location' then begin
    Location := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLExtensionPoint.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'UseCase' then begin
    Result := UseCase;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLExtensionPoint.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'UseCase' then begin
    UseCase := Value as PUMLUseCase;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLExtensionPoint.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Extends' then begin
    AddExtend(Value as PUMLExtend);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLExtensionPoint.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Extends' then begin
    RemoveExtend(Value as PUMLExtend);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLExtensionPoint.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Extends' then begin
    InsertExtend(Index, Value as PUMLExtend);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLExtensionPoint.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Extends' then begin
    DeleteExtend(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLExtensionPoint.MOF_ClearCollection(Name: string);
begin
  if Name = 'Extends' then begin
    ClearExtends;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLExtensionPoint.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Extends' then begin
    Result := IndexOfExtend(Value as PUMLExtend);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLExtensionPoint.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Extends' then begin
    Result := Extends[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLExtensionPoint.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Extends' then begin
    Result := ExtendCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLExtensionPoint
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLLink

constructor PUMLLink.Create;
begin
  inherited;
  FAssociation := nil;
  FConnections := POrderedSet.Create;
  FStimuli := POrderedSet.Create;
  FOwner := nil;
  FLinkObject := nil;
  FPlayedRoles := POrderedSet.Create;
  FCollaborationInstanceSet := nil;
end;

destructor PUMLLink.Destroy;
begin
  FConnections.Free;
  FStimuli.Free;
  FPlayedRoles.Free;
  inherited;
end;

function PUMLLink.FindRelatedModel(FirstElement: PModel): PModel;
begin
  if FirstElement = Connections[0].Instance then
    Result := Connections[1].Instance
  else if FirstElement = Connections[1].Instance then
    Result := Connections[0].Instance
  else
    Result := nil; // First element does not match
end;

procedure PUMLLink.SetAssociation(Value: PUMLAssociation);
begin
  if FAssociation <> Value then begin
    if FAssociation <> nil then Association.FLinks.Remove(Self);
    FAssociation := Value;
    if Value <> nil then begin
      Value.FLinks.Add(Self);
    end;
  end;
end;

function PUMLLink.GetConnection(Index: Integer): PUMLLinkEnd;
begin
  Result := FConnections.Items[Index] as UMLModels.PUMLLinkEnd;
end;

function PUMLLink.GetConnectionCount: Integer;
begin
  Result := FConnections.Count;
end;

function PUMLLink.GetStimulus(Index: Integer): PUMLStimulus;
begin
  Result := FStimuli.Items[Index] as UMLModels.PUMLStimulus;
end;

function PUMLLink.GetStimulusCount: Integer;
begin
  Result := FStimuli.Count;
end;

procedure PUMLLink.SetOwner(Value: PUMLInstance);
begin
  if FOwner <> Value then begin
    if FOwner <> nil then begin
      FOwner.FOwnedLinks.Remove(Self);
      FOwner.RemoveVirtualOwnedModel(Self);
    end;
    FOwner := Value;
    if Value <> nil then begin
      Value.FOwnedLinks.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLLink.SetLinkObject(Value: PUMLLinkObject);
begin
  if FLinkObject <> Value then begin
    if FLinkObject <> nil then LinkObject.FLinkSide := nil;
    FLinkObject := Value;
    if Value <> nil then Value.FLinkSide := Self;
  end;
end;

function PUMLLink.GetPlayedRole(Index: Integer): PUMLAssociationRole;
begin
  Result := FPlayedRoles.Items[Index] as UMLModels.PUMLAssociationRole;
end;

function PUMLLink.GetPlayedRoleCount: Integer;
begin
  Result := FPlayedRoles.Count;
end;

procedure PUMLLink.SetCollaborationInstanceSet(Value: PUMLCollaborationInstanceSet);
begin
  if FCollaborationInstanceSet <> Value then begin
    if FCollaborationInstanceSet <> nil then begin
      FCollaborationInstanceSet.FParticipatingLinks.Remove(Self);
      FCollaborationInstanceSet.RemoveVirtualOwnedModel(Self);
    end;
    FCollaborationInstanceSet := Value;
    if Value <> nil then begin
      Value.FParticipatingLinks.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLLink.ClearConnections;
var
  I: Integer;
begin
  for I := FConnections.Count - 1 downto 0 do
    DeleteConnection(I);
end;

procedure PUMLLink.AddConnection(Value: PUMLLinkEnd);
begin
  if Value <> nil then begin
    if Value.FLink <> nil then begin
      Value.FLink.FConnections.Remove(Value);
      Value.FLink.RemoveVirtualOwnedModel(Value);
    end;
    FConnections.Add(Value);
    Value.FLink := Self;
    AddVirtualOwnedModel(Value);
  end;
end;

procedure PUMLLink.RemoveConnection(Value: PUMLLinkEnd);
begin
  if Value <> nil then begin
    FConnections.Remove(Value);
    Value.FLink := nil;
    RemoveVirtualOwnedModel(Value);
  end;
end;

procedure PUMLLink.InsertConnection(Index: Integer; Value: PUMLLinkEnd);
begin
  if Value <> nil then begin
    if Value.FLink <> nil then begin
      Value.FLink.FConnections.Remove(Value);
      Value.FLink.RemoveVirtualOwnedModel(Value);
    end;
    FConnections.Insert(Index, Value);
    Value.FLink := Self;
    InsertVirtualOwnedModel(Index, Value);
  end;
end;

procedure PUMLLink.DeleteConnection(Index: Integer);
begin
  RemoveConnection(FConnections.Items[Index] as UMLModels.PUMLLinkEnd);
end;

function PUMLLink.IndexOfConnection(Value: PUMLLinkEnd): Integer;
begin
  Result := FConnections.IndexOf(Value);
end;

procedure PUMLLink.ClearStimuli;
var
  I: Integer;
begin
  for I := FStimuli.Count - 1 downto 0 do
    DeleteStimulus(I);
end;

procedure PUMLLink.AddStimulus(Value: PUMLStimulus);
begin
  if Value <> nil then begin
    if Value.FCommunicationLink <> nil then Value.FCommunicationLink.FStimuli.Remove(Value);
    FStimuli.Add(Value);
    Value.FCommunicationLink := Self;
  end;
end;

procedure PUMLLink.RemoveStimulus(Value: PUMLStimulus);
begin
  if Value <> nil then begin
    FStimuli.Remove(Value);
    Value.FCommunicationLink := nil;
  end;
end;

procedure PUMLLink.InsertStimulus(Index: Integer; Value: PUMLStimulus);
begin
  if Value <> nil then begin
    if Value.FCommunicationLink <> nil then Value.FCommunicationLink.FStimuli.Remove(Value);
    FStimuli.Insert(Index, Value);
    Value.FCommunicationLink := Self;
  end;
end;

procedure PUMLLink.DeleteStimulus(Index: Integer);
begin
  RemoveStimulus(FStimuli.Items[Index] as UMLModels.PUMLStimulus);
end;

function PUMLLink.IndexOfStimulus(Value: PUMLStimulus): Integer;
begin
  Result := FStimuli.IndexOf(Value);
end;

procedure PUMLLink.ClearPlayedRoles;
var
  I: Integer;
begin
  for I := FPlayedRoles.Count - 1 downto 0 do
    DeletePlayedRole(I);
end;

procedure PUMLLink.AddPlayedRole(Value: PUMLAssociationRole);
begin
  if Value <> nil then begin
    FPlayedRoles.Add(Value);
    Value.FConformingLinks.Add(Self);
  end;
end;

procedure PUMLLink.RemovePlayedRole(Value: PUMLAssociationRole);
begin
  if Value <> nil then begin
    FPlayedRoles.Remove(Value);
    Value.FConformingLinks.Remove(Self);
  end;
end;

procedure PUMLLink.InsertPlayedRole(Index: Integer; Value: PUMLAssociationRole);
begin
  if Value <> nil then begin
    FPlayedRoles.Insert(Index, Value);
    Value.FConformingLinks.Add(Self);
  end;
end;

procedure PUMLLink.DeletePlayedRole(Index: Integer);
begin
  RemovePlayedRole(FPlayedRoles.Items[Index] as UMLModels.PUMLAssociationRole);
end;

function PUMLLink.IndexOfPlayedRole(Value: PUMLAssociationRole): Integer;
begin
  Result := FPlayedRoles.IndexOf(Value);
end;

function PUMLLink.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLLink.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLLink.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'Association' then begin
    Result := Association;
  end
  else if Name = 'Owner' then begin
    Result := Owner;
  end
  else if Name = 'LinkObject' then begin
    Result := LinkObject;
  end
  else if Name = 'CollaborationInstanceSet' then begin
    Result := CollaborationInstanceSet;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLLink.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'Association' then begin
    Association := Value as PUMLAssociation;
  end
  else if Name = 'Owner' then begin
    Owner := Value as PUMLInstance;
  end
  else if Name = 'LinkObject' then begin
    LinkObject := Value as PUMLLinkObject;
  end
  else if Name = 'CollaborationInstanceSet' then begin
    CollaborationInstanceSet := Value as PUMLCollaborationInstanceSet;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLLink.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Connections' then begin
    AddConnection(Value as PUMLLinkEnd);
  end
  else if Name = 'Stimuli' then begin
    AddStimulus(Value as PUMLStimulus);
  end
  else if Name = 'PlayedRoles' then begin
    AddPlayedRole(Value as PUMLAssociationRole);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLLink.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'Connections' then begin
    RemoveConnection(Value as PUMLLinkEnd);
  end
  else if Name = 'Stimuli' then begin
    RemoveStimulus(Value as PUMLStimulus);
  end
  else if Name = 'PlayedRoles' then begin
    RemovePlayedRole(Value as PUMLAssociationRole);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLLink.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'Connections' then begin
    InsertConnection(Index, Value as PUMLLinkEnd);
  end
  else if Name = 'Stimuli' then begin
    InsertStimulus(Index, Value as PUMLStimulus);
  end
  else if Name = 'PlayedRoles' then begin
    InsertPlayedRole(Index, Value as PUMLAssociationRole);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLLink.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'Connections' then begin
    DeleteConnection(Index);
  end
  else if Name = 'Stimuli' then begin
    DeleteStimulus(Index);
  end
  else if Name = 'PlayedRoles' then begin
    DeletePlayedRole(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLLink.MOF_ClearCollection(Name: string);
begin
  if Name = 'Connections' then begin
    ClearConnections;
  end
  else if Name = 'Stimuli' then begin
    ClearStimuli;
  end
  else if Name = 'PlayedRoles' then begin
    ClearPlayedRoles;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLLink.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'Connections' then begin
    Result := IndexOfConnection(Value as PUMLLinkEnd);
  end
  else if Name = 'Stimuli' then begin
    Result := IndexOfStimulus(Value as PUMLStimulus);
  end
  else if Name = 'PlayedRoles' then begin
    Result := IndexOfPlayedRole(Value as PUMLAssociationRole);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLLink.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'Connections' then begin
    Result := Connections[Index];
  end
  else if Name = 'Stimuli' then begin
    Result := Stimuli[Index];
  end
  else if Name = 'PlayedRoles' then begin
    Result := PlayedRoles[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLLink.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'Connections' then begin
    Result := ConnectionCount;
  end
  else if Name = 'Stimuli' then begin
    Result := StimulusCount;
  end
  else if Name = 'PlayedRoles' then begin
    Result := PlayedRoleCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

function PUMLLink.CanRelocateTo(Model: PModel): Boolean;
begin
  if CollaborationInstanceSet <> nil then
    Result := False
  else
    Result := inherited CanRelocateTo(Model);
end;

// PUMLLink
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLComment

constructor PUMLComment.Create;
begin
  inherited;
  FAnnotatedElements := POrderedSet.Create;
end;

destructor PUMLComment.Destroy;
begin
  FAnnotatedElements.Free;
  inherited;
end;

procedure PUMLComment.SetBody(Value: string);
begin
  if FBody <> Value then
    FBody := Value;
end;

function PUMLComment.GetAnnotatedElement(Index: Integer): PUMLModelElement;
begin
  Result := FAnnotatedElements.Items[Index] as UMLModels.PUMLModelElement;
end;

function PUMLComment.GetAnnotatedElementCount: Integer;
begin
  Result := FAnnotatedElements.Count;
end;

procedure PUMLComment.ClearAnnotatedElements;
var
  I: Integer;
begin
  for I := FAnnotatedElements.Count - 1 downto 0 do
    DeleteAnnotatedElement(I);
end;

procedure PUMLComment.AddAnnotatedElement(Value: PUMLModelElement);
begin
  if Value <> nil then begin
    FAnnotatedElements.Add(Value);
    Value.FComments.Add(Self);
  end;
end;

procedure PUMLComment.RemoveAnnotatedElement(Value: PUMLModelElement);
begin
  if Value <> nil then begin
    FAnnotatedElements.Remove(Value);
    Value.FComments.Remove(Self);
  end;
end;

procedure PUMLComment.InsertAnnotatedElement(Index: Integer; Value: PUMLModelElement);
begin
  if Value <> nil then begin
    FAnnotatedElements.Insert(Index, Value);
    Value.FComments.Add(Self);
  end;
end;

procedure PUMLComment.DeleteAnnotatedElement(Index: Integer);
begin
  RemoveAnnotatedElement(FAnnotatedElements.Items[Index] as UMLModels.PUMLModelElement);
end;

function PUMLComment.IndexOfAnnotatedElement(Value: PUMLModelElement): Integer;
begin
  Result := FAnnotatedElements.IndexOf(Value);
end;

function PUMLComment.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Body' then begin
    Result := Body;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLComment.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Body' then begin
    Body := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLComment.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLComment.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLComment.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'AnnotatedElements' then begin
    AddAnnotatedElement(Value as PUMLModelElement);
  end
  else begin
    inherited MOF_AddCollectionItem(Name, Value);
  end;
end;

procedure PUMLComment.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  if Name = 'AnnotatedElements' then begin
    RemoveAnnotatedElement(Value as PUMLModelElement);
  end
  else begin
    inherited MOF_RemoveCollectionItem(Name, Value);
  end;
end;

procedure PUMLComment.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  if Name = 'AnnotatedElements' then begin
    InsertAnnotatedElement(Index, Value as PUMLModelElement);
  end
  else begin
    inherited MOF_InsertCollectionItem(Name, Index, Value);
  end;
end;

procedure PUMLComment.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  if Name = 'AnnotatedElements' then begin
    DeleteAnnotatedElement(Index);
  end
  else begin
    inherited MOF_DeleteCollectionItem(Name, Index);
  end;
end;

procedure PUMLComment.MOF_ClearCollection(Name: string);
begin
  if Name = 'AnnotatedElements' then begin
    ClearAnnotatedElements;
  end
  else begin
    inherited MOF_ClearCollection(Name);
  end;
end;

function PUMLComment.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  if Name = 'AnnotatedElements' then begin
    Result := IndexOfAnnotatedElement(Value as PUMLModelElement);
  end
  else begin
    Result := inherited MOF_IndexOfCollectionItem(Name, Value);
  end;
end;

function PUMLComment.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  if Name = 'AnnotatedElements' then begin
    Result := AnnotatedElements[Index];
  end
  else begin
    Result := inherited MOF_GetCollectionItem(Name, Index);
  end;
end;

function PUMLComment.MOF_GetCollectionCount(Name: string): Integer;
begin
  if Name = 'AnnotatedElements' then begin
    Result := AnnotatedElementCount;
  end
  else begin
    Result := inherited MOF_GetCollectionCount(Name);
  end;
end;

// PUMLComment
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLTemplateParameter

constructor PUMLTemplateParameter.Create;
begin
  inherited;
  FDefaultElement := nil;
  FTemplate := nil;
  FParameter := nil;
end;

destructor PUMLTemplateParameter.Destroy;
begin
  inherited;
end;

procedure PUMLTemplateParameter.SetParameterType(Value: string);
begin
  if FParameterType <> Value then
    FParameterType := Value;
end;

procedure PUMLTemplateParameter.SetDefaultValue(Value: string);
begin
  if FDefaultValue <> Value then
    FDefaultValue := Value;
end;

procedure PUMLTemplateParameter.SetDefaultElement(Value: PUMLModelElement);
begin
  if FDefaultElement <> Value then begin
    if FDefaultElement <> nil then DefaultElement.FDefaultParameters.Remove(Self);
    FDefaultElement := Value;
    if Value <> nil then begin
      Value.FDefaultParameters.Add(Self);
    end;
  end;
end;

procedure PUMLTemplateParameter.SetTemplate(Value: PUMLModelElement);
begin
  if FTemplate <> Value then begin
    if FTemplate <> nil then begin
      FTemplate.FTemplateParameters.Remove(Self);
      FTemplate.RemoveVirtualOwnedModel(Self);
    end;
    FTemplate := Value;
    if Value <> nil then begin
      Value.FTemplateParameters.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

procedure PUMLTemplateParameter.SetParameter(Value: PUMLModelElement);
begin
  if FParameter <> Value then begin
    if FParameter <> nil then Parameter.FParameterOwner := nil;
    RemoveVirtualOwnedModel(FParameter);
    FParameter := Value;
    AddVirtualOwnedModel(FParameter);
    if Value <> nil then Value.FParameterOwner := Self;
  end;
end;

function PUMLTemplateParameter.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'ParameterType' then begin
    Result := ParameterType;
  end
  else if Name = 'DefaultValue' then begin
    Result := DefaultValue;
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLTemplateParameter.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'ParameterType' then begin
    ParameterType := Value;
  end
  else if Name = 'DefaultValue' then begin
    DefaultValue := Value;
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLTemplateParameter.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'DefaultElement' then begin
    Result := DefaultElement;
  end
  else if Name = 'Template' then begin
    Result := Template;
  end
  else if Name = 'Parameter' then begin
    Result := Parameter;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLTemplateParameter.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'DefaultElement' then begin
    DefaultElement := Value as PUMLModelElement;
  end
  else if Name = 'Template' then begin
    Template := Value as PUMLModelElement;
  end
  else if Name = 'Parameter' then begin
    Parameter := Value as PUMLModelElement;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLTemplateParameter.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLTemplateParameter.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLTemplateParameter.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLTemplateParameter.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLTemplateParameter.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLTemplateParameter.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLTemplateParameter.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLTemplateParameter.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLTemplateParameter
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLTemplateArgument

constructor PUMLTemplateArgument.Create;
begin
  inherited;
  FModelElement := nil;
end;

destructor PUMLTemplateArgument.Destroy;
begin
  inherited;
end;

procedure PUMLTemplateArgument.SetModelElement(Value: PUMLModelElement);
begin
  if FModelElement <> Value then begin
    if FModelElement <> nil then ModelElement.FTemplateArguments.Remove(Self);
    FModelElement := Value;
    if Value <> nil then begin
      Value.FTemplateArguments.Add(Self);
    end;
  end;
end;

function PUMLTemplateArgument.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLTemplateArgument.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLTemplateArgument.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'ModelElement' then begin
    Result := ModelElement;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLTemplateArgument.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'ModelElement' then begin
    ModelElement := Value as PUMLModelElement;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLTemplateArgument.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLTemplateArgument.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLTemplateArgument.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLTemplateArgument.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLTemplateArgument.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLTemplateArgument.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLTemplateArgument.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLTemplateArgument.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLTemplateArgument
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLElementImport

constructor PUMLElementImport.Create;
begin
  inherited;
  FImportedElement := nil;
  FPackage := nil;
end;

destructor PUMLElementImport.Destroy;
begin
  inherited;
end;

procedure PUMLElementImport.SetVisibility(Value: PUMLVisibilityKind);
begin
  if FVisibility <> Value then
    FVisibility := Value;
end;

procedure PUMLElementImport.SetAlias(Value: string);
begin
  if FAlias <> Value then
    FAlias := Value;
end;

procedure PUMLElementImport.SetIsSpecification(Value: Boolean);
begin
  if FIsSpecification <> Value then
    FIsSpecification := Value;
end;

procedure PUMLElementImport.SetImportedElement(Value: PUMLModelElement);
begin
  if FImportedElement <> Value then begin
    if FImportedElement <> nil then ImportedElement.FElementImports.Remove(Self);
    FImportedElement := Value;
    if Value <> nil then begin
      Value.FElementImports.Add(Self);
    end;
  end;
end;

procedure PUMLElementImport.SetPackage(Value: PUMLPackage);
begin
  if FPackage <> Value then begin
    if FPackage <> nil then begin
      FPackage.FElementImportItems.Remove(Self);
      FPackage.RemoveVirtualOwnedModel(Self);
    end;
    FPackage := Value;
    if Value <> nil then begin
      Value.FElementImportItems.Add(Self);
      Value.AddVirtualOwnedModel(Self);
    end;
  end;
end;

function PUMLElementImport.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'Visibility' then begin
    Result := UMLVisibilityKindToString(Visibility);
  end
  else if Name = 'Alias' then begin
    Result := Alias;
  end
  else if Name = 'IsSpecification' then begin
    Result := BooleanToString(IsSpecification);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLElementImport.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'Visibility' then begin
    Visibility := StringToUMLVisibilityKind(Value);
  end
  else if Name = 'Alias' then begin
    Alias := Value;
  end
  else if Name = 'IsSpecification' then begin
    IsSpecification := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLElementImport.MOF_GetReference(Name: string): PElement;
begin
  if Name = 'ImportedElement' then begin
    Result := ImportedElement;
  end
  else if Name = 'Package' then begin
    Result := Package;
  end
  else begin
    Result := inherited MOF_GetReference(Name);
  end;
end;

procedure PUMLElementImport.MOF_SetReference(Name: string; Value: PElement);
begin
  if Name = 'ImportedElement' then begin
    ImportedElement := Value as PUMLModelElement;
  end
  else if Name = 'Package' then begin
    Package := Value as PUMLPackage;
  end
  else begin
    inherited MOF_SetReference(Name, Value);
  end;
end;

procedure PUMLElementImport.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLElementImport.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLElementImport.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLElementImport.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLElementImport.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLElementImport.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLElementImport.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLElementImport.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLElementImport
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLDiagram

constructor PUMLDiagram.Create;
begin
  inherited;
end;

destructor PUMLDiagram.Destroy;
begin
  inherited;
end;

function PUMLDiagram.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLDiagram.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLDiagram.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLDiagram.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLDiagram.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLDiagram.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLDiagram.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLDiagram.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLDiagram.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLDiagram.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLDiagram.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLDiagram.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLDiagram
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLDeploymentDiagram

constructor PUMLDeploymentDiagram.Create;
begin
  inherited;
end;

destructor PUMLDeploymentDiagram.Destroy;
begin
  inherited;
end;

function PUMLDeploymentDiagram.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLDeploymentDiagram.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLDeploymentDiagram.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLDeploymentDiagram.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLDeploymentDiagram.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLDeploymentDiagram.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLDeploymentDiagram.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLDeploymentDiagram.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLDeploymentDiagram.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLDeploymentDiagram.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLDeploymentDiagram.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLDeploymentDiagram.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLDeploymentDiagram
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLComponentDiagram

constructor PUMLComponentDiagram.Create;
begin
  inherited;
end;

destructor PUMLComponentDiagram.Destroy;
begin
  inherited;
end;

function PUMLComponentDiagram.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLComponentDiagram.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLComponentDiagram.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLComponentDiagram.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLComponentDiagram.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLComponentDiagram.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLComponentDiagram.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLComponentDiagram.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLComponentDiagram.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLComponentDiagram.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLComponentDiagram.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLComponentDiagram.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLComponentDiagram
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSequenceDiagram

constructor PUMLSequenceDiagram.Create;
begin
  inherited;
end;

destructor PUMLSequenceDiagram.Destroy;
begin
  inherited;
end;

procedure PUMLSequenceDiagram.SetShowSequenceNumber(Value: Boolean);
begin
  if FShowSequenceNumber <> Value then
    FShowSequenceNumber := Value;
end;

procedure PUMLSequenceDiagram.SetMessageSignature(Value: PUMLMessageSignatureKind);
begin
  if FMessageSignature <> Value then
    FMessageSignature := Value;
end;

procedure PUMLSequenceDiagram.SetShowActivation(Value: Boolean);
begin
  if FShowActivation <> Value then
    FShowActivation := Value;
end;

function PUMLSequenceDiagram.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'ShowSequenceNumber' then begin
    Result := BooleanToString(ShowSequenceNumber);
  end
  else if Name = 'MessageSignature' then begin
    Result := UMLMessageSignatureKindToString(MessageSignature);
  end
  else if Name = 'ShowActivation' then begin
    Result := BooleanToString(ShowActivation);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLSequenceDiagram.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'ShowSequenceNumber' then begin
    ShowSequenceNumber := StringToBoolean(Value);
  end
  else if Name = 'MessageSignature' then begin
    MessageSignature := StringToUMLMessageSignatureKind(Value);
  end
  else if Name = 'ShowActivation' then begin
    ShowActivation := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLSequenceDiagram.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLSequenceDiagram.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLSequenceDiagram.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLSequenceDiagram.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLSequenceDiagram.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLSequenceDiagram.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLSequenceDiagram.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLSequenceDiagram.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLSequenceDiagram.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLSequenceDiagram.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

function PUMLSequenceDiagram.CanRelocateTo(Model: PModel): Boolean;
begin
  Result := False;
end;

function PUMLSequenceDiagram.CanCopy: Boolean;
begin
  Result := False;
end;

// PUMLSequenceDiagram
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLCollaborationDiagram

constructor PUMLCollaborationDiagram.Create;
begin
  inherited;
end;

destructor PUMLCollaborationDiagram.Destroy;
begin
  inherited;
end;

procedure PUMLCollaborationDiagram.SetShowSequenceNumber(Value: Boolean);
begin
  if FShowSequenceNumber <> Value then
    FShowSequenceNumber := Value;
end;

procedure PUMLCollaborationDiagram.SetMessageSignature(Value: PUMLMessageSignatureKind);
begin
  if FMessageSignature <> Value then
    FMessageSignature := Value;
end;

function PUMLCollaborationDiagram.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'ShowSequenceNumber' then begin
    Result := BooleanToString(ShowSequenceNumber);
  end
  else if Name = 'MessageSignature' then begin
    Result := UMLMessageSignatureKindToString(MessageSignature);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLCollaborationDiagram.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'ShowSequenceNumber' then begin
    ShowSequenceNumber := StringToBoolean(Value);
  end
  else if Name = 'MessageSignature' then begin
    MessageSignature := StringToUMLMessageSignatureKind(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLCollaborationDiagram.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLCollaborationDiagram.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLCollaborationDiagram.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLCollaborationDiagram.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLCollaborationDiagram.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLCollaborationDiagram.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLCollaborationDiagram.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLCollaborationDiagram.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLCollaborationDiagram.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLCollaborationDiagram.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

function PUMLCollaborationDiagram.CanRelocateTo(Model: PModel): Boolean;
begin
  Result := False;
end;

function PUMLCollaborationDiagram.CanCopy: Boolean;
begin
  Result := False;
end;

// PUMLCollaborationDiagram
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLSequenceRoleDiagram

constructor PUMLSequenceRoleDiagram.Create;
begin
  inherited;
end;

destructor PUMLSequenceRoleDiagram.Destroy;
begin
  inherited;
end;

procedure PUMLSequenceRoleDiagram.SetShowSequenceNumber(Value: Boolean);
begin
  if FShowSequenceNumber <> Value then
    FShowSequenceNumber := Value;
end;

procedure PUMLSequenceRoleDiagram.SetMessageSignature(Value: PUMLMessageSignatureKind);
begin
  if FMessageSignature <> Value then
    FMessageSignature := Value;
end;

procedure PUMLSequenceRoleDiagram.SetShowActivation(Value: Boolean);
begin
  if FShowActivation <> Value then
    FShowActivation := Value;
end;

function PUMLSequenceRoleDiagram.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'ShowSequenceNumber' then begin
    Result := BooleanToString(ShowSequenceNumber);
  end
  else if Name = 'MessageSignature' then begin
    Result := UMLMessageSignatureKindToString(MessageSignature);
  end
  else if Name = 'ShowActivation' then begin
    Result := BooleanToString(ShowActivation);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLSequenceRoleDiagram.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'ShowSequenceNumber' then begin
    ShowSequenceNumber := StringToBoolean(Value);
  end
  else if Name = 'MessageSignature' then begin
    MessageSignature := StringToUMLMessageSignatureKind(Value);
  end
  else if Name = 'ShowActivation' then begin
    ShowActivation := StringToBoolean(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLSequenceRoleDiagram.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLSequenceRoleDiagram.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLSequenceRoleDiagram.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLSequenceRoleDiagram.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLSequenceRoleDiagram.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLSequenceRoleDiagram.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLSequenceRoleDiagram.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLSequenceRoleDiagram.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLSequenceRoleDiagram.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLSequenceRoleDiagram.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

function PUMLSequenceRoleDiagram.CanRelocateTo(Model: PModel): Boolean;
begin
  Result := False;
end;

function PUMLSequenceRoleDiagram.CanCopy: Boolean;
begin
  Result := False;
end;

// PUMLSequenceRoleDiagram
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLUseCaseDiagram

constructor PUMLUseCaseDiagram.Create;
begin
  inherited;
end;

destructor PUMLUseCaseDiagram.Destroy;
begin
  inherited;
end;

function PUMLUseCaseDiagram.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLUseCaseDiagram.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLUseCaseDiagram.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLUseCaseDiagram.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLUseCaseDiagram.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLUseCaseDiagram.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLUseCaseDiagram.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLUseCaseDiagram.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLUseCaseDiagram.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLUseCaseDiagram.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLUseCaseDiagram.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLUseCaseDiagram.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLUseCaseDiagram
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLClassDiagram

constructor PUMLClassDiagram.Create;
begin
  inherited;
end;

destructor PUMLClassDiagram.Destroy;
begin
  inherited;
end;

function PUMLClassDiagram.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLClassDiagram.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLClassDiagram.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLClassDiagram.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLClassDiagram.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLClassDiagram.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLClassDiagram.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLClassDiagram.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLClassDiagram.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLClassDiagram.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLClassDiagram.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLClassDiagram.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLClassDiagram
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLActivityDiagram

constructor PUMLActivityDiagram.Create;
begin
  inherited;
end;

destructor PUMLActivityDiagram.Destroy;
begin
  inherited;
end;

function PUMLActivityDiagram.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLActivityDiagram.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLActivityDiagram.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLActivityDiagram.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLActivityDiagram.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLActivityDiagram.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLActivityDiagram.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLActivityDiagram.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLActivityDiagram.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLActivityDiagram.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLActivityDiagram.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLActivityDiagram.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

function PUMLActivityDiagram.CanRelocateTo(Model: PModel): Boolean;
begin
  Result := False;
end;

// PUMLActivityDiagram
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLCollaborationRoleDiagram

constructor PUMLCollaborationRoleDiagram.Create;
begin
  inherited;
end;

destructor PUMLCollaborationRoleDiagram.Destroy;
begin
  inherited;
end;

procedure PUMLCollaborationRoleDiagram.SetShowSequenceNumber(Value: Boolean);
begin
  if FShowSequenceNumber <> Value then
    FShowSequenceNumber := Value;
end;

procedure PUMLCollaborationRoleDiagram.SetMessageSignature(Value: PUMLMessageSignatureKind);
begin
  if FMessageSignature <> Value then
    FMessageSignature := Value;
end;

function PUMLCollaborationRoleDiagram.MOF_GetAttribute(Name: string): string;
begin
  if Name = 'ShowSequenceNumber' then begin
    Result := BooleanToString(ShowSequenceNumber);
  end
  else if Name = 'MessageSignature' then begin
    Result := UMLMessageSignatureKindToString(MessageSignature);
  end
  else begin
    Result := inherited MOF_GetAttribute(Name);
  end;
end;

procedure PUMLCollaborationRoleDiagram.MOF_SetAttribute(Name, Value: string);
begin
  if Name = 'ShowSequenceNumber' then begin
    ShowSequenceNumber := StringToBoolean(Value);
  end
  else if Name = 'MessageSignature' then begin
    MessageSignature := StringToUMLMessageSignatureKind(Value);
  end
  else begin
    inherited MOF_SetAttribute(Name, Value);
  end;
end;

function PUMLCollaborationRoleDiagram.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLCollaborationRoleDiagram.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLCollaborationRoleDiagram.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLCollaborationRoleDiagram.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLCollaborationRoleDiagram.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLCollaborationRoleDiagram.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLCollaborationRoleDiagram.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLCollaborationRoleDiagram.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLCollaborationRoleDiagram.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLCollaborationRoleDiagram.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

function PUMLCollaborationRoleDiagram.CanRelocateTo(Model: PModel): Boolean;
begin
  Result := False;
end;

function PUMLCollaborationRoleDiagram.CanCopy: Boolean;
begin
  Result := False;
end;

// PUMLCollaborationRoleDiagram
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLCompositeStructureDiagram

constructor PUMLCompositeStructureDiagram.Create;
begin
  inherited;
end;

destructor PUMLCompositeStructureDiagram.Destroy;
begin
  inherited;
end;

function PUMLCompositeStructureDiagram.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLCompositeStructureDiagram.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLCompositeStructureDiagram.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLCompositeStructureDiagram.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLCompositeStructureDiagram.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLCompositeStructureDiagram.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLCompositeStructureDiagram.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLCompositeStructureDiagram.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLCompositeStructureDiagram.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLCompositeStructureDiagram.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLCompositeStructureDiagram.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLCompositeStructureDiagram.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

// PUMLCompositeStructureDiagram
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// PUMLStatechartDiagram

constructor PUMLStatechartDiagram.Create;
begin
  inherited;
end;

destructor PUMLStatechartDiagram.Destroy;
begin
  inherited;
end;

function PUMLStatechartDiagram.MOF_GetAttribute(Name: string): string;
begin
  Result := inherited MOF_GetAttribute(Name);
end;

procedure PUMLStatechartDiagram.MOF_SetAttribute(Name, Value: string);
begin
  inherited MOF_SetAttribute(Name, Value);
end;

function PUMLStatechartDiagram.MOF_GetReference(Name: string): PElement;
begin
  Result := inherited MOF_GetReference(Name);
end;

procedure PUMLStatechartDiagram.MOF_SetReference(Name: string; Value: PElement);
begin
  inherited MOF_SetReference(Name, Value);
end;

procedure PUMLStatechartDiagram.MOF_AddCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_AddCollectionItem(Name, Value);
end;

procedure PUMLStatechartDiagram.MOF_RemoveCollectionItem(Name: string; Value: PElement);
begin
  inherited MOF_RemoveCollectionItem(Name, Value);
end;

procedure PUMLStatechartDiagram.MOF_InsertCollectionItem(Name: string; Index: Integer; Value: PElement);
begin
  inherited MOF_InsertCollectionItem(Name, Index, Value);
end;

procedure PUMLStatechartDiagram.MOF_DeleteCollectionItem(Name: string; Index: Integer);
begin
  inherited MOF_DeleteCollectionItem(Name, Index);
end;

procedure PUMLStatechartDiagram.MOF_ClearCollection(Name: string);
begin
  inherited MOF_ClearCollection(Name);
end;

function PUMLStatechartDiagram.MOF_IndexOfCollectionItem(Name: string; Value: PElement): Integer;
begin
  Result := inherited MOF_IndexOfCollectionItem(Name, Value);
end;

function PUMLStatechartDiagram.MOF_GetCollectionItem(Name: string; Index: Integer): PElement;
begin
  Result := inherited MOF_GetCollectionItem(Name, Index);
end;

function PUMLStatechartDiagram.MOF_GetCollectionCount(Name: string): Integer;
begin
  Result := inherited MOF_GetCollectionCount(Name);
end;

function PUMLStatechartDiagram.CanRelocateTo(Model: PModel): Boolean;
begin
  Result := False;
end;

// PUMLStatechartDiagram
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// Enumeration Conversion Functions

function UMLAggregationKindToString(Value: PUMLAggregationKind): string;
begin
  if Value = akNone then
    Result := 'akNone'
  else if Value = akAggregate then
    Result := 'akAggregate'
  else if Value = akComposite then
    Result := 'akComposite'
  else
    Result := 'akNone';
end;

function StringToUMLAggregationKind(Value: string): PUMLAggregationKind;
begin
  if Value = 'akNone' then
    Result := akNone
  else if Value = 'akAggregate' then
    Result := akAggregate
  else if Value = 'akComposite' then
    Result := akComposite
  else
    Result := akNone;
end;

function UMLCallConcurrencyKindToString(Value: PUMLCallConcurrencyKind): string;
begin
  if Value = cckSequential then
    Result := 'cckSequential'
  else if Value = cckGuarded then
    Result := 'cckGuarded'
  else if Value = cckConcurrent then
    Result := 'cckConcurrent'
  else
    Result := 'cckSequential';
end;

function StringToUMLCallConcurrencyKind(Value: string): PUMLCallConcurrencyKind;
begin
  if Value = 'cckSequential' then
    Result := cckSequential
  else if Value = 'cckGuarded' then
    Result := cckGuarded
  else if Value = 'cckConcurrent' then
    Result := cckConcurrent
  else
    Result := cckSequential;
end;

function UMLChangeableKindToString(Value: PUMLChangeableKind): string;
begin
  if Value = ckChangeable then
    Result := 'ckChangeable'
  else if Value = ckFrozen then
    Result := 'ckFrozen'
  else if Value = ckAddOnly then
    Result := 'ckAddOnly'
  else
    Result := 'ckChangeable';
end;

function StringToUMLChangeableKind(Value: string): PUMLChangeableKind;
begin
  if Value = 'ckChangeable' then
    Result := ckChangeable
  else if Value = 'ckFrozen' then
    Result := ckFrozen
  else if Value = 'ckAddOnly' then
    Result := ckAddOnly
  else
    Result := ckChangeable;
end;

function UMLOrderingKindToString(Value: PUMLOrderingKind): string;
begin
  if Value = okUnordered then
    Result := 'okUnordered'
  else if Value = okOrdered then
    Result := 'okOrdered'
  else
    Result := 'okUnordered';
end;

function StringToUMLOrderingKind(Value: string): PUMLOrderingKind;
begin
  if Value = 'okUnordered' then
    Result := okUnordered
  else if Value = 'okOrdered' then
    Result := okOrdered
  else
    Result := okUnordered;
end;

function UMLParameterDirectionKindToString(Value: PUMLParameterDirectionKind): string;
begin
  if Value = pdkIn then
    Result := 'pdkIn'
  else if Value = pdkInout then
    Result := 'pdkInout'
  else if Value = pdkOut then
    Result := 'pdkOut'
  else if Value = pdkReturn then
    Result := 'pdkReturn'
  else
    Result := 'pdkIn';
end;

function StringToUMLParameterDirectionKind(Value: string): PUMLParameterDirectionKind;
begin
  if Value = 'pdkIn' then
    Result := pdkIn
  else if Value = 'pdkInout' then
    Result := pdkInout
  else if Value = 'pdkOut' then
    Result := pdkOut
  else if Value = 'pdkReturn' then
    Result := pdkReturn
  else
    Result := pdkIn;
end;

function UMLScopeKindToString(Value: PUMLScopeKind): string;
begin
  if Value = skInstance then
    Result := 'skInstance'
  else if Value = skClassifier then
    Result := 'skClassifier'
  else
    Result := 'skInstance';
end;

function StringToUMLScopeKind(Value: string): PUMLScopeKind;
begin
  if Value = 'skInstance' then
    Result := skInstance
  else if Value = 'skClassifier' then
    Result := skClassifier
  else
    Result := skInstance;
end;

function UMLVisibilityKindToString(Value: PUMLVisibilityKind): string;
begin
  if Value = vkPublic then
    Result := 'vkPublic'
  else if Value = vkProtected then
    Result := 'vkProtected'
  else if Value = vkPrivate then
    Result := 'vkPrivate'
  else if Value = vkPackage then
    Result := 'vkPackage'
  else
    Result := 'vkPublic';
end;

function StringToUMLVisibilityKind(Value: string): PUMLVisibilityKind;
begin
  if Value = 'vkPublic' then
    Result := vkPublic
  else if Value = 'vkProtected' then
    Result := vkProtected
  else if Value = 'vkPrivate' then
    Result := vkPrivate
  else if Value = 'vkPackage' then
    Result := vkPackage
  else
    Result := vkPublic;
end;

function UMLPseudostateKindToString(Value: PUMLPseudostateKind): string;
begin
  if Value = pkChoice then
    Result := 'pkChoice'
  else if Value = pkDeepHistory then
    Result := 'pkDeepHistory'
  else if Value = pkSynchronization then
    Result := 'pkSynchronization'
  else if Value = pkInitial then
    Result := 'pkInitial'
  else if Value = pkJunction then
    Result := 'pkJunction'
  else if Value = pkShallowHistory then
    Result := 'pkShallowHistory'
  else if Value = pkDecision then
    Result := 'pkDecision'
  else
    Result := 'pkChoice';
end;

function StringToUMLPseudostateKind(Value: string): PUMLPseudostateKind;
begin
  if Value = 'pkChoice' then
    Result := pkChoice
  else if Value = 'pkDeepHistory' then
    Result := pkDeepHistory
  else if Value = 'pkSynchronization' then
    Result := pkSynchronization
  else if Value = 'pkInitial' then
    Result := pkInitial
  else if Value = 'pkJunction' then
    Result := pkJunction
  else if Value = 'pkShallowHistory' then
    Result := pkShallowHistory
  else if Value = 'pkDecision' then
    Result := pkDecision
  else
    Result := pkChoice;
end;

function UMLInteractionOperatorKindToString(Value: PUMLInteractionOperatorKind): string;
begin
  if Value = iokSeq then
    Result := 'iokSeq'
  else if Value = iokAlt then
    Result := 'iokAlt'
  else if Value = iokOpt then
    Result := 'iokOpt'
  else if Value = iokBreak then
    Result := 'iokBreak'
  else if Value = iokPar then
    Result := 'iokPar'
  else if Value = iokStrict then
    Result := 'iokStrict'
  else if Value = iokLoop then
    Result := 'iokLoop'
  else if Value = iokRegion then
    Result := 'iokRegion'
  else if Value = iokNeg then
    Result := 'iokNeg'
  else if Value = iokAssert then
    Result := 'iokAssert'
  else if Value = iokIgnore then
    Result := 'iokIgnore'
  else if Value = iokConsider then
    Result := 'iokConsider'
  else
    Result := 'iokSeq';
end;

function StringToUMLInteractionOperatorKind(Value: string): PUMLInteractionOperatorKind;
begin
  if Value = 'iokSeq' then
    Result := iokSeq
  else if Value = 'iokAlt' then
    Result := iokAlt
  else if Value = 'iokOpt' then
    Result := iokOpt
  else if Value = 'iokBreak' then
    Result := iokBreak
  else if Value = 'iokPar' then
    Result := iokPar
  else if Value = 'iokStrict' then
    Result := iokStrict
  else if Value = 'iokLoop' then
    Result := iokLoop
  else if Value = 'iokRegion' then
    Result := iokRegion
  else if Value = 'iokNeg' then
    Result := iokNeg
  else if Value = 'iokAssert' then
    Result := iokAssert
  else if Value = 'iokIgnore' then
    Result := iokIgnore
  else if Value = 'iokConsider' then
    Result := iokConsider
  else
    Result := iokSeq;
end;

function UMLMessageSignatureKindToString(Value: PUMLMessageSignatureKind): string;
begin
  if Value = mskNone then
    Result := 'mskNone'
  else if Value = mskTypeOnly then
    Result := 'mskTypeOnly'
  else if Value = mskNameOnly then
    Result := 'mskNameOnly'
  else if Value = mskNameAndType then
    Result := 'mskNameAndType'
  else
    Result := 'mskNone';
end;

function StringToUMLMessageSignatureKind(Value: string): PUMLMessageSignatureKind;
begin
  if Value = 'mskNone' then
    Result := mskNone
  else if Value = 'mskTypeOnly' then
    Result := mskTypeOnly
  else if Value = 'mskNameOnly' then
    Result := mskNameOnly
  else if Value = 'mskNameAndType' then
    Result := mskNameAndType
  else
    Result := mskNone;
end;

// Enumeration Conversion Functions
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Class Register Function

procedure RegisterClasses;
begin
  ClassRegistry.RegisterClass(PUMLElement);
  ClassRegistry.RegisterClass(PUMLModelElement);
  ClassRegistry.RegisterClass(PUMLLinkEnd);
  ClassRegistry.RegisterClass(PUMLLinkObject);
  ClassRegistry.RegisterClass(PUMLPartition);
  ClassRegistry.RegisterClass(PUMLInteractionFragment);
  ClassRegistry.RegisterClass(PUMLInteractionOperand);
  ClassRegistry.RegisterClass(PUMLCombinedFragment);
  ClassRegistry.RegisterClass(PUMLInteractionInstanceSet);
  ClassRegistry.RegisterClass(PUMLInstance);
  ClassRegistry.RegisterClass(PUMLDataValue);
  ClassRegistry.RegisterClass(PUMLNodeInstance);
  ClassRegistry.RegisterClass(PUMLObject);
  ClassRegistry.RegisterClass(PUMLSubsystemInstance);
  ClassRegistry.RegisterClass(PUMLUseCaseInstance);
  ClassRegistry.RegisterClass(PUMLComponentInstance);
  ClassRegistry.RegisterClass(PUMLArgument);
  ClassRegistry.RegisterClass(PUMLConnectorEnd);
  ClassRegistry.RegisterClass(PUMLStateVertex);
  ClassRegistry.RegisterClass(PUMLSynchState);
  ClassRegistry.RegisterClass(PUMLPseudostate);
  ClassRegistry.RegisterClass(PUMLStubState);
  ClassRegistry.RegisterClass(PUMLState);
  ClassRegistry.RegisterClass(PUMLSimpleState);
  ClassRegistry.RegisterClass(PUMLObjectFlowState);
  ClassRegistry.RegisterClass(PUMLActionState);
  ClassRegistry.RegisterClass(PUMLSignalAcceptState);
  ClassRegistry.RegisterClass(PUMLCallState);
  ClassRegistry.RegisterClass(PUMLSignalSendState);
  ClassRegistry.RegisterClass(PUMLCompositeState);
  ClassRegistry.RegisterClass(PUMLSubmachineState);
  ClassRegistry.RegisterClass(PUMLSubactivityState);
  ClassRegistry.RegisterClass(PUMLFinalState);
  ClassRegistry.RegisterClass(PUMLFlowFinalState);
  ClassRegistry.RegisterClass(PUMLInteraction);
  ClassRegistry.RegisterClass(PUMLMessage);
  ClassRegistry.RegisterClass(PUMLAssociationClass);
  ClassRegistry.RegisterClass(PUMLStateMachine);
  ClassRegistry.RegisterClass(PUMLActivityGraph);
  ClassRegistry.RegisterClass(PUMLFeature);
  ClassRegistry.RegisterClass(PUMLBehavioralFeature);
  ClassRegistry.RegisterClass(PUMLMethod);
  ClassRegistry.RegisterClass(PUMLOperation);
  ClassRegistry.RegisterClass(PUMLReception);
  ClassRegistry.RegisterClass(PUMLConnector);
  ClassRegistry.RegisterClass(PUMLStructuralFeature);
  ClassRegistry.RegisterClass(PUMLAttribute);
  ClassRegistry.RegisterClass(PUMLPort);
  ClassRegistry.RegisterClass(PUMLGeneralizableElement);
  ClassRegistry.RegisterClass(PUMLNamespace);
  ClassRegistry.RegisterClass(PUMLCollaboration);
  ClassRegistry.RegisterClass(PUMLClassifier);
  ClassRegistry.RegisterClass(PUMLUseCase);
  ClassRegistry.RegisterClass(PUMLActor);
  ClassRegistry.RegisterClass(PUMLClassifierInState);
  ClassRegistry.RegisterClass(PUMLInterface);
  ClassRegistry.RegisterClass(PUMLPackage);
  ClassRegistry.RegisterClass(PUMLSubsystem);
  ClassRegistry.RegisterClass(PUMLProject);
  ClassRegistry.RegisterClass(PUMLModel);
  ClassRegistry.RegisterClass(PUMLDataType);
  ClassRegistry.RegisterClass(PUMLProgrammingLanguageDataType);
  ClassRegistry.RegisterClass(PUMLPrimitive);
  ClassRegistry.RegisterClass(PUMLEnumeration);
  ClassRegistry.RegisterClass(PUMLClass);
  ClassRegistry.RegisterClass(PUMLNode);
  ClassRegistry.RegisterClass(PUMLArtifact);
  ClassRegistry.RegisterClass(PUMLComponent);
  ClassRegistry.RegisterClass(PUMLSignal);
  ClassRegistry.RegisterClass(PUMLException);
  ClassRegistry.RegisterClass(PUMLClassifierRole);
  ClassRegistry.RegisterClass(PUMLEvent);
  ClassRegistry.RegisterClass(PUMLChangeEvent);
  ClassRegistry.RegisterClass(PUMLSignalEvent);
  ClassRegistry.RegisterClass(PUMLTimeEvent);
  ClassRegistry.RegisterClass(PUMLCallEvent);
  ClassRegistry.RegisterClass(PUMLEnumerationLiteral);
  ClassRegistry.RegisterClass(PUMLStimulus);
  ClassRegistry.RegisterClass(PUMLAttributeLink);
  ClassRegistry.RegisterClass(PUMLRelationship);
  ClassRegistry.RegisterClass(PUMLGeneralization);
  ClassRegistry.RegisterClass(PUMLInclude);
  ClassRegistry.RegisterClass(PUMLDependency);
  ClassRegistry.RegisterClass(PUMLRealization);
  ClassRegistry.RegisterClass(PUMLExtend);
  ClassRegistry.RegisterClass(PUMLAssociation);
  ClassRegistry.RegisterClass(PUMLAssociationRole);
  ClassRegistry.RegisterClass(PUMLAction);
  ClassRegistry.RegisterClass(PUMLTerminateAction);
  ClassRegistry.RegisterClass(PUMLSendAction);
  ClassRegistry.RegisterClass(PUMLActionSequence);
  ClassRegistry.RegisterClass(PUMLCreateAction);
  ClassRegistry.RegisterClass(PUMLDestroyAction);
  ClassRegistry.RegisterClass(PUMLUninterpretedAction);
  ClassRegistry.RegisterClass(PUMLCallAction);
  ClassRegistry.RegisterClass(PUMLReturnAction);
  ClassRegistry.RegisterClass(PUMLFrame);
  ClassRegistry.RegisterClass(PUMLCollaborationInstanceSet);
  ClassRegistry.RegisterClass(PUMLParameter);
  ClassRegistry.RegisterClass(PUMLAssociationEnd);
  ClassRegistry.RegisterClass(PUMLAssociationEndRole);
  ClassRegistry.RegisterClass(PUMLTransition);
  ClassRegistry.RegisterClass(PUMLExtensionPoint);
  ClassRegistry.RegisterClass(PUMLLink);
  ClassRegistry.RegisterClass(PUMLComment);
  ClassRegistry.RegisterClass(PUMLTemplateParameter);
  ClassRegistry.RegisterClass(PUMLTemplateArgument);
  ClassRegistry.RegisterClass(PUMLElementImport);
  ClassRegistry.RegisterClass(PUMLDiagram);
  ClassRegistry.RegisterClass(PUMLDeploymentDiagram);
  ClassRegistry.RegisterClass(PUMLComponentDiagram);
  ClassRegistry.RegisterClass(PUMLSequenceDiagram);
  ClassRegistry.RegisterClass(PUMLCollaborationDiagram);
  ClassRegistry.RegisterClass(PUMLSequenceRoleDiagram);
  ClassRegistry.RegisterClass(PUMLUseCaseDiagram);
  ClassRegistry.RegisterClass(PUMLClassDiagram);
  ClassRegistry.RegisterClass(PUMLActivityDiagram);
  ClassRegistry.RegisterClass(PUMLCollaborationRoleDiagram);
  ClassRegistry.RegisterClass(PUMLCompositeStructureDiagram);
  ClassRegistry.RegisterClass(PUMLStatechartDiagram);
end;

// Class Register Function
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// MetaClass Register Function

procedure RegisterMetaClasses;
var
  E: PMetaEnumeration;
  M: PMetaClass;
begin
  // Enumerations
  E := MetaModel.DefineMetaEnumeration('UMLAggregationKind');
  MetaModel.DefineMetaLiteral(E, 'akNone');
  MetaModel.DefineMetaLiteral(E, 'akAggregate');
  MetaModel.DefineMetaLiteral(E, 'akComposite');
  E := MetaModel.DefineMetaEnumeration('UMLCallConcurrencyKind');
  MetaModel.DefineMetaLiteral(E, 'cckSequential');
  MetaModel.DefineMetaLiteral(E, 'cckGuarded');
  MetaModel.DefineMetaLiteral(E, 'cckConcurrent');
  E := MetaModel.DefineMetaEnumeration('UMLChangeableKind');
  MetaModel.DefineMetaLiteral(E, 'ckChangeable');
  MetaModel.DefineMetaLiteral(E, 'ckFrozen');
  MetaModel.DefineMetaLiteral(E, 'ckAddOnly');
  E := MetaModel.DefineMetaEnumeration('UMLOrderingKind');
  MetaModel.DefineMetaLiteral(E, 'okUnordered');
  MetaModel.DefineMetaLiteral(E, 'okOrdered');
  E := MetaModel.DefineMetaEnumeration('UMLParameterDirectionKind');
  MetaModel.DefineMetaLiteral(E, 'pdkIn');
  MetaModel.DefineMetaLiteral(E, 'pdkInout');
  MetaModel.DefineMetaLiteral(E, 'pdkOut');
  MetaModel.DefineMetaLiteral(E, 'pdkReturn');
  E := MetaModel.DefineMetaEnumeration('UMLScopeKind');
  MetaModel.DefineMetaLiteral(E, 'skInstance');
  MetaModel.DefineMetaLiteral(E, 'skClassifier');
  E := MetaModel.DefineMetaEnumeration('UMLVisibilityKind');
  MetaModel.DefineMetaLiteral(E, 'vkPublic');
  MetaModel.DefineMetaLiteral(E, 'vkProtected');
  MetaModel.DefineMetaLiteral(E, 'vkPrivate');
  MetaModel.DefineMetaLiteral(E, 'vkPackage');
  E := MetaModel.DefineMetaEnumeration('UMLPseudostateKind');
  MetaModel.DefineMetaLiteral(E, 'pkChoice');
  MetaModel.DefineMetaLiteral(E, 'pkDeepHistory');
  MetaModel.DefineMetaLiteral(E, 'pkSynchronization');
  MetaModel.DefineMetaLiteral(E, 'pkInitial');
  MetaModel.DefineMetaLiteral(E, 'pkJunction');
  MetaModel.DefineMetaLiteral(E, 'pkShallowHistory');
  MetaModel.DefineMetaLiteral(E, 'pkDecision');
  E := MetaModel.DefineMetaEnumeration('UMLInteractionOperatorKind');
  MetaModel.DefineMetaLiteral(E, 'iokSeq');
  MetaModel.DefineMetaLiteral(E, 'iokAlt');
  MetaModel.DefineMetaLiteral(E, 'iokOpt');
  MetaModel.DefineMetaLiteral(E, 'iokBreak');
  MetaModel.DefineMetaLiteral(E, 'iokPar');
  MetaModel.DefineMetaLiteral(E, 'iokStrict');
  MetaModel.DefineMetaLiteral(E, 'iokLoop');
  MetaModel.DefineMetaLiteral(E, 'iokRegion');
  MetaModel.DefineMetaLiteral(E, 'iokNeg');
  MetaModel.DefineMetaLiteral(E, 'iokAssert');
  MetaModel.DefineMetaLiteral(E, 'iokIgnore');
  MetaModel.DefineMetaLiteral(E, 'iokConsider');
  E := MetaModel.DefineMetaEnumeration('UMLMessageSignatureKind');
  MetaModel.DefineMetaLiteral(E, 'mskNone');
  MetaModel.DefineMetaLiteral(E, 'mskTypeOnly');
  MetaModel.DefineMetaLiteral(E, 'mskNameOnly');
  MetaModel.DefineMetaLiteral(E, 'mskNameAndType');
  // Meta Classes
  MetaModel.DefineMetaClass(PUMLElement, 'UMLElement', True);
  MetaModel.DefineMetaClass(PUMLModelElement, 'UMLModelElement', True);
  MetaModel.DefineMetaClass(PUMLLinkEnd, 'UMLLinkEnd', False);
  MetaModel.DefineMetaClass(PUMLLinkObject, 'UMLLinkObject', False);
  MetaModel.DefineMetaClass(PUMLPartition, 'UMLPartition', False);
  MetaModel.DefineMetaClass(PUMLInteractionFragment, 'UMLInteractionFragment', True);
  MetaModel.DefineMetaClass(PUMLInteractionOperand, 'UMLInteractionOperand', False);
  MetaModel.DefineMetaClass(PUMLCombinedFragment, 'UMLCombinedFragment', False);
  MetaModel.DefineMetaClass(PUMLInteractionInstanceSet, 'UMLInteractionInstanceSet', False);
  MetaModel.DefineMetaClass(PUMLInstance, 'UMLInstance', True);
  MetaModel.DefineMetaClass(PUMLDataValue, 'UMLDataValue', False);
  MetaModel.DefineMetaClass(PUMLNodeInstance, 'UMLNodeInstance', False);
  MetaModel.DefineMetaClass(PUMLObject, 'UMLObject', False);
  MetaModel.DefineMetaClass(PUMLSubsystemInstance, 'UMLSubsystemInstance', False);
  MetaModel.DefineMetaClass(PUMLUseCaseInstance, 'UMLUseCaseInstance', False);
  MetaModel.DefineMetaClass(PUMLComponentInstance, 'UMLComponentInstance', False);
  MetaModel.DefineMetaClass(PUMLArgument, 'UMLArgument', False);
  MetaModel.DefineMetaClass(PUMLConnectorEnd, 'UMLConnectorEnd', False);
  MetaModel.DefineMetaClass(PUMLStateVertex, 'UMLStateVertex', True);
  MetaModel.DefineMetaClass(PUMLSynchState, 'UMLSynchState', False);
  MetaModel.DefineMetaClass(PUMLPseudostate, 'UMLPseudostate', False);
  MetaModel.DefineMetaClass(PUMLStubState, 'UMLStubState', False);
  MetaModel.DefineMetaClass(PUMLState, 'UMLState', True);
  MetaModel.DefineMetaClass(PUMLSimpleState, 'UMLSimpleState', False);
  MetaModel.DefineMetaClass(PUMLObjectFlowState, 'UMLObjectFlowState', False);
  MetaModel.DefineMetaClass(PUMLActionState, 'UMLActionState', False);
  MetaModel.DefineMetaClass(PUMLSignalAcceptState, 'UMLSignalAcceptState', False);
  MetaModel.DefineMetaClass(PUMLCallState, 'UMLCallState', False);
  MetaModel.DefineMetaClass(PUMLSignalSendState, 'UMLSignalSendState', False);
  MetaModel.DefineMetaClass(PUMLCompositeState, 'UMLCompositeState', False);
  MetaModel.DefineMetaClass(PUMLSubmachineState, 'UMLSubmachineState', False);
  MetaModel.DefineMetaClass(PUMLSubactivityState, 'UMLSubactivityState', False);
  MetaModel.DefineMetaClass(PUMLFinalState, 'UMLFinalState', False);
  MetaModel.DefineMetaClass(PUMLFlowFinalState, 'UMLFlowFinalState', False);
  MetaModel.DefineMetaClass(PUMLInteraction, 'UMLInteraction', False);
  MetaModel.DefineMetaClass(PUMLMessage, 'UMLMessage', False);
  MetaModel.DefineMetaClass(PUMLAssociationClass, 'UMLAssociationClass', False);
  MetaModel.DefineMetaClass(PUMLStateMachine, 'UMLStateMachine', False);
  MetaModel.DefineMetaClass(PUMLActivityGraph, 'UMLActivityGraph', False);
  MetaModel.DefineMetaClass(PUMLFeature, 'UMLFeature', True);
  MetaModel.DefineMetaClass(PUMLBehavioralFeature, 'UMLBehavioralFeature', True);
  MetaModel.DefineMetaClass(PUMLMethod, 'UMLMethod', False);
  MetaModel.DefineMetaClass(PUMLOperation, 'UMLOperation', False);
  MetaModel.DefineMetaClass(PUMLReception, 'UMLReception', False);
  MetaModel.DefineMetaClass(PUMLConnector, 'UMLConnector', False);
  MetaModel.DefineMetaClass(PUMLStructuralFeature, 'UMLStructuralFeature', True);
  MetaModel.DefineMetaClass(PUMLAttribute, 'UMLAttribute', False);
  MetaModel.DefineMetaClass(PUMLPort, 'UMLPort', False);
  MetaModel.DefineMetaClass(PUMLGeneralizableElement, 'UMLGeneralizableElement', True);
  MetaModel.DefineMetaClass(PUMLNamespace, 'UMLNamespace', True);
  MetaModel.DefineMetaClass(PUMLCollaboration, 'UMLCollaboration', False);
  MetaModel.DefineMetaClass(PUMLClassifier, 'UMLClassifier', True);
  MetaModel.DefineMetaClass(PUMLUseCase, 'UMLUseCase', False);
  MetaModel.DefineMetaClass(PUMLActor, 'UMLActor', False);
  MetaModel.DefineMetaClass(PUMLClassifierInState, 'UMLClassifierInState', False);
  MetaModel.DefineMetaClass(PUMLInterface, 'UMLInterface', False);
  MetaModel.DefineMetaClass(PUMLPackage, 'UMLPackage', False);
  MetaModel.DefineMetaClass(PUMLSubsystem, 'UMLSubsystem', False);
  MetaModel.DefineMetaClass(PUMLProject, 'UMLProject', False);
  MetaModel.DefineMetaClass(PUMLModel, 'UMLModel', False);
  MetaModel.DefineMetaClass(PUMLDataType, 'UMLDataType', False);
  MetaModel.DefineMetaClass(PUMLProgrammingLanguageDataType, 'UMLProgrammingLanguageDataType', False);
  MetaModel.DefineMetaClass(PUMLPrimitive, 'UMLPrimitive', False);
  MetaModel.DefineMetaClass(PUMLEnumeration, 'UMLEnumeration', False);
  MetaModel.DefineMetaClass(PUMLClass, 'UMLClass', False);
  MetaModel.DefineMetaClass(PUMLNode, 'UMLNode', False);
  MetaModel.DefineMetaClass(PUMLArtifact, 'UMLArtifact', False);
  MetaModel.DefineMetaClass(PUMLComponent, 'UMLComponent', False);
  MetaModel.DefineMetaClass(PUMLSignal, 'UMLSignal', False);
  MetaModel.DefineMetaClass(PUMLException, 'UMLException', False);
  MetaModel.DefineMetaClass(PUMLClassifierRole, 'UMLClassifierRole', False);
  MetaModel.DefineMetaClass(PUMLEvent, 'UMLEvent', True);
  MetaModel.DefineMetaClass(PUMLChangeEvent, 'UMLChangeEvent', False);
  MetaModel.DefineMetaClass(PUMLSignalEvent, 'UMLSignalEvent', False);
  MetaModel.DefineMetaClass(PUMLTimeEvent, 'UMLTimeEvent', False);
  MetaModel.DefineMetaClass(PUMLCallEvent, 'UMLCallEvent', False);
  MetaModel.DefineMetaClass(PUMLEnumerationLiteral, 'UMLEnumerationLiteral', False);
  MetaModel.DefineMetaClass(PUMLStimulus, 'UMLStimulus', False);
  MetaModel.DefineMetaClass(PUMLAttributeLink, 'UMLAttributeLink', False);
  MetaModel.DefineMetaClass(PUMLRelationship, 'UMLRelationship', True);
  MetaModel.DefineMetaClass(PUMLGeneralization, 'UMLGeneralization', False);
  MetaModel.DefineMetaClass(PUMLInclude, 'UMLInclude', False);
  MetaModel.DefineMetaClass(PUMLDependency, 'UMLDependency', False);
  MetaModel.DefineMetaClass(PUMLRealization, 'UMLRealization', False);
  MetaModel.DefineMetaClass(PUMLExtend, 'UMLExtend', False);
  MetaModel.DefineMetaClass(PUMLAssociation, 'UMLAssociation', False);
  MetaModel.DefineMetaClass(PUMLAssociationRole, 'UMLAssociationRole', False);
  MetaModel.DefineMetaClass(PUMLAction, 'UMLAction', True);
  MetaModel.DefineMetaClass(PUMLTerminateAction, 'UMLTerminateAction', False);
  MetaModel.DefineMetaClass(PUMLSendAction, 'UMLSendAction', False);
  MetaModel.DefineMetaClass(PUMLActionSequence, 'UMLActionSequence', False);
  MetaModel.DefineMetaClass(PUMLCreateAction, 'UMLCreateAction', False);
  MetaModel.DefineMetaClass(PUMLDestroyAction, 'UMLDestroyAction', False);
  MetaModel.DefineMetaClass(PUMLUninterpretedAction, 'UMLUninterpretedAction', False);
  MetaModel.DefineMetaClass(PUMLCallAction, 'UMLCallAction', False);
  MetaModel.DefineMetaClass(PUMLReturnAction, 'UMLReturnAction', False);
  MetaModel.DefineMetaClass(PUMLFrame, 'UMLFrame', False);
  MetaModel.DefineMetaClass(PUMLCollaborationInstanceSet, 'UMLCollaborationInstanceSet', False);
  MetaModel.DefineMetaClass(PUMLParameter, 'UMLParameter', False);
  MetaModel.DefineMetaClass(PUMLAssociationEnd, 'UMLAssociationEnd', False);
  MetaModel.DefineMetaClass(PUMLAssociationEndRole, 'UMLAssociationEndRole', False);
  MetaModel.DefineMetaClass(PUMLTransition, 'UMLTransition', False);
  MetaModel.DefineMetaClass(PUMLExtensionPoint, 'UMLExtensionPoint', False);
  MetaModel.DefineMetaClass(PUMLLink, 'UMLLink', False);
  MetaModel.DefineMetaClass(PUMLComment, 'UMLComment', False);
  MetaModel.DefineMetaClass(PUMLTemplateParameter, 'UMLTemplateParameter', False);
  MetaModel.DefineMetaClass(PUMLTemplateArgument, 'UMLTemplateArgument', False);
  MetaModel.DefineMetaClass(PUMLElementImport, 'UMLElementImport', False);
  MetaModel.DefineMetaClass(PUMLDiagram, 'UMLDiagram', False);
  MetaModel.DefineMetaClass(PUMLDeploymentDiagram, 'UMLDeploymentDiagram', False);
  MetaModel.DefineMetaClass(PUMLComponentDiagram, 'UMLComponentDiagram', False);
  MetaModel.DefineMetaClass(PUMLSequenceDiagram, 'UMLSequenceDiagram', False);
  MetaModel.DefineMetaClass(PUMLCollaborationDiagram, 'UMLCollaborationDiagram', False);
  MetaModel.DefineMetaClass(PUMLSequenceRoleDiagram, 'UMLSequenceRoleDiagram', False);
  MetaModel.DefineMetaClass(PUMLUseCaseDiagram, 'UMLUseCaseDiagram', False);
  MetaModel.DefineMetaClass(PUMLClassDiagram, 'UMLClassDiagram', False);
  MetaModel.DefineMetaClass(PUMLActivityDiagram, 'UMLActivityDiagram', False);
  MetaModel.DefineMetaClass(PUMLCollaborationRoleDiagram, 'UMLCollaborationRoleDiagram', False);
  MetaModel.DefineMetaClass(PUMLCompositeStructureDiagram, 'UMLCompositeStructureDiagram', False);
  MetaModel.DefineMetaClass(PUMLStatechartDiagram, 'UMLStatechartDiagram', False);
  // UMLModelElement
  M := MetaModel.FindMetaClass('UMLModelElement');
  MetaModel.DefineMetaAttribute(M, 'Visibility', 'UMLVisibilityKind', False, False, 'vkPublic');
  MetaModel.DefineMetaAttribute(M, 'IsSpecification', 'Boolean', False, False);
  MetaModel.DefineMetaCollection(M, 'ElementImports', 'UMLElementImport', False, False, makNone, 'ImportedElement', maeReference);
  MetaModel.DefineMetaReference(M, 'Namespace', 'UMLNamespace', True, False, makNone, 'OwnedElements', maeCollection);
  MetaModel.DefineMetaCollection(M, 'ClientDependencies', 'UMLDependency', False, False, makNone, 'Client', maeReference);
  MetaModel.DefineMetaCollection(M, 'SupplierDependencies', 'UMLDependency', False, False, makNone, 'Supplier', maeReference);
  MetaModel.DefineMetaCollection(M, 'DefaultParameters', 'UMLTemplateParameter', False, False, makNone, 'DefaultElement', maeReference);
  MetaModel.DefineMetaCollection(M, 'Comments', 'UMLComment', False, False, makNone, 'AnnotatedElements', maeCollection);
  MetaModel.DefineMetaReference(M, 'Container', 'UMLComponent', False, False, makNone, 'Residents', maeCollection);
  MetaModel.DefineMetaCollection(M, 'TemplateParameters', 'UMLTemplateParameter', True, False, makComposite, 'Template', maeReference);
  MetaModel.DefineMetaReference(M, 'ParameterOwner', 'UMLTemplateParameter', True, False, makNone, 'Parameter', maeReference);
  MetaModel.DefineMetaCollection(M, 'TemplateArguments', 'UMLTemplateArgument', False, False, makNone, 'ModelElement', maeReference);
  MetaModel.DefineMetaCollection(M, 'Behaviors', 'UMLStateMachine', True, False, makComposite, 'Context', maeReference);
  MetaModel.DefineMetaCollection(M, 'ContentRoles', 'UMLClassifierRole', False, False, makNone, 'AvailableContents', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Frames', 'UMLFrame', False, False, makNone, 'RepresentedElement', maeReference);
  MetaModel.DefineMetaCollection(M, 'OwnerPartitions', 'UMLPartition', False, False, makNone, 'Contents', maeCollection);
  // UMLLinkEnd
  M := MetaModel.FindMetaClass('UMLLinkEnd');
  MetaModel.DefineMetaReference(M, 'Instance', 'UMLInstance', False, False, makNone, 'LinkEnds', maeCollection);
  MetaModel.DefineMetaReference(M, 'Link', 'UMLLink', True, False, makNone, 'Connections', maeCollection);
  MetaModel.DefineMetaReference(M, 'AssociationEnd', 'UMLAssociationEnd', False, False, makNone, 'LinkEnds', maeCollection);
  MetaModel.DefineMetaCollection(M, 'QualifiedValues', 'UMLAttributeLink', True, False, makComposite, 'LinkEnd', maeReference);
  // UMLLinkObject
  M := MetaModel.FindMetaClass('UMLLinkObject');
  MetaModel.DefineMetaReference(M, 'LinkSide', 'UMLLink', False, False, makNone, 'LinkObject', maeReference);
  MetaModel.DefineMetaReference(M, 'ObjectSide', 'UMLObject', False, False, makNone, 'LinkObject', maeReference);
  // UMLPartition
  M := MetaModel.FindMetaClass('UMLPartition');
  MetaModel.DefineMetaCollection(M, 'Contents', 'UMLModelElement', False, False, makNone, 'OwnerPartitions', maeCollection);
  MetaModel.DefineMetaReference(M, 'ActivityGraph', 'UMLActivityGraph', True, False, makNone, 'Partitions', maeCollection);
  // UMLInteractionFragment
  M := MetaModel.FindMetaClass('UMLInteractionFragment');
  MetaModel.DefineMetaReference(M, 'EnclosingOperand', 'UMLInteractionOperand', False, False, makNone, 'Fragments', maeCollection);
  MetaModel.DefineMetaReference(M, 'EnclosingInteraction', 'UMLInteraction', False, False, makNone, 'Fragments', maeCollection);
  MetaModel.DefineMetaReference(M, 'EnclosingInteractionInstanceSet', 'UMLInteractionInstanceSet', False, False, makNone, 'Fragments', maeCollection);
  // UMLInteractionOperand
  M := MetaModel.FindMetaClass('UMLInteractionOperand');
  MetaModel.DefineMetaAttribute(M, 'Guard', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'CombinedFragment', 'UMLCombinedFragment', False, False, makNone, 'Operands', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Fragments', 'UMLInteractionFragment', False, False, makComposite, 'EnclosingOperand', maeReference);
  // UMLCombinedFragment
  M := MetaModel.FindMetaClass('UMLCombinedFragment');
  MetaModel.DefineMetaAttribute(M, 'InteractionOperator', 'UMLInteractionOperatorKind', False, False);
  MetaModel.DefineMetaCollection(M, 'Operands', 'UMLInteractionOperand', False, False, makComposite, 'CombinedFragment', maeReference);
  // UMLInteractionInstanceSet
  M := MetaModel.FindMetaClass('UMLInteractionInstanceSet');
  MetaModel.DefineMetaReference(M, 'Context', 'UMLCollaborationInstanceSet', True, False, makNone, 'InteractionInstanceSets', maeCollection);
  MetaModel.DefineMetaReference(M, 'Interaction', 'UMLInteraction', False, False, makNone, 'InteractionInstanceSets', maeCollection);
  MetaModel.DefineMetaCollection(M, 'ParticipatingStimuli', 'UMLStimulus', True, False, makComposite, 'InteractionInstanceSet', maeReference);
  MetaModel.DefineMetaCollection(M, 'Fragments', 'UMLInteractionFragment', False, False, makComposite, 'EnclosingInteractionInstanceSet', maeReference);
  MetaModel.DefineMetaCollection(M, 'OwnedFrames', 'UMLFrame', False, False, makComposite, 'InteractionInstanceSet', maeReference);
  // UMLInstance
  M := MetaModel.FindMetaClass('UMLInstance');
  MetaModel.DefineMetaAttribute(M, 'IsMultiInstance', 'Boolean', False, False);
  MetaModel.DefineMetaReference(M, 'Classifier', 'UMLClassifier', False, False, makNone, 'Instances', maeCollection);
  MetaModel.DefineMetaCollection(M, 'AttributeLinks', 'UMLAttributeLink', False, False, makNone, 'Value_', maeReference);
  MetaModel.DefineMetaCollection(M, 'LinkEnds', 'UMLLinkEnd', False, False, makNone, 'Instance', maeReference);
  MetaModel.DefineMetaCollection(M, 'Slots', 'UMLAttributeLink', True, False, makComposite, 'Instance', maeReference);
  MetaModel.DefineMetaCollection(M, 'SendingStimuli', 'UMLStimulus', False, False, makNone, 'Sender', maeReference);
  MetaModel.DefineMetaReference(M, 'ComponentInstance', 'UMLComponentInstance', False, False, makNone, 'Residents', maeCollection);
  MetaModel.DefineMetaCollection(M, 'ReceivingStimuli', 'UMLStimulus', False, False, makNone, 'Receiver', maeReference);
  MetaModel.DefineMetaReference(M, 'Owner', 'UMLInstance', True, False, makNone, 'OwnedInstances', maeCollection);
  MetaModel.DefineMetaCollection(M, 'OwnedInstances', 'UMLInstance', True, False, makComposite, 'Owner', maeReference);
  MetaModel.DefineMetaCollection(M, 'OwnedLinks', 'UMLLink', True, False, makComposite, 'Owner', maeReference);
  MetaModel.DefineMetaCollection(M, 'PlayedRoles', 'UMLClassifierRole', False, False, makNone, 'ConformingInstances', maeCollection);
  MetaModel.DefineMetaReference(M, 'CollaborationInstanceSet', 'UMLCollaborationInstanceSet', True, False, makNone, 'ParticipatingInstances', maeCollection);
  // UMLNodeInstance
  M := MetaModel.FindMetaClass('UMLNodeInstance');
  MetaModel.DefineMetaCollection(M, 'Residents', 'UMLComponentInstance', False, False, makNone, 'NodeInstance', maeReference);
  // UMLObject
  M := MetaModel.FindMetaClass('UMLObject');
  MetaModel.DefineMetaReference(M, 'LinkObject', 'UMLLinkObject', False, False, makNone, 'ObjectSide', maeReference);
  // UMLComponentInstance
  M := MetaModel.FindMetaClass('UMLComponentInstance');
  MetaModel.DefineMetaReference(M, 'NodeInstance', 'UMLNodeInstance', False, False, makNone, 'Residents', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Residents', 'UMLInstance', False, False, makNone, 'ComponentInstance', maeReference);
  // UMLArgument
  M := MetaModel.FindMetaClass('UMLArgument');
  MetaModel.DefineMetaAttribute(M, 'Value', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Action', 'UMLAction', True, False, makNone, 'ActualArguments', maeCollection);
  // UMLConnectorEnd
  M := MetaModel.FindMetaClass('UMLConnectorEnd');
  MetaModel.DefineMetaAttribute(M, 'Multiplicity', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'IsOrdered', 'Boolean', False, False, 'False');
  MetaModel.DefineMetaAttribute(M, 'IsUnique', 'Boolean', False, False, 'True');
  MetaModel.DefineMetaReference(M, 'Connector', 'UMLConnector', False, False, makNone, 'Ends', maeCollection);
  MetaModel.DefineMetaReference(M, 'Role', 'UMLFeature', False, False, makNone, 'ConnectorEnds', maeCollection);
  // UMLStateVertex
  M := MetaModel.FindMetaClass('UMLStateVertex');
  MetaModel.DefineMetaReference(M, 'ContainerState', 'UMLCompositeState', True, False, makNone, 'Subvertices', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Outgoings', 'UMLTransition', False, False, makNone, 'Source', maeReference);
  MetaModel.DefineMetaCollection(M, 'Incomings', 'UMLTransition', False, False, makNone, 'Target', maeReference);
  // UMLSynchState
  M := MetaModel.FindMetaClass('UMLSynchState');
  MetaModel.DefineMetaAttribute(M, 'Bound', 'Integer', False, False);
  // UMLPseudostate
  M := MetaModel.FindMetaClass('UMLPseudostate');
  MetaModel.DefineMetaAttribute(M, 'PseudostateKind', 'UMLPseudostateKind', False, False);
  // UMLStubState
  M := MetaModel.FindMetaClass('UMLStubState');
  MetaModel.DefineMetaAttribute(M, 'ReferenceState', 'String', False, False);
  // UMLState
  M := MetaModel.FindMetaClass('UMLState');
  MetaModel.DefineMetaCollection(M, 'EntryActions', 'UMLAction', True, False, makComposite, 'EntryState', maeReference);
  MetaModel.DefineMetaCollection(M, 'ExitActions', 'UMLAction', True, False, makComposite, 'ExitState', maeReference);
  MetaModel.DefineMetaReference(M, 'StateMachine', 'UMLStateMachine', True, False, makNone, 'Top', maeReference);
  MetaModel.DefineMetaCollection(M, 'DeferrableEvents', 'UMLEvent', False, False, makNone, 'States', maeCollection);
  MetaModel.DefineMetaCollection(M, 'InternalTransitions', 'UMLTransition', True, False, makComposite, 'State', maeReference);
  MetaModel.DefineMetaCollection(M, 'DoActivities', 'UMLAction', True, False, makComposite, 'DoActivityState', maeReference);
  MetaModel.DefineMetaCollection(M, 'ClassifierStates', 'UMLClassifierInState', False, False, makNone, 'InStates', maeCollection);
  // UMLObjectFlowState
  M := MetaModel.FindMetaClass('UMLObjectFlowState');
  MetaModel.DefineMetaAttribute(M, 'IsSynch', 'Boolean', False, False);
  MetaModel.DefineMetaCollection(M, 'Parameters', 'UMLParameter', False, False, makNone, 'States', maeCollection);
  MetaModel.DefineMetaReference(M, 'Type_', 'UMLClassifier', False, False, makNone, 'ObjectFlowStates', maeCollection);
  // UMLActionState
  M := MetaModel.FindMetaClass('UMLActionState');
  MetaModel.DefineMetaAttribute(M, 'IsDynamic', 'Boolean', False, False);
  MetaModel.DefineMetaAttribute(M, 'DynamicArguments', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'DynamicMultiplicity', 'String', False, False);
  // UMLCompositeState
  M := MetaModel.FindMetaClass('UMLCompositeState');
  MetaModel.DefineMetaAttribute(M, 'IsConcurrent', 'Boolean', False, False);
  MetaModel.DefineMetaCollection(M, 'Subvertices', 'UMLStateVertex', True, False, makComposite, 'ContainerState', maeReference);
  // UMLSubmachineState
  M := MetaModel.FindMetaClass('UMLSubmachineState');
  MetaModel.DefineMetaReference(M, 'Submachine', 'UMLStateMachine', False, False, makNone, 'SubmachineStates', maeCollection);
  // UMLSubactivityState
  M := MetaModel.FindMetaClass('UMLSubactivityState');
  MetaModel.DefineMetaAttribute(M, 'IsDynamic', 'Boolean', False, False);
  MetaModel.DefineMetaAttribute(M, 'DynamicArguments', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'DynamicMultiplicity', 'String', False, False);
  // UMLInteraction
  M := MetaModel.FindMetaClass('UMLInteraction');
  MetaModel.DefineMetaCollection(M, 'Messages', 'UMLMessage', True, False, makComposite, 'Interaction', maeReference);
  MetaModel.DefineMetaReference(M, 'Context', 'UMLCollaboration', True, False, makNone, 'Interactions', maeCollection);
  MetaModel.DefineMetaCollection(M, 'InteractionInstanceSets', 'UMLInteractionInstanceSet', False, False, makNone, 'Interaction', maeReference);
  MetaModel.DefineMetaCollection(M, 'Fragments', 'UMLInteractionFragment', False, False, makComposite, 'EnclosingInteraction', maeReference);
  MetaModel.DefineMetaCollection(M, 'OwnedFrames', 'UMLFrame', False, False, makComposite, 'Interaction', maeReference);
  // UMLMessage
  M := MetaModel.FindMetaClass('UMLMessage');
  MetaModel.DefineMetaAttribute(M, 'Arguments', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'Return', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'Iteration', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'Branch', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Interaction', 'UMLInteraction', True, False, makNone, 'Messages', maeCollection);
  MetaModel.DefineMetaReference(M, 'Activator', 'UMLMessage', False, False, makNone, 'Activatees', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Activatees', 'UMLMessage', False, False, makNone, 'Activator', maeReference);
  MetaModel.DefineMetaReference(M, 'Sender', 'UMLClassifierRole', False, False, makNone, 'SenderClientMessages', maeCollection);
  MetaModel.DefineMetaReference(M, 'Receiver', 'UMLClassifierRole', False, False, makNone, 'ReceiverClientMessages', maeCollection);
  MetaModel.DefineMetaReference(M, 'Successor', 'UMLMessage', False, False, makNone, 'Predecessor', maeReference);
  MetaModel.DefineMetaReference(M, 'Predecessor', 'UMLMessage', False, False, makNone, 'Successor', maeReference);
  MetaModel.DefineMetaReference(M, 'CommunicationConnection', 'UMLAssociationRole', False, False, makNone, 'Messages', maeCollection);
  MetaModel.DefineMetaReference(M, 'Action', 'UMLAction', True, False, makComposite, 'Message', maeReference);
  MetaModel.DefineMetaCollection(M, 'ConformingStimuli', 'UMLStimulus', False, False, makNone, 'PlayedRoles', maeCollection);
  // UMLAssociationClass
  M := MetaModel.FindMetaClass('UMLAssociationClass');
  MetaModel.DefineMetaReference(M, 'ClassSide', 'UMLClass', False, False, makNone, 'AssociationClass', maeReference);
  MetaModel.DefineMetaReference(M, 'AssociationSide', 'UMLAssociation', False, False, makNone, 'AssociationClass', maeReference);
  // UMLStateMachine
  M := MetaModel.FindMetaClass('UMLStateMachine');
  MetaModel.DefineMetaReference(M, 'Context', 'UMLModelElement', True, False, makNone, 'Behaviors', maeCollection);
  MetaModel.DefineMetaReference(M, 'Top', 'UMLState', True, False, makComposite, 'StateMachine', maeReference);
  MetaModel.DefineMetaCollection(M, 'Transitions', 'UMLTransition', True, False, makComposite, 'StateMachine', maeReference);
  MetaModel.DefineMetaCollection(M, 'SubmachineStates', 'UMLSubmachineState', False, False, makNone, 'Submachine', maeReference);
  // UMLActivityGraph
  M := MetaModel.FindMetaClass('UMLActivityGraph');
  MetaModel.DefineMetaCollection(M, 'Partitions', 'UMLPartition', True, False, makComposite, 'ActivityGraph', maeReference);
  // UMLFeature
  M := MetaModel.FindMetaClass('UMLFeature');
  MetaModel.DefineMetaAttribute(M, 'OwnerScope', 'UMLScopeKind', False, False, 'skInstance');
  MetaModel.DefineMetaCollection(M, 'ConnectorEnds', 'UMLConnectorEnd', False, False, makNone, 'Role', maeReference);
  MetaModel.DefineMetaCollection(M, 'ClassifierRoles', 'UMLClassifierRole', False, False, makNone, 'AvailableFeatures', maeCollection);
  // UMLBehavioralFeature
  M := MetaModel.FindMetaClass('UMLBehavioralFeature');
  MetaModel.DefineMetaAttribute(M, 'IsQuery', 'Boolean', False, False);
  MetaModel.DefineMetaCollection(M, 'Parameters', 'UMLParameter', True, False, makComposite, 'BehavioralFeature', maeReference);
  MetaModel.DefineMetaCollection(M, 'RaisedSignals', 'UMLSignal', False, False, makNone, 'Contexts', maeCollection);
  // UMLMethod
  M := MetaModel.FindMetaClass('UMLMethod');
  MetaModel.DefineMetaAttribute(M, 'Body', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Specification', 'UMLOperation', False, False, makNone, 'Methods', maeCollection);
  // UMLOperation
  M := MetaModel.FindMetaClass('UMLOperation');
  MetaModel.DefineMetaAttribute(M, 'Concurrency', 'UMLCallConcurrencyKind', False, False, 'cckSequential');
  MetaModel.DefineMetaAttribute(M, 'IsRoot', 'Boolean', False, False);
  MetaModel.DefineMetaAttribute(M, 'IsLeaf', 'Boolean', False, False);
  MetaModel.DefineMetaAttribute(M, 'IsAbstract', 'Boolean', False, False);
  MetaModel.DefineMetaAttribute(M, 'Specification', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Owner', 'UMLClassifier', True, False, makNone, 'Operations', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Methods', 'UMLMethod', False, False, makNone, 'Specification', maeReference);
  MetaModel.DefineMetaCollection(M, 'CallActions', 'UMLCallAction', False, False, makNone, 'Operation', maeReference);
  MetaModel.DefineMetaCollection(M, 'Occurrences', 'UMLCallEvent', False, False, makNone, 'Operation', maeReference);
  MetaModel.DefineMetaCollection(M, 'OwnedCollaborations', 'UMLCollaboration', True, False, makComposite, 'RepresentedOperation', maeReference);
  MetaModel.DefineMetaCollection(M, 'OwnedCollaborationInstanceSets', 'UMLCollaborationInstanceSet', True, False, makComposite, 'RepresentedOperation', maeReference);
  // UMLReception
  M := MetaModel.FindMetaClass('UMLReception');
  MetaModel.DefineMetaAttribute(M, 'Specification', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'IsRoot', 'Boolean', False, False);
  MetaModel.DefineMetaAttribute(M, 'IsLeaf', 'Boolean', False, False);
  MetaModel.DefineMetaAttribute(M, 'IsAbstract', 'Boolean', False, False);
  MetaModel.DefineMetaReference(M, 'Signal', 'UMLSignal', False, False, makNone, 'Receptions', maeCollection);
  // UMLConnector
  M := MetaModel.FindMetaClass('UMLConnector');
  MetaModel.DefineMetaCollection(M, 'Ends', 'UMLConnectorEnd', False, False, makComposite, 'Connector', maeReference);
  MetaModel.DefineMetaReference(M, 'Owner', 'UMLClassifier', False, False, makNone, 'OwnedConnectors', maeCollection);
  // UMLStructuralFeature
  M := MetaModel.FindMetaClass('UMLStructuralFeature');
  MetaModel.DefineMetaAttribute(M, 'Multiplicity', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'Changeability', 'UMLChangeableKind', False, False, 'ckChangeable');
  MetaModel.DefineMetaAttribute(M, 'TargetScope', 'UMLScopeKind', False, False, 'skInstance');
  MetaModel.DefineMetaAttribute(M, 'Ordering', 'UMLOrderingKind', False, False, 'okUnordered');
  MetaModel.DefineMetaAttribute(M, 'TypeExpression', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Type_', 'UMLClassifier', False, False, makNone, 'TypedFeatures', maeCollection);
  // UMLAttribute
  M := MetaModel.FindMetaClass('UMLAttribute');
  MetaModel.DefineMetaAttribute(M, 'InitialValue', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'AssociationEnd', 'UMLAssociationEnd', True, False, makNone, 'Qualifiers', maeCollection);
  MetaModel.DefineMetaReference(M, 'Owner', 'UMLClassifier', True, False, makNone, 'Attributes', maeCollection);
  MetaModel.DefineMetaCollection(M, 'AttributeLinks', 'UMLAttributeLink', False, False, makNone, 'Attribute', maeReference);
  MetaModel.DefineMetaCollection(M, 'AssociationEndRoles', 'UMLAssociationEndRole', False, False, makNone, 'AvailableQualifiers', maeCollection);
  // UMLPort
  M := MetaModel.FindMetaClass('UMLPort');
  MetaModel.DefineMetaAttribute(M, 'IsBehavior', 'Boolean', False, False, 'False');
  MetaModel.DefineMetaAttribute(M, 'IsService', 'Boolean', False, False, 'True');
  MetaModel.DefineMetaReference(M, 'Owner', 'UMLClassifier', False, False, makNone, 'OwnedPorts', maeCollection);
  // UMLGeneralizableElement
  M := MetaModel.FindMetaClass('UMLGeneralizableElement');
  MetaModel.DefineMetaAttribute(M, 'IsRoot', 'Boolean', False, False);
  MetaModel.DefineMetaAttribute(M, 'IsLeaf', 'Boolean', False, False);
  MetaModel.DefineMetaAttribute(M, 'IsAbstract', 'Boolean', False, False);
  MetaModel.DefineMetaCollection(M, 'Generalizations', 'UMLGeneralization', False, False, makNone, 'Child', maeReference);
  MetaModel.DefineMetaCollection(M, 'Specializations', 'UMLGeneralization', False, False, makNone, 'Parent', maeReference);
  // UMLNamespace
  M := MetaModel.FindMetaClass('UMLNamespace');
  MetaModel.DefineMetaCollection(M, 'OwnedElements', 'UMLModelElement', True, False, makComposite, 'Namespace', maeReference);
  // UMLCollaboration
  M := MetaModel.FindMetaClass('UMLCollaboration');
  MetaModel.DefineMetaCollection(M, 'Interactions', 'UMLInteraction', True, False, makComposite, 'Context', maeReference);
  MetaModel.DefineMetaReference(M, 'RepresentedOperation', 'UMLOperation', True, False, makNone, 'OwnedCollaborations', maeCollection);
  MetaModel.DefineMetaCollection(M, 'CollaborationInstanceSets', 'UMLCollaborationInstanceSet', False, False, makNone, 'Collaboration', maeReference);
  MetaModel.DefineMetaCollection(M, 'UserCollaborations', 'UMLCollaboration', False, False, makNone, 'UsedCollaborations', maeCollection);
  MetaModel.DefineMetaCollection(M, 'UsedCollaborations', 'UMLCollaboration', False, False, makNone, 'UserCollaborations', maeCollection);
  MetaModel.DefineMetaReference(M, 'RepresentedClassifier', 'UMLClassifier', True, False, makNone, 'OwnedCollaborations', maeCollection);
  // UMLClassifier
  M := MetaModel.FindMetaClass('UMLClassifier');
  MetaModel.DefineMetaCollection(M, 'Operations', 'UMLOperation', True, False, makComposite, 'Owner', maeReference);
  MetaModel.DefineMetaCollection(M, 'TypedFeatures', 'UMLStructuralFeature', False, False, makNone, 'Type_', maeReference);
  MetaModel.DefineMetaCollection(M, 'TypedParameters', 'UMLParameter', False, False, makNone, 'Type_', maeReference);
  MetaModel.DefineMetaCollection(M, 'Associations', 'UMLAssociationEnd', False, False, makNone, 'Participant', maeReference);
  MetaModel.DefineMetaCollection(M, 'PowertypeGeneralizations', 'UMLGeneralization', False, False, makNone, 'Powertype', maeReference);
  MetaModel.DefineMetaCollection(M, 'Attributes', 'UMLAttribute', True, False, makComposite, 'Owner', maeReference);
  MetaModel.DefineMetaCollection(M, 'OwnedPorts', 'UMLPort', False, False, makComposite, 'Owner', maeReference);
  MetaModel.DefineMetaCollection(M, 'OwnedConnectors', 'UMLConnector', False, False, makComposite, 'Owner', maeReference);
  MetaModel.DefineMetaCollection(M, 'Instances', 'UMLInstance', False, False, makNone, 'Classifier', maeReference);
  MetaModel.DefineMetaCollection(M, 'CreateActions', 'UMLCreateAction', False, False, makNone, 'Instantiation', maeReference);
  MetaModel.DefineMetaCollection(M, 'ClassifierRoles', 'UMLClassifierRole', False, False, makNone, 'Base', maeReference);
  MetaModel.DefineMetaCollection(M, 'OwnedCollaborations', 'UMLCollaboration', True, False, makComposite, 'RepresentedClassifier', maeReference);
  MetaModel.DefineMetaCollection(M, 'OwnedCollaborationInstanceSets', 'UMLCollaborationInstanceSet', True, False, makComposite, 'RepresentedClassifier', maeReference);
  MetaModel.DefineMetaCollection(M, 'ClassifierInStates', 'UMLClassifierInState', False, False, makNone, 'Type_', maeReference);
  MetaModel.DefineMetaCollection(M, 'ObjectFlowStates', 'UMLObjectFlowState', False, False, makNone, 'Type_', maeReference);
  // UMLUseCase
  M := MetaModel.FindMetaClass('UMLUseCase');
  MetaModel.DefineMetaCollection(M, 'Extenders', 'UMLExtend', False, False, makNone, 'Base', maeReference);
  MetaModel.DefineMetaCollection(M, 'Extends', 'UMLExtend', False, False, makNone, 'Extension', maeReference);
  MetaModel.DefineMetaCollection(M, 'Includers', 'UMLInclude', False, False, makNone, 'Addition', maeReference);
  MetaModel.DefineMetaCollection(M, 'Includes', 'UMLInclude', False, False, makNone, 'Base', maeReference);
  MetaModel.DefineMetaCollection(M, 'ExtensionPoints', 'UMLExtensionPoint', True, False, makComposite, 'UseCase', maeReference);
  // UMLClassifierInState
  M := MetaModel.FindMetaClass('UMLClassifierInState');
  MetaModel.DefineMetaReference(M, 'Type_', 'UMLClassifier', False, False, makNone, 'ClassifierInStates', maeCollection);
  MetaModel.DefineMetaCollection(M, 'InStates', 'UMLState', False, False, makNone, 'ClassifierStates', maeCollection);
  // UMLPackage
  M := MetaModel.FindMetaClass('UMLPackage');
  MetaModel.DefineMetaCollection(M, 'ElementImportItems', 'UMLElementImport', True, False, makComposite, 'Package', maeReference);
  // UMLSubsystem
  M := MetaModel.FindMetaClass('UMLSubsystem');
  MetaModel.DefineMetaAttribute(M, 'IsInstantiable', 'Boolean', False, False);
  // UMLProject
  M := MetaModel.FindMetaClass('UMLProject');
  MetaModel.DefineMetaAttribute(M, 'Title', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'Author', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'Company', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'Copyright', 'String', False, False);
  // UMLProgrammingLanguageDataType
  M := MetaModel.FindMetaClass('UMLProgrammingLanguageDataType');
  MetaModel.DefineMetaAttribute(M, 'Expression', 'String', False, False);
  // UMLEnumeration
  M := MetaModel.FindMetaClass('UMLEnumeration');
  MetaModel.DefineMetaCollection(M, 'Literals', 'UMLEnumerationLiteral', True, False, makComposite, 'Enumeration', maeReference);
  // UMLClass
  M := MetaModel.FindMetaClass('UMLClass');
  MetaModel.DefineMetaAttribute(M, 'IsActive', 'Boolean', False, False);
  MetaModel.DefineMetaReference(M, 'AssociationClass', 'UMLAssociationClass', False, False, makNone, 'ClassSide', maeReference);
  // UMLNode
  M := MetaModel.FindMetaClass('UMLNode');
  MetaModel.DefineMetaCollection(M, 'DeployedComponents', 'UMLComponent', False, False, makAggregate, 'DeploymentLocations', maeCollection);
  MetaModel.DefineMetaCollection(M, 'DeployedArtifacts', 'UMLArtifact', False, False, makAggregate, 'DeploymentLocations', maeCollection);
  // UMLArtifact
  M := MetaModel.FindMetaClass('UMLArtifact');
  MetaModel.DefineMetaCollection(M, 'ImplementationLocations', 'UMLComponent', False, False, makNone, 'Implementations', maeCollection);
  MetaModel.DefineMetaCollection(M, 'DeploymentLocations', 'UMLNode', False, False, makNone, 'DeployedArtifacts', maeCollection);
  // UMLComponent
  M := MetaModel.FindMetaClass('UMLComponent');
  MetaModel.DefineMetaCollection(M, 'DeploymentLocations', 'UMLNode', False, False, makNone, 'DeployedComponents', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Residents', 'UMLModelElement', False, False, makAggregate, 'Container', maeReference);
  MetaModel.DefineMetaCollection(M, 'Implementations', 'UMLArtifact', False, False, makAggregate, 'ImplementationLocations', maeCollection);
  // UMLSignal
  M := MetaModel.FindMetaClass('UMLSignal');
  MetaModel.DefineMetaCollection(M, 'Receptions', 'UMLReception', False, False, makNone, 'Signal', maeReference);
  MetaModel.DefineMetaCollection(M, 'Contexts', 'UMLBehavioralFeature', False, False, makNone, 'RaisedSignals', maeCollection);
  MetaModel.DefineMetaCollection(M, 'SendActions', 'UMLSendAction', False, False, makNone, 'Signal', maeReference);
  MetaModel.DefineMetaCollection(M, 'Occurrences', 'UMLSignalEvent', False, False, makNone, 'Signal', maeReference);
  // UMLClassifierRole
  M := MetaModel.FindMetaClass('UMLClassifierRole');
  MetaModel.DefineMetaAttribute(M, 'Multiplicity', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Base', 'UMLClassifier', False, False, makNone, 'ClassifierRoles', maeCollection);
  MetaModel.DefineMetaCollection(M, 'AvailableFeatures', 'UMLFeature', False, False, makAggregate, 'ClassifierRoles', maeCollection);
  MetaModel.DefineMetaCollection(M, 'SenderClientMessages', 'UMLMessage', False, False, makNone, 'Sender', maeReference);
  MetaModel.DefineMetaCollection(M, 'ReceiverClientMessages', 'UMLMessage', False, False, makNone, 'Receiver', maeReference);
  MetaModel.DefineMetaCollection(M, 'AvailableContents', 'UMLModelElement', False, False, makAggregate, 'ContentRoles', maeCollection);
  MetaModel.DefineMetaCollection(M, 'ConformingInstances', 'UMLInstance', False, False, makNone, 'PlayedRoles', maeCollection);
  // UMLEvent
  M := MetaModel.FindMetaClass('UMLEvent');
  MetaModel.DefineMetaCollection(M, 'Parameters', 'UMLParameter', True, False, makComposite, 'Event', maeReference);
  MetaModel.DefineMetaCollection(M, 'States', 'UMLState', False, False, makNone, 'DeferrableEvents', maeCollection);
  MetaModel.DefineMetaReference(M, 'Transition', 'UMLTransition', True, False, makNone, 'Triggers', maeCollection);
  // UMLChangeEvent
  M := MetaModel.FindMetaClass('UMLChangeEvent');
  MetaModel.DefineMetaAttribute(M, 'ChangeExpression', 'String', False, False);
  // UMLSignalEvent
  M := MetaModel.FindMetaClass('UMLSignalEvent');
  MetaModel.DefineMetaReference(M, 'Signal', 'UMLSignal', False, False, makNone, 'Occurrences', maeCollection);
  // UMLTimeEvent
  M := MetaModel.FindMetaClass('UMLTimeEvent');
  MetaModel.DefineMetaAttribute(M, 'When', 'String', False, False);
  // UMLCallEvent
  M := MetaModel.FindMetaClass('UMLCallEvent');
  MetaModel.DefineMetaReference(M, 'Operation', 'UMLOperation', False, False, makNone, 'Occurrences', maeCollection);
  // UMLEnumerationLiteral
  M := MetaModel.FindMetaClass('UMLEnumerationLiteral');
  MetaModel.DefineMetaReference(M, 'Enumeration', 'UMLEnumeration', True, False, makNone, 'Literals', maeCollection);
  // UMLStimulus
  M := MetaModel.FindMetaClass('UMLStimulus');
  MetaModel.DefineMetaAttribute(M, 'Arguments', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'Return', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'Iteration', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'Branch', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Sender', 'UMLInstance', False, False, makNone, 'SendingStimuli', maeCollection);
  MetaModel.DefineMetaReference(M, 'Receiver', 'UMLInstance', False, False, makNone, 'ReceivingStimuli', maeCollection);
  MetaModel.DefineMetaReference(M, 'CommunicationLink', 'UMLLink', False, False, makNone, 'Stimuli', maeCollection);
  MetaModel.DefineMetaReference(M, 'Action', 'UMLAction', True, False, makComposite, 'Stimulus', maeReference);
  MetaModel.DefineMetaReference(M, 'Activator', 'UMLStimulus', False, False, makNone, 'Activatees', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Activatees', 'UMLStimulus', False, False, makNone, 'Activator', maeReference);
  MetaModel.DefineMetaReference(M, 'Predecessor', 'UMLStimulus', False, False, makNone, 'Successor', maeReference);
  MetaModel.DefineMetaReference(M, 'Successor', 'UMLStimulus', False, False, makNone, 'Predecessor', maeReference);
  MetaModel.DefineMetaCollection(M, 'PlayedRoles', 'UMLMessage', False, False, makNone, 'ConformingStimuli', maeCollection);
  MetaModel.DefineMetaReference(M, 'InteractionInstanceSet', 'UMLInteractionInstanceSet', True, False, makNone, 'ParticipatingStimuli', maeCollection);
  // UMLAttributeLink
  M := MetaModel.FindMetaClass('UMLAttributeLink');
  MetaModel.DefineMetaAttribute(M, 'ValueExpression', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Attribute', 'UMLAttribute', False, False, makNone, 'AttributeLinks', maeCollection);
  MetaModel.DefineMetaReference(M, 'Value_', 'UMLInstance', False, False, makNone, 'AttributeLinks', maeCollection);
  MetaModel.DefineMetaReference(M, 'Instance', 'UMLInstance', True, False, makNone, 'Slots', maeCollection);
  MetaModel.DefineMetaReference(M, 'LinkEnd', 'UMLLinkEnd', True, False, makNone, 'QualifiedValues', maeCollection);
  // UMLGeneralization
  M := MetaModel.FindMetaClass('UMLGeneralization');
  MetaModel.DefineMetaAttribute(M, 'Discriminator', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Child', 'UMLGeneralizableElement', False, False, makNone, 'Generalizations', maeCollection);
  MetaModel.DefineMetaReference(M, 'Parent', 'UMLGeneralizableElement', False, False, makNone, 'Specializations', maeCollection);
  MetaModel.DefineMetaReference(M, 'Powertype', 'UMLClassifier', False, False, makNone, 'PowertypeGeneralizations', maeCollection);
  // UMLInclude
  M := MetaModel.FindMetaClass('UMLInclude');
  MetaModel.DefineMetaReference(M, 'Addition', 'UMLUseCase', False, False, makNone, 'Includers', maeCollection);
  MetaModel.DefineMetaReference(M, 'Base', 'UMLUseCase', False, False, makNone, 'Includes', maeCollection);
  // UMLDependency
  M := MetaModel.FindMetaClass('UMLDependency');
  MetaModel.DefineMetaAttribute(M, 'Mapping', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Client', 'UMLModelElement', False, False, makNone, 'ClientDependencies', maeCollection);
  MetaModel.DefineMetaReference(M, 'Supplier', 'UMLModelElement', False, False, makNone, 'SupplierDependencies', maeCollection);
  // UMLExtend
  M := MetaModel.FindMetaClass('UMLExtend');
  MetaModel.DefineMetaAttribute(M, 'Condition', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Base', 'UMLUseCase', False, False, makNone, 'Extenders', maeCollection);
  MetaModel.DefineMetaReference(M, 'Extension', 'UMLUseCase', False, False, makNone, 'Extends', maeCollection);
  MetaModel.DefineMetaCollection(M, 'ExtensionPoints', 'UMLExtensionPoint', False, False, makNone, 'Extends', maeCollection);
  // UMLAssociation
  M := MetaModel.FindMetaClass('UMLAssociation');
  MetaModel.DefineMetaCollection(M, 'Connections', 'UMLAssociationEnd', True, False, makComposite, 'Association', maeReference);
  MetaModel.DefineMetaReference(M, 'AssociationClass', 'UMLAssociationClass', False, False, makNone, 'AssociationSide', maeReference);
  MetaModel.DefineMetaCollection(M, 'Links', 'UMLLink', False, False, makNone, 'Association', maeReference);
  MetaModel.DefineMetaCollection(M, 'AssociationRoles', 'UMLAssociationRole', False, False, makNone, 'Base', maeReference);
  // UMLAssociationRole
  M := MetaModel.FindMetaClass('UMLAssociationRole');
  MetaModel.DefineMetaAttribute(M, 'Multiplicity', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Base', 'UMLAssociation', False, False, makNone, 'AssociationRoles', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Messages', 'UMLMessage', False, False, makNone, 'CommunicationConnection', maeReference);
  MetaModel.DefineMetaCollection(M, 'ConformingLinks', 'UMLLink', False, False, makNone, 'PlayedRoles', maeCollection);
  // UMLAction
  M := MetaModel.FindMetaClass('UMLAction');
  MetaModel.DefineMetaAttribute(M, 'Recurrence', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'Target', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'IsAsynchronous', 'Boolean', False, False);
  MetaModel.DefineMetaAttribute(M, 'Script', 'String', False, False);
  MetaModel.DefineMetaCollection(M, 'ActualArguments', 'UMLArgument', True, False, makComposite, 'Action', maeReference);
  MetaModel.DefineMetaReference(M, 'ActionSequence', 'UMLActionSequence', True, False, makNone, 'Actions', maeCollection);
  MetaModel.DefineMetaReference(M, 'Stimulus', 'UMLStimulus', True, False, makNone, 'Action', maeReference);
  MetaModel.DefineMetaReference(M, 'EntryState', 'UMLState', True, False, makNone, 'EntryActions', maeCollection);
  MetaModel.DefineMetaReference(M, 'ExitState', 'UMLState', True, False, makNone, 'ExitActions', maeCollection);
  MetaModel.DefineMetaReference(M, 'Transition', 'UMLTransition', True, False, makNone, 'Effects', maeCollection);
  MetaModel.DefineMetaReference(M, 'DoActivityState', 'UMLState', True, False, makNone, 'DoActivities', maeCollection);
  MetaModel.DefineMetaReference(M, 'Message', 'UMLMessage', True, False, makNone, 'Action', maeReference);
  // UMLSendAction
  M := MetaModel.FindMetaClass('UMLSendAction');
  MetaModel.DefineMetaReference(M, 'Signal', 'UMLSignal', False, False, makNone, 'SendActions', maeCollection);
  // UMLActionSequence
  M := MetaModel.FindMetaClass('UMLActionSequence');
  MetaModel.DefineMetaCollection(M, 'Actions', 'UMLAction', True, False, makComposite, 'ActionSequence', maeReference);
  // UMLCreateAction
  M := MetaModel.FindMetaClass('UMLCreateAction');
  MetaModel.DefineMetaReference(M, 'Instantiation', 'UMLClassifier', False, False, makNone, 'CreateActions', maeCollection);
  // UMLCallAction
  M := MetaModel.FindMetaClass('UMLCallAction');
  MetaModel.DefineMetaReference(M, 'Operation', 'UMLOperation', False, False, makNone, 'CallActions', maeCollection);
  // UMLFrame
  M := MetaModel.FindMetaClass('UMLFrame');
  MetaModel.DefineMetaAttribute(M, 'FrameKind', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'RepresentedElement', 'UMLModelElement', False, False, makNone, 'Frames', maeCollection);
  MetaModel.DefineMetaReference(M, 'Interaction', 'UMLInteraction', False, False, makNone, 'OwnedFrames', maeCollection);
  MetaModel.DefineMetaReference(M, 'InteractionInstanceSet', 'UMLInteractionInstanceSet', False, False, makNone, 'OwnedFrames', maeCollection);
  // UMLCollaborationInstanceSet
  M := MetaModel.FindMetaClass('UMLCollaborationInstanceSet');
  MetaModel.DefineMetaCollection(M, 'InteractionInstanceSets', 'UMLInteractionInstanceSet', True, False, makComposite, 'Context', maeReference);
  MetaModel.DefineMetaReference(M, 'Collaboration', 'UMLCollaboration', False, False, makNone, 'CollaborationInstanceSets', maeCollection);
  MetaModel.DefineMetaCollection(M, 'ParticipatingInstances', 'UMLInstance', True, False, makComposite, 'CollaborationInstanceSet', maeReference);
  MetaModel.DefineMetaCollection(M, 'ParticipatingLinks', 'UMLLink', True, False, makComposite, 'CollaborationInstanceSet', maeReference);
  MetaModel.DefineMetaReference(M, 'RepresentedOperation', 'UMLOperation', True, False, makNone, 'OwnedCollaborationInstanceSets', maeCollection);
  MetaModel.DefineMetaReference(M, 'RepresentedClassifier', 'UMLClassifier', True, False, makNone, 'OwnedCollaborationInstanceSets', maeCollection);
  // UMLParameter
  M := MetaModel.FindMetaClass('UMLParameter');
  MetaModel.DefineMetaAttribute(M, 'DefaultValue', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'DirectionKind', 'UMLParameterDirectionKind', False, False, 'pdkIn');
  MetaModel.DefineMetaAttribute(M, 'TypeExpression', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'BehavioralFeature', 'UMLBehavioralFeature', True, False, makNone, 'Parameters', maeCollection);
  MetaModel.DefineMetaReference(M, 'Type_', 'UMLClassifier', False, False, makNone, 'TypedParameters', maeCollection);
  MetaModel.DefineMetaReference(M, 'Event', 'UMLEvent', True, False, makNone, 'Parameters', maeCollection);
  MetaModel.DefineMetaCollection(M, 'States', 'UMLObjectFlowState', False, False, makNone, 'Parameters', maeCollection);
  // UMLAssociationEnd
  M := MetaModel.FindMetaClass('UMLAssociationEnd');
  MetaModel.DefineMetaAttribute(M, 'IsNavigable', 'Boolean', False, False, 'True');
  MetaModel.DefineMetaAttribute(M, 'Ordering', 'UMLOrderingKind', False, False, 'okUnordered');
  MetaModel.DefineMetaAttribute(M, 'Aggregation', 'UMLAggregationKind', False, False, 'akNone');
  MetaModel.DefineMetaAttribute(M, 'TargetScope', 'UMLScopeKind', False, False, 'skInstance');
  MetaModel.DefineMetaAttribute(M, 'Multiplicity', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'Changeability', 'UMLChangeableKind', False, False, 'ckChangeable');
  MetaModel.DefineMetaReference(M, 'Association', 'UMLAssociation', True, False, makNone, 'Connections', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Qualifiers', 'UMLAttribute', True, False, makComposite, 'AssociationEnd', maeReference);
  MetaModel.DefineMetaReference(M, 'Participant', 'UMLClassifier', False, False, makNone, 'Associations', maeCollection);
  MetaModel.DefineMetaCollection(M, 'LinkEnds', 'UMLLinkEnd', False, False, makNone, 'AssociationEnd', maeReference);
  MetaModel.DefineMetaCollection(M, 'AssociationEndRoles', 'UMLAssociationEndRole', False, False, makNone, 'Base', maeReference);
  // UMLAssociationEndRole
  M := MetaModel.FindMetaClass('UMLAssociationEndRole');
  MetaModel.DefineMetaAttribute(M, 'CollaborationMultiplicity', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'Base', 'UMLAssociationEnd', False, False, makNone, 'AssociationEndRoles', maeCollection);
  MetaModel.DefineMetaCollection(M, 'AvailableQualifiers', 'UMLAttribute', False, False, makAggregate, 'AssociationEndRoles', maeCollection);
  // UMLTransition
  M := MetaModel.FindMetaClass('UMLTransition');
  MetaModel.DefineMetaAttribute(M, 'GuardCondition', 'String', False, False);
  MetaModel.DefineMetaCollection(M, 'Effects', 'UMLAction', True, False, makComposite, 'Transition', maeReference);
  MetaModel.DefineMetaReference(M, 'State', 'UMLState', True, False, makNone, 'InternalTransitions', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Triggers', 'UMLEvent', True, False, makComposite, 'Transition', maeReference);
  MetaModel.DefineMetaReference(M, 'StateMachine', 'UMLStateMachine', True, False, makNone, 'Transitions', maeCollection);
  MetaModel.DefineMetaReference(M, 'Source', 'UMLStateVertex', False, False, makNone, 'Outgoings', maeCollection);
  MetaModel.DefineMetaReference(M, 'Target', 'UMLStateVertex', False, False, makNone, 'Incomings', maeCollection);
  // UMLExtensionPoint
  M := MetaModel.FindMetaClass('UMLExtensionPoint');
  MetaModel.DefineMetaAttribute(M, 'Location', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'UseCase', 'UMLUseCase', True, False, makNone, 'ExtensionPoints', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Extends', 'UMLExtend', False, False, makNone, 'ExtensionPoints', maeCollection);
  // UMLLink
  M := MetaModel.FindMetaClass('UMLLink');
  MetaModel.DefineMetaReference(M, 'Association', 'UMLAssociation', False, False, makNone, 'Links', maeCollection);
  MetaModel.DefineMetaCollection(M, 'Connections', 'UMLLinkEnd', True, False, makComposite, 'Link', maeReference);
  MetaModel.DefineMetaCollection(M, 'Stimuli', 'UMLStimulus', False, False, makNone, 'CommunicationLink', maeReference);
  MetaModel.DefineMetaReference(M, 'Owner', 'UMLInstance', True, False, makNone, 'OwnedLinks', maeCollection);
  MetaModel.DefineMetaReference(M, 'LinkObject', 'UMLLinkObject', False, False, makNone, 'LinkSide', maeReference);
  MetaModel.DefineMetaCollection(M, 'PlayedRoles', 'UMLAssociationRole', False, False, makNone, 'ConformingLinks', maeCollection);
  MetaModel.DefineMetaReference(M, 'CollaborationInstanceSet', 'UMLCollaborationInstanceSet', True, False, makNone, 'ParticipatingLinks', maeCollection);
  // UMLComment
  M := MetaModel.FindMetaClass('UMLComment');
  MetaModel.DefineMetaAttribute(M, 'Body', 'String', False, False);
  MetaModel.DefineMetaCollection(M, 'AnnotatedElements', 'UMLModelElement', False, False, makNone, 'Comments', maeCollection);
  // UMLTemplateParameter
  M := MetaModel.FindMetaClass('UMLTemplateParameter');
  MetaModel.DefineMetaAttribute(M, 'ParameterType', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'DefaultValue', 'String', False, False);
  MetaModel.DefineMetaReference(M, 'DefaultElement', 'UMLModelElement', False, False, makNone, 'DefaultParameters', maeCollection);
  MetaModel.DefineMetaReference(M, 'Template', 'UMLModelElement', True, False, makNone, 'TemplateParameters', maeCollection);
  MetaModel.DefineMetaReference(M, 'Parameter', 'UMLModelElement', True, False, makComposite, 'ParameterOwner', maeReference);
  // UMLTemplateArgument
  M := MetaModel.FindMetaClass('UMLTemplateArgument');
  MetaModel.DefineMetaReference(M, 'ModelElement', 'UMLModelElement', False, False, makAggregate, 'TemplateArguments', maeCollection);
  // UMLElementImport
  M := MetaModel.FindMetaClass('UMLElementImport');
  MetaModel.DefineMetaAttribute(M, 'Visibility', 'UMLVisibilityKind', False, False, 'vkPublic');
  MetaModel.DefineMetaAttribute(M, 'Alias', 'String', False, False);
  MetaModel.DefineMetaAttribute(M, 'IsSpecification', 'Boolean', False, False);
  MetaModel.DefineMetaReference(M, 'ImportedElement', 'UMLModelElement', False, False, makAggregate, 'ElementImports', maeCollection);
  MetaModel.DefineMetaReference(M, 'Package', 'UMLPackage', True, False, makNone, 'ElementImportItems', maeCollection);
  // UMLSequenceDiagram
  M := MetaModel.FindMetaClass('UMLSequenceDiagram');
  MetaModel.DefineMetaAttribute(M, 'ShowSequenceNumber', 'Boolean', False, False, 'True');
  MetaModel.DefineMetaAttribute(M, 'MessageSignature', 'UMLMessageSignatureKind', False, False, 'mskNone');
  MetaModel.DefineMetaAttribute(M, 'ShowActivation', 'Boolean', False, False, 'True');
  // UMLCollaborationDiagram
  M := MetaModel.FindMetaClass('UMLCollaborationDiagram');
  MetaModel.DefineMetaAttribute(M, 'ShowSequenceNumber', 'Boolean', False, False, 'True');
  MetaModel.DefineMetaAttribute(M, 'MessageSignature', 'UMLMessageSignatureKind', False, False, 'mskNone');
  // UMLSequenceRoleDiagram
  M := MetaModel.FindMetaClass('UMLSequenceRoleDiagram');
  MetaModel.DefineMetaAttribute(M, 'ShowSequenceNumber', 'Boolean', False, False, 'True');
  MetaModel.DefineMetaAttribute(M, 'MessageSignature', 'UMLMessageSignatureKind', False, False, 'mskNone');
  MetaModel.DefineMetaAttribute(M, 'ShowActivation', 'Boolean', False, False, 'True');
  // UMLCollaborationRoleDiagram
  M := MetaModel.FindMetaClass('UMLCollaborationRoleDiagram');
  MetaModel.DefineMetaAttribute(M, 'ShowSequenceNumber', 'Boolean', False, False, 'True');
  MetaModel.DefineMetaAttribute(M, 'MessageSignature', 'UMLMessageSignatureKind', False, False, 'mskNone');
  // Inheritance Relations
  MetaModel.DefineMetaInheritance('ExtensibleModel', 'UMLElement');
  MetaModel.DefineMetaInheritance('UMLElement', 'UMLModelElement');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLLinkEnd');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLLinkObject');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLPartition');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLInteractionFragment');
  MetaModel.DefineMetaInheritance('UMLInteractionFragment', 'UMLInteractionOperand');
  MetaModel.DefineMetaInheritance('UMLInteractionFragment', 'UMLCombinedFragment');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLInteractionInstanceSet');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLInstance');
  MetaModel.DefineMetaInheritance('UMLInstance', 'UMLDataValue');
  MetaModel.DefineMetaInheritance('UMLInstance', 'UMLNodeInstance');
  MetaModel.DefineMetaInheritance('UMLInstance', 'UMLObject');
  MetaModel.DefineMetaInheritance('UMLInstance', 'UMLSubsystemInstance');
  MetaModel.DefineMetaInheritance('UMLInstance', 'UMLUseCaseInstance');
  MetaModel.DefineMetaInheritance('UMLInstance', 'UMLComponentInstance');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLArgument');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLConnectorEnd');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLStateVertex');
  MetaModel.DefineMetaInheritance('UMLStateVertex', 'UMLSynchState');
  MetaModel.DefineMetaInheritance('UMLStateVertex', 'UMLPseudostate');
  MetaModel.DefineMetaInheritance('UMLStateVertex', 'UMLStubState');
  MetaModel.DefineMetaInheritance('UMLStateVertex', 'UMLState');
  MetaModel.DefineMetaInheritance('UMLState', 'UMLSimpleState');
  MetaModel.DefineMetaInheritance('UMLSimpleState', 'UMLObjectFlowState');
  MetaModel.DefineMetaInheritance('UMLSimpleState', 'UMLActionState');
  MetaModel.DefineMetaInheritance('UMLActionState', 'UMLSignalAcceptState');
  MetaModel.DefineMetaInheritance('UMLActionState', 'UMLCallState');
  MetaModel.DefineMetaInheritance('UMLActionState', 'UMLSignalSendState');
  MetaModel.DefineMetaInheritance('UMLState', 'UMLCompositeState');
  MetaModel.DefineMetaInheritance('UMLCompositeState', 'UMLSubmachineState');
  MetaModel.DefineMetaInheritance('UMLSubmachineState', 'UMLSubactivityState');
  MetaModel.DefineMetaInheritance('UMLState', 'UMLFinalState');
  MetaModel.DefineMetaInheritance('UMLFinalState', 'UMLFlowFinalState');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLInteraction');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLMessage');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLAssociationClass');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLStateMachine');
  MetaModel.DefineMetaInheritance('UMLStateMachine', 'UMLActivityGraph');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLFeature');
  MetaModel.DefineMetaInheritance('UMLFeature', 'UMLBehavioralFeature');
  MetaModel.DefineMetaInheritance('UMLBehavioralFeature', 'UMLMethod');
  MetaModel.DefineMetaInheritance('UMLBehavioralFeature', 'UMLOperation');
  MetaModel.DefineMetaInheritance('UMLBehavioralFeature', 'UMLReception');
  MetaModel.DefineMetaInheritance('UMLFeature', 'UMLConnector');
  MetaModel.DefineMetaInheritance('UMLFeature', 'UMLStructuralFeature');
  MetaModel.DefineMetaInheritance('UMLStructuralFeature', 'UMLAttribute');
  MetaModel.DefineMetaInheritance('UMLStructuralFeature', 'UMLPort');
  MetaModel.DefineMetaInheritance('UMLModelElement', 'UMLGeneralizableElement');
  MetaModel.DefineMetaInheritance('UMLGeneralizableElement', 'UMLNamespace');
  MetaModel.DefineMetaInheritance('UMLNamespace', 'UMLCollaboration');
  MetaModel.DefineMetaInheritance('UMLNamespace', 'UMLClassifier');
  MetaModel.DefineMetaInheritance('UMLClassifier', 'UMLUseCase');
  MetaModel.DefineMetaInheritance('UMLClassifier', 'UMLActor');
  MetaModel.DefineMetaInheritance('UMLClassifier', 'UMLClassifierInState');
  MetaModel.DefineMetaInheritance('UMLClassifier', 'UMLInterface');
  MetaModel.DefineMetaInheritance('UMLClassifier', 'UMLPackage');
  MetaModel.DefineMetaInheritance('UMLPackage', 'UMLSubsystem');
  MetaModel.DefineMetaInheritance('UMLPackage', 'UMLProject');
  MetaModel.DefineMetaInheritance('UMLPackage', 'UMLModel');
  MetaModel.DefineMetaInheritance('UMLClassifier', 'UMLDataType');
  MetaModel.Defi