unit Symbols;

{******************************************************************************}
{                                                                              }
{                StarUML - The Open Source UML/MDA Platform.                   }
{                                                                              }
{              Copyright (C) 2002-2005 - Plastic Software, Inc.                }
{                                                                              }
{                                                                              }
{ This program is free software; you can redistribute it and/or modify it      }
{ under the terms of the GNU General Public License as published by the Free   }
{ Software Foundation; either version 2 of the License, or (at your option)    }
{ any later version.                                                           }
{                                                                              }
{ This program is distributed in the hope that it will be useful, but WITHOUT  }
{ ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or        }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for     }
{ more details.                                                                }
{                                                                              }
{ You should have received a copy of the GNU General Public License along with }
{ this program; if not, write to the Free Software Foundation, Inc., 51        }
{ Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                          }
{                                                                              }
{ Linking StarUML statically or dynamically with other modules is making a     }
{ combined work based on StarUML. Thus, the terms and conditions of the GNU    }
{ General Public License cover the whole combination.                          }
{                                                                              }
{ In addition, as a special exception, Plastic Software give you permission to }
{ combine StarUML program with free software programs or libraries that are    }
{ released under the GNU LGPL/Mozilla/Apache/BSD and with code included in the }
{ standard release of ExpressBar, ExpressNavBar, ExpressInspector,             }
{ ExpressPageControl, ProGrammar, NextGrid under the commercial license (or    }
{ modified versions of such code, with unchanged license). You may copy and    }
{ distribute such a system following the terms of the GNU GPL for StarUML and  }
{ the licenses of the other code concerned, provided that you include the      }
{ source code of that other code when and as the GNU GPL requires distribution }
{ of source code. Plastic Software also give you permission to combine StarUML }
{ program with dynamically linking plug-in (or add-in) programs that are       }
{ released under the GPL-incompatible and proprietary license.                 }
{                                                                              }
{ Note that people who make modified versions of StarUML are not obligated to  }
{ grant this special exception for their modified versions; it is their choice }
{ whether to do so. The GNU General Public License gives permission to release }
{ a modified version without this exception; this exception also makes it      }
{ possible to release a modified version which carries forward this exception. }
{******************************************************************************}

interface

const
  // Commons
  XMI_FILE_EXT1 = 'xml';
  XMI_FILE_EXT2 = 'xmi';
  XMI_PREFIX = 'XMI';
  UML_PREFIX = 'UML';
  XMI_FIXED_VER = '1.1';
  UML_FIXED_VER = '1.3';
  EXPORTER_UNISYS = 'Unisys';
  APPROACH_RATIONAL = 'Rational';
  ROSE_LOGICAL_VIEW = 'Logical View';
  ROSE_USECASE_VIEW = 'Use Case View';
  ROSE_COMPONENT_VIEW = 'Component View';
  ROSE_DEPLOYMENT_VIEW = 'Deployment View';
  ROSE_MAIN_DIAGRAM = 'Main';
  XMI_NAMESPACE_UML13 = 'href://org.omg/UML/1.3';
  TOOL_NAME = 'StarUML.XMI-Addin';
  TOOL_VERSION = '1.0';
  UUID_NAMESPACE_PREFIX = 'DCE:';
  // StarUML (UML) Elements
  ELEM_MODEL = 'Model';
  ELEM_EXTENSIBLE_MODEL = 'ExtensibleModel';
  ELEM_DIAGRAM = 'Diagram';
  ELEM_VIEW = 'View';
  UML_MODEL_ELEMENT = 'UMLModelElement';
  UML_GENERALIZABLE = 'UMLGeneralizableElement';
  UML_CLASSIFIER = 'UMLClassifier';
  UML_NAMESPACE = 'UMLNamespace';
  UML_MODEL = 'UMLModel';
  UML_SUBSYSTEM = 'UMLSubsystem';
  UML_PACKAGE = 'UMLPackage';
  UML_CLASS = 'UMLClass';
  UML_ENUMERATION = 'UMLEnumeration';
  UML_INTERFACE = 'UMLInterface';
  UML_EXCEPTION = 'UMLException';
  UML_SIGNAL = 'UMLSignal';
  UML_USECASE = 'UMLUseCase';
  UML_ACTOR = 'UMLActor';
  UML_COMPONENT = 'UMLComponent';
  UML_COMPONENT_INSTANCE = 'UMLComponentInstance';
  UML_NODE = 'UMLNode';
  UML_NODE_INSTANCE = 'UMLNodeInstance';
  UML_FEATURE = 'UMLFeature';
  UML_STRUCTURAL = 'UMLStructuralFeature';
  UML_BEHAVIORAL_FEATURE = 'UMLBehavioralFeature';
  UML_ATTRIBUTE = 'UMLAttribute';
  UML_OPERATION = 'UMLOperation';
  UML_PARAMETER = 'UMLParameter';
  UML_TEMPLATE_PARAMETER = 'UMLTemplateParameter';
  UML_GENERALIZATION = 'UMLGeneralization';
  UML_ASSOCIATION = 'UMLAssociation';
  UML_ASSOCIATION_CLASS = 'UMLAssociationClass';
  UML_ASSOCIATION_END = 'UMLAssociationEnd';
  UML_ASSOCIATION_ROLE = 'UMLAssociationRole';
  UML_ASSOCIATION_END_ROLE = 'UMLAssociationEndRole';
  UML_DEPENDENCY = 'UMLDependency';
  UML_REALIZATION = 'UMLRealization';
  UML_EXTEND = 'UMLExtend';
  UML_INCLUDE = 'UMLInclude';
  UML_COLLABORATION = 'UMLCollaboration';
  UML_COLLABORATION_INSTANCESET = 'UMLCollaborationInstanceSet';
  UML_CLASSIFIER_ROLE = 'UMLClassifierRole';
  UML_INTERACTION = 'UMLInteraction';
  UML_MESSAGE = 'UMLMessage';
  UML_STIMULUS = 'UMLStimulus';
  UML_SEND_ACTION = 'UMLSendAction';
  UML_OBJECT = 'UMLObject';
  UML_INSTANCE = 'UMLInstance';
  UML_LINK = 'UMLLink';
  UML_STATE_MACHINE = 'UMLStateMachine';
  UML_SUBMACHINE_STATE = 'UMLSubmachineSate';
  UML_STATE_VERTEX = 'UMLStateVertex';
  UML_STATE = 'UMLState';
  UML_COMPOSITE_STATE = 'UMLCompositeState';
  UML_FINAL_STATE = 'UMLFinalState';
  UML_PSEUDO_STATE = 'UMLPseudostate';
  UML_TRANSITION = 'UMLTransition';
  UML_ACTIVITYGRAPH = 'UMLActivityGraph';
  UML_ACTION_STATE = 'UMLActionState';
  UML_SUBACTIVITY_STATE = 'UMLSubactivityState';
  UML_PARTITION= 'UMLPartition';
  UML_EVENT = 'UMLEvent';
  UML_CALL_EVENT = 'UMLCallEvent';
  UML_CHANGE_EVENT = 'UMLChangeEvent';
  UML_SIGNAL_EVENT = 'UMLSignalEvent';
  UML_TIME_EVENT = 'UMLTimeEvent';
  UML_ACTION = 'UMLAction';
  UML_CALL_ACTION = 'UMLCallAction';
  UML_CREATE_ACTION = 'UMLCreateAction';
  UML_DIAGRAM = 'UMLDiagram';
  UML_DESTROY_ACTION = 'UMLDestroyAction';
  UML_ENUMERATION_LITERAL = 'UMLEnumerationLiteral';
  UML_INTERACTION_INSTANCESET = 'UMLInteractionInstanceSet';
  UML_LINK_END = 'UMLLinkEnd';
  UML_RETURN_ACTION = 'UMLReturnAction';
  UML_UNINTERPRETED_ACTION = 'UMLUninterpretedAction';
  UML_PROJECT = 'UMLProject';
  ELEM_NOTE = 'Note';
  ELEM_NODE_VIEW = 'NodeView';
  UML_SEQ_ROLE_DIAGRAM_VIEW = 'UMLSequenceRoleDiagramView';
  UML_STATECHART_DIAGRAM_VIEW = 'UMLStatechartDiagramView';
  UML_ACTIVITY_DIAGRAM_VIEW = 'UMLActivityDiagramView';
  UML_COL_ROLE_DIAGRAM_VIEW = 'UMLCollaborationRoleDiagramView';

  UML_MESSAGE_VIEW = 'UMLCustomSeqMessageView';
  UML_SUBSYSTEM_VIEW = 'UMLSubsystemView';
  UML_CLASSIFIER_VIEW = 'UMLClassifierView';

  UML_ACTION_STATE_VIEW = 'UMLActionStateView';
  UML_ACTOR_VIEW = 'UMLActorView';
  UML_ASSOCIATION_CLASS_VIEW = 'UMLAssociationClassView';
  UML_ASSOCIATION_ROLE_VIEW = 'UMLAssociationRoleView';
  UML_ASSOCIATION_VIEW = 'UMLAssociationView';
  UML_CLASS_VIEW = 'UMLClassView';
  UML_COL_CLASSIFIER_ROLE_VIEW = 'UMLColClassifierRoleView';
  UML_COL_MESSAGE_VIEW = 'UMLColMessageView';
  UML_COL_OBJECT_VIEW = 'UMLColObjectView';
  UML_COL_STIMULUS_VIEW = 'UMLColStimulusView';
  UML_COMPONENT_VIEW = 'UMLComponentView';
  UML_DEPENDENCY_VIEW = 'UMLDependencyView';
  UML_ENUMERATION_VIEW = 'UMLEnumerationView';
  UML_EXCEPTION_VIEW = 'UMLExceptionView';
  UML_EXTEND_VIEW = 'UMLExtendView';
  UML_FINAL_STATE_VIEW = 'UMLFinalStateView';
  UML_GENERALIZATION_VIEW = 'UMLGeneralizationView';
  UML_INCLUDE_VIEW = 'UMLIncludeView';
  UML_INTERFACE_VIEW = 'UMLInterfaceView';
  UML_LINK_VIEW = 'UMLLinkView';
  UML_NODE_VIEW = 'UMLNodeView';
  UML_NOTE_VIEW = 'UMLNoteView';
  UML_NOTE_LINK_VIEW = 'UMLNoteLinkView';
  UML_PACKAGE_VIEW = 'UMLPackageView';
  UML_PSEUDOSTATE_VIEW = 'UMLPseudostateView';
  UML_REALIZATION_VIEW = 'UMLRealizationView';
  UML_SEQ_CLASSIFIER_ROLE_VIEW = 'UMLSeqClassifierRoleView';
  UML_SEQ_MESSAGE_VIEW = 'UMLSeqMessageView';
  UML_SEQ_OBJECT_VIEW = 'UMLSeqObjectView';
  UML_SEQ_STIMULUS_VIEW = 'UMLSeqStimulusView';
  UML_SIGNAL_VIEW = 'UMLSignalView';
  UML_STATE_VIEW = 'UMLStateView';
  UML_SUBACTIVITY_STATE_VIEW = 'UMLSubactivityStateView';
  UML_SUBMACHINE_STATE_VIEW = 'UMLSubmachineStateView';
  UML_SWIMLANE_VIEW = 'UMLSwimlaneView';
  UML_TRANSITION_VIEW = 'UMLTransitionView';
  UML_USECASE_VIEW = 'UMLUseCaseView';

  UML_CLASS_DIAGRAM = 'UMLClassDiagram';
  UML_USECASE_DIAGRAM = 'UMLUseCaseDiagram';
  UML_SEQUENCE_DIAGRAM = 'UMLSequenceDiagram';
  UML_SEQUENCE_ROLE_DIAGRAM = 'UMLSequenceRoleDiagram';
  UML_COLLABORATION_DIAGRAM = 'UMLCollaborationDiagram';
  UML_COLLABORATION_ROLE_DIAGRAM = 'UMLCollaborationRoleDiagram';
  UML_STATECHART_DIAGRAM = 'UMLStatechartDiagram';
  UML_ACTIVITY_DIAGRAM = 'UMLActivityDiagram';
  UML_COMPONENT_DIAGRAM = 'UMLComponentDiagram';
  UML_DEPLOYMENT_DIAGRAM = 'UMLDeploymentDiagram';

  // UML Attributes
  UML_PROP_ACTIONS = 'Actions';
  UML_PROP_ACTIVITY_GRAPH = 'ActivityGraph';
  UML_PROP_ADDITION = 'Addition';
  UML_PROP_AGGREGATION = 'Aggregation';
  UML_PROP_ARGUMENTS = 'Arguments';
  UML_PROP_ASSOCIATION = 'Association';
  UML_PROP_ASSOCIATIONS = 'Associations';
  UML_PROP_ASSOCIATION_END = 'AssociationEnd';
  UML_PROP_ATTRIBUTES = 'Attributes';
  UML_PROP_AVAILABLE_FEATURES = 'AvailableFeatures';
  UML_PROP_BASE = 'Base';
  UML_PROP_BEHAVIORS = 'Behaviors';
  UML_PROP_BEHAVIOR_FEATURE = 'BehavioralFeature';
  UML_PROP_BRANCH = 'Branch';
  UML_PROP_CHANGEABILITY = 'Changeability';
  UML_PROP_CHANGE_EXPRESSION = 'ChangeExpression';
  UML_PROP_CHILD = 'Child';
  UML_PROP_CLASSIFIER = 'Classifier';
  UML_PROP_CLIENT = 'Client';
  UML_PROP_CLIENT_DEPENDENCIES = 'ClientDependencies';
  UML_PROP_COLLABORATION_MULTIPLICITY = 'CollaborationMultiplicity';
  UML_PROP_COMMUNICATION_CONNECTION = 'CommunicationConnection';
  UML_PROP_CONCURRENCY = 'Concurrency';
  UML_PROP_CONDITION = 'Condition';
  UML_PROP_COMMUNICATION_LINK = 'CommunicationLink';
  UML_PROP_CONNECTIONS = 'Connections';
  UML_PROP_CONTAINED_VIEWS = 'ContainedViews';
  UML_PROP_CONTAINER_STATE = 'ContainerState';
  UML_PROP_CONTEXT = 'Context';
  UML_PROP_CONTEXTS = 'Contexts';
  UML_PROP_DEFAULT_VALUE = 'DefaultValue';
  UML_PROP_DEPLOYED_COMPONENTS = 'DeployedComponents';
  UML_PROP_DEPLOYMENT_LOCATIONS = 'DeploymentLocations';
  UML_PROP_DIAGRAM_OWNER = 'DiagramOwner';
  UML_PROP_DIRECTION_KIND = 'DirectionKind';
  UML_PROP_DISCRIMINATOR = 'Discriminator';
  UML_PROP_DYNAMIC_ARGUMENTS = 'DynamicArguments';
  UML_PROP_DYNAMIC_MULTIPLICITY = 'DynamicMultiplicity';
  UML_PROP_DO_ACTIVITIES = 'DoActivities';
  UML_PROP_EFFECTS = 'Effects';
  UML_PROP_ENTRY_ACTIONS = 'EntryActions';
  UML_PROP_EXIT_ACTIONS = 'ExitActions';
  UML_PROP_EXTENDERS = 'Extenders';
  UML_PROP_EXTENDS = 'Extends';
  UML_PROP_EXTENSION = 'Extension';
  UML_PROP_GENERALIZATIONS = 'Generalizations';
  UML_PROP_INCLUDERS = 'Includers';
  UML_PROP_INCLUDES = 'Includes';
  UML_PROP_INCOMINGS = 'Incomings';
  UML_PROP_INITIAL_VALUE = 'InitialValue';
  UML_PROP_INSTANCE = 'Instance';
  UML_PROP_INSTANTIATION = 'Instantiation';
  UML_PROP_INTERACTION = 'Interaction';
  UML_PROP_INTERACTION_INSTANCE_SET = 'InteractionInstanceSet';
  UML_PROP_INTERACTION_INSTANCE_SETS = 'InteractionInstanceSets';
  UML_PROP_INTERACTIONS = 'Interactions';
  UML_PROP_ITERATION = 'Iteration';
  UML_PROP_IS_ABSTRACT = 'IsAbstract';
  UML_PROP_IS_ACTIVE = 'IsActive';
  UML_PROP_IS_ASYNCHRONOUS = 'IsAsynchronous';
  UML_PROP_IS_CONCURRENT = 'IsConcurrent';
  UML_PROP_IS_DYNAMIC = 'IsDynamic';
  UML_PROP_IS_INSTANTIABLE = 'IsInstantiable';
  UML_PROP_IS_LEAF = 'IsLeaf';
  UML_PROP_IS_MULTIINSTANCE = 'IsMultiInstance';
  UML_PROP_IS_NAVIGABLE = 'IsNavigable';
  UML_PROP_IS_QUERY = 'IsQuery';
  UML_PROP_IS_ROOT = 'IsRoot';
  UML_PROP_IS_SPECIFICATION = 'IsSpecification';
  UML_PROP_LINK = 'Link';
  UML_PROP_LINK_ENDS = 'LinkEnds';
  UML_PROP_LITERALS = 'Literals';
  UML_PROP_MAPPING = 'Mapping';
  UML_PROP_MESSAGES = 'Messages';
  UML_PROP_MODEL = 'Model';
  UML_PROP_MULTIPLICITY = 'Multiplicity';
  UML_PROP_NAME = 'Name';
  UML_PROP_NAMESPACE = 'Namespace';
  UML_PROP_NODE_INSTANCE = 'NodeInstance';
  UML_PROP_OPERATION = 'Operation';
  UML_PROP_OPERATIONS = 'Operations';
  UML_PROP_ORDERING = 'Ordering';
  UML_PROP_OUTGOINGS = 'Outgoings';
  UML_PROP_OWNED_COLLABORATION_INSTANCE_SETS = 'OwnedCollaborationInstanceSets';
  UML_PROP_OWNED_COLLABORATIONS = 'OwnedCollaborations';
  UML_PROP_OWNED_ELEMENTS = 'OwnedElements';
  UML_PROP_OWNED_DIAGRAMS = 'OwnedDiagrams';
  UML_PROP_OWNED_VIEWS = 'OwnedViews';
  UML_PROP_OWNER = 'Owner';
  UML_PROP_OWNER_SCOPE = 'OwnerScope';
  UML_PROP_PARAMETERS = 'Parameters';
  UML_PROP_PARENT = 'Parent';
  UML_PROP_PARTICIPANT = 'Participant';
  UML_PROP_PARTICIPATING_INSTANCES = 'ParticipatingInstances';
  UML_PROP_PARTICIPATING_LINKS = 'ParticipatingLinks';
  UML_PROP_PARTICIPATING_STIMULI = 'ParticipatingStimuli';
  UML_PROP_PARTITIONS = 'Partitions';
  UML_PROP_PSEUDOSTATE_KIND = 'PseudostateKind';
  UML_PROP_QUALIFIERS = 'Qualifiers';
  UML_PROP_RECIVER = 'Receiver';
  UML_PROP_RECIEVER_CLIENT_MESSAGES = 'ReceiverClientMessages';
  UML_PROP_RECIEVING_STIMULI = 'ReceivingStimuli';
  UML_PROP_RESIDENTS = 'Residents';
  UML_PROP_RETURN = 'Return';
  UML_PROP_SCRIPT = 'Script';
  UML_PROP_SENDACTIONS = 'SendActions';
  UML_PROP_SENDER = 'Sender';
  UML_PROP_SENDER_CLIENT_MESSAGES = 'SenderClientMessages';
  UML_PROP_SENDING_STIMULI = 'SendingStimuli';
  UML_PROP_SIGNAL = 'Signal';
  UML_PROP_SOURCE = 'Source';
  UML_PROP_SPECIALIZATIONS = 'Specializations';
  UML_PROP_SPECIFICATION = 'Specification';
  UML_PROP_STATE_MACHINE = 'StateMachine';
  UML_PROP_STIMULUS = 'Stimulus';
  UML_PROP_STIMULI = 'Stimuli';
  UML_PROP_SUBMACHINE = 'Submachine';
  UML_PROP_SUBMACHINE_STATES = 'SubmachineStates';
  UML_PROP_SUBVERTICES = 'Subvertices';
  UML_PROP_SUPPLIER = 'Supplier';
  UML_PROP_SUPPLIER_DEPENDENCIES = 'SupplierDependencies';
  UML_PROP_TARGET = 'Target';
  UML_PROP_TARGET_SCOPE = 'TargetScope';
  UML_PROP_TEMPLATE = 'Template';
  UML_PROP_TEMPLATE_PARAMETERS = 'TemplateParameters';
  UML_PROP_TRANSITION = 'Transition';
  UML_PROP_TRANSITIONS = 'Transitions';
  UML_PROP_TRIGGERS = 'Triggers';
  UML_PROP_TYPE_ = 'Type_';
  UML_PROP_VISIBILITY = 'Visibility';
  UML_PROP_WHEN = 'When';
  // XMI General Nodes
  NODE_XMI_HEADER = 'XMI.header';
  NODE_XMI_CONTENT = 'XMI.content';
  NODE_XMI_METAMODEL = 'XMI.metamodel';
  NODE_XMI_DOC = 'XMI.documentation';
  NODE_XMI_EXPORTER = 'XMI.exporter';
  NODE_XMI_EXPORTER_VER = 'XMI.exporterVersion';
  NODE_XMI_OWNER = 'XMI.owner';
  NODE_XMI_CONTACT = 'XMI.contact';
  NODE_XMI_NOTICE = 'XMI.notice';
  // XMI UML Nodes
  NODE_UML_MODEL = 'UML:Model';
  NODE_UML_SUBSYSTEM = 'UML:Subsystem';
  NODE_UML_PACKAGE = 'UML:Package';
  NODE_UML_CLASS = 'UML:Class';
  NODE_UML_INTERFACE = 'UML:Interface';
  NODE_UML_SIGNAL = 'UML:Signal';
  NODE_UML_EXCEPTION = 'UML:Exception';
  NODE_UML_COMPONENT = 'UML:Component';
  NODE_UML_COMPONENT_INSTANCE = 'UML:ComponentInstance';
  NODE_UML_NODE = 'UML:Node';
  NODE_UML_NODE_INSTANCE = 'UML:NodeInstance';
  NODE_UML_USECASE = 'UML:UseCase';
  NODE_UML_ACTOR = 'UML:Actor';
  NODE_UML_ACTIVITY_GRAPH = 'UML:ActivityGraph';
  NODE_UML_STATE_MACHINE = 'UML:StateMachine';
  NODE_UML_COLLABORATION = 'UML:Collaboration';
  NODE_UML_INTERACTION = 'UML:Interaction';
  NODE_UML_ACTION_STATE = 'UML:ActionState';
  NODE_UML_CALL_STATE = 'UML:CallState';
  NODE_UML_SUBACTIVITY_STATE = 'UML:SubactivityState';
  NODE_UML_PSEUDO_STATE = 'UML:Pseudostate';
  NODE_UML_FINAL_STATE = 'UML:FinalState';
  NODE_UML_PARTITION = 'UML:Partition';
  NODE_UML_SUBMACHINE_STATE = 'UML:SubmachineState';
  NODE_UML_ATTRIBUTE = 'UML:Attribute';
  NODE_UML_OPERATION = 'UML:Operation';
  NODE_UML_PARAMETER = 'UML:Parameter';
  NODE_UML_TEMPLATE_PARAMETER = 'UML:TemplateParameter';
  NODE_UML_TRANSITION = 'UML:Transition';
  NODE_UML_SIGNAL_EVENT = 'UML:SignalEvent';
  NODE_UML_CALL_EVENT = 'UML:CallEvent';
  NODE_UML_TIME_EVENT = 'UML:TimeEvent';
  NODE_UML_CHANGE_EVENT = 'UML:ChangeEvent';
  NODE_UML_CLASSIFIER_ROLE = 'UML:ClassifierRole';
  NODE_UML_OBJECT = 'UML:Object';
  NODE_UML_DEPENDENCY = 'UML:Dependency';
  NODE_UML_ASSOCIATION = 'UML:Association';
  NODE_UML_GENERALIZATION = 'UML:Generalization';
  NODE_UML_LINK = 'UML:Link';
  NODE_UML_ASSOCIATION_ROLE = 'UML:AssociationRole';
  NODE_UML_STIMULUS = 'UML:Stimulus';
  NODE_UML_MESSAGE = 'UML:Message';
  NODE_UML_INCLUDE = 'UML:Include';
  NODE_UML_EXTEND = 'UML:Extend';
  NODE_UML_DIAGRAM = 'UML:Diagram';
  NODE_UML_DIAGRAM_ELEMENT = 'UML:DiagramElement';
  NODE_UML_ASSOCIATION_CLASS = 'UML:AssociationClass';
  NODE_UML_ABATRACTION = 'UML:Abstraction';
  NODE_UML_USAGE = 'UML:Usage';
  NODE_UML_PERMISSION = 'UML:Permission';
  NODE_UML_BINDING = 'UML:Binding';
  NODE_UML_COMPOSITE_STATE = 'UML:CompositeState';
  NODE_UML_SIMPLE_STATE = 'UML:SimpleState';
  NODE_UML_STATE = 'UML:State';
  NODE_UML_OBJECT_FLOW_STATE = 'UML:ObjectFlowState';
  NODE_UML_CALL_ACTION = 'UML:CallAction';
  NODE_UML_SEND_ACTION = 'UML:SendAction';
  NODE_UML_CREATE_ACTION = 'UML:CreateAction';
  NODE_UML_DESTROY_ACTION = 'UML:DestroyAction';
  NODE_UML_RETURN_ACTION = 'UML:ReturnAction';
  NODE_UML_TERMINATE_ACTION = 'UML:TerminateAction';
  NODE_UML_UNINTERPRETED_ACTION = 'UML:UninterpretedAction';
  NODE_UML_COMMENT = 'UML:Comment';
  NODE_UML_DATA_TYPE = 'UML:DataType';
  NODE_UML_TAGGED_VALUE = 'UML:TaggedValue';
  NODE_UML_METHOD = 'UML:Method';
  NODE_UML_PRESENTATION_ELEMENT = 'UML:PresentationElement';
  NODE_UML_ELEMENT_RESIDENCE = 'UML:ElementResidence';
  NODE_UML_SYNC_STATE = 'UML:SynchState';
  NODE_UML_STUB_STATE = 'UML:StubState';
  NODE_UML_CLASSIFIER_IN_STATE = 'UML:ClassifierInState';
  NODE_UML_FLOW = 'UML:Flow';
  NODE_UML_ELEMENT_IMPORT = 'UML:ElementImport';
  NODE_UML_INSTANCE = 'UML:Instance';
  NODE_UML_DATA_VALUE = 'UML:DataValue';
  NODE_UML_ATTRIBUTE_LINK = 'UML:AttributeLink';
  NODE_UML_LINK_OBJECT = 'UML:LinkObject';
  NODE_UML_ACTION_SEQUENCE = 'UML:ActionSequence';
  NODE_UML_ARGUMENT = 'UML:Argument';
  NODE_UML_RECEPTION = 'UML:Reception';
  NODE_UML_USECASE_INSTANCE = 'UML:UseCaseInstance';
  NODE_UML_EXTENSION_POINT = 'UML:ExtensionPoint';
  NODE_UML_GUARD = 'UML:Guard';
  NODE_UML_STEREOTYPE = 'UML:Stereotype';
  NODE_UML_CONSTRAINT = 'UML:Constraint';
  NODE_UML_EXPR = 'UML:Expression';
  NODE_UML_OBJECT_SET_EXPR = 'UML:ObjectSetExpression';
  NODE_UML_TIME_EXPR = 'UML:TimeExpression';
  NODE_UML_BOOLEAN_EXPR = 'UML:BooleanExpression';
  NODE_UML_ACTION_EXPR = 'UML:ActionExpression';
  NODE_UML_ITERATION_EXPR = 'UML:IterationExpression';
  NODE_UML_TYPE_EXPR = 'UML:TypeExpression';
  NODE_UML_ARG_LIST_EXPR = 'UML:ArgListsExpression';
  NODE_UML_MAPPING_EXPR = 'UML:MappingExpression';
  NODE_UML_PROCEDURE_EXPR = 'UML:ProcedureExpression';
  NODE_UML_MULTIPLICITY = 'UML:Multiplicity';
  NODE_UML_MULTIPLICITY_RANGE = 'UML:MultiplicityRange';
  NODE_UML_ACTION = 'UML:Action';
  NODE_UML_LINK_END = 'UML:LinkEnd';
  // XMI UML Subnodes
  NODE_UML_MODEL_ELEMENT_NAMESPACE = 'UML:ModelElement.namespace';
  NODE_UML_MODEL_ELEMENT_NAME = 'UML:ModelElement.name';
  NODE_UML_MODEL_ELEMENT_VISIBILITY = 'UML:ModelElement.visibility';
  NODE_UML_MODEL_ELEMENT_IS_SPEC = 'UML:ModelElement.isSpecification';
  NODE_UML_ELEM_IMPORT_PACKAGE = 'UML:ElementImport.package';
  NODE_UML_SEND_ACTION_SIGNAL = 'UML:SendAction.signal';
  NODE_UML_RECEPTION_SIGNAL = 'UML:Reception.signal';
  NODE_UML_SIGNAL_EVENT_SIGNAL = 'UML:SignalEvent.signal';
  NODE_UML_NODE_RESIDENT = 'UML:Node.resident';
  NODE_UML_ELEMENT_RESIDENCE_IMPLEMENTATION_LOCATION = 'UML:ElementResidence.implementationLocation';
  NODE_UML_INSTANCE_COMPONENT_INSTANCE = 'UML:Instance.componentInstance';
  NODE_UML_NODE_INSTANCE_RESIDENT = 'UML:NodeInstance.resident';
  NODE_UML_COMPONENT_DEPLOYMENT_LOCATION = 'UML:Component.deploymentLocation';
  NODE_UML_COMPONENT_INSTANCE_NODE_INSTANCE = 'UML:ComponentInstance.nodeInstance';
  NODE_UML_EXTEND_BASE = 'UML:Extend.base';
  NODE_UML_EXTEND_EXTENSION = 'UML:Extend.extension';
  NODE_UML_INCLUDE_ADDITION = 'UML:Include.addition';
  NODE_UML_INCLUDE_BASE = 'UML:Include.base';
  NODE_UML_EXTENSION_POINT_USECASE = 'UML:ExtensionPoint.useCase';
  NODE_UML_STATE_MACHINE_CONTEXT = 'UML:StateMachine.context';
  NODE_UML_PARTITION_ACTIVITY_GRAPH = 'UML:Partition.activityGraph';
  NODE_UML_SUBMACHINESTATE_SUBMACHINE = 'UML:SubmachineState.submachine';
  NODE_UML_TRANSITION_STATEMACHINE = 'UML:Transition.stateMachine';
  NODE_UML_STATE_STATEMACHINE = 'UML:State.stateMachine';
  NODE_UML_COLLABORATION_REPRESENTED_CLASSIFIER = 'UML:Collaboration.representedClassifier';
  NODE_UML_COLLABORATION_REPRESENTED_OPERATION = 'UML:Collaboration.representedOperation';
  NODE_UML_INTERACTION_CONTEXT = 'UML:Interaction.context';
  NODE_UML_STATE_VERTEX_CONTAINER = 'UML:StateVertex.container';
  NODE_UML_FEATURE_OWNER = 'UML:Feature.owner';
  NODE_UML_PARAMETER_BEHAVIORAL_FEATURE = 'UML:Parameter.behavioralFeature';
  NODE_UML_TEMPLATE_PARAMETER_MODEL_ELEMENT = 'UML:TemplateParameter.modelElement';
  NODE_UML_TRANSITION_SOURCE = 'UML:Transition.source';
  NODE_UML_TRANSITION_TARGET = 'UML:Transition.target';
  NODE_UML_EVENT_TRANSITION = 'UML:Event.transition';
  NODE_UML_COLLABORATION_INTERACTION = 'UML:Collaboration.interaction';
  NODE_UML_MESSAGE_INTERACTION = 'UML:Message.interaction';
  NODE_UML_ASSOCIATION_END_QUALIFIER = 'UML:AssociationEnd.qualifier';
  NODE_UML_ATTRIBUTE_LINK_ATTRIBUTE = 'UML:AttributeLink.attribute';
  NODE_UML_ASSOCIATION_END_ROLE_AVAILABLE_QUALIFIER = 'UML:AssociationEndRole.availableQualifier';
  NODE_UML_METHOD_SPECIFICATION = 'UML:Method.specification';
  NODE_UML_CALL_ACTION_OPERATION = 'UML:CallAction.operation';
  NODE_UML_CALL_EVENT_OPERATION = 'UML:CallEvent.operation';
  NODE_UML_OBJECT_FLOW_STATE_PARAMETER = 'UML:ObjectFlowState.parameter';
  NODE_UML_EVENT_PARAMETER = 'UML:Event.parameter';
  NODE_UML_STATE_VERTEX_OUTGOING = 'UML:StateVertex.outgoing';
  NODE_UML_STATE_VERTEX_INCOMING = 'UML:StateVertex.incoming';
  NODE_UML_STATE_INTERNAL_TRANSITION = 'UML:State.internalTransition';
  NODE_UML_GUARD_TRANSITION = 'UML:Guard.transition';
  NODE_UML_STATE_MACHINE_TOP = 'UML:StateMachine.top';
  NODE_UML_ASSOCIATION_END_ASSOCIATION = 'UML:AssociationEnd.association';
  NODE_UML_LINK_ASSOCIATION = 'UML:Link.association';
  NODE_UML_ASSOCIATION_ROLE_BASE = 'UML:AssociationRole.base';
  NODE_UML_ASSOCIATION_CONNECTION = 'UML:Association.connection';
  NODE_UML_ASSOCIATION_END = 'UML:AssociationEnd';
  NODE_UML_ASSOCIATION_END_ROLE = 'UML:AssociationEndRole';
  NODE_UML_ASSOCIATION_END_TYPE = 'UML:AssociationEnd.type';
  NODE_UML_CLIENT_DEPENDENCY = 'UML:ModelElement.clientDependency';
  NODE_UML_SUPPLIER_DEPENDENCY = 'UML:ModelElement.supplierDependency';
  NODE_UML_DEPENDENCY_CLIENT = 'UML:Dependency.client';
  NODE_UML_DEPENDENCY_SUPPLIER = 'UML:Dependency.supplier';
  NODE_UML_ELEM_GENERALIZATION = 'UML:GeneralizableElement.generalization';
  NODE_UML_ELEM_SPECIALIZATION = 'UML:GeneralizableElement.specialization';
  NODE_UML_POWERTYPE_RANGE = 'UML:Classifier.powertypeRange';
  NODE_UML_GENERALIZATION_PARENT = 'UML:Generalization.parent';
  NODE_UML_GENERALIZATION_CHILD = 'UML:Generalization.child';
  NODE_UML_ELEM_BINDING = 'UML:ModelElement.binding';
  NODE_UML_USECASE_INCLUDE = 'UML:UseCase.include';
  NODE_UML_USECASE_INCLUDE2 = 'UML:UseCase.include2';
  NODE_UML_USECASE_EXTEND = 'UML:UseCase.extend';
  NODE_UML_USECASE_EXTEND2 = 'UML:UseCase.extend2';
  NODE_UML_EXTENSION_POINT_EXTEND = 'UML:ExtensionPoint.extend';
  NODE_UML_LINK_END_LINK = 'UML:LinkEnd.link';
  NODE_UML_STIMULUS_LINK = 'UML:Stimulus.communicationLink';
  NODE_UML_MESSAGE_CONNECTION = 'UML:Message.communicationConnection';
  NODE_UML_CLASSIFIER_ROLE_MESSAGE1 = 'UML:ClassifierRole.message1';
  NODE_UML_CLASSIFIER_ROLE_MESSAGE2 = 'UML:ClassifierRole.message2';
  NODE_UML_ASSOC_ROLE_MESSAGE = 'UML:AssociationRole.message';
  NODE_UML_MESSAGE_ACTIVATOR = 'UML:Message.activator';
  NODE_UML_MESSAGE_PREDECESSOR = 'UML:Message.predecessor';
  NODE_UML_MESSAGE_MESSAGE3 = 'UML:Message.message3';
  NODE_UML_MESSAGE_MESSAGE4 = 'UML:Message.message4';
  NODE_UML_MESSAGE_SENDER = 'UML:Message.sender';
  NODE_UML_MESSAGE_RECEIVER = 'UML:Message.receiver';
  NODE_UML_DIAGRAM_TYPE = 'UML:Diagram.diagramType';
  NODE_UML_DIAGRAM_OWNER = 'UML:Diagram.owner';
  NODE_UML_DIAGRAM_OWNED_ELEMENT = 'UML:Diagram.element';
  NODE_UML_VIEW_SUBJECT = 'UML:PresentationElement.subject';
  NODE_UML_VIEW_GEOMETRY = 'UML:DiagramElement.geometry';
  NODE_UML_ANNOTATED_ELEM = 'UML:Comment.annotatedElement';
  NODE_UML_SIGNAL_SEND_ACTION = 'UML:Signal.sendAction';
  NODE_UML_STATE_ENTRY = 'UML:State.entry';
  NODE_UML_STATE_DO_ACTIVITY = 'UML:State.doActivity';
  NODE_UML_STATE_EXIT = 'UML:State.exit';
  NODE_UML_TRANSITION_EFFECT = 'UML:Transition.effect';
  NODE_UML_EXPRESSION_BODY = 'UML:Expression.body';
  NODE_UML_ELEM_CONSTRAINT = 'UML:ModelElement.constraint';
  NODE_UML_ELEM_TEMPLATE_PARAM2 = 'UML:ModelElement.templateParameter2';
  NODE_UML_ELEM_TEMPLATE_PARAM3 = 'UML:ModelElement.templateParameter3';
  NODE_UML_GENERALIZABLE_IS_ROOT = 'UML:GeneralizableElement.isRoot';
  NODE_UML_GENERALIZABLE_IS_LEAF = 'UML:GeneralizableElement.isLeaf';
  NODE_UML_GENERALIZABLE_IS_ABSTRACT = 'UML:GeneralizableElement.isAbstract';
  NODE_UML_CLASS_IS_ACTIVE = 'UML:Class.isActive';
  NODE_UML_FEATURE_SCOPE = 'UML:Feature.ownerScope';
  NODE_UML_STRUCTURAL_CHANGEABILITY = 'UML:StructuralFeature.changeability';
  NODE_UML_STRUCTURAL_TARGET_SCOPE = 'UML:StructuralFeature.targetScope';
  NODE_UML_MULTI_RANGE = 'UML:Multiplicity.range';
  NODE_UML_MULTI_RANGE_LOWER = 'UML:MultiplicityRange.lower';
  NODE_UML_MULTI_RANGE_UPPER = 'UML:MultiplicityRange.upper';
  NODE_UML_ASSOC_END_NAVIGABLE = 'UML:AssociationEnd.isNavigable';
  NODE_UML_ASSOC_END_ORDERING = 'UML:AssociationEnd.ordering';
  NODE_UML_ASSOC_END_AGGREGATION = 'UML:AssociationEnd.aggregation';
  NODE_UML_ASSOC_END_TARGET_SCOPE = 'UML:AssociationEnd.targetScope';
  NODE_UML_ASSOC_END_CHANGEABILITY = 'UML:AssociationEnd.changeability';
  NODE_UML_ATTR_INITIAL_VALUE = 'UML:Attribute.initialValue';
  NODE_BEHAVIORAL_IS_QUERY = 'UML:BehavioralFeature.isQuery';
  NODE_UML_OPERATION_CONCURRENCY = 'UML:Operation.concurrency';
  NODE_UML_OPERATION_IS_ROOT = 'UML:Operation.isRoot';
  NODE_UML_OPERATION_IS_LEAF = 'UML:Operation.isLeaf';
  NODE_UML_OPERATION_IS_ABSTRACT = 'UML:Operation.isAbstract';
  NODE_UML_OPERATION_SPEC = 'UML:Operation.specification';
  NODE_UML_PARAM_DEFAULT = 'UML:Parameter.defaultValue';
  NODE_UML_PARAM_KIND = 'UML:Parameter.kind';
  NODE_UML_GENERALIZATION_DISCRIMINATOR = 'UML:Generalization.discriminator';
  NODE_UML_COMPONENT_RESIDENT = 'UML:Component.residentElement';
  NODE_UML_TEMPLATE_PARAM_DEFAULT = 'UML:TemplateParameter.defaultElement';
  NODE_UML_ACTION_RECURRENCE = 'UML:Action.recurrence';
  NODE_UML_ACTION_TARGET = 'UML:Action.target';
  NODE_UML_ACTION_IS_ASYNCHRONOUS = 'UML:Action.isAsynchronous';
  NODE_UML_ACTION_SCRIPT = 'UML:Action.script';
  NODE_UML_ACTION_STIMULUS = 'UML:Action.stimulus';
  NODE_UML_EXTEND_CONDITION = 'UML:Extend.condition';
  NODE_UML_EVENT_PARAM = 'UML:Event.parameter';
  NODE_UML_COMPOSITE_STATE_CONCUR = 'UML:CompositeState.isConcurrent';
  NODE_UML_TIME_EVENT_WHEN = 'UML:TimeEvent.when';
  NODE_UML_TRANSITION_GUARD = 'UML:Transition.guard';
  NODE_UML_GUARD_EXPR = 'UML:Guard.expression';
  NODE_UML_CHANGE_EVENT_EXPR = 'UML:ChangeEvent.changeExpression';
  NODE_UML_PSEUDO_KIND = 'UML:Pseudostate.kind';
  NODE_UML_CONSTRAINING_ELEM = 'UML:Collaboaration.constrainingElement';
  NODE_UML_SUBACTIVITY_DYNAMIC = 'UML:SubactivityState.isDynamic';
  NODE_UML_STRUCTURAL_MULTIPLICITY = 'UML:StructuralFeature.multiplicity';
  NODE_UML_ASSOC_END_MULTIPLICITY = 'UML:AssociationEnd.multiplicity';
  NODE_UML_CLASSIFIER_ROLE_MULTIPLICITY = 'UML:ClassifierRole.multiplicity';
  NODE_UML_ASSOC_ROLE_MULTIPLICITY = 'UML:AssociationRole.multiplicity';
  NODE_UML_ASSOC_END_ROLE_COLL_MULTIPLICITY = 'UML:AssociationEndRole.collaborationMultiplicity';
  NODE_UML_CONSTRAINT_BODY = 'UML:Constraint.body';
  NODE_UML_SUBACTIVITY_ARGS = 'UML:SubactivityState.dynamicArguments';
  NODE_UML_SUBACTIVITY_MULTIPLICITY = 'UML:SubactivityState.dynamicMultiplicity';
  NODE_UML_ACTION_STATE_DYNAMIC = 'UML:ActionState.isDynamic';
  NODE_UML_ACTION_STATE_ARGS = 'UML:ActionState.dynamicArguments';
  NODE_UML_ACTION_STATE_MULTIPLICITY = 'UML:ActionState.dynamicMultiplicity';
  NODE_UML_SUBSYSTEM_IS_INSTANTIABLE = 'UML:Subsystem.isInstantiable';
  NODE_UML_MESSAGE_ACTION = 'UML:Message.action';
  NODE_UML_BASE_CLASS = 'UML:Stereotype.baseClass';
  NODE_UML_TAGGED_VALUE_TAG = 'UML:TaggedValue.tag';
  NODE_UML_TAGGED_VALUE_VALUE = 'UML:TaggedValue.value';
  NODE_UML_STEREOTYPE_EXTENDED_ELEM = 'UML:Stereotype.extendedElement';
  NODE_UML_TAGGED_VAL_MODEL_ELEM = 'UML:TaggedValue.modelElement';
  NODE_UML_PARAMETER_TYPE = 'UML:Parameter.type';
  NODE_UML_GENERALIZATION_POWER_TYPE = 'UML:Generalization.powertype';
  NODE_UML_ELEM_RESIDENCE_RESIDENT = 'UML:ElementResidence.resident';
  NODE_UML_RESIDENT = 'UML:Node.resident';
  NODE_UML_TEMPLATE_PARAM_MODEL_ELEM2 = 'UML:TemplateParameter.modelElement2';
  NODE_UML_STRUCTURERAL_FEATURE_TYPE = 'UML:StructuralFeature.type';
  NODE_UML_SIGNAL_CONTEXT = 'UML:Signal.context';
  NODE_UML_EVENT_STATE = 'UML:Event.state';
  NODE_UML_STATE_DEFERRABLE_EVENT = 'UML:State.deferrableEvent';
  NODE_UML_PARTITION_CONENTS = 'UML:Partition.contents';
  NODE_UML_CLASSIFIER_ROLE_BASE = 'UML:ClassifierRole.base';
  NODE_UML_CLASSIFIER_ROLE_FEATURE = 'UML:ClassifierRole.availableFeature';
  NODE_UML_CLASSIFIER_ROLE_CONTENTS = 'UML:ClassifierRole.availableContents';
  NODE_UML_ASSOC_END_ROLE_BASE = 'UML:AssociationEndRole.base';
  NODE_UML_DIAGRAM_STYLE = 'UML:Diagram.style';
  NODE_UML_DIAGRAM_ELEM_STYLE = 'UML:DiagramElement.style';
  NODE_UML_ACTIVITYGRAPH_PARTITION = 'UML:ActivityGraph.partition';
  NODE_UML_BEHAVIORFEATURE_PARAMETER = 'UML:BehavioralFeature.parameter';
  NODE_UML_CLASSIFIER_FEATURE = 'UML:Classifier.feature';
  NODE_UML_NAMESPACE_OWNED_ELEMENT = 'UML:Namespace.ownedElement';
  NODE_UML_COMPOSITE_STATE_SUBVERTEX = 'UML:CompositeState.subvertex';
  NODE_UML_INTERACTION_MESSAGE = 'UML:Interaction.message';
  NODE_UML_LINK_CONNECTION = 'UML:Link.connection';
  NODE_UML_ASSOCIATION_ROLE_CONNECTION = 'UML:AssociationRole.connection';
  NODE_UML_MODEL_ELEMENT_TEMPLATE_PARAMETER = 'UML:ModelElement.templateParameter';
  NODE_STATE_MACHINE_TRANSITION = 'UML:StateMachine.transitions';
  NODE_UML_ACTION_SEQUENCE_ACTION = 'UML:ActionSequence.action';
  NODE_UML_TRANSITION_TRIGGER = 'UML:Transition.trigger';
  NODE_UML_STRUCTUAL_FEATURE_MULTIPLICITY = 'UML:StructualFeature.multiplicity';
  NODE_UML_INSTANCE_CLASSIFIER = 'UML:Instance.classifier';
  NODE_UML_ABSTRACTION_MAPPING = 'UML:Abstraction.mapping';
  // XMI Attributes
  ATTR_XMI_NAME = 'xmi.name';
  ATTR_XMI_VERSION = 'xmi.version';
  ATTR_XMI_ID = 'xmi.id';
  ATTR_XMI_SUBJECT = 'subject';
  ATTR_XMI_VALUE = 'xmi.value';
  ATTR_XMI_REF = 'xmi.idref';
  // XMI Attributes for UML
  ATTR_UML_NAME = 'name';
  ATTR_UML_NAMESPACE = 'namespace';
  ATTR_UML_CONTEXT = 'context';
  ATTR_UML_VISIBILITY = 'visibility';
  ATTR_UML_SPECIFICATION = 'isSpecification';
  ATTR_UML_ROOT = 'isRoot';
  ATTR_UML_LEAF = 'isLeaf';
  ATTR_UML_ABSTRACT = 'isAbstract';
  ATTR_UML_REPRESENTED_CLASSIFIER = 'representedClassifier';
  ATTR_UML_REPRESENTED_OPERATION = 'representedOperation';
  ATTR_UML_CONTAINER = 'container';
  ATTR_UML_ACTIVITYGRAPH = 'activityGraph';
  ATTR_UML_OWNER = 'owner';
  ATTR_UML_BEHAVIORAL_FEATURE = 'behavioralFeature';
  ATTR_UML_MODEL_ELEMENT = 'modelElement';
  ATTR_UML_STATE_MACHINE = 'stateMachine';
  ATTR_UML_SOURCE = 'source';
  ATTR_UML_TARGET = 'target';
  ATTR_UML_TRANSITION = 'transition';
  ATTR_UML_EXTENDED_ELEMENT = 'extendedElement';
  ATTR_UML_ASSOCIATION_END = 'associationEnd';
  ATTR_UML_TYPE = 'type';
  ATTR_UML_CLIENT = 'client';
  ATTR_UML_SUPPLIER = 'supplier';
  ATTR_UML_PARENT = 'parent';
  ATTR_UML_CHILD = 'child';
  ATTR_UML_SUPERTYPE = 'supertype';
  ATTR_UML_SUBTYPE = 'subtype';
  ATTR_UML_BASE = 'base';
  ATTR_UML_ADDITION = 'addition';
  ATTR_UML_EXTENSION = 'extension';
  ATTR_UML_INTERACTION = 'interaction';
  ATTR_UML_SENDER = 'sender';
  ATTR_UML_RECEIVER = 'receiver';
  ATTR_UML_COMM_CONN = 'communicationConnection';
  ATTR_UML_DIAGRAM_TYPE = 'diagramType';
  ATTR_UML_SUBJECT = 'subject';
  ATTR_UML_GEOMETRY = 'geometry';
  ATTE_UML_ANNOTATED_ELEM = 'annotatedElement';
  ATTR_UML_TRIGGER = 'trigger';
  ATTR_UML_CONSTRINT = 'constraint';
  ATTR_UML_BODY = 'body';
  ATTR_UML_TEMPLATE_PARAM2 = 'templateParameter2';
  ATTR_UML_TEMPLATE_PARAM3 = 'templateParameter3';
  ATTR_UML_POWERTYPE_RANGE = 'powertypeRange';
  ATTR_UML_IS_ACTIVE = 'isActive';
  ATTR_UML_OWNER_SCOPE = 'ownerScope';
  ATTR_UML_CHANGEABILITY = 'changeability';
  ATTR_UML_TARGET_SCOPE = 'targetScope';
  ATTR_UML_LOWER = 'lower';
  ATTR_UML_UPPER = 'upper';
  ATTR_UML_NAVIGABLE = 'isNavigable';
  ATTR_UML_ORDERING = 'ordering';
  ATTR_UML_AGGREGATION = 'aggregation';
  ATTR_UML_QUERY = 'isQuery';
  ATTR_UML_CONCURRENCY = 'concurrency';
  ATTR_UML_SPEC = 'specification';
  ATTR_UML_KIND = 'kind';
  ATTR_UML_DISCRIMINATOR = 'discriminator';
  ATTR_UML_POWER_TYPE = 'powertype';
  ATTR_UML_RESIDENT = 'resident';
  ATTR_UML_MODEL_ELEM2 = 'modelElement2';
  ATTR_UML_DEFAULT_ELEM = 'defaultElement';
  ATTR_UML_SEND_ACTION = 'sendAction';
  ATTR_UML_IS_ASYNCHRONOUS = 'isAsynchronous';
  ATTR_UML_STIMULUS = 'stimulus';
  ATTR_UML_INSTANTIATION = 'instantiation';
  ATTR_UML_ASSOCIATION = 'association';
  ATTR_UML_ASSOCIATION2 = 'Association';
  ATTR_UML_OPERATION = 'operation';
  ATTR_UML_SIGNAL = 'signal';
  ATTR_UML_STATE = 'state';
  ATTR_UML_PARAMETER = 'parameter';
  ATTR_UML_DEFERRABLE_EVENT = 'deferrableEvent';
  ATTR_UML_IS_CONCURRENT = 'isConcurrent';
  ATTR_UML_FINAL = 'final';
  ATTR_UML_CONSTRAINING_ELEM = 'constrainingElement';
  ATTR_UML_SUBMACHINE = 'submachine';
  ATTR_UML_CONTENTS = 'contents';
  ATTR_UML_AVAILABLE_FEATURE = 'availableFeature';
  ATTR_UML_AVAILABLE_CONTENTS = 'availableContents';
  ATTR_UML_MESSAGE = 'message';
  ATTR_UML_AVAILABLE_QUALIFIER = 'availableQualifier';
  ATTR_UML_IS_DYNAMIC = 'isDynamic';
  ATTR_UML_IS_INSTANTIALBLE = 'isInstantiable';
  ATTR_UML_ACTION = 'action';
  ATTR_UML_ACTIVATOR = 'activator';
  ATTR_UML_PREDECESSOR = 'predecessor';
  ATTR_UML_BASE_CLASS = 'baseClass';
  ATTR_UML_TAG = 'tag';
  ATTR_UML_VALUE = 'value';
  ATTR_UML_STYLE = 'style';
  ATTR_UML_PARTICIPANT = 'participant';
  ATTR_UML_MESSAGE2 = 'message2';
  ATTR_UML_MESSAGE1 = 'message1';
  ATTR_UML_DEPLOYMENT_LOCATION = 'deploymentLocation';
  ATTR_UML_NODE_INSTANCE = 'nodeInstance';
  ATTR_UML_GENERAILIZATION = 'generalization';
  ATTR_UML_SPECIALIZATION = 'specialization';
  ATTR_UML_CLASSIFIER = 'classifier';
  ATTR_UML_LINK_END = 'linkEnd';
  ATTR_UML_STIMULUS3 = 'stimulus3';
  ATTR_UML_STIMULUS2 = 'stimulus2';
  ATTR_UML_INSTANCE = 'instance';
  ATTR_UML_LINK = 'link';
  ATTR_UML_CLIENT_DEPENDENCY = 'clientDependency';
  ATTR_UML_SUPPLIER_DEPENDENCY = 'supplierDependency';
  ATTR_UML_SUBMACHINE_STATE = 'submachineState';
  ATTR_UML_OUTGOING = 'outgoing';
  ATTR_UML_INCOMING = 'incoming';
  ATTR_UML_EXTEND = 'extend';
  ATTR_UML_EXTEND2 = 'extend2';
  ATTR_UML_INCLUDE = 'include';
  ATTR_UML_INCLUDE2 = 'include2';
  ATTR_UML_MULTIPLICITY = 'multiplicity';
  ATTR_UML_ELEMENT_RESIDENCE = 'elementResidence';
  ATTR_UML_IMPL_LOCATION = 'implementationLocation';
  ATTR_UML_CONSTRAINED_ELEMENT = 'constrainedElement';
  ATTR_UML_COMPONENT_INSTANCE = 'componentInstance';
  ATTR_UML_DIAGRAM_OWNER = 'DiagramOwner';
  ATTR_TOOL_NAME = 'toolName';
  ATTR_FONT_COLOR_BLUE = 'Font.Blue';
  ATTR_FONT_COLOR_GREEN = 'Font.Green';
  ATTR_FONT_COLOR_RED = 'Font.Red';
  ATTR_FONT_FACE = 'Font.FaceName';
  ATTR_FONT_SIZE = 'Font.Size';
  ATTR_FONT_BOLD = 'Font.Bold';
  ATTR_FONT_ITALIC = 'Font.Italic';
  ATTR_FONT_UNDER_LINE = 'Font.Underline';
  ATTR_FONT_STRIKE = 'Font.Strikethrough';
  ATTR_LINE_COLOR_BLUE = 'LineColor.Blue';
  ATTR_LINE_COLOR_GREEN = 'LineColor.Green';
  ATTR_LINE_COLOR_RED = 'LineColor.Red';
  ATTR_FILL_COLOR_BLUE = 'FillColor.Blue';
  ATTR_FILL_COLOR_GREEN = 'FillColor.Green';
  ATTR_FILL_COLOR_RED = 'FillColor.Red';
  ATTR_FILL_COLOR_TRANSP = 'FillColor.Transparent';
  ATTR_AUTO_RESIZE = 'AutomaticResize';
  ATTR_UML_SHOW_OP_SIG = 'ShowOperationSignature';
  ATTR_SHOW_OP_SIG = 'ShowOperationSignature';
  ATTR_UML_SUPPRESS_ATTR = 'SuppressAttributes';
  ATTR_SUPPRESS_ATTR = 'SuppressAttributes';
  ATTR_SHOW_ALL_ATTR = 'ShowAllAttributes';
  ATTR_UML_SUPPRESS_OP = 'SuppressOperations';
  ATTR_SUPPRESS_OP = 'SuppressOperations';
  ATTR_SHOW_ALL_OP = 'ShowAllOperations';
  ATTR_NOTE_TEXT_IGNORED = 'Dummy element for lame repository';
  // Streotypes and types
  TYPE_ENUMERATION = 'enumeration';
  TYPE_REALIZE = 'realize';
  TYPE_USAGE = 'usage';
  TYPE_PERMISSION = 'permission';
  TYPE_BINDING = 'binding';
  TYPE_SIMPLE = 'simple';
  TYPE_SYNCHRONOUS = 'synchronous';
  TYPE_PROCEDURAL = 'procededure_call';
  TYPE_ASYNCHRONOUS = 'asynchronous';
  TYPE_RETURN = 'return';
  TYPE_ROSE_USECASE_MODEL = 'useCaseModel';
  TYPE_BASE_CLASS = 'Class';
  TYPE_BASE_ABSTRACTION = 'Abstraction';
  TYPE_BASE_MESSAGE = 'Message';
  TYPE_DIAGRAM_CLASS = 'classdiagram';
  TYPE_DIAGRAM_USECASE = 'usecasediagram';
  TYPE_DIAGRAM_SEQUENCE = 'sequencediagram';
  TYPE_DIAGRAM_COLLABORATION = 'collaborationdiagram';
  TYPE_DIAGRAM_STATECHART = 'statediagram';
  TYPE_DIAGRAM_ACTIVITY = 'activitydiagram';
  TYPE_DIAGRAM_COMPONENT = 'componentdiagram';
  TYPE_DIAGRAM_DEPLOYMENT = 'deploymentdiagram';
  TYPE_DIAGRAM_MODULE = 'modulediagram';
  TYPE_DOCUMENTATION = 'documentation';
  TYPE_ORDERING = 'ordering';
  TYPE_IS_MULTI_INSTANCE = 'isMultiInstance';
  TYPE_ARGUMENTS = 'arguments';
  TYPE_ITERATION = 'iteration';
  TYPE_BRANCH = 'branch';
  TYPE_ATTACHMENT = 'attachment';
  TYPE_ROSE_ATTACH_FILE = 'RationalRose:externalFile';
  TYPE_ROSE_ATTACH_URL = 'RationalRose:externalURL';
  TYPE_UNDEFINED = '<undefined>';
  TYPE_EXCEPTION = 'exception';
  TYPE_SIGNAL = 'signal';
  // TaggedValue names
  TAG_DOCUMENTATION = 'documentation';
  TAG_ROSE_ATTACH_FILE = 'RationalRose:externalFile';
  TAG_ROSE_ATTACH_URL = 'RationalRose:externalURL';
  TAG_ATTACHMENT = 'attachment';
  TAG_IS_MULTIINSTANCE = 'isMultiInstance';
  TAG_ARGUMENTS = 'arguments';
  TAG_RETURN = 'return';
  TAG_ITERATION = 'iteration';
  TAG_BRANCH = 'branch';
  TAG_ORDERING = 'ordering';
  // Values
  UML_VALUE_TRUE = 'True';
  UML_VALUE_FALSE = 'False';
  XMI_VALUE_TRUE = 'true';
  XMI_VALUE_FALSE = 'false';
  XMI_VALUE_PUBLIC = 'public';
  XMI_VALUE_IN = 'in';
  XMI_VALUE_UNORDERD = 'unordered';
  XMI_VALUE_NONE = 'none';
  XMI_VALUE_INSTANCE = 'instance';
  XMI_VALUE_CHANGEABLE = 'changeable';
  XMI_VALUE_FORK = 'fork';
  XMI_VALUE_JOIN = 'join';
  XMI_VALUE_ROSE = 'Rational Rose 98';
  // ETC
  MODEL_USECASE_VIEW = 'Use Case View';
  MODEL_LOGICAL_VIEW = 'Logical View';
  MODEL_COMPONENT_VIEW = 'Component View';
  MODEL_DEPLOYMENT_VIEW = 'Deployment View';
  DGM_CLASS_DIAGRAM = 'ClassDiagram';
  DGM_USECASE_DIAGRAM = 'UseCaseDiagram';
  DGM_SEQUENCE_DIAGRAM = 'SequenceDiagram';
  DGM_COLLABORATION_DIAGRAM = 'CollaborationDiagram';
  DGM_STATE_DIAGRAM = 'StateDiagram';
  DGM_ACTIVITY_DIAGRAM = 'ActivityDiagram';
  DGM_MODULE_DIAGRAM = 'ModuleDiagram';
  DGM_DEPLOYMENT_DIAGRAM = 'DeploymentDiagram';
  VIEW_PREFIX_ASSOCIATION = 'Association';
  VIEW_PREFIX_MODULE = 'Module';
  VIEW_PREFIX_DEPENDENCY_RELATION = 'DependencyRelation';
  VIEW_PREFIX_INHERITANCE = 'Inheritance';
  VIEW_PREFIX_NOTE = 'Note';
  VIEW_PREFIX_CATEGORY = 'Category';
  VIEW_PREFIX_REALIZE_RELATION = 'RealizeRelation';
  VIEW_PREFIX_SWIMLANE = 'SwimLane';
  VIEW_PREFIX_TRANSITION = 'Transition';

implementation

end.
