object RevEngWizardForm: TRevEngWizardForm
  Left = 346
  Top = 200
  ActiveControl = ShellTreeView
  BorderStyle = bsDialog
  Caption = 'Java Reverse Engineering'
  ClientHeight = 420
  ClientWidth = 585
  Color = clBtnFace
  Font.Charset = ANSI_CHARSET
  Font.Color = clWindowText
  Font.Height = -11
  Font.Name = 'Tahoma'
  Font.Style = []
  Icon.Data = {
    0000010001002020000001000800A80800001600000028000000200000004000
    0000010008000000000000040000000000000000000000010000000100000000
    000000008000008000000080800080000000800080008080000080808000C0DC
    C000F0CAA600AA3F2A00FF3F2A00005F2A00555F2A00AA5F2A00FF5F2A00007F
    2A00557F2A00AA7F2A00FF7F2A00009F2A00559F2A00AA9F2A00FF9F2A0000BF
    2A0055BF2A00AABF2A00FFBF2A0000DF2A0055DF2A00AADF2A00FFDF2A0000FF
    2A0055FF2A00AAFF2A00FFFF2A000000550055005500AA005500FF005500001F
    5500551F5500AA1F5500FF1F5500003F5500553F5500AA3F5500FF3F5500005F
    5500555F5500AA5F5500FF5F5500007F5500557F5500AA7F5500FF7F5500009F
    5500559F5500AA9F5500FF9F550000BF550055BF5500AABF5500FFBF550000DF
    550055DF5500AADF5500FFDF550000FF550055FF5500AAFF5500FFFF55000000
    7F0055007F00AA007F00FF007F00001F7F00551F7F00AA1F7F00FF1F7F00003F
    7F00553F7F00AA3F7F00FF3F7F00005F7F00555F7F00AA5F7F00FF5F7F00007F
    7F00557F7F00AA7F7F00FF7F7F00009F7F00559F7F00AA9F7F00FF9F7F0000BF
    7F0055BF7F00AABF7F00FFBF7F0000DF7F0055DF7F00AADF7F00FFDF7F0000FF
    7F0055FF7F00AAFF7F00FFFF7F000000AA005500AA00AA00AA00FF00AA00001F
    AA00551FAA00AA1FAA00FF1FAA00003FAA00553FAA00AA3FAA00FF3FAA00005F
    AA00555FAA00AA5FAA00FF5FAA00007FAA00557FAA00AA7FAA00FF7FAA00009F
    AA00559FAA00AA9FAA00FF9FAA0000BFAA0055BFAA00AABFAA00FFBFAA0000DF
    AA0055DFAA00AADFAA00FFDFAA0000FFAA0055FFAA00AAFFAA00FFFFAA000000
    D4005500D400AA00D400FF00D400001FD400551FD400AA1FD400FF1FD400003F
    D400553FD400AA3FD400FF3FD400005FD400555FD400AA5FD400FF5FD400007F
    D400557FD400AA7FD400FF7FD400009FD400559FD400AA9FD400FF9FD40000BF
    D40055BFD400AABFD400FFBFD40000DFD40055DFD400AADFD400FFDFD40000FF
    D40055FFD400AAFFD400FFFFD4005500FF00AA00FF00001FFF00551FFF00AA1F
    FF00FF1FFF00003FFF00553FFF00AA3FFF00FF3FFF00005FFF00555FFF00AA5F
    FF00FF5FFF00007FFF00557FFF00AA7FFF00FF7FFF00009FFF00559FFF00AA9F
    FF00FF9FFF0000BFFF0055BFFF00AABFFF00FFBFFF0000DFFF0055DFFF00AADF
    FF00FFDFFF0055FFFF00AAFFFF00FFCCCC00FFCCFF00FFFF3300FFFF6600FFFF
    9900FFFFCC00007F0000557F0000AA7F0000FF7F0000009F0000559F0000AA9F
    0000FF9F000000BF000055BF0000AABF0000FFBF000000DF000055DF0000AADF
    0000FFDF000055FF0000AAFF000000002A0055002A00AA002A00FF002A00001F
    2A00551F2A00AA1F2A00FF1F2A00003F2A00553F2A00F0FBFF00A4A0A0008080
    80000000FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00FFFF
    FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
    FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
    FFFFFFFFF6D4098283878383828309838383838787D4AFF6FFFFFFFFFFFFFFFF
    FFAF09835B562E33565A5A5B565632562E322E2E325A8387ABD4AFFFFFFFFFFF
    AF5A5A5A5B5B5BF75B7FF75F8383835F7F7F7F7F83088708D4AFABAFFFFFFFFF
    D1AB5B5B83ABAFD1AFD4838383838383ABAFD1D1AFAFAFD4ABD1FFFFFFFFFFFF
    FFF6AF0987D4D1D47E5A5632323332325683D1FFFFFFFFFFD1FFFFFFFFFFFFFF
    FFFFFFFFFFF6F65A332E2E322E5657565B5B09AFABAFD1FFFFFFFFFFFFFFFFFF
    FFFFFFFFFFD1D45B5683ABABABD487A78383ABFFAFA65FABD1FFFFFFFFFFFFFF
    FFFFFFFFFFFF0956565A5B5B835A7F830908D4D4FFD187835FD4FFFFFFFFFFFF
    FFFFFFFFFFFF82335BD4D4AB7EA708A6A7ABD4D1D109AB098383ABFFFFFFFFFF
    FFFFFFFFFFAF875A5A7EA6AFA6C8D5C8CCD4ABD4D1AF83ABABD483D4FFFFFFFF
    FFFFFFFFAB5B575B837E7E82A77EA2827E7E835AD4FF097E8383F783FFFFFFFF
    FFFFFFAFF732575F837F7E7EA77F565B7E565B5B5A83835B56565A09FFFFFFFF
    FFFFFFFFD4838283D4D4AA9E83A6A6AAABABAFD483565632325683D1FFFFFFFF
    FFFFFFFFFFFFF6D1AFD1A79D9DA2A6C8CCD1FFFFF6AB838383D4D1FFFFFFFFFF
    FFFFFFFFFFF6CCA6C8CCC49999C4C808FFFFFFFFF6CCFFFFFFFFFFFFFFFFFFFF
    FFFFFFFFCCA6CCCCAABF99C3A1C4A6CCFFFFFFF6A6D0FFFFFFFFFFFFFFFFFFFF
    FFFFFFD1C8D0FFD1CC9DBFA2C8C3C4C8D1FFFFC8CCFFFFFFFFFFFFFFFFFFFFFF
    FFFFF6C8CCD1D5C8C49999BFC3C8C3A2C8F6D1C8F6FFFFFFFFFFFFFFFFFFFFFF
    FFFFD1CCD1D5CCCCCC9D99BFC4A6C8C8CCC8C8A2F6FFFFFFFFFFFFFFFFFFFFFF
    FFFFF6D5D5A6D5FFD1C8C39DC49DA1C8CCCCC89DCCFFFFFFFFFFFFFFFFFFFFFF
    FFFFF6D5CCC8F6FFF6CCC8A2C39999A6CDA2C8CD9DCCFFFFFFFFFFFFFFFFFFFF
    FFFFD1C8CCA6F6FFF6CCD5A6CCA6C8D0FFD1C3CCC8A1D1FFFFFFFFFFFFFFFFFF
    FFFFFFCDC8C8D5FFFFD1D1CCC8D0D1FFFFFFD1C8F6F6FFFFFFFFFFFFFFFFFFFF
    FFFFFFF6C8C4A6F6FFD1CCD1C8F6FFFFFFFFFFD5D1FFFFFFFFFFFFFFFFFFFFFF
    FFFFFFFFD1C8BFC8D1D1C8CCC8F6FFFFFFFFFFFFD1FFFFFFFFFFFFFFFFFFFFFF
    FFFFFFFFFFD1CCA2C8CCD5C8CCF6FFFFFFFFFFCDD1FFFFFFFFFFFFFFFFFFFFFF
    FFFFFFFFFFFFFFD1D5D5F6D5A6A6D0D1F6CCC8AAF6FFFFFFFFFFFFFFFFFFFFFF
    FFFFFFFFFFFFFFFFFFFFFFFFF6CCC8C8CCC8D5F6FFFFFFFFFFFFFFFFFFFFFFFF
    FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
    FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
    0000000000000000000000000000000000000000000000000000000000000000
    0000000000000000000000000000000000000000000000000000000000000000
    0000000000000000000000000000000000000000000000000000000000000000
    000000000000000000000000000000000000000000000000000000000000}
  OldCreateOrder = False
  Position = poScreenCenter
  OnClose = FormClose
  OnCreate = FormCreate
  OnShow = FormShow
  PixelsPerInch = 96
  TextHeight = 13
  object RevWizard: TJvWizard
    Left = 0
    Top = 0
    Width = 585
    Height = 420
    ActivePage = SelectSourceFilePage
    ButtonBarHeight = 42
    ButtonStart.Caption = 'To &Start page'
    ButtonStart.NumGlyphs = 1
    ButtonStart.Width = 85
    ButtonLast.Caption = 'To &Last page'
    ButtonLast.NumGlyphs = 1
    ButtonLast.Width = 85
    ButtonBack.Caption = '< &Back'
    ButtonBack.NumGlyphs = 1
    ButtonBack.Width = 75
    ButtonNext.Caption = '&Next >'
    ButtonNext.NumGlyphs = 1
    ButtonNext.Width = 75
    ButtonFinish.Caption = '&Finish'
    ButtonFinish.NumGlyphs = 1
    ButtonFinish.ModalResult = 1
    ButtonFinish.Width = 75
    ButtonCancel.Caption = '&Cancel'
    ButtonCancel.NumGlyphs = 1
    ButtonCancel.ModalResult = 2
    ButtonCancel.Width = 75
    ButtonHelp.Caption = '&Help'
    ButtonHelp.NumGlyphs = 1
    ButtonHelp.Width = 75
    ShowRouteMap = False
    DesignSize = (
      585
      420)
    object SelectSourceFilePage: TJvWizardInteriorPage
      Header.ParentFont = False
      Header.Title.Color = clNone
      Header.Title.Text = 'Select Source Code'
      Header.Title.Anchors = [akLeft, akTop, akRight]
      Header.Title.Font.Charset = ANSI_CHARSET
      Header.Title.Font.Color = clWindowText
      Header.Title.Font.Height = -16
      Header.Title.Font.Name = 'Tahoma'
      Header.Title.Font.Style = [fsBold]
      Header.Subtitle.Color = clNone
      Header.Subtitle.Text = 'Select source code for reverse engineering.'
      Header.Subtitle.Anchors = [akLeft, akTop, akRight, akBottom]
      Header.Subtitle.Indent = 20
      Header.Subtitle.Font.Charset = ANSI_CHARSET
      Header.Subtitle.Font.Color = clWindowText
      Header.Subtitle.Font.Height = -12
      Header.Subtitle.Font.Name = 'Tahoma'
      Header.Subtitle.Font.Style = []
      OnEnterPage = SelectSourceFilePageEnterPage
      OnCancelButtonClick = SelectSourceFilePageCancelButtonClick
      object SourceFileListLabel: TLabel
        Left = 8
        Top = 248
        Width = 176
        Height = 13
        Caption = '&Source file for Reverse Engineering: '
        FocusControl = SourceFileListView
      end
      object DirectoryLabel: TLabel
        Left = 8
        Top = 80
        Width = 48
        Height = 13
        Caption = '&Directory:'
        FocusControl = ShellTreeView
      end
      object CurDirLabel: TLabel
        Left = 280
        Top = 80
        Width = 193
        Height = 13
        Caption = 'Java source &file in the current directory:'
        FocusControl = ShellListView
      end
      object AddButton: TButton
        Left = 296
        Top = 232
        Width = 89
        Height = 25
        Caption = '&Add'
        TabOrder = 1
        OnClick = AddButtonClick
      end
      object RemoveButton: TButton
        Left = 392
        Top = 232
        Width = 89
        Height = 25
        Caption = '&Remove'
        TabOrder = 2
        OnClick = RemoveButtonClick
      end
      object ShellTreeView: TShellTreeView
        Left = 8
        Top = 96
        Width = 265
        Height = 129
        AutoContextMenus = False
        ObjectTypes = [otFolders]
        Root = 'rfDesktop'
        ShellListView = ShellListView
        UseShellImages = True
        AutoRefresh = False
        ChangeDelay = 500
        Indent = 19
        ParentColor = False
        RightClickSelect = True
        ShowRoot = False
        TabOrder = 0
        OnEnter = ShellTreeViewEnter
        OnChange = ShellTreeViewChange
      end
      object SourceFileListView: TListView
        Left = 8
        Top = 264
        Width = 569
        Height = 105
        Columns = <
          item
            Caption = 'File name'
            Width = 180
          end
          item
            Caption = 'Path'
            Width = 350
          end>
        MultiSelect = True
        ReadOnly = True
        RowSelect = True
        TabOrder = 4
        ViewStyle = vsReport
        OnDblClick = SourceFileListViewDblClick
        OnEnter = SourceFileListViewEnter
        OnKeyPress = SourceFileListViewKeyPress
        OnSelectItem = SourceFileListViewSelectItem
      end
      object AddAllButton: TButton
        Left = 488
        Top = 232
        Width = 89
        Height = 25
        Caption = 'Add A&ll'
        TabOrder = 3
        OnClick = AddAllButtonClick
      end
      object ShellListView: TShellListView
        Left = 280
        Top = 96
        Width = 297
        Height = 129
        AutoContextMenus = False
        AutoNavigate = False
        ObjectTypes = [otNonFolders]
        Root = 'rfDesktop'
        ShellTreeView = ShellTreeView
        Sorted = True
        OnAddFolder = ShellListViewAddFolder
        OnDblClick = ShellListViewDblClick
        ReadOnly = False
        HideSelection = False
        MultiSelect = True
        RowSelect = True
        OnChange = ShellListViewChange
        OnEnter = ShellListViewEnter
        TabOrder = 5
        ViewStyle = vsReport
        OnKeyPress = ShellListViewKeyPress
      end
    end
    object SelectPackagePage: TJvWizardInteriorPage
      Header.ParentFont = False
      Header.Title.Color = clNone
      Header.Title.Text = 'Select the Package to Contain Result'
      Header.Title.Anchors = [akLeft, akTop, akRight]
      Header.Title.Font.Charset = ANSI_CHARSET
      Header.Title.Font.Color = clWindowText
      Header.Title.Font.Height = -16
      Header.Title.Font.Name = 'Tahoma'
      Header.Title.Font.Style = [fsBold]
      Header.Subtitle.Color = clNone
      Header.Subtitle.Text = 'Select the package to contain result of reverse engineering.'
      Header.Subtitle.Anchors = [akLeft, akTop, akRight, akBottom]
      Header.Subtitle.Indent = 20
      Header.Subtitle.Font.Charset = ANSI_CHARSET
      Header.Subtitle.Font.Color = clWindowText
      Header.Subtitle.Font.Height = -12
      Header.Subtitle.Font.Name = 'Tahoma'
      Header.Subtitle.Font.Style = []
      OnEnterPage = SelectPackagePageEnterPage
      OnCancelButtonClick = SelectPackagePageCancelButtonClick
      object ProjectStructLabel: TLabel
        Left = 8
        Top = 80
        Width = 86
        Height = 13
        Caption = '&Project Structure:'
        FocusControl = SelectTreeFrame.SelectTree
      end
      inline SelectTreeFrame: TSelectTreeFrame
        Left = 7
        Top = 96
        Width = 570
        Height = 273
        Font.Charset = DEFAULT_CHARSET
        Font.Color = clWindowText
        Font.Height = -12
        Font.Name = 'Tahoma'
        Font.Style = []
        ParentFont = False
        TabOrder = 0
        ExplicitLeft = 7
        ExplicitTop = 96
        ExplicitWidth = 570
        ExplicitHeight = 273
        inherited SelectTree: TElTree
          Width = 570
          Height = 273
          HeaderSections.Data = {F4FFFFFF00000000}
          ExplicitWidth = 570
          ExplicitHeight = 273
        end
      end
    end
    object SetupOptionPage: TJvWizardInteriorPage
      Header.ParentFont = False
      Header.Title.Color = clNone
      Header.Title.Text = 'Option Setup'
      Header.Title.Anchors = [akLeft, akTop, akRight]
      Header.Title.Font.Charset = ANSI_CHARSET
      Header.Title.Font.Color = clWindowText
      Header.Title.Font.Height = -16
      Header.Title.Font.Name = 'Tahoma'
      Header.Title.Font.Style = [fsBold]
      Header.Subtitle.Color = clNone
      Header.Subtitle.Text = 'Configure options for reverse engineering.'
      Header.Subtitle.Anchors = [akLeft, akTop, akRight, akBottom]
      Header.Subtitle.Indent = 20
      Header.Subtitle.Font.Charset = ANSI_CHARSET
      Header.Subtitle.Font.Color = clWindowText
      Header.Subtitle.Font.Height = -12
      Header.Subtitle.Font.Name = 'Tahoma'
      Header.Subtitle.Font.Style = []
      OnEnterPage = SetupOptionPageEnterPage
      OnExitPage = SetupOptionPageExitPage
      OnCancelButtonClick = SetupOptionPageCancelButtonClick
      ExplicitWidth = 0
      ExplicitHeight = 0
      object DiagramGroupBox: TGroupBox
        Left = 264
        Top = 168
        Width = 313
        Height = 105
        Caption = ' Diagram '
        TabOrder = 2
        object DiagramNameLabel: TLabel
          Left = 16
          Top = 56
          Width = 120
          Height = 13
          Caption = 'The name of a diagram : '
        end
        object DiagramNameExLabel: TLabel
          Left = 144
          Top = 56
          Width = 101
          Height = 13
          Caption = 'e.g. Overview of %s'
        end
        object OverviewCheckBox: TCheckBox
          Left = 16
          Top = 24
          Width = 281
          Height = 17
          Caption = 'Create Overview diagram'
          Checked = True
          State = cbChecked
          TabOrder = 0
          OnClick = OverviewCheckBoxClick
        end
        object DiagramNameEdit: TEdit
          Left = 16
          Top = 72
          Width = 273
          Height = 21
          TabOrder = 1
          Text = 'Overview of %s'
        end
      end
      object ModelGroupBox: TGroupBox
        Left = 8
        Top = 80
        Width = 241
        Height = 193
        Caption = ' Model Generation '
        TabOrder = 0
        object VisibilityLabel: TLabel
          Left = 52
          Top = 85
          Width = 172
          Height = 13
          Alignment = taRightJustify
          Caption = 'Generate the following visibility only'
        end
        object VisbilityBevel: TBevel
          Left = 8
          Top = 104
          Width = 217
          Height = 9
          Shape = bsTopLine
        end
        object OmitInitialValueCheckBox: TCheckBox
          Left = 16
          Top = 48
          Width = 217
          Height = 17
          Caption = 'Generate the following visibility only'
          TabOrder = 1
        end
        object ReverseJavaDocCheckBox: TCheckBox
          Left = 16
          Top = 24
          Width = 217
          Height = 17
          Caption = 'Generate Javadoc to documentation'
          TabOrder = 0
        end
        object PackageMemberCheckBox: TCheckBox
          Left = 128
          Top = 112
          Width = 97
          Height = 17
          Caption = 'package'
          Checked = True
          State = cbChecked
          TabOrder = 3
        end
        object PublicMemberCheckBox: TCheckBox
          Left = 16
          Top = 112
          Width = 97
          Height = 17
          Caption = 'public'
          Checked = True
          State = cbChecked
          TabOrder = 2
        end
        object ProtectedMemberCheckBox: TCheckBox
          Left = 16
          Top = 136
          Width = 97
          Height = 17
          Caption = 'protected'
          Checked = True
          State = cbChecked
          TabOrder = 4
        end
        object PrivateMemberCheckBox: TCheckBox
          Left = 128
          Top = 136
          Width = 97
          Height = 17
          Caption = 'private'
          Checked = True
          State = cbChecked
          TabOrder = 5
        end
      end
      object ViewGroupBox: TGroupBox
        Left = 8
        Top = 280
        Width = 569
        Height = 81
        Caption = ' View '
        TabOrder = 3
        object OnlyInheritanceCheckBox: TCheckBox
          Left = 232
          Top = 48
          Width = 313
          Height = 17
          Caption = 'Generate Generalization and Realization views only'
          TabOrder = 3
        end
        object SuppressAttrCheckBox: TCheckBox
          Left = 16
          Top = 24
          Width = 209
          Height = 17
          Caption = 'Suppress the Attribute compartment'
          TabOrder = 0
        end
        object SuppressOperCheckBox: TCheckBox
          Left = 16
          Top = 48
          Width = 209
          Height = 17
          Caption = 'Suppress the Operation compartment'
          TabOrder = 2
        end
        object HideOperationSignatureCheckBox: TCheckBox
          Left = 232
          Top = 24
          Width = 313
          Height = 17
          Caption = 'Hide the Operation signature'
          TabOrder = 1
        end
      end
      object RefFieldGroupBox: TGroupBox
        Left = 264
        Top = 80
        Width = 313
        Height = 81
        Caption = ' Reference field creation '
        TabOrder = 1
        object FieldAsAssocRadioButton: TRadioButton
          Left = 16
          Top = 48
          Width = 289
          Height = 17
          Caption = 'Create the field to the Association'
          TabOrder = 1
        end
        object FieldAsAttrRadioButton: TRadioButton
          Left = 16
          Top = 24
          Width = 289
          Height = 17
          Caption = 'Create the field to the Attribute'
          Checked = True
          TabOrder = 0
          TabStop = True
        end
      end
    end
    object RunPage: TJvWizardInteriorPage
      Header.ParentFont = False
      Header.Title.Color = clNone
      Header.Title.Text = 'Reverse Engineering'
      Header.Title.Anchors = [akLeft, akTop, akRight]
      Header.Title.Font.Charset = ANSI_CHARSET
      Header.Title.Font.Color = clWindowText
      Header.Title.Font.Height = -16
      Header.Title.Font.Name = 'Tahoma'
      Header.Title.Font.Style = [fsBold]
      Header.Subtitle.Color = clNone
      Header.Subtitle.Text = 'Reverse engineers the source code.'
      Header.Subtitle.Anchors = [akLeft, akTop, akRight, akBottom]
      Header.Subtitle.Indent = 20
      Header.Subtitle.Font.Charset = ANSI_CHARSET
      Header.Subtitle.Font.Color = clWindowText
      Header.Subtitle.Font.Height = -12
      Header.Subtitle.Font.Name = 'Tahoma'
      Header.Subtitle.Font.Style = []
      VisibleButtons = [bkFinish]
      OnPage = RunPagePage
      OnFinishButtonClick = RunPageFinishButtonClick
      ExplicitWidth = 0
      ExplicitHeight = 0
      object MessageLabel: TLabel
        Left = 16
        Top = 296
        Width = 81
        Height = 13
        Caption = '( Main Message )'
      end
      object SourceFileLabel: TLabel
        Left = 8
        Top = 80
        Width = 61
        Height = 13
        Caption = '&Source Files:'
        FocusControl = ReverseReportListView
      end
      object FileNumInfoLabel: TLabel
        Left = 449
        Top = 80
        Width = 128
        Height = 13
        Alignment = taRightJustify
        Caption = '( Information of progress )'
      end
      object MessageSubLabel: TLabel
        Left = 16
        Top = 312
        Width = 77
        Height = 13
        Caption = '( Sub message )'
      end
      object Bevel1: TBevel
        Left = 16
        Top = 280
        Width = 545
        Height = 9
        Shape = bsTopLine
      end
      object ReverseProgressbar: TProgressBar
        Left = 16
        Top = 336
        Width = 553
        Height = 25
        TabOrder = 1
      end
      object ReverseReportListView: TListView
        Left = 8
        Top = 96
        Width = 569
        Height = 169
        Columns = <
          item
            Caption = 'File Name'
            Width = 180
          end
          item
            Caption = 'Path'
            Width = 265
          end
          item
            Caption = 'Status'
            Width = 90
          end>
        HideSelection = False
        ReadOnly = True
        RowSelect = True
        SmallImages = StateMarkImageList
        TabOrder = 0
        ViewStyle = vsReport
      end
    end
  end
  object SelectTreeImageList: TImageList
    Left = 92
    Top = 384
    Bitmap = {
      494C010106000900040010001000FFFFFFFFFF10FFFFFFFFFFFFFFFF424D3600
      0000000000003600000028000000400000002000000001002000000000000020
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000000000000000000000000000000000000000000000008484840000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000000000000000000000000000000000000000000000008484840000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000FFFF0000FFFF0000FF
      FF00000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000848484008484
      8400848484008484840084848400848484008484840084848400848484008484
      8400848484000000000000000000000000000000000000000000000000000000
      00000000000000000000000000008484840000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000000000000000000000000000000000000000000000008484840000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000000000000000000000
      000000000000000000008484840000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF0000FFFF0000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000000000000000000000000000000000000000000000008484840000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000000000000000000000
      000000000000000000008484840000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF0000FFFF0000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000848484008484
      8400848484008484840084848400848484008484840084848400848484008484
      8400848484000000000000000000000000000000000000000000000000000000
      000000000000000000008484840000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF0000FFFF0000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000000000000000000000000000000000000000000000008484840000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000000000000000000000
      00000000000000000000000000008484840000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000000000000000000000000000000000000000000000008484840000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000008484840000FFFF0000FFFF0000FF
      FF00000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000000000000000000000000000000000000000000000008484840000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000084848400848484008484
      8400000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000848484008484
      8400848484008484840084848400848484008484840084848400848484008484
      8400848484008484840000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000084848400848484008484840000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00008484840000FFFF0000FFFF00848484008400000084000000848484000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000000000000000000000000000000000000000000000008484840000FF
      FF0000FFFF0000FFFF0000FFFF00848484008400000084000000840000008400
      0000848484000000000000000000000000000000000084848400000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000084848400000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000084848400000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000FFFF0000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF00848484008400000084000000840000008400
      000084000000840000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000FFFF0000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF00848484008400000084000000840000008400
      000084000000840000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF000000000000FFFF0000FFFF0000FFFF000000000000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000FFFF0000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF00848484008400000084000000840000008400
      000084000000840000000000000000000000000000008484840000FFFF0000FF
      FF000000000000000000000000000000000000000000000000000000000000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF000000000000FFFF0000FFFF0000FFFF000000000000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000FFFF0000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF00848484008400000084000000840000008400
      000084000000840000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF000000000000FFFF0000FFFF0000FFFF000000000000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000000000000000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000FFFF0000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF00848484008400000084000000840000008400
      000084000000840000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF000000000000FFFF000000000000FFFF0000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF000000000000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000FFFF0000FFFF0000FF
      FF0000FFFF008484840084848400000084008484840084848400840000008400
      000084000000840000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF000000000000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF000000000000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000000FFFF0000FFFF008484
      8400848484000000840000008400000084000000840000008400848484008484
      840084000000840000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF00000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FFFF0000FF
      FF0000FFFF000000000000000000000000000000000084848400848484000000
      8400000084000000840000008400000084000000840000008400000084000000
      8400848484008484840000000000000000000000000084848400848484008484
      8400848484008484840084848400848484008484840084848400848484008484
      8400848484000000000000000000000000000000000084848400848484008484
      8400848484008484840084848400848484008484840084848400848484008484
      8400848484000000000000000000000000000000000084848400848484008484
      8400848484008484840084848400848484008484840084848400848484008484
      8400848484000000000000000000000000000000000000008400000084000000
      8400000084000000840000008400000084000000840000008400000084000000
      840000008400000084000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF000000000000000000000000000000
      000000000000000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF000000000000000000000000000000
      000000000000000000000000000000000000000000008484840000FFFF0000FF
      FF0000FFFF0000FFFF0000FFFF0000FFFF000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000848484000000
      8400000084000000840000008400000084000000840000008400000084000000
      8400848484000000000000000000000000000000000084848400848484008484
      8400848484008484840084848400848484008484840000000000000000000000
      0000000000000000000000000000000000000000000084848400848484008484
      8400848484008484840084848400848484008484840000000000000000000000
      0000000000000000000000000000000000000000000084848400848484008484
      8400848484008484840084848400848484008484840000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000848484000000840000008400000084000000840000008400848484000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000084848400000084008484840000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      000000000000000000000000000000000000424D3E000000000000003E000000
      2800000040000000200000000100010000000000000100000000000000000000
      000000000000000000000000FFFFFF00FFFFFFFF00000000FFFFFFFF00000000
      C003FFFF00000000C003FF8F00000000C003FF0700000000C003FE0300000000
      C003FC0100000000C003800100000000C003FC0100000000C003FE0300000000
      C003FF0700000000C003FF8F00000000C003FFFF00000000FFFFFFFF00000000
      FFFFFFFF00000000FFFFFFFF00000000FC7FFFFFFFFFFFFFF01FFFFFFFFFFFFF
      C007800380038003800380038003800380038003800380038003800380038003
      8003800380038003800380038003800380038003800380038003800380038003
      80038003800380038003807F807F807FC007807F807F807FF01FFFFFFFFFFFFF
      FC7FFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000
      000000000000}
  end
  object StateMarkImageList: TImageList
    Left = 144
    Top = 384
    Bitmap = {
      494C010104000900040010001000FFFFFFFFFF10FFFFFFFFFFFFFFFF424D3600
      0000000000003600000028000000400000002000000001002000000000000020
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000000000000000A5A5A500A5A5A500A5A5A500A5A5A500000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000EFF70000EFF70000EFF70000EFF700000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000000000000000088C0000088C0000088C0000088C0000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      000000000000000000000000FF000000FF000000FF000000FF00000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000A5A5A500A5A5A500A5A5A500A5A5A500A5A5A5009494940094949400A5A5
      A500000000000000000000000000000000000000000000000000000000000000
      000000EFF70000EFF70000EFF70000EFF70000EFF70000BDC60000BDC60000EF
      F700000000000000000000000000000000000000000000000000000000000000
      0000088C0000088C0000088C0000088C0000088C00000873000008730000088C
      0000000000000000000000000000000000000000000000000000000000000000
      00000000FF000000FF000000FF000000FF000000FF000000CE000000CE000000
      FF00000000000000000000000000000000000000000000000000000000000000
      0000A5A5A500A5A5A500A5A5A500A5A5A500A5A5A500A5A5A500949494009494
      9400000000000000000000000000000000000000000000000000000000000000
      000000EFF70000EFF70000EFF70000EFF70000EFF70000EFF70000BDC60000BD
      C600000000000000000000000000000000000000000000000000000000000000
      0000088C0000088C0000088C0000088C0000088C0000088C0000087300000873
      0000000000000000000000000000000000000000000000000000000000000000
      00000000FF000000FF000000FF000000FF000000FF000000FF000000CE000000
      CE0000000000000000000000000000000000000000000000000000000000A5A5
      A500A5A5A500A5A5A500A5A5A500A5A5A500A5A5A500A5A5A500A5A5A5009494
      9400A5A5A50000000000000000000000000000000000000000000000000000EF
      F70000EFF70000EFF70000EFF70000EFF70000EFF70000EFF70000EFF70000BD
      C60000EFF700000000000000000000000000000000000000000000000000088C
      0000088C0000088C0000088C0000088C0000088C0000088C0000088C00000873
      0000088C00000000000000000000000000000000000000000000000000000000
      FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000
      CE000000FF00000000000000000000000000000000000000000000000000A5A5
      A50000000000A5A5A500A5A5A500A5A5A500A5A5A500A5A5A500A5A5A5009494
      9400A5A5A50000000000000000000000000000000000000000000000000000EF
      F7000000000000EFF70000EFF70000EFF70000EFF70000EFF70000EFF70000BD
      C60000EFF700000000000000000000000000000000000000000000000000088C
      000000000000088C0000088C0000088C0000088C0000088C0000088C00000873
      0000088C00000000000000000000000000000000000000000000000000000000
      FF00CECEFF000000FF000000FF000000FF000000FF000000FF000000FF000000
      CE000000FF00000000000000000000000000000000000000000000000000A5A5
      A5000000000000000000A5A5A500A5A5A500A5A5A500A5A5A500A5A5A500A5A5
      A500A5A5A50000000000000000000000000000000000000000000000000000EF
      F700000000000000000000EFF70000EFF70000EFF70000EFF70000EFF70000EF
      F70000EFF700000000000000000000000000000000000000000000000000088C
      00000000000000000000088C0000088C0000088C0000088C0000088C0000088C
      0000088C00000000000000000000000000000000000000000000000000000000
      FF00CECEFF00CECEFF000000FF000000FF000000FF000000FF000000FF000000
      FF000000FF00000000000000000000000000000000000000000000000000A5A5
      A5000000000000000000A5A5A500A5A5A500A5A5A500A5A5A500A5A5A500A5A5
      A500A5A5A50000000000000000000000000000000000000000000000000000EF
      F700000000000000000000EFF70000EFF70000EFF70000EFF70000EFF70000EF
      F70000EFF700000000000000000000000000000000000000000000000000088C
      00000000000000000000088C0000088C0000088C0000088C0000088C0000088C
      0000088C00000000000000000000000000000000000000000000000000000000
      FF00CECEFF00CECEFF000000FF000000FF000000FF000000FF000000FF000000
      FF000000FF000000000000000000000000000000000000000000000000000000
      0000A5A5A5000000000000000000A5A5A500A5A5A500A5A5A500A5A5A500A5A5
      A500000000000000000000000000000000000000000000000000000000000000
      000000EFF700000000000000000000EFF70000EFF70000EFF70000EFF70000EF
      F700000000000000000000000000000000000000000000000000000000000000
      0000088C00000000000000000000088C0000088C0000088C0000088C0000088C
      0000000000000000000000000000000000000000000000000000000000000000
      00000000FF00CECEFF00CECEFF000000FF000000FF000000FF000000FF000000
      FF00000000000000000000000000000000000000000000000000000000000000
      0000A5A5A500A5A5A5000000000000000000A5A5A500A5A5A500A5A5A500A5A5
      A500000000000000000000000000000000000000000000000000000000000000
      000000EFF70000EFF700000000000000000000EFF70000EFF70000EFF70000EF
      F700000000000000000000000000000000000000000000000000000000000000
      0000088C0000088C00000000000000000000088C0000088C0000088C0000088C
      0000000000000000000000000000000000000000000000000000000000000000
      00000000FF00CECEFF00CECEFF00CECEFF000000FF000000FF000000FF000000
      FF00000000000000000000000000000000000000000000000000000000000000
      00000000000000000000A5A5A500A5A5A500A5A5A500A5A5A500000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000EFF70000EFF70000EFF70000EFF700000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000000000000000088C0000088C0000088C0000088C0000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      000000000000000000000000FF000000FF000000FF000000FF00000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      000000000000000000000000000000000000424D3E000000000000003E000000
      2800000040000000200000000100010000000000000100000000000000000000
      000000000000000000000000FFFFFF0000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      0000000000000000000000000000000000000000000000000000000000000000
      00000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
      FC3FFC3FFC3FFC3FF00FF00FF00FF00FE007E007E007E007E007E007E007E007
      C003C003C003C003C803C803C803C003CC03CC03CC03C003CC03CC03CC03C003
      E607E607E607E007E307E307E307E007F00FF00FF00FF00FFC3FFC3FFC3FFC3F
      FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000
      000000000000}
  end
end
