<div  align="center" >
<!-- <img src="https://res.cloudinary.com/dharme/image/upload/v1652064464/Copy_of_Dx_kxd5ty.png" width="400" height="300"/> -->

<img src="./Images/Banner.png" alt="banner-image"/>
</div>





## Outline

- [Outline](#outline)
- [Resources](#resources)
- [What is Technical Writing?](#what-is-technical-writing)
- [Articles](#articles)
- [Books](#books)
- [Courses](#courses)
- [Youtube](#youtube)
- [Communities](#communities)
- [Writing Tools](#writing-tools)
- [Documentation Tools](#documentation-tools)
- [Who pays technical writers](#who-pays-technical-writers)
- [Open Source Projects](#open-source-projects)
    - [Open Source Projects/Programs Technical Writers Can Contribute To](#open-source-projectsprograms-technical-writers-can-contribute-to)
- [Blogs to follow for awesome writing contents](#blogs-to-follow-for-awesome-writing-contents)
- [Preparing for technical writing interviews](#preparing-for-technical-writing-interviews)
- [Sites to publish articles](#sites-to-publish-articles)
- [Job Boards For Technical Writing roles](#job-boards-for-technical-writing-roles)
- [](#)

## Resources

This repository contains different technical writing resources that has been gathered from all around the internet

## What is Technical Writing?
Technical writing is a form of communication that helps users solve problems with technology. It is the process of creating clear, concise, and informative content designed to convey complex information in a way that is easily understood by the intended audience. 

 It often involves writing manuals, guides, reports, and documentation that explain technical concepts, processes, or products.

## Articles

- [Technical Writing Beyond Blogposts](https://medium.com/@techwritershub/technical-writing-beyond-blogposts-46b2f23168ce)
- [How to Get Started with Technical Writing](https://www.samjulien.com/how-to-get-started-with-technical-writing)
- [How to become a technical writer](https://www.freecodecamp.org/news/how-to-become-a-technical-writer/)
- [Technical Writing for Beginners – An A-Z Guide to Tech Blogging Basics](https://www.freecodecamp.org/news/technical-writing-for-beginners/)
- [Technical Writing: What and How?](https://edidiongasikpo.com/technical-writing-what-and-how)
- [How to Learn Technical Writing for Free](https://medium.com/technical-writing-is-easy/how-to-learn-technical-writing-for-free-c16d191b3cee)
- [Getting Started with Technical Writing](https://dillionmegida.com/p/getting-started-with-technical-writing/)
- [Advice for Technical Writing](https://css-tricks.com/advice-for-technical-writing/)
- [How To Write Content That Readers Will Read Based On Learnings From User Psychology](https://www.everythingtechnicalwriting.com/how-to-write-content-that-readers-will-read/)
- [How To Create A Technical Writing Portfolio](https://www.everythingtechnicalwriting.com/technical-writing-portfolio/)
- [Writing Tips for Software Developers – How to Become a Better Tech Writer](https://www.freecodecamp.org/news/writing-tips-software-developers/)
- [11 Best Practices for Writing API Documentation](https://treblle.com/blog/11-best-practices-for-writing-api-documentation)
- [Technical Writing vs Technical Blogging](https://lo-victoria.com/what-you-need-to-know-about-technical-writing-vs-technical-blogging#cknj3ppa30d7m2ks14c8o0vnf)

## Books

- [Writing Well](https://www.julian.com/guide/write/intro) ~ Julian Shapiro
- [Technical Writing, Simplified](https://www.amazon.com/Technical-Writing-Simplified-Nell-Johnson/dp/154326848X/ref=sr_1_1?crid=NUEHTLJWKLMN&keywords=Technical+Writing%2C+Simplified&qid=1651614066&s=books&sprefix=technical+writing%2C+simplified%2Cstripbooks-intl-ship%2C416&sr=1-1) ~ Nell Johnson
- [Writing for Sotware Developers](https://philipkiely.gumroad.com/l/uZPZU) ~ Philip Kiely
- [Technical Writing For Dummies](https://www.amazon.com/Technical-Writing-Dummies-Sheryl-Lindsell-Roberts/dp/0764553089) ~ Sheryl Lindsell-Roberts

- [Docs for Developers: An Engineer’s Field Guide to Technical Writing](https://www.amazon.com/Docs-Developers-Engineers-Technical-Writing/dp/1484272161/) ~ Jared Bhatti
- [Modern Technical Writing: An Introduction to Software Documentation ](https://www.amazon.com/Modern-Technical-Writing-Introduction-Documentation-ebook/dp/B01A2QL9SS/ref=sr_1_1?crid=Y7S35M7LVXWE&dchild=1&keywords=modern+technical+writing&qid=1595414707&sprefix=modern+technical+%2Caps%2C346&sr=8-1) ~ Andrew Etter
- [Everybody Writes: Your Go-To Guide to Creating Ridiculously Good Content](https://www.amazon.com/gp/product/1118905555/ref=as_li_tl?ie=UTF8&tag=techlife09-20&camp=1789&creative=9325&linkCode=as2&creativeASIN=1118905555&linkId=5a9769d7dc1a62419abb83e6b451ac96) ~ Ann Handley
- [On Writing Well](https://www.amazon.com/gp/product/0060891548/ref=as_li_tl?ie=UTF8&tag=techlife09-20&camp=1789&creative=9325&linkCode=as2&creativeASIN=0060891548&linkId=27bd72a8da3fb242b39dbe4edb470daf) ~ William Zinsser
- [Technical Communication](https://www.amazon.com/Technical-Communication-Mike-Markel-dp-1319245005/dp/1319245005/ref=dp_ob_image_bk) ~ Mike Markel

## Courses

- [Technical Writing Courses for Engineers](https://developers.google.com/tech-writing)
- [Technical Writing: How to Write Software Documentation](https://www.udemy.com/course/start-your-career-as-user-assistance-developer/)
- [Learn API Technical Writing: JSON and XML for Writers](https://www.udemy.com/course/api-documentation-1-json-and-xml/)
- [The Art of API Documentation](https://www.udemy.com/course/the-art-of-api-documentation/)
- [Documenting APIs: A guide for technical writers and engineers](https://idratherbewriting.com/learnapidoc/)
- [Technical Writer Certification Course](https://technicalwriter.teachable.com/p/technical-writing-certification) ~ Technical Writer Certification Course was created for aspiring technical writers or people who want to brush up on their technical writing skills.
- [SEO FOR DEVS](https://seofordevs.com/) ~ SEO FOR DEVS is a free 2 weeks course that helps people discover your tech blog or side project in a systematic way
- [API Documentation for Developers](https://apidocsfordevs.com/) ~ A hands-on guide to creating and maintaining API documentation.

## Youtube

- [DocToHelpTV](https://www.youtube.com/user/DocToHelpTV/videos)
- [Technical Writer HQ](youtube.com/channel/UCjMnGjosWhBxYtumwhQLZmA/videos)
- [Amruta Ranade](https://www.youtube.com/channel/UCKsaZMjb3lsLe5YtasDifuA)
- [William Smith](https://www.youtube.com/watch?v=amKDhaIlyOc)
- [How to become a Technical Writer | Skills & Career Growth](youtube.com/watch?v=8l2KJXIBpB0)

## Communities

Communities can provide valuable learning opportunities, growth, mentorship and career advancement. Connecting with people of similar interest is one of the reasons why people join communities. Here are some of the communities that technical writers can join:

- [Write the Docs](https://www.writethedocs.org/)
- [Docnext](https://x.com/docnextcm)
- [Hackmamba](https://hackmamba.io/community/)
- [Linkedin Technical Writing Community](https://www.linkedin.com/groups/13705342/)
- [Global Writers Community](https://web.facebook.com/groups/technicalwriterjobs/?_rdc=1&_rdr)
- [API Documentation Group](https://www.linkedin.com/groups/3709151/)
- [Technical Writer Forum](https://www.linkedin.com/groups/112571/)
- [Hashnode](https://discord.com/invite/hashnode)
- [The Good Docs Project Community](https://thegooddocsproject.dev/community/)
- [Techwriters.dev](https://techwriters.dev/)
- [r/technicalwriting](https://www.reddit.com/r/technicalwriting/)

## Writing Tools

- [Canva](https://www.canva.com/) ~ Canva is a graphic design platform, used to create social media graphics, presentations, posters, documents and other visual content.
- [Removebg](https://www.remove.bg/) ~ A tools that is used to remove image backgrounds.
- [Markdown](https://daringfireball.net/projects/markdown/) ~ Markdown is a text-to-HTML conversion tool for web writers.
- [AsciiDoc](https://asciidoc.org/) ~ AsciiDoc is a lightweight and semantic markup language primarily designed for writing technical documentation.
- [Denigma](https://denigma.app/) ~ Denigma is a tool that explains code in understandable english.
- [Grammarly](https://app.grammarly.com/) ~ Grammarly is a typing assistant that reviews spelling, grammar, punctuation, clarity, engagement, and delivery mistakes.
- [Hemingway App ](https://hemingwayapp.com/) ~ The Hemingway App is a web and desktop app that can improve your writing style and touch up your content.
- [Quillbot AI](https://quillbot.com/) ~ Quillbot AI is a multi-purpose writing tool that can assist in improving your writing style. Some of its products are Paraphraser, Grammar Checker, Plagiarism Checker, Co-Writer, Summarizer, Citation Generator, and Word Counter.
- [Notion](https://www.notion.so/) ~ Notion is an all-in-one workspace for your notes, tasks, wikis, and databases. It is a tool you can use to organize your thoughts, projects, and information.
- [Dropbox Paper](https://www.dropbox.com/paper) ~ Dropbox Paper is an online document workspace, where you can organize and display text, media, and files all in one place.
- [GoFullPage - Full Page Screen Capture](https://chrome.google.com/webstore/detail/gofullpage-full-page-scre/fdpohaocaechififmbbbbbknoalclacl?hl=en) ~ A chrome extension taht allows you take full page screenshot of your current browser window.
- [Carbon](https://carbon.now.sh/) ~ Carbon is the easiest way to create and share beautiful images of your source code.
- [Isitwp](https://www.isitwp.com/headline-analyzer) ~ IsItWP Headline Analyzer tool helps you write headlines that drive traffic, shares and rank better in search results.
- [Capitalize my title](https://capitalizemytitle.com/) ~ Making title capitalization easy for your writing
- [Wordtune](https://www.wordtune.com/) ~ Wordtune turns text into concise, engaging, well-written messages.
- [Headline Analyzer](https://coschedule.com/headline-analyzer) ~ Write Headlines That Drive Traffic, Shares, And Search Results.
- [Title Generator](https://tweakyourbiz.com/title-generator) ~ Generate great titles for articles and blog posts.
- [SEO writing assistant](https://www.semrush.com/swa/) ~ A smart writing editor that helps you optimize your copy for engagement and SEO.
- [HackMD](https://hackmd.io/) ~ A collaborative markdown editor for sharing your articles and getting feedback from others.
- [Copyscape](https://www.copyscape.com/) ~ Plagiarism checker
- [MarkDoc](https://markdoc.io/) ~ A superset of Markdown for creating custom documentation websites. It was created by Stripe and made open source in May 2022.
- [Wordtune](https://www.wordtune.com/) ~ Wordtune is  an AI- powered writing companion that rephrases your sentences to say exactly what you mean through clear, compelling, and authentic writing.

## Documentation Tools 

- [GitBook](https://www.gitbook.com/) ~ A modern documentation platform where teams can document everything from products to internal knowledge bases and APIs.
- [Read the Docs](https://readthedocs.org/) ~ An open-source platform for hosting, building, and versioning documentation.
- [Docusaurus](https://docusaurus.io/) ~ A static site generator that makes it easy to build open-source project websites.
- [Sphinx](https://www.sphinx-doc.org/) ~ A documentation generator that converts reStructuredText files into HTML websites and other formats.
- [MkDocs](https://www.mkdocs.org/) ~ A fast, simple, and static site generator that's geared towards building project documentation.
- [Swagger](https://swagger.io/) ~ A suite of tools for API documentation, including Swagger Editor, Swagger UI, and Swagger Codegen.
- [Postman](https://www.postman.com/) ~ A collaboration platform for API development that makes it easy to create, share, test, and document APIs.
- [Slate](https://slatedocs.github.io/slate/) ~ A static site generator specifically designed for API documentation.
- [Redoc](https://github.com/Redocly/redoc) ~ An open-source tool for generating API documentation from OpenAPI (formerly Swagger) definitions.
- [Docz](https://www.docz.site/) ~ A tool for writing documentation for your React components with MDX and live-reload support.
- [Jekyll](https://jekyllrb.com/) ~ A static site generator that transforms plain text into static websites and blogs.
- [Hugo](https://gohugo.io/) ~ A fast and flexible static site generator written in Go.
- [Antora](https://antora.org/) ~ A documentation site generator for creating documentation portals and technical documentation websites.
- [VuePress](https://vuepress.vuejs.org/) ~ A static site generator powered by Vue.js.
- [Asciidoctor](https://asciidoctor.org/) ~ A fast text processor and publishing toolchain for converting AsciiDoc content to HTML5, DocBook, PDF, and other formats.
- [Confluence](https://www.atlassian.com/software/confluence) ~ A collaboration tool used to help teams collaborate and share knowledge efficiently.
- [MadCap Flare](https://www.madcapsoftware.com/products/flare/) ~ A comprehensive technical authoring and publishing tool for creating content for various outputs.


## Who pays technical writers

Writing technical contents for organizations and publications is an excellent way to earn extra income. This way, you learn a lot, then share your knowledge and get paid. Check out these compiled list for organizations that pays technical writers.

- [Community writer program](https://github.com/malgamves/CommunityWriterPrograms)
- [Get Paid to Write for These 45+ Websites](https://blog.idrisolubisi.com/get-paid-to-write-for-these-45-websites)
- [Publications That Pay You To Write Technical Articles](https://catalins.tech/websites-that-pay-you-to-write-technical-articles)

## Open Source Projects

Contributing to open source can be a rewarding way to learn, teach, and build experience in just about any skill you can imagine. A lot of peole contribute to open source for different reasons and the vital one which is improving one's skillset.

Here are some articles to help you understand how to contribute to open source projects.

- [Open Source for Technical Writers](https://medium.com/@techwritershub/open-source-for-technical-writers-a-guide-on-how-to-make-contributions-ab1bb1962fc1)
- [The Technical Writers Guide to Contributing to Open Source Projects](https://edidiongasikpo.com/the-technical-writers-guide-to-contributing-to-open-source-projects)
- [How to Contribute to Open-Source as a Technical Writer](https://javascript.plainenglish.io/how-to-contribute-to-open-source-as-a-technical-writer-bb708245480c)
- [4 tips to becoming a technical writer with open source contributions](https://opensource.com/article/21/11/technical-writing-open-source)
- [Getting started with Open Source as a Technical Writer](https://amara.hashnode.dev/getting-started-with-open-source-as-a-technical-writer)

#### Open Source Projects/Programs Technical Writers Can Contribute To

- [Codecademy Docs](https://www.codecademy.com/resources/docs) ~ Docs is a community-driven collection of code documentation for popular programming languages and frameworks.
- [The Good Docs Project](https://thegooddocsproject.dev/) ~ The Good Docs Project is a community working together to create the templates, tools, and resources to improve the overall quality of documentation in OSS and beyond.
- [Google Season of Docs](https://developers.google.com/season-of-docs) ~ Season of Docs provides support for open source projects to improve their documentation and gives professional technical writers an opportunity to gain experience in open source.
- [Hacktoberfest](https://hacktoberfest.digitalocean.com/) ~ Hacktoberfest is a yearly event to encourage people to contribute to open source in October.
- [The GNOME Documentation Project](https://wiki.gnome.org/DocumentationProject)

## Blogs to follow for awesome writing contents

- [TechWriters Hub](https://medium.com/@techwritershub)
- [Kesi Parker](https://medium.com/@kesiparker)
- [IDRatherbewriting](https://idratherbewriting.com/)
- [Everything Technical Writing](https://www.everythingtechnicalwriting.com)
- [WriteTech Hub](https://writetechhub.org/blog/)
- [Hackmamba](https://hackmamba.io/blog/)
  

## Preparing for technical writing interviews

There are several tips that can help you land an interview but some of the important ones are having a well tailored resume and cover letters. Check out these cover letter templates and tips to help you land your next interview:

- [Cover Letter Template for your next job ](https://dillionmegida.com/p/cover-letter-template/)
- [How to Write an Enticing Cover Letter](https://ruthikegah.xyz/how-to-write-an-enticing-cover-letter)
- [How to Write a Technical Writer Resume [+Examples]](https://technicalwriterhq.com/technical-writer-resume/)
- [Best Technical Writer Cover Letter Example and Format ](https://technicalwriterhq.com/technical-writer-cover-letter/)

Here are some resources to technical writing interview questions to help you prepare for your next interview.

- [12 Technical Writer Interview Questions and Answers](https://technicalwriterhq.com/technical-writer-interview-questions/)
- [Google Technical Writer Interview Questions](https://technicalwriterhq.com/google-technical-writer-interview-questions/)
- [Technical Writing Job Interview](https://www.youtube.com/watch?v=cqaEgMv2JAg)

## Sites to publish articles

- [Hashnode](https://hashnode.com/) ~ Hashnode is a free developer blogging platform to help you share your ideas with people in tech, developers, and engineers.
- [Medium](https://medium.com/) ~ Medium is a social publishing platform with lots of users and you can publish diverse contents and ideas.
- [Dev.to](https://dev.to/) ~ Dev.to is where programmers share ideas and help each other grow. It is an online community for sharing and discovering great ideas.
- [Mirror.xyz](https://mirror.xyz/) ~ Mirror.xyz is a publishing platform for writers that leverages cryptocurrency and blockchain technology.
- [Freecodecamp](https://www.freecodecamp.org/news/how-to-write-for-freecodecamp/) ~ FreeCodeCamp is a non-profit organization that consists of an interactive learning web platform, an online community forum, chat rooms, online publications and local organizations that intend to make learning web development accessible to anyone.

## Job Boards For Technical Writing roles

- [Top Job Boards for Technical Writers](https://medium.com/@techwritershub/top-job-boards-for-technical-writers-7a318886d81d)

- [Startup.jobs](https://startup.jobs/?q=technical+writer)
- [Wellfound](wellfound.com/jobs)
  
- [Best Writing Jobs](https://bestwriting.com/jobs/?filter-title=Technical%20writer)

##

<p align="center">Made with ❤️ by <a href="https://twitter.com/that_yhemmygirl">Damilola Ezekiel</a> </p>
