# Contributing Guidelines

🎉🥳Yayyyy!!!! Thanks for taking time to contribute to this open source project.

[Technical Writing Resources](https://github.com/dharmelolar/technical-writing-resources) is [MIT license](https://github.com/dharmelolar/technical-writing-resources/blob/main/LICENSE.md) licensed and accepts contributions via GitHub pull requests. This document outlines some of the conventions on development workflow, commit message formatting, contact points, and other resources to make it easier to get your contribution accepted.

## How do I make contributions

All forms of contributions are welcomed. Here are some ways to get started with making contributions-

- Fixing typos in the repository
- Submit a typo/bug in GitHub Issues.
- Add new suggestions to the outline
- Add links to resources .

## Getting Started

- Fork the repository on GitHub.
- Clone the forked repository, into your local system:
  - [Getting started with GitHub Desktop](https://docs.github.com/en/desktop/installing-and-configuring-github-desktop/getting-started-with-github-desktop) will guide you through setting up Desktop.
  - Once Desktop is set up, you can use it to [fork the repo](https://docs.github.com/en/desktop/contributing-and-collaborating-using-github-desktop/cloning-and-forking-repositories-from-github-desktop)!
- Create a working branch and start with your changes!

## Guidelines for contributing

- Pull requests should be descriptive.
- Proofread for spelling and grammar errors before raising a pull request.
- Use descriptive commit messages.
- If you're suggesting a very big change, kindly open an issue first.

## Contribution Flow

This is an outline of what a contributor's workflow looks like:

- Create a separate branch from `master` branch to base your work.
- Make commits of logical units.
- Make sure your commit messages are in the standard format (see below).
- Push your changes to a topic branch in your fork of the repository.
- Make sure to proofread the content before submitting.
- Fetch Upstream & make sure your fork / branch is conflict free
- Submit a pull request to the original repository.

#### Commit Messages

Please follow the below format while writing commit messages:

```
  title: One line description about your change
  <Blank Line>
  description: An optional description of your changes
```

## Pull Request

When you're finished with the changes, create a pull request, also known as a PR.

- Once you submit your PR, a Docs team member will review your proposal. We may ask questions or request for additional information.
- We may ask for changes to be made before a PR can be merged, either using [suggested changes](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/incorporating-feedback-in-your-pull-request) or pull request comments. You can apply suggested changes directly through the UI. You can make any other changes in your fork, then commit them to your branch.
- As you update your PR and apply changes, mark each conversation as [resolved](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/commenting-on-a-pull-request#resolving-conversations).
- If you run into any merge issues, checkout this [git tutorial](https://github.com/skills/resolve-merge-conflicts) to help you resolve merge conflicts and other issues.

Thanks for your contribution!


<hr>

<p align="center">Made with ❤️ by Damilola Ezekiel</p>
