CREATE DATABASE  IF NOT EXISTS `chat_app` /*!40100 DEFAULT CHARACTER SET utf8 */;
USE `chat_app`;
-- MySQL dump 10.13  Distrib 5.7.9, for Win64 (x86_64)
--
-- Host: localhost    Database: chat_app
-- ------------------------------------------------------
-- Server version	5.7.11-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `emoji`
--

DROP TABLE IF EXISTS `emoji`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emoji` (
  `emoji_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `emoji_code` varchar(6) DEFAULT NULL,
  `emoji_name` varchar(50) DEFAULT NULL,
  `emoji_data` text NOT NULL,
  `e_group_id` int(11) unsigned NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`emoji_id`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emoji`
--

LOCK TABLES `emoji` WRITE;
/*!40000 ALTER TABLE `emoji` DISABLE KEYS */;
INSERT INTO `emoji` VALUES (1,'1f600','grinning face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAwFBMVEVMaXH/zEz/zlH/zE3/zEz/zEz/y0z/y0z/xkv/zEz/zEz/zU7/zEz/zEz/zEz/zEz/zEz/zEz/zEv/zE3/zEz/zEz/zEz/zE3/zU3/zEz/zEz/y0z/zEz/y03/zE1mRQBrSQPtvENyTwZ7VwpxUhL2w0iqgSLisj7e18js6OCSbBXJnDGlkmmGYRC1pYScdBv///+5jSnQojX49vP+/v13Wh3FuJ69kiuHbTfSpDZ/ZCrYqjmYglSkex7Pxa+Se0qAAzOiAAAAHnRSTlMAYwtu0UD5/gXuhyKScvFbsrkart3r5stWdVA0MuAShyFhAAAC4klEQVR4AazTRXpjMRAE4HrYkpnxS5m2kwnscv+DmVEm0b8UNwgvqGlSaeU9XZa6l7cqyVTBQydrNWhotLIOnKTNtvAhaTeV/THZgC/0KylsqLHmG7pu8aoip4VegddUTWhFagovVIe0Nqy+CKtBB42n4U1KOilHeCgROpLk4XuEzuTBm4qSHsoChmqDXhpG7dSQnoYK12r0VsOVQuhNrtKkcgbIFU7GDFLHUdpnkH769EGLr+Xya0HL8dOT1ICGxXK2tVzYjg9S7DRpkM/Z3qfYjZNN7LRp+J0d/dqNk21sdYSGr9OGL7txUjoAMppWpw0ru/GtDECLpvlpw9xufKsLKB3jIK0wZYzQOEVChiebTFAhn5b/z258p4IWGdaQp2znJAO+yEmOD5IBn/akB80o+igZRRnvoE0rVpEdNxAFzcxKNqHfTOoRk/n+pwrbHn3homutV+KiYLf2PQzRp8HrPx53pqWjDtAHeawIMKdiPUl3rGPlGBDVPyJCv0gOb+BO5fG9plTKHz+kpFTfx7lyHN6Qo1+k/9NuYDU26Kf9iiRnJbAoffsjbIgoaXxHZgg63ySY6PQESS0HAGGzrLKmSfxr91ALQQCIEPVD9+qTxtgqy6zA6hZh8XfwG7XNZmFr+A2Hxb9nRy38gTBzPEbAH7TYjnoGSf8/B19O0ZTJ/+dHsUHuXI/pct2UozRNPabb18MQoeENwpuqz1IZL+ANGocIHGue4QPiKXkxtqyq0pqX5EnAB55RrBkGLclhBbgcC1o7l9v0msAiiMbvfiyMFrCIAofR8XhcLF1TjOLxZGB/ZDAD9ogC+0yFoDNysqGoQsyWmuOcTFxO3lfG0/OlmiXVCBVREtesFcVPtugGN61cLn7jVZTGynFGCONOxXSkioYqx2Hq+ulhqAEh1KQRZGQ5OFwx+1x+Xowe+yfhh6h5nASZxt7GuugUs5xGK8c6hJNvu2fR23wYne1+m7uWX1iL7IE5/nCDAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:07','2017-08-19 09:31:07',NULL),(2,'1f601','beaming face with smiling eyes','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAWlBMVEVHcEz/zEz/zEz/zU3/zEz/zE3/zEz8yUr/yk3/zEz/zEz/zEz/zEz/zE1mRQD///93VQttSwXrukKofiCEajGPaRS/kyzRozXHu6CdiFvp5NqzooDXzrvQxrD6eS+gAAAADXRSTlMAz44eXHE7/QbusOC5tAGNlwAAArZJREFUWMO9WNkWoyAMdUe0OGzi/v+/OaLVEQTFypn7gk3tbRYSEoLAjjxLoiIsIQCwDIsoyfLgB8RpAZEGWKTxM5Y8+SALPom7XnlaogvANHekgegGTlRZiBxQZnfqRMgR0aVScYicEV4EMIPoAaDVvASgRwCJhQc9RuKJx8iUgV+IwMlPMUQ/AWqxy0P0I0J1P0XoZ0SKg9ALZD4M04xL0Suku0LwHRHM/Si0q/RWoV2lBL3Gmimf90SfJTmQB8Q+XL25uzBmtagJqQW4k20oLDGjuFqA6bXsGDdTmlFSfUHolUxJOEPwAa52YGCXqRvAUECYfJtRuq52mVpMCrNhy7v1bohJpnk7NCq0ar/Yw2wytZYE58ZDvinWRyF/b5OpzUAATURHF2ObTI1/cI5Ag3GjP5tkaqQDgLwABNAPEQxKP0RlEPohCs3J/xzFKUUcnQ9OKaIlLSMVrllDrXyANqzGFWF60qplRPxL8ZoJ0VBKwcwJwPzQCCEpNgitjKiF7VAs7lDrB5LibeJOVGmlVi3+kmhqO35BSHjXTnLVi3+smzb8mdGP7dB1nGOMZ1IyL5x33dCOvfx20CtArB+QsmzxP7fgmo8+pyN7idp0xzPpUVuP7PyQbnTxwtD2dpa+HRYP0nNfk2q2rftIumRoZ4zjOMl1kE7b9gepDZ3WcStR1+AbFFJVYm48zNT6Kc3oehLyNfjKdpIbYGgnrp+Rx047Oybl8mu+ubv/YvvIT6d2ZmvYm/X/W1PI2tXZja1hV41rVov4qNOMvDrxaCOEOtR8mSo+HPZTP3xpSHMx1GhjFq0PKdotG2j3e00vxyy9uRWW/Cfi6QhJmYGKMHrPcxqO555Rq4la/2gbjg3j+lLoyYzlQHAe1/1dIPi70nC+ZAmz/3ft4+8iyuPVmMfLuh+uD/8CG6DZ9UhRKfMAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:07','2017-08-19 09:31:07',NULL),(3,'1f602','face with tears of joy','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAulBMVEVMaXH/zEz/zE3/zExirub/zU7/zEz/y0z/zEz/zEz/zEz/zEz/zEz/zEtdrev/zU1crez/zExcrexcrexcrexkreRcrOxdrOxdrex3VQzNoDTzwUb/zE1xTwj5x0mDXg7ltUBrSgWqgSLAlC1ysNbZqzrTxHhmRQDHwoSedxz08u20iSeguquMaRqZhlVgmbywn3uLtr/ryWHf2MnJvaRgjqZjZkv2ylaFckS+3vdeo9X///9heXiNu92Jbzv2AAAAGHRSTlMAOm+N/QjP/O6z4FhiGk4i1HrikqRFfsqttr9yAAADm0lEQVR4AZzQNwLFMAgDUHeEyy+77n/OzOnYbwck3BPfo5YKEdSisXu3YgQFD6BhzG3JTYWXRFu2rwmVD/DPtjV/8AWCYZUvNKj+LU6kUXwM9S00K9+HWuAE3NZrwinSrvd04STpy3kMmbxwgZz+9AWXYOvFLJicB4EA2utVpj3Xb4G41e1c///f+hJo95aQ0J6+cdp5WQF2hlLv2h3ni3T0/bTvfJl9rUCOhsdHjHGnAs7YiHv6Gi2TlpiYuIMcViVigxx3ImqSO6N9UBqLSKpoj5tYadKxwB8oWFqd2kDhB6RzbTOgOFRfjFBTJo1UxGFshNTu48pEaWLPseDFSjXBlb4K6RAXokHBSGksiFHJpE5KD/OSIXNnB7gsAWbXk3Onu8lepoXFsZPK9DZ/7hZTqrlJnRXxBM6OBEVMzCPl7tFCc2dnOCmTzG29iUTxhcj5BKMiA7HeSvKYYUCu9xmRx0hIe9h8RroQRL7r+pFeL3M9JgfpEC8QhgF5ajsZO8pY99wP0T7WOt1cHMIfIL4qQd06ZyzFanfKmfsDgu/Z15FOo2/2gjKyryN92X0CfwgHGhx3DSV84KUh0NCn0M0C7tmIB6LbFQEfsTwJR5InRtcXsLjR55IuyloAkNEA/Zkjmfmc/g8AWpkuoqkNCw+snK2sAE2YWp94QNJ63OZ5BMWQFrtD48XfbeAXaUydRo/WR7Hanplh6uERuUEPtLZlRv56g0fkcO1J4IM5D7zaMx/wOXyQPG4O7Z76yAoIb8WxnkWTmAeBELnTEyIIeDyJZiz/6Q0Iq+5mbsv+T4FyP7CyAMpUdV9dtUPQeLGLWqCRra/aplZoxVNYrwmfAMGCN9U4WkGJ59fx7d1yPn+aMdfNpaHrstnTfL68ux2/PkOJqRpHjV4GpsiCIYKsp0Z2AmXebaJ3KJOokX0FBvfLcZ1mvFyAwZUUXYLBYsDuKlXjOzZ4AYMLKToFCvbfXd6WNbdLdzCoEv2TolaVSMJkm/LQxrKJrLyNkHO7yMQuOq+qkYWKYp+SYu9+2O7rin0MBg820QMYHDeqc0tcm8hNKjKrDikL/HqPHwwr9qPiAowbZhLWhBMbtxdcN5AL3VMgogpVGAmnYFr2IMdYpwQHg4j9UlKxwIGUYH1UXkR1edpqJVN9pgkezZgbhi6bRVxoI3o4TVqt08vjn3hA+IMnjd0fWTq7vG41d3j2+dOHqO1PY3//WPel58P/Ca7m7oH+00oAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(4,'1f923','rolling on the floor laughing','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAVFBMVEVHcEz/zEz/zEz/zEz/zEz/zU3/zUz/zEz7yEr/zEzvvkT/zE1mRQD////ot0BwTwqRaxV/XBGmfiDMnjLXqTi5jinu6+PKvqbc1MSVfk6pl2+KcDtE5+LbAAAAC3RSTlMAtItT0Bg66/5p9DawupcAAAM3SURBVFjDvVjbkqsgEIzGAJbIRdTE+P//ebICOgiDZGvrzKu7ne65D7dbxkhbVw2lXUdpU9Utuf3GHm31QQiNVu3jS5i26hCr2m/I0C5jtC6klYfZoEpYkaYrsObS8XVXaHXeO01XbE3GU4R2XxhF5d1Z95WxOxIt7B/EpJRWg4l/Jxm9OwIzKu5tjD4mOBFE18QPM7G6yE8PxM9mR9GTSHn8HDsk7kI6GDkhjJuyPPTCFCvLTIL9lSM0dJnMINfCOuFx4i+fhDCRODSDRgzHQMHtVcQckGYYU/dpjxxKyP5wHHWmeRAETwkvVZEWNhw5Om2Urgh1LEloBMluP1tKVabAFVeYsMWJ2ybC5upcpzCJ+rLC5KwBpUde2c/PY9X37FeQZO2FMrz61r532iRz2uh3QNoJ24G2LkUzZZa2wQvrvTSrjcQuEqMZBeuy7WnpAZCyTqpP7dnVuzJ47XH9g9Pvrco2k8DXRh6ZxlBHy9cPzhzkZBV0ENCfU4x8iT03Qs8AqIFBO1J/EOk03+y94fTvYLhQCOTnjha5gC0Wp9fBcKE3FjWZgeVwVofz4gEjBoAmtK+Cr3ruz8o2RgxIUwU40uPMnKM+Unt24TivPia0RY2C8CtfgQU4kBC3o6QKgKbsmNxx9oLd3GZbWw3DolkmXi4Rw2T03qhB0RqEUIwzSwg02aIlsNMnMpGpCCcQ5v6JwMY2JupL6LOfw4i54qdXrXaUMU7gIJd41UXz92sWxHlJzpOD7XHZV4+6SOBswd/GEarNu4evGRw796rcyN675dJncDRcbFIDie2LwhvgPM84lhDF15rRy5IgfU5xP2q8xRatg44G4ZqXCMeG7FiRW8TLgXtiWb6kWmQZ3WcAlJWi44Q1yHrsWzeM+vxOwPheQZCFXUV0XkkYLkXqlGxO68bi6MzPt+Y5nAY9ahwjvS7LukqOmRzTR81xZhleYm6IMpI5/FQBjj9y7plTlDF9iTPlTtHjOGYXnJTIH8fHuc6mnHfM5bkOHhCEuoLJPiDAzBRDHHoJ9qa6/JGFjYM6wLSCx3FDvn32EZ8l14ynNZe2//ch6u+exv7ysS54PmSs4PnwHyu/vaG7Li5xAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(5,'1f603','grinning face with big eyes','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAV1BMVEVHcEz/zEz/zEz/zUz/zEz/zEz/zEz/zEz/zEz/zkv/zE3/zEz/zE1mRQD///96WRC4jShyUAmYcx5rSQPNoDPntj/2xEiFXw7y7um9rpCfi2Db1MPVpziM2JXgAAAADHRSTlMAjD8e1rNw7VwIyzNtD1WQAAAClklEQVRYw62YbdeyIAzHNUWsMECEfOj7f86bLLtiDEJv9qJTZ+t3GLA/jKKI2LUtSV1Txmhdk7K9FkesaogluEZJU+2jnFvCAkbaczqmoSxitExExTErqknAnGqWYPXpV1YlS7R4ftWFJdslsoAnynYYDabXsp3WZuIESAc4KOnEDpk3TxU9BqJg7c7uug+cD/gfPc/F3U/uPhw6aygJ8ZThCTLyGS6Nz0E939Pk1pfoVhM+CPXUX/XuhvNXOPdBuOejBWd3xXT3Ng05AQ894wMSW7gIZOZ5GnRArN/CewgKed5DgrVx38LvLNXzqhSo83ILlyzVQ9bigOFqC1fpnsqf6mOgBsnsSGprbpT9/2Qzas93lrrIMQ+7IsK4f0OuG8A/yHaXyEtMSGppxj2kqBPF4oenxkA7he0NwkT/EZTaoIcWaRL/21OwTFbQPBxa1HlAdT4QyQMiRZkHVMKiFaqTvRh0+C96EL3slIBFe8Xru+O95T201sbuY2Psl8ESet7hCnAFwvaRrlVQPx/whyduFErtd+QPU1BqGwiaprmPAFU/TxMENfA4ek6BHG+327hY3txzLqWFKik572dLWFanhKJUwQNyVWX+DI7YyKFuE+/Ifq2aXGKchXur1nqXiLcqqzk4qHFSnm5v95rGP3EUn3DUxJETqUEuWp+DQsnZS3CZP2ctNiB0SOvu4/O0LKMd2jguyzTzvw2psAG5l1HDU3YjN+hl1Lke64TdrXSoiyjhpTxuQ+jC7rYQg9rBAS2E29Q8ZAwjH5GmBnQR+h7m3HW0zYKXWxFIT4q9LaRBUcIcaGqNAAneASbEQdp1M1iVlkpJq+CDSW7X8z0g5HvSyPfIkvHZJ+NDVL6nsYyPdQeeD/8BUyPLGP93REMAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(6,'1f604','grinning face with smiling eyes','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAwFBMVEVMaXH/zE3/zEz/zE3/y0z/y0n/u1X+y0z/zE3/zEz/zEz/zEv/zEz/zEz/zE3/0U//zU7/y03/zEz/zEz/zEz/zEv/zEz/zE3/zEz/zEz/y0z/zEz/y03/zE1xTwlrSQNmRQCqgSKTbBZ2VQ2DXg71w0e6jyrtvEPe18jltD/InDHOoDT29PClkmnywEb///95XCCgeR35xkl/Wwz+/v3FuJ7r5t3hsj7WpzeHbTe2p4aJYxG0o4GSe0rPxa+YglReaX8VAAAAHXRSTlMA7dGw+QcD/m/wYz3eUssMIv5bM4ka50N5kba7lXgqsfkAAALcSURBVHgBrM6FQQNBAATAfdezd9v+y8SdQM6mgsE/yrGdsrRP8jzp02xqxxIe5vpo+EOT1TOcFMNZ8abqHArYUvXCfyybgo1yS3hHUpe4q0tpoV/xv+IytGL2Av/Qktakxp/Whg6aFX8QOZ3kA25qKzqq2pufis4qgV/WnB7yFT/ohl4ajW8KSU+ywFcXve34ojP0Zjp8KFMGSEu82xikxhuVMEiiwkPfSsXCQEuBZwODDXh2MtiBJ3PFYNUMoGYENYCDEWRA2TCCpsTIKEa0j62YBZKsMBiEs+7uFsXdGZ/7n+rpGM2GNb7yJtUkyG/vqK4wKDWE26Ejx+S2pWWCL0gzrY7ckh2UIoOvyCO9jk97G/eT8w2MTK832CanoEjeINXrDU4JhBCfA75Oh1BCIAvlnKvUc82DA9P1UsV5rtMhL6GRNPyNf+/AN6RWB6NvR0c82mk/Rqdkux+jbbLTj9FO6xc56I5zulW38NMeCMapFJ6b6Swy1xOSciaaVscQRiy+RElheYPatk3z7c00bbseeJaQarXAgjDSDGwG/zQGBLbm02b80zAIteQQjUZlOGQdBsOwHKHRIaYj9ffpVHFcVE45CafDJKH0jymjNEmG03BSOlURx9W/ZZiOyAsGkaSKO6kS/geJCZJct96acrp8HNV6a9etIsJePIcw0NkEk8Xzs6GIWJQ1GAiTMnjXpkwWCyQ8aiy0ar6Ehk7RdCmckK4uu61CC76AlK9R89HMCYKiCAJnNporTcw+xGIUs0UHKmsXo1ge1+wTX3UN5fGKJ0wk3fiagh1aCP+jPXnaFgKamgHlHdBBs6kBTjbzkj3mWsZ2Z5sFjd+BpTketRrLzj5uRSPxjhUTEbSin2mOTQsOOLbMZnY9+3S7HvlC5pQxmkvhR1g3nvQ/QGiz99TPSOPTQ5btk0+MfQ57GPv0MIjC0dizbjT2DKOxTwzrdrZaR+oe1vUzPvwNDJDjzXj7E2EAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(7,'1f605','grinning face with sweat','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAvVBMVEVMaXH/zEz/zUz/zEz/zEz/zEz/zEz/zEz/zE39y0//zEz/zE11stX/zEz/zExcrOz/zEz/zEz/zExdretcrOxdrez/zE3/zExdretcrOxdretcrez+y0z/zE1drexmRQCCXg73xUhzUg7jsz7vvkSqgSJqSQPQojVvTQR5WBSPaRS6jyrEuZvLwoBmr+Sieh3e18js6ODJnDL49vOEajKWuLSnlGyVf0+2p4b///+0o4GrvKCYcRnPxa+hjWPxeSFBAAAAHXRSTlMA0h1Ai2Gw7wj76W783nQXVDO59a7EzslWfIPl/jE7qXwAAANISURBVHgBrNIFsgMhEIThXmWJu9JzgUhpynL/c8XtsQr7vgNQf0+BKuMkToO+0lr1gzROxvARdlNFi0q7IZxkycSwkJkkGZ6G8/mw5pluhxU68fOpmcis8pmBYg01yIC13KxRKgrYQD8aTuVuWJYTGzaie/IwR6FwyYb28rIqnKXYkD7Ky3aInJFmU2f52MCWGLoFPU2Hdo+hT1AuKdL0CcolhYpeQfavzBZszvTkjy2+Yjo4iGX1PZChg5NYZngLSJ9T5849oM+y/LZM0W1ZzswniD3JmT+DOnRylJwp7hL+00MTtp7Ww01oyLbHPoUAunR0kJxDF0BKR7qXW6ZTAIqtkw5UwJjuzvLH+VqMVShJC8Ngzt3vfu1NHSi+Lifv/1brElIoO3P2rafZVEK+kMxEd5XOl5qFIdOyTk5eSnbm3jqqIBCu6Qo5r5Onm3O6TBeDh/ZZK0Y3YKpOfpb2LrPsspeuGPrYYhDOKADjDjnEL+8KSV5pCa8OOcQV9n5AEQKHHODcQ1mIUSrytuSEcNnOBaXMIQc4w4YiFoDYIwGLXHJoCG7tAziHh/0RXEH3fwS/wAX5IRxbIUIcPOfQOkRBS7RPRaTbktSakG0dCerrssYRopGYrmEiHbcDqRSfRQPnSsmgHevIbBTiZ4g7RGyM7gh0RZ5gqvXpzghLZw3If2NomPS7DoN+t58M55/wfxc4HYmZhmiNRqNWkYzfB92uEWJm1BfCdLuD93FSLAbnagZ6YH+TICFZmNbIiZbBRHIPUjb0mihcdgphee3WuolQq3Pod+rMdMar81MgYk/BbQ0iQpN0Ks0kpoIirz3PWpKka4h+YW2qLzbDElxEswXZS8qBp81g+Fa0OrOFtIq34cCAoRz5foVfIIsYugMMyCJ7p17l7bH0aSNCsDFy4AEc4kTiRlAiEK+uhAia1tQGyr/BxqyiRobOfcH1nOCOAiyzCFEOOokUzELggCoLPxLXLCqMS2rz2GgoRZWuMBVqBXXIETJRXRzzmKFNxbycXeF63OW6auvIhL4fmki3FW5sgPNxNxDc+AX89YGWBlm1bD7aZNk78JqBu0c2zkG8f7wR9eHW2O3pTzTrQPvw17J9+KupfTgFi0nxTt+RoI4AAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(8,'1f606','grinning squinting face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAS1BMVEVHcEz/zE3/zUz/zEz/zEz/zEz/zEz/zEz/yk3/zEz/zEz/zE1mRQD///94Vg1sSQLvvUTZqjmMaRujex7KnTG2iyfn4te/sZSfi2C8LDMsAAAAC3RSTlMAcB6HO7PP6gZckrKS5OAAAAK2SURBVFjDvVjp1oIgEM0NNIyd9P2f9EMtZRmIzPPdH3VKvc5yhxm43dLo26HpEMaEYIy6Zmj72wnUVWcZfOCuqr9j6YeOJNAN5Xb1FSYZ4Ka/gmalqgqoWkQKgNtP5txJIe5Zo2pEioEyCWwx+QJp9wbyJYaLeBJMJ3hAppacQhSnGp8jwkHuekROAvl6upPTuF8QoChM5x0LnKvIT6h2g/BvRLi/xqDdpF8N2k0ayM/YKqX7nahbi+P4LShjVBrN849xbeRypzj+qv1Q0/EFqkSKRajjLj/cHUA0spFqiEZTewkg6vyciYNpuU8DNO514eUtKDMutJLvl0ovWFy+zbVhFDwsOCj5avfQeanYfVKgABrgXydWu3sajM2OBlIRZ2P8kBMexiEloTi/bMwTjSxWB7rhXGKczIjgQpBS7BNpR5JG8MAFzoVx5Ch8Iii/1GSKhJs3l3LvukX5ZenyCMPoqsNxjQIiTJq1UVEwRguRFKUrxxoHlwg5lQYXagqaOvFGVyxrmyCba4iasGhtED+skev6aHMbFq2/jJhDulLZxcKKcpHl8imENkoe+jbBMuI3I6+ixhhQOb8bkhdt6GEYjIVtpAqJpmmWGUIm52lavsNeW4eu0efj8Xg+Ld8sJaXUkjL7JeVsGZ7rRRq6VocNci3blSmDlWeUYYP0BLBlLc+08XhZG6Ihgr8CMad5plf8eDzXVEADoVOChgKtpAIGLXHoZI4cfM6HzgQwaIEmbVw2TY89ia5aIYP8YZTTEjlSDk/absGJAnW7a6y/i3AHds2+4rmntxAfmXR6C+FvagQttgfX2W3W3uEA+G2m/bTxMwn3mPl6C6kAKqb4iU0tN4GDMuzkQ/F2nds50A7Cy9CsooaQO4246gDhuiON4kMW1P7fsc91B1EXHo1deFh34vjwDx1Tu0jCLwPzAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(9,'1f609','winking face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAQlBMVEVHcEz/zUz/zU3/zEz/zEz/zEz/zEz/zEz/zEz/y0z/zEz/zEz/zE1mRQDxwEVzUAZ9WgugeByKZRHQojS4jSnisj0qdtdAAAAADHRSTlMAVx53aTu07dMIkonaj0OgAAACZklEQVRYw71Y65qrIAz0gqCVm4jv/6pHrbaACY1+7Jmfu+5smGRCQlVl0LGR972QUvQ9H1lXPUHD+MoQQ3DW3GMZai4R8Hqg0zAhMxAtjWposzRkqq6XBPS/hB9ekohXNqiml2T0mQR2Qt6AQI9Xy5uoYR4mb4MViQeJqZOPcNGpiXSeJ6eUmimKJ7kbgrxrb9QOQ6qCuJ5eAY06YWmVCQs02w+PW+7L9DnYEY6ZZk0v8e/h2vNn0/tIHvkTrfPVNJwZczvPBH69uD0F1vlLMsWQBLTHYxBlvtqtB08ia+OAdn0spo1RIWKqI6Q6+NSgGm//JiCLA387hQfBZzL+Vnrx00EXSsV3c3zktMTK8fbC1DzrHkeZLHEFADeYnswlMzHmxELb2a7tVe8qmJ9MgakF2IeOknF5oZTykeEYHLaC+tEyWWPctAB+YdWIKAl4xWO/WDECWlu4H+nAJNf659X1Svx+j5kN6Hk9QGRAoknFZrsQCdrRZpUgyYSoJE1su7fNZdVGL/Nmt/RwlaSl39kohNm6NCJgbnCUgky7JCA2ySKUrFFMCxBxWQQcsMgjjI/6Gni3dWWIOqixPYCAW+0TrasyIrHwOkrr21065Oywam8q/Gy7Tf3q082oq1M9ZNXwgsTGWa8A+NxwO8B50xAR7JtzrmnJIfn83I6EdLaTLxCpP4MWFpK2MQ82OzFgGE2Yopic/j1pY4YLhm5Mn2SLQBdH7bch1DivSQN7tELcQ7JCJEvNDds3f7VmlVv8yq2i5Zbjcut6uQeEck8a5R5Z9uz9fvZh//UhquDTWMHHugfPh/8AfbvEAFFarVMAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(10,'1f60a','smiling face with smiling eyes','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAWlBMVEVHcEz/zE3/wFX/zU3/zEz/zUv/zE3/zEz/zEz/zEz/zEz/zEz/zEz5x0n/zE3/eJJmRQB7UQ/ZqDz/hIj/sWSziSb/nnP/lnqHYhDquUGYcBnWamqkex/HmzC4EoR8AAAADnRSTlMA3gQeswlw7Vw7z4eS8JgO3N8AAAJdSURBVFjDvVjZtqsgDHWqKHaBYLFO/f/fvIjVKhJqNefuhw4QN0kwAwQBjCjPioSGhDES0qTI8ig4gThNNMMWJEnj31huWcIAJNntOE1KmAekOEYV+WkMVXrAWzllBxDm36y6s4O4e+2LKTsM6tnAnLAfQEDzMvYjMiQegOkEj5MpZ6ew81NMzhERa+9ulJ0E3b5Pd3YadwQH7dwU0StE9BPBKbuEdPE0uUZEbjgKLSpdVWhRaRcbUjWiLEWj5LHxOVKsPC+bckEjv4+bimCCYzumyg3Ut/EJ8c7VQ2lh8I+v3L1Y9nhWvDdC3atlrH115s9rnHvtx3tePR8r26L3nj0qrqGdWYrFAdL8HX+5xkf56k1FojnMas5nop7X8xPtmqidR2ujuJieqOeAy9Y8vBei/8yOa096zN+z7Fvuw5QFhbGLW3jAb59btph8XdmTFUzklk0C6lrEoxIgS4NQfz73k0+ICJANA+LS1mMbIEuCcZI7ABFBsnhEaKahORtt+9FeSLQQ2QbtJhABOGUzK42MmUT0tb9o1Dr27TVzK7FpNHYa3WFYktE6sW1TrU6f0pHb7eog5CS7TrX7Ojvl56F1sbTDJ4/byT92rjkWL2Vxtapx1qJ3OQoSiEmb0CnZjpWjlaoTQE2bC6SrnVWlBwpqbl1NhBQQjZBwX+Nsazo3T+frtNx9zbppgJoHq9GCOi1padXJL62fpxnVm2UUazolDzSjaO0xXsN+5QgR/c2hBu+YhXfwwzuK4h2O8Y7reBcIP11pRCiXLDT/f9c+eBdRiFdjiJd1J64P/wEtiukY9+gD+AAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(11,'1f60b','face savoring food','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAt1BMVEVMaXH/u1b/ykf/zEz/zEz8vVL/zEz/y0z8yUv/zEz/zEz/zEz/zE3/zEz/zEz/zEz/zEz/0lH/zEz/zEz/zEz/zEzmW27nWm/nW2/nWW//zEznWXDnWm/nWXD/y03nWW/4q1j/zE12Uwh7VwrnWnBmRQDUpjeJYxJvTQSjex5rSQK7kSvcrTvuvETpuEGvhSThsT2XbhmcdRvLnjLCli71mV3VZlj3plnKakvoXW+ybDTzk17dY2NgaB8KAAAAIXRSTlMAAwfRYB6w/vzvQOhu3rmJMwyTUsty/DhuvHXO7ZSApt4soc+qAAAC1klEQVR4AaTPhUEgURQEwfku64bb5B8kHC63/iqCbqxQrW28qVKMqTK+sa3CCa70iX8kXzocom0dOCvUVmOvriy4onjosIe6SdyQJoVN2XCHKmOd7gN3Cb3GCjdyt9GtbCUekDIWDJGHxAGzbOBBwWLGEHhYmGnKkSfEjD9c4inJ4Rc98qRR46eep/X4IQeeFjK+KEMBo/DphiITPnSJIqmTBM0k6YJChcYrSzGLVzXFavzjAsWCA1BS7qUVq0ByHAaCWnKUZWYSm8Kcu/+/6+yASh1DdLvuokyNqt1yPMjOM6KAIdKeEXEsTC/NLU9fQMhBG48aZWFS5utrH5BruGtPAXotH1+Oa/zzI7WDqM6HH8CVY41VjsGoQ2lnNFgZYw9fjit41zzzcnv5dGXW+eBtHyFR2GUW3RCICj7h5hJy4VhaCM1cm3MNv6vPXpA2awRnhDZDRJsjauxqF80QXZCjZoiOSNAMUUCumiG6gqDVgmvmCc2FhqC9xhDhvs1ofhbSyEEbg1Z7CoKgzRMbCTDlDP2IhpiQAkz+aeaNuz48nTg72ofkD+XI1EtCQWYC5QgKpFb4IARKV3NpmS7dkm0lib1xTEUuSErLdFxoIvqQ1esuFk9lhpnTRGBbs6o5ST1PojIs5Qozt9O6cSRRg/Whisc8yhUWM6fRIg/uH8uL1a9YQ/lfKS3TeXkz2g9XT+xUfEArxeFUWiy+D3bbY2CKe7RIQ3vxSs9UOng/qWrYu0LlCKM+XLDVj8KVQ0wl4KVqhGjRgVqDR4nu5kW6q5OIqzUGj3IHT9VDjRaqAmIuC/ioGbNowktplo+yiLfawa81GoYKEA6sGsT7vlGUpklkBI9VyM0wSVvsjxeRx3BcwfT2g3F9Ikvw4bFA8NL05LHS8NH05rFk8dH0aAUhDh7O/k/T888XUc+Pjp7n36zGnl5swD79cll38vz18vL1DDTNrA//AT2mIeNGt22HAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(12,'1f60e','smiling face with sunglasses','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAulBMVEVMaXH/zU3/zEz/zEz/zE3/wFX/y0z/y0z/zEz/zUr/zEz/zE3/zEz/zEz/zEz/zEv/zE3/zEz/zEz/zEz/zE3/zEwpLjMpLjN6azy7m0MoLTImLzP/zE1mRQBnXDrVqTv4xkuQe0DxwEiZcRm3l0SehUFGRDa8kSuFcz6GYQ9bVDlSTTiwhiVvTATmtUDcsUV4aTxrSQJ9WQvKpUbmuUqmfSAwNDQ4OjWtkEJ1UgePaRUpLzNwZDtMSTgs82UfAAAAHHRSTlMAHrDRcAT5/u8JY+lZh949y5K5M0NQstuuczg7+7VO3gAAAtpJREFUeF6t2GdzozAQBuClWXJvuZS7V3T3XlPv//+tAybHBAdpsKPn885qERbWLik4w0bbtDq8VuMdy2w3hg7dwLBNjgvctA26Sr01YCjFBq169TR2EwrNdrVUjs2hBm5X2K2uhQo6d6RW7zNUwvrK5zN6qKxnkNQdxxW49PF+1XCVWotKNRiuxBql9TBcjZXUdFfDDWrf9snguAk3qKDew416xfPSx836hXPBcDPWpZxj4Qes/AT/fpxu3fn4+b/xYu5ug1F88FHge/EoSCIXX0KTyOnjH8rcv0uN3WkwekmMRlN3LI+7p9TD+4895BVpSfS0+Gmev0+UGvgfyrB5ELjKANcfUMJgYIrA8wGJw1mxkA9mEJENYCMP+0BmK484ALCJyETiWRo2QuZFXjIDYBI5HAlXuZ6y5jkS3KEhUiPpej4yTFpzgNSQGkgdpG8En6RvNkaqQW2k/LNii9SbFCLVJhOZuSRsg09HScACGZMsZEaKMOVSATIWdZQLviAXK0vuEEcGbmlBDDk2V5XcpBogfW9nD19snuU/M9TyRJiWHbOc5MBtkSfieenBRdx8gwtH92KlqY/80TrIhfHUXYzH6Td7G8RHlDjGwTb9Zo/HC3cah8h1yIIWFpnQwqQ2tGhTA1o0aAgthuRwaMAd0rPbJhHZ0MDO/o5Q8DbbQA2b2RsKmEGJAQpmQpxCKIQnIWYoGFCqhYL1TojV0oeEv1wJsVujoEWpehMFE5FYndYosT6tRGKCgmadMjaKliIzm1zkWk9mIrMs2eqykthSfNpHE28d+n649ibRXojyPLxOVF4SJkJhggu24jLqvQqJV09yGZVcj8NIlIpCyfVYfmH3ZuKbmSe5sKtbCC/aiS9WkYfvek6Vpsb3ltF+tdut9tHS85VNTa6roc3S0PhpaEX1NMea2vWurgGCppGGo2XIYnWrjH2aUEPTdnQNovSPxvQP67SND/8BLq02TCuMQ4EAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(13,'1f60d','smiling face with heart-eyes','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAVFBMVEVHcEznWW//zEz+x07/zEz/zEzzj1//zEz3q1bve2bnWW//zEz/zEznWW/nW2//zEz/zE3nWnBmRQD6wU3veWatgyP4qFiSbBXImzDqZ2x2UwfbrDpo2ONeAAAAEHRSTlMAiDmw1Wr+7QkkXItYrNO50Zh36wAAAqRJREFUWMPNWFuCpCAMRJGHz9ZG1Nb733O1xVEhEpzxY+sTQ5FUIBEIgZBmURllacxymiSirkWS0JzFZpiEIi2bFa2qD1CtGS4DqbJmR7fzdIfhLIQnao7gGw8/DUcBcTVndK4/Cy6jm3WMokwSUlkz2pWotYYrQuR3ypkx26ZHtGkglzpnmG4SVLtgsmw84K5CFkppiLw8a2yt16SE0uTgsxB9/DYRlCYHCxFmk+IOhREtLlXN30P77gZssQCxZ0hcojCiFCfC95FRGzO52NkW0O24Jq1WiFFplZ8riVCRvuetwiPDYqsIvrVNtVXoxp53Escj88fG1+Nf+Ix+yr/yLVZ8iV6e5dq9+PtsXl+JfFaHfqR8ay0iMU9W+LGvcY8Jm4moyS9wwD/nBglZmN1BZyJxvWJXn9BdeywIiYGeDAUGLHXs6LGRaKPicMagzPFT3IzkZ1PVteAfhOVz21lf803rkxa8/XwgnoVp/sI79xslSf0IkueIxDNEgtQP4Tmix0L7/7JGnyGi9hH5LfLzoV2PQf8eez1M0FmbBt2P7979xI5lxKB/G4x9r/VgoHU/Uxj0zqSYuPl/4xjd7BNX7QCit6s1cUX6jUdsa0egRtdwNEpNgzxhwIkGa8rLtGwrxziRnf61ZUs7bxrj0XbOzB3ClluNiNQKkBp0abin0OYQsAP0ncB+HJqR3GDSbgXZ4R44HcyzHLMdbjGZQMXHCSggR0i3UCrAKe3Wj0Ral2OgCdhUAE0tnOt2DBa+Sa9FaK50E2gQuxf24rKMKnX5qYCu/sX9Ss3gR4TbTMXVc0R8q+2K2PMwcqNdJt7HHxnc5nKJvNbEQU4lccADEkOVEizsSUv6qQSTwa9ssnhd0byKcJo1gYw6fgnKUvIb2M+HPtt/Z+UX34JiZ1IAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(14,'1f618','face blowing a kiss','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAVFBMVEVHcEz/zEz/zEz7tlT/zEz+yEz/zEz/zEz/zE3+yUz/zEz/zEzoWW/oXG7/zE1mRQDnWnCIYxBwTQPPoTSbdBp4VAjsukL2wUngsD2ziCX2n1vueWYh9hg3AAAADnRSTlMAz1sfswk77m/8jOBY0Cx4CakAAALKSURBVFjDvVjXkqMwECSL4BVWABH+/z8Pk6wwSpTr+mlrl+3qSS1pksSBKmuLtENNg7q0aLMqeYK8LhDWgIo6j2MpswJbUGRlOE3dYQdQG0hVI+wBqgNoqhQHoPMlvmxxINzx5SkORuooYIVwBJA1vKzBUWgyS7W+n0wzH+jAvFRg9bLrr2Im/Y7BLwrQVF1xzbTvg4kaI0/5meeJ9DcPC8m4VrvyrDs75FDOpsDMp2o/HX3YzAfNLCJq1yoJOn7Hdx4u4rpATtMR2K6HWjMjpmkagYBTvYPYnuHJQsOGswR8Hm3dVB4V+3xJR5ueof+CqKpRqbb09imdcAjRRjUCkk5Bm3hX57CBEkKGu1uZKSmLGtTpGqDZmJQCR+Lsfomp2IfD/HLklPLRQXUMgBRdrrrHxbN/RkdXgFQd6hqM7EwCcYZHFaJPbIa9MqgwQBXlGqN7zCTwi4hHDVxtbz3D2LbSU0rmCbRK8yC7e45qGZ5vqQIwkyKUSBDbhBzZTgNDk3k2JmF4SReYbK4MrVGIzqw+XH7Wa9B6AyWm5TVQQ5KPpbFJfIyS8cFo1wYgAkeEqGbGiEEE3Ru8Qwucb0mHf4IuSX9DlMbbmuWym7RP/q1Z1nVZ1BHJHvAs7x2rkIe2esyzQcjnNoqO6+Z5r5KxBWSbbCfazIQpaJPULIs4rbb2E6kH9SoRHT8vu/nn/mDEeSoeNiQTXXx5+AE58mv+3gBeMUc2P20IInp/Tv8ycNzE6b5vq6Q6jmi1EpUoKjQ7UZCkb7IXiCiXL6OB5RcAz596PXY3JL/MdrUKStxmonU2ENvLeEKEhCZPrc7zfdQEJFuX9JfDzyxv+VVJfy/rw8/XkLIkkyagmySinWlz7frR45jrdwfb49j9XJeT7XuuWxcIWvn9CwTLSoNAbyLvygZYsmjmv8up/t/a54eLqN+txn64rHuwPvwHaKvqDlC+7lAAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(15,'1f617','kissing face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAANlBMVEVHcEz/zEz/zUz/zE3/zEz/y0z/zEz/zEz/zEz/zEz/zEz/zE1mRQB1UQfuvUONZxKheR3SpDYYe8NVAAAAC3RSTlMAjB6wPPlZ623QuLJ7SpIAAAHZSURBVFjDvVjZcoUgDFUEQozr//9sb+1V22uABJiexzieIfvSdQnY0A8I4BwADn2wXQlMGIE+AEMwSho/UgSjV9AEoASgb0JzUAUBjUUSALOG70mItH4GSQxMONACKQBR9bwjFVwkEgKpwXrPUwGYN1lXQuQedjJARYBP3yEVAgvjMBOZlipgWyj2oVygKtzRBHVE0OhB95OglggqcoPLlLGeaDySg/uybPO8LTLpN0zE1Ms8vTAvEullbk6zdTqwSqQHBt5n+/TGnpdefuPSbDt/2fLSK+E4E83nL3NeegUAV0CmC3npVUyG1IumvPSyNrZRDdlE0xvbAUukd//L/2wXUgckOZ5InSIvIr4YaZOWoL6qnUTYhgjZgCzAUNNj/6ZIaEPk67r1n74NbZzWCay9TvO67Uva1pI+e6bGnu61RvDyfTvI1uirjLxBLms0z94NUtyyt0jdv4dbod+WSHG855pQSxR0g1ZUNVCNfgljB/EwuiTdj+LxOBOQVjywp4l6zQqRUA21S03E2I+lRrBmce53tmDx4wLSl6yQDFEoWo4fqjlfsq4/jQ1WfUBgIxuN+qTBBmRfcGRhij/a/zv7NDxENTyN/RzrhhbHurfh/e/zoU8a+AsSybEf+wag6QAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(16,'1f619','kissing face with smiling eyes','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAOVBMVEVHcEz/zEz/zUz/zUz/zEz/zEz/zEz/zEz/zEz/zkz/zEz/zE1mRQCUbRbvvUR5VQlyTwW2iyfUpTZtYsaXAAAAC3RSTlMAjFcePLPP7msI4JAK65sAAAHySURBVFjDrVjZloMgDK0KBE1Z9P8/dkY7dUQDhOW+TE/O9DbcQLbXKwGhB6kWQIRFyUGLVw0mLX8ZQoDUUxnLPEqMQI4zn0YvmAAMTCoNmAFoBo1QyMCSE34ekIn0+SaFbKhEAAVgASB6vBELMUaihcXQXfyJ+CSwCg+dJqgjglvsZoWVUOF9GrAaQweBnjKpFiLVdIPI2zRDGxHMfRw6XWp16HRpxGZ8XopsJ5LH48AOmHpI/ZVb9iDazwY9iCD6zFbjvVnztv8HR0pk3fuAs2nbVSQqgVj//oO3KVuQTCit3fuES9kCtYkMsu7/baw1+981bgtzybPxsMd39k/Ht2zMFjYDRPTXfx3c9+cp2y3+Ty99eCAfs4V4kVL7C6mL2W4ePY+2ObfdP1O2G9GCXbC0FZBr+GUfItlSY8MnovsQ6bZqHdTtXomNobbxzqybzaXavEjmkz3Mlk7+jHJkt9V80kiqHDFv0pGJvE0USHbJNt+UFCvZM/O5WTp/XPoa3Uqkyxqt6NHORovlUkJszW5G0+FX7PY4cyEFu2FPEw0FI0TqaLcRIj/URMSGqXzMIsMvKgY/6kKONaMoQaSrhuPn0caacf0pNojiBQIZfjUVrzTIC5ld2RBLFiL5K8HZHvVZ+3RcRPVbjXVc1lWsD38Av62yS31Fy/cAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(17,'1f61a','kissing face with closed eyes','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAVFBMVEVHcEz/zEz/zU3/zEz/zEz/zEz/zE3/zEz/zEz/zkz/zEz/zEz/zE3/eJJmRQB8Vgzwv0WRaBdvTAX/sWP+mXX/hIi9kivTpTakfB/jsz7LZmDtcoFzYVUHAAAADHRSTlMAjB6wO89w7lwI3rmvkxgVAAACv0lEQVRYw71Y25KrIBCMFwQNKqAiyf7/fx5FQVBANNbpl62FscNcGeb1CiBHSQYqiDGsQJag/HUHaZFNDDZgVqTXWEr0xh68URlPU0AcAEwiqcI0kqqIoMkBjkB1ZvgywZEI65cCHA0QcGAO8QVAr3oIXwR6iMfDdIPHyZTjWzjYKYX3iODOdyXANwHseErwbSQPGOhoJvALETDyHf8EXQtK+BsRLD0H+nDasnZ0fTNOG5R/3EfaHYi3jUTrIlJ73HUkKzc4a5pzoqZh/JgpRp3/aMHGp9omYCj4lslxOA47WsG2IDscKrVMLdZ9cuYmsv6isMyd2TyCxHicCJspm4igycPG2OAZmckEtzTjewOeYXEM1wmHDMcyciWgCTOCBOkC0l7Ra9Ou1cUk0xGiI4fMKTKnAtk7a7dufJMZFaTrh7oe+k4wd/ga60LJGrWkUjTTzoy/LXZnE+hDEXv9b5EeFFWlvN/XKw9rGheTzTMdamWqe+V/m6eebU6//fQ5+XAx/UcXATpxCv6Z1/vvnCNtbTMtRJ1arWn7nf902pyKSJtVyn5bqj/plhNJ1YZ6h8HvdLcslMbu6gM6H49HtpLu74+bvY/IIwtkQA7HzSFas0U2kylSO+Aj8sgmMmkfIEKyjJyqRqcMEyMJqJbLwnZqbLqEMx19snAptefuJyOXZJS4ZbO1+EcFJKGy9jlli/U66uLicS7rwimbqguyjwpHMh/JJfveruw+JqwXIocsMpqITus+ePNMrBfQXlb1NYVdar23Bt0uGlu2iG+0NveHGq3z1s8IyFDrd96MBonAlfY4pFp+tWE3je1r2COfEMLqiZxPiLhHzRqQoUdN3CvCQZTfevgdVbv1hHQY+/qj1u1+dPm57gxImF8fIBjFP2qA8NxII3rIAvL/N/aRg6jqkUHUc6OxB4d1N8aH/wAHcMwKMLUQ9QAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(18,'263a','smiling face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAS1BMVEVHcEz/zEz/zU3/zEz/zEz/zEz/zEz/zEz/zEz/zEz/zE3/eJJmRQDWqDh2Uwf/sWT/hIj/mXbvvkSZchm1iyeFYA92Sw/JnDHPdVnlMERmAAAACnRSTlMA4x4z0LOMa0vucsojiAAAAn1JREFUWMO1WMmWgyAQjAoiGIwi6Pz/l44DGtlaUZk65AD9KvRWNrxeB6hIjVFBGaMFwjWpXndQErwwuKCYlBdpGswA4OYCDSnYAYo6lYayE1CS4hRiCUCnDtYsEcf+lYglAx0ksKHsAijoXsMuAmAi7DJIlvMAZ7rFE2Eq6T0i6ucOsZtAN+vwpDIb9gBNDsc85wh7hL2aIhkT/A/iZGnNHHAgMY/de0XHt1W+r42ziB/J0UM+vm1023rnLI/c0cwwZcKlAYkWKhEkztJ56/xqHEfV2a6tS6HXyxdBN4fFY0yU5EdJ4lIZO8uqdEOt/03x84Rz5bhtwo1dIplWO9Ilwm4RLXGYU6uQd3aQllKqWBZUT9tjD1Kdh6h+QdMCn6WU895aYl2AZou4glh9YkK6V6rXHbuWFFCVOE3iNEis0gor+5+hb9t++PBIt3mdxjdbK/9fmmXHYFrFQsq920ynLSuGcdps+y/VRjS0rU00Cig9Wh+m3XrYTkR9nvZnmn6OMv233/pM1AT703r4wDxx28Kkv/c3e5gobot0QQZ/cnAkwBbrFhnCzQEiAmxr3bR9uNkne2ZsiZaRNgKICLCttLA9J6JGap+7ho34Pw82MZ+j5+kvX4BvFwsSb5/sWNmrUHa4UnHb5jtEDGGEOi0lXIhFCJYfriWkYzHbwhprhiDS8h2BZDFbYg9au7CtYiViRMITQW1LvdHPl08JHCiwJWfDqPJ51OmkHR+PhSf5nTi/RcS/t8I5kxIpV0kETy9+fA6vEOClRpjyGaVIvNTcHW+a/7v45buK5rscL3HKdF3P94CQ70kj4yNLvmefjA9RmirP01jGx7rrz4e/vP+rK+m0q2cAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(19,'1f642','slightly smiling face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAOVBMVEVHcEz/zEz/zEz/zEz/zEz/zEz/zEz/zEz/zEz/zU3/zEz/zE1mRQBvTQTtvEOZchl/WwzQojSxhiXB/N9bAAAAC3RSTlMAjrDgSyXP7mwHuVLZKR0AAAHfSURBVFjDvVjbkoMgDEUUAk0B8f8/dqG13XEJCpjZ8+BDZjyTCxySCHECZSapZ0CEWcvJKDECZWRiOAJkL5ldHljBY7HtNGbGE4CxjTSAF2iiWjQ2YF6u3JmwEdOpU0pjM/RJARfADkA1vAU7UWEy2A3D4k/FpyEegknBGBH8qZ3VOAh9PE8TDmNiSFCRpvHA/gRn8Ba+p8nCPSKwVYd8cC54bLWbmkPePROcb7XvLpUOrc8X1lb7XrhC5+NzR2yzpxfhdTkK/vD5IbTZE9RZZEUMNfuebllY3ecH12ZPkIkIOIiAStFIaClJxPUYSHZKEiEg/eXPYiIR7x/InG1KQXqvSNYSQTYenZc2NwPipoT81h+ZwEUEfKHNPESz0DxEmjyQA5B33tjjFTE8RIaSkREowVN/IKV2KNf0wx9WX/vFr6Hy/CtSkNxGUvnNkXKkyAcSccuyEwohjCEL0kaMTNUu662FLmzR++Ra+sQtuKo+vp9sO5/IdolY72uodMcOnm+nRTZa0VE0Lp41WvQ18WvJQ58Kc9WMxnCkCfGy0661x7lWa4rRrbl+LVMEV8PON0KwDTV8Yxbf4Mc3ivINx3zjOt8CgW+l0bxk0cv/rX34FlGMqzHGZd3uV8/68AcFjrJ9rbe8kQAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(20,'1f917','hugging face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAvVBMVEVMaXH0jwv0jwz0jwv7tzX0kAz0kAv/ykv5mxr3oyL0kAr3oSH0kAv0kAv0jwr/zEz/u0D/zEz/yUn0kAv/y0z/zEzzkAv0kAv/zE31kAz0kAv1kA3/zEz/zE3/zEz/zE3/zEu5UwXDXgbqiA3ifQnQawj1lRDZdAjMZwf/zE15VgnvvUS2jCj0kAxmRQCmfiCIYxH4xkmYcRluTATktD/1kg7Vpzj7szLDly7OoTT3nhv+x0f5qSf9vj72lxTBwQ5IAAAAIXRSTlMA7+V17vfY/gsWXSLKhi/TA6iAo1ONQrXJOJFO3zNy7mCo2dDDAAAEMElEQVR4AaTUhY6uMBAF4Ea7XEMCyQrQjecUgrRde/8Xu/l9kMH6xSunQJkRS4I0iZ9zJaXKn+MkDcQhRRZiJMwKsdNTGWJWWD6J7YJEgaWSza/4rrBIlZHY4PczVj3/FqtShQ1UKpZFGTbKlnNibBZH/jmrSTTHJykD4fGdUuyWihm/FXZTv8XUMw54nqkLHPI+qVMFyrXaavMjsTaqxs0gAVU3F121OpqM+o8C0TY3uuJGmUcqQXw3D51kRu9KQdF+6GxD1MzoXSiIAoQ5HWnaum7NaXPFjN4VXHFoXd+Wyc+u+WFG7zLmzVD1IJxkR6fvFsBL4FGuTOkm8JKQhuYl9ih8pgXk8JKLGwUvStxIeJFsUGd6sHrTTYOYV9ON/gTjUzeafbV8vLhpGlNhRn9qSuNDcv76T6Vu634SU9vTEfz1x5MdujlFtQ6Ea+1pVE/yY65ESBvT7ber+r5y361uzqxbKJEUbBLF5CBdbCNONzP0TM7/QsxDq3UYCKJSiiNXSui994HXfJzm/P9nPWs1R8iIcumsNJqdFQkwSZVnY7nAKqx1N+v5V6zz69nVPCsslhvhQ20DdN96JE1dN90OOyOPzHHCGumOB5rd8MG/Rce6pZ8aqO3nz25OlHmzN6u1NXpq1+hoT73McGg2mhpuN4WwkNW/52+/nv7+ffr1Nv8tpQW8UCtbmg0zzKgDJNuP7R06GnYOSGYRQaVBx137uJ0AQxGaAtCjx+VaFtnTliLaxjqtbF5aayK5Xj6ONICpCFVavIhtRt7Iqkk06LWsZMzSvqzUlRLyhF7otttx92lzK6lPGDNW9JXk7jbuGbNPLy7yhpaYmMd/k8voa9+YvbTTGSCpNkuO3x8lHzlF0tZseNVbXG5WCQapymyPxyob8xAG1YBhetww0HAF7Y8zdWwzPraOYOd3OAjbvroGGCdxo0B9fSvr6GtwqIbyMWXUmJq0kJ1y4O0VyCoIWri+vPHLUKRm+h63i7rI3fckiMt7EDCmFoSH1OHp+0Y5xJ3ek4+Wm0t4Fo+CGKAlto1SVQMXt6hkZSpRS25jWO7lUNLSkEd6A8bHfltaZp0OMKgofVQ5odsHvLPyCZGreydUlYDfnKkjihZShPAQCi3CzkRI5sbFBds5UjnbdFEjdrS2QuvYkTA1m85XNzYfvEQdZ1RboRqecKRDGbn46vBXwSuFU8OdFboD4UWijr+E/fEXwWC+bu3+/ZRiTzs9z7FGj4ereGph1iH6WAVUYrF/6cjI/ttn5BO7cSVPUqke6T5Cbr0lbSRH/bkhxhyyeYQQn1KphDKag3C0qWKyMWISDsQkbDpsbCwxxxwOIp3xoS/GxwxYjMmLjzp7yrP3UanI1ZeYflDJYc9w0o/HqO8IbqUuPyw1pQ7uovqJqtwfaJ1MMxPXTDZNtB7sl1VU+g9Bjn+MezL6bQAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(21,'1f929','⊛ star-struck','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAulBMVEVMaXH/zEz8vUfpXyf+xkr/zE3/zEz/y0z4s0P/zEz/y0zpYCj/zEz/zE3pXyb/zEzpXyf/zE3/zEz/zE3pXyfsfTP/zEzoXifpXijpXyfoXyj/zE1mRQD///9sSwRzVBPntkC6jyp8WAuqgSKTbRbKnTLe18js6OClkmm1pYSReUj49vPFuJ5/ZCrVpjeJYxHPxa+kex74p0DpXyjyiDbtcy/rZyv0ljr/zE32nj3qYin7tUX+xEr4wEcttJneAAAAHHRSTlMAOBz2YHCw/Qfv6n6H3kzSps25UWsRkSzK4cz32njP/wAAA9lJREFUeF6MlOuaqjAMRasFCoLIcfDTmXmL3svl/V/rAMUMYiPsX4WdrqZJgLzqXh4XT4eoSC7n7Pc3O1+SIjosrGN5Jx9UC0HLOTJOMrtSlsTzOSUVosY56WCL73RYRFdmg2LXaPS/h0CaoqC7GJWn8cl+0Km45VMgfrly8ilgUBSdQCUK8gcJuQWSPi5HQZUHNf1nTt94UIWCfoSX3JWQ+EFBVMxqoUlt5xddC21sxSyKcSLxlBovwI1Uw9qMADO+lIaPl1YQFiEcLkBSaVj3AxQMraQA8SDpizkRVAu3Wcuxr1A+RgU5mlnb6aClzEtOt7KuHlQg0lPhW4359FHV5W3ApBUYGAdIuKqU5JucXaScVFucfaSK1JscIDUCV01Ijta5Ac4WieZT13IkaWdXckji+Y1MijsXRKk1SAUxpos9Jz1Zy3goiL9yeAjjmLWn1M80mrdmSw7T6O39fF/x88wSZPCcryPnyPBKNp0FdRrvBzuOpYb/XkDSe5v+WO4Eacnq9903nxqbDKBsXmvY7GTznpL8g0sHvp7djJDDswTLAnYGsHNK/WJslo15FvHwbL5tXxsBqBZswFgggW0jUsC0rYaQTeOu2Pyk5ulDwguotXn/vhiXPgGfouTs/bszUO0LFBM4++RemvGPnOH9bk5oxxm6z6TW/H8r5tviKAyE8YnYqsuW4pXrm02TaPxftbvHsvgm3/9rnVw47SRVU+jvjYTMPMwozCMzPMWfn5/J3N/gY3gJH68Til4j9AaH1wgd4DhggsAhzY6KYY8DJKM8k7lYlAtELjNOmcQRe3hH54T+J81kkvdCCKWGQSkhRJ8nMkungAQlvoOPzil1JkWJPhB0ZtQZhhIJQGQK1W3VrQiyrmprUyjSoxa3xsvL5VIWbV01Tcc5H0XZ+Oiapqrb4t8lN1vb6+E/k9GRrrysUnZ0JLvP22k7Mr8aL9Z0Cm59tcDTBjkjqKa6Lslca6ZD1DDzS1s27k3D24dS11aXY3TmTz8RqCQNr6wGi4pP12LO0T8R5uv+ojO8qT+LciztWhafdcPpzJfxqu2SVEodSJVZkF2SYHQTJsyCNCGaJTndpL+PP4YwQYKnlHI0VwjccR7u6Ve7Yz0KPsM9YYwuxY0uchN4NIaA8LAJBMlCUSzBkzHywIAYvqTkAykmleFCJ7A4mWNaJUaDt0SZHqB1DHzbP1Qus5SNpJnMlW0EPjzk5Oy6uC8b8pTtRgQW8WJ3ndiDFcJz4CYTnENYhxxddI4ENgl322ufnS5nW+qwsYgCNzZXY45sLOvcwevDWK8PY7w+tPkLsKQVClfalkcAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(22,'1f914','thinking face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAVFBMVEVHcEz8vT39vUL0kAv/zEz/y0v+xUf/zEz/zEz/zEz/y0v0kAv0kAv/zE30kAxmRQD8wkJxTgT6qiirgSKFYQ/3mRWXcBjsu0Laqzm8kCrDly7LnjKrQggOAAAADXRSTlMAFA2Wyakpge5Y2d9Ys825vgAAAplJREFUWMOtmOmWgyAMhYsbbiAIitr3f8/R6hRkEdDeX3Ps+J3cEEPg9boQqGCe1SVCZZ3lsAKvWypgjTTVsIilJCbln5VEYAAskVMlDLZYXWB2VFhuMuRVVjwP5wiq8nEgCpTHXr7/l1gYp7SjfGSTi5T7OQvvFFFGokk7Z+408diYjvywTxwjm5eZjXT7OzJP1fEzGbmSmWnkb2fGrWtXlChapa2eMnRDmdtYpAxzQDcmRkrZ6cnERr7WFuVsEdJc4qlosS1XN8oHMz1VxNuxcoke0Li/IFeP6sUlrCEZn9jxHjuR+ecp5aefziHp/VAYRU3eb3LU/Cw2n//m6lMNIS9oE5cPJ2m6uGwenW5N8UvdH4rZ6Y1ku0FKUQKz0PblPwekWlMFLqvaLMhvg5md1R3cX7m1PUG9wfpFGLU0zPzZh2/Ldv0MJEuyfAYqvyD0UL8H/czaz5KtLz8h5N7yawVJMMY92Tdv7pkAzgWpfSL9CsLDRlQnABEwmFQWEO71Rj0K75YETGurVnOCMTYztvfqji52EHA2NvwNSe5ptv5k7rZakgYDtAXnmkugu/nvIKy9MFF1w0TW5q95s4MQEdflaHg7ko3DqhK6t+we2yOy1rw+RUAzoEGH9IO5Bsb4J8cacmRIfYMcEDNQY6yRE+SgBUR6BWKkrnKNfl/O5/9XCNY1eEa/fRiVHKwH8s8hvmH0Y876LlbgxD8ebyvXR0CuDja5CzJYW6b7MJI6o4k81DQ4gnR1zHInaIg6+AEcHNH1UfQCROIOx4Ec/8m4CUlRGXAXkfpzFHal0XpAWeglS+IExV77uLy10bc99nSn8bdP7Y8icpm7AbKSmlu3a62Rp6Z43RJQg2rStH3dVtKmzaqVER7LH4T0uGlBfZgjAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(23,'1f928','⊛ face with raised eyebrow','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAP1BMVEVHcEz/zEz/zEz/zU3/zkz/zEz/zEz/zEz/zEz/zEz0wkb/zE1mRQDVpzeIYhCcdRt2UwfwvkS9kSuyhyXFmC//6Hl/AAAAC3RSTlMAcIweCDuz7dNc9IMwDjkAAAIiSURBVFjDtVjZsqwgDBRRlkI29f+/9c7gckcMEJTTT1NO0ZWlE0K6LoNR9kwIrhQXgvVy7J6AEvZhuIIzQutYBslUAkwOeBrCVQa8R1LlaQIVQdCMQiEgSoEfeoVE3j8qFBoik8CxEB2/WmtXf0Qq6Z4s0Nhpg9H7F/mIZ53+46CSD3jsdIHxKaYx75aZYqzhj1ucKMfY45Z1OSltiHiUu6GQ9/1o8EcfVCao4Kqnkg7D2SNZSrsfph4foO2o03clmDhMCEF7UAxfcvFT76oeOhDN359nLxi4esoU7OQDaJDX6/LBqotM9hA4uRukrftR7+Jxxu0mydhxoKgK2CqFJQvq1G8JLBRHHEBjl3lZ7KFflE00DrWe9U8bM2gicvXsnhhzdc1b56xP+AaKSM8zYIkPKXUAE4fLbOs+xoOlu1dYhBFsjIkDpzg0JACggczHgTnRbQFJ9FCszx4YmXSK3kHRFql2+AXue2iU7Yh4G9d4p9oEW3WqTfoVKOxNkLZGkDzR92tLBM5abiBJFO2HiKkmYF3fhqgvTTNYyPJtjcOYaGy14IVWWxHrZxc/2PxpCyLagb5pN2XgNHxBAgLI8kBdRCammlqiY64hb10jrwatu0GvFUCqhtHMe6tmPC6UGX5gzzaQmidExrGh6lGTzhite2bhAoR6+OXG2fdMzx61aJ7ycz2K8/j3C4R2K412S5aGa5+Gi6h2q7GGy7oH68N/eZ6zTLlzX4EAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(24,'1f610','neutral face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAM1BMVEVHcEz/zUz/zEz/zEz/zEz/zEz/zEz/zEz/zEz/zU3/zEz/zE1mRQB5VQntvEOcdBrRpDVDaTALAAAAC3RSTlMAHeKHPtCzZ+4Hkue+b1IAAAGKSURBVFjDtVjbsoMgDFSuwUj1/7/20FadaY0U4p59NLiTDQSSDEMFLtrgDTGT8cFGN2gwxlAYPkEhjn0sKQa+QIipg8ZwBWRTIw3xD1CLV85zA/yvwKeJGzFVnRo9N8NXNtARd4Au5TnuRJR5IjOCKTlmCJOKR4jTSKxj+tq75FkJ/3meJlZjuh+gDQ4h7Etc5Fs4zkCie0SUMA4dLiVzl8gkjEO7S+E+UXglBwMwYpS9tQnKHkvOy0P64cry1HY+RI88F2Rh/aWFxDR7rS7reyxOCNE6b1jbLSVI9vRt2Zcv7Ra2Qqzzvjy3W0q0zzfIfKDdwn4wGCIj7L5KGg2MCTYLRKrtJ0Ga6kCSEGxNipRge0Ykbdn+wBAEIUVUsJh77Zm0DkPkpItN80ZiHpH3VQu7/GHPkaBtzXMFeZUfSEFblUdKtXhRRPQSbUXE2aVeaRFdaMFKP1wxCiuPcQU7roWANTXqMDlQwxb/sRUFNse4dh03QMCNNHBDFuDYBzeIAo7GgMM6xfjwD6ESsUxDYffmAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(25,'1f611','expressionless face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABIBAMAAACnw650AAAALVBMVEVHcEz/zEz/zEz/zUz/zEz/zEz/zEz/zEz/zEz/zEzwvkT/zE1mRQB3UwjTpTYixh5EAAAAC3RSTlMA62gK+kbQsyeM4yRrSSYAAAGDSURBVEjHnZa9SgNBFIVHgz+lJGqQbSIWEWwSC8EygjbbKIi1IlZpjJ3YhLSWFhZ5ipVFDecVzBsE38B3cNbddWezM3OPnm6Wj9k791+pkkbPV+u9zftd5dZoAMRACDRdWK2NQvFdx8pso6QtGzXHIK5XmQtUdDPPHMKipzKz2rdBr8MSdAarNkxmKbRD8akB7cGhF/kireKqcyeD49+nBW4oyh94AI+uM2jsgyaZ2fAqNX3ZD136nWS4qhb4oSjJq0UIammoK0EN2aTUqAcJetMxCSUIQ9nuxPIVGbpVCzK0ph5l6F32QOKDsQxNZDcljsqq8usj1WfloGtUZTkwy75PKwegx0CRCuXfxUoOnYYCGYo4qC9DJ5wzqbBQAaZShUo6Kn2pQiBKqmMUZx7WcnR/irPwwawMTc0y70pQw2w9rt+12CZGtUOusVItmmr23NigBhA1yrih6HbV0V8HNTXyueWBWkO4haayPgH1/y5ZSrVDcV3T2h/kTHPHtx9aV8hvKGzE69dxSgkAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:08','2017-08-19 09:31:08',NULL),(26,'1f636','face without mouth','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAOVBMVEVHcEz/zE3/zEz/zUz/zEz/zEz/zEz/zEz/zEz/zEz/zEz1w0f/zE1mRQBwTgSAXAztvEOcdBrRojXWKc1vAAAADHRSTlMA3owePLNZ/O1tz/NT9fWqAAABnUlEQVRYw71Y23aEIAz0QkjgRFf3/z+2nF2tWwXLZdp58SE4JxkgJOm6Gxg3kO+FWXpPgzNdDUZHom/w/hFyYyGNpe3vM5hsAY3r9QYy5NKI3iJI5jJojNcM9L8KP7Bmge/jG71mw99soBEtgCTDs6xF4MRJcIU8gckh/En5ZCp4AtNFp1G0CnLeO6+V8KdzqNUY2gWKyOS1AR/BOW3CcZqkjUhADh0u9a1Em0tWm/G+KdRORK/Lwe1EPCKk3uWORLas87wusR9SFooeomWeAubI+qQl7Ju5Ln9MLzxKLCYi0XPa8My3hANwTSDrvnzNt4RkQin/IxGkLUHtawaZvpFvCbnketHmffWcb9E+svtVoUnHELGZI0RV28+x7FhxIFliWa3iigSxvSIubdh+Ugio5Y39eUUchsjG0kgNTPPreDxIhNEamPxhzxHsgcQ92bAiAlfWwAotXOkHK0Zx5TGsYK8Pjv1fNTWwNgvX+OFaUVxzjGvXcQME3Egje8jiDWDsE9Rx/zuIAo7GTsO6w5fyYd0mvP0cH9pbgb8A0ES+r6jeK9MAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(27,'1f644','face with rolling eyes','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAASFBMVEVHcEz/zEz/zEz/zEz/zEz/zkz/zEz/zEz/zEz/zEz/zU3/zE31+PpmRQD479X29u/74Jf+0VxwTwrLwKaKcj+qm3jTpTaKcDcpJSTtAAAAC3RSTlMAs3CMXAg7/O3THuOpDO8AAAIoSURBVFjDvVjreoMgDBVFCYYharu9/5vO2qoEARXZzj+/Qw+5lEBSFBE0vGJSghAgJat4U6SgLRmgA2Ble02l5kygF4Lx+rxMCRgBVCelJhmBUUB5QqaReALyKPB1JfAURNy/VuJpyEgCGzivgwKC7nGBlyB4Hp2Q0nUdv1KToDMp7eLUAiYBnNzVEhMh6f+pwmRUwQD1ZvwZhp/R9O5vvAwJk7QXd8+vGc/OODJ+Rlrn3Vqt1fj1wah0f4ZZa0G9ZazvlHosyx9Kdf0xg1DvDdJKqWFZPkwf+phZTbIMMspdrswR8zq+b5M4cYw6sLgQZma8TwqjBtkhXTcOMzPYfDgEidCEJcnvLx1n3s61+1DPOz+G4TGqvZCH2cK9eYad8qCLM5tvkEMIpmOGe9cIdJz5oLGSf0uIkwJifMtNnFmLCbPPtycU9h/Sx6zRJqXRBLc1cYOmWkKEeh2KQ5hZhGjRd12gZSTo2Cv/zi1Ed3YKW4CZD0mxu87MurVTaiPMS2h/n/VG667T2lf8Q4yAQmIWyHxCLI8Qu3PH0vuW5xHipIzcQFMUkEMHaKm9E2tS/NNR0usoGfN1lMM35lzZN5LvPCIsfK8vBhvDtzdn9e5Zs8GrMymFQh006YLQ+tDymnTBtdL7GE2pIHf7B18XkevBnt5CCKeFyNbU5Guz8jV+SUr8b5vji+06QvP3A4R8I418Q5bP2OcoOuX/DqLyjcYyDusSxoe/vb62M2bLiPAAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(28,'1f60f','smirking face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAARVBMVEVHcEz/zEz/zEz/u1X/zEz/zEz/zEz/zEz/zEz/zkz/zU3/zE3/zE1mRQB3UwjuvUO9kiuddRttSwPRpDVxTgWAXQ3erjvTfVxbAAAADHRSTlMAWowDzzuz7W4IHt6FDJ9OAAACO0lEQVRYw61YWZaEIAwERXBB2ZT7H3Uc27YBAVFTnxHrhZAiIQilUTe4omRgnLOB0Ao3NXqAvqUrgw9G2/4eS4cpT4DirpymZTwDVpVR1XmajaotiFZDeAFIc7Wrihciv7+e8GKQzAE2jN8AS24P85vAcZ6W30YL4k/Cp4Y/wilOPXtGxIKz6wh/COLnU8UfowII0ClMNXlDROo3GRTNpo69I2JdwiEh1aInE/vHTHpRUsRdChySy7hhihFNn2+LjLnkaUPO43hNNI6zPCvFueftMh48ia0dCxbrVIRNHI47eluilbTp0Fqp9mWOU70XarV/F1fHJD4B0MoLN/V5lCg5cbEvdvZWM5dHm9LkMdr1idWHzMwWYVuehnaLuzkE1zoHO4s7CS1mJ0nwcYGsRNrek4bVP6LqiLWZnMwRRv7DhB4Gducfisj5bPc8CdIyZd/vEjQEFme1J5SUfceAfMWaeRxjP6TsP92iqChnpb7izNt/iBBNm0b2nei83fEo2No0SVcwXxGk7A7RkEu3SIom7AMiaV1qHVNw3E4Q5SCgb2qsX28xDBF+V63dul0zCJ71YoOJNn1f+H+Xf3/nB7moqL0PCuQlzVoXUzsrb2fNVoZlurkt62r23mLJ9TXX4bZyv5C0yHVaSZeEsOttvzZLRw9is41W3KVlPCFRztt8MxoQrZ2auWxGwdpjuIYd7gkB9qiBe2bBPfzgnqJwj2O45zrcAAFupAE3ZAEc+8ANogBHY4DDugfjwz8XmcRhGPT2UQAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(29,'1f623','persevering face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAPFBMVEVHcEz/zEz/zEz/zU3/zEz/zEz/zEz/zEz/yk3/zEz/zE1mRQB6VwqTbRbTpTbvvkSuhCPGmS/hsj1wTgTWdUZBAAAACnRSTlMAWowebjuz7AbS0h6f9QAAAqNJREFUWMO1WFei4yAMdAOMEc3c/67ruCKqk8fqLzEMqiNB1+VlJv1AOWfLwjinQ0/m7gcZJ7ohYGF0Gr9DmXu6ZIT27/WaJ7YUhA1zC5gdanoBRfjyQjipqTMsL6Vs38iX18ILASTIOwpAlX6zrHk9PhKEgOC302hFn8aZMI4VMZCQeM30Qh/ttn0mRMb/JHUiAc7n/MASmUCK/DTiLFwhsWkHFxKhsyB2M4q7NkLEDtng3f6/8aE4zqc7D/WqzH5wAudSdPtk1htsSDhInetEwq7zHPksuLKKxIZBvCoS+yyCyLhpCYDAFmrjhoIwm2Z2F4FwII3VlTJbjQT3KM3mdEp/L1Og0M9yqtQvf5ajUujfgeheHEsDGVu4+nI3bQFEW8TsjBtZmghp46JPAgyoT7wqEW1xiRxkQgN6P8rRrPk6g6D6T2/zFFCWACxa4hNlx7BpokRJNv+ddUH09Wof3THPP+wIxq6BH1mXdIQ69zjvUOVO9DR3djkaPLfdu9QJneHOyLQjvDJ26G2vk6n0SAApKVKRQX6OzWMdLwXGi4wKPgQmclz8z+otwVUYmU/zlJDODuqXyB3fQmL7qe1nx+Ax9h3ftVaha5wdvUcjkEjCChR4NPIQG7zSBkGB35CoN2zabyjIesMpbUn+zdpRswZZadnaSLfVl9H1ll1qSN6EVoC65pq8u68cPZJmrYw1eZUMqtM8F81dedKSIhRbVCicsvM4HmFmJm3yEke4NdWtUwN7zj+pXpYY2GPjlL8ZID/HB1eI8FKj4aI4daSPvm8W2Dg2lq9Zu4NckIMHCUH5moUrRWWyZoeytcvohKaJTEVsjRMqV1FfJ5kvBw2ydjkOr+vVuZH8/weEdk8a7R5ZGj77tHuIavg01vCx7ofnw3/eOabo4nl91wAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(30,'1f625','sad but relieved face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAATlBMVEVHcEz/zEz/zEyMtr7/zUzyx1v/zEz/zEz/zEz/zExcrexdrez/zExdrOxcrez/zE1mRQBdrex2UwfsvEWIYxCcdRu3jSjSpDa6v5FqsN+uN924AAAAD3RSTlMAi7D+JQtGaO3U2FK5poXctzhoAAAChklEQVRYw61YWaKDIAysO6h9rGK9/0WfuwgBEZ1PacfJkITI5+NBXiUpxogQhHGaVPknBnmVjgxnoPQuWVG1xIG2Km7QIOIBSgKp/DQzVRVAU2ISAFxeRZWQQPjjyzEJBvZsYInIDSBneCW5CYfnFSGvMJUkAuVLPABTjuKIkLF3hbXvPed9yDN8zic7DzmlHHomrMz0G6QoTESl1yYrMDH9R0Hs9lPsySAhp79YUZD5cefMpgJBeuxXbwvSeAMqYEGio+CLDyaqBCRJEyREr2b5kKk6E5VKCFNStWcJPdC5MnDVO2PPqkVSq22u+QsI6vjhliDtXBzEJJLqoi52qj3Tct3qMTTOZadEQIkJ1UmuCZ9iSyEfOO8E7BC8ko5EyLEzXJDwFaRZZOQvmADulRxosP1meh++MppkN5DOmUvulbGZpFAnMjb3emV02z4Sj7wMXxl7yWtE6J3Q0Ie8YzYBiKK2nwChRSUkAsyOKRFw12KKdiTaEzLLyAOke4lkjD1hSrai/bERv3iiam0jgs0Q0UT52tiyhSg6OLS22h9b8Yv2emn+w0Y0RFs099pdkC1JKDlNRfLibMmXA3I4iBgwyCzwHXbtcmRrgs6ShNQOcWsIsaaIQhekSxL6MOCoMX2I+DvxaJIkNSD9c3t9JhoAf/w+rYIaxkBJggIQHkFfkyhzCoIlbcMos3AM1Z3ql8FsGuU6aPQ+xuPGJlpik9Lu2VJCDcQRGRtule4+Zde2ojtEx0eNzXOrco/vh2dE2ndI/YRI/xT9PvDo9Plob/8Q2CbNz/U6MjLrAsFVa5cHmYW/CIfgS5YT09+Ta59m96luHl5ENd+Rq/42716NvXhZF3F9+A8ucP8e6VJYpwAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(31,'1f62e','face with open mouth','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAQlBMVEVHcEz/zEz/zU3/zEz/zEz/zEz/zEz/zEz/zEz/y0z/zEz/zEz/y03/zE1mRQBxTwXuvUSAXA2cdBrUpje5jimSaxXV14+pAAAADXRSTlMAQx6SXrNw7dMIM4mAHQXvCwAAAeZJREFUWMO9WNmWgyAMVZRFnQgu/f9fHevRthQIETNzHyPeQxKyVhWCvh2kMRpAGyOHtq9KIJTcGHxoqcQ1lq6VkIBsOzqN0oBA/3QcNDuVIlDVBggwde46DRDRoJcSBsgwiANrDRegk+rVcBFtnKcFYGGqAViYingAAjsJXUakv3zXGSiE8d9TA8VoGAwUmsncIfpQTsEtqJel9T0i3SUv5GZrZwdUuUpdyNlxg3VU+XGlMMamccdElR+REuT5ZTyw0ORbRdiDI+Cfzx9mmnyDiJp6On+YaPLD3GEFG1+gyQ/ddJrI0uRPv231HThUgz6WYAuMvT2AIRRedz/AUMW6hcsP8mntWAa5GiLPXBJPRReDdie6mULe/gcm8BGxqWZ4iAwfkcyccOtk7bS6zDEZCxEvLOzxmhf83JDpipZ3Dloy/U2P6mXfRBbVrq9Q/8/jB2bU+xVmbTd6cJit0cK/+kQrXv5F+vPDJ3qkT4oK1c36RBOqGdYW+zyR4uGX7HRXY4lEZ1+j7qqmco0W0divRit5JaL7VbYZpT3Iz067vxMiNaFhpwRtQxoh8mnka4RIDjVnYrMLbahBpgg81dZ/N/jxjaJ8wzHfuM63QOBbafAtWfZcQFj7/OsiinE1xrisK1gf/gLHbNGWObBXlwAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(32,'1f910','zipper-mouth face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAXVBMVEVHcEzPu4H/zEyZqrX/zEz/zEz/zE3/zEz4yVX/zEyerLD/zEyZqrX/zE3/zEz/zU2dq7HzwUb/zE1mRQCZqrWaqrRzUQamrqjtu0OMZxOgeBzfwm/FuYjQozV+dVa5oLT1AAAAEnRSTlMAF0DrXLNw7QjUkYdFkzMixO/6r3LoAAACP0lEQVRYw72Y2ZKDIBBFIS6IGmO1iEk08/+fObglGhoHkJr7olWNp26zSAMhB6riIuGcATDOkyKuiI9omijCXixJqRslixMwKIkze0zK4ECsyEJgJlRqgbpwsBC//GXnCpa6Hpq6cbAWvx2kxcBBzJheDI6KcU4KEIQUAwQhXcBLWj/dmB+IfY1dxsFTfD+fruCta4AO0rrJP7Gv5FI4pfRtiJ0DsSyMobels4belvS1cX9K+bxjnxgi80rR/vN32YxCSKZIMu07WvPH1LqRYB+hWFe/mkUv+0iKZfZcmz/sI2NuzOAfycAcYWp/1/KVa/PGPgIVMvheoJgUECI1KPS+9ups1dv6H8Rn+IEjIJ8JqUDMtBDk3SXCiMPSPIwQCCTCwnAY4WFAPBwoCQNKkCXipcKvmsHqmyoMqCJhxp9hv1q/vkb32Vbp6InvtdQR1GMgim2QLzl+MC5z7KmCA3SiG/rvDVKbALI5Av0IITox6QOL0SJi/sCsN0iItp1ga12TOoDEljOSWmUsp2hdM286hvRasQOtuLpELL2kGfSz43Sf18hYjOJTYNhlNkA/dFsQVh6b5tKwMTQ17OtIvefuBfsH1C8Fe60MUfdKu9sb4lm5MeRyqOl3htShZmvI6RTRbw1dyN6Q08Gvb5cxG9dGFu0NuZG6haTWWP5tyO0wOnuqKaG6Ibfj+uwpKkdD5akLhIWkrNUnrzTqdRqUZy9Z8pmTn7/2mUgRDXARVUaqu0NcjWW0zP7pss7j+vAX8FMp+rvlpssAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(33,'1f62f','hushed face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAANlBMVEVHcEz/zEz/zEz/zEz/zEz/zEz/zEz/zEz/zUv/zEz/zE1mRQB0UQbouEHOoDScdBqFYA6uhCMpz4xnAAAACnRSTlMAs4ziUzHQ7g1thzwPbwAAAj5JREFUWMO9WOvC7BAMRBEUbd//Zb+2S7da93XO/NuwUxlJBIQyYJJgPoFSMHFMJEM9EBLvDCEAS9HIQrFKAFPRsJhJZQCkkkqCKgBkBQ3jqgKclrwiqhJ5/wRX1eCZaKCgGgBJ96hqRIJJ+nGzLVprG/ur3QeWzfifMrceu84ndIxIuzGbXpPj2dzUPNE+un0ML8UZ3Fdz/+jDtWvCejoILLbv1s1ZrEkrbOzipp2f4mE8nXG4BYvOwQlwziSBY4fl86Glbue37+S7c9wPxZVJq3WsiYcRdOqjTX00Gu11uqJJgNvYFh7HdAQJiHtIH1bTliHGR5tbkphc8NvWXPP/mUQqV82ebIupt38yBSd0fCuWsit8evb+gEuUtdaulLhXj6/r8z0HynYn99szn0vPKE/ZnW+QqRV19iOUXJqFuCrFXGf/JJwcQ0QRUSNc24tJpFvoEHtXO3Ikdmz/XktijUd7QKoJQbLUNKTIsf/xAtGYtDuQGgNAMIpoGkM0IT6GiCM8hggjMoaIxJK2BzRWRnrAUHH/7ar1aou7j0pqL3NNb4Gjxf/ddfgWJgkZP47CU9khe54LVPBt+xJtBc/y7fW3p4xWofDIFpl0m+dcxb8STTw69SyRzkt9NVo/uHY1WpklVYktw2a0e/v5sz3uDUj2atj7UoTUXh0LSfu4QrhLTUfRf1+Pegva7xfR5GW0o+jKf3s5blUc2K/vGeUHhHFPGvWPLOz/PfsMfIga9zQ28LHOC0/vz4c0K/Af8HOjcMr/4yoAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(34,'1f62a','sleepy face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAwFBMVEVMaXH/zEz/zEz/zEz/zE3+y07/zEz/xEn/zEz/zE3/zlH/zEz/zEz/zEz/zEz/zEz/zEv/zEz/zExcrOz/zU3/zE3/zExere7/zExysdhdrOxcrexdrexeretdrOz/zExcrez/y03/zE1mRQD9ykx3VAhdreyEXw/UpjfktD/0wkfCli65jilsSgKWbxh8WAqyiCbKnTLuvUTryWH5xkmCtcirgiJxTgWRaxWfdx2ovKK4v5PMwn9irueVt7aPaRSxXJOuAAAAInRSTlMAsNHg6/rwBf5wC2NbuYkzGjyT8yJDyxhR/r7ejqdw2EiAeTMa2QAAAwlJREFUeAGkwdVhgFAQBMDFTnCHr8j232PchYfMYIM2RR3FiWSZJHFUF43ihNYj4Q8SeYtD8rIy/smqUrFX7gk3pPc59lBPGZC6IqiLucPthG3aG3exXrFhnLnbPOJfk/AAmfCPNeMhWYk/FcaDrMAfVuNhtuKXKeMJ2YQfRuEpMuIbnXnSrPiq52k9vuiMp1mHDxrzgljxznmJ402ePrZiFlqSg0AUTdu4uwsQAsTTrvP/X7VCli1iTIbuezQB6jweUAjaiv5RgyAeRHHoMlQDc8M4Cni9pP2CoJEfY4mLanCxJPZHNZJOEECCKcbmQDnTgCAgX72nMJLcw4qmrmGFx+H3qdx3YA75oawSRj4foQZG3I/+VfNBwYVuNZnkohOBvkEkuQETotvdUVHnsnAuUAvEJK+setNxnH217GVRyFBLWCg1qSSw75yjnFQ6zFFruPQ9RTnnzrE2sFOOfgCfapPk2DmDQNCvtr2DQGf/vWau2z5OtU3H6aKd0HV6aCf0nD7aCX1ngAp8eSmBL5J6M9N/YFAO5GHszlMuCBE8nbsYe6b/wKDctczFBeLM9B/oV8zOPKzhZcb/QK86/KMkVNXDhBj/F4a/gyoIP4rDMI58YfxfoKOWyLacqUW7LccqjWzLOSQ2OyCxgdvb0Pnpxr8aP443y9Wwuv3DdtSS1SP9w3gBsdR2BBtkO4ZjKnlcwjI9hS27iSyYuWHozoIM/i1ozlrKgi17vzm3kQksC9gN0YaqUEsCh4gGu00LlYypYjyUVhsOWsbUMVxTECUFmSQRD5fwCNgELA6/OYwmuEKiSQJezcdjEeIKodD8Bl4aDuwgqFnSiup8mK4QMcZuFDAuRgiNBGdB5GIcq9IB1bm+N1xqZh4jqABh3hdSPFKdF/tr1qYiyfLit6AF3myuouA28Gp9OR7SAs/W13WyLppk/4DwWAxk/6TxWuya5SNL99J5ozpP9s8+95Xht32Iem2YkDr7bZ7G7p+Lguwf6+6fqkvN9HzYHwz6Dc+HHy9Pz9fXT3+zyG+MITtvmNqrTgAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(35,'1f62b','tired face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAVFBMVEVHcEz/zE3/zEz/zEz/zEz/zEz/zEz/zEz+ykv/zkz/zU3/zEz/zE1mRQB4VQnM1t3wvkXisj3VpjZrSgLJnDGKZRGXbxiofyG6jynFzM6noo2FcURdm1NJAAAADHRSTlMAcESMs89f6/0IHjPH/a0VAAADLklEQVRYw71YWRajIBA0bhADBETAmPvfc1yiNpsSJzP1kffiUtJLdTdk2QEedVFWCGGMUFUW9SO7guZWIjIBbz8ElbfmO5Z7XS6vesBlfU+nuSFyAFQkUh3TzFS3BJq8IufAKD+zqiBpwMf2NRVJRnUQwNzyTstYe/Q/bl5uhRwzShm8MP6X3HqiDvPUdup01Ceimpwz2eshfHrPwCs9da8EmUI8tiVEBZg8PzV2FoqJh/bEJ6fKYkdO7O5W3LmR1HPIRi8NpKrsfFrzEHPRmdmE8dO+bhcmKlUv+Hq3sBy0ZgrdYUL653p/YM0q6KZqD/D6VBeRRrc/9EmOCuidOESqw3GV9cwmIlstuKNNBFQyZTp+IjPRayblJhh0dxZ0GTdnQZfxWVIN9C0Z06em8c5oxiSoBYtSSkuWixuNiPrHMCdqI8pZHNgnmuOPj4MPiXBju9pKyEAqdfb91nZ3adu/S8TVJ9+vm07Yfpxsc2OGJwu0XEQFPtp+LunZZsduNPb3QyXIzbxOxl034gGCD8KrpOfQzT1ShdKjzrxG1moaiozlZ926bxWOr+34wsi0zg0npGVW2a1re1D37V681qLXjmoNRX+qJShQtVgvjqS/cmkOhgFAtMVXnIlUfL4IsgNlrkDOaQAVEIlDpERq6RDKIUJwSOi+qUIdHCpQ9tdVbSWqfkNUOQl5GWVW/IaoCIn2CupIGdmy2Cg2tbCx2/WHmfHI4mEDZf60JSCv1HoysBHL+zLWZ7FZxPQehteMYXjLZTjCsV7bBO4sdf49vJ4Ar+HtdwTQjgK2zTMeG54ehvkGD1qW+Qkw8cj36xnCO8hUB4cIPNslaRAyNBSuc43jbkNPYYJjjbMkQRMgQgtylqRSiFRoQfswOpc3moQWVhBvPJ6g04jAMJ+HBnbCZRrRvk0pwluI3lKp7sf5ZWyTnI/jzlgJwFf68BZi29Ro0Gk58eaXcXxklm2oiWyz2GercTSL9nsnwnlsw6aYafFpPeQ9UzEebyuasmevUzbH13nc7fppT8z//QHCF0ca5PTIJumQhVSP/3fs88ODqN8djdmHdXAtXx/WXTg+/AOkxcoE+IoK3AAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(36,'1f634','sleeping face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAvVBMVEVMaXH/zEwvapX/zE3/zUv/zEz/zEz/y0z/zEzXrGb/zE3/zEz/zEz/zEz/zEz/zEwpZpf/zEz/zEz/zEz/zEz/y0v/y00waZUrZ5b/zE3/zU4ya5Q8cJEqaZbkwFa5qGP/zE2CXg34yE1fgIU6b5HDr2EqZ5dmRQDMnzPywEanomuHYRCedhzpwlUwapVtTAO+kyzltUCYnHGNlnXQtl1ohYGBkXl4jHzaulpLd4u4q2ZwTgV2UwiPaRWrgiLVGP5qAAAAIHRSTlMAsCLpCWDR/O8Ebz3eiHQz6suSUrkZQmfFICP3mDCahW2b+NEAAALUSURBVHgBrdiHkqMwDABQZSmG9H79TnTSey///1lHxhkMKwgbD28aIeCRLYkGL5gtrVHR6wZjRl2vNLSWCRIG1YqBCfbOdd1fv9oP3+CrVK3PMG3sC9+/OkxVQeLsC1+LyGwamGW8jxz8yE5pmlCopuMLj4HcGWJ9WDSrLgo58/Pw4e9HAgnwRweF2cF5WiM3c6Nx9nFoQvsDUoYGJmzi41zknGj7ZGNk6wt0+XssJ0/PiNbR5vyID56f9gcSNIZpR8/zHic7jP+cR9vjZ3me/KTfL+IRJ7gzce4u/sMbP/zmBWqCMGSYYR8ddhab/mETWR/xiTlkYj8NJPhSHJCsimsjtyYrrXYww8zlWSL5nvF9W9p5Xcyyiw7bIue58TDzTXLFfyVrqIZZxiLzhAjSq0HM1JHg6eYcO7df/D3qImdNpFKrss1ZQL6E1Xilc64beRGJfuGFbqhxQBJ45nmhN58BKfi+7Zznj+OVpOE7ROZJs/XxfWM/rQ0AA4ZvINcqcV+pooSZM/cTnH8AUMESVABMA0tgmNDCUrRAw1Jo0MBSNKTXmqy2jqXQoY6f3KwQE0Lrlr0vrQ4k+1YQXKfhasTYaBVOr0FgZe9LU4A0SBh8EmbvS2N0IJwGKdPMfXQgWti2FSRYdvY+MrU6EqPEWdYoex9dbB0p+x7Pwc7cR+k5Bbm6Ty6XyX2Vs4+qlNYi5TVtaZeR0i5sJV1qiy/+9nKyWEyWNr5ULbwdjSxahBQb0BskbRfaFkS/8Ja9DGJLzKcVPkRMgtgEcylq4WPNIogtMFcTgIYkMZCh0kc/qalVycOo3GLrJnk8lkt/DRK68gXZhSS1I9siHRNSfhooxfgBnwwZSmBDIHpMYpweZNDY2+NoQNGY5OIhr+vFjCEQ9ANCsc5PqU8aRNeU+chC6DUoZFYVLKBUTYkPUYTSUKU/jQmsr6myH+sEo1IdQI7SPh/+B0vdGGi7ExDWAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(37,'1f60c','relieved face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAPFBMVEVHcEz/zEz/zEz/zEz/zUz/zUz/zEz/zEz/zEz/zkz/zE1mRQB2UweDXw7ktD/1w0eUbhfRozWvhSTCli35k7+xAAAACnRSTlMAcEOMXiWz7dMIXjHrrwAAAidJREFUWMO1WFmShSAMdAcji+D97zou4xOQRJ6T6c9IdWWjMakqAn3XDlIKACHl0HZ99QZ9PawMMcRQf0k2dgMgGLqxnKYWQEC0hVQ0zU5VF9A0Egogm6eoWigEHV8voRiSKGAj4AsINLwGvkSX5+kAWJgaABamVzwAtzz14h2RSGo3SngJGffTvQ+tWWFvlkxnEgkyy6ymHcqdNnda5sXgaYoCc/N0QZ1WFRhnFwUX3PfQm5AGIVqpQq8+WjAGFVsuCq21CkPbDZ/PS1C58e6QP07pxWBVMos+zvibS4FDB482dMV/o/epS9cdc6nTGI4EuOSmXDq/ZUCZkjY0KiwEDPvlgIjIlDW0iYigj1Ptgio9IT5bR5H9AVtsgoNIRCn6C/o3ApuXypaHqE1zPeuobk7PtP3KdiKN+lAcu+nYrkqatl9akhC5KYGj7RdRWv1Yjqb5yf6p/02rdXhe2yf7iQoopvA8Zj+JMo3tz/PeFtmP0HIPmvGryGpvSu25qr1+J3ku/9aQbFeE7dKyyQibsPFJbc1BVFe41iYKlFWh6DnCYlObAnln7KZB1ji/qZDCI0N/i/2Ugad+bsd83WyOyOZrNt7/s2iXPJ5qwiXQKY8G0iHUJRv/7k3K0g6lP6OB/sTyajAFKZgf/GN+kikCFRO7P2Lrk2ZxAfmXEYJtqOEbs/gGP75RlG845hvX+RYIfCsNviUL49qHcRHFtxpjXNa9WB/+ALOppI8YHn1AAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(38,'1f61b','face with tongue','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAS1BMVEVHcEzxh2L/zEz/zU3/zEz/ykz/zEz/zEz/zEz/zkv/zEz/zEz/zE3/zE3nWnBmRQBwTQWCWRDuuUbQojWYcRmsgyLVV1/qZmy2UUVuAfoOAAAADXRSTlMA+1ceO7TX7WwIh5LLuB60bQAAAkJJREFUWMOtmNuW6iAMhos9hB6YclTf/0k341anhQAp7e+VK+VbEEggaZqMOj71wwBCwDD0E++aGrW894S9oOftMcp460VC/W2kYziIjGAiovKYF4oTMN0gCBpKjh9nQdScXV+7CLKWzAZ2IA4Iksu7iYO6JXZLHBa/ZD6JOXWiSpGfWqgDQbB34yIqtezP0yyqNV/goNhNwxnQcOoEoadphHMgGK+Z0HdKZyf0nVIcG9pKaTU2JGH5HylRntdy9ZIIKWXpX8ERfa7Wl5SgW1rM1WZ9y9AtHFuZ/Xxu6ZbftUFi/sgK0hbAwmz9im7xARefRvn5WtIt3kmTuGJpYop9XeVs7+04g9Rsv88lg7jiQHoQ0AMhZ4HmQGhmLY24SA1cw4Fzeb+wa3Wg/hpQj4RIlaYgaI2mjtQmCNouiG9pnTF5hjHOyiADdEFi+8S3VNZ5oNG/Ev6ntf9nnLNKYhkAwlTrVrJcmGo5Gt/r/flUSm0GSqnU83lf0QzAo+voO/Tnrftbn/94bmub5Np+EkquLLyyFQ2kkCt7/4gwNJDB3jX7M+koIIe+tIJ3jS2DLP7QCu82VQKpZCExBPk0D7LJx2h0b7scyOWqiPDBbmQKJE3uwY6UEClQoYSIixoiCNpSmUUEdcXC74FzHoRilB8HcUJxzHAQIxTH+3K9DIKO1kAo+XppiS0Nlp/QPFKbLBoDaWqTZdv2YckJkdo+m0YUwznkRtRfa4whnCOtsb9mnd6gmK5o1m3ah4w9vBgrtQ//AYsq1nUn9naPAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(39,'1f61c','winking face with tongue','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAZlBMVEVHcEzwhGP/zEz/zU3/zEz/ykz/zE3/zEz/zEz/zkz/zEz/zE32w0f/zE3nWnD1+PpmRQAqMDSIXhP4wUr47c2lfB/XqDhzTwb65KjDly7rukL+02fEVFFcYWX38uC4vL791nCKkJOgQ3j2AAAADXRSTlMA/IweO7Rw61wI0svx0o5XkgAAAr1JREFUWMOtmNmSqyAQhuMW1BRHA6LBmGXe/yUPMYrQIrRW/oup0hm/6YVuoE8nj9I8zkpCKCWkzOI8PR1Rcs4UwRbJzsk+SpFndENZXuAxZ0I9IjES5ceMqDMCk5YUoTIU+CKmSPn9Sy4UrYsngSmhO0Q23cvpTuU/4myQDnCcpJQe0ipOCTkGIiB3BSrv91vzrKpnc7sbq8BeT5h1+G4qrea9rMy9AbpVlm7OMCHqq6mAGl13Rr0f4Bgk3QsKstcv2ztSoA16V069bZMQBjVuUGObFK6Nu/709bheHy/9eLcqJcNH6O866g9GKRuLA5+y13XSCyYucYW6F6zrmOiXN8/pu8cMekwvnuYKAJ5xUU8SfH43e3LVmt9Qwzc7Z5zVWoyjQQSWmclZSGHXVMHZyRe1JYENtloAVgNpa6AWl/5PM7FirRzrhGx7zvtWik45h1uQn2hbHYQxaT5KxlAlMvYSVK8OFO2YNlzT97aRLwi5WzRex5SwIE+rnUDo/ey27deOGI2LwL0dzaByx7bq2iB1+jP6E2Wn+DegGBSt7LFf9hKcb+w20tWqN8qW+xBclSFTfwiPNwRU7SiFE1K2bf8R558iVpJCMIWYmpWdNNBqRY2WsGMNmv/SkP4NA1v+/ddKNgwDaFVG809AkGaQlvp6WJ401vosWW2Qcg2yNf9eQs/gls1woM5xuLUPES0OZEVoPtecXRuJH2SlTJ+0wLlGhEGMugyCJn03SR+IcadBq8PoSPKAAKf0HI+FDyR8twjYTNpuC9S1qwbivULwLRBsDOAKsb7UbIECl5p1mJCgNHjxw4EQV0gUCHOpjdycCMGxr+thEElRAwQeyv4lQY40Ir9BwZGNHrJwn0FlumPsE20ahBr7GIOoyM1BD6KW0Vjk4OwZjS3DOm6gIn5gWGeMD6NIwdSP0PjwP9AY37eHKbVIAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(40,'1f61d','squinting face with tongue','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAS1BMVEVHcEzwhGP/zU3/zEz/zEz/zE3/zEz/yk3/zEz/zEz/zEz+yE3/zE1mRQDnWnDPoTR0UQfntkD5w0t+WA2whSSPaBSfdxzSV16tUDwNR5yrAAAADHRSTlMA+x6NXHI7Bu3TsLmeLzyUAAACmklEQVRYw62Y6ZqrIAyGXREUDwhqe/9XOtgelUBY1H4/Zp469p2QDUhRhNWRpu4Zo5xTxvq6IV1xQ1XbGwIU7dvqGqVrBh7Q0OTb1bWUR0Tb7heYbBRhPEOMpMypeabqqFEV49likQASyi+IBpfX8ItqfsQJkG5wUBLht+T5qaL3QNSJXcf4TTGYTzW/rfoHDvLcdH9hzuJa/kjtYRB9BqLdbww6THpq0GFSwx/rWynDc9DwKY7zs5Cj1MsspvjXJjEv2rwqzkcVdLUc/0vPQdY06+Mt6O4eAW1vCeVTlND2K+cfehgzYZMMyuUADFiaiRssMzVtDthfXcACp/O5ceOknILDgj9j//Q0d0YTAGsg1goPkrDWhDaTHnHpiHzJdh8Shr7wOohYxxRoXL04MBcEA2M5CUbUCykrKI7RqxeZT0RXjaNogcU3kth2aoPsKPz4rlOqRqfVzw5raTITY6GktTQGQMuU2zk+ftBo1ISW4koTEtLyN8MS8o76J3ssLBFYtCLfR8IpWuKUq9x6hIoh1NZppFO6xNmM9lyTyzLPwuT2JmVkfglhEntr1l5//G5IwNugYONaoa+dffbsOq/3+621XalSm0cvv1Ptzb/Ce9q/Xa+v9o8HFvix8jbI2QM5Qvvt4G/ZSueBtPK3bBg3kQcS2LmmxbaQOGhGT1rOuWZJgxaFHrQck9SSAkHOefRzD6MfUgTkcOyTNvG32jBoVZFbRO01rRDIa351/AqhQiAVv0L4l5oQKHGp8d2UCSLJi18eKOMKmQXKudSWOKfM4MDrehpESdYAQaWiz6rMkUYZN6jucocsKmZQcshij33KoEFXJ0glzsnFWKOxEuFcGY2dwzploUp1Y1h3jg+HsjQw82NIjA//AKfVyjF8nlwWAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(41,'1f924','drooling face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAUVBMVEVHcEz/zEz/zEz/zEz+ykv/zEz/zEz9ylH/zEz/zEz/zEz/zU3/zE2GwemRyev/zE1mRQCIyfnwvkTPoTSCXg1yUAaYcRiuhCOUyObUzIx1cEqJvXScAAAAD3RSTlMAjFfi+zyzB2vv0R/L9ZLFC1ijAAACoElEQVRYw61YWZaDIBBEZRFNBsNmZu5/0FFxAQIKhnp5+Qim7J3uBiAOgtoKdw2FkDYdrlpEwA30LabMA8Vtn8dCaswiwHW6XKRt2AloRRJpKLsAbROoUMcS0KArcSqWiHP9+gdLxuPEgYiyDNCoejVkWYB1mKdl2WiD8rAbCMiELL24GLVSSiRo92Gnfrcz5FoNBjzB4p7vyO53rocdKcZ/uPG0xSEcD5oP1aDQUko9CkfSyjHQJo5cOaaHIfMFEvs7pM1lmYms+SWMcXTYyra006t2qo74EcRVUKPDmWoYQprv0USo8dbynI67CnIhps+46r8/Sokr0HI+poQhH5Uj1CoSMfWQJ/PMMFTKyNQQJzcmiXR6cph4G+1MwXtiiKzcn524/gMvycHuQhxx0t+rHodUdgRgVgB4C6JvMYUSCoWJVEqOPOcEfZroSCn/D/GT2Uj+RbYVgCXJedrJUkxwnMd9Pn5irO3d0HpwoFNOlloCmkjtWiGuT0y6Adf7k/hKCz7JzbmYLwF5fWL8D9x6qqXY4nX+FlJfn5jfAGRFAAEtQ0RBU4aoAV0Zoq5M8s8BWZUhqr6qa07SojJEqFxhK1Zqyxip/eo6skBA5BrxmqkUzcLtrJiLxiim7oPzhLSu7SbCE2kIQcngrb42EWFz6yFMdda3h0PJkenv+Vrw/IsE0dnwIKxOb+V5vd6ngwSJ1JK9yRteOwIVhHy2x4E7Wkt1QYRCDXusbzkhqiIjRBhxIm+EsIaaPCLan41Z6UQQZQ5+MaI6dxSNELXZw/F7CsUPothwfDau/77fvz4RRTcXCB7Ro7+70nCJLlc28SWLTdShL9Y+B1HS2ie+iNqImop8txpb/P/OWY1FlnWL/3/uLP6Atz78eT5/ouL8A1MD81OfzDljAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(42,'1f612','unamused face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAANlBMVEVHcEz+y0v/zEz/zU3/zEz/zEz/zEz/zEz/zEz/zU3/zE1mRQB2UwfTpTXwvkSofyCMZxO4jSmWDm0mAAAACnRSTlMA+4weQNGz7GgHc8TSEAAAAjNJREFUWMO1WFmW4yAMBBsQyGDD/S/bdkgy7PGiqY/u9yIoq8QiIcYGEHpSUgLnIKWatGB3MGsFWACUnq+xGK2wA6XNBRrAAWAyFDSIHOGMV0LiCchfgTcTnsRY3yzxNORgAQXgBUBPnhEcL4HrNpHGq2gyGYE30FB3Vdfbp4ppBrwFKNbOSLwJme+nCW9jygKEDyAohBXiND7CdzeZasXWde3NapjANB1ym10O+M2VM9zmXyZbmHTtEF/j0Agbkq+vwSYmv9YupQ6FJYf9ftrZwhQql1TNY+1nmv2YbGVKmNTrcCQxiF6749itMVYZ0R6bQxF3UX8SqDlXZnPzHpVUWhoxl3kbtamcyJ3bOy4nOrQla+YSD34yZWPh4TFLD5ymIdLFBVLulv4+KoIwsbxaKHddvY9qyzvacky0/LbEu4TBUNq/7/YtTaIU2zF8O2kBNshCm7UbP2nhjNMsP2dAQwR0RJJGmWSKxiP1JMfmR4Ts0JJdIzTLBvlV+yTWjCZIOk9HdaLfk/SRx6z1MRP1MLORNufzi8O7kbKetrwKaGX8KmUb6CWuBppOfeqalkth6SAMKq2GS27pwnUdari0xgva+uD2Co3z/Y8L/v0j75Z+dTEavmUZ53He618sUMKg0i4P3D4+NBdoDWX6KN4jxWXifb8Y9X5QsF+otPn4CUH2qKF7Zt0slATNUxQ7j9rLj2Pxn5/rhA0EupYGXZPlTNsHz7V96BpRhK0xwmbdjfbhH6r1osMvmek8AAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(43,'1f613','downcast face with sweat','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAUVBMVEVHcEz/zEz/zEz/zEz/zEz/zEz/zEz/zEz/zEzMw4V0stVcrexdretcrexbrez/zE1drexmRQDMnjLtvEOBXAynfyByUAWiuqmUbhfJwoPOw31A98RbAAAAD3RSTlMAix1Y0rM77GsK/bnwez9fxKLZAAACQ0lEQVRYw62Y67qEEBSGOxDVzDCKmn3/F7p1mkGI+P7U45neWQcWVlF41OASAoAIQQDAEjfFHVUYSoIuBHEV8Gnb9+3xWkPiEKzbK1BPab9hMCIeodKPelKpp3zxY1YU9nBejwVEXw0gAQKNz7FFHQmUy78n3fUJJQFrAtvHAaKhIIIan0GUTsEkUvsMijCJEOwxKMok0ybNoPDELWrcBsWZhLTcPXRQlElAmU8vaugvhlSeJvU935QwtQ8TRKNAwOlZxDrRZlN/BsX5hlonKCpvX5POIYoM0mFSOmhfKV2yawSu+86UGmypZaHgT2r693BD0qV6tvmGyCdprW15k/u7fEyJEVoXHCYmaeEMfBRi5IP+a/voHqRyff5949QtfvH3Lq7+2D56FJPjtPCZJKublnwN4/ur8fv39tFftC07tPKF/MY/+qsl5xPD/NY0+0aVtJ1A7G2IuUdVkM0xwdkgozAMjIvdDfuoojNoHrU/Y+PsHvW6dk8ZQSAPCBQwDwjuSyRZ5bZo04XXMpJBTZEnbWgttVliXeQJ0lL8qxyg9dzm943NQmpm1xtkUfsw4igbgl1u2a07b1ytQPzyXIODOB7ScdJymXRVFU2DnCYJEyQuLxLAbtDImayua3kdGOOj3SSg3sutETp9xvjlLaJMKSDateZ2oQTGlbS6WQTQ6ULa3K5Dpuo7nNp2Qcb3qkeRwaba2eaJijjytIGqiFkAvB2gNnhmllfdn+Qmi5K9tLaP6l9aI0pDJbXGsjXr0tqH/xXc9xeeS0umAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(44,'1f614','pensive face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAP1BMVEVHcEz/zEz/zEz/zU3/zEz/zEz/zEz/zEz/zkz/zEz/zEz/zE1mRQB8WAr2xEjRozVtTAPjtD+YcRmqgSLDly6j3h6vAAAAC3RSTlMAWoweO7PP7Qhu3jsS/uIAAAIWSURBVFjDvVjXtqwgDMVCk2b7/2+96jgjJShqzt2PEfZKl4SQE7RVTVnHleIdo3XVkidoJF0YQnAqm3ssoqIqA1qJchrJ1Qm6WmDQbCbKAqqWqQJ0V44XtSrEuX0NU8VgJwFsuboBnjWvUjdRwTxS3YZE0SejU6seIfFTw58R8Sh2gqmHYGE+1eox6gsHOWNciSx0U2rY0GttYqHRuh/OjJMgD0gEMf2ySSQRG9Yreo7F8yo1CRMXOYXcqo+eUndMq7x3GZVihex2XI9QiPZPFlSpimg2dSB9DqZ+skClHH3eDvP4oennXNrM+4FxHg4yuhXHkSX6i9ShcSA+x37eanxX/w7k1QmU8hNE+pbtRGa2V1VhZxMRrbbxw7TeLJaXVdjizeX4zzT+uA+lBSdxiKo3DSRsJhSHiBKGQ8RIh0PUEY5DxEkiGsN26swIyyKkREvSmk9FrjVstvSFZLFGiWlOR3CwLCZKnT2Gd8acLHJ2Gn5r/DvG5mRR+IGE9G9970CyMCGhEtm79tpw7ZksKBH4NTNMpu/NNFzJvKJFayM4qc2Dn8ir4ic4nU36v6M3aAiObfT5cxZ63IrXcfu+aySGq09UciZuHtAL0n9oZVRKeIB+Fg8S7A2R/9Ju35jW/sWDHW+EQBtq8MYsvMEPbxTFG47xxnW8BQLeSqN4ycJKtlslax+URRSvxf9ejSEu6x6sD/8BYAyzWiJJ8zsAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(45,'1f615','confused face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAPFBMVEVHcEz/zEz/zEv/zUz/zkz/zEz/zEz/zEz/zEz/zEz/zU3/zE1mRQCfdxzHmzDrukKJZBF0UQd7VwpxTgWv/cFoAAAAC3RSTlMAjDgeCM+zaOj1S8RpTXUAAAHDSURBVFjDvVjpmoMwCPTKJbm07/+uG9vVrUrSHHTnLzrfQAIEui6BQfScSamUlIz3YuhqMAqu4ALFxVjGMgkOEXAxFdBISED2EwXNkypH1cAgA2z+JKeHTKT9GxlkgyUOcFZQADXT8MSZBBRDoHqgAnO7XzHvxiqewHQ5u4lBJdj5PvVQjf6UF9CA9zLFWojenBPQhOM2TbKNSE40gg5JrYIOSc2Cdkm8nYg/kwMIMNJ49vIN8cyZx8M47IeYZfPtnvZu0QEL8n3UotA08/oJX2IZkBBZ/QubbwlBuhcQs39u8i2hmNxjve6fr/mWEO17BdEH8i3AOklDJBGiKtckco2qgq0QoqrjV4hrVRcSi1FNigQiBhRJG46fAwl4S489p4igIRJt3frUtxUFj6JpIq9SS1b8c9qRc/YFl2hHn3xz1j/+6sdiog0y7ZtZ9QU+2rITj4ijbujVB5gNNv6uiUmyW4ouPh6Z60srIsluEXEZR3E8tHBJVntbOkhgr2y3ZtKcXtpIwtmSNKN/sNONEGRDTQgT0ZhFN/jRjaJ0w3HxuD58f4FAt9LIX7IMRGuff11EEa7G9mXdTZcsXtZVrA9/ACwnsZIvvT63AAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(46,'1f643','upside-down face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAPFBMVEVHcEz/zEz/zEz/zU3+ykv/zUz/zEz/zEz/zEz/zEz/zEz/zEz/zE1mRQB1Ugfsu0ObcxrSpDaHYQ+yiCUwOyFuAAAADHRSTlMAs3Ae+wg77dNch5K/IJNjAAAB9UlEQVRYw7VYWXbDIAw0mNXBrPe/ax03dWoQBKg6n5HfRAsjkJalAaE3opRkTCpFNi2WGayUSJNBErqOsXBNTAVE834aKk0DcuukatOcVLSDRijTAfUp8fxhOvFoxrcq0w3VKKCQZgCyGp5mZghMV3jMMDQSD8gk2AwRK/K0SjMFmdWOw3VnIXlr991anwLssrqfJ/AcBr/f4AN4Mm8JgmjiXiBCVL/TVAbm/A7CuzK4X3ov3bF7BbZ06uoFvKhY2htIReV4zaGL51ks5xhz7lm+KhOtOPTiiSnLh0sRZnq5lGsjnL4kB9XapdOvACrl3ueZO2mqgvmmyv6FnOLIvjzch715Ux1hZ7+tQKpjdJ8EFmIE0l3eYBN94BnbpOyzusEym4CYa4xQq9xwiLaF4BCRReEQKTwiiUMkF4ZDxEAid1wdHlZ/zcKg0NzZKqwbsUgo2a/2FUcsUNXCT0sN/ZaDqDyQ10Xk+y3HgSwlcjV52285JFKK9n3x9FsO0QocIgE0tpnQJNRqZ5JNoHt2pvwUuI6mDuS6QLGNS4RUnrPDotWVV81wM+K1d9YgaPWhNefQn12ircfoUN9vP48HbutPD/bOUbJnhOgJjP/PUIM3ZuENfnijKN5wjDeu4y0Q8FYaeEsWxLUP4iIKbzWGuKybWB9+AYO7wUoxdjGfAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(47,'1f911','money-mouth face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAt1BMVEVMaXH/zEz/u1X/zEz/zEz/zEz/y0n/zEz9ykv/zEz/zEz/zEz/zE3/zEz/zEyNokP/zE3/0U//zE3/zEz/zU51mUL/y02urkfgv0v/zE1mRQD////2xEhwTgWkfB/drjuEXw/SpDbmtkC7kCrGmjCMZxOWbxd4VQnS4cqvhSTuvURhkkJpSQLm7uGIrnOUtoHhwUpjWhHx9u+tx55vnFVehDVhbiOiwJK/07N7pWNdkECysEasrkc8p5g+AAAAGXRSTlMAjQPSXzoH/v3usOJuG3P9SwzLuSP+gOS5uVZljAAAA+VJREFUeAGc0lUCxCAMBFDcobaVuf9F97fewDtAbMJeCK14kNE756MMXGnBGuQUPE58SLmuilGTxS07KUMuM6SIF34ZSGVE8fjgC+FaWoJA9l/H4RYklr+e6jeCbPw91+k9Knj9WMehilP3dZRFJXtbqSfUoVTSDg1cf8nLo4k/ZWdGNBqP/8T/nViFcuswEEw6k9plJtkyY5iTwv9/15OtXG1p1RfYgdBoc77VoW6y7xqPuRF4oKs4yNKcmDIeGXj6OQt0JqvXilM9viLGWGkgisX3PsRdE8G3+gOU4kAQ2mBQJr73wNTb3/yjKeZzViP3NXuG8vvM1ZR7MBsUDdkOXDmRMEJmNulcy4deZX8SB7o/csFcJiUXLxrR1bmMMe3rQP6lFQee1XaQII6rVy8XLypkpDwhEQ/pg0oU9D+MeKrrjoUaiyMJaJaKr4eZbwzeqkpdQyBm0tOlq4mQswpBaGC6FkSXyJ/kRvldT+qZYvhcilttCns7CWqj+rqfSl4zWZAEzjq9P1JWGBjDxI0rKnRUTxdfIAyt+og44bWtDCP5syBKPvACdIFH+NPfXfBSvade5ZzEaFEXfC3VT71sqByQ6vPMq19sg7ehQrsBI3hKKA8ZITHU8A4FGqrMY1UcP5U0eWjQ5qpjUt+NZbLQEVVXVdKD/h183P0ZEmHZZiIr+yNnc5mzETY+mmSK/qgivpnHukBnn4YrlP80POKFPA2XGCKnoasFbRId2kNGiRq0WhrhjKdlAoVfUy4pU66Vkp6W2CjOeJB5cRL6UV/AFehHfpgkpZcFnEkEWmJTve2xg+GpvtaSf8gIq9V6PZsNWYPhbLZerxghVJK/Xo7snO3wRVhJ0Ef6PbeVcgQFMtaJBJZL+aoQxVAg6QKQSUA0cZwFEJFBJD42ESEQFY4zB6IQmghoa0qNaDxyHGezVIk8aGuw0bKyNtGgcCQWbaLUxkYLTXLTFtHWIUwaosCFwk/NKDLtBBMMxWS8mP+a1NR+aEaxPbY9IhoLos+KcLtdEpFnG9tjc8Me5vLYZ2WRYGoAPVj3/yOEuzs3ciqq8eCXyIURYs9QQ7daMAmMJkS0Z6jBMYsODjbzmqrYGbVvzILBr3mYwWTUXKSB6mjkgVH0pe3hibBqVL972TdAwnB8J+UvNrVpWyK6Mw3HgF7L498k2khINhYWFfUX3zCu71sgTCnyCeP6iyksEPauNO4a9Rtf38FKY/+SZTqQ6hfySkrNphRfvSPWPj+Q2MhDF9dnxyyirDvKJLWjBe4sXETtX42RTU3k/9Bq7Phl3VQYRbibHrGsw/Xh+9vdi8Dd2/ue9eE/oA3HPeMncXQAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(48,'1f632','astonished face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAVFBMVEVHcEz/zEz+ykv/zEz/zEz/zEz/zEz/zEz/zEz/zkz/zU3/zE3/zEz/zE1mRQD1+Pp3VAhtSwPtvEPYqTmacxmEYA7Cli6sgyPq6ubKwq6PeEehkGgZy+hIAAAADXRSTlMA0fuMO7Nw7VwIHt7JHclJigAAArRJREFUWMOtWFmWgyAQBJeAJhhBXJK5/z0nroB2I/qov6Ape60GCPEg42lOnyxJ2JPmKc/IHZSPnIkdWP4or7EUPBcIcl6E0zyY8IClgVR+monqEUCTUREAehb4IhWB8PtXvkQwqCeBGRMXwFD3eCIuIeEIj3lFdbqWdbP/Z/Nb1J0yC9zLk3R1NaHeE63rXeJhytaHnawqP1FVyW796CFO5RLnpq02HsC17WG7PGS73BXUMUfqrgEjnzSdlo5R1K2npQ772ZRe+ZKl+tmwfqlMJ0Dzmp5e0Oos72r+oJ5/2WGixh7ZhJRQI41N1Or3OT5whBGmyb05TpsWFGxLrlShZa3kViCscAwaiWQT3iCjd0ulPRyDftbWzZVWM+8vJnHAbi0llDxsfe6Uo86rKZK1Cl0X+dQcxw8sbdKGrgtRmlDbzq8N1YStL+E+eqbXP+iw9cW3o7zWiI7UqL4ItrWZjU2QZNj63HA8DhEnwCC74dpPTIDdwo1g/6INTOgb6Rcv8hQxClI8CTRcL7fImH9Q46827W8qkItjGh3fhMUhYmCwb+BJaBwiSvI4RDlJ4xClUNO65dy3Urb92VjgkIw4hbP1l3/iZcSbf2X2MXBBW8Lmi7bN42fKQfF3deP7GYbPF1EPW/xL9Om0q/h7T/gzewYIJfH5NqrG973gCyujNSDRAhh1TA4r0SBhRbNGdoHkrTeOrc71SM4KZ1sDefYxRB9EG62dFmLSmPvBEA1okLaNFmKSPBJJr0HbZhSbkwYSVpDD9hiZh1ZxI2122LBDw8dGCwoIdITYp38HIP2vAj7UQIPV4FiQrESPWR7fjp4lmfcAaTetjQ7pjVMm7fLoMB7gcHwibNjhGDiue6WWZRcuEDziT8trVxrYODq9sol0yRLx2ifiRVS8q7GIl3U3rg//ARpu1hvjfBsWAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(49,'2639','frowning face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAPFBMVEVHcEz/zEz/zEz/zU3+ykv/zUz/zEz/zEz/zEz/zEz/zEz/zEz/zE1mRQB1Ugfsu0ObcxrSpDaHYQ+yiCUwOyFuAAAADHRSTlMAs3Ae+wg77dNch5K/IJNjAAAB8UlEQVRYw7VY25aDIAwERQMaQPD//3Wt3bq1BIqYndfonFxIGCJEAaOZpNagFGgtJzOKFvSdBPwAyK6/xjIYiRlIM9TTdIAFwFRJVabZqboKmlFjBfS3xA8zVmIuxtdrrIYuFHAEvADIhmcUXoIyGR68DMPEQzKNqoVIJXnqAZsAH7UbNDZCn8/TjM2YTwnCG3hPk75DpN/6HW/hmAUD3COCgcehw6W7Dh0upb3hF+cWT/2SsTw7JZnz3tkNjmDKWeTeHMnn0e6IWG/pqVQH+4tQb+moyJbX50u95RFbUjP3+tzVW4BqM3ug3rI1nOEhMmJCjtBwSnPdlOwt2+kEaSn/Nks0chzIjQjqG6FkAaHqW7NkUUIhC5QAHiK4N/e/VK2NSPIQSaJFmjC1qRlK34w8RKMo1l+FdTuB21l2yxpUsfqikO2w2BOWUMh1/p4N0SaIoXDX9kg3lSVBt+B+HZGxBWczcCETGSlnV1vAmhO3qYg4eB7F8l4p7x/lyzK9dE1H88T1Ix9+jTRTRwutfTK7lR5sq0tn9iG0Ti4pv9NkT9+TypPS7yxGN/dpb/6ozuNfZ+RxjP5bY4UYM/L4LNivjfH5f54QbI8avmcW38OP7ynK9zjme67zLRD4Vhp8SxbGtQ/jIopvNca4rGtYH/4A/J7BSicCCGQAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:09','2017-08-19 09:31:09',NULL),(50,'1f641','slightly frowning face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAOVBMVEVHcEz/zEz/zEz/zEz/zEz/zUz/zEz/zEz/zEz/zU3/zE1mRQB1UgfvvUSddhvOoTSIYxHhsj21iydtL4/0AAAACnRSTlMAs45500Yl7WcH/B9RdAAAAdRJREFUWMOtmO2yhCAIhrMsjPyq+7/YdZ12zynRVeP96dQzgIrAMBS0qFFICYggpRjVMvRoUSIQrgLRCluVwIyEWhswgAXBVIdapyImomqsmiVWSM6/zBmxUmPRqEVitWRhA2fABkHWvRkblSEpbJZisSdjUxeHIC3QB4Lb3q0SOyWv52nEbo0MAUrC1O/YzbkJH+l7mlZ4BoI1a5CxWluDtesqZ5DRW5A2teunSekd81uUr10/TUryvNtOubr18CLEy5Hw7ecHW7cetJCe6c8Pum799C19wbav6tZP34ADBFSIelwLQSISbEewQ5CIBNK+/e9kQlULzQfyHW0qg7RekXcuIUGtlzaCHqaQv/1HJnGBgM81yQOSfCDBAxJP3tjrFVE8IEWlkR4tA8/+A5lqu2JdLh2Ns16HK6+1t878eP7zQXJ+u8i7Uoiyvu03TETtec9yvrmNlCsUNmRVk+HQpE9dMzVwSJIaynXNpu3hdhN2y5jdHfZcNNlCK43SESlJZPfIOvKNRFKMhu8P8tiYI31n/1fa9/LY++zpM96Xugiugp2vhWBravjaLL7Gj68V5WuO+dp1vgEC30iDb8jye3pUPfbhG0QxjsYYh3WnXS3jwxf1oqLFuq3u0wAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(51,'1f616','confounded face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAARVBMVEVHcEz/zEz/zEz/zU3/zkz/zEz/zEz/zEz/zEz/zEz/zE1mRQDXqDhtSwJ3VAfnt0B6VgmFYA/LnzL2xEibcxqtgyLAlSybOu6PAAAACnRSTlMAz+MeCDuzf+9eEZ1H0wAAAvFJREFUWMO9WNkCoyAMrCfIfen/f+qqtJRw1XbdzZtURpLJpAmPR8OmBc1djwnBfTejZXr8YgOadwRoeEbDdyjjMpOKzct4HQb1pGE9ugiFMPlgGF2AmTpywfrpo1fkorX9Gzpy2boGgRMmXxiuureQL225CaeC9ANOEWkiP1kWpwH/BoQT7saMdyYUy9aUyNY6mE9ZHjJOqUgXBaU8Q0LNAMkdh6oCEOWyFabUMXlsoSbdYo5VkSJ1dcfMcR665qFdj3Vuas6NkDHrjtepK5H0/MlC5sbSgex6Hqd0nnAmyldbONIY6qGVm/Mw2fGDbdSb22QA60egDSboyzSrpyDT4bWQVV4pc0SuP87WzuaNv958Jch8ioNAIL3ZT7qwm4ZAZIhDzQRXu+fXNLZHU/G3YJbIs7+ywzd8BxCGMtud49qt5oN70qxOcw4qwQQKY+BNrVX+2apSznyQUAmoRl6gKwNCINYsRqIqV7+KfweuzUkFsZKZNXxVg2DJ9/pqmLRJLemrykw+ykI+l/TcF9mPPDSgqD3hi/yXFMALmyJwXtJQDsQcp20gyh3LT4RbxERBgoxmlGIYbBOI2eXLJGTGSsl2qQbqDAx2RL90gd6GSGRIDydj+ueMX8c+SZQ9vxj9W86RRET2mUZpc0kioEi0IsvlZgnQQG1LVEb2FmH7pgZtcZsx3VfY7iu11c6aKdghpc9pCzjUoslhN3Q+17gYHlXf7Jl2KuS2VfA586zWzj5zTr+en+nsGs3t2Dd6hVcVC7WulCHPJqIU7rP10zqUtrOsnc+lMKFyo8WEMH7LGZdjp28prYc3IultQ6OVHEm8nTh3ChsAt2KxRZVmVERhfbvkXXQFoK7WHvsyr20IctSa+qSA/dxUbdhNHFMN0+B01lQb9mSEMNGokCbiPlqYxgjRGGpSqbSHmtaY1RIrmf7d4HffKHrfcHzfuH7fBcJ9VxqXL1m66f9d+9x4EXXf1ZgncCld1i3DTzd/31wf/gFx+am0Hdu56AAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(52,'1f61e','disappointed face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAANlBMVEVHcEz/zEz/zEz/zE3/zUv/zEz/zEz/zEz/zEz/zExmRQCNZxPxwEV5VgmpgCHbrDrMnzK5jimqi+YDAAAACnRSTlMAWoz/DW6z7dM1yrkjrwAAAdtJREFUWMOtWMkWgyAMFIKArPr/P1urr1Z2lMyhB+FNh2yQTFMFC6FcSgEgpOSULNMbsJnvDCEEn9lDFsKhAE7YAzECKhC0k6pOc1DNHTSLhA7IluEZhU7Uz8ckdKMmahHwAKLIROAhSMFb8Bgzip6CpgVeYRmzc9niT/weRUEYTxRegyIYKDWTHCGSQxGUjSYmxogEwxF0SRoVdEkiMIwzU/g4ET9OBghgGKb+mZtjEH3PJjCIxGCa3RNuxiEiIwUkLCYZW6/aKqvXzHazlZZ4WkG8VSdssn9TvyWf1pKYaFV/uFCOvi35hCjyvld3aHPjscGSif0fMYe7le5ZOTAVDqa1c04r+19y+5ft+y17OBEd7fhb665NJuM67zKSRGhsn3VWii2xUuS1LfZUCV8PriERD2No7Q1lFxqJv08RE6UIwUpatDKCVtjwSi1a8Ue7jtAuyHoAHDVxL4qbaV/ZtUeEK1W57LtmrmXUH9a0XlolSVFNLDJdD62SJK1UvSqmjYRs2OeHrfEYzSacURmYVhdBuwRlXUdbLcQZPt6YXcX+48+AarUQGc/p9GZetW63kVhtFl7jh9eK4jXHeO167zyjZ6qBNdLAG7Igjn0QB1F4ozHEYd2L8eEHOcs/ChJ3fCwAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(53,'1f61f','worried face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAPFBMVEVHcEz/zUz/zEz/zEz/zEz/zEz/zEz/zEz/zEz/zEz/zEz/y03/zE1mRQB7VwrtvEKWcBjSpDW9kiqqgiLYYqV/AAAADHRSTlMAHoeRs1rQ6m48yZUZdYCKAAACIUlEQVRYw71Y25aDMAi0Norpkpv+/7+u1e2qgVzMYXfe5KTTBAYC6boM9NCrEQARYFT9oLsWPCa1MlwBanrcpBkUJqCGGzQTYAbQi9BsVFMFjR6xAlB0/BdW4pkP1QurMWYCqAFvIH28AW8ioYQJb2MS2U9iT5osCtaG3PcG4qcH9bM1xsbfjng8jh2V4WwokfFUBSUduvfvlpj5aqHKpA7a/t9cT+J5Jp07WNh4ZmaTxrv04WIFucUYziE7k1lcSk2niDkXln0549gPk/GzO5EB2VD4WWd4Z7yZ/LHgUNUUb8hyq2JVHItstKUBCZGdM2nxS2WjTFHnWFnrl9kVMizM3trzptWWHCiAR1v14OuJYoNjqfAy9u1skJILTfWUfYsbk2af6Nla+5ZwjIvCRwWhzr4LoKfGX/X6OvsbPedrS6Sbt+/eZm7oI1Hq7HstARki4IhajgYdyjgbOaKW8CN3tBZBsj5qSJGVaOQr6lqXXL0d8dUpFIHiUqQFfVs3wyWtliHSbGG7D0iU2gZfCxZ/setI4myq3M669VJds8Lnb9+BdDUxlkJ3cu1rku525zaHT9ZrpwU1PGkmKA0PEQ9fiK6DxFjwzwds2zTm22N0hoHj0+zAs2pDbOiepRFil0/Y29e12d0FxZTG0lDjaT8arC8ONa11Sf/d4Cc3isoNx3LjutwDAq/MlieN6keWUf/fs4/gQ5Tg05jgY93958NvblHCJceKDX4AAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(54,'1f624','face with steam from nose','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAvVBMVEVMaXH/zEzh6O3h6O3/zEz/zEz/zE320IH/zE3/zEzh6O3/zEz/zUzg6Oz/zEz/zE3/zEzj6O//zEz/zEz/zUzg5uzh6Ozh5+3/zE3r3rf/y03h6O3u3Kj379X/zE13VAlvTQW4jSn6x0qZchnzwUeqgSLInDHTpTb1+PpmRQDcrTvjs0DAlC319OuMZxPquUPm4cz46sODXw7n5t35247r7vC5q4rk5+XHvqqAZi790F6llG2RekqjkWr81GzFcp7nAAAAG3RSTlMAYNDyO/pxB+6zxeEeZdDMkxXUiVMpio2H3YAH5SzqAAADu0lEQVR4Aa2Yh3qrPAyGswize/9pZfbOTrrb+7+sP4JjDiiC05G3Cx7j77E+SdhNr4tR/0I/NzVF0cxz/aI/6v0Ea6xrQND0sfU9FbWvA4+i99Wvy4xN6ED7T/2ijAb/QBt/QWp0Dl/g/F/Gq6fwRU7VzlSdwJc5sTrC0uAbaK3hXSrwLZRLXqcPSCQSe+Xlc2hhnnsrOxERIP2O9YikZJYCQzpLSgQUMGsaKVATQjwfCL6XJE0hZc8nSwOQoUlEBg2y2lAkHSe5U2t5d/3UWSWInTbCssuYndR3a1XQrKdTIKSFlD2vuWzz1p02DIJ9Apy3cqt1FsoO7FOzST0GBgdnBg1dh+27v8GNgaXI0fxPYEUegWVcLUgDFleUk6WocIFFU+mCKCH67RcVhE6HQCBLUk1oA5eU40Uua5DFVGWPteHI2DziNKHsOR1ayTA2vMDIMmhFL5pDAeiKTVR/O7Co1ZRIiKj+t8tuHQ4AxqbBAdCwzQ7CCJN/CPq9C2quUzXCPCgtliPBvGoeh5p/S7wWWDieE6VRGBTvDVEfSVZBuBtyPBtHiNvHRIggukcqjntmMzQ7aWBH3SMVJs2+74ikYha6UOHms9pyHJ/mX2G2wGA2m3lBuL8dhYG3GwqY7VNBoUOgYGiHQEOzD4GJ6T8Ex53Nv5lON/S6tf0voJXXaRxP5Q1ev0Irt11Nu4x3k/E0hCemnVC87GraUXtg8Y7n5A/PeNce3Kj9xZatceqbFHrDu3XW/mJrcdt1HmPkRQq9xMhj4PJet738M1FO3Hp56ruun+beUyks2EWNW7aj0E4WMbKsW48sEjtkGsTiN0gnST7igk3De+SD23J1dstGHbGNCz6h4jMu2ApGqc8eIkKZ7Kocq5KUBRGyhwhqt0iS97hkSesTed/bvsf8QUsk9jomFkmTkLVNhDSVP/pFAkuIWCRNQh7JVjSmh9HN4ulpsZEzqEVoktSXz9LDaNFwr4tJweL1ISYWEZPih7/PYpuRA3sxhqy3+HtbWkRNKsfW8tkFwCn5F2IzoWwxhIZJKEPYnKi9BhYuiCoBAXUIC6tHGE72uYcG98wjQ6pzNOFopn/CcdSQOTMmLPdkQRzGWc1qXgeTUmMx4TFIXBxPUOOJDDLRGb8TMkjGvhwaZUiEvm42FSKhfTn9FIMze/DVghxwZquDSlw1iEPEJebBgVoryEFVXOq1fOBOA4J2J8eu1aqIB2eN7j8yhkPjqNC+uhkMh4Obq/Ljw+Py48Nj/PhQjl1fNecg/wNKxw6fmMRT4wAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(55,'1f622','crying face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAV1BMVEVHcEz/zExnruH/zEz/zEz/zEz/zUz6yVj/zEz/zEzIwoP/zExeretcre1drez/zE1mRQBdrex2Uwfru0OedxzSpDa+kiuEXw6Jtb+tvJ7crTtldGbhx2pdGAKCAAAAD3RSTlMAs/6H1EwlB+1r/pLbU5qefn3WAAACkUlEQVRYw61YWZaDIBAERZZsiLgkmbn/OYdER1kaAZ/1KaRe9Ua6G6E4GBU1JoRLyQnBtaAMHQAV2DC44FjQMhbWYBkBbvJ1McHlDnjNzqD5UokMqobIDJAmJecqM3HdFUWJzAbZCWDDZQF41LxGFiLCJGQxxCl6IpoO8QBMlB8j4l7sGJEHQdx88vJQj33XdoP/o8F87EftZWbcQePUftH5RN38fRqjbrING5frcSJzMsLGWRn0ntr1NmTaP6Y3kE1si9i43As8YXlvubKJ4iwQ1IfCIa5ZWO9L2gTNPL1Oxrx3mRZJjXs85GTP4DLNgcO2fzqdl4e6s/2Ev8VhBzeXZ2FaE4Tarv6cvPNr420TCcsykyXdUFJl9n3sJNEmu+86OHaxExM3GnMk5K74CYUe2KVKppITgepIjkAZFT+RNcKRtHVqIHlivB0+jTnPSPhQAkTrU9Hmnxgifg4RR/Ic0ySS5zhbAqYdCj8HnH0oIaGoHSoRgrA8o2hNQtbyFNRwV/R8lndKFOJRqpSJQg/bSxm8yrobhkJv/1YfIvVbQoSh1vH55SkzTth/RwsuasGlyEUosK36J6rWlgtor0LL/C7rpVa8rDI1XMmW1I3bxqMqvTVLnwrTezHzO3VLkFI/rYPo/7kIGy1bkJHkEkFV7zRaliRHUCCpHRODxNZlV2pXUqsTnXbj51BMUp+aIq5OUm94DvorQuthTihglIRGiMonUu6bPfWpEWIeagLL0nXCKTRmPUOiVOnCA1s5UQOPoqGL5sotG0WNplKi6Jh9KyKKj+voUeKjvQXCvSD8uysNdsu1LLVkuecJylj7eF56HV9EPVI82aux++qn6gIv63J3bOz+uFXV7XFnRevDP/9T9+BeNvDdAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(56,'1f62d','loudly crying face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAwFBMVEVMaXFcrOz/zUz/zEz/zlD/zEz/zEz/y0z9ykv/zExdrOxdrez/zEz/zE1crOxaruv/zEz/zExcrez/zExjreb/zEz/zE3/zExcretdre3/zEz/y0z/y02wvpjYxHJeq+5mRQD/zE14VQhyTgeOaBSqgSKfeBxqSAHJnTHvvkWziSfhWWrjtD/TpTa6jypflLPZqzlsSgPCli7JVVVdrexghZHZWGWrUDx+SRXPw3vnWnBjbFlkVSaBXA15stFor+L//X3EAAAAIHRSTlMAsR6OCD1h/vzvkufSb88ZU3Zx3vjpzbpjSLGzrjfULuxoyc4AAANMSURBVHgBrZeFduM6EIaVGiSFykwzZjsMXd677/9WNwpaY4jt4+9Ak/zqJzQMK8OyjZf+rRRC3vZfDNtiTbgYvEokyJfBBauFaT9yzIU/2mZ1zeAeS7i/rqYyryWeQVZRWX2swK11bjgGx0pwo3RQFw9YmYeSDbQk1kAWTu9KYC3EFcvF5lgTbueOh2NteM6YLIENEFZmvyQ2QpK9Mx+wIQ/6eTKwMYa2QBwpE8eZVPkNeXqZ+kgZLwAcJDgAizFS+qfJXWc9LuSLwM2aBseVlrkeiJAQQa5JmkUDmm89Pmbwt6Y5Eq73A7pHDT4FRcAxAw9UEk5JdG8yhY0asad7NLgPCo9Mz2aKR0whpgtQTJGiDXcxFZjiUXkueKpZ5IDCnWAhExcUTpT+P3WhDE6jif7CFi9GSnbu4EyFdgJeSVfgLjmWwpcukIG/bUTydNwUoR/jWWI/BEgfWcmYhWlRGIyxEuMgTIvQYnb6kkxirEycpC9hO3MDEfOpH3ieFySTGKtnBnvRWkZeCCe8paiWqdXu60eE4E4qZIoHdktuEwSnQqa4ZZKK/vz++prNZsvgb1bkBFOVff3+Q0X3TOi3Un+23qG22Ff7ksrU0djHs1SmEEqksd6DlPJcMNmO6J7dtiO6Zf12RA/spR3RGzPaERnMPtdw7rmuNz8nsplVLuI+bPF5uchiTJaKfNjjl4okY+ylTBTBkahMpG61gxKRcOGIK0pEA/I4og0TSJHQnDyO2GOhiDuQwuGFokemsAtFc9CYF4ps/SUiI/IB3O+rb6PRt9V3FyAhOX2JYNdFIg9+jH7tGf0AT8v1pdaGlBE5sPp1ZAUOzemLFrsuEC1gdBKNYFEgGtCX0Yaivklfj5tNjVsshZErCvTFDnJFBikh8kRjbfvDcZ7owcwramjDZQhHwiXJSVFDyizSME48xw1D1/GSOC8XVl7hV/9Wy6/yS9G6Im6XFMc1ROKqrFyvLpIWK+T94+d6z38b/inWW7Yf1W+H/OfHO8ty+XzT7Qx765r0hp3uzfPlQXLTIYbavs7NRtZdt0K3PVFrU9sv9lPTxX5Si53h8vP56emm2+10OsPhsNe7u7s7bP/mY6+3+XETdbs3T0/Pn7rgf5f9a19plwlHAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(57,'1f626','frowning face with open mouth','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAPFBMVEVHcEz/zEz/zE3/zEz/zEz/zUz/zEz/zEz/zEz/zU3/zEz/zE1mRQDvvUSgeBxzUAaHYhDKnTJrSQJ6Vwp5WGeZAAAAC3RSTlMAjK+500YlaO0HsuAIR2QAAAHNSURBVFjDrVhbkoQgDPSBEI289P53Xcod3XUICJj+8GPCdHUChCRdl4FU/SAEIIIQQ69k1wKplsBwByy1ZLMaMYFRzRU0gBlAP3PQHFQlqiaBBRDTk5weC5H3Twoshshs4ARYAUi6N2ElEkwKq6FY9CQ0NfEQTBLaiOBr72aBjRD389RjM3qGAMVhEm+I/jmn8BWu0zTDOyKYeQRdkt4KuiS9FnRKGt8TjcflQAZIHs9+fVvin7Wx1mjqDynLEIjiPdN2DbDE+qQFyBC59YCrsUgiRH79wJdbQpDiBGLO5abcEpJJHOv9XL6XW0K04wyyncu3cgsKPiLgcQ065Ak2EkRN2w+Ea00HEqi833BFyF1rubSBaEEWDG/e2PsVUTxEiifTHrkWOHiATrUtsWZM/vkgae/stlnn9eNzlH0gzZU5qIt6fyAzvmm3/mFz+uHJThYRel9v2PVDXZOS5NYvuIdKKyHJrBF8vtCiJektJtp0vpEgq2xCEL11/yttqjwOkbbGe62DivDx3lgq6391EUQycS7O2c49FOx8LQRbU8PXZvE1fnytKF9zzNeu8w0Q+EYafEMWxrEP3yCKcTT2GdYN8bBuaJv8zTXjwx8UfbKTfnfRRAAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(58,'1f627','anguished face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAARVBMVEVHcEz/zEz/zEz/zUz/zkz/zEz/zEz/zEz/zEz/zEz/zEz/zEz/zE1mRQBuTAPvvUR3UwicdBq6jynTpTaFYA58WAvisz2GWJLUAAAADHRSTlMAs/keCDtx7NJckonbkFXpAAACUklEQVRYw7VYWYKsIAwUN7CFsKn3P+qzbRfQgOjw6m+MU53dJEURQdP1hDFalpQx0ndN8QZVSyg/gZK2esZSd4QHQLo6naalPALaJlLFaX5UCTQN4wlgd46vPzwRn6h9FePJYJEANpQ/AA2a15X8EcouwMMfo8vEgzI1rl2T0SMoe/43q2DUZnKtu/ipcvxsRrFAnYnU7/loHI+fYlcfcTcgRJxICDiomJ9Pex5Og9h5ENN24bAb+PEcdFIHfE/43ls13pVy3bQZZlbFZSxS8vdroDfjnHpfH+mFR8u7oMv1xfXPvRfU1OEBm5I/FhzraO0rZBcPT2mZOCmHqfUV+opApua0hCNBVpW6I0tgSq+OCY5M+1UK2bNE2Sd15rxPluLgGVA5sf8TWscyL08A8GwKSb62UTwgQkmeLqFOmR1Y63Z4ImmQxmi3CrfpkjkB+sszvb2u0yW8R3y9N50xXTJ7+/pJ3DskpEvmXkKzEJUUIXplGi3KPM4uEaJX4S8R014lJOYjLlWwRIISWjCeo2hLVhCeBQQpkVfo300z2HzT5CFqsMb2AhRvtW98nbH5xz9H0mgFoHR8QFk+R1HbNCBDGm5ZbJyVx/j2rTB5M9zWobhJJTyoENM214TcPYgThoirIyoZcYGJKhRQScKVCB+f2usweqMQrhLDxmMH8/g/p4+dFiXkZOeEwrq+Px4XyOKoh2vPHjSySoZWiIc4rRDeUvOo7KvompW+RDb/b/HLt4rmW47zrev5Dgj5Thr5jiwZzz4ZD1H5TmMZj3Uvzof/AOnjw6HfSvF9AAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(59,'1f628','fearful face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAwFBMVEVMaXH/zE3/zEz/zEz/zEzH2trg15/0zW/B2eP/y0z/zE3W1rT8zFjZ1qzc1qT/zEzS177b1afU1rfN2cz/zE3U2Ln/zE3Q2MPM2c3L2dDa1av/y0z/zEz/y02cdBqFYA/wvkV6VwrpuUJ0UQe0iifRozWQahX1xEjVpzi93fTA2+lqSgWbopWuw8p0XSa/3fD0z2v7zlhmRQCVloKpuryBdExvVhtvTwqksa2NiW3r0YD/zE3R2cTg1JuHflzY1rDesosxAAAAHnRSTlMAbjtZ7vcRB/78zp0dcjqMx4mu5+K0r9Lo7V64urIaIMT/AAADTUlEQVR4Aa3Uh5KyQAwH8NDB3r1uvbKLCnbP6Of7v9V3YEaQsoLj7/plJ/NPKCBgvBRrTc3kjsNNrVkrvhhwh0rjibMI3mxUIBe9+MySOc9FPXubhskEeK0EWRhtzm7g7QzbKmssA618a6ouy6grXFVFY5lpFcFYnOXAU8erOywXpw6Jiiy34iPy+BIylcN9psv1zN7sWMRuY8/Wy2l4utieKsGe+WS28G1YxGbhm01ChyPXTtcYcZbbxSK1EdkuHUY0HcK6jKz8NL6k0S7F2YqR7tWCGJnYC4+9nkw5S8CnkzUdmTASWpNBgzm/FNxkAiYN/+vQcAYQaLOzfwvPP5PdYP6eD7KzBhCdpvDL9o5lsLP9TDSvfh1o4m94yjKZ+nunPbUpkBlc3O2UZTTdBjeIqV+eMWpkr1iAH07HvevO54jzuevuj6cDZ4GVfWlEz9zz5S4J7hzztHcxgbs/mSx+/tl/OFiUeXRRwKVeIU4FABrs2mGPN+0PjITugKer1icvTP9ju/3oY1xQcU8srAlg8HAaf6bhaPFnNMSYcMUNp+IGvIR2Q0P1Fr4eRkQr+9CuXqAYxJmj73NBPjEiWpkHoYpQY2fOEcnHgnwgSa8cHXZWgyYNGVyrwYIMkAgqe+rUBO3cx8ULe0FsJKKKy5lHA5P63NsIXT+TCV5Dh+bKPVowHQfvO+0597LJ0cviNToILnKmysFrxJkTLCjfDRleEwczMljWRyQynAkan6c/mlkrc0eD5gkf4NSEmosP4Nagjg9RBxkfQgZQ8QFUAHjHB+gAgIQPIAFAyUKB/vhrZNujr3EfBawS/HkTHBgHb46xhalewaNgmmFvEdIbYhoFPEYrbazB4sogbbyWAT4pZa7eIqJnpa7aZ6iYZLyIGWMS1QAQROrbixi7nxKIGAVxIHGkggEXMsb9bXr0Mf4Zfn8jfn8Pf8YfI3rrR8gQUsWYr178nd37wpgqkOhwIqLBSEnFu6gliJAtvIMlQ4xyRydLgQRS7k6WBOS+TII8RFZz7VmGVKUCZlYogYBRxYyqBojJmUIVZLjJkNSb25GCOOJWLWGbqg5ZGcqrhYmsV8WAXEpSR41l6UgluIesVDuFlmpZaqvQqSrCBf8HnE4o9GWoYdcAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(60,'1f629','weary face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAWlBMVEVHcEz/zEz/zEz/zU3/zkz/zEz/zE3/zEz9yUv/zEz/zEz/zE3/zEz/zEz/zE1mRQD///9zUQnwv0WZcRm9kivRozXerjyrgiJ+XhmIYhDu6uHOxK2Wfk6vnnnSCMbHAAAADnRSTlMAjEAeCNBw7fxcsN65MxotJOMAAAMdSURBVFjDrVjr1qogENXMRCuJu7fe/zWPoKbAQHwd9x9dyuw1dwayLIJnnTflvUKoupdNXj+zX1Dcmqp1UDW34m8s1/rRBvCor+k0t6qNoMoTqeI0huqWQHMp2wSUl29W5baAIEQcnzvi9hWOOpRgTPSLflJHqUgAL653GN6JMHM9FTSvRs5SMYtjrt+4fnOMa1Ed4HE9KrUenWFHndZNuivqJB7tIIxXYanfXTeBTBcE6bMY9jHO0wl5fipcPxtBrPYPClvEm8ed2F2duMveiB0DhZj51DtKlXY+2XkoFpmjPrtOmNnRyy0H2dm8CLi5HPpzdJNl2LqaeSFqEV1VJZZxh3pvPaJewtUqeo+o/fSCa+UWqpLhwpfKLeDqCir0A26gQk569yYFlIo2uitcG3Z6d/o5O41Gli2V8girw7Zkml1MOAoufJjiCGqzxFrslRaOQeG7WjLFheCKrenULRm0pWKvOOeqd6tXu7uBinWHiH7e0MxEUHvd8Snb3vrsNYF5f/fsVQeB/uNg2oX1mfGEgr/V5qwPckKIQ+VTOw1kLU5utg/mCAgdAMIEFLbc9fWuAJiANJRLTVa2p6DM7ucQ3bPqHKIqQ+cQofOIEkxDKMW0qLMlZz1ZipVxGXd2OPxUdXahdopGwt/EmpoHRoMJmcNuUTgABTsshzu2XI0i0zgOw+s1DOM4bZ1Owl37Ce2Ci8g0viyMU6iJ6DYCxH/phtPw8jBMYFszjc339tLoxxeIkYA6NcA+a4a8bngFMHSHgdBq/gUwOYZ5ViZ3miz8DdL0Rs0zjO/3NHWE6LZISDdN7/dofvhD98Pfso1h7/HdhfKom396xtX+EMFwIhgw1xzcTXEyqD9pHVTi6UTcH7QOKrF0IuaPfodhlKQTEWAY3cdj/AdA4/GnmfygUQ4eIXpQBKTvwSPEdqj5RG1u0vPAJem2RyNKpR6/emJHrSoCxyw+FwPjIjJ5UsHZXDg8cMyKD7dfxtn/Z6oTD8ffNs46+bge31wv6RcI0Ymo+MuVRhhfr2xOumQ58drnxIuo867GTrys++H68B+nuulpIl0qTAAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(61,'1f92f','⊛ exploding head','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAulBMVEVMaXH/zEz/zEz/zEz/y0zqWG7qWW3/zEz5rFPqWG31ok3oVWv9wUHqWG7/zEz3xEf/zEz/zEz/zEz/zEzqWG3TKkL0kA3zjQzhSzb0kw7qWG3TLjzKIz3IJDzyjgz/zE1mRQB0UQfFmC+OaBO2jChvTQTUpTf9v0b2pkrMnzOfdxzcrTvrczXudIfzo7LwhZf0q7rqWW70kAzaL0f2mBTrYnbJIjzzl6jeQ0niSmHlWC/SKUL5qijkVkhrZX7oAAAAH3RSTlMAaVOP/MFP8hj1Bogl7s/+edu4ya/Wqon8aKo9pnFUgvBnvgAAAqpJREFUeF6kk9tSwyAURZnpgCGE8cWmTar+weGSe1v9/9/yGFDQ6Sgla/KQF9bsvRnIXzDKOWVkM8KuiK0eZj1bM1HroVmCsM4q0UppLqUo8/YS1qMNolFIM/Zy68BszAzKIMoG7ktFXRTkp+jOVAw9YCIU7uSbrn+cP1Vp+wDMQeJS6WgxRBYJ+4zK/MbXi4q2CftokyCS/4r4TVFcLVkUhr49dnI1C0pBHAusgztH8tgOf3EaYLQe4Z5JK2VbpD8PuVacLXJ2nqXIeLCUYbIRYPVMParO/Z7kwXAS5/E8k0wKQTkGmb54IfmcpsD1RPIp8fwnPX79gWxg33+zZIvKum4i0bHJFVVd1x0jUf16qPJuDUWXILqgt8nR7B6GYUDR8u5Fb0P3uCvu1HzUXi47CgJBFB2aTooQgzw+4PIU0Nm5MUb//7dmZExHpmmrauFZkV6c1IumSCMCbuN4PV8s/kzfuN0AylNVeTIAGC2u5wkYL/fx/nhYyBSFMoQFi2lajCOmu8UTMlJPZLGFM9lI6AGLyGQsWKwR1JkggNiKpxlEZNwU5BCSM/NMEELvZzyGmFgaUNs0LRz+CSWyETrUvxwA70Q0TBUc3UPUAeGT6k1mcGB4iBq8OwnnZnQiw/SMTY3vWwlNsVEGRQUgbz9QBEUEFRQUWaiwHxB9KrUCW5za9oQtCkn7HXOzzOEMn1JzifT1k15zkRjP09aO1hMZ9qV17IfaMezxj4S5RrzEAslVim9j9yrqsCZS3P3Nq6gJ3v583+oVop65kJiIuIAcubRGOfvJlnUtS/klQjJHtFOuNf12QNaoF61j/eTIjBC7+vVLdsMqnkizjDr2c9/Pq/oY1XocJNtpF/ZNKE/1vxDwoDj50pNEFVZUkdOoXSYuC7KWijI27y0/EeNDCNc1ah0AAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(62,'1f62c','grimacing face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAPFBMVEVHcEz/zEz/zEz/zUz+y0v/zEz/zEz/zEz/zEz/zEz/zE1mRQD1+PqAXRKieh5vTQTrukLt7uvQozXGvalasRxXAAAACnRSTlMAs44d+3E77dNct84ZIwAAAdxJREFUWMO1WO2igyAIneUHamat93/XW91qZtrQ2Pm12DpT4QDyet1A6oYBKM4VAGu0fNWgFUyZCIqJtpBGM5MB0wU0QpkbKEFCg6aSYBCArwffGCSae1eBQQNuHCiVKYDKbk9zUwSeiQRtiqGJeJJMktcQ8cs5tcpUQcW+A1MJqIzDL5EpzQNIio1FmxPmET65QD0jUvkFDb33/WCwdpFb0ODtDD9g7SqnDWdXOKx9U8olz7/thjfOPleEVRwX/n5/ocfZZ7TJo3b7Cw5n3477WsHsAZx929s1iPz+e4+z//stIbOKrc2CSyTGisOeAyCRQMrdvySTVLdQHJDLaacySKlE1lySTEWFol2JHqaQj/85DRGnIyLbGtAQAR0Ri/zrvEXAuygK2EkivLcF6PlJIoFoubNFcDwUrUyoGwnfn+r24f9h/Zdp7LrlQ3cg9TRO6+qHsCCxcEFuzL0aP40uTEwsTP7LN1OHJeqmMKGIsBwtfh/xRGOYvNuwQD4gYqeS/WBr+tRE1B+2Orc19e4XUaNVGpDxgj4RUCYRv0tEXJvRKtFCqj2uSSPyFw17fafN4VeXGrJrFt3Fj+4qSnc5pruu0w0Q6EYahEMWurEP4SCKcDRGOKwrHx/+AYgbpXsdDQNoAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(63,'1f630','anxious face with sweat','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAt1BMVEVMaXH/zEzU17jZ1avM2c3C2+fqz3yis63izY7G2tzR2MD9yUv/zEz/zE1crexdrezc1qT/y0z/zE3X17LW1rX/zE1drOz/zEzc1aRcrez/zExcrOtdrex3VAicdBrwv0WFYA/RpDbpuUJqsN+GtcSuvZ23jSjIwoOvhSSQahW93fRmRQC+3O61ztxvVht+bkL0z2t2YS2copWLhmj4zFeswMWWmYbq0HttTAX/zE3Z1q7R2cTj1JadGkzpAAAAHHRSTlMA67Fq6f4Z/gn4y/tcbt1SOjnPlaCvpoqEhbjJ7wSd4gAAA3ZJREFUeAGllIViIzsMRRUYDjNz09Z2mOH/v+tNPPE6o8H6naU2cs9eyQAxmLmGnbcsjTHNsvJ2I2eCApVsnhGEls9W4E/o9TyJIF8302uyGolBs3VIgxmmQapsilQ5i6TAyiXFsUlK7NhQFYukxqrEtMXIH9Ai2+sgTxKsDqE0yJ9phOYhCtST52Os1wYhSZ+xDiAqyMPWlK6xyP3sukITR3tn4n3f03AR3eBTYPpE+ByuXj9zIEF78FPbNyDs2VHeBWbDTWgKuejGTmvqckYWEZRuVlHNZf2rD5SiYaD/4nrwqbLCo2tiq1Yn47CjnoeRKBMvn08rsULT/YGMNZWgQUhWG7lobfgimZrYXLwinP1arvNFqhMk2u0ZLz/uz8t2ezzebsfjdnt53h+aN4HzToh8NyVP/rV2XW8O+9VLcn9ubyFsn3cuO503u6sMnueXg2C0O5IgmevCVPDeuzwut0QuD+In++5MwsOMR9fraBwikJXtnXySF3sm0vCeZkPqMpwhCapsP1Np5uc1095NTShngjW4ctE+L1xDxjl69Sl9M8UeXDnKUA35gDzF8pFYPsKiYOUpLoAtZs3kXg3F8iHyhFUuTEzb8sazlcuvYvkVeUIrW29Qlidi0pNeJEzME3HhJb6B+MqFtwRMzllh2Jznq6eX6BG/ycmVx0uk+QeU/kD6x6SBhRpLd0UQ99eusWP01UxbOTIL8vf314uFMCpwz4P9ntBiMFioi7Y2dG6cr4HLl7qpA1XvUA04F2VRFSDjNcZRbi4DAE333+/Bm29FUdMVFd0dmwvRXHHniq5I55MW4HmPl7/D63X4uxzHinRw6clAOJLzI1+OHyfa04MXBRkIRZpN6AeTWaSowEW6CIQjjYfUxzCqvYzJRV3hQJGcCUVMnKhRc0p+0VyUlzTAMi5QWRjQWRpfg6LrOCZQC3nE8f6hIfyEeGpeIHMQ4Che+uFoOZ2NHXdc49l0OXp9EnrNUGeot99J8M2e/AY9bUCdSYxbArgxTh9Z/vgGZHQAvPn4AKTBqYJgoCBCd0M1Efb8/2E7whO//YlkquCjpNhZTQc/ZbVAbRMwXYUJ1VBbIaauWcwkTqcI4ZT/zalUBoAEVQZ35VO1Sq6lVQYPs9CLfOcLWJOAXmwGcmWaRR1UqBbazVot4ziZWq3ZLlQhhv8Ab0gEGf/HRv0AAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(64,'1f631','face screaming in fear','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAvVBMVEVMaXH8rkD/zEz9ukbwtWDC2+XH2trzw3D0y2r9tUT8r0HM2c3/zEza16n8r0H8qz/Z1az/uUf/zE3/wUj3sEzR2MH/zEz/zEz9uET8sULU17r8sELW1rXU1rf/zE3/zEzX1rDW1rL/zEz/zEz+y0zexZb8q0BmRQCthCO93fTA3O3/zE330GbU6ff/zlT74qT1+Pr47tL29e/r0oHs9PrH4vb457ng7vhtTAPg1Z392X7OoDScdRvP2ch8WAv+V2ahAAAAJnRSTlMAxuVS/f33CRNAa+loPfCeayCyLvzN75KegLTgoa7P2IyXycT99aWbdigAAAOzSURBVHhepJbbjoIwFEV5aYtpSHghkxBIJPGlLVfv1/n/zxrBOSl2Ywed9ah1nbN3xRh4EHGWSM70HcZlksUi+IAol1o5aJlH71nCQqoXyCKcr8mZ8sDSeSqRggZVM9qKuZoBj/9KlaiZJN6lIq5mwyNPLK3eQL+MtwSPH72c9mTqbbLJfdQHLH39/K+nSKuP0M7dCefed1VV7UjgfZmLJ1HyrNm2PQfXc2h7ts+q5KkgOE8fAT1OiDGY9ZBpLCKPNUG4FDxEZT0VWcCUkydk4wDtmK27EDEOzUJYCM63OxyAoVNYiAJgNnwDVypwIcu+LOs7ZblvPSsVg0hiQ5a9+WUkwpZk74kUJvOLMJvqH5Qc7n5MQ6LG8eA3QEJFPhGWRNmEVpbb2hWdSXR2Reubsmgxfsz0xsDpmkQ1zDAbPX7gMrtOacwau37V9tqY0i6V2R+Qk7nTYbJX2brefrI/JpJi0Vg4THRTy1I8GXDy2LGwkOc9MvGADZ4SK6W7d1qCaygHE3uINoZoIJil7iaHbB4iTT1DE11twARDqHEdaJZGIlx8rdzDzeBZXa7fx+P39bIaTI07ZPW1CEWUMx3Qn4qfRsu1tVEgCqBHp6xjcBU1+EBIILE3hV0o7afSlPz/n7UEV53rpHTOV+XMfcydmfqwFPXt/f3tdara9Xb5z+06VeT1/nVpwqGenzE870XyLgF7+uPxcnF48b+fLSRdLrJ/5knu5CnY+LHne9PRQprLnSf2MmEgHbXnetlw1Z6xBiMT+0UkNbT6v9tWdNMrtVDLIhpmUQ628QP6PqTGQj6LBiKZ6TYhffmiL1fUQyczEYUsWKwb+80X3dzMLVYWCnbihlQ5og9f9OGIKjcg2WFkBYwjujzAERmQlZRSXG3ShIrGhF5W3MKLDFCFiioYZCEHIllJyEJFGYmsREChcitDRaXbJimAnRY3YaJGp7IDUlGpnsNEZ8hV01Btk4Q2TNSSiG6aNhuyMFGG0Zmgc+1Iw0Qpna7tpm0RZZioVOsXnmjAhokSBlnpAeh1smPI0I6Qe6KdOEAccozEIHobAUaLjiEH21F33wCQ6g1xCjlqT3r7pb6o5BBy+B+ofxDVHEOuoyPpD6KUOOSCjB+JjE4tDrmyY52a8dtfLuPvPyIczpR++3s9/mRLTPpZsxJn6Pb33ogIQKJUHnGWAIhD4U3/wISpxseWsTJMDHr6NzFGzNisaraWpsosM5GuCKQ6Rpc6a6tD3IxjEx+qNqtxKXT//wFdL7R5Y7JJFQAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(65,'1f633','flushed face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAY1BMVEVHcEz/zUz/zEz/zEz/zEz8yUv/zEz/zEz/zEz/yk3/zEz/zE3/eJL1+PpmRQD479T29fH/q2j/ioN4VQluTQj+0Vz74JjRozXKwq+Kcj+yiCbjtD+qm3j7sL343OSZcRnam0f2dDhSAAAAC3RSTlMAJYuw1PtGaO0GuUa/dYoAAALISURBVFjDtVhXoqsgEI0VDBrFmuhV97/Lp4A0QTHxnU9mOEyjDI+HHYkH/CAMYRTBMAx84CWPL+CBACINMADeNZYEPJEFT5BcoIHoANBP7qAhVC5WxSFyQBifmeMjRxz754XIGeFBAmOILgBa3YsjdAmRhQkIlaGfq7rq9JndMjj3gxgARnv4Qn31Iqh0om2856bHB3719et1TPR61b3VO4/FeeDKL5NrQsgchFruEpb3jq04d4Mx8tHQzcxitkyo1pPPosMMP0xfxJxn7vmGQFOe+bQK2ILzPuCh4Kk7lxLqamGT5BwQ8akGt2KkSenUakogT249uJb1UPMCgYkSaULUuW+QTlQaUAxaqqTqrmw1oc9MAppC0+Z5UeR52yBXCTXpqSkXGUGRFa2jBD3J5lC180xC3rhIFni6Z02RKSiac8nmWyAP5JmG/FyyIhA5I2izHdozyZY3z+DY+1PXn7fsgl3CgwT2Bv3Rc+JPWtgu4UHydxF6b4fXW8TCLtmuOSXWVP2zqX90IpOER1u+Emkg+Jld01AcS7br8j4ieI9r8BHdE+xIIsLleC39Y4klIshp0jS9VpDLBE4Ft2DjdMV4ZYuMZApWs0Z50nSybc1mt2knNgUzokDm4c45HCN8CqYFSbZIyUdVm+wH2yRmlHSLAMWgNU58af1AbYVklGdgsmk91SBCNU1Hh/80jap+SY6R9WDTiLi9Jph11wtpiXZqgI3IrBvQw/93IkCvo99d8+gF+TPRk13ZeC/ENiKjLtgeEaWzQciku71rDCZhOxG2GURMws48aK/LH1prBWBnnr0uUF7ZmPte4rMnlqorv7RjKl7k5TmNrhvvH+zWhsHaVOgPdt5CGFsYicnQSCbmpuYqEfTO20cX10xNZIy+QHzSiroC/N/m+L52/b4PhPu+NO77ZLnx2+e+j6gbv8Zu/Kz74vvwH958xWPiap/OAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:10','2017-08-19 09:31:10',NULL),(66,'1f92a','⊛ crazy face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAvVBMVEVMaXH/wFX/zEz/zEz/zEz/zEz/zEz/zEz/zEz/y0z/zU3/zE3/zE3/zUv/zEz/y03/zEv/zE3/zE3/zEz/zlT82oT74Z765Kv56b373pP91nT47tD1+Pr29vL+0WD28+bt8PLGw7mdoaTc1snX291OVFcpLzNxdnpaX2OLj5Pn5uJARUmpgCFvTglmRQCTbRbHmzHisj66jyqAWw3WpzfxwEa1pYTFuJ6lkmmEajL////9/PuVf092WBvNoDOjVtlMAAAAFHRSTlMABDNhjbDS4u78HnD/CbmAPUPLVQ64Q4EAAAOCSURBVHgBrNUFkuswDABQh+1GWwxuDGW8//3+RPljB72lN1hSBZZDLBzX84MwoozRKAx8z3XIG2ZxQKGHBvGMvOTHmzMYxebez/Nh4ggs6OK5UE5M4Q80fqJbyxCeEK7+qsqHJ/nW+mZreNraMsAVhRfQyfI2DOySNMuLvPyFBtuQUR4Dq7Ti/4lCNpG8N/L51WFQIadyWtnjpIJ3KSyQDfo0o2CT8QGBkWhvdj/2uad8hMDq1t3z5IONFHxMBTW/sxdgVfBxJdSWRHNC+8D4BJXg3pkNjsEq51NSqMW607R3fouqKtJEv6G4tt3tD9wooEZ/RhNKFUeqhIbk2vF0Pp8vW1MbtFP6iSZOTD5o0fVcu3ENUNSk5E2emLL31v2MTlyTgJpNmYORYF376/W21UeuNJWd0WMQaI7LwUDDHwks4FRHynpJPjDQhWsJIDbrt7qo8znrTlS9Hu0wobvZEgDT7gBaKuwoeuipiNbYbpfbtjt+FBDi0H6gUzcQpmnZEUQd4g626nbWnajM2Kb3H7lm+LrZ24fuRGbyHJOD5hF/eGHcL4/H5Y7/aN1akYDmk8ByFeb2tU3BCEg4ffcU9hspg5aQRNCTiWEHICmmJ4YiQqFPZpVSVS6hoxQjDxGDEgZPkrkwYcoEuthzgcyNp+pkMZt+IArfwKhp9meiwfjZP8arYkuCEAauu+91nVu/BG0BWv7/s3acIbRQI6dKYdGssyasK+KQt4AcBUh1OymhJAjkCDHjkoSI5nsYAVqWqlrh4WH9r0qpQZgDQcedIAlaw7NhIsNzkkYwXwgjwzOS2NaMurFuTsHZpqZCN6ck1Zo1o/C+LVhT2865HnFtjNg719m6YUXrfYH0aJc0+Yu1VV/4WRT9miWO7e535Yi8GrI5HdYnr3Z7Rwtkxbewn1Myn/WOUh2ZPaUlW+xoffM5KtOst5Oc7D1tIlR4XsuSQ9ngHmpnEJoIct3AA/qu/mXfn6uNfLPfuut5ANCrThqt2yznNuGGQqNFtqQww6tVuqG0GR2WhYYog5yS9jhfSUb0l+mGvcTZc5UkgcyMEJXJuuc13k7nhxo9sSnUpJ7dJdM1Sa4VjEghVCTxvmYMfpUmBzSayJDBb2YUrQYQBjlHI2CgKukomj0cZ+3nf2R01wWoOoBA+ZAGI3UGWQSoPexD+UAU5UNjwrx0GayjfPgQALbsaX+bRUT6AAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:11','2017-08-19 09:31:11',NULL),(67,'1f635','dizzy face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAP1BMVEVHcEz/zEz/zU3/zEz/zEz/zEz/zEz/zEz/zEz/zkz/zEz/zExmRQD/zE15VQnJnDHTpTbpuUFuTAOqgSGRahXuIYNZAAAADHRSTlMAsx7jzztx71wIkok45xS2AAACaElEQVRYw71YV5KFIBAUQQEl6/3Pum+fJJXoWtufiF2TmZlhKGAiK0AQc44hAiuZhicYZ/BhOAODeexjoQTwDACh7TQz5AXguZFqxrwCPDfQTIg3ANUMTxfeiKWo34h4M1DBgRPmHcBZ9QjvBKny6G0XRqjrj+pzuEtdYfI8Wgr2hbgSuXNZYprcN2kYKxMxZjzVzU4jdtIzz5NQLXy0CuKL76j1u2RfeczJEjG03K3EVih0jicbh9sh+Fb0ld4OKntrSRjo4Nl01e9bzBSbCYXPRrVEkDKBCUX5bu0TGbEGLYKdfC2g2DvX6Nao1sYHCKYngX6J2vQK2tlIsyJR6KJEqJ5MC/chfZaruewFfycC3+TIixwrmz51GIOpz6kpXTyI8qnDnNLMRYhkV6L7aazbrbyqIye/fzBVPvVlN6pDAcdlE6V4/jTUpZTzlas6sn7qA2BNuVMm/5B5Hr6mo6ifCAwoz3P5R5ZUQwMs8CSMnWOCd+8/cv/H/3fyJwGZJepNEc5Tqj1I2o9EkL8COKB3iNAbZe0IyPUdorVasfUmjBHV15ekysiJxkXzXqaaEoXt9p6eG5l0P1l+RGKeMhNIFf+AnZ2w52/Oqecole+FSuSfo7xu4kokig9kNgAUu0EVn2wKS23ZCZme0DYROXPvd6I9b+qo0aqaKGck32hlRDJ3IlMUyDejD4lQan54otqUaNifGHtJjhD97r+MEH6o6Q1IPGbHrL4UmVoG0YakJW0jbbWMkMbhuFbYSPO4Xiy1eOpZIOzZ4o/GvpVG7jla6P8sWV5c+9QXUXCm/70ae3FZ92B9+AMPTM4rBDY9FQAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:11','2017-08-19 09:31:11',NULL),(68,'1f621','pouting face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAM1BMVEVHcEzaLkbaLkfaLkfaLkbaLkbaLkbaLkbaLkbaLEfaL0cpLzM8LjWkL0HGL0R2LztULzdOjbvZAAAACnRSTlMAjCrez7NEZ+0MbNrgVQAAAgtJREFUWMOtWNuWgyAMFAXByO3/v7bWVio0BNTMw56zWXZMJhBChoHAqIWSkwEwk1RCj8MdjFptDDmM0ss1lkUrqOAK16INEJhEJxVNs4eoO2hmCR2QcysqAZ2g4xsldEMSu2E2cAGmGt4MF1HRXAOwMM0ALEy3eBCdRgP3mIrcLRJuQub7ScBtiOcCfXGWST4hko92ELoHFvOMyCw8DiWXnjqUXHrs0OGSek6k9siAAQtPZJ/YFAfROzbDQWS2+nH61dnV2hicp//LuxDtttSdbGMmkV2/sMHVWFz4rcpEEhjRexVK5bIlWTFRtWUIFfF3VVYQ7zYBjqUxE8v/7MGVOsphwiIIyEeTOwHLxYRnP317TUwumSKef1RSRNCTPGgaBiqyClFAPcJCs0hmThmzKBEm9u/jbWsSW/IQSfTwo4egYk0bUlBih7Y1HRFNpd+1renQjsSGjD3Wo4yg+fe7Htb3WI/ChpdaH6z9P1O49Si1bMWf7TpiuyD5rmy2JoJw6XvxtC4p3Wi0XFwzRNdotHCXfEHzfxsg7b8ky+0ZjmxGkfa4woMxzVTDXuX5ZxLkE+JTxPZc+U2X7cc7f1hZK54QxaMm4I3Ep4EI1KOmkMlW7tPt/BcuzfSDLcbq7vMx0jx8T1G+xzHfc51vgMA30uAbsjCOfdqDKCMuzMd4RmPHmI1hWHdjfPgCSGqjZQlvzrkAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:11','2017-08-19 09:31:11',NULL),(69,'1f620','angry face','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAPFBMVEVHcEz/zEz/zEz/zEz/zkv/zEz/zUz/zEz/zEz/zEz/u1X/zE1mRQB6VgnTpjZuTATuvEOMZhKjeh6+kiuS29utAAAAC3RSTlMAs4zjCNAlbEzvAxmIN6YAAAIsSURBVFjDrVjJdsMgDDTYgNm3///Xunk1NY4AL5pDD0o6kUaAlmlqQ3FBCZul1nJmhAqupgfggmwMNSQR/B7LshLdAFmX6zRi1h3M9BqVElIPIMUFtVamL4Cto6iovoh+fJzpy2CdBK5S34Bshrfqm2gwCX0bAsWfhk+PeAAmLp8RyVPuFqYfgtXnierHoAgCfcmk2Bsipt6cIPA0LfIdkVxwHCouLfNbonl5n7JD4hR5T0Q+l0MjgGNIvctNMIi22JTEIJKqkshZ421MLvT/K7gUrTfWVSIdJbLmDza5FotL/9+qRKIQkdk8yxBN3nw2EBGttHYHJlO7PvqcTOwcf05x/2qsxAr/9pTPOrIJumgh7wEeftTtMWUoF/MEZr/8tilMrpgimP8JzIz5FvQgD5hRkCj1iRLoERSaBTJzyJgFiSCxy1HxY2sRm+EQMfDyg5egYS0HkvbETmNruSKil343tpZLyzsHMl6x7s8I+LCFj7A2XLHuDxv81IbkfQrXrHsZQXv80crRhFUgFVbJxmsiVFvukD+F51Okchh2Wq1Gy8XjW298dINGC3Yp1DRANfgeJKBm1HkDwXWbUaDXyqaB3J8iaPv5H/lEuyOE/ZN3K4Rh02X743L00LN2GiFOQ81vYP67kXDJn4OTvDtmba0CfGxC9rVLg4EtxubpCzaOhlGsURRvOMYb1/EWCHgrDbwlC+LaB28RtfmEtRr75VLNZZ26v/u7tT78AWAStFkrEMBQAAAAAElFTkSuQmCC',1,1,'2017-08-19 09:31:11','2017-08-19 09:31:11',NULL),(70,'1f92c','⊛ face with symbols on mouth','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAulBMVEVMaXHaLkfaLkbaLkbaLkbaLkbaLkbaLkbaL0baLknaLkbaL0fGKkLaLkbYLkbZLkbZLkbaL0faLkbZLkeoL0E8LzUtMDQ1LjRELzZnLzp8LzyhL0DFL0QpLzOyL0KSLz+0L0NSLzfOLkbCL0Q6P0NgZWhNUlZESU2Ag4ZqbnExNjp4e36WmZuMj5Ggo6X////w8fHY2dq3ubv8/PzR0tNaXmHHycrn6Oj39/etsLHf4OEoLjIoLjIoLjKX9382AAAAPnRSTlMAM1+HsNDi7vkacP8Iuf5AlZIiU/////////////////////////////////////////////////////zSfHyTQWEAAAOkSURBVHgBrNWJcrsgEAbwFUGMnyFt6q3Emr7/O/6PMCkUynjkN/dmZmf5iAvFJCzlIpN5LjPBU5bQHqeCS/wgeXGiTUp2VghSZ1aub1NkiJBpubKNRBxksaLVRWAFcaG48k1hFfUeHeoqsJq4Ro4lsYH89XgfOTbJPyiIKWykWHAehc1UYKZLjh1yL6erxC7ySo5SYCdRku0Nu707ASnspuyYBIyDhytwSEFGKXGILI8P5IxUZjgoe4zEcBijf8447Ex/nRQMVHXTdv0wToiaxqHv2qauYECd3KhrbXTDDWG4DZ02ajdu7jR66mYFj5qfXdxGnIgkrKNpSz3ih9H9vcKTJEpgU9PnPCyNflgmWKbFlJtlmD8nBVsSvPz7rB/ayhq3NcX5Dh+jFAGLNpoRxthoY0FAShy+KhCoFU8FHw9ukD7eqIdPUAZf59yMd6MdfBlJ+J5xNJGqS1L+mka508j/VOJVp5GMhd1Hqi4ZDHvUxhipurLg9Svzh1xUpOoSxBHw9T+P+itWdXFKETL1bdtP0aorJYaXYJTgJRKz2I6S9qq9z8NG35uJW8t/bPVm7Wgtf/Mc3fQut+/niM7OUvzDdhnryA0CYThNmpNSXAp3f4cBjPGPbdaAL+//XNFweOPN3dcMGolPMxprd1AjoA0ao9USrINg7Gd68nPQrz+Xv25/2VdjC/UQVwgbuVtgZISQmCQ8IknOV3N9+P+WCHQOKsNDTo55KUUhsUI4mSWszH4mR3zSl4jG212UI0YucpoZcHB0LOomGsggZ3sTvd0XLQjaWmZbudkH4JlcpDl7G03UQhoe+6676L5otZIgJHbkznSSrJ5RvYgcmfYmb/SCOj+76BE2HuHkHGRQaq52ygx4EencZnDRltH7etzzgR7rPuEiME8vIle4tqEZPzRRX4877000eXtwsSVa329PkdaEWT9FKjIMG2lVpm6i9/+eEJL0fOLQmHnqSJaxfRipJYApcT+5torujQm/JalCKDFUHsFOaIlCt7EuTNeXXXlIPpNRQ/jyIO2tMMEzoCOGlXrai9z2SjLRAGalROHH9yLNDTNd95jCEZVbbRWtXAG9M9atMBae6lvRB4SRAZWmi6z0YSJZHs+p2Z0kVz3u9AA+voj+QBi8gnHoqEWUyoZm1p/DM6EubgDcIhX9nQ2GQbayZAFbzDEIG3LMseHBMppha2NNminWNrY8NBxkQQBihn3oOhBFeGiMLoN1lA8fAgDb8jxZV4gSrwAAAABJRU5ErkJggg==',1,1,'2017-08-19 09:31:11','2017-08-19 09:31:11',NULL),(71,'1f637','face with medical mask','iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAVFBMVEVHcEz/zE3/zEz/zEz/zEz/zEz/zEz/0Ff/zE365Kf824b/zEz38d756Ln/zE31+PpmRQD29ez57Mf+1W3+0V3WqDdwTgWedht3Uwi6jyrxv0V5VgkCt40gAAAADnRSTlMAcs/kXO+zDTX+/Y79rhb9OWkAAAJnSURBVFjDvZjrukUgEIaRTlhZytn93+e2HFKIpGd/v/Zu5TVNM6YpCC5E4hRFADIGQYTSmAQuwiEaCbogCvFDSoyYQSjGD4wB7ELA1qwQshvB0AJDImYhcOd4nDJLpfi9ObOiC6MIZA8EjaSYPVTsiWMgOXBOSYQ5ibzzs9njOGKOivR4SpmzUg8OOropegOKlHxnryS/BRi+A0HsxyBpEgZvQQCbcqPqmqatv22lDbbfemiarjJlyv47XzX1d1GrjrfraN3sWWhamTbUd5JiBP1YXa89hneu7hsVc1yaimr6nbuVlVW1nNVVfX/0Rd+P3pOTKn1tcG/80QUGJw5KKOlp9gMNncV+992gg8aEUze/GtrONna6dqi0AEiZF6UB8gNCAU18cBIaZHlBX2OyPAuKPB9RpTpe8t+gUQUX2mw6IYLlV7r9WF5iJtT2XkGXsUDw5S/5Hp7fiq+Y7eExsCWUz34v7kHF7Bq+LQcEQC5zctb4X26h2cPLM7+FgrWAKMM2IP3VUymRAZnw/LF4sgWkkiLiIUoNg1T/YpfUDfNL2l21lou/2TY9hKe6faiOlrum18iTIuIEQmd11gUUHsqRIwifFUgHEDot2Q6guWTjRLwDiWQ513zyPOM0KZ+DSkHpmA6f9aC1JuBIE7YgkdD1Q1rIg+1HnZPZgLRJn+2UneUvlCknbaIY+kSjM6gghwP74jpLO9btSU0thLDBCFMLoTY1j+Lo2EYSNxC5aPysy9FdC/mgQF43tcK6ZMc37frtIaK8adf9XSD4u9KwNiqyud0Kb7slEP7vRZS/qzGPl3UO14d/e2/moouSwcYAAAAASUVORK5CYII=',1,1,'2017-08-19 09:31:11','2017-08-19 09:31:11',NULL);
/*!40000 ALTER TABLE `emoji` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emoji_group`
--

DROP TABLE IF EXISTS `emoji_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emoji_group` (
  `e_group_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `e_group_name` varchar(100) NOT NULL,
  `e_group_icon` text NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`e_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emoji_group`
--

LOCK TABLES `emoji_group` WRITE;
/*!40000 ALTER TABLE `emoji_group` DISABLE KEYS */;
INSERT INTO `emoji_group` VALUES (1,'simely','data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAwFBMVEVMaXH/zEz/zlH/zE3/zEz/zEz/y0z/y0z/xkv/zEz/zEz/zU7/zEz/zEz/zEz/zEz/zEz/zEz/zEv/zE3/zEz/zEz/zEz/zE3/zU3/zEz/zEz/y0z/zEz/y03/zE1mRQBrSQPtvENyTwZ7VwpxUhL2w0iqgSLisj7e18js6OCSbBXJnDGlkmmGYRC1pYScdBv///+5jSnQojX49vP+/v13Wh3FuJ69kiuHbTfSpDZ/ZCrYqjmYglSkex7Pxa+Se0qAAzOiAAAAHnRSTlMAYwtu0UD5/gXuhyKScvFbsrkart3r5stWdVA0MuAShyFhAAAC4klEQVR4AazTRXpjMRAE4HrYkpnxS5m2kwnscv+DmVEm0b8UNwgvqGlSaeU9XZa6l7cqyVTBQydrNWhotLIOnKTNtvAhaTeV/THZgC/0KylsqLHmG7pu8aoip4VegddUTWhFagovVIe0Nqy+CKtBB42n4U1KOilHeCgROpLk4XuEzuTBm4qSHsoChmqDXhpG7dSQnoYK12r0VsOVQuhNrtKkcgbIFU7GDFLHUdpnkH769EGLr+Xya0HL8dOT1ICGxXK2tVzYjg9S7DRpkM/Z3qfYjZNN7LRp+J0d/dqNk21sdYSGr9OGL7txUjoAMppWpw0ru/GtDECLpvlpw9xufKsLKB3jIK0wZYzQOEVChiebTFAhn5b/z258p4IWGdaQp2znJAO+yEmOD5IBn/akB80o+igZRRnvoE0rVpEdNxAFzcxKNqHfTOoRk/n+pwrbHn3homutV+KiYLf2PQzRp8HrPx53pqWjDtAHeawIMKdiPUl3rGPlGBDVPyJCv0gOb+BO5fG9plTKHz+kpFTfx7lyHN6Qo1+k/9NuYDU26Kf9iiRnJbAoffsjbIgoaXxHZgg63ySY6PQESS0HAGGzrLKmSfxr91ALQQCIEPVD9+qTxtgqy6zA6hZh8XfwG7XNZmFr+A2Hxb9nRy38gTBzPEbAH7TYjnoGSf8/B19O0ZTJ/+dHsUHuXI/pct2UozRNPabb18MQoeENwpuqz1IZL+ANGocIHGue4QPiKXkxtqyq0pqX5EnAB55RrBkGLclhBbgcC1o7l9v0msAiiMbvfiyMFrCIAofR8XhcLF1TjOLxZGB/ZDAD9ogC+0yFoDNysqGoQsyWmuOcTFxO3lfG0/OlmiXVCBVREtesFcVPtugGN61cLn7jVZTGynFGCONOxXSkioYqx2Hq+ulhqAEh1KQRZGQ5OFwx+1x+Xowe+yfhh6h5nASZxt7GuugUs5xGK8c6hJNvu2fR23wYne1+m7uWX1iL7IE5/nCDAAAAAElFTkSuQmCC',1,'2017-08-19 08:01:20','2017-08-19 08:01:20',NULL);
/*!40000 ALTER TABLE `emoji_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `login`
--

DROP TABLE IF EXISTS `login`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `login` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(45) NOT NULL,
  `password` varchar(45) NOT NULL,
  `group` tinyint(1) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `last_login_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email_UNIQUE` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `login`
--

LOCK TABLES `login` WRITE;
/*!40000 ALTER TABLE `login` DISABLE KEYS */;
INSERT INTO `login` VALUES (1,'abc@xyz.com','123',0,1,'2017-08-14 12:06:18','2017-08-14 12:06:18',NULL,NULL);
/*!40000 ALTER TABLE `login` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `message`
--

DROP TABLE IF EXISTS `message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `message` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sender_id` int(10) unsigned NOT NULL,
  `receiver_id` int(10) unsigned DEFAULT NULL,
  `message` varchar(2048) NOT NULL,
  `sent_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `sender_ip` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `message`
--

LOCK TABLES `message` WRITE;
/*!40000 ALTER TABLE `message` DISABLE KEYS */;
/*!40000 ALTER TABLE `message` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary view structure for view `user_info`
--

DROP TABLE IF EXISTS `user_info`;
/*!50001 DROP VIEW IF EXISTS `user_info`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `user_info` AS SELECT 
 1 AS `login_id`,
 1 AS `email`,
 1 AS `username`,
 1 AS `password`,
 1 AS `group`,
 1 AS `active`,
 1 AS `fullname`,
 1 AS `last_login_time`*/;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `login_id` int(10) unsigned NOT NULL,
  `username` varchar(45) DEFAULT NULL,
  `firstname` varchar(45) NOT NULL,
  `middlename` varchar(45) DEFAULT NULL,
  `lastname` varchar(45) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username_UNIQUE` (`username`),
  KEY `fk_login_idx` (`login_id`),
  CONSTRAINT `fk_login` FOREIGN KEY (`login_id`) REFERENCES `login` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,1,NULL,'Joydeep','A','Dey','2017-08-14 12:07:03','2017-08-14 12:07:03',NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Final view structure for view `user_info`
--

/*!50001 DROP VIEW IF EXISTS `user_info`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `user_info` AS select `l`.`id` AS `login_id`,`l`.`email` AS `email`,`u`.`username` AS `username`,`l`.`password` AS `password`,`l`.`group` AS `group`,`l`.`active` AS `active`,concat_ws(' ',`u`.`firstname`,ifnull(`u`.`middlename`,''),`u`.`lastname`) AS `fullname`,`l`.`last_login_at` AS `last_login_time` from (`login` `l` join `users` `u` on((`u`.`login_id` = `l`.`id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2017-08-21  0:11:51
