# Contributing to Supabase Flutter Template

Thank you for your interest in contributing to the Supabase Flutter Template! We welcome contributions from everyone and are grateful for any help you can provide.

## How to Contribute

### Reporting Issues

If you find any bugs or have a feature request, please open an issue on GitHub using the [issue tracker](https://github.com/devtodollar/supabase-flutter-template/issues). Before creating a new issue, please check to make sure it hasn't already been reported.

When submitting a bug report, please include:
- A brief description of the issue
- Steps to reproduce the issue
- Any relevant error messages or screenshots

### Making Contributions

To make a contribution, please follow these steps:

1. **Fork the repository** on GitHub.
2. **Clone your fork** to your local machine.
3. **Create a new branch** for your contribution.
4. **Make your changes** and **commit** them with clear, descriptive messages.
5. **Push your changes** to your fork on GitHub.
6. **Submit a pull request** to the main repository.
7. **Wait for feedback** or approval from the project maintainers.

### Pull Request Guidelines

- Keep changes small and focused. If you have multiple unrelated changes, submit them as separate pull requests.
- Follow the existing coding style as much as possible.
- Update the README.md if necessary, especially if adding new features or changing existing functionality.
- Make sure your code changes do not introduce any new warnings or errors.

## Code of Conduct

By participating in this project, you agree to abide by its terms and to be respectful and considerate of others. For more details, see our Code of Conduct.

## Questions or Help

If you have any questions or need help with setting up or contributing, please feel free to open an issue for discussion.

Thank you for contributing to the Supabase Flutter Template project!
