# Awesome GPT Store [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
A curated list of awesome GPTs. Inspired by [awesome-chatgpt-prompts](https://github.com/f/awesome-chatgpt-prompts).

## 🚀 Add GPT
This is a space for showcasing GPTs created by AI enthusiasts worldwide.

- 🎙️ **Contributing**: `* [GPT's name](http://example.com/) - A short description.`
- ✅ **Recognition**: Your GPT could be the next big highlight in our Awesome ChatGPT Store list.

Your stars🌟 and recommendations are what make this community vibrant!

## Table of Contents
  - [AI Art](#ai-art)
  - [Business](#business)
  - [Social Media](#social-media)
  - [Music](#music)
  - [Video](#video)
  - [Writing](#writing)
  - [Gaming](#gaming)
  - [Education](#education)
  - [Finance](#finance)
  - [Productivity](#productivity)
  - [Humor](#humor)
  - [Travel](#travel)
  - [Food \& Drink](#food--drink)
  - [Developer Tools](#developer-tools)
  - [Design](#design)
  - [Health \& Fitness](#health--fitness)
  - [Philosophy \& Self-Improvement](#philosophy--self\-improvement)
  - [Security](#security)
  - [Lifestyle](#lifestyle)
  - [News](#news)
  - [Reference](#reference)
  - [Sports](#sports)
  - [Chat](#chat)
  - [CustomGPTs Security](#customgpts-security)
  - [Contributing](#contributing)

---

## AI Art
* [Character Crafter](https://chat.openai.com/g/g-EabPCuUlt-character-crafter) - Helps fiction authors create and develop characters, with Dall-E art.
* [Midjourney Generator](https://chat.openai.com/g/g-iWNYzo5Td-midjourney-generator) - MidJourney prompt expert for commercials.
* [Midjourney Prompts](https://chat.openai.com/g/g-jvU1LDhpM-hoverbaums-image-wizard) - Turn your ideas into expansive Midjourney Prompts. Learn in in [the repo](https://github.com/HoverBaum/image-wizard-gpt).
* [Simpsonize Me](https://chat.openai.com/g/g-tcmMldCYy-simpsonize-me) - I turn photos into Simpsons-style art.
* [Visual Weather Artist GPT](https://chat.openai.com/g/g-twUGxmpHv-visual-weather-artist-gpt) - Hi, I'm the visual weather artist, give me your location (or any other) and I will draw the current weather conditions for you, a unique never before seen weather report!
* [Wallpaper GPT](https://chat.openai.com/g/g-iQQ6Qfd6j-wallpaper-gpt) - I create vibrant wallpapers for phones and laptops.
* [Pixel Art Wizard](https://chat.openai.com/g/g-bOq4QJhDQ-pixel-art-wizard) - I'm a playful and creative wizard of pixel art!
* [Visual Beat Master by Ben Nash](https://chat.openai.com/g/g-Z2dOgr5kI-visual-beat-master-by-ben-nash) - Innovative visual creator with interactive idea selection.
* [Tattoo GPT](https://chat.openai.com/g/g-1zMekbWTA-tattoo-gpt) - Tattoo GPT designs your tattoo. It assists you in refining your tattoo ideas, suggests designs, generates visual previews of the designs, and offers customization options. It recommends tattoo artists or studios and provides aftercare advice.
* [Art Engineer](https://chat.openai.com/g/g-D21BibKO9-art-engineer) - Analyzes and reverse engineers images, providing style descriptions and re-creation prompts.
* [Stella Sky's Portraits](https://chat.openai.com/g/g-pw9VYpr1w-stella-s-sky-portraits) - Crafts detailed prompts for generating artistic portraits of women in diverse styles.
* [Dreamy Tales](https://chat.openai.com/g/g-j3tjdPGz3) - Creates and narrates whimsical bedtime stories for children, with DALL-E images.
* [Frienz](https://chat.openai.com/g/g-V4VX7Cu7p-frienz) - Get ready to spice up your day with a dash of nostalgia and a twist of AI magic. Introducing Frienzzz GPTs, the first app where you can relive the scenes of your beloved TV series "Friends"!
- [MinecraftMe](https://chat.openai.com/g/g-x3zm5ZeSD-minecraftme) - Turn yourself into a Minecraft character.
- [Coloring chibi images](https://chat.openai.com/g/g-KHVVTwHCX-coloring-chibi-images) - Generates chibi coloring images for kids.
- [Vinyl Visions](https://chat.openai.com/g/g-eUsbZVcuk-vinyl-visions) - Create unique playlist covers.
- [Studio Neiro AI](https://chat.openai.com/g/g-SRuCzS9Kf-studio-neiro-ai) - Create videos with talking digital avatars


## Business
* [Superdomain](https://chat.openai.com/g/g-fhWHWw3rc-superdomain) - Find best domains before anyone else with an AI scoring engine based on 10+ signals.
* [StockGPT](https://chat.openai.com/g/g-0v9iaOSnO-stockgpt) - Expert analysis of stocks using comprehensive and realtime financial data.
* [Market Analyst](https://chat.openai.com/g/g-m5ZAgJ5jt-market-analyst) - Trained on Technical Analysis and Charting Knowledge
* [CEO GPT](https://chat.openai.com/g/g-EvV57BRZ0-ceo-gpt) - A concise mentor to startup CEOs, offering wisdom from business icons.
* [Visionary Business Coach](https://chat.openai.com/g/g-SOQdsiT3I-visionary-business-coach) - A vision-based business coach specializing in plan creation and strategy refinement.
* [HormoziGPT](https://chat.openai.com/g/g-aIWEfl3zH-hormozigpt) - Engaging Business Maverick.
* [Quant coder](https://chat.openai.com/g/g-mAoqNweEV-quant-coder) - I translate market insights into trading algorithms.
* [StratGPT](https://chat.openai.com/g/g-GHU9fWyhR-stratgpt) - Generate Strategies for Everything.
* [Avian](https://chat.openai.com/g/g-zMRWQxwDU-avian) - Analyze & visualize data from 20+ platforms, including Google Analytics, Google Ads & Facebook Ads.
* [GPT Co-Founder](https://chat.openai.com/g/g-K9C3ACCHN-gpt-co-founder) - A founder's virtual companion for decision-making and idea validation.
* [NomadGPT](https://chat.openai.com/g/g-0k9rvxdJn-nomadgpt) - NomadGPT helps you become a digital nomad and find you the best places in the world to live and work remotely.
* [FB Marketplace Maven](https://chat.openai.com/g/g-EJeYSPqOq-fb-marketplace-maven) - Marketplace expert for Facebook.
* [The Solopreneur Coach](https://chat.openai.com/g/g-cXaf5hECk-the-solopreneur-coach) - I help you build million-dollar businesses.
* [First Time Manager Guide](https://chat.openai.com/g/g-3ocrRA0Y8-first-time-manager-guide) - Helpful coach for first-time or new managers that uses tested advice to help you succeed.
* [Impossible Sales Rep](https://chat.openai.com/g/g-prlTJYjxZ-impossible-sales-rep) - Generates custom cold reach sales emails with thorough research.

## Social Media
* [Twitter Hooks & Thread Crafter](https://chat.openai.com/g/g-Wi5WQPXnx-twitter-hooks-thread-crafter) - Specialized in crafting attention-grabbing and engaging hooks and a complete thread for X / Twitter.
* [Username Genius](https://chat.openai.com/g/g-2qyTpg91g-username-genius) - I craft unique usernames for social media.
* [Viral Visionary](https://chat.openai.com/g/g-Z9Qdkubmy-viral-visionary) - A creative chatbot that tracks and suggests viral social media content.

## Music
* [Music Nerd](https://chat.openai.com/g/g-U2qhvn81x-music-nerd) - Enthusiastic and knowledgeable music history expert.
* [Echolocation](https://chat.openai.com/g/g-Um51Akg9r-echolocation) - Music discovery guide specializing in unique and rich sounds.
* [Bass(ed)GPT](https://chat.openai.com/g/g-pWKtpUtec-bass-ed-gpt) - Bangers only.
* [GeistBot](https://chat.openai.com/g/g-mms0976dx-geistbot) - Formal, educational music historian with detailed responses and Discogs links.

## Video
* [Typeframes - Video Creation](https://chat.openai.com/g/g-vPFqv6NDp-typeframes-video-creation) - Create videos for you.
* [Talk To YouTube Video](https://chat.openai.com/g/g-ynY1wMTRY-talk-to-youtube-video) - I'm your YouTube video partner, here to engage with videos and enhance your understanding of their content.

## Writing
* [Interactive Writer](https://chat.openai.com/g/g-AaKhBisIN-interactive-writer) - Bring GPT Writing Skills to the Next Level.
* [The Guided Writer](https://chat.openai.com/g/g-spa305Ewq-the-best-guided-writer) - This GPT crafts customized articles by asking you questions, ensuring content that precisely matches your requirements and preferences.
* [Editing Guru](https://chat.openai.com/g/g-AZKC67NTa-editing-guru) - Your ultimate solution for improving, reviewing, and rewriting texts.
* [Character Crafter](https://chat.openai.com/g/g-EabPCuUlt-character-crafter) - Helps fiction authors create and develop characters, with Dall-E art.
* [Academic Paper Creator](https://chat.openai.com/g/g-DzTFVQytf-academic-paper-creator) - LaTeX paper writing assistant and PDF formatter.
* [OpenStorytelling Plus](https://chat.openai.com/g/g-LppT0lwkB-openstorytelling-plus) - Screenwriting Guide with Screenplay Examples.
* [Script Mystic](https://chat.openai.com/g/g-ZNKfbCThn-script-mystic) - Guiding light in screenwriting, illuminating one step at a time.
* [TechWriting GPT](https://chat.openai.com/g/g-TURZVCuy7-techwriting-gpt) - Expert in developer marketing and writing for engineers.
* [Editby | SEO and social media writer](https://chat.openai.com/g/g-I3NZ9DoPL-editby-seo-and-social-media-writer) - Write engaging SEO-optimized articles and social media posts.
* [Transcript Polisher](https://chat.openai.com/g/g-zjBCMv8GA-transcript-polisher) - Edit rough AI-generated transcripts into polished prose.
* [Fable Forge](https://chat.openai.com/g/g-mBqCBRe17-fable-forge) - Interactive fable-teller with illustrations.
* [Tales](https://chat.openai.com/g/g-sXCQE8t9o-tales) - Create short text adventures.
* [Screenplay GPT](https://chat.openai.com/g/g-INlwuHdxU-screenplay-gpt) - Crafts award-worthy screenplay gems. Ask it for images, too!
* [ReadRecs](https://chat.openai.com/g/g-utxuDJYKK-readrecs) - Book recommendations from photos of your shelves.

## Gaming
* [Dragon Realm](https://chatgpt.com/g/g-mTcflbgCG-dragon-realm-game) - Epic adventure RPG game to shape the fate of the realm.
* [DnDGPT](https://chat.openai.com/g/g-IMdD6QFb8-dndgpt) - Epic D&D narrator assisting both players and Dungeon Masters (DMs) in navigating the rich world of D&D 5E.
* [TTRPG Random Tables Generator](https://chatgpt.com/g/g-2O49TlCQu-ttrpg-random-tables-generator) - A tool for Game Masters to generate content for various tabletop RPG elements.
* [Pokemon Quiz Master](https://chat.openai.com/g/g-7J408YsY5-pokemon-quiz-master) - Enthusiastic and encouraging quiz host, with a touch of formality, for a Pokemon guessing game.
* [Pirate GPT Treasure Hunt Generator](https://chat.openai.com/g/g-DIsjeSpH0-pirate-gpt-treasure-hunt-generator) - I create personalized pirate-themed treasure hunts.
* [Mystic Conquest: Riddles & Ruins](https://chat.openai.com/g/g-A8hTX1Ijs-mystic-conquest-riddles-ruins) - The saga of puzzles and peril.
* [Tales of the Wild West](https://chat.openai.com/g/g-pi1iIhHBL-tales-of-the-wild-west) - Interactive Fiction/Choose-Your-Own-Adventure.
* [Animal Mashup](https://chat.openai.com/g/g-4PdF6N6X3-animal-mashup) - An interactive image-guessing game with animal hybrids.
* [A Club Penguin Mystery](https://chat.openai.com/g/g-zgcLC7mmJ-a-club-penguin-mystery) - Solve the Lighthouse Riddle!
* [SUDOKU](https://chat.openai.com/g/g-ogXlCik0m-sudoku) - Engaging Sudoku generator with fun facts and tips.
* [Turkish Carpet Salesman](https://chat.openai.com/g/g-Nw5RMOGEh-turkish-carpet-salesman) - Immersive and dynamic Turkish rug salesman in a unique game.

## Education
* [Real Estate Striver](https://chatgpt.com/g/g-Nhtfia7Ru-real-estate-striver-game) - Educate real estate investment as a RPG game where players build a real estate empire.
* [EduBot - HomeSchool Helper](https://chat.openai.com/g/g-LTgawtUFZ) - Personalized Homeschooling; adapting to students' unique needs, offering interactive learning, and respecting individual preferences.
* [ScholarAI](https://chat.openai.com/g/g-L2HknCZTC-scholarai) - Your Research Assistant - I'll help you navigate over a corpus of 200M articles, journals, and books.
* [ATOM library tutor](https://chat.openai.com/g/g-Dqb6xDLt6-atom-library-tutor) - Create and analyze molecular systems in MATLAB.
* [Code Animator](https://chat.openai.com/g/g-r4TatQY5C-code-animator) - I generate Manim animations for CS education.
* [CS50 Tutor](https://chat.openai.com/g/g-1KKnxZsif-cs50-tutor) - Your pseudo Harvard professor for computer science queries, blending academic rigor with supportive guidance.
* [Fast.ai Tutor](https://chat.openai.com/g/g-9p4s4Cx6W-fast-ai-tutor) - A tutor for the Fast.ai course, providing explanations and assistance.
* [anky](https://chat.openai.com/g/g-DKne07mTu-anky) - Creates notebook templates.
* [Therocial Scientist](https://chat.openai.com/g/g-YNx1VQJnF-therocial-scientist) - I am a digital scientist skilled in Python, here to assist with scientific and data analysis tasks.
* [Climate Insight](https://chat.openai.com/g/g-ZQHLb73Aq-climate-insight) - IPCC report based learning for climate change what we are facing.
* [Learning Journey](https://chat.openai.com/g/g-nL5CLc5oz-learning-journey) - A guide for personalized learning journeys in various subjects with interactive modes.
* [Research Pathfinder](https://chat.openai.com/g/g-kidbj3HXe-research-pathfinder) - Guiding you through the galaxy of STEM research!
* [Debate wars]( https://chat.openai.com/g/g-3f6WLJxOX-debate-wars) - Just provide a topic or question in your spoken language to start a ChatGpt vs ChatGpt debate battle.
* [Rust Mentor](https://chat.openai.com/g/g-DDKjGVW8S-rust-mentor) - A Rust programming language instructor for beginners.

## Finance
* [Financial Advisor Steve](https://chat.openai.com/g/g-uhrVqKFzd-financial-advisor-steve) - Friendly and professional financial advisor, simplifies complex topics.
* [Warren Buffet's Wisdom](https://chat.openai.com/g/g-fYtFCiy7X-warren-buffet-s-wisdom) - Channeling Warren Buffet's wisdom to offer timeless, tailored advice.
* [Bitcoin Simplifier](https://chat.openai.com/g/g-UOwEu1iAJ-bitcoin-simplifier) - Simplifies Bitcoin concepts for easy understanding.
* [Quant coder](https://chat.openai.com/g/g-mAoqNweEV-quant-coder) - I translate market insights into trading algorithms.
* [Crypto Mentor](https://chat.openai.com/g/g-mDvttLpe5-crypto-mentor) - Your cryptocurrency guide.
* [Douglas](https://chat.openai.com/g/g-lSg1yKEFa-douglas) - AI Family Office Manager for wealth guidance.
* [Equity Analyst](https://chat.openai.com/g/g-EtD9sVGHw-equity-analyst) - Delivers precise stock analyses with clear price targets and recommendations.
* [Austin AI: The Financial Advisor](https://chat.openai.com/g/g-yaYByRR5S-austin-ai-the-financial-advisor) - Helps plan finances around taxes, income, expenses, and investments.
* [Alex Earnings Call](https://chat.openai.com/g/g-GSs2i0VqU-alex-earnings-call) - Guides investors through earnings seasons.


## Productivity
* [Color Psychology](https://chat.openai.com/g/g-msLVpHkv3-color-psychology) - This AI will provide insights into the psychology and symbolism associated with colors.
* [Scholar Scribe](https://chat.openai.com/g/g-0f7Gok0gW-scholar-scribe) - I transform textbook and handwritten notes into detailed Markdown and PDFs.
* [Notion Templates Creator](https://chat.openai.com/g/g-A7nHjM8cF-notion-templates-creator) - Your guide to creating and monetizing Notion templates.
* [Phone Script Builder GPT](https://chat.openai.com/g/g-B21t4rTEN-phone-script-builder-gpt) - I automatically create and evaluate phone scripts, presenting a final draft.
* [Transcript Polisher](https://chat.openai.com/g/g-zjBCMv8GA-transcript-polisher) - Edit rough AI-generated transcripts into polished prose.
* [Email Proofreader](https://chat.openai.com/g/g-ebowB1582-email-proofreader) - Copy and paste your email draft to be proofread by GPT without changing its content. Optionally, write 'Verbose = True' on the line before pasting your draft if you would like GPT to explain how it evaluated and changed your text after proofreading.
* [Idea2Domain](https://chat.openai.com/g/g-GTKfx5UJP-idea2domain) - Give me your business idea, and I'll give you available domain suggestions.
* [Orchid](https://chat.openai.com/g/g-IhEVcAS4r-orchid) - A creative assistant for brainstorming project names.
* [Public Memory Board Assistant](https://chat.openai.com/g/g-3ssKt8JED-public-memory-board-assistant) - Assists in conversations, saving and retrieving data on a public board.
* [GPT Ideas](https://chat.openai.com/g/g-x2ms3pMDv-gpt-ideas) - Innovative GPT ideas for ChatGPT & API.
* [Zero](https://chat.openai.com/g/g-KRUiYR8gD-zero) - Zero, an AI agent with a rich knowledge base in quantum computing, mathematics, organic AI, and more, offering narratives for personal growth.
* [NeonMind GPT](https://chat.openai.com/g/g-S9YkPkWR1-neonmind-gpt) - Illuminating AI insights with the vibrant glow of neon creativity.
* [SmartGPT](https://chat.openai.com/g/g-FCLkygP9N-smartgpt) - Introducing Precision-Guided AI: Mastering Detailed, Step-by-Step Analysis with Unmatched Accuracy and Coherence!
* [AIT-StrategiX](https://chat.openai.com/g/g-D8ojucjoB-ait-strategix) - Methodical Approach for Strategic Scenario Analysis.
* [OCR](https://chat.openai.com/g/g-wETMBcESv-ocr) - Extract text and content from images or PDF documents.

## Humor
* [Weather GPT](https://chat.openai.com/g/g-1X1g0iFO4-weather-gpt) - Super snarky, passive-aggressive U.S. weather roaster.
* [Pep-talk Guru](https://chat.openai.com/g/g-oUQRqcRmh-pep-talk-guru) - I'm here to boost and tickle your funny bone!
* [Simpsonize Me](https://chat.openai.com/g/g-tcmMldCYy-simpsonize-me) - I turn photos into Simpsons-style art.
* [SBF-GPT](https://chat.openai.com/g/g-5yZdSSFfR-sbf-gpt) - Simulates chatting with Sam Bankman-Fried in jail.
* [CatGPT](https://chat.openai.com/g/g-0jpvqh5fm-catgpt) - Meow Meow Meow Meow Meow.

## Travel
* [NomadGPT](https://chat.openai.com/g/g-0k9rvxdJn-nomadgpt) - NomadGPT helps you become a digital nomad and find you the best places in the world to live and work remotely.
* [Undiscovered America TV Explorer's Guide](https://chat.openai.com/g/g-Ii0i4ljeX-undiscovered-america-tv-explorer-s-guide) - Your go-to guide for hidden US travel gems.

## Food & Drink
* [Foods of Earth Cuisine Crafter](https://chat.openai.com/g/g-ZltAuhWRx-foods-of-earth-cuisine-crafter) - Creative Chef GPT.
* [FineDiner](https://chat.openai.com/g/g-DenEjjjYX-finediner) - Restaurant & bar curator with feedback capabilities.
* [Vegan Chef Bot](https://chat.openai.com/g/g-FUFW5OPb6-vegan-chef-bot) - Expert in fun & tasty vegan cooking.
* [Chef's Assistant](https://chat.openai.com/g/g-Aiwc5iqFT-chef-s-assistant) - I'm a culinary expert who suggests recipes based on your ingredients.

## Developer Tools
* [React AI](https://chat.openai.com/g/g-AVrfRPzod-react-ai) - Your React companion.
* [Odoo AI](https://chat.openai.com/g/g-EcqDm06Kr-odoo-ai) - Odoo Software Development Mentor.
* [IAC Code Guardian](https://chat.openai.com/g/g-nT849ZvCx-iac-code-guardian) - Introducing IAC Code Guardian: Your Trusted IaC Security Expert in Scanning Opentofu, Terrform, AWS Cloudformation, Pulumi, K8s Yaml & Dockerfile.
* [Ferris the crab](https://chat.openai.com/g/g-2LFEDLGgS-ferris-the-crab) - The unofficial Rust programming language GPT.
* [Android Dev Assist](https://chat.openai.com/g/g-kInvm7TFe-android-dev-assist) - Helps with Android app development, focusing on new tools like Jetpack Compose and Kotlin.
* [LittleBison](https://chat.openai.com/g/g-glAjAQgqJ-littlebison) - Hypermedia and HATEOAS certified coding assistant. Proficient in HTMX, HyperScript, JavaScript, Python, and Clojure. Won't write React code.
* [Grimoire](https://chat.openai.com/g/g-n7Rs0IK86-grimoire) - Coding Wizard: 100x Engineer. Build a website with a sentence. Built for a new era of creativity: Prompt-gramming.
* [Modern Next.js Assistant](https://chat.openai.com/g/g-5uKZEh1up-modern-next-js-assistant) - Specialized in Next.js, App Router, TypeScript, Shadcn, and Tailwind CSS; avoids pages router. Has preloaded documentation of Next.js version 14.0.2 and shadcn version 0.4.1.
* [WordPress GPT (1.1)](https://chat.openai.com/g/g-Z8RtbJVuE-wordpress-gpt-1-1) - WordPress Developer Assistant.
* [StreamlitGPT](https://chat.openai.com/g/g-ucLFVBWHR-streamlitgpt) - Code reviews from a Streamlit expert.
* [Shpify - Developer Assistant](https://chat.openai.com/g/g-7tf92Ymff-shpify-developer-assistant) - Senior Shopify Developer Assistant with Full Code Solutions.
* [Linux Terminal Emulator](https://chat.openai.com/g/g-f3m27kByE-linux-terminal-emulator) - Type linux commands to view output as a terminal emulator.
* [Power Automate Helper](https://chat.openai.com/g/g-UsKloaH8k-power-automate-helper) - Expert in Power Automate flow development and troubleshooting.
* [Awesome Prompt](https://chat.openai.com/g/g-mzoUJlM5z-awesome-prompt) - Prompt Development Guide to get better result.
* [Code Sage](https://chat.openai.com/g/g-SYWHDyjjl-code-sage) - A master software engineer who follows best practices and ensures robust and elegant responses to code-related prompts.
* [Keycloak Upgrade Assistant](https://chat.openai.com/g/g-BSXYGFVZ1-keycloak-upgrade-assistant) - An assistant that helps you upgrade your Keycloak server or cluster.

## Design
* [UX/UI Designer | Roast my web and saas](https://chat.openai.com/g/g-U4yP1n6bt-ux-ui-designer-roast-my-web-and-saas) - A UX UI Designer who can help you roast your site or product, provide help, and guide you with good design.
* [DesignerGPT](https://chat.openai.com/g/g-2Eo3NxuS7-designergpt) - Creates and hosts beautiful websites.
* [Canva](https://chat.openai.com/g/g-alKfVrz9K-canva) - Effortlessly design anything: presentations, logos, social media posts, and more.
* [LogoGPT](https://chat.openai.com/g/g-z61XG6t54-logo-maker) - Designs personalized logos from sketches.

## Health & Fitness
* [My Doctor](https://chat.openai.com/g/g-zouSfk9IG-my-doctor) - I will be your private doctor.
* [Pocket Meditations](https://chat.openai.com/g/g-0AZyQVlhT-pocket-meditations) - Brief Stoic insights from Marcus Aurelius.
* [Marathon Coach](https://chat.openai.com/g/g-nfriJSBi2-marathon-coach) - Your personal running coach.
* [GreenDial](https://chat.openai.com/g/g-8lfObd3La-greendial) - A digital health assistant for diet, exercise, sleep, and wellbeing.
* [Acupuncture Master](https://chat.openai.com/g/g-iwfqg4W2h) - I'm Acupuncture Master, your specialized AI assistant for acupuncture and Chinese medicine. While I aim to assist practitioners and students with diagnostic pointers and treatment options, keep in mind I'm not a substitute for professional medical advice. Feel free to explore and learn.
* [Gravity Guide](https://chat.openai.com/g/g-zPHA1EMmM-gravity-guide) - I guide you in mastering calisthenics with personalized routines and skill progressions, turning gravity into your ally.
* [FitGPT](https://chat.openai.com/g/g-fyWPmQ0vY-fitgpt) - Digital fitness coach offering tailored workouts with links.
* [VitaCheck](https://chat.openai.com/g/g-sfZGNfopm-vitacheck) - Cross-reference your vitamins and supplements to ensure there are no negative interactions and find out how to optimize your nutritional health!
* [Personal Trainer with Common Sense](https://chat.openai.com/g/g-jtA39A6gB-personal-trainer-with-common-sense) - A Personal Trainer that customizes gym programs and offers diet tips.
* [Pump University](https://chat.openai.com/g/g-cgJkNatgi-pump-university) - The Ultimate AI fitness coach, crafting personalized workouts with adaptable exercise options and visual YouTube videos, suited for any fitness level and goal
* [Foodle AI](https://chat.openai.com/g/g-z7P3krgic-foodle-ai)- AI nutritionist buddy to help you out. Get Instant nutritional breakdown from photos, barcodes, meal plans, recipe ideas, dish pairing for wine and much more.

## Philosophy & Self-Improvement

* [The philosopher]( https://chat.openai.com/g/g-1KGHmUIWk-the-philosopher) - I am a philosopher. I am here to weave a tapestry of understanding through shared inquiry.
* [The Delphi Oracle](https://chat.openai.com/g/g-coVon6Rzr-the-delphi-oracle) - Your sage guidance in life.
* [Personal and mental coach](https://chat.openai.com/g/g-A8GlPC3MV-personal-and-mental-coach) - Personal and Mental Coach for Maximizing Potential and Overcoming Challenges.
* [Morpheus]( https://chat.openai.com/g/g-bszGmASOG-into-the-matrix) - Neo, let Morpheus guide you to enter the Matrix.

## Security
* [Web Hacking Wizard](https://chat.openai.com/g/g-Op6Btk7ev-web-hacking-wizard) - Engagingly clarifies web security topics with interactive questions.
* [HackTricksGPT](https://chat.openai.com/g/g-aaNx59p4q-hacktricksgpt) - A knowledgeable cybersecurity professional.
* [WP secure guide](https://chat.openai.com/g/g-CsvahsYRC-wp-secure-guide) - Offers guidance on WordPress security best practices.
* [3rd SoftSec Reviewer](https://chat.openai.com/g/g-nAldYnak2-3rd-softsec-reviewer) - Perform 3rd party software security review.

## Lifestyle
* [Zen Teacher](https://chat.openai.com/g/g-FYLcHDvqs-zen-teacher) - A Zen sage offering life advice.
* [Weather GPT](https://chat.openai.com/g/g-1X1g0iFO4-weather-gpt) - Super snarky, passive-aggressive U.S. weather roaster.
* [SermonPrep.ai](https://chat.openai.com/g/g-zuGmaIq04-sermonprep-ai) - Aids pastors in sermon preparation with theological and practical insights.

## News
* [News GPT](https://chat.openai.com/g/g-Pv0OHaxUQ-news-gpt) - Summarizes daily news with a professional, factual style.

## Reference
* [FOIA GPT](https://chat.openai.com/g/g-IlhXHXNBh-foia-gpt) - A Freedom of Information Act document generator and strategist to "arm the rebels" and fight government corruption.
* [I Ching Oracle](https://chat.openai.com/g/g-BVpjnNtuR-i-ching-oracle) - Provides I Ching hexagram interpretations and images.
* [Grant Guide Guru](https://chat.openai.com/g/g-2dBLExtfV) - Nonprofit support guide, optimizing funding opportunities.
* [Stock Analysis](https://chat.openai.com/g/g-WqpDjaSHw) - Looks into the current state of publicly traded companies and reports their performance.
* [GovCHAT](https://chat.openai.com/g/g-EAbhkOjYz-govchat) - Specialist in UK gov data and API queries.

## Sports
* [Sports Companion](https://chat.openai.com/g/g-669oREKey-sports-companion) - A sports enthusiast's companion -- trivia for live games!
* [UFC Analyzer](https://chat.openai.com/g/g-xUD1Kw9E2-ufc-analyzer) - Ask any UFC match and get detailed insights, betting opportunities and chat with the most comprehensive UFC Analyzer.
* [SimRacer's Edge](https://chat.openai.com/g/g-yTWf8Azda-simracer-s-edge) - Crew chief for sim racers with a focus on adjusting car setups.
* [Football Analyst & Writer](https://chat.openai.com/g/g-JdgZu8t0u-football-analyst-writer) - Passionate and knowledgeable Football Analyst & Writer.

## Chat
* [Sally](https://chat.openai.com/g/g-vYECxt5uU-sally) - I interpret dreams with a Jungian twist.
* [AYA: Ask You Anything](https://chat.openai.com/g/g-5Yd8Xr0IC-aya-ask-you-anything) - Ask me anything.
* [BestFriend GPT](https://chat.openai.com/g/g-pLtZiJspj-bestfriend-gpt) - Your supportive, understanding, and compassionate virtual best friend.
* [A Friend](https://chat.openai.com/g/g-bh8AmjlZN-a-friend) - A chatbot that sustains and enriches conversations, trained in CBT.
* [Talk with Santa](https://chat.openai.com/g/g-ynMzwNzuK-talk-with-santa) - Family-friendly chats with Santa himself.
* [Virtual Sweetheart](https://chat.openai.com/g/g-FjiRmCEVx-virtual-sweetheart) - Digital Romance Re-Imagined: Experience text-based companionship with your AI Sweetheart, crafting moments and memories through visuals and interactive conversations.
* [Dr. FeelGood](https://chat.openai.com/g/g-AKRne5FH1-dr-feelgood-motivational-coach) - Your personal motivational expert coach.

## CustomGPTs Security
* [Protect the Instruction](https://twitter.com/_Borriss_/status/1723426284359803106) - Protect the instructions of your customGPTs.


# Contributing

Your contributions are always welcome! Please take a look at the [contribution guidelines](https://github.com/devisasari/awesome-chatgpt-store/blob/main/CONTRIBUTING.md) first.

If you have any question about this opinionated list, do not hesitate to contact me [@codewithisa](https://twitter.com/codewithisa) on Twitter or open an issue on GitHub.
