from ahnlich_client_py import clients
from ahnlich_client_py.internals import db_response


def test_client_sends_ping_to_db_success(module_scopped_ahnlich_db):
    port = module_scopped_ahnlich_db
    db_client = clients.AhnlichDBClient(address="127.0.0.1", port=port)
    try:
        response: db_response.ServerResult = db_client.ping()
        assert len(response.results) == 1
        assert response.results[0] == db_response.Result__Ok(
            db_response.ServerResponse__Pong()
        )

    except Exception as e:
        print(f"Exception: {e}")
        db_client.cleanup()
        raise e
    finally:
        db_client.cleanup()


def test_client_sends_list_clients_to_db_success(module_scopped_ahnlich_db):
    port = module_scopped_ahnlich_db
    db_client = clients.AhnlichDBClient(address="127.0.0.1", port=port)
    try:
        response: db_response.ServerResult = db_client.list_clients()
        assert len(response.results) == 1
    except Exception as e:
        print(f"Exception: {e}")
        db_client.cleanup()
        raise e
    finally:
        db_client.cleanup()


def test_client_sends_info_server_to_db_success(module_scopped_ahnlich_db):
    port = module_scopped_ahnlich_db

    db_client = clients.AhnlichDBClient(address="127.0.0.1", port=port)

    try:
        response: db_response.ServerResult = db_client.info_server()
        assert len(response.results) == 1
        info_server: db_response.ServerInfo = response.results[0].value
        assert info_server.value.version == db_client.message_protocol.version
        assert info_server.value.type == db_response.ServerType__Database()
    except Exception as e:
        print(f"Exception: {e}")
        db_client.cleanup()
        raise e
    finally:
        db_client.cleanup()


def test_client_sends_list_stores_to_fresh_database_succeeds(module_scopped_ahnlich_db):
    port = module_scopped_ahnlich_db

    db_client = clients.AhnlichDBClient(address="127.0.0.1", port=port)
    try:
        response: db_response.ServerResult = db_client.list_stores()
        assert response.results[0] == db_response.Result__Ok(
            db_response.ServerResponse__StoreList([])
        )
    except Exception as e:
        print(f"Exception: {e}")
        db_client.cleanup()
        raise e
    finally:
        db_client.cleanup()


def test_client_works_using_protocol_in_context(module_scopped_ahnlich_db):
    port = module_scopped_ahnlich_db
    db_client = clients.AhnlichDBClient(address="127.0.0.1", port=port)
    with clients.AhnlichDBClient(address="127.0.0.1", port=port) as db_client:
        response: db_response.ServerResult = db_client.list_stores()
    assert response.results[0] == db_response.Result__Ok(
        db_response.ServerResponse__StoreList([])
    )
