import React from 'react'

type ModalImageProps = {
    headerTypo: string
    headerBg: string
    controlBgPrimary: string
    controlTypoPrimary: string
}

const ModalImage = ({
    headerTypo = '#2d255e',
    headerBg = '#e3e1d8',
    controlTypoPrimary = '#FFF',
    controlBgPrimary = '#5357AE',
}: Partial<ModalImageProps>) => {
    return (
        <svg
            width="470"
            height="299"
            viewBox="0 0 470 299"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <g clip-path="url(#clip0_1115_5608)">
                <path
                    d="M447.685 0H22.3145C9.99056 0 0 9.99056 0 22.3145V276.142C0 288.466 9.99056 298.457 22.3145 298.457H447.685C460.009 298.457 470 288.466 470 276.142V22.3145C470 9.99056 460.009 0 447.685 0Z"
                    fill="white"
                />
                <path
                    d="M0 22.3145C0 9.99064 9.99064 0 22.3145 0H447.685C460.009 0 470 9.99064 470 22.3145V50.2077H0V22.3145Z"
                    fill={headerBg}
                />
                <path
                    d="M447.685 13.9466H436.528C433.447 13.9466 430.95 16.4442 430.95 19.5252V30.6825C430.95 33.7635 433.447 36.2611 436.528 36.2611H447.685C450.766 36.2611 453.264 33.7635 453.264 30.6825V19.5252C453.264 16.4442 450.766 13.9466 447.685 13.9466Z"
                    fill="#F5F4F1"
                />
                <path
                    d="M437.83 29.6309C438.152 29.9468 438.696 29.9419 438.99 29.6421L442.101 26.5313L445.212 29.6414C445.517 29.9468 446.057 29.9468 446.367 29.6309C446.683 29.3102 446.688 28.7809 446.378 28.4706L443.273 25.3605L446.378 22.2546C446.528 22.0982 446.611 21.8891 446.609 21.6721C446.607 21.4552 446.52 21.2477 446.367 21.0942C446.051 20.7783 445.517 20.7783 445.212 21.0831L442.101 24.1939L438.99 21.0838C438.696 20.7839 438.146 20.7728 437.83 21.0942C437.514 21.4101 437.525 21.9547 437.82 22.2546L440.935 25.3598L437.82 28.4762C437.525 28.7704 437.514 29.3199 437.83 29.6309Z"
                    fill="#5F0EBB"
                />
                <path
                    d="M444.896 66.9437H25.1039C20.4824 66.9437 16.7359 70.6901 16.7359 75.3116V195.252C16.7359 199.874 20.4824 203.62 25.1039 203.62H444.896C449.518 203.62 453.264 199.874 453.264 195.252V75.3116C453.264 70.6901 449.518 66.9437 444.896 66.9437Z"
                    fill="#F5F4F1"
                />

                <path
                    d="M30.6825 114.362C30.6825 109.741 34.4292 105.994 39.0504 105.994H430.95C435.571 105.994 439.318 109.741 439.318 114.362V136.677C439.318 141.298 435.571 145.045 430.95 145.045H39.0504C34.4292 145.045 30.6825 141.298 30.6825 136.677V114.362Z"
                    fill={controlBgPrimary}
                />
                <path
                    d="M425.371 125.519C425.371 121.668 422.249 118.546 418.398 118.546C414.546 118.546 411.424 121.668 411.424 125.519C411.424 129.371 414.546 132.493 418.398 132.493C422.249 132.493 425.371 129.371 425.371 125.519Z"
                    fill="#5F0EBB"
                />
                <path
                    d="M30.6825 158.991C30.6825 154.37 34.4292 150.623 39.0504 150.623H430.95C435.571 150.623 439.318 154.37 439.318 158.991V181.306C439.318 185.927 435.571 189.674 430.95 189.674H39.0504C34.4292 189.674 30.6825 185.927 30.6825 181.306V158.991Z"
                    fill={controlBgPrimary}
                />
                <path
                    d="M418.209 128.733C418.063 128.959 417.846 129.065 417.569 129.065C417.307 129.065 417.11 128.97 416.935 128.762L414.827 126.208C414.679 126.041 414.626 125.89 414.626 125.718C414.626 125.334 414.912 125.052 415.308 125.052C415.537 125.052 415.701 125.134 415.852 125.314L417.548 127.418L420.89 122.147C421.054 121.89 421.221 121.791 421.491 121.791C421.883 121.791 422.169 122.07 422.169 122.454C422.169 122.597 422.124 122.747 422.017 122.911L418.209 128.733Z"
                    fill={controlBgPrimary}
                />
                <path
                    d="M424.674 170.148C424.674 166.682 421.864 163.872 418.398 163.872C414.932 163.872 412.122 166.682 412.122 170.148C412.122 173.615 414.932 176.424 418.398 176.424C421.864 176.424 424.674 173.615 424.674 170.148Z"
                    stroke="#5F0EBB"
                    stroke-width="1.39466"
                />
                <path
                    d="M16.7359 245.46C16.7359 240.839 20.4827 237.092 25.1039 237.092H444.896C449.517 237.092 453.264 240.839 453.264 245.46V267.775C453.264 272.396 449.517 276.142 444.896 276.142H25.1039C20.4827 276.142 16.7359 272.396 16.7359 267.775V245.46Z"
                    fill={controlBgPrimary}
                />
                <path
                    d="M176.78 30.6039V19.2439H181.548C182.06 19.2439 182.529 19.3505 182.956 19.5639C183.383 19.7772 183.756 20.0599 184.076 20.4119C184.396 20.7639 184.641 21.1585 184.812 21.5959C184.983 22.0332 185.068 22.4812 185.068 22.9399C185.068 23.5692 184.924 24.1719 184.636 24.7479C184.359 25.3132 183.959 25.7719 183.436 26.1239C182.924 26.4759 182.327 26.6519 181.644 26.6519H178.572V30.6039H176.78ZM178.572 25.0679H181.532C181.873 25.0679 182.172 24.9772 182.428 24.7959C182.684 24.6039 182.881 24.3479 183.02 24.0279C183.169 23.7079 183.244 23.3452 183.244 22.9399C183.244 22.5239 183.159 22.1559 182.988 21.8359C182.817 21.5159 182.593 21.2705 182.316 21.0999C182.049 20.9185 181.756 20.8279 181.436 20.8279H178.572V25.0679ZM190.129 30.7639C189.467 30.7639 188.875 30.6519 188.353 30.4279C187.83 30.1932 187.377 29.8732 186.993 29.4679C186.619 29.0625 186.331 28.6039 186.129 28.0919C185.926 27.5692 185.825 27.0145 185.825 26.4279C185.825 25.8412 185.926 25.2865 186.129 24.7639C186.331 24.2412 186.619 23.7825 186.993 23.3879C187.377 22.9825 187.83 22.6679 188.353 22.4439C188.886 22.2092 189.478 22.0919 190.129 22.0919C190.779 22.0919 191.366 22.2092 191.889 22.4439C192.422 22.6679 192.875 22.9825 193.249 23.3879C193.633 23.7825 193.926 24.2412 194.128 24.7639C194.331 25.2865 194.433 25.8412 194.433 26.4279C194.433 27.0145 194.331 27.5692 194.128 28.0919C193.926 28.6039 193.633 29.0625 193.249 29.4679C192.875 29.8732 192.422 30.1932 191.889 30.4279C191.366 30.6519 190.779 30.7639 190.129 30.7639ZM187.633 26.4439C187.633 26.9772 187.745 27.4572 187.969 27.8839C188.193 28.3105 188.491 28.6465 188.865 28.8919C189.238 29.1372 189.659 29.2599 190.129 29.2599C190.587 29.2599 191.003 29.1372 191.377 28.8919C191.761 28.6359 192.065 28.2945 192.289 27.8679C192.513 27.4305 192.625 26.9505 192.625 26.4279C192.625 25.8945 192.513 25.4145 192.289 24.9879C192.065 24.5612 191.761 24.2252 191.377 23.9799C191.003 23.7239 190.587 23.5959 190.129 23.5959C189.659 23.5959 189.238 23.7239 188.865 23.9799C188.491 24.2359 188.193 24.5772 187.969 25.0039C187.745 25.4199 187.633 25.8999 187.633 26.4439ZM198.97 30.7639C198.266 30.7639 197.599 30.6519 196.97 30.4279C196.34 30.1932 195.802 29.8465 195.354 29.3879L196.01 28.2039C196.49 28.6305 196.97 28.9399 197.45 29.1319C197.94 29.3239 198.426 29.4199 198.906 29.4199C199.396 29.4199 199.796 29.3292 200.106 29.1479C200.415 28.9559 200.57 28.6785 200.57 28.3159C200.57 28.0492 200.49 27.8519 200.33 27.7239C200.17 27.5959 199.935 27.4839 199.626 27.3879C199.327 27.2919 198.964 27.1852 198.538 27.0679C197.94 26.8865 197.439 26.6999 197.034 26.5079C196.628 26.3052 196.324 26.0599 196.122 25.7719C195.919 25.4839 195.818 25.1159 195.818 24.6679C195.818 24.1239 195.956 23.6599 196.234 23.2759C196.511 22.8919 196.895 22.5985 197.386 22.3959C197.887 22.1932 198.463 22.0919 199.114 22.0919C199.722 22.0919 200.282 22.1879 200.794 22.3799C201.316 22.5612 201.775 22.8492 202.17 23.2439L201.418 24.4119C201.044 24.0705 200.66 23.8199 200.266 23.6599C199.882 23.4999 199.466 23.4199 199.018 23.4199C198.762 23.4199 198.516 23.4519 198.282 23.5159C198.047 23.5692 197.85 23.6759 197.69 23.8359C197.54 23.9852 197.466 24.1985 197.466 24.4759C197.466 24.6999 197.53 24.8812 197.658 25.0199C197.786 25.1585 197.978 25.2759 198.234 25.3719C198.49 25.4679 198.804 25.5745 199.178 25.6919C199.828 25.8839 200.383 26.0759 200.842 26.2679C201.3 26.4492 201.652 26.6892 201.898 26.9879C202.154 27.2759 202.282 27.6759 202.282 28.1879C202.282 28.9985 201.978 29.6332 201.37 30.0919C200.772 30.5399 199.972 30.7639 198.97 30.7639ZM208.493 30.1719C208.344 30.2465 208.157 30.3265 207.933 30.4119C207.709 30.4972 207.453 30.5719 207.165 30.6359C206.888 30.6999 206.6 30.7319 206.301 30.7319C205.939 30.7319 205.603 30.6679 205.293 30.5399C204.984 30.4119 204.733 30.2092 204.541 29.9319C204.36 29.6439 204.269 29.2759 204.269 28.8279V23.5959H203.165V22.2359H204.269V19.4839H206.029V22.2359H207.853V23.5959H206.029V28.2679C206.051 28.5559 206.141 28.7692 206.301 28.9079C206.472 29.0465 206.68 29.1159 206.925 29.1159C207.171 29.1159 207.405 29.0732 207.629 28.9879C207.853 28.9025 208.019 28.8332 208.125 28.7799L208.493 30.1719ZM214.464 30.7639C213.792 30.7639 213.2 30.6039 212.688 30.2839C212.176 29.9639 211.771 29.5479 211.472 29.0359V34.0119H209.712V22.2359H211.264V23.7399C211.584 23.2385 212 22.8385 212.512 22.5399C213.024 22.2412 213.595 22.0919 214.224 22.0919C214.8 22.0919 215.328 22.2092 215.808 22.4439C216.288 22.6679 216.704 22.9825 217.056 23.3879C217.408 23.7932 217.68 24.2572 217.872 24.7799C218.075 25.2919 218.176 25.8359 218.176 26.4119C218.176 27.2119 218.016 27.9425 217.696 28.6039C217.387 29.2652 216.95 29.7932 216.384 30.1879C215.83 30.5719 215.19 30.7639 214.464 30.7639ZM213.888 29.2599C214.262 29.2599 214.598 29.1799 214.896 29.0199C215.206 28.8599 215.467 28.6465 215.68 28.3799C215.904 28.1132 216.075 27.8092 216.192 27.4679C216.31 27.1265 216.368 26.7745 216.368 26.4119C216.368 26.0279 216.304 25.6652 216.176 25.3239C216.048 24.9825 215.862 24.6839 215.616 24.4279C215.382 24.1719 215.104 23.9692 214.784 23.8199C214.475 23.6705 214.134 23.5959 213.76 23.5959C213.536 23.5959 213.302 23.6385 213.056 23.7239C212.811 23.8092 212.582 23.9265 212.368 24.0759C212.155 24.2252 211.968 24.4012 211.808 24.6039C211.648 24.8065 211.536 25.0199 211.472 25.2439V27.4359C211.622 27.7772 211.819 28.0865 212.064 28.3639C212.31 28.6305 212.592 28.8492 212.912 29.0199C213.232 29.1799 213.558 29.2599 213.888 29.2599ZM223.519 30.7639C222.858 30.7639 222.266 30.6519 221.743 30.4279C221.22 30.1932 220.767 29.8732 220.383 29.4679C220.01 29.0625 219.722 28.6039 219.519 28.0919C219.316 27.5692 219.215 27.0145 219.215 26.4279C219.215 25.8412 219.316 25.2865 219.519 24.7639C219.722 24.2412 220.01 23.7825 220.383 23.3879C220.767 22.9825 221.22 22.6679 221.743 22.4439C222.276 22.2092 222.868 22.0919 223.519 22.0919C224.17 22.0919 224.756 22.2092 225.279 22.4439C225.812 22.6679 226.266 22.9825 226.639 23.3879C227.023 23.7825 227.316 24.2412 227.519 24.7639C227.722 25.2865 227.823 25.8412 227.823 26.4279C227.823 27.0145 227.722 27.5692 227.519 28.0919C227.316 28.6039 227.023 29.0625 226.639 29.4679C226.266 29.8732 225.812 30.1932 225.279 30.4279C224.756 30.6519 224.17 30.7639 223.519 30.7639ZM221.023 26.4439C221.023 26.9772 221.135 27.4572 221.359 27.8839C221.583 28.3105 221.882 28.6465 222.255 28.8919C222.628 29.1372 223.05 29.2599 223.519 29.2599C223.978 29.2599 224.394 29.1372 224.767 28.8919C225.151 28.6359 225.455 28.2945 225.679 27.8679C225.903 27.4305 226.015 26.9505 226.015 26.4279C226.015 25.8945 225.903 25.4145 225.679 24.9879C225.455 24.5612 225.151 24.2252 224.767 23.9799C224.394 23.7239 223.978 23.5959 223.519 23.5959C223.05 23.5959 222.628 23.7239 222.255 23.9799C221.882 24.2359 221.583 24.5772 221.359 25.0039C221.135 25.4199 221.023 25.8999 221.023 26.4439ZM236.888 30.6039H235.128V25.9159C235.128 25.1372 235 24.5665 234.744 24.2039C234.499 23.8412 234.131 23.6599 233.64 23.6599C233.299 23.6599 232.957 23.7452 232.616 23.9159C232.285 24.0865 231.987 24.3212 231.72 24.6199C231.453 24.9079 231.261 25.2439 231.144 25.6279V30.6039H229.384V22.2359H230.984V23.9159C231.197 23.5425 231.475 23.2225 231.816 22.9559C232.168 22.6785 232.563 22.4652 233 22.3159C233.437 22.1665 233.901 22.0919 234.392 22.0919C234.893 22.0919 235.304 22.1825 235.624 22.3639C235.955 22.5452 236.211 22.7959 236.392 23.1159C236.584 23.4252 236.712 23.7879 236.776 24.2039C236.851 24.6092 236.888 25.0412 236.888 25.4999V30.6039ZM242.723 30.7639C242.072 30.7639 241.48 30.6519 240.947 30.4279C240.424 30.1932 239.971 29.8785 239.587 29.4839C239.203 29.0785 238.904 28.6199 238.691 28.1079C238.488 27.5852 238.387 27.0305 238.387 26.4439C238.387 25.6545 238.568 24.9345 238.931 24.2839C239.294 23.6225 239.8 23.0945 240.451 22.6999C241.102 22.2945 241.864 22.0919 242.739 22.0919C243.614 22.0919 244.366 22.2945 244.995 22.6999C245.635 23.0945 246.131 23.6172 246.483 24.2679C246.835 24.9185 247.011 25.6172 247.011 26.3639C247.011 26.4919 247.006 26.6145 246.995 26.7319C246.984 26.8385 246.974 26.9292 246.963 27.0039H240.259C240.291 27.4945 240.424 27.9265 240.659 28.2999C240.904 28.6625 241.214 28.9505 241.587 29.1639C241.96 29.3665 242.36 29.4679 242.787 29.4679C243.256 29.4679 243.699 29.3505 244.115 29.1159C244.542 28.8812 244.83 28.5719 244.979 28.1879L246.483 28.6199C246.302 29.0252 246.024 29.3932 245.651 29.7239C245.288 30.0439 244.856 30.2999 244.355 30.4919C243.854 30.6732 243.31 30.7639 242.723 30.7639ZM240.211 25.8359H245.267C245.235 25.3559 245.096 24.9345 244.851 24.5719C244.616 24.1985 244.312 23.9105 243.939 23.7079C243.576 23.4945 243.171 23.3879 242.723 23.3879C242.286 23.3879 241.88 23.4945 241.507 23.7079C241.144 23.9105 240.846 24.1985 240.611 24.5719C240.376 24.9345 240.243 25.3559 240.211 25.8359ZM257.056 30.1719C256.906 30.2465 256.72 30.3265 256.496 30.4119C256.272 30.4972 256.016 30.5719 255.728 30.6359C255.45 30.6999 255.162 30.7319 254.864 30.7319C254.501 30.7319 254.165 30.6679 253.856 30.5399C253.546 30.4119 253.296 30.2092 253.104 29.9319C252.922 29.6439 252.832 29.2759 252.832 28.8279V23.5959H251.728V22.2359H252.832V19.4839H254.592V22.2359H256.416V23.5959H254.592V28.2679C254.613 28.5559 254.704 28.7692 254.864 28.9079C255.034 29.0465 255.242 29.1159 255.488 29.1159C255.733 29.1159 255.968 29.0732 256.192 28.9879C256.416 28.9025 256.581 28.8332 256.688 28.7799L257.056 30.1719ZM258.275 30.6039V22.2359H260.035V30.6039H258.275ZM258.275 20.8599V18.9239H260.035V20.8599H258.275ZM265.942 30.7639C265.291 30.7639 264.699 30.6519 264.166 30.4279C263.643 30.1932 263.19 29.8732 262.806 29.4679C262.422 29.0625 262.123 28.5985 261.91 28.0759C261.707 27.5532 261.606 26.9985 261.606 26.4119C261.606 25.6225 261.782 24.9025 262.134 24.2519C262.496 23.6012 262.998 23.0785 263.638 22.6839C264.288 22.2892 265.056 22.0919 265.942 22.0919C266.795 22.0919 267.536 22.2839 268.166 22.6679C268.806 23.0412 269.275 23.5425 269.574 24.1719L267.862 24.7159C267.67 24.3639 267.398 24.0919 267.046 23.8999C266.704 23.6972 266.326 23.5959 265.91 23.5959C265.44 23.5959 265.014 23.7185 264.63 23.9639C264.256 24.1985 263.958 24.5292 263.734 24.9559C263.52 25.3719 263.414 25.8572 263.414 26.4119C263.414 26.9452 263.526 27.4305 263.75 27.8679C263.974 28.2945 264.272 28.6359 264.646 28.8919C265.03 29.1372 265.456 29.2599 265.926 29.2599C266.214 29.2599 266.491 29.2119 266.758 29.1159C267.035 29.0092 267.275 28.8705 267.478 28.6999C267.68 28.5185 267.824 28.3212 267.91 28.1079L269.638 28.6199C269.456 29.0359 269.184 29.4039 268.822 29.7239C268.47 30.0439 268.048 30.2999 267.558 30.4919C267.078 30.6732 266.539 30.7639 265.942 30.7639ZM276.911 30.6039L274.223 26.7479L272.847 28.0599V30.6039H271.087V18.9239H272.847V26.2839L276.719 22.2519H278.607L275.359 25.7559L278.783 30.6039H276.911ZM283.207 30.7639C282.557 30.7639 281.965 30.6519 281.431 30.4279C280.909 30.1932 280.455 29.8785 280.071 29.4839C279.687 29.0785 279.389 28.6199 279.175 28.1079C278.973 27.5852 278.871 27.0305 278.871 26.4439C278.871 25.6545 279.053 24.9345 279.415 24.2839C279.778 23.6225 280.285 23.0945 280.935 22.6999C281.586 22.2945 282.349 22.0919 283.223 22.0919C284.098 22.0919 284.85 22.2945 285.479 22.6999C286.119 23.0945 286.615 23.6172 286.967 24.2679C287.319 24.9185 287.495 25.6172 287.495 26.3639C287.495 26.4919 287.49 26.6145 287.479 26.7319C287.469 26.8385 287.458 26.9292 287.447 27.0039H280.743C280.775 27.4945 280.909 27.9265 281.143 28.2999C281.389 28.6625 281.698 28.9505 282.071 29.1639C282.445 29.3665 282.845 29.4679 283.271 29.4679C283.741 29.4679 284.183 29.3505 284.599 29.1159C285.026 28.8812 285.314 28.5719 285.463 28.1879L286.967 28.6199C286.786 29.0252 286.509 29.3932 286.135 29.7239C285.773 30.0439 285.341 30.2999 284.839 30.4919C284.338 30.6732 283.794 30.7639 283.207 30.7639ZM280.695 25.8359H285.751C285.719 25.3559 285.581 24.9345 285.335 24.5719C285.101 24.1985 284.797 23.9105 284.423 23.7079C284.061 23.4945 283.655 23.3879 283.207 23.3879C282.77 23.3879 282.365 23.4945 281.991 23.7079C281.629 23.9105 281.33 24.1985 281.095 24.5719C280.861 24.9345 280.727 25.3559 280.695 25.8359ZM293.509 30.1719C293.36 30.2465 293.173 30.3265 292.949 30.4119C292.725 30.4972 292.469 30.5719 292.181 30.6359C291.904 30.6999 291.616 30.7319 291.317 30.7319C290.954 30.7319 290.618 30.6679 290.309 30.5399C290 30.4119 289.749 30.2092 289.557 29.9319C289.376 29.6439 289.285 29.2759 289.285 28.8279V23.5959H288.181V22.2359H289.285V19.4839H291.045V22.2359H292.869V23.5959H291.045V28.2679C291.066 28.5559 291.157 28.7692 291.317 28.9079C291.488 29.0465 291.696 29.1159 291.941 29.1159C292.186 29.1159 292.421 29.0732 292.645 28.9879C292.869 28.9025 293.034 28.8332 293.141 28.7799L293.509 30.1719Z"
                    fill={headerTypo}
                />
                <path
                    d="M35.9325 91.3908C35.2138 91.3908 34.5652 91.2508 33.9865 90.9708C33.4078 90.6815 32.9085 90.2988 32.4885 89.8228C32.0685 89.3468 31.7418 88.8101 31.5085 88.2128C31.2845 87.6061 31.1725 86.9855 31.1725 86.3508C31.1725 85.6881 31.2938 85.0581 31.5365 84.4608C31.7792 83.8541 32.1152 83.3175 32.5445 82.8508C32.9738 82.3748 33.4778 82.0015 34.0565 81.7308C34.6445 81.4508 35.2792 81.3108 35.9605 81.3108C36.6698 81.3108 37.3138 81.4555 37.8925 81.7448C38.4805 82.0341 38.9798 82.4215 39.3905 82.9068C39.8105 83.3921 40.1325 83.9335 40.3565 84.5308C40.5898 85.1281 40.7065 85.7395 40.7065 86.3648C40.7065 87.0275 40.5852 87.6621 40.3425 88.2688C40.1092 88.8661 39.7778 89.4028 39.3485 89.8788C38.9192 90.3455 38.4105 90.7141 37.8225 90.9848C37.2438 91.2555 36.6138 91.3908 35.9325 91.3908ZM35.9465 89.9768C36.4505 89.9768 36.8985 89.8741 37.2905 89.6688C37.6825 89.4635 38.0092 89.1881 38.2705 88.8428C38.5412 88.4881 38.7465 88.0961 38.8865 87.6668C39.0265 87.2281 39.0965 86.7895 39.0965 86.3508C39.0965 85.8841 39.0218 85.4315 38.8725 84.9928C38.7325 84.5541 38.5225 84.1668 38.2425 83.8308C37.9625 83.4948 37.6265 83.2288 37.2345 83.0328C36.8518 82.8275 36.4225 82.7248 35.9465 82.7248C35.4425 82.7248 34.9945 82.8275 34.6025 83.0328C34.2105 83.2381 33.8792 83.5181 33.6085 83.8728C33.3378 84.2181 33.1278 84.6055 32.9785 85.0348C32.8385 85.4641 32.7685 85.9028 32.7685 86.3508C32.7685 86.8175 32.8432 87.2701 32.9925 87.7088C33.1418 88.1475 33.3518 88.5348 33.6225 88.8708C33.9025 89.2068 34.2385 89.4775 34.6305 89.6828C35.0225 89.8788 35.4612 89.9768 35.9465 89.9768ZM36.1425 87.8628H37.6545L40.6785 91.3208H39.1665L36.1425 87.8628Z"
                    fill="#5F0EBB"
                />
                <path
                    d="M42.0365 88.4788V83.9988H43.5765V88.1708C43.5765 88.8241 43.6932 89.3188 43.9265 89.6548C44.1692 89.9815 44.5192 90.1448 44.9765 90.1448C45.2658 90.1448 45.5458 90.0841 45.8165 89.9628C46.0965 89.8415 46.3485 89.6641 46.5725 89.4308C46.8058 89.1881 46.9925 88.8988 47.1325 88.5628V83.9988H48.6725V89.5848C48.6725 89.7621 48.7052 89.8881 48.7705 89.9628C48.8358 90.0375 48.9432 90.0795 49.0925 90.0888V91.3208C48.9338 91.3488 48.8032 91.3675 48.7005 91.3768C48.5978 91.3861 48.4998 91.3908 48.4065 91.3908C48.1265 91.3908 47.8932 91.3161 47.7065 91.1668C47.5198 91.0081 47.4125 90.8075 47.3845 90.5648L47.3565 89.8368C47.0298 90.3688 46.6052 90.7748 46.0825 91.0548C45.5598 91.3255 44.9858 91.4608 44.3605 91.4608C43.5952 91.4608 43.0165 91.2088 42.6245 90.7048C42.2325 90.2008 42.0365 89.4588 42.0365 88.4788Z"
                    fill="#5F0EBB"
                />
                <path
                    d="M53.9557 91.4608C53.3864 91.4608 52.8684 91.3628 52.4017 91.1668C51.9444 90.9615 51.5477 90.6861 51.2117 90.3408C50.8757 89.9861 50.6144 89.5848 50.4277 89.1368C50.2504 88.6795 50.1617 88.1941 50.1617 87.6808C50.1617 86.9901 50.3204 86.3601 50.6377 85.7908C50.9551 85.2121 51.3984 84.7501 51.9677 84.4048C52.5371 84.0501 53.2044 83.8728 53.9697 83.8728C54.7351 83.8728 55.3931 84.0501 55.9437 84.4048C56.5037 84.7501 56.9377 85.2075 57.2457 85.7768C57.5537 86.3461 57.7077 86.9575 57.7077 87.6108C57.7077 87.7228 57.7031 87.8301 57.6937 87.9328C57.6844 88.0261 57.6751 88.1055 57.6657 88.1708H51.7997C51.8277 88.6001 51.9444 88.9781 52.1497 89.3048C52.3644 89.6221 52.6351 89.8741 52.9617 90.0608C53.2884 90.2381 53.6384 90.3268 54.0117 90.3268C54.4224 90.3268 54.8097 90.2241 55.1737 90.0188C55.5471 89.8135 55.7991 89.5428 55.9297 89.2068L57.2457 89.5848C57.0871 89.9395 56.8444 90.2615 56.5177 90.5508C56.2004 90.8308 55.8224 91.0548 55.3837 91.2228C54.9451 91.3815 54.4691 91.4608 53.9557 91.4608ZM51.7577 87.1488H56.1817C56.1537 86.7288 56.0324 86.3601 55.8177 86.0428C55.6124 85.7161 55.3464 85.4641 55.0197 85.2868C54.7024 85.1001 54.3477 85.0068 53.9557 85.0068C53.5731 85.0068 53.2184 85.1001 52.8917 85.2868C52.5744 85.4641 52.3131 85.7161 52.1077 86.0428C51.9024 86.3601 51.7857 86.7288 51.7577 87.1488Z"
                    fill="#5F0EBB"
                />
                <path
                    d="M58.8939 88.4788V83.9988H60.4339V88.1708C60.4339 88.8241 60.5506 89.3188 60.7839 89.6548C61.0266 89.9815 61.3766 90.1448 61.8339 90.1448C62.1232 90.1448 62.4032 90.0841 62.6739 89.9628C62.9539 89.8415 63.2059 89.6641 63.4299 89.4308C63.6632 89.1881 63.8499 88.8988 63.9899 88.5628V83.9988H65.5299V89.5848C65.5299 89.7621 65.5626 89.8881 65.6279 89.9628C65.6932 90.0375 65.8006 90.0795 65.9499 90.0888V91.3208C65.7912 91.3488 65.6606 91.3675 65.5579 91.3768C65.4552 91.3861 65.3572 91.3908 65.2639 91.3908C64.9839 91.3908 64.7506 91.3161 64.5639 91.1668C64.3772 91.0081 64.2699 90.8075 64.2419 90.5648L64.2139 89.8368C63.8872 90.3688 63.4626 90.7748 62.9399 91.0548C62.4172 91.3255 61.8432 91.4608 61.2179 91.4608C60.4526 91.4608 59.8739 91.2088 59.4819 90.7048C59.0899 90.2008 58.8939 89.4588 58.8939 88.4788Z"
                    fill="#5F0EBB"
                />
                <path
                    d="M70.8132 91.4608C70.2438 91.4608 69.7258 91.3628 69.2592 91.1668C68.8018 90.9615 68.4052 90.6861 68.0692 90.3408C67.7332 89.9861 67.4718 89.5848 67.2852 89.1368C67.1078 88.6795 67.0192 88.1941 67.0192 87.6808C67.0192 86.9901 67.1778 86.3601 67.4952 85.7908C67.8125 85.2121 68.2558 84.7501 68.8252 84.4048C69.3945 84.0501 70.0618 83.8728 70.8272 83.8728C71.5925 83.8728 72.2505 84.0501 72.8012 84.4048C73.3612 84.7501 73.7952 85.2075 74.1032 85.7768C74.4112 86.3461 74.5652 86.9575 74.5652 87.6108C74.5652 87.7228 74.5605 87.8301 74.5512 87.9328C74.5418 88.0261 74.5325 88.1055 74.5232 88.1708H68.6572C68.6852 88.6001 68.8018 88.9781 69.0072 89.3048C69.2218 89.6221 69.4925 89.8741 69.8192 90.0608C70.1458 90.2381 70.4958 90.3268 70.8692 90.3268C71.2798 90.3268 71.6672 90.2241 72.0312 90.0188C72.4045 89.8135 72.6565 89.5428 72.7872 89.2068L74.1032 89.5848C73.9445 89.9395 73.7018 90.2615 73.3752 90.5508C73.0578 90.8308 72.6798 91.0548 72.2412 91.2228C71.8025 91.3815 71.3265 91.4608 70.8132 91.4608ZM68.6152 87.1488H73.0392C73.0112 86.7288 72.8898 86.3601 72.6752 86.0428C72.4698 85.7161 72.2038 85.4641 71.8772 85.2868C71.5598 85.1001 71.2052 85.0068 70.8132 85.0068C70.4305 85.0068 70.0758 85.1001 69.7492 85.2868C69.4318 85.4641 69.1705 85.7161 68.9652 86.0428C68.7598 86.3601 68.6432 86.7288 68.6152 87.1488Z"
                    fill="#5F0EBB"
                />
                <path
                    d="M83.3543 90.9428C83.2236 91.0081 83.0603 91.0781 82.8643 91.1528C82.6683 91.2275 82.4443 91.2928 82.1923 91.3488C81.9496 91.4048 81.6976 91.4328 81.4363 91.4328C81.119 91.4328 80.825 91.3768 80.5543 91.2648C80.2836 91.1528 80.0643 90.9755 79.8963 90.7328C79.7376 90.4808 79.6583 90.1588 79.6583 89.7668V85.1888H78.6923V83.9988H79.6583V81.5908H81.1983V83.9988H82.7943V85.1888H81.1983V89.2768C81.217 89.5288 81.2963 89.7155 81.4363 89.8368C81.5856 89.9581 81.7676 90.0188 81.9823 90.0188C82.197 90.0188 82.4023 89.9815 82.5983 89.9068C82.7943 89.8321 82.939 89.7715 83.0323 89.7248L83.3543 90.9428Z"
                    fill="#5F0EBB"
                />
                <path
                    d="M84.6593 93.0428C84.7993 93.0615 84.9346 93.0801 85.0653 93.0988C85.2053 93.1268 85.3173 93.1408 85.4013 93.1408C85.5599 93.1408 85.6953 93.0895 85.8073 92.9868C85.9286 92.8935 86.0499 92.7161 86.1713 92.4548C86.2926 92.1935 86.4419 91.8155 86.6193 91.3208L83.6093 83.9988H85.2193L87.4593 89.7528L89.4473 83.9988H90.9313L87.6133 93.0148C87.5106 93.2855 87.3613 93.5328 87.1653 93.7568C86.9693 93.9901 86.7266 94.1721 86.4373 94.3028C86.1479 94.4335 85.8073 94.4988 85.4153 94.4988C85.3033 94.4988 85.1866 94.4895 85.0653 94.4708C84.9439 94.4521 84.8086 94.4241 84.6593 94.3868V93.0428Z"
                    fill="#5F0EBB"
                />
                <path
                    d="M96.2215 91.4608C95.6335 91.4608 95.1155 91.3208 94.6675 91.0408C94.2195 90.7608 93.8648 90.3968 93.6035 89.9488V94.3028H92.0635V83.9988H93.4215V85.3148C93.7015 84.8761 94.0655 84.5261 94.5135 84.2648C94.9615 84.0035 95.4609 83.8728 96.0115 83.8728C96.5155 83.8728 96.9775 83.9755 97.3975 84.1808C97.8175 84.3768 98.1815 84.6521 98.4895 85.0068C98.7975 85.3615 99.0355 85.7675 99.2035 86.2248C99.3808 86.6728 99.4695 87.1488 99.4695 87.6528C99.4695 88.3528 99.3295 88.9921 99.0495 89.5708C98.7788 90.1495 98.3962 90.6115 97.9015 90.9568C97.4162 91.2928 96.8562 91.4608 96.2215 91.4608ZM95.7175 90.1448C96.0442 90.1448 96.3382 90.0748 96.5995 89.9348C96.8702 89.7948 97.0988 89.6081 97.2855 89.3748C97.4815 89.1415 97.6309 88.8755 97.7335 88.5768C97.8362 88.2781 97.8875 87.9701 97.8875 87.6528C97.8875 87.3168 97.8315 86.9995 97.7195 86.7008C97.6075 86.4021 97.4442 86.1408 97.2295 85.9168C97.0242 85.6928 96.7815 85.5155 96.5015 85.3848C96.2309 85.2541 95.9322 85.1888 95.6055 85.1888C95.4095 85.1888 95.2042 85.2261 94.9895 85.3008C94.7748 85.3755 94.5742 85.4781 94.3875 85.6088C94.2008 85.7395 94.0375 85.8935 93.8975 86.0708C93.7575 86.2481 93.6595 86.4348 93.6035 86.6308V88.5488C93.7342 88.8475 93.9068 89.1181 94.1215 89.3608C94.3362 89.5941 94.5835 89.7855 94.8635 89.9348C95.1435 90.0748 95.4282 90.1448 95.7175 90.1448Z"
                    fill="#5F0EBB"
                />
                <path
                    d="M104.173 91.4608C103.603 91.4608 103.085 91.3628 102.619 91.1668C102.161 90.9615 101.765 90.6861 101.429 90.3408C101.093 89.9861 100.831 89.5848 100.645 89.1368C100.467 88.6795 100.379 88.1941 100.379 87.6808C100.379 86.9901 100.537 86.3601 100.855 85.7908C101.172 85.2121 101.615 84.7501 102.185 84.4048C102.754 84.0501 103.421 83.8728 104.187 83.8728C104.952 83.8728 105.61 84.0501 106.161 84.4048C106.721 84.7501 107.155 85.2075 107.463 85.7768C107.771 86.3461 107.925 86.9575 107.925 87.6108C107.925 87.7228 107.92 87.8301 107.911 87.9328C107.901 88.0261 107.892 88.1055 107.883 88.1708H102.017C102.045 88.6001 102.161 88.9781 102.367 89.3048C102.581 89.6221 102.852 89.8741 103.179 90.0608C103.505 90.2381 103.855 90.3268 104.229 90.3268C104.639 90.3268 105.027 90.2241 105.391 90.0188C105.764 89.8135 106.016 89.5428 106.147 89.2068L107.463 89.5848C107.304 89.9395 107.061 90.2615 106.735 90.5508C106.417 90.8308 106.039 91.0548 105.601 91.2228C105.162 91.3815 104.686 91.4608 104.173 91.4608ZM101.975 87.1488H106.399C106.371 86.7288 106.249 86.3601 106.035 86.0428C105.829 85.7161 105.563 85.4641 105.237 85.2868C104.919 85.1001 104.565 85.0068 104.173 85.0068C103.79 85.0068 103.435 85.1001 103.109 85.2868C102.791 85.4641 102.53 85.7161 102.325 86.0428C102.119 86.3601 102.003 86.7288 101.975 87.1488Z"
                    fill="#5F0EBB"
                />
                <path
                    d="M204.99 256.577C204.99 255.971 205.097 255.378 205.312 254.799C205.527 254.211 205.839 253.679 206.25 253.203C206.67 252.718 207.179 252.335 207.776 252.055C208.373 251.766 209.05 251.621 209.806 251.621C210.702 251.621 211.477 251.827 212.13 252.237C212.783 252.639 213.269 253.157 213.586 253.791L212.354 254.617C212.167 254.216 211.929 253.899 211.64 253.665C211.36 253.432 211.052 253.269 210.716 253.175C210.389 253.082 210.067 253.035 209.75 253.035C209.227 253.035 208.77 253.143 208.378 253.357C207.986 253.563 207.655 253.838 207.384 254.183C207.123 254.529 206.922 254.916 206.782 255.345C206.651 255.775 206.586 256.204 206.586 256.633C206.586 257.109 206.665 257.571 206.824 258.019C206.983 258.458 207.202 258.85 207.482 259.195C207.771 259.531 208.112 259.797 208.504 259.993C208.896 260.189 209.325 260.287 209.792 260.287C210.109 260.287 210.441 260.231 210.786 260.119C211.131 260.007 211.449 259.835 211.738 259.601C212.037 259.359 212.27 259.041 212.438 258.649L213.74 259.391C213.535 259.886 213.213 260.306 212.774 260.651C212.345 260.997 211.859 261.258 211.318 261.435C210.786 261.613 210.259 261.701 209.736 261.701C209.036 261.701 208.397 261.557 207.818 261.267C207.239 260.969 206.74 260.577 206.32 260.091C205.9 259.597 205.573 259.046 205.34 258.439C205.107 257.823 204.99 257.203 204.99 256.577ZM218.271 261.757C217.692 261.757 217.174 261.659 216.717 261.463C216.259 261.258 215.863 260.978 215.527 260.623C215.2 260.269 214.948 259.867 214.771 259.419C214.593 258.962 214.505 258.477 214.505 257.963C214.505 257.45 214.593 256.965 214.771 256.507C214.948 256.05 215.2 255.649 215.527 255.303C215.863 254.949 216.259 254.673 216.717 254.477C217.183 254.272 217.701 254.169 218.271 254.169C218.84 254.169 219.353 254.272 219.811 254.477C220.277 254.673 220.674 254.949 221.001 255.303C221.337 255.649 221.593 256.05 221.771 256.507C221.948 256.965 222.037 257.45 222.037 257.963C222.037 258.477 221.948 258.962 221.771 259.419C221.593 259.867 221.337 260.269 221.001 260.623C220.674 260.978 220.277 261.258 219.811 261.463C219.353 261.659 218.84 261.757 218.271 261.757ZM216.087 257.977C216.087 258.444 216.185 258.864 216.381 259.237C216.577 259.611 216.838 259.905 217.165 260.119C217.491 260.334 217.86 260.441 218.271 260.441C218.672 260.441 219.036 260.334 219.363 260.119C219.699 259.895 219.965 259.597 220.161 259.223C220.357 258.841 220.455 258.421 220.455 257.963C220.455 257.497 220.357 257.077 220.161 256.703C219.965 256.33 219.699 256.036 219.363 255.821C219.036 255.597 218.672 255.485 218.271 255.485C217.86 255.485 217.491 255.597 217.165 255.821C216.838 256.045 216.577 256.344 216.381 256.717C216.185 257.081 216.087 257.501 216.087 257.977ZM229.969 261.617H228.429V257.515C228.429 256.834 228.317 256.335 228.093 256.017C227.878 255.7 227.556 255.541 227.127 255.541C226.828 255.541 226.529 255.616 226.231 255.765C225.941 255.915 225.68 256.12 225.447 256.381C225.213 256.633 225.045 256.927 224.943 257.263V261.617H223.403V254.295H224.803V255.765C224.989 255.439 225.232 255.159 225.531 254.925C225.839 254.683 226.184 254.496 226.567 254.365C226.949 254.235 227.355 254.169 227.785 254.169C228.223 254.169 228.583 254.249 228.863 254.407C229.152 254.566 229.376 254.785 229.535 255.065C229.703 255.336 229.815 255.653 229.871 256.017C229.936 256.372 229.969 256.75 229.969 257.151V261.617ZM235.775 261.239C235.645 261.305 235.481 261.375 235.285 261.449C235.089 261.524 234.865 261.589 234.613 261.645C234.371 261.701 234.119 261.729 233.857 261.729C233.54 261.729 233.246 261.673 232.975 261.561C232.705 261.449 232.485 261.272 232.317 261.029C232.159 260.777 232.079 260.455 232.079 260.063V255.485H231.113V254.295H232.079V251.887H233.619V254.295H235.215V255.485H233.619V259.573C233.638 259.825 233.717 260.012 233.857 260.133C234.007 260.255 234.189 260.315 234.403 260.315C234.618 260.315 234.823 260.278 235.019 260.203C235.215 260.129 235.36 260.068 235.453 260.021L235.775 261.239ZM236.842 261.617V254.295H238.382V261.617H236.842ZM236.842 253.091V251.397H238.382V253.091H236.842ZM246.799 261.617H245.259V257.515C245.259 256.834 245.147 256.335 244.923 256.017C244.708 255.7 244.386 255.541 243.957 255.541C243.658 255.541 243.359 255.616 243.061 255.765C242.771 255.915 242.51 256.12 242.277 256.381C242.043 256.633 241.875 256.927 241.773 257.263V261.617H240.233V254.295H241.633V255.765C241.819 255.439 242.062 255.159 242.361 254.925C242.669 254.683 243.014 254.496 243.397 254.365C243.779 254.235 244.185 254.169 244.615 254.169C245.053 254.169 245.413 254.249 245.693 254.407C245.982 254.566 246.206 254.785 246.365 255.065C246.533 255.336 246.645 255.653 246.701 256.017C246.766 256.372 246.799 256.75 246.799 257.151V261.617ZM248.516 258.775V254.295H250.056V258.467C250.056 259.121 250.173 259.615 250.406 259.951C250.649 260.278 250.999 260.441 251.456 260.441C251.745 260.441 252.025 260.381 252.296 260.259C252.576 260.138 252.828 259.961 253.052 259.727C253.285 259.485 253.472 259.195 253.612 258.859V254.295H255.152V259.881C255.152 260.059 255.185 260.185 255.25 260.259C255.315 260.334 255.423 260.376 255.572 260.385V261.617C255.413 261.645 255.283 261.664 255.18 261.673C255.077 261.683 254.979 261.687 254.886 261.687C254.606 261.687 254.373 261.613 254.186 261.463C253.999 261.305 253.892 261.104 253.864 260.861L253.836 260.133C253.509 260.665 253.085 261.071 252.562 261.351C252.039 261.622 251.465 261.757 250.84 261.757C250.075 261.757 249.496 261.505 249.104 261.001C248.712 260.497 248.516 259.755 248.516 258.775ZM260.435 261.757C259.866 261.757 259.348 261.659 258.881 261.463C258.424 261.258 258.027 260.983 257.691 260.637C257.355 260.283 257.094 259.881 256.907 259.433C256.73 258.976 256.641 258.491 256.641 257.977C256.641 257.287 256.8 256.657 257.117 256.087C257.435 255.509 257.878 255.047 258.447 254.701C259.017 254.347 259.684 254.169 260.449 254.169C261.215 254.169 261.873 254.347 262.423 254.701C262.983 255.047 263.417 255.504 263.725 256.073C264.033 256.643 264.187 257.254 264.187 257.907C264.187 258.019 264.183 258.127 264.173 258.229C264.164 258.323 264.155 258.402 264.145 258.467H258.279C258.307 258.897 258.424 259.275 258.629 259.601C258.844 259.919 259.115 260.171 259.441 260.357C259.768 260.535 260.118 260.623 260.491 260.623C260.902 260.623 261.289 260.521 261.653 260.315C262.027 260.11 262.279 259.839 262.409 259.503L263.725 259.881C263.567 260.236 263.324 260.558 262.997 260.847C262.68 261.127 262.302 261.351 261.863 261.519C261.425 261.678 260.949 261.757 260.435 261.757ZM258.237 257.445H262.661C262.633 257.025 262.512 256.657 262.297 256.339C262.092 256.013 261.826 255.761 261.499 255.583C261.182 255.397 260.827 255.303 260.435 255.303C260.053 255.303 259.698 255.397 259.371 255.583C259.054 255.761 258.793 256.013 258.587 256.339C258.382 256.657 258.265 257.025 258.237 257.445Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M55.2228 130.519V123.435L52.2968 128.811H51.3728L48.4328 123.435V130.519H46.8648V120.579H48.5448L51.8348 126.655L55.1248 120.579H56.8048V130.519H55.2228Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M59.1024 132.241C59.2424 132.26 59.3778 132.279 59.5084 132.297C59.6484 132.325 59.7604 132.339 59.8444 132.339C60.0031 132.339 60.1384 132.288 60.2504 132.185C60.3718 132.092 60.4931 131.915 60.6144 131.653C60.7358 131.392 60.8851 131.014 61.0624 130.519L58.0524 123.197H59.6624L61.9024 128.951L63.8904 123.197H65.3744L62.0564 132.213C61.9538 132.484 61.8044 132.731 61.6084 132.955C61.4124 133.189 61.1698 133.371 60.8804 133.501C60.5911 133.632 60.2504 133.697 59.8584 133.697C59.7464 133.697 59.6298 133.688 59.5084 133.669C59.3871 133.651 59.2518 133.623 59.1024 133.585V132.241Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M72.3825 130.659C71.9065 130.659 71.4679 130.561 71.0665 130.365C70.6745 130.16 70.3339 129.885 70.0445 129.539C69.7552 129.185 69.5312 128.779 69.3725 128.321C69.2232 127.855 69.1485 127.365 69.1485 126.851C69.1485 126.329 69.2325 125.839 69.4005 125.381C69.5779 124.924 69.8205 124.523 70.1285 124.177C70.4459 123.832 70.8145 123.561 71.2345 123.365C71.6545 123.169 72.1072 123.071 72.5925 123.071C73.1525 123.071 73.6565 123.207 74.1045 123.477C74.5619 123.748 74.9212 124.098 75.1825 124.527V123.197H76.5405V133.501H75.0005V129.147C74.3845 130.155 73.5119 130.659 72.3825 130.659ZM72.9425 129.343C73.2505 129.343 73.5305 129.283 73.7825 129.161C74.0439 129.04 74.2725 128.877 74.4685 128.671C74.6739 128.457 74.8512 128.214 75.0005 127.943V126.011C74.9539 125.787 74.8605 125.582 74.7205 125.395C74.5899 125.199 74.4265 125.027 74.2305 124.877C74.0345 124.719 73.8245 124.597 73.6005 124.513C73.3765 124.429 73.1572 124.387 72.9425 124.387C72.6159 124.387 72.3172 124.457 72.0465 124.597C71.7759 124.737 71.5379 124.929 71.3325 125.171C71.1365 125.405 70.9825 125.671 70.8705 125.969C70.7679 126.268 70.7165 126.576 70.7165 126.893C70.7165 127.341 70.8099 127.752 70.9965 128.125C71.1925 128.489 71.4539 128.783 71.7805 129.007C72.1165 129.231 72.5039 129.343 72.9425 129.343Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M78.3176 127.677V123.197H79.8576V127.369C79.8576 128.023 79.9742 128.517 80.2076 128.853C80.4502 129.18 80.8002 129.343 81.2576 129.343C81.5469 129.343 81.8269 129.283 82.0976 129.161C82.3776 129.04 82.6296 128.863 82.8536 128.629C83.0869 128.387 83.2736 128.097 83.4136 127.761V123.197H84.9536V128.783C84.9536 128.961 84.9862 129.087 85.0516 129.161C85.1169 129.236 85.2242 129.278 85.3736 129.287V130.519C85.2149 130.547 85.0842 130.566 84.9816 130.575C84.8789 130.585 84.7809 130.589 84.6876 130.589C84.4076 130.589 84.1742 130.515 83.9876 130.365C83.8009 130.207 83.6936 130.006 83.6656 129.763L83.6376 129.035C83.3109 129.567 82.8862 129.973 82.3636 130.253C81.8409 130.524 81.2669 130.659 80.6416 130.659C79.8762 130.659 79.2976 130.407 78.9056 129.903C78.5136 129.399 78.3176 128.657 78.3176 127.677Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M90.2368 130.659C89.6675 130.659 89.1495 130.561 88.6828 130.365C88.2255 130.16 87.8288 129.885 87.4928 129.539C87.1568 129.185 86.8955 128.783 86.7088 128.335C86.5315 127.878 86.4428 127.393 86.4428 126.879C86.4428 126.189 86.6015 125.559 86.9188 124.989C87.2361 124.411 87.6795 123.949 88.2488 123.603C88.8181 123.249 89.4855 123.071 90.2508 123.071C91.0161 123.071 91.6741 123.249 92.2248 123.603C92.7848 123.949 93.2188 124.406 93.5268 124.975C93.8348 125.545 93.9888 126.156 93.9888 126.809C93.9888 126.921 93.9841 127.029 93.9748 127.131C93.9655 127.225 93.9561 127.304 93.9468 127.369H88.0808C88.1088 127.799 88.2255 128.177 88.4308 128.503C88.6455 128.821 88.9161 129.073 89.2428 129.259C89.5695 129.437 89.9195 129.525 90.2928 129.525C90.7035 129.525 91.0908 129.423 91.4548 129.217C91.8281 129.012 92.0801 128.741 92.2108 128.405L93.5268 128.783C93.3681 129.138 93.1255 129.46 92.7988 129.749C92.4815 130.029 92.1035 130.253 91.6648 130.421C91.2261 130.58 90.7501 130.659 90.2368 130.659ZM88.0388 126.347H92.4628C92.4348 125.927 92.3135 125.559 92.0988 125.241C91.8935 124.915 91.6275 124.663 91.3008 124.485C90.9835 124.299 90.6288 124.205 90.2368 124.205C89.8541 124.205 89.4995 124.299 89.1728 124.485C88.8555 124.663 88.5941 124.915 88.3888 125.241C88.1835 125.559 88.0668 125.927 88.0388 126.347Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M95.175 127.677V123.197H96.715V127.369C96.715 128.023 96.8316 128.517 97.065 128.853C97.3076 129.18 97.6576 129.343 98.115 129.343C98.4043 129.343 98.6843 129.283 98.955 129.161C99.235 129.04 99.487 128.863 99.711 128.629C99.9443 128.387 100.131 128.097 100.271 127.761V123.197H101.811V128.783C101.811 128.961 101.844 129.087 101.909 129.161C101.974 129.236 102.082 129.278 102.231 129.287V130.519C102.072 130.547 101.942 130.566 101.839 130.575C101.736 130.585 101.638 130.589 101.545 130.589C101.265 130.589 101.032 130.515 100.845 130.365C100.658 130.207 100.551 130.006 100.523 129.763L100.495 129.035C100.168 129.567 99.7436 129.973 99.221 130.253C98.6983 130.524 98.1243 130.659 97.499 130.659C96.7336 130.659 96.155 130.407 95.763 129.903C95.371 129.399 95.175 128.657 95.175 127.677Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M107.094 130.659C106.525 130.659 106.007 130.561 105.54 130.365C105.083 130.16 104.686 129.885 104.35 129.539C104.014 129.185 103.753 128.783 103.566 128.335C103.389 127.878 103.3 127.393 103.3 126.879C103.3 126.189 103.459 125.559 103.776 124.989C104.094 124.411 104.537 123.949 105.106 123.603C105.676 123.249 106.343 123.071 107.108 123.071C107.874 123.071 108.532 123.249 109.082 123.603C109.642 123.949 110.076 124.406 110.384 124.975C110.692 125.545 110.846 126.156 110.846 126.809C110.846 126.921 110.842 127.029 110.832 127.131C110.823 127.225 110.814 127.304 110.804 127.369H104.938C104.966 127.799 105.083 128.177 105.288 128.503C105.503 128.821 105.774 129.073 106.1 129.259C106.427 129.437 106.777 129.525 107.15 129.525C107.561 129.525 107.948 129.423 108.312 129.217C108.686 129.012 108.938 128.741 109.068 128.405L110.384 128.783C110.226 129.138 109.983 129.46 109.656 129.749C109.339 130.029 108.961 130.253 108.522 130.421C108.084 130.58 107.608 130.659 107.094 130.659ZM104.896 126.347H109.32C109.292 125.927 109.171 125.559 108.956 125.241C108.751 124.915 108.485 124.663 108.158 124.485C107.841 124.299 107.486 124.205 107.094 124.205C106.712 124.205 106.357 124.299 106.03 124.485C105.713 124.663 105.452 124.915 105.246 125.241C105.041 125.559 104.924 125.927 104.896 126.347Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M50.9248 175.218C50.2715 175.218 49.6602 175.083 49.0908 174.812C48.5215 174.542 48.0222 174.168 47.5928 173.692C47.1728 173.216 46.8415 172.675 46.5988 172.068C46.3655 171.462 46.2488 170.818 46.2488 170.136C46.2488 169.455 46.3655 168.816 46.5988 168.218C46.8415 167.621 47.1728 167.089 47.5928 166.622C48.0222 166.156 48.5215 165.792 49.0908 165.53C49.6695 165.269 50.2995 165.138 50.9808 165.138C51.9235 165.138 52.7168 165.339 53.3608 165.74C54.0142 166.132 54.5042 166.655 54.8308 167.308L53.6268 168.176C53.3655 167.635 52.9922 167.229 52.5068 166.958C52.0308 166.688 51.5082 166.552 50.9388 166.552C50.4722 166.552 50.0475 166.65 49.6648 166.846C49.2822 167.042 48.9508 167.313 48.6708 167.658C48.4002 167.994 48.1948 168.382 48.0548 168.82C47.9148 169.25 47.8448 169.702 47.8448 170.178C47.8448 170.682 47.9242 171.154 48.0828 171.592C48.2415 172.031 48.4655 172.418 48.7548 172.754C49.0442 173.081 49.3848 173.338 49.7768 173.524C50.1688 173.711 50.5935 173.804 51.0508 173.804C51.5922 173.804 52.1055 173.669 52.5908 173.398C53.0855 173.118 53.5475 172.703 53.9768 172.152V173.748C53.1088 174.728 52.0915 175.218 50.9248 175.218ZM53.8228 171.284H51.7368V170.122H55.1388V175.148H53.8228V171.284Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M60.0493 175.288C59.48 175.288 58.962 175.19 58.4953 174.994C58.038 174.789 57.6413 174.514 57.3053 174.168C56.9693 173.814 56.708 173.412 56.5213 172.964C56.344 172.507 56.2553 172.022 56.2553 171.508C56.2553 170.818 56.414 170.188 56.7313 169.618C57.0487 169.04 57.492 168.578 58.0613 168.232C58.6307 167.878 59.298 167.7 60.0633 167.7C60.8287 167.7 61.4867 167.878 62.0373 168.232C62.5973 168.578 63.0313 169.035 63.3393 169.604C63.6473 170.174 63.8013 170.785 63.8013 171.438C63.8013 171.55 63.7967 171.658 63.7873 171.76C63.778 171.854 63.7687 171.933 63.7593 171.998H57.8933C57.9213 172.428 58.038 172.806 58.2433 173.132C58.458 173.45 58.7287 173.702 59.0553 173.888C59.382 174.066 59.732 174.154 60.1053 174.154C60.516 174.154 60.9033 174.052 61.2673 173.846C61.6407 173.641 61.8927 173.37 62.0233 173.034L63.3393 173.412C63.1807 173.767 62.938 174.089 62.6113 174.378C62.294 174.658 61.916 174.882 61.4773 175.05C61.0387 175.209 60.5627 175.288 60.0493 175.288ZM57.8513 170.976H62.2753C62.2473 170.556 62.126 170.188 61.9113 169.87C61.706 169.544 61.44 169.292 61.1133 169.114C60.796 168.928 60.4413 168.834 60.0493 168.834C59.6667 168.834 59.312 168.928 58.9853 169.114C58.668 169.292 58.4067 169.544 58.2013 169.87C57.996 170.188 57.8793 170.556 57.8513 170.976Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M71.6235 175.148H70.0835V171.046C70.0835 170.365 69.9715 169.866 69.7475 169.548C69.5328 169.231 69.2108 169.072 68.7815 169.072C68.4828 169.072 68.1842 169.147 67.8855 169.296C67.5962 169.446 67.3348 169.651 67.1015 169.912C66.8682 170.164 66.7002 170.458 66.5975 170.794V175.148H65.0575V167.826H66.4575V169.296C66.6442 168.97 66.8868 168.69 67.1855 168.456C67.4935 168.214 67.8388 168.027 68.2215 167.896C68.6042 167.766 69.0102 167.7 69.4395 167.7C69.8782 167.7 70.2375 167.78 70.5175 167.938C70.8068 168.097 71.0308 168.316 71.1895 168.596C71.3575 168.867 71.4695 169.184 71.5255 169.548C71.5908 169.903 71.6235 170.281 71.6235 170.682V175.148Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M76.729 175.288C76.1597 175.288 75.6417 175.19 75.175 174.994C74.7177 174.789 74.321 174.514 73.985 174.168C73.649 173.814 73.3877 173.412 73.201 172.964C73.0237 172.507 72.935 172.022 72.935 171.508C72.935 170.818 73.0937 170.188 73.411 169.618C73.7284 169.04 74.1717 168.578 74.741 168.232C75.3104 167.878 75.9777 167.7 76.743 167.7C77.5084 167.7 78.1664 167.878 78.717 168.232C79.277 168.578 79.711 169.035 80.019 169.604C80.327 170.174 80.481 170.785 80.481 171.438C80.481 171.55 80.4764 171.658 80.467 171.76C80.4577 171.854 80.4484 171.933 80.439 171.998H74.573C74.601 172.428 74.7177 172.806 74.923 173.132C75.1377 173.45 75.4084 173.702 75.735 173.888C76.0617 174.066 76.4117 174.154 76.785 174.154C77.1957 174.154 77.583 174.052 77.947 173.846C78.3204 173.641 78.5724 173.37 78.703 173.034L80.019 173.412C79.8604 173.767 79.6177 174.089 79.291 174.378C78.9737 174.658 78.5957 174.882 78.157 175.05C77.7184 175.209 77.2424 175.288 76.729 175.288ZM74.531 170.976H78.955C78.927 170.556 78.8057 170.188 78.591 169.87C78.3857 169.544 78.1197 169.292 77.793 169.114C77.4757 168.928 77.121 168.834 76.729 168.834C76.3464 168.834 75.9917 168.928 75.665 169.114C75.3477 169.292 75.0864 169.544 74.881 169.87C74.6757 170.188 74.559 170.556 74.531 170.976Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M85.8532 169.156C85.2559 169.166 84.7239 169.301 84.2572 169.562C83.7999 169.824 83.4732 170.192 83.2772 170.668V175.148H81.7372V167.826H83.1652V169.464C83.4172 168.96 83.7485 168.559 84.1592 168.26C84.5699 167.952 85.0039 167.784 85.4612 167.756C85.5545 167.756 85.6292 167.756 85.6852 167.756C85.7505 167.756 85.8065 167.761 85.8532 167.77V169.156Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M86.4279 173.006C86.4279 172.54 86.5585 172.134 86.8199 171.788C87.0905 171.434 87.4592 171.163 87.9259 170.976C88.3925 170.78 88.9339 170.682 89.5499 170.682C89.8765 170.682 90.2079 170.706 90.5439 170.752C90.8892 170.799 91.1925 170.874 91.4539 170.976V170.514C91.4539 170.001 91.2999 169.6 90.9919 169.31C90.6839 169.021 90.2405 168.876 89.6619 168.876C89.2512 168.876 88.8639 168.951 88.4999 169.1C88.1359 169.24 87.7485 169.441 87.3379 169.702L86.8199 168.666C87.3052 168.34 87.7905 168.097 88.2759 167.938C88.7705 167.78 89.2885 167.7 89.8299 167.7C90.8099 167.7 91.5799 167.962 92.1399 168.484C92.7092 168.998 92.9939 169.73 92.9939 170.682V173.412C92.9939 173.59 93.0219 173.716 93.0779 173.79C93.1432 173.865 93.2505 173.907 93.3999 173.916V175.148C93.2599 175.176 93.1339 175.195 93.0219 175.204C92.9099 175.214 92.8165 175.218 92.7419 175.218C92.4152 175.218 92.1679 175.139 91.9999 174.98C91.8319 174.822 91.7339 174.635 91.7059 174.42L91.6639 174C91.3465 174.411 90.9405 174.728 90.4459 174.952C89.9512 175.176 89.4519 175.288 88.9479 175.288C88.4625 175.288 88.0285 175.19 87.6459 174.994C87.2632 174.789 86.9645 174.514 86.7499 174.168C86.5352 173.823 86.4279 173.436 86.4279 173.006ZM91.0899 173.454C91.2019 173.333 91.2905 173.212 91.3559 173.09C91.4212 172.969 91.4539 172.862 91.4539 172.768V171.928C91.1925 171.826 90.9172 171.751 90.6279 171.704C90.3385 171.648 90.0539 171.62 89.7739 171.62C89.2139 171.62 88.7565 171.732 88.4019 171.956C88.0565 172.18 87.8839 172.488 87.8839 172.88C87.8839 173.095 87.9399 173.3 88.0519 173.496C88.1732 173.692 88.3412 173.851 88.5559 173.972C88.7799 174.094 89.0552 174.154 89.3819 174.154C89.7179 174.154 90.0399 174.089 90.3479 173.958C90.6559 173.828 90.9032 173.66 91.0899 173.454Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M94.8762 164.928H96.4162V173.034C96.4162 173.408 96.4722 173.646 96.5842 173.748C96.6962 173.851 96.8362 173.902 97.0042 173.902C97.1909 173.902 97.3635 173.884 97.5222 173.846C97.6902 173.809 97.8349 173.762 97.9562 173.706L98.1802 174.924C97.9562 175.018 97.6902 175.097 97.3822 175.162C97.0742 175.228 96.7989 175.26 96.5562 175.26C96.0335 175.26 95.6229 175.116 95.3242 174.826C95.0255 174.528 94.8762 174.117 94.8762 173.594V164.928Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M104.922 175.288C104.446 175.288 104.007 175.19 103.606 174.994C103.214 174.789 102.873 174.514 102.584 174.168C102.294 173.814 102.07 173.408 101.912 172.95C101.762 172.484 101.688 171.994 101.688 171.48C101.688 170.958 101.772 170.468 101.94 170.01C102.117 169.553 102.36 169.152 102.668 168.806C102.985 168.461 103.354 168.19 103.774 167.994C104.194 167.798 104.646 167.7 105.132 167.7C105.692 167.7 106.196 167.836 106.644 168.106C107.101 168.377 107.46 168.727 107.722 169.156V167.826H109.08V178.13H107.54V173.776C106.924 174.784 106.051 175.288 104.922 175.288ZM105.482 173.972C105.79 173.972 106.07 173.912 106.322 173.79C106.583 173.669 106.812 173.506 107.008 173.3C107.213 173.086 107.39 172.843 107.54 172.572V170.64C107.493 170.416 107.4 170.211 107.26 170.024C107.129 169.828 106.966 169.656 106.77 169.506C106.574 169.348 106.364 169.226 106.14 169.142C105.916 169.058 105.696 169.016 105.482 169.016C105.155 169.016 104.856 169.086 104.586 169.226C104.315 169.366 104.077 169.558 103.872 169.8C103.676 170.034 103.522 170.3 103.41 170.598C103.307 170.897 103.256 171.205 103.256 171.522C103.256 171.97 103.349 172.381 103.536 172.754C103.732 173.118 103.993 173.412 104.32 173.636C104.656 173.86 105.043 173.972 105.482 173.972Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M110.857 172.306V167.826H112.397V171.998C112.397 172.652 112.513 173.146 112.747 173.482C112.989 173.809 113.339 173.972 113.797 173.972C114.086 173.972 114.366 173.912 114.637 173.79C114.917 173.669 115.169 173.492 115.393 173.258C115.626 173.016 115.813 172.726 115.953 172.39V167.826H117.493V173.412C117.493 173.59 117.525 173.716 117.591 173.79C117.656 173.865 117.763 173.907 117.913 173.916V175.148C117.754 175.176 117.623 175.195 117.521 175.204C117.418 175.214 117.32 175.218 117.227 175.218C116.947 175.218 116.713 175.144 116.527 174.994C116.34 174.836 116.233 174.635 116.205 174.392L116.177 173.664C115.85 174.196 115.425 174.602 114.903 174.882C114.38 175.153 113.806 175.288 113.181 175.288C112.415 175.288 111.837 175.036 111.445 174.532C111.053 174.028 110.857 173.286 110.857 172.306Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M122.776 175.288C122.207 175.288 121.689 175.19 121.222 174.994C120.765 174.789 120.368 174.514 120.032 174.168C119.696 173.814 119.435 173.412 119.248 172.964C119.071 172.507 118.982 172.022 118.982 171.508C118.982 170.818 119.141 170.188 119.458 169.618C119.775 169.04 120.219 168.578 120.788 168.232C121.357 167.878 122.025 167.7 122.79 167.7C123.555 167.7 124.213 167.878 124.764 168.232C125.324 168.578 125.758 169.035 126.066 169.604C126.374 170.174 126.528 170.785 126.528 171.438C126.528 171.55 126.523 171.658 126.514 171.76C126.505 171.854 126.495 171.933 126.486 171.998H120.62C120.648 172.428 120.765 172.806 120.97 173.132C121.185 173.45 121.455 173.702 121.782 173.888C122.109 174.066 122.459 174.154 122.832 174.154C123.243 174.154 123.63 174.052 123.994 173.846C124.367 173.641 124.619 173.37 124.75 173.034L126.066 173.412C125.907 173.767 125.665 174.089 125.338 174.378C125.021 174.658 124.643 174.882 124.204 175.05C123.765 175.209 123.289 175.288 122.776 175.288ZM120.578 170.976H125.002C124.974 170.556 124.853 170.188 124.638 169.87C124.433 169.544 124.167 169.292 123.84 169.114C123.523 168.928 123.168 168.834 122.776 168.834C122.393 168.834 122.039 168.928 121.712 169.114C121.395 169.292 121.133 169.544 120.928 169.87C120.723 170.188 120.606 170.556 120.578 170.976Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M127.714 172.306V167.826H129.254V171.998C129.254 172.652 129.371 173.146 129.604 173.482C129.847 173.809 130.197 173.972 130.654 173.972C130.943 173.972 131.223 173.912 131.494 173.79C131.774 173.669 132.026 173.492 132.25 173.258C132.483 173.016 132.67 172.726 132.81 172.39V167.826H134.35V173.412C134.35 173.59 134.383 173.716 134.448 173.79C134.513 173.865 134.621 173.907 134.77 173.916V175.148C134.611 175.176 134.481 175.195 134.378 175.204C134.275 175.214 134.177 175.218 134.084 175.218C133.804 175.218 133.571 175.144 133.384 174.994C133.197 174.836 133.09 174.635 133.062 174.392L133.034 173.664C132.707 174.196 132.283 174.602 131.76 174.882C131.237 175.153 130.663 175.288 130.038 175.288C129.273 175.288 128.694 175.036 128.302 174.532C127.91 174.028 127.714 173.286 127.714 172.306Z"
                    fill={controlTypoPrimary}
                />
                <path
                    d="M139.633 175.288C139.064 175.288 138.546 175.19 138.079 174.994C137.622 174.789 137.225 174.514 136.889 174.168C136.553 173.814 136.292 173.412 136.105 172.964C135.928 172.507 135.839 172.022 135.839 171.508C135.839 170.818 135.998 170.188 136.315 169.618C136.633 169.04 137.076 168.578 137.645 168.232C138.215 167.878 138.882 167.7 139.647 167.7C140.413 167.7 141.071 167.878 141.621 168.232C142.181 168.578 142.615 169.035 142.923 169.604C143.231 170.174 143.385 170.785 143.385 171.438C143.385 171.55 143.381 171.658 143.371 171.76C143.362 171.854 143.353 171.933 143.343 171.998H137.477C137.505 172.428 137.622 172.806 137.827 173.132C138.042 173.45 138.313 173.702 138.639 173.888C138.966 174.066 139.316 174.154 139.689 174.154C140.1 174.154 140.487 174.052 140.851 173.846C141.225 173.641 141.477 173.37 141.607 173.034L142.923 173.412C142.765 173.767 142.522 174.089 142.195 174.378C141.878 174.658 141.5 174.882 141.061 175.05C140.623 175.209 140.147 175.288 139.633 175.288ZM137.435 170.976H141.859C141.831 170.556 141.71 170.188 141.495 169.87C141.29 169.544 141.024 169.292 140.697 169.114C140.38 168.928 140.025 168.834 139.633 168.834C139.251 168.834 138.896 168.928 138.569 169.114C138.252 169.292 137.991 169.544 137.785 169.87C137.58 170.188 137.463 170.556 137.435 170.976Z"
                    fill={controlTypoPrimary}
                />
            </g>
            <defs>
                <clipPath id="clip0_1115_5608">
                    <rect width="470" height="298.45" rx="8" fill="white" />
                </clipPath>
            </defs>
        </svg>
    )
}

export default ModalImage
