import React from 'react'

type HeaderImageProps = {
    hideLogo: boolean
    logo: string
    bg: string
    controlBg: string
    controlTypo: string
}

const HeaderImage = ({
    hideLogo = false,
    logo = '#2d255e',
    bg = '#e3e1d8',
    controlBg = '#f5f4f1',
    controlTypo = '#2d255e',
}: Partial<HeaderImageProps>) => {
    return (
        <svg
            width="470"
            height="88"
            viewBox="0 0 470 88"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <g clip-path="url(#clip0_1115_5602)">
                <path
                    d="M0 12.1305C0 5.96824 4.99497 0.973267 11.1573 0.973267H458.843C465.005 0.973267 470 5.96824 470 12.1305V76.2848C470 82.4471 465.005 87.4421 458.843 87.4421H11.1573C4.99497 87.4421 0 82.4471 0 76.2848V12.1305Z"
                    fill={bg}
                />
                <path
                    d="M275.814 33.0504C275.814 28.4292 279.561 24.6825 284.182 24.6825H433.411C438.032 24.6825 441.778 28.4292 441.778 33.0504V55.365C441.778 59.9862 438.032 63.7329 433.411 63.7329H284.182C279.561 63.7329 275.814 59.9862 275.814 55.365V33.0504Z"
                    fill={controlBg}
                />
                <path
                    d="M331.916 49.2077V39.2677H336.242C336.69 39.2677 337.101 39.361 337.474 39.5477C337.848 39.7343 338.17 39.9817 338.44 40.2897C338.72 40.5977 338.935 40.943 339.084 41.3257C339.243 41.7083 339.322 42.1003 339.322 42.5017C339.322 42.9403 339.243 43.3603 339.084 43.7617C338.926 44.163 338.697 44.5083 338.398 44.7977C338.109 45.087 337.768 45.297 337.376 45.4277L339.714 49.2077H337.95L335.794 45.7497H333.484V49.2077H331.916ZM333.484 44.3637H336.228C336.518 44.3637 336.774 44.2797 336.998 44.1117C337.222 43.9437 337.4 43.7197 337.53 43.4397C337.661 43.1503 337.726 42.8377 337.726 42.5017C337.726 42.1563 337.652 41.8483 337.502 41.5777C337.353 41.2977 337.157 41.0737 336.914 40.9057C336.681 40.7377 336.424 40.6537 336.144 40.6537H333.484V44.3637Z"
                    fill={controlTypo}
                />
                <path
                    d="M344.062 49.3477C343.492 49.3477 342.974 49.2497 342.508 49.0537C342.05 48.8483 341.654 48.573 341.318 48.2277C340.982 47.873 340.72 47.4717 340.534 47.0237C340.356 46.5663 340.268 46.081 340.268 45.5677C340.268 44.877 340.426 44.247 340.744 43.6777C341.061 43.099 341.504 42.637 342.074 42.2917C342.643 41.937 343.31 41.7597 344.076 41.7597C344.841 41.7597 345.499 41.937 346.05 42.2917C346.61 42.637 347.044 43.0943 347.352 43.6637C347.66 44.233 347.814 44.8443 347.814 45.4977C347.814 45.6097 347.809 45.717 347.8 45.8197C347.79 45.913 347.781 45.9923 347.772 46.0577H341.906C341.934 46.487 342.05 46.865 342.256 47.1917C342.47 47.509 342.741 47.761 343.068 47.9477C343.394 48.125 343.744 48.2137 344.118 48.2137C344.528 48.2137 344.916 48.111 345.28 47.9057C345.653 47.7003 345.905 47.4297 346.036 47.0937L347.352 47.4717C347.193 47.8263 346.95 48.1483 346.624 48.4377C346.306 48.7177 345.928 48.9417 345.49 49.1097C345.051 49.2683 344.575 49.3477 344.062 49.3477ZM341.864 45.0357H346.288C346.26 44.6157 346.138 44.247 345.924 43.9297C345.718 43.603 345.452 43.351 345.126 43.1737C344.808 42.987 344.454 42.8937 344.062 42.8937C343.679 42.8937 343.324 42.987 342.998 43.1737C342.68 43.351 342.419 43.603 342.214 43.9297C342.008 44.247 341.892 44.6157 341.864 45.0357Z"
                    fill={controlTypo}
                />
                <path
                    d="M351.968 49.2777C351.473 49.2777 351.021 49.1797 350.61 48.9837C350.199 48.7783 349.845 48.503 349.546 48.1577C349.257 47.8123 349.028 47.4157 348.86 46.9677C348.701 46.5197 348.622 46.0483 348.622 45.5537C348.622 45.031 348.706 44.541 348.874 44.0837C349.042 43.6263 349.275 43.225 349.574 42.8797C349.882 42.525 350.241 42.2497 350.652 42.0537C351.063 41.8577 351.52 41.7597 352.024 41.7597C352.612 41.7597 353.125 41.8997 353.564 42.1797C354.012 42.4597 354.381 42.8237 354.67 43.2717V41.8857H356.028V48.9977C356.028 49.707 355.855 50.309 355.51 50.8037C355.174 51.2983 354.712 51.6763 354.124 51.9377C353.536 52.199 352.873 52.3297 352.136 52.3297C351.324 52.3297 350.652 52.1897 350.12 51.9097C349.588 51.6297 349.135 51.247 348.762 50.7617L349.63 49.9497C349.91 50.3417 350.269 50.6403 350.708 50.8457C351.156 51.051 351.632 51.1537 352.136 51.1537C352.556 51.1537 352.943 51.0743 353.298 50.9157C353.662 50.7663 353.951 50.5283 354.166 50.2017C354.381 49.8843 354.488 49.483 354.488 48.9977V47.8777C354.227 48.3163 353.867 48.6617 353.41 48.9137C352.953 49.1563 352.472 49.2777 351.968 49.2777ZM352.472 48.0317C352.705 48.0317 352.929 47.9943 353.144 47.9197C353.359 47.8357 353.555 47.7283 353.732 47.5977C353.919 47.4577 354.077 47.3037 354.208 47.1357C354.339 46.9583 354.432 46.7717 354.488 46.5757V44.6577C354.367 44.3403 354.194 44.065 353.97 43.8317C353.746 43.589 353.494 43.4023 353.214 43.2717C352.934 43.141 352.649 43.0757 352.36 43.0757C352.024 43.0757 351.721 43.1503 351.45 43.2997C351.189 43.4397 350.965 43.631 350.778 43.8737C350.591 44.107 350.447 44.373 350.344 44.6717C350.241 44.9703 350.19 45.2783 350.19 45.5957C350.19 45.9317 350.246 46.2443 350.358 46.5337C350.479 46.823 350.643 47.0843 350.848 47.3177C351.053 47.5417 351.296 47.719 351.576 47.8497C351.856 47.971 352.155 48.0317 352.472 48.0317Z"
                    fill={controlTypo}
                />
                <path
                    d="M357.875 49.2077V41.8857H359.415V49.2077H357.875ZM357.875 40.6817V38.9877H359.415V40.6817H357.875Z"
                    fill={controlTypo}
                />
                <path
                    d="M363.869 49.3477C363.253 49.3477 362.67 49.2497 362.119 49.0537C361.569 48.8483 361.097 48.545 360.705 48.1437L361.279 47.1077C361.699 47.481 362.119 47.7517 362.539 47.9197C362.969 48.0877 363.393 48.1717 363.813 48.1717C364.243 48.1717 364.593 48.0923 364.863 47.9337C365.134 47.7657 365.269 47.523 365.269 47.2057C365.269 46.9723 365.199 46.7997 365.059 46.6877C364.919 46.5757 364.714 46.4777 364.443 46.3937C364.182 46.3097 363.865 46.2163 363.491 46.1137C362.969 45.955 362.53 45.7917 362.175 45.6237C361.821 45.4463 361.555 45.2317 361.377 44.9797C361.2 44.7277 361.111 44.4057 361.111 44.0137C361.111 43.5377 361.233 43.1317 361.475 42.7957C361.718 42.4597 362.054 42.203 362.483 42.0257C362.922 41.8483 363.426 41.7597 363.995 41.7597C364.527 41.7597 365.017 41.8437 365.465 42.0117C365.923 42.1703 366.324 42.4223 366.669 42.7677L366.011 43.7897C365.685 43.491 365.349 43.2717 365.003 43.1317C364.667 42.9917 364.303 42.9217 363.911 42.9217C363.687 42.9217 363.473 42.9497 363.267 43.0057C363.062 43.0523 362.889 43.1457 362.749 43.2857C362.619 43.4163 362.553 43.603 362.553 43.8457C362.553 44.0417 362.609 44.2003 362.721 44.3217C362.833 44.443 363.001 44.5457 363.225 44.6297C363.449 44.7137 363.725 44.807 364.051 44.9097C364.621 45.0777 365.106 45.2457 365.507 45.4137C365.909 45.5723 366.217 45.7823 366.431 46.0437C366.655 46.2957 366.767 46.6457 366.767 47.0937C366.767 47.803 366.501 48.3583 365.969 48.7597C365.447 49.1517 364.747 49.3477 363.869 49.3477Z"
                    fill={controlTypo}
                />
                <path
                    d="M372.202 48.8297C372.072 48.895 371.908 48.965 371.712 49.0397C371.516 49.1143 371.292 49.1797 371.04 49.2357C370.798 49.2917 370.546 49.3197 370.284 49.3197C369.967 49.3197 369.673 49.2637 369.402 49.1517C369.132 49.0397 368.912 48.8623 368.744 48.6197C368.586 48.3677 368.506 48.0457 368.506 47.6537V43.0757H367.54V41.8857H368.506V39.4777H370.046V41.8857H371.642V43.0757H370.046V47.1637C370.065 47.4157 370.144 47.6023 370.284 47.7237C370.434 47.845 370.616 47.9057 370.83 47.9057C371.045 47.9057 371.25 47.8683 371.446 47.7937C371.642 47.719 371.787 47.6583 371.88 47.6117L372.202 48.8297Z"
                    fill={controlTypo}
                />
                <path
                    d="M376.491 49.3477C375.922 49.3477 375.404 49.2497 374.937 49.0537C374.48 48.8483 374.083 48.573 373.747 48.2277C373.411 47.873 373.15 47.4717 372.963 47.0237C372.786 46.5663 372.697 46.081 372.697 45.5677C372.697 44.877 372.856 44.247 373.173 43.6777C373.491 43.099 373.934 42.637 374.503 42.2917C375.073 41.937 375.74 41.7597 376.505 41.7597C377.271 41.7597 377.929 41.937 378.479 42.2917C379.039 42.637 379.473 43.0943 379.781 43.6637C380.089 44.233 380.243 44.8443 380.243 45.4977C380.243 45.6097 380.239 45.717 380.229 45.8197C380.22 45.913 380.211 45.9923 380.201 46.0577H374.335C374.363 46.487 374.48 46.865 374.685 47.1917C374.9 47.509 375.171 47.761 375.497 47.9477C375.824 48.125 376.174 48.2137 376.547 48.2137C376.958 48.2137 377.345 48.111 377.709 47.9057C378.083 47.7003 378.335 47.4297 378.465 47.0937L379.781 47.4717C379.623 47.8263 379.38 48.1483 379.053 48.4377C378.736 48.7177 378.358 48.9417 377.919 49.1097C377.481 49.2683 377.005 49.3477 376.491 49.3477ZM374.293 45.0357H378.717C378.689 44.6157 378.568 44.247 378.353 43.9297C378.148 43.603 377.882 43.351 377.555 43.1737C377.238 42.987 376.883 42.8937 376.491 42.8937C376.109 42.8937 375.754 42.987 375.427 43.1737C375.11 43.351 374.849 43.603 374.643 43.9297C374.438 44.247 374.321 44.6157 374.293 45.0357Z"
                    fill={controlTypo}
                />
                <path
                    d="M385.616 43.2157C385.018 43.225 384.486 43.3603 384.02 43.6217C383.562 43.883 383.236 44.2517 383.04 44.7277V49.2077H381.5V41.8857H382.928V43.5237C383.18 43.0197 383.511 42.6183 383.922 42.3197C384.332 42.0117 384.766 41.8437 385.224 41.8157C385.317 41.8157 385.392 41.8157 385.448 41.8157C385.513 41.8157 385.569 41.8203 385.616 41.8297V43.2157Z"
                    fill={controlTypo}
                />
                <path
                    d="M41.2416 31.2126V55.2126H37.4603V31.2126H41.2416Z"
                    fill={logo}
                    {...(hideLogo && { opacity: 0 })}
                />
                <path
                    d="M44.0078 46.947V46.5876C44.0078 45.3689 44.1849 44.2387 44.5391 43.197C44.8932 42.1449 45.4037 41.2335 46.0703 40.4626C46.7474 39.6814 47.5703 39.0772 48.5391 38.6501C49.5182 38.2126 50.6224 37.9939 51.8516 37.9939C53.0912 37.9939 54.1953 38.2126 55.1641 38.6501C56.1432 39.0772 56.9714 39.6814 57.6485 40.4626C58.3255 41.2335 58.8412 42.1449 59.1953 43.197C59.5495 44.2387 59.7266 45.3689 59.7266 46.5876V46.947C59.7266 48.1658 59.5495 49.296 59.1953 50.3376C58.8412 51.3793 58.3255 52.2908 57.6485 53.072C56.9714 53.8429 56.1485 54.447 55.1797 54.8845C54.211 55.3116 53.112 55.5251 51.8828 55.5251C50.6432 55.5251 49.5339 55.3116 48.5547 54.8845C47.586 54.447 46.763 53.8429 46.086 53.072C45.4089 52.2908 44.8932 51.3793 44.5391 50.3376C44.1849 49.296 44.0078 48.1658 44.0078 46.947ZM47.7735 46.5876V46.947C47.7735 47.7074 47.8516 48.4262 48.0078 49.1033C48.1641 49.7804 48.4089 50.3741 48.7422 50.8845C49.0755 51.3949 49.5026 51.796 50.0235 52.0876C50.5443 52.3793 51.1641 52.5251 51.8828 52.5251C52.5807 52.5251 53.1849 52.3793 53.6953 52.0876C54.2162 51.796 54.6432 51.3949 54.9766 50.8845C55.3099 50.3741 55.5547 49.7804 55.711 49.1033C55.8776 48.4262 55.961 47.7074 55.961 46.947V46.5876C55.961 45.8376 55.8776 45.1293 55.711 44.4626C55.5547 43.7856 55.3047 43.1866 54.961 42.6658C54.6276 42.1449 54.2005 41.7387 53.6797 41.447C53.1693 41.1449 52.5599 40.9939 51.8516 40.9939C51.1432 40.9939 50.5287 41.1449 50.0078 41.447C49.4974 41.7387 49.0755 42.1449 48.7422 42.6658C48.4089 43.1866 48.1641 43.7856 48.0078 44.4626C47.8516 45.1293 47.7735 45.8376 47.7735 46.5876Z"
                    fill={logo}
                    {...(hideLogo && { opacity: 0 })}
                />
                <path
                    d="M73.071 38.3064H76.4928V54.7439C76.4928 56.2647 76.1699 57.5564 75.5241 58.6189C74.8782 59.6814 73.9772 60.4887 72.821 61.0408C71.6647 61.6033 70.3262 61.8845 68.8053 61.8845C68.1595 61.8845 67.4407 61.7908 66.6491 61.6033C65.8678 61.4158 65.1074 61.1137 64.3678 60.697C63.6387 60.2908 63.0293 59.7543 62.5397 59.0876L64.3053 56.8689C64.9095 57.5876 65.5762 58.1137 66.3053 58.447C67.0345 58.7804 67.8001 58.947 68.6022 58.947C69.4668 58.947 70.2012 58.7856 70.8053 58.4626C71.4199 58.1501 71.8939 57.6866 72.2272 57.072C72.5605 56.4574 72.7272 55.7074 72.7272 54.822V42.1345L73.071 38.3064ZM61.5866 46.947V46.6189C61.5866 45.3376 61.7428 44.171 62.0553 43.1189C62.3678 42.0564 62.8157 41.1449 63.3991 40.3845C63.9824 39.6137 64.6907 39.0251 65.5241 38.6189C66.3574 38.2022 67.3001 37.9939 68.3522 37.9939C69.446 37.9939 70.3782 38.1918 71.1491 38.5876C71.9303 38.9835 72.5814 39.5512 73.1022 40.2908C73.623 41.0199 74.0293 41.8949 74.321 42.9158C74.623 43.9262 74.847 45.0512 74.9928 46.2908V47.3376C74.8574 48.546 74.6282 49.6501 74.3053 50.6501C73.9824 51.6501 73.5553 52.5147 73.0241 53.2439C72.4928 53.9731 71.8366 54.5356 71.0553 54.9314C70.2845 55.3272 69.373 55.5251 68.321 55.5251C67.2897 55.5251 66.3574 55.3116 65.5241 54.8845C64.7012 54.4574 63.9928 53.8585 63.3991 53.0876C62.8157 52.3168 62.3678 51.4106 62.0553 50.3689C61.7428 49.3168 61.5866 48.1762 61.5866 46.947ZM65.3522 46.6189V46.947C65.3522 47.7179 65.4251 48.4366 65.571 49.1033C65.7272 49.7699 65.9616 50.3585 66.2741 50.8689C66.597 51.3689 67.0032 51.7647 67.4928 52.0564C67.9928 52.3376 68.5814 52.4783 69.2585 52.4783C70.1439 52.4783 70.8678 52.2908 71.4303 51.9158C72.0032 51.5408 72.4407 51.0356 72.7428 50.4001C73.0553 49.7543 73.2741 49.0356 73.3991 48.2439V45.4158C73.3366 44.8012 73.2064 44.2283 73.0085 43.697C72.821 43.1658 72.5657 42.7022 72.2428 42.3064C71.9199 41.9001 71.5137 41.5876 71.0241 41.3689C70.5345 41.1397 69.9564 41.0251 69.2897 41.0251C68.6126 41.0251 68.0241 41.171 67.5241 41.4626C67.0241 41.7543 66.6126 42.1554 66.2897 42.6658C65.9772 43.1762 65.7428 43.7699 65.5866 44.447C65.4303 45.1241 65.3522 45.8481 65.3522 46.6189Z"
                    fill={logo}
                    {...(hideLogo && { opacity: 0 })}
                />
                <path
                    d="M79.0403 46.947V46.5876C79.0403 45.3689 79.2174 44.2387 79.5716 43.197C79.9257 42.1449 80.4362 41.2335 81.1028 40.4626C81.7799 39.6814 82.6028 39.0772 83.5716 38.6501C84.5507 38.2126 85.6549 37.9939 86.8841 37.9939C88.1237 37.9939 89.2278 38.2126 90.1966 38.6501C91.1757 39.0772 92.0039 39.6814 92.681 40.4626C93.358 41.2335 93.8737 42.1449 94.2278 43.197C94.582 44.2387 94.7591 45.3689 94.7591 46.5876V46.947C94.7591 48.1658 94.582 49.296 94.2278 50.3376C93.8737 51.3793 93.358 52.2908 92.681 53.072C92.0039 53.8429 91.181 54.447 90.2122 54.8845C89.2435 55.3116 88.1445 55.5251 86.9153 55.5251C85.6757 55.5251 84.5664 55.3116 83.5872 54.8845C82.6185 54.447 81.7955 53.8429 81.1185 53.072C80.4414 52.2908 79.9257 51.3793 79.5716 50.3376C79.2174 49.296 79.0403 48.1658 79.0403 46.947ZM82.806 46.5876V46.947C82.806 47.7074 82.8841 48.4262 83.0403 49.1033C83.1966 49.7804 83.4414 50.3741 83.7747 50.8845C84.108 51.3949 84.5351 51.796 85.056 52.0876C85.5768 52.3793 86.1966 52.5251 86.9153 52.5251C87.6132 52.5251 88.2174 52.3793 88.7278 52.0876C89.2487 51.796 89.6757 51.3949 90.0091 50.8845C90.3424 50.3741 90.5872 49.7804 90.7435 49.1033C90.9101 48.4262 90.9935 47.7074 90.9935 46.947V46.5876C90.9935 45.8376 90.9101 45.1293 90.7435 44.4626C90.5872 43.7856 90.3372 43.1866 89.9935 42.6658C89.6601 42.1449 89.233 41.7387 88.7122 41.447C88.2018 41.1449 87.5924 40.9939 86.8841 40.9939C86.1757 40.9939 85.5612 41.1449 85.0403 41.447C84.5299 41.7387 84.108 42.1449 83.7747 42.6658C83.4414 43.1866 83.1966 43.7856 83.0403 44.4626C82.8841 45.1293 82.806 45.8376 82.806 46.5876Z"
                    fill={logo}
                    {...(hideLogo && { opacity: 0 })}
                />
            </g>
            <defs>
                <clipPath id="clip0_1115_5602">
                    <rect y="0.972717" width="470" height="86.47" rx="8" fill="white" />
                </clipPath>
            </defs>
        </svg>
    )
}

export default HeaderImage
