import React from 'react'

type BaseImageProps = {
    typoPrimary: string
    typoSecondary: string
    typoAlert: string
    controlBgSystem: string
    controlTypoSystem: string
}

const BaseImage = ({
    typoPrimary = '#2d255e',
    typoSecondary = '#9e9ca8',
    typoAlert = '#f34343',
    controlBgSystem = '#f5f4f1',
    controlTypoSystem = '#2d255e',
}: Partial<BaseImageProps>) => {
    return (
        <svg
            width="471"
            height="123"
            viewBox="0 0 471 123"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                d="M0 11.1573C0 4.99497 4.99497 0 11.1573 0H458.843C465.005 0 470 4.99497 470 11.1573V58.5757C470 64.738 465.005 69.7329 458.843 69.7329H11.1573C4.99497 69.7329 0 64.738 0 58.5757V11.1573Z"
                fill="#FFF"
            />
            <path
                d="M17.588 21.6158V24.8835H22.7733V26.5711H17.588V30.6825H15.5936V19.9436H23.433V21.6158H17.588ZM28.3199 19.7902C29.7926 19.7902 30.9328 20.2505 31.741 21.1709C32.559 22.0914 32.9683 23.4108 32.9683 25.129C32.9683 26.3354 32.7486 27.3688 32.3086 28.2279C31.8693 29.0766 31.2501 29.7265 30.4523 30.1762C29.6643 30.6156 28.7494 30.8359 27.7062 30.8359C27.154 30.8359 26.6324 30.7801 26.1414 30.6672C25.6975 30.5598 25.2731 30.3838 24.8834 30.1456L25.6198 28.6421C26.1519 28.9901 26.8318 29.1637 27.6602 29.1637C28.6937 29.1637 29.5012 28.8464 30.0841 28.2126C30.6671 27.578 30.9586 26.6631 30.9586 25.4665V25.4511C30.6413 25.8193 30.2375 26.1004 29.7466 26.2949C29.2557 26.479 28.7034 26.5711 28.0898 26.5711C27.3841 26.5711 26.7502 26.4386 26.1875 26.1722C25.6254 25.896 25.1854 25.5076 24.8681 25.0062C24.5515 24.5049 24.3925 23.9275 24.3925 23.2727C24.3925 22.5774 24.5669 21.9687 24.9141 21.4471C25.2619 20.9152 25.7505 20.4903 26.3255 20.2198C26.9183 19.9339 27.5835 19.7902 28.3199 19.7902ZM28.4733 25.0062C29.1176 25.0062 29.6392 24.8319 30.0381 24.4846C30.4474 24.1367 30.6518 23.6967 30.6518 23.1653C30.6518 22.6437 30.4523 22.2141 30.0535 21.8766C29.665 21.5287 29.1232 21.355 28.4273 21.355C27.8032 21.355 27.2976 21.5238 26.9085 21.8613C26.5201 22.189 26.3255 22.6284 26.3255 23.1806C26.3255 23.7434 26.5201 24.1883 26.9085 24.5153C27.2969 24.8431 27.8192 25.0062 28.4733 25.0062ZM40.1013 30.8359C39.0065 30.8359 38.0204 30.6009 37.1404 30.1302C36.2832 29.6708 35.5672 28.9867 35.0693 28.1512C34.5687 27.3026 34.3176 26.3563 34.3176 25.3131C34.3176 24.2699 34.5687 23.3292 35.0693 22.4903C35.5614 21.6502 36.2788 20.9646 37.1404 20.5113C38.0197 20.0301 39.0072 19.7902 40.1013 19.7902C41.1961 19.7902 42.1828 20.0308 43.0621 20.5113C43.9207 20.9618 44.6376 21.6415 45.1332 22.4749C45.6346 23.3138 45.8849 24.2601 45.8849 25.3131C45.8849 26.366 45.6339 27.3123 45.1332 28.1512C44.6354 28.9867 43.9194 29.6709 43.0621 30.1302C42.1828 30.6009 41.1961 30.8359 40.1013 30.8359ZM40.1013 29.087C40.8174 29.087 41.4611 28.9287 42.0343 28.6114C42.5987 28.2926 43.0654 27.8258 43.3843 27.2614C43.712 26.6784 43.8752 26.0292 43.8752 25.3131C43.8752 24.5969 43.712 23.9533 43.3843 23.3801C43.0712 22.8113 42.6031 22.3431 42.0343 22.03C41.4618 21.7023 40.8174 21.5391 40.1013 21.5391C39.3858 21.5391 38.7415 21.703 38.1683 22.03C37.5995 22.3432 37.1314 22.8113 36.8182 23.3801C36.4905 23.9526 36.3273 24.5969 36.3273 25.3131C36.3273 26.0292 36.4912 26.6784 36.8182 27.2614C37.1372 27.8258 37.6039 28.2925 38.1683 28.6114C38.7415 28.9287 39.3851 29.087 40.1013 29.087ZM54.8602 28.995V30.6825H46.9442V29.3478L51.209 25.2977C51.6902 24.8375 52.0117 24.4386 52.1755 24.1011C52.3499 23.7531 52.4363 23.4108 52.4363 23.0733C52.4363 22.5719 52.2676 22.1883 51.9301 21.9227C51.5926 21.657 51.0968 21.5238 50.442 21.5238C49.3472 21.5238 48.509 21.8969 47.926 22.6437L46.5299 21.5698C46.949 21.0071 47.5118 20.5726 48.2175 20.2658C48.9329 19.9485 49.7307 19.7902 50.6107 19.7902C51.7767 19.7902 52.7076 20.0664 53.4028 20.6187C54.0981 21.1709 54.446 21.9227 54.446 22.8738C54.4494 23.4418 54.3235 24.0032 54.0778 24.5153C53.8324 25.0265 53.3617 25.6101 52.6665 26.2642L49.7976 28.995H54.8602ZM62.9765 25.0369C63.5385 25.2928 63.9681 25.6401 64.2644 26.0801C64.5713 26.5097 64.7247 27.0159 64.7247 27.5989C64.7247 28.2537 64.5413 28.8262 64.1731 29.3171C63.8147 29.8081 63.3035 30.1867 62.639 30.4524C61.9737 30.7083 61.2018 30.8359 60.3217 30.8359C59.4431 30.8359 58.6705 30.7083 58.0052 30.4524C57.3511 30.1867 56.8448 29.8081 56.4864 29.3171C56.1287 28.8262 55.9495 28.2537 55.9495 27.5989C55.9495 27.0159 56.098 26.5097 56.3951 26.0801C56.6914 25.6408 57.1154 25.2922 57.6677 25.0369C57.2388 24.8019 56.9062 24.4951 56.6705 24.1165C56.446 23.728 56.333 23.2831 56.333 22.7818C56.333 22.1786 56.4969 21.6521 56.8239 21.2016C57.1614 20.7518 57.6328 20.4039 58.236 20.1584C58.8392 19.913 59.5344 19.7902 60.3217 19.7902C61.1195 19.7902 61.821 19.913 62.4235 20.1584C63.0274 20.4039 63.4974 20.7511 63.8356 21.2016C64.1724 21.6514 64.3411 22.1779 64.3411 22.7818C64.3411 23.2831 64.224 23.7232 63.989 24.1011C63.7533 24.4798 63.4165 24.7915 62.9765 25.0369ZM60.3217 21.355C59.6983 21.355 59.2018 21.4875 58.8343 21.7539C58.4759 22.0196 58.2974 22.3934 58.2974 22.8738C58.2974 23.334 58.4759 23.7022 58.8343 23.9784C59.2025 24.2441 59.6983 24.3773 60.3217 24.3773C60.9563 24.3773 61.457 24.2448 61.8252 23.9784C62.1941 23.7022 62.3782 23.334 62.3782 22.8738C62.3782 22.3927 62.1885 22.0196 61.8098 21.7539C61.4416 21.4882 60.9458 21.355 60.3217 21.355ZM60.3217 29.2711C61.0581 29.2711 61.6411 29.1177 62.0706 28.8109C62.5009 28.5041 62.715 28.0794 62.715 27.5376C62.715 27.0055 62.5002 26.5864 62.0706 26.2796C61.6418 25.9727 61.0588 25.8193 60.3217 25.8193C59.5854 25.8193 59.008 25.9727 58.5882 26.2796C58.1698 26.5864 57.9599 27.0055 57.9599 27.5376C57.9599 28.0794 58.1691 28.5041 58.5882 28.8109C59.008 29.1177 59.5854 29.2711 60.3217 29.2711Z"
                fill={typoPrimary}
            />
            <path
                d="M89.2581 31.1079C92.4505 31.1079 95.0111 28.5417 95.0111 25.3549C95.0111 22.1681 92.4505 19.6019 89.2637 19.6019C88.8495 19.6019 88.5824 19.8411 88.5824 20.2386V22.0802C88.5824 22.4233 88.8279 22.6848 89.171 22.6848C89.514 22.6848 89.7539 22.4233 89.7539 22.0802V21.0287C91.9219 21.2797 93.5781 23.1207 93.5781 25.3542C93.5796 25.922 93.4688 26.4844 93.2523 27.0092C93.0357 27.5341 92.7176 28.0109 92.3161 28.4124C91.9147 28.8139 91.4379 29.1321 90.9131 29.3488C90.3883 29.5654 89.8259 29.6762 89.2581 29.6749C88.6902 29.6767 88.1276 29.5662 87.6026 29.3497C87.0776 29.1332 86.6006 28.815 86.1991 28.4134C85.7976 28.0119 85.4795 27.5348 85.2631 27.0098C85.0466 26.4847 84.9362 25.9221 84.9382 25.3542C84.9418 24.4092 85.2535 23.4912 85.8259 22.7392C86.0929 22.3473 86.1585 21.9875 85.8426 21.6828C85.5316 21.3885 85.0309 21.4213 84.7143 21.8571C83.9329 22.8555 83.5074 24.0864 83.5052 25.3542C83.5052 28.541 86.0713 31.1079 89.2581 31.1079ZM90.1409 26.2698C90.6256 25.7684 90.5217 25.0711 89.9555 24.6952L87.3621 22.9631C86.9534 22.696 86.5776 23.0774 86.8447 23.4861L88.5768 26.0732C88.9478 26.6401 89.65 26.7496 90.1409 26.2698ZM103.069 29.3994C102.444 29.3994 101.886 29.2432 101.395 28.9308C100.904 28.6107 100.518 28.1498 100.235 27.5473C99.9524 26.9372 99.8108 26.2154 99.8108 25.3828C99.8108 24.5495 99.9524 23.8319 100.235 23.2294C100.518 22.6193 100.904 22.1583 101.395 21.8459C101.886 21.5259 102.444 21.3662 103.069 21.3662C103.694 21.3662 104.251 21.5266 104.742 21.8459C105.241 22.1583 105.631 22.62 105.914 23.2294C106.197 23.8319 106.338 24.5495 106.338 25.3828C106.338 26.2161 106.197 26.9378 105.914 27.5473C105.631 28.1498 105.241 28.6107 104.742 28.9308C104.251 29.2432 103.694 29.3994 103.069 29.3994ZM103.069 28.1386C103.627 28.1386 104.066 27.9085 104.385 27.4469C104.713 26.986 104.876 26.2977 104.876 25.3828C104.876 24.4679 104.713 23.7796 104.385 23.3187C104.066 22.8578 103.627 22.627 103.069 22.627C102.519 22.627 102.08 22.8571 101.752 23.3187C101.433 23.7796 101.272 24.4679 101.272 25.3828C101.272 26.2977 101.433 26.986 101.752 27.4469C102.08 27.9078 102.519 28.1386 103.069 28.1386ZM110.465 29.3994C109.84 29.3994 109.282 29.2432 108.791 28.9308C108.3 28.6107 107.913 28.1498 107.631 27.5473C107.348 26.9372 107.207 26.2154 107.207 25.3828C107.207 24.5495 107.348 23.8319 107.631 23.2294C107.913 22.6193 108.3 22.1583 108.791 21.8459C109.282 21.5259 109.84 21.3662 110.465 21.3662C111.089 21.3662 111.647 21.5266 112.138 21.8459C112.637 22.1583 113.027 22.62 113.31 23.2294C113.592 23.8319 113.734 24.5495 113.734 25.3828C113.734 26.2161 113.592 26.9378 113.31 27.5473C113.027 28.1498 112.637 28.6107 112.138 28.9308C111.647 29.2432 111.089 29.3994 110.465 29.3994ZM110.465 28.1386C111.022 28.1386 111.461 27.9085 111.781 27.4469C112.108 26.986 112.272 26.2977 112.272 25.3828C112.272 24.4679 112.108 23.7796 111.781 23.3187C111.461 22.8578 111.022 22.627 110.465 22.627C109.914 22.627 109.475 22.8571 109.148 23.3187C108.828 23.7796 108.668 24.4679 108.668 25.3828C108.668 26.2977 108.828 26.986 109.148 27.4469C109.475 27.9078 109.914 28.1386 110.465 28.1386ZM115.473 25.115C115.22 25.115 115.004 25.0293 114.826 24.8584C114.738 24.771 114.669 24.6665 114.623 24.5514C114.576 24.4363 114.554 24.3129 114.558 24.189C114.558 23.9135 114.643 23.6904 114.815 23.5195C114.993 23.3487 115.212 23.2629 115.473 23.2629C115.733 23.2629 115.948 23.3487 116.12 23.5195C116.298 23.6904 116.388 23.9135 116.388 24.189C116.388 24.4567 116.298 24.6799 116.12 24.8584C116.034 24.9419 115.933 25.0076 115.822 25.0516C115.711 25.0957 115.592 25.1172 115.473 25.115ZM115.473 29.3659C115.22 29.3659 115.004 29.2802 114.826 29.1093C114.738 29.0219 114.669 28.9175 114.623 28.8023C114.576 28.6872 114.554 28.5639 114.558 28.4399C114.558 28.1644 114.643 27.9413 114.815 27.7705C114.993 27.5996 115.212 27.5138 115.473 27.5138C115.733 27.5138 115.948 27.5996 116.12 27.7705C116.298 27.9413 116.388 28.1644 116.388 28.4399C116.388 28.7077 116.298 28.9308 116.12 29.1093C116.034 29.1928 115.933 29.2585 115.822 29.3026C115.711 29.3466 115.592 29.3682 115.473 29.3659ZM120.54 24.7022C121.261 24.7915 121.812 25.0369 122.191 25.4386C122.57 25.8403 122.76 26.3423 122.76 26.9448C122.765 27.3821 122.645 27.8117 122.414 28.1833C122.183 28.555 121.834 28.8527 121.365 29.0759C120.904 29.292 120.339 29.3994 119.669 29.3994C119.111 29.3994 118.572 29.3213 118.052 29.1651C117.538 29.0012 117.1 28.7781 116.735 28.4957L117.36 27.3688C117.642 27.6066 117.985 27.7963 118.386 27.9378C118.793 28.0714 119.219 28.1391 119.647 28.1386C120.16 28.1386 120.562 28.034 120.852 27.8262C121.15 27.6101 121.298 27.3207 121.298 26.956C121.298 26.5913 121.157 26.3089 120.874 26.108C120.599 25.8995 120.175 25.7956 119.602 25.7956H118.888V24.8026L120.662 22.6939H117.114V21.4778H122.436V22.4484L120.54 24.7022ZM127.145 24.4679C127.658 24.4679 128.12 24.5683 128.528 24.7692C128.922 24.9492 129.256 25.2399 129.488 25.6059C129.719 25.9707 129.834 26.3904 129.834 26.8667C129.834 27.3723 129.707 27.8186 129.454 28.2056C129.199 28.5874 128.844 28.8922 128.428 29.087C127.997 29.2955 127.513 29.3994 126.977 29.3994C125.906 29.3994 125.074 29.0647 124.478 28.3953C123.891 27.7258 123.597 26.7663 123.597 25.5167C123.597 24.6388 123.757 23.8919 124.076 23.2741C124.397 22.6493 124.843 22.1772 125.415 21.8571C125.996 21.5294 126.665 21.3662 127.424 21.3662C127.825 21.3662 128.201 21.4108 128.551 21.5001C128.908 21.5817 129.216 21.7044 129.477 21.8683L128.941 22.9617C128.555 22.7085 128.06 22.5823 127.457 22.5823C126.706 22.5823 126.118 22.8124 125.694 23.2741C125.27 23.735 125.058 24.401 125.058 25.2712V25.2824C125.296 25.0098 125.599 24.8024 125.94 24.6799C126.297 24.5383 126.698 24.4679 127.145 24.4679ZM126.899 28.2614C127.353 28.2614 127.721 28.1428 128.004 27.9043C128.287 27.6589 128.428 27.3353 128.428 26.9337C128.428 26.5243 128.287 26.2015 128.004 25.963C127.721 25.7252 127.342 25.6059 126.866 25.6059C126.397 25.6059 126.014 25.7322 125.717 25.9853C125.577 26.1025 125.465 26.2495 125.39 26.4156C125.315 26.5817 125.278 26.7625 125.281 26.9448C125.281 27.3242 125.423 27.6401 125.705 27.8932C125.996 28.1386 126.394 28.2614 126.899 28.2614ZM85.0741 15.3413H127.611V12.5519H85.0741V15.3413ZM127.611 34.8665H85.0741V37.6558H127.611V34.8665ZM85.0741 34.8665C79.6824 34.8665 75.3115 30.4956 75.3115 25.1039H72.5222C72.5222 32.036 78.142 37.6558 85.0741 37.6558V34.8665ZM137.374 25.1039C137.374 30.4956 133.003 34.8665 127.611 34.8665V37.6558C134.543 37.6558 140.163 32.036 140.163 25.1039H137.374ZM127.611 15.3413C133.003 15.3413 137.374 19.7121 137.374 25.1039H140.163C140.163 18.1717 134.543 12.5519 127.611 12.5519V15.3413ZM85.0741 12.5519C78.142 12.5519 72.5222 18.1717 72.5222 25.1039H75.3115C75.3115 19.7121 79.6824 15.3413 85.0741 15.3413V12.5519Z"
                fill={typoAlert}
            />
            <path
                d="M159.688 31.1079C162.881 31.1079 165.441 28.5417 165.441 25.3549C165.441 22.1681 162.881 19.6019 159.694 19.6019C159.28 19.6019 159.013 19.8411 159.013 20.2386V22.0802C159.013 22.4233 159.258 22.6848 159.601 22.6848C159.944 22.6848 160.184 22.4233 160.184 22.0802V21.0287C162.352 21.2797 164.008 23.1207 164.008 25.3542C164.01 25.922 163.899 26.4844 163.683 27.0092C163.466 27.5341 163.148 28.0109 162.746 28.4124C162.345 28.8139 161.868 29.1321 161.343 29.3488C160.819 29.5654 160.256 29.6762 159.688 29.6749C159.121 29.6767 158.558 29.5662 158.033 29.3497C157.508 29.1332 157.031 28.815 156.629 28.4134C156.228 28.0119 155.91 27.5348 155.693 27.0098C155.477 26.4847 155.367 25.9221 155.368 25.3542C155.372 24.4092 155.684 23.4912 156.256 22.7392C156.523 22.3473 156.589 21.9875 156.273 21.6828C155.962 21.3885 155.461 21.4213 155.145 21.8571C154.363 22.8555 153.938 24.0864 153.935 25.3542C153.935 28.541 156.502 31.1079 159.688 31.1079ZM160.571 26.2698C161.056 25.7684 160.952 25.0711 160.386 24.6952L157.792 22.9631C157.384 22.696 157.008 23.0774 157.275 23.4861L159.007 26.0732C159.378 26.6401 160.08 26.7496 160.571 26.2698ZM173.227 29.3994C172.602 29.3994 172.044 29.2432 171.553 28.9308C171.063 28.6107 170.676 28.1498 170.393 27.5473C170.11 26.9372 169.969 26.2154 169.969 25.3828C169.969 24.5495 170.11 23.8319 170.393 23.2294C170.676 22.6193 171.063 22.1583 171.553 21.8459C172.044 21.5259 172.602 21.3662 173.227 21.3662C173.852 21.3662 174.41 21.5266 174.901 21.8459C175.399 22.1583 175.789 22.62 176.072 23.2294C176.355 23.8319 176.496 24.5495 176.496 25.3828C176.496 26.2161 176.355 26.9378 176.072 27.5473C175.789 28.1498 175.399 28.6107 174.901 28.9308C174.41 29.2432 173.852 29.3994 173.227 29.3994ZM173.227 28.1386C173.785 28.1386 174.224 27.9085 174.544 27.4469C174.871 26.986 175.035 26.2977 175.035 25.3828C175.035 24.4679 174.871 23.7796 174.544 23.3187C174.224 22.8578 173.785 22.627 173.227 22.627C172.676 22.627 172.238 22.8571 171.911 23.3187C171.59 23.7796 171.431 24.4679 171.431 25.3828C171.431 26.2977 171.59 26.986 171.911 27.4469C172.238 27.9078 172.676 28.1386 173.227 28.1386ZM180.622 29.3994C179.997 29.3994 179.44 29.2432 178.949 28.9308C178.458 28.6107 178.071 28.1498 177.788 27.5473C177.506 26.9372 177.364 26.2154 177.364 25.3828C177.364 24.5495 177.506 23.8319 177.788 23.2294C178.071 22.6193 178.458 22.1583 178.949 21.8459C179.44 21.5259 179.997 21.3662 180.622 21.3662C181.247 21.3662 181.805 21.5266 182.296 21.8459C182.794 22.1583 183.185 22.62 183.467 23.2294C183.75 23.8319 183.891 24.5495 183.891 25.3828C183.891 26.2161 183.75 26.9378 183.467 27.5473C183.185 28.1498 182.794 28.6107 182.296 28.9308C181.805 29.2432 181.247 29.3994 180.622 29.3994ZM180.622 28.1386C181.18 28.1386 181.619 27.9085 181.939 27.4469C182.267 26.986 182.43 26.2977 182.43 25.3828C182.43 24.4679 182.267 23.7796 181.939 23.3187C181.619 22.8578 181.18 22.627 180.622 22.627C180.072 22.627 179.633 22.8571 179.306 23.3187C178.986 23.7796 178.826 24.4679 178.826 25.3828C178.826 26.2977 178.986 26.986 179.306 27.4469C179.633 27.9078 180.072 28.1386 180.622 28.1386ZM185.63 25.115C185.377 25.115 185.162 25.0293 184.983 24.8584C184.895 24.771 184.826 24.6665 184.78 24.5514C184.734 24.4363 184.712 24.3129 184.716 24.189C184.716 23.9135 184.801 23.6904 184.972 23.5195C185.151 23.3487 185.37 23.2629 185.63 23.2629C185.891 23.2629 186.107 23.3487 186.278 23.5195C186.456 23.6904 186.545 23.9135 186.545 24.189C186.545 24.4567 186.456 24.6799 186.278 24.8584C186.192 24.942 186.091 25.0077 185.98 25.0517C185.869 25.0958 185.75 25.1173 185.63 25.115ZM185.63 29.3659C185.377 29.3659 185.162 29.2802 184.983 29.1093C184.895 29.0219 184.826 28.9175 184.78 28.8023C184.734 28.6872 184.712 28.5639 184.716 28.4399C184.716 28.1644 184.801 27.9413 184.972 27.7705C185.151 27.5996 185.37 27.5138 185.63 27.5138C185.891 27.5138 186.107 27.5996 186.278 27.7705C186.456 27.9413 186.545 28.1644 186.545 28.4399C186.545 28.7077 186.456 28.9308 186.278 29.1093C186.192 29.1929 186.091 29.2586 185.98 29.3027C185.869 29.3467 185.75 29.3682 185.63 29.3659ZM190.072 21.4778V29.2878H188.622V22.6939H186.971V21.4778H190.072ZM195.058 24.4679C195.572 24.4679 196.033 24.5683 196.442 24.7692C196.836 24.9494 197.169 25.2401 197.401 25.6059C197.632 25.9707 197.747 26.3904 197.747 26.8667C197.747 27.3723 197.621 27.8186 197.368 28.2056C197.112 28.5873 196.757 28.892 196.341 29.087C195.91 29.2955 195.427 29.3994 194.891 29.3994C193.82 29.3994 192.987 29.0647 192.392 28.3953C191.804 27.7258 191.51 26.7663 191.51 25.5167C191.51 24.6388 191.67 23.8919 191.99 23.2741C192.31 22.6493 192.756 22.1772 193.329 21.8571C193.909 21.5294 194.579 21.3662 195.337 21.3662C195.739 21.3662 196.115 21.4108 196.464 21.5001C196.821 21.5817 197.13 21.7044 197.39 21.8683L196.855 22.9617C196.468 22.7085 195.973 22.5823 195.371 22.5823C194.62 22.5823 194.032 22.8124 193.608 23.2741C193.184 23.735 192.972 24.401 192.972 25.2712V25.2824C193.21 25.0098 193.513 24.8024 193.853 24.6799C194.21 24.5383 194.612 24.4679 195.058 24.4679ZM194.813 28.2614C195.267 28.2614 195.635 28.1428 195.917 27.9043C196.2 27.6589 196.341 27.3353 196.341 26.9337C196.341 26.5243 196.2 26.2015 195.917 25.963C195.635 25.7252 195.256 25.6059 194.779 25.6059C194.311 25.6059 193.928 25.7322 193.63 25.9853C193.491 26.1025 193.379 26.2495 193.304 26.4156C193.228 26.5817 193.191 26.7625 193.195 26.9448C193.195 27.3242 193.337 27.6401 193.619 27.8932C193.909 28.1386 194.307 28.2614 194.813 28.2614ZM155.504 15.3413H195.252V12.5519H155.504V15.3413ZM195.252 34.8665H155.504V37.6558H195.252V34.8665ZM155.504 34.8665C150.113 34.8665 145.742 30.4956 145.742 25.1039H142.953C142.953 32.036 148.572 37.6558 155.504 37.6558V34.8665ZM205.015 25.1039C205.015 30.4956 200.644 34.8665 195.252 34.8665V37.6558C202.184 37.6558 207.804 32.036 207.804 25.1039H205.015ZM195.252 15.3413C200.644 15.3413 205.015 19.7121 205.015 25.1039H207.804C207.804 18.1717 202.184 12.5519 195.252 12.5519V15.3413ZM155.504 12.5519C148.572 12.5519 142.953 18.1717 142.953 25.1039H145.742C145.742 19.7121 150.113 15.3413 155.504 15.3413V12.5519ZM211.988 25.1039C211.988 18.9416 216.983 13.9466 223.145 13.9466H242.671C248.833 13.9466 253.828 18.9416 253.828 25.1039C253.828 31.2662 248.833 36.2611 242.671 36.2611H223.145C216.983 36.2611 211.988 31.2662 211.988 25.1039Z"
                fill={typoPrimary}
            />
            <path
                d="M227.363 28.0717V29.2878H221.505V21.4778H227.207V22.6939H222.956V24.7245H226.727V25.9183H222.956V28.0717H227.363ZM235.808 21.4778V29.2878H234.614L230.308 23.9993V29.2878H228.868V21.4778H230.062L234.369 26.7663V21.4778H235.808ZM243.123 25.2935H244.495V28.4064C244.075 28.7358 243.599 28.9854 243.089 29.1428C242.555 29.3136 241.998 29.4002 241.438 29.3994C240.642 29.3994 239.925 29.2286 239.284 28.8862C238.661 28.552 238.14 28.0544 237.778 27.4469C237.414 26.8367 237.232 26.1492 237.232 25.3828C237.232 24.6164 237.414 23.9289 237.778 23.3187C238.139 22.7127 238.66 22.2184 239.284 21.8906C239.932 21.5412 240.657 21.3662 241.46 21.3662C242.115 21.3662 242.71 21.4743 243.245 21.6897C243.781 21.9059 244.231 22.2218 244.595 22.6381L243.68 23.5307C243.086 22.9359 242.368 22.6381 241.527 22.6381C240.977 22.6381 240.486 22.7532 240.054 22.984C239.636 23.2087 239.289 23.5447 239.05 23.9547C238.812 24.371 238.693 24.8473 238.693 25.3828C238.693 25.9037 238.812 26.3723 239.05 26.7886C239.291 27.2002 239.637 27.5394 240.054 27.7705C240.486 28.0082 240.973 28.1275 241.516 28.1275C242.126 28.1275 242.662 27.9936 243.123 27.7258V25.2935Z"
                fill={controlTypoSystem}
            />
            <path
                d="M223.145 15.3413H242.671V12.5519H223.145V15.3413ZM242.671 34.8665H223.145V37.6558H242.671V34.8665ZM223.145 34.8665C217.754 34.8665 213.383 30.4956 213.383 25.1039H210.594C210.594 32.036 216.213 37.6558 223.145 37.6558V34.8665ZM252.433 25.1039C252.433 30.4956 248.062 34.8665 242.671 34.8665V37.6558C249.603 37.6558 255.223 32.036 255.223 25.1039H252.433ZM242.671 15.3413C248.062 15.3413 252.433 19.7121 252.433 25.1039H255.223C255.223 18.1717 249.603 12.5519 242.671 12.5519V15.3413ZM223.145 12.5519C216.213 12.5519 210.594 18.1717 210.594 25.1039H213.383C213.383 19.7121 217.754 15.3413 223.145 15.3413V12.5519Z"
                fill={typoPrimary}
            />
            <path
                d="M323.35 23.7092C323.35 19.088 327.097 15.3412 331.718 15.3412H447.685C452.307 15.3412 456.053 19.088 456.053 23.7092V46.0237C456.053 50.6449 452.307 54.3917 447.685 54.3917H331.718C327.097 54.3917 323.35 50.6449 323.35 46.0237V23.7092Z"
                fill={controlBgSystem}
            />
            <path
                d="M0 91.7329C0 87.1117 3.74675 83.365 8.36795 83.365H219.659C224.28 83.365 228.027 87.1117 228.027 91.7329V114.047C228.027 118.669 224.28 122.415 219.659 122.415H8.36795C3.74675 122.415 0 118.669 0 114.047V91.7329Z"
                fill={controlBgSystem}
            />
            <path
                d="M242 91.7329C242 87.1117 245.747 83.365 250.368 83.365H461.659C466.28 83.365 470.027 87.1117 470.027 91.7329V114.047C470.027 118.669 466.28 122.415 461.659 122.415H250.368C245.747 122.415 242 118.669 242 114.047V91.7329Z"
                fill={controlBgSystem}
            />
            <path
                d="M19.42 44.845H20.692L24.004 53.365H22.588L21.688 51.049H18.4L17.512 53.365H16.084L19.42 44.845ZM21.424 50.053L20.056 46.321L18.64 50.053H21.424ZM27.5462 53.485C27.0582 53.485 26.6142 53.401 26.2142 53.233C25.8222 53.057 25.4822 52.817 25.1942 52.513C24.9062 52.209 24.6822 51.861 24.5222 51.469C24.3702 51.077 24.2942 50.661 24.2942 50.221C24.2942 49.629 24.4262 49.089 24.6902 48.601C24.9622 48.113 25.3382 47.721 25.8182 47.425C26.3062 47.129 26.8822 46.981 27.5462 46.981C28.1862 46.981 28.7422 47.125 29.2142 47.413C29.6942 47.693 30.0462 48.069 30.2702 48.541L28.9862 48.949C28.8422 48.685 28.6382 48.481 28.3742 48.337C28.1182 48.185 27.8342 48.109 27.5222 48.109C27.1702 48.109 26.8502 48.201 26.5622 48.385C26.2822 48.561 26.0582 48.809 25.8902 49.129C25.7302 49.441 25.6502 49.805 25.6502 50.221C25.6502 50.621 25.7342 50.985 25.9022 51.313C26.0702 51.633 26.2942 51.889 26.5742 52.081C26.8622 52.265 27.1822 52.357 27.5342 52.357C27.7502 52.357 27.9582 52.321 28.1582 52.249C28.3662 52.169 28.5462 52.065 28.6982 51.937C28.8502 51.801 28.9582 51.653 29.0222 51.493L30.3182 51.877C30.1822 52.189 29.9782 52.465 29.7062 52.705C29.4422 52.945 29.1262 53.137 28.7582 53.281C28.3982 53.417 27.9942 53.485 27.5462 53.485ZM31.3453 50.929V47.089H32.6653V50.665C32.6653 51.225 32.7653 51.649 32.9653 51.937C33.1733 52.217 33.4733 52.357 33.8653 52.357C34.1133 52.357 34.3533 52.305 34.5853 52.201C34.8253 52.097 35.0413 51.945 35.2333 51.745C35.4333 51.537 35.5933 51.289 35.7133 51.001V47.089H37.0333V51.877C37.0333 52.029 37.0613 52.137 37.1173 52.201C37.1733 52.265 37.2653 52.301 37.3933 52.309V53.365C37.2573 53.389 37.1453 53.405 37.0573 53.413C36.9693 53.421 36.8853 53.425 36.8053 53.425C36.5653 53.425 36.3653 53.361 36.2053 53.233C36.0453 53.097 35.9533 52.925 35.9293 52.717L35.9053 52.093C35.6253 52.549 35.2613 52.897 34.8133 53.137C34.3653 53.369 33.8733 53.485 33.3373 53.485C32.6813 53.485 32.1853 53.269 31.8493 52.837C31.5133 52.405 31.3453 51.769 31.3453 50.929ZM42.1981 53.041C42.0861 53.097 41.9461 53.157 41.7781 53.221C41.6101 53.285 41.4181 53.341 41.2021 53.389C40.9941 53.437 40.7781 53.461 40.5541 53.461C40.2821 53.461 40.0301 53.413 39.7981 53.317C39.5661 53.221 39.3781 53.069 39.2341 52.861C39.0981 52.645 39.0301 52.369 39.0301 52.033V48.109H38.2021V47.089H39.0301V45.025H40.3501V47.089H41.7181V48.109H40.3501V51.613C40.3661 51.829 40.4341 51.989 40.5541 52.093C40.6821 52.197 40.8381 52.249 41.0221 52.249C41.2061 52.249 41.3821 52.217 41.5501 52.153C41.7181 52.089 41.8421 52.037 41.9221 51.997L42.1981 53.041ZM45.8743 53.485C45.3863 53.485 44.9423 53.401 44.5423 53.233C44.1503 53.057 43.8103 52.821 43.5223 52.525C43.2343 52.221 43.0103 51.877 42.8503 51.493C42.6983 51.101 42.6223 50.685 42.6223 50.245C42.6223 49.653 42.7583 49.113 43.0303 48.625C43.3023 48.129 43.6823 47.733 44.1703 47.437C44.6583 47.133 45.2303 46.981 45.8863 46.981C46.5423 46.981 47.1063 47.133 47.5783 47.437C48.0583 47.733 48.4303 48.125 48.6943 48.613C48.9583 49.101 49.0903 49.625 49.0903 50.185C49.0903 50.281 49.0863 50.373 49.0783 50.461C49.0703 50.541 49.0623 50.609 49.0543 50.665H44.0263C44.0503 51.033 44.1503 51.357 44.3263 51.637C44.5103 51.909 44.7423 52.125 45.0223 52.285C45.3023 52.437 45.6023 52.513 45.9223 52.513C46.2743 52.513 46.6063 52.425 46.9183 52.249C47.2383 52.073 47.4543 51.841 47.5663 51.553L48.6943 51.877C48.5583 52.181 48.3503 52.457 48.0703 52.705C47.7983 52.945 47.4743 53.137 47.0983 53.281C46.7223 53.417 46.3143 53.485 45.8743 53.485ZM43.9903 49.789H47.7823C47.7583 49.429 47.6543 49.113 47.4703 48.841C47.2943 48.561 47.0663 48.345 46.7863 48.193C46.5143 48.033 46.2103 47.953 45.8743 47.953C45.5463 47.953 45.2423 48.033 44.9623 48.193C44.6903 48.345 44.4663 48.561 44.2903 48.841C44.1143 49.113 44.0143 49.429 43.9903 49.789ZM55.9758 53.485C55.4878 53.485 55.0438 53.401 54.6438 53.233C54.2518 53.057 53.9118 52.821 53.6238 52.525C53.3358 52.221 53.1118 51.877 52.9518 51.493C52.7998 51.101 52.7238 50.685 52.7238 50.245C52.7238 49.653 52.8598 49.113 53.1318 48.625C53.4038 48.129 53.7838 47.733 54.2718 47.437C54.7598 47.133 55.3318 46.981 55.9878 46.981C56.6438 46.981 57.2078 47.133 57.6798 47.437C58.1598 47.733 58.5318 48.125 58.7958 48.613C59.0598 49.101 59.1918 49.625 59.1918 50.185C59.1918 50.281 59.1878 50.373 59.1798 50.461C59.1718 50.541 59.1638 50.609 59.1558 50.665H54.1278C54.1518 51.033 54.2518 51.357 54.4278 51.637C54.6118 51.909 54.8438 52.125 55.1238 52.285C55.4038 52.437 55.7038 52.513 56.0238 52.513C56.3758 52.513 56.7078 52.425 57.0198 52.249C57.3398 52.073 57.5558 51.841 57.6678 51.553L58.7958 51.877C58.6598 52.181 58.4518 52.457 58.1718 52.705C57.8998 52.945 57.5758 53.137 57.1998 53.281C56.8238 53.417 56.4158 53.485 55.9758 53.485ZM54.0918 49.789H57.8838C57.8598 49.429 57.7558 49.113 57.5718 48.841C57.3958 48.561 57.1678 48.345 56.8878 48.193C56.6158 48.033 56.3118 47.953 55.9758 47.953C55.6478 47.953 55.3438 48.033 55.0638 48.193C54.7918 48.345 54.5678 48.561 54.3918 48.841C54.2158 49.113 54.1158 49.429 54.0918 49.789ZM60.2971 54.841C60.4171 54.857 60.5331 54.873 60.6451 54.889C60.7651 54.913 60.8611 54.925 60.9331 54.925C61.0691 54.925 61.1851 54.881 61.2811 54.793C61.3851 54.713 61.4891 54.561 61.5931 54.337C61.6971 54.113 61.8251 53.789 61.9771 53.365L59.3971 47.089H60.7771L62.6971 52.021L64.4011 47.089H65.6731L62.8291 54.817C62.7411 55.049 62.6131 55.261 62.4451 55.453C62.2771 55.653 62.0691 55.809 61.8211 55.921C61.5731 56.033 61.2811 56.089 60.9451 56.089C60.8491 56.089 60.7491 56.081 60.6451 56.065C60.5411 56.049 60.4251 56.025 60.2971 55.993V54.841ZM69.2766 53.485C68.7886 53.485 68.3446 53.401 67.9446 53.233C67.5526 53.057 67.2126 52.821 66.9246 52.525C66.6366 52.221 66.4126 51.877 66.2526 51.493C66.1006 51.101 66.0246 50.685 66.0246 50.245C66.0246 49.653 66.1606 49.113 66.4326 48.625C66.7046 48.129 67.0846 47.733 67.5726 47.437C68.0606 47.133 68.6326 46.981 69.2886 46.981C69.9446 46.981 70.5086 47.133 70.9806 47.437C71.4606 47.733 71.8326 48.125 72.0966 48.613C72.3606 49.101 72.4926 49.625 72.4926 50.185C72.4926 50.281 72.4886 50.373 72.4806 50.461C72.4726 50.541 72.4646 50.609 72.4566 50.665H67.4286C67.4526 51.033 67.5526 51.357 67.7286 51.637C67.9126 51.909 68.1446 52.125 68.4246 52.285C68.7046 52.437 69.0046 52.513 69.3246 52.513C69.6766 52.513 70.0086 52.425 70.3206 52.249C70.6406 52.073 70.8566 51.841 70.9686 51.553L72.0966 51.877C71.9606 52.181 71.7526 52.457 71.4726 52.705C71.2006 52.945 70.8766 53.137 70.5006 53.281C70.1246 53.417 69.7166 53.485 69.2766 53.485ZM67.3926 49.789H71.1846C71.1606 49.429 71.0566 49.113 70.8726 48.841C70.6966 48.561 70.4686 48.345 70.1886 48.193C69.9166 48.033 69.6126 47.953 69.2766 47.953C68.9486 47.953 68.6446 48.033 68.3646 48.193C68.0926 48.345 67.8686 48.561 67.6926 48.841C67.5166 49.113 67.4166 49.429 67.3926 49.789ZM76.5342 53.365V47.089H77.8542V53.365H76.5342ZM76.5342 46.057V44.605H77.8542V46.057H76.5342ZM85.0684 53.365H83.7484V49.849C83.7484 49.265 83.6524 48.837 83.4604 48.565C83.2764 48.293 83.0004 48.157 82.6324 48.157C82.3764 48.157 82.1204 48.221 81.8644 48.349C81.6164 48.477 81.3924 48.653 81.1924 48.877C80.9924 49.093 80.8484 49.345 80.7604 49.633V53.365H79.4404V47.089H80.6404V48.349C80.8004 48.069 81.0084 47.829 81.2644 47.629C81.5284 47.421 81.8244 47.261 82.1524 47.149C82.4804 47.037 82.8284 46.981 83.1964 46.981C83.5724 46.981 83.8804 47.049 84.1204 47.185C84.3684 47.321 84.5604 47.509 84.6964 47.749C84.8404 47.981 84.9364 48.253 84.9844 48.565C85.0404 48.869 85.0684 49.193 85.0684 49.537V53.365ZM91.9777 53.449C91.5217 53.449 91.1657 53.329 90.9097 53.089C90.6537 52.841 90.5257 52.509 90.5257 52.093V46.933C90.5257 46.709 90.4937 46.497 90.4297 46.297C90.3657 46.097 90.2537 45.933 90.0937 45.805C89.9337 45.677 89.7017 45.613 89.3977 45.613C89.1257 45.613 88.9057 45.677 88.7377 45.805C88.5697 45.933 88.4457 46.109 88.3657 46.333C88.2857 46.549 88.2417 46.801 88.2337 47.089V47.245H89.3857V48.265H88.2337V53.365H86.9137V48.265H86.0737V47.245H86.9137V46.885C86.9137 46.381 87.0097 45.953 87.2017 45.601C87.3937 45.241 87.6737 44.965 88.0417 44.773C88.4097 44.581 88.8537 44.485 89.3737 44.485C90.2137 44.485 90.8337 44.689 91.2337 45.097C91.6417 45.497 91.8457 46.017 91.8457 46.657V51.529C91.8457 51.833 91.8897 52.033 91.9777 52.129C92.0737 52.225 92.1937 52.273 92.3377 52.273C92.4977 52.273 92.6537 52.253 92.8057 52.213C92.9657 52.173 93.0857 52.137 93.1657 52.105L93.3577 53.173C93.2697 53.213 93.1457 53.253 92.9857 53.293C92.8257 53.333 92.6577 53.369 92.4817 53.401C92.3057 53.433 92.1377 53.449 91.9777 53.449ZM93.6563 51.529C93.6563 51.129 93.7683 50.781 93.9923 50.485C94.2243 50.181 94.5403 49.949 94.9403 49.789C95.3403 49.621 95.8043 49.537 96.3323 49.537C96.6123 49.537 96.8963 49.557 97.1843 49.597C97.4803 49.637 97.7403 49.701 97.9643 49.789V49.393C97.9643 48.953 97.8323 48.609 97.5683 48.361C97.3043 48.113 96.9243 47.989 96.4283 47.989C96.0763 47.989 95.7443 48.053 95.4323 48.181C95.1203 48.301 94.7883 48.473 94.4363 48.697L93.9923 47.809C94.4083 47.529 94.8243 47.321 95.2403 47.185C95.6643 47.049 96.1083 46.981 96.5723 46.981C97.4123 46.981 98.0723 47.205 98.5523 47.653C99.0403 48.093 99.2843 48.721 99.2843 49.537V51.877C99.2843 52.029 99.3083 52.137 99.3563 52.201C99.4123 52.265 99.5043 52.301 99.6323 52.309V53.365C99.5123 53.389 99.4043 53.405 99.3083 53.413C99.2123 53.421 99.1323 53.425 99.0683 53.425C98.7883 53.425 98.5763 53.357 98.4323 53.221C98.2883 53.085 98.2043 52.925 98.1803 52.741L98.1443 52.381C97.8723 52.733 97.5243 53.005 97.1003 53.197C96.6763 53.389 96.2483 53.485 95.8163 53.485C95.4003 53.485 95.0283 53.401 94.7003 53.233C94.3723 53.057 94.1163 52.821 93.9323 52.525C93.7483 52.229 93.6563 51.897 93.6563 51.529ZM97.6523 51.913C97.7483 51.809 97.8243 51.705 97.8803 51.601C97.9363 51.497 97.9643 51.405 97.9643 51.325V50.605C97.7403 50.517 97.5043 50.453 97.2563 50.413C97.0083 50.365 96.7643 50.341 96.5243 50.341C96.0443 50.341 95.6523 50.437 95.3483 50.629C95.0523 50.821 94.9043 51.085 94.9043 51.421C94.9043 51.605 94.9523 51.781 95.0483 51.949C95.1523 52.117 95.2963 52.253 95.4803 52.357C95.6723 52.461 95.9083 52.513 96.1883 52.513C96.4763 52.513 96.7523 52.457 97.0163 52.345C97.2803 52.233 97.4923 52.089 97.6523 51.913ZM110.486 53.365H109.166V49.849C109.166 49.265 109.07 48.837 108.878 48.565C108.686 48.293 108.406 48.157 108.038 48.157C107.67 48.157 107.326 48.297 107.006 48.577C106.694 48.849 106.474 49.205 106.346 49.645V53.365H105.026V49.849C105.026 49.265 104.93 48.837 104.738 48.565C104.546 48.293 104.27 48.157 103.91 48.157C103.542 48.157 103.198 48.293 102.878 48.565C102.566 48.837 102.342 49.193 102.206 49.633V53.365H100.886V47.089H102.086V48.349C102.334 47.909 102.658 47.573 103.058 47.341C103.466 47.101 103.93 46.981 104.45 46.981C104.97 46.981 105.378 47.117 105.674 47.389C105.978 47.661 106.166 48.001 106.238 48.409C106.51 47.945 106.842 47.593 107.234 47.353C107.634 47.105 108.09 46.981 108.602 46.981C108.97 46.981 109.278 47.049 109.526 47.185C109.774 47.321 109.966 47.509 110.102 47.749C110.238 47.981 110.334 48.253 110.39 48.565C110.454 48.869 110.486 49.193 110.486 49.537V53.365ZM121.607 53.365H120.287V49.849C120.287 49.265 120.191 48.837 119.999 48.565C119.807 48.293 119.527 48.157 119.159 48.157C118.791 48.157 118.447 48.297 118.127 48.577C117.815 48.849 117.595 49.205 117.467 49.645V53.365H116.147V49.849C116.147 49.265 116.051 48.837 115.859 48.565C115.667 48.293 115.391 48.157 115.031 48.157C114.663 48.157 114.319 48.293 113.999 48.565C113.687 48.837 113.463 49.193 113.327 49.633V53.365H112.007V47.089H113.207V48.349C113.455 47.909 113.779 47.573 114.179 47.341C114.587 47.101 115.051 46.981 115.571 46.981C116.091 46.981 116.499 47.117 116.795 47.389C117.099 47.661 117.287 48.001 117.359 48.409C117.631 47.945 117.963 47.593 118.355 47.353C118.755 47.105 119.211 46.981 119.723 46.981C120.091 46.981 120.399 47.049 120.647 47.185C120.895 47.321 121.087 47.509 121.223 47.749C121.359 47.981 121.455 48.253 121.511 48.565C121.575 48.869 121.607 49.193 121.607 49.537V53.365ZM122.672 51.529C122.672 51.129 122.784 50.781 123.008 50.485C123.24 50.181 123.556 49.949 123.956 49.789C124.356 49.621 124.82 49.537 125.348 49.537C125.628 49.537 125.912 49.557 126.2 49.597C126.496 49.637 126.756 49.701 126.98 49.789V49.393C126.98 48.953 126.848 48.609 126.584 48.361C126.32 48.113 125.94 47.989 125.444 47.989C125.092 47.989 124.76 48.053 124.448 48.181C124.136 48.301 123.804 48.473 123.452 48.697L123.008 47.809C123.424 47.529 123.84 47.321 124.256 47.185C124.68 47.049 125.124 46.981 125.588 46.981C126.428 46.981 127.088 47.205 127.568 47.653C128.056 48.093 128.3 48.721 128.3 49.537V51.877C128.3 52.029 128.324 52.137 128.372 52.201C128.428 52.265 128.52 52.301 128.648 52.309V53.365C128.528 53.389 128.42 53.405 128.324 53.413C128.228 53.421 128.148 53.425 128.084 53.425C127.804 53.425 127.592 53.357 127.448 53.221C127.304 53.085 127.22 52.925 127.196 52.741L127.16 52.381C126.888 52.733 126.54 53.005 126.116 53.197C125.692 53.389 125.264 53.485 124.832 53.485C124.416 53.485 124.044 53.401 123.716 53.233C123.388 53.057 123.132 52.821 122.948 52.525C122.764 52.229 122.672 51.897 122.672 51.529ZM126.668 51.913C126.764 51.809 126.84 51.705 126.896 51.601C126.952 51.497 126.98 51.405 126.98 51.325V50.605C126.756 50.517 126.52 50.453 126.272 50.413C126.024 50.365 125.78 50.341 125.54 50.341C125.06 50.341 124.668 50.437 124.364 50.629C124.068 50.821 123.92 51.085 123.92 51.421C123.92 51.605 123.968 51.781 124.064 51.949C124.168 52.117 124.312 52.253 124.496 52.357C124.688 52.461 124.924 52.513 125.204 52.513C125.492 52.513 125.768 52.457 126.032 52.345C126.296 52.233 126.508 52.089 126.668 51.913ZM133.347 53.041C133.235 53.097 133.095 53.157 132.927 53.221C132.759 53.285 132.567 53.341 132.351 53.389C132.143 53.437 131.927 53.461 131.703 53.461C131.431 53.461 131.179 53.413 130.947 53.317C130.715 53.221 130.527 53.069 130.383 52.861C130.247 52.645 130.179 52.369 130.179 52.033V48.109H129.351V47.089H130.179V45.025H131.499V47.089H132.867V48.109H131.499V51.613C131.515 51.829 131.583 51.989 131.703 52.093C131.831 52.197 131.987 52.249 132.171 52.249C132.355 52.249 132.531 52.217 132.699 52.153C132.867 52.089 132.991 52.037 133.071 51.997L133.347 53.041ZM134.261 53.365V47.089H135.581V53.365H134.261ZM134.261 46.057V44.605H135.581V46.057H134.261ZM139.987 53.485C139.491 53.485 139.047 53.401 138.655 53.233C138.263 53.057 137.923 52.817 137.635 52.513C137.355 52.209 137.139 51.865 136.987 51.481C136.835 51.089 136.759 50.673 136.759 50.233C136.759 49.793 136.835 49.377 136.987 48.985C137.139 48.593 137.355 48.249 137.635 47.953C137.923 47.649 138.263 47.413 138.655 47.245C139.055 47.069 139.499 46.981 139.987 46.981C140.475 46.981 140.915 47.069 141.307 47.245C141.707 47.413 142.047 47.649 142.327 47.953C142.615 48.249 142.835 48.593 142.987 48.985C143.139 49.377 143.215 49.793 143.215 50.233C143.215 50.673 143.139 51.089 142.987 51.481C142.835 51.865 142.615 52.209 142.327 52.513C142.047 52.817 141.707 53.057 141.307 53.233C140.915 53.401 140.475 53.485 139.987 53.485ZM138.115 50.245C138.115 50.645 138.199 51.005 138.367 51.325C138.535 51.645 138.759 51.897 139.039 52.081C139.319 52.265 139.635 52.357 139.987 52.357C140.331 52.357 140.643 52.265 140.923 52.081C141.211 51.889 141.439 51.633 141.607 51.313C141.775 50.985 141.859 50.625 141.859 50.233C141.859 49.833 141.775 49.473 141.607 49.153C141.439 48.833 141.211 48.581 140.923 48.397C140.643 48.205 140.331 48.109 139.987 48.109C139.635 48.109 139.319 48.205 139.039 48.397C138.759 48.589 138.535 48.845 138.367 49.165C138.199 49.477 138.115 49.837 138.115 50.245ZM150.014 53.365H148.694V49.849C148.694 49.265 148.598 48.837 148.406 48.565C148.222 48.293 147.946 48.157 147.578 48.157C147.322 48.157 147.066 48.221 146.81 48.349C146.562 48.477 146.338 48.653 146.138 48.877C145.938 49.093 145.794 49.345 145.706 49.633V53.365H144.386V47.089H145.586V48.349C145.746 48.069 145.954 47.829 146.21 47.629C146.474 47.421 146.77 47.261 147.098 47.149C147.426 47.037 147.774 46.981 148.142 46.981C148.518 46.981 148.826 47.049 149.066 47.185C149.314 47.321 149.506 47.509 149.642 47.749C149.786 47.981 149.882 48.253 149.93 48.565C149.986 48.869 150.014 49.193 150.014 49.537V53.365Z"
                fill={typoSecondary}
            />
            <path
                d="M348.49 35.325C348.49 34.7183 348.597 34.1257 348.812 33.547C349.027 32.959 349.339 32.427 349.75 31.951C350.17 31.4657 350.679 31.083 351.276 30.803C351.873 30.5137 352.55 30.369 353.306 30.369C354.202 30.369 354.977 30.5743 355.63 30.985C356.283 31.3863 356.769 31.9043 357.086 32.539L355.854 33.365C355.667 32.9637 355.429 32.6463 355.14 32.413C354.86 32.1797 354.552 32.0163 354.216 31.923C353.889 31.8297 353.567 31.783 353.25 31.783C352.727 31.783 352.27 31.8903 351.878 32.105C351.486 32.3103 351.155 32.5857 350.884 32.931C350.623 33.2763 350.422 33.6637 350.282 34.093C350.151 34.5223 350.086 34.9517 350.086 35.381C350.086 35.857 350.165 36.319 350.324 36.767C350.483 37.2057 350.702 37.5977 350.982 37.943C351.271 38.279 351.612 38.545 352.004 38.741C352.396 38.937 352.825 39.035 353.292 39.035C353.609 39.035 353.941 38.979 354.286 38.867C354.631 38.755 354.949 38.5823 355.238 38.349C355.537 38.1063 355.77 37.789 355.938 37.397L357.24 38.139C357.035 38.6337 356.713 39.0537 356.274 39.399C355.845 39.7443 355.359 40.0057 354.818 40.183C354.286 40.3603 353.759 40.449 353.236 40.449C352.536 40.449 351.897 40.3043 351.318 40.015C350.739 39.7163 350.24 39.3243 349.82 38.839C349.4 38.3443 349.073 37.7937 348.84 37.187C348.607 36.571 348.49 35.9503 348.49 35.325ZM365.06 40.365H363.52V36.263C363.52 35.6003 363.399 35.1057 363.156 34.779C362.914 34.4523 362.573 34.289 362.134 34.289C361.864 34.289 361.584 34.3637 361.294 34.513C361.005 34.6623 360.748 34.8677 360.524 35.129C360.3 35.381 360.137 35.675 360.034 36.011V40.365H358.494V30.145H360.034V34.513C360.314 34.0183 360.697 33.631 361.182 33.351C361.668 33.0617 362.19 32.917 362.75 32.917C363.208 32.917 363.586 32.9963 363.884 33.155C364.183 33.3137 364.416 33.533 364.584 33.813C364.762 34.0837 364.883 34.401 364.948 34.765C365.023 35.1197 365.06 35.4977 365.06 35.899V40.365ZM370.138 40.505C369.559 40.505 369.041 40.407 368.584 40.211C368.126 40.0057 367.73 39.7257 367.394 39.371C367.067 39.0163 366.815 38.615 366.638 38.167C366.46 37.7097 366.372 37.2243 366.372 36.711C366.372 36.1977 366.46 35.7123 366.638 35.255C366.815 34.7977 367.067 34.3963 367.394 34.051C367.73 33.6963 368.126 33.421 368.584 33.225C369.05 33.0197 369.568 32.917 370.138 32.917C370.707 32.917 371.22 33.0197 371.678 33.225C372.144 33.421 372.541 33.6963 372.868 34.051C373.204 34.3963 373.46 34.7977 373.638 35.255C373.815 35.7123 373.904 36.1977 373.904 36.711C373.904 37.2243 373.815 37.7097 373.638 38.167C373.46 38.615 373.204 39.0163 372.868 39.371C372.541 39.7257 372.144 40.0057 371.678 40.211C371.22 40.407 370.707 40.505 370.138 40.505ZM367.954 36.725C367.954 37.1917 368.052 37.6117 368.248 37.985C368.444 38.3583 368.705 38.6523 369.032 38.867C369.358 39.0817 369.727 39.189 370.138 39.189C370.539 39.189 370.903 39.0817 371.23 38.867C371.566 38.643 371.832 38.3443 372.028 37.971C372.224 37.5883 372.322 37.1683 372.322 36.711C372.322 36.2443 372.224 35.8243 372.028 35.451C371.832 35.0777 371.566 34.7837 371.23 34.569C370.903 34.345 370.539 34.233 370.138 34.233C369.727 34.233 369.358 34.345 369.032 34.569C368.705 34.793 368.444 35.0917 368.248 35.465C368.052 35.829 367.954 36.249 367.954 36.725ZM378.56 40.505C377.981 40.505 377.463 40.407 377.006 40.211C376.548 40.0057 376.152 39.7257 375.816 39.371C375.489 39.0163 375.237 38.615 375.06 38.167C374.882 37.7097 374.794 37.2243 374.794 36.711C374.794 36.1977 374.882 35.7123 375.06 35.255C375.237 34.7977 375.489 34.3963 375.816 34.051C376.152 33.6963 376.548 33.421 377.006 33.225C377.472 33.0197 377.99 32.917 378.56 32.917C379.129 32.917 379.642 33.0197 380.1 33.225C380.566 33.421 380.963 33.6963 381.29 34.051C381.626 34.3963 381.882 34.7977 382.06 35.255C382.237 35.7123 382.326 36.1977 382.326 36.711C382.326 37.2243 382.237 37.7097 382.06 38.167C381.882 38.615 381.626 39.0163 381.29 39.371C380.963 39.7257 380.566 40.0057 380.1 40.211C379.642 40.407 379.129 40.505 378.56 40.505ZM376.376 36.725C376.376 37.1917 376.474 37.6117 376.67 37.985C376.866 38.3583 377.127 38.6523 377.454 38.867C377.78 39.0817 378.149 39.189 378.56 39.189C378.961 39.189 379.325 39.0817 379.652 38.867C379.988 38.643 380.254 38.3443 380.45 37.971C380.646 37.5883 380.744 37.1683 380.744 36.711C380.744 36.2443 380.646 35.8243 380.45 35.451C380.254 35.0777 379.988 34.7837 379.652 34.569C379.325 34.345 378.961 34.233 378.56 34.233C378.149 34.233 377.78 34.345 377.454 34.569C377.127 34.793 376.866 35.0917 376.67 35.465C376.474 35.829 376.376 36.249 376.376 36.725ZM386.296 40.505C385.68 40.505 385.096 40.407 384.546 40.211C383.995 40.0057 383.524 39.7023 383.132 39.301L383.706 38.265C384.126 38.6383 384.546 38.909 384.966 39.077C385.395 39.245 385.82 39.329 386.24 39.329C386.669 39.329 387.019 39.2497 387.29 39.091C387.56 38.923 387.696 38.6803 387.696 38.363C387.696 38.1297 387.626 37.957 387.486 37.845C387.346 37.733 387.14 37.635 386.87 37.551C386.608 37.467 386.291 37.3737 385.918 37.271C385.395 37.1123 384.956 36.949 384.602 36.781C384.247 36.6037 383.981 36.389 383.804 36.137C383.626 35.885 383.538 35.563 383.538 35.171C383.538 34.695 383.659 34.289 383.902 33.953C384.144 33.617 384.48 33.3603 384.91 33.183C385.348 33.0057 385.852 32.917 386.422 32.917C386.954 32.917 387.444 33.001 387.892 33.169C388.349 33.3277 388.75 33.5797 389.096 33.925L388.438 34.947C388.111 34.6483 387.775 34.429 387.43 34.289C387.094 34.149 386.73 34.079 386.338 34.079C386.114 34.079 385.899 34.107 385.694 34.163C385.488 34.2097 385.316 34.303 385.176 34.443C385.045 34.5737 384.98 34.7603 384.98 35.003C384.98 35.199 385.036 35.3577 385.148 35.479C385.26 35.6003 385.428 35.703 385.652 35.787C385.876 35.871 386.151 35.9643 386.478 36.067C387.047 36.235 387.532 36.403 387.934 36.571C388.335 36.7297 388.643 36.9397 388.858 37.201C389.082 37.453 389.194 37.803 389.194 38.251C389.194 38.9603 388.928 39.5157 388.396 39.917C387.873 40.309 387.173 40.505 386.296 40.505ZM393.887 40.505C393.317 40.505 392.799 40.407 392.333 40.211C391.875 40.0057 391.479 39.7303 391.143 39.385C390.807 39.0303 390.545 38.629 390.359 38.181C390.181 37.7237 390.093 37.2383 390.093 36.725C390.093 36.0343 390.251 35.4043 390.569 34.835C390.886 34.2563 391.329 33.7943 391.899 33.449C392.468 33.0943 393.135 32.917 393.901 32.917C394.666 32.917 395.324 33.0943 395.875 33.449C396.435 33.7943 396.869 34.2517 397.177 34.821C397.485 35.3903 397.639 36.0017 397.639 36.655C397.639 36.767 397.634 36.8743 397.625 36.977C397.615 37.0703 397.606 37.1497 397.597 37.215H391.731C391.759 37.6443 391.875 38.0223 392.081 38.349C392.295 38.6663 392.566 38.9183 392.893 39.105C393.219 39.2823 393.569 39.371 393.943 39.371C394.353 39.371 394.741 39.2683 395.105 39.063C395.478 38.8577 395.73 38.587 395.861 38.251L397.177 38.629C397.018 38.9837 396.775 39.3057 396.449 39.595C396.131 39.875 395.753 40.099 395.315 40.267C394.876 40.4257 394.4 40.505 393.887 40.505ZM391.689 36.193H396.113C396.085 35.773 395.963 35.4043 395.749 35.087C395.543 34.7603 395.277 34.5083 394.951 34.331C394.633 34.1443 394.279 34.051 393.887 34.051C393.504 34.051 393.149 34.1443 392.823 34.331C392.505 34.5083 392.244 34.7603 392.039 35.087C391.833 35.4043 391.717 35.773 391.689 36.193ZM406.428 39.987C406.297 40.0523 406.134 40.1223 405.938 40.197C405.742 40.2717 405.518 40.337 405.266 40.393C405.023 40.449 404.771 40.477 404.51 40.477C404.192 40.477 403.898 40.421 403.628 40.309C403.357 40.197 403.138 40.0197 402.97 39.777C402.811 39.525 402.732 39.203 402.732 38.811V34.233H401.766V33.043H402.732V30.635H404.272V33.043H405.868V34.233H404.272V38.321C404.29 38.573 404.37 38.7597 404.51 38.881C404.659 39.0023 404.841 39.063 405.056 39.063C405.27 39.063 405.476 39.0257 405.672 38.951C405.868 38.8763 406.012 38.8157 406.106 38.769L406.428 39.987ZM407.494 40.365V33.043H409.034V40.365H407.494ZM407.494 31.839V30.145H409.034V31.839H407.494ZM422.085 40.365H420.545V36.263C420.545 35.5817 420.433 35.0823 420.209 34.765C419.985 34.4477 419.658 34.289 419.229 34.289C418.8 34.289 418.398 34.4523 418.025 34.779C417.661 35.0963 417.404 35.5117 417.255 36.025V40.365H415.715V36.263C415.715 35.5817 415.603 35.0823 415.379 34.765C415.155 34.4477 414.833 34.289 414.413 34.289C413.984 34.289 413.582 34.4477 413.209 34.765C412.845 35.0823 412.584 35.4977 412.425 36.011V40.365H410.885V33.043H412.285V34.513C412.574 33.9997 412.952 33.6077 413.419 33.337C413.895 33.057 414.436 32.917 415.043 32.917C415.65 32.917 416.126 33.0757 416.471 33.393C416.826 33.7103 417.045 34.107 417.129 34.583C417.446 34.0417 417.834 33.631 418.291 33.351C418.758 33.0617 419.29 32.917 419.887 32.917C420.316 32.917 420.676 32.9963 420.965 33.155C421.254 33.3137 421.478 33.533 421.637 33.813C421.796 34.0837 421.908 34.401 421.973 34.765C422.048 35.1197 422.085 35.4977 422.085 35.899V40.365ZM427.178 40.505C426.608 40.505 426.09 40.407 425.624 40.211C425.166 40.0057 424.77 39.7303 424.434 39.385C424.098 39.0303 423.836 38.629 423.65 38.181C423.472 37.7237 423.384 37.2383 423.384 36.725C423.384 36.0343 423.542 35.4043 423.86 34.835C424.177 34.2563 424.62 33.7943 425.19 33.449C425.759 33.0943 426.426 32.917 427.192 32.917C427.957 32.917 428.615 33.0943 429.166 33.449C429.726 33.7943 430.16 34.2517 430.468 34.821C430.776 35.3903 430.93 36.0017 430.93 36.655C430.93 36.767 430.925 36.8743 430.916 36.977C430.906 37.0703 430.897 37.1497 430.888 37.215H425.022C425.05 37.6443 425.166 38.0223 425.372 38.349C425.586 38.6663 425.857 38.9183 426.184 39.105C426.51 39.2823 426.86 39.371 427.234 39.371C427.644 39.371 428.032 39.2683 428.396 39.063C428.769 38.8577 429.021 38.587 429.152 38.251L430.468 38.629C430.309 38.9837 430.066 39.3057 429.74 39.595C429.422 39.875 429.044 40.099 428.606 40.267C428.167 40.4257 427.691 40.505 427.178 40.505ZM424.98 36.193H429.404C429.376 35.773 429.254 35.4043 429.04 35.087C428.834 34.7603 428.568 34.5083 428.242 34.331C427.924 34.1443 427.57 34.051 427.178 34.051C426.795 34.051 426.44 34.1443 426.114 34.331C425.796 34.5083 425.535 34.7603 425.33 35.087C425.124 35.4043 425.008 35.773 424.98 36.193Z"
                fill={controlTypoSystem}
            />
            <path
                d="M82.938 105.979V107.365H76.12V97.425H82.812V98.811H77.688V101.639H82.126V102.941H77.688V105.979H82.938ZM90.8709 107.365H89.3309V103.263C89.3309 102.582 89.2189 102.082 88.9949 101.765C88.7802 101.448 88.4582 101.289 88.0289 101.289C87.7302 101.289 87.4315 101.364 87.1329 101.513C86.8435 101.662 86.5822 101.868 86.3489 102.129C86.1155 102.381 85.9475 102.675 85.8449 103.011V107.365H84.3049V100.043H85.7049V101.513C85.8915 101.186 86.1342 100.906 86.4329 100.673C86.7409 100.43 87.0862 100.244 87.4689 100.113C87.8515 99.9823 88.2575 99.917 88.6869 99.917C89.1255 99.917 89.4849 99.9963 89.7649 100.155C90.0542 100.314 90.2782 100.533 90.4369 100.813C90.6049 101.084 90.7169 101.401 90.7729 101.765C90.8382 102.12 90.8709 102.498 90.8709 102.899V107.365ZM92.1964 103.711C92.1964 103.011 92.3364 102.376 92.6164 101.807C92.9057 101.228 93.2977 100.771 93.7924 100.435C94.287 100.09 94.8564 99.917 95.5004 99.917C96.0604 99.917 96.5644 100.062 97.0124 100.351C97.4697 100.64 97.8244 101 98.0764 101.429V97.145H99.6164V105.629C99.6164 105.806 99.649 105.932 99.7144 106.007C99.7797 106.082 99.887 106.124 100.036 106.133V107.365C99.747 107.412 99.523 107.435 99.3644 107.435C99.075 107.435 98.8277 107.351 98.6224 107.183C98.4264 107.015 98.3237 106.814 98.3144 106.581L98.3004 106.035C98.0204 106.502 97.6424 106.866 97.1664 107.127C96.6904 107.379 96.1957 107.505 95.6824 107.505C95.1784 107.505 94.7117 107.407 94.2824 107.211C93.8624 107.015 93.4937 106.74 93.1764 106.385C92.8684 106.03 92.6257 105.624 92.4484 105.167C92.2804 104.71 92.1964 104.224 92.1964 103.711ZM98.0764 104.733V102.815C97.9737 102.516 97.8057 102.25 97.5724 102.017C97.3484 101.774 97.0917 101.583 96.8024 101.443C96.5224 101.303 96.2424 101.233 95.9624 101.233C95.6357 101.233 95.337 101.303 95.0664 101.443C94.805 101.583 94.5764 101.77 94.3804 102.003C94.1937 102.236 94.049 102.502 93.9464 102.801C93.8437 103.1 93.7924 103.412 93.7924 103.739C93.7924 104.075 93.8484 104.392 93.9604 104.691C94.0724 104.98 94.231 105.242 94.4364 105.475C94.651 105.699 94.8937 105.876 95.1644 106.007C95.4444 106.128 95.7477 106.189 96.0744 106.189C96.2797 106.189 96.485 106.152 96.6904 106.077C96.905 106.002 97.1057 105.9 97.2924 105.769C97.4884 105.638 97.6517 105.484 97.7824 105.307C97.9224 105.13 98.0204 104.938 98.0764 104.733ZM107.635 107.505C107.019 107.505 106.436 107.407 105.885 107.211C105.335 107.006 104.863 106.702 104.471 106.301L105.045 105.265C105.465 105.638 105.885 105.909 106.305 106.077C106.735 106.245 107.159 106.329 107.579 106.329C108.009 106.329 108.359 106.25 108.629 106.091C108.9 105.923 109.035 105.68 109.035 105.363C109.035 105.13 108.965 104.957 108.825 104.845C108.685 104.733 108.48 104.635 108.209 104.551C107.948 104.467 107.631 104.374 107.257 104.271C106.735 104.112 106.296 103.949 105.941 103.781C105.587 103.604 105.321 103.389 105.143 103.137C104.966 102.885 104.877 102.563 104.877 102.171C104.877 101.695 104.999 101.289 105.241 100.953C105.484 100.617 105.82 100.36 106.249 100.183C106.688 100.006 107.192 99.917 107.761 99.917C108.293 99.917 108.783 100.001 109.231 100.169C109.689 100.328 110.09 100.58 110.435 100.925L109.777 101.947C109.451 101.648 109.115 101.429 108.769 101.289C108.433 101.149 108.069 101.079 107.677 101.079C107.453 101.079 107.239 101.107 107.033 101.163C106.828 101.21 106.655 101.303 106.515 101.443C106.385 101.574 106.319 101.76 106.319 102.003C106.319 102.199 106.375 102.358 106.487 102.479C106.599 102.6 106.767 102.703 106.991 102.787C107.215 102.871 107.491 102.964 107.817 103.067C108.387 103.235 108.872 103.403 109.273 103.571C109.675 103.73 109.983 103.94 110.197 104.201C110.421 104.453 110.533 104.803 110.533 105.251C110.533 105.96 110.267 106.516 109.735 106.917C109.213 107.309 108.513 107.505 107.635 107.505ZM115.226 107.505C114.657 107.505 114.139 107.407 113.672 107.211C113.215 107.006 112.818 106.73 112.482 106.385C112.146 106.03 111.885 105.629 111.698 105.181C111.521 104.724 111.432 104.238 111.432 103.725C111.432 103.034 111.591 102.404 111.908 101.835C112.226 101.256 112.669 100.794 113.238 100.449C113.808 100.094 114.475 99.917 115.24 99.917C116.006 99.917 116.664 100.094 117.214 100.449C117.774 100.794 118.208 101.252 118.516 101.821C118.824 102.39 118.978 103.002 118.978 103.655C118.978 103.767 118.974 103.874 118.964 103.977C118.955 104.07 118.946 104.15 118.936 104.215H113.07C113.098 104.644 113.215 105.022 113.42 105.349C113.635 105.666 113.906 105.918 114.232 106.105C114.559 106.282 114.909 106.371 115.282 106.371C115.693 106.371 116.08 106.268 116.444 106.063C116.818 105.858 117.07 105.587 117.2 105.251L118.516 105.629C118.358 105.984 118.115 106.306 117.788 106.595C117.471 106.875 117.093 107.099 116.654 107.267C116.216 107.426 115.74 107.505 115.226 107.505ZM113.028 103.193H117.452C117.424 102.773 117.303 102.404 117.088 102.087C116.883 101.76 116.617 101.508 116.29 101.331C115.973 101.144 115.618 101.051 115.226 101.051C114.844 101.051 114.489 101.144 114.162 101.331C113.845 101.508 113.584 101.76 113.378 102.087C113.173 102.404 113.056 102.773 113.028 103.193ZM122.839 107.505C122.223 107.505 121.639 107.407 121.089 107.211C120.538 107.006 120.067 106.702 119.675 106.301L120.249 105.265C120.669 105.638 121.089 105.909 121.509 106.077C121.938 106.245 122.363 106.329 122.783 106.329C123.212 106.329 123.562 106.25 123.833 106.091C124.103 105.923 124.239 105.68 124.239 105.363C124.239 105.13 124.169 104.957 124.029 104.845C123.889 104.733 123.683 104.635 123.413 104.551C123.151 104.467 122.834 104.374 122.461 104.271C121.938 104.112 121.499 103.949 121.145 103.781C120.79 103.604 120.524 103.389 120.347 103.137C120.169 102.885 120.081 102.563 120.081 102.171C120.081 101.695 120.202 101.289 120.445 100.953C120.687 100.617 121.023 100.36 121.453 100.183C121.891 100.006 122.395 99.917 122.965 99.917C123.497 99.917 123.987 100.001 124.435 100.169C124.892 100.328 125.293 100.58 125.639 100.925L124.981 101.947C124.654 101.648 124.318 101.429 123.973 101.289C123.637 101.149 123.273 101.079 122.881 101.079C122.657 101.079 122.442 101.107 122.237 101.163C122.031 101.21 121.859 101.303 121.719 101.443C121.588 101.574 121.523 101.76 121.523 102.003C121.523 102.199 121.579 102.358 121.691 102.479C121.803 102.6 121.971 102.703 122.195 102.787C122.419 102.871 122.694 102.964 123.021 103.067C123.59 103.235 124.075 103.403 124.477 103.571C124.878 103.73 125.186 103.94 125.401 104.201C125.625 104.453 125.737 104.803 125.737 105.251C125.737 105.96 125.471 106.516 124.939 106.917C124.416 107.309 123.716 107.505 122.839 107.505ZM129.716 107.505C129.1 107.505 128.516 107.407 127.966 107.211C127.415 107.006 126.944 106.702 126.552 106.301L127.126 105.265C127.546 105.638 127.966 105.909 128.386 106.077C128.815 106.245 129.24 106.329 129.66 106.329C130.089 106.329 130.439 106.25 130.71 106.091C130.98 105.923 131.116 105.68 131.116 105.363C131.116 105.13 131.046 104.957 130.906 104.845C130.766 104.733 130.56 104.635 130.29 104.551C130.028 104.467 129.711 104.374 129.338 104.271C128.815 104.112 128.376 103.949 128.022 103.781C127.667 103.604 127.401 103.389 127.224 103.137C127.046 102.885 126.958 102.563 126.958 102.171C126.958 101.695 127.079 101.289 127.322 100.953C127.564 100.617 127.9 100.36 128.33 100.183C128.768 100.006 129.272 99.917 129.842 99.917C130.374 99.917 130.864 100.001 131.312 100.169C131.769 100.328 132.17 100.58 132.516 100.925L131.858 101.947C131.531 101.648 131.195 101.429 130.85 101.289C130.514 101.149 130.15 101.079 129.758 101.079C129.534 101.079 129.319 101.107 129.114 101.163C128.908 101.21 128.736 101.303 128.596 101.443C128.465 101.574 128.4 101.76 128.4 102.003C128.4 102.199 128.456 102.358 128.568 102.479C128.68 102.6 128.848 102.703 129.072 102.787C129.296 102.871 129.571 102.964 129.898 103.067C130.467 103.235 130.952 103.403 131.354 103.571C131.755 103.73 132.063 103.94 132.278 104.201C132.502 104.453 132.614 104.803 132.614 105.251C132.614 105.96 132.348 106.516 131.816 106.917C131.293 107.309 130.593 107.505 129.716 107.505ZM133.988 107.365V100.043H135.528V107.365H133.988ZM133.988 98.839V97.145H135.528V98.839H133.988ZM140.669 107.505C140.09 107.505 139.572 107.407 139.115 107.211C138.658 107.006 138.261 106.726 137.925 106.371C137.598 106.016 137.346 105.615 137.169 105.167C136.992 104.71 136.903 104.224 136.903 103.711C136.903 103.198 136.992 102.712 137.169 102.255C137.346 101.798 137.598 101.396 137.925 101.051C138.261 100.696 138.658 100.421 139.115 100.225C139.582 100.02 140.1 99.917 140.669 99.917C141.238 99.917 141.752 100.02 142.209 100.225C142.676 100.421 143.072 100.696 143.399 101.051C143.735 101.396 143.992 101.798 144.169 102.255C144.346 102.712 144.435 103.198 144.435 103.711C144.435 104.224 144.346 104.71 144.169 105.167C143.992 105.615 143.735 106.016 143.399 106.371C143.072 106.726 142.676 107.006 142.209 107.211C141.752 107.407 141.238 107.505 140.669 107.505ZM138.485 103.725C138.485 104.192 138.583 104.612 138.779 104.985C138.975 105.358 139.236 105.652 139.563 105.867C139.89 106.082 140.258 106.189 140.669 106.189C141.07 106.189 141.434 106.082 141.761 105.867C142.097 105.643 142.363 105.344 142.559 104.971C142.755 104.588 142.853 104.168 142.853 103.711C142.853 103.244 142.755 102.824 142.559 102.451C142.363 102.078 142.097 101.784 141.761 101.569C141.434 101.345 141.07 101.233 140.669 101.233C140.258 101.233 139.89 101.345 139.563 101.569C139.236 101.793 138.975 102.092 138.779 102.465C138.583 102.829 138.485 103.249 138.485 103.725ZM152.367 107.365H150.827V103.263C150.827 102.582 150.715 102.082 150.491 101.765C150.276 101.448 149.954 101.289 149.525 101.289C149.226 101.289 148.928 101.364 148.629 101.513C148.34 101.662 148.078 101.868 147.845 102.129C147.612 102.381 147.444 102.675 147.341 103.011V107.365H145.801V100.043H147.201V101.513C147.388 101.186 147.63 100.906 147.929 100.673C148.237 100.43 148.582 100.244 148.965 100.113C149.348 99.9823 149.754 99.917 150.183 99.917C150.622 99.917 150.981 99.9963 151.261 100.155C151.55 100.314 151.774 100.533 151.933 100.813C152.101 101.084 152.213 101.401 152.269 101.765C152.334 102.12 152.367 102.498 152.367 102.899V107.365Z"
                fill={controlTypoSystem}
            />
            <path
                d="M309.12 107.365V97.425H313.446C313.894 97.425 314.305 97.5183 314.678 97.705C315.051 97.8917 315.373 98.139 315.644 98.447C315.924 98.755 316.139 99.1003 316.288 99.483C316.447 99.8657 316.526 100.258 316.526 100.659C316.526 101.098 316.447 101.518 316.288 101.919C316.129 102.32 315.901 102.666 315.602 102.955C315.313 103.244 314.972 103.454 314.58 103.585L316.918 107.365H315.154L312.998 103.907H310.688V107.365H309.12ZM310.688 102.521H313.432C313.721 102.521 313.978 102.437 314.202 102.269C314.426 102.101 314.603 101.877 314.734 101.597C314.865 101.308 314.93 100.995 314.93 100.659C314.93 100.314 314.855 100.006 314.706 99.735C314.557 99.455 314.361 99.231 314.118 99.063C313.885 98.895 313.628 98.811 313.348 98.811H310.688V102.521ZM321.265 107.505C320.696 107.505 320.178 107.407 319.711 107.211C319.254 107.006 318.857 106.73 318.521 106.385C318.185 106.03 317.924 105.629 317.737 105.181C317.56 104.724 317.471 104.238 317.471 103.725C317.471 103.034 317.63 102.404 317.947 101.835C318.265 101.256 318.708 100.794 319.277 100.449C319.847 100.094 320.514 99.917 321.279 99.917C322.045 99.917 322.703 100.094 323.253 100.449C323.813 100.794 324.247 101.252 324.555 101.821C324.863 102.39 325.017 103.002 325.017 103.655C325.017 103.767 325.013 103.874 325.003 103.977C324.994 104.07 324.985 104.15 324.975 104.215H319.109C319.137 104.644 319.254 105.022 319.459 105.349C319.674 105.666 319.945 105.918 320.271 106.105C320.598 106.282 320.948 106.371 321.321 106.371C321.732 106.371 322.119 106.268 322.483 106.063C322.857 105.858 323.109 105.587 323.239 105.251L324.555 105.629C324.397 105.984 324.154 106.306 323.827 106.595C323.51 106.875 323.132 107.099 322.693 107.267C322.255 107.426 321.779 107.505 321.265 107.505ZM319.067 103.193H323.491C323.463 102.773 323.342 102.404 323.127 102.087C322.922 101.76 322.656 101.508 322.329 101.331C322.012 101.144 321.657 101.051 321.265 101.051C320.883 101.051 320.528 101.144 320.201 101.331C319.884 101.508 319.623 101.76 319.417 102.087C319.212 102.404 319.095 102.773 319.067 103.193ZM325.812 103.711C325.812 103.011 325.952 102.376 326.232 101.807C326.521 101.228 326.913 100.771 327.408 100.435C327.902 100.09 328.472 99.917 329.116 99.917C329.676 99.917 330.18 100.062 330.628 100.351C331.085 100.64 331.44 101 331.692 101.429V97.145H333.232V105.629C333.232 105.806 333.264 105.932 333.33 106.007C333.395 106.082 333.502 106.124 333.652 106.133V107.365C333.362 107.412 333.138 107.435 332.98 107.435C332.69 107.435 332.443 107.351 332.238 107.183C332.042 107.015 331.939 106.814 331.93 106.581L331.916 106.035C331.636 106.502 331.258 106.866 330.782 107.127C330.306 107.379 329.811 107.505 329.298 107.505C328.794 107.505 328.327 107.407 327.898 107.211C327.478 107.015 327.109 106.74 326.792 106.385C326.484 106.03 326.241 105.624 326.064 105.167C325.896 104.71 325.812 104.224 325.812 103.711ZM331.692 104.733V102.815C331.589 102.516 331.421 102.25 331.188 102.017C330.964 101.774 330.707 101.583 330.418 101.443C330.138 101.303 329.858 101.233 329.578 101.233C329.251 101.233 328.952 101.303 328.682 101.443C328.42 101.583 328.192 101.77 327.996 102.003C327.809 102.236 327.664 102.502 327.562 102.801C327.459 103.1 327.408 103.412 327.408 103.739C327.408 104.075 327.464 104.392 327.576 104.691C327.688 104.98 327.846 105.242 328.052 105.475C328.266 105.699 328.509 105.876 328.78 106.007C329.06 106.128 329.363 106.189 329.69 106.189C329.895 106.189 330.1 106.152 330.306 106.077C330.52 106.002 330.721 105.9 330.908 105.769C331.104 105.638 331.267 105.484 331.398 105.307C331.538 105.13 331.636 104.938 331.692 104.733ZM335.188 107.365V100.043H336.728V107.365H335.188ZM335.188 98.839V97.145H336.728V98.839H335.188ZM342.694 101.373C342.097 101.382 341.565 101.518 341.098 101.779C340.641 102.04 340.314 102.409 340.118 102.885V107.365H338.578V100.043H340.006V101.681C340.258 101.177 340.59 100.776 341 100.477C341.411 100.169 341.845 100.001 342.302 99.973C342.396 99.973 342.47 99.973 342.526 99.973C342.592 99.973 342.648 99.9777 342.694 99.987V101.373ZM346.996 107.505C346.427 107.505 345.909 107.407 345.442 107.211C344.985 107.006 344.588 106.73 344.252 106.385C343.916 106.03 343.655 105.629 343.468 105.181C343.291 104.724 343.202 104.238 343.202 103.725C343.202 103.034 343.361 102.404 343.678 101.835C343.995 101.256 344.439 100.794 345.008 100.449C345.577 100.094 346.245 99.917 347.01 99.917C347.775 99.917 348.433 100.094 348.984 100.449C349.544 100.794 349.978 101.252 350.286 101.821C350.594 102.39 350.748 103.002 350.748 103.655C350.748 103.767 350.743 103.874 350.734 103.977C350.725 104.07 350.715 104.15 350.706 104.215H344.84C344.868 104.644 344.985 105.022 345.19 105.349C345.405 105.666 345.675 105.918 346.002 106.105C346.329 106.282 346.679 106.371 347.052 106.371C347.463 106.371 347.85 106.268 348.214 106.063C348.587 105.858 348.839 105.587 348.97 105.251L350.286 105.629C350.127 105.984 349.885 106.306 349.558 106.595C349.241 106.875 348.863 107.099 348.424 107.267C347.985 107.426 347.509 107.505 346.996 107.505ZM344.798 103.193H349.222C349.194 102.773 349.073 102.404 348.858 102.087C348.653 101.76 348.387 101.508 348.06 101.331C347.743 101.144 347.388 101.051 346.996 101.051C346.613 101.051 346.259 101.144 345.932 101.331C345.615 101.508 345.353 101.76 345.148 102.087C344.943 102.404 344.826 102.773 344.798 103.193ZM355.322 107.505C354.753 107.505 354.235 107.407 353.768 107.211C353.311 107.006 352.914 106.726 352.578 106.371C352.242 106.016 351.981 105.61 351.794 105.153C351.617 104.696 351.528 104.21 351.528 103.697C351.528 103.006 351.682 102.376 351.99 101.807C352.307 101.238 352.746 100.78 353.306 100.435C353.875 100.09 354.547 99.917 355.322 99.917C356.069 99.917 356.717 100.085 357.268 100.421C357.828 100.748 358.239 101.186 358.5 101.737L357.002 102.213C356.834 101.905 356.596 101.667 356.288 101.499C355.989 101.322 355.658 101.233 355.294 101.233C354.883 101.233 354.51 101.34 354.174 101.555C353.847 101.76 353.586 102.05 353.39 102.423C353.203 102.787 353.11 103.212 353.11 103.697C353.11 104.164 353.208 104.588 353.404 104.971C353.6 105.344 353.861 105.643 354.188 105.867C354.524 106.082 354.897 106.189 355.308 106.189C355.56 106.189 355.803 106.147 356.036 106.063C356.279 105.97 356.489 105.848 356.666 105.699C356.843 105.54 356.969 105.368 357.044 105.181L358.556 105.629C358.397 105.993 358.159 106.315 357.842 106.595C357.534 106.875 357.165 107.099 356.736 107.267C356.316 107.426 355.845 107.505 355.322 107.505ZM363.898 106.987C363.768 107.052 363.604 107.122 363.408 107.197C363.212 107.272 362.988 107.337 362.736 107.393C362.494 107.449 362.242 107.477 361.98 107.477C361.663 107.477 361.369 107.421 361.098 107.309C360.828 107.197 360.608 107.02 360.44 106.777C360.282 106.525 360.202 106.203 360.202 105.811V101.233H359.236V100.043H360.202V97.635H361.742V100.043H363.338V101.233H361.742V105.321C361.761 105.573 361.84 105.76 361.98 105.881C362.13 106.002 362.312 106.063 362.526 106.063C362.741 106.063 362.946 106.026 363.142 105.951C363.338 105.876 363.483 105.816 363.576 105.769L363.898 106.987ZM372.498 106.987C372.367 107.052 372.204 107.122 372.008 107.197C371.812 107.272 371.588 107.337 371.336 107.393C371.093 107.449 370.841 107.477 370.58 107.477C370.263 107.477 369.969 107.421 369.698 107.309C369.427 107.197 369.208 107.02 369.04 106.777C368.881 106.525 368.802 106.203 368.802 105.811V101.233H367.836V100.043H368.802V97.635H370.342V100.043H371.938V101.233H370.342V105.321C370.361 105.573 370.44 105.76 370.58 105.881C370.729 106.002 370.911 106.063 371.126 106.063C371.341 106.063 371.546 106.026 371.742 105.951C371.938 105.876 372.083 105.816 372.176 105.769L372.498 106.987ZM373.565 107.365V100.043H375.105V107.365H373.565ZM373.565 98.839V97.145H375.105V98.839H373.565ZM380.273 107.505C379.704 107.505 379.186 107.407 378.719 107.211C378.262 107.006 377.865 106.726 377.529 106.371C377.193 106.016 376.932 105.61 376.745 105.153C376.568 104.696 376.479 104.21 376.479 103.697C376.479 103.006 376.633 102.376 376.941 101.807C377.259 101.238 377.697 100.78 378.257 100.435C378.827 100.09 379.499 99.917 380.273 99.917C381.02 99.917 381.669 100.085 382.219 100.421C382.779 100.748 383.19 101.186 383.451 101.737L381.953 102.213C381.785 101.905 381.547 101.667 381.239 101.499C380.941 101.322 380.609 101.233 380.245 101.233C379.835 101.233 379.461 101.34 379.125 101.555C378.799 101.76 378.537 102.05 378.341 102.423C378.155 102.787 378.061 103.212 378.061 103.697C378.061 104.164 378.159 104.588 378.355 104.971C378.551 105.344 378.813 105.643 379.139 105.867C379.475 106.082 379.849 106.189 380.259 106.189C380.511 106.189 380.754 106.147 380.987 106.063C381.23 105.97 381.44 105.848 381.617 105.699C381.795 105.54 381.921 105.368 381.995 105.181L383.507 105.629C383.349 105.993 383.111 106.315 382.793 106.595C382.485 106.875 382.117 107.099 381.687 107.267C381.267 107.426 380.796 107.505 380.273 107.505ZM389.872 107.365L387.52 103.991L386.316 105.139V107.365H384.776V97.145H386.316V103.585L389.704 100.057H391.356L388.514 103.123L391.51 107.365H389.872ZM395.381 107.505C394.811 107.505 394.293 107.407 393.827 107.211C393.369 107.006 392.973 106.73 392.637 106.385C392.301 106.03 392.039 105.629 391.853 105.181C391.675 104.724 391.587 104.238 391.587 103.725C391.587 103.034 391.745 102.404 392.063 101.835C392.38 101.256 392.823 100.794 393.393 100.449C393.962 100.094 394.629 99.917 395.395 99.917C396.16 99.917 396.818 100.094 397.369 100.449C397.929 100.794 398.363 101.252 398.671 101.821C398.979 102.39 399.133 103.002 399.133 103.655C399.133 103.767 399.128 103.874 399.119 103.977C399.109 104.07 399.1 104.15 399.091 104.215H393.225C393.253 104.644 393.369 105.022 393.575 105.349C393.789 105.666 394.06 105.918 394.387 106.105C394.713 106.282 395.063 106.371 395.437 106.371C395.847 106.371 396.235 106.268 396.599 106.063C396.972 105.858 397.224 105.587 397.355 105.251L398.671 105.629C398.512 105.984 398.269 106.306 397.943 106.595C397.625 106.875 397.247 107.099 396.809 107.267C396.37 107.426 395.894 107.505 395.381 107.505ZM393.183 103.193H397.607C397.579 102.773 397.457 102.404 397.243 102.087C397.037 101.76 396.771 101.508 396.445 101.331C396.127 101.144 395.773 101.051 395.381 101.051C394.998 101.051 394.643 101.144 394.317 101.331C393.999 101.508 393.738 101.76 393.533 102.087C393.327 102.404 393.211 102.773 393.183 103.193ZM404.394 106.987C404.264 107.052 404.1 107.122 403.904 107.197C403.708 107.272 403.484 107.337 403.232 107.393C402.99 107.449 402.738 107.477 402.476 107.477C402.159 107.477 401.865 107.421 401.594 107.309C401.324 107.197 401.104 107.02 400.936 106.777C400.778 106.525 400.698 106.203 400.698 105.811V101.233H399.732V100.043H400.698V97.635H402.238V100.043H403.834V101.233H402.238V105.321C402.257 105.573 402.336 105.76 402.476 105.881C402.626 106.002 402.808 106.063 403.022 106.063C403.237 106.063 403.442 106.026 403.638 105.951C403.834 105.876 403.979 105.816 404.072 105.769L404.394 106.987Z"
                fill={controlTypoSystem}
            />
        </svg>
    )
}

export default BaseImage
