var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a3, b3) => {
  for (var prop in b3 || (b3 = {}))
    if (__hasOwnProp.call(b3, prop))
      __defNormalProp(a3, prop, b3[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b3)) {
      if (__propIsEnum.call(b3, prop))
        __defNormalProp(a3, prop, b3[prop]);
    }
  return a3;
};
var __spreadProps = (a3, b3) => __defProps(a3, __getOwnPropDescs(b3));
var __objRest = (source2, exclude) => {
  var target = {};
  for (var prop in source2)
    if (__hasOwnProp.call(source2, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source2[prop];
  if (source2 != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source2)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source2, prop))
        target[prop] = source2[prop];
    }
  return target;
};
import * as React$4 from "react";
import React__default, { useEffect, useState as useState$1, useRef, forwardRef as forwardRef$3, useCallback as useCallback$1, useContext as useContext$1, useMemo as useMemo$3, isValidElement, createContext, useReducer, Component, useLayoutEffect as useLayoutEffect$6, memo, PureComponent, cloneElement as cloneElement$1, useImperativeHandle, createElement } from "react";
import * as ReactDOM from "react-dom";
import ReactDOM__default, { unstable_batchedUpdates, createPortal } from "react-dom";
let updateQueue = makeQueue();
const raf$2 = (fn3) => schedule(fn3, updateQueue);
let writeQueue = makeQueue();
raf$2.write = (fn3) => schedule(fn3, writeQueue);
let onStartQueue = makeQueue();
raf$2.onStart = (fn3) => schedule(fn3, onStartQueue);
let onFrameQueue = makeQueue();
raf$2.onFrame = (fn3) => schedule(fn3, onFrameQueue);
let onFinishQueue = makeQueue();
raf$2.onFinish = (fn3) => schedule(fn3, onFinishQueue);
let timeouts = [];
raf$2.setTimeout = (handler, ms) => {
  let time = raf$2.now() + ms;
  let cancel = () => {
    let i2 = timeouts.findIndex((t3) => t3.cancel == cancel);
    if (~i2)
      timeouts.splice(i2, 1);
    pendingCount -= ~i2 ? 1 : 0;
  };
  let timeout = {
    time,
    handler,
    cancel
  };
  timeouts.splice(findTimeout(time), 0, timeout);
  pendingCount += 1;
  start$1();
  return timeout;
};
let findTimeout = (time) => ~(~timeouts.findIndex((t3) => t3.time > time) || ~timeouts.length);
raf$2.cancel = (fn3) => {
  onStartQueue.delete(fn3);
  onFrameQueue.delete(fn3);
  updateQueue.delete(fn3);
  writeQueue.delete(fn3);
  onFinishQueue.delete(fn3);
};
raf$2.sync = (fn3) => {
  sync = true;
  raf$2.batchedUpdates(fn3);
  sync = false;
};
raf$2.throttle = (fn3) => {
  let lastArgs;
  function queuedFn() {
    try {
      fn3(...lastArgs);
    } finally {
      lastArgs = null;
    }
  }
  function throttled(...args) {
    lastArgs = args;
    raf$2.onStart(queuedFn);
  }
  throttled.handler = fn3;
  throttled.cancel = () => {
    onStartQueue.delete(queuedFn);
    lastArgs = null;
  };
  return throttled;
};
let nativeRaf = typeof window != "undefined" ? window.requestAnimationFrame : () => {
};
raf$2.use = (impl) => nativeRaf = impl;
raf$2.now = typeof performance != "undefined" ? () => performance.now() : Date.now;
raf$2.batchedUpdates = (fn3) => fn3();
raf$2.catch = console.error;
raf$2.frameLoop = "always";
raf$2.advance = () => {
  if (raf$2.frameLoop !== "demand") {
    console.warn("Cannot call the manual advancement of rafz whilst frameLoop is not set as demand");
  } else {
    update$1();
  }
};
let ts = -1;
let pendingCount = 0;
let sync = false;
function schedule(fn3, queue) {
  if (sync) {
    queue.delete(fn3);
    fn3(0);
  } else {
    queue.add(fn3);
    start$1();
  }
}
function start$1() {
  if (ts < 0) {
    ts = 0;
    if (raf$2.frameLoop !== "demand") {
      nativeRaf(loop$1);
    }
  }
}
function stop() {
  ts = -1;
}
function loop$1() {
  if (~ts) {
    nativeRaf(loop$1);
    raf$2.batchedUpdates(update$1);
  }
}
function update$1() {
  let prevTs = ts;
  ts = raf$2.now();
  let count2 = findTimeout(ts);
  if (count2) {
    eachSafely(timeouts.splice(0, count2), (t3) => t3.handler());
    pendingCount -= count2;
  }
  onStartQueue.flush();
  updateQueue.flush(prevTs ? Math.min(64, ts - prevTs) : 16.667);
  onFrameQueue.flush();
  writeQueue.flush();
  onFinishQueue.flush();
  if (!pendingCount) {
    stop();
  }
}
function makeQueue() {
  let next = /* @__PURE__ */ new Set();
  let current = next;
  return {
    add(fn3) {
      pendingCount += current == next && !next.has(fn3) ? 1 : 0;
      next.add(fn3);
    },
    delete(fn3) {
      pendingCount -= current == next && next.has(fn3) ? 1 : 0;
      return next.delete(fn3);
    },
    flush(arg) {
      if (current.size) {
        next = /* @__PURE__ */ new Set();
        pendingCount -= current.size;
        eachSafely(current, (fn3) => fn3(arg) && next.add(fn3));
        pendingCount += next.size;
        current = next;
      }
    }
  };
}
function eachSafely(values2, each2) {
  values2.forEach((value) => {
    try {
      each2(value);
    } catch (e3) {
      raf$2.catch(e3);
    }
  });
}
function noop$8() {
}
const defineHidden = (obj, key, value) => Object.defineProperty(obj, key, {
  value,
  writable: true,
  configurable: true
});
const is$1 = {
  arr: Array.isArray,
  obj: (a3) => !!a3 && a3.constructor.name === "Object",
  fun: (a3) => typeof a3 === "function",
  str: (a3) => typeof a3 === "string",
  num: (a3) => typeof a3 === "number",
  und: (a3) => a3 === void 0
};
function isEqual$7(a3, b3) {
  if (is$1.arr(a3)) {
    if (!is$1.arr(b3) || a3.length !== b3.length)
      return false;
    for (let i2 = 0; i2 < a3.length; i2++) {
      if (a3[i2] !== b3[i2])
        return false;
    }
    return true;
  }
  return a3 === b3;
}
const each$1 = (obj, fn3) => obj.forEach(fn3);
function eachProp(obj, fn3, ctx2) {
  if (is$1.arr(obj)) {
    for (let i2 = 0; i2 < obj.length; i2++) {
      fn3.call(ctx2, obj[i2], `${i2}`);
    }
    return;
  }
  for (const key in obj) {
    if (obj.hasOwnProperty(key)) {
      fn3.call(ctx2, obj[key], key);
    }
  }
}
const toArray$8 = (a3) => is$1.und(a3) ? [] : is$1.arr(a3) ? a3 : [a3];
function flush$1(queue, iterator) {
  if (queue.size) {
    const items2 = Array.from(queue);
    queue.clear();
    each$1(items2, iterator);
  }
}
const flushCalls = (queue, ...args) => flush$1(queue, (fn3) => fn3(...args));
const isSSR = () => typeof window === "undefined" || !window.navigator || /ServerSideRendering|^Deno\//.test(window.navigator.userAgent);
let createStringInterpolator$1;
let to;
let colors$1 = null;
let skipAnimation = false;
let willAdvance = noop$8;
const assign$3 = (globals2) => {
  if (globals2.to)
    to = globals2.to;
  if (globals2.now)
    raf$2.now = globals2.now;
  if (globals2.colors !== void 0)
    colors$1 = globals2.colors;
  if (globals2.skipAnimation != null)
    skipAnimation = globals2.skipAnimation;
  if (globals2.createStringInterpolator)
    createStringInterpolator$1 = globals2.createStringInterpolator;
  if (globals2.requestAnimationFrame)
    raf$2.use(globals2.requestAnimationFrame);
  if (globals2.batchedUpdates)
    raf$2.batchedUpdates = globals2.batchedUpdates;
  if (globals2.willAdvance)
    willAdvance = globals2.willAdvance;
  if (globals2.frameLoop)
    raf$2.frameLoop = globals2.frameLoop;
};
var globals = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  get createStringInterpolator() {
    return createStringInterpolator$1;
  },
  get to() {
    return to;
  },
  get colors() {
    return colors$1;
  },
  get skipAnimation() {
    return skipAnimation;
  },
  get willAdvance() {
    return willAdvance;
  },
  assign: assign$3
});
const startQueue = /* @__PURE__ */ new Set();
let currentFrame = [];
let prevFrame = [];
let priority = 0;
const frameLoop = {
  get idle() {
    return !startQueue.size && !currentFrame.length;
  },
  start(animation) {
    if (priority > animation.priority) {
      startQueue.add(animation);
      raf$2.onStart(flushStartQueue);
    } else {
      startSafely(animation);
      raf$2(advance);
    }
  },
  advance,
  sort(animation) {
    if (priority) {
      raf$2.onFrame(() => frameLoop.sort(animation));
    } else {
      const prevIndex = currentFrame.indexOf(animation);
      if (~prevIndex) {
        currentFrame.splice(prevIndex, 1);
        startUnsafely(animation);
      }
    }
  },
  clear() {
    currentFrame = [];
    startQueue.clear();
  }
};
function flushStartQueue() {
  startQueue.forEach(startSafely);
  startQueue.clear();
  raf$2(advance);
}
function startSafely(animation) {
  if (!currentFrame.includes(animation))
    startUnsafely(animation);
}
function startUnsafely(animation) {
  currentFrame.splice(findIndex$3(currentFrame, (other) => other.priority > animation.priority), 0, animation);
}
function advance(dt) {
  const nextFrame = prevFrame;
  for (let i2 = 0; i2 < currentFrame.length; i2++) {
    const animation = currentFrame[i2];
    priority = animation.priority;
    if (!animation.idle) {
      willAdvance(animation);
      animation.advance(dt);
      if (!animation.idle) {
        nextFrame.push(animation);
      }
    }
  }
  priority = 0;
  prevFrame = currentFrame;
  prevFrame.length = 0;
  currentFrame = nextFrame;
  return currentFrame.length > 0;
}
function findIndex$3(arr, test) {
  const index2 = arr.findIndex(test);
  return index2 < 0 ? arr.length : index2;
}
const colors = {
  transparent: 0,
  aliceblue: 4042850303,
  antiquewhite: 4209760255,
  aqua: 16777215,
  aquamarine: 2147472639,
  azure: 4043309055,
  beige: 4126530815,
  bisque: 4293182719,
  black: 255,
  blanchedalmond: 4293643775,
  blue: 65535,
  blueviolet: 2318131967,
  brown: 2771004159,
  burlywood: 3736635391,
  burntsienna: 3934150143,
  cadetblue: 1604231423,
  chartreuse: 2147418367,
  chocolate: 3530104575,
  coral: 4286533887,
  cornflowerblue: 1687547391,
  cornsilk: 4294499583,
  crimson: 3692313855,
  cyan: 16777215,
  darkblue: 35839,
  darkcyan: 9145343,
  darkgoldenrod: 3095792639,
  darkgray: 2846468607,
  darkgreen: 6553855,
  darkgrey: 2846468607,
  darkkhaki: 3182914559,
  darkmagenta: 2332068863,
  darkolivegreen: 1433087999,
  darkorange: 4287365375,
  darkorchid: 2570243327,
  darkred: 2332033279,
  darksalmon: 3918953215,
  darkseagreen: 2411499519,
  darkslateblue: 1211993087,
  darkslategray: 793726975,
  darkslategrey: 793726975,
  darkturquoise: 13554175,
  darkviolet: 2483082239,
  deeppink: 4279538687,
  deepskyblue: 12582911,
  dimgray: 1768516095,
  dimgrey: 1768516095,
  dodgerblue: 512819199,
  firebrick: 2988581631,
  floralwhite: 4294635775,
  forestgreen: 579543807,
  fuchsia: 4278255615,
  gainsboro: 3705462015,
  ghostwhite: 4177068031,
  gold: 4292280575,
  goldenrod: 3668254975,
  gray: 2155905279,
  green: 8388863,
  greenyellow: 2919182335,
  grey: 2155905279,
  honeydew: 4043305215,
  hotpink: 4285117695,
  indianred: 3445382399,
  indigo: 1258324735,
  ivory: 4294963455,
  khaki: 4041641215,
  lavender: 3873897215,
  lavenderblush: 4293981695,
  lawngreen: 2096890111,
  lemonchiffon: 4294626815,
  lightblue: 2916673279,
  lightcoral: 4034953471,
  lightcyan: 3774873599,
  lightgoldenrodyellow: 4210742015,
  lightgray: 3553874943,
  lightgreen: 2431553791,
  lightgrey: 3553874943,
  lightpink: 4290167295,
  lightsalmon: 4288707327,
  lightseagreen: 548580095,
  lightskyblue: 2278488831,
  lightslategray: 2005441023,
  lightslategrey: 2005441023,
  lightsteelblue: 2965692159,
  lightyellow: 4294959359,
  lime: 16711935,
  limegreen: 852308735,
  linen: 4210091775,
  magenta: 4278255615,
  maroon: 2147483903,
  mediumaquamarine: 1724754687,
  mediumblue: 52735,
  mediumorchid: 3126187007,
  mediumpurple: 2473647103,
  mediumseagreen: 1018393087,
  mediumslateblue: 2070474495,
  mediumspringgreen: 16423679,
  mediumturquoise: 1221709055,
  mediumvioletred: 3340076543,
  midnightblue: 421097727,
  mintcream: 4127193855,
  mistyrose: 4293190143,
  moccasin: 4293178879,
  navajowhite: 4292783615,
  navy: 33023,
  oldlace: 4260751103,
  olive: 2155872511,
  olivedrab: 1804477439,
  orange: 4289003775,
  orangered: 4282712319,
  orchid: 3664828159,
  palegoldenrod: 4008225535,
  palegreen: 2566625535,
  paleturquoise: 2951671551,
  palevioletred: 3681588223,
  papayawhip: 4293907967,
  peachpuff: 4292524543,
  peru: 3448061951,
  pink: 4290825215,
  plum: 3718307327,
  powderblue: 2967529215,
  purple: 2147516671,
  rebeccapurple: 1714657791,
  red: 4278190335,
  rosybrown: 3163525119,
  royalblue: 1097458175,
  saddlebrown: 2336560127,
  salmon: 4202722047,
  sandybrown: 4104413439,
  seagreen: 780883967,
  seashell: 4294307583,
  sienna: 2689740287,
  silver: 3233857791,
  skyblue: 2278484991,
  slateblue: 1784335871,
  slategray: 1887473919,
  slategrey: 1887473919,
  snow: 4294638335,
  springgreen: 16744447,
  steelblue: 1182971135,
  tan: 3535047935,
  teal: 8421631,
  thistle: 3636451583,
  tomato: 4284696575,
  turquoise: 1088475391,
  violet: 4001558271,
  wheat: 4125012991,
  white: 4294967295,
  whitesmoke: 4126537215,
  yellow: 4294902015,
  yellowgreen: 2597139199
};
const NUMBER = "[-+]?\\d*\\.?\\d+";
const PERCENTAGE = NUMBER + "%";
function call$3(...parts) {
  return "\\(\\s*(" + parts.join(")\\s*,\\s*(") + ")\\s*\\)";
}
const rgb = new RegExp("rgb" + call$3(NUMBER, NUMBER, NUMBER));
const rgba = new RegExp("rgba" + call$3(NUMBER, NUMBER, NUMBER, NUMBER));
const hsl = new RegExp("hsl" + call$3(NUMBER, PERCENTAGE, PERCENTAGE));
const hsla = new RegExp("hsla" + call$3(NUMBER, PERCENTAGE, PERCENTAGE, NUMBER));
const hex3 = /^#([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/;
const hex4 = /^#([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/;
const hex6 = /^#([0-9a-fA-F]{6})$/;
const hex8 = /^#([0-9a-fA-F]{8})$/;
function normalizeColor(color) {
  let match2;
  if (typeof color === "number") {
    return color >>> 0 === color && color >= 0 && color <= 4294967295 ? color : null;
  }
  if (match2 = hex6.exec(color))
    return parseInt(match2[1] + "ff", 16) >>> 0;
  if (colors$1 && colors$1[color] !== void 0) {
    return colors$1[color];
  }
  if (match2 = rgb.exec(color)) {
    return (parse255(match2[1]) << 24 | parse255(match2[2]) << 16 | parse255(match2[3]) << 8 | 255) >>> 0;
  }
  if (match2 = rgba.exec(color)) {
    return (parse255(match2[1]) << 24 | parse255(match2[2]) << 16 | parse255(match2[3]) << 8 | parse1(match2[4])) >>> 0;
  }
  if (match2 = hex3.exec(color)) {
    return parseInt(match2[1] + match2[1] + match2[2] + match2[2] + match2[3] + match2[3] + "ff", 16) >>> 0;
  }
  if (match2 = hex8.exec(color))
    return parseInt(match2[1], 16) >>> 0;
  if (match2 = hex4.exec(color)) {
    return parseInt(match2[1] + match2[1] + match2[2] + match2[2] + match2[3] + match2[3] + match2[4] + match2[4], 16) >>> 0;
  }
  if (match2 = hsl.exec(color)) {
    return (hslToRgb(parse360(match2[1]), parsePercentage(match2[2]), parsePercentage(match2[3])) | 255) >>> 0;
  }
  if (match2 = hsla.exec(color)) {
    return (hslToRgb(parse360(match2[1]), parsePercentage(match2[2]), parsePercentage(match2[3])) | parse1(match2[4])) >>> 0;
  }
  return null;
}
function hue2rgb(p2, q3, t3) {
  if (t3 < 0)
    t3 += 1;
  if (t3 > 1)
    t3 -= 1;
  if (t3 < 1 / 6)
    return p2 + (q3 - p2) * 6 * t3;
  if (t3 < 1 / 2)
    return q3;
  if (t3 < 2 / 3)
    return p2 + (q3 - p2) * (2 / 3 - t3) * 6;
  return p2;
}
function hslToRgb(h4, s3, l2) {
  const q3 = l2 < 0.5 ? l2 * (1 + s3) : l2 + s3 - l2 * s3;
  const p2 = 2 * l2 - q3;
  const r2 = hue2rgb(p2, q3, h4 + 1 / 3);
  const g2 = hue2rgb(p2, q3, h4);
  const b3 = hue2rgb(p2, q3, h4 - 1 / 3);
  return Math.round(r2 * 255) << 24 | Math.round(g2 * 255) << 16 | Math.round(b3 * 255) << 8;
}
function parse255(str) {
  const int = parseInt(str, 10);
  if (int < 0)
    return 0;
  if (int > 255)
    return 255;
  return int;
}
function parse360(str) {
  const int = parseFloat(str);
  return (int % 360 + 360) % 360 / 360;
}
function parse1(str) {
  const num = parseFloat(str);
  if (num < 0)
    return 0;
  if (num > 1)
    return 255;
  return Math.round(num * 255);
}
function parsePercentage(str) {
  const int = parseFloat(str);
  if (int < 0)
    return 0;
  if (int > 100)
    return 1;
  return int / 100;
}
function colorToRgba(input2) {
  let int32Color = normalizeColor(input2);
  if (int32Color === null)
    return input2;
  int32Color = int32Color || 0;
  let r2 = (int32Color & 4278190080) >>> 24;
  let g2 = (int32Color & 16711680) >>> 16;
  let b3 = (int32Color & 65280) >>> 8;
  let a3 = (int32Color & 255) / 255;
  return `rgba(${r2}, ${g2}, ${b3}, ${a3})`;
}
const createInterpolator = (range, output, extrapolate) => {
  if (is$1.fun(range)) {
    return range;
  }
  if (is$1.arr(range)) {
    return createInterpolator({
      range,
      output,
      extrapolate
    });
  }
  if (is$1.str(range.output[0])) {
    return createStringInterpolator$1(range);
  }
  const config2 = range;
  const outputRange = config2.output;
  const inputRange = config2.range || [0, 1];
  const extrapolateLeft = config2.extrapolateLeft || config2.extrapolate || "extend";
  const extrapolateRight = config2.extrapolateRight || config2.extrapolate || "extend";
  const easing = config2.easing || ((t3) => t3);
  return (input2) => {
    const range2 = findRange(input2, inputRange);
    return interpolate(input2, inputRange[range2], inputRange[range2 + 1], outputRange[range2], outputRange[range2 + 1], easing, extrapolateLeft, extrapolateRight, config2.map);
  };
};
function interpolate(input2, inputMin, inputMax, outputMin, outputMax, easing, extrapolateLeft, extrapolateRight, map2) {
  let result = map2 ? map2(input2) : input2;
  if (result < inputMin) {
    if (extrapolateLeft === "identity")
      return result;
    else if (extrapolateLeft === "clamp")
      result = inputMin;
  }
  if (result > inputMax) {
    if (extrapolateRight === "identity")
      return result;
    else if (extrapolateRight === "clamp")
      result = inputMax;
  }
  if (outputMin === outputMax)
    return outputMin;
  if (inputMin === inputMax)
    return input2 <= inputMin ? outputMin : outputMax;
  if (inputMin === -Infinity)
    result = -result;
  else if (inputMax === Infinity)
    result = result - inputMin;
  else
    result = (result - inputMin) / (inputMax - inputMin);
  result = easing(result);
  if (outputMin === -Infinity)
    result = -result;
  else if (outputMax === Infinity)
    result = result + outputMin;
  else
    result = result * (outputMax - outputMin) + outputMin;
  return result;
}
function findRange(input2, inputRange) {
  for (var i2 = 1; i2 < inputRange.length - 1; ++i2)
    if (inputRange[i2] >= input2)
      break;
  return i2 - 1;
}
function _extends$j() {
  _extends$j = Object.assign || function(target) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      var source2 = arguments[i2];
      for (var key in source2) {
        if (Object.prototype.hasOwnProperty.call(source2, key)) {
          target[key] = source2[key];
        }
      }
    }
    return target;
  };
  return _extends$j.apply(this, arguments);
}
const $get = Symbol.for("FluidValue.get");
const $observers = Symbol.for("FluidValue.observers");
const hasFluidValue = (arg) => Boolean(arg && arg[$get]);
const getFluidValue = (arg) => arg && arg[$get] ? arg[$get]() : arg;
const getFluidObservers = (target) => target[$observers] || null;
function callFluidObserver(observer, event) {
  if (observer.eventObserved) {
    observer.eventObserved(event);
  } else {
    observer(event);
  }
}
function callFluidObservers(target, event) {
  let observers2 = target[$observers];
  if (observers2) {
    observers2.forEach((observer) => {
      callFluidObserver(observer, event);
    });
  }
}
class FluidValue {
  constructor(get4) {
    this[$get] = void 0;
    this[$observers] = void 0;
    if (!get4 && !(get4 = this.get)) {
      throw Error("Unknown getter");
    }
    setFluidGetter(this, get4);
  }
}
const setFluidGetter = (target, get4) => setHidden(target, $get, get4);
function addFluidObserver(target, observer) {
  if (target[$get]) {
    let observers2 = target[$observers];
    if (!observers2) {
      setHidden(target, $observers, observers2 = /* @__PURE__ */ new Set());
    }
    if (!observers2.has(observer)) {
      observers2.add(observer);
      if (target.observerAdded) {
        target.observerAdded(observers2.size, observer);
      }
    }
  }
  return observer;
}
function removeFluidObserver(target, observer) {
  let observers2 = target[$observers];
  if (observers2 && observers2.has(observer)) {
    const count2 = observers2.size - 1;
    if (count2) {
      observers2.delete(observer);
    } else {
      target[$observers] = null;
    }
    if (target.observerRemoved) {
      target.observerRemoved(count2, observer);
    }
  }
}
const setHidden = (target, key, value) => Object.defineProperty(target, key, {
  value,
  writable: true,
  configurable: true
});
const numberRegex = /[+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?/g;
const colorRegex = /(#(?:[0-9a-f]{2}){2,4}|(#[0-9a-f]{3})|(rgb|hsl)a?\((-?\d+%?[,\s]+){2,3}\s*[\d\.]+%?\))/gi;
const unitRegex = new RegExp(`(${numberRegex.source})(%|[a-z]+)`, "i");
const rgbaRegex = /rgba\(([0-9\.-]+), ([0-9\.-]+), ([0-9\.-]+), ([0-9\.-]+)\)/gi;
const cssVariableRegex = /var\((--[a-zA-Z0-9-_]+),? ?([a-zA-Z0-9 ()%#.,-]+)?\)/;
const variableToRgba = (input2) => {
  const [token, fallback] = parseCSSVariable(input2);
  if (!token || isSSR()) {
    return input2;
  }
  const value = window.getComputedStyle(document.documentElement).getPropertyValue(token);
  if (value) {
    return value.trim();
  } else if (fallback && fallback.startsWith("--")) {
    const _value = window.getComputedStyle(document.documentElement).getPropertyValue(fallback);
    if (_value) {
      return _value;
    } else {
      return input2;
    }
  } else if (fallback && cssVariableRegex.test(fallback)) {
    return variableToRgba(fallback);
  } else if (fallback) {
    return fallback;
  }
  return input2;
};
const parseCSSVariable = (current) => {
  const match2 = cssVariableRegex.exec(current);
  if (!match2)
    return [,];
  const [, token, fallback] = match2;
  return [token, fallback];
};
let namedColorRegex;
const rgbaRound = (_, p1, p2, p3, p4) => `rgba(${Math.round(p1)}, ${Math.round(p2)}, ${Math.round(p3)}, ${p4})`;
const createStringInterpolator = (config2) => {
  if (!namedColorRegex)
    namedColorRegex = colors$1 ? new RegExp(`(${Object.keys(colors$1).join("|")})(?!\\w)`, "g") : /^\b$/;
  const output = config2.output.map((value) => {
    return getFluidValue(value).replace(cssVariableRegex, variableToRgba).replace(colorRegex, colorToRgba).replace(namedColorRegex, colorToRgba);
  });
  const keyframes = output.map((value) => value.match(numberRegex).map(Number));
  const outputRanges = keyframes[0].map((_, i2) => keyframes.map((values2) => {
    if (!(i2 in values2)) {
      throw Error('The arity of each "output" value must be equal');
    }
    return values2[i2];
  }));
  const interpolators = outputRanges.map((output2) => createInterpolator(_extends$j({}, config2, {
    output: output2
  })));
  return (input2) => {
    var _output$find;
    const missingUnit = !unitRegex.test(output[0]) && ((_output$find = output.find((value) => unitRegex.test(value))) == null ? void 0 : _output$find.replace(numberRegex, ""));
    let i2 = 0;
    return output[0].replace(numberRegex, () => `${interpolators[i2++](input2)}${missingUnit || ""}`).replace(rgbaRegex, rgbaRound);
  };
};
const prefix$3 = "react-spring: ";
const once = (fn3) => {
  const func = fn3;
  let called = false;
  if (typeof func != "function") {
    throw new TypeError(`${prefix$3}once requires a function parameter`);
  }
  return (...args) => {
    if (!called) {
      func(...args);
      called = true;
    }
  };
};
const warnInterpolate = once(console.warn);
function deprecateInterpolate() {
  warnInterpolate(`${prefix$3}The "interpolate" function is deprecated in v9 (use "to" instead)`);
}
const warnDirectCall = once(console.warn);
function deprecateDirectCall() {
  warnDirectCall(`${prefix$3}Directly calling start instead of using the api object is deprecated in v9 (use ".start" instead), this will be removed in later 0.X.0 versions`);
}
function isAnimatedString(value) {
  return is$1.str(value) && (value[0] == "#" || /\d/.test(value) || !isSSR() && cssVariableRegex.test(value) || value in (colors$1 || {}));
}
const useOnce = (effect3) => useEffect(effect3, emptyDeps);
const emptyDeps = [];
function useForceUpdate$1() {
  const update2 = useState$1()[1];
  const mounted = useState$1(makeMountedRef)[0];
  useOnce(mounted.unmount);
  return () => {
    if (mounted.current) {
      update2({});
    }
  };
}
function makeMountedRef() {
  const mounted = {
    current: true,
    unmount: () => () => {
      mounted.current = false;
    }
  };
  return mounted;
}
function useMemoOne$1(getResult, inputs) {
  const [initial] = useState$1(() => ({
    inputs,
    result: getResult()
  }));
  const committed = useRef();
  const prevCache = committed.current;
  let cache2 = prevCache;
  if (cache2) {
    const useCache2 = Boolean(inputs && cache2.inputs && areInputsEqual$2(inputs, cache2.inputs));
    if (!useCache2) {
      cache2 = {
        inputs,
        result: getResult()
      };
    }
  } else {
    cache2 = initial;
  }
  useEffect(() => {
    committed.current = cache2;
    if (prevCache == initial) {
      initial.inputs = initial.result = void 0;
    }
  }, [cache2]);
  return cache2.result;
}
function areInputsEqual$2(next, prev) {
  if (next.length !== prev.length) {
    return false;
  }
  for (let i2 = 0; i2 < next.length; i2++) {
    if (next[i2] !== prev[i2]) {
      return false;
    }
  }
  return true;
}
function usePrev(value) {
  const prevRef = useRef();
  useEffect(() => {
    prevRef.current = value;
  });
  return prevRef.current;
}
const useLayoutEffect$5 = typeof window !== "undefined" && window.document && window.document.createElement ? React$4.useLayoutEffect : React$4.useEffect;
const $node = Symbol.for("Animated:node");
const isAnimated = (value) => !!value && value[$node] === value;
const getAnimated = (owner) => owner && owner[$node];
const setAnimated = (owner, node) => defineHidden(owner, $node, node);
const getPayload = (owner) => owner && owner[$node] && owner[$node].getPayload();
class Animated {
  constructor() {
    this.payload = void 0;
    setAnimated(this, this);
  }
  getPayload() {
    return this.payload || [];
  }
}
class AnimatedValue extends Animated {
  constructor(_value) {
    super();
    this.done = true;
    this.elapsedTime = void 0;
    this.lastPosition = void 0;
    this.lastVelocity = void 0;
    this.v0 = void 0;
    this.durationProgress = 0;
    this._value = _value;
    if (is$1.num(this._value)) {
      this.lastPosition = this._value;
    }
  }
  static create(value) {
    return new AnimatedValue(value);
  }
  getPayload() {
    return [this];
  }
  getValue() {
    return this._value;
  }
  setValue(value, step) {
    if (is$1.num(value)) {
      this.lastPosition = value;
      if (step) {
        value = Math.round(value / step) * step;
        if (this.done) {
          this.lastPosition = value;
        }
      }
    }
    if (this._value === value) {
      return false;
    }
    this._value = value;
    return true;
  }
  reset() {
    const {
      done
    } = this;
    this.done = false;
    if (is$1.num(this._value)) {
      this.elapsedTime = 0;
      this.durationProgress = 0;
      this.lastPosition = this._value;
      if (done)
        this.lastVelocity = null;
      this.v0 = null;
    }
  }
}
class AnimatedString extends AnimatedValue {
  constructor(value) {
    super(0);
    this._string = null;
    this._toString = void 0;
    this._toString = createInterpolator({
      output: [value, value]
    });
  }
  static create(value) {
    return new AnimatedString(value);
  }
  getValue() {
    let value = this._string;
    return value == null ? this._string = this._toString(this._value) : value;
  }
  setValue(value) {
    if (is$1.str(value)) {
      if (value == this._string) {
        return false;
      }
      this._string = value;
      this._value = 1;
    } else if (super.setValue(value)) {
      this._string = null;
    } else {
      return false;
    }
    return true;
  }
  reset(goal) {
    if (goal) {
      this._toString = createInterpolator({
        output: [this.getValue(), goal]
      });
    }
    this._value = 0;
    super.reset();
  }
}
const TreeContext = {
  dependencies: null
};
class AnimatedObject extends Animated {
  constructor(source2) {
    super();
    this.source = source2;
    this.setValue(source2);
  }
  getValue(animated2) {
    const values2 = {};
    eachProp(this.source, (source2, key) => {
      if (isAnimated(source2)) {
        values2[key] = source2.getValue(animated2);
      } else if (hasFluidValue(source2)) {
        values2[key] = getFluidValue(source2);
      } else if (!animated2) {
        values2[key] = source2;
      }
    });
    return values2;
  }
  setValue(source2) {
    this.source = source2;
    this.payload = this._makePayload(source2);
  }
  reset() {
    if (this.payload) {
      each$1(this.payload, (node) => node.reset());
    }
  }
  _makePayload(source2) {
    if (source2) {
      const payload = /* @__PURE__ */ new Set();
      eachProp(source2, this._addToPayload, payload);
      return Array.from(payload);
    }
  }
  _addToPayload(source2) {
    if (TreeContext.dependencies && hasFluidValue(source2)) {
      TreeContext.dependencies.add(source2);
    }
    const payload = getPayload(source2);
    if (payload) {
      each$1(payload, (node) => this.add(node));
    }
  }
}
class AnimatedArray extends AnimatedObject {
  constructor(source2) {
    super(source2);
  }
  static create(source2) {
    return new AnimatedArray(source2);
  }
  getValue() {
    return this.source.map((node) => node.getValue());
  }
  setValue(source2) {
    const payload = this.getPayload();
    if (source2.length == payload.length) {
      return payload.map((node, i2) => node.setValue(source2[i2])).some(Boolean);
    }
    super.setValue(source2.map(makeAnimated));
    return true;
  }
}
function makeAnimated(value) {
  const nodeType = isAnimatedString(value) ? AnimatedString : AnimatedValue;
  return nodeType.create(value);
}
function getAnimatedType(value) {
  const parentNode = getAnimated(value);
  return parentNode ? parentNode.constructor : is$1.arr(value) ? AnimatedArray : isAnimatedString(value) ? AnimatedString : AnimatedValue;
}
function _extends$i() {
  _extends$i = Object.assign || function(target) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      var source2 = arguments[i2];
      for (var key in source2) {
        if (Object.prototype.hasOwnProperty.call(source2, key)) {
          target[key] = source2[key];
        }
      }
    }
    return target;
  };
  return _extends$i.apply(this, arguments);
}
const withAnimated = (Component2, host2) => {
  const hasInstance = !is$1.fun(Component2) || Component2.prototype && Component2.prototype.isReactComponent;
  return forwardRef$3((givenProps, givenRef) => {
    const instanceRef = useRef(null);
    const ref = hasInstance && useCallback$1((value) => {
      instanceRef.current = updateRef$1(givenRef, value);
    }, [givenRef]);
    const [props, deps] = getAnimatedState(givenProps, host2);
    const forceUpdate = useForceUpdate$1();
    const callback = () => {
      const instance = instanceRef.current;
      if (hasInstance && !instance) {
        return;
      }
      const didUpdate = instance ? host2.applyAnimatedValues(instance, props.getValue(true)) : false;
      if (didUpdate === false) {
        forceUpdate();
      }
    };
    const observer = new PropsObserver(callback, deps);
    const observerRef = useRef();
    useLayoutEffect$5(() => {
      const lastObserver = observerRef.current;
      observerRef.current = observer;
      each$1(deps, (dep) => addFluidObserver(dep, observer));
      if (lastObserver) {
        each$1(lastObserver.deps, (dep) => removeFluidObserver(dep, lastObserver));
        raf$2.cancel(lastObserver.update);
      }
    });
    useEffect(callback, []);
    useOnce(() => () => {
      const observer2 = observerRef.current;
      each$1(observer2.deps, (dep) => removeFluidObserver(dep, observer2));
    });
    const usedProps = host2.getComponentProps(props.getValue());
    return React$4.createElement(Component2, _extends$i({}, usedProps, {
      ref
    }));
  });
};
class PropsObserver {
  constructor(update2, deps) {
    this.update = update2;
    this.deps = deps;
  }
  eventObserved(event) {
    if (event.type == "change") {
      raf$2.write(this.update);
    }
  }
}
function getAnimatedState(props, host2) {
  const dependencies = /* @__PURE__ */ new Set();
  TreeContext.dependencies = dependencies;
  if (props.style)
    props = _extends$i({}, props, {
      style: host2.createAnimatedStyle(props.style)
    });
  props = new AnimatedObject(props);
  TreeContext.dependencies = null;
  return [props, dependencies];
}
function updateRef$1(ref, value) {
  if (ref) {
    if (is$1.fun(ref))
      ref(value);
    else
      ref.current = value;
  }
  return value;
}
const cacheKey = Symbol.for("AnimatedComponent");
const createHost = (components, {
  applyAnimatedValues: _applyAnimatedValues = () => false,
  createAnimatedStyle: _createAnimatedStyle = (style2) => new AnimatedObject(style2),
  getComponentProps: _getComponentProps = (props) => props
} = {}) => {
  const hostConfig = {
    applyAnimatedValues: _applyAnimatedValues,
    createAnimatedStyle: _createAnimatedStyle,
    getComponentProps: _getComponentProps
  };
  const animated2 = (Component2) => {
    const displayName = getDisplayName(Component2) || "Anonymous";
    if (is$1.str(Component2)) {
      Component2 = animated2[Component2] || (animated2[Component2] = withAnimated(Component2, hostConfig));
    } else {
      Component2 = Component2[cacheKey] || (Component2[cacheKey] = withAnimated(Component2, hostConfig));
    }
    Component2.displayName = `Animated(${displayName})`;
    return Component2;
  };
  eachProp(components, (Component2, key) => {
    if (is$1.arr(components)) {
      key = getDisplayName(Component2);
    }
    animated2[key] = animated2(Component2);
  });
  return {
    animated: animated2
  };
};
const getDisplayName = (arg) => is$1.str(arg) ? arg : arg && is$1.str(arg.displayName) ? arg.displayName : is$1.fun(arg) && arg.name || null;
function _extends$h() {
  _extends$h = Object.assign || function(target) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      var source2 = arguments[i2];
      for (var key in source2) {
        if (Object.prototype.hasOwnProperty.call(source2, key)) {
          target[key] = source2[key];
        }
      }
    }
    return target;
  };
  return _extends$h.apply(this, arguments);
}
function callProp(value, ...args) {
  return is$1.fun(value) ? value(...args) : value;
}
const matchProp = (value, key) => value === true || !!(key && value && (is$1.fun(value) ? value(key) : toArray$8(value).includes(key)));
const resolveProp = (prop, key) => is$1.obj(prop) ? key && prop[key] : prop;
const getDefaultProp = (props, key) => props.default === true ? props[key] : props.default ? props.default[key] : void 0;
const noopTransform = (value) => value;
const getDefaultProps = (props, transform2 = noopTransform) => {
  let keys2 = DEFAULT_PROPS;
  if (props.default && props.default !== true) {
    props = props.default;
    keys2 = Object.keys(props);
  }
  const defaults2 = {};
  for (const key of keys2) {
    const value = transform2(props[key], key);
    if (!is$1.und(value)) {
      defaults2[key] = value;
    }
  }
  return defaults2;
};
const DEFAULT_PROPS = ["config", "onProps", "onStart", "onChange", "onPause", "onResume", "onRest"];
const RESERVED_PROPS = {
  config: 1,
  from: 1,
  to: 1,
  ref: 1,
  loop: 1,
  reset: 1,
  pause: 1,
  cancel: 1,
  reverse: 1,
  immediate: 1,
  default: 1,
  delay: 1,
  onProps: 1,
  onStart: 1,
  onChange: 1,
  onPause: 1,
  onResume: 1,
  onRest: 1,
  onResolve: 1,
  items: 1,
  trail: 1,
  sort: 1,
  expires: 1,
  initial: 1,
  enter: 1,
  update: 1,
  leave: 1,
  children: 1,
  onDestroyed: 1,
  keys: 1,
  callId: 1,
  parentId: 1
};
function getForwardProps(props) {
  const forward = {};
  let count2 = 0;
  eachProp(props, (value, prop) => {
    if (!RESERVED_PROPS[prop]) {
      forward[prop] = value;
      count2++;
    }
  });
  if (count2) {
    return forward;
  }
}
function inferTo(props) {
  const to2 = getForwardProps(props);
  if (to2) {
    const out = {
      to: to2
    };
    eachProp(props, (val, key) => key in to2 || (out[key] = val));
    return out;
  }
  return _extends$h({}, props);
}
function computeGoal(value) {
  value = getFluidValue(value);
  return is$1.arr(value) ? value.map(computeGoal) : isAnimatedString(value) ? globals.createStringInterpolator({
    range: [0, 1],
    output: [value, value]
  })(1) : value;
}
function hasProps(props) {
  for (const _ in props)
    return true;
  return false;
}
function isAsyncTo(to2) {
  return is$1.fun(to2) || is$1.arr(to2) && is$1.obj(to2[0]);
}
function detachRefs(ctrl, ref) {
  var _ctrl$ref;
  (_ctrl$ref = ctrl.ref) == null ? void 0 : _ctrl$ref.delete(ctrl);
  ref == null ? void 0 : ref.delete(ctrl);
}
function replaceRef(ctrl, ref) {
  if (ref && ctrl.ref !== ref) {
    var _ctrl$ref2;
    (_ctrl$ref2 = ctrl.ref) == null ? void 0 : _ctrl$ref2.delete(ctrl);
    ref.add(ctrl);
    ctrl.ref = ref;
  }
}
const config$2 = {
  default: {
    tension: 170,
    friction: 26
  },
  gentle: {
    tension: 120,
    friction: 14
  },
  wobbly: {
    tension: 180,
    friction: 12
  },
  stiff: {
    tension: 210,
    friction: 20
  },
  slow: {
    tension: 280,
    friction: 60
  },
  molasses: {
    tension: 280,
    friction: 120
  }
};
const c1 = 1.70158;
const c2 = c1 * 1.525;
const c3 = c1 + 1;
const c4 = 2 * Math.PI / 3;
const c5 = 2 * Math.PI / 4.5;
const bounceOut = (x2) => {
  const n1 = 7.5625;
  const d1 = 2.75;
  if (x2 < 1 / d1) {
    return n1 * x2 * x2;
  } else if (x2 < 2 / d1) {
    return n1 * (x2 -= 1.5 / d1) * x2 + 0.75;
  } else if (x2 < 2.5 / d1) {
    return n1 * (x2 -= 2.25 / d1) * x2 + 0.9375;
  } else {
    return n1 * (x2 -= 2.625 / d1) * x2 + 0.984375;
  }
};
const easings = {
  linear: (x2) => x2,
  easeInQuad: (x2) => x2 * x2,
  easeOutQuad: (x2) => 1 - (1 - x2) * (1 - x2),
  easeInOutQuad: (x2) => x2 < 0.5 ? 2 * x2 * x2 : 1 - Math.pow(-2 * x2 + 2, 2) / 2,
  easeInCubic: (x2) => x2 * x2 * x2,
  easeOutCubic: (x2) => 1 - Math.pow(1 - x2, 3),
  easeInOutCubic: (x2) => x2 < 0.5 ? 4 * x2 * x2 * x2 : 1 - Math.pow(-2 * x2 + 2, 3) / 2,
  easeInQuart: (x2) => x2 * x2 * x2 * x2,
  easeOutQuart: (x2) => 1 - Math.pow(1 - x2, 4),
  easeInOutQuart: (x2) => x2 < 0.5 ? 8 * x2 * x2 * x2 * x2 : 1 - Math.pow(-2 * x2 + 2, 4) / 2,
  easeInQuint: (x2) => x2 * x2 * x2 * x2 * x2,
  easeOutQuint: (x2) => 1 - Math.pow(1 - x2, 5),
  easeInOutQuint: (x2) => x2 < 0.5 ? 16 * x2 * x2 * x2 * x2 * x2 : 1 - Math.pow(-2 * x2 + 2, 5) / 2,
  easeInSine: (x2) => 1 - Math.cos(x2 * Math.PI / 2),
  easeOutSine: (x2) => Math.sin(x2 * Math.PI / 2),
  easeInOutSine: (x2) => -(Math.cos(Math.PI * x2) - 1) / 2,
  easeInExpo: (x2) => x2 === 0 ? 0 : Math.pow(2, 10 * x2 - 10),
  easeOutExpo: (x2) => x2 === 1 ? 1 : 1 - Math.pow(2, -10 * x2),
  easeInOutExpo: (x2) => x2 === 0 ? 0 : x2 === 1 ? 1 : x2 < 0.5 ? Math.pow(2, 20 * x2 - 10) / 2 : (2 - Math.pow(2, -20 * x2 + 10)) / 2,
  easeInCirc: (x2) => 1 - Math.sqrt(1 - Math.pow(x2, 2)),
  easeOutCirc: (x2) => Math.sqrt(1 - Math.pow(x2 - 1, 2)),
  easeInOutCirc: (x2) => x2 < 0.5 ? (1 - Math.sqrt(1 - Math.pow(2 * x2, 2))) / 2 : (Math.sqrt(1 - Math.pow(-2 * x2 + 2, 2)) + 1) / 2,
  easeInBack: (x2) => c3 * x2 * x2 * x2 - c1 * x2 * x2,
  easeOutBack: (x2) => 1 + c3 * Math.pow(x2 - 1, 3) + c1 * Math.pow(x2 - 1, 2),
  easeInOutBack: (x2) => x2 < 0.5 ? Math.pow(2 * x2, 2) * ((c2 + 1) * 2 * x2 - c2) / 2 : (Math.pow(2 * x2 - 2, 2) * ((c2 + 1) * (x2 * 2 - 2) + c2) + 2) / 2,
  easeInElastic: (x2) => x2 === 0 ? 0 : x2 === 1 ? 1 : -Math.pow(2, 10 * x2 - 10) * Math.sin((x2 * 10 - 10.75) * c4),
  easeOutElastic: (x2) => x2 === 0 ? 0 : x2 === 1 ? 1 : Math.pow(2, -10 * x2) * Math.sin((x2 * 10 - 0.75) * c4) + 1,
  easeInOutElastic: (x2) => x2 === 0 ? 0 : x2 === 1 ? 1 : x2 < 0.5 ? -(Math.pow(2, 20 * x2 - 10) * Math.sin((20 * x2 - 11.125) * c5)) / 2 : Math.pow(2, -20 * x2 + 10) * Math.sin((20 * x2 - 11.125) * c5) / 2 + 1,
  easeInBounce: (x2) => 1 - bounceOut(1 - x2),
  easeOutBounce: bounceOut,
  easeInOutBounce: (x2) => x2 < 0.5 ? (1 - bounceOut(1 - 2 * x2)) / 2 : (1 + bounceOut(2 * x2 - 1)) / 2
};
const defaults$7 = _extends$h({}, config$2.default, {
  mass: 1,
  damping: 1,
  easing: easings.linear,
  clamp: false
});
class AnimationConfig {
  constructor() {
    this.tension = void 0;
    this.friction = void 0;
    this.frequency = void 0;
    this.damping = void 0;
    this.mass = void 0;
    this.velocity = 0;
    this.restVelocity = void 0;
    this.precision = void 0;
    this.progress = void 0;
    this.duration = void 0;
    this.easing = void 0;
    this.clamp = void 0;
    this.bounce = void 0;
    this.decay = void 0;
    this.round = void 0;
    Object.assign(this, defaults$7);
  }
}
function mergeConfig$3(config2, newConfig, defaultConfig2) {
  if (defaultConfig2) {
    defaultConfig2 = _extends$h({}, defaultConfig2);
    sanitizeConfig(defaultConfig2, newConfig);
    newConfig = _extends$h({}, defaultConfig2, newConfig);
  }
  sanitizeConfig(config2, newConfig);
  Object.assign(config2, newConfig);
  for (const key in defaults$7) {
    if (config2[key] == null) {
      config2[key] = defaults$7[key];
    }
  }
  let {
    mass,
    frequency,
    damping
  } = config2;
  if (!is$1.und(frequency)) {
    if (frequency < 0.01)
      frequency = 0.01;
    if (damping < 0)
      damping = 0;
    config2.tension = Math.pow(2 * Math.PI / frequency, 2) * mass;
    config2.friction = 4 * Math.PI * damping * mass / frequency;
  }
  return config2;
}
function sanitizeConfig(config2, props) {
  if (!is$1.und(props.decay)) {
    config2.duration = void 0;
  } else {
    const isTensionConfig = !is$1.und(props.tension) || !is$1.und(props.friction);
    if (isTensionConfig || !is$1.und(props.frequency) || !is$1.und(props.damping) || !is$1.und(props.mass)) {
      config2.duration = void 0;
      config2.decay = void 0;
    }
    if (isTensionConfig) {
      config2.frequency = void 0;
    }
  }
}
const emptyArray = [];
class Animation {
  constructor() {
    this.changed = false;
    this.values = emptyArray;
    this.toValues = null;
    this.fromValues = emptyArray;
    this.to = void 0;
    this.from = void 0;
    this.config = new AnimationConfig();
    this.immediate = false;
  }
}
function scheduleProps(callId, {
  key,
  props,
  defaultProps: defaultProps2,
  state,
  actions: actions2
}) {
  return new Promise((resolve, reject) => {
    var _props$cancel;
    let delay;
    let timeout;
    let cancel = matchProp((_props$cancel = props.cancel) != null ? _props$cancel : defaultProps2 == null ? void 0 : defaultProps2.cancel, key);
    if (cancel) {
      onStart();
    } else {
      if (!is$1.und(props.pause)) {
        state.paused = matchProp(props.pause, key);
      }
      let pause = defaultProps2 == null ? void 0 : defaultProps2.pause;
      if (pause !== true) {
        pause = state.paused || matchProp(pause, key);
      }
      delay = callProp(props.delay || 0, key);
      if (pause) {
        state.resumeQueue.add(onResume);
        actions2.pause();
      } else {
        actions2.resume();
        onResume();
      }
    }
    function onPause() {
      state.resumeQueue.add(onResume);
      state.timeouts.delete(timeout);
      timeout.cancel();
      delay = timeout.time - raf$2.now();
    }
    function onResume() {
      if (delay > 0 && !globals.skipAnimation) {
        state.delayed = true;
        timeout = raf$2.setTimeout(onStart, delay);
        state.pauseQueue.add(onPause);
        state.timeouts.add(timeout);
      } else {
        onStart();
      }
    }
    function onStart() {
      if (state.delayed) {
        state.delayed = false;
      }
      state.pauseQueue.delete(onPause);
      state.timeouts.delete(timeout);
      if (callId <= (state.cancelId || 0)) {
        cancel = true;
      }
      try {
        actions2.start(_extends$h({}, props, {
          callId,
          cancel
        }), resolve);
      } catch (err) {
        reject(err);
      }
    }
  });
}
const getCombinedResult = (target, results) => results.length == 1 ? results[0] : results.some((result) => result.cancelled) ? getCancelledResult(target.get()) : results.every((result) => result.noop) ? getNoopResult(target.get()) : getFinishedResult(target.get(), results.every((result) => result.finished));
const getNoopResult = (value) => ({
  value,
  noop: true,
  finished: true,
  cancelled: false
});
const getFinishedResult = (value, finished, cancelled = false) => ({
  value,
  finished,
  cancelled
});
const getCancelledResult = (value) => ({
  value,
  cancelled: true,
  finished: false
});
function runAsync(to2, props, state, target) {
  const {
    callId,
    parentId,
    onRest
  } = props;
  const {
    asyncTo: prevTo,
    promise: prevPromise
  } = state;
  if (!parentId && to2 === prevTo && !props.reset) {
    return prevPromise;
  }
  return state.promise = (async () => {
    state.asyncId = callId;
    state.asyncTo = to2;
    const defaultProps2 = getDefaultProps(props, (value, key) => key === "onRest" ? void 0 : value);
    let preventBail;
    let bail;
    const bailPromise = new Promise((resolve, reject) => (preventBail = resolve, bail = reject));
    const bailIfEnded = (bailSignal) => {
      const bailResult = callId <= (state.cancelId || 0) && getCancelledResult(target) || callId !== state.asyncId && getFinishedResult(target, false);
      if (bailResult) {
        bailSignal.result = bailResult;
        bail(bailSignal);
        throw bailSignal;
      }
    };
    const animate = (arg1, arg2) => {
      const bailSignal = new BailSignal();
      const skipAnimationSignal = new SkipAniamtionSignal();
      return (async () => {
        if (globals.skipAnimation) {
          stopAsync(state);
          skipAnimationSignal.result = getFinishedResult(target, false);
          bail(skipAnimationSignal);
          throw skipAnimationSignal;
        }
        bailIfEnded(bailSignal);
        const props2 = is$1.obj(arg1) ? _extends$h({}, arg1) : _extends$h({}, arg2, {
          to: arg1
        });
        props2.parentId = callId;
        eachProp(defaultProps2, (value, key) => {
          if (is$1.und(props2[key])) {
            props2[key] = value;
          }
        });
        const result2 = await target.start(props2);
        bailIfEnded(bailSignal);
        if (state.paused) {
          await new Promise((resume) => {
            state.resumeQueue.add(resume);
          });
        }
        return result2;
      })();
    };
    let result;
    if (globals.skipAnimation) {
      stopAsync(state);
      return getFinishedResult(target, false);
    }
    try {
      let animating;
      if (is$1.arr(to2)) {
        animating = (async (queue) => {
          for (const props2 of queue) {
            await animate(props2);
          }
        })(to2);
      } else {
        animating = Promise.resolve(to2(animate, target.stop.bind(target)));
      }
      await Promise.all([animating.then(preventBail), bailPromise]);
      result = getFinishedResult(target.get(), true, false);
    } catch (err) {
      if (err instanceof BailSignal) {
        result = err.result;
      } else if (err instanceof SkipAniamtionSignal) {
        result = err.result;
      } else {
        throw err;
      }
    } finally {
      if (callId == state.asyncId) {
        state.asyncId = parentId;
        state.asyncTo = parentId ? prevTo : void 0;
        state.promise = parentId ? prevPromise : void 0;
      }
    }
    if (is$1.fun(onRest)) {
      raf$2.batchedUpdates(() => {
        onRest(result, target, target.item);
      });
    }
    return result;
  })();
}
function stopAsync(state, cancelId) {
  flush$1(state.timeouts, (t3) => t3.cancel());
  state.pauseQueue.clear();
  state.resumeQueue.clear();
  state.asyncId = state.asyncTo = state.promise = void 0;
  if (cancelId)
    state.cancelId = cancelId;
}
class BailSignal extends Error {
  constructor() {
    super("An async animation has been interrupted. You see this error because you forgot to use `await` or `.catch(...)` on its returned promise.");
    this.result = void 0;
  }
}
class SkipAniamtionSignal extends Error {
  constructor() {
    super("SkipAnimationSignal");
    this.result = void 0;
  }
}
const isFrameValue = (value) => value instanceof FrameValue;
let nextId$1 = 1;
class FrameValue extends FluidValue {
  constructor(...args) {
    super(...args);
    this.id = nextId$1++;
    this.key = void 0;
    this._priority = 0;
  }
  get priority() {
    return this._priority;
  }
  set priority(priority2) {
    if (this._priority != priority2) {
      this._priority = priority2;
      this._onPriorityChange(priority2);
    }
  }
  get() {
    const node = getAnimated(this);
    return node && node.getValue();
  }
  to(...args) {
    return globals.to(this, args);
  }
  interpolate(...args) {
    deprecateInterpolate();
    return globals.to(this, args);
  }
  toJSON() {
    return this.get();
  }
  observerAdded(count2) {
    if (count2 == 1)
      this._attach();
  }
  observerRemoved(count2) {
    if (count2 == 0)
      this._detach();
  }
  _attach() {
  }
  _detach() {
  }
  _onChange(value, idle2 = false) {
    callFluidObservers(this, {
      type: "change",
      parent: this,
      value,
      idle: idle2
    });
  }
  _onPriorityChange(priority2) {
    if (!this.idle) {
      frameLoop.sort(this);
    }
    callFluidObservers(this, {
      type: "priority",
      parent: this,
      priority: priority2
    });
  }
}
const $P = Symbol.for("SpringPhase");
const HAS_ANIMATED = 1;
const IS_ANIMATING = 2;
const IS_PAUSED = 4;
const hasAnimated = (target) => (target[$P] & HAS_ANIMATED) > 0;
const isAnimating = (target) => (target[$P] & IS_ANIMATING) > 0;
const isPaused = (target) => (target[$P] & IS_PAUSED) > 0;
const setActiveBit = (target, active3) => active3 ? target[$P] |= IS_ANIMATING | HAS_ANIMATED : target[$P] &= ~IS_ANIMATING;
const setPausedBit = (target, paused) => paused ? target[$P] |= IS_PAUSED : target[$P] &= ~IS_PAUSED;
class SpringValue extends FrameValue {
  constructor(arg1, arg2) {
    super();
    this.key = void 0;
    this.animation = new Animation();
    this.queue = void 0;
    this.defaultProps = {};
    this._state = {
      paused: false,
      delayed: false,
      pauseQueue: /* @__PURE__ */ new Set(),
      resumeQueue: /* @__PURE__ */ new Set(),
      timeouts: /* @__PURE__ */ new Set()
    };
    this._pendingCalls = /* @__PURE__ */ new Set();
    this._lastCallId = 0;
    this._lastToId = 0;
    this._memoizedDuration = 0;
    if (!is$1.und(arg1) || !is$1.und(arg2)) {
      const props = is$1.obj(arg1) ? _extends$h({}, arg1) : _extends$h({}, arg2, {
        from: arg1
      });
      if (is$1.und(props.default)) {
        props.default = true;
      }
      this.start(props);
    }
  }
  get idle() {
    return !(isAnimating(this) || this._state.asyncTo) || isPaused(this);
  }
  get goal() {
    return getFluidValue(this.animation.to);
  }
  get velocity() {
    const node = getAnimated(this);
    return node instanceof AnimatedValue ? node.lastVelocity || 0 : node.getPayload().map((node2) => node2.lastVelocity || 0);
  }
  get hasAnimated() {
    return hasAnimated(this);
  }
  get isAnimating() {
    return isAnimating(this);
  }
  get isPaused() {
    return isPaused(this);
  }
  get isDelayed() {
    return this._state.delayed;
  }
  advance(dt) {
    let idle2 = true;
    let changed = false;
    const anim = this.animation;
    let {
      config: config2,
      toValues
    } = anim;
    const payload = getPayload(anim.to);
    if (!payload && hasFluidValue(anim.to)) {
      toValues = toArray$8(getFluidValue(anim.to));
    }
    anim.values.forEach((node2, i2) => {
      if (node2.done)
        return;
      const to2 = node2.constructor == AnimatedString ? 1 : payload ? payload[i2].lastPosition : toValues[i2];
      let finished = anim.immediate;
      let position3 = to2;
      if (!finished) {
        position3 = node2.lastPosition;
        if (config2.tension <= 0) {
          node2.done = true;
          return;
        }
        let elapsed = node2.elapsedTime += dt;
        const from = anim.fromValues[i2];
        const v0 = node2.v0 != null ? node2.v0 : node2.v0 = is$1.arr(config2.velocity) ? config2.velocity[i2] : config2.velocity;
        let velocity;
        if (!is$1.und(config2.duration)) {
          let p2 = 1;
          if (config2.duration > 0) {
            if (this._memoizedDuration !== config2.duration) {
              this._memoizedDuration = config2.duration;
              if (node2.durationProgress > 0) {
                node2.elapsedTime = config2.duration * node2.durationProgress;
                elapsed = node2.elapsedTime += dt;
              }
            }
            p2 = (config2.progress || 0) + elapsed / this._memoizedDuration;
            p2 = p2 > 1 ? 1 : p2 < 0 ? 0 : p2;
            node2.durationProgress = p2;
          }
          position3 = from + config2.easing(p2) * (to2 - from);
          velocity = (position3 - node2.lastPosition) / dt;
          finished = p2 == 1;
        } else if (config2.decay) {
          const decay = config2.decay === true ? 0.998 : config2.decay;
          const e3 = Math.exp(-(1 - decay) * elapsed);
          position3 = from + v0 / (1 - decay) * (1 - e3);
          finished = Math.abs(node2.lastPosition - position3) < 0.1;
          velocity = v0 * e3;
        } else {
          velocity = node2.lastVelocity == null ? v0 : node2.lastVelocity;
          const precision = config2.precision || (from == to2 ? 5e-3 : Math.min(1, Math.abs(to2 - from) * 1e-3));
          const restVelocity = config2.restVelocity || precision / 10;
          const bounceFactor = config2.clamp ? 0 : config2.bounce;
          const canBounce = !is$1.und(bounceFactor);
          const isGrowing = from == to2 ? node2.v0 > 0 : from < to2;
          let isMoving;
          let isBouncing = false;
          const step = 1;
          const numSteps = Math.ceil(dt / step);
          for (let n2 = 0; n2 < numSteps; ++n2) {
            isMoving = Math.abs(velocity) > restVelocity;
            if (!isMoving) {
              finished = Math.abs(to2 - position3) <= precision;
              if (finished) {
                break;
              }
            }
            if (canBounce) {
              isBouncing = position3 == to2 || position3 > to2 == isGrowing;
              if (isBouncing) {
                velocity = -velocity * bounceFactor;
                position3 = to2;
              }
            }
            const springForce = -config2.tension * 1e-6 * (position3 - to2);
            const dampingForce = -config2.friction * 1e-3 * velocity;
            const acceleration = (springForce + dampingForce) / config2.mass;
            velocity = velocity + acceleration * step;
            position3 = position3 + velocity * step;
          }
        }
        node2.lastVelocity = velocity;
        if (Number.isNaN(position3)) {
          console.warn(`Got NaN while animating:`, this);
          finished = true;
        }
      }
      if (payload && !payload[i2].done) {
        finished = false;
      }
      if (finished) {
        node2.done = true;
      } else {
        idle2 = false;
      }
      if (node2.setValue(position3, config2.round)) {
        changed = true;
      }
    });
    const node = getAnimated(this);
    const currVal = node.getValue();
    if (idle2) {
      const finalVal = getFluidValue(anim.to);
      if ((currVal !== finalVal || changed) && !config2.decay) {
        node.setValue(finalVal);
        this._onChange(finalVal);
      } else if (changed && config2.decay) {
        this._onChange(currVal);
      }
      this._stop();
    } else if (changed) {
      this._onChange(currVal);
    }
  }
  set(value) {
    raf$2.batchedUpdates(() => {
      this._stop();
      this._focus(value);
      this._set(value);
    });
    return this;
  }
  pause() {
    this._update({
      pause: true
    });
  }
  resume() {
    this._update({
      pause: false
    });
  }
  finish() {
    if (isAnimating(this)) {
      const {
        to: to2,
        config: config2
      } = this.animation;
      raf$2.batchedUpdates(() => {
        this._onStart();
        if (!config2.decay) {
          this._set(to2, false);
        }
        this._stop();
      });
    }
    return this;
  }
  update(props) {
    const queue = this.queue || (this.queue = []);
    queue.push(props);
    return this;
  }
  start(to2, arg2) {
    let queue;
    if (!is$1.und(to2)) {
      queue = [is$1.obj(to2) ? to2 : _extends$h({}, arg2, {
        to: to2
      })];
    } else {
      queue = this.queue || [];
      this.queue = [];
    }
    return Promise.all(queue.map((props) => {
      const up = this._update(props);
      return up;
    })).then((results) => getCombinedResult(this, results));
  }
  stop(cancel) {
    const {
      to: to2
    } = this.animation;
    this._focus(this.get());
    stopAsync(this._state, cancel && this._lastCallId);
    raf$2.batchedUpdates(() => this._stop(to2, cancel));
    return this;
  }
  reset() {
    this._update({
      reset: true
    });
  }
  eventObserved(event) {
    if (event.type == "change") {
      this._start();
    } else if (event.type == "priority") {
      this.priority = event.priority + 1;
    }
  }
  _prepareNode(props) {
    const key = this.key || "";
    let {
      to: to2,
      from
    } = props;
    to2 = is$1.obj(to2) ? to2[key] : to2;
    if (to2 == null || isAsyncTo(to2)) {
      to2 = void 0;
    }
    from = is$1.obj(from) ? from[key] : from;
    if (from == null) {
      from = void 0;
    }
    const range = {
      to: to2,
      from
    };
    if (!hasAnimated(this)) {
      if (props.reverse)
        [to2, from] = [from, to2];
      from = getFluidValue(from);
      if (!is$1.und(from)) {
        this._set(from);
      } else if (!getAnimated(this)) {
        this._set(to2);
      }
    }
    return range;
  }
  _update(_ref, isLoop) {
    let props = _extends$h({}, _ref);
    const {
      key,
      defaultProps: defaultProps2
    } = this;
    if (props.default)
      Object.assign(defaultProps2, getDefaultProps(props, (value, prop) => /^on/.test(prop) ? resolveProp(value, key) : value));
    mergeActiveFn(this, props, "onProps");
    sendEvent(this, "onProps", props, this);
    const range = this._prepareNode(props);
    if (Object.isFrozen(this)) {
      throw Error("Cannot animate a `SpringValue` object that is frozen. Did you forget to pass your component to `animated(...)` before animating its props?");
    }
    const state = this._state;
    return scheduleProps(++this._lastCallId, {
      key,
      props,
      defaultProps: defaultProps2,
      state,
      actions: {
        pause: () => {
          if (!isPaused(this)) {
            setPausedBit(this, true);
            flushCalls(state.pauseQueue);
            sendEvent(this, "onPause", getFinishedResult(this, checkFinished(this, this.animation.to)), this);
          }
        },
        resume: () => {
          if (isPaused(this)) {
            setPausedBit(this, false);
            if (isAnimating(this)) {
              this._resume();
            }
            flushCalls(state.resumeQueue);
            sendEvent(this, "onResume", getFinishedResult(this, checkFinished(this, this.animation.to)), this);
          }
        },
        start: this._merge.bind(this, range)
      }
    }).then((result) => {
      if (props.loop && result.finished && !(isLoop && result.noop)) {
        const nextProps = createLoopUpdate(props);
        if (nextProps) {
          return this._update(nextProps, true);
        }
      }
      return result;
    });
  }
  _merge(range, props, resolve) {
    if (props.cancel) {
      this.stop(true);
      return resolve(getCancelledResult(this));
    }
    const hasToProp = !is$1.und(range.to);
    const hasFromProp = !is$1.und(range.from);
    if (hasToProp || hasFromProp) {
      if (props.callId > this._lastToId) {
        this._lastToId = props.callId;
      } else {
        return resolve(getCancelledResult(this));
      }
    }
    const {
      key,
      defaultProps: defaultProps2,
      animation: anim
    } = this;
    const {
      to: prevTo,
      from: prevFrom
    } = anim;
    let {
      to: to2 = prevTo,
      from = prevFrom
    } = range;
    if (hasFromProp && !hasToProp && (!props.default || is$1.und(to2))) {
      to2 = from;
    }
    if (props.reverse)
      [to2, from] = [from, to2];
    const hasFromChanged = !isEqual$7(from, prevFrom);
    if (hasFromChanged) {
      anim.from = from;
    }
    from = getFluidValue(from);
    const hasToChanged = !isEqual$7(to2, prevTo);
    if (hasToChanged) {
      this._focus(to2);
    }
    const hasAsyncTo = isAsyncTo(props.to);
    const {
      config: config2
    } = anim;
    const {
      decay,
      velocity
    } = config2;
    if (hasToProp || hasFromProp) {
      config2.velocity = 0;
    }
    if (props.config && !hasAsyncTo) {
      mergeConfig$3(config2, callProp(props.config, key), props.config !== defaultProps2.config ? callProp(defaultProps2.config, key) : void 0);
    }
    let node = getAnimated(this);
    if (!node || is$1.und(to2)) {
      return resolve(getFinishedResult(this, true));
    }
    const reset = is$1.und(props.reset) ? hasFromProp && !props.default : !is$1.und(from) && matchProp(props.reset, key);
    const value = reset ? from : this.get();
    const goal = computeGoal(to2);
    const isAnimatable = is$1.num(goal) || is$1.arr(goal) || isAnimatedString(goal);
    const immediate2 = !hasAsyncTo && (!isAnimatable || matchProp(defaultProps2.immediate || props.immediate, key));
    if (hasToChanged) {
      const nodeType = getAnimatedType(to2);
      if (nodeType !== node.constructor) {
        if (immediate2) {
          node = this._set(goal);
        } else
          throw Error(`Cannot animate between ${node.constructor.name} and ${nodeType.name}, as the "to" prop suggests`);
      }
    }
    const goalType = node.constructor;
    let started = hasFluidValue(to2);
    let finished = false;
    if (!started) {
      const hasValueChanged = reset || !hasAnimated(this) && hasFromChanged;
      if (hasToChanged || hasValueChanged) {
        finished = isEqual$7(computeGoal(value), goal);
        started = !finished;
      }
      if (!isEqual$7(anim.immediate, immediate2) && !immediate2 || !isEqual$7(config2.decay, decay) || !isEqual$7(config2.velocity, velocity)) {
        started = true;
      }
    }
    if (finished && isAnimating(this)) {
      if (anim.changed && !reset) {
        started = true;
      } else if (!started) {
        this._stop(prevTo);
      }
    }
    if (!hasAsyncTo) {
      if (started || hasFluidValue(prevTo)) {
        anim.values = node.getPayload();
        anim.toValues = hasFluidValue(to2) ? null : goalType == AnimatedString ? [1] : toArray$8(goal);
      }
      if (anim.immediate != immediate2) {
        anim.immediate = immediate2;
        if (!immediate2 && !reset) {
          this._set(prevTo);
        }
      }
      if (started) {
        const {
          onRest
        } = anim;
        each$1(ACTIVE_EVENTS, (type) => mergeActiveFn(this, props, type));
        const result = getFinishedResult(this, checkFinished(this, prevTo));
        flushCalls(this._pendingCalls, result);
        this._pendingCalls.add(resolve);
        if (anim.changed)
          raf$2.batchedUpdates(() => {
            anim.changed = !reset;
            onRest == null ? void 0 : onRest(result, this);
            if (reset) {
              callProp(defaultProps2.onRest, result);
            } else {
              anim.onStart == null ? void 0 : anim.onStart(result, this);
            }
          });
      }
    }
    if (reset) {
      this._set(value);
    }
    if (hasAsyncTo) {
      resolve(runAsync(props.to, props, this._state, this));
    } else if (started) {
      this._start();
    } else if (isAnimating(this) && !hasToChanged) {
      this._pendingCalls.add(resolve);
    } else {
      resolve(getNoopResult(value));
    }
  }
  _focus(value) {
    const anim = this.animation;
    if (value !== anim.to) {
      if (getFluidObservers(this)) {
        this._detach();
      }
      anim.to = value;
      if (getFluidObservers(this)) {
        this._attach();
      }
    }
  }
  _attach() {
    let priority2 = 0;
    const {
      to: to2
    } = this.animation;
    if (hasFluidValue(to2)) {
      addFluidObserver(to2, this);
      if (isFrameValue(to2)) {
        priority2 = to2.priority + 1;
      }
    }
    this.priority = priority2;
  }
  _detach() {
    const {
      to: to2
    } = this.animation;
    if (hasFluidValue(to2)) {
      removeFluidObserver(to2, this);
    }
  }
  _set(arg, idle2 = true) {
    const value = getFluidValue(arg);
    if (!is$1.und(value)) {
      const oldNode = getAnimated(this);
      if (!oldNode || !isEqual$7(value, oldNode.getValue())) {
        const nodeType = getAnimatedType(value);
        if (!oldNode || oldNode.constructor != nodeType) {
          setAnimated(this, nodeType.create(value));
        } else {
          oldNode.setValue(value);
        }
        if (oldNode) {
          raf$2.batchedUpdates(() => {
            this._onChange(value, idle2);
          });
        }
      }
    }
    return getAnimated(this);
  }
  _onStart() {
    const anim = this.animation;
    if (!anim.changed) {
      anim.changed = true;
      sendEvent(this, "onStart", getFinishedResult(this, checkFinished(this, anim.to)), this);
    }
  }
  _onChange(value, idle2) {
    if (!idle2) {
      this._onStart();
      callProp(this.animation.onChange, value, this);
    }
    callProp(this.defaultProps.onChange, value, this);
    super._onChange(value, idle2);
  }
  _start() {
    const anim = this.animation;
    getAnimated(this).reset(getFluidValue(anim.to));
    if (!anim.immediate) {
      anim.fromValues = anim.values.map((node) => node.lastPosition);
    }
    if (!isAnimating(this)) {
      setActiveBit(this, true);
      if (!isPaused(this)) {
        this._resume();
      }
    }
  }
  _resume() {
    if (globals.skipAnimation) {
      this.finish();
    } else {
      frameLoop.start(this);
    }
  }
  _stop(goal, cancel) {
    if (isAnimating(this)) {
      setActiveBit(this, false);
      const anim = this.animation;
      each$1(anim.values, (node) => {
        node.done = true;
      });
      if (anim.toValues) {
        anim.onChange = anim.onPause = anim.onResume = void 0;
      }
      callFluidObservers(this, {
        type: "idle",
        parent: this
      });
      const result = cancel ? getCancelledResult(this.get()) : getFinishedResult(this.get(), checkFinished(this, goal != null ? goal : anim.to));
      flushCalls(this._pendingCalls, result);
      if (anim.changed) {
        anim.changed = false;
        sendEvent(this, "onRest", result, this);
      }
    }
  }
}
function checkFinished(target, to2) {
  const goal = computeGoal(to2);
  const value = computeGoal(target.get());
  return isEqual$7(value, goal);
}
function createLoopUpdate(props, loop2 = props.loop, to2 = props.to) {
  let loopRet = callProp(loop2);
  if (loopRet) {
    const overrides = loopRet !== true && inferTo(loopRet);
    const reverse = (overrides || props).reverse;
    const reset = !overrides || overrides.reset;
    return createUpdate(_extends$h({}, props, {
      loop: loop2,
      default: false,
      pause: void 0,
      to: !reverse || isAsyncTo(to2) ? to2 : void 0,
      from: reset ? props.from : void 0,
      reset
    }, overrides));
  }
}
function createUpdate(props) {
  const {
    to: to2,
    from
  } = props = inferTo(props);
  const keys2 = /* @__PURE__ */ new Set();
  if (is$1.obj(to2))
    findDefined(to2, keys2);
  if (is$1.obj(from))
    findDefined(from, keys2);
  props.keys = keys2.size ? Array.from(keys2) : null;
  return props;
}
function declareUpdate(props) {
  const update2 = createUpdate(props);
  if (is$1.und(update2.default)) {
    update2.default = getDefaultProps(update2);
  }
  return update2;
}
function findDefined(values2, keys2) {
  eachProp(values2, (value, key) => value != null && keys2.add(key));
}
const ACTIVE_EVENTS = ["onStart", "onRest", "onChange", "onPause", "onResume"];
function mergeActiveFn(target, props, type) {
  target.animation[type] = props[type] !== getDefaultProp(props, type) ? resolveProp(props[type], target.key) : void 0;
}
function sendEvent(target, type, ...args) {
  var _target$animation$typ, _target$animation, _target$defaultProps$, _target$defaultProps;
  (_target$animation$typ = (_target$animation = target.animation)[type]) == null ? void 0 : _target$animation$typ.call(_target$animation, ...args);
  (_target$defaultProps$ = (_target$defaultProps = target.defaultProps)[type]) == null ? void 0 : _target$defaultProps$.call(_target$defaultProps, ...args);
}
const BATCHED_EVENTS = ["onStart", "onChange", "onRest"];
let nextId = 1;
class Controller {
  constructor(props, flush3) {
    this.id = nextId++;
    this.springs = {};
    this.queue = [];
    this.ref = void 0;
    this._flush = void 0;
    this._initialProps = void 0;
    this._lastAsyncId = 0;
    this._active = /* @__PURE__ */ new Set();
    this._changed = /* @__PURE__ */ new Set();
    this._started = false;
    this._item = void 0;
    this._state = {
      paused: false,
      pauseQueue: /* @__PURE__ */ new Set(),
      resumeQueue: /* @__PURE__ */ new Set(),
      timeouts: /* @__PURE__ */ new Set()
    };
    this._events = {
      onStart: /* @__PURE__ */ new Map(),
      onChange: /* @__PURE__ */ new Map(),
      onRest: /* @__PURE__ */ new Map()
    };
    this._onFrame = this._onFrame.bind(this);
    if (flush3) {
      this._flush = flush3;
    }
    if (props) {
      this.start(_extends$h({
        default: true
      }, props));
    }
  }
  get idle() {
    return !this._state.asyncTo && Object.values(this.springs).every((spring) => {
      return spring.idle && !spring.isDelayed && !spring.isPaused;
    });
  }
  get item() {
    return this._item;
  }
  set item(item2) {
    this._item = item2;
  }
  get() {
    const values2 = {};
    this.each((spring, key) => values2[key] = spring.get());
    return values2;
  }
  set(values2) {
    for (const key in values2) {
      const value = values2[key];
      if (!is$1.und(value)) {
        this.springs[key].set(value);
      }
    }
  }
  update(props) {
    if (props) {
      this.queue.push(createUpdate(props));
    }
    return this;
  }
  start(props) {
    let {
      queue
    } = this;
    if (props) {
      queue = toArray$8(props).map(createUpdate);
    } else {
      this.queue = [];
    }
    if (this._flush) {
      return this._flush(this, queue);
    }
    prepareKeys(this, queue);
    return flushUpdateQueue(this, queue);
  }
  stop(arg, keys2) {
    if (arg !== !!arg) {
      keys2 = arg;
    }
    if (keys2) {
      const springs = this.springs;
      each$1(toArray$8(keys2), (key) => springs[key].stop(!!arg));
    } else {
      stopAsync(this._state, this._lastAsyncId);
      this.each((spring) => spring.stop(!!arg));
    }
    return this;
  }
  pause(keys2) {
    if (is$1.und(keys2)) {
      this.start({
        pause: true
      });
    } else {
      const springs = this.springs;
      each$1(toArray$8(keys2), (key) => springs[key].pause());
    }
    return this;
  }
  resume(keys2) {
    if (is$1.und(keys2)) {
      this.start({
        pause: false
      });
    } else {
      const springs = this.springs;
      each$1(toArray$8(keys2), (key) => springs[key].resume());
    }
    return this;
  }
  each(iterator) {
    eachProp(this.springs, iterator);
  }
  _onFrame() {
    const {
      onStart,
      onChange: onChange2,
      onRest
    } = this._events;
    const active3 = this._active.size > 0;
    const changed = this._changed.size > 0;
    if (active3 && !this._started || changed && !this._started) {
      this._started = true;
      flush$1(onStart, ([onStart2, result]) => {
        result.value = this.get();
        onStart2(result, this, this._item);
      });
    }
    const idle2 = !active3 && this._started;
    const values2 = changed || idle2 && onRest.size ? this.get() : null;
    if (changed && onChange2.size) {
      flush$1(onChange2, ([onChange3, result]) => {
        result.value = values2;
        onChange3(result, this, this._item);
      });
    }
    if (idle2) {
      this._started = false;
      flush$1(onRest, ([onRest2, result]) => {
        result.value = values2;
        onRest2(result, this, this._item);
      });
    }
  }
  eventObserved(event) {
    if (event.type == "change") {
      this._changed.add(event.parent);
      if (!event.idle) {
        this._active.add(event.parent);
      }
    } else if (event.type == "idle") {
      this._active.delete(event.parent);
    } else
      return;
    raf$2.onFrame(this._onFrame);
  }
}
function flushUpdateQueue(ctrl, queue) {
  return Promise.all(queue.map((props) => flushUpdate(ctrl, props))).then((results) => getCombinedResult(ctrl, results));
}
async function flushUpdate(ctrl, props, isLoop) {
  const {
    keys: keys2,
    to: to2,
    from,
    loop: loop2,
    onRest,
    onResolve
  } = props;
  const defaults2 = is$1.obj(props.default) && props.default;
  if (loop2) {
    props.loop = false;
  }
  if (to2 === false)
    props.to = null;
  if (from === false)
    props.from = null;
  const asyncTo = is$1.arr(to2) || is$1.fun(to2) ? to2 : void 0;
  if (asyncTo) {
    props.to = void 0;
    props.onRest = void 0;
    if (defaults2) {
      defaults2.onRest = void 0;
    }
  } else {
    each$1(BATCHED_EVENTS, (key) => {
      const handler = props[key];
      if (is$1.fun(handler)) {
        const queue = ctrl["_events"][key];
        props[key] = ({
          finished,
          cancelled
        }) => {
          const result2 = queue.get(handler);
          if (result2) {
            if (!finished)
              result2.finished = false;
            if (cancelled)
              result2.cancelled = true;
          } else {
            queue.set(handler, {
              value: null,
              finished: finished || false,
              cancelled: cancelled || false
            });
          }
        };
        if (defaults2) {
          defaults2[key] = props[key];
        }
      }
    });
  }
  const state = ctrl["_state"];
  if (props.pause === !state.paused) {
    state.paused = props.pause;
    flushCalls(props.pause ? state.pauseQueue : state.resumeQueue);
  } else if (state.paused) {
    props.pause = true;
  }
  const promises = (keys2 || Object.keys(ctrl.springs)).map((key) => ctrl.springs[key].start(props));
  const cancel = props.cancel === true || getDefaultProp(props, "cancel") === true;
  if (asyncTo || cancel && state.asyncId) {
    promises.push(scheduleProps(++ctrl["_lastAsyncId"], {
      props,
      state,
      actions: {
        pause: noop$8,
        resume: noop$8,
        start(props2, resolve) {
          if (cancel) {
            stopAsync(state, ctrl["_lastAsyncId"]);
            resolve(getCancelledResult(ctrl));
          } else {
            props2.onRest = onRest;
            resolve(runAsync(asyncTo, props2, state, ctrl));
          }
        }
      }
    }));
  }
  if (state.paused) {
    await new Promise((resume) => {
      state.resumeQueue.add(resume);
    });
  }
  const result = getCombinedResult(ctrl, await Promise.all(promises));
  if (loop2 && result.finished && !(isLoop && result.noop)) {
    const nextProps = createLoopUpdate(props, loop2, to2);
    if (nextProps) {
      prepareKeys(ctrl, [nextProps]);
      return flushUpdate(ctrl, nextProps, true);
    }
  }
  if (onResolve) {
    raf$2.batchedUpdates(() => onResolve(result, ctrl, ctrl.item));
  }
  return result;
}
function getSprings(ctrl, props) {
  const springs = _extends$h({}, ctrl.springs);
  if (props) {
    each$1(toArray$8(props), (props2) => {
      if (is$1.und(props2.keys)) {
        props2 = createUpdate(props2);
      }
      if (!is$1.obj(props2.to)) {
        props2 = _extends$h({}, props2, {
          to: void 0
        });
      }
      prepareSprings(springs, props2, (key) => {
        return createSpring(key);
      });
    });
  }
  setSprings(ctrl, springs);
  return springs;
}
function setSprings(ctrl, springs) {
  eachProp(springs, (spring, key) => {
    if (!ctrl.springs[key]) {
      ctrl.springs[key] = spring;
      addFluidObserver(spring, ctrl);
    }
  });
}
function createSpring(key, observer) {
  const spring = new SpringValue();
  spring.key = key;
  if (observer) {
    addFluidObserver(spring, observer);
  }
  return spring;
}
function prepareSprings(springs, props, create2) {
  if (props.keys) {
    each$1(props.keys, (key) => {
      const spring = springs[key] || (springs[key] = create2(key));
      spring["_prepareNode"](props);
    });
  }
}
function prepareKeys(ctrl, queue) {
  each$1(queue, (props) => {
    prepareSprings(ctrl.springs, props, (key) => {
      return createSpring(key, ctrl);
    });
  });
}
function _objectWithoutPropertiesLoose$4(source2, excluded) {
  if (source2 == null)
    return {};
  var target = {};
  var sourceKeys = Object.keys(source2);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0)
      continue;
    target[key] = source2[key];
  }
  return target;
}
const _excluded$3$1 = ["children"];
const SpringContext = (_ref) => {
  let {
    children
  } = _ref, props = _objectWithoutPropertiesLoose$4(_ref, _excluded$3$1);
  const inherited = useContext$1(ctx);
  const pause = props.pause || !!inherited.pause, immediate2 = props.immediate || !!inherited.immediate;
  props = useMemoOne$1(() => ({
    pause,
    immediate: immediate2
  }), [pause, immediate2]);
  const {
    Provider: Provider2
  } = ctx;
  return React$4.createElement(Provider2, {
    value: props
  }, children);
};
const ctx = makeContext(SpringContext, {});
SpringContext.Provider = ctx.Provider;
SpringContext.Consumer = ctx.Consumer;
function makeContext(target, init) {
  Object.assign(target, React$4.createContext(init));
  target.Provider._context = target;
  target.Consumer._context = target;
  return target;
}
const SpringRef = () => {
  const current = [];
  const SpringRef2 = function SpringRef3(props) {
    deprecateDirectCall();
    const results = [];
    each$1(current, (ctrl, i2) => {
      if (is$1.und(props)) {
        results.push(ctrl.start());
      } else {
        const update2 = _getProps(props, ctrl, i2);
        if (update2) {
          results.push(ctrl.start(update2));
        }
      }
    });
    return results;
  };
  SpringRef2.current = current;
  SpringRef2.add = function(ctrl) {
    if (!current.includes(ctrl)) {
      current.push(ctrl);
    }
  };
  SpringRef2.delete = function(ctrl) {
    const i2 = current.indexOf(ctrl);
    if (~i2)
      current.splice(i2, 1);
  };
  SpringRef2.pause = function() {
    each$1(current, (ctrl) => ctrl.pause(...arguments));
    return this;
  };
  SpringRef2.resume = function() {
    each$1(current, (ctrl) => ctrl.resume(...arguments));
    return this;
  };
  SpringRef2.set = function(values2) {
    each$1(current, (ctrl) => ctrl.set(values2));
  };
  SpringRef2.start = function(props) {
    const results = [];
    each$1(current, (ctrl, i2) => {
      if (is$1.und(props)) {
        results.push(ctrl.start());
      } else {
        const update2 = this._getProps(props, ctrl, i2);
        if (update2) {
          results.push(ctrl.start(update2));
        }
      }
    });
    return results;
  };
  SpringRef2.stop = function() {
    each$1(current, (ctrl) => ctrl.stop(...arguments));
    return this;
  };
  SpringRef2.update = function(props) {
    each$1(current, (ctrl, i2) => ctrl.update(this._getProps(props, ctrl, i2)));
    return this;
  };
  const _getProps = function _getProps2(arg, ctrl, index2) {
    return is$1.fun(arg) ? arg(index2, ctrl) : arg;
  };
  SpringRef2._getProps = _getProps;
  return SpringRef2;
};
function useSprings(length, props, deps) {
  const propsFn = is$1.fun(props) && props;
  if (propsFn && !deps)
    deps = [];
  const ref = useMemo$3(() => propsFn || arguments.length == 3 ? SpringRef() : void 0, []);
  const layoutId = useRef(0);
  const forceUpdate = useForceUpdate$1();
  const state = useMemo$3(() => ({
    ctrls: [],
    queue: [],
    flush(ctrl, updates2) {
      const springs2 = getSprings(ctrl, updates2);
      const canFlushSync = layoutId.current > 0 && !state.queue.length && !Object.keys(springs2).some((key) => !ctrl.springs[key]);
      return canFlushSync ? flushUpdateQueue(ctrl, updates2) : new Promise((resolve) => {
        setSprings(ctrl, springs2);
        state.queue.push(() => {
          resolve(flushUpdateQueue(ctrl, updates2));
        });
        forceUpdate();
      });
    }
  }), []);
  const ctrls = useRef([...state.ctrls]);
  const updates = [];
  const prevLength = usePrev(length) || 0;
  useMemo$3(() => {
    each$1(ctrls.current.slice(length, prevLength), (ctrl) => {
      detachRefs(ctrl, ref);
      ctrl.stop(true);
    });
    ctrls.current.length = length;
    declareUpdates(prevLength, length);
  }, [length]);
  useMemo$3(() => {
    declareUpdates(0, Math.min(prevLength, length));
  }, deps);
  function declareUpdates(startIndex, endIndex) {
    for (let i2 = startIndex; i2 < endIndex; i2++) {
      const ctrl = ctrls.current[i2] || (ctrls.current[i2] = new Controller(null, state.flush));
      const update2 = propsFn ? propsFn(i2, ctrl) : props[i2];
      if (update2) {
        updates[i2] = declareUpdate(update2);
      }
    }
  }
  const springs = ctrls.current.map((ctrl, i2) => getSprings(ctrl, updates[i2]));
  const context2 = useContext$1(SpringContext);
  const prevContext = usePrev(context2);
  const hasContext = context2 !== prevContext && hasProps(context2);
  useLayoutEffect$5(() => {
    layoutId.current++;
    state.ctrls = ctrls.current;
    const {
      queue
    } = state;
    if (queue.length) {
      state.queue = [];
      each$1(queue, (cb) => cb());
    }
    each$1(ctrls.current, (ctrl, i2) => {
      ref == null ? void 0 : ref.add(ctrl);
      if (hasContext) {
        ctrl.start({
          default: context2
        });
      }
      const update2 = updates[i2];
      if (update2) {
        replaceRef(ctrl, update2.ref);
        if (ctrl.ref) {
          ctrl.queue.push(update2);
        } else {
          ctrl.start(update2);
        }
      }
    });
  });
  useOnce(() => () => {
    each$1(state.ctrls, (ctrl) => ctrl.stop(true));
  });
  const values2 = springs.map((x2) => _extends$h({}, x2));
  return ref ? [values2, ref] : values2;
}
function useSpring(props, deps) {
  const isFn = is$1.fun(props);
  const [[values2], ref] = useSprings(1, isFn ? props : [props], isFn ? deps || [] : deps);
  return isFn || arguments.length == 2 ? [values2, ref] : values2;
}
let TransitionPhase;
(function(TransitionPhase2) {
  TransitionPhase2["MOUNT"] = "mount";
  TransitionPhase2["ENTER"] = "enter";
  TransitionPhase2["UPDATE"] = "update";
  TransitionPhase2["LEAVE"] = "leave";
})(TransitionPhase || (TransitionPhase = {}));
function useTransition(data2, props, deps) {
  const propsFn = is$1.fun(props) && props;
  const {
    reset,
    sort,
    trail = 0,
    expires = true,
    exitBeforeEnter = false,
    onDestroyed,
    ref: propsRef,
    config: propsConfig
  } = propsFn ? propsFn() : props;
  const ref = useMemo$3(() => propsFn || arguments.length == 3 ? SpringRef() : void 0, []);
  const items2 = toArray$8(data2);
  const transitions2 = [];
  const usedTransitions = useRef(null);
  const prevTransitions = reset ? null : usedTransitions.current;
  useLayoutEffect$5(() => {
    usedTransitions.current = transitions2;
  });
  useOnce(() => () => {
    each$1(usedTransitions.current, (t3) => {
      if (t3.expired) {
        clearTimeout(t3.expirationId);
      }
      detachRefs(t3.ctrl, ref);
      t3.ctrl.stop(true);
    });
  });
  const keys2 = getKeys(items2, propsFn ? propsFn() : props, prevTransitions);
  const expired = reset && usedTransitions.current || [];
  useLayoutEffect$5(() => each$1(expired, ({
    ctrl,
    item: item2,
    key
  }) => {
    detachRefs(ctrl, ref);
    callProp(onDestroyed, item2, key);
  }));
  const reused = [];
  if (prevTransitions)
    each$1(prevTransitions, (t3, i2) => {
      if (t3.expired) {
        clearTimeout(t3.expirationId);
        expired.push(t3);
      } else {
        i2 = reused[i2] = keys2.indexOf(t3.key);
        if (~i2)
          transitions2[i2] = t3;
      }
    });
  each$1(items2, (item2, i2) => {
    if (!transitions2[i2]) {
      transitions2[i2] = {
        key: keys2[i2],
        item: item2,
        phase: TransitionPhase.MOUNT,
        ctrl: new Controller()
      };
      transitions2[i2].ctrl.item = item2;
    }
  });
  if (reused.length) {
    let i2 = -1;
    const {
      leave
    } = propsFn ? propsFn() : props;
    each$1(reused, (keyIndex, prevIndex) => {
      const t3 = prevTransitions[prevIndex];
      if (~keyIndex) {
        i2 = transitions2.indexOf(t3);
        transitions2[i2] = _extends$h({}, t3, {
          item: items2[keyIndex]
        });
      } else if (leave) {
        transitions2.splice(++i2, 0, t3);
      }
    });
  }
  if (is$1.fun(sort)) {
    transitions2.sort((a3, b3) => sort(a3.item, b3.item));
  }
  let delay = -trail;
  const forceUpdate = useForceUpdate$1();
  const defaultProps2 = getDefaultProps(props);
  const changes = /* @__PURE__ */ new Map();
  const exitingTransitions = useRef(/* @__PURE__ */ new Map());
  const forceChange = useRef(false);
  each$1(transitions2, (t3, i2) => {
    const key = t3.key;
    const prevPhase = t3.phase;
    const p2 = propsFn ? propsFn() : props;
    let to2;
    let phase;
    let propsDelay = callProp(p2.delay || 0, key);
    if (prevPhase == TransitionPhase.MOUNT) {
      to2 = p2.enter;
      phase = TransitionPhase.ENTER;
    } else {
      const isLeave = keys2.indexOf(key) < 0;
      if (prevPhase != TransitionPhase.LEAVE) {
        if (isLeave) {
          to2 = p2.leave;
          phase = TransitionPhase.LEAVE;
        } else if (to2 = p2.update) {
          phase = TransitionPhase.UPDATE;
        } else
          return;
      } else if (!isLeave) {
        to2 = p2.enter;
        phase = TransitionPhase.ENTER;
      } else
        return;
    }
    to2 = callProp(to2, t3.item, i2);
    to2 = is$1.obj(to2) ? inferTo(to2) : {
      to: to2
    };
    if (!to2.config) {
      const config2 = propsConfig || defaultProps2.config;
      to2.config = callProp(config2, t3.item, i2, phase);
    }
    delay += trail;
    const payload = _extends$h({}, defaultProps2, {
      delay: propsDelay + delay,
      ref: propsRef,
      immediate: p2.immediate,
      reset: false
    }, to2);
    if (phase == TransitionPhase.ENTER && is$1.und(payload.from)) {
      const _p = propsFn ? propsFn() : props;
      const from = is$1.und(_p.initial) || prevTransitions ? _p.from : _p.initial;
      payload.from = callProp(from, t3.item, i2);
    }
    const {
      onResolve
    } = payload;
    payload.onResolve = (result) => {
      callProp(onResolve, result);
      const transitions3 = usedTransitions.current;
      const t4 = transitions3.find((t5) => t5.key === key);
      if (!t4)
        return;
      if (result.cancelled && t4.phase != TransitionPhase.UPDATE) {
        return;
      }
      if (t4.ctrl.idle) {
        const idle2 = transitions3.every((t5) => t5.ctrl.idle);
        if (t4.phase == TransitionPhase.LEAVE) {
          const expiry = callProp(expires, t4.item);
          if (expiry !== false) {
            const expiryMs = expiry === true ? 0 : expiry;
            t4.expired = true;
            if (!idle2 && expiryMs > 0) {
              if (expiryMs <= 2147483647)
                t4.expirationId = setTimeout(forceUpdate, expiryMs);
              return;
            }
          }
        }
        if (idle2 && transitions3.some((t5) => t5.expired)) {
          exitingTransitions.current.delete(t4);
          if (exitBeforeEnter) {
            forceChange.current = true;
          }
          forceUpdate();
        }
      }
    };
    const springs = getSprings(t3.ctrl, payload);
    if (phase === TransitionPhase.LEAVE && exitBeforeEnter) {
      exitingTransitions.current.set(t3, {
        phase,
        springs,
        payload
      });
    } else {
      changes.set(t3, {
        phase,
        springs,
        payload
      });
    }
  });
  const context2 = useContext$1(SpringContext);
  const prevContext = usePrev(context2);
  const hasContext = context2 !== prevContext && hasProps(context2);
  useLayoutEffect$5(() => {
    if (hasContext) {
      each$1(transitions2, (t3) => {
        t3.ctrl.start({
          default: context2
        });
      });
    }
  }, [context2]);
  each$1(changes, (_, t3) => {
    if (exitingTransitions.current.size) {
      const ind = transitions2.findIndex((state) => state.key === t3.key);
      transitions2.splice(ind, 1);
    }
  });
  useLayoutEffect$5(() => {
    each$1(exitingTransitions.current.size ? exitingTransitions.current : changes, ({
      phase,
      payload
    }, t3) => {
      const {
        ctrl
      } = t3;
      t3.phase = phase;
      ref == null ? void 0 : ref.add(ctrl);
      if (hasContext && phase == TransitionPhase.ENTER) {
        ctrl.start({
          default: context2
        });
      }
      if (payload) {
        replaceRef(ctrl, payload.ref);
        if (ctrl.ref && !forceChange.current) {
          ctrl.update(payload);
        } else {
          ctrl.start(payload);
          if (forceChange.current) {
            forceChange.current = false;
          }
        }
      }
    });
  }, reset ? void 0 : deps);
  const renderTransitions = (render4) => React$4.createElement(React$4.Fragment, null, transitions2.map((t3, i2) => {
    const {
      springs
    } = changes.get(t3) || t3.ctrl;
    const elem = render4(_extends$h({}, springs), t3.item, t3, i2);
    return elem && elem.type ? React$4.createElement(elem.type, _extends$h({}, elem.props, {
      key: is$1.str(t3.key) || is$1.num(t3.key) ? t3.key : t3.ctrl.id,
      ref: elem.ref
    })) : elem;
  }));
  return ref ? [renderTransitions, ref] : renderTransitions;
}
let nextKey = 1;
function getKeys(items2, {
  key,
  keys: keys2 = key
}, prevTransitions) {
  if (keys2 === null) {
    const reused = /* @__PURE__ */ new Set();
    return items2.map((item2) => {
      const t3 = prevTransitions && prevTransitions.find((t4) => t4.item === item2 && t4.phase !== TransitionPhase.LEAVE && !reused.has(t4));
      if (t3) {
        reused.add(t3);
        return t3.key;
      }
      return nextKey++;
    });
  }
  return is$1.und(keys2) ? items2 : is$1.fun(keys2) ? items2.map(keys2) : toArray$8(keys2);
}
class Interpolation extends FrameValue {
  constructor(source2, args) {
    super();
    this.key = void 0;
    this.idle = true;
    this.calc = void 0;
    this._active = /* @__PURE__ */ new Set();
    this.source = source2;
    this.calc = createInterpolator(...args);
    const value = this._get();
    const nodeType = getAnimatedType(value);
    setAnimated(this, nodeType.create(value));
  }
  advance(_dt) {
    const value = this._get();
    const oldValue = this.get();
    if (!isEqual$7(value, oldValue)) {
      getAnimated(this).setValue(value);
      this._onChange(value, this.idle);
    }
    if (!this.idle && checkIdle(this._active)) {
      becomeIdle(this);
    }
  }
  _get() {
    const inputs = is$1.arr(this.source) ? this.source.map(getFluidValue) : toArray$8(getFluidValue(this.source));
    return this.calc(...inputs);
  }
  _start() {
    if (this.idle && !checkIdle(this._active)) {
      this.idle = false;
      each$1(getPayload(this), (node) => {
        node.done = false;
      });
      if (globals.skipAnimation) {
        raf$2.batchedUpdates(() => this.advance());
        becomeIdle(this);
      } else {
        frameLoop.start(this);
      }
    }
  }
  _attach() {
    let priority2 = 1;
    each$1(toArray$8(this.source), (source2) => {
      if (hasFluidValue(source2)) {
        addFluidObserver(source2, this);
      }
      if (isFrameValue(source2)) {
        if (!source2.idle) {
          this._active.add(source2);
        }
        priority2 = Math.max(priority2, source2.priority + 1);
      }
    });
    this.priority = priority2;
    this._start();
  }
  _detach() {
    each$1(toArray$8(this.source), (source2) => {
      if (hasFluidValue(source2)) {
        removeFluidObserver(source2, this);
      }
    });
    this._active.clear();
    becomeIdle(this);
  }
  eventObserved(event) {
    if (event.type == "change") {
      if (event.idle) {
        this.advance();
      } else {
        this._active.add(event.parent);
        this._start();
      }
    } else if (event.type == "idle") {
      this._active.delete(event.parent);
    } else if (event.type == "priority") {
      this.priority = toArray$8(this.source).reduce((highest, parent) => Math.max(highest, (isFrameValue(parent) ? parent.priority : 0) + 1), 0);
    }
  }
}
function isIdle(source2) {
  return source2.idle !== false;
}
function checkIdle(active3) {
  return !active3.size || Array.from(active3).every(isIdle);
}
function becomeIdle(self2) {
  if (!self2.idle) {
    self2.idle = true;
    each$1(getPayload(self2), (node) => {
      node.done = true;
    });
    callFluidObservers(self2, {
      type: "idle",
      parent: self2
    });
  }
}
globals.assign({
  createStringInterpolator,
  to: (source2, args) => new Interpolation(source2, args)
});
function _objectWithoutPropertiesLoose$3(source2, excluded) {
  if (source2 == null)
    return {};
  var target = {};
  var sourceKeys = Object.keys(source2);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0)
      continue;
    target[key] = source2[key];
  }
  return target;
}
const _excluded$2$1 = ["style", "children", "scrollTop", "scrollLeft"];
const isCustomPropRE = /^--/;
function dangerousStyleValue(name2, value) {
  if (value == null || typeof value === "boolean" || value === "")
    return "";
  if (typeof value === "number" && value !== 0 && !isCustomPropRE.test(name2) && !(isUnitlessNumber.hasOwnProperty(name2) && isUnitlessNumber[name2]))
    return value + "px";
  return ("" + value).trim();
}
const attributeCache = {};
function applyAnimatedValues(instance, props) {
  if (!instance.nodeType || !instance.setAttribute) {
    return false;
  }
  const isFilterElement = instance.nodeName === "filter" || instance.parentNode && instance.parentNode.nodeName === "filter";
  const _ref = props, {
    style: style2,
    children,
    scrollTop,
    scrollLeft
  } = _ref, attributes2 = _objectWithoutPropertiesLoose$3(_ref, _excluded$2$1);
  const values2 = Object.values(attributes2);
  const names = Object.keys(attributes2).map((name2) => isFilterElement || instance.hasAttribute(name2) ? name2 : attributeCache[name2] || (attributeCache[name2] = name2.replace(/([A-Z])/g, (n2) => "-" + n2.toLowerCase())));
  if (children !== void 0) {
    instance.textContent = children;
  }
  for (let name2 in style2) {
    if (style2.hasOwnProperty(name2)) {
      const value = dangerousStyleValue(name2, style2[name2]);
      if (isCustomPropRE.test(name2)) {
        instance.style.setProperty(name2, value);
      } else {
        instance.style[name2] = value;
      }
    }
  }
  names.forEach((name2, i2) => {
    instance.setAttribute(name2, values2[i2]);
  });
  if (scrollTop !== void 0) {
    instance.scrollTop = scrollTop;
  }
  if (scrollLeft !== void 0) {
    instance.scrollLeft = scrollLeft;
  }
}
let isUnitlessNumber = {
  animationIterationCount: true,
  borderImageOutset: true,
  borderImageSlice: true,
  borderImageWidth: true,
  boxFlex: true,
  boxFlexGroup: true,
  boxOrdinalGroup: true,
  columnCount: true,
  columns: true,
  flex: true,
  flexGrow: true,
  flexPositive: true,
  flexShrink: true,
  flexNegative: true,
  flexOrder: true,
  gridRow: true,
  gridRowEnd: true,
  gridRowSpan: true,
  gridRowStart: true,
  gridColumn: true,
  gridColumnEnd: true,
  gridColumnSpan: true,
  gridColumnStart: true,
  fontWeight: true,
  lineClamp: true,
  lineHeight: true,
  opacity: true,
  order: true,
  orphans: true,
  tabSize: true,
  widows: true,
  zIndex: true,
  zoom: true,
  fillOpacity: true,
  floodOpacity: true,
  stopOpacity: true,
  strokeDasharray: true,
  strokeDashoffset: true,
  strokeMiterlimit: true,
  strokeOpacity: true,
  strokeWidth: true
};
const prefixKey = (prefix2, key) => prefix2 + key.charAt(0).toUpperCase() + key.substring(1);
const prefixes = ["Webkit", "Ms", "Moz", "O"];
isUnitlessNumber = Object.keys(isUnitlessNumber).reduce((acc, prop) => {
  prefixes.forEach((prefix2) => acc[prefixKey(prefix2, prop)] = acc[prop]);
  return acc;
}, isUnitlessNumber);
const _excluded$1$1 = ["x", "y", "z"];
const domTransforms = /^(matrix|translate|scale|rotate|skew)/;
const pxTransforms = /^(translate)/;
const degTransforms = /^(rotate|skew)/;
const addUnit = (value, unit) => is$1.num(value) && value !== 0 ? value + unit : value;
const isValueIdentity = (value, id) => is$1.arr(value) ? value.every((v2) => isValueIdentity(v2, id)) : is$1.num(value) ? value === id : parseFloat(value) === id;
class AnimatedStyle extends AnimatedObject {
  constructor(_ref) {
    let {
      x: x2,
      y: y4,
      z: z3
    } = _ref, style2 = _objectWithoutPropertiesLoose$3(_ref, _excluded$1$1);
    const inputs = [];
    const transforms2 = [];
    if (x2 || y4 || z3) {
      inputs.push([x2 || 0, y4 || 0, z3 || 0]);
      transforms2.push((xyz) => [`translate3d(${xyz.map((v2) => addUnit(v2, "px")).join(",")})`, isValueIdentity(xyz, 0)]);
    }
    eachProp(style2, (value, key) => {
      if (key === "transform") {
        inputs.push([value || ""]);
        transforms2.push((transform2) => [transform2, transform2 === ""]);
      } else if (domTransforms.test(key)) {
        delete style2[key];
        if (is$1.und(value))
          return;
        const unit = pxTransforms.test(key) ? "px" : degTransforms.test(key) ? "deg" : "";
        inputs.push(toArray$8(value));
        transforms2.push(key === "rotate3d" ? ([x3, y5, z4, deg]) => [`rotate3d(${x3},${y5},${z4},${addUnit(deg, unit)})`, isValueIdentity(deg, 0)] : (input2) => [`${key}(${input2.map((v2) => addUnit(v2, unit)).join(",")})`, isValueIdentity(input2, key.startsWith("scale") ? 1 : 0)]);
      }
    });
    if (inputs.length) {
      style2.transform = new FluidTransform(inputs, transforms2);
    }
    super(style2);
  }
}
class FluidTransform extends FluidValue {
  constructor(inputs, transforms2) {
    super();
    this._value = null;
    this.inputs = inputs;
    this.transforms = transforms2;
  }
  get() {
    return this._value || (this._value = this._get());
  }
  _get() {
    let transform2 = "";
    let identity2 = true;
    each$1(this.inputs, (input2, i2) => {
      const arg1 = getFluidValue(input2[0]);
      const [t3, id] = this.transforms[i2](is$1.arr(arg1) ? arg1 : input2.map(getFluidValue));
      transform2 += " " + t3;
      identity2 = identity2 && id;
    });
    return identity2 ? "none" : transform2;
  }
  observerAdded(count2) {
    if (count2 == 1)
      each$1(this.inputs, (input2) => each$1(input2, (value) => hasFluidValue(value) && addFluidObserver(value, this)));
  }
  observerRemoved(count2) {
    if (count2 == 0)
      each$1(this.inputs, (input2) => each$1(input2, (value) => hasFluidValue(value) && removeFluidObserver(value, this)));
  }
  eventObserved(event) {
    if (event.type == "change") {
      this._value = null;
    }
    callFluidObservers(this, event);
  }
}
const primitives = ["a", "abbr", "address", "area", "article", "aside", "audio", "b", "base", "bdi", "bdo", "big", "blockquote", "body", "br", "button", "canvas", "caption", "cite", "code", "col", "colgroup", "data", "datalist", "dd", "del", "details", "dfn", "dialog", "div", "dl", "dt", "em", "embed", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "iframe", "img", "input", "ins", "kbd", "keygen", "label", "legend", "li", "link", "main", "map", "mark", "menu", "menuitem", "meta", "meter", "nav", "noscript", "object", "ol", "optgroup", "option", "output", "p", "param", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "script", "section", "select", "small", "source", "span", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "time", "title", "tr", "track", "u", "ul", "var", "video", "wbr", "circle", "clipPath", "defs", "ellipse", "foreignObject", "g", "image", "line", "linearGradient", "mask", "path", "pattern", "polygon", "polyline", "radialGradient", "rect", "stop", "svg", "text", "tspan"];
const _excluded$w = ["scrollTop", "scrollLeft"];
globals.assign({
  batchedUpdates: unstable_batchedUpdates,
  createStringInterpolator,
  colors
});
const host = createHost(primitives, {
  applyAnimatedValues,
  createAnimatedStyle: (style2) => new AnimatedStyle(style2),
  getComponentProps: (_ref) => {
    let props = _objectWithoutPropertiesLoose$3(_ref, _excluded$w);
    return props;
  }
});
const animated = host.animated;
var commonjsGlobal$1 = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getAugmentedNamespace(n2) {
  if (n2.__esModule)
    return n2;
  var a3 = Object.defineProperty({}, "__esModule", { value: true });
  Object.keys(n2).forEach(function(k3) {
    var d4 = Object.getOwnPropertyDescriptor(n2, k3);
    Object.defineProperty(a3, k3, d4.get ? d4 : {
      enumerable: true,
      get: function() {
        return n2[k3];
      }
    });
  });
  return a3;
}
var classnames = { exports: {} };
/*!
	Copyright (c) 2018 Jed Watson.
	Licensed under the MIT License (MIT), see
	http://jedwatson.github.io/classnames
*/
(function(module2) {
  (function() {
    var hasOwn2 = {}.hasOwnProperty;
    function classNames() {
      var classes = [];
      for (var i2 = 0; i2 < arguments.length; i2++) {
        var arg = arguments[i2];
        if (!arg)
          continue;
        var argType = typeof arg;
        if (argType === "string" || argType === "number") {
          classes.push(arg);
        } else if (Array.isArray(arg)) {
          if (arg.length) {
            var inner2 = classNames.apply(null, arg);
            if (inner2) {
              classes.push(inner2);
            }
          }
        } else if (argType === "object") {
          if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes("[native code]")) {
            classes.push(arg.toString());
            continue;
          }
          for (var key in arg) {
            if (hasOwn2.call(arg, key) && arg[key]) {
              classes.push(key);
            }
          }
        }
      }
      return classes.join(" ");
    }
    if (module2.exports) {
      classNames.default = classNames;
      module2.exports = classNames;
    } else {
      window.classNames = classNames;
    }
  })();
})(classnames);
var cn$1 = classnames.exports;
function replaceElement(element, replacement, props) {
  if (!isValidElement(element))
    return replacement;
  return React__default.cloneElement(element, typeof props === "function" ? props(element.props || {}) : props);
}
function cloneElement(element, props) {
  return replaceElement(element, element, props);
}
const badge = "_badge_jqtgo_1";
const badge__ViewFilled = "_badge__ViewFilled_jqtgo_8";
const badge__StatusSystem = "_badge__StatusSystem_jqtgo_11";
const badge__ViewStroked = "_badge__ViewStroked_jqtgo_14";
const count$2 = "_count_jqtgo_20";
const badge__SizeXS = "_badge__SizeXS_jqtgo_24";
const badge__SizeS = "_badge__SizeS_jqtgo_31";
const badge__SizeM = "_badge__SizeM_jqtgo_38";
const badge__SizeL = "_badge__SizeL_jqtgo_42";
const badge__StatusNormal = "_badge__StatusNormal_jqtgo_46";
const badge__StatusSuccess = "_badge__StatusSuccess_jqtgo_51";
const badge__StatusError = "_badge__StatusError_jqtgo_56";
const badge__StatusWarning = "_badge__StatusWarning_jqtgo_61";
const badge__NotWrapper = "_badge__NotWrapper_jqtgo_70";
const scrollNumber_Custom = "_scrollNumber_Custom_jqtgo_70";
const scrollNumber = "_scrollNumber_jqtgo_70";
const dot = "_dot_jqtgo_97";
const scrollNumber_Only = "_scrollNumber_Only_jqtgo_122";
const scrollNumber_OnlyUnit = "_scrollNumber_OnlyUnit_jqtgo_130";
var styles$v = {
  badge,
  badge__ViewFilled,
  badge__StatusSystem,
  badge__ViewStroked,
  count: count$2,
  badge__SizeXS,
  badge__SizeS,
  badge__SizeM,
  badge__SizeL,
  badge__StatusNormal,
  badge__StatusSuccess,
  badge__StatusError,
  badge__StatusWarning,
  badge__NotWrapper,
  scrollNumber_Custom,
  scrollNumber,
  dot,
  scrollNumber_Only,
  scrollNumber_OnlyUnit
};
function UnitNumber({ value, current, offset: offset4 = 0 }) {
  let style2;
  if (offset4) {
    style2 = {
      position: "absolute",
      top: `${offset4}00%`,
      left: 0
    };
  }
  return /* @__PURE__ */ React__default.createElement("span", {
    style: style2,
    className: cn$1(styles$v.scrollNumber_OnlyUnit, {
      current
    })
  }, value);
}
function getOffset$3(start2, end2, unit) {
  let index2 = start2;
  let offset4 = 0;
  while ((index2 + 10) % 10 !== end2) {
    index2 += unit;
    offset4 += unit;
  }
  return offset4;
}
function SingleNumber(props) {
  const { count: originCount, value: originValue } = props;
  const value = Number(originValue);
  const count2 = Math.abs(originCount);
  const [prevValue, setPrevValue] = React__default.useState(value);
  const [prevCount, setPrevCount] = React__default.useState(count2);
  const onTransitionEnd = () => {
    setPrevValue(value);
    setPrevCount(count2);
  };
  let unitNodes;
  let offsetStyle;
  if (prevValue === value || Number.isNaN(value) || Number.isNaN(prevValue)) {
    unitNodes = [/* @__PURE__ */ React__default.createElement(UnitNumber, __spreadProps(__spreadValues({}, props), {
      key: value,
      current: true
    }))];
    offsetStyle = {
      transition: "none"
    };
  } else {
    unitNodes = [];
    const end2 = value + 10;
    const unitNumberList = [];
    for (let index2 = value; index2 <= end2; index2 += 1) {
      unitNumberList.push(index2);
    }
    const prevIndex = unitNumberList.findIndex((n2) => n2 % 10 === prevValue);
    unitNodes = unitNumberList.map((n2, index2) => {
      const singleUnit = n2 % 10;
      return /* @__PURE__ */ React__default.createElement(UnitNumber, __spreadProps(__spreadValues({}, props), {
        key: n2,
        value: singleUnit,
        offset: index2 - prevIndex,
        current: index2 === prevIndex
      }));
    });
    const unit = prevCount < count2 ? 1 : -1;
    offsetStyle = {
      transform: `translateY(${-getOffset$3(prevValue, value, unit)}00%)`
    };
  }
  return /* @__PURE__ */ React__default.createElement("span", {
    className: styles$v.scrollNumber_Only,
    style: offsetStyle,
    onTransitionEnd
  }, unitNodes);
}
const ScrollNumber = (_a) => {
  var _b = _a, {
    count: count2,
    className,
    style: style2,
    show,
    component = "sup",
    children
  } = _b, restProps = __objRest(_b, [
    "count",
    "className",
    "style",
    "show",
    "component",
    "children"
  ]);
  const newProps = __spreadProps(__spreadValues({}, restProps), {
    style: style2,
    className: cn$1(styles$v.scrollNumber, className)
  });
  let numberNodes = count2;
  if (count2 && Number(count2) % 1 === 0) {
    const numberList = String(count2).split("");
    numberNodes = numberList.map((num, i2) => /* @__PURE__ */ React__default.createElement(SingleNumber, {
      count: Number(count2),
      value: num,
      key: numberList.length - i2
    }));
  }
  if (children) {
    return cloneElement(children, (oriProps) => ({
      className: cn$1(styles$v.scrollNumber_Custom, oriProps == null ? void 0 : oriProps.className)
    }));
  }
  return /* @__PURE__ */ React__default.createElement(animated.sup, __spreadValues({}, newProps), numberNodes);
};
/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
var __assign$3 = function() {
  __assign$3 = Object.assign || function __assign2(t3) {
    for (var s3, i2 = 1, n2 = arguments.length; i2 < n2; i2++) {
      s3 = arguments[i2];
      for (var p2 in s3)
        if (Object.prototype.hasOwnProperty.call(s3, p2))
          t3[p2] = s3[p2];
    }
    return t3;
  };
  return __assign$3.apply(this, arguments);
};
function __rest$1(s3, e3) {
  var t3 = {};
  for (var p2 in s3)
    if (Object.prototype.hasOwnProperty.call(s3, p2) && e3.indexOf(p2) < 0)
      t3[p2] = s3[p2];
  if (s3 != null && typeof Object.getOwnPropertySymbols === "function")
    for (var i2 = 0, p2 = Object.getOwnPropertySymbols(s3); i2 < p2.length; i2++) {
      if (e3.indexOf(p2[i2]) < 0 && Object.prototype.propertyIsEnumerable.call(s3, p2[i2]))
        t3[p2[i2]] = s3[p2[i2]];
    }
  return t3;
}
function __read$3(o, n2) {
  var m4 = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m4)
    return o;
  var i2 = m4.call(o), r2, ar = [], e3;
  try {
    while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done)
      ar.push(r2.value);
  } catch (error) {
    e3 = { error };
  } finally {
    try {
      if (r2 && !r2.done && (m4 = i2["return"]))
        m4.call(i2);
    } finally {
      if (e3)
        throw e3.error;
    }
  }
  return ar;
}
function __spread() {
  for (var ar = [], i2 = 0; i2 < arguments.length; i2++)
    ar = ar.concat(__read$3(arguments[i2]));
  return ar;
}
var classname = { exports: {} };
var classname_production_min = {};
function r$2(r2) {
  function e3(e4, i2, a3, o) {
    var f2 = i2 ? t3 + e4 + r2.e + i2 : t3 + e4, v2 = f2;
    if (a3) {
      var u3 = " " + v2 + r2.m;
      for (var s3 in a3)
        if (a3.hasOwnProperty(s3)) {
          var p2 = a3[s3];
          p2 === true ? v2 += u3 + s3 : p2 && (v2 += u3 + s3 + n2 + p2);
        }
    }
    if (o !== void 0)
      for (var c7 = 0, l2 = o.length; c7 < l2; c7++) {
        var y4 = o[c7];
        if (y4 && typeof y4.valueOf() == "string")
          for (var g2 = y4.valueOf().split(" "), d4 = 0; d4 < g2.length; d4++) {
            var h4 = g2[d4];
            h4 !== f2 && (v2 += " " + h4);
          }
      }
    return v2;
  }
  var t3 = r2.n || "", n2 = r2.v || r2.m;
  return function(r3, t4) {
    return function(n3, i2, a3) {
      return typeof n3 == "string" ? Array.isArray(i2) ? e3(r3, n3, void 0, i2) : e3(r3, n3, i2, a3) : e3(r3, t4, n3, i2);
    };
  };
}
Object.defineProperty(classname_production_min, "__esModule", { value: true });
var e$2 = r$2({ e: "-", m: "_" });
classname_production_min.cn = e$2, classname_production_min.withNaming = r$2;
{
  classname.exports = classname_production_min;
}
var reactBemNaming = { e: "-", m: "_", v: "_" };
var cn = classname.exports.withNaming(reactBemNaming);
var Theme$1 = "";
var Theme_color_gpnDefault = "";
var Theme_color_gpnDark = "";
var Theme_control_gpnDefault = "";
var Theme_font_gpnDefault = "";
var Theme_size_gpnDefault = "";
var Theme_space_gpnDefault = "";
var Theme_shadow_gpnDefault = "";
var presetGpnDefault = {
  color: {
    primary: "gpnDefault",
    accent: "gpnDark",
    invert: "gpnDark"
  },
  control: "gpnDefault",
  font: "gpnDefault",
  size: "gpnDefault",
  space: "gpnDefault",
  shadow: "gpnDefault"
};
var cnTheme = cn("Theme");
function generateThemeClassNames(preset2) {
  return {
    color: {
      primary: cnTheme({ color: preset2.color.primary }),
      accent: cnTheme({ color: preset2.color.accent }),
      invert: cnTheme({ color: preset2.color.invert })
    },
    control: cnTheme({ control: preset2.control }),
    font: cnTheme({ font: preset2.font }),
    size: cnTheme({ size: preset2.size }),
    space: cnTheme({ space: preset2.space }),
    shadow: cnTheme({ shadow: preset2.shadow })
  };
}
var defaultContextValue = {
  theme: presetGpnDefault,
  themeClassNames: generateThemeClassNames(presetGpnDefault)
};
var ThemeContext$1 = createContext(defaultContextValue);
var Theme = React__default.forwardRef(function(props, ref) {
  var className = props.className, children = props.children, preset2 = props.preset, otherProps = __rest$1(props, ["className", "children", "preset"]);
  var mods = __assign$3(__assign$3({}, preset2), { color: preset2.color.primary });
  var themeClassNames = generateThemeClassNames(preset2);
  return React__default.createElement(ThemeContext$1.Provider, { value: { theme: preset2, themeClassNames } }, React__default.createElement("div", __assign$3({}, otherProps, { ref, className: cnTheme(mods, [className]) }), children));
});
function useTheme$1() {
  return useContext$1(ThemeContext$1);
}
function useForceUpdate() {
  const [, forceUpdate] = useReducer((x2) => x2 + 1, 0);
  return forceUpdate;
}
function useMedia(queries, values2, defaultValue2) {
  const mediaQueryLists = queries.map((q3) => window.matchMedia(q3));
  const getValue2 = () => {
    const index2 = mediaQueryLists.findIndex((mql) => mql.matches);
    return typeof values2[index2] !== "undefined" ? values2[index2] : defaultValue2;
  };
  const [value, setValue] = useState$1(getValue2);
  useEffect(() => {
    const handler = () => setValue(getValue2);
    mediaQueryLists.forEach((mql) => mql.addListener(handler));
    return () => mediaQueryLists.forEach((mql) => mql.removeListener(handler));
  }, []);
  return value;
}
function useControlledState(defaultStateValue, option) {
  const { defaultValue: defaultValue2, value, onChange: onChange2, postState } = option || {};
  const [innerValue, setInnerValue] = useState$1(() => {
    if (value !== void 0) {
      return value;
    }
    if (defaultValue2 !== void 0) {
      return typeof defaultValue2 === "function" ? defaultValue2() : defaultValue2;
    }
    return typeof defaultStateValue === "function" ? defaultStateValue() : defaultStateValue;
  });
  let mergedValue = value !== void 0 ? value : innerValue;
  if (postState) {
    mergedValue = postState(mergedValue);
  }
  const onChangeRef = useRef(onChange2);
  onChangeRef.current = onChange2;
  const triggerChange = useCallback$1((newValue) => {
    setInnerValue(newValue);
    if (mergedValue !== newValue && onChangeRef.current) {
      onChangeRef.current(newValue, mergedValue);
    }
  }, [mergedValue, onChangeRef]);
  const firstRenderRef = useRef(true);
  useEffect(() => {
    if (firstRenderRef.current) {
      firstRenderRef.current = false;
      return;
    }
    if (value === void 0) {
      setInnerValue(value);
    }
  }, [value]);
  return [mergedValue, triggerChange];
}
function useSafeSetState(initialState) {
  const [state, setState] = useState$1(initialState);
  const mountedRef = useRef(false);
  useEffect(() => {
    mountedRef.current = true;
    return () => {
      mountedRef.current = false;
    };
  }, []);
  const safeSetState = useCallback$1((args) => {
    if (mountedRef.current) {
      return setState(args);
    }
  }, [mountedRef, setState]);
  return [state, safeSetState];
}
function _setPrototypeOf$2(o, p2) {
  _setPrototypeOf$2 = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p3) {
    o2.__proto__ = p3;
    return o2;
  };
  return _setPrototypeOf$2(o, p2);
}
function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  _setPrototypeOf$2(subClass, superClass);
}
var propTypes = { exports: {} };
var ReactPropTypesSecret$1 = "SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";
var ReactPropTypesSecret_1 = ReactPropTypesSecret$1;
var ReactPropTypesSecret = ReactPropTypesSecret_1;
function emptyFunction() {
}
function emptyFunctionWithReset() {
}
emptyFunctionWithReset.resetWarningCache = emptyFunction;
var factoryWithThrowingShims = function() {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret) {
      return;
    }
    var err = new Error("Calling PropTypes validators directly is not supported by the `prop-types` package. Use PropTypes.checkPropTypes() to call them. Read more at http://fb.me/use-check-prop-types");
    err.name = "Invariant Violation";
    throw err;
  }
  shim.isRequired = shim;
  function getShim() {
    return shim;
  }
  var ReactPropTypes = {
    array: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,
    any: shim,
    arrayOf: getShim,
    element: shim,
    elementType: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim,
    exact: getShim,
    checkPropTypes: emptyFunctionWithReset,
    resetWarningCache: emptyFunction
  };
  ReactPropTypes.PropTypes = ReactPropTypes;
  return ReactPropTypes;
};
{
  propTypes.exports = factoryWithThrowingShims();
}
var PropTypes = propTypes.exports;
function _extends$g() {
  _extends$g = Object.assign ? Object.assign.bind() : function(target) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      var source2 = arguments[i2];
      for (var key in source2) {
        if (Object.prototype.hasOwnProperty.call(source2, key)) {
          target[key] = source2[key];
        }
      }
    }
    return target;
  };
  return _extends$g.apply(this, arguments);
}
function isAbsolute(pathname) {
  return pathname.charAt(0) === "/";
}
function spliceOne(list, index2) {
  for (var i2 = index2, k3 = i2 + 1, n2 = list.length; k3 < n2; i2 += 1, k3 += 1) {
    list[i2] = list[k3];
  }
  list.pop();
}
function resolvePathname(to2, from) {
  if (from === void 0)
    from = "";
  var toParts = to2 && to2.split("/") || [];
  var fromParts = from && from.split("/") || [];
  var isToAbs = to2 && isAbsolute(to2);
  var isFromAbs = from && isAbsolute(from);
  var mustEndAbs = isToAbs || isFromAbs;
  if (to2 && isAbsolute(to2)) {
    fromParts = toParts;
  } else if (toParts.length) {
    fromParts.pop();
    fromParts = fromParts.concat(toParts);
  }
  if (!fromParts.length)
    return "/";
  var hasTrailingSlash;
  if (fromParts.length) {
    var last = fromParts[fromParts.length - 1];
    hasTrailingSlash = last === "." || last === ".." || last === "";
  } else {
    hasTrailingSlash = false;
  }
  var up = 0;
  for (var i2 = fromParts.length; i2 >= 0; i2--) {
    var part = fromParts[i2];
    if (part === ".") {
      spliceOne(fromParts, i2);
    } else if (part === "..") {
      spliceOne(fromParts, i2);
      up++;
    } else if (up) {
      spliceOne(fromParts, i2);
      up--;
    }
  }
  if (!mustEndAbs)
    for (; up--; up)
      fromParts.unshift("..");
  if (mustEndAbs && fromParts[0] !== "" && (!fromParts[0] || !isAbsolute(fromParts[0])))
    fromParts.unshift("");
  var result = fromParts.join("/");
  if (hasTrailingSlash && result.substr(-1) !== "/")
    result += "/";
  return result;
}
function valueOf(obj) {
  return obj.valueOf ? obj.valueOf() : Object.prototype.valueOf.call(obj);
}
function valueEqual(a3, b3) {
  if (a3 === b3)
    return true;
  if (a3 == null || b3 == null)
    return false;
  if (Array.isArray(a3)) {
    return Array.isArray(b3) && a3.length === b3.length && a3.every(function(item2, index2) {
      return valueEqual(item2, b3[index2]);
    });
  }
  if (typeof a3 === "object" || typeof b3 === "object") {
    var aValue = valueOf(a3);
    var bValue = valueOf(b3);
    if (aValue !== a3 || bValue !== b3)
      return valueEqual(aValue, bValue);
    return Object.keys(Object.assign({}, a3, b3)).every(function(key) {
      return valueEqual(a3[key], b3[key]);
    });
  }
  return false;
}
var isProduction = true;
var prefix$2 = "Invariant failed";
function invariant$1(condition, message) {
  if (condition) {
    return;
  }
  if (isProduction) {
    throw new Error(prefix$2);
  }
  var provided = typeof message === "function" ? message() : message;
  var value = provided ? prefix$2 + ": " + provided : prefix$2;
  throw new Error(value);
}
function addLeadingSlash$1(path) {
  return path.charAt(0) === "/" ? path : "/" + path;
}
function stripLeadingSlash(path) {
  return path.charAt(0) === "/" ? path.substr(1) : path;
}
function hasBasename(path, prefix2) {
  return path.toLowerCase().indexOf(prefix2.toLowerCase()) === 0 && "/?#".indexOf(path.charAt(prefix2.length)) !== -1;
}
function stripBasename$1(path, prefix2) {
  return hasBasename(path, prefix2) ? path.substr(prefix2.length) : path;
}
function stripTrailingSlash(path) {
  return path.charAt(path.length - 1) === "/" ? path.slice(0, -1) : path;
}
function parsePath(path) {
  var pathname = path || "/";
  var search = "";
  var hash2 = "";
  var hashIndex = pathname.indexOf("#");
  if (hashIndex !== -1) {
    hash2 = pathname.substr(hashIndex);
    pathname = pathname.substr(0, hashIndex);
  }
  var searchIndex = pathname.indexOf("?");
  if (searchIndex !== -1) {
    search = pathname.substr(searchIndex);
    pathname = pathname.substr(0, searchIndex);
  }
  return {
    pathname,
    search: search === "?" ? "" : search,
    hash: hash2 === "#" ? "" : hash2
  };
}
function createPath(location) {
  var pathname = location.pathname, search = location.search, hash2 = location.hash;
  var path = pathname || "/";
  if (search && search !== "?")
    path += search.charAt(0) === "?" ? search : "?" + search;
  if (hash2 && hash2 !== "#")
    path += hash2.charAt(0) === "#" ? hash2 : "#" + hash2;
  return path;
}
function createLocation(path, state, key, currentLocation) {
  var location;
  if (typeof path === "string") {
    location = parsePath(path);
    location.state = state;
  } else {
    location = _extends$g({}, path);
    if (location.pathname === void 0)
      location.pathname = "";
    if (location.search) {
      if (location.search.charAt(0) !== "?")
        location.search = "?" + location.search;
    } else {
      location.search = "";
    }
    if (location.hash) {
      if (location.hash.charAt(0) !== "#")
        location.hash = "#" + location.hash;
    } else {
      location.hash = "";
    }
    if (state !== void 0 && location.state === void 0)
      location.state = state;
  }
  try {
    location.pathname = decodeURI(location.pathname);
  } catch (e3) {
    if (e3 instanceof URIError) {
      throw new URIError('Pathname "' + location.pathname + '" could not be decoded. This is likely caused by an invalid percent-encoding.');
    } else {
      throw e3;
    }
  }
  if (key)
    location.key = key;
  if (currentLocation) {
    if (!location.pathname) {
      location.pathname = currentLocation.pathname;
    } else if (location.pathname.charAt(0) !== "/") {
      location.pathname = resolvePathname(location.pathname, currentLocation.pathname);
    }
  } else {
    if (!location.pathname) {
      location.pathname = "/";
    }
  }
  return location;
}
function locationsAreEqual(a3, b3) {
  return a3.pathname === b3.pathname && a3.search === b3.search && a3.hash === b3.hash && a3.key === b3.key && valueEqual(a3.state, b3.state);
}
function createTransitionManager() {
  var prompt = null;
  function setPrompt(nextPrompt) {
    prompt = nextPrompt;
    return function() {
      if (prompt === nextPrompt)
        prompt = null;
    };
  }
  function confirmTransitionTo(location, action, getUserConfirmation, callback) {
    if (prompt != null) {
      var result = typeof prompt === "function" ? prompt(location, action) : prompt;
      if (typeof result === "string") {
        if (typeof getUserConfirmation === "function") {
          getUserConfirmation(result, callback);
        } else {
          callback(true);
        }
      } else {
        callback(result !== false);
      }
    } else {
      callback(true);
    }
  }
  var listeners = [];
  function appendListener(fn3) {
    var isActive2 = true;
    function listener() {
      if (isActive2)
        fn3.apply(void 0, arguments);
    }
    listeners.push(listener);
    return function() {
      isActive2 = false;
      listeners = listeners.filter(function(item2) {
        return item2 !== listener;
      });
    };
  }
  function notifyListeners() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    listeners.forEach(function(listener) {
      return listener.apply(void 0, args);
    });
  }
  return {
    setPrompt,
    confirmTransitionTo,
    appendListener,
    notifyListeners
  };
}
var canUseDOM$1 = !!(typeof window !== "undefined" && window.document && window.document.createElement);
function getConfirmation(message, callback) {
  callback(window.confirm(message));
}
function supportsHistory() {
  var ua2 = window.navigator.userAgent;
  if ((ua2.indexOf("Android 2.") !== -1 || ua2.indexOf("Android 4.0") !== -1) && ua2.indexOf("Mobile Safari") !== -1 && ua2.indexOf("Chrome") === -1 && ua2.indexOf("Windows Phone") === -1)
    return false;
  return window.history && "pushState" in window.history;
}
function supportsPopStateOnHashChange() {
  return window.navigator.userAgent.indexOf("Trident") === -1;
}
function supportsGoWithoutReloadUsingHash() {
  return window.navigator.userAgent.indexOf("Firefox") === -1;
}
function isExtraneousPopstateEvent(event) {
  return event.state === void 0 && navigator.userAgent.indexOf("CriOS") === -1;
}
var PopStateEvent = "popstate";
var HashChangeEvent = "hashchange";
function getHistoryState() {
  try {
    return window.history.state || {};
  } catch (e3) {
    return {};
  }
}
function createBrowserHistory(props) {
  if (props === void 0) {
    props = {};
  }
  !canUseDOM$1 ? invariant$1(false) : void 0;
  var globalHistory = window.history;
  var canUseHistory = supportsHistory();
  var needsHashChangeListener = !supportsPopStateOnHashChange();
  var _props = props, _props$forceRefresh = _props.forceRefresh, forceRefresh = _props$forceRefresh === void 0 ? false : _props$forceRefresh, _props$getUserConfirm = _props.getUserConfirmation, getUserConfirmation = _props$getUserConfirm === void 0 ? getConfirmation : _props$getUserConfirm, _props$keyLength = _props.keyLength, keyLength = _props$keyLength === void 0 ? 6 : _props$keyLength;
  var basename = props.basename ? stripTrailingSlash(addLeadingSlash$1(props.basename)) : "";
  function getDOMLocation(historyState) {
    var _ref = historyState || {}, key = _ref.key, state = _ref.state;
    var _window$location = window.location, pathname = _window$location.pathname, search = _window$location.search, hash2 = _window$location.hash;
    var path = pathname + search + hash2;
    if (basename)
      path = stripBasename$1(path, basename);
    return createLocation(path, state, key);
  }
  function createKey() {
    return Math.random().toString(36).substr(2, keyLength);
  }
  var transitionManager = createTransitionManager();
  function setState(nextState) {
    _extends$g(history, nextState);
    history.length = globalHistory.length;
    transitionManager.notifyListeners(history.location, history.action);
  }
  function handlePopState(event) {
    if (isExtraneousPopstateEvent(event))
      return;
    handlePop(getDOMLocation(event.state));
  }
  function handleHashChange() {
    handlePop(getDOMLocation(getHistoryState()));
  }
  var forceNextPop = false;
  function handlePop(location) {
    if (forceNextPop) {
      forceNextPop = false;
      setState();
    } else {
      var action = "POP";
      transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function(ok) {
        if (ok) {
          setState({
            action,
            location
          });
        } else {
          revertPop(location);
        }
      });
    }
  }
  function revertPop(fromLocation) {
    var toLocation = history.location;
    var toIndex = allKeys.indexOf(toLocation.key);
    if (toIndex === -1)
      toIndex = 0;
    var fromIndex = allKeys.indexOf(fromLocation.key);
    if (fromIndex === -1)
      fromIndex = 0;
    var delta = toIndex - fromIndex;
    if (delta) {
      forceNextPop = true;
      go(delta);
    }
  }
  var initialLocation = getDOMLocation(getHistoryState());
  var allKeys = [initialLocation.key];
  function createHref(location) {
    return basename + createPath(location);
  }
  function push2(path, state) {
    var action = "PUSH";
    var location = createLocation(path, state, createKey(), history.location);
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function(ok) {
      if (!ok)
        return;
      var href = createHref(location);
      var key = location.key, state2 = location.state;
      if (canUseHistory) {
        globalHistory.pushState({
          key,
          state: state2
        }, null, href);
        if (forceRefresh) {
          window.location.href = href;
        } else {
          var prevIndex = allKeys.indexOf(history.location.key);
          var nextKeys = allKeys.slice(0, prevIndex + 1);
          nextKeys.push(location.key);
          allKeys = nextKeys;
          setState({
            action,
            location
          });
        }
      } else {
        window.location.href = href;
      }
    });
  }
  function replace2(path, state) {
    var action = "REPLACE";
    var location = createLocation(path, state, createKey(), history.location);
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function(ok) {
      if (!ok)
        return;
      var href = createHref(location);
      var key = location.key, state2 = location.state;
      if (canUseHistory) {
        globalHistory.replaceState({
          key,
          state: state2
        }, null, href);
        if (forceRefresh) {
          window.location.replace(href);
        } else {
          var prevIndex = allKeys.indexOf(history.location.key);
          if (prevIndex !== -1)
            allKeys[prevIndex] = location.key;
          setState({
            action,
            location
          });
        }
      } else {
        window.location.replace(href);
      }
    });
  }
  function go(n2) {
    globalHistory.go(n2);
  }
  function goBack() {
    go(-1);
  }
  function goForward() {
    go(1);
  }
  var listenerCount = 0;
  function checkDOMListeners(delta) {
    listenerCount += delta;
    if (listenerCount === 1 && delta === 1) {
      window.addEventListener(PopStateEvent, handlePopState);
      if (needsHashChangeListener)
        window.addEventListener(HashChangeEvent, handleHashChange);
    } else if (listenerCount === 0) {
      window.removeEventListener(PopStateEvent, handlePopState);
      if (needsHashChangeListener)
        window.removeEventListener(HashChangeEvent, handleHashChange);
    }
  }
  var isBlocked = false;
  function block(prompt) {
    if (prompt === void 0) {
      prompt = false;
    }
    var unblock = transitionManager.setPrompt(prompt);
    if (!isBlocked) {
      checkDOMListeners(1);
      isBlocked = true;
    }
    return function() {
      if (isBlocked) {
        isBlocked = false;
        checkDOMListeners(-1);
      }
      return unblock();
    };
  }
  function listen(listener) {
    var unlisten = transitionManager.appendListener(listener);
    checkDOMListeners(1);
    return function() {
      checkDOMListeners(-1);
      unlisten();
    };
  }
  var history = {
    length: globalHistory.length,
    action: "POP",
    location: initialLocation,
    createHref,
    push: push2,
    replace: replace2,
    go,
    goBack,
    goForward,
    block,
    listen
  };
  return history;
}
var HashChangeEvent$1 = "hashchange";
var HashPathCoders = {
  hashbang: {
    encodePath: function encodePath(path) {
      return path.charAt(0) === "!" ? path : "!/" + stripLeadingSlash(path);
    },
    decodePath: function decodePath(path) {
      return path.charAt(0) === "!" ? path.substr(1) : path;
    }
  },
  noslash: {
    encodePath: stripLeadingSlash,
    decodePath: addLeadingSlash$1
  },
  slash: {
    encodePath: addLeadingSlash$1,
    decodePath: addLeadingSlash$1
  }
};
function stripHash(url) {
  var hashIndex = url.indexOf("#");
  return hashIndex === -1 ? url : url.slice(0, hashIndex);
}
function getHashPath() {
  var href = window.location.href;
  var hashIndex = href.indexOf("#");
  return hashIndex === -1 ? "" : href.substring(hashIndex + 1);
}
function pushHashPath(path) {
  window.location.hash = path;
}
function replaceHashPath(path) {
  window.location.replace(stripHash(window.location.href) + "#" + path);
}
function createHashHistory(props) {
  if (props === void 0) {
    props = {};
  }
  !canUseDOM$1 ? invariant$1(false) : void 0;
  var globalHistory = window.history;
  supportsGoWithoutReloadUsingHash();
  var _props = props, _props$getUserConfirm = _props.getUserConfirmation, getUserConfirmation = _props$getUserConfirm === void 0 ? getConfirmation : _props$getUserConfirm, _props$hashType = _props.hashType, hashType = _props$hashType === void 0 ? "slash" : _props$hashType;
  var basename = props.basename ? stripTrailingSlash(addLeadingSlash$1(props.basename)) : "";
  var _HashPathCoders$hashT = HashPathCoders[hashType], encodePath2 = _HashPathCoders$hashT.encodePath, decodePath2 = _HashPathCoders$hashT.decodePath;
  function getDOMLocation() {
    var path2 = decodePath2(getHashPath());
    if (basename)
      path2 = stripBasename$1(path2, basename);
    return createLocation(path2);
  }
  var transitionManager = createTransitionManager();
  function setState(nextState) {
    _extends$g(history, nextState);
    history.length = globalHistory.length;
    transitionManager.notifyListeners(history.location, history.action);
  }
  var forceNextPop = false;
  var ignorePath = null;
  function locationsAreEqual$$1(a3, b3) {
    return a3.pathname === b3.pathname && a3.search === b3.search && a3.hash === b3.hash;
  }
  function handleHashChange() {
    var path2 = getHashPath();
    var encodedPath2 = encodePath2(path2);
    if (path2 !== encodedPath2) {
      replaceHashPath(encodedPath2);
    } else {
      var location = getDOMLocation();
      var prevLocation = history.location;
      if (!forceNextPop && locationsAreEqual$$1(prevLocation, location))
        return;
      if (ignorePath === createPath(location))
        return;
      ignorePath = null;
      handlePop(location);
    }
  }
  function handlePop(location) {
    if (forceNextPop) {
      forceNextPop = false;
      setState();
    } else {
      var action = "POP";
      transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function(ok) {
        if (ok) {
          setState({
            action,
            location
          });
        } else {
          revertPop(location);
        }
      });
    }
  }
  function revertPop(fromLocation) {
    var toLocation = history.location;
    var toIndex = allPaths.lastIndexOf(createPath(toLocation));
    if (toIndex === -1)
      toIndex = 0;
    var fromIndex = allPaths.lastIndexOf(createPath(fromLocation));
    if (fromIndex === -1)
      fromIndex = 0;
    var delta = toIndex - fromIndex;
    if (delta) {
      forceNextPop = true;
      go(delta);
    }
  }
  var path = getHashPath();
  var encodedPath = encodePath2(path);
  if (path !== encodedPath)
    replaceHashPath(encodedPath);
  var initialLocation = getDOMLocation();
  var allPaths = [createPath(initialLocation)];
  function createHref(location) {
    var baseTag = document.querySelector("base");
    var href = "";
    if (baseTag && baseTag.getAttribute("href")) {
      href = stripHash(window.location.href);
    }
    return href + "#" + encodePath2(basename + createPath(location));
  }
  function push2(path2, state) {
    var action = "PUSH";
    var location = createLocation(path2, void 0, void 0, history.location);
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function(ok) {
      if (!ok)
        return;
      var path3 = createPath(location);
      var encodedPath2 = encodePath2(basename + path3);
      var hashChanged = getHashPath() !== encodedPath2;
      if (hashChanged) {
        ignorePath = path3;
        pushHashPath(encodedPath2);
        var prevIndex = allPaths.lastIndexOf(createPath(history.location));
        var nextPaths = allPaths.slice(0, prevIndex + 1);
        nextPaths.push(path3);
        allPaths = nextPaths;
        setState({
          action,
          location
        });
      } else {
        setState();
      }
    });
  }
  function replace2(path2, state) {
    var action = "REPLACE";
    var location = createLocation(path2, void 0, void 0, history.location);
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function(ok) {
      if (!ok)
        return;
      var path3 = createPath(location);
      var encodedPath2 = encodePath2(basename + path3);
      var hashChanged = getHashPath() !== encodedPath2;
      if (hashChanged) {
        ignorePath = path3;
        replaceHashPath(encodedPath2);
      }
      var prevIndex = allPaths.indexOf(createPath(history.location));
      if (prevIndex !== -1)
        allPaths[prevIndex] = path3;
      setState({
        action,
        location
      });
    });
  }
  function go(n2) {
    globalHistory.go(n2);
  }
  function goBack() {
    go(-1);
  }
  function goForward() {
    go(1);
  }
  var listenerCount = 0;
  function checkDOMListeners(delta) {
    listenerCount += delta;
    if (listenerCount === 1 && delta === 1) {
      window.addEventListener(HashChangeEvent$1, handleHashChange);
    } else if (listenerCount === 0) {
      window.removeEventListener(HashChangeEvent$1, handleHashChange);
    }
  }
  var isBlocked = false;
  function block(prompt) {
    if (prompt === void 0) {
      prompt = false;
    }
    var unblock = transitionManager.setPrompt(prompt);
    if (!isBlocked) {
      checkDOMListeners(1);
      isBlocked = true;
    }
    return function() {
      if (isBlocked) {
        isBlocked = false;
        checkDOMListeners(-1);
      }
      return unblock();
    };
  }
  function listen(listener) {
    var unlisten = transitionManager.appendListener(listener);
    checkDOMListeners(1);
    return function() {
      checkDOMListeners(-1);
      unlisten();
    };
  }
  var history = {
    length: globalHistory.length,
    action: "POP",
    location: initialLocation,
    createHref,
    push: push2,
    replace: replace2,
    go,
    goBack,
    goForward,
    block,
    listen
  };
  return history;
}
function clamp$1(n2, lowerBound, upperBound) {
  return Math.min(Math.max(n2, lowerBound), upperBound);
}
function createMemoryHistory(props) {
  if (props === void 0) {
    props = {};
  }
  var _props = props, getUserConfirmation = _props.getUserConfirmation, _props$initialEntries = _props.initialEntries, initialEntries = _props$initialEntries === void 0 ? ["/"] : _props$initialEntries, _props$initialIndex = _props.initialIndex, initialIndex = _props$initialIndex === void 0 ? 0 : _props$initialIndex, _props$keyLength = _props.keyLength, keyLength = _props$keyLength === void 0 ? 6 : _props$keyLength;
  var transitionManager = createTransitionManager();
  function setState(nextState) {
    _extends$g(history, nextState);
    history.length = history.entries.length;
    transitionManager.notifyListeners(history.location, history.action);
  }
  function createKey() {
    return Math.random().toString(36).substr(2, keyLength);
  }
  var index2 = clamp$1(initialIndex, 0, initialEntries.length - 1);
  var entries = initialEntries.map(function(entry) {
    return typeof entry === "string" ? createLocation(entry, void 0, createKey()) : createLocation(entry, void 0, entry.key || createKey());
  });
  var createHref = createPath;
  function push2(path, state) {
    var action = "PUSH";
    var location = createLocation(path, state, createKey(), history.location);
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function(ok) {
      if (!ok)
        return;
      var prevIndex = history.index;
      var nextIndex = prevIndex + 1;
      var nextEntries = history.entries.slice(0);
      if (nextEntries.length > nextIndex) {
        nextEntries.splice(nextIndex, nextEntries.length - nextIndex, location);
      } else {
        nextEntries.push(location);
      }
      setState({
        action,
        location,
        index: nextIndex,
        entries: nextEntries
      });
    });
  }
  function replace2(path, state) {
    var action = "REPLACE";
    var location = createLocation(path, state, createKey(), history.location);
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function(ok) {
      if (!ok)
        return;
      history.entries[history.index] = location;
      setState({
        action,
        location
      });
    });
  }
  function go(n2) {
    var nextIndex = clamp$1(history.index + n2, 0, history.entries.length - 1);
    var action = "POP";
    var location = history.entries[nextIndex];
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function(ok) {
      if (ok) {
        setState({
          action,
          location,
          index: nextIndex
        });
      } else {
        setState();
      }
    });
  }
  function goBack() {
    go(-1);
  }
  function goForward() {
    go(1);
  }
  function canGo(n2) {
    var nextIndex = history.index + n2;
    return nextIndex >= 0 && nextIndex < history.entries.length;
  }
  function block(prompt) {
    if (prompt === void 0) {
      prompt = false;
    }
    return transitionManager.setPrompt(prompt);
  }
  function listen(listener) {
    return transitionManager.appendListener(listener);
  }
  var history = {
    length: entries.length,
    action: "POP",
    location: entries[index2],
    index: index2,
    entries,
    createHref,
    push: push2,
    replace: replace2,
    go,
    goBack,
    goForward,
    canGo,
    block,
    listen
  };
  return history;
}
var MAX_SIGNED_31_BIT_INT = 1073741823;
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {};
function getUniqueId() {
  var key = "__global_unique_id__";
  return commonjsGlobal[key] = (commonjsGlobal[key] || 0) + 1;
}
function objectIs(x2, y4) {
  if (x2 === y4) {
    return x2 !== 0 || 1 / x2 === 1 / y4;
  } else {
    return x2 !== x2 && y4 !== y4;
  }
}
function createEventEmitter(value) {
  var handlers = [];
  return {
    on: function on(handler) {
      handlers.push(handler);
    },
    off: function off(handler) {
      handlers = handlers.filter(function(h4) {
        return h4 !== handler;
      });
    },
    get: function get4() {
      return value;
    },
    set: function set2(newValue, changedBits) {
      value = newValue;
      handlers.forEach(function(handler) {
        return handler(value, changedBits);
      });
    }
  };
}
function onlyChild(children) {
  return Array.isArray(children) ? children[0] : children;
}
function createReactContext(defaultValue2, calculateChangedBits) {
  var _Provider$childContex, _Consumer$contextType;
  var contextProp = "__create-react-context-" + getUniqueId() + "__";
  var Provider2 = /* @__PURE__ */ function(_Component) {
    _inheritsLoose(Provider3, _Component);
    function Provider3() {
      var _this;
      _this = _Component.apply(this, arguments) || this;
      _this.emitter = createEventEmitter(_this.props.value);
      return _this;
    }
    var _proto = Provider3.prototype;
    _proto.getChildContext = function getChildContext() {
      var _ref;
      return _ref = {}, _ref[contextProp] = this.emitter, _ref;
    };
    _proto.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
      if (this.props.value !== nextProps.value) {
        var oldValue = this.props.value;
        var newValue = nextProps.value;
        var changedBits;
        if (objectIs(oldValue, newValue)) {
          changedBits = 0;
        } else {
          changedBits = typeof calculateChangedBits === "function" ? calculateChangedBits(oldValue, newValue) : MAX_SIGNED_31_BIT_INT;
          changedBits |= 0;
          if (changedBits !== 0) {
            this.emitter.set(nextProps.value, changedBits);
          }
        }
      }
    };
    _proto.render = function render4() {
      return this.props.children;
    };
    return Provider3;
  }(Component);
  Provider2.childContextTypes = (_Provider$childContex = {}, _Provider$childContex[contextProp] = PropTypes.object.isRequired, _Provider$childContex);
  var Consumer = /* @__PURE__ */ function(_Component2) {
    _inheritsLoose(Consumer2, _Component2);
    function Consumer2() {
      var _this2;
      _this2 = _Component2.apply(this, arguments) || this;
      _this2.state = {
        value: _this2.getValue()
      };
      _this2.onUpdate = function(newValue, changedBits) {
        var observedBits = _this2.observedBits | 0;
        if ((observedBits & changedBits) !== 0) {
          _this2.setState({
            value: _this2.getValue()
          });
        }
      };
      return _this2;
    }
    var _proto2 = Consumer2.prototype;
    _proto2.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
      var observedBits = nextProps.observedBits;
      this.observedBits = observedBits === void 0 || observedBits === null ? MAX_SIGNED_31_BIT_INT : observedBits;
    };
    _proto2.componentDidMount = function componentDidMount() {
      if (this.context[contextProp]) {
        this.context[contextProp].on(this.onUpdate);
      }
      var observedBits = this.props.observedBits;
      this.observedBits = observedBits === void 0 || observedBits === null ? MAX_SIGNED_31_BIT_INT : observedBits;
    };
    _proto2.componentWillUnmount = function componentWillUnmount() {
      if (this.context[contextProp]) {
        this.context[contextProp].off(this.onUpdate);
      }
    };
    _proto2.getValue = function getValue2() {
      if (this.context[contextProp]) {
        return this.context[contextProp].get();
      } else {
        return defaultValue2;
      }
    };
    _proto2.render = function render4() {
      return onlyChild(this.props.children)(this.state.value);
    };
    return Consumer2;
  }(Component);
  Consumer.contextTypes = (_Consumer$contextType = {}, _Consumer$contextType[contextProp] = PropTypes.object, _Consumer$contextType);
  return {
    Provider: Provider2,
    Consumer
  };
}
var index$6 = React__default.createContext || createReactContext;
var pathToRegexp$2 = { exports: {} };
var isarray$1 = Array.isArray || function(arr) {
  return Object.prototype.toString.call(arr) == "[object Array]";
};
var isarray = isarray$1;
pathToRegexp$2.exports = pathToRegexp;
pathToRegexp$2.exports.parse = parse$5;
pathToRegexp$2.exports.compile = compile;
pathToRegexp$2.exports.tokensToFunction = tokensToFunction;
pathToRegexp$2.exports.tokensToRegExp = tokensToRegExp;
var PATH_REGEXP = new RegExp([
  "(\\\\.)",
  "([\\/.])?(?:(?:\\:(\\w+)(?:\\(((?:\\\\.|[^\\\\()])+)\\))?|\\(((?:\\\\.|[^\\\\()])+)\\))([+*?])?|(\\*))"
].join("|"), "g");
function parse$5(str, options) {
  var tokens = [];
  var key = 0;
  var index2 = 0;
  var path = "";
  var defaultDelimiter = options && options.delimiter || "/";
  var res;
  while ((res = PATH_REGEXP.exec(str)) != null) {
    var m4 = res[0];
    var escaped = res[1];
    var offset4 = res.index;
    path += str.slice(index2, offset4);
    index2 = offset4 + m4.length;
    if (escaped) {
      path += escaped[1];
      continue;
    }
    var next = str[index2];
    var prefix2 = res[2];
    var name2 = res[3];
    var capture = res[4];
    var group = res[5];
    var modifier = res[6];
    var asterisk = res[7];
    if (path) {
      tokens.push(path);
      path = "";
    }
    var partial = prefix2 != null && next != null && next !== prefix2;
    var repeat2 = modifier === "+" || modifier === "*";
    var optional = modifier === "?" || modifier === "*";
    var delimiter = res[2] || defaultDelimiter;
    var pattern = capture || group;
    tokens.push({
      name: name2 || key++,
      prefix: prefix2 || "",
      delimiter,
      optional,
      repeat: repeat2,
      partial,
      asterisk: !!asterisk,
      pattern: pattern ? escapeGroup(pattern) : asterisk ? ".*" : "[^" + escapeString(delimiter) + "]+?"
    });
  }
  if (index2 < str.length) {
    path += str.substr(index2);
  }
  if (path) {
    tokens.push(path);
  }
  return tokens;
}
function compile(str, options) {
  return tokensToFunction(parse$5(str, options), options);
}
function encodeURIComponentPretty(str) {
  return encodeURI(str).replace(/[\/?#]/g, function(c7) {
    return "%" + c7.charCodeAt(0).toString(16).toUpperCase();
  });
}
function encodeAsterisk(str) {
  return encodeURI(str).replace(/[?#]/g, function(c7) {
    return "%" + c7.charCodeAt(0).toString(16).toUpperCase();
  });
}
function tokensToFunction(tokens, options) {
  var matches = new Array(tokens.length);
  for (var i2 = 0; i2 < tokens.length; i2++) {
    if (typeof tokens[i2] === "object") {
      matches[i2] = new RegExp("^(?:" + tokens[i2].pattern + ")$", flags(options));
    }
  }
  return function(obj, opts) {
    var path = "";
    var data2 = obj || {};
    var options2 = opts || {};
    var encode3 = options2.pretty ? encodeURIComponentPretty : encodeURIComponent;
    for (var i3 = 0; i3 < tokens.length; i3++) {
      var token = tokens[i3];
      if (typeof token === "string") {
        path += token;
        continue;
      }
      var value = data2[token.name];
      var segment;
      if (value == null) {
        if (token.optional) {
          if (token.partial) {
            path += token.prefix;
          }
          continue;
        } else {
          throw new TypeError('Expected "' + token.name + '" to be defined');
        }
      }
      if (isarray(value)) {
        if (!token.repeat) {
          throw new TypeError('Expected "' + token.name + '" to not repeat, but received `' + JSON.stringify(value) + "`");
        }
        if (value.length === 0) {
          if (token.optional) {
            continue;
          } else {
            throw new TypeError('Expected "' + token.name + '" to not be empty');
          }
        }
        for (var j = 0; j < value.length; j++) {
          segment = encode3(value[j]);
          if (!matches[i3].test(segment)) {
            throw new TypeError('Expected all "' + token.name + '" to match "' + token.pattern + '", but received `' + JSON.stringify(segment) + "`");
          }
          path += (j === 0 ? token.prefix : token.delimiter) + segment;
        }
        continue;
      }
      segment = token.asterisk ? encodeAsterisk(value) : encode3(value);
      if (!matches[i3].test(segment)) {
        throw new TypeError('Expected "' + token.name + '" to match "' + token.pattern + '", but received "' + segment + '"');
      }
      path += token.prefix + segment;
    }
    return path;
  };
}
function escapeString(str) {
  return str.replace(/([.+*?=^!:${}()[\]|\/\\])/g, "\\$1");
}
function escapeGroup(group) {
  return group.replace(/([=!:$\/()])/g, "\\$1");
}
function attachKeys(re, keys2) {
  re.keys = keys2;
  return re;
}
function flags(options) {
  return options && options.sensitive ? "" : "i";
}
function regexpToRegexp(path, keys2) {
  var groups = path.source.match(/\((?!\?)/g);
  if (groups) {
    for (var i2 = 0; i2 < groups.length; i2++) {
      keys2.push({
        name: i2,
        prefix: null,
        delimiter: null,
        optional: false,
        repeat: false,
        partial: false,
        asterisk: false,
        pattern: null
      });
    }
  }
  return attachKeys(path, keys2);
}
function arrayToRegexp(path, keys2, options) {
  var parts = [];
  for (var i2 = 0; i2 < path.length; i2++) {
    parts.push(pathToRegexp(path[i2], keys2, options).source);
  }
  var regexp = new RegExp("(?:" + parts.join("|") + ")", flags(options));
  return attachKeys(regexp, keys2);
}
function stringToRegexp(path, keys2, options) {
  return tokensToRegExp(parse$5(path, options), keys2, options);
}
function tokensToRegExp(tokens, keys2, options) {
  if (!isarray(keys2)) {
    options = keys2 || options;
    keys2 = [];
  }
  options = options || {};
  var strict = options.strict;
  var end2 = options.end !== false;
  var route = "";
  for (var i2 = 0; i2 < tokens.length; i2++) {
    var token = tokens[i2];
    if (typeof token === "string") {
      route += escapeString(token);
    } else {
      var prefix2 = escapeString(token.prefix);
      var capture = "(?:" + token.pattern + ")";
      keys2.push(token);
      if (token.repeat) {
        capture += "(?:" + prefix2 + capture + ")*";
      }
      if (token.optional) {
        if (!token.partial) {
          capture = "(?:" + prefix2 + "(" + capture + "))?";
        } else {
          capture = prefix2 + "(" + capture + ")?";
        }
      } else {
        capture = prefix2 + "(" + capture + ")";
      }
      route += capture;
    }
  }
  var delimiter = escapeString(options.delimiter || "/");
  var endsWithDelimiter = route.slice(-delimiter.length) === delimiter;
  if (!strict) {
    route = (endsWithDelimiter ? route.slice(0, -delimiter.length) : route) + "(?:" + delimiter + "(?=$))?";
  }
  if (end2) {
    route += "$";
  } else {
    route += strict && endsWithDelimiter ? "" : "(?=" + delimiter + "|$)";
  }
  return attachKeys(new RegExp("^" + route, flags(options)), keys2);
}
function pathToRegexp(path, keys2, options) {
  if (!isarray(keys2)) {
    options = keys2 || options;
    keys2 = [];
  }
  options = options || {};
  if (path instanceof RegExp) {
    return regexpToRegexp(path, keys2);
  }
  if (isarray(path)) {
    return arrayToRegexp(path, keys2, options);
  }
  return stringToRegexp(path, keys2, options);
}
var pathToRegexp$1 = pathToRegexp$2.exports;
var reactIs$2 = { exports: {} };
var reactIs_production_min$1 = {};
/** @license React v16.13.1
 * react-is.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var b$1 = typeof Symbol === "function" && Symbol.for, c$1 = b$1 ? Symbol.for("react.element") : 60103, d$1 = b$1 ? Symbol.for("react.portal") : 60106, e$1 = b$1 ? Symbol.for("react.fragment") : 60107, f$1 = b$1 ? Symbol.for("react.strict_mode") : 60108, g$1 = b$1 ? Symbol.for("react.profiler") : 60114, h$1 = b$1 ? Symbol.for("react.provider") : 60109, k$1 = b$1 ? Symbol.for("react.context") : 60110, l$1 = b$1 ? Symbol.for("react.async_mode") : 60111, m$1 = b$1 ? Symbol.for("react.concurrent_mode") : 60111, n$1 = b$1 ? Symbol.for("react.forward_ref") : 60112, p$1 = b$1 ? Symbol.for("react.suspense") : 60113, q$1 = b$1 ? Symbol.for("react.suspense_list") : 60120, r$1 = b$1 ? Symbol.for("react.memo") : 60115, t = b$1 ? Symbol.for("react.lazy") : 60116, v$1 = b$1 ? Symbol.for("react.block") : 60121, w$1 = b$1 ? Symbol.for("react.fundamental") : 60117, x$1 = b$1 ? Symbol.for("react.responder") : 60118, y$1 = b$1 ? Symbol.for("react.scope") : 60119;
function z$1(a3) {
  if (typeof a3 === "object" && a3 !== null) {
    var u3 = a3.$$typeof;
    switch (u3) {
      case c$1:
        switch (a3 = a3.type, a3) {
          case l$1:
          case m$1:
          case e$1:
          case g$1:
          case f$1:
          case p$1:
            return a3;
          default:
            switch (a3 = a3 && a3.$$typeof, a3) {
              case k$1:
              case n$1:
              case t:
              case r$1:
              case h$1:
                return a3;
              default:
                return u3;
            }
        }
      case d$1:
        return u3;
    }
  }
}
function A$1(a3) {
  return z$1(a3) === m$1;
}
reactIs_production_min$1.AsyncMode = l$1;
reactIs_production_min$1.ConcurrentMode = m$1;
reactIs_production_min$1.ContextConsumer = k$1;
reactIs_production_min$1.ContextProvider = h$1;
reactIs_production_min$1.Element = c$1;
reactIs_production_min$1.ForwardRef = n$1;
reactIs_production_min$1.Fragment = e$1;
reactIs_production_min$1.Lazy = t;
reactIs_production_min$1.Memo = r$1;
reactIs_production_min$1.Portal = d$1;
reactIs_production_min$1.Profiler = g$1;
reactIs_production_min$1.StrictMode = f$1;
reactIs_production_min$1.Suspense = p$1;
reactIs_production_min$1.isAsyncMode = function(a3) {
  return A$1(a3) || z$1(a3) === l$1;
};
reactIs_production_min$1.isConcurrentMode = A$1;
reactIs_production_min$1.isContextConsumer = function(a3) {
  return z$1(a3) === k$1;
};
reactIs_production_min$1.isContextProvider = function(a3) {
  return z$1(a3) === h$1;
};
reactIs_production_min$1.isElement = function(a3) {
  return typeof a3 === "object" && a3 !== null && a3.$$typeof === c$1;
};
reactIs_production_min$1.isForwardRef = function(a3) {
  return z$1(a3) === n$1;
};
reactIs_production_min$1.isFragment = function(a3) {
  return z$1(a3) === e$1;
};
reactIs_production_min$1.isLazy = function(a3) {
  return z$1(a3) === t;
};
reactIs_production_min$1.isMemo = function(a3) {
  return z$1(a3) === r$1;
};
reactIs_production_min$1.isPortal = function(a3) {
  return z$1(a3) === d$1;
};
reactIs_production_min$1.isProfiler = function(a3) {
  return z$1(a3) === g$1;
};
reactIs_production_min$1.isStrictMode = function(a3) {
  return z$1(a3) === f$1;
};
reactIs_production_min$1.isSuspense = function(a3) {
  return z$1(a3) === p$1;
};
reactIs_production_min$1.isValidElementType = function(a3) {
  return typeof a3 === "string" || typeof a3 === "function" || a3 === e$1 || a3 === m$1 || a3 === g$1 || a3 === f$1 || a3 === p$1 || a3 === q$1 || typeof a3 === "object" && a3 !== null && (a3.$$typeof === t || a3.$$typeof === r$1 || a3.$$typeof === h$1 || a3.$$typeof === k$1 || a3.$$typeof === n$1 || a3.$$typeof === w$1 || a3.$$typeof === x$1 || a3.$$typeof === y$1 || a3.$$typeof === v$1);
};
reactIs_production_min$1.typeOf = z$1;
{
  reactIs$2.exports = reactIs_production_min$1;
}
function _objectWithoutPropertiesLoose$2(source2, excluded) {
  if (source2 == null)
    return {};
  var target = {};
  var sourceKeys = Object.keys(source2);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0)
      continue;
    target[key] = source2[key];
  }
  return target;
}
var reactIs$1 = reactIs$2.exports;
var REACT_STATICS = {
  childContextTypes: true,
  contextType: true,
  contextTypes: true,
  defaultProps: true,
  displayName: true,
  getDefaultProps: true,
  getDerivedStateFromError: true,
  getDerivedStateFromProps: true,
  mixins: true,
  propTypes: true,
  type: true
};
var KNOWN_STATICS = {
  name: true,
  length: true,
  prototype: true,
  caller: true,
  callee: true,
  arguments: true,
  arity: true
};
var FORWARD_REF_STATICS = {
  "$$typeof": true,
  render: true,
  defaultProps: true,
  displayName: true,
  propTypes: true
};
var MEMO_STATICS = {
  "$$typeof": true,
  compare: true,
  defaultProps: true,
  displayName: true,
  propTypes: true,
  type: true
};
var TYPE_STATICS = {};
TYPE_STATICS[reactIs$1.ForwardRef] = FORWARD_REF_STATICS;
TYPE_STATICS[reactIs$1.Memo] = MEMO_STATICS;
function getStatics(component) {
  if (reactIs$1.isMemo(component)) {
    return MEMO_STATICS;
  }
  return TYPE_STATICS[component["$$typeof"]] || REACT_STATICS;
}
var defineProperty$5 = Object.defineProperty;
var getOwnPropertyNames = Object.getOwnPropertyNames;
var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var getPrototypeOf = Object.getPrototypeOf;
var objectPrototype = Object.prototype;
function hoistNonReactStatics(targetComponent, sourceComponent, blacklist) {
  if (typeof sourceComponent !== "string") {
    if (objectPrototype) {
      var inheritedComponent = getPrototypeOf(sourceComponent);
      if (inheritedComponent && inheritedComponent !== objectPrototype) {
        hoistNonReactStatics(targetComponent, inheritedComponent, blacklist);
      }
    }
    var keys2 = getOwnPropertyNames(sourceComponent);
    if (getOwnPropertySymbols) {
      keys2 = keys2.concat(getOwnPropertySymbols(sourceComponent));
    }
    var targetStatics = getStatics(targetComponent);
    var sourceStatics = getStatics(sourceComponent);
    for (var i2 = 0; i2 < keys2.length; ++i2) {
      var key = keys2[i2];
      if (!KNOWN_STATICS[key] && !(blacklist && blacklist[key]) && !(sourceStatics && sourceStatics[key]) && !(targetStatics && targetStatics[key])) {
        var descriptor = getOwnPropertyDescriptor(sourceComponent, key);
        try {
          defineProperty$5(targetComponent, key, descriptor);
        } catch (e3) {
        }
      }
    }
  }
  return targetComponent;
}
var hoistNonReactStatics_cjs = hoistNonReactStatics;
var createNamedContext = function createNamedContext2(name2) {
  var context2 = index$6();
  context2.displayName = name2;
  return context2;
};
var historyContext = /* @__PURE__ */ createNamedContext("Router-History");
var createNamedContext$1 = function createNamedContext3(name2) {
  var context2 = index$6();
  context2.displayName = name2;
  return context2;
};
var context = /* @__PURE__ */ createNamedContext$1("Router");
var Router = /* @__PURE__ */ function(_React$Component) {
  _inheritsLoose(Router2, _React$Component);
  Router2.computeRootMatch = function computeRootMatch(pathname) {
    return {
      path: "/",
      url: "/",
      params: {},
      isExact: pathname === "/"
    };
  };
  function Router2(props) {
    var _this;
    _this = _React$Component.call(this, props) || this;
    _this.state = {
      location: props.history.location
    };
    _this._isMounted = false;
    _this._pendingLocation = null;
    if (!props.staticContext) {
      _this.unlisten = props.history.listen(function(location) {
        if (_this._isMounted) {
          _this.setState({
            location
          });
        } else {
          _this._pendingLocation = location;
        }
      });
    }
    return _this;
  }
  var _proto = Router2.prototype;
  _proto.componentDidMount = function componentDidMount() {
    this._isMounted = true;
    if (this._pendingLocation) {
      this.setState({
        location: this._pendingLocation
      });
    }
  };
  _proto.componentWillUnmount = function componentWillUnmount() {
    if (this.unlisten)
      this.unlisten();
  };
  _proto.render = function render4() {
    return React__default.createElement(context.Provider, {
      value: {
        history: this.props.history,
        location: this.state.location,
        match: Router2.computeRootMatch(this.state.location.pathname),
        staticContext: this.props.staticContext
      }
    }, React__default.createElement(historyContext.Provider, {
      children: this.props.children || null,
      value: this.props.history
    }));
  };
  return Router2;
}(React__default.Component);
/* @__PURE__ */ (function(_React$Component) {
  _inheritsLoose(MemoryRouter, _React$Component);
  function MemoryRouter() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.history = createMemoryHistory(_this.props);
    return _this;
  }
  var _proto = MemoryRouter.prototype;
  _proto.render = function render4() {
    return React__default.createElement(Router, {
      history: this.history,
      children: this.props.children
    });
  };
  return MemoryRouter;
})(React__default.Component);
var Lifecycle = /* @__PURE__ */ function(_React$Component) {
  _inheritsLoose(Lifecycle2, _React$Component);
  function Lifecycle2() {
    return _React$Component.apply(this, arguments) || this;
  }
  var _proto = Lifecycle2.prototype;
  _proto.componentDidMount = function componentDidMount() {
    if (this.props.onMount)
      this.props.onMount.call(this, this);
  };
  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    if (this.props.onUpdate)
      this.props.onUpdate.call(this, this, prevProps);
  };
  _proto.componentWillUnmount = function componentWillUnmount() {
    if (this.props.onUnmount)
      this.props.onUnmount.call(this, this);
  };
  _proto.render = function render4() {
    return null;
  };
  return Lifecycle2;
}(React__default.Component);
var cache = {};
var cacheLimit = 1e4;
var cacheCount = 0;
function compilePath(path) {
  if (cache[path])
    return cache[path];
  var generator = pathToRegexp$1.compile(path);
  if (cacheCount < cacheLimit) {
    cache[path] = generator;
    cacheCount++;
  }
  return generator;
}
function generatePath(path, params) {
  if (path === void 0) {
    path = "/";
  }
  if (params === void 0) {
    params = {};
  }
  return path === "/" ? path : compilePath(path)(params, {
    pretty: true
  });
}
function Redirect(_ref) {
  var computedMatch = _ref.computedMatch, to2 = _ref.to, _ref$push = _ref.push, push2 = _ref$push === void 0 ? false : _ref$push;
  return React__default.createElement(context.Consumer, null, function(context2) {
    !context2 ? invariant$1(false) : void 0;
    var history = context2.history, staticContext = context2.staticContext;
    var method = push2 ? history.push : history.replace;
    var location = createLocation(computedMatch ? typeof to2 === "string" ? generatePath(to2, computedMatch.params) : _extends$g({}, to2, {
      pathname: generatePath(to2.pathname, computedMatch.params)
    }) : to2);
    if (staticContext) {
      method(location);
      return null;
    }
    return React__default.createElement(Lifecycle, {
      onMount: function onMount2() {
        method(location);
      },
      onUpdate: function onUpdate(self2, prevProps) {
        var prevLocation = createLocation(prevProps.to);
        if (!locationsAreEqual(prevLocation, _extends$g({}, location, {
          key: prevLocation.key
        }))) {
          method(location);
        }
      },
      to: to2
    });
  });
}
var cache$1 = {};
var cacheLimit$1 = 1e4;
var cacheCount$1 = 0;
function compilePath$1(path, options) {
  var cacheKey2 = "" + options.end + options.strict + options.sensitive;
  var pathCache = cache$1[cacheKey2] || (cache$1[cacheKey2] = {});
  if (pathCache[path])
    return pathCache[path];
  var keys2 = [];
  var regexp = pathToRegexp$1(path, keys2, options);
  var result = {
    regexp,
    keys: keys2
  };
  if (cacheCount$1 < cacheLimit$1) {
    pathCache[path] = result;
    cacheCount$1++;
  }
  return result;
}
function matchPath(pathname, options) {
  if (options === void 0) {
    options = {};
  }
  if (typeof options === "string" || Array.isArray(options)) {
    options = {
      path: options
    };
  }
  var _options = options, path = _options.path, _options$exact = _options.exact, exact = _options$exact === void 0 ? false : _options$exact, _options$strict = _options.strict, strict = _options$strict === void 0 ? false : _options$strict, _options$sensitive = _options.sensitive, sensitive = _options$sensitive === void 0 ? false : _options$sensitive;
  var paths = [].concat(path);
  return paths.reduce(function(matched, path2) {
    if (!path2 && path2 !== "")
      return null;
    if (matched)
      return matched;
    var _compilePath = compilePath$1(path2, {
      end: exact,
      strict,
      sensitive
    }), regexp = _compilePath.regexp, keys2 = _compilePath.keys;
    var match2 = regexp.exec(pathname);
    if (!match2)
      return null;
    var url = match2[0], values2 = match2.slice(1);
    var isExact = pathname === url;
    if (exact && !isExact)
      return null;
    return {
      path: path2,
      url: path2 === "/" && url === "" ? "/" : url,
      isExact,
      params: keys2.reduce(function(memo2, key, index2) {
        memo2[key.name] = values2[index2];
        return memo2;
      }, {})
    };
  }, null);
}
var Route = /* @__PURE__ */ function(_React$Component) {
  _inheritsLoose(Route2, _React$Component);
  function Route2() {
    return _React$Component.apply(this, arguments) || this;
  }
  var _proto = Route2.prototype;
  _proto.render = function render4() {
    var _this = this;
    return React__default.createElement(context.Consumer, null, function(context$1) {
      !context$1 ? invariant$1(false) : void 0;
      var location = _this.props.location || context$1.location;
      var match2 = _this.props.computedMatch ? _this.props.computedMatch : _this.props.path ? matchPath(location.pathname, _this.props) : context$1.match;
      var props = _extends$g({}, context$1, {
        location,
        match: match2
      });
      var _this$props = _this.props, children = _this$props.children, component = _this$props.component, render5 = _this$props.render;
      if (Array.isArray(children) && children.length === 0) {
        children = null;
      }
      return React__default.createElement(context.Provider, {
        value: props
      }, props.match ? children ? typeof children === "function" ? children(props) : children : component ? React__default.createElement(component, props) : render5 ? render5(props) : null : typeof children === "function" ? children(props) : null);
    });
  };
  return Route2;
}(React__default.Component);
function addLeadingSlash(path) {
  return path.charAt(0) === "/" ? path : "/" + path;
}
function addBasename(basename, location) {
  if (!basename)
    return location;
  return _extends$g({}, location, {
    pathname: addLeadingSlash(basename) + location.pathname
  });
}
function stripBasename(basename, location) {
  if (!basename)
    return location;
  var base = addLeadingSlash(basename);
  if (location.pathname.indexOf(base) !== 0)
    return location;
  return _extends$g({}, location, {
    pathname: location.pathname.substr(base.length)
  });
}
function createURL(location) {
  return typeof location === "string" ? location : createPath(location);
}
function staticHandler(methodName) {
  return function() {
    invariant$1(false);
  };
}
function noop$7() {
}
/* @__PURE__ */ (function(_React$Component) {
  _inheritsLoose(StaticRouter, _React$Component);
  function StaticRouter() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.handlePush = function(location) {
      return _this.navigateTo(location, "PUSH");
    };
    _this.handleReplace = function(location) {
      return _this.navigateTo(location, "REPLACE");
    };
    _this.handleListen = function() {
      return noop$7;
    };
    _this.handleBlock = function() {
      return noop$7;
    };
    return _this;
  }
  var _proto = StaticRouter.prototype;
  _proto.navigateTo = function navigateTo(location, action) {
    var _this$props = this.props, _this$props$basename = _this$props.basename, basename = _this$props$basename === void 0 ? "" : _this$props$basename, _this$props$context = _this$props.context, context2 = _this$props$context === void 0 ? {} : _this$props$context;
    context2.action = action;
    context2.location = addBasename(basename, createLocation(location));
    context2.url = createURL(context2.location);
  };
  _proto.render = function render4() {
    var _this$props2 = this.props, _this$props2$basename = _this$props2.basename, basename = _this$props2$basename === void 0 ? "" : _this$props2$basename, _this$props2$context = _this$props2.context, context2 = _this$props2$context === void 0 ? {} : _this$props2$context, _this$props2$location = _this$props2.location, location = _this$props2$location === void 0 ? "/" : _this$props2$location, rest = _objectWithoutPropertiesLoose$2(_this$props2, ["basename", "context", "location"]);
    var history = {
      createHref: function createHref(path) {
        return addLeadingSlash(basename + createURL(path));
      },
      action: "POP",
      location: stripBasename(basename, createLocation(location)),
      push: this.handlePush,
      replace: this.handleReplace,
      go: staticHandler(),
      goBack: staticHandler(),
      goForward: staticHandler(),
      listen: this.handleListen,
      block: this.handleBlock
    };
    return React__default.createElement(Router, _extends$g({}, rest, {
      history,
      staticContext: context2
    }));
  };
  return StaticRouter;
})(React__default.Component);
var Switch$2 = /* @__PURE__ */ function(_React$Component) {
  _inheritsLoose(Switch2, _React$Component);
  function Switch2() {
    return _React$Component.apply(this, arguments) || this;
  }
  var _proto = Switch2.prototype;
  _proto.render = function render4() {
    var _this = this;
    return React__default.createElement(context.Consumer, null, function(context2) {
      !context2 ? invariant$1(false) : void 0;
      var location = _this.props.location || context2.location;
      var element, match2;
      React__default.Children.forEach(_this.props.children, function(child) {
        if (match2 == null && React__default.isValidElement(child)) {
          element = child;
          var path = child.props.path || child.props.from;
          match2 = path ? matchPath(location.pathname, _extends$g({}, child.props, {
            path
          })) : context2.match;
        }
      });
      return match2 ? React__default.cloneElement(element, {
        location,
        computedMatch: match2
      }) : null;
    });
  };
  return Switch2;
}(React__default.Component);
var useContext = React__default.useContext;
function useHistory() {
  return useContext(historyContext);
}
function useLocation() {
  return useContext(context).location;
}
function useParams() {
  var match2 = useContext(context).match;
  return match2 ? match2.params : {};
}
function useRouteMatch(path) {
  var location = useLocation();
  var match2 = useContext(context).match;
  return path ? matchPath(location.pathname, path) : match2;
}
var shams = function hasSymbols() {
  if (typeof Symbol !== "function" || typeof Object.getOwnPropertySymbols !== "function") {
    return false;
  }
  if (typeof Symbol.iterator === "symbol") {
    return true;
  }
  var obj = {};
  var sym = Symbol("test");
  var symObj = Object(sym);
  if (typeof sym === "string") {
    return false;
  }
  if (Object.prototype.toString.call(sym) !== "[object Symbol]") {
    return false;
  }
  if (Object.prototype.toString.call(symObj) !== "[object Symbol]") {
    return false;
  }
  var symVal = 42;
  obj[sym] = symVal;
  for (sym in obj) {
    return false;
  }
  if (typeof Object.keys === "function" && Object.keys(obj).length !== 0) {
    return false;
  }
  if (typeof Object.getOwnPropertyNames === "function" && Object.getOwnPropertyNames(obj).length !== 0) {
    return false;
  }
  var syms = Object.getOwnPropertySymbols(obj);
  if (syms.length !== 1 || syms[0] !== sym) {
    return false;
  }
  if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) {
    return false;
  }
  if (typeof Object.getOwnPropertyDescriptor === "function") {
    var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
    if (descriptor.value !== symVal || descriptor.enumerable !== true) {
      return false;
    }
  }
  return true;
};
var origSymbol = typeof Symbol !== "undefined" && Symbol;
var hasSymbolSham = shams;
var hasSymbols$1 = function hasNativeSymbols() {
  if (typeof origSymbol !== "function") {
    return false;
  }
  if (typeof Symbol !== "function") {
    return false;
  }
  if (typeof origSymbol("foo") !== "symbol") {
    return false;
  }
  if (typeof Symbol("bar") !== "symbol") {
    return false;
  }
  return hasSymbolSham();
};
var ERROR_MESSAGE = "Function.prototype.bind called on incompatible ";
var slice = Array.prototype.slice;
var toStr$1 = Object.prototype.toString;
var funcType = "[object Function]";
var implementation$1 = function bind(that) {
  var target = this;
  if (typeof target !== "function" || toStr$1.call(target) !== funcType) {
    throw new TypeError(ERROR_MESSAGE + target);
  }
  var args = slice.call(arguments, 1);
  var bound;
  var binder = function() {
    if (this instanceof bound) {
      var result = target.apply(this, args.concat(slice.call(arguments)));
      if (Object(result) === result) {
        return result;
      }
      return this;
    } else {
      return target.apply(that, args.concat(slice.call(arguments)));
    }
  };
  var boundLength = Math.max(0, target.length - args.length);
  var boundArgs = [];
  for (var i2 = 0; i2 < boundLength; i2++) {
    boundArgs.push("$" + i2);
  }
  bound = Function("binder", "return function (" + boundArgs.join(",") + "){ return binder.apply(this,arguments); }")(binder);
  if (target.prototype) {
    var Empty = function Empty2() {
    };
    Empty.prototype = target.prototype;
    bound.prototype = new Empty();
    Empty.prototype = null;
  }
  return bound;
};
var implementation = implementation$1;
var functionBind = Function.prototype.bind || implementation;
var bind$4 = functionBind;
var src = bind$4.call(Function.call, Object.prototype.hasOwnProperty);
var undefined$1;
var $SyntaxError = SyntaxError;
var $Function = Function;
var $TypeError$1 = TypeError;
var getEvalledConstructor = function(expressionSyntax) {
  try {
    return $Function('"use strict"; return (' + expressionSyntax + ").constructor;")();
  } catch (e3) {
  }
};
var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
  try {
    $gOPD({}, "");
  } catch (e3) {
    $gOPD = null;
  }
}
var throwTypeError = function() {
  throw new $TypeError$1();
};
var ThrowTypeError = $gOPD ? function() {
  try {
    arguments.callee;
    return throwTypeError;
  } catch (calleeThrows) {
    try {
      return $gOPD(arguments, "callee").get;
    } catch (gOPDthrows) {
      return throwTypeError;
    }
  }
}() : throwTypeError;
var hasSymbols2 = hasSymbols$1();
var getProto = Object.getPrototypeOf || function(x2) {
  return x2.__proto__;
};
var needsEval = {};
var TypedArray = typeof Uint8Array === "undefined" ? undefined$1 : getProto(Uint8Array);
var INTRINSICS = {
  "%AggregateError%": typeof AggregateError === "undefined" ? undefined$1 : AggregateError,
  "%Array%": Array,
  "%ArrayBuffer%": typeof ArrayBuffer === "undefined" ? undefined$1 : ArrayBuffer,
  "%ArrayIteratorPrototype%": hasSymbols2 ? getProto([][Symbol.iterator]()) : undefined$1,
  "%AsyncFromSyncIteratorPrototype%": undefined$1,
  "%AsyncFunction%": needsEval,
  "%AsyncGenerator%": needsEval,
  "%AsyncGeneratorFunction%": needsEval,
  "%AsyncIteratorPrototype%": needsEval,
  "%Atomics%": typeof Atomics === "undefined" ? undefined$1 : Atomics,
  "%BigInt%": typeof BigInt === "undefined" ? undefined$1 : BigInt,
  "%Boolean%": Boolean,
  "%DataView%": typeof DataView === "undefined" ? undefined$1 : DataView,
  "%Date%": Date,
  "%decodeURI%": decodeURI,
  "%decodeURIComponent%": decodeURIComponent,
  "%encodeURI%": encodeURI,
  "%encodeURIComponent%": encodeURIComponent,
  "%Error%": Error,
  "%eval%": eval,
  "%EvalError%": EvalError,
  "%Float32Array%": typeof Float32Array === "undefined" ? undefined$1 : Float32Array,
  "%Float64Array%": typeof Float64Array === "undefined" ? undefined$1 : Float64Array,
  "%FinalizationRegistry%": typeof FinalizationRegistry === "undefined" ? undefined$1 : FinalizationRegistry,
  "%Function%": $Function,
  "%GeneratorFunction%": needsEval,
  "%Int8Array%": typeof Int8Array === "undefined" ? undefined$1 : Int8Array,
  "%Int16Array%": typeof Int16Array === "undefined" ? undefined$1 : Int16Array,
  "%Int32Array%": typeof Int32Array === "undefined" ? undefined$1 : Int32Array,
  "%isFinite%": isFinite,
  "%isNaN%": isNaN,
  "%IteratorPrototype%": hasSymbols2 ? getProto(getProto([][Symbol.iterator]())) : undefined$1,
  "%JSON%": typeof JSON === "object" ? JSON : undefined$1,
  "%Map%": typeof Map === "undefined" ? undefined$1 : Map,
  "%MapIteratorPrototype%": typeof Map === "undefined" || !hasSymbols2 ? undefined$1 : getProto((/* @__PURE__ */ new Map())[Symbol.iterator]()),
  "%Math%": Math,
  "%Number%": Number,
  "%Object%": Object,
  "%parseFloat%": parseFloat,
  "%parseInt%": parseInt,
  "%Promise%": typeof Promise === "undefined" ? undefined$1 : Promise,
  "%Proxy%": typeof Proxy === "undefined" ? undefined$1 : Proxy,
  "%RangeError%": RangeError,
  "%ReferenceError%": ReferenceError,
  "%Reflect%": typeof Reflect === "undefined" ? undefined$1 : Reflect,
  "%RegExp%": RegExp,
  "%Set%": typeof Set === "undefined" ? undefined$1 : Set,
  "%SetIteratorPrototype%": typeof Set === "undefined" || !hasSymbols2 ? undefined$1 : getProto((/* @__PURE__ */ new Set())[Symbol.iterator]()),
  "%SharedArrayBuffer%": typeof SharedArrayBuffer === "undefined" ? undefined$1 : SharedArrayBuffer,
  "%String%": String,
  "%StringIteratorPrototype%": hasSymbols2 ? getProto(""[Symbol.iterator]()) : undefined$1,
  "%Symbol%": hasSymbols2 ? Symbol : undefined$1,
  "%SyntaxError%": $SyntaxError,
  "%ThrowTypeError%": ThrowTypeError,
  "%TypedArray%": TypedArray,
  "%TypeError%": $TypeError$1,
  "%Uint8Array%": typeof Uint8Array === "undefined" ? undefined$1 : Uint8Array,
  "%Uint8ClampedArray%": typeof Uint8ClampedArray === "undefined" ? undefined$1 : Uint8ClampedArray,
  "%Uint16Array%": typeof Uint16Array === "undefined" ? undefined$1 : Uint16Array,
  "%Uint32Array%": typeof Uint32Array === "undefined" ? undefined$1 : Uint32Array,
  "%URIError%": URIError,
  "%WeakMap%": typeof WeakMap === "undefined" ? undefined$1 : WeakMap,
  "%WeakRef%": typeof WeakRef === "undefined" ? undefined$1 : WeakRef,
  "%WeakSet%": typeof WeakSet === "undefined" ? undefined$1 : WeakSet
};
var doEval = function doEval2(name2) {
  var value;
  if (name2 === "%AsyncFunction%") {
    value = getEvalledConstructor("async function () {}");
  } else if (name2 === "%GeneratorFunction%") {
    value = getEvalledConstructor("function* () {}");
  } else if (name2 === "%AsyncGeneratorFunction%") {
    value = getEvalledConstructor("async function* () {}");
  } else if (name2 === "%AsyncGenerator%") {
    var fn3 = doEval2("%AsyncGeneratorFunction%");
    if (fn3) {
      value = fn3.prototype;
    }
  } else if (name2 === "%AsyncIteratorPrototype%") {
    var gen = doEval2("%AsyncGenerator%");
    if (gen) {
      value = getProto(gen.prototype);
    }
  }
  INTRINSICS[name2] = value;
  return value;
};
var LEGACY_ALIASES = {
  "%ArrayBufferPrototype%": ["ArrayBuffer", "prototype"],
  "%ArrayPrototype%": ["Array", "prototype"],
  "%ArrayProto_entries%": ["Array", "prototype", "entries"],
  "%ArrayProto_forEach%": ["Array", "prototype", "forEach"],
  "%ArrayProto_keys%": ["Array", "prototype", "keys"],
  "%ArrayProto_values%": ["Array", "prototype", "values"],
  "%AsyncFunctionPrototype%": ["AsyncFunction", "prototype"],
  "%AsyncGenerator%": ["AsyncGeneratorFunction", "prototype"],
  "%AsyncGeneratorPrototype%": ["AsyncGeneratorFunction", "prototype", "prototype"],
  "%BooleanPrototype%": ["Boolean", "prototype"],
  "%DataViewPrototype%": ["DataView", "prototype"],
  "%DatePrototype%": ["Date", "prototype"],
  "%ErrorPrototype%": ["Error", "prototype"],
  "%EvalErrorPrototype%": ["EvalError", "prototype"],
  "%Float32ArrayPrototype%": ["Float32Array", "prototype"],
  "%Float64ArrayPrototype%": ["Float64Array", "prototype"],
  "%FunctionPrototype%": ["Function", "prototype"],
  "%Generator%": ["GeneratorFunction", "prototype"],
  "%GeneratorPrototype%": ["GeneratorFunction", "prototype", "prototype"],
  "%Int8ArrayPrototype%": ["Int8Array", "prototype"],
  "%Int16ArrayPrototype%": ["Int16Array", "prototype"],
  "%Int32ArrayPrototype%": ["Int32Array", "prototype"],
  "%JSONParse%": ["JSON", "parse"],
  "%JSONStringify%": ["JSON", "stringify"],
  "%MapPrototype%": ["Map", "prototype"],
  "%NumberPrototype%": ["Number", "prototype"],
  "%ObjectPrototype%": ["Object", "prototype"],
  "%ObjProto_toString%": ["Object", "prototype", "toString"],
  "%ObjProto_valueOf%": ["Object", "prototype", "valueOf"],
  "%PromisePrototype%": ["Promise", "prototype"],
  "%PromiseProto_then%": ["Promise", "prototype", "then"],
  "%Promise_all%": ["Promise", "all"],
  "%Promise_reject%": ["Promise", "reject"],
  "%Promise_resolve%": ["Promise", "resolve"],
  "%RangeErrorPrototype%": ["RangeError", "prototype"],
  "%ReferenceErrorPrototype%": ["ReferenceError", "prototype"],
  "%RegExpPrototype%": ["RegExp", "prototype"],
  "%SetPrototype%": ["Set", "prototype"],
  "%SharedArrayBufferPrototype%": ["SharedArrayBuffer", "prototype"],
  "%StringPrototype%": ["String", "prototype"],
  "%SymbolPrototype%": ["Symbol", "prototype"],
  "%SyntaxErrorPrototype%": ["SyntaxError", "prototype"],
  "%TypedArrayPrototype%": ["TypedArray", "prototype"],
  "%TypeErrorPrototype%": ["TypeError", "prototype"],
  "%Uint8ArrayPrototype%": ["Uint8Array", "prototype"],
  "%Uint8ClampedArrayPrototype%": ["Uint8ClampedArray", "prototype"],
  "%Uint16ArrayPrototype%": ["Uint16Array", "prototype"],
  "%Uint32ArrayPrototype%": ["Uint32Array", "prototype"],
  "%URIErrorPrototype%": ["URIError", "prototype"],
  "%WeakMapPrototype%": ["WeakMap", "prototype"],
  "%WeakSetPrototype%": ["WeakSet", "prototype"]
};
var bind$3 = functionBind;
var hasOwn$1 = src;
var $concat$1 = bind$3.call(Function.call, Array.prototype.concat);
var $spliceApply = bind$3.call(Function.apply, Array.prototype.splice);
var $replace$1 = bind$3.call(Function.call, String.prototype.replace);
var $strSlice = bind$3.call(Function.call, String.prototype.slice);
var rePropName$2 = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar$2 = /\\(\\)?/g;
var stringToPath$4 = function stringToPath(string) {
  var first = $strSlice(string, 0, 1);
  var last = $strSlice(string, -1);
  if (first === "%" && last !== "%") {
    throw new $SyntaxError("invalid intrinsic syntax, expected closing `%`");
  } else if (last === "%" && first !== "%") {
    throw new $SyntaxError("invalid intrinsic syntax, expected opening `%`");
  }
  var result = [];
  $replace$1(string, rePropName$2, function(match2, number, quote2, subString) {
    result[result.length] = quote2 ? $replace$1(subString, reEscapeChar$2, "$1") : number || match2;
  });
  return result;
};
var getBaseIntrinsic = function getBaseIntrinsic2(name2, allowMissing) {
  var intrinsicName = name2;
  var alias;
  if (hasOwn$1(LEGACY_ALIASES, intrinsicName)) {
    alias = LEGACY_ALIASES[intrinsicName];
    intrinsicName = "%" + alias[0] + "%";
  }
  if (hasOwn$1(INTRINSICS, intrinsicName)) {
    var value = INTRINSICS[intrinsicName];
    if (value === needsEval) {
      value = doEval(intrinsicName);
    }
    if (typeof value === "undefined" && !allowMissing) {
      throw new $TypeError$1("intrinsic " + name2 + " exists, but is not available. Please file an issue!");
    }
    return {
      alias,
      name: intrinsicName,
      value
    };
  }
  throw new $SyntaxError("intrinsic " + name2 + " does not exist!");
};
var getIntrinsic = function GetIntrinsic(name2, allowMissing) {
  if (typeof name2 !== "string" || name2.length === 0) {
    throw new $TypeError$1("intrinsic name must be a non-empty string");
  }
  if (arguments.length > 1 && typeof allowMissing !== "boolean") {
    throw new $TypeError$1('"allowMissing" argument must be a boolean');
  }
  var parts = stringToPath$4(name2);
  var intrinsicBaseName = parts.length > 0 ? parts[0] : "";
  var intrinsic = getBaseIntrinsic("%" + intrinsicBaseName + "%", allowMissing);
  var intrinsicRealName = intrinsic.name;
  var value = intrinsic.value;
  var skipFurtherCaching = false;
  var alias = intrinsic.alias;
  if (alias) {
    intrinsicBaseName = alias[0];
    $spliceApply(parts, $concat$1([0, 1], alias));
  }
  for (var i2 = 1, isOwn = true; i2 < parts.length; i2 += 1) {
    var part = parts[i2];
    var first = $strSlice(part, 0, 1);
    var last = $strSlice(part, -1);
    if ((first === '"' || first === "'" || first === "`" || (last === '"' || last === "'" || last === "`")) && first !== last) {
      throw new $SyntaxError("property names with quotes must have matching quotes");
    }
    if (part === "constructor" || !isOwn) {
      skipFurtherCaching = true;
    }
    intrinsicBaseName += "." + part;
    intrinsicRealName = "%" + intrinsicBaseName + "%";
    if (hasOwn$1(INTRINSICS, intrinsicRealName)) {
      value = INTRINSICS[intrinsicRealName];
    } else if (value != null) {
      if (!(part in value)) {
        if (!allowMissing) {
          throw new $TypeError$1("base intrinsic for " + name2 + " exists, but the property is not available.");
        }
        return void 0;
      }
      if ($gOPD && i2 + 1 >= parts.length) {
        var desc = $gOPD(value, part);
        isOwn = !!desc;
        if (isOwn && "get" in desc && !("originalValue" in desc.get)) {
          value = desc.get;
        } else {
          value = value[part];
        }
      } else {
        isOwn = hasOwn$1(value, part);
        value = value[part];
      }
      if (isOwn && !skipFurtherCaching) {
        INTRINSICS[intrinsicRealName] = value;
      }
    }
  }
  return value;
};
var callBind$1 = { exports: {} };
(function(module2) {
  var bind4 = functionBind;
  var GetIntrinsic3 = getIntrinsic;
  var $apply = GetIntrinsic3("%Function.prototype.apply%");
  var $call = GetIntrinsic3("%Function.prototype.call%");
  var $reflectApply = GetIntrinsic3("%Reflect.apply%", true) || bind4.call($call, $apply);
  var $gOPD2 = GetIntrinsic3("%Object.getOwnPropertyDescriptor%", true);
  var $defineProperty = GetIntrinsic3("%Object.defineProperty%", true);
  var $max = GetIntrinsic3("%Math.max%");
  if ($defineProperty) {
    try {
      $defineProperty({}, "a", { value: 1 });
    } catch (e3) {
      $defineProperty = null;
    }
  }
  module2.exports = function callBind2(originalFunction) {
    var func = $reflectApply(bind4, $call, arguments);
    if ($gOPD2 && $defineProperty) {
      var desc = $gOPD2(func, "length");
      if (desc.configurable) {
        $defineProperty(func, "length", { value: 1 + $max(0, originalFunction.length - (arguments.length - 1)) });
      }
    }
    return func;
  };
  var applyBind = function applyBind2() {
    return $reflectApply(bind4, $apply, arguments);
  };
  if ($defineProperty) {
    $defineProperty(module2.exports, "apply", { value: applyBind });
  } else {
    module2.exports.apply = applyBind;
  }
})(callBind$1);
var GetIntrinsic$1 = getIntrinsic;
var callBind = callBind$1.exports;
var $indexOf = callBind(GetIntrinsic$1("String.prototype.indexOf"));
var callBound$1 = function callBoundIntrinsic(name2, allowMissing) {
  var intrinsic = GetIntrinsic$1(name2, !!allowMissing);
  if (typeof intrinsic === "function" && $indexOf(name2, ".prototype.") > -1) {
    return callBind(intrinsic);
  }
  return intrinsic;
};
var __viteBrowserExternal = {};
var __viteBrowserExternal$1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  "default": __viteBrowserExternal
}, Symbol.toStringTag, { value: "Module" }));
var require$$0 = /* @__PURE__ */ getAugmentedNamespace(__viteBrowserExternal$1);
var hasMap = typeof Map === "function" && Map.prototype;
var mapSizeDescriptor = Object.getOwnPropertyDescriptor && hasMap ? Object.getOwnPropertyDescriptor(Map.prototype, "size") : null;
var mapSize = hasMap && mapSizeDescriptor && typeof mapSizeDescriptor.get === "function" ? mapSizeDescriptor.get : null;
var mapForEach = hasMap && Map.prototype.forEach;
var hasSet = typeof Set === "function" && Set.prototype;
var setSizeDescriptor = Object.getOwnPropertyDescriptor && hasSet ? Object.getOwnPropertyDescriptor(Set.prototype, "size") : null;
var setSize = hasSet && setSizeDescriptor && typeof setSizeDescriptor.get === "function" ? setSizeDescriptor.get : null;
var setForEach = hasSet && Set.prototype.forEach;
var hasWeakMap = typeof WeakMap === "function" && WeakMap.prototype;
var weakMapHas = hasWeakMap ? WeakMap.prototype.has : null;
var hasWeakSet = typeof WeakSet === "function" && WeakSet.prototype;
var weakSetHas = hasWeakSet ? WeakSet.prototype.has : null;
var hasWeakRef = typeof WeakRef === "function" && WeakRef.prototype;
var weakRefDeref = hasWeakRef ? WeakRef.prototype.deref : null;
var booleanValueOf = Boolean.prototype.valueOf;
var objectToString$5 = Object.prototype.toString;
var functionToString = Function.prototype.toString;
var $match = String.prototype.match;
var $slice = String.prototype.slice;
var $replace = String.prototype.replace;
var $toUpperCase = String.prototype.toUpperCase;
var $toLowerCase = String.prototype.toLowerCase;
var $test = RegExp.prototype.test;
var $concat = Array.prototype.concat;
var $join = Array.prototype.join;
var $arrSlice = Array.prototype.slice;
var $floor = Math.floor;
var bigIntValueOf = typeof BigInt === "function" ? BigInt.prototype.valueOf : null;
var gOPS = Object.getOwnPropertySymbols;
var symToString = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? Symbol.prototype.toString : null;
var hasShammedSymbols = typeof Symbol === "function" && typeof Symbol.iterator === "object";
var toStringTag = typeof Symbol === "function" && Symbol.toStringTag && (typeof Symbol.toStringTag === hasShammedSymbols ? "object" : "symbol") ? Symbol.toStringTag : null;
var isEnumerable = Object.prototype.propertyIsEnumerable;
var gPO = (typeof Reflect === "function" ? Reflect.getPrototypeOf : Object.getPrototypeOf) || ([].__proto__ === Array.prototype ? function(O2) {
  return O2.__proto__;
} : null);
function addNumericSeparator(num, str) {
  if (num === Infinity || num === -Infinity || num !== num || num && num > -1e3 && num < 1e3 || $test.call(/e/, str)) {
    return str;
  }
  var sepRegex = /[0-9](?=(?:[0-9]{3})+(?![0-9]))/g;
  if (typeof num === "number") {
    var int = num < 0 ? -$floor(-num) : $floor(num);
    if (int !== num) {
      var intStr = String(int);
      var dec = $slice.call(str, intStr.length + 1);
      return $replace.call(intStr, sepRegex, "$&_") + "." + $replace.call($replace.call(dec, /([0-9]{3})/g, "$&_"), /_$/, "");
    }
  }
  return $replace.call(str, sepRegex, "$&_");
}
var inspectCustom = require$$0.custom;
var inspectSymbol = inspectCustom && isSymbol$7(inspectCustom) ? inspectCustom : null;
var objectInspect = function inspect_(obj, options, depth, seen) {
  var opts = options || {};
  if (has$3(opts, "quoteStyle") && (opts.quoteStyle !== "single" && opts.quoteStyle !== "double")) {
    throw new TypeError('option "quoteStyle" must be "single" or "double"');
  }
  if (has$3(opts, "maxStringLength") && (typeof opts.maxStringLength === "number" ? opts.maxStringLength < 0 && opts.maxStringLength !== Infinity : opts.maxStringLength !== null)) {
    throw new TypeError('option "maxStringLength", if provided, must be a positive integer, Infinity, or `null`');
  }
  var customInspect = has$3(opts, "customInspect") ? opts.customInspect : true;
  if (typeof customInspect !== "boolean" && customInspect !== "symbol") {
    throw new TypeError("option \"customInspect\", if provided, must be `true`, `false`, or `'symbol'`");
  }
  if (has$3(opts, "indent") && opts.indent !== null && opts.indent !== "	" && !(parseInt(opts.indent, 10) === opts.indent && opts.indent > 0)) {
    throw new TypeError('option "indent" must be "\\t", an integer > 0, or `null`');
  }
  if (has$3(opts, "numericSeparator") && typeof opts.numericSeparator !== "boolean") {
    throw new TypeError('option "numericSeparator", if provided, must be `true` or `false`');
  }
  var numericSeparator = opts.numericSeparator;
  if (typeof obj === "undefined") {
    return "undefined";
  }
  if (obj === null) {
    return "null";
  }
  if (typeof obj === "boolean") {
    return obj ? "true" : "false";
  }
  if (typeof obj === "string") {
    return inspectString(obj, opts);
  }
  if (typeof obj === "number") {
    if (obj === 0) {
      return Infinity / obj > 0 ? "0" : "-0";
    }
    var str = String(obj);
    return numericSeparator ? addNumericSeparator(obj, str) : str;
  }
  if (typeof obj === "bigint") {
    var bigIntStr = String(obj) + "n";
    return numericSeparator ? addNumericSeparator(obj, bigIntStr) : bigIntStr;
  }
  var maxDepth = typeof opts.depth === "undefined" ? 5 : opts.depth;
  if (typeof depth === "undefined") {
    depth = 0;
  }
  if (depth >= maxDepth && maxDepth > 0 && typeof obj === "object") {
    return isArray$i(obj) ? "[Array]" : "[Object]";
  }
  var indent = getIndent(opts, depth);
  if (typeof seen === "undefined") {
    seen = [];
  } else if (indexOf(seen, obj) >= 0) {
    return "[Circular]";
  }
  function inspect2(value, from, noIndent) {
    if (from) {
      seen = $arrSlice.call(seen);
      seen.push(from);
    }
    if (noIndent) {
      var newOpts = {
        depth: opts.depth
      };
      if (has$3(opts, "quoteStyle")) {
        newOpts.quoteStyle = opts.quoteStyle;
      }
      return inspect_(value, newOpts, depth + 1, seen);
    }
    return inspect_(value, opts, depth + 1, seen);
  }
  if (typeof obj === "function") {
    var name2 = nameOf(obj);
    var keys2 = arrObjKeys(obj, inspect2);
    return "[Function" + (name2 ? ": " + name2 : " (anonymous)") + "]" + (keys2.length > 0 ? " { " + $join.call(keys2, ", ") + " }" : "");
  }
  if (isSymbol$7(obj)) {
    var symString = hasShammedSymbols ? $replace.call(String(obj), /^(Symbol\(.*\))_[^)]*$/, "$1") : symToString.call(obj);
    return typeof obj === "object" && !hasShammedSymbols ? markBoxed(symString) : symString;
  }
  if (isElement$3(obj)) {
    var s3 = "<" + $toLowerCase.call(String(obj.nodeName));
    var attrs = obj.attributes || [];
    for (var i2 = 0; i2 < attrs.length; i2++) {
      s3 += " " + attrs[i2].name + "=" + wrapQuotes(quote(attrs[i2].value), "double", opts);
    }
    s3 += ">";
    if (obj.childNodes && obj.childNodes.length) {
      s3 += "...";
    }
    s3 += "</" + $toLowerCase.call(String(obj.nodeName)) + ">";
    return s3;
  }
  if (isArray$i(obj)) {
    if (obj.length === 0) {
      return "[]";
    }
    var xs = arrObjKeys(obj, inspect2);
    if (indent && !singleLineValues(xs)) {
      return "[" + indentedJoin(xs, indent) + "]";
    }
    return "[ " + $join.call(xs, ", ") + " ]";
  }
  if (isError(obj)) {
    var parts = arrObjKeys(obj, inspect2);
    if ("cause" in obj && !isEnumerable.call(obj, "cause")) {
      return "{ [" + String(obj) + "] " + $join.call($concat.call("[cause]: " + inspect2(obj.cause), parts), ", ") + " }";
    }
    if (parts.length === 0) {
      return "[" + String(obj) + "]";
    }
    return "{ [" + String(obj) + "] " + $join.call(parts, ", ") + " }";
  }
  if (typeof obj === "object" && customInspect) {
    if (inspectSymbol && typeof obj[inspectSymbol] === "function") {
      return obj[inspectSymbol]();
    } else if (customInspect !== "symbol" && typeof obj.inspect === "function") {
      return obj.inspect();
    }
  }
  if (isMap$2(obj)) {
    var mapParts = [];
    mapForEach.call(obj, function(value, key) {
      mapParts.push(inspect2(key, obj, true) + " => " + inspect2(value, obj));
    });
    return collectionOf("Map", mapSize.call(obj), mapParts, indent);
  }
  if (isSet$2(obj)) {
    var setParts = [];
    setForEach.call(obj, function(value) {
      setParts.push(inspect2(value, obj));
    });
    return collectionOf("Set", setSize.call(obj), setParts, indent);
  }
  if (isWeakMap(obj)) {
    return weakCollectionOf("WeakMap");
  }
  if (isWeakSet(obj)) {
    return weakCollectionOf("WeakSet");
  }
  if (isWeakRef(obj)) {
    return weakCollectionOf("WeakRef");
  }
  if (isNumber$1(obj)) {
    return markBoxed(inspect2(Number(obj)));
  }
  if (isBigInt(obj)) {
    return markBoxed(inspect2(bigIntValueOf.call(obj)));
  }
  if (isBoolean(obj)) {
    return markBoxed(booleanValueOf.call(obj));
  }
  if (isString$2(obj)) {
    return markBoxed(inspect2(String(obj)));
  }
  if (!isDate$3(obj) && !isRegExp$1(obj)) {
    var ys = arrObjKeys(obj, inspect2);
    var isPlainObject2 = gPO ? gPO(obj) === Object.prototype : obj instanceof Object || obj.constructor === Object;
    var protoTag = obj instanceof Object ? "" : "null prototype";
    var stringTag2 = !isPlainObject2 && toStringTag && Object(obj) === obj && toStringTag in obj ? $slice.call(toStr(obj), 8, -1) : protoTag ? "Object" : "";
    var constructorTag = isPlainObject2 || typeof obj.constructor !== "function" ? "" : obj.constructor.name ? obj.constructor.name + " " : "";
    var tag = constructorTag + (stringTag2 || protoTag ? "[" + $join.call($concat.call([], stringTag2 || [], protoTag || []), ": ") + "] " : "");
    if (ys.length === 0) {
      return tag + "{}";
    }
    if (indent) {
      return tag + "{" + indentedJoin(ys, indent) + "}";
    }
    return tag + "{ " + $join.call(ys, ", ") + " }";
  }
  return String(obj);
};
function wrapQuotes(s3, defaultStyle, opts) {
  var quoteChar = (opts.quoteStyle || defaultStyle) === "double" ? '"' : "'";
  return quoteChar + s3 + quoteChar;
}
function quote(s3) {
  return $replace.call(String(s3), /"/g, "&quot;");
}
function isArray$i(obj) {
  return toStr(obj) === "[object Array]" && (!toStringTag || !(typeof obj === "object" && toStringTag in obj));
}
function isDate$3(obj) {
  return toStr(obj) === "[object Date]" && (!toStringTag || !(typeof obj === "object" && toStringTag in obj));
}
function isRegExp$1(obj) {
  return toStr(obj) === "[object RegExp]" && (!toStringTag || !(typeof obj === "object" && toStringTag in obj));
}
function isError(obj) {
  return toStr(obj) === "[object Error]" && (!toStringTag || !(typeof obj === "object" && toStringTag in obj));
}
function isString$2(obj) {
  return toStr(obj) === "[object String]" && (!toStringTag || !(typeof obj === "object" && toStringTag in obj));
}
function isNumber$1(obj) {
  return toStr(obj) === "[object Number]" && (!toStringTag || !(typeof obj === "object" && toStringTag in obj));
}
function isBoolean(obj) {
  return toStr(obj) === "[object Boolean]" && (!toStringTag || !(typeof obj === "object" && toStringTag in obj));
}
function isSymbol$7(obj) {
  if (hasShammedSymbols) {
    return obj && typeof obj === "object" && obj instanceof Symbol;
  }
  if (typeof obj === "symbol") {
    return true;
  }
  if (!obj || typeof obj !== "object" || !symToString) {
    return false;
  }
  try {
    symToString.call(obj);
    return true;
  } catch (e3) {
  }
  return false;
}
function isBigInt(obj) {
  if (!obj || typeof obj !== "object" || !bigIntValueOf) {
    return false;
  }
  try {
    bigIntValueOf.call(obj);
    return true;
  } catch (e3) {
  }
  return false;
}
var hasOwn = Object.prototype.hasOwnProperty || function(key) {
  return key in this;
};
function has$3(obj, key) {
  return hasOwn.call(obj, key);
}
function toStr(obj) {
  return objectToString$5.call(obj);
}
function nameOf(f2) {
  if (f2.name) {
    return f2.name;
  }
  var m4 = $match.call(functionToString.call(f2), /^function\s*([\w$]+)/);
  if (m4) {
    return m4[1];
  }
  return null;
}
function indexOf(xs, x2) {
  if (xs.indexOf) {
    return xs.indexOf(x2);
  }
  for (var i2 = 0, l2 = xs.length; i2 < l2; i2++) {
    if (xs[i2] === x2) {
      return i2;
    }
  }
  return -1;
}
function isMap$2(x2) {
  if (!mapSize || !x2 || typeof x2 !== "object") {
    return false;
  }
  try {
    mapSize.call(x2);
    try {
      setSize.call(x2);
    } catch (s3) {
      return true;
    }
    return x2 instanceof Map;
  } catch (e3) {
  }
  return false;
}
function isWeakMap(x2) {
  if (!weakMapHas || !x2 || typeof x2 !== "object") {
    return false;
  }
  try {
    weakMapHas.call(x2, weakMapHas);
    try {
      weakSetHas.call(x2, weakSetHas);
    } catch (s3) {
      return true;
    }
    return x2 instanceof WeakMap;
  } catch (e3) {
  }
  return false;
}
function isWeakRef(x2) {
  if (!weakRefDeref || !x2 || typeof x2 !== "object") {
    return false;
  }
  try {
    weakRefDeref.call(x2);
    return true;
  } catch (e3) {
  }
  return false;
}
function isSet$2(x2) {
  if (!setSize || !x2 || typeof x2 !== "object") {
    return false;
  }
  try {
    setSize.call(x2);
    try {
      mapSize.call(x2);
    } catch (m4) {
      return true;
    }
    return x2 instanceof Set;
  } catch (e3) {
  }
  return false;
}
function isWeakSet(x2) {
  if (!weakSetHas || !x2 || typeof x2 !== "object") {
    return false;
  }
  try {
    weakSetHas.call(x2, weakSetHas);
    try {
      weakMapHas.call(x2, weakMapHas);
    } catch (s3) {
      return true;
    }
    return x2 instanceof WeakSet;
  } catch (e3) {
  }
  return false;
}
function isElement$3(x2) {
  if (!x2 || typeof x2 !== "object") {
    return false;
  }
  if (typeof HTMLElement !== "undefined" && x2 instanceof HTMLElement) {
    return true;
  }
  return typeof x2.nodeName === "string" && typeof x2.getAttribute === "function";
}
function inspectString(str, opts) {
  if (str.length > opts.maxStringLength) {
    var remaining = str.length - opts.maxStringLength;
    var trailer = "... " + remaining + " more character" + (remaining > 1 ? "s" : "");
    return inspectString($slice.call(str, 0, opts.maxStringLength), opts) + trailer;
  }
  var s3 = $replace.call($replace.call(str, /(['\\])/g, "\\$1"), /[\x00-\x1f]/g, lowbyte);
  return wrapQuotes(s3, "single", opts);
}
function lowbyte(c7) {
  var n2 = c7.charCodeAt(0);
  var x2 = {
    8: "b",
    9: "t",
    10: "n",
    12: "f",
    13: "r"
  }[n2];
  if (x2) {
    return "\\" + x2;
  }
  return "\\x" + (n2 < 16 ? "0" : "") + $toUpperCase.call(n2.toString(16));
}
function markBoxed(str) {
  return "Object(" + str + ")";
}
function weakCollectionOf(type) {
  return type + " { ? }";
}
function collectionOf(type, size, entries, indent) {
  var joinedEntries = indent ? indentedJoin(entries, indent) : $join.call(entries, ", ");
  return type + " (" + size + ") {" + joinedEntries + "}";
}
function singleLineValues(xs) {
  for (var i2 = 0; i2 < xs.length; i2++) {
    if (indexOf(xs[i2], "\n") >= 0) {
      return false;
    }
  }
  return true;
}
function getIndent(opts, depth) {
  var baseIndent;
  if (opts.indent === "	") {
    baseIndent = "	";
  } else if (typeof opts.indent === "number" && opts.indent > 0) {
    baseIndent = $join.call(Array(opts.indent + 1), " ");
  } else {
    return null;
  }
  return {
    base: baseIndent,
    prev: $join.call(Array(depth + 1), baseIndent)
  };
}
function indentedJoin(xs, indent) {
  if (xs.length === 0) {
    return "";
  }
  var lineJoiner = "\n" + indent.prev + indent.base;
  return lineJoiner + $join.call(xs, "," + lineJoiner) + "\n" + indent.prev;
}
function arrObjKeys(obj, inspect2) {
  var isArr = isArray$i(obj);
  var xs = [];
  if (isArr) {
    xs.length = obj.length;
    for (var i2 = 0; i2 < obj.length; i2++) {
      xs[i2] = has$3(obj, i2) ? inspect2(obj[i2], obj) : "";
    }
  }
  var syms = typeof gOPS === "function" ? gOPS(obj) : [];
  var symMap;
  if (hasShammedSymbols) {
    symMap = {};
    for (var k3 = 0; k3 < syms.length; k3++) {
      symMap["$" + syms[k3]] = syms[k3];
    }
  }
  for (var key in obj) {
    if (!has$3(obj, key)) {
      continue;
    }
    if (isArr && String(Number(key)) === key && key < obj.length) {
      continue;
    }
    if (hasShammedSymbols && symMap["$" + key] instanceof Symbol) {
      continue;
    } else if ($test.call(/[^\w$]/, key)) {
      xs.push(inspect2(key, obj) + ": " + inspect2(obj[key], obj));
    } else {
      xs.push(key + ": " + inspect2(obj[key], obj));
    }
  }
  if (typeof gOPS === "function") {
    for (var j = 0; j < syms.length; j++) {
      if (isEnumerable.call(obj, syms[j])) {
        xs.push("[" + inspect2(syms[j]) + "]: " + inspect2(obj[syms[j]], obj));
      }
    }
  }
  return xs;
}
var GetIntrinsic2 = getIntrinsic;
var callBound = callBound$1;
var inspect = objectInspect;
var $TypeError = GetIntrinsic2("%TypeError%");
var $WeakMap = GetIntrinsic2("%WeakMap%", true);
var $Map = GetIntrinsic2("%Map%", true);
var $weakMapGet = callBound("WeakMap.prototype.get", true);
var $weakMapSet = callBound("WeakMap.prototype.set", true);
var $weakMapHas = callBound("WeakMap.prototype.has", true);
var $mapGet = callBound("Map.prototype.get", true);
var $mapSet = callBound("Map.prototype.set", true);
var $mapHas = callBound("Map.prototype.has", true);
var listGetNode = function(list, key) {
  for (var prev = list, curr; (curr = prev.next) !== null; prev = curr) {
    if (curr.key === key) {
      prev.next = curr.next;
      curr.next = list.next;
      list.next = curr;
      return curr;
    }
  }
};
var listGet = function(objects, key) {
  var node = listGetNode(objects, key);
  return node && node.value;
};
var listSet = function(objects, key, value) {
  var node = listGetNode(objects, key);
  if (node) {
    node.value = value;
  } else {
    objects.next = {
      key,
      next: objects.next,
      value
    };
  }
};
var listHas = function(objects, key) {
  return !!listGetNode(objects, key);
};
var sideChannel = function getSideChannel() {
  var $wm;
  var $m;
  var $o;
  var channel = {
    assert: function(key) {
      if (!channel.has(key)) {
        throw new $TypeError("Side channel does not contain " + inspect(key));
      }
    },
    get: function(key) {
      if ($WeakMap && key && (typeof key === "object" || typeof key === "function")) {
        if ($wm) {
          return $weakMapGet($wm, key);
        }
      } else if ($Map) {
        if ($m) {
          return $mapGet($m, key);
        }
      } else {
        if ($o) {
          return listGet($o, key);
        }
      }
    },
    has: function(key) {
      if ($WeakMap && key && (typeof key === "object" || typeof key === "function")) {
        if ($wm) {
          return $weakMapHas($wm, key);
        }
      } else if ($Map) {
        if ($m) {
          return $mapHas($m, key);
        }
      } else {
        if ($o) {
          return listHas($o, key);
        }
      }
      return false;
    },
    set: function(key, value) {
      if ($WeakMap && key && (typeof key === "object" || typeof key === "function")) {
        if (!$wm) {
          $wm = new $WeakMap();
        }
        $weakMapSet($wm, key, value);
      } else if ($Map) {
        if (!$m) {
          $m = new $Map();
        }
        $mapSet($m, key, value);
      } else {
        if (!$o) {
          $o = { key: {}, next: null };
        }
        listSet($o, key, value);
      }
    }
  };
  return channel;
};
var replace = String.prototype.replace;
var percentTwenties = /%20/g;
var Format = {
  RFC1738: "RFC1738",
  RFC3986: "RFC3986"
};
var formats$3 = {
  "default": Format.RFC3986,
  formatters: {
    RFC1738: function(value) {
      return replace.call(value, percentTwenties, "+");
    },
    RFC3986: function(value) {
      return String(value);
    }
  },
  RFC1738: Format.RFC1738,
  RFC3986: Format.RFC3986
};
var formats$2 = formats$3;
var has$2 = Object.prototype.hasOwnProperty;
var isArray$h = Array.isArray;
var hexTable = function() {
  var array = [];
  for (var i2 = 0; i2 < 256; ++i2) {
    array.push("%" + ((i2 < 16 ? "0" : "") + i2.toString(16)).toUpperCase());
  }
  return array;
}();
var compactQueue = function compactQueue2(queue) {
  while (queue.length > 1) {
    var item2 = queue.pop();
    var obj = item2.obj[item2.prop];
    if (isArray$h(obj)) {
      var compacted = [];
      for (var j = 0; j < obj.length; ++j) {
        if (typeof obj[j] !== "undefined") {
          compacted.push(obj[j]);
        }
      }
      item2.obj[item2.prop] = compacted;
    }
  }
};
var arrayToObject = function arrayToObject2(source2, options) {
  var obj = options && options.plainObjects ? /* @__PURE__ */ Object.create(null) : {};
  for (var i2 = 0; i2 < source2.length; ++i2) {
    if (typeof source2[i2] !== "undefined") {
      obj[i2] = source2[i2];
    }
  }
  return obj;
};
var merge$3 = function merge(target, source2, options) {
  if (!source2) {
    return target;
  }
  if (typeof source2 !== "object") {
    if (isArray$h(target)) {
      target.push(source2);
    } else if (target && typeof target === "object") {
      if (options && (options.plainObjects || options.allowPrototypes) || !has$2.call(Object.prototype, source2)) {
        target[source2] = true;
      }
    } else {
      return [target, source2];
    }
    return target;
  }
  if (!target || typeof target !== "object") {
    return [target].concat(source2);
  }
  var mergeTarget = target;
  if (isArray$h(target) && !isArray$h(source2)) {
    mergeTarget = arrayToObject(target, options);
  }
  if (isArray$h(target) && isArray$h(source2)) {
    source2.forEach(function(item2, i2) {
      if (has$2.call(target, i2)) {
        var targetItem = target[i2];
        if (targetItem && typeof targetItem === "object" && item2 && typeof item2 === "object") {
          target[i2] = merge(targetItem, item2, options);
        } else {
          target.push(item2);
        }
      } else {
        target[i2] = item2;
      }
    });
    return target;
  }
  return Object.keys(source2).reduce(function(acc, key) {
    var value = source2[key];
    if (has$2.call(acc, key)) {
      acc[key] = merge(acc[key], value, options);
    } else {
      acc[key] = value;
    }
    return acc;
  }, mergeTarget);
};
var assign$2 = function assignSingleSource(target, source2) {
  return Object.keys(source2).reduce(function(acc, key) {
    acc[key] = source2[key];
    return acc;
  }, target);
};
var decode = function(str, decoder2, charset) {
  var strWithoutPlus = str.replace(/\+/g, " ");
  if (charset === "iso-8859-1") {
    return strWithoutPlus.replace(/%[0-9a-f]{2}/gi, unescape);
  }
  try {
    return decodeURIComponent(strWithoutPlus);
  } catch (e3) {
    return strWithoutPlus;
  }
};
var encode$1 = function encode(str, defaultEncoder, charset, kind, format3) {
  if (str.length === 0) {
    return str;
  }
  var string = str;
  if (typeof str === "symbol") {
    string = Symbol.prototype.toString.call(str);
  } else if (typeof str !== "string") {
    string = String(str);
  }
  if (charset === "iso-8859-1") {
    return escape(string).replace(/%u[0-9a-f]{4}/gi, function($0) {
      return "%26%23" + parseInt($0.slice(2), 16) + "%3B";
    });
  }
  var out = "";
  for (var i2 = 0; i2 < string.length; ++i2) {
    var c7 = string.charCodeAt(i2);
    if (c7 === 45 || c7 === 46 || c7 === 95 || c7 === 126 || c7 >= 48 && c7 <= 57 || c7 >= 65 && c7 <= 90 || c7 >= 97 && c7 <= 122 || format3 === formats$2.RFC1738 && (c7 === 40 || c7 === 41)) {
      out += string.charAt(i2);
      continue;
    }
    if (c7 < 128) {
      out = out + hexTable[c7];
      continue;
    }
    if (c7 < 2048) {
      out = out + (hexTable[192 | c7 >> 6] + hexTable[128 | c7 & 63]);
      continue;
    }
    if (c7 < 55296 || c7 >= 57344) {
      out = out + (hexTable[224 | c7 >> 12] + hexTable[128 | c7 >> 6 & 63] + hexTable[128 | c7 & 63]);
      continue;
    }
    i2 += 1;
    c7 = 65536 + ((c7 & 1023) << 10 | string.charCodeAt(i2) & 1023);
    out += hexTable[240 | c7 >> 18] + hexTable[128 | c7 >> 12 & 63] + hexTable[128 | c7 >> 6 & 63] + hexTable[128 | c7 & 63];
  }
  return out;
};
var compact = function compact2(value) {
  var queue = [{ obj: { o: value }, prop: "o" }];
  var refs = [];
  for (var i2 = 0; i2 < queue.length; ++i2) {
    var item2 = queue[i2];
    var obj = item2.obj[item2.prop];
    var keys2 = Object.keys(obj);
    for (var j = 0; j < keys2.length; ++j) {
      var key = keys2[j];
      var val = obj[key];
      if (typeof val === "object" && val !== null && refs.indexOf(val) === -1) {
        queue.push({ obj, prop: key });
        refs.push(val);
      }
    }
  }
  compactQueue(queue);
  return value;
};
var isRegExp = function isRegExp2(obj) {
  return Object.prototype.toString.call(obj) === "[object RegExp]";
};
var isBuffer$7 = function isBuffer(obj) {
  if (!obj || typeof obj !== "object") {
    return false;
  }
  return !!(obj.constructor && obj.constructor.isBuffer && obj.constructor.isBuffer(obj));
};
var combine$1 = function combine(a3, b3) {
  return [].concat(a3, b3);
};
var maybeMap = function maybeMap2(val, fn3) {
  if (isArray$h(val)) {
    var mapped = [];
    for (var i2 = 0; i2 < val.length; i2 += 1) {
      mapped.push(fn3(val[i2]));
    }
    return mapped;
  }
  return fn3(val);
};
var utils$i = {
  arrayToObject,
  assign: assign$2,
  combine: combine$1,
  compact,
  decode,
  encode: encode$1,
  isBuffer: isBuffer$7,
  isRegExp,
  maybeMap,
  merge: merge$3
};
var getSideChannel2 = sideChannel;
var utils$h = utils$i;
var formats$1 = formats$3;
var has$1 = Object.prototype.hasOwnProperty;
var arrayPrefixGenerators = {
  brackets: function brackets(prefix2) {
    return prefix2 + "[]";
  },
  comma: "comma",
  indices: function indices(prefix2, key) {
    return prefix2 + "[" + key + "]";
  },
  repeat: function repeat(prefix2) {
    return prefix2;
  }
};
var isArray$g = Array.isArray;
var split = String.prototype.split;
var push = Array.prototype.push;
var pushToArray = function(arr, valueOrArray) {
  push.apply(arr, isArray$g(valueOrArray) ? valueOrArray : [valueOrArray]);
};
var toISO = Date.prototype.toISOString;
var defaultFormat$1 = formats$1["default"];
var defaults$6 = {
  addQueryPrefix: false,
  allowDots: false,
  charset: "utf-8",
  charsetSentinel: false,
  delimiter: "&",
  encode: true,
  encoder: utils$h.encode,
  encodeValuesOnly: false,
  format: defaultFormat$1,
  formatter: formats$1.formatters[defaultFormat$1],
  indices: false,
  serializeDate: function serializeDate(date) {
    return toISO.call(date);
  },
  skipNulls: false,
  strictNullHandling: false
};
var isNonNullishPrimitive = function isNonNullishPrimitive2(v2) {
  return typeof v2 === "string" || typeof v2 === "number" || typeof v2 === "boolean" || typeof v2 === "symbol" || typeof v2 === "bigint";
};
var sentinel = {};
var stringify$1 = function stringify(object, prefix2, generateArrayPrefix, strictNullHandling, skipNulls, encoder, filter, sort, allowDots, serializeDate2, format3, formatter, encodeValuesOnly, charset, sideChannel2) {
  var obj = object;
  var tmpSc = sideChannel2;
  var step = 0;
  var findFlag = false;
  while ((tmpSc = tmpSc.get(sentinel)) !== void 0 && !findFlag) {
    var pos = tmpSc.get(object);
    step += 1;
    if (typeof pos !== "undefined") {
      if (pos === step) {
        throw new RangeError("Cyclic object value");
      } else {
        findFlag = true;
      }
    }
    if (typeof tmpSc.get(sentinel) === "undefined") {
      step = 0;
    }
  }
  if (typeof filter === "function") {
    obj = filter(prefix2, obj);
  } else if (obj instanceof Date) {
    obj = serializeDate2(obj);
  } else if (generateArrayPrefix === "comma" && isArray$g(obj)) {
    obj = utils$h.maybeMap(obj, function(value2) {
      if (value2 instanceof Date) {
        return serializeDate2(value2);
      }
      return value2;
    });
  }
  if (obj === null) {
    if (strictNullHandling) {
      return encoder && !encodeValuesOnly ? encoder(prefix2, defaults$6.encoder, charset, "key", format3) : prefix2;
    }
    obj = "";
  }
  if (isNonNullishPrimitive(obj) || utils$h.isBuffer(obj)) {
    if (encoder) {
      var keyValue = encodeValuesOnly ? prefix2 : encoder(prefix2, defaults$6.encoder, charset, "key", format3);
      if (generateArrayPrefix === "comma" && encodeValuesOnly) {
        var valuesArray = split.call(String(obj), ",");
        var valuesJoined = "";
        for (var i2 = 0; i2 < valuesArray.length; ++i2) {
          valuesJoined += (i2 === 0 ? "" : ",") + formatter(encoder(valuesArray[i2], defaults$6.encoder, charset, "value", format3));
        }
        return [formatter(keyValue) + "=" + valuesJoined];
      }
      return [formatter(keyValue) + "=" + formatter(encoder(obj, defaults$6.encoder, charset, "value", format3))];
    }
    return [formatter(prefix2) + "=" + formatter(String(obj))];
  }
  var values2 = [];
  if (typeof obj === "undefined") {
    return values2;
  }
  var objKeys;
  if (generateArrayPrefix === "comma" && isArray$g(obj)) {
    objKeys = [{ value: obj.length > 0 ? obj.join(",") || null : void 0 }];
  } else if (isArray$g(filter)) {
    objKeys = filter;
  } else {
    var keys2 = Object.keys(obj);
    objKeys = sort ? keys2.sort(sort) : keys2;
  }
  for (var j = 0; j < objKeys.length; ++j) {
    var key = objKeys[j];
    var value = typeof key === "object" && typeof key.value !== "undefined" ? key.value : obj[key];
    if (skipNulls && value === null) {
      continue;
    }
    var keyPrefix = isArray$g(obj) ? typeof generateArrayPrefix === "function" ? generateArrayPrefix(prefix2, key) : prefix2 : prefix2 + (allowDots ? "." + key : "[" + key + "]");
    sideChannel2.set(object, step);
    var valueSideChannel = getSideChannel2();
    valueSideChannel.set(sentinel, sideChannel2);
    pushToArray(values2, stringify(value, keyPrefix, generateArrayPrefix, strictNullHandling, skipNulls, encoder, filter, sort, allowDots, serializeDate2, format3, formatter, encodeValuesOnly, charset, valueSideChannel));
  }
  return values2;
};
var normalizeStringifyOptions = function normalizeStringifyOptions2(opts) {
  if (!opts) {
    return defaults$6;
  }
  if (opts.encoder !== null && typeof opts.encoder !== "undefined" && typeof opts.encoder !== "function") {
    throw new TypeError("Encoder has to be a function.");
  }
  var charset = opts.charset || defaults$6.charset;
  if (typeof opts.charset !== "undefined" && opts.charset !== "utf-8" && opts.charset !== "iso-8859-1") {
    throw new TypeError("The charset option must be either utf-8, iso-8859-1, or undefined");
  }
  var format3 = formats$1["default"];
  if (typeof opts.format !== "undefined") {
    if (!has$1.call(formats$1.formatters, opts.format)) {
      throw new TypeError("Unknown format option provided.");
    }
    format3 = opts.format;
  }
  var formatter = formats$1.formatters[format3];
  var filter = defaults$6.filter;
  if (typeof opts.filter === "function" || isArray$g(opts.filter)) {
    filter = opts.filter;
  }
  return {
    addQueryPrefix: typeof opts.addQueryPrefix === "boolean" ? opts.addQueryPrefix : defaults$6.addQueryPrefix,
    allowDots: typeof opts.allowDots === "undefined" ? defaults$6.allowDots : !!opts.allowDots,
    charset,
    charsetSentinel: typeof opts.charsetSentinel === "boolean" ? opts.charsetSentinel : defaults$6.charsetSentinel,
    delimiter: typeof opts.delimiter === "undefined" ? defaults$6.delimiter : opts.delimiter,
    encode: typeof opts.encode === "boolean" ? opts.encode : defaults$6.encode,
    encoder: typeof opts.encoder === "function" ? opts.encoder : defaults$6.encoder,
    encodeValuesOnly: typeof opts.encodeValuesOnly === "boolean" ? opts.encodeValuesOnly : defaults$6.encodeValuesOnly,
    filter,
    format: format3,
    formatter,
    serializeDate: typeof opts.serializeDate === "function" ? opts.serializeDate : defaults$6.serializeDate,
    skipNulls: typeof opts.skipNulls === "boolean" ? opts.skipNulls : defaults$6.skipNulls,
    sort: typeof opts.sort === "function" ? opts.sort : null,
    strictNullHandling: typeof opts.strictNullHandling === "boolean" ? opts.strictNullHandling : defaults$6.strictNullHandling
  };
};
var stringify_1 = function(object, opts) {
  var obj = object;
  var options = normalizeStringifyOptions(opts);
  var objKeys;
  var filter;
  if (typeof options.filter === "function") {
    filter = options.filter;
    obj = filter("", obj);
  } else if (isArray$g(options.filter)) {
    filter = options.filter;
    objKeys = filter;
  }
  var keys2 = [];
  if (typeof obj !== "object" || obj === null) {
    return "";
  }
  var arrayFormat;
  if (opts && opts.arrayFormat in arrayPrefixGenerators) {
    arrayFormat = opts.arrayFormat;
  } else if (opts && "indices" in opts) {
    arrayFormat = opts.indices ? "indices" : "repeat";
  } else {
    arrayFormat = "indices";
  }
  var generateArrayPrefix = arrayPrefixGenerators[arrayFormat];
  if (!objKeys) {
    objKeys = Object.keys(obj);
  }
  if (options.sort) {
    objKeys.sort(options.sort);
  }
  var sideChannel2 = getSideChannel2();
  for (var i2 = 0; i2 < objKeys.length; ++i2) {
    var key = objKeys[i2];
    if (options.skipNulls && obj[key] === null) {
      continue;
    }
    pushToArray(keys2, stringify$1(obj[key], key, generateArrayPrefix, options.strictNullHandling, options.skipNulls, options.encode ? options.encoder : null, options.filter, options.sort, options.allowDots, options.serializeDate, options.format, options.formatter, options.encodeValuesOnly, options.charset, sideChannel2));
  }
  var joined = keys2.join(options.delimiter);
  var prefix2 = options.addQueryPrefix === true ? "?" : "";
  if (options.charsetSentinel) {
    if (options.charset === "iso-8859-1") {
      prefix2 += "utf8=%26%2310003%3B&";
    } else {
      prefix2 += "utf8=%E2%9C%93&";
    }
  }
  return joined.length > 0 ? prefix2 + joined : "";
};
var utils$g = utils$i;
var has = Object.prototype.hasOwnProperty;
var isArray$f = Array.isArray;
var defaults$5 = {
  allowDots: false,
  allowPrototypes: false,
  allowSparse: false,
  arrayLimit: 20,
  charset: "utf-8",
  charsetSentinel: false,
  comma: false,
  decoder: utils$g.decode,
  delimiter: "&",
  depth: 5,
  ignoreQueryPrefix: false,
  interpretNumericEntities: false,
  parameterLimit: 1e3,
  parseArrays: true,
  plainObjects: false,
  strictNullHandling: false
};
var interpretNumericEntities = function(str) {
  return str.replace(/&#(\d+);/g, function($0, numberStr) {
    return String.fromCharCode(parseInt(numberStr, 10));
  });
};
var parseArrayValue = function(val, options) {
  if (val && typeof val === "string" && options.comma && val.indexOf(",") > -1) {
    return val.split(",");
  }
  return val;
};
var isoSentinel = "utf8=%26%2310003%3B";
var charsetSentinel = "utf8=%E2%9C%93";
var parseValues = function parseQueryStringValues(str, options) {
  var obj = {};
  var cleanStr = options.ignoreQueryPrefix ? str.replace(/^\?/, "") : str;
  var limit = options.parameterLimit === Infinity ? void 0 : options.parameterLimit;
  var parts = cleanStr.split(options.delimiter, limit);
  var skipIndex = -1;
  var i2;
  var charset = options.charset;
  if (options.charsetSentinel) {
    for (i2 = 0; i2 < parts.length; ++i2) {
      if (parts[i2].indexOf("utf8=") === 0) {
        if (parts[i2] === charsetSentinel) {
          charset = "utf-8";
        } else if (parts[i2] === isoSentinel) {
          charset = "iso-8859-1";
        }
        skipIndex = i2;
        i2 = parts.length;
      }
    }
  }
  for (i2 = 0; i2 < parts.length; ++i2) {
    if (i2 === skipIndex) {
      continue;
    }
    var part = parts[i2];
    var bracketEqualsPos = part.indexOf("]=");
    var pos = bracketEqualsPos === -1 ? part.indexOf("=") : bracketEqualsPos + 1;
    var key, val;
    if (pos === -1) {
      key = options.decoder(part, defaults$5.decoder, charset, "key");
      val = options.strictNullHandling ? null : "";
    } else {
      key = options.decoder(part.slice(0, pos), defaults$5.decoder, charset, "key");
      val = utils$g.maybeMap(parseArrayValue(part.slice(pos + 1), options), function(encodedVal) {
        return options.decoder(encodedVal, defaults$5.decoder, charset, "value");
      });
    }
    if (val && options.interpretNumericEntities && charset === "iso-8859-1") {
      val = interpretNumericEntities(val);
    }
    if (part.indexOf("[]=") > -1) {
      val = isArray$f(val) ? [val] : val;
    }
    if (has.call(obj, key)) {
      obj[key] = utils$g.combine(obj[key], val);
    } else {
      obj[key] = val;
    }
  }
  return obj;
};
var parseObject = function(chain, val, options, valuesParsed) {
  var leaf = valuesParsed ? val : parseArrayValue(val, options);
  for (var i2 = chain.length - 1; i2 >= 0; --i2) {
    var obj;
    var root2 = chain[i2];
    if (root2 === "[]" && options.parseArrays) {
      obj = [].concat(leaf);
    } else {
      obj = options.plainObjects ? /* @__PURE__ */ Object.create(null) : {};
      var cleanRoot = root2.charAt(0) === "[" && root2.charAt(root2.length - 1) === "]" ? root2.slice(1, -1) : root2;
      var index2 = parseInt(cleanRoot, 10);
      if (!options.parseArrays && cleanRoot === "") {
        obj = { 0: leaf };
      } else if (!isNaN(index2) && root2 !== cleanRoot && String(index2) === cleanRoot && index2 >= 0 && (options.parseArrays && index2 <= options.arrayLimit)) {
        obj = [];
        obj[index2] = leaf;
      } else if (cleanRoot !== "__proto__") {
        obj[cleanRoot] = leaf;
      }
    }
    leaf = obj;
  }
  return leaf;
};
var parseKeys$1 = function parseQueryStringKeys(givenKey, val, options, valuesParsed) {
  if (!givenKey) {
    return;
  }
  var key = options.allowDots ? givenKey.replace(/\.([^.[]+)/g, "[$1]") : givenKey;
  var brackets2 = /(\[[^[\]]*])/;
  var child = /(\[[^[\]]*])/g;
  var segment = options.depth > 0 && brackets2.exec(key);
  var parent = segment ? key.slice(0, segment.index) : key;
  var keys2 = [];
  if (parent) {
    if (!options.plainObjects && has.call(Object.prototype, parent)) {
      if (!options.allowPrototypes) {
        return;
      }
    }
    keys2.push(parent);
  }
  var i2 = 0;
  while (options.depth > 0 && (segment = child.exec(key)) !== null && i2 < options.depth) {
    i2 += 1;
    if (!options.plainObjects && has.call(Object.prototype, segment[1].slice(1, -1))) {
      if (!options.allowPrototypes) {
        return;
      }
    }
    keys2.push(segment[1]);
  }
  if (segment) {
    keys2.push("[" + key.slice(segment.index) + "]");
  }
  return parseObject(keys2, val, options, valuesParsed);
};
var normalizeParseOptions = function normalizeParseOptions2(opts) {
  if (!opts) {
    return defaults$5;
  }
  if (opts.decoder !== null && opts.decoder !== void 0 && typeof opts.decoder !== "function") {
    throw new TypeError("Decoder has to be a function.");
  }
  if (typeof opts.charset !== "undefined" && opts.charset !== "utf-8" && opts.charset !== "iso-8859-1") {
    throw new TypeError("The charset option must be either utf-8, iso-8859-1, or undefined");
  }
  var charset = typeof opts.charset === "undefined" ? defaults$5.charset : opts.charset;
  return {
    allowDots: typeof opts.allowDots === "undefined" ? defaults$5.allowDots : !!opts.allowDots,
    allowPrototypes: typeof opts.allowPrototypes === "boolean" ? opts.allowPrototypes : defaults$5.allowPrototypes,
    allowSparse: typeof opts.allowSparse === "boolean" ? opts.allowSparse : defaults$5.allowSparse,
    arrayLimit: typeof opts.arrayLimit === "number" ? opts.arrayLimit : defaults$5.arrayLimit,
    charset,
    charsetSentinel: typeof opts.charsetSentinel === "boolean" ? opts.charsetSentinel : defaults$5.charsetSentinel,
    comma: typeof opts.comma === "boolean" ? opts.comma : defaults$5.comma,
    decoder: typeof opts.decoder === "function" ? opts.decoder : defaults$5.decoder,
    delimiter: typeof opts.delimiter === "string" || utils$g.isRegExp(opts.delimiter) ? opts.delimiter : defaults$5.delimiter,
    depth: typeof opts.depth === "number" || opts.depth === false ? +opts.depth : defaults$5.depth,
    ignoreQueryPrefix: opts.ignoreQueryPrefix === true,
    interpretNumericEntities: typeof opts.interpretNumericEntities === "boolean" ? opts.interpretNumericEntities : defaults$5.interpretNumericEntities,
    parameterLimit: typeof opts.parameterLimit === "number" ? opts.parameterLimit : defaults$5.parameterLimit,
    parseArrays: opts.parseArrays !== false,
    plainObjects: typeof opts.plainObjects === "boolean" ? opts.plainObjects : defaults$5.plainObjects,
    strictNullHandling: typeof opts.strictNullHandling === "boolean" ? opts.strictNullHandling : defaults$5.strictNullHandling
  };
};
var parse$4 = function(str, opts) {
  var options = normalizeParseOptions(opts);
  if (str === "" || str === null || typeof str === "undefined") {
    return options.plainObjects ? /* @__PURE__ */ Object.create(null) : {};
  }
  var tempObj = typeof str === "string" ? parseValues(str, options) : str;
  var obj = options.plainObjects ? /* @__PURE__ */ Object.create(null) : {};
  var keys2 = Object.keys(tempObj);
  for (var i2 = 0; i2 < keys2.length; ++i2) {
    var key = keys2[i2];
    var newObj = parseKeys$1(key, tempObj[key], options, typeof str === "string");
    obj = utils$g.merge(obj, newObj, options);
  }
  if (options.allowSparse === true) {
    return obj;
  }
  return utils$g.compact(obj);
};
var stringify2 = stringify_1;
var parse$3 = parse$4;
var formats = formats$3;
var lib$1 = {
  formats,
  parse: parse$3,
  stringify: stringify2
};
const useUrlState = (initialState, options) => {
  const { navigateMode = "push" } = options || {};
  const location = useLocation();
  const history = useHistory();
  const initialStateRef = useRef(typeof initialState === "function" ? initialState() : initialState || {});
  const queryFromUrl = useMemo$3(() => {
    return lib$1.parse(location.search.replace(/(^[?])/gi, ""), {
      arrayLimit: 100,
      decoder
    });
  }, [location.search]);
  const targetQuery = useMemo$3(() => __spreadValues(__spreadValues({}, initialStateRef.current), queryFromUrl), [queryFromUrl]);
  const setState = (s3) => {
    const newQuery = typeof s3 === "function" ? s3(targetQuery) : s3;
    if (history) {
      history[navigateMode]({
        hash: location.hash,
        search: lib$1.stringify(__spreadValues(__spreadValues({}, queryFromUrl), newQuery), {
          encode: false
        }) || "?"
      });
    }
  };
  return [targetQuery, setState];
};
function decoder(str) {
  const strWithoutPlus = str.replace(/\+/g, " ");
  const keywords = {
    true: true,
    false: false,
    null: null,
    undefined: void 0
  };
  if (str in keywords) {
    return keywords[str];
  }
  try {
    return decodeURIComponent(strWithoutPlus);
  } catch (e3) {
    return strWithoutPlus;
  }
}
const useUpdateEffect$1 = (callback, dependencies) => {
  const isFirstRender = useRef(true);
  useEffect(() => {
    if (isFirstRender.current) {
      isFirstRender.current = false;
    } else {
      return callback();
    }
  }, dependencies);
};
function useMemoizedFn(fn3) {
  var fnRef = useRef(fn3);
  fnRef.current = useMemo$3(function() {
    return fn3;
  }, [fn3]);
  var memoizedFn = useRef();
  if (!memoizedFn.current) {
    memoizedFn.current = function() {
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
      }
      return fnRef.current.apply(this, args);
    };
  }
  return memoizedFn.current;
}
var createUpdateEffect = function createUpdateEffect2(hook) {
  return function(effect3, deps) {
    var isMounted = useRef(false);
    hook(function() {
      return function() {
        isMounted.current = false;
      };
    }, []);
    hook(function() {
      if (!isMounted.current) {
        isMounted.current = true;
      } else {
        return effect3();
      }
    }, deps);
  };
};
var useUpdateEffect = createUpdateEffect(useEffect);
function depsAreSame(oldDeps, deps) {
  if (oldDeps === deps)
    return true;
  for (var i2 = 0; i2 < oldDeps.length; i2++) {
    if (!Object.is(oldDeps[i2], deps[i2]))
      return false;
  }
  return true;
}
function useLatest$1(value) {
  var ref = useRef(value);
  ref.current = value;
  return ref;
}
var useUnmount = function useUnmount2(fn3) {
  var fnRef = useLatest$1(fn3);
  useEffect(function() {
    return function() {
      fnRef.current();
    };
  }, []);
};
var useUnmount$1 = useUnmount;
function isObject$b(value) {
  var type = typeof value;
  return value != null && (type == "object" || type == "function");
}
var isObject_1 = isObject$b;
var freeGlobal$5 = typeof commonjsGlobal$1 == "object" && commonjsGlobal$1 && commonjsGlobal$1.Object === Object && commonjsGlobal$1;
var _freeGlobal = freeGlobal$5;
var freeGlobal$4 = _freeGlobal;
var freeSelf$3 = typeof self == "object" && self && self.Object === Object && self;
var root$c = freeGlobal$4 || freeSelf$3 || Function("return this")();
var _root = root$c;
var root$b = _root;
var Symbol$8 = root$b.Symbol;
var _Symbol = Symbol$8;
var Symbol$7 = _Symbol;
var objectProto$w = Object.prototype;
var hasOwnProperty$o = objectProto$w.hasOwnProperty;
var nativeObjectToString$3 = objectProto$w.toString;
var symToStringTag$3 = Symbol$7 ? Symbol$7.toStringTag : void 0;
function getRawTag$2(value) {
  var isOwn = hasOwnProperty$o.call(value, symToStringTag$3), tag = value[symToStringTag$3];
  try {
    value[symToStringTag$3] = void 0;
    var unmasked = true;
  } catch (e3) {
  }
  var result = nativeObjectToString$3.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag$3] = tag;
    } else {
      delete value[symToStringTag$3];
    }
  }
  return result;
}
var _getRawTag = getRawTag$2;
var objectProto$v = Object.prototype;
var nativeObjectToString$2 = objectProto$v.toString;
function objectToString$4(value) {
  return nativeObjectToString$2.call(value);
}
var _objectToString = objectToString$4;
var Symbol$6 = _Symbol, getRawTag$1 = _getRawTag, objectToString$3 = _objectToString;
var nullTag$1 = "[object Null]", undefinedTag$1 = "[object Undefined]";
var symToStringTag$2 = Symbol$6 ? Symbol$6.toStringTag : void 0;
function baseGetTag$8(value) {
  if (value == null) {
    return value === void 0 ? undefinedTag$1 : nullTag$1;
  }
  return symToStringTag$2 && symToStringTag$2 in Object(value) ? getRawTag$1(value) : objectToString$3(value);
}
var _baseGetTag = baseGetTag$8;
function isObjectLike$c(value) {
  return value != null && typeof value == "object";
}
var isObjectLike_1 = isObjectLike$c;
var baseGetTag$7 = _baseGetTag, isObjectLike$b = isObjectLike_1;
var symbolTag$7 = "[object Symbol]";
function isSymbol$6(value) {
  return typeof value == "symbol" || isObjectLike$b(value) && baseGetTag$7(value) == symbolTag$7;
}
var isSymbol_1 = isSymbol$6;
var isBrowser$3 = !!(typeof window !== "undefined" && window.document && window.document.createElement);
var isBrowser$4 = isBrowser$3;
function getTargetElement(target, defaultElement) {
  if (!isBrowser$4) {
    return void 0;
  }
  if (!target) {
    return defaultElement;
  }
  var targetElement;
  if (typeof target === "function") {
    targetElement = target();
  } else if ("current" in target) {
    targetElement = target.current;
  } else {
    targetElement = target;
  }
  return targetElement;
}
var createEffectWithTarget = function createEffectWithTarget2(useEffectType) {
  var useEffectWithTarget2 = function useEffectWithTarget3(effect3, deps, target) {
    var hasInitRef = useRef(false);
    var lastElementRef = useRef([]);
    var lastDepsRef = useRef([]);
    var unLoadRef = useRef();
    useEffectType(function() {
      var _a;
      var targets = Array.isArray(target) ? target : [target];
      var els = targets.map(function(item2) {
        return getTargetElement(item2);
      });
      if (!hasInitRef.current) {
        hasInitRef.current = true;
        lastElementRef.current = els;
        lastDepsRef.current = deps;
        unLoadRef.current = effect3();
        return;
      }
      if (els.length !== lastElementRef.current.length || !depsAreSame(els, lastElementRef.current) || !depsAreSame(deps, lastDepsRef.current)) {
        (_a = unLoadRef.current) === null || _a === void 0 ? void 0 : _a.call(unLoadRef);
        lastElementRef.current = els;
        lastDepsRef.current = deps;
        unLoadRef.current = effect3();
      }
    });
    useUnmount$1(function() {
      var _a;
      (_a = unLoadRef.current) === null || _a === void 0 ? void 0 : _a.call(unLoadRef);
      hasInitRef.current = false;
    });
  };
  return useEffectWithTarget2;
};
var createEffectWithTarget$1 = createEffectWithTarget;
var useEffectWithTarget$1 = createEffectWithTarget$1(useEffect);
var useEffectWithTarget$2 = useEffectWithTarget$1;
function listCacheClear$2() {
  this.__data__ = [];
  this.size = 0;
}
var _listCacheClear = listCacheClear$2;
function eq$4(value, other) {
  return value === other || value !== value && other !== other;
}
var eq_1 = eq$4;
var eq$3 = eq_1;
function assocIndexOf$5(array, key) {
  var length = array.length;
  while (length--) {
    if (eq$3(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}
var _assocIndexOf = assocIndexOf$5;
var assocIndexOf$4 = _assocIndexOf;
var arrayProto$1 = Array.prototype;
var splice$1 = arrayProto$1.splice;
function listCacheDelete$2(key) {
  var data2 = this.__data__, index2 = assocIndexOf$4(data2, key);
  if (index2 < 0) {
    return false;
  }
  var lastIndex = data2.length - 1;
  if (index2 == lastIndex) {
    data2.pop();
  } else {
    splice$1.call(data2, index2, 1);
  }
  --this.size;
  return true;
}
var _listCacheDelete = listCacheDelete$2;
var assocIndexOf$3 = _assocIndexOf;
function listCacheGet$2(key) {
  var data2 = this.__data__, index2 = assocIndexOf$3(data2, key);
  return index2 < 0 ? void 0 : data2[index2][1];
}
var _listCacheGet = listCacheGet$2;
var assocIndexOf$2 = _assocIndexOf;
function listCacheHas$2(key) {
  return assocIndexOf$2(this.__data__, key) > -1;
}
var _listCacheHas = listCacheHas$2;
var assocIndexOf$1 = _assocIndexOf;
function listCacheSet$2(key, value) {
  var data2 = this.__data__, index2 = assocIndexOf$1(data2, key);
  if (index2 < 0) {
    ++this.size;
    data2.push([key, value]);
  } else {
    data2[index2][1] = value;
  }
  return this;
}
var _listCacheSet = listCacheSet$2;
var listCacheClear$1 = _listCacheClear, listCacheDelete$1 = _listCacheDelete, listCacheGet$1 = _listCacheGet, listCacheHas$1 = _listCacheHas, listCacheSet$1 = _listCacheSet;
function ListCache$5(entries) {
  var index2 = -1, length = entries == null ? 0 : entries.length;
  this.clear();
  while (++index2 < length) {
    var entry = entries[index2];
    this.set(entry[0], entry[1]);
  }
}
ListCache$5.prototype.clear = listCacheClear$1;
ListCache$5.prototype["delete"] = listCacheDelete$1;
ListCache$5.prototype.get = listCacheGet$1;
ListCache$5.prototype.has = listCacheHas$1;
ListCache$5.prototype.set = listCacheSet$1;
var _ListCache = ListCache$5;
var ListCache$4 = _ListCache;
function stackClear$2() {
  this.__data__ = new ListCache$4();
  this.size = 0;
}
var _stackClear = stackClear$2;
function stackDelete$2(key) {
  var data2 = this.__data__, result = data2["delete"](key);
  this.size = data2.size;
  return result;
}
var _stackDelete = stackDelete$2;
function stackGet$2(key) {
  return this.__data__.get(key);
}
var _stackGet = stackGet$2;
function stackHas$2(key) {
  return this.__data__.has(key);
}
var _stackHas = stackHas$2;
var baseGetTag$6 = _baseGetTag, isObject$a = isObject_1;
var asyncTag$1 = "[object AsyncFunction]", funcTag$4 = "[object Function]", genTag$2 = "[object GeneratorFunction]", proxyTag$1 = "[object Proxy]";
function isFunction$6(value) {
  if (!isObject$a(value)) {
    return false;
  }
  var tag = baseGetTag$6(value);
  return tag == funcTag$4 || tag == genTag$2 || tag == asyncTag$1 || tag == proxyTag$1;
}
var isFunction_1 = isFunction$6;
var root$a = _root;
var coreJsData$3 = root$a["__core-js_shared__"];
var _coreJsData = coreJsData$3;
var coreJsData$2 = _coreJsData;
var maskSrcKey$1 = function() {
  var uid2 = /[^.]+$/.exec(coreJsData$2 && coreJsData$2.keys && coreJsData$2.keys.IE_PROTO || "");
  return uid2 ? "Symbol(src)_1." + uid2 : "";
}();
function isMasked$2(func) {
  return !!maskSrcKey$1 && maskSrcKey$1 in func;
}
var _isMasked = isMasked$2;
var funcProto$5 = Function.prototype;
var funcToString$5 = funcProto$5.toString;
function toSource$3(func) {
  if (func != null) {
    try {
      return funcToString$5.call(func);
    } catch (e3) {
    }
    try {
      return func + "";
    } catch (e3) {
    }
  }
  return "";
}
var _toSource = toSource$3;
var isFunction$5 = isFunction_1, isMasked$1 = _isMasked, isObject$9 = isObject_1, toSource$2 = _toSource;
var reRegExpChar$1 = /[\\^$.*+?()[\]{}|]/g;
var reIsHostCtor$1 = /^\[object .+?Constructor\]$/;
var funcProto$4 = Function.prototype, objectProto$u = Object.prototype;
var funcToString$4 = funcProto$4.toString;
var hasOwnProperty$n = objectProto$u.hasOwnProperty;
var reIsNative$1 = RegExp("^" + funcToString$4.call(hasOwnProperty$n).replace(reRegExpChar$1, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$");
function baseIsNative$2(value) {
  if (!isObject$9(value) || isMasked$1(value)) {
    return false;
  }
  var pattern = isFunction$5(value) ? reIsNative$1 : reIsHostCtor$1;
  return pattern.test(toSource$2(value));
}
var _baseIsNative = baseIsNative$2;
function getValue$4(object, key) {
  return object == null ? void 0 : object[key];
}
var _getValue = getValue$4;
var baseIsNative$1 = _baseIsNative, getValue$3 = _getValue;
function getNative$8(object, key) {
  var value = getValue$3(object, key);
  return baseIsNative$1(value) ? value : void 0;
}
var _getNative = getNative$8;
var getNative$7 = _getNative, root$9 = _root;
var Map$6 = getNative$7(root$9, "Map");
var _Map = Map$6;
var getNative$6 = _getNative;
var nativeCreate$6 = getNative$6(Object, "create");
var _nativeCreate = nativeCreate$6;
var nativeCreate$5 = _nativeCreate;
function hashClear$2() {
  this.__data__ = nativeCreate$5 ? nativeCreate$5(null) : {};
  this.size = 0;
}
var _hashClear = hashClear$2;
function hashDelete$2(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}
var _hashDelete = hashDelete$2;
var nativeCreate$4 = _nativeCreate;
var HASH_UNDEFINED$5 = "__lodash_hash_undefined__";
var objectProto$t = Object.prototype;
var hasOwnProperty$m = objectProto$t.hasOwnProperty;
function hashGet$2(key) {
  var data2 = this.__data__;
  if (nativeCreate$4) {
    var result = data2[key];
    return result === HASH_UNDEFINED$5 ? void 0 : result;
  }
  return hasOwnProperty$m.call(data2, key) ? data2[key] : void 0;
}
var _hashGet = hashGet$2;
var nativeCreate$3 = _nativeCreate;
var objectProto$s = Object.prototype;
var hasOwnProperty$l = objectProto$s.hasOwnProperty;
function hashHas$2(key) {
  var data2 = this.__data__;
  return nativeCreate$3 ? data2[key] !== void 0 : hasOwnProperty$l.call(data2, key);
}
var _hashHas = hashHas$2;
var nativeCreate$2 = _nativeCreate;
var HASH_UNDEFINED$4 = "__lodash_hash_undefined__";
function hashSet$2(key, value) {
  var data2 = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data2[key] = nativeCreate$2 && value === void 0 ? HASH_UNDEFINED$4 : value;
  return this;
}
var _hashSet = hashSet$2;
var hashClear$1 = _hashClear, hashDelete$1 = _hashDelete, hashGet$1 = _hashGet, hashHas$1 = _hashHas, hashSet$1 = _hashSet;
function Hash$2(entries) {
  var index2 = -1, length = entries == null ? 0 : entries.length;
  this.clear();
  while (++index2 < length) {
    var entry = entries[index2];
    this.set(entry[0], entry[1]);
  }
}
Hash$2.prototype.clear = hashClear$1;
Hash$2.prototype["delete"] = hashDelete$1;
Hash$2.prototype.get = hashGet$1;
Hash$2.prototype.has = hashHas$1;
Hash$2.prototype.set = hashSet$1;
var _Hash = Hash$2;
var Hash$1 = _Hash, ListCache$3 = _ListCache, Map$5 = _Map;
function mapCacheClear$2() {
  this.size = 0;
  this.__data__ = {
    "hash": new Hash$1(),
    "map": new (Map$5 || ListCache$3)(),
    "string": new Hash$1()
  };
}
var _mapCacheClear = mapCacheClear$2;
function isKeyable$2(value) {
  var type = typeof value;
  return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
}
var _isKeyable = isKeyable$2;
var isKeyable$1 = _isKeyable;
function getMapData$5(map2, key) {
  var data2 = map2.__data__;
  return isKeyable$1(key) ? data2[typeof key == "string" ? "string" : "hash"] : data2.map;
}
var _getMapData = getMapData$5;
var getMapData$4 = _getMapData;
function mapCacheDelete$2(key) {
  var result = getMapData$4(this, key)["delete"](key);
  this.size -= result ? 1 : 0;
  return result;
}
var _mapCacheDelete = mapCacheDelete$2;
var getMapData$3 = _getMapData;
function mapCacheGet$2(key) {
  return getMapData$3(this, key).get(key);
}
var _mapCacheGet = mapCacheGet$2;
var getMapData$2 = _getMapData;
function mapCacheHas$2(key) {
  return getMapData$2(this, key).has(key);
}
var _mapCacheHas = mapCacheHas$2;
var getMapData$1 = _getMapData;
function mapCacheSet$2(key, value) {
  var data2 = getMapData$1(this, key), size = data2.size;
  data2.set(key, value);
  this.size += data2.size == size ? 0 : 1;
  return this;
}
var _mapCacheSet = mapCacheSet$2;
var mapCacheClear$1 = _mapCacheClear, mapCacheDelete$1 = _mapCacheDelete, mapCacheGet$1 = _mapCacheGet, mapCacheHas$1 = _mapCacheHas, mapCacheSet$1 = _mapCacheSet;
function MapCache$4(entries) {
  var index2 = -1, length = entries == null ? 0 : entries.length;
  this.clear();
  while (++index2 < length) {
    var entry = entries[index2];
    this.set(entry[0], entry[1]);
  }
}
MapCache$4.prototype.clear = mapCacheClear$1;
MapCache$4.prototype["delete"] = mapCacheDelete$1;
MapCache$4.prototype.get = mapCacheGet$1;
MapCache$4.prototype.has = mapCacheHas$1;
MapCache$4.prototype.set = mapCacheSet$1;
var _MapCache = MapCache$4;
var ListCache$2 = _ListCache, Map$4 = _Map, MapCache$3 = _MapCache;
var LARGE_ARRAY_SIZE$1 = 200;
function stackSet$2(key, value) {
  var data2 = this.__data__;
  if (data2 instanceof ListCache$2) {
    var pairs = data2.__data__;
    if (!Map$4 || pairs.length < LARGE_ARRAY_SIZE$1 - 1) {
      pairs.push([key, value]);
      this.size = ++data2.size;
      return this;
    }
    data2 = this.__data__ = new MapCache$3(pairs);
  }
  data2.set(key, value);
  this.size = data2.size;
  return this;
}
var _stackSet = stackSet$2;
var ListCache$1 = _ListCache, stackClear$1 = _stackClear, stackDelete$1 = _stackDelete, stackGet$1 = _stackGet, stackHas$1 = _stackHas, stackSet$1 = _stackSet;
function Stack$4(entries) {
  var data2 = this.__data__ = new ListCache$1(entries);
  this.size = data2.size;
}
Stack$4.prototype.clear = stackClear$1;
Stack$4.prototype["delete"] = stackDelete$1;
Stack$4.prototype.get = stackGet$1;
Stack$4.prototype.has = stackHas$1;
Stack$4.prototype.set = stackSet$1;
var _Stack = Stack$4;
var HASH_UNDEFINED$3 = "__lodash_hash_undefined__";
function setCacheAdd$2(value) {
  this.__data__.set(value, HASH_UNDEFINED$3);
  return this;
}
var _setCacheAdd = setCacheAdd$2;
function setCacheHas$2(value) {
  return this.__data__.has(value);
}
var _setCacheHas = setCacheHas$2;
var MapCache$2 = _MapCache, setCacheAdd$1 = _setCacheAdd, setCacheHas$1 = _setCacheHas;
function SetCache$2(values2) {
  var index2 = -1, length = values2 == null ? 0 : values2.length;
  this.__data__ = new MapCache$2();
  while (++index2 < length) {
    this.add(values2[index2]);
  }
}
SetCache$2.prototype.add = SetCache$2.prototype.push = setCacheAdd$1;
SetCache$2.prototype.has = setCacheHas$1;
var _SetCache = SetCache$2;
function arraySome$2(array, predicate) {
  var index2 = -1, length = array == null ? 0 : array.length;
  while (++index2 < length) {
    if (predicate(array[index2], index2, array)) {
      return true;
    }
  }
  return false;
}
var _arraySome = arraySome$2;
function cacheHas$2(cache2, key) {
  return cache2.has(key);
}
var _cacheHas = cacheHas$2;
var SetCache$1 = _SetCache, arraySome$1 = _arraySome, cacheHas$1 = _cacheHas;
var COMPARE_PARTIAL_FLAG$b = 1, COMPARE_UNORDERED_FLAG$7 = 2;
function equalArrays$3(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG$b, arrLength = array.length, othLength = other.length;
  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  var arrStacked = stack.get(array);
  var othStacked = stack.get(other);
  if (arrStacked && othStacked) {
    return arrStacked == other && othStacked == array;
  }
  var index2 = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG$7 ? new SetCache$1() : void 0;
  stack.set(array, other);
  stack.set(other, array);
  while (++index2 < arrLength) {
    var arrValue = array[index2], othValue = other[index2];
    if (customizer) {
      var compared = isPartial ? customizer(othValue, arrValue, index2, other, array, stack) : customizer(arrValue, othValue, index2, array, other, stack);
    }
    if (compared !== void 0) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    if (seen) {
      if (!arraySome$1(other, function(othValue2, othIndex) {
        if (!cacheHas$1(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
          return seen.push(othIndex);
        }
      })) {
        result = false;
        break;
      }
    } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
      result = false;
      break;
    }
  }
  stack["delete"](array);
  stack["delete"](other);
  return result;
}
var _equalArrays = equalArrays$3;
var root$8 = _root;
var Uint8Array$5 = root$8.Uint8Array;
var _Uint8Array = Uint8Array$5;
function mapToArray$2(map2) {
  var index2 = -1, result = Array(map2.size);
  map2.forEach(function(value, key) {
    result[++index2] = [key, value];
  });
  return result;
}
var _mapToArray = mapToArray$2;
function setToArray$2(set2) {
  var index2 = -1, result = Array(set2.size);
  set2.forEach(function(value) {
    result[++index2] = value;
  });
  return result;
}
var _setToArray = setToArray$2;
var Symbol$5 = _Symbol, Uint8Array$4 = _Uint8Array, eq$2 = eq_1, equalArrays$2 = _equalArrays, mapToArray$1 = _mapToArray, setToArray$1 = _setToArray;
var COMPARE_PARTIAL_FLAG$a = 1, COMPARE_UNORDERED_FLAG$6 = 2;
var boolTag$5 = "[object Boolean]", dateTag$5 = "[object Date]", errorTag$4 = "[object Error]", mapTag$8 = "[object Map]", numberTag$5 = "[object Number]", regexpTag$5 = "[object RegExp]", setTag$8 = "[object Set]", stringTag$6 = "[object String]", symbolTag$6 = "[object Symbol]";
var arrayBufferTag$5 = "[object ArrayBuffer]", dataViewTag$7 = "[object DataView]";
var symbolProto$4 = Symbol$5 ? Symbol$5.prototype : void 0, symbolValueOf$2 = symbolProto$4 ? symbolProto$4.valueOf : void 0;
function equalByTag$2(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag$7:
      if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;
    case arrayBufferTag$5:
      if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array$4(object), new Uint8Array$4(other))) {
        return false;
      }
      return true;
    case boolTag$5:
    case dateTag$5:
    case numberTag$5:
      return eq$2(+object, +other);
    case errorTag$4:
      return object.name == other.name && object.message == other.message;
    case regexpTag$5:
    case stringTag$6:
      return object == other + "";
    case mapTag$8:
      var convert = mapToArray$1;
    case setTag$8:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG$a;
      convert || (convert = setToArray$1);
      if (object.size != other.size && !isPartial) {
        return false;
      }
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG$6;
      stack.set(object, other);
      var result = equalArrays$2(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack["delete"](object);
      return result;
    case symbolTag$6:
      if (symbolValueOf$2) {
        return symbolValueOf$2.call(object) == symbolValueOf$2.call(other);
      }
  }
  return false;
}
var _equalByTag = equalByTag$2;
function arrayPush$3(array, values2) {
  var index2 = -1, length = values2.length, offset4 = array.length;
  while (++index2 < length) {
    array[offset4 + index2] = values2[index2];
  }
  return array;
}
var _arrayPush = arrayPush$3;
var isArray$e = Array.isArray;
var isArray_1 = isArray$e;
var arrayPush$2 = _arrayPush, isArray$d = isArray_1;
function baseGetAllKeys$3(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray$d(object) ? result : arrayPush$2(result, symbolsFunc(object));
}
var _baseGetAllKeys = baseGetAllKeys$3;
function arrayFilter$2(array, predicate) {
  var index2 = -1, length = array == null ? 0 : array.length, resIndex = 0, result = [];
  while (++index2 < length) {
    var value = array[index2];
    if (predicate(value, index2, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}
var _arrayFilter = arrayFilter$2;
function stubArray$3() {
  return [];
}
var stubArray_1 = stubArray$3;
var arrayFilter$1 = _arrayFilter, stubArray$2 = stubArray_1;
var objectProto$r = Object.prototype;
var propertyIsEnumerable$3 = objectProto$r.propertyIsEnumerable;
var nativeGetSymbols$2 = Object.getOwnPropertySymbols;
var getSymbols$5 = !nativeGetSymbols$2 ? stubArray$2 : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return arrayFilter$1(nativeGetSymbols$2(object), function(symbol) {
    return propertyIsEnumerable$3.call(object, symbol);
  });
};
var _getSymbols = getSymbols$5;
function baseTimes$2(n2, iteratee) {
  var index2 = -1, result = Array(n2);
  while (++index2 < n2) {
    result[index2] = iteratee(index2);
  }
  return result;
}
var _baseTimes = baseTimes$2;
var baseGetTag$5 = _baseGetTag, isObjectLike$a = isObjectLike_1;
var argsTag$6 = "[object Arguments]";
function baseIsArguments$2(value) {
  return isObjectLike$a(value) && baseGetTag$5(value) == argsTag$6;
}
var _baseIsArguments = baseIsArguments$2;
var baseIsArguments$1 = _baseIsArguments, isObjectLike$9 = isObjectLike_1;
var objectProto$q = Object.prototype;
var hasOwnProperty$k = objectProto$q.hasOwnProperty;
var propertyIsEnumerable$2 = objectProto$q.propertyIsEnumerable;
var isArguments$4 = baseIsArguments$1(function() {
  return arguments;
}()) ? baseIsArguments$1 : function(value) {
  return isObjectLike$9(value) && hasOwnProperty$k.call(value, "callee") && !propertyIsEnumerable$2.call(value, "callee");
};
var isArguments_1 = isArguments$4;
var isBuffer$6 = { exports: {} };
function stubFalse$1() {
  return false;
}
var stubFalse_1 = stubFalse$1;
(function(module2, exports2) {
  var root2 = _root, stubFalse2 = stubFalse_1;
  var freeExports2 = exports2 && !exports2.nodeType && exports2;
  var freeModule2 = freeExports2 && true && module2 && !module2.nodeType && module2;
  var moduleExports2 = freeModule2 && freeModule2.exports === freeExports2;
  var Buffer3 = moduleExports2 ? root2.Buffer : void 0;
  var nativeIsBuffer2 = Buffer3 ? Buffer3.isBuffer : void 0;
  var isBuffer3 = nativeIsBuffer2 || stubFalse2;
  module2.exports = isBuffer3;
})(isBuffer$6, isBuffer$6.exports);
var MAX_SAFE_INTEGER$3 = 9007199254740991;
var reIsUint$1 = /^(?:0|[1-9]\d*)$/;
function isIndex$3(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER$3 : length;
  return !!length && (type == "number" || type != "symbol" && reIsUint$1.test(value)) && (value > -1 && value % 1 == 0 && value < length);
}
var _isIndex = isIndex$3;
var MAX_SAFE_INTEGER$2 = 9007199254740991;
function isLength$4(value) {
  return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER$2;
}
var isLength_1 = isLength$4;
var baseGetTag$4 = _baseGetTag, isLength$3 = isLength_1, isObjectLike$8 = isObjectLike_1;
var argsTag$5 = "[object Arguments]", arrayTag$4 = "[object Array]", boolTag$4 = "[object Boolean]", dateTag$4 = "[object Date]", errorTag$3 = "[object Error]", funcTag$3 = "[object Function]", mapTag$7 = "[object Map]", numberTag$4 = "[object Number]", objectTag$8 = "[object Object]", regexpTag$4 = "[object RegExp]", setTag$7 = "[object Set]", stringTag$5 = "[object String]", weakMapTag$4 = "[object WeakMap]";
var arrayBufferTag$4 = "[object ArrayBuffer]", dataViewTag$6 = "[object DataView]", float32Tag$3 = "[object Float32Array]", float64Tag$3 = "[object Float64Array]", int8Tag$3 = "[object Int8Array]", int16Tag$3 = "[object Int16Array]", int32Tag$3 = "[object Int32Array]", uint8Tag$3 = "[object Uint8Array]", uint8ClampedTag$3 = "[object Uint8ClampedArray]", uint16Tag$3 = "[object Uint16Array]", uint32Tag$3 = "[object Uint32Array]";
var typedArrayTags$1 = {};
typedArrayTags$1[float32Tag$3] = typedArrayTags$1[float64Tag$3] = typedArrayTags$1[int8Tag$3] = typedArrayTags$1[int16Tag$3] = typedArrayTags$1[int32Tag$3] = typedArrayTags$1[uint8Tag$3] = typedArrayTags$1[uint8ClampedTag$3] = typedArrayTags$1[uint16Tag$3] = typedArrayTags$1[uint32Tag$3] = true;
typedArrayTags$1[argsTag$5] = typedArrayTags$1[arrayTag$4] = typedArrayTags$1[arrayBufferTag$4] = typedArrayTags$1[boolTag$4] = typedArrayTags$1[dataViewTag$6] = typedArrayTags$1[dateTag$4] = typedArrayTags$1[errorTag$3] = typedArrayTags$1[funcTag$3] = typedArrayTags$1[mapTag$7] = typedArrayTags$1[numberTag$4] = typedArrayTags$1[objectTag$8] = typedArrayTags$1[regexpTag$4] = typedArrayTags$1[setTag$7] = typedArrayTags$1[stringTag$5] = typedArrayTags$1[weakMapTag$4] = false;
function baseIsTypedArray$2(value) {
  return isObjectLike$8(value) && isLength$3(value.length) && !!typedArrayTags$1[baseGetTag$4(value)];
}
var _baseIsTypedArray = baseIsTypedArray$2;
function baseUnary$4(func) {
  return function(value) {
    return func(value);
  };
}
var _baseUnary = baseUnary$4;
var _nodeUtil = { exports: {} };
(function(module2, exports2) {
  var freeGlobal2 = _freeGlobal;
  var freeExports2 = exports2 && !exports2.nodeType && exports2;
  var freeModule2 = freeExports2 && true && module2 && !module2.nodeType && module2;
  var moduleExports2 = freeModule2 && freeModule2.exports === freeExports2;
  var freeProcess2 = moduleExports2 && freeGlobal2.process;
  var nodeUtil2 = function() {
    try {
      var types = freeModule2 && freeModule2.require && freeModule2.require("util").types;
      if (types) {
        return types;
      }
      return freeProcess2 && freeProcess2.binding && freeProcess2.binding("util");
    } catch (e3) {
    }
  }();
  module2.exports = nodeUtil2;
})(_nodeUtil, _nodeUtil.exports);
var baseIsTypedArray$1 = _baseIsTypedArray, baseUnary$3 = _baseUnary, nodeUtil$4 = _nodeUtil.exports;
var nodeIsTypedArray$1 = nodeUtil$4 && nodeUtil$4.isTypedArray;
var isTypedArray$4 = nodeIsTypedArray$1 ? baseUnary$3(nodeIsTypedArray$1) : baseIsTypedArray$1;
var isTypedArray_1 = isTypedArray$4;
var baseTimes$1 = _baseTimes, isArguments$3 = isArguments_1, isArray$c = isArray_1, isBuffer$5 = isBuffer$6.exports, isIndex$2 = _isIndex, isTypedArray$3 = isTypedArray_1;
var objectProto$p = Object.prototype;
var hasOwnProperty$j = objectProto$p.hasOwnProperty;
function arrayLikeKeys$3(value, inherited) {
  var isArr = isArray$c(value), isArg = !isArr && isArguments$3(value), isBuff = !isArr && !isArg && isBuffer$5(value), isType2 = !isArr && !isArg && !isBuff && isTypedArray$3(value), skipIndexes = isArr || isArg || isBuff || isType2, result = skipIndexes ? baseTimes$1(value.length, String) : [], length = result.length;
  for (var key in value) {
    if ((inherited || hasOwnProperty$j.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType2 && (key == "buffer" || key == "byteLength" || key == "byteOffset") || isIndex$2(key, length)))) {
      result.push(key);
    }
  }
  return result;
}
var _arrayLikeKeys = arrayLikeKeys$3;
var objectProto$o = Object.prototype;
function isPrototype$4(value) {
  var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto$o;
  return value === proto;
}
var _isPrototype = isPrototype$4;
function overArg$3(func, transform2) {
  return function(arg) {
    return func(transform2(arg));
  };
}
var _overArg = overArg$3;
var overArg$2 = _overArg;
var nativeKeys$3 = overArg$2(Object.keys, Object);
var _nativeKeys = nativeKeys$3;
var isPrototype$3 = _isPrototype, nativeKeys$2 = _nativeKeys;
var objectProto$n = Object.prototype;
var hasOwnProperty$i = objectProto$n.hasOwnProperty;
function baseKeys$2(object) {
  if (!isPrototype$3(object)) {
    return nativeKeys$2(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty$i.call(object, key) && key != "constructor") {
      result.push(key);
    }
  }
  return result;
}
var _baseKeys = baseKeys$2;
var isFunction$4 = isFunction_1, isLength$2 = isLength_1;
function isArrayLike$5(value) {
  return value != null && isLength$2(value.length) && !isFunction$4(value);
}
var isArrayLike_1 = isArrayLike$5;
var arrayLikeKeys$2 = _arrayLikeKeys, baseKeys$1 = _baseKeys, isArrayLike$4 = isArrayLike_1;
function keys$6(object) {
  return isArrayLike$4(object) ? arrayLikeKeys$2(object) : baseKeys$1(object);
}
var keys_1 = keys$6;
var baseGetAllKeys$2 = _baseGetAllKeys, getSymbols$4 = _getSymbols, keys$5 = keys_1;
function getAllKeys$3(object) {
  return baseGetAllKeys$2(object, keys$5, getSymbols$4);
}
var _getAllKeys = getAllKeys$3;
var getAllKeys$2 = _getAllKeys;
var COMPARE_PARTIAL_FLAG$9 = 1;
var objectProto$m = Object.prototype;
var hasOwnProperty$h = objectProto$m.hasOwnProperty;
function equalObjects$2(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG$9, objProps = getAllKeys$2(object), objLength = objProps.length, othProps = getAllKeys$2(other), othLength = othProps.length;
  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index2 = objLength;
  while (index2--) {
    var key = objProps[index2];
    if (!(isPartial ? key in other : hasOwnProperty$h.call(other, key))) {
      return false;
    }
  }
  var objStacked = stack.get(object);
  var othStacked = stack.get(other);
  if (objStacked && othStacked) {
    return objStacked == other && othStacked == object;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);
  var skipCtor = isPartial;
  while (++index2 < objLength) {
    key = objProps[index2];
    var objValue = object[key], othValue = other[key];
    if (customizer) {
      var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
    }
    if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == "constructor");
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor, othCtor = other.constructor;
    if (objCtor != othCtor && ("constructor" in object && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack["delete"](object);
  stack["delete"](other);
  return result;
}
var _equalObjects = equalObjects$2;
var getNative$5 = _getNative, root$7 = _root;
var DataView$4 = getNative$5(root$7, "DataView");
var _DataView = DataView$4;
var getNative$4 = _getNative, root$6 = _root;
var Promise$4 = getNative$4(root$6, "Promise");
var _Promise = Promise$4;
var getNative$3 = _getNative, root$5 = _root;
var Set$4 = getNative$3(root$5, "Set");
var _Set = Set$4;
var getNative$2 = _getNative, root$4 = _root;
var WeakMap$4 = getNative$2(root$4, "WeakMap");
var _WeakMap = WeakMap$4;
var DataView$3 = _DataView, Map$3 = _Map, Promise$3 = _Promise, Set$3 = _Set, WeakMap$3 = _WeakMap, baseGetTag$3 = _baseGetTag, toSource$1 = _toSource;
var mapTag$6 = "[object Map]", objectTag$7 = "[object Object]", promiseTag$1 = "[object Promise]", setTag$6 = "[object Set]", weakMapTag$3 = "[object WeakMap]";
var dataViewTag$5 = "[object DataView]";
var dataViewCtorString$1 = toSource$1(DataView$3), mapCtorString$1 = toSource$1(Map$3), promiseCtorString$1 = toSource$1(Promise$3), setCtorString$1 = toSource$1(Set$3), weakMapCtorString$1 = toSource$1(WeakMap$3);
var getTag$6 = baseGetTag$3;
if (DataView$3 && getTag$6(new DataView$3(new ArrayBuffer(1))) != dataViewTag$5 || Map$3 && getTag$6(new Map$3()) != mapTag$6 || Promise$3 && getTag$6(Promise$3.resolve()) != promiseTag$1 || Set$3 && getTag$6(new Set$3()) != setTag$6 || WeakMap$3 && getTag$6(new WeakMap$3()) != weakMapTag$3) {
  getTag$6 = function(value) {
    var result = baseGetTag$3(value), Ctor = result == objectTag$7 ? value.constructor : void 0, ctorString = Ctor ? toSource$1(Ctor) : "";
    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString$1:
          return dataViewTag$5;
        case mapCtorString$1:
          return mapTag$6;
        case promiseCtorString$1:
          return promiseTag$1;
        case setCtorString$1:
          return setTag$6;
        case weakMapCtorString$1:
          return weakMapTag$3;
      }
    }
    return result;
  };
}
var _getTag = getTag$6;
var Stack$3 = _Stack, equalArrays$1 = _equalArrays, equalByTag$1 = _equalByTag, equalObjects$1 = _equalObjects, getTag$5 = _getTag, isArray$b = isArray_1, isBuffer$4 = isBuffer$6.exports, isTypedArray$2 = isTypedArray_1;
var COMPARE_PARTIAL_FLAG$8 = 1;
var argsTag$4 = "[object Arguments]", arrayTag$3 = "[object Array]", objectTag$6 = "[object Object]";
var objectProto$l = Object.prototype;
var hasOwnProperty$g = objectProto$l.hasOwnProperty;
function baseIsEqualDeep$2(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = isArray$b(object), othIsArr = isArray$b(other), objTag = objIsArr ? arrayTag$3 : getTag$5(object), othTag = othIsArr ? arrayTag$3 : getTag$5(other);
  objTag = objTag == argsTag$4 ? objectTag$6 : objTag;
  othTag = othTag == argsTag$4 ? objectTag$6 : othTag;
  var objIsObj = objTag == objectTag$6, othIsObj = othTag == objectTag$6, isSameTag = objTag == othTag;
  if (isSameTag && isBuffer$4(object)) {
    if (!isBuffer$4(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new Stack$3());
    return objIsArr || isTypedArray$2(object) ? equalArrays$1(object, other, bitmask, customizer, equalFunc, stack) : equalByTag$1(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG$8)) {
    var objIsWrapped = objIsObj && hasOwnProperty$g.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty$g.call(other, "__wrapped__");
    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
      stack || (stack = new Stack$3());
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new Stack$3());
  return equalObjects$1(object, other, bitmask, customizer, equalFunc, stack);
}
var _baseIsEqualDeep = baseIsEqualDeep$2;
var baseIsEqualDeep$1 = _baseIsEqualDeep, isObjectLike$7 = isObjectLike_1;
function baseIsEqual$4(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || !isObjectLike$7(value) && !isObjectLike$7(other)) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep$1(value, other, bitmask, customizer, baseIsEqual$4, stack);
}
var _baseIsEqual = baseIsEqual$4;
var baseIsEqual$3 = _baseIsEqual;
function isEqual$6(value, other) {
  return baseIsEqual$3(value, other);
}
var isEqual_1 = isEqual$6;
var __read$2 = globalThis && globalThis.__read || function(o, n2) {
  var m4 = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m4)
    return o;
  var i2 = m4.call(o), r2, ar = [], e3;
  try {
    while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) {
      ar.push(r2.value);
    }
  } catch (error) {
    e3 = {
      error
    };
  } finally {
    try {
      if (r2 && !r2.done && (m4 = i2["return"]))
        m4.call(i2);
    } finally {
      if (e3)
        throw e3.error;
    }
  }
  return ar;
};
function isFunction$3(obj) {
  return typeof obj === "function";
}
function createUseStorageState(getStorage) {
  function useStorageState(key, options) {
    var storage;
    try {
      storage = getStorage();
    } catch (err) {
      console.error(err);
    }
    var serializer = function serializer2(value) {
      if (options === null || options === void 0 ? void 0 : options.serializer) {
        return options === null || options === void 0 ? void 0 : options.serializer(value);
      }
      return JSON.stringify(value);
    };
    var deserializer = function deserializer2(value) {
      if (options === null || options === void 0 ? void 0 : options.deserializer) {
        return options === null || options === void 0 ? void 0 : options.deserializer(value);
      }
      return JSON.parse(value);
    };
    function getStoredValue() {
      try {
        var raw = storage === null || storage === void 0 ? void 0 : storage.getItem(key);
        if (raw) {
          return deserializer(raw);
        }
      } catch (e3) {
        console.error(e3);
      }
      if (isFunction$3(options === null || options === void 0 ? void 0 : options.defaultValue)) {
        return options === null || options === void 0 ? void 0 : options.defaultValue();
      }
      return options === null || options === void 0 ? void 0 : options.defaultValue;
    }
    var _a = __read$2(useState$1(function() {
      return getStoredValue();
    }), 2), state = _a[0], setState = _a[1];
    useUpdateEffect(function() {
      setState(getStoredValue());
    }, [key]);
    var updateState = function updateState2(value) {
      if (typeof value === "undefined") {
        setState(void 0);
        storage === null || storage === void 0 ? void 0 : storage.removeItem(key);
      } else if (isFunction$3(value)) {
        var currentState = value(state);
        try {
          setState(currentState);
          storage === null || storage === void 0 ? void 0 : storage.setItem(key, serializer(currentState));
        } catch (e3) {
          console.error(e3);
        }
      } else {
        try {
          setState(value);
          storage === null || storage === void 0 ? void 0 : storage.setItem(key, serializer(value));
        } catch (e3) {
          console.error(e3);
        }
      }
    };
    return [state, useMemoizedFn(updateState)];
  }
  return useStorageState;
}
var useLocalStorageState = createUseStorageState(function() {
  return isBrowser$4 ? localStorage : void 0;
});
var useLocalStorageState$1 = useLocalStorageState;
var __read$1 = globalThis && globalThis.__read || function(o, n2) {
  var m4 = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m4)
    return o;
  var i2 = m4.call(o), r2, ar = [], e3;
  try {
    while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) {
      ar.push(r2.value);
    }
  } catch (error) {
    e3 = {
      error
    };
  } finally {
    try {
      if (r2 && !r2.done && (m4 = i2["return"]))
        m4.call(i2);
    } finally {
      if (e3)
        throw e3.error;
    }
  }
  return ar;
};
function useRafState$1(initialState) {
  var ref = useRef(0);
  var _a = __read$1(useState$1(initialState), 2), state = _a[0], setState = _a[1];
  var setRafState = useCallback$1(function(value) {
    cancelAnimationFrame(ref.current);
    ref.current = requestAnimationFrame(function() {
      setState(value);
    });
  }, []);
  useUnmount$1(function() {
    cancelAnimationFrame(ref.current);
  });
  return [state, setRafState];
}
var MapShim = function() {
  if (typeof Map !== "undefined") {
    return Map;
  }
  function getIndex(arr, key) {
    var result = -1;
    arr.some(function(entry, index2) {
      if (entry[0] === key) {
        result = index2;
        return true;
      }
      return false;
    });
    return result;
  }
  return function() {
    function class_1() {
      this.__entries__ = [];
    }
    Object.defineProperty(class_1.prototype, "size", {
      get: function() {
        return this.__entries__.length;
      },
      enumerable: true,
      configurable: true
    });
    class_1.prototype.get = function(key) {
      var index2 = getIndex(this.__entries__, key);
      var entry = this.__entries__[index2];
      return entry && entry[1];
    };
    class_1.prototype.set = function(key, value) {
      var index2 = getIndex(this.__entries__, key);
      if (~index2) {
        this.__entries__[index2][1] = value;
      } else {
        this.__entries__.push([key, value]);
      }
    };
    class_1.prototype.delete = function(key) {
      var entries = this.__entries__;
      var index2 = getIndex(entries, key);
      if (~index2) {
        entries.splice(index2, 1);
      }
    };
    class_1.prototype.has = function(key) {
      return !!~getIndex(this.__entries__, key);
    };
    class_1.prototype.clear = function() {
      this.__entries__.splice(0);
    };
    class_1.prototype.forEach = function(callback, ctx2) {
      if (ctx2 === void 0) {
        ctx2 = null;
      }
      for (var _i = 0, _a = this.__entries__; _i < _a.length; _i++) {
        var entry = _a[_i];
        callback.call(ctx2, entry[1], entry[0]);
      }
    };
    return class_1;
  }();
}();
var isBrowser$2 = typeof window !== "undefined" && typeof document !== "undefined" && window.document === document;
var global$1$1 = function() {
  if (typeof global !== "undefined" && global.Math === Math) {
    return global;
  }
  if (typeof self !== "undefined" && self.Math === Math) {
    return self;
  }
  if (typeof window !== "undefined" && window.Math === Math) {
    return window;
  }
  return Function("return this")();
}();
var requestAnimationFrame$1 = function() {
  if (typeof requestAnimationFrame === "function") {
    return requestAnimationFrame.bind(global$1$1);
  }
  return function(callback) {
    return setTimeout(function() {
      return callback(Date.now());
    }, 1e3 / 60);
  };
}();
var trailingTimeout = 2;
function throttle$2(callback, delay) {
  var leadingCall = false, trailingCall = false, lastCallTime = 0;
  function resolvePending() {
    if (leadingCall) {
      leadingCall = false;
      callback();
    }
    if (trailingCall) {
      proxy();
    }
  }
  function timeoutCallback() {
    requestAnimationFrame$1(resolvePending);
  }
  function proxy() {
    var timeStamp = Date.now();
    if (leadingCall) {
      if (timeStamp - lastCallTime < trailingTimeout) {
        return;
      }
      trailingCall = true;
    } else {
      leadingCall = true;
      trailingCall = false;
      setTimeout(timeoutCallback, delay);
    }
    lastCallTime = timeStamp;
  }
  return proxy;
}
var REFRESH_DELAY = 20;
var transitionKeys = ["top", "right", "bottom", "left", "width", "height", "size", "weight"];
var mutationObserverSupported = typeof MutationObserver !== "undefined";
var ResizeObserverController = function() {
  function ResizeObserverController2() {
    this.connected_ = false;
    this.mutationEventsAdded_ = false;
    this.mutationsObserver_ = null;
    this.observers_ = [];
    this.onTransitionEnd_ = this.onTransitionEnd_.bind(this);
    this.refresh = throttle$2(this.refresh.bind(this), REFRESH_DELAY);
  }
  ResizeObserverController2.prototype.addObserver = function(observer) {
    if (!~this.observers_.indexOf(observer)) {
      this.observers_.push(observer);
    }
    if (!this.connected_) {
      this.connect_();
    }
  };
  ResizeObserverController2.prototype.removeObserver = function(observer) {
    var observers2 = this.observers_;
    var index2 = observers2.indexOf(observer);
    if (~index2) {
      observers2.splice(index2, 1);
    }
    if (!observers2.length && this.connected_) {
      this.disconnect_();
    }
  };
  ResizeObserverController2.prototype.refresh = function() {
    var changesDetected = this.updateObservers_();
    if (changesDetected) {
      this.refresh();
    }
  };
  ResizeObserverController2.prototype.updateObservers_ = function() {
    var activeObservers = this.observers_.filter(function(observer) {
      return observer.gatherActive(), observer.hasActive();
    });
    activeObservers.forEach(function(observer) {
      return observer.broadcastActive();
    });
    return activeObservers.length > 0;
  };
  ResizeObserverController2.prototype.connect_ = function() {
    if (!isBrowser$2 || this.connected_) {
      return;
    }
    document.addEventListener("transitionend", this.onTransitionEnd_);
    window.addEventListener("resize", this.refresh);
    if (mutationObserverSupported) {
      this.mutationsObserver_ = new MutationObserver(this.refresh);
      this.mutationsObserver_.observe(document, {
        attributes: true,
        childList: true,
        characterData: true,
        subtree: true
      });
    } else {
      document.addEventListener("DOMSubtreeModified", this.refresh);
      this.mutationEventsAdded_ = true;
    }
    this.connected_ = true;
  };
  ResizeObserverController2.prototype.disconnect_ = function() {
    if (!isBrowser$2 || !this.connected_) {
      return;
    }
    document.removeEventListener("transitionend", this.onTransitionEnd_);
    window.removeEventListener("resize", this.refresh);
    if (this.mutationsObserver_) {
      this.mutationsObserver_.disconnect();
    }
    if (this.mutationEventsAdded_) {
      document.removeEventListener("DOMSubtreeModified", this.refresh);
    }
    this.mutationsObserver_ = null;
    this.mutationEventsAdded_ = false;
    this.connected_ = false;
  };
  ResizeObserverController2.prototype.onTransitionEnd_ = function(_a) {
    var _b = _a.propertyName, propertyName = _b === void 0 ? "" : _b;
    var isReflowProperty = transitionKeys.some(function(key) {
      return !!~propertyName.indexOf(key);
    });
    if (isReflowProperty) {
      this.refresh();
    }
  };
  ResizeObserverController2.getInstance = function() {
    if (!this.instance_) {
      this.instance_ = new ResizeObserverController2();
    }
    return this.instance_;
  };
  ResizeObserverController2.instance_ = null;
  return ResizeObserverController2;
}();
var defineConfigurable = function(target, props) {
  for (var _i = 0, _a = Object.keys(props); _i < _a.length; _i++) {
    var key = _a[_i];
    Object.defineProperty(target, key, {
      value: props[key],
      enumerable: false,
      writable: false,
      configurable: true
    });
  }
  return target;
};
var getWindowOf = function(target) {
  var ownerGlobal = target && target.ownerDocument && target.ownerDocument.defaultView;
  return ownerGlobal || global$1$1;
};
var emptyRect = createRectInit(0, 0, 0, 0);
function toFloat(value) {
  return parseFloat(value) || 0;
}
function getBordersSize(styles2) {
  var positions = [];
  for (var _i = 1; _i < arguments.length; _i++) {
    positions[_i - 1] = arguments[_i];
  }
  return positions.reduce(function(size, position3) {
    var value = styles2["border-" + position3 + "-width"];
    return size + toFloat(value);
  }, 0);
}
function getPaddings(styles2) {
  var positions = ["top", "right", "bottom", "left"];
  var paddings = {};
  for (var _i = 0, positions_1 = positions; _i < positions_1.length; _i++) {
    var position3 = positions_1[_i];
    var value = styles2["padding-" + position3];
    paddings[position3] = toFloat(value);
  }
  return paddings;
}
function getSVGContentRect(target) {
  var bbox = target.getBBox();
  return createRectInit(0, 0, bbox.width, bbox.height);
}
function getHTMLElementContentRect(target) {
  var clientWidth = target.clientWidth, clientHeight = target.clientHeight;
  if (!clientWidth && !clientHeight) {
    return emptyRect;
  }
  var styles2 = getWindowOf(target).getComputedStyle(target);
  var paddings = getPaddings(styles2);
  var horizPad = paddings.left + paddings.right;
  var vertPad = paddings.top + paddings.bottom;
  var width = toFloat(styles2.width), height = toFloat(styles2.height);
  if (styles2.boxSizing === "border-box") {
    if (Math.round(width + horizPad) !== clientWidth) {
      width -= getBordersSize(styles2, "left", "right") + horizPad;
    }
    if (Math.round(height + vertPad) !== clientHeight) {
      height -= getBordersSize(styles2, "top", "bottom") + vertPad;
    }
  }
  if (!isDocumentElement(target)) {
    var vertScrollbar = Math.round(width + horizPad) - clientWidth;
    var horizScrollbar = Math.round(height + vertPad) - clientHeight;
    if (Math.abs(vertScrollbar) !== 1) {
      width -= vertScrollbar;
    }
    if (Math.abs(horizScrollbar) !== 1) {
      height -= horizScrollbar;
    }
  }
  return createRectInit(paddings.left, paddings.top, width, height);
}
var isSVGGraphicsElement = function() {
  if (typeof SVGGraphicsElement !== "undefined") {
    return function(target) {
      return target instanceof getWindowOf(target).SVGGraphicsElement;
    };
  }
  return function(target) {
    return target instanceof getWindowOf(target).SVGElement && typeof target.getBBox === "function";
  };
}();
function isDocumentElement(target) {
  return target === getWindowOf(target).document.documentElement;
}
function getContentRect(target) {
  if (!isBrowser$2) {
    return emptyRect;
  }
  if (isSVGGraphicsElement(target)) {
    return getSVGContentRect(target);
  }
  return getHTMLElementContentRect(target);
}
function createReadOnlyRect(_a) {
  var x2 = _a.x, y4 = _a.y, width = _a.width, height = _a.height;
  var Constr = typeof DOMRectReadOnly !== "undefined" ? DOMRectReadOnly : Object;
  var rect = Object.create(Constr.prototype);
  defineConfigurable(rect, {
    x: x2,
    y: y4,
    width,
    height,
    top: y4,
    right: x2 + width,
    bottom: height + y4,
    left: x2
  });
  return rect;
}
function createRectInit(x2, y4, width, height) {
  return { x: x2, y: y4, width, height };
}
var ResizeObservation = function() {
  function ResizeObservation2(target) {
    this.broadcastWidth = 0;
    this.broadcastHeight = 0;
    this.contentRect_ = createRectInit(0, 0, 0, 0);
    this.target = target;
  }
  ResizeObservation2.prototype.isActive = function() {
    var rect = getContentRect(this.target);
    this.contentRect_ = rect;
    return rect.width !== this.broadcastWidth || rect.height !== this.broadcastHeight;
  };
  ResizeObservation2.prototype.broadcastRect = function() {
    var rect = this.contentRect_;
    this.broadcastWidth = rect.width;
    this.broadcastHeight = rect.height;
    return rect;
  };
  return ResizeObservation2;
}();
var ResizeObserverEntry = function() {
  function ResizeObserverEntry2(target, rectInit) {
    var contentRect = createReadOnlyRect(rectInit);
    defineConfigurable(this, { target, contentRect });
  }
  return ResizeObserverEntry2;
}();
var ResizeObserverSPI = function() {
  function ResizeObserverSPI2(callback, controller, callbackCtx) {
    this.activeObservations_ = [];
    this.observations_ = new MapShim();
    if (typeof callback !== "function") {
      throw new TypeError("The callback provided as parameter 1 is not a function.");
    }
    this.callback_ = callback;
    this.controller_ = controller;
    this.callbackCtx_ = callbackCtx;
  }
  ResizeObserverSPI2.prototype.observe = function(target) {
    if (!arguments.length) {
      throw new TypeError("1 argument required, but only 0 present.");
    }
    if (typeof Element === "undefined" || !(Element instanceof Object)) {
      return;
    }
    if (!(target instanceof getWindowOf(target).Element)) {
      throw new TypeError('parameter 1 is not of type "Element".');
    }
    var observations = this.observations_;
    if (observations.has(target)) {
      return;
    }
    observations.set(target, new ResizeObservation(target));
    this.controller_.addObserver(this);
    this.controller_.refresh();
  };
  ResizeObserverSPI2.prototype.unobserve = function(target) {
    if (!arguments.length) {
      throw new TypeError("1 argument required, but only 0 present.");
    }
    if (typeof Element === "undefined" || !(Element instanceof Object)) {
      return;
    }
    if (!(target instanceof getWindowOf(target).Element)) {
      throw new TypeError('parameter 1 is not of type "Element".');
    }
    var observations = this.observations_;
    if (!observations.has(target)) {
      return;
    }
    observations.delete(target);
    if (!observations.size) {
      this.controller_.removeObserver(this);
    }
  };
  ResizeObserverSPI2.prototype.disconnect = function() {
    this.clearActive();
    this.observations_.clear();
    this.controller_.removeObserver(this);
  };
  ResizeObserverSPI2.prototype.gatherActive = function() {
    var _this = this;
    this.clearActive();
    this.observations_.forEach(function(observation) {
      if (observation.isActive()) {
        _this.activeObservations_.push(observation);
      }
    });
  };
  ResizeObserverSPI2.prototype.broadcastActive = function() {
    if (!this.hasActive()) {
      return;
    }
    var ctx2 = this.callbackCtx_;
    var entries = this.activeObservations_.map(function(observation) {
      return new ResizeObserverEntry(observation.target, observation.broadcastRect());
    });
    this.callback_.call(ctx2, entries, ctx2);
    this.clearActive();
  };
  ResizeObserverSPI2.prototype.clearActive = function() {
    this.activeObservations_.splice(0);
  };
  ResizeObserverSPI2.prototype.hasActive = function() {
    return this.activeObservations_.length > 0;
  };
  return ResizeObserverSPI2;
}();
var observers = typeof WeakMap !== "undefined" ? /* @__PURE__ */ new WeakMap() : new MapShim();
var ResizeObserver = function() {
  function ResizeObserver2(callback) {
    if (!(this instanceof ResizeObserver2)) {
      throw new TypeError("Cannot call a class as a function.");
    }
    if (!arguments.length) {
      throw new TypeError("1 argument required, but only 0 present.");
    }
    var controller = ResizeObserverController.getInstance();
    var observer = new ResizeObserverSPI(callback, controller, this);
    observers.set(this, observer);
  }
  return ResizeObserver2;
}();
[
  "observe",
  "unobserve",
  "disconnect"
].forEach(function(method) {
  ResizeObserver.prototype[method] = function() {
    var _a;
    return (_a = observers.get(this))[method].apply(_a, arguments);
  };
});
var index$5 = function() {
  if (typeof global$1$1.ResizeObserver !== "undefined") {
    return global$1$1.ResizeObserver;
  }
  return ResizeObserver;
}();
var useEffectWithTarget = createEffectWithTarget$1(useLayoutEffect$6);
var useLayoutEffectWithTarget = useEffectWithTarget;
var useIsomorphicLayoutEffectWithTarget = isBrowser$4 ? useLayoutEffectWithTarget : useEffectWithTarget$2;
var useIsomorphicLayoutEffectWithTarget$1 = useIsomorphicLayoutEffectWithTarget;
var __read = globalThis && globalThis.__read || function(o, n2) {
  var m4 = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m4)
    return o;
  var i2 = m4.call(o), r2, ar = [], e3;
  try {
    while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) {
      ar.push(r2.value);
    }
  } catch (error) {
    e3 = {
      error
    };
  } finally {
    try {
      if (r2 && !r2.done && (m4 = i2["return"]))
        m4.call(i2);
    } finally {
      if (e3)
        throw e3.error;
    }
  }
  return ar;
};
function useSize(target) {
  var _a = __read(useRafState$1(), 2), state = _a[0], setState = _a[1];
  useIsomorphicLayoutEffectWithTarget$1(function() {
    var el = getTargetElement(target);
    if (!el) {
      return;
    }
    var resizeObserver = new index$5(function(entries) {
      entries.forEach(function(entry) {
        var _a2 = entry.target, clientWidth = _a2.clientWidth, clientHeight = _a2.clientHeight;
        setState({
          width: clientWidth,
          height: clientHeight
        });
      });
    });
    resizeObserver.observe(el);
    return function() {
      resizeObserver.disconnect();
    };
  }, [], target);
  return state;
}
var _Theme_color_themeLight = "";
var _Theme_color_themeDark = "";
var _Theme_control_themeLight = "";
var _Theme_font_themeLight = "";
var _Theme_size_themeLight = "";
var _Theme_space_themeLight = "";
var _Theme_shadow_themeLight = "";
var themeLight = {
  color: {
    primary: "themeLight",
    accent: "themeDark",
    invert: "themeDark"
  },
  control: "themeLight",
  font: "themeLight",
  size: "themeLight",
  space: "themeLight",
  shadow: "themeLight"
};
var themeDark = {
  color: {
    primary: "themeDark",
    accent: "themeLight",
    invert: "themeLight"
  },
  control: "themeLight",
  font: "themeLight",
  size: "themeLight",
  space: "themeLight",
  shadow: "themeLight"
};
function getPreset(themeName, presets) {
  const _presets = presets || {
    light: themeLight,
    dark: themeDark
  };
  return _presets[themeName] || _presets.light;
}
const ThemeContext = createContext({});
const themeStorageKey = "df_admin_theme";
const ThemeProvider = ({ children, presetName, presets }) => {
  const prefersMode = useMedia(["(prefers-color-scheme: dark)"], ["dark"], "light");
  const [name2, setName] = useLocalStorageState$1(themeStorageKey, {
    defaultValue: presetName || prefersMode || "light"
  });
  const toggleTheme = useCallback$1((name22) => {
    if (name22)
      setName(name22);
  }, []);
  const preset2 = useMemo$3(() => getPreset(name2, presets), [name2, presets]);
  return /* @__PURE__ */ React__default.createElement(Theme, {
    preset: preset2
  }, /* @__PURE__ */ React__default.createElement(ThemeContext.Provider, {
    value: {
      theme: preset2,
      themeClassNames: generateThemeClassNames(preset2),
      themeName: name2,
      setTheme: toggleTheme
    }
  }, children));
};
function useTheme() {
  return useContext$1(ThemeContext);
}
var cssColorVars = [
  "--color-bg-default",
  "--color-bg-secondary",
  "--color-bg-brand",
  "--color-bg-link",
  "--color-bg-border",
  "--color-bg-stripe",
  "--color-bg-ghost",
  "--color-bg-tone",
  "--color-bg-soft",
  "--color-bg-system",
  "--color-bg-normal",
  "--color-bg-success",
  "--color-bg-caution",
  "--color-bg-warning",
  "--color-bg-alert",
  "--color-bg-critical",
  "--color-typo-primary",
  "--color-typo-secondary",
  "--color-typo-ghost",
  "--color-typo-brand",
  "--color-typo-system",
  "--color-typo-normal",
  "--color-typo-success",
  "--color-typo-caution",
  "--color-typo-warning",
  "--color-typo-alert",
  "--color-typo-critical",
  "--color-typo-link",
  "--color-typo-link-minor",
  "--color-typo-link-hover",
  "--color-scroll-bg",
  "--color-scroll-thumb",
  "--color-scroll-thumb-hover",
  "--color-control-bg-default",
  "--color-control-typo-default",
  "--color-control-typo-placeholder",
  "--color-control-bg-border-default",
  "--color-control-bg-border-default-hover",
  "--color-control-bg-border-focus",
  "--color-control-bg-focus",
  "--color-control-bg-active",
  "--color-control-bg-primary",
  "--color-control-bg-primary-hover",
  "--color-control-typo-primary",
  "--color-control-typo-primary-hover",
  "--color-control-bg-secondary",
  "--color-control-bg-border-secondary",
  "--color-control-bg-border-secondary-hover",
  "--color-control-typo-secondary",
  "--color-control-typo-secondary-hover",
  "--color-control-bg-ghost",
  "--color-control-bg-ghost-hover",
  "--color-control-typo-ghost",
  "--color-control-typo-ghost-hover",
  "--color-control-bg-clear",
  "--color-control-bg-clear-hover",
  "--color-control-typo-clear",
  "--color-control-typo-clear-hover",
  "--color-control-bg-disable",
  "--color-control-bg-border-disable",
  "--color-control-typo-disable"
];
var cssControlVars = [
  "--control-radius",
  "--control-border-width",
  "--control-height-l",
  "--control-height-m",
  "--control-height-s",
  "--control-height-xs",
  "--control-box-size-m",
  "--control-box-size-l",
  "--control-space-l",
  "--control-space-m",
  "--control-space-s",
  "--control-space-xs",
  "--control-text-size-l",
  "--control-text-size-m",
  "--control-text-size-s",
  "--control-text-size-xs"
];
var cssFontVars = ["--font-primary", "--font-mono"];
var cssSizeVars = [
  "--size-text-2xs",
  "--size-text-xs",
  "--size-text-s",
  "--size-text-m",
  "--size-text-l",
  "--size-text-xl",
  "--size-text-2xl",
  "--size-text-3xl",
  "--size-text-4xl",
  "--size-text-5xl",
  "--size-text-6xl",
  "--line-height-text-2xs",
  "--line-height-text-xs",
  "--line-height-text-s",
  "--line-height-text-m",
  "--line-height-text-l"
];
var cssSpaceVars = [
  "--space-3xs",
  "--space-2xs",
  "--space-xs",
  "--space-s",
  "--space-m",
  "--space-l",
  "--space-xl",
  "--space-2xl",
  "--space-3xl",
  "--space-4xl",
  "--space-5xl",
  "--space-6xl"
];
var cssShadowVars = ["--shadow-group", "--shadow-layer", "--shadow-modal"];
var defaultVars = {
  color: {
    primary: cssColorVars,
    accent: cssColorVars,
    invert: cssColorVars
  },
  control: cssControlVars,
  font: cssFontVars,
  size: cssSizeVars,
  space: cssSpaceVars,
  shadow: cssShadowVars
};
var getVars = function(cssVars, element) {
  var vars = {};
  var style2 = getComputedStyle(element);
  for (var i2 = 0; i2 < cssVars.length; i2++) {
    vars[cssVars[i2]] = style2.getPropertyValue(cssVars[i2]).trim();
  }
  return vars;
};
var addElement = function(mods) {
  var element = document.createElement("div");
  element.setAttribute("class", cnTheme(mods));
  document.body.append(element);
  return element;
};
var useThemeVars = function(options) {
  var variables = (options === null || options === void 0 ? void 0 : options.vars) || defaultVars;
  var theme = useTheme$1().theme;
  return useMemo$3(function() {
    var elementPrimary = addElement(__assign$3(__assign$3({}, theme), { color: theme.color.primary }));
    var elementAccent = addElement({ color: theme.color.accent });
    var elementInvert = addElement({ color: theme.color.invert });
    var themeVars = {
      color: {
        primary: getVars(variables.color.primary, elementPrimary),
        accent: getVars(variables.color.accent, elementAccent),
        invert: getVars(variables.color.invert, elementInvert)
      },
      control: getVars(variables.control, elementPrimary),
      font: getVars(variables.font, elementPrimary),
      size: getVars(variables.size, elementPrimary),
      space: getVars(variables.space, elementPrimary),
      shadow: getVars(variables.shadow, elementPrimary)
    };
    document.body.removeChild(elementPrimary);
    document.body.removeChild(elementAccent);
    document.body.removeChild(elementInvert);
    return themeVars;
  }, __spread([
    theme.color.primary,
    theme.color.accent,
    theme.color.invert,
    theme.control,
    theme.font,
    theme.size,
    theme.space,
    theme.shadow
  ], (options === null || options === void 0 ? void 0 : options.deps) ? options.deps : []));
};
const _useThemeVars = () => {
  const vars = useThemeVars();
  const varsInline = useMemo$3(() => {
    const {
      color: { primary: color },
      control: control2,
      font,
      shadow,
      size: sizeVars,
      space: space2
    } = vars;
    return Object.entries(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues({}, color), control2), font), shadow), sizeVars), space2)).map((item2) => item2.join(": ")).join("; ");
  }, [vars]);
  return { vars, varsInline };
};
const Badge = (_c) => {
  var _d = _c, {
    children,
    status,
    count: count2 = null,
    overflowCount = 99,
    dot: dot2 = false,
    size,
    view,
    className,
    showZero = false
  } = _d, restProps = __objRest(_d, [
    "children",
    "status",
    "count",
    "overflowCount",
    "dot",
    "size",
    "view",
    "className",
    "showZero"
  ]);
  const { themeClassNames, themeName } = useTheme();
  const numberedDisplayCount = count2 > overflowCount ? `${overflowCount}+` : count2;
  const isZero = numberedDisplayCount === "0" || numberedDisplayCount === 0;
  const showAsDot = dot2 && !isZero;
  const mergedCount = showAsDot ? "" : numberedDisplayCount;
  const isHidden = useMemo$3(() => {
    const isEmpty = mergedCount === null || mergedCount === void 0 || mergedCount === "";
    return (isEmpty || isZero && !showZero) && !showAsDot;
  }, [mergedCount, isZero, showZero, showAsDot]);
  const countRef = useRef(count2);
  if (!isHidden) {
    countRef.current = count2;
  }
  const livingCount = countRef.current;
  const displayCountRef = useRef(mergedCount);
  if (!isHidden) {
    displayCountRef.current = mergedCount;
  }
  const displayCount = displayCountRef.current;
  const isDotRef = useRef(showAsDot);
  if (!isHidden) {
    isDotRef.current = showAsDot;
  }
  const displayNode = !livingCount || typeof livingCount !== "object" ? void 0 : cloneElement(livingCount);
  const badgeClassName = cn$1(styles$v.badge, {
    [themeClassNames.color.accent]: status !== "system" && view === "filled" && themeName === "light",
    [styles$v.badge__SizeXS]: size === "XS",
    [styles$v.badge__SizeS]: size === "S",
    [styles$v.badge__SizeM]: size === "M",
    [styles$v.badge__SizeL]: size === "L",
    [styles$v.badge__ViewFilled]: view === "filled",
    [styles$v.badge__ViewStroked]: view === "stroked",
    [styles$v.badge__StatusNormal]: status === "normal",
    [styles$v.badge__StatusSuccess]: status === "success",
    [styles$v.badge__StatusError]: status === "error",
    [styles$v.badge__StatusWarning]: status === "warning",
    [styles$v.badge__StatusSystem]: status === "system",
    [styles$v.badge__NotWrapper]: !children
  }, className);
  const noWrapper = !children;
  const transitions2 = useTransition(!isHidden, {
    initial: {
      opacity: 1,
      scale: 1,
      translateX: noWrapper ? 0 : "50%",
      translateY: noWrapper ? 0 : "-50%"
    },
    from: {
      opacity: 0,
      scale: 0,
      translateX: noWrapper ? 0 : "50%",
      translateY: noWrapper ? 0 : "-50%"
    },
    enter: {
      opacity: 1,
      scale: 1,
      translateX: noWrapper ? 0 : "50%",
      translateY: noWrapper ? 0 : "-50%"
    },
    leave: {
      opacity: 0,
      scale: 0,
      translateX: noWrapper ? 0 : "50%",
      translateY: noWrapper ? 0 : "-50%"
    },
    reverse: !isHidden,
    config: __spreadProps(__spreadValues({}, config$2.stiff), { duration: 160 })
  });
  return /* @__PURE__ */ React__default.createElement("div", __spreadProps(__spreadValues({}, restProps), {
    className: badgeClassName
  }), /* @__PURE__ */ React__default.createElement("div", {
    className: themeClassNames.color.primary
  }, children), transitions2((trStyles, item2) => {
    const isDot = isDotRef.current;
    const scrollNumberCls = cn$1({
      [styles$v.dot]: isDot,
      [styles$v.count]: !isDot
    });
    return item2 && /* @__PURE__ */ React__default.createElement(ScrollNumber, {
      show: !isHidden,
      className: scrollNumberCls,
      count: displayCount,
      style: trStyles,
      key: "scrollNumber"
    }, displayNode);
  }));
};
Badge.defaultProps = {
  size: "M",
  view: "filled",
  status: "normal"
};
const button$1 = "_button_1eq8n_1";
const sizeXS = "_sizeXS_1eq8n_27";
const sizeS = "_sizeS_1eq8n_35";
const sizeL = "_sizeL_1eq8n_43";
const onlyIcon = "_onlyIcon_1eq8n_51";
const icon$1 = "_icon_1eq8n_64";
const viewClear = "_viewClear_1eq8n_69";
const viewGhost = "_viewGhost_1eq8n_77";
const viewPrimary = "_viewPrimary_1eq8n_85";
const viewSecondary = "_viewSecondary_1eq8n_93";
const disabled = "_disabled_1eq8n_107";
const loading = "_loading_1eq8n_107";
const content$3 = "_content_1eq8n_117";
const icon__Left = "_icon__Left_1eq8n_132";
const icon__Right = "_icon__Right_1eq8n_135";
var styles$u = {
  button: button$1,
  sizeXS,
  sizeS,
  sizeL,
  onlyIcon,
  icon: icon$1,
  viewClear,
  viewGhost,
  viewPrimary,
  viewSecondary,
  disabled,
  loading,
  content: content$3,
  icon__Left,
  icon__Right
};
function mergeRefs(refs) {
  return function(value) {
    refs.forEach(function(ref) {
      if (typeof ref === "function") {
        ref(value);
      } else if (ref != null) {
        ref.current = value;
      }
    });
  };
}
const Button = forwardRef$3((props, buttonRef) => {
  const _a = props, {
    component: Component2 = "button",
    className,
    size = "M",
    view = "primary",
    loading: loading2,
    disabled: disabled2 = false,
    iconLeft,
    iconRight,
    children
  } = _a, rest = __objRest(_a, [
    "component",
    "className",
    "size",
    "view",
    "loading",
    "disabled",
    "iconLeft",
    "iconRight",
    "children"
  ]);
  const withLoader = typeof loading2 === "boolean";
  const ref = useRef(null);
  const onlyIcon2 = !!iconLeft && !iconRight && !children || !!iconRight && !iconLeft && !children;
  const content2 = /* @__PURE__ */ React__default.createElement("span", {
    className: styles$u.content
  }, iconLeft && /* @__PURE__ */ React__default.createElement("span", {
    className: cn$1(styles$u.icon, styles$u.icon__Left)
  }, iconLeft), children, iconRight && /* @__PURE__ */ React__default.createElement("span", {
    className: cn$1(styles$u.icon, styles$u.icon__Right)
  }, iconRight));
  return /* @__PURE__ */ React__default.createElement(Component2, __spreadValues(__spreadValues({
    ref: mergeRefs([ref, buttonRef]),
    className: cn$1(styles$u.button, {
      [styles$u.disabled]: loading2 ? false : disabled2,
      [styles$u.loading]: withLoader ? loading2 : false,
      [styles$u.viewPrimary]: view === "primary",
      [styles$u.viewSecondary]: view === "secondary",
      [styles$u.viewGhost]: view === "ghost",
      [styles$u.viewClear]: view === "clear",
      [styles$u.sizeL]: size === "L",
      [styles$u.sizeS]: size === "S",
      [styles$u.sizeXS]: size === "XS",
      [styles$u.onlyIcon]: onlyIcon2
    }, className)
  }, Component2 === "button" && { disabled: disabled2 || !!loading2 }), rest), withLoader ? /* @__PURE__ */ React__default.createElement(Spin, {
    spinning: loading2,
    className: styles$u.spinner
  }, content2) : content2);
});
var Button$1 = memo(Button);
const card$2 = "_card_13up2_1";
const card__NoShadow = "_card__NoShadow_13up2_9";
const card__FormSquare = "_card__FormSquare_13up2_12";
const card__SpaceVerticalXS = "_card__SpaceVerticalXS_13up2_15";
const card__SpaceVerticalS = "_card__SpaceVerticalS_13up2_19";
const card__SpaceVerticalM = "_card__SpaceVerticalM_13up2_23";
const card__SpaceVerticalL = "_card__SpaceVerticalL_13up2_27";
const card__SpaceVerticalXL = "_card__SpaceVerticalXL_13up2_31";
const card__SpaceVertical2XL = "_card__SpaceVertical2XL_13up2_35";
const card__SpaceVertical3XL = "_card__SpaceVertical3XL_13up2_39";
const card__SpaceVertical4XL = "_card__SpaceVertical4XL_13up2_43";
const card__SpaceVertical5XL = "_card__SpaceVertical5XL_13up2_47";
const card__SpaceHorizontalXS = "_card__SpaceHorizontalXS_13up2_51";
const card__SpaceHorizontalS = "_card__SpaceHorizontalS_13up2_55";
const card__SpaceHorizontalM = "_card__SpaceHorizontalM_13up2_59";
const card__SpaceHorizontalL = "_card__SpaceHorizontalL_13up2_63";
const card__SpaceHorizontalXL = "_card__SpaceHorizontalXL_13up2_67";
const card__SpaceHorizontal2XL = "_card__SpaceHorizontal2XL_13up2_71";
const card__SpaceHorizontal3XL = "_card__SpaceHorizontal3XL_13up2_75";
const card__SpaceHorizontal4XL = "_card__SpaceHorizontal4XL_13up2_79";
const card__SpaceHorizontal5XL = "_card__SpaceHorizontal5XL_13up2_83";
var styles$t = {
  card: card$2,
  card__NoShadow,
  card__FormSquare,
  card__SpaceVerticalXS,
  card__SpaceVerticalS,
  card__SpaceVerticalM,
  card__SpaceVerticalL,
  card__SpaceVerticalXL,
  card__SpaceVertical2XL,
  card__SpaceVertical3XL,
  card__SpaceVertical4XL,
  card__SpaceVertical5XL,
  card__SpaceHorizontalXS,
  card__SpaceHorizontalS,
  card__SpaceHorizontalM,
  card__SpaceHorizontalL,
  card__SpaceHorizontalXL,
  card__SpaceHorizontal2XL,
  card__SpaceHorizontal3XL,
  card__SpaceHorizontal4XL,
  card__SpaceHorizontal5XL
};
const Card = forwardRef$3((props, cardRef) => {
  const _a = props, {
    component: Component2 = "div",
    className,
    verticalSpace = "3xl",
    horizontalSpace = "3xl",
    form = "round",
    shadow = true,
    children
  } = _a, rest = __objRest(_a, [
    "component",
    "className",
    "verticalSpace",
    "horizontalSpace",
    "form",
    "shadow",
    "children"
  ]);
  const ref = useRef(null);
  const content2 = /* @__PURE__ */ React__default.createElement("div", {
    className: styles$t.content
  }, children);
  return /* @__PURE__ */ React__default.createElement(Component2, __spreadValues({
    ref: mergeRefs([ref, cardRef]),
    className: cn$1(styles$t.card, {
      [styles$t.card__FormSquare]: form === "square",
      [styles$t.card__NoShadow]: !shadow,
      [styles$t.card__SpaceVerticalXS]: verticalSpace === "xs",
      [styles$t.card__SpaceVerticalS]: verticalSpace === "s",
      [styles$t.card__SpaceVerticalM]: verticalSpace === "m",
      [styles$t.card__SpaceVerticalL]: verticalSpace === "l",
      [styles$t.card__SpaceVerticalXL]: verticalSpace === "xl",
      [styles$t.card__SpaceVertical2XL]: verticalSpace === "2xl",
      [styles$t.card__SpaceVertical3XL]: verticalSpace === "3xl",
      [styles$t.card__SpaceVertical4XL]: verticalSpace === "4xl",
      [styles$t.card__SpaceVertical5XL]: verticalSpace === "5xl",
      [styles$t.card__SpaceHorizontalXS]: horizontalSpace === "xs",
      [styles$t.card__SpaceHorizontalS]: horizontalSpace === "s",
      [styles$t.card__SpaceHorizontalM]: horizontalSpace === "m",
      [styles$t.card__SpaceHorizontalL]: horizontalSpace === "l",
      [styles$t.card__SpaceHorizontalXL]: horizontalSpace === "xl",
      [styles$t.card__SpaceHorizontal2XL]: horizontalSpace === "2xl",
      [styles$t.card__SpaceHorizontal3XL]: horizontalSpace === "3xl",
      [styles$t.card__SpaceHorizontal4XL]: horizontalSpace === "4xl",
      [styles$t.card__SpaceHorizontal5XL]: horizontalSpace === "5xl"
    }, className)
  }, rest), content2);
});
var Card$1 = memo(Card);
const wrapper$7 = "_wrapper_1okl0_1";
const wrapper__Radio = "_wrapper__Radio_1okl0_15";
const inner = "_inner_1okl0_15";
const input$3 = "_input_1okl0_25";
const wrapper__Indeterminate = "_wrapper__Indeterminate_1okl0_28";
const wrapper__Ghost = "_wrapper__Ghost_1okl0_42";
const animFocus$2 = "_animFocus_1okl0_1";
var styles$s = {
  wrapper: wrapper$7,
  wrapper__Radio,
  inner,
  input: input$3,
  wrapper__Indeterminate,
  wrapper__Ghost,
  animFocus: animFocus$2
};
const InternalChoice = (props, outerRef) => {
  const _a = props, {
    checked: checkedFromProps,
    defaultChecked: defaultCheckedFromProps = false,
    type = "checkbox",
    view = "primary",
    disabled: disabled2,
    onChange: onChange2,
    style: style2,
    classNames,
    indeterminate = false
  } = _a, restProps = __objRest(_a, [
    "checked",
    "defaultChecked",
    "type",
    "view",
    "disabled",
    "onChange",
    "style",
    "classNames",
    "indeterminate"
  ]);
  const [checked, setChecked] = useState$1(checkedFromProps != null ? checkedFromProps : defaultCheckedFromProps);
  const ref = useRef(null);
  useEffect(() => {
    if (typeof checkedFromProps === "boolean" && checkedFromProps !== checked) {
      setChecked(checkedFromProps);
    }
  }, [checkedFromProps]);
  const _onChange = (e3) => {
    if (disabled2) {
      return;
    }
    if (typeof checkedFromProps !== "boolean") {
      setChecked(e3.target.checked);
    }
    if (onChange2) {
      onChange2({
        target: __spreadProps(__spreadValues({}, props), {
          checked: e3.target.checked
        }),
        event: e3.nativeEvent
      });
    }
  };
  return /* @__PURE__ */ React__default.createElement("span", {
    className: cn$1(styles$s.wrapper, classNames == null ? void 0 : classNames.wrapper, {
      [styles$s.wrapper__Radio]: type === "radio",
      [styles$s.wrapper__Indeterminate]: type !== "radio" && indeterminate,
      [styles$s.wrapper__Ghost]: view === "ghost"
    }),
    style: style2
  }, /* @__PURE__ */ React__default.createElement("input", __spreadProps(__spreadValues({}, restProps), {
    type,
    checked,
    ref: mergeRefs([ref, outerRef]),
    className: cn$1(styles$s.input, classNames == null ? void 0 : classNames.input),
    onChange: _onChange,
    disabled: disabled2
  })), /* @__PURE__ */ React__default.createElement("span", {
    className: cn$1(styles$s.inner, classNames == null ? void 0 : classNames.inner)
  }));
};
const Choice = forwardRef$3(InternalChoice);
var Choice$1 = memo(Choice);
const checkbox = "_checkbox_1fg6h_1";
const checkbox__Large = "_checkbox__Large_1fg6h_12";
const checkbox__AlignTop = "_checkbox__AlignTop_1fg6h_17";
const checkbox__Empty = "_checkbox__Empty_1fg6h_20";
const checkbox__AlignCenter = "_checkbox__AlignCenter_1fg6h_23";
const checkbox__AlignBottom = "_checkbox__AlignBottom_1fg6h_26";
var styles$r = {
  checkbox,
  checkbox__Large,
  checkbox__AlignTop,
  checkbox__Empty,
  checkbox__AlignCenter,
  checkbox__AlignBottom
};
const InternalCheckbox = (_e, ref) => {
  var _f = _e, { className, children, style: style2, onMouseEnter, onMouseLeave, size, align = "top" } = _f, restProps = __objRest(_f, ["className", "children", "style", "onMouseEnter", "onMouseLeave", "size", "align"]);
  const choiceProps = __spreadValues({}, restProps);
  return /* @__PURE__ */ React__default.createElement("label", {
    className: cn$1(styles$r.checkbox, {
      [styles$r.checkbox__Large]: size === "l",
      [styles$r.checkbox__AlignTop]: align === "top",
      [styles$r.checkbox__AlignCenter]: align === "center",
      [styles$r.checkbox__AlignBottom]: align === "bottom",
      [styles$r.checkbox__Empty]: !children
    }, className),
    style: style2,
    onMouseEnter,
    onMouseLeave
  }, /* @__PURE__ */ React__default.createElement(Choice$1, __spreadProps(__spreadValues({}, choiceProps), {
    ref
  })), children && /* @__PURE__ */ React__default.createElement("span", null, children));
};
const Checkbox = forwardRef$3(InternalCheckbox);
var Checkbox$1 = memo(Checkbox);
var lib = {};
var flattenNames$1 = {};
var baseGetTag$2 = _baseGetTag, isArray$a = isArray_1, isObjectLike$6 = isObjectLike_1;
var stringTag$4 = "[object String]";
function isString$1(value) {
  return typeof value == "string" || !isArray$a(value) && isObjectLike$6(value) && baseGetTag$2(value) == stringTag$4;
}
var isString_1 = isString$1;
function createBaseFor$2(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index2 = -1, iterable = Object(object), props = keysFunc(object), length = props.length;
    while (length--) {
      var key = props[fromRight ? length : ++index2];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}
var _createBaseFor = createBaseFor$2;
var createBaseFor$1 = _createBaseFor;
var baseFor$3 = createBaseFor$1();
var _baseFor = baseFor$3;
var baseFor$2 = _baseFor, keys$4 = keys_1;
function baseForOwn$3(object, iteratee) {
  return object && baseFor$2(object, iteratee, keys$4);
}
var _baseForOwn = baseForOwn$3;
function identity$3(value) {
  return value;
}
var identity_1 = identity$3;
var identity$2 = identity_1;
function castFunction$2(value) {
  return typeof value == "function" ? value : identity$2;
}
var _castFunction = castFunction$2;
var baseForOwn$2 = _baseForOwn, castFunction$1 = _castFunction;
function forOwn(object, iteratee) {
  return object && baseForOwn$2(object, castFunction$1(iteratee));
}
var forOwn_1 = forOwn;
var overArg$1 = _overArg;
var getPrototype$5 = overArg$1(Object.getPrototypeOf, Object);
var _getPrototype = getPrototype$5;
var baseGetTag$1 = _baseGetTag, getPrototype$4 = _getPrototype, isObjectLike$5 = isObjectLike_1;
var objectTag$5 = "[object Object]";
var funcProto$3 = Function.prototype, objectProto$k = Object.prototype;
var funcToString$3 = funcProto$3.toString;
var hasOwnProperty$f = objectProto$k.hasOwnProperty;
var objectCtorString$1 = funcToString$3.call(Object);
function isPlainObject$3(value) {
  if (!isObjectLike$5(value) || baseGetTag$1(value) != objectTag$5) {
    return false;
  }
  var proto = getPrototype$4(value);
  if (proto === null) {
    return true;
  }
  var Ctor = hasOwnProperty$f.call(proto, "constructor") && proto.constructor;
  return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString$3.call(Ctor) == objectCtorString$1;
}
var isPlainObject_1 = isPlainObject$3;
function arrayMap$3(array, iteratee) {
  var index2 = -1, length = array == null ? 0 : array.length, result = Array(length);
  while (++index2 < length) {
    result[index2] = iteratee(array[index2], index2, array);
  }
  return result;
}
var _arrayMap = arrayMap$3;
var Stack$2 = _Stack, baseIsEqual$2 = _baseIsEqual;
var COMPARE_PARTIAL_FLAG$7 = 1, COMPARE_UNORDERED_FLAG$5 = 2;
function baseIsMatch$2(object, source2, matchData, customizer) {
  var index2 = matchData.length, length = index2, noCustomizer = !customizer;
  if (object == null) {
    return !length;
  }
  object = Object(object);
  while (index2--) {
    var data2 = matchData[index2];
    if (noCustomizer && data2[2] ? data2[1] !== object[data2[0]] : !(data2[0] in object)) {
      return false;
    }
  }
  while (++index2 < length) {
    data2 = matchData[index2];
    var key = data2[0], objValue = object[key], srcValue = data2[1];
    if (noCustomizer && data2[2]) {
      if (objValue === void 0 && !(key in object)) {
        return false;
      }
    } else {
      var stack = new Stack$2();
      if (customizer) {
        var result = customizer(objValue, srcValue, key, object, source2, stack);
      }
      if (!(result === void 0 ? baseIsEqual$2(srcValue, objValue, COMPARE_PARTIAL_FLAG$7 | COMPARE_UNORDERED_FLAG$5, customizer, stack) : result)) {
        return false;
      }
    }
  }
  return true;
}
var _baseIsMatch = baseIsMatch$2;
var isObject$8 = isObject_1;
function isStrictComparable$3(value) {
  return value === value && !isObject$8(value);
}
var _isStrictComparable = isStrictComparable$3;
var isStrictComparable$2 = _isStrictComparable, keys$3 = keys_1;
function getMatchData$2(object) {
  var result = keys$3(object), length = result.length;
  while (length--) {
    var key = result[length], value = object[key];
    result[length] = [key, value, isStrictComparable$2(value)];
  }
  return result;
}
var _getMatchData = getMatchData$2;
function matchesStrictComparable$3(key, srcValue) {
  return function(object) {
    if (object == null) {
      return false;
    }
    return object[key] === srcValue && (srcValue !== void 0 || key in Object(object));
  };
}
var _matchesStrictComparable = matchesStrictComparable$3;
var baseIsMatch$1 = _baseIsMatch, getMatchData$1 = _getMatchData, matchesStrictComparable$2 = _matchesStrictComparable;
function baseMatches$2(source2) {
  var matchData = getMatchData$1(source2);
  if (matchData.length == 1 && matchData[0][2]) {
    return matchesStrictComparable$2(matchData[0][0], matchData[0][1]);
  }
  return function(object) {
    return object === source2 || baseIsMatch$1(object, source2, matchData);
  };
}
var _baseMatches = baseMatches$2;
var isArray$9 = isArray_1, isSymbol$5 = isSymbol_1;
var reIsDeepProp$1 = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp$1 = /^\w*$/;
function isKey$4(value, object) {
  if (isArray$9(value)) {
    return false;
  }
  var type = typeof value;
  if (type == "number" || type == "symbol" || type == "boolean" || value == null || isSymbol$5(value)) {
    return true;
  }
  return reIsPlainProp$1.test(value) || !reIsDeepProp$1.test(value) || object != null && value in Object(object);
}
var _isKey = isKey$4;
var MapCache$1 = _MapCache;
var FUNC_ERROR_TEXT$5 = "Expected a function";
function memoize$2(func, resolver) {
  if (typeof func != "function" || resolver != null && typeof resolver != "function") {
    throw new TypeError(FUNC_ERROR_TEXT$5);
  }
  var memoized = function() {
    var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache2 = memoized.cache;
    if (cache2.has(key)) {
      return cache2.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache2.set(key, result) || cache2;
    return result;
  };
  memoized.cache = new (memoize$2.Cache || MapCache$1)();
  return memoized;
}
memoize$2.Cache = MapCache$1;
var memoize_1 = memoize$2;
var memoize$1 = memoize_1;
var MAX_MEMOIZE_SIZE$1 = 500;
function memoizeCapped$2(func) {
  var result = memoize$1(func, function(key) {
    if (cache2.size === MAX_MEMOIZE_SIZE$1) {
      cache2.clear();
    }
    return key;
  });
  var cache2 = result.cache;
  return result;
}
var _memoizeCapped = memoizeCapped$2;
var memoizeCapped$1 = _memoizeCapped;
var rePropName$1 = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
var reEscapeChar$1 = /\\(\\)?/g;
var stringToPath$3 = memoizeCapped$1(function(string) {
  var result = [];
  if (string.charCodeAt(0) === 46) {
    result.push("");
  }
  string.replace(rePropName$1, function(match2, number, quote2, subString) {
    result.push(quote2 ? subString.replace(reEscapeChar$1, "$1") : number || match2);
  });
  return result;
});
var _stringToPath = stringToPath$3;
var Symbol$4 = _Symbol, arrayMap$2 = _arrayMap, isArray$8 = isArray_1, isSymbol$4 = isSymbol_1;
var INFINITY$3 = 1 / 0;
var symbolProto$3 = Symbol$4 ? Symbol$4.prototype : void 0, symbolToString$1 = symbolProto$3 ? symbolProto$3.toString : void 0;
function baseToString$2(value) {
  if (typeof value == "string") {
    return value;
  }
  if (isArray$8(value)) {
    return arrayMap$2(value, baseToString$2) + "";
  }
  if (isSymbol$4(value)) {
    return symbolToString$1 ? symbolToString$1.call(value) : "";
  }
  var result = value + "";
  return result == "0" && 1 / value == -INFINITY$3 ? "-0" : result;
}
var _baseToString = baseToString$2;
var baseToString$1 = _baseToString;
function toString$3(value) {
  return value == null ? "" : baseToString$1(value);
}
var toString_1 = toString$3;
var isArray$7 = isArray_1, isKey$3 = _isKey, stringToPath$2 = _stringToPath, toString$2 = toString_1;
function castPath$3(value, object) {
  if (isArray$7(value)) {
    return value;
  }
  return isKey$3(value, object) ? [value] : stringToPath$2(toString$2(value));
}
var _castPath = castPath$3;
var isSymbol$3 = isSymbol_1;
var INFINITY$2 = 1 / 0;
function toKey$5(value) {
  if (typeof value == "string" || isSymbol$3(value)) {
    return value;
  }
  var result = value + "";
  return result == "0" && 1 / value == -INFINITY$2 ? "-0" : result;
}
var _toKey = toKey$5;
var castPath$2 = _castPath, toKey$4 = _toKey;
function baseGet$3(object, path) {
  path = castPath$2(path, object);
  var index2 = 0, length = path.length;
  while (object != null && index2 < length) {
    object = object[toKey$4(path[index2++])];
  }
  return index2 && index2 == length ? object : void 0;
}
var _baseGet = baseGet$3;
var baseGet$2 = _baseGet;
function get$3(object, path, defaultValue2) {
  var result = object == null ? void 0 : baseGet$2(object, path);
  return result === void 0 ? defaultValue2 : result;
}
var get_1 = get$3;
function baseHasIn$2(object, key) {
  return object != null && key in Object(object);
}
var _baseHasIn = baseHasIn$2;
var castPath$1 = _castPath, isArguments$2 = isArguments_1, isArray$6 = isArray_1, isIndex$1 = _isIndex, isLength$1 = isLength_1, toKey$3 = _toKey;
function hasPath$2(object, path, hasFunc) {
  path = castPath$1(path, object);
  var index2 = -1, length = path.length, result = false;
  while (++index2 < length) {
    var key = toKey$3(path[index2]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result || ++index2 != length) {
    return result;
  }
  length = object == null ? 0 : object.length;
  return !!length && isLength$1(length) && isIndex$1(key, length) && (isArray$6(object) || isArguments$2(object));
}
var _hasPath = hasPath$2;
var baseHasIn$1 = _baseHasIn, hasPath$1 = _hasPath;
function hasIn$2(object, path) {
  return object != null && hasPath$1(object, path, baseHasIn$1);
}
var hasIn_1 = hasIn$2;
var baseIsEqual$1 = _baseIsEqual, get$2 = get_1, hasIn$1 = hasIn_1, isKey$2 = _isKey, isStrictComparable$1 = _isStrictComparable, matchesStrictComparable$1 = _matchesStrictComparable, toKey$2 = _toKey;
var COMPARE_PARTIAL_FLAG$6 = 1, COMPARE_UNORDERED_FLAG$4 = 2;
function baseMatchesProperty$2(path, srcValue) {
  if (isKey$2(path) && isStrictComparable$1(srcValue)) {
    return matchesStrictComparable$1(toKey$2(path), srcValue);
  }
  return function(object) {
    var objValue = get$2(object, path);
    return objValue === void 0 && objValue === srcValue ? hasIn$1(object, path) : baseIsEqual$1(srcValue, objValue, COMPARE_PARTIAL_FLAG$6 | COMPARE_UNORDERED_FLAG$4);
  };
}
var _baseMatchesProperty = baseMatchesProperty$2;
function baseProperty$2(key) {
  return function(object) {
    return object == null ? void 0 : object[key];
  };
}
var _baseProperty = baseProperty$2;
var baseGet$1 = _baseGet;
function basePropertyDeep$2(path) {
  return function(object) {
    return baseGet$1(object, path);
  };
}
var _basePropertyDeep = basePropertyDeep$2;
var baseProperty$1 = _baseProperty, basePropertyDeep$1 = _basePropertyDeep, isKey$1 = _isKey, toKey$1 = _toKey;
function property$2(path) {
  return isKey$1(path) ? baseProperty$1(toKey$1(path)) : basePropertyDeep$1(path);
}
var property_1 = property$2;
var baseMatches$1 = _baseMatches, baseMatchesProperty$1 = _baseMatchesProperty, identity$1 = identity_1, isArray$5 = isArray_1, property$1 = property_1;
function baseIteratee$2(value) {
  if (typeof value == "function") {
    return value;
  }
  if (value == null) {
    return identity$1;
  }
  if (typeof value == "object") {
    return isArray$5(value) ? baseMatchesProperty$1(value[0], value[1]) : baseMatches$1(value);
  }
  return property$1(value);
}
var _baseIteratee = baseIteratee$2;
var isArrayLike$3 = isArrayLike_1;
function createBaseEach$2(eachFunc, fromRight) {
  return function(collection, iteratee) {
    if (collection == null) {
      return collection;
    }
    if (!isArrayLike$3(collection)) {
      return eachFunc(collection, iteratee);
    }
    var length = collection.length, index2 = fromRight ? length : -1, iterable = Object(collection);
    while (fromRight ? index2-- : ++index2 < length) {
      if (iteratee(iterable[index2], index2, iterable) === false) {
        break;
      }
    }
    return collection;
  };
}
var _createBaseEach = createBaseEach$2;
var baseForOwn$1 = _baseForOwn, createBaseEach$1 = _createBaseEach;
var baseEach$3 = createBaseEach$1(baseForOwn$1);
var _baseEach = baseEach$3;
var baseEach$2 = _baseEach, isArrayLike$2 = isArrayLike_1;
function baseMap$2(collection, iteratee) {
  var index2 = -1, result = isArrayLike$2(collection) ? Array(collection.length) : [];
  baseEach$2(collection, function(value, key, collection2) {
    result[++index2] = iteratee(value, key, collection2);
  });
  return result;
}
var _baseMap = baseMap$2;
var arrayMap$1 = _arrayMap, baseIteratee$1 = _baseIteratee, baseMap$1 = _baseMap, isArray$4 = isArray_1;
function map$1(collection, iteratee) {
  var func = isArray$4(collection) ? arrayMap$1 : baseMap$1;
  return func(collection, baseIteratee$1(iteratee));
}
var map_1 = map$1;
Object.defineProperty(flattenNames$1, "__esModule", {
  value: true
});
flattenNames$1.flattenNames = void 0;
var _isString2 = isString_1;
var _isString3 = _interopRequireDefault$e(_isString2);
var _forOwn2$2 = forOwn_1;
var _forOwn3$2 = _interopRequireDefault$e(_forOwn2$2);
var _isPlainObject2 = isPlainObject_1;
var _isPlainObject3 = _interopRequireDefault$e(_isPlainObject2);
var _map2 = map_1;
var _map3 = _interopRequireDefault$e(_map2);
function _interopRequireDefault$e(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}
var flattenNames = flattenNames$1.flattenNames = function flattenNames2() {
  var things = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : [];
  var names = [];
  (0, _map3.default)(things, function(thing) {
    if (Array.isArray(thing)) {
      flattenNames2(thing).map(function(name2) {
        return names.push(name2);
      });
    } else if ((0, _isPlainObject3.default)(thing)) {
      (0, _forOwn3$2.default)(thing, function(value, key) {
        value === true && names.push(key);
        names.push(key + "-" + value);
      });
    } else if ((0, _isString3.default)(thing)) {
      names.push(thing);
    }
  });
  return names;
};
flattenNames$1.default = flattenNames;
var mergeClasses$1 = {};
function arrayEach$2(array, iteratee) {
  var index2 = -1, length = array == null ? 0 : array.length;
  while (++index2 < length) {
    if (iteratee(array[index2], index2, array) === false) {
      break;
    }
  }
  return array;
}
var _arrayEach = arrayEach$2;
var getNative$1 = _getNative;
var defineProperty$4 = function() {
  try {
    var func = getNative$1(Object, "defineProperty");
    func({}, "", {});
    return func;
  } catch (e3) {
  }
}();
var _defineProperty$7 = defineProperty$4;
var defineProperty$3 = _defineProperty$7;
function baseAssignValue$3(object, key, value) {
  if (key == "__proto__" && defineProperty$3) {
    defineProperty$3(object, key, {
      "configurable": true,
      "enumerable": true,
      "value": value,
      "writable": true
    });
  } else {
    object[key] = value;
  }
}
var _baseAssignValue = baseAssignValue$3;
var baseAssignValue$2 = _baseAssignValue, eq$1 = eq_1;
var objectProto$j = Object.prototype;
var hasOwnProperty$e = objectProto$j.hasOwnProperty;
function assignValue$3(object, key, value) {
  var objValue = object[key];
  if (!(hasOwnProperty$e.call(object, key) && eq$1(objValue, value)) || value === void 0 && !(key in object)) {
    baseAssignValue$2(object, key, value);
  }
}
var _assignValue = assignValue$3;
var assignValue$2 = _assignValue, baseAssignValue$1 = _baseAssignValue;
function copyObject$5(source2, props, object, customizer) {
  var isNew = !object;
  object || (object = {});
  var index2 = -1, length = props.length;
  while (++index2 < length) {
    var key = props[index2];
    var newValue = customizer ? customizer(object[key], source2[key], key, object, source2) : void 0;
    if (newValue === void 0) {
      newValue = source2[key];
    }
    if (isNew) {
      baseAssignValue$1(object, key, newValue);
    } else {
      assignValue$2(object, key, newValue);
    }
  }
  return object;
}
var _copyObject = copyObject$5;
var copyObject$4 = _copyObject, keys$2 = keys_1;
function baseAssign$1(object, source2) {
  return object && copyObject$4(source2, keys$2(source2), object);
}
var _baseAssign = baseAssign$1;
function nativeKeysIn$2(object) {
  var result = [];
  if (object != null) {
    for (var key in Object(object)) {
      result.push(key);
    }
  }
  return result;
}
var _nativeKeysIn = nativeKeysIn$2;
var isObject$7 = isObject_1, isPrototype$2 = _isPrototype, nativeKeysIn$1 = _nativeKeysIn;
var objectProto$i = Object.prototype;
var hasOwnProperty$d = objectProto$i.hasOwnProperty;
function baseKeysIn$2(object) {
  if (!isObject$7(object)) {
    return nativeKeysIn$1(object);
  }
  var isProto = isPrototype$2(object), result = [];
  for (var key in object) {
    if (!(key == "constructor" && (isProto || !hasOwnProperty$d.call(object, key)))) {
      result.push(key);
    }
  }
  return result;
}
var _baseKeysIn = baseKeysIn$2;
var arrayLikeKeys$1 = _arrayLikeKeys, baseKeysIn$1 = _baseKeysIn, isArrayLike$1 = isArrayLike_1;
function keysIn$4(object) {
  return isArrayLike$1(object) ? arrayLikeKeys$1(object, true) : baseKeysIn$1(object);
}
var keysIn_1 = keysIn$4;
var copyObject$3 = _copyObject, keysIn$3 = keysIn_1;
function baseAssignIn$1(object, source2) {
  return object && copyObject$3(source2, keysIn$3(source2), object);
}
var _baseAssignIn = baseAssignIn$1;
var _cloneBuffer = { exports: {} };
(function(module2, exports2) {
  var root2 = _root;
  var freeExports2 = exports2 && !exports2.nodeType && exports2;
  var freeModule2 = freeExports2 && true && module2 && !module2.nodeType && module2;
  var moduleExports2 = freeModule2 && freeModule2.exports === freeExports2;
  var Buffer3 = moduleExports2 ? root2.Buffer : void 0, allocUnsafe2 = Buffer3 ? Buffer3.allocUnsafe : void 0;
  function cloneBuffer2(buffer, isDeep) {
    if (isDeep) {
      return buffer.slice();
    }
    var length = buffer.length, result = allocUnsafe2 ? allocUnsafe2(length) : new buffer.constructor(length);
    buffer.copy(result);
    return result;
  }
  module2.exports = cloneBuffer2;
})(_cloneBuffer, _cloneBuffer.exports);
function copyArray$2(source2, array) {
  var index2 = -1, length = source2.length;
  array || (array = Array(length));
  while (++index2 < length) {
    array[index2] = source2[index2];
  }
  return array;
}
var _copyArray = copyArray$2;
var copyObject$2 = _copyObject, getSymbols$3 = _getSymbols;
function copySymbols$1(source2, object) {
  return copyObject$2(source2, getSymbols$3(source2), object);
}
var _copySymbols = copySymbols$1;
var arrayPush$1 = _arrayPush, getPrototype$3 = _getPrototype, getSymbols$2 = _getSymbols, stubArray$1 = stubArray_1;
var nativeGetSymbols$1 = Object.getOwnPropertySymbols;
var getSymbolsIn$2 = !nativeGetSymbols$1 ? stubArray$1 : function(object) {
  var result = [];
  while (object) {
    arrayPush$1(result, getSymbols$2(object));
    object = getPrototype$3(object);
  }
  return result;
};
var _getSymbolsIn = getSymbolsIn$2;
var copyObject$1 = _copyObject, getSymbolsIn$1 = _getSymbolsIn;
function copySymbolsIn$1(source2, object) {
  return copyObject$1(source2, getSymbolsIn$1(source2), object);
}
var _copySymbolsIn = copySymbolsIn$1;
var baseGetAllKeys$1 = _baseGetAllKeys, getSymbolsIn = _getSymbolsIn, keysIn$2 = keysIn_1;
function getAllKeysIn$1(object) {
  return baseGetAllKeys$1(object, keysIn$2, getSymbolsIn);
}
var _getAllKeysIn = getAllKeysIn$1;
var objectProto$h = Object.prototype;
var hasOwnProperty$c = objectProto$h.hasOwnProperty;
function initCloneArray$1(array) {
  var length = array.length, result = new array.constructor(length);
  if (length && typeof array[0] == "string" && hasOwnProperty$c.call(array, "index")) {
    result.index = array.index;
    result.input = array.input;
  }
  return result;
}
var _initCloneArray = initCloneArray$1;
var Uint8Array$3 = _Uint8Array;
function cloneArrayBuffer$4(arrayBuffer) {
  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  new Uint8Array$3(result).set(new Uint8Array$3(arrayBuffer));
  return result;
}
var _cloneArrayBuffer = cloneArrayBuffer$4;
var cloneArrayBuffer$3 = _cloneArrayBuffer;
function cloneDataView$1(dataView, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer$3(dataView.buffer) : dataView.buffer;
  return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
}
var _cloneDataView = cloneDataView$1;
var reFlags = /\w*$/;
function cloneRegExp$1(regexp) {
  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
  result.lastIndex = regexp.lastIndex;
  return result;
}
var _cloneRegExp = cloneRegExp$1;
var Symbol$3 = _Symbol;
var symbolProto$2 = Symbol$3 ? Symbol$3.prototype : void 0, symbolValueOf$1 = symbolProto$2 ? symbolProto$2.valueOf : void 0;
function cloneSymbol$1(symbol) {
  return symbolValueOf$1 ? Object(symbolValueOf$1.call(symbol)) : {};
}
var _cloneSymbol = cloneSymbol$1;
var cloneArrayBuffer$2 = _cloneArrayBuffer;
function cloneTypedArray$2(typedArray, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer$2(typedArray.buffer) : typedArray.buffer;
  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}
var _cloneTypedArray = cloneTypedArray$2;
var cloneArrayBuffer$1 = _cloneArrayBuffer, cloneDataView = _cloneDataView, cloneRegExp = _cloneRegExp, cloneSymbol = _cloneSymbol, cloneTypedArray$1 = _cloneTypedArray;
var boolTag$3 = "[object Boolean]", dateTag$3 = "[object Date]", mapTag$5 = "[object Map]", numberTag$3 = "[object Number]", regexpTag$3 = "[object RegExp]", setTag$5 = "[object Set]", stringTag$3 = "[object String]", symbolTag$5 = "[object Symbol]";
var arrayBufferTag$3 = "[object ArrayBuffer]", dataViewTag$4 = "[object DataView]", float32Tag$2 = "[object Float32Array]", float64Tag$2 = "[object Float64Array]", int8Tag$2 = "[object Int8Array]", int16Tag$2 = "[object Int16Array]", int32Tag$2 = "[object Int32Array]", uint8Tag$2 = "[object Uint8Array]", uint8ClampedTag$2 = "[object Uint8ClampedArray]", uint16Tag$2 = "[object Uint16Array]", uint32Tag$2 = "[object Uint32Array]";
function initCloneByTag$1(object, tag, isDeep) {
  var Ctor = object.constructor;
  switch (tag) {
    case arrayBufferTag$3:
      return cloneArrayBuffer$1(object);
    case boolTag$3:
    case dateTag$3:
      return new Ctor(+object);
    case dataViewTag$4:
      return cloneDataView(object, isDeep);
    case float32Tag$2:
    case float64Tag$2:
    case int8Tag$2:
    case int16Tag$2:
    case int32Tag$2:
    case uint8Tag$2:
    case uint8ClampedTag$2:
    case uint16Tag$2:
    case uint32Tag$2:
      return cloneTypedArray$1(object, isDeep);
    case mapTag$5:
      return new Ctor();
    case numberTag$3:
    case stringTag$3:
      return new Ctor(object);
    case regexpTag$3:
      return cloneRegExp(object);
    case setTag$5:
      return new Ctor();
    case symbolTag$5:
      return cloneSymbol(object);
  }
}
var _initCloneByTag = initCloneByTag$1;
var isObject$6 = isObject_1;
var objectCreate$1 = Object.create;
var baseCreate$3 = function() {
  function object() {
  }
  return function(proto) {
    if (!isObject$6(proto)) {
      return {};
    }
    if (objectCreate$1) {
      return objectCreate$1(proto);
    }
    object.prototype = proto;
    var result = new object();
    object.prototype = void 0;
    return result;
  };
}();
var _baseCreate = baseCreate$3;
var baseCreate$2 = _baseCreate, getPrototype$2 = _getPrototype, isPrototype$1 = _isPrototype;
function initCloneObject$2(object) {
  return typeof object.constructor == "function" && !isPrototype$1(object) ? baseCreate$2(getPrototype$2(object)) : {};
}
var _initCloneObject = initCloneObject$2;
var getTag$4 = _getTag, isObjectLike$4 = isObjectLike_1;
var mapTag$4 = "[object Map]";
function baseIsMap$1(value) {
  return isObjectLike$4(value) && getTag$4(value) == mapTag$4;
}
var _baseIsMap = baseIsMap$1;
var baseIsMap = _baseIsMap, baseUnary$2 = _baseUnary, nodeUtil$3 = _nodeUtil.exports;
var nodeIsMap = nodeUtil$3 && nodeUtil$3.isMap;
var isMap$1 = nodeIsMap ? baseUnary$2(nodeIsMap) : baseIsMap;
var isMap_1 = isMap$1;
var getTag$3 = _getTag, isObjectLike$3 = isObjectLike_1;
var setTag$4 = "[object Set]";
function baseIsSet$1(value) {
  return isObjectLike$3(value) && getTag$3(value) == setTag$4;
}
var _baseIsSet = baseIsSet$1;
var baseIsSet = _baseIsSet, baseUnary$1 = _baseUnary, nodeUtil$2 = _nodeUtil.exports;
var nodeIsSet = nodeUtil$2 && nodeUtil$2.isSet;
var isSet$1 = nodeIsSet ? baseUnary$1(nodeIsSet) : baseIsSet;
var isSet_1 = isSet$1;
var Stack$1 = _Stack, arrayEach$1 = _arrayEach, assignValue$1 = _assignValue, baseAssign = _baseAssign, baseAssignIn = _baseAssignIn, cloneBuffer$1 = _cloneBuffer.exports, copyArray$1 = _copyArray, copySymbols = _copySymbols, copySymbolsIn = _copySymbolsIn, getAllKeys$1 = _getAllKeys, getAllKeysIn = _getAllKeysIn, getTag$2 = _getTag, initCloneArray = _initCloneArray, initCloneByTag = _initCloneByTag, initCloneObject$1 = _initCloneObject, isArray$3 = isArray_1, isBuffer$3 = isBuffer$6.exports, isMap = isMap_1, isObject$5 = isObject_1, isSet = isSet_1, keys$1 = keys_1, keysIn$1 = keysIn_1;
var CLONE_DEEP_FLAG$1 = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG$1 = 4;
var argsTag$3 = "[object Arguments]", arrayTag$2 = "[object Array]", boolTag$2 = "[object Boolean]", dateTag$2 = "[object Date]", errorTag$2 = "[object Error]", funcTag$2 = "[object Function]", genTag$1 = "[object GeneratorFunction]", mapTag$3 = "[object Map]", numberTag$2 = "[object Number]", objectTag$4 = "[object Object]", regexpTag$2 = "[object RegExp]", setTag$3 = "[object Set]", stringTag$2 = "[object String]", symbolTag$4 = "[object Symbol]", weakMapTag$2 = "[object WeakMap]";
var arrayBufferTag$2 = "[object ArrayBuffer]", dataViewTag$3 = "[object DataView]", float32Tag$1 = "[object Float32Array]", float64Tag$1 = "[object Float64Array]", int8Tag$1 = "[object Int8Array]", int16Tag$1 = "[object Int16Array]", int32Tag$1 = "[object Int32Array]", uint8Tag$1 = "[object Uint8Array]", uint8ClampedTag$1 = "[object Uint8ClampedArray]", uint16Tag$1 = "[object Uint16Array]", uint32Tag$1 = "[object Uint32Array]";
var cloneableTags = {};
cloneableTags[argsTag$3] = cloneableTags[arrayTag$2] = cloneableTags[arrayBufferTag$2] = cloneableTags[dataViewTag$3] = cloneableTags[boolTag$2] = cloneableTags[dateTag$2] = cloneableTags[float32Tag$1] = cloneableTags[float64Tag$1] = cloneableTags[int8Tag$1] = cloneableTags[int16Tag$1] = cloneableTags[int32Tag$1] = cloneableTags[mapTag$3] = cloneableTags[numberTag$2] = cloneableTags[objectTag$4] = cloneableTags[regexpTag$2] = cloneableTags[setTag$3] = cloneableTags[stringTag$2] = cloneableTags[symbolTag$4] = cloneableTags[uint8Tag$1] = cloneableTags[uint8ClampedTag$1] = cloneableTags[uint16Tag$1] = cloneableTags[uint32Tag$1] = true;
cloneableTags[errorTag$2] = cloneableTags[funcTag$2] = cloneableTags[weakMapTag$2] = false;
function baseClone$1(value, bitmask, customizer, key, object, stack) {
  var result, isDeep = bitmask & CLONE_DEEP_FLAG$1, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG$1;
  if (customizer) {
    result = object ? customizer(value, key, object, stack) : customizer(value);
  }
  if (result !== void 0) {
    return result;
  }
  if (!isObject$5(value)) {
    return value;
  }
  var isArr = isArray$3(value);
  if (isArr) {
    result = initCloneArray(value);
    if (!isDeep) {
      return copyArray$1(value, result);
    }
  } else {
    var tag = getTag$2(value), isFunc = tag == funcTag$2 || tag == genTag$1;
    if (isBuffer$3(value)) {
      return cloneBuffer$1(value, isDeep);
    }
    if (tag == objectTag$4 || tag == argsTag$3 || isFunc && !object) {
      result = isFlat || isFunc ? {} : initCloneObject$1(value);
      if (!isDeep) {
        return isFlat ? copySymbolsIn(value, baseAssignIn(result, value)) : copySymbols(value, baseAssign(result, value));
      }
    } else {
      if (!cloneableTags[tag]) {
        return object ? value : {};
      }
      result = initCloneByTag(value, tag, isDeep);
    }
  }
  stack || (stack = new Stack$1());
  var stacked = stack.get(value);
  if (stacked) {
    return stacked;
  }
  stack.set(value, result);
  if (isSet(value)) {
    value.forEach(function(subValue) {
      result.add(baseClone$1(subValue, bitmask, customizer, subValue, value, stack));
    });
  } else if (isMap(value)) {
    value.forEach(function(subValue, key2) {
      result.set(key2, baseClone$1(subValue, bitmask, customizer, key2, value, stack));
    });
  }
  var keysFunc = isFull ? isFlat ? getAllKeysIn : getAllKeys$1 : isFlat ? keysIn$1 : keys$1;
  var props = isArr ? void 0 : keysFunc(value);
  arrayEach$1(props || value, function(subValue, key2) {
    if (props) {
      key2 = subValue;
      subValue = value[key2];
    }
    assignValue$1(result, key2, baseClone$1(subValue, bitmask, customizer, key2, value, stack));
  });
  return result;
}
var _baseClone = baseClone$1;
var baseClone = _baseClone;
var CLONE_DEEP_FLAG = 1, CLONE_SYMBOLS_FLAG = 4;
function cloneDeep(value) {
  return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
}
var cloneDeep_1 = cloneDeep;
Object.defineProperty(mergeClasses$1, "__esModule", {
  value: true
});
mergeClasses$1.mergeClasses = void 0;
var _forOwn2$1 = forOwn_1;
var _forOwn3$1 = _interopRequireDefault$d(_forOwn2$1);
var _cloneDeep2 = cloneDeep_1;
var _cloneDeep3 = _interopRequireDefault$d(_cloneDeep2);
var _extends$f = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
function _interopRequireDefault$d(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}
var mergeClasses = mergeClasses$1.mergeClasses = function mergeClasses2(classes) {
  var activeNames = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : [];
  var styles2 = classes.default && (0, _cloneDeep3.default)(classes.default) || {};
  activeNames.map(function(name2) {
    var toMerge = classes[name2];
    if (toMerge) {
      (0, _forOwn3$1.default)(toMerge, function(value, key) {
        if (!styles2[key]) {
          styles2[key] = {};
        }
        styles2[key] = _extends$f({}, styles2[key], toMerge[key]);
      });
    }
    return name2;
  });
  return styles2;
};
mergeClasses$1.default = mergeClasses;
var autoprefix$1 = {};
Object.defineProperty(autoprefix$1, "__esModule", {
  value: true
});
autoprefix$1.autoprefix = void 0;
var _forOwn2 = forOwn_1;
var _forOwn3 = _interopRequireDefault$c(_forOwn2);
var _extends$e = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
function _interopRequireDefault$c(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}
var transforms$1 = {
  borderRadius: function borderRadius(value) {
    return {
      msBorderRadius: value,
      MozBorderRadius: value,
      OBorderRadius: value,
      WebkitBorderRadius: value,
      borderRadius: value
    };
  },
  boxShadow: function boxShadow(value) {
    return {
      msBoxShadow: value,
      MozBoxShadow: value,
      OBoxShadow: value,
      WebkitBoxShadow: value,
      boxShadow: value
    };
  },
  userSelect: function userSelect(value) {
    return {
      WebkitTouchCallout: value,
      KhtmlUserSelect: value,
      MozUserSelect: value,
      msUserSelect: value,
      WebkitUserSelect: value,
      userSelect: value
    };
  },
  flex: function flex(value) {
    return {
      WebkitBoxFlex: value,
      MozBoxFlex: value,
      WebkitFlex: value,
      msFlex: value,
      flex: value
    };
  },
  flexBasis: function flexBasis(value) {
    return {
      WebkitFlexBasis: value,
      flexBasis: value
    };
  },
  justifyContent: function justifyContent(value) {
    return {
      WebkitJustifyContent: value,
      justifyContent: value
    };
  },
  transition: function transition(value) {
    return {
      msTransition: value,
      MozTransition: value,
      OTransition: value,
      WebkitTransition: value,
      transition: value
    };
  },
  transform: function transform(value) {
    return {
      msTransform: value,
      MozTransform: value,
      OTransform: value,
      WebkitTransform: value,
      transform: value
    };
  },
  absolute: function absolute(value) {
    var direction = value && value.split(" ");
    return {
      position: "absolute",
      top: direction && direction[0],
      right: direction && direction[1],
      bottom: direction && direction[2],
      left: direction && direction[3]
    };
  },
  extend: function extend(name2, otherElementStyles) {
    var otherStyle = otherElementStyles[name2];
    if (otherStyle) {
      return otherStyle;
    }
    return {
      "extend": name2
    };
  }
};
var autoprefix = autoprefix$1.autoprefix = function autoprefix2(elements) {
  var prefixed = {};
  (0, _forOwn3.default)(elements, function(styles2, element) {
    var expanded = {};
    (0, _forOwn3.default)(styles2, function(value, key) {
      var transform2 = transforms$1[key];
      if (transform2) {
        expanded = _extends$e({}, expanded, transform2(value));
      } else {
        expanded[key] = value;
      }
    });
    prefixed[element] = expanded;
  });
  return prefixed;
};
autoprefix$1.default = autoprefix;
var hover$1 = {};
Object.defineProperty(hover$1, "__esModule", {
  value: true
});
hover$1.hover = void 0;
var _extends$d = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var _react$4 = React__default;
var _react2$3 = _interopRequireDefault$b(_react$4);
function _interopRequireDefault$b(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}
function _classCallCheck$d(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _possibleConstructorReturn$c(self2, call2) {
  if (!self2) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return call2 && (typeof call2 === "object" || typeof call2 === "function") ? call2 : self2;
}
function _inherits$c(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });
  if (superClass)
    Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
}
var hover = hover$1.hover = function hover2(Component2) {
  var Span = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "span";
  return function(_React$Component) {
    _inherits$c(Hover, _React$Component);
    function Hover() {
      var _ref;
      var _temp, _this, _ret;
      _classCallCheck$d(this, Hover);
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      return _ret = (_temp = (_this = _possibleConstructorReturn$c(this, (_ref = Hover.__proto__ || Object.getPrototypeOf(Hover)).call.apply(_ref, [this].concat(args))), _this), _this.state = { hover: false }, _this.handleMouseOver = function() {
        return _this.setState({ hover: true });
      }, _this.handleMouseOut = function() {
        return _this.setState({ hover: false });
      }, _this.render = function() {
        return _react2$3.default.createElement(Span, { onMouseOver: _this.handleMouseOver, onMouseOut: _this.handleMouseOut }, _react2$3.default.createElement(Component2, _extends$d({}, _this.props, _this.state)));
      }, _temp), _possibleConstructorReturn$c(_this, _ret);
    }
    return Hover;
  }(_react2$3.default.Component);
};
hover$1.default = hover;
var active$1 = {};
Object.defineProperty(active$1, "__esModule", {
  value: true
});
active$1.active = void 0;
var _extends$c = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var _react$3 = React__default;
var _react2$2 = _interopRequireDefault$a(_react$3);
function _interopRequireDefault$a(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}
function _classCallCheck$c(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _possibleConstructorReturn$b(self2, call2) {
  if (!self2) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return call2 && (typeof call2 === "object" || typeof call2 === "function") ? call2 : self2;
}
function _inherits$b(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });
  if (superClass)
    Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
}
var active = active$1.active = function active2(Component2) {
  var Span = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "span";
  return function(_React$Component) {
    _inherits$b(Active, _React$Component);
    function Active() {
      var _ref;
      var _temp, _this, _ret;
      _classCallCheck$c(this, Active);
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      return _ret = (_temp = (_this = _possibleConstructorReturn$b(this, (_ref = Active.__proto__ || Object.getPrototypeOf(Active)).call.apply(_ref, [this].concat(args))), _this), _this.state = { active: false }, _this.handleMouseDown = function() {
        return _this.setState({ active: true });
      }, _this.handleMouseUp = function() {
        return _this.setState({ active: false });
      }, _this.render = function() {
        return _react2$2.default.createElement(Span, { onMouseDown: _this.handleMouseDown, onMouseUp: _this.handleMouseUp }, _react2$2.default.createElement(Component2, _extends$c({}, _this.props, _this.state)));
      }, _temp), _possibleConstructorReturn$b(_this, _ret);
    }
    return Active;
  }(_react2$2.default.Component);
};
active$1.default = active;
var loop = {};
Object.defineProperty(loop, "__esModule", {
  value: true
});
var loopable = function loopable2(i2, length) {
  var props = {};
  var setProp = function setProp2(name2) {
    var value = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : true;
    props[name2] = value;
  };
  i2 === 0 && setProp("first-child");
  i2 === length - 1 && setProp("last-child");
  (i2 === 0 || i2 % 2 === 0) && setProp("even");
  Math.abs(i2 % 2) === 1 && setProp("odd");
  setProp("nth-child", i2);
  return props;
};
loop.default = loopable;
Object.defineProperty(lib, "__esModule", {
  value: true
});
lib.ReactCSS = lib.loop = lib.handleActive = handleHover = lib.handleHover = lib.hover = void 0;
var _flattenNames = flattenNames$1;
var _flattenNames2 = _interopRequireDefault$9(_flattenNames);
var _mergeClasses = mergeClasses$1;
var _mergeClasses2 = _interopRequireDefault$9(_mergeClasses);
var _autoprefix = autoprefix$1;
var _autoprefix2 = _interopRequireDefault$9(_autoprefix);
var _hover2 = hover$1;
var _hover3 = _interopRequireDefault$9(_hover2);
var _active = active$1;
var _active2 = _interopRequireDefault$9(_active);
var _loop2 = loop;
var _loop3 = _interopRequireDefault$9(_loop2);
function _interopRequireDefault$9(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}
lib.hover = _hover3.default;
var handleHover = lib.handleHover = _hover3.default;
lib.handleActive = _active2.default;
lib.loop = _loop3.default;
var ReactCSS = lib.ReactCSS = function ReactCSS2(classes) {
  for (var _len = arguments.length, activations = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    activations[_key - 1] = arguments[_key];
  }
  var activeNames = (0, _flattenNames2.default)(activations);
  var merged = (0, _mergeClasses2.default)(classes, activeNames);
  return (0, _autoprefix2.default)(merged);
};
var _default$9 = lib.default = ReactCSS;
var calculateChange$2 = function calculateChange(e3, hsl2, direction, initialA, container2) {
  var containerWidth = container2.clientWidth;
  var containerHeight = container2.clientHeight;
  var x2 = typeof e3.pageX === "number" ? e3.pageX : e3.touches[0].pageX;
  var y4 = typeof e3.pageY === "number" ? e3.pageY : e3.touches[0].pageY;
  var left2 = x2 - (container2.getBoundingClientRect().left + window.pageXOffset);
  var top2 = y4 - (container2.getBoundingClientRect().top + window.pageYOffset);
  if (direction === "vertical") {
    var a3 = void 0;
    if (top2 < 0) {
      a3 = 0;
    } else if (top2 > containerHeight) {
      a3 = 1;
    } else {
      a3 = Math.round(top2 * 100 / containerHeight) / 100;
    }
    if (hsl2.a !== a3) {
      return {
        h: hsl2.h,
        s: hsl2.s,
        l: hsl2.l,
        a: a3,
        source: "rgb"
      };
    }
  } else {
    var _a = void 0;
    if (left2 < 0) {
      _a = 0;
    } else if (left2 > containerWidth) {
      _a = 1;
    } else {
      _a = Math.round(left2 * 100 / containerWidth) / 100;
    }
    if (initialA !== _a) {
      return {
        h: hsl2.h,
        s: hsl2.s,
        l: hsl2.l,
        a: _a,
        source: "rgb"
      };
    }
  }
  return null;
};
var checkboardCache = {};
var render$1 = function render(c12, c22, size, serverCanvas) {
  if (typeof document === "undefined" && !serverCanvas) {
    return null;
  }
  var canvas = serverCanvas ? new serverCanvas() : document.createElement("canvas");
  canvas.width = size * 2;
  canvas.height = size * 2;
  var ctx2 = canvas.getContext("2d");
  if (!ctx2) {
    return null;
  }
  ctx2.fillStyle = c12;
  ctx2.fillRect(0, 0, canvas.width, canvas.height);
  ctx2.fillStyle = c22;
  ctx2.fillRect(0, 0, size, size);
  ctx2.translate(size, size);
  ctx2.fillRect(0, 0, size, size);
  return canvas.toDataURL();
};
var get$1 = function get(c12, c22, size, serverCanvas) {
  var key = c12 + "-" + c22 + "-" + size + (serverCanvas ? "-server" : "");
  if (checkboardCache[key]) {
    return checkboardCache[key];
  }
  var checkboard = render$1(c12, c22, size, serverCanvas);
  checkboardCache[key] = checkboard;
  return checkboard;
};
var _extends$b = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var Checkboard = function Checkboard2(_ref) {
  var white = _ref.white, grey = _ref.grey, size = _ref.size, renderers = _ref.renderers, borderRadius2 = _ref.borderRadius, boxShadow2 = _ref.boxShadow, children = _ref.children;
  var styles2 = _default$9({
    "default": {
      grid: {
        borderRadius: borderRadius2,
        boxShadow: boxShadow2,
        absolute: "0px 0px 0px 0px",
        background: "url(" + get$1(white, grey, size, renderers.canvas) + ") center left"
      }
    }
  });
  return isValidElement(children) ? React__default.cloneElement(children, _extends$b({}, children.props, { style: _extends$b({}, children.props.style, styles2.grid) })) : React__default.createElement("div", { style: styles2.grid });
};
Checkboard.defaultProps = {
  size: 8,
  white: "transparent",
  grey: "rgba(0,0,0,.08)",
  renderers: {}
};
var _extends$a = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var _createClass$b = function() {
  function defineProperties(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  return function(Constructor, protoProps, staticProps) {
    if (protoProps)
      defineProperties(Constructor.prototype, protoProps);
    if (staticProps)
      defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();
function _classCallCheck$b(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _possibleConstructorReturn$a(self2, call2) {
  if (!self2) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return call2 && (typeof call2 === "object" || typeof call2 === "function") ? call2 : self2;
}
function _inherits$a(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });
  if (superClass)
    Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
}
var Alpha = function(_ref) {
  _inherits$a(Alpha2, _ref);
  function Alpha2() {
    var _ref2;
    var _temp, _this, _ret;
    _classCallCheck$b(this, Alpha2);
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    return _ret = (_temp = (_this = _possibleConstructorReturn$a(this, (_ref2 = Alpha2.__proto__ || Object.getPrototypeOf(Alpha2)).call.apply(_ref2, [this].concat(args))), _this), _this.handleChange = function(e3) {
      var change = calculateChange$2(e3, _this.props.hsl, _this.props.direction, _this.props.a, _this.container);
      change && typeof _this.props.onChange === "function" && _this.props.onChange(change, e3);
    }, _this.handleMouseDown = function(e3) {
      _this.handleChange(e3);
      window.addEventListener("mousemove", _this.handleChange);
      window.addEventListener("mouseup", _this.handleMouseUp);
    }, _this.handleMouseUp = function() {
      _this.unbindEventListeners();
    }, _this.unbindEventListeners = function() {
      window.removeEventListener("mousemove", _this.handleChange);
      window.removeEventListener("mouseup", _this.handleMouseUp);
    }, _temp), _possibleConstructorReturn$a(_this, _ret);
  }
  _createClass$b(Alpha2, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unbindEventListeners();
    }
  }, {
    key: "render",
    value: function render4() {
      var _this2 = this;
      var rgb2 = this.props.rgb;
      var styles2 = _default$9({
        "default": {
          alpha: {
            absolute: "0px 0px 0px 0px",
            borderRadius: this.props.radius
          },
          checkboard: {
            absolute: "0px 0px 0px 0px",
            overflow: "hidden",
            borderRadius: this.props.radius
          },
          gradient: {
            absolute: "0px 0px 0px 0px",
            background: "linear-gradient(to right, rgba(" + rgb2.r + "," + rgb2.g + "," + rgb2.b + ", 0) 0%,\n           rgba(" + rgb2.r + "," + rgb2.g + "," + rgb2.b + ", 1) 100%)",
            boxShadow: this.props.shadow,
            borderRadius: this.props.radius
          },
          container: {
            position: "relative",
            height: "100%",
            margin: "0 3px"
          },
          pointer: {
            position: "absolute",
            left: rgb2.a * 100 + "%"
          },
          slider: {
            width: "4px",
            borderRadius: "1px",
            height: "8px",
            boxShadow: "0 0 2px rgba(0, 0, 0, .6)",
            background: "#fff",
            marginTop: "1px",
            transform: "translateX(-2px)"
          }
        },
        "vertical": {
          gradient: {
            background: "linear-gradient(to bottom, rgba(" + rgb2.r + "," + rgb2.g + "," + rgb2.b + ", 0) 0%,\n           rgba(" + rgb2.r + "," + rgb2.g + "," + rgb2.b + ", 1) 100%)"
          },
          pointer: {
            left: 0,
            top: rgb2.a * 100 + "%"
          }
        },
        "overwrite": _extends$a({}, this.props.style)
      }, {
        vertical: this.props.direction === "vertical",
        overwrite: true
      });
      return React__default.createElement("div", { style: styles2.alpha }, React__default.createElement("div", { style: styles2.checkboard }, React__default.createElement(Checkboard, { renderers: this.props.renderers })), React__default.createElement("div", { style: styles2.gradient }), React__default.createElement("div", {
        style: styles2.container,
        ref: function ref(container2) {
          return _this2.container = container2;
        },
        onMouseDown: this.handleMouseDown,
        onTouchMove: this.handleChange,
        onTouchStart: this.handleChange
      }, React__default.createElement("div", { style: styles2.pointer }, this.props.pointer ? React__default.createElement(this.props.pointer, this.props) : React__default.createElement("div", { style: styles2.slider }))));
    }
  }]);
  return Alpha2;
}(PureComponent || Component);
var _createClass$a = function() {
  function defineProperties(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  return function(Constructor, protoProps, staticProps) {
    if (protoProps)
      defineProperties(Constructor.prototype, protoProps);
    if (staticProps)
      defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();
function _defineProperty$6(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _classCallCheck$a(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _possibleConstructorReturn$9(self2, call2) {
  if (!self2) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return call2 && (typeof call2 === "object" || typeof call2 === "function") ? call2 : self2;
}
function _inherits$9(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });
  if (superClass)
    Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
}
var DEFAULT_ARROW_OFFSET = 1;
var UP_KEY_CODE = 38;
var DOWN_KEY_CODE = 40;
var VALID_KEY_CODES = [UP_KEY_CODE, DOWN_KEY_CODE];
var isValidKeyCode = function isValidKeyCode2(keyCode) {
  return VALID_KEY_CODES.indexOf(keyCode) > -1;
};
var getNumberValue = function getNumberValue2(value) {
  return Number(String(value).replace(/%/g, ""));
};
var idCounter$1 = 1;
var EditableInput = function(_ref) {
  _inherits$9(EditableInput2, _ref);
  function EditableInput2(props) {
    _classCallCheck$a(this, EditableInput2);
    var _this = _possibleConstructorReturn$9(this, (EditableInput2.__proto__ || Object.getPrototypeOf(EditableInput2)).call(this));
    _this.handleBlur = function() {
      if (_this.state.blurValue) {
        _this.setState({ value: _this.state.blurValue, blurValue: null });
      }
    };
    _this.handleChange = function(e3) {
      _this.setUpdatedValue(e3.target.value, e3);
    };
    _this.handleKeyDown = function(e3) {
      var value = getNumberValue(e3.target.value);
      if (!isNaN(value) && isValidKeyCode(e3.keyCode)) {
        var offset4 = _this.getArrowOffset();
        var updatedValue = e3.keyCode === UP_KEY_CODE ? value + offset4 : value - offset4;
        _this.setUpdatedValue(updatedValue, e3);
      }
    };
    _this.handleDrag = function(e3) {
      if (_this.props.dragLabel) {
        var newValue = Math.round(_this.props.value + e3.movementX);
        if (newValue >= 0 && newValue <= _this.props.dragMax) {
          _this.props.onChange && _this.props.onChange(_this.getValueObjectWithLabel(newValue), e3);
        }
      }
    };
    _this.handleMouseDown = function(e3) {
      if (_this.props.dragLabel) {
        e3.preventDefault();
        _this.handleDrag(e3);
        window.addEventListener("mousemove", _this.handleDrag);
        window.addEventListener("mouseup", _this.handleMouseUp);
      }
    };
    _this.handleMouseUp = function() {
      _this.unbindEventListeners();
    };
    _this.unbindEventListeners = function() {
      window.removeEventListener("mousemove", _this.handleDrag);
      window.removeEventListener("mouseup", _this.handleMouseUp);
    };
    _this.state = {
      value: String(props.value).toUpperCase(),
      blurValue: String(props.value).toUpperCase()
    };
    _this.inputId = "rc-editable-input-" + idCounter$1++;
    return _this;
  }
  _createClass$a(EditableInput2, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (this.props.value !== this.state.value && (prevProps.value !== this.props.value || prevState.value !== this.state.value)) {
        if (this.input === document.activeElement) {
          this.setState({ blurValue: String(this.props.value).toUpperCase() });
        } else {
          this.setState({ value: String(this.props.value).toUpperCase(), blurValue: !this.state.blurValue && String(this.props.value).toUpperCase() });
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unbindEventListeners();
    }
  }, {
    key: "getValueObjectWithLabel",
    value: function getValueObjectWithLabel(value) {
      return _defineProperty$6({}, this.props.label, value);
    }
  }, {
    key: "getArrowOffset",
    value: function getArrowOffset() {
      return this.props.arrowOffset || DEFAULT_ARROW_OFFSET;
    }
  }, {
    key: "setUpdatedValue",
    value: function setUpdatedValue(value, e3) {
      var onChangeValue = this.props.label ? this.getValueObjectWithLabel(value) : value;
      this.props.onChange && this.props.onChange(onChangeValue, e3);
      this.setState({ value });
    }
  }, {
    key: "render",
    value: function render4() {
      var _this2 = this;
      var styles2 = _default$9({
        "default": {
          wrap: {
            position: "relative"
          }
        },
        "user-override": {
          wrap: this.props.style && this.props.style.wrap ? this.props.style.wrap : {},
          input: this.props.style && this.props.style.input ? this.props.style.input : {},
          label: this.props.style && this.props.style.label ? this.props.style.label : {}
        },
        "dragLabel-true": {
          label: {
            cursor: "ew-resize"
          }
        }
      }, {
        "user-override": true
      }, this.props);
      return React__default.createElement("div", { style: styles2.wrap }, React__default.createElement("input", {
        id: this.inputId,
        style: styles2.input,
        ref: function ref(input2) {
          return _this2.input = input2;
        },
        value: this.state.value,
        onKeyDown: this.handleKeyDown,
        onChange: this.handleChange,
        onBlur: this.handleBlur,
        placeholder: this.props.placeholder,
        spellCheck: "false"
      }), this.props.label && !this.props.hideLabel ? React__default.createElement("label", {
        htmlFor: this.inputId,
        style: styles2.label,
        onMouseDown: this.handleMouseDown
      }, this.props.label) : null);
    }
  }]);
  return EditableInput2;
}(PureComponent || Component);
var calculateChange$1 = function calculateChange2(e3, direction, hsl2, container2) {
  var containerWidth = container2.clientWidth;
  var containerHeight = container2.clientHeight;
  var x2 = typeof e3.pageX === "number" ? e3.pageX : e3.touches[0].pageX;
  var y4 = typeof e3.pageY === "number" ? e3.pageY : e3.touches[0].pageY;
  var left2 = x2 - (container2.getBoundingClientRect().left + window.pageXOffset);
  var top2 = y4 - (container2.getBoundingClientRect().top + window.pageYOffset);
  if (direction === "vertical") {
    var h4 = void 0;
    if (top2 < 0) {
      h4 = 359;
    } else if (top2 > containerHeight) {
      h4 = 0;
    } else {
      var percent = -(top2 * 100 / containerHeight) + 100;
      h4 = 360 * percent / 100;
    }
    if (hsl2.h !== h4) {
      return {
        h: h4,
        s: hsl2.s,
        l: hsl2.l,
        a: hsl2.a,
        source: "hsl"
      };
    }
  } else {
    var _h = void 0;
    if (left2 < 0) {
      _h = 0;
    } else if (left2 > containerWidth) {
      _h = 359;
    } else {
      var _percent = left2 * 100 / containerWidth;
      _h = 360 * _percent / 100;
    }
    if (hsl2.h !== _h) {
      return {
        h: _h,
        s: hsl2.s,
        l: hsl2.l,
        a: hsl2.a,
        source: "hsl"
      };
    }
  }
  return null;
};
var _createClass$9 = function() {
  function defineProperties(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  return function(Constructor, protoProps, staticProps) {
    if (protoProps)
      defineProperties(Constructor.prototype, protoProps);
    if (staticProps)
      defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();
function _classCallCheck$9(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _possibleConstructorReturn$8(self2, call2) {
  if (!self2) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return call2 && (typeof call2 === "object" || typeof call2 === "function") ? call2 : self2;
}
function _inherits$8(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });
  if (superClass)
    Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
}
var Hue = function(_ref) {
  _inherits$8(Hue2, _ref);
  function Hue2() {
    var _ref2;
    var _temp, _this, _ret;
    _classCallCheck$9(this, Hue2);
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    return _ret = (_temp = (_this = _possibleConstructorReturn$8(this, (_ref2 = Hue2.__proto__ || Object.getPrototypeOf(Hue2)).call.apply(_ref2, [this].concat(args))), _this), _this.handleChange = function(e3) {
      var change = calculateChange$1(e3, _this.props.direction, _this.props.hsl, _this.container);
      change && typeof _this.props.onChange === "function" && _this.props.onChange(change, e3);
    }, _this.handleMouseDown = function(e3) {
      _this.handleChange(e3);
      window.addEventListener("mousemove", _this.handleChange);
      window.addEventListener("mouseup", _this.handleMouseUp);
    }, _this.handleMouseUp = function() {
      _this.unbindEventListeners();
    }, _temp), _possibleConstructorReturn$8(_this, _ret);
  }
  _createClass$9(Hue2, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unbindEventListeners();
    }
  }, {
    key: "unbindEventListeners",
    value: function unbindEventListeners() {
      window.removeEventListener("mousemove", this.handleChange);
      window.removeEventListener("mouseup", this.handleMouseUp);
    }
  }, {
    key: "render",
    value: function render4() {
      var _this2 = this;
      var _props$direction = this.props.direction, direction = _props$direction === void 0 ? "horizontal" : _props$direction;
      var styles2 = _default$9({
        "default": {
          hue: {
            absolute: "0px 0px 0px 0px",
            borderRadius: this.props.radius,
            boxShadow: this.props.shadow
          },
          container: {
            padding: "0 2px",
            position: "relative",
            height: "100%",
            borderRadius: this.props.radius
          },
          pointer: {
            position: "absolute",
            left: this.props.hsl.h * 100 / 360 + "%"
          },
          slider: {
            marginTop: "1px",
            width: "4px",
            borderRadius: "1px",
            height: "8px",
            boxShadow: "0 0 2px rgba(0, 0, 0, .6)",
            background: "#fff",
            transform: "translateX(-2px)"
          }
        },
        "vertical": {
          pointer: {
            left: "0px",
            top: -(this.props.hsl.h * 100 / 360) + 100 + "%"
          }
        }
      }, { vertical: direction === "vertical" });
      return React__default.createElement("div", { style: styles2.hue }, React__default.createElement("div", {
        className: "hue-" + direction,
        style: styles2.container,
        ref: function ref(container2) {
          return _this2.container = container2;
        },
        onMouseDown: this.handleMouseDown,
        onTouchMove: this.handleChange,
        onTouchStart: this.handleChange
      }, React__default.createElement("style", null, "\n            .hue-horizontal {\n              background: linear-gradient(to right, #f00 0%, #ff0 17%, #0f0\n                33%, #0ff 50%, #00f 67%, #f0f 83%, #f00 100%);\n              background: -webkit-linear-gradient(to right, #f00 0%, #ff0\n                17%, #0f0 33%, #0ff 50%, #00f 67%, #f0f 83%, #f00 100%);\n            }\n\n            .hue-vertical {\n              background: linear-gradient(to top, #f00 0%, #ff0 17%, #0f0 33%,\n                #0ff 50%, #00f 67%, #f0f 83%, #f00 100%);\n              background: -webkit-linear-gradient(to top, #f00 0%, #ff0 17%,\n                #0f0 33%, #0ff 50%, #00f 67%, #f0f 83%, #f00 100%);\n            }\n          "), React__default.createElement("div", { style: styles2.pointer }, this.props.pointer ? React__default.createElement(this.props.pointer, this.props) : React__default.createElement("div", { style: styles2.slider }))));
    }
  }]);
  return Hue2;
}(PureComponent || Component);
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}
function eq(value, other) {
  return value === other || value !== value && other !== other;
}
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}
var arrayProto = Array.prototype;
var splice = arrayProto.splice;
function listCacheDelete(key) {
  var data2 = this.__data__, index2 = assocIndexOf(data2, key);
  if (index2 < 0) {
    return false;
  }
  var lastIndex = data2.length - 1;
  if (index2 == lastIndex) {
    data2.pop();
  } else {
    splice.call(data2, index2, 1);
  }
  --this.size;
  return true;
}
function listCacheGet(key) {
  var data2 = this.__data__, index2 = assocIndexOf(data2, key);
  return index2 < 0 ? void 0 : data2[index2][1];
}
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}
function listCacheSet(key, value) {
  var data2 = this.__data__, index2 = assocIndexOf(data2, key);
  if (index2 < 0) {
    ++this.size;
    data2.push([key, value]);
  } else {
    data2[index2][1] = value;
  }
  return this;
}
function ListCache(entries) {
  var index2 = -1, length = entries == null ? 0 : entries.length;
  this.clear();
  while (++index2 < length) {
    var entry = entries[index2];
    this.set(entry[0], entry[1]);
  }
}
ListCache.prototype.clear = listCacheClear;
ListCache.prototype["delete"] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;
function stackClear() {
  this.__data__ = new ListCache();
  this.size = 0;
}
function stackDelete(key) {
  var data2 = this.__data__, result = data2["delete"](key);
  this.size = data2.size;
  return result;
}
function stackGet(key) {
  return this.__data__.get(key);
}
function stackHas(key) {
  return this.__data__.has(key);
}
var freeGlobal$2 = typeof global == "object" && global && global.Object === Object && global;
var freeGlobal$3 = freeGlobal$2;
var freeSelf$2 = typeof self == "object" && self && self.Object === Object && self;
var root$2 = freeGlobal$3 || freeSelf$2 || Function("return this")();
var root$3 = root$2;
var Symbol$1 = root$3.Symbol;
var Symbol$2 = Symbol$1;
var objectProto$g = Object.prototype;
var hasOwnProperty$b = objectProto$g.hasOwnProperty;
var nativeObjectToString$1 = objectProto$g.toString;
var symToStringTag$1 = Symbol$2 ? Symbol$2.toStringTag : void 0;
function getRawTag(value) {
  var isOwn = hasOwnProperty$b.call(value, symToStringTag$1), tag = value[symToStringTag$1];
  try {
    value[symToStringTag$1] = void 0;
    var unmasked = true;
  } catch (e3) {
  }
  var result = nativeObjectToString$1.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag$1] = tag;
    } else {
      delete value[symToStringTag$1];
    }
  }
  return result;
}
var objectProto$f = Object.prototype;
var nativeObjectToString = objectProto$f.toString;
function objectToString$2(value) {
  return nativeObjectToString.call(value);
}
var nullTag = "[object Null]", undefinedTag = "[object Undefined]";
var symToStringTag = Symbol$2 ? Symbol$2.toStringTag : void 0;
function baseGetTag(value) {
  if (value == null) {
    return value === void 0 ? undefinedTag : nullTag;
  }
  return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString$2(value);
}
function isObject$4(value) {
  var type = typeof value;
  return value != null && (type == "object" || type == "function");
}
var asyncTag = "[object AsyncFunction]", funcTag$1 = "[object Function]", genTag = "[object GeneratorFunction]", proxyTag = "[object Proxy]";
function isFunction$2(value) {
  if (!isObject$4(value)) {
    return false;
  }
  var tag = baseGetTag(value);
  return tag == funcTag$1 || tag == genTag || tag == asyncTag || tag == proxyTag;
}
var coreJsData = root$3["__core-js_shared__"];
var coreJsData$1 = coreJsData;
var maskSrcKey = function() {
  var uid2 = /[^.]+$/.exec(coreJsData$1 && coreJsData$1.keys && coreJsData$1.keys.IE_PROTO || "");
  return uid2 ? "Symbol(src)_1." + uid2 : "";
}();
function isMasked(func) {
  return !!maskSrcKey && maskSrcKey in func;
}
var funcProto$2 = Function.prototype;
var funcToString$2 = funcProto$2.toString;
function toSource(func) {
  if (func != null) {
    try {
      return funcToString$2.call(func);
    } catch (e3) {
    }
    try {
      return func + "";
    } catch (e3) {
    }
  }
  return "";
}
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
var reIsHostCtor = /^\[object .+?Constructor\]$/;
var funcProto$1 = Function.prototype, objectProto$e = Object.prototype;
var funcToString$1 = funcProto$1.toString;
var hasOwnProperty$a = objectProto$e.hasOwnProperty;
var reIsNative = RegExp("^" + funcToString$1.call(hasOwnProperty$a).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$");
function baseIsNative(value) {
  if (!isObject$4(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction$2(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}
function getValue$2(object, key) {
  return object == null ? void 0 : object[key];
}
function getNative(object, key) {
  var value = getValue$2(object, key);
  return baseIsNative(value) ? value : void 0;
}
var Map$1 = getNative(root$3, "Map");
var Map$2 = Map$1;
var nativeCreate = getNative(Object, "create");
var nativeCreate$1 = nativeCreate;
function hashClear() {
  this.__data__ = nativeCreate$1 ? nativeCreate$1(null) : {};
  this.size = 0;
}
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}
var HASH_UNDEFINED$2 = "__lodash_hash_undefined__";
var objectProto$d = Object.prototype;
var hasOwnProperty$9 = objectProto$d.hasOwnProperty;
function hashGet(key) {
  var data2 = this.__data__;
  if (nativeCreate$1) {
    var result = data2[key];
    return result === HASH_UNDEFINED$2 ? void 0 : result;
  }
  return hasOwnProperty$9.call(data2, key) ? data2[key] : void 0;
}
var objectProto$c = Object.prototype;
var hasOwnProperty$8 = objectProto$c.hasOwnProperty;
function hashHas(key) {
  var data2 = this.__data__;
  return nativeCreate$1 ? data2[key] !== void 0 : hasOwnProperty$8.call(data2, key);
}
var HASH_UNDEFINED$1 = "__lodash_hash_undefined__";
function hashSet(key, value) {
  var data2 = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data2[key] = nativeCreate$1 && value === void 0 ? HASH_UNDEFINED$1 : value;
  return this;
}
function Hash(entries) {
  var index2 = -1, length = entries == null ? 0 : entries.length;
  this.clear();
  while (++index2 < length) {
    var entry = entries[index2];
    this.set(entry[0], entry[1]);
  }
}
Hash.prototype.clear = hashClear;
Hash.prototype["delete"] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    "hash": new Hash(),
    "map": new (Map$2 || ListCache)(),
    "string": new Hash()
  };
}
function isKeyable(value) {
  var type = typeof value;
  return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
}
function getMapData(map2, key) {
  var data2 = map2.__data__;
  return isKeyable(key) ? data2[typeof key == "string" ? "string" : "hash"] : data2.map;
}
function mapCacheDelete(key) {
  var result = getMapData(this, key)["delete"](key);
  this.size -= result ? 1 : 0;
  return result;
}
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}
function mapCacheSet(key, value) {
  var data2 = getMapData(this, key), size = data2.size;
  data2.set(key, value);
  this.size += data2.size == size ? 0 : 1;
  return this;
}
function MapCache(entries) {
  var index2 = -1, length = entries == null ? 0 : entries.length;
  this.clear();
  while (++index2 < length) {
    var entry = entries[index2];
    this.set(entry[0], entry[1]);
  }
}
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype["delete"] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;
var LARGE_ARRAY_SIZE = 200;
function stackSet(key, value) {
  var data2 = this.__data__;
  if (data2 instanceof ListCache) {
    var pairs = data2.__data__;
    if (!Map$2 || pairs.length < LARGE_ARRAY_SIZE - 1) {
      pairs.push([key, value]);
      this.size = ++data2.size;
      return this;
    }
    data2 = this.__data__ = new MapCache(pairs);
  }
  data2.set(key, value);
  this.size = data2.size;
  return this;
}
function Stack(entries) {
  var data2 = this.__data__ = new ListCache(entries);
  this.size = data2.size;
}
Stack.prototype.clear = stackClear;
Stack.prototype["delete"] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;
var defineProperty$1 = function() {
  try {
    var func = getNative(Object, "defineProperty");
    func({}, "", {});
    return func;
  } catch (e3) {
  }
}();
var defineProperty$2 = defineProperty$1;
function baseAssignValue(object, key, value) {
  if (key == "__proto__" && defineProperty$2) {
    defineProperty$2(object, key, {
      "configurable": true,
      "enumerable": true,
      "value": value,
      "writable": true
    });
  } else {
    object[key] = value;
  }
}
function assignMergeValue(object, key, value) {
  if (value !== void 0 && !eq(object[key], value) || value === void 0 && !(key in object)) {
    baseAssignValue(object, key, value);
  }
}
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index2 = -1, iterable = Object(object), props = keysFunc(object), length = props.length;
    while (length--) {
      var key = props[fromRight ? length : ++index2];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}
var baseFor = createBaseFor();
var baseFor$1 = baseFor;
var freeExports$2 = typeof exports == "object" && exports && !exports.nodeType && exports;
var freeModule$2 = freeExports$2 && typeof module == "object" && module && !module.nodeType && module;
var moduleExports$2 = freeModule$2 && freeModule$2.exports === freeExports$2;
var Buffer$1 = moduleExports$2 ? root$3.Buffer : void 0, allocUnsafe = Buffer$1 ? Buffer$1.allocUnsafe : void 0;
function cloneBuffer(buffer, isDeep) {
  if (isDeep) {
    return buffer.slice();
  }
  var length = buffer.length, result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
  buffer.copy(result);
  return result;
}
var Uint8Array$1 = root$3.Uint8Array;
var Uint8Array$2 = Uint8Array$1;
function cloneArrayBuffer(arrayBuffer) {
  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  new Uint8Array$2(result).set(new Uint8Array$2(arrayBuffer));
  return result;
}
function cloneTypedArray(typedArray, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}
function copyArray(source2, array) {
  var index2 = -1, length = source2.length;
  array || (array = Array(length));
  while (++index2 < length) {
    array[index2] = source2[index2];
  }
  return array;
}
var objectCreate = Object.create;
var baseCreate = function() {
  function object() {
  }
  return function(proto) {
    if (!isObject$4(proto)) {
      return {};
    }
    if (objectCreate) {
      return objectCreate(proto);
    }
    object.prototype = proto;
    var result = new object();
    object.prototype = void 0;
    return result;
  };
}();
var baseCreate$1 = baseCreate;
function overArg(func, transform2) {
  return function(arg) {
    return func(transform2(arg));
  };
}
var getPrototype = overArg(Object.getPrototypeOf, Object);
var getPrototype$1 = getPrototype;
var objectProto$b = Object.prototype;
function isPrototype(value) {
  var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto$b;
  return value === proto;
}
function initCloneObject(object) {
  return typeof object.constructor == "function" && !isPrototype(object) ? baseCreate$1(getPrototype$1(object)) : {};
}
function isObjectLike$2(value) {
  return value != null && typeof value == "object";
}
var argsTag$2 = "[object Arguments]";
function baseIsArguments(value) {
  return isObjectLike$2(value) && baseGetTag(value) == argsTag$2;
}
var objectProto$a = Object.prototype;
var hasOwnProperty$7 = objectProto$a.hasOwnProperty;
var propertyIsEnumerable$1 = objectProto$a.propertyIsEnumerable;
var isArguments = baseIsArguments(function() {
  return arguments;
}()) ? baseIsArguments : function(value) {
  return isObjectLike$2(value) && hasOwnProperty$7.call(value, "callee") && !propertyIsEnumerable$1.call(value, "callee");
};
var isArguments$1 = isArguments;
var isArray$1 = Array.isArray;
var isArray$2 = isArray$1;
var MAX_SAFE_INTEGER$1 = 9007199254740991;
function isLength(value) {
  return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER$1;
}
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction$2(value);
}
function isArrayLikeObject(value) {
  return isObjectLike$2(value) && isArrayLike(value);
}
function stubFalse() {
  return false;
}
var freeExports$1 = typeof exports == "object" && exports && !exports.nodeType && exports;
var freeModule$1 = freeExports$1 && typeof module == "object" && module && !module.nodeType && module;
var moduleExports$1 = freeModule$1 && freeModule$1.exports === freeExports$1;
var Buffer2 = moduleExports$1 ? root$3.Buffer : void 0;
var nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : void 0;
var isBuffer$1 = nativeIsBuffer || stubFalse;
var isBuffer$2 = isBuffer$1;
var objectTag$3 = "[object Object]";
var funcProto = Function.prototype, objectProto$9 = Object.prototype;
var funcToString = funcProto.toString;
var hasOwnProperty$6 = objectProto$9.hasOwnProperty;
var objectCtorString = funcToString.call(Object);
function isPlainObject$2(value) {
  if (!isObjectLike$2(value) || baseGetTag(value) != objectTag$3) {
    return false;
  }
  var proto = getPrototype$1(value);
  if (proto === null) {
    return true;
  }
  var Ctor = hasOwnProperty$6.call(proto, "constructor") && proto.constructor;
  return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString.call(Ctor) == objectCtorString;
}
var argsTag$1 = "[object Arguments]", arrayTag$1 = "[object Array]", boolTag$1 = "[object Boolean]", dateTag$1 = "[object Date]", errorTag$1 = "[object Error]", funcTag = "[object Function]", mapTag$2 = "[object Map]", numberTag$1 = "[object Number]", objectTag$2 = "[object Object]", regexpTag$1 = "[object RegExp]", setTag$2 = "[object Set]", stringTag$1 = "[object String]", weakMapTag$1 = "[object WeakMap]";
var arrayBufferTag$1 = "[object ArrayBuffer]", dataViewTag$2 = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag$1] = typedArrayTags[arrayTag$1] = typedArrayTags[arrayBufferTag$1] = typedArrayTags[boolTag$1] = typedArrayTags[dataViewTag$2] = typedArrayTags[dateTag$1] = typedArrayTags[errorTag$1] = typedArrayTags[funcTag] = typedArrayTags[mapTag$2] = typedArrayTags[numberTag$1] = typedArrayTags[objectTag$2] = typedArrayTags[regexpTag$1] = typedArrayTags[setTag$2] = typedArrayTags[stringTag$1] = typedArrayTags[weakMapTag$1] = false;
function baseIsTypedArray(value) {
  return isObjectLike$2(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}
var freeExports = typeof exports == "object" && exports && !exports.nodeType && exports;
var freeModule = freeExports && typeof module == "object" && module && !module.nodeType && module;
var moduleExports = freeModule && freeModule.exports === freeExports;
var freeProcess = moduleExports && freeGlobal$3.process;
var nodeUtil = function() {
  try {
    var types = freeModule && freeModule.require && freeModule.require("util").types;
    if (types) {
      return types;
    }
    return freeProcess && freeProcess.binding && freeProcess.binding("util");
  } catch (e3) {
  }
}();
var nodeUtil$1 = nodeUtil;
var nodeIsTypedArray = nodeUtil$1 && nodeUtil$1.isTypedArray;
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
var isTypedArray$1 = isTypedArray;
function safeGet(object, key) {
  if (key === "constructor" && typeof object[key] === "function") {
    return;
  }
  if (key == "__proto__") {
    return;
  }
  return object[key];
}
var objectProto$8 = Object.prototype;
var hasOwnProperty$5 = objectProto$8.hasOwnProperty;
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(hasOwnProperty$5.call(object, key) && eq(objValue, value)) || value === void 0 && !(key in object)) {
    baseAssignValue(object, key, value);
  }
}
function copyObject(source2, props, object, customizer) {
  var isNew = !object;
  object || (object = {});
  var index2 = -1, length = props.length;
  while (++index2 < length) {
    var key = props[index2];
    var newValue = customizer ? customizer(object[key], source2[key], key, object, source2) : void 0;
    if (newValue === void 0) {
      newValue = source2[key];
    }
    if (isNew) {
      baseAssignValue(object, key, newValue);
    } else {
      assignValue(object, key, newValue);
    }
  }
  return object;
}
function baseTimes(n2, iteratee) {
  var index2 = -1, result = Array(n2);
  while (++index2 < n2) {
    result[index2] = iteratee(index2);
  }
  return result;
}
var MAX_SAFE_INTEGER = 9007199254740991;
var reIsUint = /^(?:0|[1-9]\d*)$/;
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER : length;
  return !!length && (type == "number" || type != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
}
var objectProto$7 = Object.prototype;
var hasOwnProperty$4 = objectProto$7.hasOwnProperty;
function arrayLikeKeys(value, inherited) {
  var isArr = isArray$2(value), isArg = !isArr && isArguments$1(value), isBuff = !isArr && !isArg && isBuffer$2(value), isType2 = !isArr && !isArg && !isBuff && isTypedArray$1(value), skipIndexes = isArr || isArg || isBuff || isType2, result = skipIndexes ? baseTimes(value.length, String) : [], length = result.length;
  for (var key in value) {
    if ((inherited || hasOwnProperty$4.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType2 && (key == "buffer" || key == "byteLength" || key == "byteOffset") || isIndex(key, length)))) {
      result.push(key);
    }
  }
  return result;
}
function nativeKeysIn(object) {
  var result = [];
  if (object != null) {
    for (var key in Object(object)) {
      result.push(key);
    }
  }
  return result;
}
var objectProto$6 = Object.prototype;
var hasOwnProperty$3 = objectProto$6.hasOwnProperty;
function baseKeysIn(object) {
  if (!isObject$4(object)) {
    return nativeKeysIn(object);
  }
  var isProto = isPrototype(object), result = [];
  for (var key in object) {
    if (!(key == "constructor" && (isProto || !hasOwnProperty$3.call(object, key)))) {
      result.push(key);
    }
  }
  return result;
}
function keysIn(object) {
  return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
}
function toPlainObject(value) {
  return copyObject(value, keysIn(value));
}
function baseMergeDeep(object, source2, key, srcIndex, mergeFunc, customizer, stack) {
  var objValue = safeGet(object, key), srcValue = safeGet(source2, key), stacked = stack.get(srcValue);
  if (stacked) {
    assignMergeValue(object, key, stacked);
    return;
  }
  var newValue = customizer ? customizer(objValue, srcValue, key + "", object, source2, stack) : void 0;
  var isCommon = newValue === void 0;
  if (isCommon) {
    var isArr = isArray$2(srcValue), isBuff = !isArr && isBuffer$2(srcValue), isTyped = !isArr && !isBuff && isTypedArray$1(srcValue);
    newValue = srcValue;
    if (isArr || isBuff || isTyped) {
      if (isArray$2(objValue)) {
        newValue = objValue;
      } else if (isArrayLikeObject(objValue)) {
        newValue = copyArray(objValue);
      } else if (isBuff) {
        isCommon = false;
        newValue = cloneBuffer(srcValue, true);
      } else if (isTyped) {
        isCommon = false;
        newValue = cloneTypedArray(srcValue, true);
      } else {
        newValue = [];
      }
    } else if (isPlainObject$2(srcValue) || isArguments$1(srcValue)) {
      newValue = objValue;
      if (isArguments$1(objValue)) {
        newValue = toPlainObject(objValue);
      } else if (!isObject$4(objValue) || isFunction$2(objValue)) {
        newValue = initCloneObject(srcValue);
      }
    } else {
      isCommon = false;
    }
  }
  if (isCommon) {
    stack.set(srcValue, newValue);
    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
    stack["delete"](srcValue);
  }
  assignMergeValue(object, key, newValue);
}
function baseMerge(object, source2, srcIndex, customizer, stack) {
  if (object === source2) {
    return;
  }
  baseFor$1(source2, function(srcValue, key) {
    stack || (stack = new Stack());
    if (isObject$4(srcValue)) {
      baseMergeDeep(object, source2, key, srcIndex, baseMerge, customizer, stack);
    } else {
      var newValue = customizer ? customizer(safeGet(object, key), srcValue, key + "", object, source2, stack) : void 0;
      if (newValue === void 0) {
        newValue = srcValue;
      }
      assignMergeValue(object, key, newValue);
    }
  }, keysIn);
}
function identity(value) {
  return value;
}
function apply$1(func, thisArg, args) {
  switch (args.length) {
    case 0:
      return func.call(thisArg);
    case 1:
      return func.call(thisArg, args[0]);
    case 2:
      return func.call(thisArg, args[0], args[1]);
    case 3:
      return func.call(thisArg, args[0], args[1], args[2]);
  }
  return func.apply(thisArg, args);
}
var nativeMax$3 = Math.max;
function overRest(func, start2, transform2) {
  start2 = nativeMax$3(start2 === void 0 ? func.length - 1 : start2, 0);
  return function() {
    var args = arguments, index2 = -1, length = nativeMax$3(args.length - start2, 0), array = Array(length);
    while (++index2 < length) {
      array[index2] = args[start2 + index2];
    }
    index2 = -1;
    var otherArgs = Array(start2 + 1);
    while (++index2 < start2) {
      otherArgs[index2] = args[index2];
    }
    otherArgs[start2] = transform2(array);
    return apply$1(func, this, otherArgs);
  };
}
function constant(value) {
  return function() {
    return value;
  };
}
var baseSetToString = !defineProperty$2 ? identity : function(func, string) {
  return defineProperty$2(func, "toString", {
    "configurable": true,
    "enumerable": false,
    "value": constant(string),
    "writable": true
  });
};
var baseSetToString$1 = baseSetToString;
var HOT_COUNT = 800, HOT_SPAN = 16;
var nativeNow = Date.now;
function shortOut(func) {
  var count2 = 0, lastCalled = 0;
  return function() {
    var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
    lastCalled = stamp;
    if (remaining > 0) {
      if (++count2 >= HOT_COUNT) {
        return arguments[0];
      }
    } else {
      count2 = 0;
    }
    return func.apply(void 0, arguments);
  };
}
var setToString = shortOut(baseSetToString$1);
var setToString$1 = setToString;
function baseRest(func, start2) {
  return setToString$1(overRest(func, start2, identity), func + "");
}
function isIterateeCall(value, index2, object) {
  if (!isObject$4(object)) {
    return false;
  }
  var type = typeof index2;
  if (type == "number" ? isArrayLike(object) && isIndex(index2, object.length) : type == "string" && index2 in object) {
    return eq(object[index2], value);
  }
  return false;
}
function createAssigner(assigner) {
  return baseRest(function(object, sources) {
    var index2 = -1, length = sources.length, customizer = length > 1 ? sources[length - 1] : void 0, guard = length > 2 ? sources[2] : void 0;
    customizer = assigner.length > 3 && typeof customizer == "function" ? (length--, customizer) : void 0;
    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      customizer = length < 3 ? void 0 : customizer;
      length = 1;
    }
    object = Object(object);
    while (++index2 < length) {
      var source2 = sources[index2];
      if (source2) {
        assigner(object, source2, index2, customizer);
      }
    }
    return object;
  });
}
var merge$1 = createAssigner(function(object, source2, srcIndex) {
  baseMerge(object, source2, srcIndex);
});
var merge$2 = merge$1;
var Raised = function Raised2(_ref) {
  var zDepth = _ref.zDepth, radius = _ref.radius, background = _ref.background, children = _ref.children, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles;
  var styles2 = _default$9(merge$2({
    "default": {
      wrap: {
        position: "relative",
        display: "inline-block"
      },
      content: {
        position: "relative"
      },
      bg: {
        absolute: "0px 0px 0px 0px",
        boxShadow: "0 " + zDepth + "px " + zDepth * 4 + "px rgba(0,0,0,.24)",
        borderRadius: radius,
        background
      }
    },
    "zDepth-0": {
      bg: {
        boxShadow: "none"
      }
    },
    "zDepth-1": {
      bg: {
        boxShadow: "0 2px 10px rgba(0,0,0,.12), 0 2px 5px rgba(0,0,0,.16)"
      }
    },
    "zDepth-2": {
      bg: {
        boxShadow: "0 6px 20px rgba(0,0,0,.19), 0 8px 17px rgba(0,0,0,.2)"
      }
    },
    "zDepth-3": {
      bg: {
        boxShadow: "0 17px 50px rgba(0,0,0,.19), 0 12px 15px rgba(0,0,0,.24)"
      }
    },
    "zDepth-4": {
      bg: {
        boxShadow: "0 25px 55px rgba(0,0,0,.21), 0 16px 28px rgba(0,0,0,.22)"
      }
    },
    "zDepth-5": {
      bg: {
        boxShadow: "0 40px 77px rgba(0,0,0,.22), 0 27px 24px rgba(0,0,0,.2)"
      }
    },
    "square": {
      bg: {
        borderRadius: "0"
      }
    },
    "circle": {
      bg: {
        borderRadius: "50%"
      }
    }
  }, passedStyles), { "zDepth-1": zDepth === 1 });
  return React__default.createElement("div", { style: styles2.wrap }, React__default.createElement("div", { style: styles2.bg }), React__default.createElement("div", { style: styles2.content }, children));
};
Raised.propTypes = {
  background: PropTypes.string,
  zDepth: PropTypes.oneOf([0, 1, 2, 3, 4, 5]),
  radius: PropTypes.number,
  styles: PropTypes.object
};
Raised.defaultProps = {
  background: "#fff",
  zDepth: 1,
  radius: 2,
  styles: {}
};
var now$4 = function() {
  return root$3.Date.now();
};
var now$5 = now$4;
var reWhitespace = /\s/;
function trimmedEndIndex(string) {
  var index2 = string.length;
  while (index2-- && reWhitespace.test(string.charAt(index2))) {
  }
  return index2;
}
var reTrimStart = /^\s+/;
function baseTrim(string) {
  return string ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, "") : string;
}
var symbolTag$3 = "[object Symbol]";
function isSymbol$2(value) {
  return typeof value == "symbol" || isObjectLike$2(value) && baseGetTag(value) == symbolTag$3;
}
var NAN$2 = 0 / 0;
var reIsBadHex$2 = /^[-+]0x[0-9a-f]+$/i;
var reIsBinary$2 = /^0b[01]+$/i;
var reIsOctal$2 = /^0o[0-7]+$/i;
var freeParseInt$2 = parseInt;
function toNumber$2(value) {
  if (typeof value == "number") {
    return value;
  }
  if (isSymbol$2(value)) {
    return NAN$2;
  }
  if (isObject$4(value)) {
    var other = typeof value.valueOf == "function" ? value.valueOf() : value;
    value = isObject$4(other) ? other + "" : other;
  }
  if (typeof value != "string") {
    return value === 0 ? value : +value;
  }
  value = baseTrim(value);
  var isBinary = reIsBinary$2.test(value);
  return isBinary || reIsOctal$2.test(value) ? freeParseInt$2(value.slice(2), isBinary ? 2 : 8) : reIsBadHex$2.test(value) ? NAN$2 : +value;
}
var FUNC_ERROR_TEXT$4 = "Expected a function";
var nativeMax$2 = Math.max, nativeMin$2 = Math.min;
function debounce$4(func, wait, options) {
  var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
  if (typeof func != "function") {
    throw new TypeError(FUNC_ERROR_TEXT$4);
  }
  wait = toNumber$2(wait) || 0;
  if (isObject$4(options)) {
    leading = !!options.leading;
    maxing = "maxWait" in options;
    maxWait = maxing ? nativeMax$2(toNumber$2(options.maxWait) || 0, wait) : maxWait;
    trailing = "trailing" in options ? !!options.trailing : trailing;
  }
  function invokeFunc(time) {
    var args = lastArgs, thisArg = lastThis;
    lastArgs = lastThis = void 0;
    lastInvokeTime = time;
    result = func.apply(thisArg, args);
    return result;
  }
  function leadingEdge(time) {
    lastInvokeTime = time;
    timerId = setTimeout(timerExpired, wait);
    return leading ? invokeFunc(time) : result;
  }
  function remainingWait(time) {
    var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
    return maxing ? nativeMin$2(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
  }
  function shouldInvoke(time) {
    var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
    return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
  }
  function timerExpired() {
    var time = now$5();
    if (shouldInvoke(time)) {
      return trailingEdge(time);
    }
    timerId = setTimeout(timerExpired, remainingWait(time));
  }
  function trailingEdge(time) {
    timerId = void 0;
    if (trailing && lastArgs) {
      return invokeFunc(time);
    }
    lastArgs = lastThis = void 0;
    return result;
  }
  function cancel() {
    if (timerId !== void 0) {
      clearTimeout(timerId);
    }
    lastInvokeTime = 0;
    lastArgs = lastCallTime = lastThis = timerId = void 0;
  }
  function flush3() {
    return timerId === void 0 ? result : trailingEdge(now$5());
  }
  function debounced() {
    var time = now$5(), isInvoking = shouldInvoke(time);
    lastArgs = arguments;
    lastThis = this;
    lastCallTime = time;
    if (isInvoking) {
      if (timerId === void 0) {
        return leadingEdge(lastCallTime);
      }
      if (maxing) {
        clearTimeout(timerId);
        timerId = setTimeout(timerExpired, wait);
        return invokeFunc(lastCallTime);
      }
    }
    if (timerId === void 0) {
      timerId = setTimeout(timerExpired, wait);
    }
    return result;
  }
  debounced.cancel = cancel;
  debounced.flush = flush3;
  return debounced;
}
var FUNC_ERROR_TEXT$3 = "Expected a function";
function throttle$1(func, wait, options) {
  var leading = true, trailing = true;
  if (typeof func != "function") {
    throw new TypeError(FUNC_ERROR_TEXT$3);
  }
  if (isObject$4(options)) {
    leading = "leading" in options ? !!options.leading : leading;
    trailing = "trailing" in options ? !!options.trailing : trailing;
  }
  return debounce$4(func, wait, {
    "leading": leading,
    "maxWait": wait,
    "trailing": trailing
  });
}
var calculateChange3 = function calculateChange4(e3, hsl2, container2) {
  var _container$getBoundin = container2.getBoundingClientRect(), containerWidth = _container$getBoundin.width, containerHeight = _container$getBoundin.height;
  var x2 = typeof e3.pageX === "number" ? e3.pageX : e3.touches[0].pageX;
  var y4 = typeof e3.pageY === "number" ? e3.pageY : e3.touches[0].pageY;
  var left2 = x2 - (container2.getBoundingClientRect().left + window.pageXOffset);
  var top2 = y4 - (container2.getBoundingClientRect().top + window.pageYOffset);
  if (left2 < 0) {
    left2 = 0;
  } else if (left2 > containerWidth) {
    left2 = containerWidth;
  }
  if (top2 < 0) {
    top2 = 0;
  } else if (top2 > containerHeight) {
    top2 = containerHeight;
  }
  var saturation = left2 / containerWidth;
  var bright = 1 - top2 / containerHeight;
  return {
    h: hsl2.h,
    s: saturation,
    v: bright,
    a: hsl2.a,
    source: "hsv"
  };
};
var _createClass$8 = function() {
  function defineProperties(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  return function(Constructor, protoProps, staticProps) {
    if (protoProps)
      defineProperties(Constructor.prototype, protoProps);
    if (staticProps)
      defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();
function _classCallCheck$8(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _possibleConstructorReturn$7(self2, call2) {
  if (!self2) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return call2 && (typeof call2 === "object" || typeof call2 === "function") ? call2 : self2;
}
function _inherits$7(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });
  if (superClass)
    Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
}
var Saturation = function(_ref) {
  _inherits$7(Saturation2, _ref);
  function Saturation2(props) {
    _classCallCheck$8(this, Saturation2);
    var _this = _possibleConstructorReturn$7(this, (Saturation2.__proto__ || Object.getPrototypeOf(Saturation2)).call(this, props));
    _this.handleChange = function(e3) {
      typeof _this.props.onChange === "function" && _this.throttle(_this.props.onChange, calculateChange3(e3, _this.props.hsl, _this.container), e3);
    };
    _this.handleMouseDown = function(e3) {
      _this.handleChange(e3);
      var renderWindow = _this.getContainerRenderWindow();
      renderWindow.addEventListener("mousemove", _this.handleChange);
      renderWindow.addEventListener("mouseup", _this.handleMouseUp);
    };
    _this.handleMouseUp = function() {
      _this.unbindEventListeners();
    };
    _this.throttle = throttle$1(function(fn3, data2, e3) {
      fn3(data2, e3);
    }, 50);
    return _this;
  }
  _createClass$8(Saturation2, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.throttle.cancel();
      this.unbindEventListeners();
    }
  }, {
    key: "getContainerRenderWindow",
    value: function getContainerRenderWindow() {
      var container2 = this.container;
      var renderWindow = window;
      while (!renderWindow.document.contains(container2) && renderWindow.parent !== renderWindow) {
        renderWindow = renderWindow.parent;
      }
      return renderWindow;
    }
  }, {
    key: "unbindEventListeners",
    value: function unbindEventListeners() {
      var renderWindow = this.getContainerRenderWindow();
      renderWindow.removeEventListener("mousemove", this.handleChange);
      renderWindow.removeEventListener("mouseup", this.handleMouseUp);
    }
  }, {
    key: "render",
    value: function render4() {
      var _this2 = this;
      var _ref2 = this.props.style || {}, color = _ref2.color, white = _ref2.white, black = _ref2.black, pointer = _ref2.pointer, circle = _ref2.circle;
      var styles2 = _default$9({
        "default": {
          color: {
            absolute: "0px 0px 0px 0px",
            background: "hsl(" + this.props.hsl.h + ",100%, 50%)",
            borderRadius: this.props.radius
          },
          white: {
            absolute: "0px 0px 0px 0px",
            borderRadius: this.props.radius
          },
          black: {
            absolute: "0px 0px 0px 0px",
            boxShadow: this.props.shadow,
            borderRadius: this.props.radius
          },
          pointer: {
            position: "absolute",
            top: -(this.props.hsv.v * 100) + 100 + "%",
            left: this.props.hsv.s * 100 + "%",
            cursor: "default"
          },
          circle: {
            width: "4px",
            height: "4px",
            boxShadow: "0 0 0 1.5px #fff, inset 0 0 1px 1px rgba(0,0,0,.3),\n            0 0 1px 2px rgba(0,0,0,.4)",
            borderRadius: "50%",
            cursor: "hand",
            transform: "translate(-2px, -2px)"
          }
        },
        "custom": {
          color,
          white,
          black,
          pointer,
          circle
        }
      }, { "custom": !!this.props.style });
      return React__default.createElement("div", {
        style: styles2.color,
        ref: function ref(container2) {
          return _this2.container = container2;
        },
        onMouseDown: this.handleMouseDown,
        onTouchMove: this.handleChange,
        onTouchStart: this.handleChange
      }, React__default.createElement("style", null, "\n          .saturation-white {\n            background: -webkit-linear-gradient(to right, #fff, rgba(255,255,255,0));\n            background: linear-gradient(to right, #fff, rgba(255,255,255,0));\n          }\n          .saturation-black {\n            background: -webkit-linear-gradient(to top, #000, rgba(0,0,0,0));\n            background: linear-gradient(to top, #000, rgba(0,0,0,0));\n          }\n        "), React__default.createElement("div", { style: styles2.white, className: "saturation-white" }, React__default.createElement("div", { style: styles2.black, className: "saturation-black" }), React__default.createElement("div", { style: styles2.pointer }, this.props.pointer ? React__default.createElement(this.props.pointer, this.props) : React__default.createElement("div", { style: styles2.circle }))));
    }
  }]);
  return Saturation2;
}(PureComponent || Component);
function arrayEach(array, iteratee) {
  var index2 = -1, length = array == null ? 0 : array.length;
  while (++index2 < length) {
    if (iteratee(array[index2], index2, array) === false) {
      break;
    }
  }
  return array;
}
var nativeKeys = overArg(Object.keys, Object);
var nativeKeys$1 = nativeKeys;
var objectProto$5 = Object.prototype;
var hasOwnProperty$2 = objectProto$5.hasOwnProperty;
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys$1(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty$2.call(object, key) && key != "constructor") {
      result.push(key);
    }
  }
  return result;
}
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}
function baseForOwn(object, iteratee) {
  return object && baseFor$1(object, iteratee, keys);
}
function createBaseEach(eachFunc, fromRight) {
  return function(collection, iteratee) {
    if (collection == null) {
      return collection;
    }
    if (!isArrayLike(collection)) {
      return eachFunc(collection, iteratee);
    }
    var length = collection.length, index2 = fromRight ? length : -1, iterable = Object(collection);
    while (fromRight ? index2-- : ++index2 < length) {
      if (iteratee(iterable[index2], index2, iterable) === false) {
        break;
      }
    }
    return collection;
  };
}
var baseEach = createBaseEach(baseForOwn);
var baseEach$1 = baseEach;
function castFunction(value) {
  return typeof value == "function" ? value : identity;
}
function forEach$1(collection, iteratee) {
  var func = isArray$2(collection) ? arrayEach : baseEach$1;
  return func(collection, castFunction(iteratee));
}
var tinycolor$1 = { exports: {} };
(function(module2) {
  (function(Math2) {
    var trimLeft = /^\s+/, trimRight = /\s+$/, tinyCounter = 0, mathRound = Math2.round, mathMin = Math2.min, mathMax = Math2.max, mathRandom = Math2.random;
    function tinycolor2(color, opts) {
      color = color ? color : "";
      opts = opts || {};
      if (color instanceof tinycolor2) {
        return color;
      }
      if (!(this instanceof tinycolor2)) {
        return new tinycolor2(color, opts);
      }
      var rgb2 = inputToRGB(color);
      this._originalInput = color, this._r = rgb2.r, this._g = rgb2.g, this._b = rgb2.b, this._a = rgb2.a, this._roundA = mathRound(100 * this._a) / 100, this._format = opts.format || rgb2.format;
      this._gradientType = opts.gradientType;
      if (this._r < 1) {
        this._r = mathRound(this._r);
      }
      if (this._g < 1) {
        this._g = mathRound(this._g);
      }
      if (this._b < 1) {
        this._b = mathRound(this._b);
      }
      this._ok = rgb2.ok;
      this._tc_id = tinyCounter++;
    }
    tinycolor2.prototype = {
      isDark: function() {
        return this.getBrightness() < 128;
      },
      isLight: function() {
        return !this.isDark();
      },
      isValid: function() {
        return this._ok;
      },
      getOriginalInput: function() {
        return this._originalInput;
      },
      getFormat: function() {
        return this._format;
      },
      getAlpha: function() {
        return this._a;
      },
      getBrightness: function() {
        var rgb2 = this.toRgb();
        return (rgb2.r * 299 + rgb2.g * 587 + rgb2.b * 114) / 1e3;
      },
      getLuminance: function() {
        var rgb2 = this.toRgb();
        var RsRGB, GsRGB, BsRGB, R2, G3, B3;
        RsRGB = rgb2.r / 255;
        GsRGB = rgb2.g / 255;
        BsRGB = rgb2.b / 255;
        if (RsRGB <= 0.03928) {
          R2 = RsRGB / 12.92;
        } else {
          R2 = Math2.pow((RsRGB + 0.055) / 1.055, 2.4);
        }
        if (GsRGB <= 0.03928) {
          G3 = GsRGB / 12.92;
        } else {
          G3 = Math2.pow((GsRGB + 0.055) / 1.055, 2.4);
        }
        if (BsRGB <= 0.03928) {
          B3 = BsRGB / 12.92;
        } else {
          B3 = Math2.pow((BsRGB + 0.055) / 1.055, 2.4);
        }
        return 0.2126 * R2 + 0.7152 * G3 + 0.0722 * B3;
      },
      setAlpha: function(value) {
        this._a = boundAlpha(value);
        this._roundA = mathRound(100 * this._a) / 100;
        return this;
      },
      toHsv: function() {
        var hsv = rgbToHsv(this._r, this._g, this._b);
        return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };
      },
      toHsvString: function() {
        var hsv = rgbToHsv(this._r, this._g, this._b);
        var h4 = mathRound(hsv.h * 360), s3 = mathRound(hsv.s * 100), v2 = mathRound(hsv.v * 100);
        return this._a == 1 ? "hsv(" + h4 + ", " + s3 + "%, " + v2 + "%)" : "hsva(" + h4 + ", " + s3 + "%, " + v2 + "%, " + this._roundA + ")";
      },
      toHsl: function() {
        var hsl2 = rgbToHsl(this._r, this._g, this._b);
        return { h: hsl2.h * 360, s: hsl2.s, l: hsl2.l, a: this._a };
      },
      toHslString: function() {
        var hsl2 = rgbToHsl(this._r, this._g, this._b);
        var h4 = mathRound(hsl2.h * 360), s3 = mathRound(hsl2.s * 100), l2 = mathRound(hsl2.l * 100);
        return this._a == 1 ? "hsl(" + h4 + ", " + s3 + "%, " + l2 + "%)" : "hsla(" + h4 + ", " + s3 + "%, " + l2 + "%, " + this._roundA + ")";
      },
      toHex: function(allow3Char) {
        return rgbToHex(this._r, this._g, this._b, allow3Char);
      },
      toHexString: function(allow3Char) {
        return "#" + this.toHex(allow3Char);
      },
      toHex8: function(allow4Char) {
        return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);
      },
      toHex8String: function(allow4Char) {
        return "#" + this.toHex8(allow4Char);
      },
      toRgb: function() {
        return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };
      },
      toRgbString: function() {
        return this._a == 1 ? "rgb(" + mathRound(this._r) + ", " + mathRound(this._g) + ", " + mathRound(this._b) + ")" : "rgba(" + mathRound(this._r) + ", " + mathRound(this._g) + ", " + mathRound(this._b) + ", " + this._roundA + ")";
      },
      toPercentageRgb: function() {
        return { r: mathRound(bound01(this._r, 255) * 100) + "%", g: mathRound(bound01(this._g, 255) * 100) + "%", b: mathRound(bound01(this._b, 255) * 100) + "%", a: this._a };
      },
      toPercentageRgbString: function() {
        return this._a == 1 ? "rgb(" + mathRound(bound01(this._r, 255) * 100) + "%, " + mathRound(bound01(this._g, 255) * 100) + "%, " + mathRound(bound01(this._b, 255) * 100) + "%)" : "rgba(" + mathRound(bound01(this._r, 255) * 100) + "%, " + mathRound(bound01(this._g, 255) * 100) + "%, " + mathRound(bound01(this._b, 255) * 100) + "%, " + this._roundA + ")";
      },
      toName: function() {
        if (this._a === 0) {
          return "transparent";
        }
        if (this._a < 1) {
          return false;
        }
        return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;
      },
      toFilter: function(secondColor) {
        var hex8String = "#" + rgbaToArgbHex(this._r, this._g, this._b, this._a);
        var secondHex8String = hex8String;
        var gradientType = this._gradientType ? "GradientType = 1, " : "";
        if (secondColor) {
          var s3 = tinycolor2(secondColor);
          secondHex8String = "#" + rgbaToArgbHex(s3._r, s3._g, s3._b, s3._a);
        }
        return "progid:DXImageTransform.Microsoft.gradient(" + gradientType + "startColorstr=" + hex8String + ",endColorstr=" + secondHex8String + ")";
      },
      toString: function(format3) {
        var formatSet = !!format3;
        format3 = format3 || this._format;
        var formattedString = false;
        var hasAlpha = this._a < 1 && this._a >= 0;
        var needsAlphaFormat = !formatSet && hasAlpha && (format3 === "hex" || format3 === "hex6" || format3 === "hex3" || format3 === "hex4" || format3 === "hex8" || format3 === "name");
        if (needsAlphaFormat) {
          if (format3 === "name" && this._a === 0) {
            return this.toName();
          }
          return this.toRgbString();
        }
        if (format3 === "rgb") {
          formattedString = this.toRgbString();
        }
        if (format3 === "prgb") {
          formattedString = this.toPercentageRgbString();
        }
        if (format3 === "hex" || format3 === "hex6") {
          formattedString = this.toHexString();
        }
        if (format3 === "hex3") {
          formattedString = this.toHexString(true);
        }
        if (format3 === "hex4") {
          formattedString = this.toHex8String(true);
        }
        if (format3 === "hex8") {
          formattedString = this.toHex8String();
        }
        if (format3 === "name") {
          formattedString = this.toName();
        }
        if (format3 === "hsl") {
          formattedString = this.toHslString();
        }
        if (format3 === "hsv") {
          formattedString = this.toHsvString();
        }
        return formattedString || this.toHexString();
      },
      clone: function() {
        return tinycolor2(this.toString());
      },
      _applyModification: function(fn3, args) {
        var color = fn3.apply(null, [this].concat([].slice.call(args)));
        this._r = color._r;
        this._g = color._g;
        this._b = color._b;
        this.setAlpha(color._a);
        return this;
      },
      lighten: function() {
        return this._applyModification(lighten, arguments);
      },
      brighten: function() {
        return this._applyModification(brighten, arguments);
      },
      darken: function() {
        return this._applyModification(darken, arguments);
      },
      desaturate: function() {
        return this._applyModification(desaturate, arguments);
      },
      saturate: function() {
        return this._applyModification(saturate, arguments);
      },
      greyscale: function() {
        return this._applyModification(greyscale, arguments);
      },
      spin: function() {
        return this._applyModification(spin2, arguments);
      },
      _applyCombination: function(fn3, args) {
        return fn3.apply(null, [this].concat([].slice.call(args)));
      },
      analogous: function() {
        return this._applyCombination(analogous, arguments);
      },
      complement: function() {
        return this._applyCombination(complement, arguments);
      },
      monochromatic: function() {
        return this._applyCombination(monochromatic, arguments);
      },
      splitcomplement: function() {
        return this._applyCombination(splitcomplement, arguments);
      },
      triad: function() {
        return this._applyCombination(triad, arguments);
      },
      tetrad: function() {
        return this._applyCombination(tetrad, arguments);
      }
    };
    tinycolor2.fromRatio = function(color, opts) {
      if (typeof color == "object") {
        var newColor = {};
        for (var i2 in color) {
          if (color.hasOwnProperty(i2)) {
            if (i2 === "a") {
              newColor[i2] = color[i2];
            } else {
              newColor[i2] = convertToPercentage(color[i2]);
            }
          }
        }
        color = newColor;
      }
      return tinycolor2(color, opts);
    };
    function inputToRGB(color) {
      var rgb2 = { r: 0, g: 0, b: 0 };
      var a3 = 1;
      var s3 = null;
      var v2 = null;
      var l2 = null;
      var ok = false;
      var format3 = false;
      if (typeof color == "string") {
        color = stringInputToObject(color);
      }
      if (typeof color == "object") {
        if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {
          rgb2 = rgbToRgb(color.r, color.g, color.b);
          ok = true;
          format3 = String(color.r).substr(-1) === "%" ? "prgb" : "rgb";
        } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {
          s3 = convertToPercentage(color.s);
          v2 = convertToPercentage(color.v);
          rgb2 = hsvToRgb(color.h, s3, v2);
          ok = true;
          format3 = "hsv";
        } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {
          s3 = convertToPercentage(color.s);
          l2 = convertToPercentage(color.l);
          rgb2 = hslToRgb2(color.h, s3, l2);
          ok = true;
          format3 = "hsl";
        }
        if (color.hasOwnProperty("a")) {
          a3 = color.a;
        }
      }
      a3 = boundAlpha(a3);
      return {
        ok,
        format: color.format || format3,
        r: mathMin(255, mathMax(rgb2.r, 0)),
        g: mathMin(255, mathMax(rgb2.g, 0)),
        b: mathMin(255, mathMax(rgb2.b, 0)),
        a: a3
      };
    }
    function rgbToRgb(r2, g2, b3) {
      return {
        r: bound01(r2, 255) * 255,
        g: bound01(g2, 255) * 255,
        b: bound01(b3, 255) * 255
      };
    }
    function rgbToHsl(r2, g2, b3) {
      r2 = bound01(r2, 255);
      g2 = bound01(g2, 255);
      b3 = bound01(b3, 255);
      var max2 = mathMax(r2, g2, b3), min2 = mathMin(r2, g2, b3);
      var h4, s3, l2 = (max2 + min2) / 2;
      if (max2 == min2) {
        h4 = s3 = 0;
      } else {
        var d4 = max2 - min2;
        s3 = l2 > 0.5 ? d4 / (2 - max2 - min2) : d4 / (max2 + min2);
        switch (max2) {
          case r2:
            h4 = (g2 - b3) / d4 + (g2 < b3 ? 6 : 0);
            break;
          case g2:
            h4 = (b3 - r2) / d4 + 2;
            break;
          case b3:
            h4 = (r2 - g2) / d4 + 4;
            break;
        }
        h4 /= 6;
      }
      return { h: h4, s: s3, l: l2 };
    }
    function hslToRgb2(h4, s3, l2) {
      var r2, g2, b3;
      h4 = bound01(h4, 360);
      s3 = bound01(s3, 100);
      l2 = bound01(l2, 100);
      function hue2rgb2(p3, q4, t3) {
        if (t3 < 0)
          t3 += 1;
        if (t3 > 1)
          t3 -= 1;
        if (t3 < 1 / 6)
          return p3 + (q4 - p3) * 6 * t3;
        if (t3 < 1 / 2)
          return q4;
        if (t3 < 2 / 3)
          return p3 + (q4 - p3) * (2 / 3 - t3) * 6;
        return p3;
      }
      if (s3 === 0) {
        r2 = g2 = b3 = l2;
      } else {
        var q3 = l2 < 0.5 ? l2 * (1 + s3) : l2 + s3 - l2 * s3;
        var p2 = 2 * l2 - q3;
        r2 = hue2rgb2(p2, q3, h4 + 1 / 3);
        g2 = hue2rgb2(p2, q3, h4);
        b3 = hue2rgb2(p2, q3, h4 - 1 / 3);
      }
      return { r: r2 * 255, g: g2 * 255, b: b3 * 255 };
    }
    function rgbToHsv(r2, g2, b3) {
      r2 = bound01(r2, 255);
      g2 = bound01(g2, 255);
      b3 = bound01(b3, 255);
      var max2 = mathMax(r2, g2, b3), min2 = mathMin(r2, g2, b3);
      var h4, s3, v2 = max2;
      var d4 = max2 - min2;
      s3 = max2 === 0 ? 0 : d4 / max2;
      if (max2 == min2) {
        h4 = 0;
      } else {
        switch (max2) {
          case r2:
            h4 = (g2 - b3) / d4 + (g2 < b3 ? 6 : 0);
            break;
          case g2:
            h4 = (b3 - r2) / d4 + 2;
            break;
          case b3:
            h4 = (r2 - g2) / d4 + 4;
            break;
        }
        h4 /= 6;
      }
      return { h: h4, s: s3, v: v2 };
    }
    function hsvToRgb(h4, s3, v2) {
      h4 = bound01(h4, 360) * 6;
      s3 = bound01(s3, 100);
      v2 = bound01(v2, 100);
      var i2 = Math2.floor(h4), f2 = h4 - i2, p2 = v2 * (1 - s3), q3 = v2 * (1 - f2 * s3), t3 = v2 * (1 - (1 - f2) * s3), mod = i2 % 6, r2 = [v2, q3, p2, p2, t3, v2][mod], g2 = [t3, v2, v2, q3, p2, p2][mod], b3 = [p2, p2, t3, v2, v2, q3][mod];
      return { r: r2 * 255, g: g2 * 255, b: b3 * 255 };
    }
    function rgbToHex(r2, g2, b3, allow3Char) {
      var hex = [
        pad2(mathRound(r2).toString(16)),
        pad2(mathRound(g2).toString(16)),
        pad2(mathRound(b3).toString(16))
      ];
      if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {
        return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);
      }
      return hex.join("");
    }
    function rgbaToHex(r2, g2, b3, a3, allow4Char) {
      var hex = [
        pad2(mathRound(r2).toString(16)),
        pad2(mathRound(g2).toString(16)),
        pad2(mathRound(b3).toString(16)),
        pad2(convertDecimalToHex(a3))
      ];
      if (allow4Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1) && hex[3].charAt(0) == hex[3].charAt(1)) {
        return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);
      }
      return hex.join("");
    }
    function rgbaToArgbHex(r2, g2, b3, a3) {
      var hex = [
        pad2(convertDecimalToHex(a3)),
        pad2(mathRound(r2).toString(16)),
        pad2(mathRound(g2).toString(16)),
        pad2(mathRound(b3).toString(16))
      ];
      return hex.join("");
    }
    tinycolor2.equals = function(color1, color2) {
      if (!color1 || !color2) {
        return false;
      }
      return tinycolor2(color1).toRgbString() == tinycolor2(color2).toRgbString();
    };
    tinycolor2.random = function() {
      return tinycolor2.fromRatio({
        r: mathRandom(),
        g: mathRandom(),
        b: mathRandom()
      });
    };
    function desaturate(color, amount) {
      amount = amount === 0 ? 0 : amount || 10;
      var hsl2 = tinycolor2(color).toHsl();
      hsl2.s -= amount / 100;
      hsl2.s = clamp01(hsl2.s);
      return tinycolor2(hsl2);
    }
    function saturate(color, amount) {
      amount = amount === 0 ? 0 : amount || 10;
      var hsl2 = tinycolor2(color).toHsl();
      hsl2.s += amount / 100;
      hsl2.s = clamp01(hsl2.s);
      return tinycolor2(hsl2);
    }
    function greyscale(color) {
      return tinycolor2(color).desaturate(100);
    }
    function lighten(color, amount) {
      amount = amount === 0 ? 0 : amount || 10;
      var hsl2 = tinycolor2(color).toHsl();
      hsl2.l += amount / 100;
      hsl2.l = clamp01(hsl2.l);
      return tinycolor2(hsl2);
    }
    function brighten(color, amount) {
      amount = amount === 0 ? 0 : amount || 10;
      var rgb2 = tinycolor2(color).toRgb();
      rgb2.r = mathMax(0, mathMin(255, rgb2.r - mathRound(255 * -(amount / 100))));
      rgb2.g = mathMax(0, mathMin(255, rgb2.g - mathRound(255 * -(amount / 100))));
      rgb2.b = mathMax(0, mathMin(255, rgb2.b - mathRound(255 * -(amount / 100))));
      return tinycolor2(rgb2);
    }
    function darken(color, amount) {
      amount = amount === 0 ? 0 : amount || 10;
      var hsl2 = tinycolor2(color).toHsl();
      hsl2.l -= amount / 100;
      hsl2.l = clamp01(hsl2.l);
      return tinycolor2(hsl2);
    }
    function spin2(color, amount) {
      var hsl2 = tinycolor2(color).toHsl();
      var hue = (hsl2.h + amount) % 360;
      hsl2.h = hue < 0 ? 360 + hue : hue;
      return tinycolor2(hsl2);
    }
    function complement(color) {
      var hsl2 = tinycolor2(color).toHsl();
      hsl2.h = (hsl2.h + 180) % 360;
      return tinycolor2(hsl2);
    }
    function triad(color) {
      var hsl2 = tinycolor2(color).toHsl();
      var h4 = hsl2.h;
      return [
        tinycolor2(color),
        tinycolor2({ h: (h4 + 120) % 360, s: hsl2.s, l: hsl2.l }),
        tinycolor2({ h: (h4 + 240) % 360, s: hsl2.s, l: hsl2.l })
      ];
    }
    function tetrad(color) {
      var hsl2 = tinycolor2(color).toHsl();
      var h4 = hsl2.h;
      return [
        tinycolor2(color),
        tinycolor2({ h: (h4 + 90) % 360, s: hsl2.s, l: hsl2.l }),
        tinycolor2({ h: (h4 + 180) % 360, s: hsl2.s, l: hsl2.l }),
        tinycolor2({ h: (h4 + 270) % 360, s: hsl2.s, l: hsl2.l })
      ];
    }
    function splitcomplement(color) {
      var hsl2 = tinycolor2(color).toHsl();
      var h4 = hsl2.h;
      return [
        tinycolor2(color),
        tinycolor2({ h: (h4 + 72) % 360, s: hsl2.s, l: hsl2.l }),
        tinycolor2({ h: (h4 + 216) % 360, s: hsl2.s, l: hsl2.l })
      ];
    }
    function analogous(color, results, slices) {
      results = results || 6;
      slices = slices || 30;
      var hsl2 = tinycolor2(color).toHsl();
      var part = 360 / slices;
      var ret = [tinycolor2(color)];
      for (hsl2.h = (hsl2.h - (part * results >> 1) + 720) % 360; --results; ) {
        hsl2.h = (hsl2.h + part) % 360;
        ret.push(tinycolor2(hsl2));
      }
      return ret;
    }
    function monochromatic(color, results) {
      results = results || 6;
      var hsv = tinycolor2(color).toHsv();
      var h4 = hsv.h, s3 = hsv.s, v2 = hsv.v;
      var ret = [];
      var modification = 1 / results;
      while (results--) {
        ret.push(tinycolor2({ h: h4, s: s3, v: v2 }));
        v2 = (v2 + modification) % 1;
      }
      return ret;
    }
    tinycolor2.mix = function(color1, color2, amount) {
      amount = amount === 0 ? 0 : amount || 50;
      var rgb1 = tinycolor2(color1).toRgb();
      var rgb2 = tinycolor2(color2).toRgb();
      var p2 = amount / 100;
      var rgba2 = {
        r: (rgb2.r - rgb1.r) * p2 + rgb1.r,
        g: (rgb2.g - rgb1.g) * p2 + rgb1.g,
        b: (rgb2.b - rgb1.b) * p2 + rgb1.b,
        a: (rgb2.a - rgb1.a) * p2 + rgb1.a
      };
      return tinycolor2(rgba2);
    };
    tinycolor2.readability = function(color1, color2) {
      var c12 = tinycolor2(color1);
      var c22 = tinycolor2(color2);
      return (Math2.max(c12.getLuminance(), c22.getLuminance()) + 0.05) / (Math2.min(c12.getLuminance(), c22.getLuminance()) + 0.05);
    };
    tinycolor2.isReadable = function(color1, color2, wcag2) {
      var readability = tinycolor2.readability(color1, color2);
      var wcag2Parms, out;
      out = false;
      wcag2Parms = validateWCAG2Parms(wcag2);
      switch (wcag2Parms.level + wcag2Parms.size) {
        case "AAsmall":
        case "AAAlarge":
          out = readability >= 4.5;
          break;
        case "AAlarge":
          out = readability >= 3;
          break;
        case "AAAsmall":
          out = readability >= 7;
          break;
      }
      return out;
    };
    tinycolor2.mostReadable = function(baseColor, colorList, args) {
      var bestColor = null;
      var bestScore = 0;
      var readability;
      var includeFallbackColors, level, size;
      args = args || {};
      includeFallbackColors = args.includeFallbackColors;
      level = args.level;
      size = args.size;
      for (var i2 = 0; i2 < colorList.length; i2++) {
        readability = tinycolor2.readability(baseColor, colorList[i2]);
        if (readability > bestScore) {
          bestScore = readability;
          bestColor = tinycolor2(colorList[i2]);
        }
      }
      if (tinycolor2.isReadable(baseColor, bestColor, { "level": level, "size": size }) || !includeFallbackColors) {
        return bestColor;
      } else {
        args.includeFallbackColors = false;
        return tinycolor2.mostReadable(baseColor, ["#fff", "#000"], args);
      }
    };
    var names = tinycolor2.names = {
      aliceblue: "f0f8ff",
      antiquewhite: "faebd7",
      aqua: "0ff",
      aquamarine: "7fffd4",
      azure: "f0ffff",
      beige: "f5f5dc",
      bisque: "ffe4c4",
      black: "000",
      blanchedalmond: "ffebcd",
      blue: "00f",
      blueviolet: "8a2be2",
      brown: "a52a2a",
      burlywood: "deb887",
      burntsienna: "ea7e5d",
      cadetblue: "5f9ea0",
      chartreuse: "7fff00",
      chocolate: "d2691e",
      coral: "ff7f50",
      cornflowerblue: "6495ed",
      cornsilk: "fff8dc",
      crimson: "dc143c",
      cyan: "0ff",
      darkblue: "00008b",
      darkcyan: "008b8b",
      darkgoldenrod: "b8860b",
      darkgray: "a9a9a9",
      darkgreen: "006400",
      darkgrey: "a9a9a9",
      darkkhaki: "bdb76b",
      darkmagenta: "8b008b",
      darkolivegreen: "556b2f",
      darkorange: "ff8c00",
      darkorchid: "9932cc",
      darkred: "8b0000",
      darksalmon: "e9967a",
      darkseagreen: "8fbc8f",
      darkslateblue: "483d8b",
      darkslategray: "2f4f4f",
      darkslategrey: "2f4f4f",
      darkturquoise: "00ced1",
      darkviolet: "9400d3",
      deeppink: "ff1493",
      deepskyblue: "00bfff",
      dimgray: "696969",
      dimgrey: "696969",
      dodgerblue: "1e90ff",
      firebrick: "b22222",
      floralwhite: "fffaf0",
      forestgreen: "228b22",
      fuchsia: "f0f",
      gainsboro: "dcdcdc",
      ghostwhite: "f8f8ff",
      gold: "ffd700",
      goldenrod: "daa520",
      gray: "808080",
      green: "008000",
      greenyellow: "adff2f",
      grey: "808080",
      honeydew: "f0fff0",
      hotpink: "ff69b4",
      indianred: "cd5c5c",
      indigo: "4b0082",
      ivory: "fffff0",
      khaki: "f0e68c",
      lavender: "e6e6fa",
      lavenderblush: "fff0f5",
      lawngreen: "7cfc00",
      lemonchiffon: "fffacd",
      lightblue: "add8e6",
      lightcoral: "f08080",
      lightcyan: "e0ffff",
      lightgoldenrodyellow: "fafad2",
      lightgray: "d3d3d3",
      lightgreen: "90ee90",
      lightgrey: "d3d3d3",
      lightpink: "ffb6c1",
      lightsalmon: "ffa07a",
      lightseagreen: "20b2aa",
      lightskyblue: "87cefa",
      lightslategray: "789",
      lightslategrey: "789",
      lightsteelblue: "b0c4de",
      lightyellow: "ffffe0",
      lime: "0f0",
      limegreen: "32cd32",
      linen: "faf0e6",
      magenta: "f0f",
      maroon: "800000",
      mediumaquamarine: "66cdaa",
      mediumblue: "0000cd",
      mediumorchid: "ba55d3",
      mediumpurple: "9370db",
      mediumseagreen: "3cb371",
      mediumslateblue: "7b68ee",
      mediumspringgreen: "00fa9a",
      mediumturquoise: "48d1cc",
      mediumvioletred: "c71585",
      midnightblue: "191970",
      mintcream: "f5fffa",
      mistyrose: "ffe4e1",
      moccasin: "ffe4b5",
      navajowhite: "ffdead",
      navy: "000080",
      oldlace: "fdf5e6",
      olive: "808000",
      olivedrab: "6b8e23",
      orange: "ffa500",
      orangered: "ff4500",
      orchid: "da70d6",
      palegoldenrod: "eee8aa",
      palegreen: "98fb98",
      paleturquoise: "afeeee",
      palevioletred: "db7093",
      papayawhip: "ffefd5",
      peachpuff: "ffdab9",
      peru: "cd853f",
      pink: "ffc0cb",
      plum: "dda0dd",
      powderblue: "b0e0e6",
      purple: "800080",
      rebeccapurple: "663399",
      red: "f00",
      rosybrown: "bc8f8f",
      royalblue: "4169e1",
      saddlebrown: "8b4513",
      salmon: "fa8072",
      sandybrown: "f4a460",
      seagreen: "2e8b57",
      seashell: "fff5ee",
      sienna: "a0522d",
      silver: "c0c0c0",
      skyblue: "87ceeb",
      slateblue: "6a5acd",
      slategray: "708090",
      slategrey: "708090",
      snow: "fffafa",
      springgreen: "00ff7f",
      steelblue: "4682b4",
      tan: "d2b48c",
      teal: "008080",
      thistle: "d8bfd8",
      tomato: "ff6347",
      turquoise: "40e0d0",
      violet: "ee82ee",
      wheat: "f5deb3",
      white: "fff",
      whitesmoke: "f5f5f5",
      yellow: "ff0",
      yellowgreen: "9acd32"
    };
    var hexNames = tinycolor2.hexNames = flip2(names);
    function flip2(o) {
      var flipped = {};
      for (var i2 in o) {
        if (o.hasOwnProperty(i2)) {
          flipped[o[i2]] = i2;
        }
      }
      return flipped;
    }
    function boundAlpha(a3) {
      a3 = parseFloat(a3);
      if (isNaN(a3) || a3 < 0 || a3 > 1) {
        a3 = 1;
      }
      return a3;
    }
    function bound01(n2, max2) {
      if (isOnePointZero(n2)) {
        n2 = "100%";
      }
      var processPercent = isPercentage(n2);
      n2 = mathMin(max2, mathMax(0, parseFloat(n2)));
      if (processPercent) {
        n2 = parseInt(n2 * max2, 10) / 100;
      }
      if (Math2.abs(n2 - max2) < 1e-6) {
        return 1;
      }
      return n2 % max2 / parseFloat(max2);
    }
    function clamp01(val) {
      return mathMin(1, mathMax(0, val));
    }
    function parseIntFromHex(val) {
      return parseInt(val, 16);
    }
    function isOnePointZero(n2) {
      return typeof n2 == "string" && n2.indexOf(".") != -1 && parseFloat(n2) === 1;
    }
    function isPercentage(n2) {
      return typeof n2 === "string" && n2.indexOf("%") != -1;
    }
    function pad2(c7) {
      return c7.length == 1 ? "0" + c7 : "" + c7;
    }
    function convertToPercentage(n2) {
      if (n2 <= 1) {
        n2 = n2 * 100 + "%";
      }
      return n2;
    }
    function convertDecimalToHex(d4) {
      return Math2.round(parseFloat(d4) * 255).toString(16);
    }
    function convertHexToDecimal(h4) {
      return parseIntFromHex(h4) / 255;
    }
    var matchers = function() {
      var CSS_INTEGER = "[-\\+]?\\d+%?";
      var CSS_NUMBER = "[-\\+]?\\d*\\.\\d+%?";
      var CSS_UNIT = "(?:" + CSS_NUMBER + ")|(?:" + CSS_INTEGER + ")";
      var PERMISSIVE_MATCH3 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
      var PERMISSIVE_MATCH4 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
      return {
        CSS_UNIT: new RegExp(CSS_UNIT),
        rgb: new RegExp("rgb" + PERMISSIVE_MATCH3),
        rgba: new RegExp("rgba" + PERMISSIVE_MATCH4),
        hsl: new RegExp("hsl" + PERMISSIVE_MATCH3),
        hsla: new RegExp("hsla" + PERMISSIVE_MATCH4),
        hsv: new RegExp("hsv" + PERMISSIVE_MATCH3),
        hsva: new RegExp("hsva" + PERMISSIVE_MATCH4),
        hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
        hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
        hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
        hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/
      };
    }();
    function isValidCSSUnit(color) {
      return !!matchers.CSS_UNIT.exec(color);
    }
    function stringInputToObject(color) {
      color = color.replace(trimLeft, "").replace(trimRight, "").toLowerCase();
      var named = false;
      if (names[color]) {
        color = names[color];
        named = true;
      } else if (color == "transparent") {
        return { r: 0, g: 0, b: 0, a: 0, format: "name" };
      }
      var match2;
      if (match2 = matchers.rgb.exec(color)) {
        return { r: match2[1], g: match2[2], b: match2[3] };
      }
      if (match2 = matchers.rgba.exec(color)) {
        return { r: match2[1], g: match2[2], b: match2[3], a: match2[4] };
      }
      if (match2 = matchers.hsl.exec(color)) {
        return { h: match2[1], s: match2[2], l: match2[3] };
      }
      if (match2 = matchers.hsla.exec(color)) {
        return { h: match2[1], s: match2[2], l: match2[3], a: match2[4] };
      }
      if (match2 = matchers.hsv.exec(color)) {
        return { h: match2[1], s: match2[2], v: match2[3] };
      }
      if (match2 = matchers.hsva.exec(color)) {
        return { h: match2[1], s: match2[2], v: match2[3], a: match2[4] };
      }
      if (match2 = matchers.hex8.exec(color)) {
        return {
          r: parseIntFromHex(match2[1]),
          g: parseIntFromHex(match2[2]),
          b: parseIntFromHex(match2[3]),
          a: convertHexToDecimal(match2[4]),
          format: named ? "name" : "hex8"
        };
      }
      if (match2 = matchers.hex6.exec(color)) {
        return {
          r: parseIntFromHex(match2[1]),
          g: parseIntFromHex(match2[2]),
          b: parseIntFromHex(match2[3]),
          format: named ? "name" : "hex"
        };
      }
      if (match2 = matchers.hex4.exec(color)) {
        return {
          r: parseIntFromHex(match2[1] + "" + match2[1]),
          g: parseIntFromHex(match2[2] + "" + match2[2]),
          b: parseIntFromHex(match2[3] + "" + match2[3]),
          a: convertHexToDecimal(match2[4] + "" + match2[4]),
          format: named ? "name" : "hex8"
        };
      }
      if (match2 = matchers.hex3.exec(color)) {
        return {
          r: parseIntFromHex(match2[1] + "" + match2[1]),
          g: parseIntFromHex(match2[2] + "" + match2[2]),
          b: parseIntFromHex(match2[3] + "" + match2[3]),
          format: named ? "name" : "hex"
        };
      }
      return false;
    }
    function validateWCAG2Parms(parms) {
      var level, size;
      parms = parms || { "level": "AA", "size": "small" };
      level = (parms.level || "AA").toUpperCase();
      size = (parms.size || "small").toLowerCase();
      if (level !== "AA" && level !== "AAA") {
        level = "AA";
      }
      if (size !== "small" && size !== "large") {
        size = "small";
      }
      return { "level": level, "size": size };
    }
    if (module2.exports) {
      module2.exports = tinycolor2;
    } else {
      window.tinycolor = tinycolor2;
    }
  })(Math);
})(tinycolor$1);
var tinycolor = tinycolor$1.exports;
var simpleCheckForValidColor = function simpleCheckForValidColor2(data2) {
  var keysToCheck = ["r", "g", "b", "a", "h", "s", "l", "v"];
  var checked = 0;
  var passed = 0;
  forEach$1(keysToCheck, function(letter) {
    if (data2[letter]) {
      checked += 1;
      if (!isNaN(data2[letter])) {
        passed += 1;
      }
      if (letter === "s" || letter === "l") {
        var percentPatt = /^\d+%$/;
        if (percentPatt.test(data2[letter])) {
          passed += 1;
        }
      }
    }
  });
  return checked === passed ? data2 : false;
};
var toState = function toState2(data2, oldHue) {
  var color = data2.hex ? tinycolor(data2.hex) : tinycolor(data2);
  var hsl2 = color.toHsl();
  var hsv = color.toHsv();
  var rgb2 = color.toRgb();
  var hex = color.toHex();
  if (hsl2.s === 0) {
    hsl2.h = oldHue || 0;
    hsv.h = oldHue || 0;
  }
  var transparent = hex === "000000" && rgb2.a === 0;
  return {
    hsl: hsl2,
    hex: transparent ? "transparent" : "#" + hex,
    rgb: rgb2,
    hsv,
    oldHue: data2.h || oldHue || hsl2.h,
    source: data2.source
  };
};
var isValidHex = function isValidHex2(hex) {
  if (hex === "transparent") {
    return true;
  }
  var lh = String(hex).charAt(0) === "#" ? 1 : 0;
  return hex.length !== 4 + lh && hex.length < 7 + lh && tinycolor(hex).isValid();
};
var getContrastingColor = function getContrastingColor2(data2) {
  if (!data2) {
    return "#fff";
  }
  var col = toState(data2);
  if (col.hex === "transparent") {
    return "rgba(0,0,0,0.4)";
  }
  var yiq = (col.rgb.r * 299 + col.rgb.g * 587 + col.rgb.b * 114) / 1e3;
  return yiq >= 128 ? "#000" : "#fff";
};
var isvalidColorString = function isvalidColorString2(string, type) {
  var stringWithoutDegree = string.replace("\xB0", "");
  return tinycolor(type + " (" + stringWithoutDegree + ")")._ok;
};
var _extends$9 = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var _createClass$7 = function() {
  function defineProperties(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  return function(Constructor, protoProps, staticProps) {
    if (protoProps)
      defineProperties(Constructor.prototype, protoProps);
    if (staticProps)
      defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();
function _classCallCheck$7(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _possibleConstructorReturn$6(self2, call2) {
  if (!self2) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return call2 && (typeof call2 === "object" || typeof call2 === "function") ? call2 : self2;
}
function _inherits$6(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });
  if (superClass)
    Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
}
var ColorWrap = function ColorWrap2(Picker2) {
  var ColorPicker2 = function(_ref) {
    _inherits$6(ColorPicker3, _ref);
    function ColorPicker3(props) {
      _classCallCheck$7(this, ColorPicker3);
      var _this = _possibleConstructorReturn$6(this, (ColorPicker3.__proto__ || Object.getPrototypeOf(ColorPicker3)).call(this));
      _this.handleChange = function(data2, event) {
        var isValidColor = simpleCheckForValidColor(data2);
        if (isValidColor) {
          var colors2 = toState(data2, data2.h || _this.state.oldHue);
          _this.setState(colors2);
          _this.props.onChangeComplete && _this.debounce(_this.props.onChangeComplete, colors2, event);
          _this.props.onChange && _this.props.onChange(colors2, event);
        }
      };
      _this.handleSwatchHover = function(data2, event) {
        var isValidColor = simpleCheckForValidColor(data2);
        if (isValidColor) {
          var colors2 = toState(data2, data2.h || _this.state.oldHue);
          _this.props.onSwatchHover && _this.props.onSwatchHover(colors2, event);
        }
      };
      _this.state = _extends$9({}, toState(props.color, 0));
      _this.debounce = debounce$4(function(fn3, data2, event) {
        fn3(data2, event);
      }, 100);
      return _this;
    }
    _createClass$7(ColorPicker3, [{
      key: "render",
      value: function render4() {
        var optionalEvents = {};
        if (this.props.onSwatchHover) {
          optionalEvents.onSwatchHover = this.handleSwatchHover;
        }
        return React__default.createElement(Picker2, _extends$9({}, this.props, this.state, {
          onChange: this.handleChange
        }, optionalEvents));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(nextProps, state) {
        return _extends$9({}, toState(nextProps.color, state.oldHue));
      }
    }]);
    return ColorPicker3;
  }(PureComponent || Component);
  ColorPicker2.propTypes = _extends$9({}, Picker2.propTypes);
  ColorPicker2.defaultProps = _extends$9({}, Picker2.defaultProps, {
    color: {
      h: 250,
      s: 0.5,
      l: 0.2,
      a: 1
    }
  });
  return ColorPicker2;
};
var _extends$8 = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var _createClass$6 = function() {
  function defineProperties(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  return function(Constructor, protoProps, staticProps) {
    if (protoProps)
      defineProperties(Constructor.prototype, protoProps);
    if (staticProps)
      defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();
function _classCallCheck$6(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _possibleConstructorReturn$5(self2, call2) {
  if (!self2) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return call2 && (typeof call2 === "object" || typeof call2 === "function") ? call2 : self2;
}
function _inherits$5(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });
  if (superClass)
    Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
}
var handleFocus = function handleFocus2(Component2) {
  var Span = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "span";
  return function(_React$Component) {
    _inherits$5(Focus, _React$Component);
    function Focus() {
      var _ref;
      var _temp, _this, _ret;
      _classCallCheck$6(this, Focus);
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      return _ret = (_temp = (_this = _possibleConstructorReturn$5(this, (_ref = Focus.__proto__ || Object.getPrototypeOf(Focus)).call.apply(_ref, [this].concat(args))), _this), _this.state = { focus: false }, _this.handleFocus = function() {
        return _this.setState({ focus: true });
      }, _this.handleBlur = function() {
        return _this.setState({ focus: false });
      }, _temp), _possibleConstructorReturn$5(_this, _ret);
    }
    _createClass$6(Focus, [{
      key: "render",
      value: function render4() {
        return React__default.createElement(Span, { onFocus: this.handleFocus, onBlur: this.handleBlur }, React__default.createElement(Component2, _extends$8({}, this.props, this.state)));
      }
    }]);
    return Focus;
  }(React__default.Component);
};
var _extends$7 = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var ENTER$1 = 13;
var Swatch = function Swatch2(_ref) {
  var color = _ref.color, style2 = _ref.style, _ref$onClick = _ref.onClick, onClick = _ref$onClick === void 0 ? function() {
  } : _ref$onClick, onHover = _ref.onHover, _ref$title = _ref.title, title2 = _ref$title === void 0 ? color : _ref$title, children = _ref.children, focus2 = _ref.focus, _ref$focusStyle = _ref.focusStyle, focusStyle = _ref$focusStyle === void 0 ? {} : _ref$focusStyle;
  var transparent = color === "transparent";
  var styles2 = _default$9({
    default: {
      swatch: _extends$7({
        background: color,
        height: "100%",
        width: "100%",
        cursor: "pointer",
        position: "relative",
        outline: "none"
      }, style2, focus2 ? focusStyle : {})
    }
  });
  var handleClick = function handleClick2(e3) {
    return onClick(color, e3);
  };
  var handleKeyDown = function handleKeyDown2(e3) {
    return e3.keyCode === ENTER$1 && onClick(color, e3);
  };
  var handleHover2 = function handleHover3(e3) {
    return onHover(color, e3);
  };
  var optionalEvents = {};
  if (onHover) {
    optionalEvents.onMouseOver = handleHover2;
  }
  return React__default.createElement("div", _extends$7({
    style: styles2.swatch,
    onClick: handleClick,
    title: title2,
    tabIndex: 0,
    onKeyDown: handleKeyDown
  }, optionalEvents), children, transparent && React__default.createElement(Checkboard, {
    borderRadius: styles2.swatch.borderRadius,
    boxShadow: "inset 0 0 0 1px rgba(0,0,0,0.1)"
  }));
};
var Swatch$1 = handleFocus(Swatch);
var AlphaPointer = function AlphaPointer2(_ref) {
  var direction = _ref.direction;
  var styles2 = _default$9({
    "default": {
      picker: {
        width: "18px",
        height: "18px",
        borderRadius: "50%",
        transform: "translate(-9px, -1px)",
        backgroundColor: "rgb(248, 248, 248)",
        boxShadow: "0 1px 4px 0 rgba(0, 0, 0, 0.37)"
      }
    },
    "vertical": {
      picker: {
        transform: "translate(-3px, -9px)"
      }
    }
  }, { vertical: direction === "vertical" });
  return React__default.createElement("div", { style: styles2.picker });
};
var _extends$6 = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var AlphaPicker = function AlphaPicker2(_ref) {
  var rgb2 = _ref.rgb, hsl2 = _ref.hsl, width = _ref.width, height = _ref.height, onChange2 = _ref.onChange, direction = _ref.direction, style2 = _ref.style, renderers = _ref.renderers, pointer = _ref.pointer, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className;
  var styles2 = _default$9({
    "default": {
      picker: {
        position: "relative",
        width,
        height
      },
      alpha: {
        radius: "2px",
        style: style2
      }
    }
  });
  return React__default.createElement("div", { style: styles2.picker, className: "alpha-picker " + className }, React__default.createElement(Alpha, _extends$6({}, styles2.alpha, {
    rgb: rgb2,
    hsl: hsl2,
    pointer,
    renderers,
    onChange: onChange2,
    direction
  })));
};
AlphaPicker.defaultProps = {
  width: "316px",
  height: "16px",
  direction: "horizontal",
  pointer: AlphaPointer
};
ColorWrap(AlphaPicker);
function arrayMap(array, iteratee) {
  var index2 = -1, length = array == null ? 0 : array.length, result = Array(length);
  while (++index2 < length) {
    result[index2] = iteratee(array[index2], index2, array);
  }
  return result;
}
var HASH_UNDEFINED = "__lodash_hash_undefined__";
function setCacheAdd(value) {
  this.__data__.set(value, HASH_UNDEFINED);
  return this;
}
function setCacheHas(value) {
  return this.__data__.has(value);
}
function SetCache(values2) {
  var index2 = -1, length = values2 == null ? 0 : values2.length;
  this.__data__ = new MapCache();
  while (++index2 < length) {
    this.add(values2[index2]);
  }
}
SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
SetCache.prototype.has = setCacheHas;
function arraySome(array, predicate) {
  var index2 = -1, length = array == null ? 0 : array.length;
  while (++index2 < length) {
    if (predicate(array[index2], index2, array)) {
      return true;
    }
  }
  return false;
}
function cacheHas(cache2, key) {
  return cache2.has(key);
}
var COMPARE_PARTIAL_FLAG$5 = 1, COMPARE_UNORDERED_FLAG$3 = 2;
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG$5, arrLength = array.length, othLength = other.length;
  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  var arrStacked = stack.get(array);
  var othStacked = stack.get(other);
  if (arrStacked && othStacked) {
    return arrStacked == other && othStacked == array;
  }
  var index2 = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG$3 ? new SetCache() : void 0;
  stack.set(array, other);
  stack.set(other, array);
  while (++index2 < arrLength) {
    var arrValue = array[index2], othValue = other[index2];
    if (customizer) {
      var compared = isPartial ? customizer(othValue, arrValue, index2, other, array, stack) : customizer(arrValue, othValue, index2, array, other, stack);
    }
    if (compared !== void 0) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    if (seen) {
      if (!arraySome(other, function(othValue2, othIndex) {
        if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
          return seen.push(othIndex);
        }
      })) {
        result = false;
        break;
      }
    } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
      result = false;
      break;
    }
  }
  stack["delete"](array);
  stack["delete"](other);
  return result;
}
function mapToArray(map2) {
  var index2 = -1, result = Array(map2.size);
  map2.forEach(function(value, key) {
    result[++index2] = [key, value];
  });
  return result;
}
function setToArray(set2) {
  var index2 = -1, result = Array(set2.size);
  set2.forEach(function(value) {
    result[++index2] = value;
  });
  return result;
}
var COMPARE_PARTIAL_FLAG$4 = 1, COMPARE_UNORDERED_FLAG$2 = 2;
var boolTag = "[object Boolean]", dateTag = "[object Date]", errorTag = "[object Error]", mapTag$1 = "[object Map]", numberTag = "[object Number]", regexpTag = "[object RegExp]", setTag$1 = "[object Set]", stringTag = "[object String]", symbolTag$2 = "[object Symbol]";
var arrayBufferTag = "[object ArrayBuffer]", dataViewTag$1 = "[object DataView]";
var symbolProto$1 = Symbol$2 ? Symbol$2.prototype : void 0, symbolValueOf = symbolProto$1 ? symbolProto$1.valueOf : void 0;
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag$1:
      if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;
    case arrayBufferTag:
      if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array$2(object), new Uint8Array$2(other))) {
        return false;
      }
      return true;
    case boolTag:
    case dateTag:
    case numberTag:
      return eq(+object, +other);
    case errorTag:
      return object.name == other.name && object.message == other.message;
    case regexpTag:
    case stringTag:
      return object == other + "";
    case mapTag$1:
      var convert = mapToArray;
    case setTag$1:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG$4;
      convert || (convert = setToArray);
      if (object.size != other.size && !isPartial) {
        return false;
      }
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG$2;
      stack.set(object, other);
      var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack["delete"](object);
      return result;
    case symbolTag$2:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}
function arrayPush(array, values2) {
  var index2 = -1, length = values2.length, offset4 = array.length;
  while (++index2 < length) {
    array[offset4 + index2] = values2[index2];
  }
  return array;
}
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray$2(object) ? result : arrayPush(result, symbolsFunc(object));
}
function arrayFilter(array, predicate) {
  var index2 = -1, length = array == null ? 0 : array.length, resIndex = 0, result = [];
  while (++index2 < length) {
    var value = array[index2];
    if (predicate(value, index2, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}
function stubArray() {
  return [];
}
var objectProto$4 = Object.prototype;
var propertyIsEnumerable = objectProto$4.propertyIsEnumerable;
var nativeGetSymbols = Object.getOwnPropertySymbols;
var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return arrayFilter(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable.call(object, symbol);
  });
};
var getSymbols$1 = getSymbols;
function getAllKeys(object) {
  return baseGetAllKeys(object, keys, getSymbols$1);
}
var COMPARE_PARTIAL_FLAG$3 = 1;
var objectProto$3 = Object.prototype;
var hasOwnProperty$1 = objectProto$3.hasOwnProperty;
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG$3, objProps = getAllKeys(object), objLength = objProps.length, othProps = getAllKeys(other), othLength = othProps.length;
  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index2 = objLength;
  while (index2--) {
    var key = objProps[index2];
    if (!(isPartial ? key in other : hasOwnProperty$1.call(other, key))) {
      return false;
    }
  }
  var objStacked = stack.get(object);
  var othStacked = stack.get(other);
  if (objStacked && othStacked) {
    return objStacked == other && othStacked == object;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);
  var skipCtor = isPartial;
  while (++index2 < objLength) {
    key = objProps[index2];
    var objValue = object[key], othValue = other[key];
    if (customizer) {
      var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
    }
    if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == "constructor");
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor, othCtor = other.constructor;
    if (objCtor != othCtor && ("constructor" in object && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack["delete"](object);
  stack["delete"](other);
  return result;
}
var DataView$1 = getNative(root$3, "DataView");
var DataView$2 = DataView$1;
var Promise$1 = getNative(root$3, "Promise");
var Promise$2 = Promise$1;
var Set$1 = getNative(root$3, "Set");
var Set$2 = Set$1;
var WeakMap$1 = getNative(root$3, "WeakMap");
var WeakMap$2 = WeakMap$1;
var mapTag = "[object Map]", objectTag$1 = "[object Object]", promiseTag = "[object Promise]", setTag = "[object Set]", weakMapTag = "[object WeakMap]";
var dataViewTag = "[object DataView]";
var dataViewCtorString = toSource(DataView$2), mapCtorString = toSource(Map$2), promiseCtorString = toSource(Promise$2), setCtorString = toSource(Set$2), weakMapCtorString = toSource(WeakMap$2);
var getTag = baseGetTag;
if (DataView$2 && getTag(new DataView$2(new ArrayBuffer(1))) != dataViewTag || Map$2 && getTag(new Map$2()) != mapTag || Promise$2 && getTag(Promise$2.resolve()) != promiseTag || Set$2 && getTag(new Set$2()) != setTag || WeakMap$2 && getTag(new WeakMap$2()) != weakMapTag) {
  getTag = function(value) {
    var result = baseGetTag(value), Ctor = result == objectTag$1 ? value.constructor : void 0, ctorString = Ctor ? toSource(Ctor) : "";
    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString:
          return dataViewTag;
        case mapCtorString:
          return mapTag;
        case promiseCtorString:
          return promiseTag;
        case setCtorString:
          return setTag;
        case weakMapCtorString:
          return weakMapTag;
      }
    }
    return result;
  };
}
var getTag$1 = getTag;
var COMPARE_PARTIAL_FLAG$2 = 1;
var argsTag = "[object Arguments]", arrayTag = "[object Array]", objectTag = "[object Object]";
var objectProto$2 = Object.prototype;
var hasOwnProperty = objectProto$2.hasOwnProperty;
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = isArray$2(object), othIsArr = isArray$2(other), objTag = objIsArr ? arrayTag : getTag$1(object), othTag = othIsArr ? arrayTag : getTag$1(other);
  objTag = objTag == argsTag ? objectTag : objTag;
  othTag = othTag == argsTag ? objectTag : othTag;
  var objIsObj = objTag == objectTag, othIsObj = othTag == objectTag, isSameTag = objTag == othTag;
  if (isSameTag && isBuffer$2(object)) {
    if (!isBuffer$2(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new Stack());
    return objIsArr || isTypedArray$1(object) ? equalArrays(object, other, bitmask, customizer, equalFunc, stack) : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG$2)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty.call(other, "__wrapped__");
    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
      stack || (stack = new Stack());
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new Stack());
  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || !isObjectLike$2(value) && !isObjectLike$2(other)) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}
var COMPARE_PARTIAL_FLAG$1 = 1, COMPARE_UNORDERED_FLAG$1 = 2;
function baseIsMatch(object, source2, matchData, customizer) {
  var index2 = matchData.length, length = index2, noCustomizer = !customizer;
  if (object == null) {
    return !length;
  }
  object = Object(object);
  while (index2--) {
    var data2 = matchData[index2];
    if (noCustomizer && data2[2] ? data2[1] !== object[data2[0]] : !(data2[0] in object)) {
      return false;
    }
  }
  while (++index2 < length) {
    data2 = matchData[index2];
    var key = data2[0], objValue = object[key], srcValue = data2[1];
    if (noCustomizer && data2[2]) {
      if (objValue === void 0 && !(key in object)) {
        return false;
      }
    } else {
      var stack = new Stack();
      if (customizer) {
        var result = customizer(objValue, srcValue, key, object, source2, stack);
      }
      if (!(result === void 0 ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG$1 | COMPARE_UNORDERED_FLAG$1, customizer, stack) : result)) {
        return false;
      }
    }
  }
  return true;
}
function isStrictComparable(value) {
  return value === value && !isObject$4(value);
}
function getMatchData(object) {
  var result = keys(object), length = result.length;
  while (length--) {
    var key = result[length], value = object[key];
    result[length] = [key, value, isStrictComparable(value)];
  }
  return result;
}
function matchesStrictComparable(key, srcValue) {
  return function(object) {
    if (object == null) {
      return false;
    }
    return object[key] === srcValue && (srcValue !== void 0 || key in Object(object));
  };
}
function baseMatches(source2) {
  var matchData = getMatchData(source2);
  if (matchData.length == 1 && matchData[0][2]) {
    return matchesStrictComparable(matchData[0][0], matchData[0][1]);
  }
  return function(object) {
    return object === source2 || baseIsMatch(object, source2, matchData);
  };
}
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/;
function isKey(value, object) {
  if (isArray$2(value)) {
    return false;
  }
  var type = typeof value;
  if (type == "number" || type == "symbol" || type == "boolean" || value == null || isSymbol$2(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object(object);
}
var FUNC_ERROR_TEXT$2 = "Expected a function";
function memoize(func, resolver) {
  if (typeof func != "function" || resolver != null && typeof resolver != "function") {
    throw new TypeError(FUNC_ERROR_TEXT$2);
  }
  var memoized = function() {
    var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache2 = memoized.cache;
    if (cache2.has(key)) {
      return cache2.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache2.set(key, result) || cache2;
    return result;
  };
  memoized.cache = new (memoize.Cache || MapCache)();
  return memoized;
}
memoize.Cache = MapCache;
var MAX_MEMOIZE_SIZE = 500;
function memoizeCapped(func) {
  var result = memoize(func, function(key) {
    if (cache2.size === MAX_MEMOIZE_SIZE) {
      cache2.clear();
    }
    return key;
  });
  var cache2 = result.cache;
  return result;
}
var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
var reEscapeChar = /\\(\\)?/g;
var stringToPath2 = memoizeCapped(function(string) {
  var result = [];
  if (string.charCodeAt(0) === 46) {
    result.push("");
  }
  string.replace(rePropName, function(match2, number, quote2, subString) {
    result.push(quote2 ? subString.replace(reEscapeChar, "$1") : number || match2);
  });
  return result;
});
var stringToPath$1 = stringToPath2;
var INFINITY$1 = 1 / 0;
var symbolProto = Symbol$2 ? Symbol$2.prototype : void 0, symbolToString = symbolProto ? symbolProto.toString : void 0;
function baseToString(value) {
  if (typeof value == "string") {
    return value;
  }
  if (isArray$2(value)) {
    return arrayMap(value, baseToString) + "";
  }
  if (isSymbol$2(value)) {
    return symbolToString ? symbolToString.call(value) : "";
  }
  var result = value + "";
  return result == "0" && 1 / value == -INFINITY$1 ? "-0" : result;
}
function toString$1(value) {
  return value == null ? "" : baseToString(value);
}
function castPath(value, object) {
  if (isArray$2(value)) {
    return value;
  }
  return isKey(value, object) ? [value] : stringToPath$1(toString$1(value));
}
var INFINITY = 1 / 0;
function toKey(value) {
  if (typeof value == "string" || isSymbol$2(value)) {
    return value;
  }
  var result = value + "";
  return result == "0" && 1 / value == -INFINITY ? "-0" : result;
}
function baseGet(object, path) {
  path = castPath(path, object);
  var index2 = 0, length = path.length;
  while (object != null && index2 < length) {
    object = object[toKey(path[index2++])];
  }
  return index2 && index2 == length ? object : void 0;
}
function get2(object, path, defaultValue2) {
  var result = object == null ? void 0 : baseGet(object, path);
  return result === void 0 ? defaultValue2 : result;
}
function baseHasIn(object, key) {
  return object != null && key in Object(object);
}
function hasPath(object, path, hasFunc) {
  path = castPath(path, object);
  var index2 = -1, length = path.length, result = false;
  while (++index2 < length) {
    var key = toKey(path[index2]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result || ++index2 != length) {
    return result;
  }
  length = object == null ? 0 : object.length;
  return !!length && isLength(length) && isIndex(key, length) && (isArray$2(object) || isArguments$1(object));
}
function hasIn(object, path) {
  return object != null && hasPath(object, path, baseHasIn);
}
var COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
function baseMatchesProperty(path, srcValue) {
  if (isKey(path) && isStrictComparable(srcValue)) {
    return matchesStrictComparable(toKey(path), srcValue);
  }
  return function(object) {
    var objValue = get2(object, path);
    return objValue === void 0 && objValue === srcValue ? hasIn(object, path) : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
  };
}
function baseProperty(key) {
  return function(object) {
    return object == null ? void 0 : object[key];
  };
}
function basePropertyDeep(path) {
  return function(object) {
    return baseGet(object, path);
  };
}
function property(path) {
  return isKey(path) ? baseProperty(toKey(path)) : basePropertyDeep(path);
}
function baseIteratee(value) {
  if (typeof value == "function") {
    return value;
  }
  if (value == null) {
    return identity;
  }
  if (typeof value == "object") {
    return isArray$2(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
  }
  return property(value);
}
function baseMap(collection, iteratee) {
  var index2 = -1, result = isArrayLike(collection) ? Array(collection.length) : [];
  baseEach$1(collection, function(value, key, collection2) {
    result[++index2] = iteratee(value, key, collection2);
  });
  return result;
}
function map(collection, iteratee) {
  var func = isArray$2(collection) ? arrayMap : baseMap;
  return func(collection, baseIteratee(iteratee));
}
var BlockSwatches = function BlockSwatches2(_ref) {
  var colors2 = _ref.colors, onClick = _ref.onClick, onSwatchHover = _ref.onSwatchHover;
  var styles2 = _default$9({
    "default": {
      swatches: {
        marginRight: "-10px"
      },
      swatch: {
        width: "22px",
        height: "22px",
        float: "left",
        marginRight: "10px",
        marginBottom: "10px",
        borderRadius: "4px"
      },
      clear: {
        clear: "both"
      }
    }
  });
  return React__default.createElement("div", { style: styles2.swatches }, map(colors2, function(c7) {
    return React__default.createElement(Swatch$1, {
      key: c7,
      color: c7,
      style: styles2.swatch,
      onClick,
      onHover: onSwatchHover,
      focusStyle: {
        boxShadow: "0 0 4px " + c7
      }
    });
  }), React__default.createElement("div", { style: styles2.clear }));
};
var Block = function Block2(_ref) {
  var onChange2 = _ref.onChange, onSwatchHover = _ref.onSwatchHover, hex = _ref.hex, colors2 = _ref.colors, width = _ref.width, triangle = _ref.triangle, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className;
  var transparent = hex === "transparent";
  var handleChange = function handleChange2(hexCode, e3) {
    isValidHex(hexCode) && onChange2({
      hex: hexCode,
      source: "hex"
    }, e3);
  };
  var styles2 = _default$9(merge$2({
    "default": {
      card: {
        width,
        background: "#fff",
        boxShadow: "0 1px rgba(0,0,0,.1)",
        borderRadius: "6px",
        position: "relative"
      },
      head: {
        height: "110px",
        background: hex,
        borderRadius: "6px 6px 0 0",
        display: "flex",
        alignItems: "center",
        justifyContent: "center",
        position: "relative"
      },
      body: {
        padding: "10px"
      },
      label: {
        fontSize: "18px",
        color: getContrastingColor(hex),
        position: "relative"
      },
      triangle: {
        width: "0px",
        height: "0px",
        borderStyle: "solid",
        borderWidth: "0 10px 10px 10px",
        borderColor: "transparent transparent " + hex + " transparent",
        position: "absolute",
        top: "-10px",
        left: "50%",
        marginLeft: "-10px"
      },
      input: {
        width: "100%",
        fontSize: "12px",
        color: "#666",
        border: "0px",
        outline: "none",
        height: "22px",
        boxShadow: "inset 0 0 0 1px #ddd",
        borderRadius: "4px",
        padding: "0 7px",
        boxSizing: "border-box"
      }
    },
    "hide-triangle": {
      triangle: {
        display: "none"
      }
    }
  }, passedStyles), { "hide-triangle": triangle === "hide" });
  return React__default.createElement("div", { style: styles2.card, className: "block-picker " + className }, React__default.createElement("div", { style: styles2.triangle }), React__default.createElement("div", { style: styles2.head }, transparent && React__default.createElement(Checkboard, { borderRadius: "6px 6px 0 0" }), React__default.createElement("div", { style: styles2.label }, hex)), React__default.createElement("div", { style: styles2.body }, React__default.createElement(BlockSwatches, { colors: colors2, onClick: handleChange, onSwatchHover }), React__default.createElement(EditableInput, {
    style: { input: styles2.input },
    value: hex,
    onChange: handleChange
  })));
};
Block.propTypes = {
  width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  colors: PropTypes.arrayOf(PropTypes.string),
  triangle: PropTypes.oneOf(["top", "hide"]),
  styles: PropTypes.object
};
Block.defaultProps = {
  width: 170,
  colors: ["#D9E3F0", "#F47373", "#697689", "#37D67A", "#2CCCE4", "#555555", "#dce775", "#ff8a65", "#ba68c8"],
  triangle: "top",
  styles: {}
};
ColorWrap(Block);
var red = { "50": "#ffebee", "100": "#ffcdd2", "200": "#ef9a9a", "300": "#e57373", "400": "#ef5350", "500": "#f44336", "600": "#e53935", "700": "#d32f2f", "800": "#c62828", "900": "#b71c1c", "a100": "#ff8a80", "a200": "#ff5252", "a400": "#ff1744", "a700": "#d50000" };
var pink = { "50": "#fce4ec", "100": "#f8bbd0", "200": "#f48fb1", "300": "#f06292", "400": "#ec407a", "500": "#e91e63", "600": "#d81b60", "700": "#c2185b", "800": "#ad1457", "900": "#880e4f", "a100": "#ff80ab", "a200": "#ff4081", "a400": "#f50057", "a700": "#c51162" };
var purple = { "50": "#f3e5f5", "100": "#e1bee7", "200": "#ce93d8", "300": "#ba68c8", "400": "#ab47bc", "500": "#9c27b0", "600": "#8e24aa", "700": "#7b1fa2", "800": "#6a1b9a", "900": "#4a148c", "a100": "#ea80fc", "a200": "#e040fb", "a400": "#d500f9", "a700": "#aa00ff" };
var deepPurple = { "50": "#ede7f6", "100": "#d1c4e9", "200": "#b39ddb", "300": "#9575cd", "400": "#7e57c2", "500": "#673ab7", "600": "#5e35b1", "700": "#512da8", "800": "#4527a0", "900": "#311b92", "a100": "#b388ff", "a200": "#7c4dff", "a400": "#651fff", "a700": "#6200ea" };
var indigo = { "50": "#e8eaf6", "100": "#c5cae9", "200": "#9fa8da", "300": "#7986cb", "400": "#5c6bc0", "500": "#3f51b5", "600": "#3949ab", "700": "#303f9f", "800": "#283593", "900": "#1a237e", "a100": "#8c9eff", "a200": "#536dfe", "a400": "#3d5afe", "a700": "#304ffe" };
var blue = { "50": "#e3f2fd", "100": "#bbdefb", "200": "#90caf9", "300": "#64b5f6", "400": "#42a5f5", "500": "#2196f3", "600": "#1e88e5", "700": "#1976d2", "800": "#1565c0", "900": "#0d47a1", "a100": "#82b1ff", "a200": "#448aff", "a400": "#2979ff", "a700": "#2962ff" };
var lightBlue = { "50": "#e1f5fe", "100": "#b3e5fc", "200": "#81d4fa", "300": "#4fc3f7", "400": "#29b6f6", "500": "#03a9f4", "600": "#039be5", "700": "#0288d1", "800": "#0277bd", "900": "#01579b", "a100": "#80d8ff", "a200": "#40c4ff", "a400": "#00b0ff", "a700": "#0091ea" };
var cyan = { "50": "#e0f7fa", "100": "#b2ebf2", "200": "#80deea", "300": "#4dd0e1", "400": "#26c6da", "500": "#00bcd4", "600": "#00acc1", "700": "#0097a7", "800": "#00838f", "900": "#006064", "a100": "#84ffff", "a200": "#18ffff", "a400": "#00e5ff", "a700": "#00b8d4" };
var teal = { "50": "#e0f2f1", "100": "#b2dfdb", "200": "#80cbc4", "300": "#4db6ac", "400": "#26a69a", "500": "#009688", "600": "#00897b", "700": "#00796b", "800": "#00695c", "900": "#004d40", "a100": "#a7ffeb", "a200": "#64ffda", "a400": "#1de9b6", "a700": "#00bfa5" };
var green = { "50": "#e8f5e9", "100": "#c8e6c9", "200": "#a5d6a7", "300": "#81c784", "400": "#66bb6a", "500": "#4caf50", "600": "#43a047", "700": "#388e3c", "800": "#2e7d32", "900": "#1b5e20", "a100": "#b9f6ca", "a200": "#69f0ae", "a400": "#00e676", "a700": "#00c853" };
var lightGreen = { "50": "#f1f8e9", "100": "#dcedc8", "200": "#c5e1a5", "300": "#aed581", "400": "#9ccc65", "500": "#8bc34a", "600": "#7cb342", "700": "#689f38", "800": "#558b2f", "900": "#33691e", "a100": "#ccff90", "a200": "#b2ff59", "a400": "#76ff03", "a700": "#64dd17" };
var lime = { "50": "#f9fbe7", "100": "#f0f4c3", "200": "#e6ee9c", "300": "#dce775", "400": "#d4e157", "500": "#cddc39", "600": "#c0ca33", "700": "#afb42b", "800": "#9e9d24", "900": "#827717", "a100": "#f4ff81", "a200": "#eeff41", "a400": "#c6ff00", "a700": "#aeea00" };
var yellow = { "50": "#fffde7", "100": "#fff9c4", "200": "#fff59d", "300": "#fff176", "400": "#ffee58", "500": "#ffeb3b", "600": "#fdd835", "700": "#fbc02d", "800": "#f9a825", "900": "#f57f17", "a100": "#ffff8d", "a200": "#ffff00", "a400": "#ffea00", "a700": "#ffd600" };
var amber = { "50": "#fff8e1", "100": "#ffecb3", "200": "#ffe082", "300": "#ffd54f", "400": "#ffca28", "500": "#ffc107", "600": "#ffb300", "700": "#ffa000", "800": "#ff8f00", "900": "#ff6f00", "a100": "#ffe57f", "a200": "#ffd740", "a400": "#ffc400", "a700": "#ffab00" };
var orange = { "50": "#fff3e0", "100": "#ffe0b2", "200": "#ffcc80", "300": "#ffb74d", "400": "#ffa726", "500": "#ff9800", "600": "#fb8c00", "700": "#f57c00", "800": "#ef6c00", "900": "#e65100", "a100": "#ffd180", "a200": "#ffab40", "a400": "#ff9100", "a700": "#ff6d00" };
var deepOrange = { "50": "#fbe9e7", "100": "#ffccbc", "200": "#ffab91", "300": "#ff8a65", "400": "#ff7043", "500": "#ff5722", "600": "#f4511e", "700": "#e64a19", "800": "#d84315", "900": "#bf360c", "a100": "#ff9e80", "a200": "#ff6e40", "a400": "#ff3d00", "a700": "#dd2c00" };
var brown = { "50": "#efebe9", "100": "#d7ccc8", "200": "#bcaaa4", "300": "#a1887f", "400": "#8d6e63", "500": "#795548", "600": "#6d4c41", "700": "#5d4037", "800": "#4e342e", "900": "#3e2723" };
var blueGrey = { "50": "#eceff1", "100": "#cfd8dc", "200": "#b0bec5", "300": "#90a4ae", "400": "#78909c", "500": "#607d8b", "600": "#546e7a", "700": "#455a64", "800": "#37474f", "900": "#263238" };
var CircleSwatch = function CircleSwatch2(_ref) {
  var color = _ref.color, onClick = _ref.onClick, onSwatchHover = _ref.onSwatchHover, hover3 = _ref.hover, active3 = _ref.active, circleSize = _ref.circleSize, circleSpacing = _ref.circleSpacing;
  var styles2 = _default$9({
    "default": {
      swatch: {
        width: circleSize,
        height: circleSize,
        marginRight: circleSpacing,
        marginBottom: circleSpacing,
        transform: "scale(1)",
        transition: "100ms transform ease"
      },
      Swatch: {
        borderRadius: "50%",
        background: "transparent",
        boxShadow: "inset 0 0 0 " + (circleSize / 2 + 1) + "px " + color,
        transition: "100ms box-shadow ease"
      }
    },
    "hover": {
      swatch: {
        transform: "scale(1.2)"
      }
    },
    "active": {
      Swatch: {
        boxShadow: "inset 0 0 0 3px " + color
      }
    }
  }, { hover: hover3, active: active3 });
  return React__default.createElement("div", { style: styles2.swatch }, React__default.createElement(Swatch$1, {
    style: styles2.Swatch,
    color,
    onClick,
    onHover: onSwatchHover,
    focusStyle: { boxShadow: styles2.Swatch.boxShadow + ", 0 0 5px " + color }
  }));
};
CircleSwatch.defaultProps = {
  circleSize: 28,
  circleSpacing: 14
};
var CircleSwatch$1 = handleHover(CircleSwatch);
var Circle = function Circle2(_ref) {
  var width = _ref.width, onChange2 = _ref.onChange, onSwatchHover = _ref.onSwatchHover, colors2 = _ref.colors, hex = _ref.hex, circleSize = _ref.circleSize, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles, circleSpacing = _ref.circleSpacing, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className;
  var styles2 = _default$9(merge$2({
    "default": {
      card: {
        width,
        display: "flex",
        flexWrap: "wrap",
        marginRight: -circleSpacing,
        marginBottom: -circleSpacing
      }
    }
  }, passedStyles));
  var handleChange = function handleChange2(hexCode, e3) {
    return onChange2({ hex: hexCode, source: "hex" }, e3);
  };
  return React__default.createElement("div", { style: styles2.card, className: "circle-picker " + className }, map(colors2, function(c7) {
    return React__default.createElement(CircleSwatch$1, {
      key: c7,
      color: c7,
      onClick: handleChange,
      onSwatchHover,
      active: hex === c7.toLowerCase(),
      circleSize,
      circleSpacing
    });
  }));
};
Circle.propTypes = {
  width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  circleSize: PropTypes.number,
  circleSpacing: PropTypes.number,
  styles: PropTypes.object
};
Circle.defaultProps = {
  width: 252,
  circleSize: 28,
  circleSpacing: 14,
  colors: [red["500"], pink["500"], purple["500"], deepPurple["500"], indigo["500"], blue["500"], lightBlue["500"], cyan["500"], teal["500"], green["500"], lightGreen["500"], lime["500"], yellow["500"], amber["500"], orange["500"], deepOrange["500"], brown["500"], blueGrey["500"]],
  styles: {}
};
ColorWrap(Circle);
function isUndefined$1(value) {
  return value === void 0;
}
var UnfoldMoreHorizontalIcon = {};
Object.defineProperty(UnfoldMoreHorizontalIcon, "__esModule", {
  value: true
});
var _extends$5 = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var _react$2 = React__default;
var _react2$1 = _interopRequireDefault$8(_react$2);
function _interopRequireDefault$8(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}
function _objectWithoutProperties$3(obj, keys2) {
  var target = {};
  for (var i2 in obj) {
    if (keys2.indexOf(i2) >= 0)
      continue;
    if (!Object.prototype.hasOwnProperty.call(obj, i2))
      continue;
    target[i2] = obj[i2];
  }
  return target;
}
var DEFAULT_SIZE$3 = 24;
var _default$8 = UnfoldMoreHorizontalIcon.default = function(_ref) {
  var _ref$fill = _ref.fill, fill = _ref$fill === void 0 ? "currentColor" : _ref$fill, _ref$width = _ref.width, width = _ref$width === void 0 ? DEFAULT_SIZE$3 : _ref$width, _ref$height = _ref.height, height = _ref$height === void 0 ? DEFAULT_SIZE$3 : _ref$height, _ref$style = _ref.style, style2 = _ref$style === void 0 ? {} : _ref$style, props = _objectWithoutProperties$3(_ref, ["fill", "width", "height", "style"]);
  return _react2$1.default.createElement("svg", _extends$5({
    viewBox: "0 0 " + DEFAULT_SIZE$3 + " " + DEFAULT_SIZE$3,
    style: _extends$5({ fill, width, height }, style2)
  }, props), _react2$1.default.createElement("path", { d: "M12,18.17L8.83,15L7.42,16.41L12,21L16.59,16.41L15.17,15M12,5.83L15.17,9L16.58,7.59L12,3L7.41,7.59L8.83,9L12,5.83Z" }));
};
var _createClass$5 = function() {
  function defineProperties(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  return function(Constructor, protoProps, staticProps) {
    if (protoProps)
      defineProperties(Constructor.prototype, protoProps);
    if (staticProps)
      defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();
function _classCallCheck$5(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _possibleConstructorReturn$4(self2, call2) {
  if (!self2) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return call2 && (typeof call2 === "object" || typeof call2 === "function") ? call2 : self2;
}
function _inherits$4(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });
  if (superClass)
    Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
}
var ChromeFields = function(_React$Component) {
  _inherits$4(ChromeFields2, _React$Component);
  function ChromeFields2(props) {
    _classCallCheck$5(this, ChromeFields2);
    var _this = _possibleConstructorReturn$4(this, (ChromeFields2.__proto__ || Object.getPrototypeOf(ChromeFields2)).call(this));
    _this.toggleViews = function() {
      if (_this.state.view === "hex") {
        _this.setState({ view: "rgb" });
      } else if (_this.state.view === "rgb") {
        _this.setState({ view: "hsl" });
      } else if (_this.state.view === "hsl") {
        if (_this.props.hsl.a === 1) {
          _this.setState({ view: "hex" });
        } else {
          _this.setState({ view: "rgb" });
        }
      }
    };
    _this.handleChange = function(data2, e3) {
      if (data2.hex) {
        isValidHex(data2.hex) && _this.props.onChange({
          hex: data2.hex,
          source: "hex"
        }, e3);
      } else if (data2.r || data2.g || data2.b) {
        _this.props.onChange({
          r: data2.r || _this.props.rgb.r,
          g: data2.g || _this.props.rgb.g,
          b: data2.b || _this.props.rgb.b,
          source: "rgb"
        }, e3);
      } else if (data2.a) {
        if (data2.a < 0) {
          data2.a = 0;
        } else if (data2.a > 1) {
          data2.a = 1;
        }
        _this.props.onChange({
          h: _this.props.hsl.h,
          s: _this.props.hsl.s,
          l: _this.props.hsl.l,
          a: Math.round(data2.a * 100) / 100,
          source: "rgb"
        }, e3);
      } else if (data2.h || data2.s || data2.l) {
        if (typeof data2.s === "string" && data2.s.includes("%")) {
          data2.s = data2.s.replace("%", "");
        }
        if (typeof data2.l === "string" && data2.l.includes("%")) {
          data2.l = data2.l.replace("%", "");
        }
        if (data2.s == 1) {
          data2.s = 0.01;
        } else if (data2.l == 1) {
          data2.l = 0.01;
        }
        _this.props.onChange({
          h: data2.h || _this.props.hsl.h,
          s: Number(!isUndefined$1(data2.s) ? data2.s : _this.props.hsl.s),
          l: Number(!isUndefined$1(data2.l) ? data2.l : _this.props.hsl.l),
          source: "hsl"
        }, e3);
      }
    };
    _this.showHighlight = function(e3) {
      e3.currentTarget.style.background = "#eee";
    };
    _this.hideHighlight = function(e3) {
      e3.currentTarget.style.background = "transparent";
    };
    if (props.hsl.a !== 1 && props.view === "hex") {
      _this.state = {
        view: "rgb"
      };
    } else {
      _this.state = {
        view: props.view
      };
    }
    return _this;
  }
  _createClass$5(ChromeFields2, [{
    key: "render",
    value: function render4() {
      var _this2 = this;
      var styles2 = _default$9({
        "default": {
          wrap: {
            paddingTop: "16px",
            display: "flex"
          },
          fields: {
            flex: "1",
            display: "flex",
            marginLeft: "-6px"
          },
          field: {
            paddingLeft: "6px",
            width: "100%"
          },
          alpha: {
            paddingLeft: "6px",
            width: "100%"
          },
          toggle: {
            width: "32px",
            textAlign: "right",
            position: "relative"
          },
          icon: {
            marginRight: "-4px",
            marginTop: "12px",
            cursor: "pointer",
            position: "relative"
          },
          iconHighlight: {
            position: "absolute",
            width: "24px",
            height: "28px",
            background: "#eee",
            borderRadius: "4px",
            top: "10px",
            left: "12px",
            display: "none"
          },
          input: {
            fontSize: "11px",
            color: "#333",
            width: "100%",
            borderRadius: "2px",
            border: "none",
            boxShadow: "inset 0 0 0 1px #dadada",
            height: "21px",
            textAlign: "center"
          },
          label: {
            textTransform: "uppercase",
            fontSize: "11px",
            lineHeight: "11px",
            color: "#969696",
            textAlign: "center",
            display: "block",
            marginTop: "12px"
          },
          svg: {
            fill: "#333",
            width: "24px",
            height: "24px",
            border: "1px transparent solid",
            borderRadius: "5px"
          }
        },
        "disableAlpha": {
          alpha: {
            display: "none"
          }
        }
      }, this.props, this.state);
      var fields2 = void 0;
      if (this.state.view === "hex") {
        fields2 = React__default.createElement("div", { style: styles2.fields, className: "flexbox-fix" }, React__default.createElement("div", { style: styles2.field }, React__default.createElement(EditableInput, {
          style: { input: styles2.input, label: styles2.label },
          label: "hex",
          value: this.props.hex,
          onChange: this.handleChange
        })));
      } else if (this.state.view === "rgb") {
        fields2 = React__default.createElement("div", { style: styles2.fields, className: "flexbox-fix" }, React__default.createElement("div", { style: styles2.field }, React__default.createElement(EditableInput, {
          style: { input: styles2.input, label: styles2.label },
          label: "r",
          value: this.props.rgb.r,
          onChange: this.handleChange
        })), React__default.createElement("div", { style: styles2.field }, React__default.createElement(EditableInput, {
          style: { input: styles2.input, label: styles2.label },
          label: "g",
          value: this.props.rgb.g,
          onChange: this.handleChange
        })), React__default.createElement("div", { style: styles2.field }, React__default.createElement(EditableInput, {
          style: { input: styles2.input, label: styles2.label },
          label: "b",
          value: this.props.rgb.b,
          onChange: this.handleChange
        })), React__default.createElement("div", { style: styles2.alpha }, React__default.createElement(EditableInput, {
          style: { input: styles2.input, label: styles2.label },
          label: "a",
          value: this.props.rgb.a,
          arrowOffset: 0.01,
          onChange: this.handleChange
        })));
      } else if (this.state.view === "hsl") {
        fields2 = React__default.createElement("div", { style: styles2.fields, className: "flexbox-fix" }, React__default.createElement("div", { style: styles2.field }, React__default.createElement(EditableInput, {
          style: { input: styles2.input, label: styles2.label },
          label: "h",
          value: Math.round(this.props.hsl.h),
          onChange: this.handleChange
        })), React__default.createElement("div", { style: styles2.field }, React__default.createElement(EditableInput, {
          style: { input: styles2.input, label: styles2.label },
          label: "s",
          value: Math.round(this.props.hsl.s * 100) + "%",
          onChange: this.handleChange
        })), React__default.createElement("div", { style: styles2.field }, React__default.createElement(EditableInput, {
          style: { input: styles2.input, label: styles2.label },
          label: "l",
          value: Math.round(this.props.hsl.l * 100) + "%",
          onChange: this.handleChange
        })), React__default.createElement("div", { style: styles2.alpha }, React__default.createElement(EditableInput, {
          style: { input: styles2.input, label: styles2.label },
          label: "a",
          value: this.props.hsl.a,
          arrowOffset: 0.01,
          onChange: this.handleChange
        })));
      }
      return React__default.createElement("div", { style: styles2.wrap, className: "flexbox-fix" }, fields2, React__default.createElement("div", { style: styles2.toggle }, React__default.createElement("div", { style: styles2.icon, onClick: this.toggleViews, ref: function ref(icon2) {
        return _this2.icon = icon2;
      } }, React__default.createElement(_default$8, {
        style: styles2.svg,
        onMouseOver: this.showHighlight,
        onMouseEnter: this.showHighlight,
        onMouseOut: this.hideHighlight
      }))));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, state) {
      if (nextProps.hsl.a !== 1 && state.view === "hex") {
        return { view: "rgb" };
      }
      return null;
    }
  }]);
  return ChromeFields2;
}(React__default.Component);
ChromeFields.defaultProps = {
  view: "hex"
};
var ChromePointer = function ChromePointer2() {
  var styles2 = _default$9({
    "default": {
      picker: {
        width: "12px",
        height: "12px",
        borderRadius: "6px",
        transform: "translate(-6px, -1px)",
        backgroundColor: "rgb(248, 248, 248)",
        boxShadow: "0 1px 4px 0 rgba(0, 0, 0, 0.37)"
      }
    }
  });
  return React__default.createElement("div", { style: styles2.picker });
};
var ChromePointerCircle = function ChromePointerCircle2() {
  var styles2 = _default$9({
    "default": {
      picker: {
        width: "12px",
        height: "12px",
        borderRadius: "6px",
        boxShadow: "inset 0 0 0 1px #fff",
        transform: "translate(-6px, -6px)"
      }
    }
  });
  return React__default.createElement("div", { style: styles2.picker });
};
var Chrome = function Chrome2(_ref) {
  var width = _ref.width, onChange2 = _ref.onChange, disableAlpha = _ref.disableAlpha, rgb2 = _ref.rgb, hsl2 = _ref.hsl, hsv = _ref.hsv, hex = _ref.hex, renderers = _ref.renderers, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className, defaultView = _ref.defaultView;
  var styles2 = _default$9(merge$2({
    "default": {
      picker: {
        width,
        background: "#fff",
        borderRadius: "2px",
        boxShadow: "0 0 2px rgba(0,0,0,.3), 0 4px 8px rgba(0,0,0,.3)",
        boxSizing: "initial",
        fontFamily: "Menlo"
      },
      saturation: {
        width: "100%",
        paddingBottom: "55%",
        position: "relative",
        borderRadius: "2px 2px 0 0",
        overflow: "hidden"
      },
      Saturation: {
        radius: "2px 2px 0 0"
      },
      body: {
        padding: "16px 16px 12px"
      },
      controls: {
        display: "flex"
      },
      color: {
        width: "32px"
      },
      swatch: {
        marginTop: "6px",
        width: "16px",
        height: "16px",
        borderRadius: "8px",
        position: "relative",
        overflow: "hidden"
      },
      active: {
        absolute: "0px 0px 0px 0px",
        borderRadius: "8px",
        boxShadow: "inset 0 0 0 1px rgba(0,0,0,.1)",
        background: "rgba(" + rgb2.r + ", " + rgb2.g + ", " + rgb2.b + ", " + rgb2.a + ")",
        zIndex: "2"
      },
      toggles: {
        flex: "1"
      },
      hue: {
        height: "10px",
        position: "relative",
        marginBottom: "8px"
      },
      Hue: {
        radius: "2px"
      },
      alpha: {
        height: "10px",
        position: "relative"
      },
      Alpha: {
        radius: "2px"
      }
    },
    "disableAlpha": {
      color: {
        width: "22px"
      },
      alpha: {
        display: "none"
      },
      hue: {
        marginBottom: "0px"
      },
      swatch: {
        width: "10px",
        height: "10px",
        marginTop: "0px"
      }
    }
  }, passedStyles), { disableAlpha });
  return React__default.createElement("div", { style: styles2.picker, className: "chrome-picker " + className }, React__default.createElement("div", { style: styles2.saturation }, React__default.createElement(Saturation, {
    style: styles2.Saturation,
    hsl: hsl2,
    hsv,
    pointer: ChromePointerCircle,
    onChange: onChange2
  })), React__default.createElement("div", { style: styles2.body }, React__default.createElement("div", { style: styles2.controls, className: "flexbox-fix" }, React__default.createElement("div", { style: styles2.color }, React__default.createElement("div", { style: styles2.swatch }, React__default.createElement("div", { style: styles2.active }), React__default.createElement(Checkboard, { renderers }))), React__default.createElement("div", { style: styles2.toggles }, React__default.createElement("div", { style: styles2.hue }, React__default.createElement(Hue, {
    style: styles2.Hue,
    hsl: hsl2,
    pointer: ChromePointer,
    onChange: onChange2
  })), React__default.createElement("div", { style: styles2.alpha }, React__default.createElement(Alpha, {
    style: styles2.Alpha,
    rgb: rgb2,
    hsl: hsl2,
    pointer: ChromePointer,
    renderers,
    onChange: onChange2
  })))), React__default.createElement(ChromeFields, {
    rgb: rgb2,
    hsl: hsl2,
    hex,
    view: defaultView,
    onChange: onChange2,
    disableAlpha
  })));
};
Chrome.propTypes = {
  width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  disableAlpha: PropTypes.bool,
  styles: PropTypes.object,
  defaultView: PropTypes.oneOf(["hex", "rgb", "hsl"])
};
Chrome.defaultProps = {
  width: 225,
  disableAlpha: false,
  styles: {}
};
var ChromePicker = ColorWrap(Chrome);
var CompactColor = function CompactColor2(_ref) {
  var color = _ref.color, _ref$onClick = _ref.onClick, onClick = _ref$onClick === void 0 ? function() {
  } : _ref$onClick, onSwatchHover = _ref.onSwatchHover, active3 = _ref.active;
  var styles2 = _default$9({
    "default": {
      color: {
        background: color,
        width: "15px",
        height: "15px",
        float: "left",
        marginRight: "5px",
        marginBottom: "5px",
        position: "relative",
        cursor: "pointer"
      },
      dot: {
        absolute: "5px 5px 5px 5px",
        background: getContrastingColor(color),
        borderRadius: "50%",
        opacity: "0"
      }
    },
    "active": {
      dot: {
        opacity: "1"
      }
    },
    "color-#FFFFFF": {
      color: {
        boxShadow: "inset 0 0 0 1px #ddd"
      },
      dot: {
        background: "#000"
      }
    },
    "transparent": {
      dot: {
        background: "#000"
      }
    }
  }, { active: active3, "color-#FFFFFF": color === "#FFFFFF", "transparent": color === "transparent" });
  return React__default.createElement(Swatch$1, {
    style: styles2.color,
    color,
    onClick,
    onHover: onSwatchHover,
    focusStyle: { boxShadow: "0 0 4px " + color }
  }, React__default.createElement("div", { style: styles2.dot }));
};
var CompactFields = function CompactFields2(_ref) {
  var hex = _ref.hex, rgb2 = _ref.rgb, onChange2 = _ref.onChange;
  var styles2 = _default$9({
    "default": {
      fields: {
        display: "flex",
        paddingBottom: "6px",
        paddingRight: "5px",
        position: "relative"
      },
      active: {
        position: "absolute",
        top: "6px",
        left: "5px",
        height: "9px",
        width: "9px",
        background: hex
      },
      HEXwrap: {
        flex: "6",
        position: "relative"
      },
      HEXinput: {
        width: "80%",
        padding: "0px",
        paddingLeft: "20%",
        border: "none",
        outline: "none",
        background: "none",
        fontSize: "12px",
        color: "#333",
        height: "16px"
      },
      HEXlabel: {
        display: "none"
      },
      RGBwrap: {
        flex: "3",
        position: "relative"
      },
      RGBinput: {
        width: "70%",
        padding: "0px",
        paddingLeft: "30%",
        border: "none",
        outline: "none",
        background: "none",
        fontSize: "12px",
        color: "#333",
        height: "16px"
      },
      RGBlabel: {
        position: "absolute",
        top: "3px",
        left: "0px",
        lineHeight: "16px",
        textTransform: "uppercase",
        fontSize: "12px",
        color: "#999"
      }
    }
  });
  var handleChange = function handleChange2(data2, e3) {
    if (data2.r || data2.g || data2.b) {
      onChange2({
        r: data2.r || rgb2.r,
        g: data2.g || rgb2.g,
        b: data2.b || rgb2.b,
        source: "rgb"
      }, e3);
    } else {
      onChange2({
        hex: data2.hex,
        source: "hex"
      }, e3);
    }
  };
  return React__default.createElement("div", { style: styles2.fields, className: "flexbox-fix" }, React__default.createElement("div", { style: styles2.active }), React__default.createElement(EditableInput, {
    style: { wrap: styles2.HEXwrap, input: styles2.HEXinput, label: styles2.HEXlabel },
    label: "hex",
    value: hex,
    onChange: handleChange
  }), React__default.createElement(EditableInput, {
    style: { wrap: styles2.RGBwrap, input: styles2.RGBinput, label: styles2.RGBlabel },
    label: "r",
    value: rgb2.r,
    onChange: handleChange
  }), React__default.createElement(EditableInput, {
    style: { wrap: styles2.RGBwrap, input: styles2.RGBinput, label: styles2.RGBlabel },
    label: "g",
    value: rgb2.g,
    onChange: handleChange
  }), React__default.createElement(EditableInput, {
    style: { wrap: styles2.RGBwrap, input: styles2.RGBinput, label: styles2.RGBlabel },
    label: "b",
    value: rgb2.b,
    onChange: handleChange
  }));
};
var Compact = function Compact2(_ref) {
  var onChange2 = _ref.onChange, onSwatchHover = _ref.onSwatchHover, colors2 = _ref.colors, hex = _ref.hex, rgb2 = _ref.rgb, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className;
  var styles2 = _default$9(merge$2({
    "default": {
      Compact: {
        background: "#f6f6f6",
        radius: "4px"
      },
      compact: {
        paddingTop: "5px",
        paddingLeft: "5px",
        boxSizing: "initial",
        width: "240px"
      },
      clear: {
        clear: "both"
      }
    }
  }, passedStyles));
  var handleChange = function handleChange2(data2, e3) {
    if (data2.hex) {
      isValidHex(data2.hex) && onChange2({
        hex: data2.hex,
        source: "hex"
      }, e3);
    } else {
      onChange2(data2, e3);
    }
  };
  return React__default.createElement(Raised, { style: styles2.Compact, styles: passedStyles }, React__default.createElement("div", { style: styles2.compact, className: "compact-picker " + className }, React__default.createElement("div", null, map(colors2, function(c7) {
    return React__default.createElement(CompactColor, {
      key: c7,
      color: c7,
      active: c7.toLowerCase() === hex,
      onClick: handleChange,
      onSwatchHover
    });
  }), React__default.createElement("div", { style: styles2.clear })), React__default.createElement(CompactFields, { hex, rgb: rgb2, onChange: handleChange })));
};
Compact.propTypes = {
  colors: PropTypes.arrayOf(PropTypes.string),
  styles: PropTypes.object
};
Compact.defaultProps = {
  colors: ["#4D4D4D", "#999999", "#FFFFFF", "#F44E3B", "#FE9200", "#FCDC00", "#DBDF00", "#A4DD00", "#68CCCA", "#73D8FF", "#AEA1FF", "#FDA1FF", "#333333", "#808080", "#cccccc", "#D33115", "#E27300", "#FCC400", "#B0BC00", "#68BC00", "#16A5A5", "#009CE0", "#7B64FF", "#FA28FF", "#000000", "#666666", "#B3B3B3", "#9F0500", "#C45100", "#FB9E00", "#808900", "#194D33", "#0C797D", "#0062B1", "#653294", "#AB149E"],
  styles: {}
};
ColorWrap(Compact);
var GithubSwatch = function GithubSwatch2(_ref) {
  var hover3 = _ref.hover, color = _ref.color, onClick = _ref.onClick, onSwatchHover = _ref.onSwatchHover;
  var hoverSwatch = {
    position: "relative",
    zIndex: "2",
    outline: "2px solid #fff",
    boxShadow: "0 0 5px 2px rgba(0,0,0,0.25)"
  };
  var styles2 = _default$9({
    "default": {
      swatch: {
        width: "25px",
        height: "25px",
        fontSize: "0"
      }
    },
    "hover": {
      swatch: hoverSwatch
    }
  }, { hover: hover3 });
  return React__default.createElement("div", { style: styles2.swatch }, React__default.createElement(Swatch$1, {
    color,
    onClick,
    onHover: onSwatchHover,
    focusStyle: hoverSwatch
  }));
};
var GithubSwatch$1 = handleHover(GithubSwatch);
var Github = function Github2(_ref) {
  var width = _ref.width, colors2 = _ref.colors, onChange2 = _ref.onChange, onSwatchHover = _ref.onSwatchHover, triangle = _ref.triangle, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className;
  var styles2 = _default$9(merge$2({
    "default": {
      card: {
        width,
        background: "#fff",
        border: "1px solid rgba(0,0,0,0.2)",
        boxShadow: "0 3px 12px rgba(0,0,0,0.15)",
        borderRadius: "4px",
        position: "relative",
        padding: "5px",
        display: "flex",
        flexWrap: "wrap"
      },
      triangle: {
        position: "absolute",
        border: "7px solid transparent",
        borderBottomColor: "#fff"
      },
      triangleShadow: {
        position: "absolute",
        border: "8px solid transparent",
        borderBottomColor: "rgba(0,0,0,0.15)"
      }
    },
    "hide-triangle": {
      triangle: {
        display: "none"
      },
      triangleShadow: {
        display: "none"
      }
    },
    "top-left-triangle": {
      triangle: {
        top: "-14px",
        left: "10px"
      },
      triangleShadow: {
        top: "-16px",
        left: "9px"
      }
    },
    "top-right-triangle": {
      triangle: {
        top: "-14px",
        right: "10px"
      },
      triangleShadow: {
        top: "-16px",
        right: "9px"
      }
    },
    "bottom-left-triangle": {
      triangle: {
        top: "35px",
        left: "10px",
        transform: "rotate(180deg)"
      },
      triangleShadow: {
        top: "37px",
        left: "9px",
        transform: "rotate(180deg)"
      }
    },
    "bottom-right-triangle": {
      triangle: {
        top: "35px",
        right: "10px",
        transform: "rotate(180deg)"
      },
      triangleShadow: {
        top: "37px",
        right: "9px",
        transform: "rotate(180deg)"
      }
    }
  }, passedStyles), {
    "hide-triangle": triangle === "hide",
    "top-left-triangle": triangle === "top-left",
    "top-right-triangle": triangle === "top-right",
    "bottom-left-triangle": triangle === "bottom-left",
    "bottom-right-triangle": triangle === "bottom-right"
  });
  var handleChange = function handleChange2(hex, e3) {
    return onChange2({ hex, source: "hex" }, e3);
  };
  return React__default.createElement("div", { style: styles2.card, className: "github-picker " + className }, React__default.createElement("div", { style: styles2.triangleShadow }), React__default.createElement("div", { style: styles2.triangle }), map(colors2, function(c7) {
    return React__default.createElement(GithubSwatch$1, {
      color: c7,
      key: c7,
      onClick: handleChange,
      onSwatchHover
    });
  }));
};
Github.propTypes = {
  width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  colors: PropTypes.arrayOf(PropTypes.string),
  triangle: PropTypes.oneOf(["hide", "top-left", "top-right", "bottom-left", "bottom-right"]),
  styles: PropTypes.object
};
Github.defaultProps = {
  width: 200,
  colors: ["#B80000", "#DB3E00", "#FCCB00", "#008B02", "#006B76", "#1273DE", "#004DCF", "#5300EB", "#EB9694", "#FAD0C3", "#FEF3BD", "#C1E1C5", "#BEDADC", "#C4DEF6", "#BED3F3", "#D4C4FB"],
  triangle: "top-left",
  styles: {}
};
ColorWrap(Github);
var SliderPointer$1 = function SliderPointer(_ref) {
  var direction = _ref.direction;
  var styles2 = _default$9({
    "default": {
      picker: {
        width: "18px",
        height: "18px",
        borderRadius: "50%",
        transform: "translate(-9px, -1px)",
        backgroundColor: "rgb(248, 248, 248)",
        boxShadow: "0 1px 4px 0 rgba(0, 0, 0, 0.37)"
      }
    },
    "vertical": {
      picker: {
        transform: "translate(-3px, -9px)"
      }
    }
  }, { vertical: direction === "vertical" });
  return React__default.createElement("div", { style: styles2.picker });
};
var _extends$4 = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var HuePicker = function HuePicker2(_ref) {
  var width = _ref.width, height = _ref.height, onChange2 = _ref.onChange, hsl2 = _ref.hsl, direction = _ref.direction, pointer = _ref.pointer, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className;
  var styles2 = _default$9(merge$2({
    "default": {
      picker: {
        position: "relative",
        width,
        height
      },
      hue: {
        radius: "2px"
      }
    }
  }, passedStyles));
  var handleChange = function handleChange2(data2) {
    return onChange2({ a: 1, h: data2.h, l: 0.5, s: 1 });
  };
  return React__default.createElement("div", { style: styles2.picker, className: "hue-picker " + className }, React__default.createElement(Hue, _extends$4({}, styles2.hue, {
    hsl: hsl2,
    pointer,
    onChange: handleChange,
    direction
  })));
};
HuePicker.propTypes = {
  styles: PropTypes.object
};
HuePicker.defaultProps = {
  width: "316px",
  height: "16px",
  direction: "horizontal",
  pointer: SliderPointer$1,
  styles: {}
};
ColorWrap(HuePicker);
var Material = function Material2(_ref) {
  var onChange2 = _ref.onChange, hex = _ref.hex, rgb2 = _ref.rgb, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className;
  var styles2 = _default$9(merge$2({
    "default": {
      material: {
        width: "98px",
        height: "98px",
        padding: "16px",
        fontFamily: "Roboto"
      },
      HEXwrap: {
        position: "relative"
      },
      HEXinput: {
        width: "100%",
        marginTop: "12px",
        fontSize: "15px",
        color: "#333",
        padding: "0px",
        border: "0px",
        borderBottom: "2px solid " + hex,
        outline: "none",
        height: "30px"
      },
      HEXlabel: {
        position: "absolute",
        top: "0px",
        left: "0px",
        fontSize: "11px",
        color: "#999999",
        textTransform: "capitalize"
      },
      Hex: {
        style: {}
      },
      RGBwrap: {
        position: "relative"
      },
      RGBinput: {
        width: "100%",
        marginTop: "12px",
        fontSize: "15px",
        color: "#333",
        padding: "0px",
        border: "0px",
        borderBottom: "1px solid #eee",
        outline: "none",
        height: "30px"
      },
      RGBlabel: {
        position: "absolute",
        top: "0px",
        left: "0px",
        fontSize: "11px",
        color: "#999999",
        textTransform: "capitalize"
      },
      split: {
        display: "flex",
        marginRight: "-10px",
        paddingTop: "11px"
      },
      third: {
        flex: "1",
        paddingRight: "10px"
      }
    }
  }, passedStyles));
  var handleChange = function handleChange2(data2, e3) {
    if (data2.hex) {
      isValidHex(data2.hex) && onChange2({
        hex: data2.hex,
        source: "hex"
      }, e3);
    } else if (data2.r || data2.g || data2.b) {
      onChange2({
        r: data2.r || rgb2.r,
        g: data2.g || rgb2.g,
        b: data2.b || rgb2.b,
        source: "rgb"
      }, e3);
    }
  };
  return React__default.createElement(Raised, { styles: passedStyles }, React__default.createElement("div", { style: styles2.material, className: "material-picker " + className }, React__default.createElement(EditableInput, {
    style: { wrap: styles2.HEXwrap, input: styles2.HEXinput, label: styles2.HEXlabel },
    label: "hex",
    value: hex,
    onChange: handleChange
  }), React__default.createElement("div", { style: styles2.split, className: "flexbox-fix" }, React__default.createElement("div", { style: styles2.third }, React__default.createElement(EditableInput, {
    style: { wrap: styles2.RGBwrap, input: styles2.RGBinput, label: styles2.RGBlabel },
    label: "r",
    value: rgb2.r,
    onChange: handleChange
  })), React__default.createElement("div", { style: styles2.third }, React__default.createElement(EditableInput, {
    style: { wrap: styles2.RGBwrap, input: styles2.RGBinput, label: styles2.RGBlabel },
    label: "g",
    value: rgb2.g,
    onChange: handleChange
  })), React__default.createElement("div", { style: styles2.third }, React__default.createElement(EditableInput, {
    style: { wrap: styles2.RGBwrap, input: styles2.RGBinput, label: styles2.RGBlabel },
    label: "b",
    value: rgb2.b,
    onChange: handleChange
  })))));
};
ColorWrap(Material);
var PhotoshopPicker = function PhotoshopPicker2(_ref) {
  var onChange2 = _ref.onChange, rgb2 = _ref.rgb, hsv = _ref.hsv, hex = _ref.hex;
  var styles2 = _default$9({
    "default": {
      fields: {
        paddingTop: "5px",
        paddingBottom: "9px",
        width: "80px",
        position: "relative"
      },
      divider: {
        height: "5px"
      },
      RGBwrap: {
        position: "relative"
      },
      RGBinput: {
        marginLeft: "40%",
        width: "40%",
        height: "18px",
        border: "1px solid #888888",
        boxShadow: "inset 0 1px 1px rgba(0,0,0,.1), 0 1px 0 0 #ECECEC",
        marginBottom: "5px",
        fontSize: "13px",
        paddingLeft: "3px",
        marginRight: "10px"
      },
      RGBlabel: {
        left: "0px",
        top: "0px",
        width: "34px",
        textTransform: "uppercase",
        fontSize: "13px",
        height: "18px",
        lineHeight: "22px",
        position: "absolute"
      },
      HEXwrap: {
        position: "relative"
      },
      HEXinput: {
        marginLeft: "20%",
        width: "80%",
        height: "18px",
        border: "1px solid #888888",
        boxShadow: "inset 0 1px 1px rgba(0,0,0,.1), 0 1px 0 0 #ECECEC",
        marginBottom: "6px",
        fontSize: "13px",
        paddingLeft: "3px"
      },
      HEXlabel: {
        position: "absolute",
        top: "0px",
        left: "0px",
        width: "14px",
        textTransform: "uppercase",
        fontSize: "13px",
        height: "18px",
        lineHeight: "22px"
      },
      fieldSymbols: {
        position: "absolute",
        top: "5px",
        right: "-7px",
        fontSize: "13px"
      },
      symbol: {
        height: "20px",
        lineHeight: "22px",
        paddingBottom: "7px"
      }
    }
  });
  var handleChange = function handleChange2(data2, e3) {
    if (data2["#"]) {
      isValidHex(data2["#"]) && onChange2({
        hex: data2["#"],
        source: "hex"
      }, e3);
    } else if (data2.r || data2.g || data2.b) {
      onChange2({
        r: data2.r || rgb2.r,
        g: data2.g || rgb2.g,
        b: data2.b || rgb2.b,
        source: "rgb"
      }, e3);
    } else if (data2.h || data2.s || data2.v) {
      onChange2({
        h: data2.h || hsv.h,
        s: data2.s || hsv.s,
        v: data2.v || hsv.v,
        source: "hsv"
      }, e3);
    }
  };
  return React__default.createElement("div", { style: styles2.fields }, React__default.createElement(EditableInput, {
    style: { wrap: styles2.RGBwrap, input: styles2.RGBinput, label: styles2.RGBlabel },
    label: "h",
    value: Math.round(hsv.h),
    onChange: handleChange
  }), React__default.createElement(EditableInput, {
    style: { wrap: styles2.RGBwrap, input: styles2.RGBinput, label: styles2.RGBlabel },
    label: "s",
    value: Math.round(hsv.s * 100),
    onChange: handleChange
  }), React__default.createElement(EditableInput, {
    style: { wrap: styles2.RGBwrap, input: styles2.RGBinput, label: styles2.RGBlabel },
    label: "v",
    value: Math.round(hsv.v * 100),
    onChange: handleChange
  }), React__default.createElement("div", { style: styles2.divider }), React__default.createElement(EditableInput, {
    style: { wrap: styles2.RGBwrap, input: styles2.RGBinput, label: styles2.RGBlabel },
    label: "r",
    value: rgb2.r,
    onChange: handleChange
  }), React__default.createElement(EditableInput, {
    style: { wrap: styles2.RGBwrap, input: styles2.RGBinput, label: styles2.RGBlabel },
    label: "g",
    value: rgb2.g,
    onChange: handleChange
  }), React__default.createElement(EditableInput, {
    style: { wrap: styles2.RGBwrap, input: styles2.RGBinput, label: styles2.RGBlabel },
    label: "b",
    value: rgb2.b,
    onChange: handleChange
  }), React__default.createElement("div", { style: styles2.divider }), React__default.createElement(EditableInput, {
    style: { wrap: styles2.HEXwrap, input: styles2.HEXinput, label: styles2.HEXlabel },
    label: "#",
    value: hex.replace("#", ""),
    onChange: handleChange
  }), React__default.createElement("div", { style: styles2.fieldSymbols }, React__default.createElement("div", { style: styles2.symbol }, "\xB0"), React__default.createElement("div", { style: styles2.symbol }, "%"), React__default.createElement("div", { style: styles2.symbol }, "%")));
};
var PhotoshopPointerCircle$1 = function PhotoshopPointerCircle(_ref) {
  var hsl2 = _ref.hsl;
  var styles2 = _default$9({
    "default": {
      picker: {
        width: "12px",
        height: "12px",
        borderRadius: "6px",
        boxShadow: "inset 0 0 0 1px #fff",
        transform: "translate(-6px, -6px)"
      }
    },
    "black-outline": {
      picker: {
        boxShadow: "inset 0 0 0 1px #000"
      }
    }
  }, { "black-outline": hsl2.l > 0.5 });
  return React__default.createElement("div", { style: styles2.picker });
};
var PhotoshopPointerCircle2 = function PhotoshopPointerCircle3() {
  var styles2 = _default$9({
    "default": {
      triangle: {
        width: 0,
        height: 0,
        borderStyle: "solid",
        borderWidth: "4px 0 4px 6px",
        borderColor: "transparent transparent transparent #fff",
        position: "absolute",
        top: "1px",
        left: "1px"
      },
      triangleBorder: {
        width: 0,
        height: 0,
        borderStyle: "solid",
        borderWidth: "5px 0 5px 8px",
        borderColor: "transparent transparent transparent #555"
      },
      left: {
        Extend: "triangleBorder",
        transform: "translate(-13px, -4px)"
      },
      leftInside: {
        Extend: "triangle",
        transform: "translate(-8px, -5px)"
      },
      right: {
        Extend: "triangleBorder",
        transform: "translate(20px, -14px) rotate(180deg)"
      },
      rightInside: {
        Extend: "triangle",
        transform: "translate(-8px, -5px)"
      }
    }
  });
  return React__default.createElement("div", { style: styles2.pointer }, React__default.createElement("div", { style: styles2.left }, React__default.createElement("div", { style: styles2.leftInside })), React__default.createElement("div", { style: styles2.right }, React__default.createElement("div", { style: styles2.rightInside })));
};
var PhotoshopButton = function PhotoshopButton2(_ref) {
  var onClick = _ref.onClick, label = _ref.label, children = _ref.children, active3 = _ref.active;
  var styles2 = _default$9({
    "default": {
      button: {
        backgroundImage: "linear-gradient(-180deg, #FFFFFF 0%, #E6E6E6 100%)",
        border: "1px solid #878787",
        borderRadius: "2px",
        height: "20px",
        boxShadow: "0 1px 0 0 #EAEAEA",
        fontSize: "14px",
        color: "#000",
        lineHeight: "20px",
        textAlign: "center",
        marginBottom: "10px",
        cursor: "pointer"
      }
    },
    "active": {
      button: {
        boxShadow: "0 0 0 1px #878787"
      }
    }
  }, { active: active3 });
  return React__default.createElement("div", { style: styles2.button, onClick }, label || children);
};
var PhotoshopPreviews = function PhotoshopPreviews2(_ref) {
  var rgb2 = _ref.rgb, currentColor = _ref.currentColor;
  var styles2 = _default$9({
    "default": {
      swatches: {
        border: "1px solid #B3B3B3",
        borderBottom: "1px solid #F0F0F0",
        marginBottom: "2px",
        marginTop: "1px"
      },
      new: {
        height: "34px",
        background: "rgb(" + rgb2.r + "," + rgb2.g + ", " + rgb2.b + ")",
        boxShadow: "inset 1px 0 0 #000, inset -1px 0 0 #000, inset 0 1px 0 #000"
      },
      current: {
        height: "34px",
        background: currentColor,
        boxShadow: "inset 1px 0 0 #000, inset -1px 0 0 #000, inset 0 -1px 0 #000"
      },
      label: {
        fontSize: "14px",
        color: "#000",
        textAlign: "center"
      }
    }
  });
  return React__default.createElement("div", null, React__default.createElement("div", { style: styles2.label }, "new"), React__default.createElement("div", { style: styles2.swatches }, React__default.createElement("div", { style: styles2.new }), React__default.createElement("div", { style: styles2.current })), React__default.createElement("div", { style: styles2.label }, "current"));
};
var _createClass$4 = function() {
  function defineProperties(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  return function(Constructor, protoProps, staticProps) {
    if (protoProps)
      defineProperties(Constructor.prototype, protoProps);
    if (staticProps)
      defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();
function _classCallCheck$4(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _possibleConstructorReturn$3(self2, call2) {
  if (!self2) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return call2 && (typeof call2 === "object" || typeof call2 === "function") ? call2 : self2;
}
function _inherits$3(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });
  if (superClass)
    Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
}
var Photoshop = function(_React$Component) {
  _inherits$3(Photoshop2, _React$Component);
  function Photoshop2(props) {
    _classCallCheck$4(this, Photoshop2);
    var _this = _possibleConstructorReturn$3(this, (Photoshop2.__proto__ || Object.getPrototypeOf(Photoshop2)).call(this));
    _this.state = {
      currentColor: props.hex
    };
    return _this;
  }
  _createClass$4(Photoshop2, [{
    key: "render",
    value: function render4() {
      var _props = this.props, _props$styles = _props.styles, passedStyles = _props$styles === void 0 ? {} : _props$styles, _props$className = _props.className, className = _props$className === void 0 ? "" : _props$className;
      var styles2 = _default$9(merge$2({
        "default": {
          picker: {
            background: "#DCDCDC",
            borderRadius: "4px",
            boxShadow: "0 0 0 1px rgba(0,0,0,.25), 0 8px 16px rgba(0,0,0,.15)",
            boxSizing: "initial",
            width: "513px"
          },
          head: {
            backgroundImage: "linear-gradient(-180deg, #F0F0F0 0%, #D4D4D4 100%)",
            borderBottom: "1px solid #B1B1B1",
            boxShadow: "inset 0 1px 0 0 rgba(255,255,255,.2), inset 0 -1px 0 0 rgba(0,0,0,.02)",
            height: "23px",
            lineHeight: "24px",
            borderRadius: "4px 4px 0 0",
            fontSize: "13px",
            color: "#4D4D4D",
            textAlign: "center"
          },
          body: {
            padding: "15px 15px 0",
            display: "flex"
          },
          saturation: {
            width: "256px",
            height: "256px",
            position: "relative",
            border: "2px solid #B3B3B3",
            borderBottom: "2px solid #F0F0F0",
            overflow: "hidden"
          },
          hue: {
            position: "relative",
            height: "256px",
            width: "19px",
            marginLeft: "10px",
            border: "2px solid #B3B3B3",
            borderBottom: "2px solid #F0F0F0"
          },
          controls: {
            width: "180px",
            marginLeft: "10px"
          },
          top: {
            display: "flex"
          },
          previews: {
            width: "60px"
          },
          actions: {
            flex: "1",
            marginLeft: "20px"
          }
        }
      }, passedStyles));
      return React__default.createElement("div", { style: styles2.picker, className: "photoshop-picker " + className }, React__default.createElement("div", { style: styles2.head }, this.props.header), React__default.createElement("div", { style: styles2.body, className: "flexbox-fix" }, React__default.createElement("div", { style: styles2.saturation }, React__default.createElement(Saturation, {
        hsl: this.props.hsl,
        hsv: this.props.hsv,
        pointer: PhotoshopPointerCircle$1,
        onChange: this.props.onChange
      })), React__default.createElement("div", { style: styles2.hue }, React__default.createElement(Hue, {
        direction: "vertical",
        hsl: this.props.hsl,
        pointer: PhotoshopPointerCircle2,
        onChange: this.props.onChange
      })), React__default.createElement("div", { style: styles2.controls }, React__default.createElement("div", { style: styles2.top, className: "flexbox-fix" }, React__default.createElement("div", { style: styles2.previews }, React__default.createElement(PhotoshopPreviews, {
        rgb: this.props.rgb,
        currentColor: this.state.currentColor
      })), React__default.createElement("div", { style: styles2.actions }, React__default.createElement(PhotoshopButton, { label: "OK", onClick: this.props.onAccept, active: true }), React__default.createElement(PhotoshopButton, { label: "Cancel", onClick: this.props.onCancel }), React__default.createElement(PhotoshopPicker, {
        onChange: this.props.onChange,
        rgb: this.props.rgb,
        hsv: this.props.hsv,
        hex: this.props.hex
      }))))));
    }
  }]);
  return Photoshop2;
}(React__default.Component);
Photoshop.propTypes = {
  header: PropTypes.string,
  styles: PropTypes.object
};
Photoshop.defaultProps = {
  header: "Color Picker",
  styles: {}
};
ColorWrap(Photoshop);
var SketchFields = function SketchFields2(_ref) {
  var onChange2 = _ref.onChange, rgb2 = _ref.rgb, hsl2 = _ref.hsl, hex = _ref.hex, disableAlpha = _ref.disableAlpha;
  var styles2 = _default$9({
    "default": {
      fields: {
        display: "flex",
        paddingTop: "4px"
      },
      single: {
        flex: "1",
        paddingLeft: "6px"
      },
      alpha: {
        flex: "1",
        paddingLeft: "6px"
      },
      double: {
        flex: "2"
      },
      input: {
        width: "80%",
        padding: "4px 10% 3px",
        border: "none",
        boxShadow: "inset 0 0 0 1px #ccc",
        fontSize: "11px"
      },
      label: {
        display: "block",
        textAlign: "center",
        fontSize: "11px",
        color: "#222",
        paddingTop: "3px",
        paddingBottom: "4px",
        textTransform: "capitalize"
      }
    },
    "disableAlpha": {
      alpha: {
        display: "none"
      }
    }
  }, { disableAlpha });
  var handleChange = function handleChange2(data2, e3) {
    if (data2.hex) {
      isValidHex(data2.hex) && onChange2({
        hex: data2.hex,
        source: "hex"
      }, e3);
    } else if (data2.r || data2.g || data2.b) {
      onChange2({
        r: data2.r || rgb2.r,
        g: data2.g || rgb2.g,
        b: data2.b || rgb2.b,
        a: rgb2.a,
        source: "rgb"
      }, e3);
    } else if (data2.a) {
      if (data2.a < 0) {
        data2.a = 0;
      } else if (data2.a > 100) {
        data2.a = 100;
      }
      data2.a /= 100;
      onChange2({
        h: hsl2.h,
        s: hsl2.s,
        l: hsl2.l,
        a: data2.a,
        source: "rgb"
      }, e3);
    }
  };
  return React__default.createElement("div", { style: styles2.fields, className: "flexbox-fix" }, React__default.createElement("div", { style: styles2.double }, React__default.createElement(EditableInput, {
    style: { input: styles2.input, label: styles2.label },
    label: "hex",
    value: hex.replace("#", ""),
    onChange: handleChange
  })), React__default.createElement("div", { style: styles2.single }, React__default.createElement(EditableInput, {
    style: { input: styles2.input, label: styles2.label },
    label: "r",
    value: rgb2.r,
    onChange: handleChange,
    dragLabel: "true",
    dragMax: "255"
  })), React__default.createElement("div", { style: styles2.single }, React__default.createElement(EditableInput, {
    style: { input: styles2.input, label: styles2.label },
    label: "g",
    value: rgb2.g,
    onChange: handleChange,
    dragLabel: "true",
    dragMax: "255"
  })), React__default.createElement("div", { style: styles2.single }, React__default.createElement(EditableInput, {
    style: { input: styles2.input, label: styles2.label },
    label: "b",
    value: rgb2.b,
    onChange: handleChange,
    dragLabel: "true",
    dragMax: "255"
  })), React__default.createElement("div", { style: styles2.alpha }, React__default.createElement(EditableInput, {
    style: { input: styles2.input, label: styles2.label },
    label: "a",
    value: Math.round(rgb2.a * 100),
    onChange: handleChange,
    dragLabel: "true",
    dragMax: "100"
  })));
};
var _extends$3 = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var SketchPresetColors = function SketchPresetColors2(_ref) {
  var colors2 = _ref.colors, _ref$onClick = _ref.onClick, onClick = _ref$onClick === void 0 ? function() {
  } : _ref$onClick, onSwatchHover = _ref.onSwatchHover;
  var styles2 = _default$9({
    "default": {
      colors: {
        margin: "0 -10px",
        padding: "10px 0 0 10px",
        borderTop: "1px solid #eee",
        display: "flex",
        flexWrap: "wrap",
        position: "relative"
      },
      swatchWrap: {
        width: "16px",
        height: "16px",
        margin: "0 10px 10px 0"
      },
      swatch: {
        borderRadius: "3px",
        boxShadow: "inset 0 0 0 1px rgba(0,0,0,.15)"
      }
    },
    "no-presets": {
      colors: {
        display: "none"
      }
    }
  }, {
    "no-presets": !colors2 || !colors2.length
  });
  var handleClick = function handleClick2(hex, e3) {
    onClick({
      hex,
      source: "hex"
    }, e3);
  };
  return React__default.createElement("div", { style: styles2.colors, className: "flexbox-fix" }, colors2.map(function(colorObjOrString) {
    var c7 = typeof colorObjOrString === "string" ? { color: colorObjOrString } : colorObjOrString;
    var key = "" + c7.color + (c7.title || "");
    return React__default.createElement("div", { key, style: styles2.swatchWrap }, React__default.createElement(Swatch$1, _extends$3({}, c7, {
      style: styles2.swatch,
      onClick: handleClick,
      onHover: onSwatchHover,
      focusStyle: {
        boxShadow: "inset 0 0 0 1px rgba(0,0,0,.15), 0 0 4px " + c7.color
      }
    })));
  }));
};
SketchPresetColors.propTypes = {
  colors: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.shape({
    color: PropTypes.string,
    title: PropTypes.string
  })])).isRequired
};
var _extends$2 = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var Sketch = function Sketch2(_ref) {
  var width = _ref.width, rgb2 = _ref.rgb, hex = _ref.hex, hsv = _ref.hsv, hsl2 = _ref.hsl, onChange2 = _ref.onChange, onSwatchHover = _ref.onSwatchHover, disableAlpha = _ref.disableAlpha, presetColors = _ref.presetColors, renderers = _ref.renderers, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className;
  var styles2 = _default$9(merge$2({
    "default": _extends$2({
      picker: {
        width,
        padding: "10px 10px 0",
        boxSizing: "initial",
        background: "#fff",
        borderRadius: "4px",
        boxShadow: "0 0 0 1px rgba(0,0,0,.15), 0 8px 16px rgba(0,0,0,.15)"
      },
      saturation: {
        width: "100%",
        paddingBottom: "75%",
        position: "relative",
        overflow: "hidden"
      },
      Saturation: {
        radius: "3px",
        shadow: "inset 0 0 0 1px rgba(0,0,0,.15), inset 0 0 4px rgba(0,0,0,.25)"
      },
      controls: {
        display: "flex"
      },
      sliders: {
        padding: "4px 0",
        flex: "1"
      },
      color: {
        width: "24px",
        height: "24px",
        position: "relative",
        marginTop: "4px",
        marginLeft: "4px",
        borderRadius: "3px"
      },
      activeColor: {
        absolute: "0px 0px 0px 0px",
        borderRadius: "2px",
        background: "rgba(" + rgb2.r + "," + rgb2.g + "," + rgb2.b + "," + rgb2.a + ")",
        boxShadow: "inset 0 0 0 1px rgba(0,0,0,.15), inset 0 0 4px rgba(0,0,0,.25)"
      },
      hue: {
        position: "relative",
        height: "10px",
        overflow: "hidden"
      },
      Hue: {
        radius: "2px",
        shadow: "inset 0 0 0 1px rgba(0,0,0,.15), inset 0 0 4px rgba(0,0,0,.25)"
      },
      alpha: {
        position: "relative",
        height: "10px",
        marginTop: "4px",
        overflow: "hidden"
      },
      Alpha: {
        radius: "2px",
        shadow: "inset 0 0 0 1px rgba(0,0,0,.15), inset 0 0 4px rgba(0,0,0,.25)"
      }
    }, passedStyles),
    "disableAlpha": {
      color: {
        height: "10px"
      },
      hue: {
        height: "10px"
      },
      alpha: {
        display: "none"
      }
    }
  }, passedStyles), { disableAlpha });
  return React__default.createElement("div", { style: styles2.picker, className: "sketch-picker " + className }, React__default.createElement("div", { style: styles2.saturation }, React__default.createElement(Saturation, {
    style: styles2.Saturation,
    hsl: hsl2,
    hsv,
    onChange: onChange2
  })), React__default.createElement("div", { style: styles2.controls, className: "flexbox-fix" }, React__default.createElement("div", { style: styles2.sliders }, React__default.createElement("div", { style: styles2.hue }, React__default.createElement(Hue, {
    style: styles2.Hue,
    hsl: hsl2,
    onChange: onChange2
  })), React__default.createElement("div", { style: styles2.alpha }, React__default.createElement(Alpha, {
    style: styles2.Alpha,
    rgb: rgb2,
    hsl: hsl2,
    renderers,
    onChange: onChange2
  }))), React__default.createElement("div", { style: styles2.color }, React__default.createElement(Checkboard, null), React__default.createElement("div", { style: styles2.activeColor }))), React__default.createElement(SketchFields, {
    rgb: rgb2,
    hsl: hsl2,
    hex,
    onChange: onChange2,
    disableAlpha
  }), React__default.createElement(SketchPresetColors, {
    colors: presetColors,
    onClick: onChange2,
    onSwatchHover
  }));
};
Sketch.propTypes = {
  disableAlpha: PropTypes.bool,
  width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  styles: PropTypes.object
};
Sketch.defaultProps = {
  disableAlpha: false,
  width: 200,
  styles: {},
  presetColors: ["#D0021B", "#F5A623", "#F8E71C", "#8B572A", "#7ED321", "#417505", "#BD10E0", "#9013FE", "#4A90E2", "#50E3C2", "#B8E986", "#000000", "#4A4A4A", "#9B9B9B", "#FFFFFF"]
};
ColorWrap(Sketch);
var SliderSwatch = function SliderSwatch2(_ref) {
  var hsl2 = _ref.hsl, offset4 = _ref.offset, _ref$onClick = _ref.onClick, onClick = _ref$onClick === void 0 ? function() {
  } : _ref$onClick, active3 = _ref.active, first = _ref.first, last = _ref.last;
  var styles2 = _default$9({
    "default": {
      swatch: {
        height: "12px",
        background: "hsl(" + hsl2.h + ", 50%, " + offset4 * 100 + "%)",
        cursor: "pointer"
      }
    },
    "first": {
      swatch: {
        borderRadius: "2px 0 0 2px"
      }
    },
    "last": {
      swatch: {
        borderRadius: "0 2px 2px 0"
      }
    },
    "active": {
      swatch: {
        transform: "scaleY(1.8)",
        borderRadius: "3.6px/2px"
      }
    }
  }, { active: active3, first, last });
  var handleClick = function handleClick2(e3) {
    return onClick({
      h: hsl2.h,
      s: 0.5,
      l: offset4,
      source: "hsl"
    }, e3);
  };
  return React__default.createElement("div", { style: styles2.swatch, onClick: handleClick });
};
var SliderSwatches = function SliderSwatches2(_ref) {
  var onClick = _ref.onClick, hsl2 = _ref.hsl;
  var styles2 = _default$9({
    "default": {
      swatches: {
        marginTop: "20px"
      },
      swatch: {
        boxSizing: "border-box",
        width: "20%",
        paddingRight: "1px",
        float: "left"
      },
      clear: {
        clear: "both"
      }
    }
  });
  var epsilon = 0.1;
  return React__default.createElement("div", { style: styles2.swatches }, React__default.createElement("div", { style: styles2.swatch }, React__default.createElement(SliderSwatch, {
    hsl: hsl2,
    offset: ".80",
    active: Math.abs(hsl2.l - 0.8) < epsilon && Math.abs(hsl2.s - 0.5) < epsilon,
    onClick,
    first: true
  })), React__default.createElement("div", { style: styles2.swatch }, React__default.createElement(SliderSwatch, {
    hsl: hsl2,
    offset: ".65",
    active: Math.abs(hsl2.l - 0.65) < epsilon && Math.abs(hsl2.s - 0.5) < epsilon,
    onClick
  })), React__default.createElement("div", { style: styles2.swatch }, React__default.createElement(SliderSwatch, {
    hsl: hsl2,
    offset: ".50",
    active: Math.abs(hsl2.l - 0.5) < epsilon && Math.abs(hsl2.s - 0.5) < epsilon,
    onClick
  })), React__default.createElement("div", { style: styles2.swatch }, React__default.createElement(SliderSwatch, {
    hsl: hsl2,
    offset: ".35",
    active: Math.abs(hsl2.l - 0.35) < epsilon && Math.abs(hsl2.s - 0.5) < epsilon,
    onClick
  })), React__default.createElement("div", { style: styles2.swatch }, React__default.createElement(SliderSwatch, {
    hsl: hsl2,
    offset: ".20",
    active: Math.abs(hsl2.l - 0.2) < epsilon && Math.abs(hsl2.s - 0.5) < epsilon,
    onClick,
    last: true
  })), React__default.createElement("div", { style: styles2.clear }));
};
var SliderPointer2 = function SliderPointer3() {
  var styles2 = _default$9({
    "default": {
      picker: {
        width: "14px",
        height: "14px",
        borderRadius: "6px",
        transform: "translate(-7px, -1px)",
        backgroundColor: "rgb(248, 248, 248)",
        boxShadow: "0 1px 4px 0 rgba(0, 0, 0, 0.37)"
      }
    }
  });
  return React__default.createElement("div", { style: styles2.picker });
};
var Slider = function Slider2(_ref) {
  var hsl2 = _ref.hsl, onChange2 = _ref.onChange, pointer = _ref.pointer, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className;
  var styles2 = _default$9(merge$2({
    "default": {
      hue: {
        height: "12px",
        position: "relative"
      },
      Hue: {
        radius: "2px"
      }
    }
  }, passedStyles));
  return React__default.createElement("div", { style: styles2.wrap || {}, className: "slider-picker " + className }, React__default.createElement("div", { style: styles2.hue }, React__default.createElement(Hue, {
    style: styles2.Hue,
    hsl: hsl2,
    pointer,
    onChange: onChange2
  })), React__default.createElement("div", { style: styles2.swatches }, React__default.createElement(SliderSwatches, { hsl: hsl2, onClick: onChange2 })));
};
Slider.propTypes = {
  styles: PropTypes.object
};
Slider.defaultProps = {
  pointer: SliderPointer2,
  styles: {}
};
ColorWrap(Slider);
var CheckIcon = {};
Object.defineProperty(CheckIcon, "__esModule", {
  value: true
});
var _extends$1 = Object.assign || function(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source2 = arguments[i2];
    for (var key in source2) {
      if (Object.prototype.hasOwnProperty.call(source2, key)) {
        target[key] = source2[key];
      }
    }
  }
  return target;
};
var _react$1 = React__default;
var _react2 = _interopRequireDefault$7(_react$1);
function _interopRequireDefault$7(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}
function _objectWithoutProperties$2(obj, keys2) {
  var target = {};
  for (var i2 in obj) {
    if (keys2.indexOf(i2) >= 0)
      continue;
    if (!Object.prototype.hasOwnProperty.call(obj, i2))
      continue;
    target[i2] = obj[i2];
  }
  return target;
}
var DEFAULT_SIZE$2 = 24;
var _default$7 = CheckIcon.default = function(_ref) {
  var _ref$fill = _ref.fill, fill = _ref$fill === void 0 ? "currentColor" : _ref$fill, _ref$width = _ref.width, width = _ref$width === void 0 ? DEFAULT_SIZE$2 : _ref$width, _ref$height = _ref.height, height = _ref$height === void 0 ? DEFAULT_SIZE$2 : _ref$height, _ref$style = _ref.style, style2 = _ref$style === void 0 ? {} : _ref$style, props = _objectWithoutProperties$2(_ref, ["fill", "width", "height", "style"]);
  return _react2.default.createElement("svg", _extends$1({
    viewBox: "0 0 " + DEFAULT_SIZE$2 + " " + DEFAULT_SIZE$2,
    style: _extends$1({ fill, width, height }, style2)
  }, props), _react2.default.createElement("path", { d: "M21,7L9,19L3.5,13.5L4.91,12.09L9,16.17L19.59,5.59L21,7Z" }));
};
var SwatchesColor = function SwatchesColor2(_ref) {
  var color = _ref.color, _ref$onClick = _ref.onClick, onClick = _ref$onClick === void 0 ? function() {
  } : _ref$onClick, onSwatchHover = _ref.onSwatchHover, first = _ref.first, last = _ref.last, active3 = _ref.active;
  var styles2 = _default$9({
    "default": {
      color: {
        width: "40px",
        height: "24px",
        cursor: "pointer",
        background: color,
        marginBottom: "1px"
      },
      check: {
        color: getContrastingColor(color),
        marginLeft: "8px",
        display: "none"
      }
    },
    "first": {
      color: {
        overflow: "hidden",
        borderRadius: "2px 2px 0 0"
      }
    },
    "last": {
      color: {
        overflow: "hidden",
        borderRadius: "0 0 2px 2px"
      }
    },
    "active": {
      check: {
        display: "block"
      }
    },
    "color-#FFFFFF": {
      color: {
        boxShadow: "inset 0 0 0 1px #ddd"
      },
      check: {
        color: "#333"
      }
    },
    "transparent": {
      check: {
        color: "#333"
      }
    }
  }, {
    first,
    last,
    active: active3,
    "color-#FFFFFF": color === "#FFFFFF",
    "transparent": color === "transparent"
  });
  return React__default.createElement(Swatch$1, {
    color,
    style: styles2.color,
    onClick,
    onHover: onSwatchHover,
    focusStyle: { boxShadow: "0 0 4px " + color }
  }, React__default.createElement("div", { style: styles2.check }, React__default.createElement(_default$7, null)));
};
var SwatchesGroup = function SwatchesGroup2(_ref) {
  var onClick = _ref.onClick, onSwatchHover = _ref.onSwatchHover, group = _ref.group, active3 = _ref.active;
  var styles2 = _default$9({
    "default": {
      group: {
        paddingBottom: "10px",
        width: "40px",
        float: "left",
        marginRight: "10px"
      }
    }
  });
  return React__default.createElement("div", { style: styles2.group }, map(group, function(color, i2) {
    return React__default.createElement(SwatchesColor, {
      key: color,
      color,
      active: color.toLowerCase() === active3,
      first: i2 === 0,
      last: i2 === group.length - 1,
      onClick,
      onSwatchHover
    });
  }));
};
var Swatches = function Swatches2(_ref) {
  var width = _ref.width, height = _ref.height, onChange2 = _ref.onChange, onSwatchHover = _ref.onSwatchHover, colors2 = _ref.colors, hex = _ref.hex, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className;
  var styles2 = _default$9(merge$2({
    "default": {
      picker: {
        width,
        height
      },
      overflow: {
        height,
        overflowY: "scroll"
      },
      body: {
        padding: "16px 0 6px 16px"
      },
      clear: {
        clear: "both"
      }
    }
  }, passedStyles));
  var handleChange = function handleChange2(data2, e3) {
    return onChange2({ hex: data2, source: "hex" }, e3);
  };
  return React__default.createElement("div", { style: styles2.picker, className: "swatches-picker " + className }, React__default.createElement(Raised, null, React__default.createElement("div", { style: styles2.overflow }, React__default.createElement("div", { style: styles2.body }, map(colors2, function(group) {
    return React__default.createElement(SwatchesGroup, {
      key: group.toString(),
      group,
      active: hex,
      onClick: handleChange,
      onSwatchHover
    });
  }), React__default.createElement("div", { style: styles2.clear })))));
};
Swatches.propTypes = {
  width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  height: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  colors: PropTypes.arrayOf(PropTypes.arrayOf(PropTypes.string)),
  styles: PropTypes.object
};
Swatches.defaultProps = {
  width: 320,
  height: 240,
  colors: [[red["900"], red["700"], red["500"], red["300"], red["100"]], [pink["900"], pink["700"], pink["500"], pink["300"], pink["100"]], [purple["900"], purple["700"], purple["500"], purple["300"], purple["100"]], [deepPurple["900"], deepPurple["700"], deepPurple["500"], deepPurple["300"], deepPurple["100"]], [indigo["900"], indigo["700"], indigo["500"], indigo["300"], indigo["100"]], [blue["900"], blue["700"], blue["500"], blue["300"], blue["100"]], [lightBlue["900"], lightBlue["700"], lightBlue["500"], lightBlue["300"], lightBlue["100"]], [cyan["900"], cyan["700"], cyan["500"], cyan["300"], cyan["100"]], [teal["900"], teal["700"], teal["500"], teal["300"], teal["100"]], ["#194D33", green["700"], green["500"], green["300"], green["100"]], [lightGreen["900"], lightGreen["700"], lightGreen["500"], lightGreen["300"], lightGreen["100"]], [lime["900"], lime["700"], lime["500"], lime["300"], lime["100"]], [yellow["900"], yellow["700"], yellow["500"], yellow["300"], yellow["100"]], [amber["900"], amber["700"], amber["500"], amber["300"], amber["100"]], [orange["900"], orange["700"], orange["500"], orange["300"], orange["100"]], [deepOrange["900"], deepOrange["700"], deepOrange["500"], deepOrange["300"], deepOrange["100"]], [brown["900"], brown["700"], brown["500"], brown["300"], brown["100"]], [blueGrey["900"], blueGrey["700"], blueGrey["500"], blueGrey["300"], blueGrey["100"]], ["#000000", "#525252", "#969696", "#D9D9D9", "#FFFFFF"]],
  styles: {}
};
ColorWrap(Swatches);
var Twitter = function Twitter2(_ref) {
  var onChange2 = _ref.onChange, onSwatchHover = _ref.onSwatchHover, hex = _ref.hex, colors2 = _ref.colors, width = _ref.width, triangle = _ref.triangle, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className;
  var styles2 = _default$9(merge$2({
    "default": {
      card: {
        width,
        background: "#fff",
        border: "0 solid rgba(0,0,0,0.25)",
        boxShadow: "0 1px 4px rgba(0,0,0,0.25)",
        borderRadius: "4px",
        position: "relative"
      },
      body: {
        padding: "15px 9px 9px 15px"
      },
      label: {
        fontSize: "18px",
        color: "#fff"
      },
      triangle: {
        width: "0px",
        height: "0px",
        borderStyle: "solid",
        borderWidth: "0 9px 10px 9px",
        borderColor: "transparent transparent #fff transparent",
        position: "absolute"
      },
      triangleShadow: {
        width: "0px",
        height: "0px",
        borderStyle: "solid",
        borderWidth: "0 9px 10px 9px",
        borderColor: "transparent transparent rgba(0,0,0,.1) transparent",
        position: "absolute"
      },
      hash: {
        background: "#F0F0F0",
        height: "30px",
        width: "30px",
        borderRadius: "4px 0 0 4px",
        float: "left",
        color: "#98A1A4",
        display: "flex",
        alignItems: "center",
        justifyContent: "center"
      },
      input: {
        width: "100px",
        fontSize: "14px",
        color: "#666",
        border: "0px",
        outline: "none",
        height: "28px",
        boxShadow: "inset 0 0 0 1px #F0F0F0",
        boxSizing: "content-box",
        borderRadius: "0 4px 4px 0",
        float: "left",
        paddingLeft: "8px"
      },
      swatch: {
        width: "30px",
        height: "30px",
        float: "left",
        borderRadius: "4px",
        margin: "0 6px 6px 0"
      },
      clear: {
        clear: "both"
      }
    },
    "hide-triangle": {
      triangle: {
        display: "none"
      },
      triangleShadow: {
        display: "none"
      }
    },
    "top-left-triangle": {
      triangle: {
        top: "-10px",
        left: "12px"
      },
      triangleShadow: {
        top: "-11px",
        left: "12px"
      }
    },
    "top-right-triangle": {
      triangle: {
        top: "-10px",
        right: "12px"
      },
      triangleShadow: {
        top: "-11px",
        right: "12px"
      }
    }
  }, passedStyles), {
    "hide-triangle": triangle === "hide",
    "top-left-triangle": triangle === "top-left",
    "top-right-triangle": triangle === "top-right"
  });
  var handleChange = function handleChange2(hexcode, e3) {
    isValidHex(hexcode) && onChange2({
      hex: hexcode,
      source: "hex"
    }, e3);
  };
  return React__default.createElement("div", { style: styles2.card, className: "twitter-picker " + className }, React__default.createElement("div", { style: styles2.triangleShadow }), React__default.createElement("div", { style: styles2.triangle }), React__default.createElement("div", { style: styles2.body }, map(colors2, function(c7, i2) {
    return React__default.createElement(Swatch$1, {
      key: i2,
      color: c7,
      hex: c7,
      style: styles2.swatch,
      onClick: handleChange,
      onHover: onSwatchHover,
      focusStyle: {
        boxShadow: "0 0 4px " + c7
      }
    });
  }), React__default.createElement("div", { style: styles2.hash }, "#"), React__default.createElement(EditableInput, {
    label: null,
    style: { input: styles2.input },
    value: hex.replace("#", ""),
    onChange: handleChange
  }), React__default.createElement("div", { style: styles2.clear })));
};
Twitter.propTypes = {
  width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  triangle: PropTypes.oneOf(["hide", "top-left", "top-right"]),
  colors: PropTypes.arrayOf(PropTypes.string),
  styles: PropTypes.object
};
Twitter.defaultProps = {
  width: 276,
  colors: ["#FF6900", "#FCB900", "#7BDCB5", "#00D084", "#8ED1FC", "#0693E3", "#ABB8C3", "#EB144C", "#F78DA7", "#9900EF"],
  triangle: "top-left",
  styles: {}
};
ColorWrap(Twitter);
var GooglePointerCircle = function GooglePointerCircle2(props) {
  var styles2 = _default$9({
    "default": {
      picker: {
        width: "20px",
        height: "20px",
        borderRadius: "22px",
        border: "2px #fff solid",
        transform: "translate(-12px, -13px)",
        background: "hsl(" + Math.round(props.hsl.h) + ", " + Math.round(props.hsl.s * 100) + "%, " + Math.round(props.hsl.l * 100) + "%)"
      }
    }
  });
  return React__default.createElement("div", { style: styles2.picker });
};
GooglePointerCircle.propTypes = {
  hsl: PropTypes.shape({
    h: PropTypes.number,
    s: PropTypes.number,
    l: PropTypes.number,
    a: PropTypes.number
  })
};
GooglePointerCircle.defaultProps = {
  hsl: { a: 1, h: 249.94, l: 0.2, s: 0.5 }
};
var GooglePointer = function GooglePointer2(props) {
  var styles2 = _default$9({
    "default": {
      picker: {
        width: "20px",
        height: "20px",
        borderRadius: "22px",
        transform: "translate(-10px, -7px)",
        background: "hsl(" + Math.round(props.hsl.h) + ", 100%, 50%)",
        border: "2px white solid"
      }
    }
  });
  return React__default.createElement("div", { style: styles2.picker });
};
GooglePointer.propTypes = {
  hsl: PropTypes.shape({
    h: PropTypes.number,
    s: PropTypes.number,
    l: PropTypes.number,
    a: PropTypes.number
  })
};
GooglePointer.defaultProps = {
  hsl: { a: 1, h: 249.94, l: 0.2, s: 0.5 }
};
var GoogleFields = function GoogleFields2(_ref) {
  var onChange2 = _ref.onChange, rgb2 = _ref.rgb, hsl2 = _ref.hsl, hex = _ref.hex, hsv = _ref.hsv;
  var handleChange = function handleChange2(data2, e3) {
    if (data2.hex) {
      isValidHex(data2.hex) && onChange2({
        hex: data2.hex,
        source: "hex"
      }, e3);
    } else if (data2.rgb) {
      var values2 = data2.rgb.split(",");
      isvalidColorString(data2.rgb, "rgb") && onChange2({
        r: values2[0],
        g: values2[1],
        b: values2[2],
        a: 1,
        source: "rgb"
      }, e3);
    } else if (data2.hsv) {
      var _values = data2.hsv.split(",");
      if (isvalidColorString(data2.hsv, "hsv")) {
        _values[2] = _values[2].replace("%", "");
        _values[1] = _values[1].replace("%", "");
        _values[0] = _values[0].replace("\xB0", "");
        if (_values[1] == 1) {
          _values[1] = 0.01;
        } else if (_values[2] == 1) {
          _values[2] = 0.01;
        }
        onChange2({
          h: Number(_values[0]),
          s: Number(_values[1]),
          v: Number(_values[2]),
          source: "hsv"
        }, e3);
      }
    } else if (data2.hsl) {
      var _values2 = data2.hsl.split(",");
      if (isvalidColorString(data2.hsl, "hsl")) {
        _values2[2] = _values2[2].replace("%", "");
        _values2[1] = _values2[1].replace("%", "");
        _values2[0] = _values2[0].replace("\xB0", "");
        if (hsvValue[1] == 1) {
          hsvValue[1] = 0.01;
        } else if (hsvValue[2] == 1) {
          hsvValue[2] = 0.01;
        }
        onChange2({
          h: Number(_values2[0]),
          s: Number(_values2[1]),
          v: Number(_values2[2]),
          source: "hsl"
        }, e3);
      }
    }
  };
  var styles2 = _default$9({
    "default": {
      wrap: {
        display: "flex",
        height: "100px",
        marginTop: "4px"
      },
      fields: {
        width: "100%"
      },
      column: {
        paddingTop: "10px",
        display: "flex",
        justifyContent: "space-between"
      },
      double: {
        padding: "0px 4.4px",
        boxSizing: "border-box"
      },
      input: {
        width: "100%",
        height: "38px",
        boxSizing: "border-box",
        padding: "4px 10% 3px",
        textAlign: "center",
        border: "1px solid #dadce0",
        fontSize: "11px",
        textTransform: "lowercase",
        borderRadius: "5px",
        outline: "none",
        fontFamily: "Roboto,Arial,sans-serif"
      },
      input2: {
        height: "38px",
        width: "100%",
        border: "1px solid #dadce0",
        boxSizing: "border-box",
        fontSize: "11px",
        textTransform: "lowercase",
        borderRadius: "5px",
        outline: "none",
        paddingLeft: "10px",
        fontFamily: "Roboto,Arial,sans-serif"
      },
      label: {
        textAlign: "center",
        fontSize: "12px",
        background: "#fff",
        position: "absolute",
        textTransform: "uppercase",
        color: "#3c4043",
        width: "35px",
        top: "-6px",
        left: "0",
        right: "0",
        marginLeft: "auto",
        marginRight: "auto",
        fontFamily: "Roboto,Arial,sans-serif"
      },
      label2: {
        left: "10px",
        textAlign: "center",
        fontSize: "12px",
        background: "#fff",
        position: "absolute",
        textTransform: "uppercase",
        color: "#3c4043",
        width: "32px",
        top: "-6px",
        fontFamily: "Roboto,Arial,sans-serif"
      },
      single: {
        flexGrow: "1",
        margin: "0px 4.4px"
      }
    }
  });
  var rgbValue = rgb2.r + ", " + rgb2.g + ", " + rgb2.b;
  var hslValue = Math.round(hsl2.h) + "\xB0, " + Math.round(hsl2.s * 100) + "%, " + Math.round(hsl2.l * 100) + "%";
  var hsvValue = Math.round(hsv.h) + "\xB0, " + Math.round(hsv.s * 100) + "%, " + Math.round(hsv.v * 100) + "%";
  return React__default.createElement("div", { style: styles2.wrap, className: "flexbox-fix" }, React__default.createElement("div", { style: styles2.fields }, React__default.createElement("div", { style: styles2.double }, React__default.createElement(EditableInput, {
    style: { input: styles2.input, label: styles2.label },
    label: "hex",
    value: hex,
    onChange: handleChange
  })), React__default.createElement("div", { style: styles2.column }, React__default.createElement("div", { style: styles2.single }, React__default.createElement(EditableInput, {
    style: { input: styles2.input2, label: styles2.label2 },
    label: "rgb",
    value: rgbValue,
    onChange: handleChange
  })), React__default.createElement("div", { style: styles2.single }, React__default.createElement(EditableInput, {
    style: { input: styles2.input2, label: styles2.label2 },
    label: "hsv",
    value: hsvValue,
    onChange: handleChange
  })), React__default.createElement("div", { style: styles2.single }, React__default.createElement(EditableInput, {
    style: { input: styles2.input2, label: styles2.label2 },
    label: "hsl",
    value: hslValue,
    onChange: handleChange
  })))));
};
var Google = function Google2(_ref) {
  var width = _ref.width, onChange2 = _ref.onChange, rgb2 = _ref.rgb, hsl2 = _ref.hsl, hsv = _ref.hsv, hex = _ref.hex, header2 = _ref.header, _ref$styles = _ref.styles, passedStyles = _ref$styles === void 0 ? {} : _ref$styles, _ref$className = _ref.className, className = _ref$className === void 0 ? "" : _ref$className;
  var styles2 = _default$9(merge$2({
    "default": {
      picker: {
        width,
        background: "#fff",
        border: "1px solid #dfe1e5",
        boxSizing: "initial",
        display: "flex",
        flexWrap: "wrap",
        borderRadius: "8px 8px 0px 0px"
      },
      head: {
        height: "57px",
        width: "100%",
        paddingTop: "16px",
        paddingBottom: "16px",
        paddingLeft: "16px",
        fontSize: "20px",
        boxSizing: "border-box",
        fontFamily: "Roboto-Regular,HelveticaNeue,Arial,sans-serif"
      },
      saturation: {
        width: "70%",
        padding: "0px",
        position: "relative",
        overflow: "hidden"
      },
      swatch: {
        width: "30%",
        height: "228px",
        padding: "0px",
        background: "rgba(" + rgb2.r + ", " + rgb2.g + ", " + rgb2.b + ", 1)",
        position: "relative",
        overflow: "hidden"
      },
      body: {
        margin: "auto",
        width: "95%"
      },
      controls: {
        display: "flex",
        boxSizing: "border-box",
        height: "52px",
        paddingTop: "22px"
      },
      color: {
        width: "32px"
      },
      hue: {
        height: "8px",
        position: "relative",
        margin: "0px 16px 0px 16px",
        width: "100%"
      },
      Hue: {
        radius: "2px"
      }
    }
  }, passedStyles));
  return React__default.createElement("div", { style: styles2.picker, className: "google-picker " + className }, React__default.createElement("div", { style: styles2.head }, header2), React__default.createElement("div", { style: styles2.swatch }), React__default.createElement("div", { style: styles2.saturation }, React__default.createElement(Saturation, {
    hsl: hsl2,
    hsv,
    pointer: GooglePointerCircle,
    onChange: onChange2
  })), React__default.createElement("div", { style: styles2.body }, React__default.createElement("div", { style: styles2.controls, className: "flexbox-fix" }, React__default.createElement("div", { style: styles2.hue }, React__default.createElement(Hue, {
    style: styles2.Hue,
    hsl: hsl2,
    radius: "4px",
    pointer: GooglePointer,
    onChange: onChange2
  }))), React__default.createElement(GoogleFields, {
    rgb: rgb2,
    hsl: hsl2,
    hex,
    hsv,
    onChange: onChange2
  })));
};
Google.propTypes = {
  width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  styles: PropTypes.object,
  header: PropTypes.string
};
Google.defaultProps = {
  width: 652,
  styles: {},
  header: "Color picker"
};
ColorWrap(Google);
var top = "top";
var bottom = "bottom";
var right = "right";
var left = "left";
var auto = "auto";
var basePlacements = [top, bottom, right, left];
var start = "start";
var end$1 = "end";
var clippingParents = "clippingParents";
var viewport = "viewport";
var popper = "popper";
var reference = "reference";
var variationPlacements = /* @__PURE__ */ basePlacements.reduce(function(acc, placement) {
  return acc.concat([placement + "-" + start, placement + "-" + end$1]);
}, []);
var placements$2 = /* @__PURE__ */ [].concat(basePlacements, [auto]).reduce(function(acc, placement) {
  return acc.concat([placement, placement + "-" + start, placement + "-" + end$1]);
}, []);
var beforeRead = "beforeRead";
var read = "read";
var afterRead = "afterRead";
var beforeMain = "beforeMain";
var main = "main";
var afterMain = "afterMain";
var beforeWrite = "beforeWrite";
var write = "write";
var afterWrite = "afterWrite";
var modifierPhases = [beforeRead, read, afterRead, beforeMain, main, afterMain, beforeWrite, write, afterWrite];
function getNodeName(element) {
  return element ? (element.nodeName || "").toLowerCase() : null;
}
function getWindow$1(node) {
  if (node == null) {
    return window;
  }
  if (node.toString() !== "[object Window]") {
    var ownerDocument = node.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView || window : window;
  }
  return node;
}
function isElement$2(node) {
  var OwnElement = getWindow$1(node).Element;
  return node instanceof OwnElement || node instanceof Element;
}
function isHTMLElement$1(node) {
  var OwnElement = getWindow$1(node).HTMLElement;
  return node instanceof OwnElement || node instanceof HTMLElement;
}
function isShadowRoot(node) {
  if (typeof ShadowRoot === "undefined") {
    return false;
  }
  var OwnElement = getWindow$1(node).ShadowRoot;
  return node instanceof OwnElement || node instanceof ShadowRoot;
}
function applyStyles(_ref) {
  var state = _ref.state;
  Object.keys(state.elements).forEach(function(name2) {
    var style2 = state.styles[name2] || {};
    var attributes2 = state.attributes[name2] || {};
    var element = state.elements[name2];
    if (!isHTMLElement$1(element) || !getNodeName(element)) {
      return;
    }
    Object.assign(element.style, style2);
    Object.keys(attributes2).forEach(function(name3) {
      var value = attributes2[name3];
      if (value === false) {
        element.removeAttribute(name3);
      } else {
        element.setAttribute(name3, value === true ? "" : value);
      }
    });
  });
}
function effect$2(_ref2) {
  var state = _ref2.state;
  var initialStyles2 = {
    popper: {
      position: state.options.strategy,
      left: "0",
      top: "0",
      margin: "0"
    },
    arrow: {
      position: "absolute"
    },
    reference: {}
  };
  Object.assign(state.elements.popper.style, initialStyles2.popper);
  state.styles = initialStyles2;
  if (state.elements.arrow) {
    Object.assign(state.elements.arrow.style, initialStyles2.arrow);
  }
  return function() {
    Object.keys(state.elements).forEach(function(name2) {
      var element = state.elements[name2];
      var attributes2 = state.attributes[name2] || {};
      var styleProperties = Object.keys(state.styles.hasOwnProperty(name2) ? state.styles[name2] : initialStyles2[name2]);
      var style2 = styleProperties.reduce(function(style3, property2) {
        style3[property2] = "";
        return style3;
      }, {});
      if (!isHTMLElement$1(element) || !getNodeName(element)) {
        return;
      }
      Object.assign(element.style, style2);
      Object.keys(attributes2).forEach(function(attribute) {
        element.removeAttribute(attribute);
      });
    });
  };
}
var applyStyles$1 = {
  name: "applyStyles",
  enabled: true,
  phase: "write",
  fn: applyStyles,
  effect: effect$2,
  requires: ["computeStyles"]
};
function getBasePlacement$1(placement) {
  return placement.split("-")[0];
}
var round$1 = Math.round;
function getBoundingClientRect(element, includeScale) {
  if (includeScale === void 0) {
    includeScale = false;
  }
  var rect = element.getBoundingClientRect();
  var scaleX = 1;
  var scaleY = 1;
  if (isHTMLElement$1(element) && includeScale) {
    var offsetHeight = element.offsetHeight;
    var offsetWidth = element.offsetWidth;
    if (offsetWidth > 0) {
      scaleX = rect.width / offsetWidth || 1;
    }
    if (offsetHeight > 0) {
      scaleY = rect.height / offsetHeight || 1;
    }
  }
  return {
    width: round$1(rect.width / scaleX),
    height: round$1(rect.height / scaleY),
    top: round$1(rect.top / scaleY),
    right: round$1(rect.right / scaleX),
    bottom: round$1(rect.bottom / scaleY),
    left: round$1(rect.left / scaleX),
    x: round$1(rect.left / scaleX),
    y: round$1(rect.top / scaleY)
  };
}
function getLayoutRect(element) {
  var clientRect = getBoundingClientRect(element);
  var width = element.offsetWidth;
  var height = element.offsetHeight;
  if (Math.abs(clientRect.width - width) <= 1) {
    width = clientRect.width;
  }
  if (Math.abs(clientRect.height - height) <= 1) {
    height = clientRect.height;
  }
  return {
    x: element.offsetLeft,
    y: element.offsetTop,
    width,
    height
  };
}
function contains$1(parent, child) {
  var rootNode = child.getRootNode && child.getRootNode();
  if (parent.contains(child)) {
    return true;
  } else if (rootNode && isShadowRoot(rootNode)) {
    var next = child;
    do {
      if (next && parent.isSameNode(next)) {
        return true;
      }
      next = next.parentNode || next.host;
    } while (next);
  }
  return false;
}
function getComputedStyle$1(element) {
  return getWindow$1(element).getComputedStyle(element);
}
function isTableElement(element) {
  return ["table", "td", "th"].indexOf(getNodeName(element)) >= 0;
}
function getDocumentElement$1(element) {
  return ((isElement$2(element) ? element.ownerDocument : element.document) || window.document).documentElement;
}
function getParentNode(element) {
  if (getNodeName(element) === "html") {
    return element;
  }
  return element.assignedSlot || element.parentNode || (isShadowRoot(element) ? element.host : null) || getDocumentElement$1(element);
}
function getTrueOffsetParent(element) {
  if (!isHTMLElement$1(element) || getComputedStyle$1(element).position === "fixed") {
    return null;
  }
  return element.offsetParent;
}
function getContainingBlock(element) {
  var isFirefox = navigator.userAgent.toLowerCase().indexOf("firefox") !== -1;
  var isIE2 = navigator.userAgent.indexOf("Trident") !== -1;
  if (isIE2 && isHTMLElement$1(element)) {
    var elementCss = getComputedStyle$1(element);
    if (elementCss.position === "fixed") {
      return null;
    }
  }
  var currentNode = getParentNode(element);
  while (isHTMLElement$1(currentNode) && ["html", "body"].indexOf(getNodeName(currentNode)) < 0) {
    var css2 = getComputedStyle$1(currentNode);
    if (css2.transform !== "none" || css2.perspective !== "none" || css2.contain === "paint" || ["transform", "perspective"].indexOf(css2.willChange) !== -1 || isFirefox && css2.willChange === "filter" || isFirefox && css2.filter && css2.filter !== "none") {
      return currentNode;
    } else {
      currentNode = currentNode.parentNode;
    }
  }
  return null;
}
function getOffsetParent$1(element) {
  var window2 = getWindow$1(element);
  var offsetParent = getTrueOffsetParent(element);
  while (offsetParent && isTableElement(offsetParent) && getComputedStyle$1(offsetParent).position === "static") {
    offsetParent = getTrueOffsetParent(offsetParent);
  }
  if (offsetParent && (getNodeName(offsetParent) === "html" || getNodeName(offsetParent) === "body" && getComputedStyle$1(offsetParent).position === "static")) {
    return window2;
  }
  return offsetParent || getContainingBlock(element) || window2;
}
function getMainAxisFromPlacement(placement) {
  return ["top", "bottom"].indexOf(placement) >= 0 ? "x" : "y";
}
var max$1 = Math.max;
var min$1 = Math.min;
var round = Math.round;
function within(min2, value, max2) {
  return max$1(min2, min$1(value, max2));
}
function getFreshSideObject() {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  };
}
function mergePaddingObject(paddingObject) {
  return Object.assign({}, getFreshSideObject(), paddingObject);
}
function expandToHashMap(value, keys2) {
  return keys2.reduce(function(hashMap, key) {
    hashMap[key] = value;
    return hashMap;
  }, {});
}
var toPaddingObject = function toPaddingObject2(padding, state) {
  padding = typeof padding === "function" ? padding(Object.assign({}, state.rects, {
    placement: state.placement
  })) : padding;
  return mergePaddingObject(typeof padding !== "number" ? padding : expandToHashMap(padding, basePlacements));
};
function arrow(_ref) {
  var _state$modifiersData$;
  var state = _ref.state, name2 = _ref.name, options = _ref.options;
  var arrowElement = state.elements.arrow;
  var popperOffsets2 = state.modifiersData.popperOffsets;
  var basePlacement = getBasePlacement$1(state.placement);
  var axis = getMainAxisFromPlacement(basePlacement);
  var isVertical = [left, right].indexOf(basePlacement) >= 0;
  var len = isVertical ? "height" : "width";
  if (!arrowElement || !popperOffsets2) {
    return;
  }
  var paddingObject = toPaddingObject(options.padding, state);
  var arrowRect = getLayoutRect(arrowElement);
  var minProp = axis === "y" ? top : left;
  var maxProp = axis === "y" ? bottom : right;
  var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets2[axis] - state.rects.popper[len];
  var startDiff = popperOffsets2[axis] - state.rects.reference[axis];
  var arrowOffsetParent = getOffsetParent$1(arrowElement);
  var clientSize = arrowOffsetParent ? axis === "y" ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
  var centerToReference = endDiff / 2 - startDiff / 2;
  var min2 = paddingObject[minProp];
  var max2 = clientSize - arrowRect[len] - paddingObject[maxProp];
  var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
  var offset4 = within(min2, center, max2);
  var axisProp = axis;
  state.modifiersData[name2] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset4, _state$modifiersData$.centerOffset = offset4 - center, _state$modifiersData$);
}
function effect$1(_ref2) {
  var state = _ref2.state, options = _ref2.options;
  var _options$element = options.element, arrowElement = _options$element === void 0 ? "[data-popper-arrow]" : _options$element;
  if (arrowElement == null) {
    return;
  }
  if (typeof arrowElement === "string") {
    arrowElement = state.elements.popper.querySelector(arrowElement);
    if (!arrowElement) {
      return;
    }
  }
  if (!contains$1(state.elements.popper, arrowElement)) {
    return;
  }
  state.elements.arrow = arrowElement;
}
var arrow$1 = {
  name: "arrow",
  enabled: true,
  phase: "main",
  fn: arrow,
  effect: effect$1,
  requires: ["popperOffsets"],
  requiresIfExists: ["preventOverflow"]
};
function getVariation(placement) {
  return placement.split("-")[1];
}
var unsetSides = {
  top: "auto",
  right: "auto",
  bottom: "auto",
  left: "auto"
};
function roundOffsetsByDPR(_ref) {
  var x2 = _ref.x, y4 = _ref.y;
  var win = window;
  var dpr = win.devicePixelRatio || 1;
  return {
    x: round(round(x2 * dpr) / dpr) || 0,
    y: round(round(y4 * dpr) / dpr) || 0
  };
}
function mapToStyles(_ref2) {
  var _Object$assign2;
  var popper2 = _ref2.popper, popperRect = _ref2.popperRect, placement = _ref2.placement, variation = _ref2.variation, offsets = _ref2.offsets, position3 = _ref2.position, gpuAcceleration = _ref2.gpuAcceleration, adaptive = _ref2.adaptive, roundOffsets = _ref2.roundOffsets;
  var _ref3 = roundOffsets === true ? roundOffsetsByDPR(offsets) : typeof roundOffsets === "function" ? roundOffsets(offsets) : offsets, _ref3$x = _ref3.x, x2 = _ref3$x === void 0 ? 0 : _ref3$x, _ref3$y = _ref3.y, y4 = _ref3$y === void 0 ? 0 : _ref3$y;
  var hasX = offsets.hasOwnProperty("x");
  var hasY = offsets.hasOwnProperty("y");
  var sideX = left;
  var sideY = top;
  var win = window;
  if (adaptive) {
    var offsetParent = getOffsetParent$1(popper2);
    var heightProp = "clientHeight";
    var widthProp = "clientWidth";
    if (offsetParent === getWindow$1(popper2)) {
      offsetParent = getDocumentElement$1(popper2);
      if (getComputedStyle$1(offsetParent).position !== "static" && position3 === "absolute") {
        heightProp = "scrollHeight";
        widthProp = "scrollWidth";
      }
    }
    offsetParent = offsetParent;
    if (placement === top || (placement === left || placement === right) && variation === end$1) {
      sideY = bottom;
      y4 -= offsetParent[heightProp] - popperRect.height;
      y4 *= gpuAcceleration ? 1 : -1;
    }
    if (placement === left || (placement === top || placement === bottom) && variation === end$1) {
      sideX = right;
      x2 -= offsetParent[widthProp] - popperRect.width;
      x2 *= gpuAcceleration ? 1 : -1;
    }
  }
  var commonStyles = Object.assign({
    position: position3
  }, adaptive && unsetSides);
  if (gpuAcceleration) {
    var _Object$assign;
    return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? "0" : "", _Object$assign[sideX] = hasX ? "0" : "", _Object$assign.transform = (win.devicePixelRatio || 1) <= 1 ? "translate(" + x2 + "px, " + y4 + "px)" : "translate3d(" + x2 + "px, " + y4 + "px, 0)", _Object$assign));
  }
  return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y4 + "px" : "", _Object$assign2[sideX] = hasX ? x2 + "px" : "", _Object$assign2.transform = "", _Object$assign2));
}
function computeStyles(_ref4) {
  var state = _ref4.state, options = _ref4.options;
  var _options$gpuAccelerat = options.gpuAcceleration, gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat, _options$adaptive = options.adaptive, adaptive = _options$adaptive === void 0 ? true : _options$adaptive, _options$roundOffsets = options.roundOffsets, roundOffsets = _options$roundOffsets === void 0 ? true : _options$roundOffsets;
  var commonStyles = {
    placement: getBasePlacement$1(state.placement),
    variation: getVariation(state.placement),
    popper: state.elements.popper,
    popperRect: state.rects.popper,
    gpuAcceleration
  };
  if (state.modifiersData.popperOffsets != null) {
    state.styles.popper = Object.assign({}, state.styles.popper, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.popperOffsets,
      position: state.options.strategy,
      adaptive,
      roundOffsets
    })));
  }
  if (state.modifiersData.arrow != null) {
    state.styles.arrow = Object.assign({}, state.styles.arrow, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.arrow,
      position: "absolute",
      adaptive: false,
      roundOffsets
    })));
  }
  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    "data-popper-placement": state.placement
  });
}
var computeStyles$1 = {
  name: "computeStyles",
  enabled: true,
  phase: "beforeWrite",
  fn: computeStyles,
  data: {}
};
var passive = {
  passive: true
};
function effect(_ref) {
  var state = _ref.state, instance = _ref.instance, options = _ref.options;
  var _options$scroll = options.scroll, scroll3 = _options$scroll === void 0 ? true : _options$scroll, _options$resize = options.resize, resize = _options$resize === void 0 ? true : _options$resize;
  var window2 = getWindow$1(state.elements.popper);
  var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);
  if (scroll3) {
    scrollParents.forEach(function(scrollParent) {
      scrollParent.addEventListener("scroll", instance.update, passive);
    });
  }
  if (resize) {
    window2.addEventListener("resize", instance.update, passive);
  }
  return function() {
    if (scroll3) {
      scrollParents.forEach(function(scrollParent) {
        scrollParent.removeEventListener("scroll", instance.update, passive);
      });
    }
    if (resize) {
      window2.removeEventListener("resize", instance.update, passive);
    }
  };
}
var eventListeners = {
  name: "eventListeners",
  enabled: true,
  phase: "write",
  fn: function fn() {
  },
  effect,
  data: {}
};
var hash$1 = {
  left: "right",
  right: "left",
  bottom: "top",
  top: "bottom"
};
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, function(matched) {
    return hash$1[matched];
  });
}
var hash = {
  start: "end",
  end: "start"
};
function getOppositeVariationPlacement(placement) {
  return placement.replace(/start|end/g, function(matched) {
    return hash[matched];
  });
}
function getWindowScroll$2(node) {
  var win = getWindow$1(node);
  var scrollLeft = win.pageXOffset;
  var scrollTop = win.pageYOffset;
  return {
    scrollLeft,
    scrollTop
  };
}
function getWindowScrollBarX(element) {
  return getBoundingClientRect(getDocumentElement$1(element)).left + getWindowScroll$2(element).scrollLeft;
}
function getViewportRect(element) {
  var win = getWindow$1(element);
  var html = getDocumentElement$1(element);
  var visualViewport = win.visualViewport;
  var width = html.clientWidth;
  var height = html.clientHeight;
  var x2 = 0;
  var y4 = 0;
  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    if (!/^((?!chrome|android).)*safari/i.test(navigator.userAgent)) {
      x2 = visualViewport.offsetLeft;
      y4 = visualViewport.offsetTop;
    }
  }
  return {
    width,
    height,
    x: x2 + getWindowScrollBarX(element),
    y: y4
  };
}
function getDocumentRect(element) {
  var _element$ownerDocumen;
  var html = getDocumentElement$1(element);
  var winScroll = getWindowScroll$2(element);
  var body2 = (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
  var width = max$1(html.scrollWidth, html.clientWidth, body2 ? body2.scrollWidth : 0, body2 ? body2.clientWidth : 0);
  var height = max$1(html.scrollHeight, html.clientHeight, body2 ? body2.scrollHeight : 0, body2 ? body2.clientHeight : 0);
  var x2 = -winScroll.scrollLeft + getWindowScrollBarX(element);
  var y4 = -winScroll.scrollTop;
  if (getComputedStyle$1(body2 || html).direction === "rtl") {
    x2 += max$1(html.clientWidth, body2 ? body2.clientWidth : 0) - width;
  }
  return {
    width,
    height,
    x: x2,
    y: y4
  };
}
function isScrollParent(element) {
  var _getComputedStyle2 = getComputedStyle$1(element), overflow = _getComputedStyle2.overflow, overflowX = _getComputedStyle2.overflowX, overflowY = _getComputedStyle2.overflowY;
  return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
}
function getScrollParent(node) {
  if (["html", "body", "#document"].indexOf(getNodeName(node)) >= 0) {
    return node.ownerDocument.body;
  }
  if (isHTMLElement$1(node) && isScrollParent(node)) {
    return node;
  }
  return getScrollParent(getParentNode(node));
}
function listScrollParents(element, list) {
  var _element$ownerDocumen;
  if (list === void 0) {
    list = [];
  }
  var scrollParent = getScrollParent(element);
  var isBody = scrollParent === ((_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body);
  var win = getWindow$1(scrollParent);
  var target = isBody ? [win].concat(win.visualViewport || [], isScrollParent(scrollParent) ? scrollParent : []) : scrollParent;
  var updatedList = list.concat(target);
  return isBody ? updatedList : updatedList.concat(listScrollParents(getParentNode(target)));
}
function rectToClientRect(rect) {
  return Object.assign({}, rect, {
    left: rect.x,
    top: rect.y,
    right: rect.x + rect.width,
    bottom: rect.y + rect.height
  });
}
function getInnerBoundingClientRect(element) {
  var rect = getBoundingClientRect(element);
  rect.top = rect.top + element.clientTop;
  rect.left = rect.left + element.clientLeft;
  rect.bottom = rect.top + element.clientHeight;
  rect.right = rect.left + element.clientWidth;
  rect.width = element.clientWidth;
  rect.height = element.clientHeight;
  rect.x = rect.left;
  rect.y = rect.top;
  return rect;
}
function getClientRectFromMixedType(element, clippingParent) {
  return clippingParent === viewport ? rectToClientRect(getViewportRect(element)) : isHTMLElement$1(clippingParent) ? getInnerBoundingClientRect(clippingParent) : rectToClientRect(getDocumentRect(getDocumentElement$1(element)));
}
function getClippingParents(element) {
  var clippingParents2 = listScrollParents(getParentNode(element));
  var canEscapeClipping = ["absolute", "fixed"].indexOf(getComputedStyle$1(element).position) >= 0;
  var clipperElement = canEscapeClipping && isHTMLElement$1(element) ? getOffsetParent$1(element) : element;
  if (!isElement$2(clipperElement)) {
    return [];
  }
  return clippingParents2.filter(function(clippingParent) {
    return isElement$2(clippingParent) && contains$1(clippingParent, clipperElement) && getNodeName(clippingParent) !== "body";
  });
}
function getClippingRect(element, boundary, rootBoundary) {
  var mainClippingParents = boundary === "clippingParents" ? getClippingParents(element) : [].concat(boundary);
  var clippingParents2 = [].concat(mainClippingParents, [rootBoundary]);
  var firstClippingParent = clippingParents2[0];
  var clippingRect = clippingParents2.reduce(function(accRect, clippingParent) {
    var rect = getClientRectFromMixedType(element, clippingParent);
    accRect.top = max$1(rect.top, accRect.top);
    accRect.right = min$1(rect.right, accRect.right);
    accRect.bottom = min$1(rect.bottom, accRect.bottom);
    accRect.left = max$1(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromMixedType(element, firstClippingParent));
  clippingRect.width = clippingRect.right - clippingRect.left;
  clippingRect.height = clippingRect.bottom - clippingRect.top;
  clippingRect.x = clippingRect.left;
  clippingRect.y = clippingRect.top;
  return clippingRect;
}
function computeOffsets(_ref) {
  var reference2 = _ref.reference, element = _ref.element, placement = _ref.placement;
  var basePlacement = placement ? getBasePlacement$1(placement) : null;
  var variation = placement ? getVariation(placement) : null;
  var commonX = reference2.x + reference2.width / 2 - element.width / 2;
  var commonY = reference2.y + reference2.height / 2 - element.height / 2;
  var offsets;
  switch (basePlacement) {
    case top:
      offsets = {
        x: commonX,
        y: reference2.y - element.height
      };
      break;
    case bottom:
      offsets = {
        x: commonX,
        y: reference2.y + reference2.height
      };
      break;
    case right:
      offsets = {
        x: reference2.x + reference2.width,
        y: commonY
      };
      break;
    case left:
      offsets = {
        x: reference2.x - element.width,
        y: commonY
      };
      break;
    default:
      offsets = {
        x: reference2.x,
        y: reference2.y
      };
  }
  var mainAxis = basePlacement ? getMainAxisFromPlacement(basePlacement) : null;
  if (mainAxis != null) {
    var len = mainAxis === "y" ? "height" : "width";
    switch (variation) {
      case start:
        offsets[mainAxis] = offsets[mainAxis] - (reference2[len] / 2 - element[len] / 2);
        break;
      case end$1:
        offsets[mainAxis] = offsets[mainAxis] + (reference2[len] / 2 - element[len] / 2);
        break;
    }
  }
  return offsets;
}
function detectOverflow(state, options) {
  if (options === void 0) {
    options = {};
  }
  var _options = options, _options$placement = _options.placement, placement = _options$placement === void 0 ? state.placement : _options$placement, _options$boundary = _options.boundary, boundary = _options$boundary === void 0 ? clippingParents : _options$boundary, _options$rootBoundary = _options.rootBoundary, rootBoundary = _options$rootBoundary === void 0 ? viewport : _options$rootBoundary, _options$elementConte = _options.elementContext, elementContext = _options$elementConte === void 0 ? popper : _options$elementConte, _options$altBoundary = _options.altBoundary, altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary, _options$padding = _options.padding, padding = _options$padding === void 0 ? 0 : _options$padding;
  var paddingObject = mergePaddingObject(typeof padding !== "number" ? padding : expandToHashMap(padding, basePlacements));
  var altContext = elementContext === popper ? reference : popper;
  var popperRect = state.rects.popper;
  var element = state.elements[altBoundary ? altContext : elementContext];
  var clippingClientRect = getClippingRect(isElement$2(element) ? element : element.contextElement || getDocumentElement$1(state.elements.popper), boundary, rootBoundary);
  var referenceClientRect = getBoundingClientRect(state.elements.reference);
  var popperOffsets2 = computeOffsets({
    reference: referenceClientRect,
    element: popperRect,
    strategy: "absolute",
    placement
  });
  var popperClientRect = rectToClientRect(Object.assign({}, popperRect, popperOffsets2));
  var elementClientRect = elementContext === popper ? popperClientRect : referenceClientRect;
  var overflowOffsets = {
    top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
    bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
    left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
    right: elementClientRect.right - clippingClientRect.right + paddingObject.right
  };
  var offsetData = state.modifiersData.offset;
  if (elementContext === popper && offsetData) {
    var offset4 = offsetData[placement];
    Object.keys(overflowOffsets).forEach(function(key) {
      var multiply = [right, bottom].indexOf(key) >= 0 ? 1 : -1;
      var axis = [top, bottom].indexOf(key) >= 0 ? "y" : "x";
      overflowOffsets[key] += offset4[axis] * multiply;
    });
  }
  return overflowOffsets;
}
function computeAutoPlacement(state, options) {
  if (options === void 0) {
    options = {};
  }
  var _options = options, placement = _options.placement, boundary = _options.boundary, rootBoundary = _options.rootBoundary, padding = _options.padding, flipVariations = _options.flipVariations, _options$allowedAutoP = _options.allowedAutoPlacements, allowedAutoPlacements = _options$allowedAutoP === void 0 ? placements$2 : _options$allowedAutoP;
  var variation = getVariation(placement);
  var placements2 = variation ? flipVariations ? variationPlacements : variationPlacements.filter(function(placement2) {
    return getVariation(placement2) === variation;
  }) : basePlacements;
  var allowedPlacements = placements2.filter(function(placement2) {
    return allowedAutoPlacements.indexOf(placement2) >= 0;
  });
  if (allowedPlacements.length === 0) {
    allowedPlacements = placements2;
  }
  var overflows = allowedPlacements.reduce(function(acc, placement2) {
    acc[placement2] = detectOverflow(state, {
      placement: placement2,
      boundary,
      rootBoundary,
      padding
    })[getBasePlacement$1(placement2)];
    return acc;
  }, {});
  return Object.keys(overflows).sort(function(a3, b3) {
    return overflows[a3] - overflows[b3];
  });
}
function getExpandedFallbackPlacements(placement) {
  if (getBasePlacement$1(placement) === auto) {
    return [];
  }
  var oppositePlacement = getOppositePlacement(placement);
  return [getOppositeVariationPlacement(placement), oppositePlacement, getOppositeVariationPlacement(oppositePlacement)];
}
function flip$1(_ref) {
  var state = _ref.state, options = _ref.options, name2 = _ref.name;
  if (state.modifiersData[name2]._skip) {
    return;
  }
  var _options$mainAxis = options.mainAxis, checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis, _options$altAxis = options.altAxis, checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis, specifiedFallbackPlacements = options.fallbackPlacements, padding = options.padding, boundary = options.boundary, rootBoundary = options.rootBoundary, altBoundary = options.altBoundary, _options$flipVariatio = options.flipVariations, flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio, allowedAutoPlacements = options.allowedAutoPlacements;
  var preferredPlacement = state.options.placement;
  var basePlacement = getBasePlacement$1(preferredPlacement);
  var isBasePlacement = basePlacement === preferredPlacement;
  var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [getOppositePlacement(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
  var placements2 = [preferredPlacement].concat(fallbackPlacements).reduce(function(acc, placement2) {
    return acc.concat(getBasePlacement$1(placement2) === auto ? computeAutoPlacement(state, {
      placement: placement2,
      boundary,
      rootBoundary,
      padding,
      flipVariations,
      allowedAutoPlacements
    }) : placement2);
  }, []);
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var checksMap = /* @__PURE__ */ new Map();
  var makeFallbackChecks = true;
  var firstFittingPlacement = placements2[0];
  for (var i2 = 0; i2 < placements2.length; i2++) {
    var placement = placements2[i2];
    var _basePlacement = getBasePlacement$1(placement);
    var isStartVariation = getVariation(placement) === start;
    var isVertical = [top, bottom].indexOf(_basePlacement) >= 0;
    var len = isVertical ? "width" : "height";
    var overflow = detectOverflow(state, {
      placement,
      boundary,
      rootBoundary,
      altBoundary,
      padding
    });
    var mainVariationSide = isVertical ? isStartVariation ? right : left : isStartVariation ? bottom : top;
    if (referenceRect[len] > popperRect[len]) {
      mainVariationSide = getOppositePlacement(mainVariationSide);
    }
    var altVariationSide = getOppositePlacement(mainVariationSide);
    var checks = [];
    if (checkMainAxis) {
      checks.push(overflow[_basePlacement] <= 0);
    }
    if (checkAltAxis) {
      checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
    }
    if (checks.every(function(check) {
      return check;
    })) {
      firstFittingPlacement = placement;
      makeFallbackChecks = false;
      break;
    }
    checksMap.set(placement, checks);
  }
  if (makeFallbackChecks) {
    var numberOfChecks = flipVariations ? 3 : 1;
    var _loop = function _loop4(_i2) {
      var fittingPlacement = placements2.find(function(placement2) {
        var checks2 = checksMap.get(placement2);
        if (checks2) {
          return checks2.slice(0, _i2).every(function(check) {
            return check;
          });
        }
      });
      if (fittingPlacement) {
        firstFittingPlacement = fittingPlacement;
        return "break";
      }
    };
    for (var _i = numberOfChecks; _i > 0; _i--) {
      var _ret = _loop(_i);
      if (_ret === "break")
        break;
    }
  }
  if (state.placement !== firstFittingPlacement) {
    state.modifiersData[name2]._skip = true;
    state.placement = firstFittingPlacement;
    state.reset = true;
  }
}
var flip$2 = {
  name: "flip",
  enabled: true,
  phase: "main",
  fn: flip$1,
  requiresIfExists: ["offset"],
  data: {
    _skip: false
  }
};
function getSideOffsets(overflow, rect, preventedOffsets) {
  if (preventedOffsets === void 0) {
    preventedOffsets = {
      x: 0,
      y: 0
    };
  }
  return {
    top: overflow.top - rect.height - preventedOffsets.y,
    right: overflow.right - rect.width + preventedOffsets.x,
    bottom: overflow.bottom - rect.height + preventedOffsets.y,
    left: overflow.left - rect.width - preventedOffsets.x
  };
}
function isAnySideFullyClipped(overflow) {
  return [top, right, bottom, left].some(function(side) {
    return overflow[side] >= 0;
  });
}
function hide(_ref) {
  var state = _ref.state, name2 = _ref.name;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var preventedOffsets = state.modifiersData.preventOverflow;
  var referenceOverflow = detectOverflow(state, {
    elementContext: "reference"
  });
  var popperAltOverflow = detectOverflow(state, {
    altBoundary: true
  });
  var referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
  var popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
  var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
  var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
  state.modifiersData[name2] = {
    referenceClippingOffsets,
    popperEscapeOffsets,
    isReferenceHidden,
    hasPopperEscaped
  };
  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    "data-popper-reference-hidden": isReferenceHidden,
    "data-popper-escaped": hasPopperEscaped
  });
}
var hide$1 = {
  name: "hide",
  enabled: true,
  phase: "main",
  requiresIfExists: ["preventOverflow"],
  fn: hide
};
function distanceAndSkiddingToXY(placement, rects, offset4) {
  var basePlacement = getBasePlacement$1(placement);
  var invertDistance = [left, top].indexOf(basePlacement) >= 0 ? -1 : 1;
  var _ref = typeof offset4 === "function" ? offset4(Object.assign({}, rects, {
    placement
  })) : offset4, skidding = _ref[0], distance3 = _ref[1];
  skidding = skidding || 0;
  distance3 = (distance3 || 0) * invertDistance;
  return [left, right].indexOf(basePlacement) >= 0 ? {
    x: distance3,
    y: skidding
  } : {
    x: skidding,
    y: distance3
  };
}
function offset$2(_ref2) {
  var state = _ref2.state, options = _ref2.options, name2 = _ref2.name;
  var _options$offset = options.offset, offset4 = _options$offset === void 0 ? [0, 0] : _options$offset;
  var data2 = placements$2.reduce(function(acc, placement) {
    acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset4);
    return acc;
  }, {});
  var _data$state$placement = data2[state.placement], x2 = _data$state$placement.x, y4 = _data$state$placement.y;
  if (state.modifiersData.popperOffsets != null) {
    state.modifiersData.popperOffsets.x += x2;
    state.modifiersData.popperOffsets.y += y4;
  }
  state.modifiersData[name2] = data2;
}
var offset$3 = {
  name: "offset",
  enabled: true,
  phase: "main",
  requires: ["popperOffsets"],
  fn: offset$2
};
function popperOffsets(_ref) {
  var state = _ref.state, name2 = _ref.name;
  state.modifiersData[name2] = computeOffsets({
    reference: state.rects.reference,
    element: state.rects.popper,
    strategy: "absolute",
    placement: state.placement
  });
}
var popperOffsets$1 = {
  name: "popperOffsets",
  enabled: true,
  phase: "read",
  fn: popperOffsets,
  data: {}
};
function getAltAxis(axis) {
  return axis === "x" ? "y" : "x";
}
function preventOverflow(_ref) {
  var state = _ref.state, options = _ref.options, name2 = _ref.name;
  var _options$mainAxis = options.mainAxis, checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis, _options$altAxis = options.altAxis, checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis, boundary = options.boundary, rootBoundary = options.rootBoundary, altBoundary = options.altBoundary, padding = options.padding, _options$tether = options.tether, tether = _options$tether === void 0 ? true : _options$tether, _options$tetherOffset = options.tetherOffset, tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
  var overflow = detectOverflow(state, {
    boundary,
    rootBoundary,
    padding,
    altBoundary
  });
  var basePlacement = getBasePlacement$1(state.placement);
  var variation = getVariation(state.placement);
  var isBasePlacement = !variation;
  var mainAxis = getMainAxisFromPlacement(basePlacement);
  var altAxis = getAltAxis(mainAxis);
  var popperOffsets2 = state.modifiersData.popperOffsets;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var tetherOffsetValue = typeof tetherOffset === "function" ? tetherOffset(Object.assign({}, state.rects, {
    placement: state.placement
  })) : tetherOffset;
  var data2 = {
    x: 0,
    y: 0
  };
  if (!popperOffsets2) {
    return;
  }
  if (checkMainAxis || checkAltAxis) {
    var mainSide = mainAxis === "y" ? top : left;
    var altSide = mainAxis === "y" ? bottom : right;
    var len = mainAxis === "y" ? "height" : "width";
    var offset4 = popperOffsets2[mainAxis];
    var min2 = popperOffsets2[mainAxis] + overflow[mainSide];
    var max2 = popperOffsets2[mainAxis] - overflow[altSide];
    var additive = tether ? -popperRect[len] / 2 : 0;
    var minLen = variation === start ? referenceRect[len] : popperRect[len];
    var maxLen = variation === start ? -popperRect[len] : -referenceRect[len];
    var arrowElement = state.elements.arrow;
    var arrowRect = tether && arrowElement ? getLayoutRect(arrowElement) : {
      width: 0,
      height: 0
    };
    var arrowPaddingObject = state.modifiersData["arrow#persistent"] ? state.modifiersData["arrow#persistent"].padding : getFreshSideObject();
    var arrowPaddingMin = arrowPaddingObject[mainSide];
    var arrowPaddingMax = arrowPaddingObject[altSide];
    var arrowLen = within(0, referenceRect[len], arrowRect[len]);
    var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - tetherOffsetValue : minLen - arrowLen - arrowPaddingMin - tetherOffsetValue;
    var maxOffset = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + tetherOffsetValue : maxLen + arrowLen + arrowPaddingMax + tetherOffsetValue;
    var arrowOffsetParent = state.elements.arrow && getOffsetParent$1(state.elements.arrow);
    var clientOffset = arrowOffsetParent ? mainAxis === "y" ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
    var offsetModifierValue = state.modifiersData.offset ? state.modifiersData.offset[state.placement][mainAxis] : 0;
    var tetherMin = popperOffsets2[mainAxis] + minOffset - offsetModifierValue - clientOffset;
    var tetherMax = popperOffsets2[mainAxis] + maxOffset - offsetModifierValue;
    if (checkMainAxis) {
      var preventedOffset = within(tether ? min$1(min2, tetherMin) : min2, offset4, tether ? max$1(max2, tetherMax) : max2);
      popperOffsets2[mainAxis] = preventedOffset;
      data2[mainAxis] = preventedOffset - offset4;
    }
    if (checkAltAxis) {
      var _mainSide = mainAxis === "x" ? top : left;
      var _altSide = mainAxis === "x" ? bottom : right;
      var _offset = popperOffsets2[altAxis];
      var _min = _offset + overflow[_mainSide];
      var _max = _offset - overflow[_altSide];
      var _preventedOffset = within(tether ? min$1(_min, tetherMin) : _min, _offset, tether ? max$1(_max, tetherMax) : _max);
      popperOffsets2[altAxis] = _preventedOffset;
      data2[altAxis] = _preventedOffset - _offset;
    }
  }
  state.modifiersData[name2] = data2;
}
var preventOverflow$1 = {
  name: "preventOverflow",
  enabled: true,
  phase: "main",
  fn: preventOverflow,
  requiresIfExists: ["offset"]
};
function getHTMLElementScroll(element) {
  return {
    scrollLeft: element.scrollLeft,
    scrollTop: element.scrollTop
  };
}
function getNodeScroll(node) {
  if (node === getWindow$1(node) || !isHTMLElement$1(node)) {
    return getWindowScroll$2(node);
  } else {
    return getHTMLElementScroll(node);
  }
}
function isElementScaled(element) {
  var rect = element.getBoundingClientRect();
  var scaleX = rect.width / element.offsetWidth || 1;
  var scaleY = rect.height / element.offsetHeight || 1;
  return scaleX !== 1 || scaleY !== 1;
}
function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed2) {
  if (isFixed2 === void 0) {
    isFixed2 = false;
  }
  var isOffsetParentAnElement = isHTMLElement$1(offsetParent);
  var offsetParentIsScaled = isHTMLElement$1(offsetParent) && isElementScaled(offsetParent);
  var documentElement = getDocumentElement$1(offsetParent);
  var rect = getBoundingClientRect(elementOrVirtualElement, offsetParentIsScaled);
  var scroll3 = {
    scrollLeft: 0,
    scrollTop: 0
  };
  var offsets = {
    x: 0,
    y: 0
  };
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed2) {
    if (getNodeName(offsetParent) !== "body" || isScrollParent(documentElement)) {
      scroll3 = getNodeScroll(offsetParent);
    }
    if (isHTMLElement$1(offsetParent)) {
      offsets = getBoundingClientRect(offsetParent, true);
      offsets.x += offsetParent.clientLeft;
      offsets.y += offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = getWindowScrollBarX(documentElement);
    }
  }
  return {
    x: rect.left + scroll3.scrollLeft - offsets.x,
    y: rect.top + scroll3.scrollTop - offsets.y,
    width: rect.width,
    height: rect.height
  };
}
function order(modifiers) {
  var map2 = /* @__PURE__ */ new Map();
  var visited = /* @__PURE__ */ new Set();
  var result = [];
  modifiers.forEach(function(modifier) {
    map2.set(modifier.name, modifier);
  });
  function sort(modifier) {
    visited.add(modifier.name);
    var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
    requires.forEach(function(dep) {
      if (!visited.has(dep)) {
        var depModifier = map2.get(dep);
        if (depModifier) {
          sort(depModifier);
        }
      }
    });
    result.push(modifier);
  }
  modifiers.forEach(function(modifier) {
    if (!visited.has(modifier.name)) {
      sort(modifier);
    }
  });
  return result;
}
function orderModifiers(modifiers) {
  var orderedModifiers = order(modifiers);
  return modifierPhases.reduce(function(acc, phase) {
    return acc.concat(orderedModifiers.filter(function(modifier) {
      return modifier.phase === phase;
    }));
  }, []);
}
function debounce$3(fn3) {
  var pending;
  return function() {
    if (!pending) {
      pending = new Promise(function(resolve) {
        Promise.resolve().then(function() {
          pending = void 0;
          resolve(fn3());
        });
      });
    }
    return pending;
  };
}
function mergeByName(modifiers) {
  var merged = modifiers.reduce(function(merged2, current) {
    var existing = merged2[current.name];
    merged2[current.name] = existing ? Object.assign({}, existing, current, {
      options: Object.assign({}, existing.options, current.options),
      data: Object.assign({}, existing.data, current.data)
    }) : current;
    return merged2;
  }, {});
  return Object.keys(merged).map(function(key) {
    return merged[key];
  });
}
var DEFAULT_OPTIONS = {
  placement: "bottom",
  modifiers: [],
  strategy: "absolute"
};
function areValidElements() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }
  return !args.some(function(element) {
    return !(element && typeof element.getBoundingClientRect === "function");
  });
}
function popperGenerator(generatorOptions) {
  if (generatorOptions === void 0) {
    generatorOptions = {};
  }
  var _generatorOptions = generatorOptions, _generatorOptions$def = _generatorOptions.defaultModifiers, defaultModifiers2 = _generatorOptions$def === void 0 ? [] : _generatorOptions$def, _generatorOptions$def2 = _generatorOptions.defaultOptions, defaultOptions2 = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS : _generatorOptions$def2;
  return function createPopper2(reference2, popper2, options) {
    if (options === void 0) {
      options = defaultOptions2;
    }
    var state = {
      placement: "bottom",
      orderedModifiers: [],
      options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions2),
      modifiersData: {},
      elements: {
        reference: reference2,
        popper: popper2
      },
      attributes: {},
      styles: {}
    };
    var effectCleanupFns = [];
    var isDestroyed = false;
    var instance = {
      state,
      setOptions: function setOptions(setOptionsAction) {
        var options2 = typeof setOptionsAction === "function" ? setOptionsAction(state.options) : setOptionsAction;
        cleanupModifierEffects();
        state.options = Object.assign({}, defaultOptions2, state.options, options2);
        state.scrollParents = {
          reference: isElement$2(reference2) ? listScrollParents(reference2) : reference2.contextElement ? listScrollParents(reference2.contextElement) : [],
          popper: listScrollParents(popper2)
        };
        var orderedModifiers = orderModifiers(mergeByName([].concat(defaultModifiers2, state.options.modifiers)));
        state.orderedModifiers = orderedModifiers.filter(function(m4) {
          return m4.enabled;
        });
        runModifierEffects();
        return instance.update();
      },
      forceUpdate: function forceUpdate() {
        if (isDestroyed) {
          return;
        }
        var _state$elements = state.elements, reference3 = _state$elements.reference, popper3 = _state$elements.popper;
        if (!areValidElements(reference3, popper3)) {
          return;
        }
        state.rects = {
          reference: getCompositeRect(reference3, getOffsetParent$1(popper3), state.options.strategy === "fixed"),
          popper: getLayoutRect(popper3)
        };
        state.reset = false;
        state.placement = state.options.placement;
        state.orderedModifiers.forEach(function(modifier) {
          return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
        });
        for (var index2 = 0; index2 < state.orderedModifiers.length; index2++) {
          if (state.reset === true) {
            state.reset = false;
            index2 = -1;
            continue;
          }
          var _state$orderedModifie = state.orderedModifiers[index2], fn3 = _state$orderedModifie.fn, _state$orderedModifie2 = _state$orderedModifie.options, _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2, name2 = _state$orderedModifie.name;
          if (typeof fn3 === "function") {
            state = fn3({
              state,
              options: _options,
              name: name2,
              instance
            }) || state;
          }
        }
      },
      update: debounce$3(function() {
        return new Promise(function(resolve) {
          instance.forceUpdate();
          resolve(state);
        });
      }),
      destroy: function destroy() {
        cleanupModifierEffects();
        isDestroyed = true;
      }
    };
    if (!areValidElements(reference2, popper2)) {
      return instance;
    }
    instance.setOptions(options).then(function(state2) {
      if (!isDestroyed && options.onFirstUpdate) {
        options.onFirstUpdate(state2);
      }
    });
    function runModifierEffects() {
      state.orderedModifiers.forEach(function(_ref3) {
        var name2 = _ref3.name, _ref3$options = _ref3.options, options2 = _ref3$options === void 0 ? {} : _ref3$options, effect3 = _ref3.effect;
        if (typeof effect3 === "function") {
          var cleanupFn = effect3({
            state,
            name: name2,
            instance,
            options: options2
          });
          var noopFn = function noopFn2() {
          };
          effectCleanupFns.push(cleanupFn || noopFn);
        }
      });
    }
    function cleanupModifierEffects() {
      effectCleanupFns.forEach(function(fn3) {
        return fn3();
      });
      effectCleanupFns = [];
    }
    return instance;
  };
}
var defaultModifiers = [eventListeners, popperOffsets$1, computeStyles$1, applyStyles$1, offset$3, flip$2, preventOverflow$1, arrow$1, hide$1];
var createPopper = /* @__PURE__ */ popperGenerator({
  defaultModifiers
});
var CONTENT_CLASS = "tippy-content";
var BACKDROP_CLASS = "tippy-backdrop";
var ARROW_CLASS = "tippy-arrow";
var SVG_ARROW_CLASS = "tippy-svg-arrow";
var TOUCH_OPTIONS = {
  passive: true,
  capture: true
};
function getValueAtIndexOrReturn(value, index2, defaultValue2) {
  if (Array.isArray(value)) {
    var v2 = value[index2];
    return v2 == null ? Array.isArray(defaultValue2) ? defaultValue2[index2] : defaultValue2 : v2;
  }
  return value;
}
function isType(value, type) {
  var str = {}.toString.call(value);
  return str.indexOf("[object") === 0 && str.indexOf(type + "]") > -1;
}
function invokeWithArgsOrReturn(value, args) {
  return typeof value === "function" ? value.apply(void 0, args) : value;
}
function debounce$2(fn3, ms) {
  if (ms === 0) {
    return fn3;
  }
  var timeout;
  return function(arg) {
    clearTimeout(timeout);
    timeout = setTimeout(function() {
      fn3(arg);
    }, ms);
  };
}
function splitBySpaces(value) {
  return value.split(/\s+/).filter(Boolean);
}
function normalizeToArray(value) {
  return [].concat(value);
}
function pushIfUnique(arr, value) {
  if (arr.indexOf(value) === -1) {
    arr.push(value);
  }
}
function unique$1(arr) {
  return arr.filter(function(item2, index2) {
    return arr.indexOf(item2) === index2;
  });
}
function getBasePlacement(placement) {
  return placement.split("-")[0];
}
function arrayFrom(value) {
  return [].slice.call(value);
}
function removeUndefinedProps(obj) {
  return Object.keys(obj).reduce(function(acc, key) {
    if (obj[key] !== void 0) {
      acc[key] = obj[key];
    }
    return acc;
  }, {});
}
function div() {
  return document.createElement("div");
}
function isElement$1(value) {
  return ["Element", "Fragment"].some(function(type) {
    return isType(value, type);
  });
}
function isNodeList(value) {
  return isType(value, "NodeList");
}
function isMouseEvent(value) {
  return isType(value, "MouseEvent");
}
function isReferenceElement(value) {
  return !!(value && value._tippy && value._tippy.reference === value);
}
function getArrayOfElements(value) {
  if (isElement$1(value)) {
    return [value];
  }
  if (isNodeList(value)) {
    return arrayFrom(value);
  }
  if (Array.isArray(value)) {
    return value;
  }
  return arrayFrom(document.querySelectorAll(value));
}
function setTransitionDuration(els, value) {
  els.forEach(function(el) {
    if (el) {
      el.style.transitionDuration = value + "ms";
    }
  });
}
function setVisibilityState(els, state) {
  els.forEach(function(el) {
    if (el) {
      el.setAttribute("data-state", state);
    }
  });
}
function getOwnerDocument$1(elementOrElements) {
  var _element$ownerDocumen;
  var _normalizeToArray = normalizeToArray(elementOrElements), element = _normalizeToArray[0];
  return (element == null ? void 0 : (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body) ? element.ownerDocument : document;
}
function isCursorOutsideInteractiveBorder(popperTreeData, event) {
  var clientX = event.clientX, clientY = event.clientY;
  return popperTreeData.every(function(_ref) {
    var popperRect = _ref.popperRect, popperState = _ref.popperState, props = _ref.props;
    var interactiveBorder = props.interactiveBorder;
    var basePlacement = getBasePlacement(popperState.placement);
    var offsetData = popperState.modifiersData.offset;
    if (!offsetData) {
      return true;
    }
    var topDistance = basePlacement === "bottom" ? offsetData.top.y : 0;
    var bottomDistance = basePlacement === "top" ? offsetData.bottom.y : 0;
    var leftDistance = basePlacement === "right" ? offsetData.left.x : 0;
    var rightDistance = basePlacement === "left" ? offsetData.right.x : 0;
    var exceedsTop = popperRect.top - clientY + topDistance > interactiveBorder;
    var exceedsBottom = clientY - popperRect.bottom - bottomDistance > interactiveBorder;
    var exceedsLeft = popperRect.left - clientX + leftDistance > interactiveBorder;
    var exceedsRight = clientX - popperRect.right - rightDistance > interactiveBorder;
    return exceedsTop || exceedsBottom || exceedsLeft || exceedsRight;
  });
}
function updateTransitionEndListener(box, action, listener) {
  var method = action + "EventListener";
  ["transitionend", "webkitTransitionEnd"].forEach(function(event) {
    box[method](event, listener);
  });
}
var currentInput = {
  isTouch: false
};
var lastMouseMoveTime = 0;
function onDocumentTouchStart() {
  if (currentInput.isTouch) {
    return;
  }
  currentInput.isTouch = true;
  if (window.performance) {
    document.addEventListener("mousemove", onDocumentMouseMove);
  }
}
function onDocumentMouseMove() {
  var now2 = performance.now();
  if (now2 - lastMouseMoveTime < 20) {
    currentInput.isTouch = false;
    document.removeEventListener("mousemove", onDocumentMouseMove);
  }
  lastMouseMoveTime = now2;
}
function onWindowBlur() {
  var activeElement = document.activeElement;
  if (isReferenceElement(activeElement)) {
    var instance = activeElement._tippy;
    if (activeElement.blur && !instance.state.isVisible) {
      activeElement.blur();
    }
  }
}
function bindGlobalEventListeners() {
  document.addEventListener("touchstart", onDocumentTouchStart, TOUCH_OPTIONS);
  window.addEventListener("blur", onWindowBlur);
}
var isBrowser$1 = typeof window !== "undefined" && typeof document !== "undefined";
var ua = isBrowser$1 ? navigator.userAgent : "";
var isIE$1 = /MSIE |Trident\//.test(ua);
var pluginProps = {
  animateFill: false,
  followCursor: false,
  inlinePositioning: false,
  sticky: false
};
var renderProps = {
  allowHTML: false,
  animation: "fade",
  arrow: true,
  content: "",
  inertia: false,
  maxWidth: 350,
  role: "tooltip",
  theme: "",
  zIndex: 9999
};
var defaultProps$1 = Object.assign({
  appendTo: function appendTo() {
    return document.body;
  },
  aria: {
    content: "auto",
    expanded: "auto"
  },
  delay: 0,
  duration: [300, 250],
  getReferenceClientRect: null,
  hideOnClick: true,
  ignoreAttributes: false,
  interactive: false,
  interactiveBorder: 2,
  interactiveDebounce: 0,
  moveTransition: "",
  offset: [0, 10],
  onAfterUpdate: function onAfterUpdate() {
  },
  onBeforeUpdate: function onBeforeUpdate() {
  },
  onCreate: function onCreate() {
  },
  onDestroy: function onDestroy() {
  },
  onHidden: function onHidden() {
  },
  onHide: function onHide() {
  },
  onMount: function onMount() {
  },
  onShow: function onShow() {
  },
  onShown: function onShown() {
  },
  onTrigger: function onTrigger() {
  },
  onUntrigger: function onUntrigger() {
  },
  onClickOutside: function onClickOutside() {
  },
  placement: "top",
  plugins: [],
  popperOptions: {},
  render: null,
  showOnCreate: false,
  touch: true,
  trigger: "mouseenter focus",
  triggerTarget: null
}, pluginProps, {}, renderProps);
var defaultKeys = Object.keys(defaultProps$1);
var setDefaultProps = function setDefaultProps2(partialProps) {
  var keys2 = Object.keys(partialProps);
  keys2.forEach(function(key) {
    defaultProps$1[key] = partialProps[key];
  });
};
function getExtendedPassedProps(passedProps) {
  var plugins = passedProps.plugins || [];
  var pluginProps2 = plugins.reduce(function(acc, plugin) {
    var name2 = plugin.name, defaultValue2 = plugin.defaultValue;
    if (name2) {
      acc[name2] = passedProps[name2] !== void 0 ? passedProps[name2] : defaultValue2;
    }
    return acc;
  }, {});
  return Object.assign({}, passedProps, {}, pluginProps2);
}
function getDataAttributeProps(reference2, plugins) {
  var propKeys = plugins ? Object.keys(getExtendedPassedProps(Object.assign({}, defaultProps$1, {
    plugins
  }))) : defaultKeys;
  var props = propKeys.reduce(function(acc, key) {
    var valueAsString = (reference2.getAttribute("data-tippy-" + key) || "").trim();
    if (!valueAsString) {
      return acc;
    }
    if (key === "content") {
      acc[key] = valueAsString;
    } else {
      try {
        acc[key] = JSON.parse(valueAsString);
      } catch (e3) {
        acc[key] = valueAsString;
      }
    }
    return acc;
  }, {});
  return props;
}
function evaluateProps(reference2, props) {
  var out = Object.assign({}, props, {
    content: invokeWithArgsOrReturn(props.content, [reference2])
  }, props.ignoreAttributes ? {} : getDataAttributeProps(reference2, props.plugins));
  out.aria = Object.assign({}, defaultProps$1.aria, {}, out.aria);
  out.aria = {
    expanded: out.aria.expanded === "auto" ? props.interactive : out.aria.expanded,
    content: out.aria.content === "auto" ? props.interactive ? null : "describedby" : out.aria.content
  };
  return out;
}
function getChildren(popper2) {
  var box = popper2.firstElementChild;
  var boxChildren = arrayFrom(box.children);
  return {
    box,
    content: boxChildren.find(function(node) {
      return node.classList.contains(CONTENT_CLASS);
    }),
    arrow: boxChildren.find(function(node) {
      return node.classList.contains(ARROW_CLASS) || node.classList.contains(SVG_ARROW_CLASS);
    }),
    backdrop: boxChildren.find(function(node) {
      return node.classList.contains(BACKDROP_CLASS);
    })
  };
}
var idCounter = 1;
var mouseMoveListeners = [];
var mountedInstances = [];
function createTippy(reference2, passedProps) {
  var props = evaluateProps(reference2, Object.assign({}, defaultProps$1, {}, getExtendedPassedProps(removeUndefinedProps(passedProps))));
  var showTimeout;
  var hideTimeout;
  var scheduleHideAnimationFrame;
  var isVisibleFromClick = false;
  var didHideDueToDocumentMouseDown = false;
  var didTouchMove = false;
  var ignoreOnFirstUpdate = false;
  var lastTriggerEvent;
  var currentTransitionEndListener;
  var onFirstUpdate;
  var listeners = [];
  var debouncedOnMouseMove = debounce$2(onMouseMove, props.interactiveDebounce);
  var currentTarget;
  var id = idCounter++;
  var popperInstance = null;
  var plugins = unique$1(props.plugins);
  var state = {
    isEnabled: true,
    isVisible: false,
    isDestroyed: false,
    isMounted: false,
    isShown: false
  };
  var instance = {
    id,
    reference: reference2,
    popper: div(),
    popperInstance,
    props,
    state,
    plugins,
    clearDelayTimeouts,
    setProps,
    setContent,
    show,
    hide: hide2,
    hideWithInteractivity,
    enable,
    disable,
    unmount: unmount2,
    destroy
  };
  if (!props.render) {
    return instance;
  }
  var _props$render = props.render(instance), popper2 = _props$render.popper, onUpdate = _props$render.onUpdate;
  popper2.setAttribute("data-tippy-root", "");
  popper2.id = "tippy-" + instance.id;
  instance.popper = popper2;
  reference2._tippy = instance;
  popper2._tippy = instance;
  var pluginsHooks = plugins.map(function(plugin) {
    return plugin.fn(instance);
  });
  var hasAriaExpanded = reference2.hasAttribute("aria-expanded");
  addListeners();
  handleAriaExpandedAttribute();
  handleStyles();
  invokeHook("onCreate", [instance]);
  if (props.showOnCreate) {
    scheduleShow();
  }
  popper2.addEventListener("mouseenter", function() {
    if (instance.props.interactive && instance.state.isVisible) {
      instance.clearDelayTimeouts();
    }
  });
  popper2.addEventListener("mouseleave", function(event) {
    if (instance.props.interactive && instance.props.trigger.indexOf("mouseenter") >= 0) {
      getDocument2().addEventListener("mousemove", debouncedOnMouseMove);
      debouncedOnMouseMove(event);
    }
  });
  return instance;
  function getNormalizedTouchSettings() {
    var touch = instance.props.touch;
    return Array.isArray(touch) ? touch : [touch, 0];
  }
  function getIsCustomTouchBehavior() {
    return getNormalizedTouchSettings()[0] === "hold";
  }
  function getIsDefaultRenderFn() {
    var _instance$props$rende;
    return !!((_instance$props$rende = instance.props.render) == null ? void 0 : _instance$props$rende.$$tippy);
  }
  function getCurrentTarget() {
    return currentTarget || reference2;
  }
  function getDocument2() {
    var parent = getCurrentTarget().parentNode;
    return parent ? getOwnerDocument$1(parent) : document;
  }
  function getDefaultTemplateChildren() {
    return getChildren(popper2);
  }
  function getDelay(isShow) {
    if (instance.state.isMounted && !instance.state.isVisible || currentInput.isTouch || lastTriggerEvent && lastTriggerEvent.type === "focus") {
      return 0;
    }
    return getValueAtIndexOrReturn(instance.props.delay, isShow ? 0 : 1, defaultProps$1.delay);
  }
  function handleStyles() {
    popper2.style.pointerEvents = instance.props.interactive && instance.state.isVisible ? "" : "none";
    popper2.style.zIndex = "" + instance.props.zIndex;
  }
  function invokeHook(hook, args, shouldInvokePropsHook) {
    if (shouldInvokePropsHook === void 0) {
      shouldInvokePropsHook = true;
    }
    pluginsHooks.forEach(function(pluginHooks) {
      if (pluginHooks[hook]) {
        pluginHooks[hook].apply(void 0, args);
      }
    });
    if (shouldInvokePropsHook) {
      var _instance$props;
      (_instance$props = instance.props)[hook].apply(_instance$props, args);
    }
  }
  function handleAriaContentAttribute() {
    var aria = instance.props.aria;
    if (!aria.content) {
      return;
    }
    var attr = "aria-" + aria.content;
    var id2 = popper2.id;
    var nodes = normalizeToArray(instance.props.triggerTarget || reference2);
    nodes.forEach(function(node) {
      var currentValue = node.getAttribute(attr);
      if (instance.state.isVisible) {
        node.setAttribute(attr, currentValue ? currentValue + " " + id2 : id2);
      } else {
        var nextValue = currentValue && currentValue.replace(id2, "").trim();
        if (nextValue) {
          node.setAttribute(attr, nextValue);
        } else {
          node.removeAttribute(attr);
        }
      }
    });
  }
  function handleAriaExpandedAttribute() {
    if (hasAriaExpanded || !instance.props.aria.expanded) {
      return;
    }
    var nodes = normalizeToArray(instance.props.triggerTarget || reference2);
    nodes.forEach(function(node) {
      if (instance.props.interactive) {
        node.setAttribute("aria-expanded", instance.state.isVisible && node === getCurrentTarget() ? "true" : "false");
      } else {
        node.removeAttribute("aria-expanded");
      }
    });
  }
  function cleanupInteractiveMouseListeners() {
    getDocument2().removeEventListener("mousemove", debouncedOnMouseMove);
    mouseMoveListeners = mouseMoveListeners.filter(function(listener) {
      return listener !== debouncedOnMouseMove;
    });
  }
  function onDocumentPress(event) {
    if (currentInput.isTouch) {
      if (didTouchMove || event.type === "mousedown") {
        return;
      }
    }
    if (instance.props.interactive && popper2.contains(event.target)) {
      return;
    }
    if (getCurrentTarget().contains(event.target)) {
      if (currentInput.isTouch) {
        return;
      }
      if (instance.state.isVisible && instance.props.trigger.indexOf("click") >= 0) {
        return;
      }
    } else {
      invokeHook("onClickOutside", [instance, event]);
    }
    if (instance.props.hideOnClick === true) {
      instance.clearDelayTimeouts();
      instance.hide();
      didHideDueToDocumentMouseDown = true;
      setTimeout(function() {
        didHideDueToDocumentMouseDown = false;
      });
      if (!instance.state.isMounted) {
        removeDocumentPress();
      }
    }
  }
  function onTouchMove() {
    didTouchMove = true;
  }
  function onTouchStart() {
    didTouchMove = false;
  }
  function addDocumentPress() {
    var doc = getDocument2();
    doc.addEventListener("mousedown", onDocumentPress, true);
    doc.addEventListener("touchend", onDocumentPress, TOUCH_OPTIONS);
    doc.addEventListener("touchstart", onTouchStart, TOUCH_OPTIONS);
    doc.addEventListener("touchmove", onTouchMove, TOUCH_OPTIONS);
  }
  function removeDocumentPress() {
    var doc = getDocument2();
    doc.removeEventListener("mousedown", onDocumentPress, true);
    doc.removeEventListener("touchend", onDocumentPress, TOUCH_OPTIONS);
    doc.removeEventListener("touchstart", onTouchStart, TOUCH_OPTIONS);
    doc.removeEventListener("touchmove", onTouchMove, TOUCH_OPTIONS);
  }
  function onTransitionedOut(duration2, callback) {
    onTransitionEnd(duration2, function() {
      if (!instance.state.isVisible && popper2.parentNode && popper2.parentNode.contains(popper2)) {
        callback();
      }
    });
  }
  function onTransitionedIn(duration2, callback) {
    onTransitionEnd(duration2, callback);
  }
  function onTransitionEnd(duration2, callback) {
    var box = getDefaultTemplateChildren().box;
    function listener(event) {
      if (event.target === box) {
        updateTransitionEndListener(box, "remove", listener);
        callback();
      }
    }
    if (duration2 === 0) {
      return callback();
    }
    updateTransitionEndListener(box, "remove", currentTransitionEndListener);
    updateTransitionEndListener(box, "add", listener);
    currentTransitionEndListener = listener;
  }
  function on(eventType, handler, options) {
    if (options === void 0) {
      options = false;
    }
    var nodes = normalizeToArray(instance.props.triggerTarget || reference2);
    nodes.forEach(function(node) {
      node.addEventListener(eventType, handler, options);
      listeners.push({
        node,
        eventType,
        handler,
        options
      });
    });
  }
  function addListeners() {
    if (getIsCustomTouchBehavior()) {
      on("touchstart", onTrigger2, {
        passive: true
      });
      on("touchend", onMouseLeave, {
        passive: true
      });
    }
    splitBySpaces(instance.props.trigger).forEach(function(eventType) {
      if (eventType === "manual") {
        return;
      }
      on(eventType, onTrigger2);
      switch (eventType) {
        case "mouseenter":
          on("mouseleave", onMouseLeave);
          break;
        case "focus":
          on(isIE$1 ? "focusout" : "blur", onBlurOrFocusOut);
          break;
        case "focusin":
          on("focusout", onBlurOrFocusOut);
          break;
      }
    });
  }
  function removeListeners() {
    listeners.forEach(function(_ref) {
      var node = _ref.node, eventType = _ref.eventType, handler = _ref.handler, options = _ref.options;
      node.removeEventListener(eventType, handler, options);
    });
    listeners = [];
  }
  function onTrigger2(event) {
    var _lastTriggerEvent;
    var shouldScheduleClickHide = false;
    if (!instance.state.isEnabled || isEventListenerStopped(event) || didHideDueToDocumentMouseDown) {
      return;
    }
    var wasFocused = ((_lastTriggerEvent = lastTriggerEvent) == null ? void 0 : _lastTriggerEvent.type) === "focus";
    lastTriggerEvent = event;
    currentTarget = event.currentTarget;
    handleAriaExpandedAttribute();
    if (!instance.state.isVisible && isMouseEvent(event)) {
      mouseMoveListeners.forEach(function(listener) {
        return listener(event);
      });
    }
    if (event.type === "click" && (instance.props.trigger.indexOf("mouseenter") < 0 || isVisibleFromClick) && instance.props.hideOnClick !== false && instance.state.isVisible) {
      shouldScheduleClickHide = true;
    } else {
      scheduleShow(event);
    }
    if (event.type === "click") {
      isVisibleFromClick = !shouldScheduleClickHide;
    }
    if (shouldScheduleClickHide && !wasFocused) {
      scheduleHide(event);
    }
  }
  function onMouseMove(event) {
    var target = event.target;
    var isCursorOverReferenceOrPopper = getCurrentTarget().contains(target) || popper2.contains(target);
    if (event.type === "mousemove" && isCursorOverReferenceOrPopper) {
      return;
    }
    var popperTreeData = getNestedPopperTree().concat(popper2).map(function(popper3) {
      var _instance$popperInsta;
      var instance2 = popper3._tippy;
      var state2 = (_instance$popperInsta = instance2.popperInstance) == null ? void 0 : _instance$popperInsta.state;
      if (state2) {
        return {
          popperRect: popper3.getBoundingClientRect(),
          popperState: state2,
          props
        };
      }
      return null;
    }).filter(Boolean);
    if (isCursorOutsideInteractiveBorder(popperTreeData, event)) {
      cleanupInteractiveMouseListeners();
      scheduleHide(event);
    }
  }
  function onMouseLeave(event) {
    var shouldBail = isEventListenerStopped(event) || instance.props.trigger.indexOf("click") >= 0 && isVisibleFromClick;
    if (shouldBail) {
      return;
    }
    if (instance.props.interactive) {
      instance.hideWithInteractivity(event);
      return;
    }
    scheduleHide(event);
  }
  function onBlurOrFocusOut(event) {
    if (instance.props.trigger.indexOf("focusin") < 0 && event.target !== getCurrentTarget()) {
      return;
    }
    if (instance.props.interactive && event.relatedTarget && popper2.contains(event.relatedTarget)) {
      return;
    }
    scheduleHide(event);
  }
  function isEventListenerStopped(event) {
    return currentInput.isTouch ? getIsCustomTouchBehavior() !== event.type.indexOf("touch") >= 0 : false;
  }
  function createPopperInstance() {
    destroyPopperInstance();
    var _instance$props2 = instance.props, popperOptions = _instance$props2.popperOptions, placement = _instance$props2.placement, offset4 = _instance$props2.offset, getReferenceClientRect = _instance$props2.getReferenceClientRect, moveTransition = _instance$props2.moveTransition;
    var arrow2 = getIsDefaultRenderFn() ? getChildren(popper2).arrow : null;
    var computedReference = getReferenceClientRect ? {
      getBoundingClientRect: getReferenceClientRect,
      contextElement: getReferenceClientRect.contextElement || getCurrentTarget()
    } : reference2;
    var tippyModifier = {
      name: "$$tippy",
      enabled: true,
      phase: "beforeWrite",
      requires: ["computeStyles"],
      fn: function fn3(_ref2) {
        var state2 = _ref2.state;
        if (getIsDefaultRenderFn()) {
          var _getDefaultTemplateCh = getDefaultTemplateChildren(), box = _getDefaultTemplateCh.box;
          ["placement", "reference-hidden", "escaped"].forEach(function(attr) {
            if (attr === "placement") {
              box.setAttribute("data-placement", state2.placement);
            } else {
              if (state2.attributes.popper["data-popper-" + attr]) {
                box.setAttribute("data-" + attr, "");
              } else {
                box.removeAttribute("data-" + attr);
              }
            }
          });
          state2.attributes.popper = {};
        }
      }
    };
    var modifiers = [{
      name: "offset",
      options: {
        offset: offset4
      }
    }, {
      name: "preventOverflow",
      options: {
        padding: {
          top: 2,
          bottom: 2,
          left: 5,
          right: 5
        }
      }
    }, {
      name: "flip",
      options: {
        padding: 5
      }
    }, {
      name: "computeStyles",
      options: {
        adaptive: !moveTransition
      }
    }, tippyModifier];
    if (getIsDefaultRenderFn() && arrow2) {
      modifiers.push({
        name: "arrow",
        options: {
          element: arrow2,
          padding: 3
        }
      });
    }
    modifiers.push.apply(modifiers, (popperOptions == null ? void 0 : popperOptions.modifiers) || []);
    instance.popperInstance = createPopper(computedReference, popper2, Object.assign({}, popperOptions, {
      placement,
      onFirstUpdate,
      modifiers
    }));
  }
  function destroyPopperInstance() {
    if (instance.popperInstance) {
      instance.popperInstance.destroy();
      instance.popperInstance = null;
    }
  }
  function mount() {
    var appendTo2 = instance.props.appendTo;
    var parentNode;
    var node = getCurrentTarget();
    if (instance.props.interactive && appendTo2 === defaultProps$1.appendTo || appendTo2 === "parent") {
      parentNode = node.parentNode;
    } else {
      parentNode = invokeWithArgsOrReturn(appendTo2, [node]);
    }
    if (!parentNode.contains(popper2)) {
      parentNode.appendChild(popper2);
    }
    createPopperInstance();
  }
  function getNestedPopperTree() {
    return arrayFrom(popper2.querySelectorAll("[data-tippy-root]"));
  }
  function scheduleShow(event) {
    instance.clearDelayTimeouts();
    if (event) {
      invokeHook("onTrigger", [instance, event]);
    }
    addDocumentPress();
    var delay = getDelay(true);
    var _getNormalizedTouchSe = getNormalizedTouchSettings(), touchValue = _getNormalizedTouchSe[0], touchDelay = _getNormalizedTouchSe[1];
    if (currentInput.isTouch && touchValue === "hold" && touchDelay) {
      delay = touchDelay;
    }
    if (delay) {
      showTimeout = setTimeout(function() {
        instance.show();
      }, delay);
    } else {
      instance.show();
    }
  }
  function scheduleHide(event) {
    instance.clearDelayTimeouts();
    invokeHook("onUntrigger", [instance, event]);
    if (!instance.state.isVisible) {
      removeDocumentPress();
      return;
    }
    if (instance.props.trigger.indexOf("mouseenter") >= 0 && instance.props.trigger.indexOf("click") >= 0 && ["mouseleave", "mousemove"].indexOf(event.type) >= 0 && isVisibleFromClick) {
      return;
    }
    var delay = getDelay(false);
    if (delay) {
      hideTimeout = setTimeout(function() {
        if (instance.state.isVisible) {
          instance.hide();
        }
      }, delay);
    } else {
      scheduleHideAnimationFrame = requestAnimationFrame(function() {
        instance.hide();
      });
    }
  }
  function enable() {
    instance.state.isEnabled = true;
  }
  function disable() {
    instance.hide();
    instance.state.isEnabled = false;
  }
  function clearDelayTimeouts() {
    clearTimeout(showTimeout);
    clearTimeout(hideTimeout);
    cancelAnimationFrame(scheduleHideAnimationFrame);
  }
  function setProps(partialProps) {
    if (instance.state.isDestroyed) {
      return;
    }
    invokeHook("onBeforeUpdate", [instance, partialProps]);
    removeListeners();
    var prevProps = instance.props;
    var nextProps = evaluateProps(reference2, Object.assign({}, instance.props, {}, partialProps, {
      ignoreAttributes: true
    }));
    instance.props = nextProps;
    addListeners();
    if (prevProps.interactiveDebounce !== nextProps.interactiveDebounce) {
      cleanupInteractiveMouseListeners();
      debouncedOnMouseMove = debounce$2(onMouseMove, nextProps.interactiveDebounce);
    }
    if (prevProps.triggerTarget && !nextProps.triggerTarget) {
      normalizeToArray(prevProps.triggerTarget).forEach(function(node) {
        node.removeAttribute("aria-expanded");
      });
    } else if (nextProps.triggerTarget) {
      reference2.removeAttribute("aria-expanded");
    }
    handleAriaExpandedAttribute();
    handleStyles();
    if (onUpdate) {
      onUpdate(prevProps, nextProps);
    }
    if (instance.popperInstance) {
      createPopperInstance();
      getNestedPopperTree().forEach(function(nestedPopper) {
        requestAnimationFrame(nestedPopper._tippy.popperInstance.forceUpdate);
      });
    }
    invokeHook("onAfterUpdate", [instance, partialProps]);
  }
  function setContent(content2) {
    instance.setProps({
      content: content2
    });
  }
  function show() {
    var isAlreadyVisible = instance.state.isVisible;
    var isDestroyed = instance.state.isDestroyed;
    var isDisabled = !instance.state.isEnabled;
    var isTouchAndTouchDisabled = currentInput.isTouch && !instance.props.touch;
    var duration2 = getValueAtIndexOrReturn(instance.props.duration, 0, defaultProps$1.duration);
    if (isAlreadyVisible || isDestroyed || isDisabled || isTouchAndTouchDisabled) {
      return;
    }
    if (getCurrentTarget().hasAttribute("disabled")) {
      return;
    }
    invokeHook("onShow", [instance], false);
    if (instance.props.onShow(instance) === false) {
      return;
    }
    instance.state.isVisible = true;
    if (getIsDefaultRenderFn()) {
      popper2.style.visibility = "visible";
    }
    handleStyles();
    addDocumentPress();
    if (!instance.state.isMounted) {
      popper2.style.transition = "none";
    }
    if (getIsDefaultRenderFn()) {
      var _getDefaultTemplateCh2 = getDefaultTemplateChildren(), box = _getDefaultTemplateCh2.box, content2 = _getDefaultTemplateCh2.content;
      setTransitionDuration([box, content2], 0);
    }
    onFirstUpdate = function onFirstUpdate2() {
      var _instance$popperInsta2;
      if (!instance.state.isVisible || ignoreOnFirstUpdate) {
        return;
      }
      ignoreOnFirstUpdate = true;
      void popper2.offsetHeight;
      popper2.style.transition = instance.props.moveTransition;
      if (getIsDefaultRenderFn() && instance.props.animation) {
        var _getDefaultTemplateCh3 = getDefaultTemplateChildren(), _box = _getDefaultTemplateCh3.box, _content = _getDefaultTemplateCh3.content;
        setTransitionDuration([_box, _content], duration2);
        setVisibilityState([_box, _content], "visible");
      }
      handleAriaContentAttribute();
      handleAriaExpandedAttribute();
      pushIfUnique(mountedInstances, instance);
      (_instance$popperInsta2 = instance.popperInstance) == null ? void 0 : _instance$popperInsta2.forceUpdate();
      instance.state.isMounted = true;
      invokeHook("onMount", [instance]);
      if (instance.props.animation && getIsDefaultRenderFn()) {
        onTransitionedIn(duration2, function() {
          instance.state.isShown = true;
          invokeHook("onShown", [instance]);
        });
      }
    };
    mount();
  }
  function hide2() {
    var isAlreadyHidden = !instance.state.isVisible;
    var isDestroyed = instance.state.isDestroyed;
    var isDisabled = !instance.state.isEnabled;
    var duration2 = getValueAtIndexOrReturn(instance.props.duration, 1, defaultProps$1.duration);
    if (isAlreadyHidden || isDestroyed || isDisabled) {
      return;
    }
    invokeHook("onHide", [instance], false);
    if (instance.props.onHide(instance) === false) {
      return;
    }
    instance.state.isVisible = false;
    instance.state.isShown = false;
    ignoreOnFirstUpdate = false;
    isVisibleFromClick = false;
    if (getIsDefaultRenderFn()) {
      popper2.style.visibility = "hidden";
    }
    cleanupInteractiveMouseListeners();
    removeDocumentPress();
    handleStyles();
    if (getIsDefaultRenderFn()) {
      var _getDefaultTemplateCh4 = getDefaultTemplateChildren(), box = _getDefaultTemplateCh4.box, content2 = _getDefaultTemplateCh4.content;
      if (instance.props.animation) {
        setTransitionDuration([box, content2], duration2);
        setVisibilityState([box, content2], "hidden");
      }
    }
    handleAriaContentAttribute();
    handleAriaExpandedAttribute();
    if (instance.props.animation) {
      if (getIsDefaultRenderFn()) {
        onTransitionedOut(duration2, instance.unmount);
      }
    } else {
      instance.unmount();
    }
  }
  function hideWithInteractivity(event) {
    getDocument2().addEventListener("mousemove", debouncedOnMouseMove);
    pushIfUnique(mouseMoveListeners, debouncedOnMouseMove);
    debouncedOnMouseMove(event);
  }
  function unmount2() {
    if (instance.state.isVisible) {
      instance.hide();
    }
    if (!instance.state.isMounted) {
      return;
    }
    destroyPopperInstance();
    getNestedPopperTree().forEach(function(nestedPopper) {
      nestedPopper._tippy.unmount();
    });
    if (popper2.parentNode) {
      popper2.parentNode.removeChild(popper2);
    }
    mountedInstances = mountedInstances.filter(function(i2) {
      return i2 !== instance;
    });
    instance.state.isMounted = false;
    invokeHook("onHidden", [instance]);
  }
  function destroy() {
    if (instance.state.isDestroyed) {
      return;
    }
    instance.clearDelayTimeouts();
    instance.unmount();
    removeListeners();
    delete reference2._tippy;
    instance.state.isDestroyed = true;
    invokeHook("onDestroy", [instance]);
  }
}
function tippy(targets, optionalProps) {
  if (optionalProps === void 0) {
    optionalProps = {};
  }
  var plugins = defaultProps$1.plugins.concat(optionalProps.plugins || []);
  bindGlobalEventListeners();
  var passedProps = Object.assign({}, optionalProps, {
    plugins
  });
  var elements = getArrayOfElements(targets);
  var instances = elements.reduce(function(acc, reference2) {
    var instance = reference2 && createTippy(reference2, passedProps);
    if (instance) {
      acc.push(instance);
    }
    return acc;
  }, []);
  return isElement$1(targets) ? instances[0] : instances;
}
tippy.defaultProps = defaultProps$1;
tippy.setDefaultProps = setDefaultProps;
tippy.currentInput = currentInput;
Object.assign({}, applyStyles$1, {
  effect: function effect2(_ref) {
    var state = _ref.state;
    var initialStyles2 = {
      popper: {
        position: state.options.strategy,
        left: "0",
        top: "0",
        margin: "0"
      },
      arrow: {
        position: "absolute"
      },
      reference: {}
    };
    Object.assign(state.elements.popper.style, initialStyles2.popper);
    state.styles = initialStyles2;
    if (state.elements.arrow) {
      Object.assign(state.elements.arrow.style, initialStyles2.arrow);
    }
  }
});
tippy.setDefaultProps({
  animation: false
});
function _objectWithoutPropertiesLoose$1(source2, excluded) {
  if (source2 == null)
    return {};
  var target = {};
  var sourceKeys = Object.keys(source2);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0)
      continue;
    target[key] = source2[key];
  }
  return target;
}
var isBrowser = typeof window !== "undefined" && typeof document !== "undefined";
function preserveRef(ref, node) {
  if (ref) {
    if (typeof ref === "function") {
      ref(node);
    }
    if ({}.hasOwnProperty.call(ref, "current")) {
      ref.current = node;
    }
  }
}
function ssrSafeCreateDiv() {
  return isBrowser && document.createElement("div");
}
function toDataAttributes(attrs) {
  var dataAttrs = {
    "data-placement": attrs.placement
  };
  if (attrs.referenceHidden) {
    dataAttrs["data-reference-hidden"] = "";
  }
  if (attrs.escaped) {
    dataAttrs["data-escaped"] = "";
  }
  return dataAttrs;
}
function deepEqual(x2, y4) {
  if (x2 === y4) {
    return true;
  } else if (typeof x2 === "object" && x2 != null && typeof y4 === "object" && y4 != null) {
    if (Object.keys(x2).length !== Object.keys(y4).length) {
      return false;
    }
    for (var prop in x2) {
      if (y4.hasOwnProperty(prop)) {
        if (!deepEqual(x2[prop], y4[prop])) {
          return false;
        }
      } else {
        return false;
      }
    }
    return true;
  } else {
    return false;
  }
}
function uniqueByShape(arr) {
  var output = [];
  arr.forEach(function(item2) {
    if (!output.find(function(outputItem) {
      return deepEqual(item2, outputItem);
    })) {
      output.push(item2);
    }
  });
  return output;
}
function deepPreserveProps(instanceProps, componentProps) {
  var _instanceProps$popper, _componentProps$poppe;
  return Object.assign({}, componentProps, {
    popperOptions: Object.assign({}, instanceProps.popperOptions, componentProps.popperOptions, {
      modifiers: uniqueByShape([].concat(((_instanceProps$popper = instanceProps.popperOptions) == null ? void 0 : _instanceProps$popper.modifiers) || [], ((_componentProps$poppe = componentProps.popperOptions) == null ? void 0 : _componentProps$poppe.modifiers) || []))
    })
  });
}
var useIsomorphicLayoutEffect$4 = isBrowser ? useLayoutEffect$6 : useEffect;
function useMutableBox(initialValue) {
  var ref = useRef();
  if (!ref.current) {
    ref.current = typeof initialValue === "function" ? initialValue() : initialValue;
  }
  return ref.current;
}
function updateClassName(box, action, classNames) {
  classNames.split(/\s+/).forEach(function(name2) {
    if (name2) {
      box.classList[action](name2);
    }
  });
}
var classNamePlugin = {
  name: "className",
  defaultValue: "",
  fn: function fn2(instance) {
    var box = instance.popper.firstElementChild;
    var isDefaultRenderFn = function isDefaultRenderFn2() {
      var _instance$props$rende;
      return !!((_instance$props$rende = instance.props.render) == null ? void 0 : _instance$props$rende.$$tippy);
    };
    function add3() {
      if (instance.props.className && !isDefaultRenderFn()) {
        return;
      }
      updateClassName(box, "add", instance.props.className);
    }
    function remove() {
      if (isDefaultRenderFn()) {
        updateClassName(box, "remove", instance.props.className);
      }
    }
    return {
      onCreate: add3,
      onBeforeUpdate: remove,
      onAfterUpdate: add3
    };
  }
};
function TippyGenerator(tippy2) {
  function Tippy2(_ref) {
    var children = _ref.children, content2 = _ref.content, visible = _ref.visible, singleton = _ref.singleton, render4 = _ref.render, reference2 = _ref.reference, _ref$disabled = _ref.disabled, disabled2 = _ref$disabled === void 0 ? false : _ref$disabled, _ref$ignoreAttributes = _ref.ignoreAttributes, ignoreAttributes = _ref$ignoreAttributes === void 0 ? true : _ref$ignoreAttributes;
    _ref.__source;
    _ref.__self;
    var restOfNativeProps = _objectWithoutPropertiesLoose$1(_ref, ["children", "content", "visible", "singleton", "render", "reference", "disabled", "ignoreAttributes", "__source", "__self"]);
    var isControlledMode = visible !== void 0;
    var isSingletonMode = singleton !== void 0;
    var _useState = useState$1(false), mounted = _useState[0], setMounted = _useState[1];
    var _useState2 = useState$1({}), attrs = _useState2[0], setAttrs = _useState2[1];
    var _useState3 = useState$1(), singletonContent = _useState3[0], setSingletonContent = _useState3[1];
    var mutableBox = useMutableBox(function() {
      return {
        container: ssrSafeCreateDiv(),
        renders: 1
      };
    });
    var props = Object.assign({
      ignoreAttributes
    }, restOfNativeProps, {
      content: mutableBox.container
    });
    if (isControlledMode) {
      props.trigger = "manual";
      props.hideOnClick = false;
    }
    if (isSingletonMode) {
      disabled2 = true;
    }
    var computedProps = props;
    var plugins = props.plugins || [];
    if (render4) {
      computedProps = Object.assign({}, props, {
        plugins: isSingletonMode ? [].concat(plugins, [{
          fn: function fn3() {
            return {
              onTrigger: function onTrigger2(_, event) {
                var _singleton$data$child = singleton.data.children.find(function(_ref2) {
                  var instance = _ref2.instance;
                  return instance.reference === event.currentTarget;
                }), content3 = _singleton$data$child.content;
                setSingletonContent(content3);
              }
            };
          }
        }]) : plugins,
        render: function render5() {
          return {
            popper: mutableBox.container
          };
        }
      });
    }
    var deps = [reference2].concat(children ? [children.type] : []);
    useIsomorphicLayoutEffect$4(function() {
      var element = reference2;
      if (reference2 && reference2.hasOwnProperty("current")) {
        element = reference2.current;
      }
      var instance = tippy2(element || mutableBox.ref || ssrSafeCreateDiv(), Object.assign({}, computedProps, {
        plugins: [classNamePlugin].concat(props.plugins || [])
      }));
      mutableBox.instance = instance;
      if (disabled2) {
        instance.disable();
      }
      if (visible) {
        instance.show();
      }
      if (isSingletonMode) {
        singleton.hook({
          instance,
          content: content2,
          props: computedProps
        });
      }
      setMounted(true);
      return function() {
        instance.destroy();
        singleton == null ? void 0 : singleton.cleanup(instance);
      };
    }, deps);
    useIsomorphicLayoutEffect$4(function() {
      var _instance$popperInsta;
      if (mutableBox.renders === 1) {
        mutableBox.renders++;
        return;
      }
      var instance = mutableBox.instance;
      instance.setProps(deepPreserveProps(instance.props, computedProps));
      (_instance$popperInsta = instance.popperInstance) == null ? void 0 : _instance$popperInsta.forceUpdate();
      if (disabled2) {
        instance.disable();
      } else {
        instance.enable();
      }
      if (isControlledMode) {
        if (visible) {
          instance.show();
        } else {
          instance.hide();
        }
      }
      if (isSingletonMode) {
        singleton.hook({
          instance,
          content: content2,
          props: computedProps
        });
      }
    });
    useIsomorphicLayoutEffect$4(function() {
      var _instance$props$poppe;
      if (!render4) {
        return;
      }
      var instance = mutableBox.instance;
      instance.setProps({
        popperOptions: Object.assign({}, instance.props.popperOptions, {
          modifiers: [].concat((((_instance$props$poppe = instance.props.popperOptions) == null ? void 0 : _instance$props$poppe.modifiers) || []).filter(function(_ref3) {
            var name2 = _ref3.name;
            return name2 !== "$$tippyReact";
          }), [{
            name: "$$tippyReact",
            enabled: true,
            phase: "beforeWrite",
            requires: ["computeStyles"],
            fn: function fn3(_ref4) {
              var _state$modifiersData;
              var state = _ref4.state;
              var hideData = (_state$modifiersData = state.modifiersData) == null ? void 0 : _state$modifiersData.hide;
              if (attrs.placement !== state.placement || attrs.referenceHidden !== (hideData == null ? void 0 : hideData.isReferenceHidden) || attrs.escaped !== (hideData == null ? void 0 : hideData.hasPopperEscaped)) {
                setAttrs({
                  placement: state.placement,
                  referenceHidden: hideData == null ? void 0 : hideData.isReferenceHidden,
                  escaped: hideData == null ? void 0 : hideData.hasPopperEscaped
                });
              }
              state.attributes.popper = {};
            }
          }])
        })
      });
    }, [attrs.placement, attrs.referenceHidden, attrs.escaped].concat(deps));
    return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, children ? /* @__PURE__ */ cloneElement$1(children, {
      ref: function ref(node) {
        mutableBox.ref = node;
        preserveRef(children.ref, node);
      }
    }) : null, mounted && /* @__PURE__ */ createPortal(render4 ? render4(toDataAttributes(attrs), singletonContent, mutableBox.instance) : content2, mutableBox.container));
  }
  return Tippy2;
}
var forwardRef$2 = function(Tippy2, defaultProps2) {
  return /* @__PURE__ */ forwardRef$3(function TippyWrapper(_ref, _ref2) {
    var children = _ref.children, props = _objectWithoutPropertiesLoose$1(_ref, ["children"]);
    return /* @__PURE__ */ React__default.createElement(Tippy2, Object.assign({}, defaultProps2, props), children ? /* @__PURE__ */ cloneElement$1(children, {
      ref: function ref(node) {
        preserveRef(_ref2, node);
        preserveRef(children.ref, node);
      }
    }) : null);
  });
};
var headless = /* @__PURE__ */ forwardRef$2(/* @__PURE__ */ TippyGenerator(tippy), {
  render: function render2() {
    return "";
  }
});
var Tippy = headless;
const tooltip = "_tooltip_1x7yk_1";
const tooltip__Custom = "_tooltip__Custom_1x7yk_9";
var styles$q = {
  tooltip,
  tooltip__Custom
};
const config$1 = { tension: 90, friction: 10, precision: 0.1, duration: 160 };
const initialStyles = { opacity: 0, transform: "scale(0.6)" };
const Tooltip = (_g) => {
  var _h = _g, {
    mode,
    onMount: onMount2,
    onHide: onHide2,
    content: content2,
    children,
    invertTheme = false,
    appendTo: customizeAppendTo
  } = _h, tippyProps = __objRest(_h, [
    "mode",
    "onMount",
    "onHide",
    "content",
    "children",
    "invertTheme",
    "appendTo"
  ]);
  const appendTo2 = useCallback$1(() => document.querySelector("#root > .Theme"), []);
  const [props, setSpring] = useSpring(() => initialStyles);
  const { themeClassNames } = useTheme();
  const _onMount = (instance) => {
    setSpring({
      opacity: 1,
      transform: "scale(1)",
      onRest: () => {
      },
      config: config$1
    });
    if (onMount2)
      onMount2(instance);
  };
  const _onHide = (instance) => {
    const { unmount: unmount2 } = instance;
    setSpring(__spreadProps(__spreadValues({}, initialStyles), {
      onRest: unmount2,
      config: __spreadProps(__spreadValues({}, config$1), { clamp: true })
    }));
    if (onHide2)
      onHide2(instance);
  };
  return /* @__PURE__ */ React__default.createElement(Tippy, __spreadValues({
    animation: true,
    onMount: _onMount,
    onHide: _onHide,
    render: (attrs) => {
      return /* @__PURE__ */ React__default.createElement(animated.div, __spreadProps(__spreadValues({
        style: props
      }, attrs), {
        className: cn$1(styles$q.tooltip, {
          [themeClassNames.color.invert]: invertTheme,
          [styles$q.tooltip__Custom]: mode === "custom"
        }, tippyProps == null ? void 0 : tippyProps.contentClassName)
      }), content2, /* @__PURE__ */ React__default.createElement("div", {
        "data-popper-arrow": ""
      }));
    },
    appendTo: customizeAppendTo || appendTo2
  }, tippyProps), children);
};
var ColorPicker$2 = "";
const chromePickerStyles = {
  default: {
    body: {
      padding: "var(--space-m) var(--space-m) var(--space-s)"
    }
  }
};
const ColorPicker = forwardRef$3(({
  initialOpen = false,
  value,
  size = "M",
  disabled: disabled2 = false,
  alert = false,
  onChange: onChange2,
  onChangeComplete,
  appendTo: appendTo2
}, pickerRef) => {
  const ref = useRef(null);
  const [open, setOpen] = useState$1(initialOpen);
  const [color, setColor] = useState$1(formatColorToRgb(value));
  const [isValid2, setIsValid] = useState$1(tinycolor(value).isValid());
  useEffect(() => {
    const valueFromProps = value ? formatColorToRgb(value) : formatColorToRgb();
    const equals = tinycolor.equals(valueFromProps, color);
    if (!equals || !isValid2) {
      setColor(valueFromProps);
      setIsValid(tinycolor(value).isValid());
    }
  }, [value]);
  const handleChange = useCallback$1((color2) => {
    setColor(color2.rgb);
    setIsValid(tinycolor(color2.rgb).isValid());
    if (onChange2)
      onChange2(formatColorOutput(color2.rgb));
  }, [onChange2]);
  const handleChangeComplete = useCallback$1((color2) => {
    if (onChangeComplete)
      onChangeComplete(formatColorOutput(color2.rgb));
  }, [onChangeComplete]);
  const onToggleOpen = useCallback$1(() => setOpen((prev) => !prev), []);
  return /* @__PURE__ */ React__default.createElement(Tooltip, {
    placement: "bottom-start",
    invertTheme: false,
    visible: open,
    onClickOutside: onToggleOpen,
    content: /* @__PURE__ */ React__default.createElement(ChromePicker, {
      styles: chromePickerStyles,
      className: "colorPicker",
      color,
      onChange: handleChange,
      onChangeComplete: handleChangeComplete
    }),
    interactive: true,
    disabled: disabled2,
    mode: "custom",
    appendTo: appendTo2
  }, /* @__PURE__ */ React__default.createElement("button", {
    ref: mergeRefs([pickerRef, ref]),
    className: cn$1("colorPickerToggle", {
      colorPickerToggle__SizeL: size === "L",
      colorPickerToggle__SizeS: size === "S",
      colorPickerToggle__SizeXS: size === "XS",
      colorPickerToggle__Alert: alert,
      colorPickerToggle__Unset: !isValid2
    }),
    type: "button",
    onClick: onToggleOpen
  }, /* @__PURE__ */ React__default.createElement("span", {
    style: { backgroundColor: tinycolor(color).toRgbString() }
  })));
});
var ColorPicker$1 = memo(ColorPicker);
function formatColorOutput(color) {
  return {
    hex: tinycolor(color).toHex(),
    hex8: tinycolor(color).toHex8(),
    rgb: tinycolor(color).toRgb(),
    rgbString: tinycolor(color).toRgbString(),
    hsl: tinycolor(color).toHsl(),
    hslString: tinycolor(color).toHslString()
  };
}
function formatColorToRgb(color) {
  return tinycolor(color).toRgb();
}
var dateFns = {};
var interopRequireWildcard = { exports: {} };
var _typeof$6 = { exports: {} };
(function(module2) {
  function _typeof2(obj) {
    "@babel/helpers - typeof";
    return module2.exports = _typeof2 = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(obj2) {
      return typeof obj2;
    } : function(obj2) {
      return obj2 && typeof Symbol == "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    }, module2.exports.__esModule = true, module2.exports["default"] = module2.exports, _typeof2(obj);
  }
  module2.exports = _typeof2, module2.exports.__esModule = true, module2.exports["default"] = module2.exports;
})(_typeof$6);
(function(module2) {
  var _typeof2 = _typeof$6.exports["default"];
  function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function")
      return null;
    var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
    var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
    return (_getRequireWildcardCache = function _getRequireWildcardCache2(nodeInterop2) {
      return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
  }
  function _interopRequireWildcard2(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
      return obj;
    }
    if (obj === null || _typeof2(obj) !== "object" && typeof obj !== "function") {
      return {
        "default": obj
      };
    }
    var cache2 = _getRequireWildcardCache(nodeInterop);
    if (cache2 && cache2.has(obj)) {
      return cache2.get(obj);
    }
    var newObj = {};
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for (var key in obj) {
      if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
        if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }
    newObj["default"] = obj;
    if (cache2) {
      cache2.set(obj, newObj);
    }
    return newObj;
  }
  module2.exports = _interopRequireWildcard2, module2.exports.__esModule = true, module2.exports["default"] = module2.exports;
})(interopRequireWildcard);
function _typeof$5(o) {
  "@babel/helpers - typeof";
  return _typeof$5 = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(o2) {
    return typeof o2;
  } : function(o2) {
    return o2 && typeof Symbol == "function" && o2.constructor === Symbol && o2 !== Symbol.prototype ? "symbol" : typeof o2;
  }, _typeof$5(o);
}
function toInteger$1(dirtyNumber) {
  if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
    return NaN;
  }
  var number = Number(dirtyNumber);
  if (isNaN(number)) {
    return number;
  }
  return number < 0 ? Math.ceil(number) : Math.floor(number);
}
function requiredArgs$1(required, args) {
  if (args.length < required) {
    throw new TypeError(required + " argument" + (required > 1 ? "s" : "") + " required, but only " + args.length + " present");
  }
}
function toDate$1(argument) {
  requiredArgs$1(1, arguments);
  var argStr = Object.prototype.toString.call(argument);
  if (argument instanceof Date || _typeof$5(argument) === "object" && argStr === "[object Date]") {
    return new Date(argument.getTime());
  } else if (typeof argument === "number" || argStr === "[object Number]") {
    return new Date(argument);
  } else {
    if ((typeof argument === "string" || argStr === "[object String]") && typeof console !== "undefined") {
      console.warn("Starting with v2.0.0-beta.1 date-fns doesn't accept strings as date arguments. Please use `parseISO` to parse strings. See: https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#string-arguments");
      console.warn(new Error().stack);
    }
    return new Date(NaN);
  }
}
function addDays(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var amount = toInteger$1(dirtyAmount);
  if (isNaN(amount)) {
    return new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  date.setDate(date.getDate() + amount);
  return date;
}
function addMonths(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var amount = toInteger$1(dirtyAmount);
  if (isNaN(amount)) {
    return new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  var dayOfMonth = date.getDate();
  var endOfDesiredMonth = new Date(date.getTime());
  endOfDesiredMonth.setMonth(date.getMonth() + amount + 1, 0);
  var daysInMonth = endOfDesiredMonth.getDate();
  if (dayOfMonth >= daysInMonth) {
    return endOfDesiredMonth;
  } else {
    date.setFullYear(endOfDesiredMonth.getFullYear(), endOfDesiredMonth.getMonth(), dayOfMonth);
    return date;
  }
}
function add$2(dirtyDate, duration2) {
  requiredArgs$1(2, arguments);
  if (!duration2 || _typeof$5(duration2) !== "object")
    return new Date(NaN);
  var years = duration2.years ? toInteger$1(duration2.years) : 0;
  var months2 = duration2.months ? toInteger$1(duration2.months) : 0;
  var weeks = duration2.weeks ? toInteger$1(duration2.weeks) : 0;
  var days2 = duration2.days ? toInteger$1(duration2.days) : 0;
  var hours = duration2.hours ? toInteger$1(duration2.hours) : 0;
  var minutes = duration2.minutes ? toInteger$1(duration2.minutes) : 0;
  var seconds = duration2.seconds ? toInteger$1(duration2.seconds) : 0;
  var date = toDate$1(dirtyDate);
  var dateWithMonths = months2 || years ? addMonths(date, months2 + years * 12) : date;
  var dateWithDays = days2 || weeks ? addDays(dateWithMonths, days2 + weeks * 7) : dateWithMonths;
  var minutesToAdd = minutes + hours * 60;
  var secondsToAdd = seconds + minutesToAdd * 60;
  var msToAdd = secondsToAdd * 1e3;
  var finalDate = new Date(dateWithDays.getTime() + msToAdd);
  return finalDate;
}
function isWeekend(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var day = date.getDay();
  return day === 0 || day === 6;
}
function isSunday(dirtyDate) {
  requiredArgs$1(1, arguments);
  return toDate$1(dirtyDate).getDay() === 0;
}
function isSaturday(dirtyDate) {
  requiredArgs$1(1, arguments);
  return toDate$1(dirtyDate).getDay() === 6;
}
function addBusinessDays(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var startedOnWeekend = isWeekend(date);
  var amount = toInteger$1(dirtyAmount);
  if (isNaN(amount))
    return new Date(NaN);
  var hours = date.getHours();
  var sign = amount < 0 ? -1 : 1;
  var fullWeeks = toInteger$1(amount / 5);
  date.setDate(date.getDate() + fullWeeks * 7);
  var restDays = Math.abs(amount % 5);
  while (restDays > 0) {
    date.setDate(date.getDate() + sign);
    if (!isWeekend(date))
      restDays -= 1;
  }
  if (startedOnWeekend && isWeekend(date) && amount !== 0) {
    if (isSaturday(date))
      date.setDate(date.getDate() + (sign < 0 ? 2 : -1));
    if (isSunday(date))
      date.setDate(date.getDate() + (sign < 0 ? 1 : -2));
  }
  date.setHours(hours);
  return date;
}
function addMilliseconds$1(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var timestamp = toDate$1(dirtyDate).getTime();
  var amount = toInteger$1(dirtyAmount);
  return new Date(timestamp + amount);
}
var MILLISECONDS_IN_HOUR$1 = 36e5;
function addHours(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addMilliseconds$1(dirtyDate, amount * MILLISECONDS_IN_HOUR$1);
}
var defaultOptions$1 = {};
function getDefaultOptions$1() {
  return defaultOptions$1;
}
function setDefaultOptions$1(newOptions) {
  defaultOptions$1 = newOptions;
}
function startOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(1, arguments);
  var defaultOptions2 = getDefaultOptions$1();
  var weekStartsOn = toInteger$1((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate$1(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setDate(date.getDate() - diff);
  date.setHours(0, 0, 0, 0);
  return date;
}
function startOfISOWeek(dirtyDate) {
  requiredArgs$1(1, arguments);
  return startOfWeek(dirtyDate, {
    weekStartsOn: 1
  });
}
function getISOWeekYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var year = date.getFullYear();
  var fourthOfJanuaryOfNextYear = new Date(0);
  fourthOfJanuaryOfNextYear.setFullYear(year + 1, 0, 4);
  fourthOfJanuaryOfNextYear.setHours(0, 0, 0, 0);
  var startOfNextYear = startOfISOWeek(fourthOfJanuaryOfNextYear);
  var fourthOfJanuaryOfThisYear = new Date(0);
  fourthOfJanuaryOfThisYear.setFullYear(year, 0, 4);
  fourthOfJanuaryOfThisYear.setHours(0, 0, 0, 0);
  var startOfThisYear = startOfISOWeek(fourthOfJanuaryOfThisYear);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}
function startOfISOWeekYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  var year = getISOWeekYear(dirtyDate);
  var fourthOfJanuary = new Date(0);
  fourthOfJanuary.setFullYear(year, 0, 4);
  fourthOfJanuary.setHours(0, 0, 0, 0);
  var date = startOfISOWeek(fourthOfJanuary);
  return date;
}
function getTimezoneOffsetInMilliseconds$1(date) {
  var utcDate = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds()));
  utcDate.setUTCFullYear(date.getFullYear());
  return date.getTime() - utcDate.getTime();
}
function startOfDay(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  date.setHours(0, 0, 0, 0);
  return date;
}
var MILLISECONDS_IN_DAY$3 = 864e5;
function differenceInCalendarDays(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var startOfDayLeft = startOfDay(dirtyDateLeft);
  var startOfDayRight = startOfDay(dirtyDateRight);
  var timestampLeft = startOfDayLeft.getTime() - getTimezoneOffsetInMilliseconds$1(startOfDayLeft);
  var timestampRight = startOfDayRight.getTime() - getTimezoneOffsetInMilliseconds$1(startOfDayRight);
  return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_DAY$3);
}
function setISOWeekYear(dirtyDate, dirtyISOWeekYear) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var isoWeekYear = toInteger$1(dirtyISOWeekYear);
  var diff = differenceInCalendarDays(date, startOfISOWeekYear(date));
  var fourthOfJanuary = new Date(0);
  fourthOfJanuary.setFullYear(isoWeekYear, 0, 4);
  fourthOfJanuary.setHours(0, 0, 0, 0);
  date = startOfISOWeekYear(fourthOfJanuary);
  date.setDate(date.getDate() + diff);
  return date;
}
function addISOWeekYears(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return setISOWeekYear(dirtyDate, getISOWeekYear(dirtyDate) + amount);
}
var MILLISECONDS_IN_MINUTE$2 = 6e4;
function addMinutes(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addMilliseconds$1(dirtyDate, amount * MILLISECONDS_IN_MINUTE$2);
}
function addQuarters(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  var months2 = amount * 3;
  return addMonths(dirtyDate, months2);
}
function addSeconds(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addMilliseconds$1(dirtyDate, amount * 1e3);
}
function addWeeks(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  var days2 = amount * 7;
  return addDays(dirtyDate, days2);
}
function addYears(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addMonths(dirtyDate, amount * 12);
}
function areIntervalsOverlapping(intervalLeft, intervalRight, options) {
  requiredArgs$1(2, arguments);
  var leftStartTime = toDate$1(intervalLeft === null || intervalLeft === void 0 ? void 0 : intervalLeft.start).getTime();
  var leftEndTime = toDate$1(intervalLeft === null || intervalLeft === void 0 ? void 0 : intervalLeft.end).getTime();
  var rightStartTime = toDate$1(intervalRight === null || intervalRight === void 0 ? void 0 : intervalRight.start).getTime();
  var rightEndTime = toDate$1(intervalRight === null || intervalRight === void 0 ? void 0 : intervalRight.end).getTime();
  if (!(leftStartTime <= leftEndTime && rightStartTime <= rightEndTime)) {
    throw new RangeError("Invalid interval");
  }
  if (options !== null && options !== void 0 && options.inclusive) {
    return leftStartTime <= rightEndTime && rightStartTime <= leftEndTime;
  }
  return leftStartTime < rightEndTime && rightStartTime < leftEndTime;
}
function max(dirtyDatesArray) {
  requiredArgs$1(1, arguments);
  var datesArray;
  if (dirtyDatesArray && typeof dirtyDatesArray.forEach === "function") {
    datesArray = dirtyDatesArray;
  } else if (_typeof$5(dirtyDatesArray) === "object" && dirtyDatesArray !== null) {
    datesArray = Array.prototype.slice.call(dirtyDatesArray);
  } else {
    return new Date(NaN);
  }
  var result;
  datesArray.forEach(function(dirtyDate) {
    var currentDate = toDate$1(dirtyDate);
    if (result === void 0 || result < currentDate || isNaN(Number(currentDate))) {
      result = currentDate;
    }
  });
  return result || new Date(NaN);
}
function min(dirtyDatesArray) {
  requiredArgs$1(1, arguments);
  var datesArray;
  if (dirtyDatesArray && typeof dirtyDatesArray.forEach === "function") {
    datesArray = dirtyDatesArray;
  } else if (_typeof$5(dirtyDatesArray) === "object" && dirtyDatesArray !== null) {
    datesArray = Array.prototype.slice.call(dirtyDatesArray);
  } else {
    return new Date(NaN);
  }
  var result;
  datesArray.forEach(function(dirtyDate) {
    var currentDate = toDate$1(dirtyDate);
    if (result === void 0 || result > currentDate || isNaN(currentDate.getDate())) {
      result = currentDate;
    }
  });
  return result || new Date(NaN);
}
function clamp(date, _ref) {
  var start2 = _ref.start, end2 = _ref.end;
  requiredArgs$1(2, arguments);
  return min([max([date, start2]), end2]);
}
function closestIndexTo(dirtyDateToCompare, dirtyDatesArray) {
  requiredArgs$1(2, arguments);
  var dateToCompare = toDate$1(dirtyDateToCompare);
  if (isNaN(Number(dateToCompare)))
    return NaN;
  var timeToCompare = dateToCompare.getTime();
  var datesArray;
  if (dirtyDatesArray == null) {
    datesArray = [];
  } else if (typeof dirtyDatesArray.forEach === "function") {
    datesArray = dirtyDatesArray;
  } else {
    datesArray = Array.prototype.slice.call(dirtyDatesArray);
  }
  var result;
  var minDistance;
  datesArray.forEach(function(dirtyDate, index2) {
    var currentDate = toDate$1(dirtyDate);
    if (isNaN(Number(currentDate))) {
      result = NaN;
      minDistance = NaN;
      return;
    }
    var distance3 = Math.abs(timeToCompare - currentDate.getTime());
    if (result == null || distance3 < Number(minDistance)) {
      result = index2;
      minDistance = distance3;
    }
  });
  return result;
}
function closestTo(dirtyDateToCompare, dirtyDatesArray) {
  requiredArgs$1(2, arguments);
  var dateToCompare = toDate$1(dirtyDateToCompare);
  if (isNaN(Number(dateToCompare)))
    return new Date(NaN);
  var timeToCompare = dateToCompare.getTime();
  var datesArray;
  if (dirtyDatesArray == null) {
    datesArray = [];
  } else if (typeof dirtyDatesArray.forEach === "function") {
    datesArray = dirtyDatesArray;
  } else {
    datesArray = Array.prototype.slice.call(dirtyDatesArray);
  }
  var result;
  var minDistance;
  datesArray.forEach(function(dirtyDate) {
    var currentDate = toDate$1(dirtyDate);
    if (isNaN(Number(currentDate))) {
      result = new Date(NaN);
      minDistance = NaN;
      return;
    }
    var distance3 = Math.abs(timeToCompare - currentDate.getTime());
    if (result == null || distance3 < Number(minDistance)) {
      result = currentDate;
      minDistance = distance3;
    }
  });
  return result;
}
function compareAsc(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyDateLeft);
  var dateRight = toDate$1(dirtyDateRight);
  var diff = dateLeft.getTime() - dateRight.getTime();
  if (diff < 0) {
    return -1;
  } else if (diff > 0) {
    return 1;
  } else {
    return diff;
  }
}
function compareDesc(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyDateLeft);
  var dateRight = toDate$1(dirtyDateRight);
  var diff = dateLeft.getTime() - dateRight.getTime();
  if (diff > 0) {
    return -1;
  } else if (diff < 0) {
    return 1;
  } else {
    return diff;
  }
}
var daysInWeek = 7;
var daysInYear$1 = 365.2425;
var maxTime = Math.pow(10, 8) * 24 * 60 * 60 * 1e3;
var millisecondsInMinute$1 = 6e4;
var millisecondsInHour$1 = 36e5;
var millisecondsInSecond = 1e3;
var minTime = -maxTime;
var minutesInHour = 60;
var monthsInQuarter = 3;
var monthsInYear = 12;
var quartersInYear = 4;
var secondsInHour = 3600;
var secondsInMinute = 60;
var secondsInDay = secondsInHour * 24;
var secondsInWeek = secondsInDay * 7;
var secondsInYear = secondsInDay * daysInYear$1;
var secondsInMonth = secondsInYear / 12;
var secondsInQuarter = secondsInMonth * 3;
function daysToWeeks(days2) {
  requiredArgs$1(1, arguments);
  var weeks = days2 / daysInWeek;
  return Math.floor(weeks);
}
function isSameDay(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeftStartOfDay = startOfDay(dirtyDateLeft);
  var dateRightStartOfDay = startOfDay(dirtyDateRight);
  return dateLeftStartOfDay.getTime() === dateRightStartOfDay.getTime();
}
function isDate$2(value) {
  requiredArgs$1(1, arguments);
  return value instanceof Date || _typeof$5(value) === "object" && Object.prototype.toString.call(value) === "[object Date]";
}
function isValid$1(dirtyDate) {
  requiredArgs$1(1, arguments);
  if (!isDate$2(dirtyDate) && typeof dirtyDate !== "number") {
    return false;
  }
  var date = toDate$1(dirtyDate);
  return !isNaN(Number(date));
}
function differenceInBusinessDays(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyDateLeft);
  var dateRight = toDate$1(dirtyDateRight);
  if (!isValid$1(dateLeft) || !isValid$1(dateRight))
    return NaN;
  var calendarDifference = differenceInCalendarDays(dateLeft, dateRight);
  var sign = calendarDifference < 0 ? -1 : 1;
  var weeks = toInteger$1(calendarDifference / 7);
  var result = weeks * 5;
  dateRight = addDays(dateRight, weeks * 7);
  while (!isSameDay(dateLeft, dateRight)) {
    result += isWeekend(dateRight) ? 0 : sign;
    dateRight = addDays(dateRight, sign);
  }
  return result === 0 ? 0 : result;
}
function differenceInCalendarISOWeekYears(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  return getISOWeekYear(dirtyDateLeft) - getISOWeekYear(dirtyDateRight);
}
var MILLISECONDS_IN_WEEK$8 = 6048e5;
function differenceInCalendarISOWeeks(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var startOfISOWeekLeft = startOfISOWeek(dirtyDateLeft);
  var startOfISOWeekRight = startOfISOWeek(dirtyDateRight);
  var timestampLeft = startOfISOWeekLeft.getTime() - getTimezoneOffsetInMilliseconds$1(startOfISOWeekLeft);
  var timestampRight = startOfISOWeekRight.getTime() - getTimezoneOffsetInMilliseconds$1(startOfISOWeekRight);
  return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_WEEK$8);
}
function differenceInCalendarMonths(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyDateLeft);
  var dateRight = toDate$1(dirtyDateRight);
  var yearDiff = dateLeft.getFullYear() - dateRight.getFullYear();
  var monthDiff = dateLeft.getMonth() - dateRight.getMonth();
  return yearDiff * 12 + monthDiff;
}
function getQuarter$1(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var quarter = Math.floor(date.getMonth() / 3) + 1;
  return quarter;
}
function differenceInCalendarQuarters(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyDateLeft);
  var dateRight = toDate$1(dirtyDateRight);
  var yearDiff = dateLeft.getFullYear() - dateRight.getFullYear();
  var quarterDiff = getQuarter$1(dateLeft) - getQuarter$1(dateRight);
  return yearDiff * 4 + quarterDiff;
}
var MILLISECONDS_IN_WEEK$7 = 6048e5;
function differenceInCalendarWeeks(dirtyDateLeft, dirtyDateRight, options) {
  requiredArgs$1(2, arguments);
  var startOfWeekLeft = startOfWeek(dirtyDateLeft, options);
  var startOfWeekRight = startOfWeek(dirtyDateRight, options);
  var timestampLeft = startOfWeekLeft.getTime() - getTimezoneOffsetInMilliseconds$1(startOfWeekLeft);
  var timestampRight = startOfWeekRight.getTime() - getTimezoneOffsetInMilliseconds$1(startOfWeekRight);
  return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_WEEK$7);
}
function differenceInCalendarYears(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyDateLeft);
  var dateRight = toDate$1(dirtyDateRight);
  return dateLeft.getFullYear() - dateRight.getFullYear();
}
function compareLocalAsc(dateLeft, dateRight) {
  var diff = dateLeft.getFullYear() - dateRight.getFullYear() || dateLeft.getMonth() - dateRight.getMonth() || dateLeft.getDate() - dateRight.getDate() || dateLeft.getHours() - dateRight.getHours() || dateLeft.getMinutes() - dateRight.getMinutes() || dateLeft.getSeconds() - dateRight.getSeconds() || dateLeft.getMilliseconds() - dateRight.getMilliseconds();
  if (diff < 0) {
    return -1;
  } else if (diff > 0) {
    return 1;
  } else {
    return diff;
  }
}
function differenceInDays(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyDateLeft);
  var dateRight = toDate$1(dirtyDateRight);
  var sign = compareLocalAsc(dateLeft, dateRight);
  var difference = Math.abs(differenceInCalendarDays(dateLeft, dateRight));
  dateLeft.setDate(dateLeft.getDate() - sign * difference);
  var isLastDayNotFull = Number(compareLocalAsc(dateLeft, dateRight) === -sign);
  var result = sign * (difference - isLastDayNotFull);
  return result === 0 ? 0 : result;
}
function differenceInMilliseconds(dateLeft, dateRight) {
  requiredArgs$1(2, arguments);
  return toDate$1(dateLeft).getTime() - toDate$1(dateRight).getTime();
}
var roundingMap = {
  ceil: Math.ceil,
  round: Math.round,
  floor: Math.floor,
  trunc: function trunc(value) {
    return value < 0 ? Math.ceil(value) : Math.floor(value);
  }
};
var defaultRoundingMethod = "trunc";
function getRoundingMethod(method) {
  return method ? roundingMap[method] : roundingMap[defaultRoundingMethod];
}
function differenceInHours(dateLeft, dateRight, options) {
  requiredArgs$1(2, arguments);
  var diff = differenceInMilliseconds(dateLeft, dateRight) / millisecondsInHour$1;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function subISOWeekYears(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addISOWeekYears(dirtyDate, -amount);
}
function differenceInISOWeekYears(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyDateLeft);
  var dateRight = toDate$1(dirtyDateRight);
  var sign = compareAsc(dateLeft, dateRight);
  var difference = Math.abs(differenceInCalendarISOWeekYears(dateLeft, dateRight));
  dateLeft = subISOWeekYears(dateLeft, sign * difference);
  var isLastISOWeekYearNotFull = Number(compareAsc(dateLeft, dateRight) === -sign);
  var result = sign * (difference - isLastISOWeekYearNotFull);
  return result === 0 ? 0 : result;
}
function differenceInMinutes(dateLeft, dateRight, options) {
  requiredArgs$1(2, arguments);
  var diff = differenceInMilliseconds(dateLeft, dateRight) / millisecondsInMinute$1;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function endOfDay(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  date.setHours(23, 59, 59, 999);
  return date;
}
function endOfMonth(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var month = date.getMonth();
  date.setFullYear(date.getFullYear(), month + 1, 0);
  date.setHours(23, 59, 59, 999);
  return date;
}
function isLastDayOfMonth(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  return endOfDay(date).getTime() === endOfMonth(date).getTime();
}
function differenceInMonths(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyDateLeft);
  var dateRight = toDate$1(dirtyDateRight);
  var sign = compareAsc(dateLeft, dateRight);
  var difference = Math.abs(differenceInCalendarMonths(dateLeft, dateRight));
  var result;
  if (difference < 1) {
    result = 0;
  } else {
    if (dateLeft.getMonth() === 1 && dateLeft.getDate() > 27) {
      dateLeft.setDate(30);
    }
    dateLeft.setMonth(dateLeft.getMonth() - sign * difference);
    var isLastMonthNotFull = compareAsc(dateLeft, dateRight) === -sign;
    if (isLastDayOfMonth(toDate$1(dirtyDateLeft)) && difference === 1 && compareAsc(dirtyDateLeft, dateRight) === 1) {
      isLastMonthNotFull = false;
    }
    result = sign * (difference - Number(isLastMonthNotFull));
  }
  return result === 0 ? 0 : result;
}
function differenceInQuarters(dateLeft, dateRight, options) {
  requiredArgs$1(2, arguments);
  var diff = differenceInMonths(dateLeft, dateRight) / 3;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function differenceInSeconds(dateLeft, dateRight, options) {
  requiredArgs$1(2, arguments);
  var diff = differenceInMilliseconds(dateLeft, dateRight) / 1e3;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function differenceInWeeks(dateLeft, dateRight, options) {
  requiredArgs$1(2, arguments);
  var diff = differenceInDays(dateLeft, dateRight) / 7;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function differenceInYears(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyDateLeft);
  var dateRight = toDate$1(dirtyDateRight);
  var sign = compareAsc(dateLeft, dateRight);
  var difference = Math.abs(differenceInCalendarYears(dateLeft, dateRight));
  dateLeft.setFullYear(1584);
  dateRight.setFullYear(1584);
  var isLastYearNotFull = compareAsc(dateLeft, dateRight) === -sign;
  var result = sign * (difference - Number(isLastYearNotFull));
  return result === 0 ? 0 : result;
}
function eachDayOfInterval(dirtyInterval, options) {
  var _options$step;
  requiredArgs$1(1, arguments);
  var interval = dirtyInterval || {};
  var startDate = toDate$1(interval.start);
  var endDate = toDate$1(interval.end);
  var endTime = endDate.getTime();
  if (!(startDate.getTime() <= endTime)) {
    throw new RangeError("Invalid interval");
  }
  var dates = [];
  var currentDate = startDate;
  currentDate.setHours(0, 0, 0, 0);
  var step = Number((_options$step = options === null || options === void 0 ? void 0 : options.step) !== null && _options$step !== void 0 ? _options$step : 1);
  if (step < 1 || isNaN(step))
    throw new RangeError("`options.step` must be a number greater than 1");
  while (currentDate.getTime() <= endTime) {
    dates.push(toDate$1(currentDate));
    currentDate.setDate(currentDate.getDate() + step);
    currentDate.setHours(0, 0, 0, 0);
  }
  return dates;
}
function eachHourOfInterval(dirtyInterval, options) {
  var _options$step;
  requiredArgs$1(1, arguments);
  var interval = dirtyInterval || {};
  var startDate = toDate$1(interval.start);
  var endDate = toDate$1(interval.end);
  var startTime = startDate.getTime();
  var endTime = endDate.getTime();
  if (!(startTime <= endTime)) {
    throw new RangeError("Invalid interval");
  }
  var dates = [];
  var currentDate = startDate;
  currentDate.setMinutes(0, 0, 0);
  var step = Number((_options$step = options === null || options === void 0 ? void 0 : options.step) !== null && _options$step !== void 0 ? _options$step : 1);
  if (step < 1 || isNaN(step))
    throw new RangeError("`options.step` must be a number greater than 1");
  while (currentDate.getTime() <= endTime) {
    dates.push(toDate$1(currentDate));
    currentDate = addHours(currentDate, step);
  }
  return dates;
}
function startOfMinute(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  date.setSeconds(0, 0);
  return date;
}
function eachMinuteOfInterval(interval, options) {
  var _options$step;
  requiredArgs$1(1, arguments);
  var startDate = startOfMinute(toDate$1(interval.start));
  var endDate = toDate$1(interval.end);
  var startTime = startDate.getTime();
  var endTime = endDate.getTime();
  if (startTime >= endTime) {
    throw new RangeError("Invalid interval");
  }
  var dates = [];
  var currentDate = startDate;
  var step = Number((_options$step = options === null || options === void 0 ? void 0 : options.step) !== null && _options$step !== void 0 ? _options$step : 1);
  if (step < 1 || isNaN(step))
    throw new RangeError("`options.step` must be a number equal to or greater than 1");
  while (currentDate.getTime() <= endTime) {
    dates.push(toDate$1(currentDate));
    currentDate = addMinutes(currentDate, step);
  }
  return dates;
}
function eachMonthOfInterval(dirtyInterval) {
  requiredArgs$1(1, arguments);
  var interval = dirtyInterval || {};
  var startDate = toDate$1(interval.start);
  var endDate = toDate$1(interval.end);
  var endTime = endDate.getTime();
  var dates = [];
  if (!(startDate.getTime() <= endTime)) {
    throw new RangeError("Invalid interval");
  }
  var currentDate = startDate;
  currentDate.setHours(0, 0, 0, 0);
  currentDate.setDate(1);
  while (currentDate.getTime() <= endTime) {
    dates.push(toDate$1(currentDate));
    currentDate.setMonth(currentDate.getMonth() + 1);
  }
  return dates;
}
function startOfQuarter(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var currentMonth = date.getMonth();
  var month = currentMonth - currentMonth % 3;
  date.setMonth(month, 1);
  date.setHours(0, 0, 0, 0);
  return date;
}
function eachQuarterOfInterval(dirtyInterval) {
  requiredArgs$1(1, arguments);
  var interval = dirtyInterval || {};
  var startDate = toDate$1(interval.start);
  var endDate = toDate$1(interval.end);
  var endTime = endDate.getTime();
  if (!(startDate.getTime() <= endTime)) {
    throw new RangeError("Invalid interval");
  }
  var startDateQuarter = startOfQuarter(startDate);
  var endDateQuarter = startOfQuarter(endDate);
  endTime = endDateQuarter.getTime();
  var quarters = [];
  var currentQuarter = startDateQuarter;
  while (currentQuarter.getTime() <= endTime) {
    quarters.push(toDate$1(currentQuarter));
    currentQuarter = addQuarters(currentQuarter, 1);
  }
  return quarters;
}
function eachWeekOfInterval(dirtyInterval, options) {
  requiredArgs$1(1, arguments);
  var interval = dirtyInterval || {};
  var startDate = toDate$1(interval.start);
  var endDate = toDate$1(interval.end);
  var endTime = endDate.getTime();
  if (!(startDate.getTime() <= endTime)) {
    throw new RangeError("Invalid interval");
  }
  var startDateWeek = startOfWeek(startDate, options);
  var endDateWeek = startOfWeek(endDate, options);
  startDateWeek.setHours(15);
  endDateWeek.setHours(15);
  endTime = endDateWeek.getTime();
  var weeks = [];
  var currentWeek = startDateWeek;
  while (currentWeek.getTime() <= endTime) {
    currentWeek.setHours(0);
    weeks.push(toDate$1(currentWeek));
    currentWeek = addWeeks(currentWeek, 1);
    currentWeek.setHours(15);
  }
  return weeks;
}
function eachWeekendOfInterval(interval) {
  requiredArgs$1(1, arguments);
  var dateInterval = eachDayOfInterval(interval);
  var weekends = [];
  var index2 = 0;
  while (index2 < dateInterval.length) {
    var date = dateInterval[index2++];
    if (isWeekend(date)) {
      weekends.push(date);
      if (isSunday(date))
        index2 = index2 + 5;
    }
  }
  return weekends;
}
function startOfMonth(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  date.setDate(1);
  date.setHours(0, 0, 0, 0);
  return date;
}
function eachWeekendOfMonth(dirtyDate) {
  requiredArgs$1(1, arguments);
  var startDate = startOfMonth(dirtyDate);
  if (isNaN(startDate.getTime()))
    throw new RangeError("The passed date is invalid");
  var endDate = endOfMonth(dirtyDate);
  return eachWeekendOfInterval({
    start: startDate,
    end: endDate
  });
}
function endOfYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var year = date.getFullYear();
  date.setFullYear(year + 1, 0, 0);
  date.setHours(23, 59, 59, 999);
  return date;
}
function startOfYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  var cleanDate = toDate$1(dirtyDate);
  var date = new Date(0);
  date.setFullYear(cleanDate.getFullYear(), 0, 1);
  date.setHours(0, 0, 0, 0);
  return date;
}
function eachWeekendOfYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  var startDate = startOfYear(dirtyDate);
  var endDate = endOfYear(dirtyDate);
  return eachWeekendOfInterval({
    start: startDate,
    end: endDate
  });
}
function eachYearOfInterval(dirtyInterval) {
  requiredArgs$1(1, arguments);
  var interval = dirtyInterval || {};
  var startDate = toDate$1(interval.start);
  var endDate = toDate$1(interval.end);
  var endTime = endDate.getTime();
  if (!(startDate.getTime() <= endTime)) {
    throw new RangeError("Invalid interval");
  }
  var dates = [];
  var currentDate = startDate;
  currentDate.setHours(0, 0, 0, 0);
  currentDate.setMonth(0, 1);
  while (currentDate.getTime() <= endTime) {
    dates.push(toDate$1(currentDate));
    currentDate.setFullYear(currentDate.getFullYear() + 1);
  }
  return dates;
}
function endOfDecade(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var year = date.getFullYear();
  var decade = 9 + Math.floor(year / 10) * 10;
  date.setFullYear(decade, 11, 31);
  date.setHours(23, 59, 59, 999);
  return date;
}
function endOfHour(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  date.setMinutes(59, 59, 999);
  return date;
}
function endOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(1, arguments);
  var defaultOptions2 = getDefaultOptions$1();
  var weekStartsOn = toInteger$1((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate$1(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? -7 : 0) + 6 - (day - weekStartsOn);
  date.setDate(date.getDate() + diff);
  date.setHours(23, 59, 59, 999);
  return date;
}
function endOfISOWeek(dirtyDate) {
  requiredArgs$1(1, arguments);
  return endOfWeek(dirtyDate, {
    weekStartsOn: 1
  });
}
function endOfISOWeekYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  var year = getISOWeekYear(dirtyDate);
  var fourthOfJanuaryOfNextYear = new Date(0);
  fourthOfJanuaryOfNextYear.setFullYear(year + 1, 0, 4);
  fourthOfJanuaryOfNextYear.setHours(0, 0, 0, 0);
  var date = startOfISOWeek(fourthOfJanuaryOfNextYear);
  date.setMilliseconds(date.getMilliseconds() - 1);
  return date;
}
function endOfMinute(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  date.setSeconds(59, 999);
  return date;
}
function endOfQuarter(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var currentMonth = date.getMonth();
  var month = currentMonth - currentMonth % 3 + 3;
  date.setMonth(month, 0);
  date.setHours(23, 59, 59, 999);
  return date;
}
function endOfSecond(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  date.setMilliseconds(999);
  return date;
}
function endOfToday() {
  return endOfDay(Date.now());
}
function endOfTomorrow() {
  var now2 = new Date();
  var year = now2.getFullYear();
  var month = now2.getMonth();
  var day = now2.getDate();
  var date = new Date(0);
  date.setFullYear(year, month, day + 1);
  date.setHours(23, 59, 59, 999);
  return date;
}
function endOfYesterday() {
  var now2 = new Date();
  var year = now2.getFullYear();
  var month = now2.getMonth();
  var day = now2.getDate();
  var date = new Date(0);
  date.setFullYear(year, month, day - 1);
  date.setHours(23, 59, 59, 999);
  return date;
}
function subMilliseconds$1(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addMilliseconds$1(dirtyDate, -amount);
}
var MILLISECONDS_IN_DAY$2 = 864e5;
function getUTCDayOfYear$1(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var timestamp = date.getTime();
  date.setUTCMonth(0, 1);
  date.setUTCHours(0, 0, 0, 0);
  var startOfYearTimestamp = date.getTime();
  var difference = timestamp - startOfYearTimestamp;
  return Math.floor(difference / MILLISECONDS_IN_DAY$2) + 1;
}
function startOfUTCISOWeek$1(dirtyDate) {
  requiredArgs$1(1, arguments);
  var weekStartsOn = 1;
  var date = toDate$1(dirtyDate);
  var day = date.getUTCDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setUTCDate(date.getUTCDate() - diff);
  date.setUTCHours(0, 0, 0, 0);
  return date;
}
function getUTCISOWeekYear$1(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var year = date.getUTCFullYear();
  var fourthOfJanuaryOfNextYear = new Date(0);
  fourthOfJanuaryOfNextYear.setUTCFullYear(year + 1, 0, 4);
  fourthOfJanuaryOfNextYear.setUTCHours(0, 0, 0, 0);
  var startOfNextYear = startOfUTCISOWeek$1(fourthOfJanuaryOfNextYear);
  var fourthOfJanuaryOfThisYear = new Date(0);
  fourthOfJanuaryOfThisYear.setUTCFullYear(year, 0, 4);
  fourthOfJanuaryOfThisYear.setUTCHours(0, 0, 0, 0);
  var startOfThisYear = startOfUTCISOWeek$1(fourthOfJanuaryOfThisYear);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}
function startOfUTCISOWeekYear$1(dirtyDate) {
  requiredArgs$1(1, arguments);
  var year = getUTCISOWeekYear$1(dirtyDate);
  var fourthOfJanuary = new Date(0);
  fourthOfJanuary.setUTCFullYear(year, 0, 4);
  fourthOfJanuary.setUTCHours(0, 0, 0, 0);
  var date = startOfUTCISOWeek$1(fourthOfJanuary);
  return date;
}
var MILLISECONDS_IN_WEEK$6 = 6048e5;
function getUTCISOWeek$1(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var diff = startOfUTCISOWeek$1(date).getTime() - startOfUTCISOWeekYear$1(date).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK$6) + 1;
}
function startOfUTCWeek$1(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(1, arguments);
  var defaultOptions2 = getDefaultOptions$1();
  var weekStartsOn = toInteger$1((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate$1(dirtyDate);
  var day = date.getUTCDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setUTCDate(date.getUTCDate() - diff);
  date.setUTCHours(0, 0, 0, 0);
  return date;
}
function getUTCWeekYear$1(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var year = date.getUTCFullYear();
  var defaultOptions2 = getDefaultOptions$1();
  var firstWeekContainsDate = toInteger$1((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var firstWeekOfNextYear = new Date(0);
  firstWeekOfNextYear.setUTCFullYear(year + 1, 0, firstWeekContainsDate);
  firstWeekOfNextYear.setUTCHours(0, 0, 0, 0);
  var startOfNextYear = startOfUTCWeek$1(firstWeekOfNextYear, options);
  var firstWeekOfThisYear = new Date(0);
  firstWeekOfThisYear.setUTCFullYear(year, 0, firstWeekContainsDate);
  firstWeekOfThisYear.setUTCHours(0, 0, 0, 0);
  var startOfThisYear = startOfUTCWeek$1(firstWeekOfThisYear, options);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}
function startOfUTCWeekYear$1(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(1, arguments);
  var defaultOptions2 = getDefaultOptions$1();
  var firstWeekContainsDate = toInteger$1((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  var year = getUTCWeekYear$1(dirtyDate, options);
  var firstWeek = new Date(0);
  firstWeek.setUTCFullYear(year, 0, firstWeekContainsDate);
  firstWeek.setUTCHours(0, 0, 0, 0);
  var date = startOfUTCWeek$1(firstWeek, options);
  return date;
}
var MILLISECONDS_IN_WEEK$5 = 6048e5;
function getUTCWeek$1(dirtyDate, options) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var diff = startOfUTCWeek$1(date, options).getTime() - startOfUTCWeekYear$1(date, options).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK$5) + 1;
}
function addLeadingZeros$1(number, targetLength) {
  var sign = number < 0 ? "-" : "";
  var output = Math.abs(number).toString();
  while (output.length < targetLength) {
    output = "0" + output;
  }
  return sign + output;
}
var formatters$6 = {
  y: function y(date, token) {
    var signedYear = date.getUTCFullYear();
    var year = signedYear > 0 ? signedYear : 1 - signedYear;
    return addLeadingZeros$1(token === "yy" ? year % 100 : year, token.length);
  },
  M: function M(date, token) {
    var month = date.getUTCMonth();
    return token === "M" ? String(month + 1) : addLeadingZeros$1(month + 1, 2);
  },
  d: function d(date, token) {
    return addLeadingZeros$1(date.getUTCDate(), token.length);
  },
  a: function a(date, token) {
    var dayPeriodEnumValue = date.getUTCHours() / 12 >= 1 ? "pm" : "am";
    switch (token) {
      case "a":
      case "aa":
        return dayPeriodEnumValue.toUpperCase();
      case "aaa":
        return dayPeriodEnumValue;
      case "aaaaa":
        return dayPeriodEnumValue[0];
      case "aaaa":
      default:
        return dayPeriodEnumValue === "am" ? "a.m." : "p.m.";
    }
  },
  h: function h(date, token) {
    return addLeadingZeros$1(date.getUTCHours() % 12 || 12, token.length);
  },
  H: function H(date, token) {
    return addLeadingZeros$1(date.getUTCHours(), token.length);
  },
  m: function m(date, token) {
    return addLeadingZeros$1(date.getUTCMinutes(), token.length);
  },
  s: function s(date, token) {
    return addLeadingZeros$1(date.getUTCSeconds(), token.length);
  },
  S: function S(date, token) {
    var numberOfDigits = token.length;
    var milliseconds2 = date.getUTCMilliseconds();
    var fractionalSeconds = Math.floor(milliseconds2 * Math.pow(10, numberOfDigits - 3));
    return addLeadingZeros$1(fractionalSeconds, token.length);
  }
};
var formatters$7 = formatters$6;
var dayPeriodEnum$1 = {
  am: "am",
  pm: "pm",
  midnight: "midnight",
  noon: "noon",
  morning: "morning",
  afternoon: "afternoon",
  evening: "evening",
  night: "night"
};
var formatters$4 = {
  G: function G(date, token, localize2) {
    var era = date.getUTCFullYear() > 0 ? 1 : 0;
    switch (token) {
      case "G":
      case "GG":
      case "GGG":
        return localize2.era(era, {
          width: "abbreviated"
        });
      case "GGGGG":
        return localize2.era(era, {
          width: "narrow"
        });
      case "GGGG":
      default:
        return localize2.era(era, {
          width: "wide"
        });
    }
  },
  y: function y2(date, token, localize2) {
    if (token === "yo") {
      var signedYear = date.getUTCFullYear();
      var year = signedYear > 0 ? signedYear : 1 - signedYear;
      return localize2.ordinalNumber(year, {
        unit: "year"
      });
    }
    return formatters$7.y(date, token);
  },
  Y: function Y(date, token, localize2, options) {
    var signedWeekYear = getUTCWeekYear$1(date, options);
    var weekYear = signedWeekYear > 0 ? signedWeekYear : 1 - signedWeekYear;
    if (token === "YY") {
      var twoDigitYear = weekYear % 100;
      return addLeadingZeros$1(twoDigitYear, 2);
    }
    if (token === "Yo") {
      return localize2.ordinalNumber(weekYear, {
        unit: "year"
      });
    }
    return addLeadingZeros$1(weekYear, token.length);
  },
  R: function R(date, token) {
    var isoWeekYear = getUTCISOWeekYear$1(date);
    return addLeadingZeros$1(isoWeekYear, token.length);
  },
  u: function u(date, token) {
    var year = date.getUTCFullYear();
    return addLeadingZeros$1(year, token.length);
  },
  Q: function Q(date, token, localize2) {
    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
    switch (token) {
      case "Q":
        return String(quarter);
      case "QQ":
        return addLeadingZeros$1(quarter, 2);
      case "Qo":
        return localize2.ordinalNumber(quarter, {
          unit: "quarter"
        });
      case "QQQ":
        return localize2.quarter(quarter, {
          width: "abbreviated",
          context: "formatting"
        });
      case "QQQQQ":
        return localize2.quarter(quarter, {
          width: "narrow",
          context: "formatting"
        });
      case "QQQQ":
      default:
        return localize2.quarter(quarter, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  q: function q(date, token, localize2) {
    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
    switch (token) {
      case "q":
        return String(quarter);
      case "qq":
        return addLeadingZeros$1(quarter, 2);
      case "qo":
        return localize2.ordinalNumber(quarter, {
          unit: "quarter"
        });
      case "qqq":
        return localize2.quarter(quarter, {
          width: "abbreviated",
          context: "standalone"
        });
      case "qqqqq":
        return localize2.quarter(quarter, {
          width: "narrow",
          context: "standalone"
        });
      case "qqqq":
      default:
        return localize2.quarter(quarter, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  M: function M2(date, token, localize2) {
    var month = date.getUTCMonth();
    switch (token) {
      case "M":
      case "MM":
        return formatters$7.M(date, token);
      case "Mo":
        return localize2.ordinalNumber(month + 1, {
          unit: "month"
        });
      case "MMM":
        return localize2.month(month, {
          width: "abbreviated",
          context: "formatting"
        });
      case "MMMMM":
        return localize2.month(month, {
          width: "narrow",
          context: "formatting"
        });
      case "MMMM":
      default:
        return localize2.month(month, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  L: function L(date, token, localize2) {
    var month = date.getUTCMonth();
    switch (token) {
      case "L":
        return String(month + 1);
      case "LL":
        return addLeadingZeros$1(month + 1, 2);
      case "Lo":
        return localize2.ordinalNumber(month + 1, {
          unit: "month"
        });
      case "LLL":
        return localize2.month(month, {
          width: "abbreviated",
          context: "standalone"
        });
      case "LLLLL":
        return localize2.month(month, {
          width: "narrow",
          context: "standalone"
        });
      case "LLLL":
      default:
        return localize2.month(month, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  w: function w(date, token, localize2, options) {
    var week2 = getUTCWeek$1(date, options);
    if (token === "wo") {
      return localize2.ordinalNumber(week2, {
        unit: "week"
      });
    }
    return addLeadingZeros$1(week2, token.length);
  },
  I: function I(date, token, localize2) {
    var isoWeek = getUTCISOWeek$1(date);
    if (token === "Io") {
      return localize2.ordinalNumber(isoWeek, {
        unit: "week"
      });
    }
    return addLeadingZeros$1(isoWeek, token.length);
  },
  d: function d2(date, token, localize2) {
    if (token === "do") {
      return localize2.ordinalNumber(date.getUTCDate(), {
        unit: "date"
      });
    }
    return formatters$7.d(date, token);
  },
  D: function D(date, token, localize2) {
    var dayOfYear = getUTCDayOfYear$1(date);
    if (token === "Do") {
      return localize2.ordinalNumber(dayOfYear, {
        unit: "dayOfYear"
      });
    }
    return addLeadingZeros$1(dayOfYear, token.length);
  },
  E: function E(date, token, localize2) {
    var dayOfWeek = date.getUTCDay();
    switch (token) {
      case "E":
      case "EE":
      case "EEE":
        return localize2.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "EEEEE":
        return localize2.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "EEEEEE":
        return localize2.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "EEEE":
      default:
        return localize2.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  e: function e(date, token, localize2, options) {
    var dayOfWeek = date.getUTCDay();
    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      case "e":
        return String(localDayOfWeek);
      case "ee":
        return addLeadingZeros$1(localDayOfWeek, 2);
      case "eo":
        return localize2.ordinalNumber(localDayOfWeek, {
          unit: "day"
        });
      case "eee":
        return localize2.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "eeeee":
        return localize2.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "eeeeee":
        return localize2.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "eeee":
      default:
        return localize2.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  c: function c(date, token, localize2, options) {
    var dayOfWeek = date.getUTCDay();
    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      case "c":
        return String(localDayOfWeek);
      case "cc":
        return addLeadingZeros$1(localDayOfWeek, token.length);
      case "co":
        return localize2.ordinalNumber(localDayOfWeek, {
          unit: "day"
        });
      case "ccc":
        return localize2.day(dayOfWeek, {
          width: "abbreviated",
          context: "standalone"
        });
      case "ccccc":
        return localize2.day(dayOfWeek, {
          width: "narrow",
          context: "standalone"
        });
      case "cccccc":
        return localize2.day(dayOfWeek, {
          width: "short",
          context: "standalone"
        });
      case "cccc":
      default:
        return localize2.day(dayOfWeek, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  i: function i(date, token, localize2) {
    var dayOfWeek = date.getUTCDay();
    var isoDayOfWeek = dayOfWeek === 0 ? 7 : dayOfWeek;
    switch (token) {
      case "i":
        return String(isoDayOfWeek);
      case "ii":
        return addLeadingZeros$1(isoDayOfWeek, token.length);
      case "io":
        return localize2.ordinalNumber(isoDayOfWeek, {
          unit: "day"
        });
      case "iii":
        return localize2.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "iiiii":
        return localize2.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "iiiiii":
        return localize2.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "iiii":
      default:
        return localize2.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  a: function a2(date, token, localize2) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    switch (token) {
      case "a":
      case "aa":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "aaa":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "aaaaa":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "aaaa":
      default:
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  b: function b(date, token, localize2) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue;
    if (hours === 12) {
      dayPeriodEnumValue = dayPeriodEnum$1.noon;
    } else if (hours === 0) {
      dayPeriodEnumValue = dayPeriodEnum$1.midnight;
    } else {
      dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    }
    switch (token) {
      case "b":
      case "bb":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "bbb":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "bbbbb":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "bbbb":
      default:
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  B: function B(date, token, localize2) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue;
    if (hours >= 17) {
      dayPeriodEnumValue = dayPeriodEnum$1.evening;
    } else if (hours >= 12) {
      dayPeriodEnumValue = dayPeriodEnum$1.afternoon;
    } else if (hours >= 4) {
      dayPeriodEnumValue = dayPeriodEnum$1.morning;
    } else {
      dayPeriodEnumValue = dayPeriodEnum$1.night;
    }
    switch (token) {
      case "B":
      case "BB":
      case "BBB":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "BBBBB":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "BBBB":
      default:
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  h: function h2(date, token, localize2) {
    if (token === "ho") {
      var hours = date.getUTCHours() % 12;
      if (hours === 0)
        hours = 12;
      return localize2.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return formatters$7.h(date, token);
  },
  H: function H2(date, token, localize2) {
    if (token === "Ho") {
      return localize2.ordinalNumber(date.getUTCHours(), {
        unit: "hour"
      });
    }
    return formatters$7.H(date, token);
  },
  K: function K(date, token, localize2) {
    var hours = date.getUTCHours() % 12;
    if (token === "Ko") {
      return localize2.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return addLeadingZeros$1(hours, token.length);
  },
  k: function k(date, token, localize2) {
    var hours = date.getUTCHours();
    if (hours === 0)
      hours = 24;
    if (token === "ko") {
      return localize2.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return addLeadingZeros$1(hours, token.length);
  },
  m: function m2(date, token, localize2) {
    if (token === "mo") {
      return localize2.ordinalNumber(date.getUTCMinutes(), {
        unit: "minute"
      });
    }
    return formatters$7.m(date, token);
  },
  s: function s2(date, token, localize2) {
    if (token === "so") {
      return localize2.ordinalNumber(date.getUTCSeconds(), {
        unit: "second"
      });
    }
    return formatters$7.s(date, token);
  },
  S: function S2(date, token) {
    return formatters$7.S(date, token);
  },
  X: function X(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    if (timezoneOffset === 0) {
      return "Z";
    }
    switch (token) {
      case "X":
        return formatTimezoneWithOptionalMinutes$1(timezoneOffset);
      case "XXXX":
      case "XX":
        return formatTimezone$1(timezoneOffset);
      case "XXXXX":
      case "XXX":
      default:
        return formatTimezone$1(timezoneOffset, ":");
    }
  },
  x: function x(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "x":
        return formatTimezoneWithOptionalMinutes$1(timezoneOffset);
      case "xxxx":
      case "xx":
        return formatTimezone$1(timezoneOffset);
      case "xxxxx":
      case "xxx":
      default:
        return formatTimezone$1(timezoneOffset, ":");
    }
  },
  O: function O(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "O":
      case "OO":
      case "OOO":
        return "GMT" + formatTimezoneShort$1(timezoneOffset, ":");
      case "OOOO":
      default:
        return "GMT" + formatTimezone$1(timezoneOffset, ":");
    }
  },
  z: function z(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "z":
      case "zz":
      case "zzz":
        return "GMT" + formatTimezoneShort$1(timezoneOffset, ":");
      case "zzzz":
      default:
        return "GMT" + formatTimezone$1(timezoneOffset, ":");
    }
  },
  t: function t2(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timestamp = Math.floor(originalDate.getTime() / 1e3);
    return addLeadingZeros$1(timestamp, token.length);
  },
  T: function T(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timestamp = originalDate.getTime();
    return addLeadingZeros$1(timestamp, token.length);
  }
};
function formatTimezoneShort$1(offset4, dirtyDelimiter) {
  var sign = offset4 > 0 ? "-" : "+";
  var absOffset = Math.abs(offset4);
  var hours = Math.floor(absOffset / 60);
  var minutes = absOffset % 60;
  if (minutes === 0) {
    return sign + String(hours);
  }
  var delimiter = dirtyDelimiter || "";
  return sign + String(hours) + delimiter + addLeadingZeros$1(minutes, 2);
}
function formatTimezoneWithOptionalMinutes$1(offset4, dirtyDelimiter) {
  if (offset4 % 60 === 0) {
    var sign = offset4 > 0 ? "-" : "+";
    return sign + addLeadingZeros$1(Math.abs(offset4) / 60, 2);
  }
  return formatTimezone$1(offset4, dirtyDelimiter);
}
function formatTimezone$1(offset4, dirtyDelimiter) {
  var delimiter = dirtyDelimiter || "";
  var sign = offset4 > 0 ? "-" : "+";
  var absOffset = Math.abs(offset4);
  var hours = addLeadingZeros$1(Math.floor(absOffset / 60), 2);
  var minutes = addLeadingZeros$1(absOffset % 60, 2);
  return sign + hours + delimiter + minutes;
}
var formatters$5 = formatters$4;
var dateLongFormatter$1 = function dateLongFormatter(pattern, formatLong2) {
  switch (pattern) {
    case "P":
      return formatLong2.date({
        width: "short"
      });
    case "PP":
      return formatLong2.date({
        width: "medium"
      });
    case "PPP":
      return formatLong2.date({
        width: "long"
      });
    case "PPPP":
    default:
      return formatLong2.date({
        width: "full"
      });
  }
};
var timeLongFormatter$1 = function timeLongFormatter(pattern, formatLong2) {
  switch (pattern) {
    case "p":
      return formatLong2.time({
        width: "short"
      });
    case "pp":
      return formatLong2.time({
        width: "medium"
      });
    case "ppp":
      return formatLong2.time({
        width: "long"
      });
    case "pppp":
    default:
      return formatLong2.time({
        width: "full"
      });
  }
};
var dateTimeLongFormatter$1 = function dateTimeLongFormatter(pattern, formatLong2) {
  var matchResult = pattern.match(/(P+)(p+)?/) || [];
  var datePattern = matchResult[1];
  var timePattern = matchResult[2];
  if (!timePattern) {
    return dateLongFormatter$1(pattern, formatLong2);
  }
  var dateTimeFormat;
  switch (datePattern) {
    case "P":
      dateTimeFormat = formatLong2.dateTime({
        width: "short"
      });
      break;
    case "PP":
      dateTimeFormat = formatLong2.dateTime({
        width: "medium"
      });
      break;
    case "PPP":
      dateTimeFormat = formatLong2.dateTime({
        width: "long"
      });
      break;
    case "PPPP":
    default:
      dateTimeFormat = formatLong2.dateTime({
        width: "full"
      });
      break;
  }
  return dateTimeFormat.replace("{{date}}", dateLongFormatter$1(datePattern, formatLong2)).replace("{{time}}", timeLongFormatter$1(timePattern, formatLong2));
};
var longFormatters$2 = {
  p: timeLongFormatter$1,
  P: dateTimeLongFormatter$1
};
var longFormatters$3 = longFormatters$2;
var protectedDayOfYearTokens$1 = ["D", "DD"];
var protectedWeekYearTokens$1 = ["YY", "YYYY"];
function isProtectedDayOfYearToken$1(token) {
  return protectedDayOfYearTokens$1.indexOf(token) !== -1;
}
function isProtectedWeekYearToken$1(token) {
  return protectedWeekYearTokens$1.indexOf(token) !== -1;
}
function throwProtectedError$1(token, format3, input2) {
  if (token === "YYYY") {
    throw new RangeError("Use `yyyy` instead of `YYYY` (in `".concat(format3, "`) for formatting years to the input `").concat(input2, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "YY") {
    throw new RangeError("Use `yy` instead of `YY` (in `".concat(format3, "`) for formatting years to the input `").concat(input2, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "D") {
    throw new RangeError("Use `d` instead of `D` (in `".concat(format3, "`) for formatting days of the month to the input `").concat(input2, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "DD") {
    throw new RangeError("Use `dd` instead of `DD` (in `".concat(format3, "`) for formatting days of the month to the input `").concat(input2, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  }
}
var formatDistanceLocale$1i = {
  lessThanXSeconds: {
    one: "less than a second",
    other: "less than {{count}} seconds"
  },
  xSeconds: {
    one: "1 second",
    other: "{{count}} seconds"
  },
  halfAMinute: "half a minute",
  lessThanXMinutes: {
    one: "less than a minute",
    other: "less than {{count}} minutes"
  },
  xMinutes: {
    one: "1 minute",
    other: "{{count}} minutes"
  },
  aboutXHours: {
    one: "about 1 hour",
    other: "about {{count}} hours"
  },
  xHours: {
    one: "1 hour",
    other: "{{count}} hours"
  },
  xDays: {
    one: "1 day",
    other: "{{count}} days"
  },
  aboutXWeeks: {
    one: "about 1 week",
    other: "about {{count}} weeks"
  },
  xWeeks: {
    one: "1 week",
    other: "{{count}} weeks"
  },
  aboutXMonths: {
    one: "about 1 month",
    other: "about {{count}} months"
  },
  xMonths: {
    one: "1 month",
    other: "{{count}} months"
  },
  aboutXYears: {
    one: "about 1 year",
    other: "about {{count}} years"
  },
  xYears: {
    one: "1 year",
    other: "{{count}} years"
  },
  overXYears: {
    one: "over 1 year",
    other: "over {{count}} years"
  },
  almostXYears: {
    one: "almost 1 year",
    other: "almost {{count}} years"
  }
};
var formatDistance$2D = function formatDistance(token, count2, options) {
  var result;
  var tokenValue = formatDistanceLocale$1i[token];
  if (typeof tokenValue === "string") {
    result = tokenValue;
  } else if (count2 === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace("{{count}}", count2.toString());
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "in " + result;
    } else {
      return result + " ago";
    }
  }
  return result;
};
var formatDistance$2E = formatDistance$2D;
function buildFormatLongFn$1(args) {
  return function() {
    var options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    var width = options.width ? String(options.width) : args.defaultWidth;
    var format3 = args.formats[width] || args.formats[args.defaultWidth];
    return format3;
  };
}
var dateFormats$1r = {
  full: "EEEE, MMMM do, y",
  long: "MMMM do, y",
  medium: "MMM d, y",
  short: "MM/dd/yyyy"
};
var timeFormats$1r = {
  full: "h:mm:ss a zzzz",
  long: "h:mm:ss a z",
  medium: "h:mm:ss a",
  short: "h:mm a"
};
var dateTimeFormats$1r = {
  full: "{{date}} 'at' {{time}}",
  long: "{{date}} 'at' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong$2S = {
  date: buildFormatLongFn$1({
    formats: dateFormats$1r,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn$1({
    formats: timeFormats$1r,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn$1({
    formats: dateTimeFormats$1r,
    defaultWidth: "full"
  })
};
var formatLong$2T = formatLong$2S;
var formatRelativeLocale$1j = {
  lastWeek: "'last' eeee 'at' p",
  yesterday: "'yesterday at' p",
  today: "'today at' p",
  tomorrow: "'tomorrow at' p",
  nextWeek: "eeee 'at' p",
  other: "P"
};
var formatRelative$2D = function formatRelative(token, _date, _baseDate, _options) {
  return formatRelativeLocale$1j[token];
};
var formatRelative$2E = formatRelative$2D;
function buildLocalizeFn$1(args) {
  return function(dirtyIndex, options) {
    var context2 = options !== null && options !== void 0 && options.context ? String(options.context) : "standalone";
    var valuesArray;
    if (context2 === "formatting" && args.formattingValues) {
      var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
      var width = options !== null && options !== void 0 && options.width ? String(options.width) : defaultWidth;
      valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
    } else {
      var _defaultWidth = args.defaultWidth;
      var _width = options !== null && options !== void 0 && options.width ? String(options.width) : args.defaultWidth;
      valuesArray = args.values[_width] || args.values[_defaultWidth];
    }
    var index2 = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
    return valuesArray[index2];
  };
}
var eraValues$1j = {
  narrow: ["B", "A"],
  abbreviated: ["BC", "AD"],
  wide: ["Before Christ", "Anno Domini"]
};
var quarterValues$1j = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["Q1", "Q2", "Q3", "Q4"],
  wide: ["1st quarter", "2nd quarter", "3rd quarter", "4th quarter"]
};
var monthValues$1j = {
  narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
  abbreviated: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
  wide: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
};
var dayValues$1j = {
  narrow: ["S", "M", "T", "W", "T", "F", "S"],
  short: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
  abbreviated: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
  wide: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
};
var dayPeriodValues$1j = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  }
};
var formattingDayPeriodValues$14 = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  }
};
var ordinalNumber$1j = function ordinalNumber(dirtyNumber, _options) {
  var number = Number(dirtyNumber);
  var rem100 = number % 100;
  if (rem100 > 20 || rem100 < 10) {
    switch (rem100 % 10) {
      case 1:
        return number + "st";
      case 2:
        return number + "nd";
      case 3:
        return number + "rd";
    }
  }
  return number + "th";
};
var localize$2C = {
  ordinalNumber: ordinalNumber$1j,
  era: buildLocalizeFn$1({
    values: eraValues$1j,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn$1({
    values: quarterValues$1j,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback(quarter) {
      return quarter - 1;
    }
  }),
  month: buildLocalizeFn$1({
    values: monthValues$1j,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn$1({
    values: dayValues$1j,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn$1({
    values: dayPeriodValues$1j,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues$14,
    defaultFormattingWidth: "wide"
  })
};
var localize$2D = localize$2C;
function buildMatchFn$1(args) {
  return function(string) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var width = options.width;
    var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
    var matchResult = string.match(matchPattern);
    if (!matchResult) {
      return null;
    }
    var matchedString = matchResult[0];
    var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
    var key = Array.isArray(parsePatterns) ? findIndex$2(parsePatterns, function(pattern) {
      return pattern.test(matchedString);
    }) : findKey$1(parsePatterns, function(pattern) {
      return pattern.test(matchedString);
    });
    var value;
    value = args.valueCallback ? args.valueCallback(key) : key;
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value,
      rest
    };
  };
}
function findKey$1(object, predicate) {
  for (var key in object) {
    if (object.hasOwnProperty(key) && predicate(object[key])) {
      return key;
    }
  }
  return void 0;
}
function findIndex$2(array, predicate) {
  for (var key = 0; key < array.length; key++) {
    if (predicate(array[key])) {
      return key;
    }
  }
  return void 0;
}
function buildMatchPatternFn$1(args) {
  return function(string) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var matchResult = string.match(args.matchPattern);
    if (!matchResult)
      return null;
    var matchedString = matchResult[0];
    var parseResult = string.match(args.parsePattern);
    if (!parseResult)
      return null;
    var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value,
      rest
    };
  };
}
var matchOrdinalNumberPattern$1i = /^(\d+)(th|st|nd|rd)?/i;
var parseOrdinalNumberPattern$1i = /\d+/i;
var matchEraPatterns$1i = {
  narrow: /^(b|a)/i,
  abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
  wide: /^(before christ|before common era|anno domini|common era)/i
};
var parseEraPatterns$1i = {
  any: [/^b/i, /^(a|c)/i]
};
var matchQuarterPatterns$1i = {
  narrow: /^[1234]/i,
  abbreviated: /^q[1234]/i,
  wide: /^[1234](th|st|nd|rd)? quarter/i
};
var parseQuarterPatterns$1i = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns$1i = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
  wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
};
var parseMonthPatterns$1i = {
  narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
  any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
};
var matchDayPatterns$1i = {
  narrow: /^[smtwf]/i,
  short: /^(su|mo|tu|we|th|fr|sa)/i,
  abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
  wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
};
var parseDayPatterns$1i = {
  narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
  any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
};
var matchDayPeriodPatterns$1i = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
};
var parseDayPeriodPatterns$1i = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i
  }
};
var match$2C = {
  ordinalNumber: buildMatchPatternFn$1({
    matchPattern: matchOrdinalNumberPattern$1i,
    parsePattern: parseOrdinalNumberPattern$1i,
    valueCallback: function valueCallback(value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn$1({
    matchPatterns: matchEraPatterns$1i,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns$1i,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn$1({
    matchPatterns: matchQuarterPatterns$1i,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns$1i,
    defaultParseWidth: "any",
    valueCallback: function valueCallback2(index2) {
      return index2 + 1;
    }
  }),
  month: buildMatchFn$1({
    matchPatterns: matchMonthPatterns$1i,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns$1i,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn$1({
    matchPatterns: matchDayPatterns$1i,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns$1i,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn$1({
    matchPatterns: matchDayPeriodPatterns$1i,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns$1i,
    defaultParseWidth: "any"
  })
};
var match$2D = match$2C;
var locale$2Y = {
  code: "en-US",
  formatDistance: formatDistance$2E,
  formatLong: formatLong$2T,
  formatRelative: formatRelative$2E,
  localize: localize$2D,
  match: match$2D,
  options: {
    weekStartsOn: 0,
    firstWeekContainsDate: 1
  }
};
var defaultLocale$8 = locale$2Y;
var formattingTokensRegExp$4 = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
var longFormattingTokensRegExp$3 = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
var escapedStringRegExp$4 = /^'([^]*?)'?$/;
var doubleQuoteRegExp$4 = /''/g;
var unescapedLatinCharacterRegExp$4 = /[a-zA-Z]/;
function format$1(dirtyDate, dirtyFormatStr, options) {
  var _ref, _options$locale, _ref2, _ref3, _ref4, _options$firstWeekCon, _options$locale2, _options$locale2$opti, _defaultOptions$local, _defaultOptions$local2, _ref5, _ref6, _ref7, _options$weekStartsOn, _options$locale3, _options$locale3$opti, _defaultOptions$local3, _defaultOptions$local4;
  requiredArgs$1(2, arguments);
  var formatStr = String(dirtyFormatStr);
  var defaultOptions2 = getDefaultOptions$1();
  var locale2 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale$8;
  var firstWeekContainsDate = toInteger$1((_ref2 = (_ref3 = (_ref4 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale2 = options.locale) === null || _options$locale2 === void 0 ? void 0 : (_options$locale2$opti = _options$locale2.options) === null || _options$locale2$opti === void 0 ? void 0 : _options$locale2$opti.firstWeekContainsDate) !== null && _ref4 !== void 0 ? _ref4 : defaultOptions2.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var weekStartsOn = toInteger$1((_ref5 = (_ref6 = (_ref7 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale3 = options.locale) === null || _options$locale3 === void 0 ? void 0 : (_options$locale3$opti = _options$locale3.options) === null || _options$locale3$opti === void 0 ? void 0 : _options$locale3$opti.weekStartsOn) !== null && _ref7 !== void 0 ? _ref7 : defaultOptions2.weekStartsOn) !== null && _ref6 !== void 0 ? _ref6 : (_defaultOptions$local3 = defaultOptions2.locale) === null || _defaultOptions$local3 === void 0 ? void 0 : (_defaultOptions$local4 = _defaultOptions$local3.options) === null || _defaultOptions$local4 === void 0 ? void 0 : _defaultOptions$local4.weekStartsOn) !== null && _ref5 !== void 0 ? _ref5 : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  if (!locale2.localize) {
    throw new RangeError("locale must contain localize property");
  }
  if (!locale2.formatLong) {
    throw new RangeError("locale must contain formatLong property");
  }
  var originalDate = toDate$1(dirtyDate);
  if (!isValid$1(originalDate)) {
    throw new RangeError("Invalid time value");
  }
  var timezoneOffset = getTimezoneOffsetInMilliseconds$1(originalDate);
  var utcDate = subMilliseconds$1(originalDate, timezoneOffset);
  var formatterOptions = {
    firstWeekContainsDate,
    weekStartsOn,
    locale: locale2,
    _originalDate: originalDate
  };
  var result = formatStr.match(longFormattingTokensRegExp$3).map(function(substring) {
    var firstCharacter = substring[0];
    if (firstCharacter === "p" || firstCharacter === "P") {
      var longFormatter = longFormatters$3[firstCharacter];
      return longFormatter(substring, locale2.formatLong);
    }
    return substring;
  }).join("").match(formattingTokensRegExp$4).map(function(substring) {
    if (substring === "''") {
      return "'";
    }
    var firstCharacter = substring[0];
    if (firstCharacter === "'") {
      return cleanEscapedString$4(substring);
    }
    var formatter = formatters$5[firstCharacter];
    if (formatter) {
      if (!(options !== null && options !== void 0 && options.useAdditionalWeekYearTokens) && isProtectedWeekYearToken$1(substring)) {
        throwProtectedError$1(substring, dirtyFormatStr, String(dirtyDate));
      }
      if (!(options !== null && options !== void 0 && options.useAdditionalDayOfYearTokens) && isProtectedDayOfYearToken$1(substring)) {
        throwProtectedError$1(substring, dirtyFormatStr, String(dirtyDate));
      }
      return formatter(utcDate, substring, locale2.localize, formatterOptions);
    }
    if (firstCharacter.match(unescapedLatinCharacterRegExp$4)) {
      throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
    }
    return substring;
  }).join("");
  return result;
}
function cleanEscapedString$4(input2) {
  var matched = input2.match(escapedStringRegExp$4);
  if (!matched) {
    return input2;
  }
  return matched[1].replace(doubleQuoteRegExp$4, "'");
}
function assign$1(target, object) {
  if (target == null) {
    throw new TypeError("assign requires that input parameter not be null or undefined");
  }
  for (var property2 in object) {
    if (Object.prototype.hasOwnProperty.call(object, property2)) {
      target[property2] = object[property2];
    }
  }
  return target;
}
function cloneObject(object) {
  return assign$1({}, object);
}
var MINUTES_IN_DAY$1 = 1440;
var MINUTES_IN_ALMOST_TWO_DAYS = 2520;
var MINUTES_IN_MONTH$1 = 43200;
var MINUTES_IN_TWO_MONTHS = 86400;
function formatDistance$2C(dirtyDate, dirtyBaseDate, options) {
  var _ref, _options$locale;
  requiredArgs$1(2, arguments);
  var defaultOptions2 = getDefaultOptions$1();
  var locale2 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale$8;
  if (!locale2.formatDistance) {
    throw new RangeError("locale must contain formatDistance property");
  }
  var comparison = compareAsc(dirtyDate, dirtyBaseDate);
  if (isNaN(comparison)) {
    throw new RangeError("Invalid time value");
  }
  var localizeOptions = assign$1(cloneObject(options), {
    addSuffix: Boolean(options === null || options === void 0 ? void 0 : options.addSuffix),
    comparison
  });
  var dateLeft;
  var dateRight;
  if (comparison > 0) {
    dateLeft = toDate$1(dirtyBaseDate);
    dateRight = toDate$1(dirtyDate);
  } else {
    dateLeft = toDate$1(dirtyDate);
    dateRight = toDate$1(dirtyBaseDate);
  }
  var seconds = differenceInSeconds(dateRight, dateLeft);
  var offsetInSeconds = (getTimezoneOffsetInMilliseconds$1(dateRight) - getTimezoneOffsetInMilliseconds$1(dateLeft)) / 1e3;
  var minutes = Math.round((seconds - offsetInSeconds) / 60);
  var months2;
  if (minutes < 2) {
    if (options !== null && options !== void 0 && options.includeSeconds) {
      if (seconds < 5) {
        return locale2.formatDistance("lessThanXSeconds", 5, localizeOptions);
      } else if (seconds < 10) {
        return locale2.formatDistance("lessThanXSeconds", 10, localizeOptions);
      } else if (seconds < 20) {
        return locale2.formatDistance("lessThanXSeconds", 20, localizeOptions);
      } else if (seconds < 40) {
        return locale2.formatDistance("halfAMinute", 0, localizeOptions);
      } else if (seconds < 60) {
        return locale2.formatDistance("lessThanXMinutes", 1, localizeOptions);
      } else {
        return locale2.formatDistance("xMinutes", 1, localizeOptions);
      }
    } else {
      if (minutes === 0) {
        return locale2.formatDistance("lessThanXMinutes", 1, localizeOptions);
      } else {
        return locale2.formatDistance("xMinutes", minutes, localizeOptions);
      }
    }
  } else if (minutes < 45) {
    return locale2.formatDistance("xMinutes", minutes, localizeOptions);
  } else if (minutes < 90) {
    return locale2.formatDistance("aboutXHours", 1, localizeOptions);
  } else if (minutes < MINUTES_IN_DAY$1) {
    var hours = Math.round(minutes / 60);
    return locale2.formatDistance("aboutXHours", hours, localizeOptions);
  } else if (minutes < MINUTES_IN_ALMOST_TWO_DAYS) {
    return locale2.formatDistance("xDays", 1, localizeOptions);
  } else if (minutes < MINUTES_IN_MONTH$1) {
    var days2 = Math.round(minutes / MINUTES_IN_DAY$1);
    return locale2.formatDistance("xDays", days2, localizeOptions);
  } else if (minutes < MINUTES_IN_TWO_MONTHS) {
    months2 = Math.round(minutes / MINUTES_IN_MONTH$1);
    return locale2.formatDistance("aboutXMonths", months2, localizeOptions);
  }
  months2 = differenceInMonths(dateRight, dateLeft);
  if (months2 < 12) {
    var nearestMonth = Math.round(minutes / MINUTES_IN_MONTH$1);
    return locale2.formatDistance("xMonths", nearestMonth, localizeOptions);
  } else {
    var monthsSinceStartOfYear = months2 % 12;
    var years = Math.floor(months2 / 12);
    if (monthsSinceStartOfYear < 3) {
      return locale2.formatDistance("aboutXYears", years, localizeOptions);
    } else if (monthsSinceStartOfYear < 9) {
      return locale2.formatDistance("overXYears", years, localizeOptions);
    } else {
      return locale2.formatDistance("almostXYears", years + 1, localizeOptions);
    }
  }
}
var MILLISECONDS_IN_MINUTE$1 = 1e3 * 60;
var MINUTES_IN_DAY = 60 * 24;
var MINUTES_IN_MONTH = MINUTES_IN_DAY * 30;
var MINUTES_IN_YEAR = MINUTES_IN_DAY * 365;
function formatDistanceStrict(dirtyDate, dirtyBaseDate, options) {
  var _ref, _options$locale, _options$roundingMeth;
  requiredArgs$1(2, arguments);
  var defaultOptions2 = getDefaultOptions$1();
  var locale2 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale$8;
  if (!locale2.formatDistance) {
    throw new RangeError("locale must contain localize.formatDistance property");
  }
  var comparison = compareAsc(dirtyDate, dirtyBaseDate);
  if (isNaN(comparison)) {
    throw new RangeError("Invalid time value");
  }
  var localizeOptions = assign$1(cloneObject(options), {
    addSuffix: Boolean(options === null || options === void 0 ? void 0 : options.addSuffix),
    comparison
  });
  var dateLeft;
  var dateRight;
  if (comparison > 0) {
    dateLeft = toDate$1(dirtyBaseDate);
    dateRight = toDate$1(dirtyDate);
  } else {
    dateLeft = toDate$1(dirtyDate);
    dateRight = toDate$1(dirtyBaseDate);
  }
  var roundingMethod = String((_options$roundingMeth = options === null || options === void 0 ? void 0 : options.roundingMethod) !== null && _options$roundingMeth !== void 0 ? _options$roundingMeth : "round");
  var roundingMethodFn;
  if (roundingMethod === "floor") {
    roundingMethodFn = Math.floor;
  } else if (roundingMethod === "ceil") {
    roundingMethodFn = Math.ceil;
  } else if (roundingMethod === "round") {
    roundingMethodFn = Math.round;
  } else {
    throw new RangeError("roundingMethod must be 'floor', 'ceil' or 'round'");
  }
  var milliseconds2 = dateRight.getTime() - dateLeft.getTime();
  var minutes = milliseconds2 / MILLISECONDS_IN_MINUTE$1;
  var timezoneOffset = getTimezoneOffsetInMilliseconds$1(dateRight) - getTimezoneOffsetInMilliseconds$1(dateLeft);
  var dstNormalizedMinutes = (milliseconds2 - timezoneOffset) / MILLISECONDS_IN_MINUTE$1;
  var defaultUnit = options === null || options === void 0 ? void 0 : options.unit;
  var unit;
  if (!defaultUnit) {
    if (minutes < 1) {
      unit = "second";
    } else if (minutes < 60) {
      unit = "minute";
    } else if (minutes < MINUTES_IN_DAY) {
      unit = "hour";
    } else if (dstNormalizedMinutes < MINUTES_IN_MONTH) {
      unit = "day";
    } else if (dstNormalizedMinutes < MINUTES_IN_YEAR) {
      unit = "month";
    } else {
      unit = "year";
    }
  } else {
    unit = String(defaultUnit);
  }
  if (unit === "second") {
    var seconds = roundingMethodFn(milliseconds2 / 1e3);
    return locale2.formatDistance("xSeconds", seconds, localizeOptions);
  } else if (unit === "minute") {
    var roundedMinutes = roundingMethodFn(minutes);
    return locale2.formatDistance("xMinutes", roundedMinutes, localizeOptions);
  } else if (unit === "hour") {
    var hours = roundingMethodFn(minutes / 60);
    return locale2.formatDistance("xHours", hours, localizeOptions);
  } else if (unit === "day") {
    var days2 = roundingMethodFn(dstNormalizedMinutes / MINUTES_IN_DAY);
    return locale2.formatDistance("xDays", days2, localizeOptions);
  } else if (unit === "month") {
    var months2 = roundingMethodFn(dstNormalizedMinutes / MINUTES_IN_MONTH);
    return months2 === 12 && defaultUnit !== "month" ? locale2.formatDistance("xYears", 1, localizeOptions) : locale2.formatDistance("xMonths", months2, localizeOptions);
  } else if (unit === "year") {
    var years = roundingMethodFn(dstNormalizedMinutes / MINUTES_IN_YEAR);
    return locale2.formatDistance("xYears", years, localizeOptions);
  }
  throw new RangeError("unit must be 'second', 'minute', 'hour', 'day', 'month' or 'year'");
}
function formatDistanceToNow(dirtyDate, options) {
  requiredArgs$1(1, arguments);
  return formatDistance$2C(dirtyDate, Date.now(), options);
}
function formatDistanceToNowStrict(dirtyDate, options) {
  requiredArgs$1(1, arguments);
  return formatDistanceStrict(dirtyDate, Date.now(), options);
}
var defaultFormat = ["years", "months", "weeks", "days", "hours", "minutes", "seconds"];
function formatDuration(duration2, options) {
  var _ref, _options$locale, _options$format, _options$zero, _options$delimiter;
  if (arguments.length < 1) {
    throw new TypeError("1 argument required, but only ".concat(arguments.length, " present"));
  }
  var defaultOptions2 = getDefaultOptions$1();
  var locale2 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale$8;
  var format3 = (_options$format = options === null || options === void 0 ? void 0 : options.format) !== null && _options$format !== void 0 ? _options$format : defaultFormat;
  var zero = (_options$zero = options === null || options === void 0 ? void 0 : options.zero) !== null && _options$zero !== void 0 ? _options$zero : false;
  var delimiter = (_options$delimiter = options === null || options === void 0 ? void 0 : options.delimiter) !== null && _options$delimiter !== void 0 ? _options$delimiter : " ";
  if (!locale2.formatDistance) {
    return "";
  }
  var result = format3.reduce(function(acc, unit) {
    var token = "x".concat(unit.replace(/(^.)/, function(m4) {
      return m4.toUpperCase();
    }));
    var value = duration2[unit];
    if (typeof value === "number" && (zero || duration2[unit])) {
      return acc.concat(locale2.formatDistance(token, value));
    }
    return acc;
  }, []).join(delimiter);
  return result;
}
function formatISO(date, options) {
  var _options$format, _options$representati;
  requiredArgs$1(1, arguments);
  var originalDate = toDate$1(date);
  if (isNaN(originalDate.getTime())) {
    throw new RangeError("Invalid time value");
  }
  var format3 = String((_options$format = options === null || options === void 0 ? void 0 : options.format) !== null && _options$format !== void 0 ? _options$format : "extended");
  var representation = String((_options$representati = options === null || options === void 0 ? void 0 : options.representation) !== null && _options$representati !== void 0 ? _options$representati : "complete");
  if (format3 !== "extended" && format3 !== "basic") {
    throw new RangeError("format must be 'extended' or 'basic'");
  }
  if (representation !== "date" && representation !== "time" && representation !== "complete") {
    throw new RangeError("representation must be 'date', 'time', or 'complete'");
  }
  var result = "";
  var tzOffset = "";
  var dateDelimiter = format3 === "extended" ? "-" : "";
  var timeDelimiter = format3 === "extended" ? ":" : "";
  if (representation !== "time") {
    var day = addLeadingZeros$1(originalDate.getDate(), 2);
    var month = addLeadingZeros$1(originalDate.getMonth() + 1, 2);
    var year = addLeadingZeros$1(originalDate.getFullYear(), 4);
    result = "".concat(year).concat(dateDelimiter).concat(month).concat(dateDelimiter).concat(day);
  }
  if (representation !== "date") {
    var offset4 = originalDate.getTimezoneOffset();
    if (offset4 !== 0) {
      var absoluteOffset = Math.abs(offset4);
      var hourOffset = addLeadingZeros$1(Math.floor(absoluteOffset / 60), 2);
      var minuteOffset = addLeadingZeros$1(absoluteOffset % 60, 2);
      var sign = offset4 < 0 ? "+" : "-";
      tzOffset = "".concat(sign).concat(hourOffset, ":").concat(minuteOffset);
    } else {
      tzOffset = "Z";
    }
    var hour = addLeadingZeros$1(originalDate.getHours(), 2);
    var minute = addLeadingZeros$1(originalDate.getMinutes(), 2);
    var second = addLeadingZeros$1(originalDate.getSeconds(), 2);
    var separator = result === "" ? "" : "T";
    var time = [hour, minute, second].join(timeDelimiter);
    result = "".concat(result).concat(separator).concat(time).concat(tzOffset);
  }
  return result;
}
function formatISO9075(dirtyDate, options) {
  var _options$format, _options$representati;
  if (arguments.length < 1) {
    throw new TypeError("1 argument required, but only ".concat(arguments.length, " present"));
  }
  var originalDate = toDate$1(dirtyDate);
  if (!isValid$1(originalDate)) {
    throw new RangeError("Invalid time value");
  }
  var format3 = String((_options$format = options === null || options === void 0 ? void 0 : options.format) !== null && _options$format !== void 0 ? _options$format : "extended");
  var representation = String((_options$representati = options === null || options === void 0 ? void 0 : options.representation) !== null && _options$representati !== void 0 ? _options$representati : "complete");
  if (format3 !== "extended" && format3 !== "basic") {
    throw new RangeError("format must be 'extended' or 'basic'");
  }
  if (representation !== "date" && representation !== "time" && representation !== "complete") {
    throw new RangeError("representation must be 'date', 'time', or 'complete'");
  }
  var result = "";
  var dateDelimiter = format3 === "extended" ? "-" : "";
  var timeDelimiter = format3 === "extended" ? ":" : "";
  if (representation !== "time") {
    var day = addLeadingZeros$1(originalDate.getDate(), 2);
    var month = addLeadingZeros$1(originalDate.getMonth() + 1, 2);
    var year = addLeadingZeros$1(originalDate.getFullYear(), 4);
    result = "".concat(year).concat(dateDelimiter).concat(month).concat(dateDelimiter).concat(day);
  }
  if (representation !== "date") {
    var hour = addLeadingZeros$1(originalDate.getHours(), 2);
    var minute = addLeadingZeros$1(originalDate.getMinutes(), 2);
    var second = addLeadingZeros$1(originalDate.getSeconds(), 2);
    var separator = result === "" ? "" : " ";
    result = "".concat(result).concat(separator).concat(hour).concat(timeDelimiter).concat(minute).concat(timeDelimiter).concat(second);
  }
  return result;
}
function formatISODuration(duration2) {
  requiredArgs$1(1, arguments);
  if (_typeof$5(duration2) !== "object")
    throw new Error("Duration must be an object");
  var _duration$years = duration2.years, years = _duration$years === void 0 ? 0 : _duration$years, _duration$months = duration2.months, months2 = _duration$months === void 0 ? 0 : _duration$months, _duration$days = duration2.days, days2 = _duration$days === void 0 ? 0 : _duration$days, _duration$hours = duration2.hours, hours = _duration$hours === void 0 ? 0 : _duration$hours, _duration$minutes = duration2.minutes, minutes = _duration$minutes === void 0 ? 0 : _duration$minutes, _duration$seconds = duration2.seconds, seconds = _duration$seconds === void 0 ? 0 : _duration$seconds;
  return "P".concat(years, "Y").concat(months2, "M").concat(days2, "DT").concat(hours, "H").concat(minutes, "M").concat(seconds, "S");
}
function formatRFC3339(dirtyDate, options) {
  var _options$fractionDigi;
  if (arguments.length < 1) {
    throw new TypeError("1 arguments required, but only ".concat(arguments.length, " present"));
  }
  var originalDate = toDate$1(dirtyDate);
  if (!isValid$1(originalDate)) {
    throw new RangeError("Invalid time value");
  }
  var fractionDigits = Number((_options$fractionDigi = options === null || options === void 0 ? void 0 : options.fractionDigits) !== null && _options$fractionDigi !== void 0 ? _options$fractionDigi : 0);
  if (!(fractionDigits >= 0 && fractionDigits <= 3)) {
    throw new RangeError("fractionDigits must be between 0 and 3 inclusively");
  }
  var day = addLeadingZeros$1(originalDate.getDate(), 2);
  var month = addLeadingZeros$1(originalDate.getMonth() + 1, 2);
  var year = originalDate.getFullYear();
  var hour = addLeadingZeros$1(originalDate.getHours(), 2);
  var minute = addLeadingZeros$1(originalDate.getMinutes(), 2);
  var second = addLeadingZeros$1(originalDate.getSeconds(), 2);
  var fractionalSecond = "";
  if (fractionDigits > 0) {
    var milliseconds2 = originalDate.getMilliseconds();
    var fractionalSeconds = Math.floor(milliseconds2 * Math.pow(10, fractionDigits - 3));
    fractionalSecond = "." + addLeadingZeros$1(fractionalSeconds, fractionDigits);
  }
  var offset4 = "";
  var tzOffset = originalDate.getTimezoneOffset();
  if (tzOffset !== 0) {
    var absoluteOffset = Math.abs(tzOffset);
    var hourOffset = addLeadingZeros$1(toInteger$1(absoluteOffset / 60), 2);
    var minuteOffset = addLeadingZeros$1(absoluteOffset % 60, 2);
    var sign = tzOffset < 0 ? "+" : "-";
    offset4 = "".concat(sign).concat(hourOffset, ":").concat(minuteOffset);
  } else {
    offset4 = "Z";
  }
  return "".concat(year, "-").concat(month, "-").concat(day, "T").concat(hour, ":").concat(minute, ":").concat(second).concat(fractionalSecond).concat(offset4);
}
var days = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
var months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
function formatRFC7231(dirtyDate) {
  if (arguments.length < 1) {
    throw new TypeError("1 arguments required, but only ".concat(arguments.length, " present"));
  }
  var originalDate = toDate$1(dirtyDate);
  if (!isValid$1(originalDate)) {
    throw new RangeError("Invalid time value");
  }
  var dayName = days[originalDate.getUTCDay()];
  var dayOfMonth = addLeadingZeros$1(originalDate.getUTCDate(), 2);
  var monthName = months[originalDate.getUTCMonth()];
  var year = originalDate.getUTCFullYear();
  var hour = addLeadingZeros$1(originalDate.getUTCHours(), 2);
  var minute = addLeadingZeros$1(originalDate.getUTCMinutes(), 2);
  var second = addLeadingZeros$1(originalDate.getUTCSeconds(), 2);
  return "".concat(dayName, ", ").concat(dayOfMonth, " ").concat(monthName, " ").concat(year, " ").concat(hour, ":").concat(minute, ":").concat(second, " GMT");
}
function formatRelative$2C(dirtyDate, dirtyBaseDate, options) {
  var _ref, _options$locale, _ref2, _ref3, _ref4, _options$weekStartsOn, _options$locale2, _options$locale2$opti, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var baseDate = toDate$1(dirtyBaseDate);
  var defaultOptions2 = getDefaultOptions$1();
  var locale2 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale$8;
  var weekStartsOn = toInteger$1((_ref2 = (_ref3 = (_ref4 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale2 = options.locale) === null || _options$locale2 === void 0 ? void 0 : (_options$locale2$opti = _options$locale2.options) === null || _options$locale2$opti === void 0 ? void 0 : _options$locale2$opti.weekStartsOn) !== null && _ref4 !== void 0 ? _ref4 : defaultOptions2.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : 0);
  if (!locale2.localize) {
    throw new RangeError("locale must contain localize property");
  }
  if (!locale2.formatLong) {
    throw new RangeError("locale must contain formatLong property");
  }
  if (!locale2.formatRelative) {
    throw new RangeError("locale must contain formatRelative property");
  }
  var diff = differenceInCalendarDays(date, baseDate);
  if (isNaN(diff)) {
    throw new RangeError("Invalid time value");
  }
  var token;
  if (diff < -6) {
    token = "other";
  } else if (diff < -1) {
    token = "lastWeek";
  } else if (diff < 0) {
    token = "yesterday";
  } else if (diff < 1) {
    token = "today";
  } else if (diff < 2) {
    token = "tomorrow";
  } else if (diff < 7) {
    token = "nextWeek";
  } else {
    token = "other";
  }
  var utcDate = subMilliseconds$1(date, getTimezoneOffsetInMilliseconds$1(date));
  var utcBaseDate = subMilliseconds$1(baseDate, getTimezoneOffsetInMilliseconds$1(baseDate));
  var formatStr = locale2.formatRelative(token, utcDate, utcBaseDate, {
    locale: locale2,
    weekStartsOn
  });
  return format$1(date, formatStr, {
    locale: locale2,
    weekStartsOn
  });
}
function fromUnixTime(dirtyUnixTime) {
  requiredArgs$1(1, arguments);
  var unixTime = toInteger$1(dirtyUnixTime);
  return toDate$1(unixTime * 1e3);
}
function getDate(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var dayOfMonth = date.getDate();
  return dayOfMonth;
}
function getDay(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var day = date.getDay();
  return day;
}
function getDayOfYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var diff = differenceInCalendarDays(date, startOfYear(date));
  var dayOfYear = diff + 1;
  return dayOfYear;
}
function getDaysInMonth(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var year = date.getFullYear();
  var monthIndex = date.getMonth();
  var lastDayOfMonth2 = new Date(0);
  lastDayOfMonth2.setFullYear(year, monthIndex + 1, 0);
  lastDayOfMonth2.setHours(0, 0, 0, 0);
  return lastDayOfMonth2.getDate();
}
function isLeapYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var year = date.getFullYear();
  return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
}
function getDaysInYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  if (String(new Date(date)) === "Invalid Date") {
    return NaN;
  }
  return isLeapYear(date) ? 366 : 365;
}
function getDecade(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var year = date.getFullYear();
  var decade = Math.floor(year / 10) * 10;
  return decade;
}
function getDefaultOptions() {
  return assign$1({}, getDefaultOptions$1());
}
function getHours(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var hours = date.getHours();
  return hours;
}
function getISODay(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var day = date.getDay();
  if (day === 0) {
    day = 7;
  }
  return day;
}
var MILLISECONDS_IN_WEEK$4 = 6048e5;
function getISOWeek(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var diff = startOfISOWeek(date).getTime() - startOfISOWeekYear(date).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK$4) + 1;
}
var MILLISECONDS_IN_WEEK$3 = 6048e5;
function getISOWeeksInYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  var thisYear = startOfISOWeekYear(dirtyDate);
  var nextYear = startOfISOWeekYear(addWeeks(thisYear, 60));
  var diff = nextYear.valueOf() - thisYear.valueOf();
  return Math.round(diff / MILLISECONDS_IN_WEEK$3);
}
function getMilliseconds(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var milliseconds2 = date.getMilliseconds();
  return milliseconds2;
}
function getMinutes(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var minutes = date.getMinutes();
  return minutes;
}
function getMonth(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var month = date.getMonth();
  return month;
}
var MILLISECONDS_IN_DAY$1 = 24 * 60 * 60 * 1e3;
function getOverlappingDaysInIntervals(dirtyIntervalLeft, dirtyIntervalRight) {
  requiredArgs$1(2, arguments);
  var intervalLeft = dirtyIntervalLeft || {};
  var intervalRight = dirtyIntervalRight || {};
  var leftStartTime = toDate$1(intervalLeft.start).getTime();
  var leftEndTime = toDate$1(intervalLeft.end).getTime();
  var rightStartTime = toDate$1(intervalRight.start).getTime();
  var rightEndTime = toDate$1(intervalRight.end).getTime();
  if (!(leftStartTime <= leftEndTime && rightStartTime <= rightEndTime)) {
    throw new RangeError("Invalid interval");
  }
  var isOverlapping = leftStartTime < rightEndTime && rightStartTime < leftEndTime;
  if (!isOverlapping) {
    return 0;
  }
  var overlapStartDate = rightStartTime < leftStartTime ? leftStartTime : rightStartTime;
  var overlapEndDate = rightEndTime > leftEndTime ? leftEndTime : rightEndTime;
  var differenceInMs = overlapEndDate - overlapStartDate;
  return Math.ceil(differenceInMs / MILLISECONDS_IN_DAY$1);
}
function getSeconds(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var seconds = date.getSeconds();
  return seconds;
}
function getTime(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var timestamp = date.getTime();
  return timestamp;
}
function getUnixTime(dirtyDate) {
  requiredArgs$1(1, arguments);
  return Math.floor(getTime(dirtyDate) / 1e3);
}
function getWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var year = date.getFullYear();
  var defaultOptions2 = getDefaultOptions$1();
  var firstWeekContainsDate = toInteger$1((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var firstWeekOfNextYear = new Date(0);
  firstWeekOfNextYear.setFullYear(year + 1, 0, firstWeekContainsDate);
  firstWeekOfNextYear.setHours(0, 0, 0, 0);
  var startOfNextYear = startOfWeek(firstWeekOfNextYear, options);
  var firstWeekOfThisYear = new Date(0);
  firstWeekOfThisYear.setFullYear(year, 0, firstWeekContainsDate);
  firstWeekOfThisYear.setHours(0, 0, 0, 0);
  var startOfThisYear = startOfWeek(firstWeekOfThisYear, options);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}
function startOfWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(1, arguments);
  var defaultOptions2 = getDefaultOptions$1();
  var firstWeekContainsDate = toInteger$1((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  var year = getWeekYear(dirtyDate, options);
  var firstWeek = new Date(0);
  firstWeek.setFullYear(year, 0, firstWeekContainsDate);
  firstWeek.setHours(0, 0, 0, 0);
  var date = startOfWeek(firstWeek, options);
  return date;
}
var MILLISECONDS_IN_WEEK$2 = 6048e5;
function getWeek(dirtyDate, options) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var diff = startOfWeek(date, options).getTime() - startOfWeekYear(date, options).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK$2) + 1;
}
function getWeekOfMonth(date, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(1, arguments);
  var defaultOptions2 = getDefaultOptions$1();
  var weekStartsOn = toInteger$1((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var currentDayOfMonth = getDate(date);
  if (isNaN(currentDayOfMonth))
    return NaN;
  var startWeekDay = getDay(startOfMonth(date));
  var lastDayOfFirstWeek = weekStartsOn - startWeekDay;
  if (lastDayOfFirstWeek <= 0)
    lastDayOfFirstWeek += 7;
  var remainingDaysAfterFirstWeek = currentDayOfMonth - lastDayOfFirstWeek;
  return Math.ceil(remainingDaysAfterFirstWeek / 7) + 1;
}
function lastDayOfMonth(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var month = date.getMonth();
  date.setFullYear(date.getFullYear(), month + 1, 0);
  date.setHours(0, 0, 0, 0);
  return date;
}
function getWeeksInMonth(date, options) {
  requiredArgs$1(1, arguments);
  return differenceInCalendarWeeks(lastDayOfMonth(date), startOfMonth(date), options) + 1;
}
function getYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  return toDate$1(dirtyDate).getFullYear();
}
function hoursToMilliseconds(hours) {
  requiredArgs$1(1, arguments);
  return Math.floor(hours * millisecondsInHour$1);
}
function hoursToMinutes(hours) {
  requiredArgs$1(1, arguments);
  return Math.floor(hours * minutesInHour);
}
function hoursToSeconds(hours) {
  requiredArgs$1(1, arguments);
  return Math.floor(hours * secondsInHour);
}
function intervalToDuration(interval) {
  requiredArgs$1(1, arguments);
  var start2 = toDate$1(interval.start);
  var end2 = toDate$1(interval.end);
  if (isNaN(start2.getTime()))
    throw new RangeError("Start Date is invalid");
  if (isNaN(end2.getTime()))
    throw new RangeError("End Date is invalid");
  var duration2 = {};
  duration2.years = Math.abs(differenceInYears(end2, start2));
  var sign = compareAsc(end2, start2);
  var remainingMonths = add$2(start2, {
    years: sign * duration2.years
  });
  duration2.months = Math.abs(differenceInMonths(end2, remainingMonths));
  var remainingDays = add$2(remainingMonths, {
    months: sign * duration2.months
  });
  duration2.days = Math.abs(differenceInDays(end2, remainingDays));
  var remainingHours = add$2(remainingDays, {
    days: sign * duration2.days
  });
  duration2.hours = Math.abs(differenceInHours(end2, remainingHours));
  var remainingMinutes = add$2(remainingHours, {
    hours: sign * duration2.hours
  });
  duration2.minutes = Math.abs(differenceInMinutes(end2, remainingMinutes));
  var remainingSeconds = add$2(remainingMinutes, {
    minutes: sign * duration2.minutes
  });
  duration2.seconds = Math.abs(differenceInSeconds(end2, remainingSeconds));
  return duration2;
}
function intlFormat(date, formatOrLocale, localeOptions) {
  var _localeOptions;
  requiredArgs$1(1, arguments);
  var formatOptions;
  if (isFormatOptions(formatOrLocale)) {
    formatOptions = formatOrLocale;
  } else {
    localeOptions = formatOrLocale;
  }
  return new Intl.DateTimeFormat((_localeOptions = localeOptions) === null || _localeOptions === void 0 ? void 0 : _localeOptions.locale, formatOptions).format(date);
}
function isFormatOptions(opts) {
  return opts !== void 0 && !("locale" in opts);
}
function intlFormatDistance(date, baseDate, options) {
  requiredArgs$1(2, arguments);
  var value = 0;
  var unit;
  var dateLeft = toDate$1(date);
  var dateRight = toDate$1(baseDate);
  if (!(options !== null && options !== void 0 && options.unit)) {
    var diffInSeconds = differenceInSeconds(dateLeft, dateRight);
    if (Math.abs(diffInSeconds) < secondsInMinute) {
      value = differenceInSeconds(dateLeft, dateRight);
      unit = "second";
    } else if (Math.abs(diffInSeconds) < secondsInHour) {
      value = differenceInMinutes(dateLeft, dateRight);
      unit = "minute";
    } else if (Math.abs(diffInSeconds) < secondsInDay && Math.abs(differenceInCalendarDays(dateLeft, dateRight)) < 1) {
      value = differenceInHours(dateLeft, dateRight);
      unit = "hour";
    } else if (Math.abs(diffInSeconds) < secondsInWeek && (value = differenceInCalendarDays(dateLeft, dateRight)) && Math.abs(value) < 7) {
      unit = "day";
    } else if (Math.abs(diffInSeconds) < secondsInMonth) {
      value = differenceInCalendarWeeks(dateLeft, dateRight);
      unit = "week";
    } else if (Math.abs(diffInSeconds) < secondsInQuarter) {
      value = differenceInCalendarMonths(dateLeft, dateRight);
      unit = "month";
    } else if (Math.abs(diffInSeconds) < secondsInYear) {
      if (differenceInCalendarQuarters(dateLeft, dateRight) < 4) {
        value = differenceInCalendarQuarters(dateLeft, dateRight);
        unit = "quarter";
      } else {
        value = differenceInCalendarYears(dateLeft, dateRight);
        unit = "year";
      }
    } else {
      value = differenceInCalendarYears(dateLeft, dateRight);
      unit = "year";
    }
  } else {
    unit = options === null || options === void 0 ? void 0 : options.unit;
    if (unit === "second") {
      value = differenceInSeconds(dateLeft, dateRight);
    } else if (unit === "minute") {
      value = differenceInMinutes(dateLeft, dateRight);
    } else if (unit === "hour") {
      value = differenceInHours(dateLeft, dateRight);
    } else if (unit === "day") {
      value = differenceInCalendarDays(dateLeft, dateRight);
    } else if (unit === "week") {
      value = differenceInCalendarWeeks(dateLeft, dateRight);
    } else if (unit === "month") {
      value = differenceInCalendarMonths(dateLeft, dateRight);
    } else if (unit === "quarter") {
      value = differenceInCalendarQuarters(dateLeft, dateRight);
    } else if (unit === "year") {
      value = differenceInCalendarYears(dateLeft, dateRight);
    }
  }
  var rtf = new Intl.RelativeTimeFormat(options === null || options === void 0 ? void 0 : options.locale, {
    localeMatcher: options === null || options === void 0 ? void 0 : options.localeMatcher,
    numeric: (options === null || options === void 0 ? void 0 : options.numeric) || "auto",
    style: options === null || options === void 0 ? void 0 : options.style
  });
  return rtf.format(value, unit);
}
function isAfter(dirtyDate, dirtyDateToCompare) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var dateToCompare = toDate$1(dirtyDateToCompare);
  return date.getTime() > dateToCompare.getTime();
}
function isBefore(dirtyDate, dirtyDateToCompare) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var dateToCompare = toDate$1(dirtyDateToCompare);
  return date.getTime() < dateToCompare.getTime();
}
function isEqual$5(dirtyLeftDate, dirtyRightDate) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyLeftDate);
  var dateRight = toDate$1(dirtyRightDate);
  return dateLeft.getTime() === dateRight.getTime();
}
function isExists(year, month, day) {
  if (arguments.length < 3) {
    throw new TypeError("3 argument required, but only " + arguments.length + " present");
  }
  var date = new Date(year, month, day);
  return date.getFullYear() === year && date.getMonth() === month && date.getDate() === day;
}
function isFirstDayOfMonth(dirtyDate) {
  requiredArgs$1(1, arguments);
  return toDate$1(dirtyDate).getDate() === 1;
}
function isFriday(dirtyDate) {
  requiredArgs$1(1, arguments);
  return toDate$1(dirtyDate).getDay() === 5;
}
function isFuture(dirtyDate) {
  requiredArgs$1(1, arguments);
  return toDate$1(dirtyDate).getTime() > Date.now();
}
function _arrayLikeToArray$4(arr, len) {
  if (len == null || len > arr.length)
    len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++)
    arr2[i2] = arr[i2];
  return arr2;
}
function _unsupportedIterableToArray$4(o, minLen) {
  if (!o)
    return;
  if (typeof o === "string")
    return _arrayLikeToArray$4(o, minLen);
  var n2 = Object.prototype.toString.call(o).slice(8, -1);
  if (n2 === "Object" && o.constructor)
    n2 = o.constructor.name;
  if (n2 === "Map" || n2 === "Set")
    return Array.from(o);
  if (n2 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n2))
    return _arrayLikeToArray$4(o, minLen);
}
function _createForOfIteratorHelper(o, allowArrayLike) {
  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
  if (!it) {
    if (Array.isArray(o) || (it = _unsupportedIterableToArray$4(o)) || allowArrayLike && o && typeof o.length === "number") {
      if (it)
        o = it;
      var i2 = 0;
      var F2 = function F3() {
      };
      return {
        s: F2,
        n: function n2() {
          if (i2 >= o.length)
            return {
              done: true
            };
          return {
            done: false,
            value: o[i2++]
          };
        },
        e: function e3(_e) {
          throw _e;
        },
        f: F2
      };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var normalCompletion = true, didErr = false, err;
  return {
    s: function s3() {
      it = it.call(o);
    },
    n: function n2() {
      var step = it.next();
      normalCompletion = step.done;
      return step;
    },
    e: function e3(_e2) {
      didErr = true;
      err = _e2;
    },
    f: function f2() {
      try {
        if (!normalCompletion && it["return"] != null)
          it["return"]();
      } finally {
        if (didErr)
          throw err;
      }
    }
  };
}
function _assertThisInitialized$2(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _setPrototypeOf$1(o, p2) {
  _setPrototypeOf$1 = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p3) {
    o2.__proto__ = p3;
    return o2;
  };
  return _setPrototypeOf$1(o, p2);
}
function _inherits$2(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  Object.defineProperty(subClass, "prototype", {
    writable: false
  });
  if (superClass)
    _setPrototypeOf$1(subClass, superClass);
}
function _getPrototypeOf$2(o) {
  _getPrototypeOf$2 = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf2(o2) {
    return o2.__proto__ || Object.getPrototypeOf(o2);
  };
  return _getPrototypeOf$2(o);
}
function _isNativeReflectConstruct$2() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e3) {
    return false;
  }
}
function _possibleConstructorReturn$2(self2, call2) {
  if (call2 && (_typeof$5(call2) === "object" || typeof call2 === "function")) {
    return call2;
  } else if (call2 !== void 0) {
    throw new TypeError("Derived constructors may only return object or undefined");
  }
  return _assertThisInitialized$2(self2);
}
function _createSuper$2(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct$2();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf$2(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf$2(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn$2(this, result);
  };
}
function _classCallCheck$3(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function toPrimitive(t3, r2) {
  if (_typeof$5(t3) != "object" || !t3)
    return t3;
  var e3 = t3[Symbol.toPrimitive];
  if (e3 !== void 0) {
    var i2 = e3.call(t3, r2 || "default");
    if (_typeof$5(i2) != "object")
      return i2;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (r2 === "string" ? String : Number)(t3);
}
function toPropertyKey(t3) {
  var i2 = toPrimitive(t3, "string");
  return _typeof$5(i2) == "symbol" ? i2 : String(i2);
}
function _defineProperties$3(target, props) {
  for (var i2 = 0; i2 < props.length; i2++) {
    var descriptor = props[i2];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass$3(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties$3(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties$3(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _defineProperty$5(obj, key, value) {
  key = toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
var TIMEZONE_UNIT_PRIORITY$1 = 10;
var Setter = /* @__PURE__ */ function() {
  function Setter2() {
    _classCallCheck$3(this, Setter2);
    _defineProperty$5(this, "priority", void 0);
    _defineProperty$5(this, "subPriority", 0);
  }
  _createClass$3(Setter2, [{
    key: "validate",
    value: function validate(_utcDate, _options) {
      return true;
    }
  }]);
  return Setter2;
}();
var ValueSetter = /* @__PURE__ */ function(_Setter) {
  _inherits$2(ValueSetter2, _Setter);
  var _super = _createSuper$2(ValueSetter2);
  function ValueSetter2(value, validateValue2, setValue, priority2, subPriority) {
    var _this;
    _classCallCheck$3(this, ValueSetter2);
    _this = _super.call(this);
    _this.value = value;
    _this.validateValue = validateValue2;
    _this.setValue = setValue;
    _this.priority = priority2;
    if (subPriority) {
      _this.subPriority = subPriority;
    }
    return _this;
  }
  _createClass$3(ValueSetter2, [{
    key: "validate",
    value: function validate(utcDate, options) {
      return this.validateValue(utcDate, this.value, options);
    }
  }, {
    key: "set",
    value: function set2(utcDate, flags2, options) {
      return this.setValue(utcDate, flags2, this.value, options);
    }
  }]);
  return ValueSetter2;
}(Setter);
var DateToSystemTimezoneSetter = /* @__PURE__ */ function(_Setter2) {
  _inherits$2(DateToSystemTimezoneSetter2, _Setter2);
  var _super2 = _createSuper$2(DateToSystemTimezoneSetter2);
  function DateToSystemTimezoneSetter2() {
    var _this2;
    _classCallCheck$3(this, DateToSystemTimezoneSetter2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this2 = _super2.call.apply(_super2, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this2), "priority", TIMEZONE_UNIT_PRIORITY$1);
    _defineProperty$5(_assertThisInitialized$2(_this2), "subPriority", -1);
    return _this2;
  }
  _createClass$3(DateToSystemTimezoneSetter2, [{
    key: "set",
    value: function set2(date, flags2) {
      if (flags2.timestampIsSet) {
        return date;
      }
      var convertedDate = new Date(0);
      convertedDate.setFullYear(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate());
      convertedDate.setHours(date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.getUTCMilliseconds());
      return convertedDate;
    }
  }]);
  return DateToSystemTimezoneSetter2;
}(Setter);
var Parser = /* @__PURE__ */ function() {
  function Parser2() {
    _classCallCheck$3(this, Parser2);
    _defineProperty$5(this, "incompatibleTokens", void 0);
    _defineProperty$5(this, "priority", void 0);
    _defineProperty$5(this, "subPriority", void 0);
  }
  _createClass$3(Parser2, [{
    key: "run",
    value: function run(dateString, token, match2, options) {
      var result = this.parse(dateString, token, match2, options);
      if (!result) {
        return null;
      }
      return {
        setter: new ValueSetter(result.value, this.validate, this.set, this.priority, this.subPriority),
        rest: result.rest
      };
    }
  }, {
    key: "validate",
    value: function validate(_utcDate, _value, _options) {
      return true;
    }
  }]);
  return Parser2;
}();
var EraParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(EraParser2, _Parser);
  var _super = _createSuper$2(EraParser2);
  function EraParser2() {
    var _this;
    _classCallCheck$3(this, EraParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 140);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["R", "u", "t", "T"]);
    return _this;
  }
  _createClass$3(EraParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "G":
        case "GG":
        case "GGG":
          return match2.era(dateString, {
            width: "abbreviated"
          }) || match2.era(dateString, {
            width: "narrow"
          });
        case "GGGGG":
          return match2.era(dateString, {
            width: "narrow"
          });
        case "GGGG":
        default:
          return match2.era(dateString, {
            width: "wide"
          }) || match2.era(dateString, {
            width: "abbreviated"
          }) || match2.era(dateString, {
            width: "narrow"
          });
      }
    }
  }, {
    key: "set",
    value: function set2(date, flags2, value) {
      flags2.era = value;
      date.setUTCFullYear(value, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return EraParser2;
}(Parser);
var numericPatterns$1 = {
  month: /^(1[0-2]|0?\d)/,
  date: /^(3[0-1]|[0-2]?\d)/,
  dayOfYear: /^(36[0-6]|3[0-5]\d|[0-2]?\d?\d)/,
  week: /^(5[0-3]|[0-4]?\d)/,
  hour23h: /^(2[0-3]|[0-1]?\d)/,
  hour24h: /^(2[0-4]|[0-1]?\d)/,
  hour11h: /^(1[0-1]|0?\d)/,
  hour12h: /^(1[0-2]|0?\d)/,
  minute: /^[0-5]?\d/,
  second: /^[0-5]?\d/,
  singleDigit: /^\d/,
  twoDigits: /^\d{1,2}/,
  threeDigits: /^\d{1,3}/,
  fourDigits: /^\d{1,4}/,
  anyDigitsSigned: /^-?\d+/,
  singleDigitSigned: /^-?\d/,
  twoDigitsSigned: /^-?\d{1,2}/,
  threeDigitsSigned: /^-?\d{1,3}/,
  fourDigitsSigned: /^-?\d{1,4}/
};
var timezonePatterns$1 = {
  basicOptionalMinutes: /^([+-])(\d{2})(\d{2})?|Z/,
  basic: /^([+-])(\d{2})(\d{2})|Z/,
  basicOptionalSeconds: /^([+-])(\d{2})(\d{2})((\d{2}))?|Z/,
  extended: /^([+-])(\d{2}):(\d{2})|Z/,
  extendedOptionalSeconds: /^([+-])(\d{2}):(\d{2})(:(\d{2}))?|Z/
};
function mapValue(parseFnResult, mapFn) {
  if (!parseFnResult) {
    return parseFnResult;
  }
  return {
    value: mapFn(parseFnResult.value),
    rest: parseFnResult.rest
  };
}
function parseNumericPattern$1(pattern, dateString) {
  var matchResult = dateString.match(pattern);
  if (!matchResult) {
    return null;
  }
  return {
    value: parseInt(matchResult[0], 10),
    rest: dateString.slice(matchResult[0].length)
  };
}
function parseTimezonePattern$1(pattern, dateString) {
  var matchResult = dateString.match(pattern);
  if (!matchResult) {
    return null;
  }
  if (matchResult[0] === "Z") {
    return {
      value: 0,
      rest: dateString.slice(1)
    };
  }
  var sign = matchResult[1] === "+" ? 1 : -1;
  var hours = matchResult[2] ? parseInt(matchResult[2], 10) : 0;
  var minutes = matchResult[3] ? parseInt(matchResult[3], 10) : 0;
  var seconds = matchResult[5] ? parseInt(matchResult[5], 10) : 0;
  return {
    value: sign * (hours * millisecondsInHour$1 + minutes * millisecondsInMinute$1 + seconds * millisecondsInSecond),
    rest: dateString.slice(matchResult[0].length)
  };
}
function parseAnyDigitsSigned$1(dateString) {
  return parseNumericPattern$1(numericPatterns$1.anyDigitsSigned, dateString);
}
function parseNDigits$1(n2, dateString) {
  switch (n2) {
    case 1:
      return parseNumericPattern$1(numericPatterns$1.singleDigit, dateString);
    case 2:
      return parseNumericPattern$1(numericPatterns$1.twoDigits, dateString);
    case 3:
      return parseNumericPattern$1(numericPatterns$1.threeDigits, dateString);
    case 4:
      return parseNumericPattern$1(numericPatterns$1.fourDigits, dateString);
    default:
      return parseNumericPattern$1(new RegExp("^\\d{1," + n2 + "}"), dateString);
  }
}
function parseNDigitsSigned$1(n2, dateString) {
  switch (n2) {
    case 1:
      return parseNumericPattern$1(numericPatterns$1.singleDigitSigned, dateString);
    case 2:
      return parseNumericPattern$1(numericPatterns$1.twoDigitsSigned, dateString);
    case 3:
      return parseNumericPattern$1(numericPatterns$1.threeDigitsSigned, dateString);
    case 4:
      return parseNumericPattern$1(numericPatterns$1.fourDigitsSigned, dateString);
    default:
      return parseNumericPattern$1(new RegExp("^-?\\d{1," + n2 + "}"), dateString);
  }
}
function dayPeriodEnumToHours$1(dayPeriod) {
  switch (dayPeriod) {
    case "morning":
      return 4;
    case "evening":
      return 17;
    case "pm":
    case "noon":
    case "afternoon":
      return 12;
    case "am":
    case "midnight":
    case "night":
    default:
      return 0;
  }
}
function normalizeTwoDigitYear$1(twoDigitYear, currentYear) {
  var isCommonEra = currentYear > 0;
  var absCurrentYear = isCommonEra ? currentYear : 1 - currentYear;
  var result;
  if (absCurrentYear <= 50) {
    result = twoDigitYear || 100;
  } else {
    var rangeEnd = absCurrentYear + 50;
    var rangeEndCentury = Math.floor(rangeEnd / 100) * 100;
    var isPreviousCentury = twoDigitYear >= rangeEnd % 100;
    result = twoDigitYear + rangeEndCentury - (isPreviousCentury ? 100 : 0);
  }
  return isCommonEra ? result : 1 - result;
}
function isLeapYearIndex$3(year) {
  return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
}
var YearParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(YearParser2, _Parser);
  var _super = _createSuper$2(YearParser2);
  function YearParser2() {
    var _this;
    _classCallCheck$3(this, YearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 130);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["Y", "R", "u", "w", "I", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass$3(YearParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      var valueCallback164 = function valueCallback165(year) {
        return {
          year,
          isTwoDigitYear: token === "yy"
        };
      };
      switch (token) {
        case "y":
          return mapValue(parseNDigits$1(4, dateString), valueCallback164);
        case "yo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "year"
          }), valueCallback164);
        default:
          return mapValue(parseNDigits$1(token.length, dateString), valueCallback164);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value.isTwoDigitYear || value.year > 0;
    }
  }, {
    key: "set",
    value: function set2(date, flags2, value) {
      var currentYear = date.getUTCFullYear();
      if (value.isTwoDigitYear) {
        var normalizedTwoDigitYear = normalizeTwoDigitYear$1(value.year, currentYear);
        date.setUTCFullYear(normalizedTwoDigitYear, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      }
      var year = !("era" in flags2) || flags2.era === 1 ? value.year : 1 - value.year;
      date.setUTCFullYear(year, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return YearParser2;
}(Parser);
var LocalWeekYearParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(LocalWeekYearParser2, _Parser);
  var _super = _createSuper$2(LocalWeekYearParser2);
  function LocalWeekYearParser2() {
    var _this;
    _classCallCheck$3(this, LocalWeekYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 130);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["y", "R", "u", "Q", "q", "M", "L", "I", "d", "D", "i", "t", "T"]);
    return _this;
  }
  _createClass$3(LocalWeekYearParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      var valueCallback164 = function valueCallback165(year) {
        return {
          year,
          isTwoDigitYear: token === "YY"
        };
      };
      switch (token) {
        case "Y":
          return mapValue(parseNDigits$1(4, dateString), valueCallback164);
        case "Yo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "year"
          }), valueCallback164);
        default:
          return mapValue(parseNDigits$1(token.length, dateString), valueCallback164);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value.isTwoDigitYear || value.year > 0;
    }
  }, {
    key: "set",
    value: function set2(date, flags2, value, options) {
      var currentYear = getUTCWeekYear$1(date, options);
      if (value.isTwoDigitYear) {
        var normalizedTwoDigitYear = normalizeTwoDigitYear$1(value.year, currentYear);
        date.setUTCFullYear(normalizedTwoDigitYear, 0, options.firstWeekContainsDate);
        date.setUTCHours(0, 0, 0, 0);
        return startOfUTCWeek$1(date, options);
      }
      var year = !("era" in flags2) || flags2.era === 1 ? value.year : 1 - value.year;
      date.setUTCFullYear(year, 0, options.firstWeekContainsDate);
      date.setUTCHours(0, 0, 0, 0);
      return startOfUTCWeek$1(date, options);
    }
  }]);
  return LocalWeekYearParser2;
}(Parser);
var ISOWeekYearParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(ISOWeekYearParser2, _Parser);
  var _super = _createSuper$2(ISOWeekYearParser2);
  function ISOWeekYearParser2() {
    var _this;
    _classCallCheck$3(this, ISOWeekYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 130);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["G", "y", "Y", "u", "Q", "q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass$3(ISOWeekYearParser2, [{
    key: "parse",
    value: function parse4(dateString, token) {
      if (token === "R") {
        return parseNDigitsSigned$1(4, dateString);
      }
      return parseNDigitsSigned$1(token.length, dateString);
    }
  }, {
    key: "set",
    value: function set2(_date, _flags, value) {
      var firstWeekOfYear = new Date(0);
      firstWeekOfYear.setUTCFullYear(value, 0, 4);
      firstWeekOfYear.setUTCHours(0, 0, 0, 0);
      return startOfUTCISOWeek$1(firstWeekOfYear);
    }
  }]);
  return ISOWeekYearParser2;
}(Parser);
var ExtendedYearParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(ExtendedYearParser2, _Parser);
  var _super = _createSuper$2(ExtendedYearParser2);
  function ExtendedYearParser2() {
    var _this;
    _classCallCheck$3(this, ExtendedYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 130);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["G", "y", "Y", "R", "w", "I", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass$3(ExtendedYearParser2, [{
    key: "parse",
    value: function parse4(dateString, token) {
      if (token === "u") {
        return parseNDigitsSigned$1(4, dateString);
      }
      return parseNDigitsSigned$1(token.length, dateString);
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCFullYear(value, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return ExtendedYearParser2;
}(Parser);
var QuarterParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(QuarterParser2, _Parser);
  var _super = _createSuper$2(QuarterParser2);
  function QuarterParser2() {
    var _this;
    _classCallCheck$3(this, QuarterParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 120);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["Y", "R", "q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass$3(QuarterParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "Q":
        case "QQ":
          return parseNDigits$1(token.length, dateString);
        case "Qo":
          return match2.ordinalNumber(dateString, {
            unit: "quarter"
          });
        case "QQQ":
          return match2.quarter(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQQ":
          return match2.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQ":
        default:
          return match2.quarter(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.quarter(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 4;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth((value - 1) * 3, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return QuarterParser2;
}(Parser);
var StandAloneQuarterParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(StandAloneQuarterParser2, _Parser);
  var _super = _createSuper$2(StandAloneQuarterParser2);
  function StandAloneQuarterParser2() {
    var _this;
    _classCallCheck$3(this, StandAloneQuarterParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 120);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["Y", "R", "Q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass$3(StandAloneQuarterParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "q":
        case "qq":
          return parseNDigits$1(token.length, dateString);
        case "qo":
          return match2.ordinalNumber(dateString, {
            unit: "quarter"
          });
        case "qqq":
          return match2.quarter(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqqq":
          return match2.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqq":
        default:
          return match2.quarter(dateString, {
            width: "wide",
            context: "standalone"
          }) || match2.quarter(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 4;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth((value - 1) * 3, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneQuarterParser2;
}(Parser);
var MonthParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(MonthParser2, _Parser);
  var _super = _createSuper$2(MonthParser2);
  function MonthParser2() {
    var _this;
    _classCallCheck$3(this, MonthParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "L", "w", "I", "D", "i", "e", "c", "t", "T"]);
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 110);
    return _this;
  }
  _createClass$3(MonthParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      var valueCallback164 = function valueCallback165(value) {
        return value - 1;
      };
      switch (token) {
        case "M":
          return mapValue(parseNumericPattern$1(numericPatterns$1.month, dateString), valueCallback164);
        case "MM":
          return mapValue(parseNDigits$1(2, dateString), valueCallback164);
        case "Mo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "month"
          }), valueCallback164);
        case "MMM":
          return match2.month(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMMM":
          return match2.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMM":
        default:
          return match2.month(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.month(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth(value, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return MonthParser2;
}(Parser);
var StandAloneMonthParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(StandAloneMonthParser2, _Parser);
  var _super = _createSuper$2(StandAloneMonthParser2);
  function StandAloneMonthParser2() {
    var _this;
    _classCallCheck$3(this, StandAloneMonthParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 110);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "M", "w", "I", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass$3(StandAloneMonthParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      var valueCallback164 = function valueCallback165(value) {
        return value - 1;
      };
      switch (token) {
        case "L":
          return mapValue(parseNumericPattern$1(numericPatterns$1.month, dateString), valueCallback164);
        case "LL":
          return mapValue(parseNDigits$1(2, dateString), valueCallback164);
        case "Lo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "month"
          }), valueCallback164);
        case "LLL":
          return match2.month(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLLL":
          return match2.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLL":
        default:
          return match2.month(dateString, {
            width: "wide",
            context: "standalone"
          }) || match2.month(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth(value, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneMonthParser2;
}(Parser);
function setUTCWeek$1(dirtyDate, dirtyWeek, options) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var week2 = toInteger$1(dirtyWeek);
  var diff = getUTCWeek$1(date, options) - week2;
  date.setUTCDate(date.getUTCDate() - diff * 7);
  return date;
}
var LocalWeekParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(LocalWeekParser2, _Parser);
  var _super = _createSuper$2(LocalWeekParser2);
  function LocalWeekParser2() {
    var _this;
    _classCallCheck$3(this, LocalWeekParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 100);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "i", "t", "T"]);
    return _this;
  }
  _createClass$3(LocalWeekParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "w":
          return parseNumericPattern$1(numericPatterns$1.week, dateString);
        case "wo":
          return match2.ordinalNumber(dateString, {
            unit: "week"
          });
        default:
          return parseNDigits$1(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 53;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value, options) {
      return startOfUTCWeek$1(setUTCWeek$1(date, value, options), options);
    }
  }]);
  return LocalWeekParser2;
}(Parser);
function setUTCISOWeek$1(dirtyDate, dirtyISOWeek) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var isoWeek = toInteger$1(dirtyISOWeek);
  var diff = getUTCISOWeek$1(date) - isoWeek;
  date.setUTCDate(date.getUTCDate() - diff * 7);
  return date;
}
var ISOWeekParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(ISOWeekParser2, _Parser);
  var _super = _createSuper$2(ISOWeekParser2);
  function ISOWeekParser2() {
    var _this;
    _classCallCheck$3(this, ISOWeekParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 100);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass$3(ISOWeekParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "I":
          return parseNumericPattern$1(numericPatterns$1.week, dateString);
        case "Io":
          return match2.ordinalNumber(dateString, {
            unit: "week"
          });
        default:
          return parseNDigits$1(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 53;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      return startOfUTCISOWeek$1(setUTCISOWeek$1(date, value));
    }
  }]);
  return ISOWeekParser2;
}(Parser);
var DAYS_IN_MONTH$1 = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
var DAYS_IN_MONTH_LEAP_YEAR$1 = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
var DateParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(DateParser2, _Parser);
  var _super = _createSuper$2(DateParser2);
  function DateParser2() {
    var _this;
    _classCallCheck$3(this, DateParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 90);
    _defineProperty$5(_assertThisInitialized$2(_this), "subPriority", 1);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "w", "I", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass$3(DateParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "d":
          return parseNumericPattern$1(numericPatterns$1.date, dateString);
        case "do":
          return match2.ordinalNumber(dateString, {
            unit: "date"
          });
        default:
          return parseNDigits$1(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(date, value) {
      var year = date.getUTCFullYear();
      var isLeapYear2 = isLeapYearIndex$3(year);
      var month = date.getUTCMonth();
      if (isLeapYear2) {
        return value >= 1 && value <= DAYS_IN_MONTH_LEAP_YEAR$1[month];
      } else {
        return value >= 1 && value <= DAYS_IN_MONTH$1[month];
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCDate(value);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return DateParser2;
}(Parser);
var DayOfYearParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(DayOfYearParser2, _Parser);
  var _super = _createSuper$2(DayOfYearParser2);
  function DayOfYearParser2() {
    var _this;
    _classCallCheck$3(this, DayOfYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 90);
    _defineProperty$5(_assertThisInitialized$2(_this), "subpriority", 1);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "M", "L", "w", "I", "d", "E", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass$3(DayOfYearParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "D":
        case "DD":
          return parseNumericPattern$1(numericPatterns$1.dayOfYear, dateString);
        case "Do":
          return match2.ordinalNumber(dateString, {
            unit: "date"
          });
        default:
          return parseNDigits$1(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(date, value) {
      var year = date.getUTCFullYear();
      var isLeapYear2 = isLeapYearIndex$3(year);
      if (isLeapYear2) {
        return value >= 1 && value <= 366;
      } else {
        return value >= 1 && value <= 365;
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth(0, value);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return DayOfYearParser2;
}(Parser);
function setUTCDay$1(dirtyDate, dirtyDay, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(2, arguments);
  var defaultOptions2 = getDefaultOptions$1();
  var weekStartsOn = toInteger$1((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate$1(dirtyDate);
  var day = toInteger$1(dirtyDay);
  var currentDay = date.getUTCDay();
  var remainder = day % 7;
  var dayIndex = (remainder + 7) % 7;
  var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}
var DayParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(DayParser2, _Parser);
  var _super = _createSuper$2(DayParser2);
  function DayParser2() {
    var _this;
    _classCallCheck$3(this, DayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 90);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass$3(DayParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "E":
        case "EE":
        case "EEE":
          return match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEEE":
          return match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEEEE":
          return match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEE":
        default:
          return match2.day(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 6;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value, options) {
      date = setUTCDay$1(date, value, options);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return DayParser2;
}(Parser);
var LocalDayParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(LocalDayParser2, _Parser);
  var _super = _createSuper$2(LocalDayParser2);
  function LocalDayParser2() {
    var _this;
    _classCallCheck$3(this, LocalDayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 90);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "E", "i", "c", "t", "T"]);
    return _this;
  }
  _createClass$3(LocalDayParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2, options) {
      var valueCallback164 = function valueCallback165(value) {
        var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
        return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
      };
      switch (token) {
        case "e":
        case "ee":
          return mapValue(parseNDigits$1(token.length, dateString), valueCallback164);
        case "eo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "day"
          }), valueCallback164);
        case "eee":
          return match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "eeeee":
          return match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "eeeeee":
          return match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "eeee":
        default:
          return match2.day(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 6;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value, options) {
      date = setUTCDay$1(date, value, options);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return LocalDayParser2;
}(Parser);
var StandAloneLocalDayParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(StandAloneLocalDayParser2, _Parser);
  var _super = _createSuper$2(StandAloneLocalDayParser2);
  function StandAloneLocalDayParser2() {
    var _this;
    _classCallCheck$3(this, StandAloneLocalDayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 90);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "E", "i", "e", "t", "T"]);
    return _this;
  }
  _createClass$3(StandAloneLocalDayParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2, options) {
      var valueCallback164 = function valueCallback165(value) {
        var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
        return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
      };
      switch (token) {
        case "c":
        case "cc":
          return mapValue(parseNDigits$1(token.length, dateString), valueCallback164);
        case "co":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "day"
          }), valueCallback164);
        case "ccc":
          return match2.day(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "short",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "ccccc":
          return match2.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "cccccc":
          return match2.day(dateString, {
            width: "short",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "cccc":
        default:
          return match2.day(dateString, {
            width: "wide",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "short",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 6;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value, options) {
      date = setUTCDay$1(date, value, options);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneLocalDayParser2;
}(Parser);
function setUTCISODay$1(dirtyDate, dirtyDay) {
  requiredArgs$1(2, arguments);
  var day = toInteger$1(dirtyDay);
  if (day % 7 === 0) {
    day = day - 7;
  }
  var weekStartsOn = 1;
  var date = toDate$1(dirtyDate);
  var currentDay = date.getUTCDay();
  var remainder = day % 7;
  var dayIndex = (remainder + 7) % 7;
  var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}
var ISODayParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(ISODayParser2, _Parser);
  var _super = _createSuper$2(ISODayParser2);
  function ISODayParser2() {
    var _this;
    _classCallCheck$3(this, ISODayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 90);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "E", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass$3(ISODayParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      var valueCallback164 = function valueCallback165(value) {
        if (value === 0) {
          return 7;
        }
        return value;
      };
      switch (token) {
        case "i":
        case "ii":
          return parseNDigits$1(token.length, dateString);
        case "io":
          return match2.ordinalNumber(dateString, {
            unit: "day"
          });
        case "iii":
          return mapValue(match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback164);
        case "iiiii":
          return mapValue(match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback164);
        case "iiiiii":
          return mapValue(match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback164);
        case "iiii":
        default:
          return mapValue(match2.day(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback164);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 7;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date = setUTCISODay$1(date, value);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return ISODayParser2;
}(Parser);
var AMPMParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(AMPMParser2, _Parser);
  var _super = _createSuper$2(AMPMParser2);
  function AMPMParser2() {
    var _this;
    _classCallCheck$3(this, AMPMParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 80);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["b", "B", "H", "k", "t", "T"]);
    return _this;
  }
  _createClass$3(AMPMParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "a":
        case "aa":
        case "aaa":
          return match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "aaaaa":
          return match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "aaaa":
        default:
          return match2.dayPeriod(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCHours(dayPeriodEnumToHours$1(value), 0, 0, 0);
      return date;
    }
  }]);
  return AMPMParser2;
}(Parser);
var AMPMMidnightParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(AMPMMidnightParser2, _Parser);
  var _super = _createSuper$2(AMPMMidnightParser2);
  function AMPMMidnightParser2() {
    var _this;
    _classCallCheck$3(this, AMPMMidnightParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 80);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["a", "B", "H", "k", "t", "T"]);
    return _this;
  }
  _createClass$3(AMPMMidnightParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "b":
        case "bb":
        case "bbb":
          return match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "bbbbb":
          return match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "bbbb":
        default:
          return match2.dayPeriod(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCHours(dayPeriodEnumToHours$1(value), 0, 0, 0);
      return date;
    }
  }]);
  return AMPMMidnightParser2;
}(Parser);
var DayPeriodParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(DayPeriodParser2, _Parser);
  var _super = _createSuper$2(DayPeriodParser2);
  function DayPeriodParser2() {
    var _this;
    _classCallCheck$3(this, DayPeriodParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 80);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["a", "b", "t", "T"]);
    return _this;
  }
  _createClass$3(DayPeriodParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "B":
        case "BB":
        case "BBB":
          return match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "BBBBB":
          return match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "BBBB":
        default:
          return match2.dayPeriod(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCHours(dayPeriodEnumToHours$1(value), 0, 0, 0);
      return date;
    }
  }]);
  return DayPeriodParser2;
}(Parser);
var Hour1to12Parser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(Hour1to12Parser2, _Parser);
  var _super = _createSuper$2(Hour1to12Parser2);
  function Hour1to12Parser2() {
    var _this;
    _classCallCheck$3(this, Hour1to12Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 70);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["H", "K", "k", "t", "T"]);
    return _this;
  }
  _createClass$3(Hour1to12Parser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "h":
          return parseNumericPattern$1(numericPatterns$1.hour12h, dateString);
        case "ho":
          return match2.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits$1(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 12;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      var isPM = date.getUTCHours() >= 12;
      if (isPM && value < 12) {
        date.setUTCHours(value + 12, 0, 0, 0);
      } else if (!isPM && value === 12) {
        date.setUTCHours(0, 0, 0, 0);
      } else {
        date.setUTCHours(value, 0, 0, 0);
      }
      return date;
    }
  }]);
  return Hour1to12Parser2;
}(Parser);
var Hour0to23Parser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(Hour0to23Parser2, _Parser);
  var _super = _createSuper$2(Hour0to23Parser2);
  function Hour0to23Parser2() {
    var _this;
    _classCallCheck$3(this, Hour0to23Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 70);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["a", "b", "h", "K", "k", "t", "T"]);
    return _this;
  }
  _createClass$3(Hour0to23Parser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "H":
          return parseNumericPattern$1(numericPatterns$1.hour23h, dateString);
        case "Ho":
          return match2.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits$1(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 23;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCHours(value, 0, 0, 0);
      return date;
    }
  }]);
  return Hour0to23Parser2;
}(Parser);
var Hour0To11Parser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(Hour0To11Parser2, _Parser);
  var _super = _createSuper$2(Hour0To11Parser2);
  function Hour0To11Parser2() {
    var _this;
    _classCallCheck$3(this, Hour0To11Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 70);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["h", "H", "k", "t", "T"]);
    return _this;
  }
  _createClass$3(Hour0To11Parser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "K":
          return parseNumericPattern$1(numericPatterns$1.hour11h, dateString);
        case "Ko":
          return match2.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits$1(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      var isPM = date.getUTCHours() >= 12;
      if (isPM && value < 12) {
        date.setUTCHours(value + 12, 0, 0, 0);
      } else {
        date.setUTCHours(value, 0, 0, 0);
      }
      return date;
    }
  }]);
  return Hour0To11Parser2;
}(Parser);
var Hour1To24Parser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(Hour1To24Parser2, _Parser);
  var _super = _createSuper$2(Hour1To24Parser2);
  function Hour1To24Parser2() {
    var _this;
    _classCallCheck$3(this, Hour1To24Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 70);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["a", "b", "h", "H", "K", "t", "T"]);
    return _this;
  }
  _createClass$3(Hour1To24Parser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "k":
          return parseNumericPattern$1(numericPatterns$1.hour24h, dateString);
        case "ko":
          return match2.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits$1(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 24;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      var hours = value <= 24 ? value % 24 : value;
      date.setUTCHours(hours, 0, 0, 0);
      return date;
    }
  }]);
  return Hour1To24Parser2;
}(Parser);
var MinuteParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(MinuteParser2, _Parser);
  var _super = _createSuper$2(MinuteParser2);
  function MinuteParser2() {
    var _this;
    _classCallCheck$3(this, MinuteParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 60);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["t", "T"]);
    return _this;
  }
  _createClass$3(MinuteParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "m":
          return parseNumericPattern$1(numericPatterns$1.minute, dateString);
        case "mo":
          return match2.ordinalNumber(dateString, {
            unit: "minute"
          });
        default:
          return parseNDigits$1(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 59;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMinutes(value, 0, 0);
      return date;
    }
  }]);
  return MinuteParser2;
}(Parser);
var SecondParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(SecondParser2, _Parser);
  var _super = _createSuper$2(SecondParser2);
  function SecondParser2() {
    var _this;
    _classCallCheck$3(this, SecondParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 50);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["t", "T"]);
    return _this;
  }
  _createClass$3(SecondParser2, [{
    key: "parse",
    value: function parse4(dateString, token, match2) {
      switch (token) {
        case "s":
          return parseNumericPattern$1(numericPatterns$1.second, dateString);
        case "so":
          return match2.ordinalNumber(dateString, {
            unit: "second"
          });
        default:
          return parseNDigits$1(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 59;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCSeconds(value, 0);
      return date;
    }
  }]);
  return SecondParser2;
}(Parser);
var FractionOfSecondParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(FractionOfSecondParser2, _Parser);
  var _super = _createSuper$2(FractionOfSecondParser2);
  function FractionOfSecondParser2() {
    var _this;
    _classCallCheck$3(this, FractionOfSecondParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 30);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["t", "T"]);
    return _this;
  }
  _createClass$3(FractionOfSecondParser2, [{
    key: "parse",
    value: function parse4(dateString, token) {
      var valueCallback164 = function valueCallback165(value) {
        return Math.floor(value * Math.pow(10, -token.length + 3));
      };
      return mapValue(parseNDigits$1(token.length, dateString), valueCallback164);
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMilliseconds(value);
      return date;
    }
  }]);
  return FractionOfSecondParser2;
}(Parser);
var ISOTimezoneWithZParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(ISOTimezoneWithZParser2, _Parser);
  var _super = _createSuper$2(ISOTimezoneWithZParser2);
  function ISOTimezoneWithZParser2() {
    var _this;
    _classCallCheck$3(this, ISOTimezoneWithZParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 10);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["t", "T", "x"]);
    return _this;
  }
  _createClass$3(ISOTimezoneWithZParser2, [{
    key: "parse",
    value: function parse4(dateString, token) {
      switch (token) {
        case "X":
          return parseTimezonePattern$1(timezonePatterns$1.basicOptionalMinutes, dateString);
        case "XX":
          return parseTimezonePattern$1(timezonePatterns$1.basic, dateString);
        case "XXXX":
          return parseTimezonePattern$1(timezonePatterns$1.basicOptionalSeconds, dateString);
        case "XXXXX":
          return parseTimezonePattern$1(timezonePatterns$1.extendedOptionalSeconds, dateString);
        case "XXX":
        default:
          return parseTimezonePattern$1(timezonePatterns$1.extended, dateString);
      }
    }
  }, {
    key: "set",
    value: function set2(date, flags2, value) {
      if (flags2.timestampIsSet) {
        return date;
      }
      return new Date(date.getTime() - value);
    }
  }]);
  return ISOTimezoneWithZParser2;
}(Parser);
var ISOTimezoneParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(ISOTimezoneParser2, _Parser);
  var _super = _createSuper$2(ISOTimezoneParser2);
  function ISOTimezoneParser2() {
    var _this;
    _classCallCheck$3(this, ISOTimezoneParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 10);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", ["t", "T", "X"]);
    return _this;
  }
  _createClass$3(ISOTimezoneParser2, [{
    key: "parse",
    value: function parse4(dateString, token) {
      switch (token) {
        case "x":
          return parseTimezonePattern$1(timezonePatterns$1.basicOptionalMinutes, dateString);
        case "xx":
          return parseTimezonePattern$1(timezonePatterns$1.basic, dateString);
        case "xxxx":
          return parseTimezonePattern$1(timezonePatterns$1.basicOptionalSeconds, dateString);
        case "xxxxx":
          return parseTimezonePattern$1(timezonePatterns$1.extendedOptionalSeconds, dateString);
        case "xxx":
        default:
          return parseTimezonePattern$1(timezonePatterns$1.extended, dateString);
      }
    }
  }, {
    key: "set",
    value: function set2(date, flags2, value) {
      if (flags2.timestampIsSet) {
        return date;
      }
      return new Date(date.getTime() - value);
    }
  }]);
  return ISOTimezoneParser2;
}(Parser);
var TimestampSecondsParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(TimestampSecondsParser2, _Parser);
  var _super = _createSuper$2(TimestampSecondsParser2);
  function TimestampSecondsParser2() {
    var _this;
    _classCallCheck$3(this, TimestampSecondsParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 40);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", "*");
    return _this;
  }
  _createClass$3(TimestampSecondsParser2, [{
    key: "parse",
    value: function parse4(dateString) {
      return parseAnyDigitsSigned$1(dateString);
    }
  }, {
    key: "set",
    value: function set2(_date, _flags, value) {
      return [new Date(value * 1e3), {
        timestampIsSet: true
      }];
    }
  }]);
  return TimestampSecondsParser2;
}(Parser);
var TimestampMillisecondsParser = /* @__PURE__ */ function(_Parser) {
  _inherits$2(TimestampMillisecondsParser2, _Parser);
  var _super = _createSuper$2(TimestampMillisecondsParser2);
  function TimestampMillisecondsParser2() {
    var _this;
    _classCallCheck$3(this, TimestampMillisecondsParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty$5(_assertThisInitialized$2(_this), "priority", 20);
    _defineProperty$5(_assertThisInitialized$2(_this), "incompatibleTokens", "*");
    return _this;
  }
  _createClass$3(TimestampMillisecondsParser2, [{
    key: "parse",
    value: function parse4(dateString) {
      return parseAnyDigitsSigned$1(dateString);
    }
  }, {
    key: "set",
    value: function set2(_date, _flags, value) {
      return [new Date(value), {
        timestampIsSet: true
      }];
    }
  }]);
  return TimestampMillisecondsParser2;
}(Parser);
var parsers$2 = {
  G: new EraParser(),
  y: new YearParser(),
  Y: new LocalWeekYearParser(),
  R: new ISOWeekYearParser(),
  u: new ExtendedYearParser(),
  Q: new QuarterParser(),
  q: new StandAloneQuarterParser(),
  M: new MonthParser(),
  L: new StandAloneMonthParser(),
  w: new LocalWeekParser(),
  I: new ISOWeekParser(),
  d: new DateParser(),
  D: new DayOfYearParser(),
  E: new DayParser(),
  e: new LocalDayParser(),
  c: new StandAloneLocalDayParser(),
  i: new ISODayParser(),
  a: new AMPMParser(),
  b: new AMPMMidnightParser(),
  B: new DayPeriodParser(),
  h: new Hour1to12Parser(),
  H: new Hour0to23Parser(),
  K: new Hour0To11Parser(),
  k: new Hour1To24Parser(),
  m: new MinuteParser(),
  s: new SecondParser(),
  S: new FractionOfSecondParser(),
  X: new ISOTimezoneWithZParser(),
  x: new ISOTimezoneParser(),
  t: new TimestampSecondsParser(),
  T: new TimestampMillisecondsParser()
};
var formattingTokensRegExp$3 = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
var longFormattingTokensRegExp$2 = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
var escapedStringRegExp$3 = /^'([^]*?)'?$/;
var doubleQuoteRegExp$3 = /''/g;
var notWhitespaceRegExp$1 = /\S/;
var unescapedLatinCharacterRegExp$3 = /[a-zA-Z]/;
function parse$2(dirtyDateString, dirtyFormatString, dirtyReferenceDate, options) {
  var _ref, _options$locale, _ref2, _ref3, _ref4, _options$firstWeekCon, _options$locale2, _options$locale2$opti, _defaultOptions$local, _defaultOptions$local2, _ref5, _ref6, _ref7, _options$weekStartsOn, _options$locale3, _options$locale3$opti, _defaultOptions$local3, _defaultOptions$local4;
  requiredArgs$1(3, arguments);
  var dateString = String(dirtyDateString);
  var formatString = String(dirtyFormatString);
  var defaultOptions2 = getDefaultOptions$1();
  var locale2 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale$8;
  if (!locale2.match) {
    throw new RangeError("locale must contain match property");
  }
  var firstWeekContainsDate = toInteger$1((_ref2 = (_ref3 = (_ref4 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale2 = options.locale) === null || _options$locale2 === void 0 ? void 0 : (_options$locale2$opti = _options$locale2.options) === null || _options$locale2$opti === void 0 ? void 0 : _options$locale2$opti.firstWeekContainsDate) !== null && _ref4 !== void 0 ? _ref4 : defaultOptions2.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var weekStartsOn = toInteger$1((_ref5 = (_ref6 = (_ref7 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale3 = options.locale) === null || _options$locale3 === void 0 ? void 0 : (_options$locale3$opti = _options$locale3.options) === null || _options$locale3$opti === void 0 ? void 0 : _options$locale3$opti.weekStartsOn) !== null && _ref7 !== void 0 ? _ref7 : defaultOptions2.weekStartsOn) !== null && _ref6 !== void 0 ? _ref6 : (_defaultOptions$local3 = defaultOptions2.locale) === null || _defaultOptions$local3 === void 0 ? void 0 : (_defaultOptions$local4 = _defaultOptions$local3.options) === null || _defaultOptions$local4 === void 0 ? void 0 : _defaultOptions$local4.weekStartsOn) !== null && _ref5 !== void 0 ? _ref5 : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  if (formatString === "") {
    if (dateString === "") {
      return toDate$1(dirtyReferenceDate);
    } else {
      return new Date(NaN);
    }
  }
  var subFnOptions = {
    firstWeekContainsDate,
    weekStartsOn,
    locale: locale2
  };
  var setters = [new DateToSystemTimezoneSetter()];
  var tokens = formatString.match(longFormattingTokensRegExp$2).map(function(substring) {
    var firstCharacter = substring[0];
    if (firstCharacter in longFormatters$3) {
      var longFormatter = longFormatters$3[firstCharacter];
      return longFormatter(substring, locale2.formatLong);
    }
    return substring;
  }).join("").match(formattingTokensRegExp$3);
  var usedTokens = [];
  var _iterator = _createForOfIteratorHelper(tokens), _step;
  try {
    var _loop = function _loop4() {
      var token = _step.value;
      if (!(options !== null && options !== void 0 && options.useAdditionalWeekYearTokens) && isProtectedWeekYearToken$1(token)) {
        throwProtectedError$1(token, formatString, dirtyDateString);
      }
      if (!(options !== null && options !== void 0 && options.useAdditionalDayOfYearTokens) && isProtectedDayOfYearToken$1(token)) {
        throwProtectedError$1(token, formatString, dirtyDateString);
      }
      var firstCharacter = token[0];
      var parser = parsers$2[firstCharacter];
      if (parser) {
        var incompatibleTokens = parser.incompatibleTokens;
        if (Array.isArray(incompatibleTokens)) {
          var incompatibleToken = usedTokens.find(function(usedToken) {
            return incompatibleTokens.includes(usedToken.token) || usedToken.token === firstCharacter;
          });
          if (incompatibleToken) {
            throw new RangeError("The format string mustn't contain `".concat(incompatibleToken.fullToken, "` and `").concat(token, "` at the same time"));
          }
        } else if (parser.incompatibleTokens === "*" && usedTokens.length > 0) {
          throw new RangeError("The format string mustn't contain `".concat(token, "` and any other token at the same time"));
        }
        usedTokens.push({
          token: firstCharacter,
          fullToken: token
        });
        var parseResult = parser.run(dateString, token, locale2.match, subFnOptions);
        if (!parseResult) {
          return {
            v: new Date(NaN)
          };
        }
        setters.push(parseResult.setter);
        dateString = parseResult.rest;
      } else {
        if (firstCharacter.match(unescapedLatinCharacterRegExp$3)) {
          throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
        }
        if (token === "''") {
          token = "'";
        } else if (firstCharacter === "'") {
          token = cleanEscapedString$3(token);
        }
        if (dateString.indexOf(token) === 0) {
          dateString = dateString.slice(token.length);
        } else {
          return {
            v: new Date(NaN)
          };
        }
      }
    };
    for (_iterator.s(); !(_step = _iterator.n()).done; ) {
      var _ret = _loop();
      if (_typeof$5(_ret) === "object")
        return _ret.v;
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  if (dateString.length > 0 && notWhitespaceRegExp$1.test(dateString)) {
    return new Date(NaN);
  }
  var uniquePrioritySetters = setters.map(function(setter2) {
    return setter2.priority;
  }).sort(function(a3, b3) {
    return b3 - a3;
  }).filter(function(priority2, index2, array) {
    return array.indexOf(priority2) === index2;
  }).map(function(priority2) {
    return setters.filter(function(setter2) {
      return setter2.priority === priority2;
    }).sort(function(a3, b3) {
      return b3.subPriority - a3.subPriority;
    });
  }).map(function(setterArray) {
    return setterArray[0];
  });
  var date = toDate$1(dirtyReferenceDate);
  if (isNaN(date.getTime())) {
    return new Date(NaN);
  }
  var utcDate = subMilliseconds$1(date, getTimezoneOffsetInMilliseconds$1(date));
  var flags2 = {};
  var _iterator2 = _createForOfIteratorHelper(uniquePrioritySetters), _step2;
  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done; ) {
      var setter = _step2.value;
      if (!setter.validate(utcDate, subFnOptions)) {
        return new Date(NaN);
      }
      var result = setter.set(utcDate, flags2, subFnOptions);
      if (Array.isArray(result)) {
        utcDate = result[0];
        assign$1(flags2, result[1]);
      } else {
        utcDate = result;
      }
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
  return utcDate;
}
function cleanEscapedString$3(input2) {
  return input2.match(escapedStringRegExp$3)[1].replace(doubleQuoteRegExp$3, "'");
}
function isMatch(dateString, formatString, options) {
  requiredArgs$1(2, arguments);
  return isValid$1(parse$2(dateString, formatString, new Date(), options));
}
function isMonday(date) {
  requiredArgs$1(1, arguments);
  return toDate$1(date).getDay() === 1;
}
function isPast(dirtyDate) {
  requiredArgs$1(1, arguments);
  return toDate$1(dirtyDate).getTime() < Date.now();
}
function startOfHour(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  date.setMinutes(0, 0, 0);
  return date;
}
function isSameHour(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeftStartOfHour = startOfHour(dirtyDateLeft);
  var dateRightStartOfHour = startOfHour(dirtyDateRight);
  return dateLeftStartOfHour.getTime() === dateRightStartOfHour.getTime();
}
function isSameWeek$1(dirtyDateLeft, dirtyDateRight, options) {
  requiredArgs$1(2, arguments);
  var dateLeftStartOfWeek = startOfWeek(dirtyDateLeft, options);
  var dateRightStartOfWeek = startOfWeek(dirtyDateRight, options);
  return dateLeftStartOfWeek.getTime() === dateRightStartOfWeek.getTime();
}
function isSameISOWeek(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  return isSameWeek$1(dirtyDateLeft, dirtyDateRight, {
    weekStartsOn: 1
  });
}
function isSameISOWeekYear(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeftStartOfYear = startOfISOWeekYear(dirtyDateLeft);
  var dateRightStartOfYear = startOfISOWeekYear(dirtyDateRight);
  return dateLeftStartOfYear.getTime() === dateRightStartOfYear.getTime();
}
function isSameMinute(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeftStartOfMinute = startOfMinute(dirtyDateLeft);
  var dateRightStartOfMinute = startOfMinute(dirtyDateRight);
  return dateLeftStartOfMinute.getTime() === dateRightStartOfMinute.getTime();
}
function isSameMonth$1(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyDateLeft);
  var dateRight = toDate$1(dirtyDateRight);
  return dateLeft.getFullYear() === dateRight.getFullYear() && dateLeft.getMonth() === dateRight.getMonth();
}
function isSameQuarter$1(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeftStartOfQuarter = startOfQuarter(dirtyDateLeft);
  var dateRightStartOfQuarter = startOfQuarter(dirtyDateRight);
  return dateLeftStartOfQuarter.getTime() === dateRightStartOfQuarter.getTime();
}
function startOfSecond(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  date.setMilliseconds(0);
  return date;
}
function isSameSecond(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeftStartOfSecond = startOfSecond(dirtyDateLeft);
  var dateRightStartOfSecond = startOfSecond(dirtyDateRight);
  return dateLeftStartOfSecond.getTime() === dateRightStartOfSecond.getTime();
}
function isSameYear$1(dirtyDateLeft, dirtyDateRight) {
  requiredArgs$1(2, arguments);
  var dateLeft = toDate$1(dirtyDateLeft);
  var dateRight = toDate$1(dirtyDateRight);
  return dateLeft.getFullYear() === dateRight.getFullYear();
}
function isThisHour(dirtyDate) {
  requiredArgs$1(1, arguments);
  return isSameHour(Date.now(), dirtyDate);
}
function isThisISOWeek(dirtyDate) {
  requiredArgs$1(1, arguments);
  return isSameISOWeek(dirtyDate, Date.now());
}
function isThisMinute(dirtyDate) {
  requiredArgs$1(1, arguments);
  return isSameMinute(Date.now(), dirtyDate);
}
function isThisMonth(dirtyDate) {
  requiredArgs$1(1, arguments);
  return isSameMonth$1(Date.now(), dirtyDate);
}
function isThisQuarter(dirtyDate) {
  requiredArgs$1(1, arguments);
  return isSameQuarter$1(Date.now(), dirtyDate);
}
function isThisSecond(dirtyDate) {
  requiredArgs$1(1, arguments);
  return isSameSecond(Date.now(), dirtyDate);
}
function isThisWeek(dirtyDate, options) {
  requiredArgs$1(1, arguments);
  return isSameWeek$1(dirtyDate, Date.now(), options);
}
function isThisYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  return isSameYear$1(dirtyDate, Date.now());
}
function isThursday(dirtyDate) {
  requiredArgs$1(1, arguments);
  return toDate$1(dirtyDate).getDay() === 4;
}
function isToday(dirtyDate) {
  requiredArgs$1(1, arguments);
  return isSameDay(dirtyDate, Date.now());
}
function isTomorrow(dirtyDate) {
  requiredArgs$1(1, arguments);
  return isSameDay(dirtyDate, addDays(Date.now(), 1));
}
function isTuesday(dirtyDate) {
  requiredArgs$1(1, arguments);
  return toDate$1(dirtyDate).getDay() === 2;
}
function isWednesday(dirtyDate) {
  requiredArgs$1(1, arguments);
  return toDate$1(dirtyDate).getDay() === 3;
}
function isWithinInterval(dirtyDate, interval) {
  requiredArgs$1(2, arguments);
  var time = toDate$1(dirtyDate).getTime();
  var startTime = toDate$1(interval.start).getTime();
  var endTime = toDate$1(interval.end).getTime();
  if (!(startTime <= endTime)) {
    throw new RangeError("Invalid interval");
  }
  return time >= startTime && time <= endTime;
}
function subDays(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addDays(dirtyDate, -amount);
}
function isYesterday(dirtyDate) {
  requiredArgs$1(1, arguments);
  return isSameDay(dirtyDate, subDays(Date.now(), 1));
}
function lastDayOfDecade(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var year = date.getFullYear();
  var decade = 9 + Math.floor(year / 10) * 10;
  date.setFullYear(decade + 1, 0, 0);
  date.setHours(0, 0, 0, 0);
  return date;
}
function lastDayOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(1, arguments);
  var defaultOptions2 = getDefaultOptions$1();
  var weekStartsOn = toInteger$1((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6");
  }
  var date = toDate$1(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? -7 : 0) + 6 - (day - weekStartsOn);
  date.setHours(0, 0, 0, 0);
  date.setDate(date.getDate() + diff);
  return date;
}
function lastDayOfISOWeek(dirtyDate) {
  requiredArgs$1(1, arguments);
  return lastDayOfWeek(dirtyDate, {
    weekStartsOn: 1
  });
}
function lastDayOfISOWeekYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  var year = getISOWeekYear(dirtyDate);
  var fourthOfJanuary = new Date(0);
  fourthOfJanuary.setFullYear(year + 1, 0, 4);
  fourthOfJanuary.setHours(0, 0, 0, 0);
  var date = startOfISOWeek(fourthOfJanuary);
  date.setDate(date.getDate() - 1);
  return date;
}
function lastDayOfQuarter(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var currentMonth = date.getMonth();
  var month = currentMonth - currentMonth % 3 + 3;
  date.setMonth(month, 0);
  date.setHours(0, 0, 0, 0);
  return date;
}
function lastDayOfYear(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var year = date.getFullYear();
  date.setFullYear(year + 1, 0, 0);
  date.setHours(0, 0, 0, 0);
  return date;
}
var formattingTokensRegExp$2 = /(\w)\1*|''|'(''|[^'])+('|$)|./g;
var escapedStringRegExp$2 = /^'([^]*?)'?$/;
var doubleQuoteRegExp$2 = /''/g;
var unescapedLatinCharacterRegExp$2 = /[a-zA-Z]/;
function lightFormat(dirtyDate, formatStr) {
  requiredArgs$1(2, arguments);
  var originalDate = toDate$1(dirtyDate);
  if (!isValid$1(originalDate)) {
    throw new RangeError("Invalid time value");
  }
  var timezoneOffset = getTimezoneOffsetInMilliseconds$1(originalDate);
  var utcDate = subMilliseconds$1(originalDate, timezoneOffset);
  var tokens = formatStr.match(formattingTokensRegExp$2);
  if (!tokens)
    return "";
  var result = tokens.map(function(substring) {
    if (substring === "''") {
      return "'";
    }
    var firstCharacter = substring[0];
    if (firstCharacter === "'") {
      return cleanEscapedString$2(substring);
    }
    var formatter = formatters$7[firstCharacter];
    if (formatter) {
      return formatter(utcDate, substring);
    }
    if (firstCharacter.match(unescapedLatinCharacterRegExp$2)) {
      throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
    }
    return substring;
  }).join("");
  return result;
}
function cleanEscapedString$2(input2) {
  var matches = input2.match(escapedStringRegExp$2);
  if (!matches) {
    return input2;
  }
  return matches[1].replace(doubleQuoteRegExp$2, "'");
}
var daysInYear = 365.2425;
function milliseconds(_ref) {
  var years = _ref.years, months2 = _ref.months, weeks = _ref.weeks, days2 = _ref.days, hours = _ref.hours, minutes = _ref.minutes, seconds = _ref.seconds;
  requiredArgs$1(1, arguments);
  var totalDays = 0;
  if (years)
    totalDays += years * daysInYear;
  if (months2)
    totalDays += months2 * (daysInYear / 12);
  if (weeks)
    totalDays += weeks * 7;
  if (days2)
    totalDays += days2;
  var totalSeconds = totalDays * 24 * 60 * 60;
  if (hours)
    totalSeconds += hours * 60 * 60;
  if (minutes)
    totalSeconds += minutes * 60;
  if (seconds)
    totalSeconds += seconds;
  return Math.round(totalSeconds * 1e3);
}
function millisecondsToHours(milliseconds2) {
  requiredArgs$1(1, arguments);
  var hours = milliseconds2 / millisecondsInHour$1;
  return Math.floor(hours);
}
function millisecondsToMinutes(milliseconds2) {
  requiredArgs$1(1, arguments);
  var minutes = milliseconds2 / millisecondsInMinute$1;
  return Math.floor(minutes);
}
function millisecondsToSeconds(milliseconds2) {
  requiredArgs$1(1, arguments);
  var seconds = milliseconds2 / millisecondsInSecond;
  return Math.floor(seconds);
}
function minutesToHours(minutes) {
  requiredArgs$1(1, arguments);
  var hours = minutes / minutesInHour;
  return Math.floor(hours);
}
function minutesToMilliseconds(minutes) {
  requiredArgs$1(1, arguments);
  return Math.floor(minutes * millisecondsInMinute$1);
}
function minutesToSeconds(minutes) {
  requiredArgs$1(1, arguments);
  return Math.floor(minutes * secondsInMinute);
}
function monthsToQuarters(months2) {
  requiredArgs$1(1, arguments);
  var quarters = months2 / monthsInQuarter;
  return Math.floor(quarters);
}
function monthsToYears(months2) {
  requiredArgs$1(1, arguments);
  var years = months2 / monthsInYear;
  return Math.floor(years);
}
function nextDay(date, day) {
  requiredArgs$1(2, arguments);
  var delta = day - getDay(date);
  if (delta <= 0)
    delta += 7;
  return addDays(date, delta);
}
function nextFriday(date) {
  requiredArgs$1(1, arguments);
  return nextDay(date, 5);
}
function nextMonday(date) {
  requiredArgs$1(1, arguments);
  return nextDay(date, 1);
}
function nextSaturday(date) {
  requiredArgs$1(1, arguments);
  return nextDay(date, 6);
}
function nextSunday(date) {
  requiredArgs$1(1, arguments);
  return nextDay(date, 0);
}
function nextThursday(date) {
  requiredArgs$1(1, arguments);
  return nextDay(date, 4);
}
function nextTuesday(date) {
  requiredArgs$1(1, arguments);
  return nextDay(date, 2);
}
function nextWednesday(date) {
  requiredArgs$1(1, arguments);
  return nextDay(date, 3);
}
function parseISO$1(argument, options) {
  var _options$additionalDi;
  requiredArgs$1(1, arguments);
  var additionalDigits = toInteger$1((_options$additionalDi = options === null || options === void 0 ? void 0 : options.additionalDigits) !== null && _options$additionalDi !== void 0 ? _options$additionalDi : 2);
  if (additionalDigits !== 2 && additionalDigits !== 1 && additionalDigits !== 0) {
    throw new RangeError("additionalDigits must be 0, 1 or 2");
  }
  if (!(typeof argument === "string" || Object.prototype.toString.call(argument) === "[object String]")) {
    return new Date(NaN);
  }
  var dateStrings = splitDateString$1(argument);
  var date;
  if (dateStrings.date) {
    var parseYearResult = parseYear$1(dateStrings.date, additionalDigits);
    date = parseDate$1(parseYearResult.restDateString, parseYearResult.year);
  }
  if (!date || isNaN(date.getTime())) {
    return new Date(NaN);
  }
  var timestamp = date.getTime();
  var time = 0;
  var offset4;
  if (dateStrings.time) {
    time = parseTime$1(dateStrings.time);
    if (isNaN(time)) {
      return new Date(NaN);
    }
  }
  if (dateStrings.timezone) {
    offset4 = parseTimezone$1(dateStrings.timezone);
    if (isNaN(offset4)) {
      return new Date(NaN);
    }
  } else {
    var dirtyDate = new Date(timestamp + time);
    var result = new Date(0);
    result.setFullYear(dirtyDate.getUTCFullYear(), dirtyDate.getUTCMonth(), dirtyDate.getUTCDate());
    result.setHours(dirtyDate.getUTCHours(), dirtyDate.getUTCMinutes(), dirtyDate.getUTCSeconds(), dirtyDate.getUTCMilliseconds());
    return result;
  }
  return new Date(timestamp + time + offset4);
}
var patterns$1 = {
  dateTimeDelimiter: /[T ]/,
  timeZoneDelimiter: /[Z ]/i,
  timezone: /([Z+-].*)$/
};
var dateRegex$1 = /^-?(?:(\d{3})|(\d{2})(?:-?(\d{2}))?|W(\d{2})(?:-?(\d{1}))?|)$/;
var timeRegex$1 = /^(\d{2}(?:[.,]\d*)?)(?::?(\d{2}(?:[.,]\d*)?))?(?::?(\d{2}(?:[.,]\d*)?))?$/;
var timezoneRegex$1 = /^([+-])(\d{2})(?::?(\d{2}))?$/;
function splitDateString$1(dateString) {
  var dateStrings = {};
  var array = dateString.split(patterns$1.dateTimeDelimiter);
  var timeString;
  if (array.length > 2) {
    return dateStrings;
  }
  if (/:/.test(array[0])) {
    timeString = array[0];
  } else {
    dateStrings.date = array[0];
    timeString = array[1];
    if (patterns$1.timeZoneDelimiter.test(dateStrings.date)) {
      dateStrings.date = dateString.split(patterns$1.timeZoneDelimiter)[0];
      timeString = dateString.substr(dateStrings.date.length, dateString.length);
    }
  }
  if (timeString) {
    var token = patterns$1.timezone.exec(timeString);
    if (token) {
      dateStrings.time = timeString.replace(token[1], "");
      dateStrings.timezone = token[1];
    } else {
      dateStrings.time = timeString;
    }
  }
  return dateStrings;
}
function parseYear$1(dateString, additionalDigits) {
  var regex = new RegExp("^(?:(\\d{4}|[+-]\\d{" + (4 + additionalDigits) + "})|(\\d{2}|[+-]\\d{" + (2 + additionalDigits) + "})$)");
  var captures = dateString.match(regex);
  if (!captures)
    return {
      year: NaN,
      restDateString: ""
    };
  var year = captures[1] ? parseInt(captures[1]) : null;
  var century = captures[2] ? parseInt(captures[2]) : null;
  return {
    year: century === null ? year : century * 100,
    restDateString: dateString.slice((captures[1] || captures[2]).length)
  };
}
function parseDate$1(dateString, year) {
  if (year === null)
    return new Date(NaN);
  var captures = dateString.match(dateRegex$1);
  if (!captures)
    return new Date(NaN);
  var isWeekDate = !!captures[4];
  var dayOfYear = parseDateUnit$1(captures[1]);
  var month = parseDateUnit$1(captures[2]) - 1;
  var day = parseDateUnit$1(captures[3]);
  var week2 = parseDateUnit$1(captures[4]);
  var dayOfWeek = parseDateUnit$1(captures[5]) - 1;
  if (isWeekDate) {
    if (!validateWeekDate$1(year, week2, dayOfWeek)) {
      return new Date(NaN);
    }
    return dayOfISOWeekYear$1(year, week2, dayOfWeek);
  } else {
    var date = new Date(0);
    if (!validateDate$1(year, month, day) || !validateDayOfYearDate$1(year, dayOfYear)) {
      return new Date(NaN);
    }
    date.setUTCFullYear(year, month, Math.max(dayOfYear, day));
    return date;
  }
}
function parseDateUnit$1(value) {
  return value ? parseInt(value) : 1;
}
function parseTime$1(timeString) {
  var captures = timeString.match(timeRegex$1);
  if (!captures)
    return NaN;
  var hours = parseTimeUnit$1(captures[1]);
  var minutes = parseTimeUnit$1(captures[2]);
  var seconds = parseTimeUnit$1(captures[3]);
  if (!validateTime$1(hours, minutes, seconds)) {
    return NaN;
  }
  return hours * millisecondsInHour$1 + minutes * millisecondsInMinute$1 + seconds * 1e3;
}
function parseTimeUnit$1(value) {
  return value && parseFloat(value.replace(",", ".")) || 0;
}
function parseTimezone$1(timezoneString) {
  if (timezoneString === "Z")
    return 0;
  var captures = timezoneString.match(timezoneRegex$1);
  if (!captures)
    return 0;
  var sign = captures[1] === "+" ? -1 : 1;
  var hours = parseInt(captures[2]);
  var minutes = captures[3] && parseInt(captures[3]) || 0;
  if (!validateTimezone$1(hours, minutes)) {
    return NaN;
  }
  return sign * (hours * millisecondsInHour$1 + minutes * millisecondsInMinute$1);
}
function dayOfISOWeekYear$1(isoWeekYear, week2, day) {
  var date = new Date(0);
  date.setUTCFullYear(isoWeekYear, 0, 4);
  var fourthOfJanuaryDay = date.getUTCDay() || 7;
  var diff = (week2 - 1) * 7 + day + 1 - fourthOfJanuaryDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}
var daysInMonths$1 = [31, null, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
function isLeapYearIndex$2(year) {
  return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
}
function validateDate$1(year, month, date) {
  return month >= 0 && month <= 11 && date >= 1 && date <= (daysInMonths$1[month] || (isLeapYearIndex$2(year) ? 29 : 28));
}
function validateDayOfYearDate$1(year, dayOfYear) {
  return dayOfYear >= 1 && dayOfYear <= (isLeapYearIndex$2(year) ? 366 : 365);
}
function validateWeekDate$1(_year, week2, day) {
  return week2 >= 1 && week2 <= 53 && day >= 0 && day <= 6;
}
function validateTime$1(hours, minutes, seconds) {
  if (hours === 24) {
    return minutes === 0 && seconds === 0;
  }
  return seconds >= 0 && seconds < 60 && minutes >= 0 && minutes < 60 && hours >= 0 && hours < 25;
}
function validateTimezone$1(_hours, minutes) {
  return minutes >= 0 && minutes <= 59;
}
function parseJSON(argument) {
  requiredArgs$1(1, arguments);
  if (typeof argument === "string") {
    var parts = argument.match(/(\d{4})-(\d{2})-(\d{2})[T ](\d{2}):(\d{2}):(\d{2})(?:\.(\d{0,7}))?(?:Z|(.)(\d{2}):?(\d{2})?)?/);
    if (parts) {
      return new Date(Date.UTC(+parts[1], +parts[2] - 1, +parts[3], +parts[4] - (+parts[9] || 0) * (parts[8] == "-" ? -1 : 1), +parts[5] - (+parts[10] || 0) * (parts[8] == "-" ? -1 : 1), +parts[6], +((parts[7] || "0") + "00").substring(0, 3)));
    }
    return new Date(NaN);
  }
  return toDate$1(argument);
}
function previousDay(date, day) {
  requiredArgs$1(2, arguments);
  var delta = getDay(date) - day;
  if (delta <= 0)
    delta += 7;
  return subDays(date, delta);
}
function previousFriday(date) {
  requiredArgs$1(1, arguments);
  return previousDay(date, 5);
}
function previousMonday(date) {
  requiredArgs$1(1, arguments);
  return previousDay(date, 1);
}
function previousSaturday(date) {
  requiredArgs$1(1, arguments);
  return previousDay(date, 6);
}
function previousSunday(date) {
  requiredArgs$1(1, arguments);
  return previousDay(date, 0);
}
function previousThursday(date) {
  requiredArgs$1(1, arguments);
  return previousDay(date, 4);
}
function previousTuesday(date) {
  requiredArgs$1(1, arguments);
  return previousDay(date, 2);
}
function previousWednesday(date) {
  requiredArgs$1(1, arguments);
  return previousDay(date, 3);
}
function quartersToMonths(quarters) {
  requiredArgs$1(1, arguments);
  return Math.floor(quarters * monthsInQuarter);
}
function quartersToYears(quarters) {
  requiredArgs$1(1, arguments);
  var years = quarters / quartersInYear;
  return Math.floor(years);
}
function roundToNearestMinutes(dirtyDate, options) {
  var _options$nearestTo;
  if (arguments.length < 1) {
    throw new TypeError("1 argument required, but only none provided present");
  }
  var nearestTo = toInteger$1((_options$nearestTo = options === null || options === void 0 ? void 0 : options.nearestTo) !== null && _options$nearestTo !== void 0 ? _options$nearestTo : 1);
  if (nearestTo < 1 || nearestTo > 30) {
    throw new RangeError("`options.nearestTo` must be between 1 and 30");
  }
  var date = toDate$1(dirtyDate);
  var seconds = date.getSeconds();
  var minutes = date.getMinutes() + seconds / 60;
  var roundingMethod = getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod);
  var roundedMinutes = roundingMethod(minutes / nearestTo) * nearestTo;
  var remainderMinutes = minutes % nearestTo;
  var addedMinutes = Math.round(remainderMinutes / nearestTo) * nearestTo;
  return new Date(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), roundedMinutes + addedMinutes);
}
function secondsToHours(seconds) {
  requiredArgs$1(1, arguments);
  var hours = seconds / secondsInHour;
  return Math.floor(hours);
}
function secondsToMilliseconds(seconds) {
  requiredArgs$1(1, arguments);
  return seconds * millisecondsInSecond;
}
function secondsToMinutes(seconds) {
  requiredArgs$1(1, arguments);
  var minutes = seconds / secondsInMinute;
  return Math.floor(minutes);
}
function setMonth(dirtyDate, dirtyMonth) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var month = toInteger$1(dirtyMonth);
  var year = date.getFullYear();
  var day = date.getDate();
  var dateWithDesiredMonth = new Date(0);
  dateWithDesiredMonth.setFullYear(year, month, 15);
  dateWithDesiredMonth.setHours(0, 0, 0, 0);
  var daysInMonth = getDaysInMonth(dateWithDesiredMonth);
  date.setMonth(month, Math.min(day, daysInMonth));
  return date;
}
function set(dirtyDate, values2) {
  requiredArgs$1(2, arguments);
  if (_typeof$5(values2) !== "object" || values2 === null) {
    throw new RangeError("values parameter must be an object");
  }
  var date = toDate$1(dirtyDate);
  if (isNaN(date.getTime())) {
    return new Date(NaN);
  }
  if (values2.year != null) {
    date.setFullYear(values2.year);
  }
  if (values2.month != null) {
    date = setMonth(date, values2.month);
  }
  if (values2.date != null) {
    date.setDate(toInteger$1(values2.date));
  }
  if (values2.hours != null) {
    date.setHours(toInteger$1(values2.hours));
  }
  if (values2.minutes != null) {
    date.setMinutes(toInteger$1(values2.minutes));
  }
  if (values2.seconds != null) {
    date.setSeconds(toInteger$1(values2.seconds));
  }
  if (values2.milliseconds != null) {
    date.setMilliseconds(toInteger$1(values2.milliseconds));
  }
  return date;
}
function setDate(dirtyDate, dirtyDayOfMonth) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var dayOfMonth = toInteger$1(dirtyDayOfMonth);
  date.setDate(dayOfMonth);
  return date;
}
function setDay(dirtyDate, dirtyDay, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(2, arguments);
  var defaultOptions2 = getDefaultOptions$1();
  var weekStartsOn = toInteger$1((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate$1(dirtyDate);
  var day = toInteger$1(dirtyDay);
  var currentDay = date.getDay();
  var remainder = day % 7;
  var dayIndex = (remainder + 7) % 7;
  var delta = 7 - weekStartsOn;
  var diff = day < 0 || day > 6 ? day - (currentDay + delta) % 7 : (dayIndex + delta) % 7 - (currentDay + delta) % 7;
  return addDays(date, diff);
}
function setDayOfYear(dirtyDate, dirtyDayOfYear) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var dayOfYear = toInteger$1(dirtyDayOfYear);
  date.setMonth(0);
  date.setDate(dayOfYear);
  return date;
}
function setDefaultOptions(newOptions) {
  requiredArgs$1(1, arguments);
  var result = {};
  var defaultOptions2 = getDefaultOptions$1();
  for (var property2 in defaultOptions2) {
    if (Object.prototype.hasOwnProperty.call(defaultOptions2, property2)) {
      result[property2] = defaultOptions2[property2];
    }
  }
  for (var _property in newOptions) {
    if (Object.prototype.hasOwnProperty.call(newOptions, _property)) {
      if (newOptions[_property] === void 0) {
        delete result[_property];
      } else {
        result[_property] = newOptions[_property];
      }
    }
  }
  setDefaultOptions$1(result);
}
function setHours(dirtyDate, dirtyHours) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var hours = toInteger$1(dirtyHours);
  date.setHours(hours);
  return date;
}
function setISODay(dirtyDate, dirtyDay) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var day = toInteger$1(dirtyDay);
  var currentDay = getISODay(date);
  var diff = day - currentDay;
  return addDays(date, diff);
}
function setISOWeek(dirtyDate, dirtyISOWeek) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var isoWeek = toInteger$1(dirtyISOWeek);
  var diff = getISOWeek(date) - isoWeek;
  date.setDate(date.getDate() - diff * 7);
  return date;
}
function setMilliseconds(dirtyDate, dirtyMilliseconds) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var milliseconds2 = toInteger$1(dirtyMilliseconds);
  date.setMilliseconds(milliseconds2);
  return date;
}
function setMinutes(dirtyDate, dirtyMinutes) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var minutes = toInteger$1(dirtyMinutes);
  date.setMinutes(minutes);
  return date;
}
function setQuarter(dirtyDate, dirtyQuarter) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var quarter = toInteger$1(dirtyQuarter);
  var oldQuarter = Math.floor(date.getMonth() / 3) + 1;
  var diff = quarter - oldQuarter;
  return setMonth(date, date.getMonth() + diff * 3);
}
function setSeconds(dirtyDate, dirtySeconds) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var seconds = toInteger$1(dirtySeconds);
  date.setSeconds(seconds);
  return date;
}
function setWeek(dirtyDate, dirtyWeek, options) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var week2 = toInteger$1(dirtyWeek);
  var diff = getWeek(date, options) - week2;
  date.setDate(date.getDate() - diff * 7);
  return date;
}
function setWeekYear(dirtyDate, dirtyWeekYear, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs$1(2, arguments);
  var defaultOptions2 = getDefaultOptions$1();
  var firstWeekContainsDate = toInteger$1((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  var date = toDate$1(dirtyDate);
  var weekYear = toInteger$1(dirtyWeekYear);
  var diff = differenceInCalendarDays(date, startOfWeekYear(date, options));
  var firstWeek = new Date(0);
  firstWeek.setFullYear(weekYear, 0, firstWeekContainsDate);
  firstWeek.setHours(0, 0, 0, 0);
  date = startOfWeekYear(firstWeek, options);
  date.setDate(date.getDate() + diff);
  return date;
}
function setYear(dirtyDate, dirtyYear) {
  requiredArgs$1(2, arguments);
  var date = toDate$1(dirtyDate);
  var year = toInteger$1(dirtyYear);
  if (isNaN(date.getTime())) {
    return new Date(NaN);
  }
  date.setFullYear(year);
  return date;
}
function startOfDecade(dirtyDate) {
  requiredArgs$1(1, arguments);
  var date = toDate$1(dirtyDate);
  var year = date.getFullYear();
  var decade = Math.floor(year / 10) * 10;
  date.setFullYear(decade, 0, 1);
  date.setHours(0, 0, 0, 0);
  return date;
}
function startOfToday() {
  return startOfDay(Date.now());
}
function startOfTomorrow() {
  var now2 = new Date();
  var year = now2.getFullYear();
  var month = now2.getMonth();
  var day = now2.getDate();
  var date = new Date(0);
  date.setFullYear(year, month, day + 1);
  date.setHours(0, 0, 0, 0);
  return date;
}
function startOfYesterday() {
  var now2 = new Date();
  var year = now2.getFullYear();
  var month = now2.getMonth();
  var day = now2.getDate();
  var date = new Date(0);
  date.setFullYear(year, month, day - 1);
  date.setHours(0, 0, 0, 0);
  return date;
}
function subMonths(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addMonths(dirtyDate, -amount);
}
function sub(date, duration2) {
  requiredArgs$1(2, arguments);
  if (!duration2 || _typeof$5(duration2) !== "object")
    return new Date(NaN);
  var years = duration2.years ? toInteger$1(duration2.years) : 0;
  var months2 = duration2.months ? toInteger$1(duration2.months) : 0;
  var weeks = duration2.weeks ? toInteger$1(duration2.weeks) : 0;
  var days2 = duration2.days ? toInteger$1(duration2.days) : 0;
  var hours = duration2.hours ? toInteger$1(duration2.hours) : 0;
  var minutes = duration2.minutes ? toInteger$1(duration2.minutes) : 0;
  var seconds = duration2.seconds ? toInteger$1(duration2.seconds) : 0;
  var dateWithoutMonths = subMonths(date, months2 + years * 12);
  var dateWithoutDays = subDays(dateWithoutMonths, days2 + weeks * 7);
  var minutestoSub = minutes + hours * 60;
  var secondstoSub = seconds + minutestoSub * 60;
  var mstoSub = secondstoSub * 1e3;
  var finalDate = new Date(dateWithoutDays.getTime() - mstoSub);
  return finalDate;
}
function subBusinessDays(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addBusinessDays(dirtyDate, -amount);
}
function subHours(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addHours(dirtyDate, -amount);
}
function subMinutes(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addMinutes(dirtyDate, -amount);
}
function subQuarters(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addQuarters(dirtyDate, -amount);
}
function subSeconds(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addSeconds(dirtyDate, -amount);
}
function subWeeks(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addWeeks(dirtyDate, -amount);
}
function subYears(dirtyDate, dirtyAmount) {
  requiredArgs$1(2, arguments);
  var amount = toInteger$1(dirtyAmount);
  return addYears(dirtyDate, -amount);
}
function weeksToDays(weeks) {
  requiredArgs$1(1, arguments);
  return Math.floor(weeks * daysInWeek);
}
function yearsToMonths(years) {
  requiredArgs$1(1, arguments);
  return Math.floor(years * monthsInYear);
}
function yearsToQuarters(years) {
  requiredArgs$1(1, arguments);
  return Math.floor(years * quartersInYear);
}
var esm = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  add: add$2,
  addBusinessDays,
  addDays,
  addHours,
  addISOWeekYears,
  addMilliseconds: addMilliseconds$1,
  addMinutes,
  addMonths,
  addQuarters,
  addSeconds,
  addWeeks,
  addYears,
  areIntervalsOverlapping,
  clamp,
  closestIndexTo,
  closestTo,
  compareAsc,
  compareDesc,
  daysToWeeks,
  differenceInBusinessDays,
  differenceInCalendarDays,
  differenceInCalendarISOWeekYears,
  differenceInCalendarISOWeeks,
  differenceInCalendarMonths,
  differenceInCalendarQuarters,
  differenceInCalendarWeeks,
  differenceInCalendarYears,
  differenceInDays,
  differenceInHours,
  differenceInISOWeekYears,
  differenceInMilliseconds,
  differenceInMinutes,
  differenceInMonths,
  differenceInQuarters,
  differenceInSeconds,
  differenceInWeeks,
  differenceInYears,
  eachDayOfInterval,
  eachHourOfInterval,
  eachMinuteOfInterval,
  eachMonthOfInterval,
  eachQuarterOfInterval,
  eachWeekOfInterval,
  eachWeekendOfInterval,
  eachWeekendOfMonth,
  eachWeekendOfYear,
  eachYearOfInterval,
  endOfDay,
  endOfDecade,
  endOfHour,
  endOfISOWeek,
  endOfISOWeekYear,
  endOfMinute,
  endOfMonth,
  endOfQuarter,
  endOfSecond,
  endOfToday,
  endOfTomorrow,
  endOfWeek,
  endOfYear,
  endOfYesterday,
  format: format$1,
  formatDistance: formatDistance$2C,
  formatDistanceStrict,
  formatDistanceToNow,
  formatDistanceToNowStrict,
  formatDuration,
  formatISO,
  formatISO9075,
  formatISODuration,
  formatRFC3339,
  formatRFC7231,
  formatRelative: formatRelative$2C,
  fromUnixTime,
  getDate,
  getDay,
  getDayOfYear,
  getDaysInMonth,
  getDaysInYear,
  getDecade,
  getDefaultOptions,
  getHours,
  getISODay,
  getISOWeek,
  getISOWeekYear,
  getISOWeeksInYear,
  getMilliseconds,
  getMinutes,
  getMonth,
  getOverlappingDaysInIntervals,
  getQuarter: getQuarter$1,
  getSeconds,
  getTime,
  getUnixTime,
  getWeek,
  getWeekOfMonth,
  getWeekYear,
  getWeeksInMonth,
  getYear,
  hoursToMilliseconds,
  hoursToMinutes,
  hoursToSeconds,
  intervalToDuration,
  intlFormat,
  intlFormatDistance,
  isAfter,
  isBefore,
  isDate: isDate$2,
  isEqual: isEqual$5,
  isExists,
  isFirstDayOfMonth,
  isFriday,
  isFuture,
  isLastDayOfMonth,
  isLeapYear,
  isMatch,
  isMonday,
  isPast,
  isSameDay,
  isSameHour,
  isSameISOWeek,
  isSameISOWeekYear,
  isSameMinute,
  isSameMonth: isSameMonth$1,
  isSameQuarter: isSameQuarter$1,
  isSameSecond,
  isSameWeek: isSameWeek$1,
  isSameYear: isSameYear$1,
  isSaturday,
  isSunday,
  isThisHour,
  isThisISOWeek,
  isThisMinute,
  isThisMonth,
  isThisQuarter,
  isThisSecond,
  isThisWeek,
  isThisYear,
  isThursday,
  isToday,
  isTomorrow,
  isTuesday,
  isValid: isValid$1,
  isWednesday,
  isWeekend,
  isWithinInterval,
  isYesterday,
  lastDayOfDecade,
  lastDayOfISOWeek,
  lastDayOfISOWeekYear,
  lastDayOfMonth,
  lastDayOfQuarter,
  lastDayOfWeek,
  lastDayOfYear,
  lightFormat,
  max,
  milliseconds,
  millisecondsToHours,
  millisecondsToMinutes,
  millisecondsToSeconds,
  min,
  minutesToHours,
  minutesToMilliseconds,
  minutesToSeconds,
  monthsToQuarters,
  monthsToYears,
  nextDay,
  nextFriday,
  nextMonday,
  nextSaturday,
  nextSunday,
  nextThursday,
  nextTuesday,
  nextWednesday,
  parse: parse$2,
  parseISO: parseISO$1,
  parseJSON,
  previousDay,
  previousFriday,
  previousMonday,
  previousSaturday,
  previousSunday,
  previousThursday,
  previousTuesday,
  previousWednesday,
  quartersToMonths,
  quartersToYears,
  roundToNearestMinutes,
  secondsToHours,
  secondsToMilliseconds,
  secondsToMinutes,
  set,
  setDate,
  setDay,
  setDayOfYear,
  setDefaultOptions,
  setHours,
  setISODay,
  setISOWeek,
  setISOWeekYear,
  setMilliseconds,
  setMinutes,
  setMonth,
  setQuarter,
  setSeconds,
  setWeek,
  setWeekYear,
  setYear,
  startOfDay,
  startOfDecade,
  startOfHour,
  startOfISOWeek,
  startOfISOWeekYear,
  startOfMinute,
  startOfMonth,
  startOfQuarter,
  startOfSecond,
  startOfToday,
  startOfTomorrow,
  startOfWeek,
  startOfWeekYear,
  startOfYear,
  startOfYesterday,
  sub,
  subBusinessDays,
  subDays,
  subHours,
  subISOWeekYears,
  subMilliseconds: subMilliseconds$1,
  subMinutes,
  subMonths,
  subQuarters,
  subSeconds,
  subWeeks,
  subYears,
  toDate: toDate$1,
  weeksToDays,
  yearsToMonths,
  yearsToQuarters,
  daysInWeek,
  daysInYear: daysInYear$1,
  maxTime,
  millisecondsInMinute: millisecondsInMinute$1,
  millisecondsInHour: millisecondsInHour$1,
  millisecondsInSecond,
  minTime,
  minutesInHour,
  monthsInQuarter,
  monthsInYear,
  quartersInYear,
  secondsInHour,
  secondsInMinute,
  secondsInDay,
  secondsInWeek,
  secondsInYear,
  secondsInMonth,
  secondsInQuarter
}, Symbol.toStringTag, { value: "Module" }));
var require$$1 = /* @__PURE__ */ getAugmentedNamespace(esm);
var formatDistanceLocale$1h = {
  lessThanXSeconds: {
    one: "minder as 'n sekonde",
    other: "minder as {{count}} sekondes"
  },
  xSeconds: {
    one: "1 sekonde",
    other: "{{count}} sekondes"
  },
  halfAMinute: "'n halwe minuut",
  lessThanXMinutes: {
    one: "minder as 'n minuut",
    other: "minder as {{count}} minute"
  },
  xMinutes: {
    one: "'n minuut",
    other: "{{count}} minute"
  },
  aboutXHours: {
    one: "ongeveer 1 uur",
    other: "ongeveer {{count}} ure"
  },
  xHours: {
    one: "1 uur",
    other: "{{count}} ure"
  },
  xDays: {
    one: "1 dag",
    other: "{{count}} dae"
  },
  aboutXWeeks: {
    one: "ongeveer 1 week",
    other: "ongeveer {{count}} weke"
  },
  xWeeks: {
    one: "1 week",
    other: "{{count}} weke"
  },
  aboutXMonths: {
    one: "ongeveer 1 maand",
    other: "ongeveer {{count}} maande"
  },
  xMonths: {
    one: "1 maand",
    other: "{{count}} maande"
  },
  aboutXYears: {
    one: "ongeveer 1 jaar",
    other: "ongeveer {{count}} jaar"
  },
  xYears: {
    one: "1 jaar",
    other: "{{count}} jaar"
  },
  overXYears: {
    one: "meer as 1 jaar",
    other: "meer as {{count}} jaar"
  },
  almostXYears: {
    one: "byna 1 jaar",
    other: "byna {{count}} jaar"
  }
};
var formatDistance$2A = function formatDistance2(token, count2, options) {
  var result;
  var tokenValue = formatDistanceLocale$1h[token];
  if (typeof tokenValue === "string") {
    result = tokenValue;
  } else if (count2 === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace("{{count}}", String(count2));
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "oor " + result;
    } else {
      return result + " gelede";
    }
  }
  return result;
};
var formatDistance$2B = formatDistance$2A;
var dateFormats$1q = {
  full: "EEEE, d MMMM yyyy",
  long: "d MMMM yyyy",
  medium: "d MMM yyyy",
  short: "yyyy/MM/dd"
};
var timeFormats$1q = {
  full: "HH:mm:ss zzzz",
  long: "HH:mm:ss z",
  medium: "HH:mm:ss",
  short: "HH:mm"
};
var dateTimeFormats$1q = {
  full: "{{date}} 'om' {{time}}",
  long: "{{date}} 'om' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong$2Q = {
  date: buildFormatLongFn$1({
    formats: dateFormats$1q,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn$1({
    formats: timeFormats$1q,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn$1({
    formats: dateTimeFormats$1q,
    defaultWidth: "full"
  })
};
var formatLong$2R = formatLong$2Q;
var formatRelativeLocale$1i = {
  lastWeek: "'verlede' eeee 'om' p",
  yesterday: "'gister om' p",
  today: "'vandag om' p",
  tomorrow: "'m\xF4re om' p",
  nextWeek: "eeee 'om' p",
  other: "P"
};
var formatRelative$2A = function formatRelative2(token, _date, _baseDate, _options) {
  return formatRelativeLocale$1i[token];
};
var formatRelative$2B = formatRelative$2A;
var eraValues$1i = {
  narrow: ["vC", "nC"],
  abbreviated: ["vC", "nC"],
  wide: ["voor Christus", "na Christus"]
};
var quarterValues$1i = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["K1", "K2", "K3", "K4"],
  wide: ["1ste kwartaal", "2de kwartaal", "3de kwartaal", "4de kwartaal"]
};
var monthValues$1i = {
  narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
  abbreviated: ["Jan", "Feb", "Mrt", "Apr", "Mei", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Des"],
  wide: ["Januarie", "Februarie", "Maart", "April", "Mei", "Junie", "Julie", "Augustus", "September", "Oktober", "November", "Desember"]
};
var dayValues$1i = {
  narrow: ["S", "M", "D", "W", "D", "V", "S"],
  short: ["So", "Ma", "Di", "Wo", "Do", "Vr", "Sa"],
  abbreviated: ["Son", "Maa", "Din", "Woe", "Don", "Vry", "Sat"],
  wide: ["Sondag", "Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrydag", "Saterdag"]
};
var dayPeriodValues$1i = {
  narrow: {
    am: "vm",
    pm: "nm",
    midnight: "middernag",
    noon: "middaguur",
    morning: "oggend",
    afternoon: "middag",
    evening: "laat middag",
    night: "aand"
  },
  abbreviated: {
    am: "vm",
    pm: "nm",
    midnight: "middernag",
    noon: "middaguur",
    morning: "oggend",
    afternoon: "middag",
    evening: "laat middag",
    night: "aand"
  },
  wide: {
    am: "vm",
    pm: "nm",
    midnight: "middernag",
    noon: "middaguur",
    morning: "oggend",
    afternoon: "middag",
    evening: "laat middag",
    night: "aand"
  }
};
var formattingDayPeriodValues$13 = {
  narrow: {
    am: "vm",
    pm: "nm",
    midnight: "middernag",
    noon: "uur die middag",
    morning: "uur die oggend",
    afternoon: "uur die middag",
    evening: "uur die aand",
    night: "uur die aand"
  },
  abbreviated: {
    am: "vm",
    pm: "nm",
    midnight: "middernag",
    noon: "uur die middag",
    morning: "uur die oggend",
    afternoon: "uur die middag",
    evening: "uur die aand",
    night: "uur die aand"
  },
  wide: {
    am: "vm",
    pm: "nm",
    midnight: "middernag",
    noon: "uur die middag",
    morning: "uur die oggend",
    afternoon: "uur die middag",
    evening: "uur die aand",
    night: "uur die aand"
  }
};
var ordinalNumber$1i = function ordinalNumber2(dirtyNumber) {
  var number = Number(dirtyNumber);
  var rem100 = number % 100;
  if (rem100 < 20) {
    switch (rem100) {
      case 1:
      case 8:
        return number + "ste";
      default:
        return number + "de";
    }
  }
  return number + "ste";
};
var localize$2A = {
  ordinalNumber: ordinalNumber$1i,
  era: buildLocalizeFn$1({
    values: eraValues$1i,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn$1({
    values: quarterValues$1i,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback2(quarter) {
      return quarter - 1;
    }
  }),
  month: buildLocalizeFn$1({
    values: monthValues$1i,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn$1({
    values: dayValues$1i,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn$1({
    values: dayPeriodValues$1i,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues$13,
    defaultFormattingWidth: "wide"
  })
};
var localize$2B = localize$2A;
var matchOrdinalNumberPattern$1h = /^(\d+)(ste|de)?/i;
var parseOrdinalNumberPattern$1h = /\d+/i;
var matchEraPatterns$1h = {
  narrow: /^([vn]\.? ?C\.?)/,
  abbreviated: /^([vn]\. ?C\.?)/,
  wide: /^((voor|na) Christus)/
};
var parseEraPatterns$1h = {
  any: [/^v/, /^n/]
};
var matchQuarterPatterns$1h = {
  narrow: /^[1234]/i,
  abbreviated: /^K[1234]/i,
  wide: /^[1234](st|d)e kwartaal/i
};
var parseQuarterPatterns$1h = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns$1h = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(Jan|Feb|Mrt|Apr|Mei|Jun|Jul|Aug|Sep|Okt|Nov|Dec)\.?/i,
  wide: /^(Januarie|Februarie|Maart|April|Mei|Junie|Julie|Augustus|September|Oktober|November|Desember)/i
};
var parseMonthPatterns$1h = {
  narrow: [/^J/i, /^F/i, /^M/i, /^A/i, /^M/i, /^J/i, /^J/i, /^A/i, /^S/i, /^O/i, /^N/i, /^D/i],
  any: [/^Jan/i, /^Feb/i, /^Mrt/i, /^Apr/i, /^Mei/i, /^Jun/i, /^Jul/i, /^Aug/i, /^Sep/i, /^Okt/i, /^Nov/i, /^Dec/i]
};
var matchDayPatterns$1h = {
  narrow: /^[smdwv]/i,
  short: /^(So|Ma|Di|Wo|Do|Vr|Sa)/i,
  abbreviated: /^(Son|Maa|Din|Woe|Don|Vry|Sat)/i,
  wide: /^(Sondag|Maandag|Dinsdag|Woensdag|Donderdag|Vrydag|Saterdag)/i
};
var parseDayPatterns$1h = {
  narrow: [/^S/i, /^M/i, /^D/i, /^W/i, /^D/i, /^V/i, /^S/i],
  any: [/^So/i, /^Ma/i, /^Di/i, /^Wo/i, /^Do/i, /^Vr/i, /^Sa/i]
};
var matchDayPeriodPatterns$1h = {
  any: /^(vm|nm|middernag|(?:uur )?die (oggend|middag|aand))/i
};
var parseDayPeriodPatterns$1h = {
  any: {
    am: /^vm/i,
    pm: /^nm/i,
    midnight: /^middernag/i,
    noon: /^middaguur/i,
    morning: /oggend/i,
    afternoon: /middag/i,
    evening: /laat middag/i,
    night: /aand/i
  }
};
var match$2A = {
  ordinalNumber: buildMatchPatternFn$1({
    matchPattern: matchOrdinalNumberPattern$1h,
    parsePattern: parseOrdinalNumberPattern$1h,
    valueCallback: function valueCallback3(value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn$1({
    matchPatterns: matchEraPatterns$1h,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns$1h,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn$1({
    matchPatterns: matchQuarterPatterns$1h,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns$1h,
    defaultParseWidth: "any",
    valueCallback: function valueCallback4(index2) {
      return index2 + 1;
    }
  }),
  month: buildMatchFn$1({
    matchPatterns: matchMonthPatterns$1h,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns$1h,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn$1({
    matchPatterns: matchDayPatterns$1h,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns$1h,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn$1({
    matchPatterns: matchDayPeriodPatterns$1h,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns$1h,
    defaultParseWidth: "any"
  })
};
var match$2B = match$2A;
var locale$2W = {
  code: "af",
  formatDistance: formatDistance$2B,
  formatLong: formatLong$2R,
  formatRelative: formatRelative$2B,
  localize: localize$2B,
  match: match$2B,
  options: {
    weekStartsOn: 0,
    firstWeekContainsDate: 1
  }
};
var locale$2X = locale$2W;
var formatDistanceLocale$1g = {
  lessThanXSeconds: {
    one: "\u0623\u0642\u0644 \u0645\u0646 \u062B\u0627\u0646\u064A\u0629",
    two: "\u0623\u0642\u0644 \u0645\u0646 \u062B\u0627\u0646\u064A\u062A\u064A\u0646",
    threeToTen: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062B\u0648\u0627\u0646\u064A",
    other: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062B\u0627\u0646\u064A\u0629"
  },
  xSeconds: {
    one: "\u062B\u0627\u0646\u064A\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u062B\u0627\u0646\u064A\u062A\u0627\u0646",
    threeToTen: "{{count}} \u062B\u0648\u0627\u0646\u064A",
    other: "{{count}} \u062B\u0627\u0646\u064A\u0629"
  },
  halfAMinute: "\u0646\u0635\u0641 \u062F\u0642\u064A\u0642\u0629",
  lessThanXMinutes: {
    one: "\u0623\u0642\u0644 \u0645\u0646 \u062F\u0642\u064A\u0642\u0629",
    two: "\u0623\u0642\u0644 \u0645\u0646 \u062F\u0642\u064A\u0642\u062A\u064A\u0646",
    threeToTen: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062F\u0642\u0627\u0626\u0642",
    other: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062F\u0642\u064A\u0642\u0629"
  },
  xMinutes: {
    one: "\u062F\u0642\u064A\u0642\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u062F\u0642\u064A\u0642\u062A\u0627\u0646",
    threeToTen: "{{count}} \u062F\u0642\u0627\u0626\u0642",
    other: "{{count}} \u062F\u0642\u064A\u0642\u0629"
  },
  aboutXHours: {
    one: "\u0633\u0627\u0639\u0629 \u0648\u0627\u062D\u062F\u0629 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0633\u0627\u0639\u062A\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627",
    threeToTen: "{{count}} \u0633\u0627\u0639\u0627\u062A \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0633\u0627\u0639\u0629 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xHours: {
    one: "\u0633\u0627\u0639\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u0633\u0627\u0639\u062A\u0627\u0646",
    threeToTen: "{{count}} \u0633\u0627\u0639\u0627\u062A",
    other: "{{count}} \u0633\u0627\u0639\u0629"
  },
  xDays: {
    one: "\u064A\u0648\u0645 \u0648\u0627\u062D\u062F",
    two: "\u064A\u0648\u0645\u0627\u0646",
    threeToTen: "{{count}} \u0623\u064A\u0627\u0645",
    other: "{{count}} \u064A\u0648\u0645"
  },
  aboutXWeeks: {
    one: "\u0623\u0633\u0628\u0648\u0639 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627",
    two: "\u0623\u0633\u0628\u0648\u0639\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627",
    threeToTen: "{{count}} \u0623\u0633\u0627\u0628\u064A\u0639 \u062A\u0642\u0631\u064A\u0628\u0627",
    other: "{{count}} \u0623\u0633\u0628\u0648\u0639\u0627 \u062A\u0642\u0631\u064A\u0628\u0627"
  },
  xWeeks: {
    one: "\u0623\u0633\u0628\u0648\u0639 \u0648\u0627\u062D\u062F",
    two: "\u0623\u0633\u0628\u0648\u0639\u0627\u0646",
    threeToTen: "{{count}} \u0623\u0633\u0627\u0628\u064A\u0639",
    other: "{{count}} \u0623\u0633\u0628\u0648\u0639\u0627"
  },
  aboutXMonths: {
    one: "\u0634\u0647\u0631 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0634\u0647\u0631\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627",
    threeToTen: "{{count}} \u0623\u0634\u0647\u0631 \u062A\u0642\u0631\u064A\u0628\u0627",
    other: "{{count}} \u0634\u0647\u0631\u0627 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xMonths: {
    one: "\u0634\u0647\u0631 \u0648\u0627\u062D\u062F",
    two: "\u0634\u0647\u0631\u0627\u0646",
    threeToTen: "{{count}} \u0623\u0634\u0647\u0631",
    other: "{{count}} \u0634\u0647\u0631\u0627"
  },
  aboutXYears: {
    one: "\u0633\u0646\u0629 \u0648\u0627\u062D\u062F\u0629 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0633\u0646\u062A\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627",
    threeToTen: "{{count}} \u0633\u0646\u0648\u0627\u062A \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0633\u0646\u0629 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xYears: {
    one: "\u0633\u0646\u0629 \u0648\u0627\u062D\u062F",
    two: "\u0633\u0646\u062A\u0627\u0646",
    threeToTen: "{{count}} \u0633\u0646\u0648\u0627\u062A",
    other: "{{count}} \u0633\u0646\u0629"
  },
  overXYears: {
    one: "\u0623\u0643\u062B\u0631 \u0645\u0646 \u0633\u0646\u0629",
    two: "\u0623\u0643\u062B\u0631 \u0645\u0646 \u0633\u0646\u062A\u064A\u0646",
    threeToTen: "\u0623\u0643\u062B\u0631 \u0645\u0646 {{count}} \u0633\u0646\u0648\u0627\u062A",
    other: "\u0623\u0643\u062B\u0631 \u0645\u0646 {{count}} \u0633\u0646\u0629"
  },
  almostXYears: {
    one: "\u0645\u0627 \u064A\u0642\u0627\u0631\u0628 \u0633\u0646\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u0645\u0627 \u064A\u0642\u0627\u0631\u0628 \u0633\u0646\u062A\u064A\u0646",
    threeToTen: "\u0645\u0627 \u064A\u0642\u0627\u0631\u0628 {{count}} \u0633\u0646\u0648\u0627\u062A",
    other: "\u0645\u0627 \u064A\u0642\u0627\u0631\u0628 {{count}} \u0633\u0646\u0629"
  }
};
var formatDistance$2y = function formatDistance3(token, count2, options) {
  var usageGroup = formatDistanceLocale$1g[token];
  var result;
  if (typeof usageGroup === "string") {
    result = usageGroup;
  } else if (count2 === 1) {
    result = usageGroup.one;
  } else if (count2 === 2) {
    result = usageGroup.two;
  } else if (count2 <= 10) {
    result = usageGroup.threeToTen.replace("{{count}}", String(count2));
  } else {
    result = usageGroup.other.replace("{{count}}", String(count2));
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "\u062E\u0644\u0627\u0644 " + result;
    } else {
      return "\u0645\u0646\u0630 " + result;
    }
  }
  return result;
};
var formatDistance$2z = formatDistance$2y;
var dateFormats$1p = {
  full: "EEEE\u060C do MMMM y",
  long: "do MMMM y",
  medium: "d MMM y",
  short: "dd/MM/yyyy"
};
var timeFormats$1p = {
  full: "HH:mm:ss",
  long: "HH:mm:ss",
  medium: "HH:mm:ss",
  short: "HH:mm"
};
var dateTimeFormats$1p = {
  full: "{{date}} '\u0639\u0646\u062F \u0627\u0644\u0633\u0627\u0639\u0629' {{time}}",
  long: "{{date}} '\u0639\u0646\u062F \u0627\u0644\u0633\u0627\u0639\u0629' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong$2O = {
  date: buildFormatLongFn$1({
    formats: dateFormats$1p,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn$1({
    formats: timeFormats$1p,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn$1({
    formats: dateTimeFormats$1p,
    defaultWidth: "full"
  })
};
var formatLong$2P = formatLong$2O;
var formatRelativeLocale$1h = {
  lastWeek: "eeee '\u0627\u0644\u0645\u0627\u0636\u064A \u0639\u0646\u062F \u0627\u0644\u0633\u0627\u0639\u0629' p",
  yesterday: "'\u0627\u0644\u0623\u0645\u0633 \u0639\u0646\u062F \u0627\u0644\u0633\u0627\u0639\u0629' p",
  today: "'\u0627\u0644\u064A\u0648\u0645 \u0639\u0646\u062F \u0627\u0644\u0633\u0627\u0639\u0629' p",
  tomorrow: "'\u063A\u062F\u0627 \u0639\u0646\u062F \u0627\u0644\u0633\u0627\u0639\u0629' p",
  nextWeek: "eeee '\u0627\u0644\u0642\u0627\u062F\u0645 \u0639\u0646\u062F \u0627\u0644\u0633\u0627\u0639\u0629' p",
  other: "P"
};
var formatRelative$2y = function formatRelative3(token) {
  return formatRelativeLocale$1h[token];
};
var formatRelative$2z = formatRelative$2y;
var eraValues$1h = {
  narrow: ["\u0642", "\u0628"],
  abbreviated: ["\u0642.\u0645.", "\u0628.\u0645."],
  wide: ["\u0642\u0628\u0644 \u0627\u0644\u0645\u064A\u0644\u0627\u062F", "\u0628\u0639\u062F \u0627\u0644\u0645\u064A\u0644\u0627\u062F"]
};
var quarterValues$1h = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["\u06311", "\u06312", "\u06313", "\u06314"],
  wide: ["\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u0623\u0648\u0644", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u062B\u0627\u0646\u064A", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u062B\u0627\u0644\u062B", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u0631\u0627\u0628\u0639"]
};
var monthValues$1h = {
  narrow: ["\u064A", "\u0641", "\u0645", "\u0623", "\u0645", "\u064A", "\u064A", "\u0623", "\u0633", "\u0623", "\u0646", "\u062F"],
  abbreviated: ["\u064A\u0646\u0627\u064A\u0631", "\u0641\u0628\u0631\u0627\u064A\u0631", "\u0645\u0627\u0631\u0633", "\u0623\u0628\u0631\u064A\u0644", "\u0645\u0627\u064A\u0648", "\u064A\u0648\u0646\u064A\u0648", "\u064A\u0648\u0644\u064A\u0648", "\u0623\u063A\u0633\u0637\u0633", "\u0633\u0628\u062A\u0645\u0628\u0631", "\u0623\u0643\u062A\u0648\u0628\u0631", "\u0646\u0648\u0641\u0645\u0628\u0631", "\u062F\u064A\u0633\u0645\u0628\u0631"],
  wide: ["\u064A\u0646\u0627\u064A\u0631", "\u0641\u0628\u0631\u0627\u064A\u0631", "\u0645\u0627\u0631\u0633", "\u0623\u0628\u0631\u064A\u0644", "\u0645\u0627\u064A\u0648", "\u064A\u0648\u0646\u064A\u0648", "\u064A\u0648\u0644\u064A\u0648", "\u0623\u063A\u0633\u0637\u0633", "\u0633\u0628\u062A\u0645\u0628\u0631", "\u0623\u0643\u062A\u0648\u0628\u0631", "\u0646\u0648\u0641\u0645\u0628\u0631", "\u062F\u064A\u0633\u0645\u0628\u0631"]
};
var dayValues$1h = {
  narrow: ["\u062D", "\u0646", "\u062B", "\u0631", "\u062E", "\u062C", "\u0633"],
  short: ["\u0623\u062D\u062F", "\u0627\u062B\u0646\u064A\u0646", "\u062B\u0644\u0627\u062B\u0627\u0621", "\u0623\u0631\u0628\u0639\u0627\u0621", "\u062E\u0645\u064A\u0633", "\u062C\u0645\u0639\u0629", "\u0633\u0628\u062A"],
  abbreviated: ["\u0623\u062D\u062F", "\u0627\u062B\u0646\u064A\u0646", "\u062B\u0644\u0627\u062B\u0627\u0621", "\u0623\u0631\u0628\u0639\u0627\u0621", "\u062E\u0645\u064A\u0633", "\u062C\u0645\u0639\u0629", "\u0633\u0628\u062A"],
  wide: ["\u0627\u0644\u0623\u062D\u062F", "\u0627\u0644\u0627\u062B\u0646\u064A\u0646", "\u0627\u0644\u062B\u0644\u0627\u062B\u0627\u0621", "\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621", "\u0627\u0644\u062E\u0645\u064A\u0633", "\u0627\u0644\u062C\u0645\u0639\u0629", "\u0627\u0644\u0633\u0628\u062A"]
};
var dayPeriodValues$1h = {
  narrow: {
    am: "\u0635",
    pm: "\u0645",
    morning: "\u0627\u0644\u0635\u0628\u0627\u062D",
    noon: "\u0627\u0644\u0638\u0647\u0631",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0627\u0644\u0644\u064A\u0644",
    midnight: "\u0645\u0646\u062A\u0635\u0641 \u0627\u0644\u0644\u064A\u0644"
  },
  abbreviated: {
    am: "\u0635",
    pm: "\u0645",
    morning: "\u0627\u0644\u0635\u0628\u0627\u062D",
    noon: "\u0627\u0644\u0638\u0647\u0631",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0627\u0644\u0644\u064A\u0644",
    midnight: "\u0645\u0646\u062A\u0635\u0641 \u0627\u0644\u0644\u064A\u0644"
  },
  wide: {
    am: "\u0635",
    pm: "\u0645",
    morning: "\u0627\u0644\u0635\u0628\u0627\u062D",
    noon: "\u0627\u0644\u0638\u0647\u0631",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0627\u0644\u0644\u064A\u0644",
    midnight: "\u0645\u0646\u062A\u0635\u0641 \u0627\u0644\u0644\u064A\u0644"
  }
};
var formattingDayPeriodValues$12 = {
  narrow: {
    am: "\u0635",
    pm: "\u0645",
    morning: "\u0641\u064A \u0627\u0644\u0635\u0628\u0627\u062D",
    noon: "\u0627\u0644\u0638\u0647\u0631",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u0644",
    midnight: "\u0645\u0646\u062A\u0635\u0641 \u0627\u0644\u0644\u064A\u0644"
  },
  abbreviated: {
    am: "\u0635",
    pm: "\u0645",
    morning: "\u0641\u064A \u0627\u0644\u0635\u0628\u0627\u062D",
    noon: "\u0627\u0644\u0638\u0647\u0631",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u0644",
    midnight: "\u0645\u0646\u062A\u0635\u0641 \u0627\u0644\u0644\u064A\u0644"
  },
  wide: {
    am: "\u0635",
    pm: "\u0645",
    morning: "\u0641\u064A \u0627\u0644\u0635\u0628\u0627\u062D",
    noon: "\u0627\u0644\u0638\u0647\u0631",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u0644",
    midnight: "\u0645\u0646\u062A\u0635\u0641 \u0627\u0644\u0644\u064A\u0644"
  }
};
var ordinalNumber$1h = function ordinalNumber3(num) {
  return String(num);
};
var localize$2y = {
  ordinalNumber: ordinalNumber$1h,
  era: buildLocalizeFn$1({
    values: eraValues$1h,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn$1({
    values: quarterValues$1h,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback3(quarter) {
      return quarter - 1;
    }
  }),
  month: buildLocalizeFn$1({
    values: monthValues$1h,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn$1({
    values: dayValues$1h,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn$1({
    values: dayPeriodValues$1h,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues$12,
    defaultFormattingWidth: "wide"
  })
};
var localize$2z = localize$2y;
var matchOrdinalNumberPattern$1g = /^(\d+)(th|st|nd|rd)?/i;
var parseOrdinalNumberPattern$1g = /\d+/i;
var matchEraPatterns$1g = {
  narrow: /[قب]/,
  abbreviated: /[قب]\.م\./,
  wide: /(قبل|بعد) الميلاد/
};
var parseEraPatterns$1g = {
  any: [/قبل/, /بعد/]
};
var matchQuarterPatterns$1g = {
  narrow: /^[1234]/i,
  abbreviated: /ر[1234]/,
  wide: /الربع (الأول|الثاني|الثالث|الرابع)/
};
var parseQuarterPatterns$1g = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns$1g = {
  narrow: /^[أيفمسند]/,
  abbreviated: /^(يناير|فبراير|مارس|أبريل|مايو|يونيو|يوليو|أغسطس|سبتمبر|أكتوبر|نوفمبر|ديسمبر)/,
  wide: /^(يناير|فبراير|مارس|أبريل|مايو|يونيو|يوليو|أغسطس|سبتمبر|أكتوبر|نوفمبر|ديسمبر)/
};
var parseMonthPatterns$1g = {
  narrow: [/^ي/i, /^ف/i, /^م/i, /^أ/i, /^م/i, /^ي/i, /^ي/i, /^أ/i, /^س/i, /^أ/i, /^ن/i, /^د/i],
  any: [/^يناير/i, /^فبراير/i, /^مارس/i, /^أبريل/i, /^مايو/i, /^يونيو/i, /^يوليو/i, /^أغسطس/i, /^سبتمبر/i, /^أكتوبر/i, /^نوفمبر/i, /^ديسمبر/i]
};
var matchDayPatterns$1g = {
  narrow: /^[حنثرخجس]/i,
  short: /^(أحد|اثنين|ثلاثاء|أربعاء|خميس|جمعة|سبت)/i,
  abbreviated: /^(أحد|اثنين|ثلاثاء|أربعاء|خميس|جمعة|سبت)/i,
  wide: /^(الأحد|الاثنين|الثلاثاء|الأربعاء|الخميس|الجمعة|السبت)/i
};
var parseDayPatterns$1g = {
  narrow: [/^ح/i, /^ن/i, /^ث/i, /^ر/i, /^خ/i, /^ج/i, /^س/i],
  wide: [/^الأحد/i, /^الاثنين/i, /^الثلاثاء/i, /^الأربعاء/i, /^الخميس/i, /^الجمعة/i, /^السبت/i],
  any: [/^أح/i, /^اث/i, /^ث/i, /^أر/i, /^خ/i, /^ج/i, /^س/i]
};
var matchDayPeriodPatterns$1g = {
  narrow: /^(ص|م|منتصف الليل|الظهر|بعد الظهر|في الصباح|في المساء|في الليل)/,
  any: /^(ص|م|منتصف الليل|الظهر|بعد الظهر|في الصباح|في المساء|في الليل)/
};
var parseDayPeriodPatterns$1g = {
  any: {
    am: /^ص/,
    pm: /^م/,
    midnight: /منتصف الليل/,
    noon: /الظهر/,
    afternoon: /بعد الظهر/,
    morning: /في الصباح/,
    evening: /في المساء/,
    night: /في الليل/
  }
};
var match$2y = {
  ordinalNumber: buildMatchPatternFn$1({
    matchPattern: matchOrdinalNumberPattern$1g,
    parsePattern: parseOrdinalNumberPattern$1g,
    valueCallback: function valueCallback5(value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn$1({
    matchPatterns: matchEraPatterns$1g,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns$1g,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn$1({
    matchPatterns: matchQuarterPatterns$1g,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns$1g,
    defaultParseWidth: "any",
    valueCallback: function valueCallback6(index2) {
      return index2 + 1;
    }
  }),
  month: buildMatchFn$1({
    matchPatterns: matchMonthPatterns$1g,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns$1g,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn$1({
    matchPatterns: matchDayPatterns$1g,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns$1g,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn$1({
    matchPatterns: matchDayPeriodPatterns$1g,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns$1g,
    defaultParseWidth: "any"
  })
};
var match$2z = match$2y;
var locale$2U = {
  code: "ar",
  formatDistance: formatDistance$2z,
  formatLong: formatLong$2P,
  formatRelative: formatRelative$2z,
  localize: localize$2z,
  match: match$2z,
  options: {
    weekStartsOn: 6,
    firstWeekContainsDate: 1
  }
};
var locale$2V = locale$2U;
var formatDistanceLocale$1f = {
  lessThanXSeconds: {
    one: "\u0623\u0642\u0644 \u0645\u0646 \u062B\u0627\u0646\u064A\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u0623\u0642\u0644 \u0645\u0646 \u062B\u0627\u0646\u062A\u064A\u0646",
    threeToTen: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062B\u0648\u0627\u0646\u064A",
    other: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062B\u0627\u0646\u064A\u0629"
  },
  xSeconds: {
    one: "\u062B\u0627\u0646\u064A\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u062B\u0627\u0646\u062A\u064A\u0646",
    threeToTen: "{{count}} \u062B\u0648\u0627\u0646\u064A",
    other: "{{count}} \u062B\u0627\u0646\u064A\u0629"
  },
  halfAMinute: "\u0646\u0635\u0641 \u062F\u0642\u064A\u0642\u0629",
  lessThanXMinutes: {
    one: "\u0623\u0642\u0644 \u0645\u0646 \u062F\u0642\u064A\u0642\u0629",
    two: "\u0623\u0642\u0644 \u0645\u0646 \u062F\u0642\u064A\u0642\u062A\u064A\u0646",
    threeToTen: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062F\u0642\u0627\u0626\u0642",
    other: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062F\u0642\u064A\u0642\u0629"
  },
  xMinutes: {
    one: "\u062F\u0642\u064A\u0642\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u062F\u0642\u064A\u0642\u062A\u064A\u0646",
    threeToTen: "{{count}} \u062F\u0642\u0627\u0626\u0642",
    other: "{{count}} \u062F\u0642\u064A\u0642\u0629"
  },
  aboutXHours: {
    one: "\u0633\u0627\u0639\u0629 \u0648\u0627\u062D\u062F\u0629 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0633\u0627\u0639\u062A\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0633\u0627\u0639\u0627\u062A \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0633\u0627\u0639\u0629 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xHours: {
    one: "\u0633\u0627\u0639\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u0633\u0627\u0639\u062A\u064A\u0646",
    threeToTen: "{{count}} \u0633\u0627\u0639\u0627\u062A",
    other: "{{count}} \u0633\u0627\u0639\u0629"
  },
  xDays: {
    one: "\u064A\u0648\u0645 \u0648\u0627\u062D\u062F",
    two: "\u064A\u0648\u0645\u064A\u0646",
    threeToTen: "{{count}} \u0623\u064A\u0627\u0645",
    other: "{{count}} \u064A\u0648\u0645"
  },
  aboutXWeeks: {
    one: "\u0623\u0633\u0628\u0648\u0639 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0623\u0633\u0628\u0648\u0639\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0623\u0633\u0627\u0628\u064A\u0639 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0623\u0633\u0628\u0648\u0639 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xWeeks: {
    one: "\u0623\u0633\u0628\u0648\u0639 \u0648\u0627\u062D\u062F",
    two: "\u0623\u0633\u0628\u0648\u0639\u064A\u0646",
    threeToTen: "{{count}} \u0623\u0633\u0627\u0628\u064A\u0639",
    other: "{{count}} \u0623\u0633\u0628\u0648\u0639"
  },
  aboutXMonths: {
    one: "\u0634\u0647\u0631 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0634\u0647\u0631\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0623\u0634\u0647\u0631 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0634\u0647\u0631 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xMonths: {
    one: "\u0634\u0647\u0631 \u0648\u0627\u062D\u062F",
    two: "\u0634\u0647\u0631\u064A\u0646",
    threeToTen: "{{count}} \u0623\u0634\u0647\u0631",
    other: "{{count}} \u0634\u0647\u0631"
  },
  aboutXYears: {
    one: "\u0639\u0627\u0645 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0639\u0627\u0645\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0623\u0639\u0648\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0639\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xYears: {
    one: "\u0639\u0627\u0645 \u0648\u0627\u062D\u062F",
    two: "\u0639\u0627\u0645\u064A\u0646",
    threeToTen: "{{count}} \u0623\u0639\u0648\u0627\u0645",
    other: "{{count}} \u0639\u0627\u0645"
  },
  overXYears: {
    one: "\u0623\u0643\u062B\u0631 \u0645\u0646 \u0639\u0627\u0645",
    two: "\u0623\u0643\u062B\u0631 \u0645\u0646 \u0639\u0627\u0645\u064A\u0646",
    threeToTen: "\u0623\u0643\u062B\u0631 \u0645\u0646 {{count}} \u0623\u0639\u0648\u0627\u0645",
    other: "\u0623\u0643\u062B\u0631 \u0645\u0646 {{count}} \u0639\u0627\u0645"
  },
  almostXYears: {
    one: "\u0639\u0627\u0645 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0639\u0627\u0645\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0623\u0639\u0648\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0639\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  }
};
var formatDistance$2w = function formatDistance4(token, count2, options) {
  options = options || {};
  var usageGroup = formatDistanceLocale$1f[token];
  var result;
  if (typeof usageGroup === "string") {
    result = usageGroup;
  } else if (count2 === 1) {
    result = usageGroup.one;
  } else if (count2 === 2) {
    result = usageGroup.two;
  } else if (count2 <= 10) {
    result = usageGroup.threeToTen.replace("{{count}}", String(count2));
  } else {
    result = usageGroup.other.replace("{{count}}", String(count2));
  }
  if (options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "\u0641\u064A \u062E\u0644\u0627\u0644 " + result;
    } else {
      return "\u0645\u0646\u0630 " + result;
    }
  }
  return result;
};
var formatDistance$2x = formatDistance$2w;
var dateFormats$1o = {
  full: "EEEE, MMMM do, y",
  long: "MMMM do, y",
  medium: "MMM d, y",
  short: "MM/dd/yyyy"
};
var timeFormats$1o = {
  full: "h:mm:ss a zzzz",
  long: "h:mm:ss a z",
  medium: "h:mm:ss a",
  short: "h:mm a"
};
var dateTimeFormats$1o = {
  full: "{{date}} '\u0639\u0646\u062F' {{time}}",
  long: "{{date}} '\u0639\u0646\u062F' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong$2M = {
  date: buildFormatLongFn$1({
    formats: dateFormats$1o,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn$1({
    formats: timeFormats$1o,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn$1({
    formats: dateTimeFormats$1o,
    defaultWidth: "full"
  })
};
var formatLong$2N = formatLong$2M;
var formatRelativeLocale$1g = {
  lastWeek: "'\u0623\u062E\u0631' eeee '\u0639\u0646\u062F' p",
  yesterday: "'\u0623\u0645\u0633 \u0639\u0646\u062F' p",
  today: "'\u0627\u0644\u064A\u0648\u0645 \u0639\u0646\u062F' p",
  tomorrow: "'\u063A\u062F\u0627\u064B \u0639\u0646\u062F' p",
  nextWeek: "eeee '\u0639\u0646\u062F' p",
  other: "P"
};
var formatRelative$2w = function formatRelative4(token, _date, _baseDate, _options) {
  return formatRelativeLocale$1g[token];
};
var formatRelative$2x = formatRelative$2w;
var eraValues$1g = {
  narrow: ["\u0642", "\u0628"],
  abbreviated: ["\u0642.\u0645.", "\u0628.\u0645."],
  wide: ["\u0642\u0628\u0644 \u0627\u0644\u0645\u064A\u0644\u0627\u062F", "\u0628\u0639\u062F \u0627\u0644\u0645\u064A\u0644\u0627\u062F"]
};
var quarterValues$1g = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["\u06311", "\u06312", "\u06313", "\u06314"],
  wide: ["\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u0623\u0648\u0644", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u062B\u0627\u0646\u064A", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u062B\u0627\u0644\u062B", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u0631\u0627\u0628\u0639"]
};
var monthValues$1g = {
  narrow: ["\u062C", "\u0641", "\u0645", "\u0623", "\u0645", "\u062C", "\u062C", "\u0623", "\u0633", "\u0623", "\u0646", "\u062F"],
  abbreviated: ["\u062C\u0627\u0646\u0640", "\u0641\u064A\u0641\u0640", "\u0645\u0627\u0631\u0633", "\u0623\u0641\u0631\u064A\u0644", "\u0645\u0627\u064A\u0640", "\u062C\u0648\u0627\u0646\u0640", "\u062C\u0648\u064A\u0640", "\u0623\u0648\u062A", "\u0633\u0628\u062A\u0640", "\u0623\u0643\u062A\u0640", "\u0646\u0648\u0641\u0640", "\u062F\u064A\u0633\u0640"],
  wide: ["\u062C\u0627\u0646\u0641\u064A", "\u0641\u064A\u0641\u0631\u064A", "\u0645\u0627\u0631\u0633", "\u0623\u0641\u0631\u064A\u0644", "\u0645\u0627\u064A", "\u062C\u0648\u0627\u0646", "\u062C\u0648\u064A\u0644\u064A\u0629", "\u0623\u0648\u062A", "\u0633\u0628\u062A\u0645\u0628\u0631", "\u0623\u0643\u062A\u0648\u0628\u0631", "\u0646\u0648\u0641\u0645\u0628\u0631", "\u062F\u064A\u0633\u0645\u0628\u0631"]
};
var dayValues$1g = {
  narrow: ["\u062D", "\u0646", "\u062B", "\u0631", "\u062E", "\u062C", "\u0633"],
  short: ["\u0623\u062D\u062F", "\u0627\u062B\u0646\u064A\u0646", "\u062B\u0644\u0627\u062B\u0627\u0621", "\u0623\u0631\u0628\u0639\u0627\u0621", "\u062E\u0645\u064A\u0633", "\u062C\u0645\u0639\u0629", "\u0633\u0628\u062A"],
  abbreviated: ["\u0623\u062D\u062F", "\u0627\u062B\u0646\u0640", "\u062B\u0644\u0627", "\u0623\u0631\u0628\u0640", "\u062E\u0645\u064A\u0640", "\u062C\u0645\u0639\u0629", "\u0633\u0628\u062A"],
  wide: ["\u0627\u0644\u0623\u062D\u062F", "\u0627\u0644\u0627\u062B\u0646\u064A\u0646", "\u0627\u0644\u062B\u0644\u0627\u062B\u0627\u0621", "\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621", "\u0627\u0644\u062E\u0645\u064A\u0633", "\u0627\u0644\u062C\u0645\u0639\u0629", "\u0627\u0644\u0633\u0628\u062A"]
};
var dayPeriodValues$1g = {
  narrow: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646",
    noon: "\u0638",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0645\u0633\u0627\u0621\u0627\u064B",
    night: "\u0644\u064A\u0644\u0627\u064B"
  },
  abbreviated: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0645\u0633\u0627\u0621\u0627\u064B",
    night: "\u0644\u064A\u0644\u0627\u064B"
  },
  wide: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0645\u0633\u0627\u0621\u0627\u064B",
    night: "\u0644\u064A\u0644\u0627\u064B"
  }
};
var formattingDayPeriodValues$11 = {
  narrow: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646",
    noon: "\u0638",
    morning: "\u0641\u064A \u0627\u0644\u0635\u0628\u0627\u062D",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0640\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u0644"
  },
  abbreviated: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631",
    morning: "\u0641\u064A \u0627\u0644\u0635\u0628\u0627\u062D",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u0644"
  },
  wide: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0640\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u0644"
  }
};
var ordinalNumber$1g = function ordinalNumber4(dirtyNumber) {
  return String(dirtyNumber);
};
var localize$2w = {
  ordinalNumber: ordinalNumber$1g,
  era: buildLocalizeFn$1({
    values: eraValues$1g,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn$1({
    values: quarterValues$1g,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback4(quarter) {
      return Number(quarter) - 1;
    }
  }),
  month: buildLocalizeFn$1({
    values: monthValues$1g,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn$1({
    values: dayValues$1g,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn$1({
    values: dayPeriodValues$1g,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues$11,
    defaultFormattingWidth: "wide"
  })
};
var localize$2x = localize$2w;
var matchOrdinalNumberPattern$1f = /^(\d+)(th|st|nd|rd)?/i;
var parseOrdinalNumberPattern$1f = /\d+/i;
var matchEraPatterns$1f = {
  narrow: /^(ق|ب)/i,
  abbreviated: /^(ق\.?\s?م\.?|ق\.?\s?م\.?\s?|a\.?\s?d\.?|c\.?\s?)/i,
  wide: /^(قبل الميلاد|قبل الميلاد|بعد الميلاد|بعد الميلاد)/i
};
var parseEraPatterns$1f = {
  any: [/^قبل/i, /^بعد/i]
};
var matchQuarterPatterns$1f = {
  narrow: /^[1234]/i,
  abbreviated: /^ر[1234]/i,
  wide: /^الربع [1234]/i
};
var parseQuarterPatterns$1f = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns$1f = {
  narrow: /^[جفمأسند]/i,
  abbreviated: /^(جان|فيف|مار|أفر|ماي|جوا|جوي|أوت|سبت|أكت|نوف|ديس)/i,
  wide: /^(جانفي|فيفري|مارس|أفريل|ماي|جوان|جويلية|أوت|سبتمبر|أكتوبر|نوفمبر|ديسمبر)/i
};
var parseMonthPatterns$1f = {
  narrow: [/^ج/i, /^ف/i, /^م/i, /^أ/i, /^م/i, /^ج/i, /^ج/i, /^أ/i, /^س/i, /^أ/i, /^ن/i, /^د/i],
  any: [/^جان/i, /^فيف/i, /^مار/i, /^أفر/i, /^ماي/i, /^جوا/i, /^جوي/i, /^أوت/i, /^سبت/i, /^أكت/i, /^نوف/i, /^ديس/i]
};
var matchDayPatterns$1f = {
  narrow: /^[حنثرخجس]/i,
  short: /^(أحد|اثنين|ثلاثاء|أربعاء|خميس|جمعة|سبت)/i,
  abbreviated: /^(أحد|اثن|ثلا|أرب|خمي|جمعة|سبت)/i,
  wide: /^(الأحد|الاثنين|الثلاثاء|الأربعاء|الخميس|الجمعة|السبت)/i
};
var parseDayPatterns$1f = {
  narrow: [/^ح/i, /^ن/i, /^ث/i, /^ر/i, /^خ/i, /^ج/i, /^س/i],
  wide: [/^الأحد/i, /^الاثنين/i, /^الثلاثاء/i, /^الأربعاء/i, /^الخميس/i, /^الجمعة/i, /^السبت/i],
  any: [/^أح/i, /^اث/i, /^ث/i, /^أر/i, /^خ/i, /^ج/i, /^س/i]
};
var matchDayPeriodPatterns$1f = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
};
var parseDayPeriodPatterns$1f = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i
  }
};
var match$2w = {
  ordinalNumber: buildMatchPatternFn$1({
    matchPattern: matchOrdinalNumberPattern$1f,
    parsePattern: parseOrdinalNumberPattern$1f,
    valueCallback: function valueCallback7(value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn$1({
    matchPatterns: matchEraPatterns$1f,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns$1f,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn$1({
    matchPatterns: matchQuarterPatterns$1f,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns$1f,
    defaultParseWidth: "any",
    valueCallback: function valueCallback8(index2) {
      return Number(index2) + 1;
    }
  }),
  month: buildMatchFn$1({
    matchPatterns: matchMonthPatterns$1f,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns$1f,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn$1({
    matchPatterns: matchDayPatterns$1f,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns$1f,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn$1({
    matchPatterns: matchDayPeriodPatterns$1f,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns$1f,
    defaultParseWidth: "any"
  })
};
var match$2x = match$2w;
var locale$2S = {
  code: "ar-DZ",
  formatDistance: formatDistance$2x,
  formatLong: formatLong$2N,
  formatRelative: formatRelative$2x,
  localize: localize$2x,
  match: match$2x,
  options: {
    weekStartsOn: 0,
    firstWeekContainsDate: 1
  }
};
var locale$2T = locale$2S;
var formatDistanceLocale$1e = {
  lessThanXSeconds: {
    one: "\u0623\u0642\u0644 \u0645\u0646 \u062B\u0627\u0646\u064A\u0629",
    two: "\u0623\u0642\u0644 \u0645\u0646 \u062B\u0627\u0646\u064A\u062A\u064A\u0646",
    threeToTen: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062B\u0648\u0627\u0646\u064A",
    other: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062B\u0627\u0646\u064A\u0629"
  },
  xSeconds: {
    one: "\u062B\u0627\u0646\u064A\u0629",
    two: "\u062B\u0627\u0646\u064A\u062A\u064A\u0646",
    threeToTen: "{{count}} \u062B\u0648\u0627\u0646\u064A",
    other: "{{count}} \u062B\u0627\u0646\u064A\u0629"
  },
  halfAMinute: "\u0646\u0635 \u062F\u0642\u064A\u0642\u0629",
  lessThanXMinutes: {
    one: "\u0623\u0642\u0644 \u0645\u0646 \u062F\u0642\u064A\u0642\u0629",
    two: "\u0623\u0642\u0644 \u0645\u0646 \u062F\u0642\u064A\u0642\u062A\u064A\u0646",
    threeToTen: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062F\u0642\u0627\u064A\u0642",
    other: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062F\u0642\u064A\u0642\u0629"
  },
  xMinutes: {
    one: "\u062F\u0642\u064A\u0642\u0629",
    two: "\u062F\u0642\u064A\u0642\u062A\u064A\u0646",
    threeToTen: "{{count}} \u062F\u0642\u0627\u064A\u0642",
    other: "{{count}} \u062F\u0642\u064A\u0642\u0629"
  },
  aboutXHours: {
    one: "\u062D\u0648\u0627\u0644\u064A \u0633\u0627\u0639\u0629",
    two: "\u062D\u0648\u0627\u0644\u064A \u0633\u0627\u0639\u062A\u064A\u0646",
    threeToTen: "\u062D\u0648\u0627\u0644\u064A {{count}} \u0633\u0627\u0639\u0627\u062A",
    other: "\u062D\u0648\u0627\u0644\u064A {{count}} \u0633\u0627\u0639\u0629"
  },
  xHours: {
    one: "\u0633\u0627\u0639\u0629",
    two: "\u0633\u0627\u0639\u062A\u064A\u0646",
    threeToTen: "{{count}} \u0633\u0627\u0639\u0627\u062A",
    other: "{{count}} \u0633\u0627\u0639\u0629"
  },
  xDays: {
    one: "\u064A\u0648\u0645",
    two: "\u064A\u0648\u0645\u064A\u0646",
    threeToTen: "{{count}} \u0623\u064A\u0627\u0645",
    other: "{{count}} \u064A\u0648\u0645"
  },
  aboutXWeeks: {
    one: "\u062D\u0648\u0627\u0644\u064A \u0623\u0633\u0628\u0648\u0639",
    two: "\u062D\u0648\u0627\u0644\u064A \u0623\u0633\u0628\u0648\u0639\u064A\u0646",
    threeToTen: "\u062D\u0648\u0627\u0644\u064A {{count}} \u0623\u0633\u0627\u0628\u064A\u0639",
    other: "\u062D\u0648\u0627\u0644\u064A {{count}} \u0623\u0633\u0628\u0648\u0639"
  },
  xWeeks: {
    one: "\u0623\u0633\u0628\u0648\u0639",
    two: "\u0623\u0633\u0628\u0648\u0639\u064A\u0646",
    threeToTen: "{{count}} \u0623\u0633\u0627\u0628\u064A\u0639",
    other: "{{count}} \u0623\u0633\u0628\u0648\u0639"
  },
  aboutXMonths: {
    one: "\u062D\u0648\u0627\u0644\u064A \u0634\u0647\u0631",
    two: "\u062D\u0648\u0627\u0644\u064A \u0634\u0647\u0631\u064A\u0646",
    threeToTen: "\u062D\u0648\u0627\u0644\u064A {{count}} \u0623\u0634\u0647\u0631",
    other: "\u062D\u0648\u0627\u0644\u064A {{count}} \u0634\u0647\u0631"
  },
  xMonths: {
    one: "\u0634\u0647\u0631",
    two: "\u0634\u0647\u0631\u064A\u0646",
    threeToTen: "{{count}} \u0623\u0634\u0647\u0631",
    other: "{{count}} \u0634\u0647\u0631"
  },
  aboutXYears: {
    one: "\u062D\u0648\u0627\u0644\u064A \u0633\u0646\u0629",
    two: "\u062D\u0648\u0627\u0644\u064A \u0633\u0646\u062A\u064A\u0646",
    threeToTen: "\u062D\u0648\u0627\u0644\u064A {{count}} \u0633\u0646\u064A\u0646",
    other: "\u062D\u0648\u0627\u0644\u064A {{count}} \u0633\u0646\u0629"
  },
  xYears: {
    one: "\u0639\u0627\u0645",
    two: "\u0639\u0627\u0645\u064A\u0646",
    threeToTen: "{{count}} \u0623\u0639\u0648\u0627\u0645",
    other: "{{count}} \u0639\u0627\u0645"
  },
  overXYears: {
    one: "\u0623\u0643\u062B\u0631 \u0645\u0646 \u0633\u0646\u0629",
    two: "\u0623\u0643\u062B\u0631 \u0645\u0646 \u0633\u0646\u062A\u064A\u0646",
    threeToTen: "\u0623\u0643\u062B\u0631 \u0645\u0646 {{count}} \u0633\u0646\u064A\u0646",
    other: "\u0623\u0643\u062B\u0631 \u0645\u0646 {{count}} \u0633\u0646\u0629"
  },
  almostXYears: {
    one: "\u0639\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u064B\u0627",
    two: "\u0639\u0627\u0645\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u064B\u0627",
    threeToTen: "{{count}} \u0623\u0639\u0648\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u064B\u0627",
    other: "{{count}} \u0639\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u064B\u0627"
  }
};
var formatDistance$2u = function formatDistance5(token, count2, options) {
  var result;
  var tokenValue = formatDistanceLocale$1e[token];
  if (typeof tokenValue === "string") {
    result = tokenValue;
  } else if (count2 === 1) {
    result = tokenValue.one;
  } else if (count2 === 2) {
    result = tokenValue.two;
  } else if (count2 <= 10) {
    result = tokenValue.threeToTen.replace("{{count}}", String(count2));
  } else {
    result = tokenValue.other.replace("{{count}}", String(count2));
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "\u0641\u064A \u062E\u0644\u0627\u0644 ".concat(result);
    } else {
      return "\u0645\u0646\u0630 ".concat(result);
    }
  }
  return result;
};
var formatDistance$2v = formatDistance$2u;
var dateFormats$1n = {
  full: "EEEE\u060C do MMMM y",
  long: "do MMMM y",
  medium: "dd/MMM/y",
  short: "d/MM/y"
};
var timeFormats$1n = {
  full: "h:mm:ss a zzzz",
  long: "h:mm:ss a z",
  medium: "h:mm:ss a",
  short: "h:mm a"
};
var dateTimeFormats$1n = {
  full: "{{date}} '\u0627\u0644\u0633\u0627\u0639\u0629' {{time}}",
  long: "{{date}} '\u0627\u0644\u0633\u0627\u0639\u0629' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong$2K = {
  date: buildFormatLongFn$1({
    formats: dateFormats$1n,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn$1({
    formats: timeFormats$1n,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn$1({
    formats: dateTimeFormats$1n,
    defaultWidth: "full"
  })
};
var formatLong$2L = formatLong$2K;
var formatRelativeLocale$1f = {
  lastWeek: "eeee '\u0627\u0644\u0644\u064A \u062C\u0627\u064A \u0627\u0644\u0633\u0627\u0639\u0629' p",
  yesterday: "'\u0625\u0645\u0628\u0627\u0631\u062D \u0627\u0644\u0633\u0627\u0639\u0629' p",
  today: "'\u0627\u0644\u0646\u0647\u0627\u0631\u062F\u0629 \u0627\u0644\u0633\u0627\u0639\u0629' p",
  tomorrow: "'\u0628\u0643\u0631\u0629 \u0627\u0644\u0633\u0627\u0639\u0629' p",
  nextWeek: "eeee '\u0627\u0644\u0633\u0627\u0639\u0629' p",
  other: "P"
};
var formatRelative$2u = function formatRelative5(token, _date, _baseDate, _options) {
  return formatRelativeLocale$1f[token];
};
var formatRelative$2v = formatRelative$2u;
var eraValues$1f = {
  narrow: ["\u0642", "\u0628"],
  abbreviated: ["\u0642.\u0645", "\u0628.\u0645"],
  wide: ["\u0642\u0628\u0644 \u0627\u0644\u0645\u064A\u0644\u0627\u062F", "\u0628\u0639\u062F \u0627\u0644\u0645\u064A\u0644\u0627\u062F"]
};
var quarterValues$1f = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["\u06311", "\u06312", "\u06313", "\u06314"],
  wide: ["\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u0623\u0648\u0644", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u062B\u0627\u0646\u064A", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u062B\u0627\u0644\u062B", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u0631\u0627\u0628\u0639"]
};
var monthValues$1f = {
  narrow: ["\u064A", "\u0641", "\u0645", "\u0623", "\u0645", "\u064A", "\u064A", "\u0623", "\u0633", "\u0623", "\u0646", "\u062F"],
  abbreviated: ["\u064A\u0646\u0627", "\u0641\u0628\u0631", "\u0645\u0627\u0631\u0633", "\u0623\u0628\u0631\u064A\u0644", "\u0645\u0627\u064A\u0648", "\u064A\u0648\u0646\u0640", "\u064A\u0648\u0644\u0640", "\u0623\u063A\u0633\u0640", "\u0633\u0628\u062A\u0640", "\u0623\u0643\u062A\u0640", "\u0646\u0648\u0641\u0640", "\u062F\u064A\u0633\u0640"],
  wide: ["\u064A\u0646\u0627\u064A\u0631", "\u0641\u0628\u0631\u0627\u064A\u0631", "\u0645\u0627\u0631\u0633", "\u0623\u0628\u0631\u064A\u0644", "\u0645\u0627\u064A\u0648", "\u064A\u0648\u0646\u064A\u0648", "\u064A\u0648\u0644\u064A\u0648", "\u0623\u063A\u0633\u0637\u0633", "\u0633\u0628\u062A\u0645\u0628\u0631", "\u0623\u0643\u062A\u0648\u0628\u0631", "\u0646\u0648\u0641\u0645\u0628\u0631", "\u062F\u064A\u0633\u0645\u0628\u0631"]
};
var dayValues$1f = {
  narrow: ["\u062D", "\u0646", "\u062B", "\u0631", "\u062E", "\u062C", "\u0633"],
  short: ["\u0623\u062D\u062F", "\u0627\u062B\u0646\u064A\u0646", "\u062B\u0644\u0627\u062B\u0627\u0621", "\u0623\u0631\u0628\u0639\u0627\u0621", "\u062E\u0645\u064A\u0633", "\u062C\u0645\u0639\u0629", "\u0633\u0628\u062A"],
  abbreviated: ["\u0623\u062D\u062F", "\u0627\u062B\u0646\u064A\u0646", "\u062B\u0644\u0627\u062B\u0627\u0621", "\u0623\u0631\u0628\u0639\u0627\u0621", "\u062E\u0645\u064A\u0633", "\u062C\u0645\u0639\u0629", "\u0633\u0628\u062A"],
  wide: ["\u0627\u0644\u0623\u062D\u062F", "\u0627\u0644\u0627\u062B\u0646\u064A\u0646", "\u0627\u0644\u062B\u0644\u0627\u062B\u0627\u0621", "\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621", "\u0627\u0644\u062E\u0645\u064A\u0633", "\u0627\u0644\u062C\u0645\u0639\u0629", "\u0627\u0644\u0633\u0628\u062A"]
};
var dayPeriodValues$1f = {
  narrow: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646",
    noon: "\u0638",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0645\u0633\u0627\u0621\u064B",
    night: "\u0644\u064A\u0644\u0627\u064B"
  },
  abbreviated: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631\u0627\u064B",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0645\u0633\u0627\u0621\u064B",
    night: "\u0644\u064A\u0644\u0627\u064B"
  },
  wide: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631\u0627\u064B",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0645\u0633\u0627\u0621\u064B",
    night: "\u0644\u064A\u0644\u0627\u064B"
  }
};
var formattingDayPeriodValues$10 = {
  narrow: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646",
    noon: "\u0638",
    morning: "\u0641\u064A \u0627\u0644\u0635\u0628\u0627\u062D",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u0644"
  },
  abbreviated: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631\u0627\u064B",
    morning: "\u0641\u064A \u0627\u0644\u0635\u0628\u0627\u062D",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u0644"
  },
  wide: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    morning: "\u0641\u064A \u0627\u0644\u0635\u0628\u0627\u062D",
    noon: "\u0638\u0647\u0631\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u0644"
  }
};
var ordinalNumber$1f = function ordinalNumber5(dirtyNumber, _options) {
  return String(dirtyNumber);
};
var localize$2u = {
  ordinalNumber: ordinalNumber$1f,
  era: buildLocalizeFn$1({
    values: eraValues$1f,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn$1({
    values: quarterValues$1f,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback5(quarter) {
      return quarter - 1;
    }
  }),
  month: buildLocalizeFn$1({
    values: monthValues$1f,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn$1({
    values: dayValues$1f,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn$1({
    values: dayPeriodValues$1f,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues$10,
    defaultFormattingWidth: "wide"
  })
};
var localize$2v = localize$2u;
var matchOrdinalNumberPattern$1e = /^(\d+)/;
var parseOrdinalNumberPattern$1e = /\d+/i;
var matchEraPatterns$1e = {
  narrow: /^(ق|ب)/g,
  abbreviated: /^(ق.م|ب.م)/g,
  wide: /^(قبل الميلاد|بعد الميلاد)/g
};
var parseEraPatterns$1e = {
  any: [/^ق/g, /^ب/g]
};
var matchQuarterPatterns$1e = {
  narrow: /^[1234]/,
  abbreviated: /^ر[1234]/,
  wide: /^الربع (الأول|الثاني|الثالث|الرابع)/
};
var parseQuarterPatterns$1e = {
  wide: [/الربع الأول/, /الربع الثاني/, /الربع الثالث/, /الربع الرابع/],
  any: [/1/, /2/, /3/, /4/]
};
var matchMonthPatterns$1e = {
  narrow: /^(ي|ف|م|أ|س|ن|د)/,
  abbreviated: /^(ينا|فبر|مارس|أبريل|مايو|يونـ|يولـ|أغسـ|سبتـ|أكتـ|نوفـ|ديسـ)/,
  wide: /^(يناير|فبراير|مارس|أبريل|مايو|يونيو|يوليو|أغسطس|سبتمبر|أكتوبر|نوفمبر|ديسمبر)/
};
var parseMonthPatterns$1e = {
  narrow: [/^ي/, /^ف/, /^م/, /^أ/, /^م/, /^ي/, /^ي/, /^أ/, /^س/, /^أ/, /^ن/, /^د/],
  any: [/^ينا/, /^فبر/, /^مارس/, /^أبريل/, /^مايو/, /^يون/, /^يول/, /^أغس/, /^سبت/, /^أكت/, /^نوف/, /^ديس/]
};
var matchDayPatterns$1e = {
  narrow: /^(ح|ن|ث|ر|خ|ج|س)/,
  short: /^(أحد|اثنين|ثلاثاء|أربعاء|خميس|جمعة|سبت)/,
  abbreviated: /^(أحد|اثنين|ثلاثاء|أربعاء|خميس|جمعة|سبت)/,
  wide: /^(الأحد|الاثنين|الثلاثاء|الأربعاء|الخميس|الجمعة|السبت)/
};
var parseDayPatterns$1e = {
  narrow: [/^ح/, /^ن/, /^ث/, /^ر/, /^خ/, /^ج/, /^س/],
  any: [/أحد/, /اثنين/, /ثلاثاء/, /أربعاء/, /خميس/, /جمعة/, /سبت/]
};
var matchDayPeriodPatterns$1e = {
  narrow: /^(ص|م|ن|ظ|في الصباح|بعد الظهر|في المساء|في الليل)/,
  abbreviated: /^(ص|م|نصف الليل|ظهراً|في الصباح|بعد الظهر|في المساء|في الليل)/,
  wide: /^(ص|م|نصف الليل|في الصباح|ظهراً|بعد الظهر|في المساء|في الليل)/,
  any: /^(ص|م|صباح|ظهر|مساء|ليل)/
};
var parseDayPeriodPatterns$1e = {
  any: {
    am: /^ص/,
    pm: /^م/,
    midnight: /^ن/,
    noon: /^ظ/,
    morning: /^ص/,
    afternoon: /^بعد/,
    evening: /^م/,
    night: /^ل/
  }
};
var match$2u = {
  ordinalNumber: buildMatchPatternFn$1({
    matchPattern: matchOrdinalNumberPattern$1e,
    parsePattern: parseOrdinalNumberPattern$1e,
    valueCallback: function valueCallback9(value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn$1({
    matchPatterns: matchEraPatterns$1e,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns$1e,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn$1({
    matchPatterns: matchQuarterPatterns$1e,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns$1e,
    defaultParseWidth: "any",
    valueCallback: function valueCallback10(index2) {
      return index2 + 1;
    }
  }),
  month: buildMatchFn$1({
    matchPatterns: matchMonthPatterns$1e,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns$1e,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn$1({
    matchPatterns: matchDayPatterns$1e,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns$1e,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn$1({
    matchPatterns: matchDayPeriodPatterns$1e,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns$1e,
    defaultParseWidth: "any"
  })
};
var match$2v = match$2u;
var locale$2Q = {
  code: "ar-EG",
  formatDistance: formatDistance$2v,
  formatLong: formatLong$2L,
  formatRelative: formatRelative$2v,
  localize: localize$2v,
  match: match$2v,
  options: {
    weekStartsOn: 0,
    firstWeekContainsDate: 1
  }
};
var locale$2R = locale$2Q;
var formatDistanceLocale$1d = {
  lessThanXSeconds: {
    one: "\u0623\u0642\u0644 \u0645\u0646 \u062B\u0627\u0646\u064A\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u0623\u0642\u0644 \u0645\u0646 \u062B\u0627\u0646\u062A\u064A\u0646",
    threeToTen: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062B\u0648\u0627\u0646\u064A",
    other: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062B\u0627\u0646\u064A\u0629"
  },
  xSeconds: {
    one: "\u062B\u0627\u0646\u064A\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u062B\u0627\u0646\u062A\u064A\u0646",
    threeToTen: "{{count}} \u062B\u0648\u0627\u0646\u064A",
    other: "{{count}} \u062B\u0627\u0646\u064A\u0629"
  },
  halfAMinute: "\u0646\u0635\u0641 \u062F\u0642\u064A\u0642\u0629",
  lessThanXMinutes: {
    one: "\u0623\u0642\u0644 \u0645\u0646 \u062F\u0642\u064A\u0642\u0629",
    two: "\u0623\u0642\u0644 \u0645\u0646 \u062F\u0642\u064A\u0642\u062A\u064A\u0646",
    threeToTen: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062F\u0642\u0627\u0626\u0642",
    other: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062F\u0642\u064A\u0642\u0629"
  },
  xMinutes: {
    one: "\u062F\u0642\u064A\u0642\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u062F\u0642\u064A\u0642\u062A\u064A\u0646",
    threeToTen: "{{count}} \u062F\u0642\u0627\u0626\u0642",
    other: "{{count}} \u062F\u0642\u064A\u0642\u0629"
  },
  aboutXHours: {
    one: "\u0633\u0627\u0639\u0629 \u0648\u0627\u062D\u062F\u0629 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0633\u0627\u0639\u062A\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0633\u0627\u0639\u0627\u062A \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0633\u0627\u0639\u0629 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xHours: {
    one: "\u0633\u0627\u0639\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u0633\u0627\u0639\u062A\u064A\u0646",
    threeToTen: "{{count}} \u0633\u0627\u0639\u0627\u062A",
    other: "{{count}} \u0633\u0627\u0639\u0629"
  },
  xDays: {
    one: "\u064A\u0648\u0645 \u0648\u0627\u062D\u062F",
    two: "\u064A\u0648\u0645\u064A\u0646",
    threeToTen: "{{count}} \u0623\u064A\u0627\u0645",
    other: "{{count}} \u064A\u0648\u0645"
  },
  aboutXWeeks: {
    one: "\u0623\u0633\u0628\u0648\u0639 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0623\u0633\u0628\u0648\u0639\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0623\u0633\u0627\u0628\u064A\u0639 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0623\u0633\u0628\u0648\u0639 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xWeeks: {
    one: "\u0623\u0633\u0628\u0648\u0639 \u0648\u0627\u062D\u062F",
    two: "\u0623\u0633\u0628\u0648\u0639\u064A\u0646",
    threeToTen: "{{count}} \u0623\u0633\u0627\u0628\u064A\u0639",
    other: "{{count}} \u0623\u0633\u0628\u0648\u0639"
  },
  aboutXMonths: {
    one: "\u0634\u0647\u0631 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0634\u0647\u0631\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0623\u0634\u0647\u0631 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0634\u0647\u0631 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xMonths: {
    one: "\u0634\u0647\u0631 \u0648\u0627\u062D\u062F",
    two: "\u0634\u0647\u0631\u064A\u0646",
    threeToTen: "{{count}} \u0623\u0634\u0647\u0631",
    other: "{{count}} \u0634\u0647\u0631"
  },
  aboutXYears: {
    one: "\u0639\u0627\u0645 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0639\u0627\u0645\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0623\u0639\u0648\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0639\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xYears: {
    one: "\u0639\u0627\u0645 \u0648\u0627\u062D\u062F",
    two: "\u0639\u0627\u0645\u064A\u0646",
    threeToTen: "{{count}} \u0623\u0639\u0648\u0627\u0645",
    other: "{{count}} \u0639\u0627\u0645"
  },
  overXYears: {
    one: "\u0623\u0643\u062B\u0631 \u0645\u0646 \u0639\u0627\u0645",
    two: "\u0623\u0643\u062B\u0631 \u0645\u0646 \u0639\u0627\u0645\u064A\u0646",
    threeToTen: "\u0623\u0643\u062B\u0631 \u0645\u0646 {{count}} \u0623\u0639\u0648\u0627\u0645",
    other: "\u0623\u0643\u062B\u0631 \u0645\u0646 {{count}} \u0639\u0627\u0645"
  },
  almostXYears: {
    one: "\u0639\u0627\u0645 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0639\u0627\u0645\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0623\u0639\u0648\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0639\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  }
};
var formatDistance$2s = function formatDistance6(token, count2, options) {
  options = options || {};
  var usageGroup = formatDistanceLocale$1d[token];
  var result;
  if (typeof usageGroup === "string") {
    result = usageGroup;
  } else if (count2 === 1) {
    result = usageGroup.one;
  } else if (count2 === 2) {
    result = usageGroup.two;
  } else if (count2 <= 10) {
    result = usageGroup.threeToTen.replace("{{count}}", String(count2));
  } else {
    result = usageGroup.other.replace("{{count}}", String(count2));
  }
  if (options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "\u0641\u064A \u062E\u0644\u0627\u0644 " + result;
    } else {
      return "\u0645\u0646\u0630 " + result;
    }
  }
  return result;
};
var formatDistance$2t = formatDistance$2s;
var dateFormats$1m = {
  full: "EEEE, MMMM do, y",
  long: "MMMM do, y",
  medium: "MMM d, y",
  short: "MM/dd/yyyy"
};
var timeFormats$1m = {
  full: "h:mm:ss a zzzz",
  long: "h:mm:ss a z",
  medium: "h:mm:ss a",
  short: "h:mm a"
};
var dateTimeFormats$1m = {
  full: "{{date}} '\u0639\u0646\u062F' {{time}}",
  long: "{{date}} '\u0639\u0646\u062F' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong$2I = {
  date: buildFormatLongFn$1({
    formats: dateFormats$1m,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn$1({
    formats: timeFormats$1m,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn$1({
    formats: dateTimeFormats$1m,
    defaultWidth: "full"
  })
};
var formatLong$2J = formatLong$2I;
var formatRelativeLocale$1e = {
  lastWeek: "'\u0623\u062E\u0631' eeee '\u0639\u0646\u062F' p",
  yesterday: "'\u0623\u0645\u0633 \u0639\u0646\u062F' p",
  today: "'\u0627\u0644\u064A\u0648\u0645 \u0639\u0646\u062F' p",
  tomorrow: "'\u063A\u062F\u0627\u064B \u0639\u0646\u062F' p",
  nextWeek: "eeee '\u0639\u0646\u062F' p",
  other: "P"
};
var formatRelative$2s = function formatRelative6(token, _date, _baseDate, _options) {
  return formatRelativeLocale$1e[token];
};
var formatRelative$2t = formatRelative$2s;
var eraValues$1e = {
  narrow: ["\u0642", "\u0628"],
  abbreviated: ["\u0642.\u0645.", "\u0628.\u0645."],
  wide: ["\u0642\u0628\u0644 \u0627\u0644\u0645\u064A\u0644\u0627\u062F", "\u0628\u0639\u062F \u0627\u0644\u0645\u064A\u0644\u0627\u062F"]
};
var quarterValues$1e = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["\u06311", "\u06312", "\u06313", "\u06314"],
  wide: ["\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u0623\u0648\u0644", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u062B\u0627\u0646\u064A", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u062B\u0627\u0644\u062B", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u0631\u0627\u0628\u0639"]
};
var monthValues$1e = {
  narrow: ["\u064A", "\u0641", "\u0645", "\u0623", "\u0645", "\u064A", "\u064A", "\u063A", "\u0634", "\u0623", "\u0646", "\u062F"],
  abbreviated: ["\u064A\u0646\u0627", "\u0641\u0628\u0631", "\u0645\u0627\u0631\u0633", "\u0623\u0628\u0631\u064A\u0644", "\u0645\u0627\u064A", "\u064A\u0648\u0646\u0640", "\u064A\u0648\u0644\u0640", "\u063A\u0634\u062A", "\u0634\u062A\u0646\u0640", "\u0623\u0643\u062A\u0640", "\u0646\u0648\u0646\u0640", "\u062F\u062C\u0646\u0640"],
  wide: ["\u064A\u0646\u0627\u064A\u0631", "\u0641\u0628\u0631\u0627\u064A\u0631", "\u0645\u0627\u0631\u0633", "\u0623\u0628\u0631\u064A\u0644", "\u0645\u0627\u064A", "\u064A\u0648\u0646\u064A\u0648", "\u064A\u0648\u0644\u064A\u0648\u0632", "\u063A\u0634\u062A", "\u0634\u062A\u0646\u0628\u0631", "\u0623\u0643\u062A\u0648\u0628\u0631", "\u0646\u0648\u0646\u0628\u0631", "\u062F\u062C\u0646\u0628\u0631"]
};
var dayValues$1e = {
  narrow: ["\u062D", "\u0646", "\u062B", "\u0631", "\u062E", "\u062C", "\u0633"],
  short: ["\u0623\u062D\u062F", "\u0627\u062B\u0646\u064A\u0646", "\u062B\u0644\u0627\u062B\u0627\u0621", "\u0623\u0631\u0628\u0639\u0627\u0621", "\u062E\u0645\u064A\u0633", "\u062C\u0645\u0639\u0629", "\u0633\u0628\u062A"],
  abbreviated: ["\u0623\u062D\u062F", "\u0627\u062B\u0646\u0640", "\u062B\u0644\u0627", "\u0623\u0631\u0628\u0640", "\u062E\u0645\u064A\u0640", "\u062C\u0645\u0639\u0629", "\u0633\u0628\u062A"],
  wide: ["\u0627\u0644\u0623\u062D\u062F", "\u0627\u0644\u0625\u062B\u0646\u064A\u0646", "\u0627\u0644\u062B\u0644\u0627\u062B\u0627\u0621", "\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621", "\u0627\u0644\u062E\u0645\u064A\u0633", "\u0627\u0644\u062C\u0645\u0639\u0629", "\u0627\u0644\u0633\u0628\u062A"]
};
var dayPeriodValues$1e = {
  narrow: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646",
    noon: "\u0638",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0645\u0633\u0627\u0621\u0627\u064B",
    night: "\u0644\u064A\u0644\u0627\u064B"
  },
  abbreviated: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0645\u0633\u0627\u0621\u0627\u064B",
    night: "\u0644\u064A\u0644\u0627\u064B"
  },
  wide: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0645\u0633\u0627\u0621\u0627\u064B",
    night: "\u0644\u064A\u0644\u0627\u064B"
  }
};
var formattingDayPeriodValues$$ = {
  narrow: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646",
    noon: "\u0638",
    morning: "\u0641\u064A \u0627\u0644\u0635\u0628\u0627\u062D",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0640\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u0644"
  },
  abbreviated: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631",
    morning: "\u0641\u064A \u0627\u0644\u0635\u0628\u0627\u062D",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u0644"
  },
  wide: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0640\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u0644"
  }
};
var ordinalNumber$1e = function ordinalNumber6(dirtyNumber) {
  return String(dirtyNumber);
};
var localize$2s = {
  ordinalNumber: ordinalNumber$1e,
  era: buildLocalizeFn$1({
    values: eraValues$1e,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn$1({
    values: quarterValues$1e,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback6(quarter) {
      return Number(quarter) - 1;
    }
  }),
  month: buildLocalizeFn$1({
    values: monthValues$1e,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn$1({
    values: dayValues$1e,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn$1({
    values: dayPeriodValues$1e,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues$$,
    defaultFormattingWidth: "wide"
  })
};
var localize$2t = localize$2s;
var matchOrdinalNumberPattern$1d = /^(\d+)(th|st|nd|rd)?/i;
var parseOrdinalNumberPattern$1d = /\d+/i;
var matchEraPatterns$1d = {
  narrow: /^(ق|ب)/i,
  abbreviated: /^(ق\.?\s?م\.?|ق\.?\s?م\.?\s?|a\.?\s?d\.?|c\.?\s?)/i,
  wide: /^(قبل الميلاد|قبل الميلاد|بعد الميلاد|بعد الميلاد)/i
};
var parseEraPatterns$1d = {
  any: [/^قبل/i, /^بعد/i]
};
var matchQuarterPatterns$1d = {
  narrow: /^[1234]/i,
  abbreviated: /^ر[1234]/i,
  wide: /^الربع [1234]/i
};
var parseQuarterPatterns$1d = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns$1d = {
  narrow: /^[يفمأمسند]/i,
  abbreviated: /^(ين|ف|مار|أب|ماي|يون|يول|غش|شت|أك|ن|د)/i,
  wide: /^(ين|ف|مار|أب|ماي|يون|يول|غش|شت|أك|ن|د)/i
};
var parseMonthPatterns$1d = {
  narrow: [/^ي/i, /^ف/i, /^م/i, /^أ/i, /^م/i, /^ي/i, /^ي/i, /^غ/i, /^ش/i, /^أ/i, /^ن/i, /^د/i],
  any: [/^ين/i, /^فب/i, /^مار/i, /^أب/i, /^ماي/i, /^يون/i, /^يول/i, /^غشت/i, /^ش/i, /^أك/i, /^ن/i, /^د/i]
};
var matchDayPatterns$1d = {
  narrow: /^[حنثرخجس]/i,
  short: /^(أحد|إثنين|ثلاثاء|أربعاء|خميس|جمعة|سبت)/i,
  abbreviated: /^(أحد|إثن|ثلا|أرب|خمي|جمعة|سبت)/i,
  wide: /^(الأحد|الإثنين|الثلاثاء|الأربعاء|الخميس|الجمعة|السبت)/i
};
var parseDayPatterns$1d = {
  narrow: [/^ح/i, /^ن/i, /^ث/i, /^ر/i, /^خ/i, /^ج/i, /^س/i],
  wide: [/^الأحد/i, /^الإثنين/i, /^الثلاثاء/i, /^الأربعاء/i, /^الخميس/i, /^الجمعة/i, /^السبت/i],
  any: [/^أح/i, /^إث/i, /^ث/i, /^أر/i, /^خ/i, /^ج/i, /^س/i]
};
var matchDayPeriodPatterns$1d = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
};
var parseDayPeriodPatterns$1d = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i
  }
};
var match$2s = {
  ordinalNumber: buildMatchPatternFn$1({
    matchPattern: matchOrdinalNumberPattern$1d,
    parsePattern: parseOrdinalNumberPattern$1d,
    valueCallback: function valueCallback11(value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn$1({
    matchPatterns: matchEraPatterns$1d,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns$1d,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn$1({
    matchPatterns: matchQuarterPatterns$1d,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns$1d,
    defaultParseWidth: "any",
    valueCallback: function valueCallback12(index2) {
      return Number(index2) + 1;
    }
  }),
  month: buildMatchFn$1({
    matchPatterns: matchMonthPatterns$1d,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns$1d,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn$1({
    matchPatterns: matchDayPatterns$1d,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns$1d,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn$1({
    matchPatterns: matchDayPeriodPatterns$1d,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns$1d,
    defaultParseWidth: "any"
  })
};
var match$2t = match$2s;
var locale$2O = {
  code: "ar-MA",
  formatDistance: formatDistance$2t,
  formatLong: formatLong$2J,
  formatRelative: formatRelative$2t,
  localize: localize$2t,
  match: match$2t,
  options: {
    weekStartsOn: 1,
    firstWeekContainsDate: 1
  }
};
var locale$2P = locale$2O;
var formatDistanceLocale$1c = {
  lessThanXSeconds: {
    one: "\u0623\u0642\u0644 \u0645\u0646 \u062B\u0627\u0646\u064A\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u0623\u0642\u0644 \u0645\u0646 \u062B\u0627\u0646\u062A\u064A\u0646",
    threeToTen: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062B\u0648\u0627\u0646\u064A",
    other: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062B\u0627\u0646\u064A\u0629"
  },
  xSeconds: {
    one: "\u062B\u0627\u0646\u064A\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u062B\u0627\u0646\u062A\u064A\u0646",
    threeToTen: "{{count}} \u062B\u0648\u0627\u0646\u064A",
    other: "{{count}} \u062B\u0627\u0646\u064A\u0629"
  },
  halfAMinute: "\u0646\u0635\u0641 \u062F\u0642\u064A\u0642\u0629",
  lessThanXMinutes: {
    one: "\u0623\u0642\u0644 \u0645\u0646 \u062F\u0642\u064A\u0642\u0629",
    two: "\u0623\u0642\u0644 \u0645\u0646 \u062F\u0642\u064A\u0642\u062A\u064A\u0646",
    threeToTen: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062F\u0642\u0627\u0626\u0642",
    other: "\u0623\u0642\u0644 \u0645\u0646 {{count}} \u062F\u0642\u064A\u0642\u0629"
  },
  xMinutes: {
    one: "\u062F\u0642\u064A\u0642\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u062F\u0642\u064A\u0642\u062A\u064A\u0646",
    threeToTen: "{{count}} \u062F\u0642\u0627\u0626\u0642",
    other: "{{count}} \u062F\u0642\u064A\u0642\u0629"
  },
  aboutXHours: {
    one: "\u0633\u0627\u0639\u0629 \u0648\u0627\u062D\u062F\u0629 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0633\u0627\u0639\u062A\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0633\u0627\u0639\u0627\u062A \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0633\u0627\u0639\u0629 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xHours: {
    one: "\u0633\u0627\u0639\u0629 \u0648\u0627\u062D\u062F\u0629",
    two: "\u0633\u0627\u0639\u062A\u064A\u0646",
    threeToTen: "{{count}} \u0633\u0627\u0639\u0627\u062A",
    other: "{{count}} \u0633\u0627\u0639\u0629"
  },
  xDays: {
    one: "\u064A\u0648\u0645 \u0648\u0627\u062D\u062F",
    two: "\u064A\u0648\u0645\u064A\u0646",
    threeToTen: "{{count}} \u0623\u064A\u0627\u0645",
    other: "{{count}} \u064A\u0648\u0645"
  },
  aboutXWeeks: {
    one: "\u0623\u0633\u0628\u0648\u0639 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0623\u0633\u0628\u0648\u0639\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0623\u0633\u0627\u0628\u064A\u0639 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0623\u0633\u0628\u0648\u0639 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xWeeks: {
    one: "\u0623\u0633\u0628\u0648\u0639 \u0648\u0627\u062D\u062F",
    two: "\u0623\u0633\u0628\u0648\u0639\u064A\u0646",
    threeToTen: "{{count}} \u0623\u0633\u0627\u0628\u064A\u0639",
    other: "{{count}} \u0623\u0633\u0628\u0648\u0639"
  },
  aboutXMonths: {
    one: "\u0634\u0647\u0631 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0634\u0647\u0631\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0623\u0634\u0647\u0631 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0634\u0647\u0631 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xMonths: {
    one: "\u0634\u0647\u0631 \u0648\u0627\u062D\u062F",
    two: "\u0634\u0647\u0631\u064A\u0646",
    threeToTen: "{{count}} \u0623\u0634\u0647\u0631",
    other: "{{count}} \u0634\u0647\u0631"
  },
  aboutXYears: {
    one: "\u0639\u0627\u0645 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0639\u0627\u0645\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0623\u0639\u0648\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0639\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  },
  xYears: {
    one: "\u0639\u0627\u0645 \u0648\u0627\u062D\u062F",
    two: "\u0639\u0627\u0645\u064A\u0646",
    threeToTen: "{{count}} \u0623\u0639\u0648\u0627\u0645",
    other: "{{count}} \u0639\u0627\u0645"
  },
  overXYears: {
    one: "\u0623\u0643\u062B\u0631 \u0645\u0646 \u0639\u0627\u0645",
    two: "\u0623\u0643\u062B\u0631 \u0645\u0646 \u0639\u0627\u0645\u064A\u0646",
    threeToTen: "\u0623\u0643\u062B\u0631 \u0645\u0646 {{count}} \u0623\u0639\u0648\u0627\u0645",
    other: "\u0623\u0643\u062B\u0631 \u0645\u0646 {{count}} \u0639\u0627\u0645"
  },
  almostXYears: {
    one: "\u0639\u0627\u0645 \u0648\u0627\u062D\u062F \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    two: "\u0639\u0627\u0645\u064A\u0646 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    threeToTen: "{{count}} \u0623\u0639\u0648\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u0627\u064B",
    other: "{{count}} \u0639\u0627\u0645 \u062A\u0642\u0631\u064A\u0628\u0627\u064B"
  }
};
var formatDistance$2q = function formatDistance7(token, count2, options) {
  var result;
  var tokenValue = formatDistanceLocale$1c[token];
  if (typeof tokenValue === "string") {
    result = tokenValue;
  } else if (count2 === 1) {
    result = tokenValue.one;
  } else if (count2 === 2) {
    result = tokenValue.two;
  } else if (count2 <= 10) {
    result = tokenValue.threeToTen.replace("{{count}}", String(count2));
  } else {
    result = tokenValue.other.replace("{{count}}", String(count2));
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "\u0641\u064A \u062E\u0644\u0627\u0644 " + result;
    } else {
      return "\u0645\u0646\u0630 " + result;
    }
  }
  return result;
};
var formatDistance$2r = formatDistance$2q;
var dateFormats$1l = {
  full: "EEEE, MMMM do, y",
  long: "MMMM do, y",
  medium: "MMM d, y",
  short: "MM/dd/yyyy"
};
var timeFormats$1l = {
  full: "h:mm:ss a zzzz",
  long: "h:mm:ss a z",
  medium: "h:mm:ss a",
  short: "h:mm a"
};
var dateTimeFormats$1l = {
  full: "{{date}} '\u0639\u0646\u062F' {{time}}",
  long: "{{date}} '\u0639\u0646\u062F' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong$2G = {
  date: buildFormatLongFn$1({
    formats: dateFormats$1l,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn$1({
    formats: timeFormats$1l,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn$1({
    formats: dateTimeFormats$1l,
    defaultWidth: "full"
  })
};
var formatLong$2H = formatLong$2G;
var formatRelativeLocale$1d = {
  lastWeek: "'\u0623\u062E\u0631' eeee '\u0639\u0646\u062F' p",
  yesterday: "'\u0623\u0645\u0633 \u0639\u0646\u062F' p",
  today: "'\u0627\u0644\u064A\u0648\u0645 \u0639\u0646\u062F' p",
  tomorrow: "'\u063A\u062F\u0627\u064B \u0639\u0646\u062F' p",
  nextWeek: "eeee '\u0639\u0646\u062F' p",
  other: "P"
};
var formatRelative$2q = function formatRelative7(token, _date, _baseDate, _options) {
  return formatRelativeLocale$1d[token];
};
var formatRelative$2r = formatRelative$2q;
var eraValues$1d = {
  narrow: ["\u0642", "\u0628"],
  abbreviated: ["\u0642.\u0645.", "\u0628.\u0645."],
  wide: ["\u0642\u0628\u0644 \u0627\u0644\u0645\u064A\u0644\u0627\u062F", "\u0628\u0639\u062F \u0627\u0644\u0645\u064A\u0644\u0627\u062F"]
};
var quarterValues$1d = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["\u06311", "\u06312", "\u06313", "\u06314"],
  wide: ["\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u0623\u0648\u0644", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u062B\u0627\u0646\u064A", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u062B\u0627\u0644\u062B", "\u0627\u0644\u0631\u0628\u0639 \u0627\u0644\u0631\u0627\u0628\u0639"]
};
var monthValues$1d = {
  narrow: ["\u064A", "\u0641", "\u0645", "\u0623", "\u0645", "\u064A", "\u064A", "\u0623", "\u0633", "\u0623", "\u0646", "\u062F"],
  abbreviated: ["\u064A\u0646\u0627", "\u0641\u0628\u0631", "\u0645\u0627\u0631\u0633", "\u0623\u0628\u0631\u064A\u0644", "\u0645\u0627\u064A\u0648", "\u064A\u0648\u0646\u0640", "\u064A\u0648\u0644\u0640", "\u0623\u063A\u0633\u0640", "\u0633\u0628\u062A\u0640", "\u0623\u0643\u062A\u0640", "\u0646\u0648\u0641\u0640", "\u062F\u064A\u0633\u0640"],
  wide: ["\u064A\u0646\u0627\u064A\u0631", "\u0641\u0628\u0631\u0627\u064A\u0631", "\u0645\u0627\u0631\u0633", "\u0623\u0628\u0631\u064A\u0644", "\u0645\u0627\u064A\u0648", "\u064A\u0648\u0646\u064A\u0648", "\u064A\u0648\u0644\u064A\u0648", "\u0623\u063A\u0633\u0637\u0633", "\u0633\u0628\u062A\u0645\u0628\u0631", "\u0623\u0643\u062A\u0648\u0628\u0631", "\u0646\u0648\u0641\u0645\u0628\u0631", "\u062F\u064A\u0633\u0645\u0628\u0631"]
};
var dayValues$1d = {
  narrow: ["\u062D", "\u0646", "\u062B", "\u0631", "\u062E", "\u062C", "\u0633"],
  short: ["\u0623\u062D\u062F", "\u0627\u062B\u0646\u064A\u0646", "\u062B\u0644\u0627\u062B\u0627\u0621", "\u0623\u0631\u0628\u0639\u0627\u0621", "\u062E\u0645\u064A\u0633", "\u062C\u0645\u0639\u0629", "\u0633\u0628\u062A"],
  abbreviated: ["\u0623\u062D\u062F", "\u0627\u062B\u0646\u0640", "\u062B\u0644\u0627", "\u0623\u0631\u0628\u0640", "\u062E\u0645\u064A\u0640", "\u062C\u0645\u0639\u0629", "\u0633\u0628\u062A"],
  wide: ["\u0627\u0644\u0623\u062D\u062F", "\u0627\u0644\u0627\u062B\u0646\u064A\u0646", "\u0627\u0644\u062B\u0644\u0627\u062B\u0627\u0621", "\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621", "\u0627\u0644\u062E\u0645\u064A\u0633", "\u0627\u0644\u062C\u0645\u0639\u0629", "\u0627\u0644\u0633\u0628\u062A"]
};
var dayPeriodValues$1d = {
  narrow: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646",
    noon: "\u0638",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0645\u0633\u0627\u0621\u0627\u064B",
    night: "\u0644\u064A\u0644\u0627\u064B"
  },
  abbreviated: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0645\u0633\u0627\u0621\u0627\u064B",
    night: "\u0644\u064A\u0644\u0627\u064B"
  },
  wide: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646\u0635\u0641 \u0627\u0644\u0644\u064A\u0644",
    noon: "\u0638\u0647\u0631",
    morning: "\u0635\u0628\u0627\u062D\u0627\u064B",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0647\u0631",
    evening: "\u0645\u0633\u0627\u0621\u0627\u064B",
    night: "\u0644\u064A\u0644\u0627\u064B"
  }
};
var formattingDayPeriodValues$_ = {
  narrow: {
    am: "\u0635",
    pm: "\u0645",
    midnight: "\u0646",
    noon: "\u0638",
    morning: "\u0641\u064A \u0627\u0644\u0635\u0628\u0627\u062D",
    afternoon: "\u0628\u0639\u062F \u0627\u0644\u0638\u0640\u0647\u0631",
    evening: "\u0641\u064A \u0627\u0644\u0645\u0633\u0627\u0621",
    night: "\u0641\u064A \u0627\u0644\u0644\u064A\u06