import React from 'react'
import { IconProps } from './interfaces'

const SVG = ({ fill = 'none', width, height, viewBox = '0 0 698 136' }: IconProps) => (
    <svg width={width} height={height} viewBox={viewBox} fill={fill}>
        <path
            d="M253.417 47.3394L254.006 37.3137H271.257V110H254.301L253.417 99.3845C249.288 107.936 237.936 112.064 229.827 112.212C208.301 112.359 192.378 99.0897 192.378 73.5831C192.378 48.5189 209.038 35.3971 230.269 35.5445C240 35.5445 249.288 40.115 253.417 47.3394ZM231.891 51.6151C219.949 51.6151 210.365 59.7241 210.365 73.5831C210.365 87.4422 219.949 95.6986 231.891 95.6986C260.199 95.6986 260.199 51.6151 231.891 51.6151Z"
            fill="#292929"
        />
        <path
            d="M318.779 52.3523C307.279 52.3523 298.138 60.4613 298.138 73.5831C298.138 86.2627 307.279 94.9614 318.779 94.9614C330.132 94.9614 339.863 86.705 339.863 73.5831C339.863 60.9036 330.132 52.3523 318.779 52.3523ZM341.042 6.94179H359.03V110H342.222L341.042 99.9743C335.44 108.673 326.446 111.622 317.6 111.622C296.222 111.622 280.151 97.4679 280.151 73.5831C280.151 48.5189 295.927 35.5445 317.158 35.5445C324.824 35.5445 336.767 39.6727 341.042 47.192V6.94179Z"
            fill="#292929"
        />
        <path
            d="M438.08 110H420.093V71.0767C420.093 61.4933 415.08 52.7946 405.202 52.7946C395.471 52.7946 389.721 61.4933 389.721 71.0767V110H371.733V37.1663H388.394L389.721 46.0125C393.554 38.6407 401.958 35.9868 408.887 35.9868C417.586 35.9868 426.285 39.5253 430.413 49.551C436.9 39.2304 445.304 36.2817 454.74 36.2817C475.381 36.2817 485.554 48.9612 485.554 70.7818V110H467.567V70.7818C467.567 61.1985 463.586 53.0895 453.856 53.0895C444.125 53.0895 438.08 61.4933 438.08 71.0767V110Z"
            fill="#292929"
        />
        <path
            d="M518.947 37.0189V110H500.959V37.0189H518.947ZM499.337 16.82C499.337 30.8265 520.568 30.8265 520.568 16.82C520.568 2.81357 499.337 2.81357 499.337 16.82Z"
            fill="#292929"
        />
        <path
            d="M532.278 37.3137H548.938L550.265 45.7176C555.868 36.724 563.387 35.3971 570.759 35.3971C578.278 35.3971 585.503 38.3458 589.483 42.3266L581.374 57.9549C577.689 54.8587 574.297 53.2369 568.4 53.2369C558.964 53.2369 550.265 58.2497 550.265 71.6665V110H532.278V37.3137Z"
            fill="#292929"
        />
        <path
            d="M650.315 47.3394L650.905 37.3137H668.155V110H651.199L650.315 99.3845C646.187 107.936 634.834 112.064 626.725 112.212C605.199 112.359 589.276 99.0897 589.276 73.5831C589.276 48.5189 605.936 35.3971 627.167 35.5445C636.898 35.5445 646.187 40.115 650.315 47.3394ZM628.789 51.6151C616.847 51.6151 607.263 59.7241 607.263 73.5831C607.263 87.4422 616.847 95.6986 628.789 95.6986C657.097 95.6986 657.097 51.6151 628.789 51.6151Z"
            fill="#292929"
        />
        <path d="M680.44 6.94179H698.28V110H680.44V6.94179Z" fill="#292929" />
        <path
            d="M3.06093 126.467C-1.02031 119.996 -1.02031 111.756 3.06093 105.286L52.0541 27.6094C63.6635 9.20312 69.4682 3.11078e-07 77.8932 0C86.3183 -3.11078e-07 92.123 9.20314 103.732 27.6094L117.661 49.693C124.415 60.4002 127.791 65.7537 126.496 71.1292C125.2 76.5046 119.756 79.7322 108.866 86.1874L29.9749 132.953C20.7272 138.435 8.7961 135.56 3.06093 126.467Z"
            fill="#643ADD"
        />
        <path
            d="M148.35 116.254C148.35 127.111 139.55 135.911 128.693 135.911C117.837 135.911 109.036 127.111 109.036 116.254C109.036 105.398 117.837 96.5973 128.693 96.5973C139.55 96.5973 148.35 105.398 148.35 116.254Z"
            fill="#8D68F5"
        />
    </svg>
)

export default SVG
