import React from 'react'
import { IconProps } from './interfaces'

const SVG = ({ fill = 'none', width = 104, height, viewBox = '0 0 104 54' }: IconProps) => (
    <svg
        width={width}
        height={height || Math.round((width * 54) / 104)}
        viewBox={viewBox}
        fill={fill}
        xmlns="http://www.w3.org/2000/svg"
    >
        <path
            d="M70.544 26.03a3.639 3.639 0 100-7.277 3.639 3.639 0 000 7.277z"
            fill="#fff"
            fill-opacity=".5"
        />
        <path
            d="M25.34 1.05v6.517c0 .16-.17.26-.31.18a9.715 9.715 0 00-5.948-1.19c-4.478.53-8.077 4.169-8.546 8.647-.62 5.868 3.968 10.826 9.716 10.826 1.74 0 3.359-.46 4.768-1.26.19-.11.43-.09.6.05l.81.68c.19.16.43.24.67.24h2.689c.58 0 1.05-.47 1.05-1.05V1.05c0-.58-.47-1.05-1.05-1.05h-3.4c-.579 0-1.049.47-1.049 1.05zm-4.528 20.462a5.253 5.253 0 01-5.258-5.348c.05-2.859 2.509-5.218 5.368-5.158 1.78.04 3.339.96 4.258 2.34.11.169.16.369.16.569v4.688c0 .2-.05.4-.16.57a5.247 5.247 0 01-4.368 2.339zM26.13 27.88c-.44 0-.79.35-.79.79 0 .16-.18.26-.319.18a9.7 9.7 0 00-6.128-1.16c-4.388.6-7.887 4.199-8.357 8.607-.63 5.878 3.969 10.846 9.717 10.846 1.74 0 3.358-.46 4.768-1.26.19-.11.43-.09.6.05l.81.68c.19.16.43.24.67.24h2.688c.58 0 1.05-.47 1.05-1.05V28.92c0-.58-.47-1.05-1.05-1.05h-3.658v.01zm-5.317 14.745a5.259 5.259 0 01-5.258-5.348c.05-2.86 2.509-5.218 5.367-5.159 1.78.04 3.34.96 4.259 2.34.11.17.16.37.16.57v4.688c0 .2-.05.4-.16.57a5.247 5.247 0 01-4.369 2.339zM98.484 28.519l-4.518 10.836c-.22.52-.95.52-1.16 0l-4.478-10.826c-.16-.39-.54-.65-.97-.65H83.97c-.75 0-1.26.77-.96 1.46l7.477 17.393c.07.17.05.37-.05.52l-.73 1.04c-.65.919-1.709 1.469-2.838 1.469h-.94c-.58 0-1.05.47-1.05 1.05v2.139c0 .58.47 1.05 1.05 1.05h1.68c1.809 0 3.358-.45 4.638-1.34 1.28-.89 2.359-2.44 3.229-4.619l7.957-18.693a1.05 1.05 0 00-.96-1.46h-3.009c-.44-.01-.82.24-.98.63zM68.834 27.879h3.409c.58 0 1.05.47 1.05 1.05v16.883c0 .58-.47 1.05-1.05 1.05h-3.41c-.579 0-1.049-.47-1.049-1.05V28.92c0-.57.47-1.04 1.05-1.04zM80.38 20.832h-3.408c-.58 0-1.05.47-1.05 1.05v23.93c0 .58.47 1.05 1.05 1.05h3.408c.58 0 1.05-.47 1.05-1.05v-23.94c0-.57-.47-1.04-1.05-1.04zM9.287 25.06h.23c.58 0 1.05-.47 1.05-1.049v-2.14c0-.579-.47-1.049-1.05-1.049h-.98a6.143 6.143 0 00-6.148 6.148v.42c0 .25-.2.45-.45.45h-.89C.47 27.85 0 28.32 0 28.9v2.139c0 .58.47 1.05 1.05 1.05h.89c.25 0 .45.199.45.449v13.275c0 .58.469 1.05 1.049 1.05h3.408c.58 0 1.05-.47 1.05-1.05V32.538c0-.25.2-.45.45-.45h1.87c.579 0 1.049-.47 1.049-1.05V28.9c0-.58-.47-1.05-1.05-1.05H8.197c-.25 0-.45-.2-.45-.45V26.6c0-.85.69-1.54 1.54-1.54zM57.238 27.6a8.263 8.263 0 00-6.128 2.599c-.2.22-.55.21-.75 0a8.246 8.246 0 00-6.017-2.61c-2.06 0-3.939.76-5.388 2-.14.12-.35.03-.35-.15v-.52c0-.58-.47-1.05-1.05-1.05h-3.169c-.58 0-1.05.47-1.05 1.05v16.884c0 .58.47 1.05 1.05 1.05h3.4c.58 0 1.049-.47 1.049-1.05v-9.546c0-1.39.7-2.74 1.91-3.41.679-.379 1.489-.559 2.348-.469 2.02.22 3.499 2.04 3.499 4.069v9.356c0 .58.47 1.05 1.05 1.05h3.408c.58 0 1.05-.47 1.05-1.05v-9.636c0-.73.17-1.46.58-2.07a3.922 3.922 0 013.688-1.719c2.04.21 3.53 2.03 3.53 4.079v9.346c0 .58.469 1.05 1.049 1.05h3.408c.58 0 1.05-.46 1.05-1.04v-9.696c0-4.569-3.599-8.457-8.167-8.517zM70.964 8.216L63.836 25.1c-.16.39-.54.64-.97.64h-4.288c-.42 0-.8-.25-.97-.64L50.512 8.216c-.29-.69.22-1.45.96-1.45h3.399c.43 0 .81.26.97.65l4.418 10.856c.21.52.95.52 1.16.01l4.578-10.866c.16-.39.54-.64.96-.64h3.018c.78-.01 1.29.75.99 1.44zM46.333 20.643c-.36-.36-.92-.42-1.33-.12a5.2 5.2 0 01-3.058.99 5.256 5.256 0 01-4.699-2.899c-.17-.35.1-.75.48-.75h10.866c1.92 0 2.92-1.44 2.91-2.919 0-.77-.21-1.55-.44-2.129-1.53-4.048-5.658-6.827-10.357-6.258-4.308.53-7.697 3.749-8.407 8.027a9.776 9.776 0 009.637 11.436c2.269 0 4.358-.78 6.017-2.079.52-.41.57-1.11.11-1.57l-1.729-1.729zm-9.076-6.747a5.256 5.256 0 019.396 0c.17.35-.1.75-.48.75h-8.427c-.4.01-.67-.4-.49-.75z"
            fill="#fff"
        />
    </svg>
)

export default SVG
