#### E3 Methods without modifiers

```php
<?php

namespace Test\e3;

class NoMethodModifiers {
    function methodWithoutModifier() {
    }
}
```

### Problem 

Forgetting to add a modifier makes it seem like it has no harm. But it is 
when you omit the modifier. When in the scenario that you have a class
with multiple methods that do not have the modifier. You are opening the 
doors to creating undefined behaviors in your class. 

#### Example
```php
<?php

// Dinner.php
class Dinner {

  function eat(){}
  
  function drink(){}
  
  function dessert(){}

  function cleanTable(){}

  function sittAtTable(){}
  
}
```

The dinner class has all the activities I can think of when a family 
is having dinner. However, the problem now is that there is an order 
in which these methods should be executed. However, this behavior is not defined in the class.

```php
<?php
 
// index.php

$dinner->sittAtTable();
$dinner->eat();
$dinner->drink();
$dinner->desert();
$dinner->eat();
$dinner->cleanTable();

```
This will work without any issues, but now you are just waiting for the misinterpretation to happen.

### Solution 


```php
<?php

class Dinner {

 protected function eat(){}
  
 protected function drink(){}
  
 protected function dessert(){}

 protected function cleanTable(){}

 protected function sittAtTable(){}
  
 public function start(){
      $dinner->sittAtTable();
      $dinner->eat();
      $dinner->drink();
      $dinner->desert();
      $dinner->eat();
      $dinner->cleanTable();
  }
}
```

In the future, you will thank yourself when you need to extend the functionality, as there is only one place where this behavior is implemented.
